/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/Input","sap/m/library","../config/datatable","./datatable/filters/DataTableFilterDropDown","./datatable/filters/DataTableFilterRange","sap/ui/documentation/sdk/controller/util/Highlighter","./DataTableUtil"],function($,I,m,d,D,a,H,b){"use strict";var c=m.InputType;function f(){this.oColumns=[];this.oChangedFilters=[];this.aShownRows=[];this.API=null;}f.DEFAULT_SORTING="0,asc";f.FILTER_CLASS_WRAPPER="sapUiDocumentationDatatableFilterWrapper";f.FILTER_TYPES={REGEX:"REGEX",NORMAL:"NORMAL",NUMBER:"NUMBER",SELECT:"SELECT",CELL_RANGE:"CELL_RANGE",NUMBER_RANGE:"NUMBER_RANGE"};f.prototype.destroy=function(){this.oColumns.forEach(function(C){if(C.highlighter){C.highlighter.destroy();C.highlighter=null;}C.aControls.forEach(function(o){o.destroy();});C.aControls=[];});this.oColumns=[];this.API.destroy();};f.prototype.get=function(p){return this.oConfig[p];};f.prototype.init=function(i,t,C){this.sId=i;this.oDomTable=t;this.oConfig=this.getConfig(i,C);var A=$(t).DataTable(Object.assign(this.oConfig,this.getLifeCycleMethods(i,C)));A.on('draw',function(){if(this.get("highlight")){var T=A.search();if(T||this.oChangedFilters.length){this.oColumns.forEach(function(o,e){var F=this.oChangedFilters[e]&&this.oChangedFilters[e].value,g=Array.isArray(F);if(g){F=F.reduce(function(r,h,e){if(h.value){r+=" "+h.text;}return r;},"");}if(F&&!(typeof F==="object")){if(T){T+=" "+F;}else{T=F;}}this.highlight(e,T);},this);}else{this.highlight(null,"");}}}.bind(this));A.buttons().container().insertBefore('#'+i+'_length');A.on('column-visibility.dt',function(e,s,g,v){this.onColumnVisibilityChange(g,v);}.bind(this));this.oConfig.columns.forEach(function(p,e){this.onColumnVisibilityChange(e,p.visible);},this);return this;};f.prototype.highlight=function(C,t){if(C===null){this.oColumns.forEach(function(o){o.highlighter.highlight(t);});return;}this.oColumns[C].highlighter.highlight(t);};f.prototype.onColumnVisibilityChange=function(i,v){var F=this.oColumns[i]&&this.oColumns[i].filterHeader,C=this.oDomTable.querySelector("colgroup"),o;if(C){o=C.children[i];if(o){o.classList.toggle("hidden",!v);}}if(F){F.toggle(v);}};f.prototype.handleSearch=function(s,o,e,r,g){var E,h,C,j,S=[],k;this.oChangedFilters.forEach(function(l,n){E=o[n];C=l.value;j=l.control;if(C===""){return;}switch(true){case j.hasStyleClass(f.FILTER_TYPES.REGEX):case j.hasStyleClass(f.FILTER_TYPES.NORMAL):case j.hasStyleClass(f.FILTER_TYPES.ALPHA_NUMERIC):case j.hasStyleClass(f.FILTER_TYPES.NUMBER):k=E.toLowerCase().indexOf(C.toLowerCase())>-1;break;case j.hasStyleClass(f.FILTER_TYPES.NUMBER_RANGE):var p=C.from!==""?C.from:Number.MIN_SAFE_INTEGER,q=C.to!==""?C.to:Number.MAX_SAFE_INTEGER,t=parseFloat(E)||0;k=(isNaN(p)&&isNaN(q))||(isNaN(p)&&t<=q)||(p<=t&&isNaN(q))||(p<=t&&t<=q);break;case j.hasStyleClass(f.FILTER_TYPES.CELL_RANGE):var u=E.split("-"),v=parseFloat(C);k=u[0]<=v&&u[1]>=v;break;case j.hasStyleClass(f.FILTER_TYPES.SELECT):var w=C.some(function(i){return i.value;});k=!w||(C.findIndex(function(x){h=s.aoData[e].anCells[n].querySelectorAll("li");var y=[];if(h.length){for(var i=0;i<h.length;i++){y[i]=h[i].textContent;}}else{y.push(E);}return x.value&&(y.indexOf(x.text)>-1);},this)>-1);break;default:k=true;}S.push(k);},this);return S.indexOf(false)<0;};f.prototype.getConfig=function(i,C){var o=[],n=JSON.parse(JSON.stringify(d.getPreset()));n.sapTableId=i;n.columnDefs=[];if(C){n.save=C['save']!==false;n.searching=C['search']!==false;n.highlight=C['highlight']!==false;if(C['excel_export']){n.buttons.push('csv');}if(C['paginate']){var p=parseInt(C['paginate']);n.pageLength=p>0?p:-1;}n.columns=C.columns.map(function(e,g){var r={visible:true};r.visible=e.visible!==false;if(e.sort){var s=n.columnDefs.find(function(s){return s.type===e.sort;});if(s){s.targets.push(g);}else{n.columnDefs.push({type:e.sort,targets:[g]});}}return r;});C['initial_sort']=C['initial_sort']||f.DEFAULT_SORTING;if(C['initial_sort']!=='none'){o=C['initial_sort'].split(';');o=o.map(function(e){return e.split(',');});}n.order=o;}return n;};f.prototype.onFilterChange=function(C,o){this.oChangedFilters[C]={control:o.control,value:o.value};this.API.columns(C).draw();};f.prototype.getSelectOptions=function(C){var o=[];this.API.columns(C).data().unique().sort()[0].forEach(function(O){var e;if(o.indexOf(O)>-1){return;}try{e=$(O);}catch(g){e=null;}if(e&&e.length>0){e.find('li').each(function(i,O){if(o.indexOf(O.textContent)<0){o.push(O.textContent);}});}else{o.push(O);}});o.sort(b.sortAlphaNumeric);return o;};f.prototype.getLifeCycleMethods=function(i,C){var t=this;return{initComplete:function(){t.API=this.api();var T=$('#'+i+' thead'),n=$('<tr/>'),F,h,e=0;this.api().columns().every(function(){var l=e,g=C.columns[e],o=[],j,k=g.filter==="select";F=$('<th/>');F.addClass(f.FILTER_CLASS_WRAPPER);t.oColumns[e]={};t.oColumns[e].aControls=[];t.oColumns[e].filterHeader=F;if(t.get("highlight")){h=new H([].slice.call(this.nodes()),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});t.oColumns[e].highlighter=h;}if(k){o=t.getSelectOptions(e);}j=f.getFilterByType(g.filter,o);if(j.control){t.oColumns[e].aControls.push(j.control);j.control.attachEvent(j.event,function(E){t.onFilterChange(l,{value:E.getParameter("value"),control:j.control});});j.control.placeAt(F);}n.append(F);e++;});T.append(n);}};};f.getFilterByType=function(t,o){var C,e="liveChange";switch(t){case'number-range':C=new a({from:new I({type:c.Number,placeholder:"From"}),to:new I({type:c.Number,placeholder:"To"})}).addStyleClass(f.FILTER_TYPES.NUMBER_RANGE);break;case'select':e="change";C=new D({options:o}).addStyleClass(f.FILTER_TYPES.SELECT);break;case'none':C='';break;default:var F=f.FILTER_TYPES.NORMAL,i=c.Text;if(t==='regex'){F=f.FILTER_TYPES.REGEX;}else if(t==='cell-range'){F=f.FILTER_TYPES.CELL_RANGE;i=c.Number;}else if(t==='number'){F=f.FILTER_TYPES.NUMBER;i=c.Number;}C=new I({type:i,placeholder:"Filter"}).addStyleClass(F);}return{control:C,event:e};};return f;});
