/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define([],function(){"use strict";var H={};H.CURRENTLY_HIGHLIGHTED_DOM_REFS=[];H.MUTATION_OBSERVER=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;var c=function c(d,C){this._bIsCaseSensitive=!!C.isCaseSensitive;this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._aOldTerms=[];this._aRegExTerms=[];this._bUseExternalStyles=!!C.useExternalStyles;this._oObserver=null;if(Array.isArray(d)){this._oDomRef=d;}else{this._oDomRef=[d];}this._oDomRef.forEach(this.validate,this);if(C.shouldBeObserved){this._addMutationObserver();}};c.prototype.validate=function(d){if(H.CURRENTLY_HIGHLIGHTED_DOM_REFS.indexOf(d)===-1){H.CURRENTLY_HIGHLIGHTED_DOM_REFS.forEach(function(D){if(this._bIsDomNodeDescendant(d,D)){throw new Error("Desired DOM Ref is parent of DOM Ref which is being highlighted.");}else if(this._bIsDomNodeDescendant(D,d)){throw new Error("Desired DOM Ref is child of DOM Ref which is being highlighted.");}},this);H.CURRENTLY_HIGHLIGHTED_DOM_REFS.push(d);}else{throw new Error("Highlighter instance is already created for this DOM Reference");}};c.prototype.highlight=function(t){var T;if(!t){this._restorePreviouslyHighlightedNodes();this._aRegExTerms=[];this._aOldTerms=[];return;}T=this._formatTerms(t);if(!T||!T.length||this._isNewTermsSameAsOld(T)){return;}this._aOldTerms=T;this._cacheRegExTerms();if(this._aPreviouslyHighlightedNodes&&this._aPreviouslyHighlightedNodes.length>0){this._restorePreviouslyHighlightedNodes();}this._toggleMutationObserver(false);this._oDomRef.forEach(function(d){this._highlightSubTree(d);},this);this._toggleMutationObserver(true);};c.prototype._cacheRegExTerms=function(){var r;this._aRegExTerms=[];this._aOldTerms.forEach(function(t){t=this._escapeRegExp(t);r=this._bIsCaseSensitive?new RegExp(t,"g"):new RegExp(t,"gi");this._aRegExTerms.push(r);},this);};c.prototype._escapeRegExp=function(t){return t.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&');};c.prototype._isNewTermsSameAsOld=function(t){var o=this._aOldTerms.length,i;if(o!==t.length){return false;}for(i=0;i<o;i++){if(this._aOldTerms[i]!==t[i]){return false;}}return true;};c.prototype._highlightSubTree=function(r){var n,i;for(i=0;i<r.childNodes.length;i++){n=r.childNodes[i];this._processNode(n);}};c.prototype._processNode=function(n){var t,r,i,j,m,C,o,b,a;if(n.nodeName==="IFRAME"){this._highlightSubTree(n.contentDocument.body);return;}if(n.nodeType===document.ELEMENT_NODE){this._highlightSubTree(n);}else if(n.nodeType===document.TEXT_NODE){t=n.data;m=Object.create(null);b=[];for(i=0;i<this._aRegExTerms.length;i++){r=this._aRegExTerms[i];while((o=r.exec(t))!==null){a=o["index"];if(b.indexOf(a)===-1){C=o["0"];m[a]=C;for(j=a;j<a+C.length;j++){b.push(j);}}}}if(Object.keys(m).length!==0){t=this._highlightTerms(m,t);this._replaceNode(n,t);}}};c.prototype._formatTerms=function(t){var T=t&&t.replace(/\s+/g,' ').trim().split(" "),u;u=T.reduce(function(a,b){if(a.indexOf(b)===-1){a.push(b);}return a;},[]);return u.sort(function(a,b){return b.length-a.length;});};c.prototype._replaceNode=function(n,h){var w;if(n.parentNode){w=document.createElement('span');w.innerHTML=h;n.parentNode.replaceChild(w,n);this._aPreviouslyHighlightedNodes.push(w);this._aPreviouslyOriginalNodes.push(n);}};c.prototype._restorePreviouslyHighlightedNodes=function(){var m,o;this._toggleMutationObserver(false);for(var i=0;i<this._aPreviouslyHighlightedNodes.length;i++){m=this._aPreviouslyHighlightedNodes[i];o=this._aPreviouslyOriginalNodes[i];if(m.parentNode){m.parentNode.replaceChild(o,m);}}this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._toggleMutationObserver(true);};c.prototype._highlightTerms=function(m,t){var o=this._bUseExternalStyles?'<span class="highlightedText">':'<span class="defaultHighlightedText">',C='</span>',s,u,i=0,I;for(I in m){u=+I+(i*(o.length+C.length));s=m[I];t=t.substring(0,u)+o+s+C+t.substring(u+s.length);i++;}return t;};c.prototype._addMutationObserver=function(){this._instantiateMutationObserver();this._toggleMutationObserver(true);};c.prototype._removeMutationObserver=function(){this._toggleMutationObserver(false);this._oObserver=null;this._oDomRef=[];};c.prototype._toggleMutationObserver=function(C){if(C){this._oDomRef.forEach(function(d){this._oObserver.observe(d,this.oObserverConfig);},this);}else{this._oObserver.disconnect();}};c.prototype._bIsDomNodeDescendant=function(p,C){return p.contains(C);};c.prototype._instantiateMutationObserver=function(){this.oObserverConfig={attributes:false,childList:true,characterData:true,subtree:true};this._oObserver=new H.MUTATION_OBSERVER(this._onMutationDetectionCallback.bind(this));};c.prototype._onMutationDetectionCallback=function(m){var a,n;this._toggleMutationObserver(false);m.forEach(function(M){if(M.type==='childList'){a=M.addedNodes;for(var i=0;i<a.length;i++){n=a[i];this._processNode(n);}}else if(M.type==='characterData'){this._processNode(M.target);}},this);this._toggleMutationObserver(true);};c.prototype.destroy=function(){this._removeMutationObserver();};return c;});
