//@ui5-bundle sap/ui/dt/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/ContextMenuControl',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/base/util/deepEqual","sap/m/library","sap/m/Popover","sap/m/VBox","sap/m/HBox","sap/m/Button","sap/m/FlexItemData","sap/ui/dt/OverlayRegistry","sap/ui/dt/DOMUtil","sap/ui/Device","sap/ui/dom/jquery/rect"],function(q,M,D,m,P,V,H,B,F,O,a,b){"use strict";var c=m.PlacementType;
var C=M.extend("sap.ui.dt.ContextMenuControl",{
metadata:{properties:{maxButtonsDisplayed:{type:"int",defaultValue:4},buttons:{type:"object[]",defaultValue:[]},styleClass:{type:"string",defaultValue:""}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},
init:function(){var p=this.getId()+"-popover";var o=new P(p,{showHeader:false,verticalScrolling:false,placement:"Top",showArrow:true,horizontalScrolling:false,content:new H(p+"ContentBox",{renderType:"Bare"})});o._getAnimationDuration=function(){return 0;};o.attachBrowserEvent("keydown",this._onKeyDown,this);this._oPopover=o;o.addStyleClass("sapUiDtContextMenu");var s=this.getId()+"-popoverExp";var d=new P(s,{showHeader:false,showArrow:false,verticalScrolling:true,horizontalScrolling:false,content:new V(s+"ContentBox",{renderType:"Bare"})});d._getAnimationDuration=function(){return 0;};d.attachBrowserEvent("keydown",this._onKeyDown,this);this._oExpandedPopover=d;d.addStyleClass("sapUiDtContextMenu");o.attachBrowserEvent("contextmenu",this._onContextMenu,this);d.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;this._oLastSourceOverlay=this._oLastSourceClientRects=this._oLastPosition=null;},
exit:function(){[true,false].forEach(function(d){this.getPopover(d).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(d).destroy();}.bind(this));},
isPopupOpen:function(d){return this.getPopover(d).isOpen();},
show:function(s,d,o){d=!!d;this._bCompactMode=q(s.getDomRef()).closest(".sapUiSizeCompact").length>0;this._bOpenAsContextMenu=d;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass());this.getPopover(false).addStyleClass(this.getStyleClass());this._showButtons(d);if(this.bOnInit||!this.isPopupOpen()){this._finalizeOpening(s);this.bOnInit=false;}else{this.getPopover().oPopup.attachEventOnce("closed",this._finalizeOpening.bind(this,s));}},
_finalizeOpening:function(s){this._bUseExpPop=this._bOpenAsContextMenu;if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this.getPopover().attachAfterOpen(this._handleAfterOpen,this);this.getPopover().attachBeforeClose(this._handleBeforeClose,this);this.getPopover().attachAfterClose(this._handleAfterClose,this);this._oTarget=this._placeContextMenu(s,this._bOpenAsContextMenu);this.getPopover().setVisible(true);},
_showButtons:function(d){var e=this.getButtons(d);if(!this._bOpenAsContextMenu){this._setButtonsForCollapsedMenu(e);}else{this._makeAllButtonsVisible(e);}},
_setButtonsForCollapsedMenu:function(d){var i=this._getNumberOfEnabledButtons(d);if(i!==0){this._hideDisabledButtons(d);}this._iButtonsVisible=this._hideButtonsInOverflow(d);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==d.length){this._replaceLastVisibleButtonWithOverflowButton(d);}else if(i<d.length-1&&i!==0){this.addOverflowButton();}i=null;},
_makeAllButtonsVisible:function(d){this._iFirstVisibleButtonIndex=0;d.forEach(function(o){o.setVisible(true);o._bInOverflow=true;});},
_getNumberOfEnabledButtons:function(d){var e=0;for(var i=0;i<d.length;i++){if(d[i].getEnabled()){e++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return e;},
_hideDisabledButtons:function(d){var v=0;d.forEach(function(o){o.setVisible(o.getEnabled());if(o.getEnabled()){v++;}});return v;},
_hideButtonsInOverflow:function(d){var v=0;for(var i=0;i<d.length;i++){if(v<this.getMaxButtonsDisplayed()&&d[i].getVisible()){v++;}else{d[i].setVisible(false);}}return v;},
_replaceLastVisibleButtonWithOverflowButton:function(d){for(var i=d.length-1;i>=0;i--){if(d[i].getVisible()){d[i].setVisible(false);this.addOverflowButton();return;}}},
_placeContextMenu:function(s,d){var o=(s.getId&&s.getId())||s.getAttribute("overlay");var f="contextMenuFakeDiv";var e=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var i=e.top-50>v.top?0:v.top-(e.top-50);q("#"+f).remove();q("#"+o).append("<div id=\""+f+"\" overlay=\""+o+"\" style = \"position: absolute; top: "+i+"px; left: 0px;\"></div>");o=null;var g=document.getElementById(f);this.getPopover().setContentWidth(undefined);this.getPopover().setContentHeight(undefined);this.getPopover().openBy(g);var p=this._getPopoverDimensions(!d);if(p.height>=v.height*2/3){p.height=(v.height*2/3).toFixed(0);this.getPopover().setContentHeight(p.height+"px");}if(p.width>400){p.width=400;this.getPopover().setContentWidth("400px");}else{this.getPopover().setContentWidth(undefined);}var I=(this._oLastSourceOverlay?this._oLastSourceOverlay===s:false);var h=(this._oLastSourceClientRects?D(JSON.parse(JSON.stringify(this._oLastSourceClientRects)),JSON.parse(JSON.stringify(s.getDomRef().getClientRects()))):false);if(this._oContextMenuPosition.x==="not set"&&this._oContextMenuPosition.y==="not set"&&I&&h){this._oContextMenuPosition.x=this._oLastPosition.x;this._oContextMenuPosition.y=this._oLastPosition.y;}else{this._oContextMenuPosition.x=this._oContextMenuPosition.x||parseInt(e.left+20);this._oContextMenuPosition.y=this._oContextMenuPosition.y||parseInt(e.top+20);}var j={};if(d){j=this._placeAsExpandedContextMenu(this._oContextMenuPosition,p,v);}else{j=this._placeAsCompactContextMenu(this._oContextMenuPosition,p,v);}j.top-=e.top;j.left-=e.left;j.top=(j.top<0)?0:j.top;j.left=(j.left<0)?0:j.left;g.style.top=j.top.toFixed(0)+"px";g.style.left=j.left.toFixed(0)+"px";return g;},
_placeAsExpandedContextMenu:function(o,p,v){this.getPopover().setShowArrow(false);var d={};if(v.height-10-o.y>=p.height){d.top=o.y;this.getPopover().setPlacement("Bottom");}else if(o.y>=p.height){d.top=o.y;this.getPopover().setPlacement("Top");}else{d.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}if(v.width-o.x>=p.width){d.left=o.x;}else if(o.x>=p.width){d.left=o.x-p.width/2;}else{d.left=v.width-p.width;}return d;},
_placeAsCompactContextMenu:function(o,p,v){this.getPopover().setShowArrow(true);var d={};this.getPopover().setPlacement(c.PreferredTopOrFlip);var i=p.width/this._iButtonsVisible;var f=sap.ui.getCore().getConfiguration().getRTL()?-1:1;d.left=o.x+(f*((this._iButtonsVisible-1)*i)/2+(this._getBaseFontSize()*1/2));d.top=o.y-(this._getBaseFontSize()*1/2);d.left=(d.left<32)?32:d.left;d.top=(d.top-v.top<0)?v.top:d.top;if(v.width-d.left<32){d.left=v.width-32;this.getPopover().addStyleClass("sapUiDtContextMenuRightArrow");}else{this.getPopover().removeStyleClass("sapUiDtContextMenuRightArrow");}var e=this._bCompactMode?0:15;if(d.top<(100+e)){this.getPopover().setPlacement(c.Bottom);d.top+=16;}return d;},
_getPopoverDimensions:function(w){var p={};var d=this._bCompactMode;var A=this._getArrowHeight(d);var i=this._getBaseFontSize();this._iFirstVisibleButtonIndex=null;p.height=parseInt(q("#"+this.getPopover().getId()).css("height"))||40;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"))||80;if(w){var e=i*A;if(e){p.height+=e;p.width+=e;}}return p;},
_getArrowHeight:function(d){if(b.browser.msie||b.browser.edge){return d?0.5:0.5;}return d?0.5625:0.5625;},
_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"));},
_getOverlayDimensions:function(o){var d=q("#"+o).rect();d.right=d.left+d.width;d.bottom=d.top+d.height;return d;},
_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"))||0;v.bottom=v.top+v.height;return v;},
_getIcon:function(i){if(i===undefined||i===null||typeof i!=="string"){return"sap-icon://incident";}if(i==="blank"){return" ";}return i;},
addOverflowButton:function(){var o="OVERFLOW_BUTTON";var d={icon:"sap-icon://overflow",type:"Transparent",enabled:true,press:this._onOverflowPress.bind(this),layoutData:new F({})};return this._addButton(o,d);},
addMenuButton:function(o,f,e){function h(){f(this);}if(o.responsible){e=o.responsible;}var t=typeof o.text==="function"?o.text(e[0]):o.text;var E=typeof o.enabled==="function"?o.enabled(e):o.enabled;var d={icon:this._getIcon(o.icon),text:t,tooltip:t,type:"Transparent",enabled:E,press:h,layoutData:new F({})};return this._addButton(o.id,d);},
_addButton:function(s,o){this.setProperty("buttons",this.getProperty("buttons").concat(o));var d={id:s,key:s};var e=new B(o);e.data(d);delete o.text;var f=new B(o);f.data(d);this.getFlexbox(true).addItem(e);this.getFlexbox(false).addItem(f);return this;},
close:function(e){if(this.getPopover()){if(e){this.getPopover(true).close();this.getPopover(false).close();}if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},
removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},
removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},
getButtons:function(d){return this.getFlexbox(d).getItems();},
insertButton:function(o,i){this.getFlexbox().insertItem(o,i);return this;},
setButtons:function(_,f,e){this.removeAllButtons();_.forEach(function(o){this.addMenuButton(o,f,e);}.bind(this));},
setMaxButtonsDisplayed:function(i){if(i<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",i);},
getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this._oExpandedPopover;}return this._oPopover;}else if(e){return this._oExpandedPopover;}return this._oPopover;},
getFlexbox:function(e){return this.getPopover(e).getContent()[0];},
_onOverflowPress:function(e){this.fireOverflowButtonPressed({oButton:e.oSource});},
_setFocusOnButton:function(o){if(o.getEnabled()&&o.getVisible()){o.focus();return true;}},
_onKeyDown:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;case"Escape":this._rememberPosition();break;default:break;}}},
_changeFocusOnButtons:function(i,p){this.getButtons().some(function(o,I,A){if(i===o.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},
_rememberPosition:function(){var n=document.getElementById(this._oTarget.getAttribute("overlay"));if(n){a.focusWithoutScrolling(n);this._oLastSourceOverlay=O.getOverlay(n.id);this._oLastSourceClientRects=this._oLastSourceOverlay.getDomRef().getClientRects();}else{this._oLastSourceClientRects=null;}this._oLastPosition={x:this._oContextMenuPosition.x,y:this._oContextMenuPosition.y};},
_setFocusOnNextButton:function(d,i){for(var e=i+1;e<d.length;e++){if(this._setFocusOnButton(d[e])){return;}}for(var f=0;f<i;f++){if(this._setFocusOnButton(d[f])){return;}}},
_setFocusOnPreviousButton:function(d,i){for(var e=i-1;e>=0;e--){if(this._setFocusOnButton(d[e])){return;}}for(var f=d.length-1;f>=i;f--){if(this._setFocusOnButton(d[f])){return;}}},
_onContextMenu:function(e){if(e.preventDefault){e.preventDefault();}},
_handleAfterOpen:function(){this.getPopover().detachAfterOpen(this._handleAfterOpen,this);this.getPopover().addStyleClass("sapUiDtContextMenuVisible");this.fireOpened();},
_handleBeforeClose:function(){this.getPopover().detachBeforeClose(this._handleBeforeClose,this);this.getPopover().removeStyleClass("sapUiDtContextMenuVisible");},
_handleAfterClose:function(){this.getPopover().detachAfterClose(this._handleAfterClose,this);this.fireClosed();},
setStyleClass:function(s){this.setProperty("styleClass",s);}
});
return C;});
sap.ui.predefine('sap/ui/dt/ManagedObjectObserver',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/base/util/includes"],function(M,E,i){"use strict";
var a=M.extend("sap.ui.dt.ManagedObjectObserver",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{aggregations:{type:"array",defaultValue:null}},associations:{target:{type:"sap.ui.base.ManagedObject"}},events:{modified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},destroyed:{}}}});
a.prototype.init=function(){this._fnFireModified=function(e){var p=e.getParameters();if(e.sId==="_change"){e.sId="propertyChanged";}this.fireModified({type:e.sId,name:p.name,value:p.newValue,oldValue:p.oldValue,target:e.getSource()});}.bind(this);};
a.prototype.exit=function(){this.unobserve();delete this._fnFireModified;};
a.prototype.setTarget=function(t){this.unobserve();this.setAssociation("target",t);var T=this.getTargetInstance();if(T){this.observe(T);}return this;};
a.prototype.observe=function(t){this._bIsObserved=true;t.attachEvent("_change",this._fnFireModified,this);this._fnOriginalDestroy=t.destroy;t.destroy=function(){this.unobserve(t);var o=t.destroy.apply(t,arguments);this.fireDestroyed();return o;}.bind(this);this._fnOriginalBindProperty=t.bindProperty;t.bindProperty=function(){var o=this._fnOriginalBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalUnBindProperty=t.unbindProperty;t.unbindProperty=function(){var o=this._fnOriginalUnBindProperty.apply(t,arguments);this.fireModified();return o;}.bind(this);this._fnOriginalBindAggregation=t.bindAggregation;t.bindAggregation=function(s){var o=this._fnOriginalBindAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified();}return o;}.bind(this);this._fnOriginalUnBindAggregation=t.unbindAggregation;t.unbindAggregation=function(s){var o=this._fnOriginalUnBindAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified();}return o;}.bind(this);this._fnOriginalSetParent=t.setParent;t.setParent=function(p,s){var f=false;if(!t._bInSetParent){f=true;t._bInSetParent=true;}var c=t.getParent();var o=this._fnOriginalSetParent.apply(t,arguments);if(f){t._bInSetParent=false;if(!t.__bSapUiDtSupressParentChangeEvent&&(c!==p||s==="dependents")){this.fireModified({type:"setParent",value:p,oldValue:c,target:t});}}return o;}.bind(this);this._fnOriginalAddAggregation=t.addAggregation;t.addAggregation=function(s,o){this._sAddOrSetAggregationCall=s;var O=this._fnOriginalAddAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalSetAggregation=t.setAggregation;t.setAggregation=function(s,o){this._sAddOrSetAggregationCall=s;var O=this._fnOriginalSetAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAggregation=t.removeAggregation;t.removeAggregation=function(s,o){this._sRemoveAggregationCall=s;var O=this._fnOriginalRemoveAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalInsertAggregation=t.insertAggregation;t.insertAggregation=function(s,o){this._sInsertAggregationCall=s;var O=this._fnOriginalInsertAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"insertAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAllAggregation=t.removeAllAggregation;t.removeAllAggregation=function(s){this._sRemoveAllAggregationCall=s;var r=t.getAggregation(s);var o=this._fnOriginalRemoveAllAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._fnOriginalDestroyAggregation=t.destroyAggregation;t.destroyAggregation=function(s){this._sDestroyAggregationCall=s;var r=t.getAggregation(s);var o=this._fnOriginalDestroyAggregation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"destroyAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._fnOriginalAddAssociation=t.addAssociation;t.addAssociation=function(s,o){this._sAddOrSetAssociationCall=s;var O=this._fnOriginalAddAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalSetAssociation=t.setAssociation;t.setAssociation=function(s,o){this._sAddOrSetAssociationCall=s;var O=this._fnOriginalSetAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"addOrSetAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAssociation=t.removeAssociation;t.removeAssociation=function(s,o){this._sRemoveAssociationCall=s;var O=this._fnOriginalRemoveAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAggregation",name:s,value:o,target:t});}return O;}.bind(this);this._fnOriginalRemoveAllAssociation=t.removeAllAssociation;t.removeAllAssociation=function(s){this._sRemoveAllAssociationCall=s;var r=t.getAssociation(s);var o=this._fnOriginalRemoveAllAssociation.apply(t,arguments);if(this._isAggregationObservable(s)){this.fireModified({type:"removeAllAggregation",name:s,value:r,target:t});}return o;}.bind(this);this._aOriginalAddMutators={};this._aOriginalInsertMutators={};this._aOriginalRemoveMutators={};this._aOriginalRemoveAllMutators={};this._aOriginalDestructors={};var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){delete this._sAddOrSetAggregationCall;var v=_.apply(t,arguments);if((!this._sAddOrSetAggregationCall||this._sAddOrSetAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sInsertMutator];this._aOriginalInsertMutators[o.name]=b;t[o._sInsertMutator]=function(O){delete this._sInsertAggregationCall;var v=b.apply(t,arguments);if((!this._sInsertAggregationCall||this._sInsertAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"insertAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=c;t[o._sRemoveMutator]=function(O){delete this._sRemoveAggregationCall;var v=c.apply(t,arguments);if((!this._sRemoveAggregationCall||this._sRemoveAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var d=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=d;t[o._sRemoveAllMutator]=function(){delete this._sRemoveAllAggregationCall;var r=this.getAggregation(s);var O=d.apply(t,arguments);if((!this._sRemoveAllAggregationCall||this._sRemoveAllAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);var e=t[o._sDestructor];this._aOriginalDestructors[o.name]=e;t[o._sDestructor]=function(){delete this._sDestroyAggregationCall;var r=this.getAggregation(s);var O=e.apply(t,arguments);if((!this._sDestroyAggregationCall||this._sDestroyAggregationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"destroyAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];var _=t[o._sMutator];this._aOriginalAddMutators[o.name]=_;t[o._sMutator]=function(O){delete this._sAddOrSetAssociationCall;var v;v=_.apply(t,arguments);if((!this._sAddOrSetAssociationCall||this._sAddOrSetAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"addOrSetAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var b=t[o._sRemoveMutator];this._aOriginalRemoveMutators[o.name]=b;t[o._sRemoveMutator]=function(O){delete this._sRemoveAssociationCall;var v=b.apply(t,arguments);if((!this._sRemoveAssociationCall||this._sRemoveAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAggregation",name:o.name,value:O,target:t});}return v;}.bind(this);var c=t[o._sRemoveAllMutator];this._aOriginalRemoveAllMutators[o.name]=c;t[o._sRemoveAllMutator]=function(){delete this._sRemoveAllAssociationCall;var r=this.getAssociation(s);var O=c.apply(t,arguments);if((!this._sRemoveAllAssociationCall||this._sRemoveAllAssociationCall!==o.name)&&this._isAggregationObservable(o.name)){this.fireModified({type:"removeAllAggregation",name:o.name,value:r,target:t});}return O;}.bind(this);}.bind(this),this);};
a.prototype.unobserve=function(t){t=t||this.getTargetInstance();if(this._bIsObserved&&t){this._bIsObserved=false;t.destroy=this._fnOriginalDestroy;t.bindProperty=this._fnOriginalBindProperty;t.unbindProperty=this._fnOriginalUnBindProperty;t.bindAggregation=this._fnOriginalBindAggregation;t.unbindAggregation=this._fnOriginalUnBindAggregation;t.setParent=this._fnOriginalSetParent;t.addAggregation=this._fnOriginalAddAggregation;t.removeAggregation=this._fnOriginalRemoveAggregation;t.insertAggregation=this._fnOriginalInsertAggregation;t.setAggregation=this._fnOriginalSetAggregation;t.removeAllAggregation=this._fnOriginalRemoveAllAggregation;t.destroyAggregation=this._fnOriginalDestroyAggregation;t.addAssociation=this._fnOriginalAddAssociation;t.removeAssociation=this._fnOriginalRemoveAssociation;t.setAssociation=this._fnOriginalSetAssociation;t.removeAllAssociation=this._fnOriginalRemoveAllAssociation;var A=t.getMetadata().getAllAggregations();Object.keys(A).forEach(function(s){var o=A[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sInsertMutator]=this._aOriginalInsertMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];t[o._sDestructor]=this._aOriginalDestructors[o.name];},this);var m=t.getMetadata().getAllAssociations();Object.keys(m).forEach(function(s){var o=m[s];t[o._sMutator]=this._aOriginalAddMutators[o.name];t[o._sRemoveMutator]=this._aOriginalRemoveMutators[o.name];t[o._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[o.name];},this);t.detachEvent("_change",this._fnFireModified,this);}delete this._fnOriginalDestroy;delete this._fnOriginalBindProperty;delete this._fnOriginalUnBindProperty;delete this._fnOriginalBindAggregation;delete this._fnOriginalUnBindAggregation;delete this._fnOriginalSetParent;delete this._fnOriginalAddAggregation;delete this._fnOriginalRemoveAggregation;delete this._fnOriginalInsertAggregation;delete this._fnOriginalSetAggregation;delete this._fnOriginalRemoveAllAggregations;delete this._fnOriginalDestroyAggregation;delete this._aOriginalAddMutators;delete this._aOriginalInsertMutators;delete this._aOriginalRemoveMutators;delete this._aOriginalRemoveAllMutators;delete this._aOriginalDestructors;};
a.prototype.getTargetInstance=function(){return E.getElementInstance(this.getTarget());};
a.prototype._isAggregationObservable=function(A){return(this.getAggregations()===null||i(this.getAggregations(),A));};
return a;});
sap.ui.predefine('sap/ui/dt/MetadataPropagationUtil',["sap/ui/dt/Util","sap/base/util/merge","sap/base/util/isEmptyObject"],function(U,m,i){"use strict";var M={};
M._getParentPropagationInfo=function(a){if(!a||!a["propagationInfos"]){return false;}return Object.assign([],a["propagationInfos"]);};
M._getCurrentRelevantContainerPropagation=function(e,E){var n={};if(!e.propagateRelevantContainer){return n;}else if(typeof e.propagateRelevantContainer==="function"){n.relevantContainerFunction=e.propagateRelevantContainer;n.relevantContainerElement=E;}else if(typeof e.propagateRelevantContainer==="boolean"&&e.propagateRelevantContainer){n.relevantContainerFunction=function(){return true;};n.relevantContainerElement=E;}else{var o=U.wrapError("Wrong type: it should be either a function or a boolean value and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentRelevantContainerPropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._getCurrentDesigntimePropagation=function(e,E){var n={};if(!e.propagateMetadata){return n;}else if(typeof e.propagateMetadata==="function"){n.relevantContainerElement=E;n.metadataFunction=e.propagateMetadata;}else{var o=U.wrapError("Wrong type: it should be a function and it is:"+typeof e.propagateRelevantContainer);var l='sap.ui.dt.MetadataPropagationUtil#_getCurrentDesigntimePropagation';o.name='Error in '+l;o.message=U.printf("{0} / {1}",l,o.message);throw o;}return n;};
M._setPropagationInfo=function(a,n,p){if(!p&&i(n)){return false;}a.propagationInfos=p||[];if(!i(n)){a.propagationInfos.push(n);}return a;};
M.propagateMetadataToAggregationOverlay=function(o,e,p){var n;var a;var r;var b=Object.assign({},o);var P=M._getParentPropagationInfo(p);if(b&&!i(b)){r=M._getCurrentRelevantContainerPropagation(b,e);a=M._getCurrentDesigntimePropagation(b,e);}if(P||!i(r)||!i(a)){n=Object.assign({},r,a);return M._setPropagationInfo(b,n,P);}return b;};
M.getRelevantContainerForPropagation=function(p,e){var P=false;if(!p||!p.propagationInfos){return false;}p.propagationInfos.some(function(o){if(o.relevantContainerFunction&&o.relevantContainerFunction(e)){P=o.relevantContainerElement;return true;}});return P||false;};
M.getMetadataForPropagation=function(p,e){var r={};if(!p||!p.propagationInfos){return false;}var R=p.propagationInfos.slice().reverse();r=R.reduce(function(r,P){if(P.metadataFunction){var c=P.metadataFunction(e,P.relevantContainerElement);return m(r,c);}return r;},r);return i(r)?false:r;};
M.propagateMetadataToElementOverlay=function(t,p,e){var P=M.getRelevantContainerForPropagation(p,e);var v=M.getMetadataForPropagation(p,e);if(!P&&!v){return t;}var r=m({},t);if(P){r.relevantContainer=P;}if(v){if(v.actions===null||v.actions==="not-adaptable"){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);if(r.aggregations){A=A.concat(Object.keys(r.aggregations).filter(function(s){return A.indexOf(s)<0;}));}else{r.aggregations={};}A.forEach(function(s){if(r.aggregations[s]&&r.aggregations[s].actions){r.aggregations[s].actions=v.actions;}});}return m(r,v);}return r;};
return M;},true);
sap.ui.predefine('sap/ui/dt/MutationObserver',["sap/ui/thirdparty/jquery","sap/ui/dt/OverlayUtil","sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/base/util/restricted/_intersection","sap/base/util/restricted/_uniq"],function(q,O,M,D,_,a){"use strict";
var b=M.extend("sap.ui.dt.MutationObserver",{metadata:{library:"sap.ui.dt",events:{domChanged:{parameters:{type:{type:"string"},targetNodes:{type:"element[]"}}}}}});
b.prototype.init=function(){this._mutationOnTransitionend=this._callDomChangedCallback.bind(this,"MutationOnTransitionend");this._mutationOnAnimationEnd=this._callDomChangedCallback.bind(this,"MutationOnAnimationEnd");this._fireDomChangeOnScroll=this._fireDomChangeOnScroll.bind(this);this._mutationOnResize=this._callDomChangedOnResizeWithRoot.bind(this,"MutationOnResize");window.addEventListener("transitionend",this._mutationOnTransitionend,true);window.addEventListener("animationend",this._mutationOnAnimationEnd,true);window.addEventListener("scroll",this._fireDomChangeOnScroll,true);q(window).on("resize",this._mutationOnResize);this._aIgnoredMutations=[];this._bHandlerRegistred=false;this._mMutationHandlers={};this._aRootIds=[];this._startMutationObserver();};
b.prototype.exit=function(){this._stopMutationObserver();window.removeEventListener("transitionend",this._mutationOnTransitionend,true);window.removeEventListener("animationend",this._mutationOnAnimationEnd,true);window.removeEventListener("scroll",this._fireDomChangeOnScroll,true);q(window).off("resize",this._mutationOnResize);this._aIgnoredMutations=[];this._bHandlerRegistred=false;this._mMutationHandlers={};};
b.prototype.ignoreOnce=function(p){this._aIgnoredMutations.push(p);};
b.prototype.registerHandler=function(i,d,I){if(!this._mMutationHandlers[i]){this._mMutationHandlers[i]=[];this._bHandlerRegistred=true;}this._mMutationHandlers[i].push(d);if(I&&this._aRootIds.indexOf(i)===-1){this._aRootIds.push(i);}};
b.prototype.deregisterHandler=function(i){delete this._mMutationHandlers[i];if(Object.keys(this._mMutationHandlers).length===0){this._bHandlerRegistred=false;}this._aRootIds=this._aRootIds.filter(function(r){return r!==i;});};
b.prototype._hasScrollbar=function(s,e){return s||D.hasScrollBar(e);};
b.prototype._getIdsWhenRegistered=function(s,e,E){var r;if(e&&this._mMutationHandlers[e]){r=e;if(!E.closestElementInWhitlist){E.closestElementInWhitlist=e;}}E.result=s?r:E.closestElementInWhitlist;return E;};
b.prototype._getClosestParentIdForNodeRegisteredWithScrollbar=function(n,N){var e={closestElementInWhitlist:undefined,result:undefined};var s=false;var c=q(N);var C=n;do{s=this._hasScrollbar(s,c);e=this._getIdsWhenRegistered(s,C,e);c=c.parent();C=c.attr("data-sap-ui");}while(!(e.result&&s)&&c.length&&c[0]!==document);return e.result||e.closestElementInWhitlist;};
b.prototype._isNodeOverlayRelated=function(n,m){var o="overlay-container";if(D.contains(o,n)){return true;}if(n===document.body){return m&&m.addedNodes&&m.addedNodes[0]&&m.addedNodes[0].getAttribute&&m.addedNodes[0].getAttribute('id')===o;}return false;};
b.prototype._getRelevantElementId=function(n,m){var N=n&&n.getAttribute&&n.getAttribute('id');var r;if(!this._isNodeOverlayRelated(n,m)&&document.body.contains(n)&&N!=="sap-ui-static"&&!D.contains("sap-ui-preserve",n)){var i=0;while(this._aRootIds.length>i&&!r){if(D.contains(this._aRootIds[i],n)||n.contains(document.getElementById(this._aRootIds[i]))){r=this._aRootIds[i];}i++;}}return r;};
b.prototype._getRelevantElementIdsFromStaticArea=function(m){return m.target.id==="sap-ui-static"&&_([].concat(Array.prototype.slice.call(m.addedNodes),Array.prototype.slice.call(m.removedNodes)).map(function(n){return n.id;}),Object.keys(this._mMutationHandlers));};
b.prototype._ignoreMutation=function(m){return this._aIgnoredMutations.some(function(i,I,s){if(i.target===m.target&&(!i.type||i.type===m.type)){s.splice(I,1);return true;}});};
b.prototype._getTargetNode=function(m){return(m.type==="characterData"?m.target.parentNode:m.target);};
b.prototype._callRelevantCallbackFunctions=function(t,T){t=a(t);t.forEach(function(s){(this._mMutationHandlers[s]||[]).forEach(function(f){f({type:T});});}.bind(this));};
b.prototype._startMutationObserver=function(){this._oMutationObserver=new window.MutationObserver(function(m){if(this._bHandlerRegistred){var o=m.reduce(function(o,c){var t=[];var T=this._getTargetNode(c);var d=this._getRelevantElementId(T,c);if(d){t.push(d);}else{t=this._getRelevantElementIdsFromStaticArea(c);}if(t.length&&!this._ignoreMutation(c)){return o.concat(t);}return o;}.bind(this),[]);if(o.length){this._callRelevantCallbackFunctions(o,"MutationObserver");}}}.bind(this));this._oMutationObserver.observe(window.document,{childList:true,subtree:true,attributes:true,attributeFilter:["style","class","width","height","border"],characterData:true});};
b.prototype._stopMutationObserver=function(){if(this._oMutationObserver){this._oMutationObserver.disconnect();delete this._oMutationObserver;}};
b.prototype._callDomChangedCallback=function(m,e){var t=e.target;if(this._bHandlerRegistred&&t!==window){var T=this._getRelevantElementId(t);if(T){this._callRelevantCallbackFunctions([T],m);}}};
b.prototype._callDomChangedOnResizeWithRoot=function(m){if(this._aRootIds.length){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this._callRelevantCallbackFunctions(this._aRootIds,m);delete this._iApplyStylesRequest;}.bind(this));}};
b.prototype._fireDomChangeOnScroll=function(e){var t=e.target;var T=[];if(this._bHandlerRegistred&&t!==document){var s=this._getRelevantElementId(t);if(s){T.push(s);}else if(t.getAttribute("id")!=="sap-ui-static"){T=this._aRootIds.filter(function(s){return t.contains(document.getElementById(s));});}if(T.length&&!O.getClosestOverlayForNode(t)){this._callRelevantCallbackFunctions(T,"MutationOnScroll");}}};
return b;});
sap.ui.predefine('sap/ui/dt/OverlayUtil',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil"],function(O,E){"use strict";var c={};
c.isInTargetZoneAggregation=function(e){var a=e.getParent();return!!a&&a.isTargetZone();};
c.getParentInformation=function(e){var p=e.getParentElementOverlay();if(p){var P=p.getElement();var s=e.getParentAggregationOverlay().getAggregationName();var C=E.getAggregation(P,s);var o=e.getElement();var i=C.indexOf(o);return{parent:P,aggregation:s,index:i};}return{parent:null,aggregation:"",index:-1};};
c.getClosestOverlayFor=function(e){if(!e){return null;}var p=e;var P=O.getOverlay(p);while(p&&!P){p=p.getParent();P=O.getOverlay(p);}return P;};
c.getGeometry=function(g){var m;var a;var b;var d;g.forEach(function(e){if(e&&e.visible){if(!m||e.position.left<m){m=e.position.left;}if(!b||e.position.top<b){b=e.position.top;}var r=e.position.left+e.size.width;if(!a||r>a){a=r;}var B=e.position.top+e.size.height;if(!d||B>d){d=B;}}});if(typeof m==="number"){return{size:{width:a-m,height:d-b},position:{left:m,top:b},visible:true};}};
c.getFirstDescendantByCondition=function(o,C){if(!C){throw new Error("expected condition is 'undefined' or not a function");}var a=c.getAllChildOverlays(o);for(var i=0,n=a.length;i<n;i++){var b=a[i];if(C(b)){return b;}var d=this.getFirstDescendantByCondition(b,C);if(d){return d;}}return undefined;};
c.getLastDescendantByCondition=function(o,C){if(!C){throw new Error("expected condition is 'undefined' or not a function");}var a=c.getAllChildOverlays(o);for(var i=a.length-1,n=-1;i>n;i--){var b=a[i];if(C(b)){return b;}var d=this.getLastDescendantByCondition(b,C);if(d){return d;}}return undefined;};
c.getAllChildOverlays=function(e){var C=[];var a=[];if(!e){return C;}var A=e.getChildren();for(var i=0;i<A.length;i++){a=A[i].getChildren();if(a&&a.length>0){C=C.concat(a);}}return C;};
c.getFirstChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[0];}return undefined;};
c.getLastChildOverlay=function(o){var C=this.getAllChildOverlays(o);if(C.length){return C[C.length-1];}return undefined;};
c.getNextSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i!==a.length-1){return a[i+1];}else if(i===a.length-1){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)+1;i<a.length;i++){var b=a[i].getChildren();if(b.length){return b[0];}}}}};
c.getPreviousSiblingOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(p){var a=p.getChildren();var i=a.indexOf(o);if(i>0){return a[i-1];}else if(i===0){var P=o.getParentElementOverlay();a=P.getAggregationOverlays();for(i=a.indexOf(p)-1;i>=0;i--){var b=a[i].getChildren();if(b.length){return b[b.length-1];}}}}};
c.getNextOverlay=function(o){if(!o){return undefined;}var f=this.getFirstChildOverlay(o);if(f){return f;}var n=this.getNextSiblingOverlay(o);if(n){return n;}do{o=o.getParentElementOverlay();n=this.getNextSiblingOverlay(o);}while(o&&!n);return n;};
c.getPreviousOverlay=function(o){if(!o){return undefined;}var p=o.getParentAggregationOverlay();if(!p){return undefined;}var P=this.getPreviousSiblingOverlay(o);if(P){var l=P;do{P=l;l=this.getLastChildOverlay(P);}while(l);return P;}return o.getParentElementOverlay();};
c.iterateOverlayElementTree=function(e,C){C(e);e.getAggregationOverlays().forEach(function(a){a.getChildren().forEach(function(o){this.iterateOverlayElementTree(o,C);},this);},this);};
c.getClosestOverlayForNode=function(n){var e=E.getClosestElementForNode(n);return c.getClosestOverlayFor(e);};
c.findAllSiblingOverlaysInContainer=function(o,r){var p=o.getParentElementOverlay();var R=[];if(p){if(p!==r){var P=c.findAllSiblingOverlaysInContainer(p,r);R=P.map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(f,C){return f.concat(C);},[]);}else{R=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();}}R=R.filter(function(o){return o.getDesignTimeMetadata();});return R;};
c.findAllOverlaysInContainer=function(o){var r=o.getRelevantContainer()||o.getElement();var R=O.getOverlay(r);var a=[];if(!R){return a;}var m=c._findAllSiblingsAndParents(o,R,0);if(m[0]){for(var l in m){a=a.concat(m[l]);}var C=[];m[0].forEach(function(o){C=C.concat(c._findAllChildrenInContainer(o,r));});a=a.concat(C);}else{a=c._findAllChildrenInContainer(o,r);}a.push(R);a=a.filter(function(o){return o.getDesignTimeMetadata();});return a;};
c._findAllSiblingsAndParents=function(o,r,l){var p=o.getParentElementOverlay();if(!p){return[];}if(p!==r){var P=c._findAllSiblingsAndParents(p,r,l+1);var d=P[l+1].map(function(p){var a=p.getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName());return a?a.getChildren():[];}).reduce(function(a,b){return a.concat(b);},[]);P[l]=d;return P;}var C=o.getParentElementOverlay().getAggregationOverlay(o.getParentAggregationOverlay().getAggregationName()).getChildren();var R={};R[l]=C;return R;};
c._findAllChildrenInContainer=function(e,r,_){_=_||[];if(e.getChildren().length>0){e.getChildren().forEach(function(a){a.getChildren().forEach(function(C){if(C.getRelevantContainer()===r){_.push(C);c._findAllChildrenInContainer(C,r,_);}});});}return _;};
c.findAllUniqueAggregationOverlaysInContainer=function(o,r){var a=c.findAllSiblingOverlaysInContainer(o,r);return a.map(function(o){return o.getParentAggregationOverlay();}).filter(function(o,p,A){return A.indexOf(o)===p;});};
return c;},true);
sap.ui.predefine('sap/ui/dt/plugin/ContextMenu',["sap/ui/dt/Plugin","sap/ui/dt/ContextMenuControl","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/dt/util/_createPromise","sap/ui/Device","sap/base/assert","sap/ui/events/KeyCodes","sap/base/util/restricted/_debounce"],function(P,C,D,O,_,a,b,K,c){"use strict";
var d=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},styleClass:{type:"string"},openOnHover:{type:"boolean",defaultValue:true},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});
d.prototype.init=function(){this.iMenuHoverOpeningDelay=500;this.iMenuHoverClosingDelay=250;this.oContextMenuControl=new C({maxButtonsDisplayed:4});this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.attachOverflowButtonPressed(this._pressedOverflowButton,this);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[];};
d.prototype.exit=function(){this._clearHoverTimeout();delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.detachClosed(this._contextMenuClosed,this);this.oContextMenuControl.detachOverflowButtonPressed(this._pressedOverflowButton,this);this.oContextMenuControl.destroy();delete this.oContextMenuControl;}};
d.prototype.addMenuItem=function(m,r,p){var M={menuItem:m,fromPlugin:!!r,bPersistOneTime:p};this._aMenuItems.push(M);};
d.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("click",this._onContextMenuOrClick,this);o.attachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.attachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("keyup",this._onKeyUp,this);};
d.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._onContextMenuOrClick,this);o.detachBrowserEvent("touchstart",this._onContextMenuOrClick,this);o.detachBrowserEvent("contextmenu",this._onContextMenuOrClick,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("keyup",this._onKeyUp,this);};
d.prototype.open=function(p,o,e,i){this._bContextMenu=!!e;var n=o.getElement();if(this._fnCancelMenuPromise){if(this.getContextElement()===n){return;}this._fnCancelMenuPromise();delete this._fnCancelMenuPromise;}this.setContextElement(n);this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);var s=this.getSelectedOverlays().filter(function(E){return E!==o;});s.unshift(o);if(document.activeElement){document.activeElement.blur();}this._aMenuItems=this._aMenuItems.filter(function(m){if(m.bPersistOneTime){m.bPersistOneTime=false;return true;}return!m.fromPlugin;});var f=Promise.resolve();if(!i){var g=_(function(r,h){D.waitForSynced(this.getDesignTime())().then(r).catch(h);}.bind(this));this._fnCancelMenuPromise=g.cancel;f=g.promise.then(function(){this._aGroupedItems=[];this._aSubMenus=[];var h=[];var j=this.getDesignTime().getPlugins();j.forEach(function(l){var m=l.getMenuItems(s);if(!(m instanceof Promise)){m=Promise.resolve(m);}h.push(m);});var k=_(function(r,l){Promise.all(h).then(r).catch(l);});this._fnCancelMenuPromise=k.cancel;return k.promise;}.bind(this)).then(function(h){return h.reduce(function(j,m){return j.concat(m);});}).then(function(h){h.forEach(function(m){if(m.group!==undefined&&!e){this._addMenuItemToGroup(m);}else if(m.submenu!==undefined){this._addSubMenu(m,p,o);}else{this.addMenuItem(m,true);}}.bind(this));this._addItemGroupsToMenu(p,o);delete this._fnCancelMenuPromise;}.bind(this));}f.then(function(){var m=this._aMenuItems.map(function(M){return M.menuItem;});if(m.length>0){m=this._sortMenuItems(m);this.oContextMenuControl.setButtons(m,this._onItemSelected.bind(this),s);this.oContextMenuControl.setStyleClass(this.getStyleClass());this.oContextMenuControl.show(o,e,{x:p.clientX,y:p.clientY});}this.fireOpenedContextMenu();}.bind(this)).catch(function(E){throw D.createError("ContextMenu#open","An error occured during calling getMenuItems: "+E);});};
d.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};
d.prototype._onContextMenu=function(e){var o=O.getOverlay(e.currentTarget.id);var p={clientX:e.clientX,clientY:e.clientY};this._openContextMenu(e,o,p);};
d.prototype._onItemSelected=function(e){this.oContextMenuControl.close(true);this._ensureSelection(this._oCurrentOverlay);this.setFocusLock(true);var s=[];var o=this.getContextElement();var S=e.data("id");this._aMenuItems.some(function(m){if(S===m.menuItem.id){var i=m.menuItem;s=m.menuItem.responsible||this.getSelectedOverlays();b(s.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");var p={};p.eventItem=e;p.contextElement=o;var h=i.handler;if(this.oContextMenuControl.isPopupOpen()){this.oContextMenuControl.attachEventOnce("Closed",function(){h(s,p);});}else{h(s,p);}i=null;return true;}},this);};
d.prototype._onContextMenuOrClick=function(e){if(!this.fnDebounced){this.fnDebounced=c(function(){if(this._oCurrentEvent.type==="contextmenu"){this._onContextMenu(this._oCurrentEvent);}else{this._onClickorTouch(this._oCurrentEvent);}this._oCurrentEvent=undefined;this.fnDebounced=undefined;}.bind(this),50);}var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&o.getSelected()){this._oCurrentEvent=e;e.stopPropagation();this.fnDebounced();}};
d.prototype._onClickorTouch=function(e){if(this.getOpenOnClick()){if(this.isMenuOpeningLocked()){this.unlockMenuOpening();this.oContextMenuControl.close();}this._startOpening(e);}};
d.prototype._startOpening=function(e,l){clearTimeout(this.hoverTimeout);this._bOpenedByHover=false;this._oTempTarget=e.currentTarget.id;var o=O.getOverlay(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1&&(!this.isMenuOpeningLocked())){e.stopPropagation();if(this._shouldContextMenuOpen(e)){this._ensureSelection(o);if(this._oCurrentOverlay.isSelected()||a.os.android){if(l){this.lockMenuOpening();}this.open({clientX:e.clientX,clientY:e.clientY},o);return true;}}}};
d.prototype._onHover=function(e){var o=O.getOverlay(e.currentTarget.id);if(o&&o.isSelectable()&&!e.ctrlKey&&this.getOpenOnHover()){e.stopPropagation();if(this._shouldContextMenuOpen(e,true)){if(this.iMenuHoverClosingDelay>=this.iMenuHoverOpeningDelay){throw new Error("sap.ui.dt ContextMenu iMenuHoverClosingDelay is bigger or equal to iMenuHoverOpeningDelay!");}if(this.oContextMenuControl.getPopover().isOpen()){this._closingTimeout=setTimeout(function(){if(this.oContextMenuControl.getPopover().isOpen()){this.oContextMenuControl.close();}}.bind(this),this.iMenuHoverClosingDelay);}this.hoverTimeout=setTimeout(function(){O.getOverlay(e.currentTarget.id).focus();this._startOpening(e);this._bOpenedByHover=true;}.bind(this),this.iMenuHoverOpeningDelay);}}};
d.prototype._clearHoverTimeout=function(){if(this.hoverTimeout){clearTimeout(this.hoverTimeout);this.hoverTimeout=null;}if(this._closingTimeout){clearTimeout(this._closingTimeout);this._closingTimeout=null;}};
d.prototype._onKeyUp=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE||e.keyCode===K.ENTER)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){this._startOpening(e,true);e.stopPropagation();e.preventDefault();}}if((e.keyCode===K.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()){e.preventDefault();var p={clientX:"not set",clientY:"not set"};this._openContextMenu(e,o,p);}}};
d.prototype._onKeyDown=function(e){var o=O.getOverlay(e.currentTarget.id);if((e.keyCode===K.SPACE)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()&&!this._checkForPluginLock()){e.stopPropagation();e.preventDefault();}}};
d.prototype._shouldContextMenuOpen=function(e,o){if((!this._checkForPluginLock()&&!this.isMenuOpeningLocked())){if(!o){this._oCurrentOverlay=O.getOverlay(e.currentTarget.id);}return true;}return false;};
d.prototype._pressedOverflowButton=function(e){this.lockMenuOpening();var o=O.getOverlay(e.oSource._oTarget.getAttribute("overlay"));var p={clientX:e.mParameters.oButton.$().offset().left,clientY:e.mParameters.oButton.$().offset().top};this._openContextMenu(e,o,p);this.setFocusLock(true);};
d.prototype._openContextMenu=function(e,o,p){if(o&&o.isSelectable()){e.preventDefault();this._oCurrentOverlay=o;this.oContextMenuControl.close(true);this._bOpenedByHover=false;clearTimeout(this.hoverTimeout);this._ensureSelection(o);this.lockMenuOpening();this.open(p,o,true);if(e.stopPropagation){e.stopPropagation();}}};
d.prototype._contextMenuClosed=function(){this.unlockMenuOpening();this.setFocusLock(false);};
d.prototype._onSelectionChanged=function(){this.oContextMenuControl.close(true);this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this);};
d.prototype.lockMenuOpening=function(o){if((this.oContextMenuControl.getPopover(true).isOpen()||this.oContextMenuControl.getPopover(false).isOpen())&&o!==true){this._bAsyncLock=true;}else{this._bOpeningLocked=true;}};
d.prototype.unlockMenuOpening=function(){this._bOpeningLocked=false;if(this._bAsyncLock){this.lockMenuOpening(true);}this._bAsyncLock=false;};
d.prototype.isMenuOpeningLocked=function(){return this._bOpeningLocked;};
d.prototype.setFocusLock=function(i){this._bFocusLocked=i;};
d.prototype._ensureSelection=function(o){if(o&&!o.isSelected()){o.setSelected(true);}};
d.prototype._checkForPluginLock=function(){if(a.os.ios){return false;}if(this.getDesignTime().getBusyPlugins().length){return true;}this.setFocusLock(false);return false;};
d.prototype._addMenuItemToGroup=function(m){var g=this._aGroupedItems.some(function(e){if(e.sGroupName===m.group){e.aGroupedItems.push(m);return true;}});if(!g){this._aGroupedItems.push({sGroupName:m.group,aGroupedItems:[m]});}};
d.prototype._addSubMenu=function(m,p,o){m.submenu.forEach(function(s){s.handler=m.handler;});m.handler=function(M,p,o){this._aSubMenus.some(function(e){if(e.sSubMenuId===M){e.aSubMenuItems.forEach(function(s){this.addMenuItem(s,true,true);}.bind(this));return true;}}.bind(this));if(!this._bContextMenu){p.clientX=null;p.clientY=null;}this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();}.bind(this,m.id,p,o);this._aSubMenus.push({sSubMenuId:m.id,aSubMenuItems:m.submenu});this.addMenuItem(m,true);};
d.prototype._addItemGroupsToMenu=function(p,o){this._aGroupedItems.forEach(function(g,i){if(g.aGroupedItems.length===1){this.addMenuItem(g.aGroupedItems[0],true,false);}else{var h=function(i,p,o){this._aGroupedItems[i].aGroupedItems.forEach(function(m){this.addMenuItem(m,true,true);}.bind(this));this.oContextMenuControl.close();setTimeout(function(){this.open(p,o,true,true);}.bind(this),0);this.lockMenuOpening();};this.addMenuItem({id:g.sGroupName+"-groupButton",enabled:true,text:g.sGroupName,icon:g.aGroupedItems[0].icon,rank:g.aGroupedItems[0].rank,handler:h.bind(this,i,p,o)},true);}}.bind(this));};
return d;});
sap.ui.predefine('sap/ui/dt/plugin/ControlDragDrop',["sap/ui/dt/plugin/DragDrop","sap/ui/dt/plugin/ElementMover"],function(D,E){"use strict";
var C=D.extend("sap.ui.dt.plugin.ControlDragDrop",{metadata:{library:"sap.ui.dt",properties:{draggableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"},insertAfterElement:{type:"boolean",defaultValue:false}},associations:{}}});
var d="sapUiDtOverlayDropZone";
C.prototype.init=function(){D.prototype.init.apply(this,arguments);this.setElementMover(new E());};
C.prototype.setElementMover=function(n){var o=this.getElementMover();if(o!==n){if(o){o.destroy();}this.setProperty("elementMover",n);}};
C.prototype.setDraggableTypes=function(a){this.getElementMover().setMovableTypes(a);return this.setProperty("draggableTypes",a);};
C.prototype.registerElementOverlay=function(o){var e=o.getElement();this.getElementMover().checkMovable(o).then(function(m){if(this.getElementMover().isMovableType(e)&&m){o.setMovable(true);}if(this.oDraggedElement){this.getElementMover().activateTargetZonesFor(o,d);}D.prototype.registerElementOverlay.call(this,o);}.bind(this));};
C.prototype.deregisterElementOverlay=function(o){D.prototype.deregisterElementOverlay.apply(this,arguments);o.setMovable(false);if(this.oDraggedElement){this.getElementMover().deactivateTargetZonesFor(o,d);}};
C.prototype.getDraggedOverlay=function(){return this._oDraggedOverlay;};
C.prototype.onDragStart=function(o){this._oDraggedOverlay=o;this.getElementMover().setMovedOverlay(o);this.getElementMover().activateAllValidTargetZones(this.getDesignTime(),d);};
C.prototype.onDragEnd=function(){delete this._oPreviousTarget;this.getElementMover().deactivateAllTargetZones(this.getDesignTime(),d);delete this._oDraggedOverlay;this.getElementMover().setMovedOverlay(null);};
C.prototype.onDragEnter=function(t){var o=this.getDraggedOverlay();if(t.getElement()!==o.getElement()&&t!==this._oPreviousTarget){this.getElementMover().repositionOn(o,t);}this._oPreviousTarget=t;};
C.prototype.onAggregationDragEnter=function(a){delete this._oPreviousTarget;var o=this.getDraggedOverlay();this.getElementMover().insertInto(o,a,this.getInsertAfterElement());};
return C;});
sap.ui.predefine('sap/ui/dt/plugin/CutPaste',["sap/ui/dt/Plugin","sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/Device"],function(P,E,O,D,a,K,b){"use strict";var I=true;
var C=P.extend("sap.ui.dt.plugin.CutPaste",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});
C.prototype.init=function(){this.setElementMover(new E());};
C.prototype.registerElementOverlay=function(o){var e=o.getElement();this.getElementMover().checkMovable(o).then(function(m){o.attachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().isMovableType(e)&&m){o.setMovable(true);}if(this.getElementMover().getMovedOverlay()){this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay());}}.bind(this)).catch(function(c){throw D.createError("CutPaste#registerElementOverlay","An error occured during checkMovable: "+c);});};
C.prototype.deregisterElementOverlay=function(o){o.setMovable(false);o.detachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().getMovedOverlay()){this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay());}};
C.prototype.setMovableTypes=function(m){this.getElementMover().setMovableTypes(m);return this.setProperty("movableTypes",m);};
C.prototype.setElementMover=function(e){e.setMovableTypes(this.getMovableTypes());return this.setProperty("elementMover",e);};
C.prototype.getCuttedOverlay=function(){return this.getElementMover().getMovedOverlay();};
C.prototype.isElementPasteable=function(t){var T=this._getTargetZoneAggregation(t);if((T)||(O.isInTargetZoneAggregation(t))){return true;}return false;};
C.prototype._onKeyDown=function(e){var o=a.getOverlay(e.currentTarget.id);var c=b.os.macintosh?e.metaKey:e.ctrlKey;if((e.keyCode===K.X)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){this.cut(o);e.stopPropagation();}else if((e.keyCode===K.V)&&(e.shiftKey===false)&&(e.altKey===false)&&(c===true)){if(this.getElementMover().getMovedOverlay()){this.paste(o);}e.stopPropagation();}else if(e.keyCode===K.ESCAPE){this.stopCutAndPaste();e.stopPropagation();}};
C.prototype.cut=function(o){this.stopCutAndPaste();if(o.isMovable()){this.getElementMover().setMovedOverlay(o);o.addStyleClass("sapUiDtOverlayCutted");return this.getElementMover().activateAllValidTargetZones(this.getDesignTime()).then(function(){o.focus();});}return Promise.resolve(undefined);};
C.prototype._executePaste=function(t){var c=this.getElementMover().getMovedOverlay();if(!c){return false;}var r=false;if(!this._isForSameElement(c,t)){var T=this._getTargetZoneAggregation(t);if(T){this.getElementMover().insertInto(c,T);r=true;}else if(O.isInTargetZoneAggregation(t)){this.getElementMover().repositionOn(c,t,I);r=true;}}if(r){c.setSelected(true);setTimeout(function(){c.focus();},0);}return r;};
C.prototype.paste=function(t){var p=this._executePaste(t);if(p===true){this.stopCutAndPaste();}};
C.prototype.stopCutAndPaste=function(){var c=this.getElementMover().getMovedOverlay();if(c){c.removeStyleClass("sapUiDtOverlayCutted");this.getElementMover().setMovedOverlay(null);this.getElementMover().deactivateAllTargetZones(this.getDesignTime());}};
C.prototype._isForSameElement=function(c,t){return t.getElement()===c.getElement();};
C.prototype._getTargetZoneAggregation=function(t){var A=t.getAggregationOverlays();var p=A.filter(function(o){return o.isTargetZone();});if(p.length>0){return p[0];}return null;};
return C;});
sap.ui.predefine('sap/ui/dt/plugin/ElementMover',["sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/Util"],function(B,M,E,D,O,a){"use strict";
var b=M.extend("sap.ui.dt.plugin.ElementMover",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{validTargetZonesActivated:{}}}});
b.prototype._getMovableTypes=function(){return this.getProperty("movableTypes")||[];};
b.prototype.isMovableType=function(e){var m=this._getMovableTypes();return m.some(function(t){return B.isA(e,t);});};
b.prototype.checkMovable=function(){return Promise.resolve(true);};
b.prototype.getMovedOverlay=function(){return this._oMovedOverlay;};
b.prototype.setMovedOverlay=function(m){if(m){this._source=O.getParentInformation(m);}else{delete this._source;}this._oMovedOverlay=m;};
b.prototype._getSource=function(){return this._source;};
b.prototype.activateAllValidTargetZones=function(d,A){return this._iterateAllAggregations(d,this._activateValidTargetZone.bind(this),A,true).then(function(){this.fireValidTargetZonesActivated();}.bind(this));};
b.prototype._activateValidTargetZone=function(A,s){return this.checkTargetZone(A).then(function(v){if(v){A.setTargetZone(true);if(s){A.addStyleClass(s);}}}).catch(function(e){throw a.createError("ElementMover#_activateValidTargetZone","An error occured during activation of valid target zones: "+e);});};
b.prototype._checkAggregationOverlayVisibility=function(A,p){var o=A.getDomRef();var c=D.isVisible(o);if(!o){return c;}var P=p&&p.getDomRef&&p.getDomRef();var d=P?D.isVisible(P):true;return c||d;};
b.prototype.checkTargetZone=function(A,o,c){var g=A.getGeometry();var G=g&&g.size.height>0&&g.size.width>0;var p=A.getElement();if((c&&!G)||!c&&!this._checkAggregationOverlayVisibility(A,p)||!(p&&p.getVisible&&p.getVisible())){return Promise.resolve(false);}if(!p.getParent()){return Promise.resolve(false);}var m=o||this.getMovedOverlay();var d=m.getElement();var s=A.getAggregationName();if(d&&E.isValidForAggregation(p,s,d)){return Promise.resolve(true);}return Promise.resolve(false);};
b.prototype._deactivateTargetZone=function(A,s){A.setTargetZone(false);if(s){A.removeStyleClass(s);}};
b.prototype.activateTargetZonesFor=function(o,A){return this._iterateOverlayAggregations(o,this._activateValidTargetZone.bind(this),A,true).then(function(){this.fireValidTargetZonesActivated();}.bind(this));};
b.prototype.deactivateTargetZonesFor=function(o,A){this._iterateOverlayAggregations(o,this._deactivateTargetZone.bind(this),A);};
b.prototype.deactivateAllTargetZones=function(d,A){this._iterateAllAggregations(d,this._deactivateTargetZone.bind(this),A);};
b.prototype._iterateAllAggregations=function(d,s,A,c){var o=d.getElementOverlays();var r=o.map(function(e){return this._iterateOverlayAggregations(e,s,A,c);},this);if(c){return Promise.all(r);}};
b.prototype._iterateOverlayAggregations=function(o,s,A,c){var d=o.getAggregationOverlays();var r=d.map(function(e){return s(e,A);});if(c){return Promise.all(r);}};
b.prototype.repositionOn=function(m,t,i){var o=m.getElement();var T=O.getParentInformation(t);var s=O.getParentInformation(m);var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var c=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(c);}if(T.index!==-1){if(A&&A.beforeMove){A.beforeMove(r,o);}if(i){T.index++;if(s.aggregation===T.aggregation){T.index=E.adjustIndexForMove(s.parent,T.parent,s.index,T.index);}}E.insertAggregation(T.parent,T.aggregation,o,T.index);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype.insertInto=function(m,t,i){var o=m.getElement();var T=t.getElement();var A;var p=m.getParentAggregationOverlay();var r=m.getRelevantContainer();var P=m.getParentElementOverlay();if(p&&P){var s=p.getAggregationName();A=P.getDesignTimeMetadata().getAggregation(s);}var c=E.getAggregation(t.getElement(),t.getAggregationName());var I=c.indexOf(o);var d=i?c.length:0;if(!(I>-1&&I===(d===0?d:d-1))){if(A&&A.beforeMove){A.beforeMove(r,o);}var e=t.getAggregationName();E.insertAggregation(T,e,o,d);if(A&&A.afterMove){A.afterMove(r,o);}}};
b.prototype._compareSourceAndTarget=function(s,t){var p;for(p in s){switch(typeof(s[p])){case'object':if(s[p].getId()!==t[p].getId()){return false;}break;default:if(s[p]!==t[p]){return false;}}}return true;};
return b;});
sap.ui.predefine('sap/ui/dt/plugin/TabHandling',["sap/ui/thirdparty/jquery","sap/ui/dt/Plugin","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dom/jquery/Selectors"],function(q,P,O,a){"use strict";
var T=P.extend("sap.ui.dt.plugin.TabHandling",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
T.prototype.registerElementOverlay=function(o){if(o.isRoot()){this.removeTabIndex();}};
T.prototype.deregisterElementOverlay=function(o){if(o.isRoot()){this.restoreTabIndex();}};
T.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){if(!this._oMutationObserver){this._oMutationObserver=O.getMutationObserver();this._oMutationObserver.attachDomChanged(this._onDomChanged,this);}}else{this._oMutationObserver.detachDomChanged(this._onDomChanged,this);delete this._oMutationObserver;this.restoreTabIndex();}};
T.prototype.removeTabIndex=function(){var d=this.getDesignTime();var r=d.getRootElements();r.forEach(function(R){var o=a.getOverlay(R);var $=o&&o.getAssociatedDomRef();if($){$.find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(i,n){n.setAttribute("data-sap-ui-dt-tabindex",n.tabIndex);n.setAttribute("tabindex",-1);});}});};
T.prototype.restoreTabIndex=function(){q("[data-sap-ui-dt-tabindex]").each(function(i,n){n.setAttribute("tabindex",n.getAttribute("data-sap-ui-dt-tabindex"));n.removeAttribute("data-sap-ui-dt-tabindex");});};
T.prototype._onDomChanged=function(){if(this.getDesignTime().getEnabled()){this.removeTabIndex();}};
return T;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/dt/AggregationDesignTimeMetadata',["sap/ui/dt/DesignTimeMetadata"],function(D){"use strict";
var A=D.extend("sap.ui.dt.AggregationDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
A.prototype.getLabel=function(e,a){return D.prototype.getLabel.apply(this,arguments)||a;};
return A;});
sap.ui.predefine('sap/ui/dt/AggregationOverlay',["sap/ui/thirdparty/jquery","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/Util","sap/base/util/merge"],function(q,O,E,U,m){"use strict";
var A=O.extend("sap.ui.dt.AggregationOverlay",{metadata:{library:"sap.ui.dt",properties:{aggregationName:{type:"string"},targetZone:{type:"boolean",defaultValue:false},scrollContainerId:{type:"int"}},events:{targetZoneChange:{parameters:{targetZone:{type:"boolean"}}}}}});
A.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-aggregation":this.getAggregationName()});};
A.prototype._getChildIndex=function(c){var C=this.getChildren();var p;var P=C.indexOf(c)-1;while(P>0){p=C[P];if(p.isRendered()){break;}P--;}return P<0?0:P+1;};
A.prototype.insertChild=function(p,c){if(!(U.isInteger(p))){p=E[this.isAssociation()?'getIndexInAssociation':'getIndexInAggregation'](c.getElement(),this.getElement(),this.getAggregationName());}var P=this.indexOfAggregation('children',c);if(P!==p){if(P>-1){this.removeAggregation('children',c);}this.insertAggregation('children',c,p);if(this.isRendered()){var i=this._getChildIndex(c);var C=c.isRendered();var $=C?c.$():c.render(true);var a=q(this.getChildrenDomRef());var b=a.find('>').index($);var I;if(b!==i){if(i>0){I=b>-1&&b<i?i:i-1;a.find('>').eq(I).after($);}else{I=i;a.prepend($);}}if(!C){c.fireAfterRendering({domRef:$.get(0)});}}this.fireChildAdded();return true;}return false;};
A.prototype.addChild=function(c,s){this.insertChild(this.getChildren().length,c);if(!s){this.fireChildAdded();}};
A.prototype.render=function(){if(this.getChildren().length>0||this.getDesignTimeMetadata().getDomRef()){this.addStyleClass('sapUiDtAggregationOverlay');return O.prototype.render.apply(this,arguments);}};
A.prototype._getRenderingParent=function(){if(U.isInteger(this.getScrollContainerId())){return this.getParent().getScrollContainerById(this.getScrollContainerId());}return O.prototype._getRenderingParent.apply(this,arguments);};
A.prototype._setPosition=function(t,g,p,f){O.prototype._setPosition.apply(this,arguments);if(g.domRef&&!U.isInteger(this.getScrollContainerId())){this._handleOverflowScroll(g,this.$(),this.getParent(),f);}};
A.prototype.getAssociatedDomRef=function(){var e=this.getElement();var a=this.getAggregationName();var d=this.getDesignTimeMetadata();return d.getAssociatedDomRef(e,d.getDomRef(),a);};
A.prototype.setTargetZone=function(t){if(this.getTargetZone()!==t){this.setProperty("targetZone",t);this.toggleStyleClass("sapUiDtOverlayTargetZone",t);this.fireTargetZoneChange({targetZone:t});}return this;};
A.prototype.isTargetZone=function(){return this.getTargetZone();};
A.prototype.isAssociation=function(){return!!this.getDesignTimeMetadata().getData().aggregationLike;};
return A;});
sap.ui.predefine('sap/ui/dt/ControlObserver',["sap/ui/dt/ManagedObjectObserver"],function(M){"use strict";
var C=M.extend("sap.ui.dt.ControlObserver",{metadata:{library:"sap.ui.dt",properties:{},associations:{target:{type:"sap.ui.core.Control"}}}});
C.prototype.init=function(){M.prototype.init.apply(this,arguments);this._oControlDelegate={onAfterRendering:this._onAfterRendering};};
C.prototype.observe=function(c){M.prototype.observe.apply(this,arguments);c.addEventDelegate(this._oControlDelegate,this);};
C.prototype.unobserve=function(){var c=this.getTargetInstance();if(c){c.removeDelegate(this._oControlDelegate,this);}M.prototype.unobserve.apply(this,arguments);};
C.prototype._onAfterRendering=function(){this.fireModified({type:"afterRendering"});};
return C;});
sap.ui.predefine('sap/ui/dt/DOMUtil',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/dom/jquery/zIndex","sap/ui/dom/jquery/scrollLeftRTL"],function(q,D){"use strict";var a={};
a.getSize=function(d){var c=d.getBoundingClientRect();return{width:c.width,height:c.height};};
a.getOffsetFromParent=function(g,p){var P=p?q(p):null;var s=P?P.scrollTop():null;var S=p?a.getScrollLeft(p):null;var m=P?P.offset():null;var o={left:g.position.left,top:g.position.top};if(m){o.left-=(m.left-(S||0));o.top-=(m.top-(s||0));}if(sap.ui.getCore().getConfiguration().getRTL()){var i=P?P.outerWidth():q(window).outerWidth();if(D.browser.safari&&!D.browser.mobile&&a.hasVerticalScrollBar(P)){o.left-=a.getScrollbarWidth();}o.left=o.left-(i-g.size.width);}return o;};
a.getScrollLeft=function(e){if(!sap.ui.getCore().getConfiguration().getRTL()||!a.hasHorizontalScrollBar(e)){return q(e).scrollLeft();}var s=q(e).scrollLeftRTL();var m=e.scrollWidth-e.clientWidth;return s-m;};
a.getZIndex=function(d){var z;var e=q(d);if(e.length){z=e.zIndex()||e.css("z-index");}return z;};
a._getElementDimensions=function(d,m,b){var r=d[0]||d;var o=r["offset"+m];var v=0;for(var i=0;i<2;i++){var B=window.getComputedStyle(r,null)["border"+b[i]+m];v-=B?parseInt(B.slice(0,-2)):0;}return o+v;};
a._getElementWidth=function(d){return a._getElementDimensions(d,"Width",["Right","Left"]);};
a._getElementHeight=function(d){return a._getElementDimensions(d,"Height",["Top","Bottom"]);};
a.hasVerticalScrollBar=function(d){var $=q(d);var o=$.css("overflow-y")==="auto"||$.css("overflow-y")==="scroll";return o&&$.get(0).scrollHeight>a._getElementHeight(d);};
a.hasHorizontalScrollBar=function(d){var $=q(d);var o=$.css("overflow-x")==="auto"||$.css("overflow-x")==="scroll";return o&&$.get(0).scrollWidth>a._getElementWidth(d);};
a.hasScrollBar=function(d){return a.hasVerticalScrollBar(d)||a.hasHorizontalScrollBar(d);};
a.getScrollbarWidth=function(){if(typeof a.getScrollbarWidth._cache==='undefined'){var o=q('<div></div>').css({position:'absolute',top:'-9999px',left:'-9999px',width:'100px'}).appendTo('body');var w=o.width();o.css('overflow','scroll');var i=q('<div></div>').css('width','100%').appendTo(o);var W=i.width();o.remove();a.getScrollbarWidth._cache=w-W;}return a.getScrollbarWidth._cache;};
a.getOverflows=function(d){var $=q(d);return{overflowX:$.css("overflow-x"),overflowY:$.css("overflow-y")};};
a.getGeometry=function(d,u){if(d){var o=q(d).offset();if(u){o.left=o.left-q(window).scrollLeft();o.top=o.top-q(window).scrollTop();}return{domRef:d,size:this.getSize(d),position:o,visible:this.isVisible(d)};}};
a.syncScroll=function(s,t){var $=q(t);var T=$.scrollTop();var o=$.scrollLeft();var b=q(s);var S=b.scrollTop();var c=b.scrollLeft();if(S!==T){$.scrollTop(S);}if(c!==o){$.scrollLeft(c);}};
a.getDomRefForCSSSelector=function(d,c){if(c&&d){var $=q(d);if(c===":sap-domref"){return $;}if(c.indexOf(":sap-domref")>-1){return $.find(c.replace(/:sap-domref/g,""));}return $.find(c);}return q();};
a.isVisible=function(d){return d?d.offsetWidth>0&&d.offsetHeight>0:false;};
a.setDraggable=function(n,v){n.setAttribute("draggable",v);};
a.getDraggable=function(n){switch(n.getAttribute("draggable")){case"true":return true;case"false":return false;default:return;}};
a._copyStylesTo=function(s,d){var S="";var b="";var l=s.length;for(var i=0;i<l;i++){b=s[i];S=S+b+":"+s.getPropertyValue(b)+";";}d.style.cssText=S;};
a._copyPseudoElement=function(p,s,d){var S=window.getComputedStyle(s,p);var c=S.getPropertyValue("content");if(c&&c!=="none"){c=String(c).trim();if(c.indexOf("attr(")===0){c=c.replace("attr(","");if(c.length){c=c.substring(0,c.length-1);}c=s.getAttribute(c)||"";}var P=q("<span></span>");if(p===":after"){P.appendTo(d);}else{P.prependTo(d);}P.text(c.replace(/(^['"])|(['"]$)/g,""));a._copyStylesTo(S,P.get(0));P.css("display","inline");}};
a.copyComputedStyle=function(s,d){s=q(s).get(0);d=q(d).get(0);var S=window.getComputedStyle(s);if(S.getPropertyValue("display")==="none"){d.style.display="none";return;}a._copyStylesTo(S,d);this._copyPseudoElement(":after",s,d);this._copyPseudoElement(":before",s,d);};
a.copyComputedStyles=function(s,d){s=q(s).get(0);d=q(d).get(0);for(var i=0;i<s.children.length;i++){this.copyComputedStyles(s.children[i],d.children[i]);}q(d).removeClass();q(d).attr("id","");q(d).attr("role","");q(d).attr("data-sap-ui","");q(d).attr("for","");q(d).attr("tabindex",-1);this.copyComputedStyle(s,d);};
a.cloneDOMAndStyles=function(n,t){n=q(n).get(0);var c=n.cloneNode(true);this.copyComputedStyles(n,c);q(t).append(c);};
a.insertStyles=function(s,t){var S=document.createElement('style');S.type='text/css';S.appendChild(document.createTextNode(s));t.appendChild(S);};
a.contains=function(i,t){var n=document.getElementById(i);return!!n&&n.contains(t);};
a.appendChild=function(t,c){var s=c.scrollTop;var S=q(c).scrollLeft();t.appendChild(c);c.scrollTop=s;q(c).scrollLeft(S);};
a.focusWithoutScrolling=function(t){if(D.browser.name!=="ie"){t.focus({preventScroll:true});return;}var s=[];var p=t.parentNode;while(p){s.push([p,q(p).scrollLeft(),p.scrollTop]);p=p.parentNode;}t.focus();s.forEach(function(i){var e=i[0];if(q(e).scrollLeft()!==i[1]){q(e).scrollLeft(i[1]);}if(e.scrollTop!==i[2]){e.scrollTop=i[2];}});};
return a;},true);
sap.ui.predefine('sap/ui/dt/DesignTime',["sap/ui/base/ManagedObject","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/SelectionManager","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Util","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/dt/SelectionMode","sap/base/util/includes","sap/ui/dt/DesignTimeStatus","sap/base/util/restricted/_curry"],function(M,E,A,O,S,a,b,c,d,e,f,U,T,g,L,i,m,h,j,D,_){"use strict";
var k=M.extend("sap.ui.dt.DesignTime",{
metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},
constructor:function(){this._sStatus=D.SYNCED;this._mPendingOverlays={};this._oTaskManager=new T({complete:function(o){if(o.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==D.SYNCED){this._sStatus=D.SYNCED;setTimeout(function(){if(this._sStatus===D.SYNCED){this.fireSynced();}}.bind(this),0);}}}.bind(this),add:function(o){if(o.getSource().count()===1){this._sStatus=D.SYNCING;this.fireSyncing();}}.bind(this)});this._oTaskRunner=new g({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new S();this._aOverlaysCreatedInLastBatch=[];M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(o){this._createOverlaysForRootElement(o.getParameter('element'));},this);this.getPlugins().forEach(function(p){p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("addPlugin",function(o){var p=o.getParameter('plugin');p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("enabledChanged",function(o){var v=o.getParameter('value');var $=d.getOverlayContainer();$[v?'show':'hide']();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){this._oTaskManager.add({type:"applyStyles",callbackFn:R.applyStyles.bind(R,true),overlayId:R.getId()});}}.bind(this));},this);}
});
k.prototype._onProcessingStatusChange=function(o){if(o.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}};
k.prototype._onApplyStylesRequired=function(o){var p=o.getParameters();var l=o.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:l.applyStyles.bind(l,p.bForceScrollbarSync),overlayId:l.getId()},"overlayId");};
k.prototype._removeOverlayFromSyncingBatch=function(o){var I=this._aOverlaysCreatedInLastBatch.indexOf(o);if(I!==-1){this._aOverlaysCreatedInLastBatch.splice(I,1);}};
k.prototype._registerElementOverlays=function(){var l=this._aOverlaysCreatedInLastBatch.slice();if(!l.length){return;}var t=this._oTaskManager.add({type:"registerElementOverlays"});var p=this.getPlugins();l.forEach(function(o){O.register(o);o.attachBeforeDestroy(function(n){O.deregister(n.getSource());});});l.forEach(function(o){p.forEach(function(P){try{P.callElementOverlayRegistrationMethods(o);}catch(v){var n=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('registerElementOverlay() method of the plugin {0} has failed for overlay with id="{1}" (element id="{2}")',P.getMetadata().getName(),o.getId(),o.getElement().getId()));L.error(U.errorToString(n));}});},this);l.forEach(function(o){try{this.fireElementOverlayCreated({elementOverlay:o});}catch(v){var n=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('One of the listeners of elementOverlayCreated event failed while precessing the overlay with id="{0}" for element with id="{1}"',o.getId(),o.getElement().getId()));L.error(U.errorToString(n));}},this);this._aOverlaysCreatedInLastBatch=[];this._oTaskManager.complete(t);};
k.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(p){p.destroy();});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending;};
k.prototype.getSelection=function(){return this.getSelectionManager().get();};
k.prototype.getSelectionManager=function(){return this._oSelectionManager;};
k.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};
k.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(p){return p.isBusy();});};
k.prototype.addPlugin=function(p){this.addAggregation("plugins",p);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};
k.prototype.insertPlugin=function(p,I){this.insertAggregation("plugins",p,I);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};
k.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}}.bind(this));this.removeAggregation("plugins",p);return this;};
k.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}.bind(this));this.removeAllAggregation("plugins");return this;};
k.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};
k.prototype.getDesignTimeMetadataFor=function(o){var C;if(typeof o==='string'){C=o;L.error('sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance');}else{C=o.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};
k.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};
k.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:"createOverlay",element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(o){d.getOverlayContainer().append(o.render());this._oTaskManager.add({type:"applyStyles",callbackFn:o.applyStyles.bind(o),overlayId:o.getId()},"overlayId");this._oTaskManager.complete(t);return o;}.bind(this),function(v){var o=U.propagateError(v,"DesignTime#_createOverlaysForRootElement",U.printf('Root element with id = "{0}" initialization is failed',r.getId()));L.error(U.errorToString(o));this._oTaskManager.cancel(t);this.fireSyncFailed({error:o});}.bind(this));};
k.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};
k.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};
k.prototype.getElementOverlays=function(){var l=[];this._iterateRootElements(function(r){l=l.concat(this._getAllElementOverlaysIn(r));},this);return l;};
k.prototype.createOverlay=function(v){var p=Object.assign({},i(v)?v:{element:v});var t=this._oTaskManager.add({type:'createOverlay'});if(!p.element||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return this._rejectCreateOverlay(p.element);}var s=p.element.getId();var o=O.getOverlay(s);if(o){this._oTaskManager.complete(t);return Promise.resolve(o);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}if(typeof p.root==="undefined"){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(o){return this._createChildren(o,p.parentMetadata).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[s];},this);if(this.bIsDestroyed){o.detachEvent('destroyed',this._onElementOverlayDestroyed,this);o.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(o.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}this._aOverlaysCreatedInLastBatch.push(o);this._oTaskManager.complete(t);return o;}.bind(this));}.bind(this)).catch(function(l){var n=U.propagateError(l,'DesignTime#createOverlay',U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this._oTaskManager.cancel(t);return Promise.reject(n);}.bind(this));return this._mPendingOverlays[s];};
k.prototype._rejectCreateOverlay=function(o){var r;if(!o){r="Cannot create overlay — no element is specified.";}else if(o.bIsDestroyed){r="Cannot create overlay — the element is already destroyed.";}else if(o instanceof M&&!c.isElementInTemplate(o)){r="Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='"+o.getId()+"'. Please report to CA-UI5-FL-RTA component.";}else{r=U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(o));}return Promise.reject(U.createError("DesignTime#createOverlay",r));};
k.prototype._createElementOverlay=function(p){var o=p.element;function l(P){return new E(P);}return new Promise(function(r,R){l({element:o,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(o)instanceof a?this.getDesignTimeMetadataFor(o):_(function(n,P,o,q){q=m({},q,n);this._mMetadataOriginal=q;if(P){q=f.propagateMetadataToElementOverlay(q,P,o);}return q;})(this.getDesignTimeMetadataFor(o),p.parentMetadata,o)),init:function(n){var q=n.getSource();r(n.getSource());q.attachEvent('destroyed',this._onElementOverlayDestroyed,this);q.attachEvent('elementDestroyed',this._onElementDestroyed,this);q.attachEvent('selectionChange',this._onElementOverlaySelectionChange,this);q.attachEvent('elementModified',this._onElementModified,this);q.attachEvent('editableChange',this._onEditableChanged,this);q.attachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this),initFailed:function(s,n){var q=n.getSource();var t=U.propagateError(n.getParameter('error'),'DesignTime#_createElementOverlay',U.printf("Can't create overlay properly (id='{0}') for '{1}'",q.getId(),s));q.detachEvent('destroyed',this._onElementOverlayDestroyed,this);q.detachEvent('elementDestroyed',this._onElementDestroyed,this);q.detachEvent('applyStylesRequired',this._onApplyStylesRequired,this);q.destroy();R(t);}.bind(this,o.getId())});}.bind(this));};
k.prototype._createChildren=function(o,p){return Promise.all(o.getAggregationNames().map(function(s){var l=o.getElement();var n=l.getMetadata().getName();var q=f.propagateMetadataToAggregationOverlay(o.getDesignTimeMetadata().getAggregation(s),l,p);var r=new A({aggregationName:s,element:l,designTimeMetadata:new b({data:q}),init:function(t){var r=t.getSource();r.attachEvent('destroyed',this._onAggregationOverlayDestroyed,this);r.attachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this),beforeDestroy:function(t){var r=t.getSource();O.deregister(r);r.detachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this)});O.register(r);return Promise.all(c[r.isAssociation()?'getAssociationInstances':'getAggregation'](l,s).map(function(P,l){return this.createOverlay({element:l,root:false,parentMetadata:q}).catch(function(t){var u=this._enrichChildCreationError(t,l,P,s);L[u.severity](u.message);return u.errorObject;}.bind(this));}.bind(this,n))).then(function(C){C.map(function(t){if(t instanceof E&&!t.bIsDestroyed){r.addChild(t,true);}},this);return r;}.bind(this));},this)).then(function(l){l.forEach(function(n){if(o.bIsDestroyed){n.destroy();}else{o.addChild(n,true);}});});};
k.prototype._enrichChildCreationError=function(o,l,p,s){var n="error";var q=U.errorToString(o);if(o.message.includes("Cannot create overlay without a valid element")){n="warning";o=U.createError("DesignTime#_createChildren",U.printf(["Child element in aggregation '{0}' of {1} must be a descendant of sap.ui.core.Element or ","sap.ui.core.Component, but {2} was give. Consider ignoring the aggregation '{0}' ","in the .designtime configuration of the control."].join(''),s,p,U.getObjectType(l)));q=o.toString();}else if(o.message.startsWith("Element is in a bound aggregation")){n="error";q=o.toString();}return{errorObject:o,severity:n,message:q};};
k.prototype._destroyOverlaysForElement=function(o){var l=O.getOverlay(o);if(l){l.destroy();}};
k.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};
k.prototype._onElementOverlayDestroyed=function(o){if(this._bDestroyPending){return;}var l=o.getSource();var s=l.getAssociation('element');if(s in this._mPendingOverlays){this._removeOverlayFromSyncingBatch(l);delete this._mPendingOverlays[s];return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(l.isSelected()){this.getSelectionManager().remove(l);}this.fireElementOverlayDestroyed({elementOverlay:l});};
k.prototype._onElementDestroyed=function(o){var s=o.getParameter("targetId");this.removeRootElement(s);};
k.prototype._onAggregationOverlayDestroyed=function(){if(!O.hasOverlays()){d.removeOverlayContainer();}};
k.prototype._onElementOverlaySelectionChange=function(o){var l=o.getSource();var s=o.getParameter("selected");if(s){if(this.getSelectionManager().getSelectionMode()===h.Multi){this.getSelectionManager().add(l);}else{this.getSelectionManager().set(l);}if(!j(this.getSelectionManager().get(),l)){l.setSelected(false);}}else{this.getSelectionManager().remove(l);}};
k.prototype._onElementModified=function(o){var p=m({},o.getParameters());var l=o.getSource();p.type=!p.type?o.getId():p.type;switch(p.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(p.value,p.target,p.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(p.target);}}.bind(this),0);break;case"propertyChanged":p.id=o.getSource().getId();delete p.type;delete p.target;if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",p,function(){if(!l.bIsDestroyed){this.fireElementPropertyChanged(arguments[1]);}},this);}else{this.fireElementPropertyChanged(p);}break;}};
k.prototype._onEditableChanged=function(o){var p=m({},o.getParameters());var l=o.getSource();p.id=l.getId();if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",p,function(){if(!l.bIsDestroyed){this.fireElementOverlayEditableChanged(arguments[1]);}},this);}else{this.fireElementOverlayEditableChanged(p);}};
k.prototype._onAddAggregation=function(o,p,s){if(c.isElementValid(o)){var P=O.getOverlay(p);var l=P&&P.getAggregationOverlay(s);if(!l){var n;var q=function(r){var t=r.getParameter('elementOverlay');if(t.getElement().getId()===p.getId()){var l=t.getAggregationOverlay(s);this.detachSynced(n,this);this.detachElementOverlayCreated(q,this);this._addAggregation(o,l);}};n=function(){var P=O.getOverlay(p);var l=P&&P.getAggregationOverlay(s);this.detachSynced(n,this);this.detachElementOverlayCreated(q,this);this._addAggregation(o,l);};this.attachElementOverlayCreated(q,this);this.attachSynced(n,this);}else{return this._addAggregation(o,l);}}};
k.prototype._addAggregation=function(o,p){var l=O.getOverlay(o);if(!l&&p&&p.getElement()){var t=this._oTaskManager.add({type:'createChildOverlay',element:o});this.createOverlay({element:o,root:false,parentMetadata:p.getDesignTimeMetadata().getData()}).then(function(l){var I=p.insertChild(null,l);if(I===true){this._oTaskManager.add({type:"applyStyles",callbackFn:l.applyStyles.bind(l),overlayId:l.getId()},"overlayId");var n=p.indexOfAggregation('children',l);this.attachEventOnce("synced",l,function(){if(!l.bIsDestroyed){this.fireElementOverlayAdded({id:l.getId(),targetIndex:n,targetId:p.getId(),targetAggregation:p.getAggregationName()});}},this);}this._oTaskManager.complete(t);}.bind(this)).catch(function(s,n,v){this._oTaskManager.cancel(t);var q=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new element overlay (elementId='{0}') into aggregation overlay (id='{1}')",s,n));if(!o.bIsDestroyed&&!p.bIsDestroyed){L.error(U.errorToString(q));}}.bind(this,o.getId(),p.getId()));}else{if(l&&!this._isElementInRootElements(l)&&l.isRoot()){l.setIsRoot(false);}if(p){p.insertChild(null,l);}else{L.error("No parentAggregationOverlay exists during addAggregation");return;}l.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(l._mMetadataOriginal,p.getDesignTimeMetadata().getData(),o));this.fireElementOverlayMoved({id:l.getId(),targetIndex:p.indexOfAggregation('children',l),targetId:p.getId(),targetAggregation:p.getAggregationName()});}};
k.prototype._checkIfOverlayShouldBeDestroyed=function(o){var l=O.getOverlay(o);if(!o.bIsDestroyed&&l&&(!this._isElementInRootElements(o)||o.sParentAggregationName==="dependents")){l.destroy();}};
k.prototype._isElementInRootElements=function(o){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(o,r)){F=true;return false;}});return F;};
k.prototype._iterateRootElements=function(s,o){var r=this.getRootElements();r.forEach(function(R){var l=c.getElementInstance(R);s.call(o||this,l);},this);};
k.prototype._getAllElementOverlaysIn=function(o){var l=[];var n=O.getOverlay(o);if(n){e.iterateOverlayElementTree(n,function(C){if(C.getDesignTimeMetadata()){l.push(C);}});}return l;};
k.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty('enabled',v);this.fireEnabledChanged({value:v});}};
k.prototype.getStatus=function(){return this._sStatus;};
return k;});
sap.ui.predefine('sap/ui/dt/DesignTimeMetadata',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/util/includes"],function(q,M,E,D,m,O,i){"use strict";
function e(A,o){if(typeof(A)==="function"){A=A(o);}if(typeof(A)==="string"){return{changeType:A};}return A;}
var a=M.extend("sap.ui.dt.DesignTimeMetadata",{metadata:{library:"sap.ui.dt",properties:{data:{type:"any",defaultValue:{}}}}});
a.prototype.setData=function(d){this.setProperty("data",m({},this.getDefaultData(),d));return this;};
a.prototype.getDefaultData=function(){return{ignore:false,domRef:undefined};};
a.prototype.isIgnored=function(o){var I=this.getData().ignore;if(!I||(I&&typeof I==="function"&&!I(o))){return false;}return true;};
a.prototype.markedAsNotAdaptable=function(){var A=this.getData().actions;return A==="not-adaptable";};
a.prototype.getDomRef=function(){return this.getData().domRef;};
a.prototype.getAssociatedDomRef=function(o,d,A){if(o){var b=E.getDomRef(o);var c=[];c.push(o);if(A){c.push(A);}if(typeof(d)==="function"){var r=d.apply(null,c);return r?q(r):r;}else if(b&&typeof(d)==="string"){return D.getDomRefForCSSSelector(b,d);}}};
a.prototype.getAction=function(A,o,s){var d=this.getData();var b=["actions",A];if(s){b.push(s);}return e(O.get(b,d),o);};
a.prototype.getLibraryText=function(o,k,A){var b=o.getMetadata();return this._lookForLibraryTextInHierarchy(b,k,A);};
a.prototype._lookForLibraryTextInHierarchy=function(o,k,A){var l;var p;var r;l=o.getLibraryName();r=this._getTextFromLibrary(l,k,A);if(!r){p=o.getParent();if(p&&p.getLibraryName){r=this._lookForLibraryTextInHierarchy(p,k,A);}else{r=k;}}return r;};
a.prototype._getTextFromLibrary=function(l,k,A){var L=sap.ui.getCore().getLibraryResourceBundle(l+".designtime");if(L&&L.hasText(k)){return L.getText(k,A);}L=sap.ui.getCore().getLibraryResourceBundle(l);if(L&&L.hasText(k)){return L.getText(k,A);}};
a.prototype.getLabel=function(){var l=this.getData().getLabel;return typeof l==="function"?l.apply(this,arguments):undefined;};
a.prototype.getControllerExtensionTemplate=function(){return this.getData().controllerExtensionTemplate;};
a.prototype.getResponsibleElement=function(o){var d=this.getData();var r=O.get(["actions","getResponsibleElement"],d);if(r){return r(o);}};
a.prototype.isResponsibleActionAvailable=function(A){var d=this.getData();var b=O.get(["actions","actionsFromResponsibleElement"],d);if(b){return i(b,A);}return false;};
return a;});
sap.ui.predefine('sap/ui/dt/DesignTimeStatus',[],function(){"use strict";return{SYNCING:'syncing',SYNCED:'synced'};});
sap.ui.predefine('sap/ui/dt/ElementDesignTimeMetadata',["sap/ui/dt/DesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil"],function(D,A,E){"use strict";
var a=D.extend("sap.ui.dt.ElementDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});
a.prototype.getDefaultData=function(){var d=D.prototype.getDefaultData.apply(this,arguments);d.aggregations={layout:{ignore:true},dependents:{ignore:true},customData:{ignore:true},layoutData:{ignore:true},tooltip:{ignore:true},dragDropConfig:{ignore:true}};return d;};
a.prototype.hasAggregation=function(s){return!!this.getAggregations()[s];};
a.prototype.getAggregation=function(s){return this.getAggregations()[s];};
a.prototype.createAggregationDesignTimeMetadata=function(m){return new A({data:m});};
a.prototype.getAggregations=function(){var m=this.getData().aggregations||{};var b=this.getData().associations||{};Object.keys(b).forEach(function(s){var c=b[s];if(c.aggregationLike){m[s]=c;}});return m;};
a.prototype.getAggregationNamesWithAction=function(s){var m=this.getAggregations();return Object.keys(m).filter(function(b){return m[b].actions&&m[b].actions[s];});};
a.prototype.getActionDataFromAggregations=function(s,e,b,S){var v;var m=this.getAggregations();var c=[];for(var d in m){if(m[d].actions&&m[d].actions[s]){v=m[d].actions[s];if(S){v=v[S];}if(typeof v==="function"){var f=[e];if(b){f=f.concat(b);}v=v.apply(null,f);}if(typeof(v)==="string"){v={changeType:v};}if(v){v.aggregation=d;c.push(v);}}}return c;};
a.prototype._getText=function(e,n){if(typeof n==="function"){return n();}return this.getLibraryText(e,n);};
a.prototype.getAggregationDescription=function(s,e){var c=this.getAggregation(s).childNames;if(typeof c==="function"){c=c(e);}if(c){return{singular:this._getText(e,c.singular),plural:this._getText(e,c.plural)};}};
a.prototype.getName=function(e){var n=this.getData().name;if(typeof n==="function"){n=n(e);}if(n){return{singular:this._getText(e,n.singular),plural:this._getText(e,n.plural)};}};
a.prototype.getToolHooks=function(){return this.getData().tool||{start:function(){},stop:function(){}};};
a.prototype.isAggregationIgnored=function(e,s){var m=this.getAggregations();var o=m[s];var i=(o)?o.ignore:false;if(!i||(i&&typeof i==="function"&&!i(e))){return false;}return true;};
a.prototype.getScrollContainers=function(e){var s=this.getData().scrollContainers||[];s.forEach(function(S){if(typeof S.aggregations==="function"){S.aggregations=S.aggregations.call(null,e);}});return s;};
a.prototype.getLabel=function(e){return D.prototype.getLabel.apply(this,arguments)||E.getLabelForElement(e);};
a.prototype.getStableElements=function(o){var e=o.getElement();var s;var g=this.getData().getStableElements;if(g){s=g(e);}else{s=[e];}if(!s||!Array.isArray(s)){s=[];}return s;};
return a;});
sap.ui.predefine('sap/ui/dt/ElementOverlay',["sap/ui/dt/Overlay","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/restricted/_intersection","sap/base/util/restricted/_max"],function(O,C,M,E,a,D,U,b,q,L,i,m,_,c){"use strict";var S='sapUiDtOverlayScrollContainer';
var d=O.extend("sap.ui.dt.ElementOverlay",{
metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},
constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}
});
d.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(e){var p=e.getParameters();var n=p.name;if(p.type==="propertyChanged"){if(n==="visible"){this.setRelevantOverlays([]);}}else if(n){this.setRelevantOverlays([]);}},this);this._initMutationObserver();this._initControlObserver();}.bind(this));};
d.prototype._onRootChanged=function(e){var r=e.getParameter('value');this._subscribeToMutationObserver(r);};
d.prototype._initMutationObserver=function(){this._subscribeToMutationObserver(this.isRoot());this.attachEvent('isRootChanged',this._onRootChanged,this);};
d.prototype._subscribeToMutationObserver=function(I){var o=O.getMutationObserver();var $=this.getAssociatedDomRef();this._sObservableNodeId=$&&$.get(0)&&$.get(0).id;if(this._sObservableNodeId){o.registerHandler(this._sObservableNodeId,this._domChangedCallback.bind(this),I);}else if(I){L.error('sap.ui.dt.ElementOverlay#_subscribeToMutationObserver: please provide a root control with proper domRef and id to ensure that RTA is working properly');}};
d.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var o=O.getMutationObserver();o.deregisterHandler(this._sObservableNodeId);delete this._sObservableNodeId;}};
d.prototype._initControlObserver=function(){if(this.getElement()instanceof b){this._oObserver=new C({target:this.getElement(),aggregations:this.getAggregationNames()});}else{this._oObserver=new M({target:this.getElement(),aggregations:this.getAggregationNames()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};
d.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};
d.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()});};
d.prototype.render=function(){this.addStyleClass('sapUiDtElementOverlay');return O.prototype.render.apply(this,arguments);};
d.prototype.exit=function(){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};
d.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(e){var o=this.getElement();if(!o||o.bIsDestroyed){throw U.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(e);}.bind(this)).catch(function(e){throw U.propagateError(e,"ElementOverlay#loadDesignTimeMetadata",U.printf("Can't load designtime metadata data for overlay with id='{1}', element id='{2}': {3}",this.getId(),this.getAssociation('element'),U.wrapError(e).message));}.bind(this));};
d.prototype._setPosition=function(t,g,p,f){O.prototype._setPosition.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var e=this.getScrollContainerById(I);if($.length){var o=$.get(0);var h=D.getGeometry(o);this._setSize(e,h);O.prototype._setPosition.call(this,e,h,this.$());this._handleOverflowScroll(h,e,this,f);this._setZIndex(h,e);}else{e.css("display","none");}},this);};
d.prototype._applySizes=function(){return O.prototype._applySizes.apply(this,arguments).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var e=this.getScrollContainerById(I);if($.length){this._sortChildren(e.get(0));}},this);}}.bind(this));};
d.prototype._sortChildren=function(o){var f=function(h,j){var G=D.getGeometry(h);var k=D.getGeometry(j);var p=G&&G.position;var P=k&&k.position;if(p&&P){var B=p.top+G.size.height;var l=P.top+k.size.height;if(p.top<P.top){if(B>=l&&P.left<p.left){return 1;}return-1;}else if(p.top===P.top){if(p.left===P.left){if(G.size.height<k.size.height||G.size.width<k.size.width){return-1;}else if(G.size.height>k.size.height||G.size.width>k.size.width){return 1;}return 0;}else if(p.left<P.left){return-1;}return 1;}else if(B<=l&&P.left>p.left){return-1;}return 1;}return 0;};var e=q(o).find('>:not(.sapUiDtDummyScrollContainer)').toArray();var s=e.slice().sort(f);var g=e.some(function(h,I){return h!==s[I];});if(g){s.forEach(function(h){D.appendChild(o,h);});}};
d.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{L.error('sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?');}}else{L.error('sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy');}}else{L.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};
d.prototype.setDesignTimeMetadata=function(v){var o=this.getDesignTimeMetadata();var e;if(typeof v==="function"){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(v);}else{o.setData(v(m({},o.getData())));return;}}else if(v instanceof E){o=v;}else if(i(v)){e=v;var f;while(f=this._aMetadataEnhancers.shift()){e=f.call(this,e);}o=new E({data:e});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};
d.prototype.getScrollContainers=function(){return this.getDesignTimeMetadata().getScrollContainers(this.getElement());};
d.prototype._renderChildren=function(){var e=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=q("<div></div>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":I});if(s.aggregations){_(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var f=e.indexOf(o.$());o.setScrollContainerId(I);$.append(e[f]);e.splice(f,1);},this);}e.push($);},this);return e;};
d.prototype.getScrollContainerById=function(I){return q(this.getChildrenDomRef()).find('>.'+S+'[data-sap-ui-dt-scrollcontainerindex="'+I+'"]');};
d.prototype.getAssociatedDomRef=function(){var o=this.getDesignTimeMetadata();var v=o.getDomRef();var e=o.getAssociatedDomRef(this.getElement(),v);if(!e){e=a.getDomRef(this.getElement());}if(e){return q(e);}return undefined;};
d.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};
d.prototype.setSelected=function(s){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);this.fireSelectionChange({selected:s});}return this;};
d.prototype.setMovable=function(e){e=!!e;if(this.getMovable()!==e){this.toggleStyleClass("sapUiDtOverlayMovable",e);this.setProperty("movable",e);this.fireMovableChange({movable:e});this.$()[e?'attr':'removeAttr']('draggable',e);}return this;};
d.prototype.setEditable=function(e){e=!!e;if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e});}return this;};
d.prototype.getAggregationNames=function(){var e=this.getElement();var o=this.getDesignTimeMetadata();var A=e.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(o.getAggregations())).filter(function(s,I,f){return(I===f.indexOf(s)&&!o.isAggregationIgnored(e,s));});};
d.prototype._onChildAdded=function(e){var A=e.getSource();if(this.isRendered()&&!A.isRendered()){var t=(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):q(this.getChildrenDomRef()));t.append(A.render());}};
d.prototype.addChild=function(A){A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};
d.prototype._onElementModified=function(e){if(e.getParameters().type==="afterRendering"){this._subscribeToMutationObserver(this.isRoot());this._oScrollbarSynchronizers.forEach(function(s){s.refreshListeners();});}this.fireElementModified(e.getParameters());};
d.prototype._domChangedCallback=function(p){p.targetOverlay=this;if(this.isReady()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.fireApplyStylesRequired(p);delete this._iApplyStylesRequest;}.bind(this));}};
d.prototype._onElementDestroyed=function(e){var s=e.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};
d.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};
d.prototype.getAggregationOverlay=function(A){return this.getChildren().filter(function(o){return o.getAggregationName()===A;}).pop();};
d.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};
d.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};
d.prototype.isSelected=function(){return this.getSelected();};
d.prototype.isSelectable=function(){return this.getSelectable();};
d.prototype.isMovable=function(){return this.getMovable();};
d.prototype.isEditable=function(){return this.getEditable();};
d.prototype._getElementInstanceVisible=function(){var e=this.getElement();if(e){var g=this.getGeometry();return g&&g.visible;}return false;};
d.prototype.getElementVisibility=function(){var e=this.getElement();if(e instanceof sap.ui.core.Control){return e.getVisible();}var o=this.getDesignTimeMetadata();var f=o&&o.getData().isVisible;if(!f){return undefined;}return f(this.getElement());};
d.prototype.isElementVisible=function(){var e=this.getElement();var v=false;var o=this.getDesignTimeMetadata();var f=o.getData();if(o.isIgnored(e)){v=false;}else if(typeof f.isVisible==="function"){v=f.isVisible(e);}else{var g=this.getGeometry(true);if(g){v=g.visible;}else if(e instanceof b){v=!!e.getDomRef()&&e.getVisible();}}return v;};
d.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};
d.prototype.getRelevantContainer=function(f){var o=this.getDesignTimeMetadata();if(o&&o.getData().relevantContainer){return o.getData().relevantContainer;}else if(f){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};
d.prototype._hasSameSize=function(s,t){var e=this.getScrollContainers();var f;if(e.length){f=c(e.map(function(g,I){var G=D.getGeometry(this.getScrollContainerById(I).get(0));return G.size[t];},this));}else{f=this.getGeometry().size[t];}return s.size[t]===f;};
return d;});
sap.ui.predefine('sap/ui/dt/ElementUtil',["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/dt/Util","sap/ui/core/Element","sap/ui/core/Component","sap/base/util/isPlainObject","sap/ui/core/UIArea"],function(q,B,U,E,C,c,d){"use strict";var e={};
e.iterateOverAllPublicAggregations=function(o,f){var a=o.getMetadata().getAllAggregations();var A=Object.keys(a);A.forEach(function(s){var b=a[s];var v=this.getAggregation(o,s);f(b,v);},this);};
e.getElementInstance=function(v){if(typeof v==="string"){var o=sap.ui.getCore().byId(v);return o||C.get(v);}return v;};
e.hasAncestor=function(o,a){a=this.fixComponentContainerElement(a);var f;while(o&&o!==a){f=this.fixComponentParent(o);if(o===f){o=o.getParent();}else{o=f;}}return!!o;};
e.getClosestElementForNode=function(n){var $=q(n).closest("[data-sap-ui]");return $.length?sap.ui.getCore().byId($.attr("data-sap-ui")):undefined;};
e.fixComponentParent=function(o){if(B.isA(o,"sap.ui.core.UIComponent")){var a=o.oContainer;if(a){return a.getParent();}}else{return o;}};
e.fixComponentContainerElement=function(o){if(B.isA(o,"sap.ui.core.ComponentContainer")){if(!o.getComponentInstance()){return undefined;}return o.getComponentInstance().getRootControl();}return o;};
e.getDomRef=function(o){if(o){var D;if(o.getDomRef){D=o.getDomRef();}if(!D&&o.getRenderedDomRef){D=o.getRenderedDomRef();}return D;}};
e.findAllSiblingsInContainer=function(o,f){var p=o&&o.getParent();if(!p){return[];}if(p!==f){var P=e.findAllSiblingsInContainer(p,f);return P.map(function(p){return e.getAggregation(p,o.sParentAggregationName);}).reduce(function(a,b){return a.concat(b);},[]);}return e.getAggregation(p,o.sParentAggregationName);};
e.getAggregationAccessors=function(o,a){var m=o.getMetadata();m.getJSONKeys();var A=m.getAggregation(a);if(A){var g=A._sGetter;if(A.altTypes&&A.altTypes.length&&o[A._sGetter+"Control"]){g=A._sGetter+"Control";}return{get:g,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}return{};};
e.getAggregation=function(o,a){var v;var g=this.getAggregationAccessors(o,a).get;if(g){v=o[g]();}else{v=o.getAggregation(a);}v=v&&v.splice?v:(v?[v]:[]);return v;};
e.getIndexInAggregation=function(o,p,a){return this.getAggregation(p,a).indexOf(o);};
e.addAggregation=function(p,a,o){if(this.hasAncestor(p,o)){throw new Error("Trying to add an element to itself or its successors");}var A=this.getAggregationAccessors(p,a).add;if(A){p[A](o);}else{p.addAggregation(a,o);}};
e.removeAggregation=function(p,a,o,s){var A=this.getAggregationAccessors(p,a).remove;if(A){p[A](o,s);}else{p.removeAggregation(a,o,s);}};
e.insertAggregation=function(p,a,o,i){if(this.hasAncestor(p,o)){throw new Error("Trying to add an element to itself or its successors");}if(this.getIndexInAggregation(o,p,a)!==-1){o.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(p,a,o,true);}finally{delete o.__bSapUiDtSupressParentChangeEvent;}}var A=this.getAggregationAccessors(p,a).insert;if(A){p[A](o,i);}else{p.insertAggregation(a,o,i);}};
e.isValidForAggregation=function(p,a,o){var A=p.getMetadata().getAggregation(a);if(this.hasAncestor(p,o)){return false;}if(A){var t=A.type;if(A.multiple===false&&this.getAggregation(p,a)&&this.getAggregation(p,a).length>0){return false;}return B.isA(o,t)||this.hasInterface(o,t);}};
e.getAssociationAccessors=function(o,a){var m=o.getMetadata();m.getJSONKeys();var A=m.getAssociation(a);if(A){return{get:A._sGetter,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}return{};};
e.getAssociation=function(o,a){var v;var g=this.getAssociationAccessors(o,a).get;if(g){v=o[g]();}return v;};
e.getIndexInAssociation=function(o,p,a){return this.getAssociationInstances(p,a).indexOf(o);};
e.getAssociationInstances=function(o,a){var v=U.castArray(this.getAssociation(o,a));return v.map(function(i){return this.getElementInstance(i);},this);};
e.hasInterface=function(o,i){var I=o.getMetadata().getInterfaces();return I.indexOf(i)!==-1;};
e.isElementInTemplate=function(o){var l=e.getAggregationInformation(o);if(l.templateId){var t=e.extractTemplateId(l);if(!t){return false;}}return true;};
e.isElementValid=function(o){var v=((o instanceof E||o instanceof C)&&!o.bIsDestroyed&&e.isElementInTemplate(o));return v;};
e.getParent=function(o){return B.isA(o,'sap.ui.core.Component')?o.oContainer:o.getParent();};
e.getLabelForElement=function(o,f){if(!e.isElementValid(o)){throw U.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt");}if(typeof f==="function"){return f(o);}function a(o){var F=(typeof o.getText==="function"&&o.getText()||typeof o.getLabelText==="function"&&o.getLabelText()||typeof o.getLabel==="function"&&o.getLabel()||typeof o.getTitle==="function"&&o.getTitle()||typeof o.getHeading==="function"&&o.getHeading());if(e.isElementValid(F)){return a(F);}return F;}var v=a(o);return typeof v!=="string"?o.getId():v;};
e.extractTemplateId=function(b){if(c(b)&&b.templateId){if(b.stack.length>1){var r;var a=sap.ui.getCore().byId(b.templateId);var A;var I;for(var i=b.stack.length-2;i>=0;i--){A=b.stack[i].aggregation;I=b.stack[i].index;r=e.getAggregation(a,A)[I];if(!r){return undefined;}a=r;}return a.getId();}else if(b.stack.length===1){return b.templateId;}}else{return undefined;}};
e.getAggregationInformation=function(o){var s=[];return this._evaluateBinding(o,s);};
e._evaluateBinding=function(o,s){var a;var i;var p=o.getParent();if(p){a=o.sParentAggregationName;i=e.getAggregation(p,a).indexOf(o);}else{i=-1;}s.push({element:o.getId(),type:o.getMetadata().getName(),aggregation:a,index:i});if(a&&p.getBinding(a)){var b=p.getBindingInfo(a);var t=b&&b.template;return{elementId:p.getId(),aggregation:a,templateId:t?t.getId():undefined,stack:s};}return!p||p instanceof d?{elementId:undefined,aggregation:undefined,templateId:undefined,stack:s}:(this._evaluateBinding(p,s));};
e.adjustIndexForMove=function(s,t,S,T){if(s===t&&S<T&&S>-1){return T-1;}return T;};
return e;},true);
sap.ui.predefine('sap/ui/dt/Overlay',["sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dt/MutationObserver","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/ui/dt/ScrollbarSynchronizer","sap/ui/dt/Util","sap/base/Log","sap/ui/dt/util/ZIndexManager"],function(q,E,M,a,O,D,S,U,L,Z){"use strict";var b="overlay-container";var o;var m;
var c=E.extend("sap.ui.dt.Overlay",{
metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.base.ManagedObject"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}},beforeGeometryChanged:{},applyStylesRequired:{parameters:{type:{type:"string"},targetOverlay:{type:"sap.ui.dt.ElementOverlay"}}}}},
constructor:function(){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new Map();this._aBindParameters=[];E.apply(this,arguments);if(!this.getElement()){throw U.createError("Overlay#constructor",U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(arguments[0].element)));}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:U.createError("Overlay#asyncInit","ElementOverlay is destroyed during initialization ('"+this.getId()+"')")});}else{this._bInit=true;this.fireInit();}}.bind(this)).catch(function(e){var d=U.propagateError(e,"Overlay#asyncInit",U.printf("Can't initialize overlay (id='{0}') properly. Original error: {1}",this.getId(),U.wrapError(e).message));this.fireInitFailed({error:d});}.bind(this));this.attachEventOnce('afterRendering',function(e){var d=q(e.getParameter('domRef'));this._aBindParameters.forEach(function(B){d.on(B.sEventType,B.fnProxy);});},this);},
_bInit:false,
_bRendered:false,
_$DomRef:null,
_aStyleClasses:['sapUiDtOverlay'],
_bShouldBeDestroyed:false,
_aBindParameters:null
});
c.getOverlayContainer=function(){if(!o){o=q("<div></div>").attr('id',b).appendTo("body");}return o;};
c.removeOverlayContainer=function(){if(o){o.remove();}o=undefined;};
c.getMutationObserver=function(){if(!m){m=new M();}return m;};
c.destroyMutationObserver=function(){if(m){m.destroy();m=null;}};
c.prototype.asyncInit=function(){return Promise.resolve();};
c.prototype._getAttributes=function(){return{id:this.getId(),"data-sap-ui":this.getId(),"class":this._aStyleClasses.join(" "),tabindex:this.isFocusable()?0:null};};
c.prototype._renderChildren=function(){return this.getChildren().map(function(C){return C.isRendered()?C.$():C.render();});};
c.prototype.render=function(s){if(this.isRendered()){return this.getDomRef();}this._$DomRef=q('<div></div>').attr(this._getAttributes());this._$Children=q('<div></div>').attr({"class":"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!s){this.fireAfterRendering({domRef:this._$DomRef.get(0)});}return this._$DomRef;};
c.prototype.isInit=function(){return this._bInit;};
c.prototype.isRendered=function(){return this._bRendered;};
c.prototype.isReady=function(){return this.isInit()&&this.isRendered();};
c.prototype.addStyleClass=function(C){if(!this.hasStyleClass(C)){this._aStyleClasses.push(C);if(this.isReady()){this.$().addClass(C);}}};
c.prototype.hasStyleClass=function(C){return this._aStyleClasses.indexOf(C)!==-1;};
c.prototype.removeStyleClass=function(C){if(this.hasStyleClass(C)){this._aStyleClasses=this._aStyleClasses.filter(function(i){return i!==C;});if(this.isReady()){this.$().removeClass(C);}}};
c.prototype.toggleStyleClass=function(C){this[(this.hasStyleClass(C)?'remove':'add')+'StyleClass'](C);};
c.prototype.setElement=function(e){if(!this.getElement()){this.setAssociation("element",e);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache;}}};
c.prototype.destroy=function(){if(this.bIsDestroyed){L.error('FIXME: Do not destroy overlay twice (overlayId = '+this.getId()+')!');return;}this.fireBeforeDestroy();E.prototype.destroy.apply(this,arguments);};
c.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(s){s.destroy();});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed();};
c.prototype.setDesignTimeMetadata=function(v){if(!this.getElement()){this._designTimeMetadataCache=v;}else{this.setAggregation('designTimeMetadata',v);}};
c.prototype.getDomRef=function(){return this.$().get(0);};
c.prototype.getChildrenDomRef=function(){return this._$Children.get(0);};
c.prototype.$=function(){return this._$DomRef||q();};
c.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented");};
c.prototype.getElementInstance=function(){return this.getElement();};
c.prototype.getElement=function(){return a.getElementInstance(this.getAssociation('element'));};
c.prototype.hasFocus=function(){return document.activeElement===this.getDomRef();};
c.prototype.focus=function(){this.$().trigger("focus");};
c.prototype.setFocusable=function(f){f=!!f;if(this.getFocusable()!==f){this.setProperty("focusable",f);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",f?0:null);}};
c.prototype.isFocusable=function(){return this.getFocusable();};
c.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$();};
c.prototype.applyStyles=function(f){this.fireBeforeGeometryChanged();if(!this.isRendered()||this._bIsBeingDestroyed||this.getShouldBeDestroyed()){return Promise.resolve();}var g=Promise.resolve();if(this.isVisible()){var G=this.getGeometry(true);if(G&&G.visible){this._setSize(this.$(),G);var r=this._getRenderingParent();if(!this.isRoot()){var p=[];this.getParent()._oScrollbarSynchronizers.forEach(function(s){if(s.isSyncing()){p.push(new Promise(function(R){s.attachEventOnce('synced',R);s.attachEventOnce('destroyed',R);}));}});if(p.length){g=Promise.all(p).then(function(){return this._applySizes(G,r,f);}.bind(this));}else{g=this._applySizes(G,r,f);}}else{g=this._applySizes(G,r,f);}}else{this.$().css("display","none");}}else{this.$().css("display","none");}return g.catch(function(e){L.error(U.createError('Overlay#applyStyles','Error occured during applySizes calculation: '+e));}).then(function(){this.fireGeometryChanged();}.bind(this));};
c.prototype._applySizes=function(g,r,f){this._setPosition(this.$(),g,r,f);if(g.domRef){this._setZIndex(g,this.$());}var p=this.getChildren().filter(function(C){return C.isRendered();}).map(function(C){var P={};P.bForceScrollbarSync=f;return new Promise(function(R){C.attachEventOnce('geometryChanged',R);C.fireApplyStylesRequired(P);});});return Promise.all(p);};
c.prototype._setZIndex=function(g,$){var d=g.domRef;var z=D.getZIndex(d);if(U.isInteger(z)){$.css("z-index",z);}else if(this.isRoot()){this._iZIndex=this._iZIndex||Z.getZIndexBelowPopups();$.css("z-index",this._iZIndex);}};
c.prototype._setSize=function(t,g){t.css("display","block");var s=g.size;t.css("width",s.width+"px");t.css("height",s.height+"px");};
c.prototype._setPosition=function(t,g,p){var P=D.getOffsetFromParent(g,p?p.get(0):null);t.css("transform","translate("+P.left+"px, "+P.top+"px)");};
c.prototype.attachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof h==="function"){if(!this._aBindParameters){this._aBindParameters=[];}l=l||this;var p=h.bind(l);this._aBindParameters.push({sEventType:e,fnHandler:h,oListener:l,fnProxy:p});this.$().on(e,p);}}return this;};
c.prototype.detachBrowserEvent=function(e,h,l){if(e&&(typeof(e)==="string")){if(typeof(h)==="function"){l=l||this;if(this._aBindParameters){var $=this.$();var p;for(var i=this._aBindParameters.length-1;i>=0;i--){p=this._aBindParameters[i];if(p.sEventType===e&&p.fnHandler===h&&p.oListener===l){this._aBindParameters.splice(i,1);$.off(e,p.fnProxy);}}}}}return this;};
c.prototype._deleteDummyContainer=function(t,T){var d=t.find(">.sapUiDtDummyScrollContainer");if(d.length){d.remove();this._oScrollbarSynchronizers.get(t.get(0)).destroy();this._oScrollbarSynchronizers.delete(t.get(0));if(T._oScrollbarSynchronizers.size===0&&!T.getChildren().some(function(A){return A._oScrollbarSynchronizers.size>0;})){T.removeStyleClass("sapUiDtOverlayWithScrollBar");T.removeStyleClass("sapUiDtOverlayWithScrollBarVertical");T.removeStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}}};
c.prototype._handleOverflowScroll=function(g,t,T,f){var d=g.domRef;var s=g.size;var e=D.getOverflows(d);t.css("overflow-x",e.overflowX);t.css("overflow-y",e.overflowY);var i=d.scrollHeight;var h=d.scrollWidth;if(i>Math.ceil(s.height)||h>Math.ceil(s.width)){var j=t.find("> .sapUiDtDummyScrollContainer");var k;if(!j.length){j=q("<div></div>",{css:{height:i+"px",width:h+"px"}});j=q("<div class='sapUiDtDummyScrollContainer' style='height: "+i+"px; width: "+h+"px;'></div>");if(T&&D.hasVerticalScrollBar(d)&&T._hasSameSize(g,'height')){T.addStyleClass("sapUiDtOverlayWithScrollBar");T.addStyleClass("sapUiDtOverlayWithScrollBarVertical");}if(T&&D.hasHorizontalScrollBar(d)&&T._hasSameSize(g,'width')){T.addStyleClass("sapUiDtOverlayWithScrollBar");T.addStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}t.append(j);k=new S({synced:this.fireScrollSynced.bind(this)});k.addTarget(d,t.get(0));this._oScrollbarSynchronizers.set(t.get(0),k);}else{j.css({height:i,width:h});k=this._oScrollbarSynchronizers.get(t.get(0));if(!k.hasTarget(d)){k.addTarget(d);}}if(f){k.sync(d,true);}}else{this._deleteDummyContainer(t,T);}};
c.prototype.getGeometry=function(f){if(f||!this._mGeometry){var d=this.getAssociatedDomRef();var C;if(d){var i=this.isRoot();C=q.makeArray(d).map(function($){return D.getGeometry($,i);});}else{C=this.getChildren().map(function(e){return e.getGeometry(true);});}if(C.length){this._mGeometry=C.length>1?O.getGeometry(C):C[0];}else{delete this._mGeometry;}}return this._mGeometry;};
c.prototype.setVisible=function(v){v=!!v;if(this.getVisible()!==v){this.setProperty("visible",v);this.fireVisibleChanged({visible:v});}};
c.prototype.isVisible=function(){return(this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible()));};
c.prototype.setIsRoot=function(v){v=!!v;if(this.getIsRoot()!==v){this.setProperty('isRoot',v);this.fireIsRootChanged({value:v});}};
c.prototype.isRoot=function(){return this.getIsRoot();};
c.prototype.getShouldBeDestroyed=function(){return this._bShouldBeDestroyed;};
return c;});
sap.ui.predefine('sap/ui/dt/OverlayRegistry',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/Util","sap/base/util/isEmptyObject"],function(M,E,U,i){"use strict";var O={};var S='sap.ui.dt.ElementOverlay';var a='sap.ui.dt.AggregationOverlay';var o={};var A={};
O.getOverlay=function(e){var I=(typeof e==="string"?e:E.getElementInstance(e)&&E.getElementInstance(e).getId());return o[I]||A[I];};
O.getOverlays=function(){return U.objectValues(o);};
O.register=function(c){if(!b(c)){var l='sap.ui.dt.OverlayRegistry#register';var e=new Error(l+' / Attempt to register illegal overlay');e.name=l;throw e;}o[c.getId()]=c;if(c.getMetadata().getName()===S){A[c.getAssociation('element')]=c;}};
O.deregister=function(c){if(!b(c)){var l='sap.ui.dt.OverlayRegistry#deregister';var e=new Error(l+' / Attempt to deregister illegal overlay');e.name=l;throw e;}delete o[c.getId()];if(c.getMetadata().getName()===S){delete A[c.getAssociation('element')];}};
O.hasOverlays=function(){return!i(o);};
function b(c){return(c instanceof M&&[S,a].indexOf(c.getMetadata().getName())>-1);}
return O;},true);
sap.ui.predefine('sap/ui/dt/Plugin',["sap/ui/base/ManagedObject","sap/ui/dt/OverlayRegistry"],function(M,O){"use strict";
var P=M.extend("sap.ui.dt.Plugin",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});
P.prototype._bProcessingCounter=0;
P.prototype.init=function(){};
P.prototype.exit=function(){this.setDesignTime(null);};
P.prototype.setDesignTime=function(d){var o=this.getDesignTime();if(o){this._deregisterOverlays(o);}this.setProperty("designTime",d);if(d){this._registerOverlays(d);}return this;};
P.prototype._registerOverlays=function(d){if(this.registerElementOverlay||this.registerAggregationOverlay){var e=d.getElementOverlays();this.setProcessingStatus(true);e.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false);}};
P.prototype._deregisterOverlays=function(d){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var o=d.getElementOverlays();o.forEach(this._callElementOverlayDeregestrationMethods.bind(this));}};
P.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.registerAggregationOverlay.bind(this));}};
P.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e);}this.callAggregationOverlayRegistrationMethods(e);};
P.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e);}if(this.deregisterAggregationOverlay){var a=e.getAggregationOverlays();a.forEach(this.deregisterAggregationOverlay.bind(this));}};
P.prototype._onElementOverlayCreated=function(e){var o=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(o);};
P.prototype.getMenuItems=function(){return[];};
P.prototype.getActionName=function(){};
P.prototype.isBusy=P.prototype.getBusy;
P.prototype.setProcessingStatus=function(p){this._bProcessingCounter=p?this._bProcessingCounter+1:this._bProcessingCounter-1;if((p===true&&this._bProcessingCounter===1)||(p===false&&this._bProcessingCounter===0)){this.fireProcessingStatusChange({processing:p});}};
P.prototype.getAction=function(o){return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getAction(this.getActionName(),o.getElement()):null;};
P.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get();};
P.prototype.getActionText=function(o,a,p){var n=a.name;var e=o.getElement();if(n){if(typeof n==="function"){return n(e);}return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getLibraryText(e,n):"";}return sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText(p);};
P.prototype.isAvailable=function(){return false;};
P.prototype.handler=function(){};
P.prototype.isEnabled=function(){return false;};
P.prototype._getMenuItems=function(e,p){var m=this.enhanceItemWithResponsibleElement({id:p.pluginId,handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:p.rank,icon:p.icon,group:p.group},e);var r=m.responsible||e;var R=r[0];var a=this.getAction(R);if(!a||!this.isAvailable(r)){return[];}m.text=this.getActionText(R,a,p.pluginId);return[m];};
P.prototype.isResponsibleElementActionAvailable=function(e,a){var d=e.getDesignTimeMetadata();if(d){return d.isResponsibleActionAvailable(a||this.getActionName());}return false;};
P.prototype.getResponsibleElementOverlay=function(e){var E=e.getElement();var d=e.getDesignTimeMetadata();if(d){var r=d.getResponsibleElement(E);if(r){try{return O.getOverlay(r);}catch(o){return e;}}}return e;};
P.prototype.enhanceItemWithResponsibleElement=function(m,e,a){var r=[];var A=a||[this.getActionName()];var E=A.some(function(s){if(this.isResponsibleElementActionAvailable(e[0],s)){r=e.map(this.getResponsibleElementOverlay.bind(this));return true;}}.bind(this));return Object.assign(m,E&&{responsible:r});};
return P;});
sap.ui.predefine('sap/ui/dt/ScrollbarSynchronizer',["sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/ui/thirdparty/jquery"],function(M,D,q){"use strict";
var S=M.extend("sap.ui.dt.ScrollbarSynchronizer",{
metadata:{library:"sap.ui.dt",properties:{scrollTop:{type:"float"},scrollLeft:{type:"float"},targets:{type:"any[]",defaultValue:[]}},events:{synced:{},destroyed:{}}},
_bSyncing:false,
constructor:function(){this._scrollEventHandler=this._scrollEventHandler.bind(this);M.apply(this,arguments);}
});
S.prototype.getTargets=function(){return this.getProperty('targets').slice(0);};
S.prototype.setTargets=function(t){var T=Array.isArray(t)?t:[t];this.getTargets().forEach(this.removeTarget.bind(this));this.addTarget.apply(this,T);};
S.prototype.removeTarget=function(d){this._detachScrollEvent(d);this.setProperty('targets',this.getTargets().filter(function(t){return t!==d;}));};
S.prototype.addTarget=function(){var t=Array.prototype.slice.call(arguments);if(!t.length){return;}this._removeDeadNodes();t.forEach(this._attachScrollEvent,this);var n=this.getTargets().concat(t);this.setProperty('targets',n);this.sync(n[0]);};
S.prototype.hasTarget=function(d){return this.getTargets().indexOf(d)>-1;};
S.prototype._removeDeadNodes=function(){this.getTargets().forEach(function(d){if(!document.body.contains(d)){this.removeTarget(d);}},this);};
S.prototype._attachScrollEvent=function(d){q(d).on("scroll",this._scrollEventHandler);};
S.prototype._detachScrollEvent=function(d){q(d).off("scroll",this._scrollEventHandler);};
S.prototype._scrollEventHandler=function(e){this.sync(e.target);};
S.prototype.sync=function(s,f){if(f||this.getScrollTop()!==s.scrollTop||this.getScrollLeft()!==q(s).scrollLeft()){this.setScrollTop(s.scrollTop);this.setScrollLeft(q(s).scrollLeft());if(this._bSyncing){this._abortSync();}this._bSyncing=true;this.animationFrame=window.requestAnimationFrame(function(){this.getTargets().filter(function(d){return s!==d;}).forEach(function(d){D.syncScroll(s,d);});this._bSyncing=false;this.fireSynced();}.bind(this));}};
S.prototype._abortSync=function(){window.cancelAnimationFrame(this.animationFrame);this._bSyncing=false;};
S.prototype.destroy=function(){this.getTargets().forEach(function(d){this.removeTarget(d);},this);this._abortSync();this.fireDestroyed();M.prototype.destroy.apply(this,arguments);};
S.prototype.isSyncing=function(){return this._bSyncing;};
S.prototype.refreshListeners=function(){this.getTargets().forEach(function(d){this._detachScrollEvent(d);this._attachScrollEvent(d);},this);};
return S;});
sap.ui.predefine('sap/ui/dt/SelectionManager',["sap/ui/base/ManagedObject","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/dt/SelectionMode","sap/ui/dt/ElementOverlay","sap/base/util/includes"],function(M,O,U,S,E,i){"use strict";
var a=M.extend("sap.ui.dt.SelectionManager",{metadata:{events:{change:{parameters:{selection:{type:"sap.ui.dt.ElementOverlay[]"}}}}}});
function g(o){return U.castArray(o).map(function(b){if(b instanceof E){return b;}var e=O.getOverlay(b);if(e){return e;}}).filter(function(e,I,b){return e&&b.indexOf(e)===I;});}
function s(e){return e.every(function(o){return o.isSelectable();});}
a.prototype.init=function(){this._aSelection=[];this._aValidators=[];this.addValidator(s);};
a.prototype.exit=function(){delete this._aSelection;delete this._aValidators;};
a.prototype.getSelectionMode=function(){return this._aSelection.length>1?S.Multi:S.Single;};
a.prototype.get=function(){return this._aSelection.slice();};
a.prototype.set=function(o){var e=g(o);var r=false;if(this._validate(e)){var b=this.get().filter(function(c){return!i(e,c);});r=this._remove(b)||r;r=this._add(e)||r;if(r){this.fireChange({selection:this.get()});}}return r;};
a.prototype._validate=function(e){return this.getValidators().every(function(v){return v(e);});};
a.prototype._add=function(e){var c=this.get();e=e.filter(function(o){return!i(c,o);});if(e.length){var n=c.concat(e);if(this._validate(n)){this._aSelection=n;e.forEach(function(o){o.setSelected(true);},this);return true;}}return false;};
a.prototype.add=function(o){if(this._add(g(o))){this.fireChange({selection:this.get()});return true;}return false;};
a.prototype._remove=function(e){var c=this.get();var n=c.filter(function(o){return!i(e,o);});if(n.length!==c.length){this._aSelection=n;e.forEach(function(o){o.setSelected(false);});return true;}return false;};
a.prototype.remove=function(o){if(this._remove(g(o))){this.fireChange({selection:this.get()});return true;}return false;};
a.prototype.reset=function(){return this.remove(this.get());};
a.prototype.addValidator=function(v){if(typeof v==="function"&&!i(this._aValidators,v)){this._aValidators=this._aValidators.concat(v);}};
a.prototype.removeValidator=function(v){this._aValidators=this._aValidators.filter(function(c){return v!==c;});};
a.prototype.getValidators=function(){return this._aValidators.slice();};
return a;});
sap.ui.predefine('sap/ui/dt/SelectionMode',function(){"use strict";return{Multi:"Multi",Single:"Single"};},true);
sap.ui.predefine('sap/ui/dt/TaskManager',["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(M,i){"use strict";
var T=M.extend("sap.ui.dt.TaskManager",{
metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},
constructor:function(){M.apply(this,arguments);this._mQueuedTasks={};this._mPendingTasks={};},
_iNextId:0,
_iTaskCounter:0
});
T.prototype._validateTask=function(t){if(!i(t)||!t.type||typeof t.type!=="string"){throw new Error("Invalid task specified");}};
T.prototype._removeOutdatedTasks=function(t,d){if(d){var D;if(typeof d==="string"){D=function(t){return t[d];};}else if(typeof d==="function"){D=d;}else{throw new Error("Validator needs to be a function or a string");}var a=this._mQueuedTasks[t.type];var n=D(t);if(a&&n){this._mQueuedTasks[t.type]=a.filter(function(o){if(D(o)===n){this._iTaskCounter--;return false;}return true;}.bind(this));}}};
T.prototype._addTask=function(t){var a=this._iNextId++;this._mQueuedTasks[t.type]=this._mQueuedTasks[t.type]||[];this._mQueuedTasks[t.type].push(Object.assign({},t,{id:a}));this._iTaskCounter++;if(!this.getSuppressEvents()){this.fireAdd({taskId:a});}return a;};
T.prototype.add=function(t,d){this._validateTask(t);this._removeOutdatedTasks(t,d);return this._addTask(t);};
T.prototype._removeTaskById=function(t,l){Object.keys(this[l]).forEach(function(s){this[l][s]=this[l][s].filter(function(m){if(m.id===t){this._iTaskCounter--;return false;}return true;}.bind(this));},this);};
T.prototype.complete=function(t){this._removeTaskById(t,"_mQueuedTasks");this._removeTaskById(t,"_mPendingTasks");if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]});}};
T.prototype.completeBy=function(t){this._validateTask(t);var c=[];var _=function(a){return(a||[]).filter(function(l){var C=Object.keys(t).every(function(k){return l[k]&&l[k]===t[k];});if(C){this._iTaskCounter--;c.push(l.id);return false;}return true;}.bind(this));}.bind(this);this._mQueuedTasks[t.type]=_(this._mQueuedTasks[t.type]);this._mPendingTasks[t.type]=_(this._mPendingTasks[t.type]);if(!this.getSuppressEvents()){this.fireComplete({taskId:c});}};
T.prototype.cancel=function(t){this.complete(t);};
T.prototype.isEmpty=function(){return this._iTaskCounter===0;};
T.prototype.count=function(t){return this.getList(t).length;};
T.prototype._markAsPending=function(t,a){this._mPendingTasks[t]=(this._mPendingTasks[t]||[]).concat(a);this._mQueuedTasks[t]=[];};
T.prototype._getTypedList=function(t,m){var a=[];if(this._mQueuedTasks[t]){a=this._mQueuedTasks[t].slice(0);}if(m){this._markAsPending(t,a);}else if(this._mPendingTasks[t]){a=a.concat(this._mQueuedTasks[t].slice(0));}return a;};
T.prototype._getAllTasks=function(m){var a=[];a=Object.keys(this._mQueuedTasks).reduce(function(r,_){r=r.concat(this._mQueuedTasks[_]);if(m){this._markAsPending(_,this._mQueuedTasks[_]);}return r;}.bind(this),[]);if(!m){a=a.concat(Object.keys(this._mPendingTasks).reduce(function(r,_){return r.concat(this._mPendingTasks[_]);}.bind(this),[]));}return a;};
T.prototype.getList=function(t){if(t){return this._getTypedList(t,false);}return this._getAllTasks(false);};
T.prototype.getQueuedTasks=function(t){if(t){return this._getTypedList(t,true);}return this._getAllTasks(true);};
T.prototype.destroy=function(){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id);},this);M.prototype.destroy.apply(this,arguments);};
return T;});
sap.ui.predefine('sap/ui/dt/TaskRunner',["sap/ui/dt/TaskManager","sap/ui/dt/Util","sap/base/Log"],function(T,D,B){"use strict";var a=function(p){if(!p||!p.taskManager||!(p.taskManager instanceof T)){throw D.createError("TaskRunner#constructor","sap.ui.dt.TaskRunner: TaskManager required");}this._oTaskManager=p.taskManager;this._sInitialTaskType=p.taskType;this._sObservedTaskType=p.taskType;this._iRequestId=undefined;this.bIsStopped=true;this._oTaskPromise=Promise.resolve();};
a.prototype._shouldObserveBreak=function(){if(this.bIsStopped||!this._oTaskManager||this._oTaskManager.bIsDestroyed){this.bIsStopped=true;return true;}return false;};
a.prototype._observe=function(e){this._oTaskPromise=this._oTaskPromise.then(function(){if(this._shouldObserveBreak()){return this.stop();}this._runTasksFromManager(e);}.bind(this));};
a.prototype._runTasksFromManager=function(){var t=this._oTaskManager.getQueuedTasks(this._sObservedTaskType);if(t.length){this._runTasks(t);}};
a.prototype._runTasks=function(t){var b=[];for(var i=0,n=t.length;i<n;i++){if(t[i].callbackFn){try{b.push(t[i].callbackFn().then(this._oTaskManager.complete.bind(this._oTaskManager,t[i].id)));}catch(e){B.error(D.errorToString(e));}}}};
a.prototype.run=function(t){this._sObservedTaskType=t||this._sInitialTaskType;this.bIsStopped=false;this._oTaskManager.attachAdd(this._observe,this);this._observe();};
a.prototype.stop=function(){this.bIsStopped=true;this._oTaskManager.detachAdd(this._observe,this);};
return a;});
sap.ui.predefine('sap/ui/dt/Util',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/ManagedObject","sap/base/util/includes","sap/base/util/isPlainObject","sap/ui/dt/DesignTimeStatus"],function(q,D,M,i,a,b){"use strict";var U={};var S="sap.ui.dt";
function c(n){return!isNaN(parseFloat(n))&&isFinite(n);}
U.wrapError=function(e){var E=e instanceof Error&&e||new Error();if(typeof e==="string"){E.message=e;}return E;};
U.isForeignError=function(e,l){if(e instanceof Error){return e.name.indexOf(l||S)===-1;}throw U.createError("Util#isForeignError","Wrong parameter specified");};
U.createError=function(l,m,L){var e=new Error();var s=(L||S)+(l?"."+l:"");e.name="Error in "+s;e.message=m;return e;};
U.errorToString=function(e){if(typeof e==="string"){return e;}else if(e instanceof Error){var E=e.toString();if(e.stack){E+="\n"+e.stack.replace(E,"").trim();}return E;}throw U.createError("Util#errorToString","Wrong parameter specified");};
U.propagateError=function(e,l,m,L){var E=U.wrapError(e);if(U.isForeignError(E,L)){var s=(L||S)+"."+l;var o=[E.name,E.message].join(" - ");E.name="Error in "+s;E.message=U.printf("{0}. Original error: {1}",m,o||"¯\\_(ツ)_/¯");}return E;};
U.getObjectType=function(o){return((o instanceof M&&U.printf('{0} (id = "{1}")',o.getMetadata().getName(),o.getId()))||typeof o);};
U.printf=function(s){var A=Array.prototype.slice.call(arguments,1);return s.replace(/{(\d+)}/g,function(m,I){return typeof A[I]!=="undefined"?A[I]:m;});};
U.objectValues=function(o){return q.map(o,function(v){return v;});};
U.isInteger=function(v){return c(v)&&Math.ceil(v)===v;};
U.castArray=function(v){var r=[];if(v){if(!Array.isArray(v)){r.push(v);}else{r=v;}}return r;};
U.wrapIntoPromise=function(h){if(typeof h!=="function"){throw U.createError("Util#wrapIntoPromise",U.printf("Invalid argument specified. Function is expected, but '{0}' is given",typeof h),"sap.ui.dt");}return function(){var A=Array.prototype.slice.call(arguments);return Promise.resolve().then(function(){return h.apply(null,A);});};};
U.isWebkit=function(){return D.browser.webkit&&(D.browser.safari||D.browser.chrome&&D.browser.mobile);};
U.waitForSynced=function(d,o){return function(){o=o||function(){};var A=arguments;return new Promise(function(r,R){if(d.getStatus()===b.SYNCING){d.attachEventOnce("synced",function(){r(o.apply(null,A));});d.attachEventOnce("syncFailed",R);}else{r(o.apply(null,A));}});};};
return U;},true);
sap.ui.predefine('sap/ui/dt/enablement/ElementEnablementTest',["sap/ui/thirdparty/jquery","sap/ui/dt/enablement/Test","sap/ui/dt/DesignTime","sap/ui/dt/enablement/Util","sap/base/util/ObjectPath","sap/ui/dt/ElementOverlay","sap/ui/qunit/utils/waitForThemeApplied","sap/ui/thirdparty/sinon-4"],function(q,T,D,E,O,a,w,s){"use strict";
var b=T.extend("sap.ui.dt.test.ElementEnablementTest",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"},create:{type:"any"},timeout:{type:"int",defaultValue:0},groupPostfix:{type:"string"}}}});
var S=0;var m;
b.prototype.init=function(){this._aAggregatedTestResult=null;this._aAggregatedInfoResult=null;this._sAggregation=null;this._$TestAreaDomRef=null;if(S===0){m=s.stub(a.prototype,"_subscribeToMutationObserver");}S++;};
b.prototype.exit=function(){if(this._oDesignTime){this._oDesignTime.destroy();}S--;if(S===0){m.restore();}window.clearTimeout(this._iTimeout);this._oElement.destroy();if(this._$TestAreaDomRef){this._$TestAreaDomRef.remove();delete this._$TestAreaDomRef;}};
b.prototype.run=function(){return this._setup().then(function(){this._mResult=this.createSuite("Element Enablement Test");var e=this.addGroup(this._mResult.children,this.getType(),"Given that a DesignTime is created for "+this.getType());this._testAggregations(e.children);this._mResult=this.aggregate(this._mResult);return this._mResult;}.bind(this));};
b.prototype._createElement=function(){var t=this.getType();var c=this.getCreate();var d=O.get(t||"");var e;if(c){e=c();}else{e=new d();}if(e.addStyleClass){e.addStyleClass("minSize");}return e;};
b.prototype._getTestArea=function(){if(!this._$TestAreaDomRef){this._$TestAreaDomRef=q("<div id='"+this.getId()+"--testArea"+"'></div>").css({height:"500px",width:"1000px"}).appendTo("body");}return this._$TestAreaDomRef;};
b.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNoRenderer=false;this._bErrorDuringRendering=false;return new Promise(function(r){w().then(function(){this._oElement=this._createElement();try{this._oElement.getRenderer();}catch(e){this._bNoRenderer=true;}if(!this._bNoRenderer){try{this._oElement.placeAt(this._getTestArea().get(0));sap.ui.getCore().applyChanges();}catch(e){this._bErrorDuringRendering=true;}if(!this._bErrorDuringRendering){this._oDesignTime=new D({rootElements:[this._oElement]});this._oDesignTime.attachEventOnce("synced",function(){if(this.getTimeout()){this._iTimeout=window.setTimeout(function(){r();},this.getTimeout());}else{r();}},this);}else{r();}}else{r();}}.bind(this));}.bind(this));};
b.prototype._testAggregations=function(t){var A=this.addGroup(t,"Aggregations","Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",this.getGroupPostfix());if(this._bNoRenderer){this.addTest(A.children,true,"Control has no renderer","Control has no renderer, not supported by the element test (requires a special element test)",T.STATUS.UNKNOWN);}else if(this._bErrorDuringRendering){this.addTest(A.children,true,"Error during rendering","Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",T.STATUS.ERROR);}else{var c=E.getAggregationsInfo(this._oElement);for(var d in c){var e=c[d];var f=this.addGroup(A.children,d,(e.ignored?"Aggregation ignored":"Aggregation tests"));if(!e.ignored){this.addTest(f.children,e.overlayVisible,"Overlay Visible","Overlay domRef is visible in DOM");if(e.domRefDeclared){this.addTest(f.children,e.domRefDeclared,"Dom Ref Declared","DomRef is declared in design time metadata");this.addTest(f.children,e.domRefFound,"Dom Ref Found","Declared DomRef is found in DOM");this.addTest(f.children,e.domRefVisible,"Dom Ref Visible","Declared DomRef is visible");}else if(e.overlayVisible){this.addTest(f.children,e.overlayGeometryCalculatedByChildren,"Overlay Geometry calculated by children","Control might work based on DT Heuristic, but safer with domRefDeclared",T.STATUS.PARTIAL_SUPPORTED);}else{this.addTest(f.children,false,"Overlay Dom Ref","Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",T.STATUS.PARTIAL_SUPPORTED);}if(e.overlayTooSmall){this.addTest(f.children,false,"Overlay too small","Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",T.STATUS.PARTIAL_SUPPORTED);}}}}};
return b;});
sap.ui.predefine('sap/ui/dt/enablement/Test',["sap/ui/base/ManagedObject"],function(M){"use strict";
var T=M.extend("sap.ui.dt.test.Test",{metadata:{"abstract":true}});
T.STATUS={SUPPORTED:{key:"SUPPORTED",text:"supported",value:3},PARTIAL_SUPPORTED:{key:"PARTIAL_SUPPORTED",text:"partial supported",value:2},NOT_SUPPORTED:{key:"NOT_SUPPORTED",text:"not supported",value:1},ERROR:{key:"ERROR",text:"error",value:0},UNKNOWN:{key:"UNKNOWN",text:"unknown",value:0}};T.TYPE={TEST:"Test",GROUP:"Group",SUITE:"Suite"};
T.prototype.createSuite=function(n,m){return this.add(null,false,n,m,null,T.TYPE.SUITE);};
T.prototype.addGroup=function(p,n,m,N){return this.add(p,true,n+(N?(" ("+N+")"):""),m,null,T.TYPE.GROUP);};
T.prototype.addTest=function(p,r,n,m,s){return this.add(p,r,n,m,s,T.TYPE.TEST);};
T.prototype.add=function(p,r,n,m,s,t){if(!s){if(r){s=T.STATUS.SUPPORTED;}else{s=T.STATUS.NOT_SUPPORTED;}}var e={name:n,message:m,result:r,status:s,type:t,statistic:{},children:[]};if(p){p.push(e);}return e;};
T.prototype.run=function(){throw new Error("Abstract method");};
T.prototype.aggregate=function(r){if(r.type!==T.TYPE.TEST&&r.children.length>0){var c=r.children;var m=c.map(function(e){var C=this.aggregate(e);return{result:C.result,status:C.status};},this);if(m.length===1){m.push(m[0]);}var R=m.reduce(function(p,C){return{result:this._getResult(p,C),status:this._getStatus(p,C),statistic:this._getStatistic(p,C)};}.bind(this));r.result=R.result;r.status=R.status;r.statistic=R.statistic;}return r;};
T.prototype._getResult=function(p,c){return!p.result?false:c.result;};
T.prototype._getStatus=function(p,c){return p.status.value<c.status.value?p.status:c.status;};
T.prototype._getStatistic=function(p,c){var s=this._getStatisticObjectForEntry(p);if(p!==c){s[c.status.key]++;}return s;};
T.prototype._getStatisticObjectForEntry=function(e){var s={};if(!e.statistic){for(var S in T.STATUS){s[S]=0;}s[e.status.key]++;}else{s=e.statistic;}return s;};
return T;});
sap.ui.predefine('sap/ui/dt/enablement/Util',["sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayRegistry"],function(E,D,O){"use strict";var M=5;var a={};
a.getInfo=function(e){var m=e.getMetadata();var o=O.getOverlay(e);return{metadata:m,overlay:o};};
a.getAggregationInfo=function(e,A){var m={ignored:true,domRefDeclared:false,domRefFound:false,domRefVisible:false,overlayTooSmall:false,overlayGeometryCalculatedByChildren:false,overlayVisible:false};var d;var b=this.getInfo(e);var o=b.overlay.getAggregationOverlay(A);if(o){d=o.getDesignTimeMetadata();}if(d&&!d.isIgnored(e)){m.ignored=false;m.domRefDeclared=!!d.getDomRef();var $=o.getAssociatedDomRef();if($){m.domRefFound=true;m.domRefVisible=D.isVisible($.get(0));}var g=o.getGeometry();if(g){var s=g.size;m.overlayTooSmall=(s.width<=M||s.height<=M);m.overlayGeometryCalculatedByChildren=!g.domRef;m.overlayVisible=g.visible;}}return m;};
a.getAggregationsInfo=function(e){var A={};E.iterateOverAllPublicAggregations(e,function(o){A[o.name]=this.getAggregationInfo(e,o.name);}.bind(this));return A;};
return a;},true);
sap.ui.predefine('sap/ui/dt/enablement/elementDesigntimeTest',["sap/ui/dt/enablement/report/QUnitReport","sap/ui/dt/enablement/ElementEnablementTest"],function(Q,E){"use strict";var e=function(p){var o=new E(p);return o.run().then(function(d){var q=new Q({data:d});o.destroy();q.destroy();});};return e;});
sap.ui.predefine('sap/ui/dt/enablement/libraryTest',["sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","jquery.sap.global","jquery.sap.sjax"],function(R,J,q){"use strict";var d=[];var m=[];var b={};var l;
function h(k,B){return B.hasText(k)||B.getText(k,[],true)!==undefined;}
var L=function(t){return new Promise(function(r){sap.ui.getCore().loadLibraries([t]).then(function(){var c=sap.ui.getCore().getLoadedLibraries()[t];var E=c.controls.concat(c.elements);l=t;sap.ui.require(E.map(function(s){return q.sap.getResourceName(s,"");}),function(){var f=sap.ui.getCore().getLoadedLibraries();try{var g=new R({bundleUrl:sap.ui.resource(t,"messagebundle.properties"),bundleLocale:"en"});var D=new R({bundleUrl:sap.ui.resource(t+".designtime","messagebundle.properties"),bundleLocale:"en"});b.runtime=g.getResourceBundle();b.designtime=D.getResourceBundle();Object.keys(f).forEach(function(s){if(t!==s){g.enhance({bundleUrl:sap.ui.resource(s,"messagebundle.properties"),bundleLocale:"en"});D.enhance({bundleUrl:sap.ui.resource(s+".designtime","messagebundle.properties"),bundleLocale:"en"});}});}catch(e){}var j=[];var C=[];for(var i=0;i<arguments.length;i++){if(arguments[i].getMetadata()._oDesignTime){j.push(arguments[i].getMetadata().loadDesignTime());C.push(arguments[i].getMetadata());}}Promise.all(j).then(function(E){var i=0;d=E;m=d.map(function(o){var k=new J(o);k._oControlMetadata=C[i];i++;return k;});a();r();});});});});};L.version=2.0;var M={"/":{optional:false,check:function(c,o,C){c.strictEqual(typeof o,"object",C+" is an object");}},"/designtimeModule":{optional:false,check:function(c,s,C){c.strictEqual(typeof s,"string",C+" defines /designtimeModule : "+s);}},"/actions":{optional:true,check:function(c,A,C){Object.keys(A).forEach(function(s){if(A[s].changeType){c.strictEqual(typeof A[s].changeType,"string",C+" defines "+s+" with changetype:"+A[s].changeType);}else if(typeof A[s]==="string"){c.strictEqual(typeof A[s],"string",C+" defines "+s+" as string");}else{c.strictEqual(typeof A[s],"function",C+" defines "+s+" as function");}});}},"/name":{optional:true,check:function(c,e,C){if(typeof e==="string"&&e.indexOf("{")===0&&e.indexOf("}")===e.length-1){return true;}var k=["singular","plural"];k.forEach(function(K){if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines mandatory entry /name/"+K);}else{c.strictEqual(typeof e[K],"string",C+" defines mandatory entry /name/"+K);}});k.forEach(function(K){var D=false;if(typeof e[K]==="function"){c.strictEqual(typeof e[K],"function",C+" defines function for translation of entry /name/"+K);c.strictEqual(typeof e[K](),"string","Assuming that "+K+" with "+e[K].toString()+" returns a translation at runtime");return;}if(e[K].toUpperCase()!==e[K]){c.ok(true,"Assuming that "+K+" with "+e[K]+" needs currently no translation");return;}if(b.designtime){D=h(e[K],b.designtime);c.strictEqual(D,true,e[K]+" found in designtime message bundle");}if(b.runtime){if(D){c.strictEqual(h(e[K],b.runtime),false,e[K]+" found in runtime message bundle and designtime message bundle, please delete the entry from the runtime message bundle (messagebundle.properties + messagebundle_en.properties)");}else{c.strictEqual(h(e[K],b.runtime),true,e[K]+" found in runtime message bundle only, consider to move this text to the designtime message bundle");}}});}},"/palette":{optional:true,check:function(c,e,C){var v=["ACTION","DISPLAY","LAYOUT","LIST","INPUT","CONTAINER","CHART","TILE","DIALOG"];c.strictEqual(typeof e,"object",C+" defines optional entry /palette/");c.strictEqual(v.indexOf(e.group)>-1,true,"palette entry defines valid group "+e.group);if(e.icons){Object.keys(e.icons).forEach(function(k){var i=e.icons[k];c.strictEqual(typeof i,"string","palette/icons/"+k+" entry defines icon path "+i);var r=q.sap.sjax({url:sap.ui.require.toUrl(i)+""});c.ok(r.status==="success","File "+i+" does exist. Check entry palette/icons/"+k);if(i.indexOf(".svg")===i.length-4){c.ok(r.data.documentElement&&r.data.documentElement.tagName==="svg","File "+i+" starts with a svg node");}});}}},"/templates":{optional:true,check:function(c,e){if(e.create){var C=e.create;c.strictEqual(typeof C,"string","templates/create entry defines fragment path to "+C);var D=q.sap.sjax({url:sap.ui.require.toUrl(C)+""});c.ok(D.data.documentElement&&D.data.documentElement.localName==="FragmentDefinition","File "+C+" exists and starts with a FragmentDefinition node");}}}};
function a(){QUnit.test("Checking library.designtime.js",function(c){var e=sap.ui.getCore().getLoadedLibraries()[l];if(e.designtime){var f=c.async();sap.ui.require([e.designtime],function(o){c.ok(o!==null,e.designtime+" loaded successfully");f();});}else{c.ok(true,"No library.designtime.js "+l);}});QUnit.test("Checking loaded designtime data",function(c){d.forEach(function(D){c.strictEqual(D!==null,true,"Designtime data found and loaded successful");c.strictEqual(typeof D,"object","Designtime data returned an object");});});m.forEach(function(o){var c=o._oControlMetadata;var C=c.getName();QUnit.test(C+": Checking entries in designtime data",function(e){Object.keys(M).forEach(function(p){var f=M[p];var v=o.getProperty(p);if(v===undefined&&!f.optional){e.equal(false,true,C+" does not define mandatory entry "+p);}else if(v!==undefined&&f.optional){e.equal(true,true,C+" does define optional entry "+p);f.check(e,v,C);}else if(v!==undefined&&!f.optional){e.equal(true,true,C+" does define mandatory entry "+p);f.check(e,v,C);}});});});}
return L;},true);
sap.ui.predefine('sap/ui/dt/enablement/report/LibraryReport',["sap/ui/dt/enablement/Test","sap/ui/dt/enablement/ElementEnablementTest"],function(T,E){"use strict";
var L=T.extend("sap.ui.dt.enablement.report.LibraryReport",{metadata:{library:"sap.ui.dt",properties:{libraryName:{type:"string"},testData:{type:"object"}}}});
L.prototype.run=function(){this._aResult=[];var t=this.getTestData()||{};var l=this.getLibraryName();var e=[];var o=sap.ui.getCore().getLoadedLibraries()[l];if(o){var a=o.controls;a.forEach(function(s){var b=t[s];if(!b&&b!==false){b={};}if(b!==false){b.type=s;var c=null;if(b.create){c=Object.assign({},b);delete c.create;b.groupPostfix="with create method";}e.push(new E(b));if(c){e.push(new E(c));}}});}var r=[];var i=function(R){if(R){r.push(R);}var b=e.shift();if(b){return b.run().then(function(R){b.destroy();return i(R);});}return Promise.resolve(r);};return i().then(function(r){var R=this.createSuite("Library Enablement Test");r.forEach(function(m){var c=m.children[0];var p=R.children[R.children.length-1];if(p&&c.name===p.name){p.children=p.children.concat(c.children);}else{R.children.push(c);}});R=this.aggregate(R);return R;}.bind(this));};
return L;});
sap.ui.predefine('sap/ui/dt/enablement/report/QUnitReport',["sap/ui/base/ManagedObject"],function(M){"use strict";
var Q=M.extend("sap.ui.dt.enablement.report.QUnitReport",{
metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}}},
init:function(){if(!QUnit){throw new Error("QUnit is required for this report.");}},
setData:function(d){if(d){var c=d.children;c.forEach(function(g){this._createModule(g);},this);}this.setProperty("data",d);},
_createModule:function(g){QUnit.module(g.message);g.children.forEach(function(g){this._createTest(g);},this);},
_createTest:function(g){QUnit.test(g.name+": "+g.message,function(a){g.children.forEach(function(g){this._createAssertion(a,g);},this);}.bind(this));},
_createAssertion:function(a,g){if(g.children.length>0){g.children.forEach(function(t){a.ok(t.result,g.name+": "+t.message);});}else{a.ok(true,g.name+": "+g.message);}}
});
return Q;});
sap.ui.predefine('sap/ui/dt/enablement/report/Statistic',["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/layout/form/SimpleForm","sap/m/Label","sap/m/Text","./StatisticRenderer"],function(C,J,S,L,T){"use strict";
var s=C.extend("sap.ui.dt.enablement.report.Statistic",{
metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}},aggregations:{_form:{type:"sap.ui.layout.form.SimpleForm",hidden:true,multiple:false}}},
init:function(){this._oModel=null;this.setAggregation("_form",this._createForm());},
exit:function(){this.setData(null);},
setData:function(d){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(d){this._oModel=new J(d);this._getForm().setModel(this._oModel);}else{this._getForm().setModel(null);}this.setProperty("data",d);},
_createForm:function(){var f=new S(this.getId()+"--form",{editable:false,title:"Statistics",content:[new L(this.getId()+"--form-supported-label",{text:"Supported"}),new T(this.getId()+"--form-supported-value",{text:"{/statistic/SUPPORTED}"}),new L(this.getId()+"--form-partial-supported-label",{text:"Partial Supported"}),new T(this.getId()+"--form-partial-supported-value",{text:"{/statistic/PARTIAL_SUPPORTED}"}),new L(this.getId()+"--form-not-supported-label",{text:"Not Supported"}),new T(this.getId()+"--form-not-supported-value",{text:"{/statistic/NOT_SUPPORTED}"}),new L(this.getId()+"--form-unknown-label",{text:"Unknown"}),new T(this.getId()+"--form-unknown-value",{text:"{/statistic/UNKNOWN}"}),new L(this.getId()+"--form-error-label",{text:"Error"}),new T(this.getId()+"--form-error-value",{text:"{/statistic/ERROR}"})]});return f;},
_getForm:function(){return this.getAggregation("_form");}
});
return s;});
sap.ui.predefine('sap/ui/dt/enablement/report/StatisticRenderer',function(){"use strict";var S={};
S.render=function(r,s){r.addClass("sapUiDtStatisticReport");r.write("<div");r.writeControlData(s);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(s._getForm());r.write("</div>");};
return S;});
sap.ui.predefine('sap/ui/dt/enablement/report/Table',["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/table/TreeTable","sap/ui/table/Column","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/SearchField","sap/m/Text","sap/m/RatingIndicator","./TableRenderer"],function(C,J,T,a,b,c,B,S,d,R){"use strict";
var t=C.extend("sap.ui.dt.enablement.report.Table",{
metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}},aggregations:{_table:{type:"sap.ui.table.TreeTable",hidden:true,multiple:false}}},
init:function(){this.setAggregation("_table",this._createTable());},
exit:function(){clearTimeout(this._iFilterTimeout);this.setData(null);},
setData:function(D){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(D){this._oModel=new J(D);this._getTable().setModel(this._oModel);}else{this._getTable().setModel(null);}this.setProperty("data",D);},
filter:function(f){var m=this._getTable().getModel();if(m){if(f.length>0){var D=this.getData();var F=D.children.filter(function(e){if(f.indexOf("status=")!==-1){return e.status.value===f.substring(f.indexOf("=")+1);}return e.name.toLowerCase().indexOf(f.toLowerCase())!==-1;});m.setData(F);}else{m.setData(this.getData());}}},
_createTable:function(){var t=new T(this.getId()+"--table",{selectionMode:"MultiToggle",visibleRowCount:20,enableSelectAll:false,ariaLabelledBy:"title",toolbar:this._createToolbar(),rows:"{path:'/', parameters: {arrayNames:['children']}}",columns:[this._createTextColumn("name","Name","{name}"),this._createRatingIndicatorColumn("value","Status Values","{status/value}","{status/text} ({status/value})"),this._createTextColumn("status","Status","{status/text}"),this._createTextColumn("message","Message","{message}")]});return t;},
_createToolbar:function(){return new b(this.getId()+"--toolbar",{content:[new c(this.getId()+"--toolbar-spacer"),new B(this.getId()+"--toolbar-collapse-button",{text:"Collapse all",press:this._onCollapseAll.bind(this)}),new B(this.getId()+"--toolbar-expand-button",{text:"Expand",press:this._onExpandSecondLevel.bind(this)}),new S(this.getId()+"--toolbar-search-field",{liveChange:this._onSearch.bind(this)})]});},
_onSearch:function(e){var f=e.getParameter('newValue');clearTimeout(this._iFilterTimeout);this._iFilterTimeout=setTimeout(function(){this.filter(f);}.bind(this),100);},
_createTextColumn:function(i,s,r){return this._createColumn(i,s,new d({text:r}));},
_createRatingIndicatorColumn:function(i,s,r,e){return this._createColumn(i,s,new R({maxValue:3,value:r,enabled:false,tooltip:e}));},
_createColumn:function(i,s,o){return new a(this.getId()+"--table-column-"+i,{label:s,width:"13em",template:o});},
_getTable:function(){return this.getAggregation("_table");},
_onCollapseAll:function(){var t=this._getTable();t.collapseAll();},
_onExpandSecondLevel:function(){var t=this._getTable();t.expandToLevel(2);}
});
return t;});
sap.ui.predefine('sap/ui/dt/enablement/report/TableRenderer',function(){"use strict";var T={};
T.render=function(r,t){r.addClass("sapUiDtTableReport");r.write("<div");r.writeControlData(t);r.writeStyles();r.writeClasses();r.write(">");r.renderControl(t._getTable());r.write("</div>");};
return T;});
sap.ui.predefine('sap/ui/dt/library',["sap/ui/base/ManagedObjectMetadata","sap/ui/dt/SelectionMode","sap/ui/core/library"],function(M){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.dt",version:"1.84.17",dependencies:["sap.ui.core"],types:["sap.ui.dt.SelectionMode"],interfaces:[],controls:[],elements:[]});M.setDesignTimeDefaultMapping({"not-adaptable":"sap/ui/dt/designtime/notAdaptable.designtime","not-adaptable-tree":"sap/ui/dt/designtime/notAdaptableTree.designtime","not-adaptable-visibility":"sap/ui/dt/designtime/notAdaptableVisibility.designtime","not-removable":"sap/ui/dt/designtime/notAdaptableVisibility.designtime"});return sap.ui.dt;},true);
sap.ui.predefine('sap/ui/dt/plugin/DragDrop',["sap/ui/base/Object","sap/ui/dt/Plugin","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/OverlayRegistry","sap/ui/thirdparty/jquery","sap/ui/Device"],function(B,P,D,O,a,q,b){"use strict";
var c=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});
var I=7;var p=false;var o;
c.prototype._preventScrollOnTouch=function(E){if(p){E.preventDefault();}};
c.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};
c.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};
c.prototype.registerElementOverlay=function(g){g.attachEvent("movableChange",this._onMovableChange,this);if(g.isMovable()){this._attachDragEvents(g);}g.attachBrowserEvent("dragover",this._onDragOver,this);g.attachBrowserEvent("dragenter",this._onDragEnter,this);g.attachBrowserEvent("dragleave",this._onDragLeave,this);};
c.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!b.browser.webkit){this._attachDragScrollHandler(A);}};
c.prototype.deregisterElementOverlay=function(g){g.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(g);g.detachBrowserEvent("dragover",this._onDragOver,this);g.detachBrowserEvent("dragenter",this._onDragEnter,this);g.detachBrowserEvent("dragleave",this._onDragLeave,this);};
c.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!b.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};
c.prototype._attachDragEvents=function(g){g.attachBrowserEvent("dragstart",this._onDragStart,this);g.attachBrowserEvent("drag",this._onDrag,this);g.attachBrowserEvent("dragend",this._onDragEnd,this);g.attachBrowserEvent("touchstart",this._onTouchStart,this);};
c.prototype._detachDragEvents=function(g){g.detachBrowserEvent("dragstart",this._onDragStart,this);g.detachBrowserEvent("drag",this._onDrag,this);g.detachBrowserEvent("dragend",this._onDragEnd,this);g.detachBrowserEvent("touchstart",this._onTouchStart,this);};
c.prototype.onMovableChange=function(){};
c.prototype.onDragStart=function(){};
c.prototype.onDragEnd=function(){};
c.prototype.onDrag=function(){};
c.prototype.onDragEnter=function(){};
c.prototype.onDragLeave=function(){};
c.prototype.onDragOver=function(){};
c.prototype.onAggregationDragEnter=function(){};
c.prototype.onAggregationDragOver=function(){};
c.prototype.onAggregationDragLeave=function(){};
c.prototype.onAggregationDrop=function(){};
c.prototype._checkMovable=function(g){if(g.isMovable()||D.getDraggable(g.$())!==undefined){D.setDraggable(g.$(),g.isMovable());}};
c.prototype._onMovableChange=function(E){var g=E.getSource();if(g.isMovable()){this._attachDragEvents(g);}else{this._detachDragEvents(g);}this.onMovableChange(g);};
c.prototype._onDragStart=function(E){var g=a.getOverlay(E.currentTarget.id);E.stopPropagation();if(b.browser.firefox&&E&&E.originalEvent&&E.originalEvent.dataTransfer&&E.originalEvent.dataTransfer.setData){E.originalEvent.dataTransfer.setData('text/plain','');}this.setBusy(true);this.showGhost(g,E);this.onDragStart(g);};
c.prototype._attachTouchDragEvents=function(g){g.attachBrowserEvent("touchmove",this._onTouchMove,this);g.attachBrowserEvent("touchend",this._onTouchEnd,this);};
c.prototype._detachTouchDragEvents=function(g){g.detachBrowserEvent("touchmove",this._onTouchMove,this);g.detachBrowserEvent("touchend",this._onTouchEnd,this);};
c.prototype._onTouchStart=function(E){var t=E.touches[0].pageX;var g=E.touches[0].pageY;var T=a.getOverlay(E.currentTarget.id);function h(){T.detachBrowserEvent("touchmove",j,this);T.detachBrowserEvent("touchend",k,this);T.detachBrowserEvent("contextmenu",k,this);}function i(l,m){var n=t-l;var r=g-m;return Math.sqrt((n*n)+(r*r));}function j(E){var l=E.touches[0].pageX;var m=E.touches[0].pageY;var n=i(l,m);if(n>I){this.onDragStart(T);h.call(this);this._attachTouchDragEvents(T);}}function k(){h.call(this);p=false;}p=true;E.stopPropagation();T.attachBrowserEvent("touchmove",j,this);T.attachBrowserEvent("contextmenu",k,this);T.attachBrowserEvent("touchend",k,this);};
c.prototype._getTargetOverlay=function(E){if(B.isA(E,"sap.ui.dt.Overlay")){var t;if(B.isA(E,"sap.ui.dt.AggregationOverlay")&&E.getTargetZone()){t=E;}else if(B.isA(E,"sap.ui.dt.ElementOverlay")&&O.isInTargetZoneAggregation(E)){t=E;}return t||this._getTargetOverlay(E.getParent());}};
c.prototype._findTargetOverlayFromCoordinates=function(g,h){var i=document.elementFromPoint(g,h);var E=i?sap.ui.getCore().byId(i.id):undefined;return this._getTargetOverlay(E);};
c.prototype._onTouchMove=function(E){var g=a.getOverlay(E.currentTarget.id);this.onDrag(g);var t=E.touches||E.changedTouches;var h=t[0].pageX;var i=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(h,i);if(!T){return;}if(T!==o){if(o){if(B.isA(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}E.stopPropagation();};
c.prototype._getValidTargetZoneAggregationOverlay=function(g){if(B.isA(g,"sap.ui.dt.AggregationOverlay")&&g.getTargetZone()){return g;}return this._getValidTargetZoneAggregationOverlay(g.getParent());};
c.prototype._onTouchEnd=function(E){var g=a.getOverlay(E.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(g);if(A){this.onAggregationDrop(A);}this.onDragEnd(g);this._detachTouchDragEvents(g);o=undefined;p=false;};
c.prototype.showGhost=function(g,E){if(E&&E.originalEvent&&E.originalEvent.dataTransfer){E.originalEvent.dataTransfer.effectAllowed="move";E.originalEvent.dataTransfer.dropEffect="move";if(!b.browser.msie&&!b.browser.edge&&!b.browser.msie&&E.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(g,E);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);E.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),E.originalEvent.pageX-g.$().offset().left,E.originalEvent.pageY-g.$().offset().top);}}};
c.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};
c.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};
c.prototype.createGhost=function(g){var G=g.getAssociatedDomRef();var $;if(!G){G=this._getAssociatedDomCopy(g);$=G;}else{$=q("<div></div>");q.makeArray(G).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=q("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};
c.prototype._getAssociatedDomCopy=function(g){var $=q("<div></div>");g.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var h=C.getAssociatedDomRef();if(h){D.cloneDOMAndStyles(h,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};
c.prototype.getGhost=function(){return this._$ghost;};
c.prototype._onDragEnd=function(E){this.setBusy(false);var g=a.getOverlay(E.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(g);E.stopPropagation();};
c.prototype._onDrag=function(E){var g=a.getOverlay(E.currentTarget.id);this.onDrag(g);E.stopPropagation();};
c.prototype._onDragEnter=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragEnter(g)){E.stopPropagation();}}E.preventDefault();};
c.prototype._onDragLeave=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragLeave(g)){E.stopPropagation();}}E.preventDefault();};
c.prototype._onDragOver=function(E){var g=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(g)){if(!this.onDragOver(g)){E.stopPropagation();}}E.preventDefault();};
c.prototype._onAggregationTargetZoneChange=function(E){var A=E.getSource();var t=E.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};
c.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};
c.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};
c.prototype._onAggregationDragEnter=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragEnter(A);E.preventDefault();E.stopPropagation();};
c.prototype._onAggregationDragOver=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragOver(A);E.preventDefault();E.stopPropagation();};
c.prototype._onAggregationDragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragLeave(A);E.preventDefault();E.stopPropagation();};
c.prototype._onAggregationDrop=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDrop(A);E.preventDefault();E.stopPropagation();};
var d=100;var e=20;var f=50;
c.prototype._clearScrollInterval=function(E,s){if(this._mScrollIntervals[E]){window.clearInterval(this._mScrollIntervals[E][s]);delete this._mScrollIntervals[E][s];}};
c.prototype._clearScrollIntervalFor=function(E){if(this._mScrollIntervals[E]){Object.keys(this._mScrollIntervals[E]).forEach(function(s){this._clearScrollInterval(E,s);},this);}};
c.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};
c.prototype._checkScroll=function($,s,E){var S;var g;var i=1;if(s==="top"||s==="bottom"){S=$.outerHeight();g=$.scrollTop.bind($);}else{S=$.outerWidth();g=$.scrollLeft.bind($);}if(s==="top"||s==="left"){i=-1;}var h=Math.floor(S/4);var t=d;if(h<d){t=h;}if(E<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var j=g();g(j+i*e);},f);}}else{this._clearScrollInterval($.attr("id"),s);}};
c.prototype._dragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};
c.prototype._dragScroll=function(E){var A=a.getOverlay(E.currentTarget.id);var $=A.$();var i=E.clientX;var g=E.clientY;var h=$.offset();var H=$.height();var w=$.width();var t=h.top;var l=h.left;var j=t+H;var r=l+w;this._checkScroll($,"bottom",j-g);this._checkScroll($,"top",g-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};
c.prototype._attachDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};
c.prototype._removeDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}var g=A.getDomRef();if(g){g.removeEventListener("dragover",this._dragScrollHandler,true);}};
return c;});
sap.ui.predefine('sap/ui/dt/plugin/MouseSelection',["sap/ui/dt/Plugin"],function(P){"use strict";
var M=P.extend("sap.ui.dt.plugin.MouseSelection",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
M.prototype.init=function(){P.prototype.init.apply(this,arguments);};
M.prototype.registerElementOverlay=function(o){o.setSelectable(true);o.attachBrowserEvent('click',this._onClick,o);};
M.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent('click',this._onClick,o);};
M.prototype._onClick=function(e){this.setSelected(!this.getSelected());e.preventDefault();e.stopPropagation();};
return M;});
sap.ui.predefine('sap/ui/dt/plugin/ToolHooks',["sap/ui/dt/Plugin"],function(P){"use strict";
var T=P.extend("sap.ui.dt.plugin.ToolHooks",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});
T.prototype.registerElementOverlay=function(o){o.getDesignTimeMetadata().getToolHooks().start(o.getElement());};
T.prototype.deregisterElementOverlay=function(o){o.getDesignTimeMetadata().getToolHooks().stop(o.getElement());};
return T;});
sap.ui.predefine('sap/ui/dt/util/ZIndexManager',["sap/ui/core/Popup","sap/ui/core/BusyIndicator","sap/base/Log","sap/ui/dt/Util","sap/m/InstanceManager","sap/base/util/includes","sap/base/util/restricted/_max","sap/base/util/restricted/_min"],function(P,B,L,U,I,i,_,a){"use strict";var Z=10;var b=3;var A=[];var c=[];
function g(){return I.getOpenDialogs().concat(I.getOpenPopovers(),B.oPopup&&B.oPopup.isOpen()?[B.oPopup]:[]);}
function d(C,m,E){if(++C<=m){if(i(E,C)){return d(C,m,E);}return C;}L.error('sap.ui.dt.util.ZIndexManager: z-index limit has been exceeded, therefore all following calls receive the same z-Index = '+m);return m;}
function e(p){return p.map(function(o){return o._iZIndex||o.oPopup._iZIndex;});}
var f={getNextZIndex:function(){var h=g();var v=[];var j=[];h.forEach(function(o){var V=c.every(function(F){return F(o);});V&&c.length>0?v.push(o):j.push(o);});var m=v.length>0?_(e(v)):-1;var M=j.length>0?a(e(j)):-1;if(m<M){return this._getNextMinZIndex(M);}return P.getNextZIndex();},getZIndexBelowPopups:function(){var o=g();var l;if(o.length>0){l=Math.min.apply(null,e(o));}if(!U.isInteger(l)){return P.getNextZIndex();}return this._getNextMinZIndex(l);},addPopupFilter:function(F){if(typeof F==="function"){c=c.concat([F]);}},removePopupFilter:function(F){c=c.filter(function(E){return E===F;});},_getNextMinZIndex:function(C){var m=C-b;var M=C-Z;var n=d(M,m,A);A.push(n);return n;}};return f;});
sap.ui.predefine('sap/ui/dt/util/_createPromise',function(){"use strict";return function(f){var c=false;var C;var a;var b;var p=new Promise(function(r,R){f(function(){if(!c){r.apply(this,arguments);}else if(a){a.apply(this,arguments);}},function(){if(!c){R.apply(this,arguments);}else if(b){b.apply(this,arguments);}});});return{promise:p,cancel:function(){c=true;if(!C){C=new Promise(function(r,R){a=r;b=R;});}return C;}};};});
sap.ui.require.preload({
	"sap/ui/dt/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.dt","type":"library","embeds":[],"applicationVersion":{"version":"1.84.17"},"title":"SAP UI library: sap.ui.dt (by SAP, Author)","description":"SAP UI library: sap.ui.dt (by SAP, Author)","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.17"}}},"library":{"i18n":false,"content":{"controls":[],"elements":[],"types":["sap.ui.dt.SelectionMode"],"interfaces":[]}}}}'
},"sap/ui/dt/library-preload"
);
//# sourceMappingURL=library-preload.js.map