/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Cache","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/write/_internal/Storage","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/thirdparty/jquery","sap/base/util/includes","sap/base/util/merge","sap/base/util/UriParameters","sap/base/Log","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/condenser/Condenser"],function(D,S,C,L,V,U,a,b,A,c,J,d,e,M,q,i,m,f,g,h,F,j,k){"use strict";var l=function(p){this._mComponent=p;this._mChanges=D.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=m({},this._mChanges);if(!this._mComponent||!this._mComponent.name){g.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};function r(v,p){return v.controlChanges.some(function(t,u){if(t.fileName===p.getDefinition().fileName){v.controlChanges.splice(u,1,p);return true;}});}function n(p,t){var u;if(t instanceof C){u=t;this._mChangesEntries[u.getFileName()]=u;}else{if(!this._mChangesEntries[t.fileName]){this._mChangesEntries[t.fileName]=new C(t);}u=this._mChangesEntries[t.fileName];u.setState(C.states.PERSISTED);var v=u.getVariantReference();if(v){var w=h.getVariant({vReference:v,reference:this._mComponent.name});if(w){r(w,u);}}}return u;}l.prototype.getComponentName=function(){return this._mComponent.name;};l.prototype.getCacheKey=function(p){return b.getCacheKey(this._mComponent,p);};l.prototype._preconditionsFulfilled=function(p){var t=p instanceof C?p.getDefinition():p;function _(){if((t.fileType==="ctrl_variant")||(t.fileType==="ctrl_variant_change")||(t.fileType==="ctrl_variant_management_change")){return t.variantManagementReference||t.variantReference||(t.selector&&t.selector.id);}}return t.fileType==="change"||_();};l.prototype.getChangesForComponent=function(p,I){return b.getChangesFillingCache(this._mComponent,p,I).then(function(p,w){var t=m({},w);var u=p&&p.component&&U.getAppComponentForControl(p.component);var H=S.isStorageResponseFilled(t.changes);if(!H){return[];}var v=t.changes.changes;if(!this._oMessagebundle&&t.messagebundle&&u){if(!u.getModel("i18nFlexVendor")){if(v.some(function(K){return K.layer===L.VENDOR;})){this._oMessagebundle=t.messagebundle;var x=new e(this._oMessagebundle);u.setModel(x,"i18nFlexVendor");}}}var y=p&&p.currentLayer;var z=!(p&&p.ignoreMaxLayerParameter);var B=function(){return true;};if(y){B=this._filterChangeForCurrentLayer.bind(this,y);v=v.filter(B);}else if(a.isLayerFilteringRequired()&&z){B=this._filterChangeForMaxLayer.bind(this);v=v.filter(B);}else if(this._bHasChangesOverMaxLayer&&!z){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}var E=t.changes&&p&&p.includeCtrlVariants;var G=this._getAllCtrlVariantChanges(t,E,B);v=v.concat(G);return this._checkAndGetChangeInstances(v,t);}.bind(this,p));};l.prototype._checkAndGetChangeInstances=function(p,t){return p.filter(this._preconditionsFulfilled).map(n.bind(this,t));};l.prototype._filterChangeForMaxLayer=function(p){if(a.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(p))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};l.prototype._filterChangeForCurrentLayer=function(p,t){return p===this._getLayerFromChangeOrChangeContent(t);};l.prototype._getLayerFromChangeOrChangeContent=function(p){var t;if(p instanceof V||p instanceof C){t=p.getLayer();}else{t=p.layer;}return t;};l.prototype._getAllCtrlVariantChanges=function(p,I,t){if(!I){return h.getInitialChanges({reference:this._mComponent.name});}return["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"].reduce(function(R,v){if(p.changes[v]){return R.concat(p.changes[v]);}return R;},[]).filter(t);};l.prototype.loadChangesMapForComponent=function(p){return this.getChangesForComponent({component:p}).then(t.bind(this));function t(u){M.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=D.createEmptyDependencyMap();u.forEach(this.addChangeAndUpdateDependencies.bind(this,p));this._mChangesInitial=m({},this._mChanges);M.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this);}};l.prototype.checkForOpenDependenciesForControl=function(p,t){return D.checkForOpenDependenciesForControl(this._mChanges,J.getControlIdBySelector(p,t),t);};l.prototype.copyDependenciesFromInitialChangesMap=function(p,t,u){var I=m({},this._mChangesInitial.mDependencies);var v=I[p.getId()];if(v){var N=[];v.dependencies.forEach(function(y){if(t(y)){this._mChanges.mDependentChangesOnMe[y]=this._mChanges.mDependentChangesOnMe[y]||[];this._mChanges.mDependentChangesOnMe[y].push(p.getId());N.push(y);}}.bind(this));var w;var x=[];v.controlsDependencies.forEach(function(y){if(!J.bySelector(y,u)){w=J.getControlIdBySelector(y,u);x.push(y);this._mChanges.mControlsWithDependencies[w]=this._mChanges.mControlsWithDependencies[w]||[];if(!i(this._mChanges.mControlsWithDependencies[w],p.getId())){this._mChanges.mControlsWithDependencies[w].push(p.getId());}}}.bind(this));v.dependencies=N;v.controlsDependencies=x;if(N.length||x.length){this._mChanges.mDependencies[p.getId()]=v;}}return this._mChanges;};l.prototype.addChangeAndUpdateDependencies=function(p,t,R){t.setInitialApplyState();if(R){D.insertChange(t,this._mChanges,R);}D.addChangeAndUpdateDependencies(t,p,this._mChanges);};l.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(p,t){D.addRuntimeChangeAndUpdateDependencies(t,p,this._mChanges,this._mChangesInitial);};l.prototype.getChangesMapForComponent=function(){return this._mChanges;};l.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated;};l.prototype.changesHavingCorrectViewPrefix=function(p,t){var u=p.modifier;var v=p.appComponent;var w=t.getSelector();if(!w||!p){return false;}if(w.viewSelector){var x=u.getControlIdBySelector(w.viewSelector,v);return x===p.viewId;}var y=w.id;if(y){var z;if(t.getSelector().idIsLocal){if(v){z=v.getLocalId(p.viewId);}}else{z=p.viewId;}var I=0;var B;do{I=y.indexOf("--",I);B=y.slice(0,I);I++;}while(B!==z&&I>0);return B===z;}return false;};l.prototype.getChangesForView=function(p){return this.getChangesForComponent(p).then(function(t){return t.filter(this.changesHavingCorrectViewPrefix.bind(this,p));}.bind(this));};l.prototype.addChange=function(v,p){var t=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(p,t);this._addPropagationListener(p);return t;};l.prototype.addDirtyChange=function(v){var N;if(v instanceof C||v instanceof V){N=v;}else{N=new C(v);}if(this._aDirtyChanges.indexOf(N)===-1){this._aDirtyChanges.push(N);}return N;};l.prototype._addPropagationListener=function(p){var t=U.getAppComponentForControl(p);if(t instanceof d){var u=function(P){return!P._bIsSapUiFlFlexControllerApplyChangesOnControl;};var N=t.getPropagationListeners().every(u);if(N){var v=sap.ui.require("sap/ui/fl/FlexControllerFactory");var w=v.create(this.getComponentName());var P=A.applyAllChangesForControl.bind(A,this.getChangesMapForComponent.bind(this),t,w);P._bIsSapUiFlFlexControllerApplyChangesOnControl=true;t.addPropagationListener(P);}}};l.prototype._deleteNotSavedChanges=function(p,t){p.filter(function(u){return!t.some(function(v){return u.getId()===v.getId();});}).forEach(function(u){this.deleteChange(u,true);}.bind(this));};function s(p,t){var u=false;if(!p||t.length<2){return false;}var v=t.map(function(y){return y.getLayer();});var w=v.filter(function(y,I,v){return v.indexOf(y)===I;});if(w.length>1){return false;}if(w[0]==="CUSTOMER"||w[0]==="USER"){u=true;}var x=f.fromURL(window.location.href);if(x.has("sap-ui-xx-condense-changes")){u=x.get("sap-ui-xx-condense-changes")==="true";}return u;}l.prototype.saveDirtyChanges=function(p,t,u,v){u=u||this._aDirtyChanges;var w=u.slice(0);var R=this._getRequests(u);var P=this._getPendingActions(u);if(P.length===1&&R.length===1&&P[0]==="NEW"){var x=Promise.resolve(w);if(s(p,w)){x=k.condense(p,w);}return x.then(function(y){if(y.length){var z=R[0];var B=this._prepareDirtyChanges(y);return c.write({layer:B[0].layer,flexObjects:B,transport:z,isLegacyVariant:false,parentVersion:v}).then(function(E){this._massUpdateCacheAndDirtyState(y,t);this._deleteNotSavedChanges(u,y);return E;}.bind(this));}this._deleteNotSavedChanges(u,y);}.bind(this));}return this.saveSequenceOfDirtyChanges(w,t,v);};l.prototype.saveSequenceOfDirtyChanges=function(p,t,u){var v;if(u){var N=p.filter(function(w){return w.getPendingAction()==="NEW";});v=[].concat(N).shift();}return p.reduce(function(P,w){return P.then(this._performSingleSaveAction(w,v,u)).then(this._updateCacheAndDirtyState.bind(this,w,t));}.bind(this),Promise.resolve());};l.prototype._performSingleSaveAction=function(p,t,u){return function(){if(p.getPendingAction()==="NEW"){if(u!==undefined){u=p===t?u:sap.ui.fl.Versions.Draft;}return c.write({layer:p.getLayer(),flexObjects:[p.getDefinition()],transport:p.getRequest(),parentVersion:u});}if(p.getPendingAction()==="DELETE"){return c.remove({flexObject:p.getDefinition(),layer:p.getLayer(),transport:p.getRequest()});}};};l.prototype._updateCacheAndDirtyState=function(p,t){if(!t){if(U.isChangeRelatedToVariants(p)){h.updateVariantsState({reference:this._mComponent.name,changeToBeAddedOrDeleted:p});}else if(U.isChangeRelatedToCompVariant(p)){j.updateState({reference:this._mComponent.name,changeToBeAddedOrDeleted:p});}else if(p.getPendingAction()==="NEW"){b.addChange(this._mComponent,p.getDefinition());}else if(p.getPendingAction()==="DELETE"){b.deleteChange(this._mComponent,p.getDefinition());}}this._aDirtyChanges=this._aDirtyChanges.filter(function(E){return p.getId()!==E.getId();});};l.prototype._massUpdateCacheAndDirtyState=function(p,t){p.forEach(function(u){this._updateCacheAndDirtyState(u,t);},this);};l.prototype._getRequests=function(p){var R=[];p.forEach(function(t){var u=t.getRequest();if(R.indexOf(u)===-1){R.push(u);}});return R;};l.prototype._getPendingActions=function(p){var P=[];p.forEach(function(t){var u=t.getPendingAction();if(P.indexOf(u)===-1){P.push(u);}});return P;};l.prototype._prepareDirtyChanges=function(p){var t=[];p.forEach(function(u){t.push(u.getDefinition());});return t;};l.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};l.prototype.deleteChange=function(p,R){var t=this._aDirtyChanges.indexOf(p);if(t>-1){if(p.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(t,1);this._deleteChangeInMap(p,R);return;}p.markForDeletion();this.addDirtyChange(p);this._deleteChangeInMap(p,R);};l.prototype._deleteChangeInMap=function(p,R){var t=p.getId();D.removeChangeFromMap(this._mChanges,t);D.removeChangeFromDependencies(R?this._mChangesInitial:this._mChanges,t);};function o(p,O){return(O.getRequest()==="$TMP"||O.getRequest()==="")&&O.getLayer()===p;}l.prototype.transportAllUIChanges=function(R,p,t,u){return Promise.all([this.getChangesForComponent({currentLayer:t,includeCtrlVariants:true}),F.getCompEntitiesByIdMap(this.getComponentName())]).then(function(v){var w=v[0];var x=v[1];var y=[];for(var z in x){y.push(x[z]);}w=w.concat(y.filter(o.bind(this,t)));return c.publish({transportDialogSettings:{rootControl:R,styleClass:p},layer:t,reference:this.getComponentName(),localChanges:w,appVariantDescriptors:u});}.bind(this));};l.prototype._getChangesFromMapByNames=function(N){return this._mChanges.aChanges.filter(function(p){return N.indexOf(p.getFileName())!==-1;});};l.prototype.removeDirtyChanges=function(p,t,u,G,v){if(!u){g.error("The selectorId must be provided");return Promise.reject("The selectorId must be provided");}var w=this._aDirtyChanges;var x=w.filter(function(y){var z=true;if(y.getLayer()!==p){return false;}if(G&&y.getDefinition().support.generator!==G){return false;}var B=y.getSelector();z=u.getId()===J.getControlIdBySelector(B,t);if(v){z=z&&v.indexOf(y.getChangeType())!==-1;}return z;});x.forEach(function(y){var z=w.indexOf(y);w.splice(z,1);});return Promise.resolve(x);};l.prototype.resetChanges=function(p,G,t,u){var v=t&&t.length>0;var w=u&&u.length>0;if(!G&&!v&&!w){g.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}return this.getChangesForComponent({currentLayer:p,includeCtrlVariants:true}).then(function(x){var P={reference:this.getComponentName(),layer:p,changes:x};if(G){P.generator=G;}if(v){P.selectorIds=t;}if(w){P.changeTypes=u;}return c.reset(P);}.bind(this)).then(function(R){var x=[];if(t||u){var N=[];if(R&&R.response&&R.response.length>0){R.response.forEach(function(y){N.push(y.fileName);});}b.removeChanges(this._mComponent,N);x=this._getChangesFromMapByNames(N);}return x;}.bind(this));};l.prototype.getResetAndPublishInfo=function(p){return c.getFlexInfo(p);};return l;},true);
