/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/library","sap/ui/integration/library","sap/ui/util/openWindow","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/DataProviderFactory"],function(l,a,o,M,L,B,D){"use strict";function _(s){if(s&&typeof s==="object"){return s.name;}return s;}var A=a.AreaType,C=a.CardActionType,b=l.ListType;var c=M.extend("sap.ui.integration.util.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},areaType:{type:"sap.ui.integration.AreaType",defaultValue:A.None}}}});c.prototype.exit=function(){this._oAreaControl=null;};c.prototype.attach=function(i,d){this._oAreaControl=d;if(!i.actions){this._fireActionReady();return;}var e=i.actions[0];if(e&&e.type){this._attachAction(i,e);}else{this._fireActionReady();}};c.prototype._setItemTemplateTypeFormatter=function(d){var t=this,e=t._oAreaControl,i=e._oItemTemplate;var f=M.bindingParser("{path:''}");f.formatter=function(v){var g=this.getBindingContext(),p,P;if(g){p=g.getPath();}P=B.resolveValue(d.parameters,e,p);if(v.__resolved){if(!v.__enabled||v.__enabled==="false"){return b.Inactive;}return b.Navigation;}if(!v.__promise){v.__promise=true;e._oServiceManager.getService(_(d.service)).then(function(n){if(n){n.enabled({parameters:P}).then(function(E){v.__resolved=true;v.__enabled=E;e.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return b.Inactive;};i.bindProperty("type",f);};c.prototype._setSingleActionEnabledState=function(i,d){var e=this._oAreaControl,f=e.getBindingContext(),p,P;if(f){P=f.getPath();}p=B.resolveValue(d.parameters,e,P);return new Promise(function(r){e._oServiceManager.getService(_(d.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};c.prototype._setItemTemplateEnabledState=function(d){var e,t,i=this._oAreaControl._oItemTemplate;if(typeof d.enabled==="object"){e=d.enabled;e.formatter=function(v){if(!v||v==="false"){return b.Inactive;}return b.Navigation;};}if(e){i.bindProperty("type",e);}else{t=(d.enabled===false||d.enabled==="false")?b.Inactive:b.Navigation;i.setProperty("type",t);}};c.prototype._fireActionReady=function(){var h=this.getAreaType()===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";this._oAreaControl.fireEvent(e);};c.prototype._handleServiceAction=function(s,d){var f=s.getBindingContext(),p;if(f){p=f.getPath();}this._oAreaControl._oServiceManager.getService(_(d.service)).then(function(S){if(S){S.navigate({parameters:B.resolveValue(d.parameters,s,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,d,p);}.bind(this));};c.prototype._handleAction=function(s,d){var e=s.getBindingContext(),p;if(e){p=e.getPath();}this._processAction(s,d,p);};c.prototype._attachPressEvent=function(d,e,s){d.attachPress(function(E){var S=E.getSource();if(e.service){this._handleServiceAction(S,e);}else{this._handleAction(S,e);}}.bind(this));};c.prototype._attachAction=function(i,d){var e=this.getAreaType()===A.ContentItem?this._oAreaControl._oItemTemplate:this._oAreaControl,f=true,s=this.getAreaType(),S=s===A.Header||s===A.Content,g=s===A.ContentItem,h=true;if(d.service){if(this.getAreaType()===A.ContentItem){this._setItemTemplateTypeFormatter(d);}f=false;}else if(g){this._setItemTemplateEnabledState(d);f=false;}if(S&&d.service){this._setSingleActionEnabledState(i,d).then(function(E){if(E){this._attachPressEvent(e,d,S);}this._fireActionReady();}.bind(this));}else{if(f){h=d.enabled!==false&&d.enabled!=="false";}if(h){this._attachPressEvent(e,d,S);}this._fireActionReady();}};c.prototype._processAction=function(s,d,p){var h=this._getHostInstance(),e=this.getCard(),u=d.url;if(u){u=B.resolveValue(u,s,p);}c.fireAction({card:e,host:h,action:d,parameters:B.resolveValue(d.parameters,s,p),source:s,url:u});};c.prototype._getHostInstance=function(){var d=this.getCard();if(d){return d.getHostInstance();}return null;};c.prototype.fireAction=function(s,t,p){var h=this._getHostInstance(),d=this.getCard(),e=this._extractActionConfigurations(d,p),E={card:d,host:h,action:{type:t},parameters:e,source:s};c.fireAction(E);};c.fireAction=function(m){var h=m.host,d=m.card,e=d.getAggregation("_extension"),f=m.action,p=m.parameters||{},g={type:f.type,card:d,actionSource:m.source,manifestParameters:p,parameters:p},i=d.fireAction(g);if(!i){return false;}if(h){i=h.fireAction(g);}if(!i){return false;}if(e){i=e.fireAction(g);}if(i){c._doPredefinedAction(m);}return i;};c._doPredefinedAction=function(m){var d=m.action,p=m.parameters,f,u,t;if(p){var P=p.url,s=p.target;}switch(d.type){case C.Navigation:if(d.service){break;}u=m.url||P;t=d.target||s||"_blank";if(u){c.openUrl(u,t);}break;case C.Custom:f=d.action;if(typeof f==="function"){f(m.card,m.source);}break;case C.Submit:if(m.source&&m.source.isA("sap.ui.integration.cards.BaseContent")){c.handleSubmitAction(m);}break;}};c.openUrl=function(u,t){o(u,t);};c.handleSubmitAction=function(m){var d,e=m.card,f=e._oDataProviderFactory,g=m.source,h=m.parameters;if(!h.configuration){return;}g.onActionSubmitStart(h);d=f.create({request:h.configuration});d.getData().then(function(r){g.onActionSubmitEnd(r,null);},function(E){L.error(E);g.onActionSubmitEnd(null,{error:E});}).finally(function(){f.remove(d);});};c.prototype._extractActionConfigurations=function(d,p){var r=d&&d.getManifestEntry("/sap.card/configuration/actionHandlers/submit"),e=p.data||{};if(!r){return p;}return{data:e,configuration:{"mode":r.mode||"cors","url":r.url,"method":r.method||"POST","parameters":Object.assign({},e,r.parameters),"headers":r.headers,"xhrFields":{"withCredentials":!!r.withCredentials}}};};return c;});
