//@ui5-bundle sap/ui/mdc/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/ActionToolbar',["sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator"],function(O,a,T,b){"use strict";
var A=O.extend("sap.ui.mdc.ActionToolbar",{
metadata:{library:"sap.ui.mdc",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},
renderer:a
});
var _=["begin","between","actions","end"];
function c(t,s){var i=_.indexOf(s);if(i>=0&&t._oSpacer){return i;}return-1;}
function d(t,o){t._editctx=true;var r=t.addContent(o);t._editctx=false;return r;}
function e(t,o,i){t._editctx=true;var r=t.insertContent(o,i);t._editctx=false;return r;}
function f(t,o){t._editctx=true;var r=t.removeContent(o);t._editctx=false;return r;}
function g(t){t._editctx=true;var r=t.destroyContent();t._editctx=false;return r;}
function h(t,s){if(s==="content"&&!t._editctx){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+t.getId()+"' must not be used.");}}
A.prototype.init=function(){this._oTitleSeparator=new b({visible:false});this._oSpacer=new T();this._oActionSeparator=new b({visible:false});if(O.prototype.init){O.prototype.init.apply(this,arguments);}d(this,this._oTitleSeparator);d(this,this._oSpacer);d(this,this._oActionSeparator);this.setUseAsHeader(true);};
A.prototype.exit=function(){this._oSpacer=null;this._oTitleSeparator=null;this._oActionSeparator=null;g(this);if(O.prototype.exit){O.prototype.exit.apply(this,arguments);}};
A.prototype._getState=function(s){var i=c(this,s);if(i>=0){return{aggIdx:i,sepIdcs:[this.indexOfContent(this._oTitleSeparator),this.indexOfContent(this._oSpacer),this.indexOfContent(this._oActionSeparator)]};}return null;};
A.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);this._updateSeparator();};
A.prototype._onContentPropertyChangedOverflowToolbar=function(E){if(this._bIsBeingDestroyed){return;}O.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(E.getParameter("name")==="visible"||E.getParameter("name")==="width"&&E.getSource()!=this._oTitleSeparator){this._updateSeparator();}};
A.prototype._updateSeparator=function(){if(this._oTitleSeparator&&!this._editctx){var H=function(k){return k?k.some(function(C){var l=C.getWidth?C.getWidth()!=="0px":true;return C.getVisible()&&l;}):false;};var i=H(this.getBegin());var j=H(this.getBetween());this._oTitleSeparator.setVisible(i&&j);}};
A.prototype.setUseAsHeader=function(H){this.setProperty("useAsHeader",H,true);this.toggleStyleClass("sapMTBHeader-CTX",!!H);return this;};
A.prototype.indexOfAggregation=function(s,o){var i=this._getState(s);if(i){var I=this.indexOfContent(o);if(I<0){return-1;}var p=i.aggIdx==0?-1:i.sepIdcs[i.aggIdx-1];var n=i.aggIdx==3?this.getContent().length:i.sepIdcs[i.aggIdx];if(I<p||I>n){return-1;}return I-p-1;}return O.prototype.indexOfAggregation.apply(this,arguments);};
A.prototype.getAggregation=function(s){var i=this._getState(s);if(i){var C=this.getContent();return C.slice(i.aggIdx===0?0:(i.sepIdcs[i.aggIdx-1]+1),i.aggIdx>=i.sepIdcs.length?C.length:i.sepIdcs[i.aggIdx]);}return O.prototype.getAggregation.apply(this,arguments);};
A.prototype.addAggregation=function(s,o){var i=this._getState(s);if(i){if(!o){return this;}var I=this.indexOfContent(o);if(I>=0){f(this,o);this.addAggregation(s,o);}else{e(this,o,i.aggIdx>=i.sepIdcs.length?this.getContent().length:i.sepIdcs[i.aggIdx]);}this._updateSeparator();return this;}h(this,s);return O.prototype.addAggregation.apply(this,arguments);};
A.prototype.insertAggregation=function(s,o,i){var I=this._getState(s);if(I){if(!o){return this;}var j=this.indexOfContent(o);if(j>=0){j=this.indexOfAggregation(s,o);if(j>=0&&i>j){i--;}f(this,o);this.insertAggregation(s,o,i);}else{var l=this.getAggregation(s).length;if(i<0){j=0;}else if(i>l){j=l;}else{j=i;}var p=I.aggIdx==0?-1:I.sepIdcs[I.aggIdx-1];e(this,o,j+p+1);}this._updateSeparator();return this;}h(this,s);return O.prototype.insertAggregation.apply(this,arguments);};
A.prototype.removeAggregation=function(s,o){if(c(this,s)>=0){var r=f(this,o);this._updateSeparator();return r;}h(this,s);return O.prototype.removeAggregation.apply(this,arguments);};
A.prototype.removeAllAggregation=function(s){if(c(this,s)>=0){var C=this.getAggregation(s);for(var i=0;i<C.length;i++){this.removeAggregation(s,C[i]);}this._updateSeparator();return C;}h(this,s);return O.prototype.removeAllAggregation.apply(this,arguments);};
A.prototype.destroyAggregation=function(s){if(c(this,s)>=0){var C=this.removeAllAggregation(s);for(var i=0;i<C.length;i++){C[i].destroy();}this._updateSeparator();return this;}h(this,s);return O.prototype.destroyAggregation.apply(this,arguments);};
A.prototype.propagateProperties=function(){var C=this.getContent();for(var i=0;i<C.length;i++){if(C[i].aAPIParentInfos){C[i].__aAPIParentInfos=C[i].aAPIParentInfos;C[i].aAPIParentInfos=null;}}var r=O.prototype.propagateProperties.apply(this,arguments);for(var i=0;i<C.length;i++){if(C[i].__aAPIParentInfos){C[i].aAPIParentInfos=C[i].__aAPIParentInfos;C[i].__aAPIParentInfos=null;}}return r;};
return A;},true);
sap.ui.predefine('sap/ui/mdc/Delegate',[],function(){"use strict";var D=function(){};
D.retrieveAllMetadata=function(m,d){return[];};
D.retrieveAggregationItem=function(a,m){return null;};
D.preConfiguration=function(n,v){return n;};
D.getNavigationTargets=function(f){return[];};
return D;});
sap.ui.predefine('sap/ui/mdc/FilterBar',["sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer",'sap/m/library','sap/m/Button',"sap/ui/mdc/p13n/StateUtil","sap/base/util/merge","sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],function(F,a,b,c,l,B,S,m,A){"use strict";
var d=b.extend("sap.ui.mdc.FilterBar",{
metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},p13nMode:{type:"sap.ui.mdc.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false},_p13nModeValue:{type:"boolean",visibility:"hidden",defaultValue:false}}},
renderer:c
});
var e=l.ButtonType;
d.prototype._createInnerLayout=function(){this._cLayoutItem=a;this._oFilterBarLayout=new F();this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons();};
d.prototype.setP13nMode=function(M){var o=this.getP13nMode();this.setProperty("p13nMode",M||[],false);M&&M.forEach(function(s){if(!o||o.indexOf(s)<0){this._setP13nMode(s,true);}}.bind(this));o&&o.forEach(function(s){if(!M||M.indexOf(s)<0){this._setP13nMode(s,false);}}.bind(this));return this;};
d.prototype._setP13nMode=function(M,v){switch(M){case"Item":this._setP13nModeItem(v);break;case"Value":this._setP13nModeValue(v);break;}};
d.prototype.setFilterConditions=function(v,s){S.checkConditionOperatorSanity(v);if(this._oP13nFB){this._oP13nFB.setFilterConditions(m({},v));}this.setProperty("filterConditions",v,s);return this;};
d.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem");};
d.prototype._setP13nModeItem=function(v){this._oModel.setProperty("/_p13nModeItem",v,true);};
d.prototype._getP13nModeValue=function(){return this._oModel.getProperty("/_p13nModeValue");};
d.prototype._setP13nModeValue=function(v){this._oModel.setProperty("/_p13nModeValue",v,false);this._bPersistValues=v;};
d.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new B(this.getId()+"-btnAdapt",{type:e.Transparent,text:"{"+b.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setModel(this._oModel,b.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:'/showAdaptFiltersButton',model:b.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:b.INNER_MODEL_NAME}],formatter:function(v,V){return v&&V;}});this._btnAdapt.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._oFilterBarLayout.addButton(this._btnAdapt);this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,b.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:'/showGoButton',model:b.INNER_MODEL_NAME},{path:"/liveMode",model:b.INNER_MODEL_NAME}],formatter:function(v,V){return v&&((this._isPhone())?true:!V);}.bind(this)});this._oFilterBarLayout.addButton(this._btnSearch);}};
d.prototype.retrieveInbuiltFilter=function(){var i=b.prototype.retrieveInbuiltFilter.apply(this,arguments);return i.then(function(I){I._bPersistValues=this._bPersistValues;return I;}.bind(this));};
d.prototype.onAdaptFilters=function(E){return this._oMetadataAppliedPromise.then(function(){return this.retrieveAdaptationController().then(function(o){return o.showP13n(this._btnAdapt,"Filter");}.bind(this));}.bind(this));};
d.prototype.getCurrentState=function(){var s=b.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete s.items;}return s;};
return d;});
sap.ui.predefine('sap/ui/mdc/FilterBarDelegate',["sap/ui/mdc/AggregationBaseDelegate"],function(A){"use strict";var F=Object.assign({},A);
F.addItem=function(p,f,P){return Promise.resolve(null);};
F.removeItem=function(p,f,P){return Promise.resolve(true);};
return F;});
sap.ui.predefine('sap/ui/mdc/Link',["sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library"],function(F,q,B,J,L,S,P,a,b,C,l){"use strict";var R=l.form.SimpleFormLayout.ResponsiveGridLayout;
var c=F.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});
c.prototype.applySettings=function(){F.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};
c.prototype.init=function(){var m=new J({contentTitle:undefined,linkItems:[]});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._bLinkItemsFetched=false;this._aLinkItems=[];this._oLinkType=null;F.prototype.init.apply(this,arguments);};
c.prototype.isTriggerable=function(){return this.retrieveLinkType().then(function(o){var r=o.runtimeType;var i=o.initialType?o.initialType:o;if(r&&r instanceof Promise){r.then(function(d){if(!this._oLinkType||d.linkType!==this._oLinkType.linkType){this._oLinkType=d;this.fireDataUpdate();}}.bind(this));}return this._oLinkType?this._oLinkType.type>0:i.type>0;}.bind(this));};
c.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(function(o){return o?o.href:null;});};
c.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(function(d){this.addDependent(d);return d?{target:d.getTarget(),href:d.getHref()}:null;}.bind(this));};
c.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(function(o){if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink;}var d=o.initialType?o.initialType:o;if(this._linkTypeHasDirectLink(d)){return d.directLink;}return null;}.bind(this));};
c.prototype._linkTypeHasDirectLink=function(o){return o&&o.type===1&&o.directLink;};
c.prototype.getContent=function(g){var o=this.retrieveLinkItems();var A=this.retrieveAdditionalContent();return Promise.all([o,A]).then(function(v){var d=v[0];var e=v[1];return new Promise(function(r){sap.ui.require(['sap/ui/fl/Utils','sap/ui/fl/apply/api/FlexRuntimeInfoAPI'],function(U,f){this._setConvertedLinkItems(d);var m=this._getInternalModel().getProperty("/linkItems");var M=this._getInternalModel().getProperty("/baselineLinkItems");var p=!e.length&&!m.length?this._getNoContent():e;var h=new P(this._createPanelId(U,f),{enablePersonalization:this.getEnablePersonalization(),items:M.map(function(i){return new a(i.key,{text:i.text,description:i.description,href:i.href,target:i.target,icon:i.icon,visible:true});}),additionalContent:p,beforeSelectionDialogOpen:function(){if(g&&g()){g().setModal(true);}},afterSelectionDialogClose:function(){if(g&&g()){g().setModal(false);}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});h.setModel(new J({metadata:q.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:q.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");return r(h);}.bind(this));}.bind(this));}.bind(this));};
c.prototype._setConvertedLinkItems=function(d){var m=this._getInternalModel();var M=d.map(function(o){if(!o.getKey()){S.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+o.getId()+". The mandatory 'key' property should be defined due to personalization reasons.");}return{key:o.getKey(),text:o.getText(),description:o.getDescription(),href:o.getHref(),target:o.getTarget(),icon:o.getIcon(),initiallyVisible:o.getInitiallyVisible(),visible:false};});m.setProperty("/linkItems/",M);var e=M.filter(function(o){return o.initiallyVisible;});m.setProperty("/baselineLinkItems/",e);};
c.prototype._getNoContent=function(){var s=new b({layout:R,content:[new C({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});s.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return s;};
c.prototype._createPanelId=function(U,d){var f;if(this.getParent()){f=this.getParent();}var o=sap.ui.getCore().byId(this.getSourceControl());if(!o){this.setSourceControl(f);o=f;}if(!d.isFlexSupported({element:this})||!d.isFlexSupported({element:o})){S.error("Invalid component. The mandatory 'sourceControl' association should be assigned to the app component due to personalization reasons.");return this.getId()+"-idInfoPanel";}var A=U.getAppComponentForControl(o)||U.getAppComponentForControl(f);return A.createId("idInfoPanel");};
c.retrieveAllMetadata=function(p){if(!p.getModel||!p.getModel("$sapuimdcLink")){return[];}var m=p.getModel("$sapuimdcLink");return m.getProperty("/metadata").map(function(M){return{id:M.key,text:M.text,description:M.description,href:M.href,target:M.target,visible:M.visible};});};
c.retrieveBaseline=function(p){if(!p.getModel||!p.getModel("$sapuimdcLink")){return[];}var m=p.getModel("$sapuimdcLink");return m.getProperty("/baseline").map(function(M){return{id:M.key,visible:true};});};
c.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog;}if(S.getLevel()>=S.Level.INFO){this._oInfoLog=new L();this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog;}}return undefined;};
c.prototype._getContextObject=function(o){return o?o.getObject(o.getPath()):undefined;};
c.prototype.retrieveAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());return this.getControlDelegate().fetchAdditionalContent(p,this).then(function(A){return A;});}.bind(this));}S.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([]);};
c.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());return this.getControlDelegate().fetchLinkType(p,this);}.bind(this));}S.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null);};
c.prototype.retrieveLinkItems=function(){var p=Object.assign({},this.getPayload());var o=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(function(u){return this.getControlDelegate().modifyLinkItems(p,o,u).then(function(d){return d;});}.bind(this));};
c.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems);}else{this.oUseDelegateItemsPromise=this._useDelegateItems();return this.oUseDelegateItemsPromise.then(function(){return Promise.resolve(this._aLinkItems);}.bind(this));}};
c.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());var o=this._getControlBindingContext();var i=this._getInfoLog();return new Promise(function(r){this.getControlDelegate().fetchLinkItems(p,o,i).then(function(d){this._setLinkItems(d===null?[]:d);this._bLinkItemsFetched=d!==null;r();}.bind(this));}.bind(this));}.bind(this));}S.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve();};
c.prototype._setLinkItems=function(d){var e=d.filter(function(o){return o.getParent()===null;});e.forEach(function(o){this.addDependent(o);}.bind(this));this._aLinkItems=d;};
c.prototype._beforeNavigationCallback=function(e){if(this.awaitControlDelegate()){var p=Object.assign({},this.getPayload());return this.getControlDelegate().beforeNavigationCallback(p,e);}S.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve();};
c.prototype._getControlBindingContext=function(){var o=sap.ui.getCore().byId(this.getSourceControl());return o&&o.getBindingContext()||this.getBindingContext();};
c.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink");};
return c;});
sap.ui.predefine('sap/ui/mdc/LinkDelegate',['sap/ui/mdc/BaseDelegate'],function(B){"use strict";var L=Object.assign({},B,{fetchLinkItems:function(p,b,i){return Promise.resolve(null);},fetchLinkType:function(p,l){return Promise.resolve({initialType:{type:2,directLink:undefined},runtimeType:null});},fetchAdditionalContent:function(p,l){return Promise.resolve([]);},modifyLinkItems:function(p,b,l){return Promise.resolve(l);},beforeNavigationCallback:function(p,e){return Promise.resolve(true);}});return L;},true);
sap.ui.predefine('sap/ui/mdc/Table',["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/V4AnalyticsTableType","./table/ResponsiveTableType","./table/PropertyHelper","./mixin/FilterIntegrationMixin","./library","sap/m/Text","sap/m/Title","sap/m/ColumnHeaderPopover","sap/m/ColumnPopoverSortItem","sap/m/OverflowToolbar","sap/m/library","sap/ui/core/Core","sap/ui/core/format/NumberFormat","sap/ui/core/dnd/DragDropInfo","sap/ui/core/Item","sap/ui/core/format/ListFormat","sap/ui/events/KeyCodes","sap/ui/model/Sorter","sap/ui/dom/containsOrEquals","sap/base/strings/capitalize","sap/base/util/deepEqual"],function(C,A,T,G,V,R,P,F,l,a,b,c,d,O,M,e,N,D,I,L,K,S,f,g,h){"use strict";var i=l.SelectionMode;var j=l.TableType;var k=l.RowAction;var m=M.ToolbarDesign;var s="sap.ui.mdc.IFilter";var n=new window.WeakMap();var o=function(B){if(!n.has(B)){n.set(B,{oFilterInfoBar:null});}return n.get(B);};
function p(B,E){sap.ui.require(["sap/m/MessageToast"],function(H){var J=e.getLibraryResourceBundle("sap.ui.mdc");H.show(J.getText(B,E));});}
var q=C.extend("sap.ui.mdc.Table",{
library:"sap.ui.mdc",
metadata:{designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},rowAction:{type:"sap.ui.mdc.RowAction[]",defaultValue:[]},p13nMode:{type:"sap.ui.mdc.TableP13nMode[]",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.Auto},rowsBindingInfo:{type:"object",defaultValue:null},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},header:{type:"string",group:"Misc",defaultValue:null},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},selectionMode:{type:"sap.ui.mdc.SelectionMode",defaultValue:i.None},showRowCount:{type:"boolean",group:"Misc",defaultValue:true},threshold:{type:"int",group:"Appearance",defaultValue:-1},noDataText:{type:"string"},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},enableExport:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false}},associations:{filter:{type:s,multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{bindingContext:{type:"sap.ui.model.Context"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},beforeExport:{parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"}}},paste:{parameters:{data:{type:"string[][]"}}}}},
constructor:function(){this._oTableReady=new Promise(this._resolveTable.bind(this));this._oAdaptationController=null;C.apply(this,arguments);this.bCreated=true;this._doOneTimeOperations();this._initializeContent();},
renderer:{apiVersion:2,render:function(B,E){B.openStart("div",E);B.class("sapUiMdcTable");B.style("height",E.getHeight());B.style("width",E.getWidth());B.openEnd();B.renderControl(E.getAggregation("_content"));B.close("div");}}
});
var t=["variant","quickFilter"];F.call(q.prototype);t.forEach(function(B){var E=g(B),H="_o"+E,J="get"+E,Q="set"+E,U="destroy"+E;q.prototype[J]=function(){return this[H];};q.prototype[U]=function(){var W=this[H];this[Q]();if(W){W.destroy();}return this;};q.prototype[Q]=function(W){this.validateAggregation(B,W,false);var X=this._createToolbar(),Y=W!==this[H];if(!W||Y){X.removeBetween((this[J]()));this[H]=W;}if(Y&&W){this._setToolbarBetween(X);}return this;};});
q.prototype.init=function(){C.prototype.init.apply(this,arguments);this.mSkipPropagation={rowSettings:true};var B=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.setProperty("adaptationConfig",{itemConfig:{changeOperations:{add:"addColumn",remove:"removeColumn",move:"moveColumn"},adaptationUI:"sap/ui/mdc/p13n/panels/SelectionPanel",containerSettings:{title:B.getText("table.SETTINGS_COLUMN")}}});};
q.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};
q.prototype._setToolbarBetween=function(B){[this._oVariant,this._oQuickFilter].forEach(function(E){if(E){B.addBetween(E);}});};
q.prototype.initialized=function(){return this._oTableReady;};
q.prototype._resolveTable=function(B,E){this._fResolve=B;this._fReject=E;};
q.prototype._getStringType=function(B){var E,H=E=B||this.getType();if(!H){E=j.Table;}else if(typeof H==="object"){if(H.isA("sap.ui.mdc.table.ResponsiveTableType")){E=j.ResponsiveTable;}else if(H.isA("sap.ui.mdc.table.V4AnalyticsTableType")){E="V4AnalyticsTable";}else{E=j.Table;}}return E;};
q.prototype._updateTypeSettings=function(){var B=this.getType();if(B&&typeof B==="object"){B.updateTableSettings();}else{if(B==="ResponsiveTable"){B=R;}else if(B==="V4AnalyticsTable"){B=V;}else{B=G;}B.updateDefault(this._oTable);}};
q.prototype.scrollToIndex=function(B){if(!this._oTable||(typeof B!=="number")){return;}if(this._getStringType()===j.ResponsiveTable){this._oTable.scrollToIndex(B);}else{if(B===-1){B=this.getRowBinding()?this.getRowBinding().getLength():0;}this._oTable.setFirstVisibleRow(B);}};
q.prototype.setType=function(B){var E=this._getStringType(B);var H=this._getStringType();this.setAggregation("type",B,true);if(E===H&&this._oTable){this._updateTypeSettings();return this;}if(this.bCreated){if(this._oTable){if(H==="ResponsiveTable"){this._oTable.setHeaderToolbar();}else{this._oTable.removeExtension(this._oToolbar);}this._oTable.destroy("KeepDom");this._oTable=null;this._bTableExists=false;}else{this._onAfterTableCreated();}if(this._oTemplate){this._oTemplate.destroy();this._oTemplate=null;}this._oTableReady=new Promise(this._resolveTable.bind(this));this._initializeContent();}return this;};
q.prototype.setRowSettings=function(B){var E=this._getStringType();this.setAggregation("rowSettings",B,true);if(this._oTable){if(E==="ResponsiveTable"){R.updateRowSettings(this._oTemplate,B);this.checkAndRebind();}else{G.updateRowSettings(this._oTable,B);}}return this;};
q.prototype.setHeaderLevel=function(B){if(this.getHeaderLevel()===B){return this;}this.setProperty("headerLevel",B,true);this._oTitle&&this._oTitle.setLevel(B);return this;};
q.prototype.focus=function(B){var E=this.getDomRef();if(this._oTable&&E&&!f(E,document.activeElement)){this._oTable.focus();}};
q.prototype.setBusy=function(B){this.setProperty('busy',B,true);if(this._oTable){this._oTable.setBusy(B);}return this;};
q.prototype.setBusyIndicatorDelay=function(B){this.setProperty('busyIndicatorDelay',B,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(B);}return this;};
q.prototype.setSelectionMode=function(B){var E=this.getSelectionMode();this.setProperty("selectionMode",B,true);if(this._oTable&&E!=this.getSelectionMode()){this._updateSelectionBehavior();}return this;};
q.prototype.setRowAction=function(B){var E=this.getRowAction();this.setProperty("rowAction",B,true);if(!h(E.sort(),this.getRowAction().sort())){this._updateRowAction();}return this;};
q.prototype.setCreationRow=function(B){this.setAggregation("creationRow",B,true);if(B){B.update();}return this;};
q.prototype.setP13nMode=function(B){var E=this.getP13nMode();this.setProperty("p13nMode",B,true);if(!h(E.sort(),this.getP13nMode().sort())){u(this);}return this;};
function u(B){if(B._oToolbar){B._oToolbar.destroyEnd();B._getP13nButtons().forEach(function(H){B._oToolbar.addEnd(H);});}if(B._oTable){var E=B._oTable.getDragDropConfig()[0];if(E){E.setEnabled(B.getP13nMode().indexOf("Column")>-1);}}if(B.isFilteringEnabled()){v(B);}r(B);}
q.prototype.setFilterConditions=function(B){this.setProperty("filterConditions",B,true);var E=this.getInbuiltFilter();if(E){E.setFilterConditions(B);}r(this);return this;};
function r(B){var E=x(B);var H=y(B);var J=z(B);if(!E){return;}if(J.length===0||!B.isFilteringEnabled()){var Q=E.getDomRef();if(Q&&Q.contains(document.activeElement)){B.focus();}E.setVisible(false);return;}B.awaitPropertyHelper().then(function(U){var W=J.map(function($){return U.getLabel($);});var X=e.getLibraryResourceBundle("sap.ui.mdc");var Y=L.getInstance();var Z=X.getText("table.FILTER_INFO",Y.format(W));E.setVisible(true);H.setText(Z);});}
function v(B){if(!B._oTable){return;}var E=x(B);if(!E){E=w(B);}if(B._bMobileTable){if(B._oTable.getInfoToolbar()!==E){B._oTable.setInfoToolbar(E);B._oTable.addAriaLabelledBy(y(B));}}else if(B._oTable.indexOfExtension(E)===-1){B._oTable.insertExtension(E,1);B._oTable.addAriaLabelledBy(y(B));}}
function w(B){var E=B.getId()+"-filterInfoBar";var H=o(B).oFilterInfoBar;if(H&&!H.bIsDestroyed){H.destroy();}H=new O({id:E,active:true,design:m.Info,visible:false,content:[new a({id:E+"-text",wrapping:false})],press:function(){T.showPanel(B,"Filter",H);}});H.focus=function(){if(this.getDomRef()){O.prototype.focus.apply(this,arguments);}else{B.focus();}};o(B).oFilterInfoBar=H;r(B);return H;}
function x(B){var E=o(B).oFilterInfoBar;if(E&&(E.bIsDestroyed||E.bIsBeingDestroyed)){return null;}return o(B).oFilterInfoBar;}
function y(B){var E=x(B);return E?E.getContent()[0]:null;}
q.prototype.setThreshold=function(B){this.setProperty("threshold",B,true);if(!this._oTable){return this;}B=this.getThreshold()>-1?this.getThreshold():undefined;if(this._bMobileTable){this._oTable.setGrowingThreshold(B);}else{this._oTable.setThreshold(B);}return this;};
q.prototype._onFilterProvided=function(){this._updateInnerTableNoDataText();};
q.prototype.setNoDataText=function(B){this.setProperty("noDataText",B,true);this._updateInnerTableNoDataText();return this;};
q.prototype._updateInnerTableNoDataText=function(){if(!this._oTable){return;}var B=this._getNoDataText();if(this._bMobileTable){this._oTable.setNoDataText(B);}else{this._oTable.setNoData(B);}};
q.prototype._getNoDataText=function(){var B=this.getNoDataText();if(B){return B;}var E=e.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){if(this.getFilter()){return E.getText("table.NO_DATA_WITH_FILTERBAR");}return E.getText("table.NO_DATA");}return E.getText("table.NO_RESULTS");};
q.prototype._updateRowAction=function(){if(!this._oTable){return;}var B=this.getRowAction().indexOf(k.Navigation)>-1;var E=this._bMobileTable?R:G;E.updateRowAction(this,B,this._bMobileTable?undefined:this._onRowActionPress);};
q.prototype._initializeContent=function(){var B,E=this._getStringType();if(E==="ResponsiveTable"){B=R;}else if(E==="V4AnalyticsTable"){B=V;}else{B=G;}Promise.all([this.awaitControlDelegate(),B.loadTableModules(),this.retrieveAdaptationController()]).then(function(){if(this.bIsDestroyed){return;}if(!this._bTableExists&&E===this._getStringType()){this._bMobileTable=E==="ResponsiveTable";this._createContent();this._bTableExists=true;}}.bind(this));};
q.prototype._doOneTimeOperations=function(){if(!this.bColumnsOrdered){this.bColumnsOrdered=true;this._orderColumns();}};
q.prototype._onAfterTableCreated=function(B){if(B&&this._fResolve){this._fResolve(this);}else if(this._fReject){this._fReject(this);}delete this._fResolve;delete this._fReject;};
q.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateRowAction();var B=this.getColumns();B.forEach(this._insertInnerColumn,this);this.setAggregation("_content",this._oTable);this._onAfterTableCreated(true);this.initialized().then(function(){this.initPropertyHelper(P);var E=this.getCreationRow();if(E){E.update();}if(this.getAutoBindOnInit()){this.checkAndRebind();}}.bind(this));};
q.prototype.setHeader=function(B){this.setProperty("header",B,true);this._updateHeaderText();this._updateExportState(true);return this;};
q.prototype.setHeaderVisible=function(B){this.setProperty("headerVisible",B,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px");}return this;};
q.prototype.setEnableExport=function(E){if(E!==this.getEnableExport()){this.setProperty("enableExport",E,true);if(E&&!this._oExportButton&&this._oToolbar){this._oToolbar.addEnd(this._getExportButton());}else if(this._oExportButton){this._oExportButton.setVisible(E);}}return this;};
q.prototype._createToolbar=function(){if(!this._oToolbar){this._oTitle=new b(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel()});this._oToolbar=new A(this.getId()+"-toolbar",{design:"Transparent",begin:[this._oTitle],end:[this._getP13nButtons(),this._getExportButton()]});}return this._oToolbar;};
q.prototype._getVisibleProperties=function(){var B=[],E;this.getColumns().forEach(function(H,J){E=H&&H.getDataProperty();if(E){B.push({name:E});}});return B;};
q.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[];};
q.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[];};
function z(B){var E=B.getFilterConditions();return Object.keys(E).filter(function(H){return E[H].length>0;});}
q.prototype.getCurrentState=function(){var B={};var E=this.getP13nMode();if(E.indexOf("Column")>-1){B.items=this._getVisibleProperties();}if(this.isSortingEnabled()){B.sorters=this._getSortedProperties();}if(this.isFilteringEnabled()){B.filter=this.getFilterConditions();}return B;};
q.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1;};
q.prototype.retrieveInbuiltFilter=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return C.prototype.retrieveInbuiltFilter.call(this,this._registerInnerFilter,false).then(function(E){var H={adaptationUI:E,applyFilterChangeOn:E,initializeControl:E.createFilterFields,sortData:false,containerSettings:{title:B.getText("filter.PERSONALIZATION_DIALOG_TITLE")}};this.enhanceAdaptationConfig({filterConfig:H});return E;}.bind(this));};
q.prototype.isSortingEnabled=function(){return this.getP13nMode().indexOf("Sort")>-1;};
q.prototype._getP13nButtons=function(){var B=this.getP13nMode();var E=[];if(this.isSortingEnabled()){E.push(T.createSortButton(this.getId(),[this._showSort,this]));}if(this.isFilteringEnabled()){E.push(T.createFilterButton(this.getId(),[this._showFilter,this]));}if(B.indexOf("Column")>-1){E.push(T.createColumnsButton(this.getId(),[this._showSettings,this]));}return E;};
q.prototype._getExportButton=function(){if(!this.getEnableExport()){return null;}var B={fileName:this.getHeader()};if(!this._cachedExportSettings){this._cachedExportSettings=B;}if(!this._oExportButton){this._oExportButton=T.createExportButton(this.getId(),{"default":[function(){this._onExport(B);},this],"exportAs":[this._onExportAs,this]});}this._updateExportState();return this._oExportButton;};
q.prototype._updateExportState=function(U){var B=this._getRowBinding();if(this._oExportButton){this._oExportButton.setEnabled(!!(B&&B.getLength()>0));if(U&&this._cachedExportSettings){this._cachedExportSettings.fileName=this.getHeader();}}};
q.prototype._createExportColumnConfiguration=function(B){var E=B&&B.splitCells;var H=this.getColumns();return this.awaitPropertyHelper().then(function(J){var Q=[];H.forEach(function(U){var W=J.getColumnExportSettings(U,E);Q=Q.concat(W);},this);return[Q,J];}.bind(this));};
q.prototype._onExport=function(B){return this._createExportColumnConfiguration(B).then(function(E){var H=E[0];var J=E[1];if(!H||!H.length){sap.ui.require(["sap/m/MessageBox"],function(W){W.error(e.getLibraryResourceBundle("sap.ui.mdc").getText("table.NO_COLS_EXPORT"),{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":""});}.bind(this));return;}var Q=this._getRowBinding();var U={workbook:{columns:H},dataSource:Q,fileName:B?B.fileName:this.getHeader()};this._loadExportLibrary().then(function(){sap.ui.require(["sap/ui/export/ExportUtils","sap/ui/export/Spreadsheet"],function(W,X){var Y=Promise.resolve();if(B.includeFilterSettings){Y=W.parseFilterConfiguration(Q,function(Z){return J.getLabel(Z);}).then(function(Z){if(Z){U.workbook.context={metaSheetName:Z.name,metainfo:[Z]};}});}Y.then(function(){var Z={splitCells:false,includeFilterSettings:false};if(B){Z.splitCells=B.splitCells;Z.includeFilterSettings=B.includeFilterSettings;}var $=new X(U);$.attachBeforeExport(function(_){this.fireBeforeExport({exportSettings:_.getParameter("exportSettings"),userExportSettings:Z});},this);$.build().finally(function(){$.destroy();});}.bind(this));}.bind(this));}.bind(this));}.bind(this));};
q.prototype._onExportAs=function(){var B=this;this._loadExportLibrary().then(function(){sap.ui.require(['sap/ui/export/ExportUtils'],function(E){E.getExportSettingsViaDialog(B._cachedExportSettings,B).then(function(U){B._cachedExportSettings=U;B._onExport(U);});});});};
q.prototype._loadExportLibrary=function(){if(!this._oExportLibLoadPromise){this._oExportLibLoadPromise=e.loadLibrary("sap.ui.export",true);}return this._oExportLibLoadPromise;};
q.prototype.onkeydown=function(E){if(E.isMarked()){return;}if((E.metaKey||E.ctrlKey)&&E.shiftKey&&E.which===K.E){if(this.getEnableExport()&&this._oExportButton&&this._oExportButton.getEnabled()){this._onExportAs();E.setMarked();E.preventDefault();}}};
q.prototype._createTable=function(){var B=this.getThreshold()>-1?this.getThreshold():undefined;var E=this.getRowSettings()?this.getRowSettings().getAllSettings():{};if(this._bMobileTable){this._oTable=R.createTable(this.getId()+"-innerTable",{autoPopinMode:true,growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],selectionChange:[this._onSelectionChange,this],growingThreshold:B,noDataText:this._getNoDataText(),headerToolbar:this._oToolbar,ariaLabelledBy:[this._oTitle]});this._oTemplate=R.createTemplate(this.getId()+"-innerTableRow",E);this._createColumn=q.prototype._createMobileColumn;this._sAggregation="items";this._oTable.bindRows=this._oTable.bindItems;this._oTable.bActiveHeaders=true;this._oTable.attachEvent("columnPress",this._onResponsiveTableColumnPress,this);}else{this._oTable=G.createTable(this.getId()+"-innerTable",{enableBusyIndicator:true,enableColumnReordering:false,threshold:B,cellClick:[this._onCellClick,this],noData:this._getNoDataText(),extension:[this._oToolbar],ariaLabelledBy:[this._oTitle],plugins:[G.createMultiSelectionPlugin(this,[this._onRowSelectionChange,this])],columnSelect:[this._onGridTableColumnPress,this],rowSettingsTemplate:E});this._createColumn=q.prototype._createColumn;this._sAggregation="rows";}this._updateTypeSettings();this._updateSelectionBehavior();var H=new D({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",enabled:this.getP13nMode().indexOf("Column")>-1,drop:[this._onColumnRearrange,this]});H.bIgnoreMetadataCheck=true;this._oTable.addDragDropConfig(H);this._oTable.setBusyIndicatorDelay(this.getBusyIndicatorDelay());this._oTable.attachPaste(this._onInnerTablePaste,this);if(this.isFilteringEnabled()){v(this);}};
q.prototype._updateSelectionBehavior=function(){var B=this._bMobileTable?R:G;B.updateSelection(this);};
q.prototype._onColumnRearrange=function(E){var B=E.getParameter("draggedControl");var H=E.getParameter("droppedControl");if(B===H){return;}var J=E.getParameter("dropPosition");var Q=this._oTable.indexOfColumn(B);var U=this._oTable.indexOfColumn(H);var W=U+(J=="Before"?0:1)+(Q<U?-1:0);T.moveColumn(this,Q,W);};
q.prototype._onColumnPress=function(B){if(!this.isSortingEnabled()){return;}var E,H=B.getParent(),J;E=H.indexOfColumn(B);J=this.getColumns()[E];this.awaitPropertyHelper().then(function(Q){var U=Q.getSortableProperties(J.getDataProperty());if(!U||!U.length){return;}var W,X=[];U.forEach(function(Y){W=new I({text:Q.getName(Y),key:Q.getName(Y)});X.push(W);});if(X.length>0){if(this._oPopover){this._oPopover.destroy();}this._oPopover=new c({items:[new d({items:X,sort:[this._onCustomSort,this]})]});this._oPopover.openBy(B);B.addDependent(this._oPopover);}}.bind(this));};
q.prototype._onCustomSort=function(E){var B=E.getParameter("property");T.createSort(this,B,true);};
q.prototype._insertInnerColumn=function(B,E){if(!this._oTable){return;}var H=this._createColumn(B);this._setColumnTemplate(B,H,E);if(E===undefined){this._oTable.addColumn(H);}else{this._oTable.insertColumn(H,E);}};
q.prototype._orderColumns=function(){var B,E=[],H=this.getColumns();H.forEach(function(J){B=J.getInitialIndex();if(B>-1){E.push({index:B,column:this.removeColumn(J)});}},this);E.sort(function(J,Q){return J-Q;});E.forEach(function(J){this.insertColumn(J.column,J.index);},this);};
q.prototype._setColumnTemplate=function(B,E,H){var J=B.getTemplate(true),Q;if(!this._bMobileTable){Q=B.getCreationTemplate(true);[J,Q].forEach(function(U){if(!U){return;}if(U.setWrapping){U.setWrapping(false);}if(U.setRenderWhitespace){U.setRenderWhitespace(false);}});E.setTemplate(J);E.setCreationTemplate(Q);}else if(H>=0){this._oTemplate.insertCell(J,H);}else{this._oTemplate.addCell(J);}};
q.prototype._createColumn=function(B){return G.createColumn(B.getId()+"-innerColumn",{width:B.getWidth(),minWidth:Math.round(B.getMinWidth()*parseFloat(M.BaseFontSize)),hAlign:B.getHAlign(),label:B.getColumnHeaderControl(this._bMobileTable)});};
q.prototype._createMobileColumn=function(B){return R.createColumn(B.getId()+"-innerColumn",{width:B.getWidth(),autoPopinWidth:B.getMinWidth(),hAlign:B.getHAlign(),header:B.getColumnHeaderControl(this._bMobileTable),importance:B.getImportance(),popinDisplay:"Inline"});};
q.prototype.moveColumn=function(B,E){var H;this.removeAggregation("columns",B,true);this.insertAggregation("columns",B,E,true);if(this._oTable){H=this._oTable.removeColumn(B.getId()+"-innerColumn");this._oTable.insertColumn(H,E);if(this._bMobileTable){this._updateColumnTemplate(B,E);}}};
q.prototype.removeColumn=function(B){B=this.removeAggregation("columns",B,true);if(this._oTable){var E=this._oTable.removeColumn(B.getId()+"-innerColumn");E.destroy();if(this._bMobileTable){this._updateColumnTemplate(B,-1);}}return B;};
q.prototype.addColumn=function(B){this.addAggregation("columns",B,true);this._insertInnerColumn(B);return this;};
q.prototype.insertColumn=function(B,E){this.insertAggregation("columns",B,E,true);this._insertInnerColumn(B,E);return this;};
q.prototype._updateColumnTemplate=function(B,E){var H,J;if(this._oTemplate){H=B.getTemplate(true);J=this._oTemplate.indexOfCell(H);q._removeItemCell(this._oTemplate,J,E);}if(J>-1){this._oTable.getItems().forEach(function(Q){if(Q.removeCell){q._removeItemCell(Q,J,E);}});}};
q._removeItemCell=function(B,E,H){var J=B.removeCell(E);if(J){if(H>-1){B.insertCell(J,H);}else{J.destroy();}}};
q.prototype._onItemPress=function(E){this.fireRowPress({bindingContext:E.getParameter("listItem").getBindingContext()});};
q.prototype._onSelectionChange=function(E){var B=E.getParameter("selectAll");this.fireSelectionChange({bindingContext:E.getParameter("listItem").getBindingContext(),selected:E.getParameter("selected"),selectAll:B});if(B){var H=this.getRowBinding();if(H&&this._oTable){var J=H.getLength();var Q=this._oTable.getItems().length;var U=H.isLengthFinal();if(Q!=J||!U){p("table.SELECTION_LIMIT_MESSAGE",[Q]);}}}};
q.prototype._onResponsiveTableColumnPress=function(E){this._onColumnPress(E.getParameter("column"));};
q.prototype._onCellClick=function(E){this.fireRowPress({bindingContext:E.getParameter("rowBindingContext")});};
q.prototype._onRowActionPress=function(E){var B=E.getParameter("row");this.fireRowPress({bindingContext:B.getBindingContext()});};
q.prototype._onRowSelectionChange=function(E){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({bindingContext:E.getParameter("rowContext"),selected:E.getSource().isIndexSelected(E.getParameter("rowIndex")),selectAll:E.getParameter("selectAll")});}};
q.prototype._onGridTableColumnPress=function(E){E.preventDefault();this._onColumnPress(E.getParameter("column"));};
q.prototype.getSelectedContexts=function(){if(this._oTable){if(this._bMobileTable){return this._oTable.getSelectedContexts();}var B=this._oTable.getPlugins()[0].getSelectedIndices();return B.map(function(E){return this._oTable.getContextByIndex(E);},this);}return[];};
q.prototype.clearSelection=function(){if(this._oTable){if(this._bMobileTable){this._oTable.removeSelections(true);}else{this._bSelectionChangedByAPI=true;this._oTable.getPlugins()[0].clearSelection();this._bSelectionChangedByAPI=false;}}};
q.prototype._registerInnerFilter=function(B){B.attachSearch(this.rebind,this);};
q.prototype._onFiltersChanged=function(E){if(this.isTableBound()&&E.getParameter("conditionsBased")){this._oTable.setShowOverlay(true);}};
q.prototype.isTableBound=function(){return this._oTable?this._oTable.isBound(this._bMobileTable?"items":"rows"):false;};
q.prototype.bindRows=function(B){if(!this.bDelegateInitialized||!this._oTable){return;}this.getControlDelegate().updateBindingInfo(this,this.getPayload(),B);if(B&&B.path){this._oTable.setShowOverlay(false);if(this._bMobileTable&&this._oTemplate){B.template=this._oTemplate;}else{delete B.template;}if(!B.parameters){B.parameters={};}B.sorter=this._getSorters();if(this.getShowRowCount()){q._addBindingListener(B,"dataReceived",this._onDataReceived.bind(this));q._addBindingListener(B,"change",this._updateHeaderText.bind(this));}this._updateColumnsBeforeBinding(B);this.getControlDelegate().rebindTable(this,B);this._updateInnerTableNoDataText();}return this;};
q.prototype._onDataReceived=function(E){if(E&&E.getParameter&&E.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._updateHeaderText();this._updateExportState();};
q.prototype._updateHeaderText=function(){var H,B;if(this._oTitle&&this.getHeader()){H=this.getHeader();if(this.getShowRowCount()){B=this._getRowCount();if(B){H+=" ("+B+")";}}this._oTitle.setText(H);}};
q.prototype._updateColumnsBeforeBinding=function(B){var E=[].concat(B.sorter||[]);var H=this.getColumns();var J=this._bMobileTable;this.awaitPropertyHelper().then(function(Q){H.forEach(function(U){var W=e.byId(U.getId()+"-innerColumn");var X=Q.getSortableProperties(U.getDataProperty());var Y=X&&X.map(function(_){return Q.getPath(_);});if(Y){var Z=E.find(function(Z){return Y.indexOf(Z.sPath)>-1;});var $=Z&&Z.bDescending?"Descending":"Ascending";if(J){W.setSortIndicator(Z?$:"None");}else{W.setSorted(!!Z).setSortOrder($);}}});});};
q.prototype._getRowCount=function(){var B=this.getRowBinding(),E,H="";if(B){E=B.getLength();if(!this._oNumberFormatInstance){this._oNumberFormatInstance=N.getFloatInstance();}if(B.isLengthFinal()){H=this._oNumberFormatInstance.format(E);}}return H;};
q.prototype.getRowBinding=function(){return this._getRowBinding();};
q.prototype._getRowBinding=function(){if(this._oTable){return this._oTable.getBinding(this._sAggregation);}};
q._addBindingListener=function(B,E,H){if(!B.events){B.events={};}if(!B.events[E]){B.events[E]=H;}else{var J=B.events[E];B.events[E]=function(){H.apply(this,arguments);J.apply(this,arguments);};}};
q.prototype.rebindTable=function(){this.rebind();};
q.prototype.rebind=function(){if(this._bTableExists){this.bindRows(this.getRowsBindingInfo()||{});}else{this.initialized().then(this.rebind.bind(this));}};
q.prototype._showSettings=function(E){T.showPanel(this,"Columns",E.getSource());};
q.prototype._showSort=function(E){T.showPanel(this,"Sort",E.getSource());};
q.prototype._showFilter=function(E){T.showPanel(this,"Filter",E.getSource());};
q.prototype._getSorters=function(){var B=this.getSortConditions()?this.getSortConditions().sorters:[];var E=[];B.forEach(function(H){E.push(new S(H.name,H.descending));});return E;};
q.prototype._onInnerTablePaste=function(E){this.firePaste({data:E.getParameter("data")});};
q.prototype.exit=function(){if(this._oTemplate){this._oTemplate.destroy();}this._oTemplate=null;this._oTable=null;if(this._oToolbar&&!this._bTableExists){this._oToolbar.destroy();}this._oToolbar=null;this._oTitle=null;this._oNumberFormatInstance=null;t.forEach(function(B){var E=g(B),H="_o"+E;this[H]=null;},this);this._oTableReady=null;this._fReject=null;this._fResolve=null;C.prototype.exit.apply(this,arguments);};
return q;});
sap.ui.predefine('sap/ui/mdc/TableDelegate',["sap/ui/mdc/AggregationBaseDelegate","./table/Column","sap/m/Text",'sap/ui/core/Core','sap/ui/mdc/util/FilterUtil'],function(A,C,T,a,F){"use strict";var b=Object.assign(A,{addItem:function(p,t,P){if(t.getModel){return this._createColumn(p,t);}return Promise.resolve(null);},removeItem:function(p,t,P){return Promise.resolve(true);},updateBindingInfo:function(m,M,B){if(!m){return;}if(M&&B){B.path=B.path||M.collectionPath||"/"+M.collectionName;B.model=B.model||M.model;}if(!B){B={};}var f=a.byId(m.getFilter()),c=m.isFilteringEnabled(),d;var o=c?m:f;if(o){var p=c?[]:f.getPropertyInfoSet();d=o.getConditions();var e=F.getFilterInfo(o,d,p);B.filters=e.filters;}},rebindTable:function(m,r){if(m&&m._oTable&&r){m._oTable.bindRows(r);}},_createColumn:function(p,t){return this.fetchProperties(t).then(function(P){var o=P.find(function(c){return c.name===p;});if(!o){return null;}return this._createColumnTemplate(o).then(function(c){var d=this._getColumnInfo(o);d.template=c;return new C(t.getId()+"--"+o.name,d);}.bind(this));}.bind(this));},getFilterDelegate:function(){return{addFilterItem:function(p,t){return Promise.resolve(null);}};},_getColumnInfo:function(p){return{header:p.label,dataProperty:p.name,hAlign:p.align,width:p.width};},_getColumnTemplateInfo:function(p){return{text:{path:p.path||p.name},textAlign:p.align};},_createColumnTemplate:function(p){return Promise.resolve(new T(this._getColumnTemplateInfo(p)));}});return b;});
sap.ui.predefine('sap/ui/mdc/chart/ChartSettings',[],function(){"use strict";var C={showPanel:function(c,p,s,P){C["showP13n"+p](c,s);},showP13nChart:function(c,s){var a=c.getAdaptationController();a.showP13n(s,"Item");},showP13nSort:function(c,s){var a=c.getAdaptationController();a.showP13n(s,"Sort");}};return C;});
sap.ui.predefine('sap/ui/mdc/chart/ChartTypeButton',["sap/m/Button","sap/m/ButtonRenderer","sap/ui/base/ManagedObjectObserver"],function(B,a,M){"use strict";var R,L,b,S,c,I,D,r;
var C=B.extend("sap.ui.mdc.chart.ChartTypeButton",{
metadata:{library:"sap.ui.mdc"},
constructor:function(o){this.oChartModel=o.getManagedObjectModel();var s={type:"Transparent",press:function(e){this.displayChartTypes(e.getSource(),o);}.bind(this),id:o.getId()+"-btnChartType",icon:'{$chart>/getTypeInfo/icon}',tooltip:'{$chart>/getTypeInfo/text}'};this.oChart=o;B.apply(this,[s]);this.setModel(this.oChartModel,"$chart");this._oObserver=new M(function(){this.oChartModel.checkUpdate(true);}.bind(this));this._oObserver.observe(this.oChart,{aggregations:["items"],properties:["chartType"]});},
renderer:a.render
});
C.mMatchingIcon={"bar":"sap-icon://horizontal-bar-chart","bullet":"sap-icon://horizontal-bullet-chart","bubble":"sap-icon://bubble-chart","column":"sap-icon://vertical-bar-chart","combination":"sap-icon://business-objects-experience","dual_bar":"sap-icon://horizontal-bar-chart","dual_column":"sap-icon://vertical-bar-chart","dual_combination":"sap-icon://business-objects-experience","dual_horizontal_combination":"sap-icon://business-objects-experience","dual_horizontal_stacked_combination":"sap-icon://business-objects-experience","dual_line":"sap-icon://line-chart","dual_stacked_bar":"sap-icon://full-stacked-chart","dual_stacked_column":"sap-icon://vertical-stacked-chart","dual_stacked_combination":"sap-icon://business-objects-experience","donut":"sap-icon://donut-chart","heatmap":"sap-icon://heatmap-chart","horizontal_stacked_combination":"sap-icon://business-objects-experience","line":"sap-icon://line-chart","pie":"sap-icon://pie-chart","scatter":"sap-icon://scatter-chart","stacked_bar":"sap-icon://full-stacked-chart","stacked_column":"sap-icon://vertical-stacked-chart","stacked_combination":"sap-icon://business-objects-experience","treemap":"sap-icon://Chart-Tree-Map","vertical_bullet":"sap-icon://vertical-bullet-chart","100_dual_stacked_bar":"sap-icon://full-stacked-chart","100_dual_stacked_column":"sap-icon://vertical-stacked-chart","100_stacked_bar":"sap-icon://full-stacked-chart","100_stacked_column":"sap-icon://full-stacked-column-chart","waterfall":"sap-icon://vertical-waterfall-chart","horizontal_waterfall":"sap-icon://horizontal-waterfall-chart"};
C.prototype.displayChartTypes=function(o,d){if(!d||!o){return;}if(this.oPopover){return this.oPopover.openBy(o);}if(!this.oReadyPromise){this.oReadyPromise=new Promise(function(e){if(R){e(true);}else{sap.ui.require(["sap/m/ResponsivePopover","sap/m/List","sap/m/Bar","sap/m/SearchField","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/ui/Device"],function(f,g,h,i,j,k,l){R=f;L=g;b=h;S=i;c=j;I=k;D=l;if(!r){sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc",true).then(function(m){r=m;e(true);});}else{e(true);}});}});}this.oReadyPromise.then(function(){this.oPopover=this._createPopover(o,d);return this.oPopover.openBy(o);}.bind(this));};
C.prototype._createPopover=function(o,d){var i=new c({title:"{$chart>text}",icon:"{$chart>icon}",selected:"{$chart>selected}"});var l=new L({mode:"SingleSelectMaster",items:{path:"$chart>/getAvailableChartTypes",template:i},selectionChange:function(E){if(E&&E.mParameters&&E.mParameters.listItem){var g=E.mParameters.listItem.getBinding("title");if(g){var h=g.getContext();if(h){var O=h.getObject();if(O&&O.key){sap.ui.require(["sap/ui/mdc/p13n/FlexUtil","sap/ui/mdc/flexibility/Chart.flexibility"],function(F,j){var k=[];k.push(j["setChartType"].changeHandler.createChange({control:d,chartType:O.key}));F.handleChanges(k,d);});}}}}p.close();}});var s=new b();var e=new S({placeholder:r.getText("chart.CHART_TYPE_SEARCH")});e.attachLiveChange(function(E){this._triggerSearchInPopover(E,l);});s.addContentRight(e);var p=new R({placement:"Bottom",subHeader:s,contentWidth:"25rem"});p.setModel(this.oChartModel,"$chart");if(D.system.desktop){var f=new I({text:r.getText("chart.CHART_TYPELIST_TEXT")});p.setShowHeader(false);p.addContent(f);p.addAriaLabelledBy(f);}else{p.setTitle(r.getText("chart.CHART_TYPELIST_TEXT"));}p.addContent(l);if(l.getItems().length<7){s.setVisible(false);}return p;};
C.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this.oPopover){this.oPopover.destroy();this.oPopover=null;}};
return C;},true);
sap.ui.predefine('sap/ui/mdc/chart/MetadataDelegate',["sap/ui/mdc/Delegate"],function(B){"use strict";
var D=B.extend("sap.ui.mdc.chart.Delegate",{
retrieveAllMetadata:function(){return{};},
retrieveAggregationItem:function(a,p){return null;},
preConfiguration:function(n,v){return n;},
getNavigationTargets:function(f){return[];}
});
return D;});
sap.ui.predefine('sap/ui/mdc/chart/SelectionHandler',["sap/m/SelectionDetails","sap/m/SelectionDetailsItem","sap/m/SelectionDetailsItemLine","./SelectionDetailsActions"],function(S,a,b,c){"use strict";var d=function(){};
d.prepareChart=function(C){if(!C.getSelectionDetailsActions()){C.setSelectionDetailsActions(new c());}var s=new S(C.getId()+"-selectionDetails",{});s.registerSelectionDetailsItemFactory([],function(D,e,o,f){var l=[];for(var i=0;i<D.length;i++){l.push(new b({label:D[i].label,value:d.formatValue(D[i].value),unit:D[i].unit}));}return new a({enableNav:d.hasNavigationTargets(C,e),lines:l}).setBindingContext(o);});s.attachNavigate(function(e){if(e.getParameter("direction")==="back"){e.getParameter("content").destroy();}else{C._navigateToSemanticObjectDetails(e);}});s.attachActionPress(function(e){var i=[];e.getParameter("items").forEach(function(I){i.push(I.getBindingContext());});C.fireSelectionDetailsActionPressed({id:e.getParameter("id"),action:e.getParameter("action"),itemContexts:i,level:e.getParameter("level")});});s.attachBeforeOpen(function(e){var o=C.getSelectionDetailsActions(),f;var g=s.getItems();g.forEach(function(i){var I=o.getDetailsItemActions();I.forEach(function(h){f=h.clone();i.addAction(f);});});var D=o.getDetailsActions();s.removeAllActions();D.forEach(function(h){f=h.clone();s.addAction(f);});var A=o.getActionGroups();s.removeAllActionGroups();A.forEach(function(h){f=h.clone();s.addActionGroup(f);});});s.attachSelectionHandler("_selectionDetails",C.getAggregation("_chart"));s.attachBeforeClose(function(e){});var t=C.getAggregation("_toolbar");t.addAction(s);};
d.formatValue=function(v){if(v){return v instanceof Object?v:v.toString();}else{return v;}};
d.hasNavigationTargets=function(C,D){return false;};
return d;},true);
sap.ui.predefine('sap/ui/mdc/field/BoolFieldHelp',['sap/ui/mdc/library','sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/base/ManagedObjectObserver','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/json/JSONModel'],function(l,F,C,M,a,P,J){"use strict";var L;var S;var m;var b;
var B=F.extend("sap.ui.mdc.field.BoolFieldHelp",{metadata:{library:"sap.ui.mdc"}});
B.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(d.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions"]});this._oModel=new J({"type":"","items":[{"key":true,"text":"true"},{"key":false,"text":"false"}]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
B._init=function(){F._init.apply(this,arguments);L=undefined;S=undefined;m=undefined;b=undefined;};
B.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._oModel.destroy();this._oModel=undefined;};
B.prototype.connect=function(o){F.prototype.connect.apply(this,arguments);n.call(this);return this;};
B.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if((!L||!S||!m)&&!this._bListRequested){L=sap.ui.require("sap/m/List");S=sap.ui.require("sap/m/StandardListItem");m=sap.ui.require("sap/m/library");b=sap.ui.require("sap/ui/model/Filter");if(!L||!S||!m){sap.ui.require(["sap/m/List","sap/m/StandardListItem","sap/m/library","sap/ui/model/Filter"],c.bind(this));this._bListRequested=true;}}if(p){var o=this._getField();if(o){p.setInitialFocus(o);}_.call(this);}return p;};
function _(){if(!this._oList&&L&&S&&m&&!this._bListRequested){var i=new S(this.getId()+"-item",{type:m.ListType.Active,title:"{text}"});this._oList=new L(this.getId()+"-List",{width:"100%",showNoData:false,mode:m.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"/items",template:i},itemPress:e.bind(this)});this._oList.setModel(this._oModel);f.call(this,this.getFilterValue());g.call(this);this._setContent(this._oList);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);this._iStep=null;}}}
function c(i,s,o,p){L=i;S=s;m=o;b=p;this._bListRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
B.prototype.open=function(s){var p=this.getAggregation("_popover");if(p){var o=this._getField();p.setInitialFocus(o);}F.prototype.open.apply(this,arguments);return this;};
B.prototype._handleAfterClose=function(E){if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;f.call(this);}F.prototype._handleAfterClose.apply(this,arguments);};
function d(o){if(o.name==="conditions"){h.call(this,o.current);}if(o.name==="filterValue"){if(this._oList){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{f.call(this,o.current);}}}}
B.prototype.openByTyping=function(){return true;};
B.prototype.navigate=function(s){var p=this._getPopover();if(!p||!this._oList){this._bNavigate=true;this._iStep=s;return;}var o=this._oList.getSelectedItem();var i=this._oList.getItems();var I=i.length;var q=0;if(o){q=this._oList.indexOfItem(o);q=q+s;if(q<0){q=0;}else if(q>=I-1){q=I-1;}}else if(s>=0){q=s-1;}else{q=I+s;}var r=i[q];if(r){if(!p.isOpen()){this.open();}if(r!==o){r.setSelected(true);var K=j.call(this,r);var t=k.call(this,K);this.setProperty("conditions",[t],true);this.fireNavigate({value:r.getTitle(),key:K,condition:t,itemId:r.getId()});}}};
B.prototype._getTextOrKey=function(v,K,o,I,O,N){if(v===null||v===undefined||v===""){return null;}else if(!v&&!K){return null;}var p=this._oModel.getData()["items"];for(var i=0;i<p.length;i++){var q=p[i];if(K){if(q["key"]===v){return q["text"];}}else if(q["text"]===v){return q["key"];}}var E=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);if(K){throw new a(E);}else{throw new P(E);}};
function e(E){var i=E.getParameter("listItem");var s=i.getSelected();if(s){var K=j.call(this,i);var o=k.call(this,K);this.setProperty("conditions",[o],true);this.close();this.fireSelect({conditions:[o],add:true,close:true});}}
function f(t){var o=this._oList.getBinding("items");if(t){var i=new b({path:"text",operator:"StartsWith",value1:t});o.filter(i);}else{o.filter();}this._oList.invalidate();g.call(this);}
function g(){if(this._oList){var o=this.getConditions();var s;var t;var I=this._oList.getItems();if(o.length>0&&(o[0].operator==="EQ")){s=o[0].values[0];t=this.getTextForKey(s);}for(var i=0;i<I.length;i++){var p=I[i];if(p.getTitle()===t){p.setSelected(true);}else{p.setSelected(false);}}}}
function h(i){g.call(this);}
function j(i){var o=i.getBindingContext();var D=o&&o.getObject();if(D){return D["key"];}}
function k(K){var o;var t=this.getTextForKey(K);if(t){o=C.createItemCondition(K,t);}return o;}
function n(){if(this._oField&&this._oField._getFormatOptions){var t=this._oField._getFormatOptions().valueType;var D=this._oModel.getData();if(t&&D["type"]!==t.getMetadata().getName()){D["type"]=t.getMetadata().getName();var I=D["items"];for(var i=0;i<I.length;i++){var o=I[i];o["text"]=t.formatValue(o["key"],"string");}}}}
return B;});
sap.ui.predefine('sap/ui/mdc/field/ConditionFieldHelp',['sap/m/library','sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/base/ManagedObjectObserver'],function(m,F,C,M){"use strict";var B=m.ButtonType;var D;var T;var a;var b;var c;var d;
var e=F.extend("sap.ui.mdc.field.ConditionFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},label:{type:"string",group:"Appearance",defaultValue:""}}}});
e.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(g.bind(this));this._oObserver.observe(this,{properties:["title"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
e._init=function(){F._init.apply(this,arguments);D=undefined;b=undefined;};
e.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;};
e.prototype.getIcon=function(){return"sap-icon://value-help";};
e.prototype.isFocusInHelp=function(){return true;};
e.prototype.openByTyping=function(){return false;};
e.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if((!D||!T||!a||!b||!c||!d)&&!this._bModulesRequested){D=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");T=sap.ui.require("sap/m/Toolbar");a=sap.ui.require("sap/m/ToolbarSpacer");b=sap.ui.require("sap/m/Button");c=sap.ui.require("sap/ui/model/base/ManagedObjectModel");d=sap.ui.require("sap/ui/mdc/condition/FilterOperatorUtil");if(!D||!T||!a||!b||!c){sap.ui.require(["sap/ui/mdc/field/DefineConditionPanel","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/condition/FilterOperatorUtil"],f.bind(this));this._bModulesRequested=true;}}if(p){p.setShowArrow(true);p.setTitle(this.getTitle());p.setShowHeader(true);p.setTitleAlignment("Center");p.setContentWidth("500px");p.setResizable(false);_.call(this);}return p;};
function _(){if(!this._oDefineConditionPanel&&D&&T&&a&&b&&c&&d&&!this._bModulesRequested){this._oManagedObjectModel=new c(this);this._oDefineConditionPanel=new D(this.getId()+"-DCP",{conditions:{path:"$help>/conditions"},formatOptions:h.call(this),label:"{$help>/label}"}).setModel(this._oManagedObjectModel,"$help");this._setContent(this._oDefineConditionPanel);var o=new b(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),type:B.Emphasized,press:i.bind(this)});var k=new b(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:j.bind(this)});var t=new T(this.getId()+"-TB",{content:[new a(this.getId()+"-Spacer"),o,k]});var p=this.getAggregation("_popover");if(p){p.setFooter(t);}}}
function f(k,t,l,n,o,p){D=k;T=t;a=l;b=n;c=o;d=p;this._bModulesRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
e.prototype.open=function(s){F.prototype.open.apply(this,arguments);var p=this.getAggregation("_popover");if(p&&this._oDefineConditionPanel){this._oDefineConditionPanel.setFormatOptions(h.call(this));this._oDefineConditionPanel.getBinding("conditions").resume();}return this;};
e.prototype._handleAfterClose=function(E){this._oDefineConditionPanel.getBinding("conditions").suspend();F.prototype._handleAfterClose.apply(this,arguments);};
e.prototype._getControlForSuggestion=function(){var o=F.prototype._getControlForSuggestion.apply(this,arguments);var I=o.getAggregation("_endIcon",[]);if(I.length===1){o=I[0];}return o;};
function g(o){if(o.name==="title"){var p=this.getAggregation("_popover");if(p){p.setTitle(this.getTitel());}}}
e.prototype.isValidationSupported=function(){return false;};
e.prototype.getItemForValue=function(v,p,I,o,k,l,n,q){return{key:p,description:undefined};};
function h(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}}
function i(E){this.close();var k=this.getConditions();k=C._removeEmptyConditions(k);d.updateConditionsValues(k,h.call(this).operators);this.setProperty("conditions",k,true);this.fireSelect({conditions:k,add:false,close:true});}
function j(E){this.close();}
return e;});
sap.ui.predefine('sap/ui/mdc/field/CustomFieldHelp',['sap/ui/mdc/field/FieldHelpBase'],function(F){"use strict";
var C=F.extend("sap.ui.mdc.field.CustomFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content",events:{beforeOpen:{}}}});
C.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if(p){p._getAllContent=function(){var f=this.getParent();if(f){var c=[];c.push(f.getContent());return c;}else{return this.getContent();}};}return p;};
C.prototype.fireSelectEvent=function(c){this.close();this.fireSelect({conditions:c});};
C.prototype.open=function(s){this.fireBeforeOpen();F.prototype.open.apply(this,arguments);};
return C;});
sap.ui.predefine('sap/ui/mdc/field/CustomFieldInfo',['sap/ui/mdc/field/FieldInfoBase','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/base/ManagedObjectObserver'],function(F,C,I,M){"use strict";
var a=F.extend("sap.ui.mdc.field.CustomFieldInfo",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content"}});
a._oBox=undefined;
a.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{aggregations:["content"]});};
a.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oMyBox){this._oMyBox.destroy();this._oMyBox=undefined;}};
a.prototype.isTriggerable=function(){return Promise.resolve(!!this.getAggregation("content"));};
a.prototype.getTriggerHref=function(){return Promise.resolve(null);};
a.prototype.getDirectLinkHrefAndTarget=function(){return Promise.resolve(null);};
a.prototype.getContent=function(){if(!a._oBox){a._oBox=C.extend("sap.ui.mdc.field.CustomFieldInfoBox",{metadata:{},renderer:function(r,b){var c=b._oInfo.getAggregation("content");r.write("<div");r.writeControlData(b);r.write(">");if(c){r.renderControl(c);}r.write("</div>");}});}if(!this._oMyBox||this._oMyBox._bIsBeingDestroyed){this._oMyBox=new a._oBox(this.getId()+"-box");this._oMyBox._oInfo=this;}return Promise.resolve(this._oMyBox);};
function _(c){if(c.object==this&&!this._bIsBeingDestroyed){if(c.name=="content"){this.fireDataUpdate();}}}
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldBaseDelegate',['sap/ui/mdc/BaseDelegate','sap/ui/mdc/odata/TypeUtil'],function(B,T){"use strict";var F=Object.assign({},B);
F.getDataTypeClass=function(p,t){return T.getDataTypeClassName(t);};
F.getBaseType=function(p,t,f,c){return T.getBaseType(t,f,c);};
F.initializeTypeFromBinding=function(p,t,v){return{};};
F.initializeInternalUnitType=function(p,t,o){};
F.isInputValidationEnabled=function(p,f){if(f&&f.isValidationSupported()){return true;}else{return false;}};
F.isInvalidInputAllowed=function(p,f){if(f){return!f.getValidateInput();}else{return true;}};
F.getItemForValue=function(p,f,v,P,b,c,C,a){if(f){return f.getItemForValue(v,P,undefined,undefined,b,c,C,a);}};
F.getDescription=function(p,f,k,i,o,b){if(f){return f.getTextForKey(k,i,o,b);}};
F.getDefaultFieldHelpBaseDelegate=function(p){return{name:"sap/ui/mdc/field/FieldHelpBaseDelegate",payload:{}};};
F.getDefaultFieldValueHelpDelegate=function(p){return{name:"sap/ui/mdc/field/FieldValueHelpDelegate",payload:{}};};
F.getTypeUtil=function(p){return T;};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldHelpBase',['sap/ui/mdc/Element','sap/base/Log','sap/base/util/merge','sap/ui/base/SyncPromise','sap/ui/model/FormatException','sap/ui/model/ParseException'],function(E,L,m,S,F,P){"use strict";var a;var l;
var b=E.extend("sap.ui.mdc.field.FieldHelpBase",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldHelpBaseDelegate"}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},navigate:{parameters:{value:{type:"any"},key:{type:"any"},condition:{type:"object"},itemId:{type:"string"}}},dataUpdate:{},disconnect:{},open:{suggestion:{type:"boolean"}},afterClose:{}},defaultProperty:"filterValue"}});
b._init=function(){a=undefined;l=undefined;};
b.prototype.init=function(){E.prototype.init.apply(this,arguments);this._oTextOrKeyPromises={};};
b.prototype.invalidate=function(o){if(o){var p=this.getAggregation("_popover");if(p&&o===p){if(o.bOutput&&!this._bIsBeingDestroyed){var j=this.getParent();if(j){j.invalidate(this);}}return;}}};
b.prototype.setFilterValue=function(s){this.setProperty("filterValue",s,true);return this;};
b.prototype.connect=function(o){if(this._oField&&this._oField!==o){var p=this.getAggregation("_popover");if(p){p._oPreviousFocus=null;}this.close();this.setFilterValue("");this.setConditions([]);this.fireDisconnect();}this._oField=o;return this;};
b.prototype._getField=function(){if(this._oField){return this._oField;}else{return this.getParent();}};
b.prototype._getControlForSuggestion=function(){var o=this._getField();if(o.getControlForSuggestion){return o.getControlForSuggestion();}else{return o;}};
b.prototype.getFieldPath=function(){var s="";if(this._oField&&this._oField.getFieldPath){s=this._oField.getFieldPath();}return s||"Help";};
b.prototype.getDomRef=function(){var p=this.getAggregation("_popover");if(p){return p.getDomRef();}else{return E.prototype.getDomRef.apply(this,arguments);}};
b.prototype.getContentId=function(){var p=this.getAggregation("_popover");if(p){var C=p._getAllContent();if(C.length===1){return C[0].getId();}}};
b.prototype.getRoleDescription=function(M){return null;};
b.prototype.open=function(s){var o=this._getField();if(o){var p=this._getPopover();if(p&&!this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;if(!p.isOpen()){if(!this.isFocusInHelp()){p.setInitialFocus(this._getControlForSuggestion());}var O=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var j=this._fireOpen(!!s,O);if(j){if(p._getAllContent().length>0){p.openBy(this._getControlForSuggestion());}else{this._bOpenIfContent=true;}}else{this._bOpenAfterPromise=true;}}}else{this._bOpen=true;this._bSuggestion=s;}}else{L.warning("FieldHelp not assigned to field -> can not be opened.",this);}};
b.prototype.close=function(){var p=this.getAggregation("_popover");if(p&&p.isOpen()){var j=p.oPopup.getOpenState();if(j!=="CLOSED"&&j!=="CLOSING"){this._bClosing=true;p.close();}}else{delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}this._bReopen=false;};
b.prototype.toggleOpen=function(s){var p=this.getAggregation("_popover");if(p){if(p.isOpen()){var j=p.oPopup.getOpenState();if(j!=="CLOSED"&&j!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(s);}}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{this.open(s);}};
b.prototype.isOpen=function(C){if(C&&this._bClosing){return false;}var I=false;var p=this.getAggregation("_popover");if(p){I=p.isOpen();}return I;};
b.prototype.skipOpening=function(){if(this._bOpenIfContent){delete this._bOpenIfContent;}if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;}};
b.prototype.initBeforeOpen=function(s){if(this._bOpenAfterPromise){return;}var B=function(){this._bBeforeOpenPending=false;if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var j=this._callContentRequest(s,B);if(!j){this._bBeforeOpenPending=true;}};
b.prototype._createPopover=function(){var p;if((!a||!l)&&!this._bPopoverRequested){a=sap.ui.require("sap/m/Popover");l=sap.ui.require("sap/m/library");if(!a||!l){sap.ui.require(["sap/m/Popover","sap/m/library"],_.bind(this));this._bPopoverRequested=true;}}if(a&&l&&!this._bPopoverRequested){p=new a(this.getId()+"-pop",{placement:l.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,afterOpen:this._handleAfterOpen.bind(this),afterClose:this._handleAfterClose.bind(this)});p.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_popover",p,true);if(this._oContent){this._setContent(this._oContent);}}return p;};
function _(p,j){a=p;l=j;this._bPopoverRequested=false;if(!this._bIsBeingDestroyed){this._createPopover();if(this._bOpen){this.open(this._bSuggestion);}}}
b.prototype._getPopover=function(){var p=this.getAggregation("_popover");if(!p){p=this._createPopover();}return p;};
b.prototype._handleAfterOpen=function(o){};
b.prototype._handleAfterClose=function(o){this._bClosing=false;if(this._bReopen){this._bReopen=false;this.open();}this.fireAfterClose();};
b.prototype.openByTyping=function(){return false;};
b.prototype.openByClick=function(){return false;};
b.prototype.isFocusInHelp=function(){return!this.openByTyping();};
b.prototype.navigate=function(s){};
b.prototype.getTextForKey=function(k,I,o,B){return c.call(this,k,B,I,o,false);};
function c(k,B,I,o,n){return g.call(this,true,k,B,I,o,n);}
b.prototype.getKeyForText=function(t,B){return d.call(this,t,B,false);};
function d(t,B,n){return g.call(this,false,t,B,undefined,undefined,n);}
b.prototype._getTextOrKey=function(v,k,B,I,o,n){if(k){return"";}else{return undefined;}};
b.prototype._isTextOrKeyRequestSupported=function(){return false;};
b.prototype.isValidationSupported=function(){return true;};
b.prototype.getItemForValue=function(v,p,I,o,B,C,j,k){return S.resolve().then(function(){return e.call(this,v,p,I,o,B,C&&j,j,k,true,true);}.bind(this)).then(function(r){if(!r&&this._isTextOrKeyRequestSupported()){return e.call(this,v,p,I,o,B,C&&j,j,k,true,false);}else{return r;}}.bind(this)).catch(function(n){f.call(this,n,!this._isTextOrKeyRequestSupported());if(this._isTextOrKeyRequestSupported()){var r=e.call(this,v,p,I,o,B,C&&j,j,k,true,false);if(!r){throw n;}return r;}}.bind(this)).unwrap();};
function e(v,p,I,o,B,C,j,k,n,N){return S.resolve().then(function(){if(C){if(j){return c.call(this,p,B,I,o,N);}}else if(k){return d.call(this,v,B,N);}}.bind(this)).then(function(r){if(r){if(typeof r==="object"){return r;}else if(C){return{key:p,description:r};}else{return{key:r,description:v};}}else if(n&&((C&&k)||(!C&&j))){return e.call(this,v,p,I,o,B,!C,j,k,false,N);}else{return undefined;}}.bind(this)).catch(function(q){f.call(this,q,q&&q._bSecondCheck);if(n&&((C&&k)||(!C&&j))){var r=e.call(this,v,p,I,o,B,!C,j,k,false,N);if(!r){throw q;}return r;}else{q._bSecondCheck=true;throw q;}}.bind(this)).unwrap();}
function f(o,t){if(o){if(t){throw o;}if(!(o instanceof P)&&!(o instanceof F)){throw o;}if(o._bNotUnique){throw o;}}}
b.prototype.isUsableForValidation=function(){return true;};
b.prototype.onFieldChange=function(){};
b.prototype._setContent=function(C){var p=this.getAggregation("_popover");if(p){p.removeAllContent();p.addContent(C);this._oContent=undefined;if(this._bOpenIfContent){var o=this._getField();if(o){p.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else{this._oContent=C;}return this;};
b.prototype.getIcon=function(){return"sap-icon://slim-arrow-down";};
b.prototype.getUIArea=function(){var u=E.prototype.getUIArea.apply(this,arguments);if(!u){if(this._oField){u=this._oField.getUIArea();}}return u;};
b.prototype.getScrollDelegate=function(){var p=this.getAggregation("_popover");if(p){return p.getScrollDelegate();}else{return undefined;}};
b.prototype._fireOpen=function(s,C){if(this._bBeforeOpenPending){return false;}var j=this._callContentRequest(s,C);if(j){this.fireOpen({suggestion:s});}return j;};
b.prototype._callContentRequest=function(s,C){if(!this._bNoContentRequest){if(this._oContentRequestPromise){this._oContentRequestPromise.then(function(){this._bNoContentRequest=true;C();this._bNoContentRequest=false;}.bind(this));return false;}this.initControlDelegate();if(this.bDelegateInitialized){var p=this.getControlDelegate().contentRequest(this.getPayload(),this,s);if(p instanceof Promise){this._oContentRequestPromise=p;p.then(function(){this._oContentRequestPromise=undefined;this._bNoContentRequest=true;C();this._bNoContentRequest=false;}.bind(this));return false;}}else{this.awaitControlDelegate().then(function(){if(this._callContentRequest(s,C)){C();}}.bind(this));return false;}}return true;};
function g(k,v,B,I,o,n){var s=JSON.stringify(I);var C=B&&B.getPath();if(this._oTextOrKeyPromises[k]&&this._oTextOrKeyPromises[k][v]&&this._oTextOrKeyPromises[k][v][s]&&this._oTextOrKeyPromises[k][v][s][C]){return this._oTextOrKeyPromises[k][v][s][C].promise;}var j=function(){h.call(this);}.bind(this);var p=this._callContentRequest(true,j);if(!p){if(!this._oTextOrKeyPromises[k]){this._oTextOrKeyPromises[k]={};}if(!this._oTextOrKeyPromises[k][v]){this._oTextOrKeyPromises[k][v]={};}if(!this._oTextOrKeyPromises[k][v][s]){this._oTextOrKeyPromises[k][v][s]={};}if(!this._oTextOrKeyPromises[k][v][s][C]){this._oTextOrKeyPromises[k][v][s][C]={};}this._oTextOrKeyPromises[k][v][s][C].promise=new Promise(function(r,R){this._oTextOrKeyPromises[k][v][s][C].resolve=r;this._oTextOrKeyPromises[k][v][s][C].reject=R;this._oTextOrKeyPromises[k][v][s][C].key=k;this._oTextOrKeyPromises[k][v][s][C].value=v;this._oTextOrKeyPromises[k][v][s][C].inParameters=I?m({},I):undefined;this._oTextOrKeyPromises[k][v][s][C].outParameters=o?m({},o):undefined;this._oTextOrKeyPromises[k][v][s][C].bindingContext=B;this._oTextOrKeyPromises[k][v][s][C].noRequest=n;}.bind(this));return this._oTextOrKeyPromises[k][v][s][C].promise;}return this._getTextOrKey(v,k,B,I,o,n);}
function h(){for(var k in this._oTextOrKeyPromises){for(var v in this._oTextOrKeyPromises[k]){for(var I in this._oTextOrKeyPromises[k][v]){for(var C in this._oTextOrKeyPromises[k][v][I]){i.call(this,this._oTextOrKeyPromises[k][v][I][C]);delete this._oTextOrKeyPromises[k][v][I][C];}}}}}
function i(t){var M=t.value;var j=t.key;var I=t.inParameters;var o=t.outParameters;var B=t.bindingContext;var n=t.noRequest;var r=t.resolve;var R=t.reject;S.resolve().then(function(){return this._getTextOrKey(M,j,B,I,o,n);}.bind(this)).then(function(v){r(v);}).catch(function(k){R(k);}).unwrap();}
return b;});
sap.ui.predefine('sap/ui/mdc/field/FieldHelpBaseDelegate',[],function(){"use strict";var F={contentRequest:function(p,f,s){}};return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInfoBase',['sap/ui/Device','sap/ui/mdc/Element','sap/m/library','sap/m/ResponsivePopover'],function(D,E,m,R){"use strict";var P=m.PlacementType;
var F=E.extend("sap.ui.mdc.field.FieldInfoBase",{metadata:{library:"sap.ui.mdc",events:{dataUpdate:{},popoverAfterOpen:{}}}});
F.prototype.isTriggerable=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method isTriggerable must be redefined");};
F.prototype.getTriggerHref=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getTriggerHref must be redefined");};
F.prototype.getDirectLinkHrefAndTarget=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getDirectLinkHrefAndTarget must be redefined");};
F.prototype.open=function(c){var p=this.getParent();if(!p){throw new Error("sap.ui.mdc.field.FieldInfoBase: popover can not be open because the control is undefined");}if(this._oPopover&&this._oPopover.isOpen()){return Promise.resolve();}return this.createPopover().then(function(o){this._oPopover=o;this.addDependent(this._oPopover);this._oPopover.openBy(c||p);this._oPopover.attachAfterOpen(function(){this.firePopoverAfterOpen();}.bind(this));}.bind(this));};
F.prototype.getContent=function(g){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getContent must be redefined");};
F.prototype.getSourceControl=function(){return this.getParent();};
F.prototype.createPopover=function(){var p;return this.getContent(function(){return p;}).then(function(o){p=new R(this.getId()+"-popover",{contentWidth:"380px",horizontalScrolling:false,showHeader:D.system.phone,placement:P.Auto,content:[o],afterClose:function(){if(this._oPopover){this._oPopover.destroy();}}.bind(this)});sap.ui.require(['sap/ui/fl/apply/api/FlexRuntimeInfoAPI'],function(a){if(a.isFlexSupported({element:o})){a.waitForChanges({element:o}).then(function(){p.addAriaLabelledBy(o.getContentTitle?o.getContentTitle():"");});}else{p.addAriaLabelledBy(o.getContentTitle?o.getContentTitle():"");}});return p;}.bind(this));};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInput',['sap/m/Input','sap/ui/mdc/field/FieldInputRenderer'],function(I,F){"use strict";
var a=I.extend("sap.ui.mdc.field.FieldInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}}});
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldMultiInput',['sap/m/MultiInput','sap/ui/mdc/field/FieldMultiInputRenderer'],function(M,F){"use strict";
var a=M.extend("sap.ui.mdc.field.FieldMultiInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}}});
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelp',['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/OutParameterMode','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/condition/FilterConverter','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/resource/ResourceModel','sap/ui/model/Context','sap/ui/Device','sap/m/library','sap/ui/core/library'],function(F,C,a,O,b,c,M,S,d,e,m,R,f,D,g,h){"use strict";var k;var B;var V;var l;var n;var o;var p=g.ButtonType;var q=h.OpenState;
var r=F.extend("sap.ui.mdc.field.FieldValueHelp",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldValueHelpDelegate"}},filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},showConditionPanel:{type:"boolean",defaultValue:false},title:{type:"string",group:"Appearance",defaultValue:""},noDialog:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false},inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"}},defaultAggregation:"content",events:{dataRequested:{}}}});
r._init=function(){F._init.apply(this,arguments);k=undefined;B=undefined;V=undefined;l=undefined;n=undefined;o=undefined;};
r.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(s.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","showConditionPanel","title","filterFields"],aggregations:["content","filterBar","inParameters"]});this.setBindingContext(null);};
r.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}if(this._oFilterConditionModel){this._oFilterConditionModel.destroy();delete this._oFilterConditionModel;}this._oObserver.disconnect();this._oObserver=undefined;};
r.prototype.invalidate=function(i){if(i){var j=this.getContent();var v1=this.getAggregation("_dialog");if(j&&i===j){var w1=this.getAggregation("_popover");if(v1&&v1.isOpen()){var x1=v1.getContent()[0];x1.invalidate(i);}else if(w1&&w1.isOpen()){w1.invalidate(i);}return;}var y1=this.getFilterBar();if((v1&&i===v1)||(y1&&i===y1)){if(i.bOutput&&!this._bIsBeingDestroyed){var z1=this.getParent();if(z1){z1.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};
r.prototype.connect=function(i){F.prototype.connect.apply(this,arguments);t1.call(this);o1.call(this,this.getShowConditionPanel());return this;};
r.prototype.getIcon=function(){if(this.getNoDialog()){return"sap-icon://slim-arrow-down";}else{return"sap-icon://value-help";}};
r.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);if(i){var j=this.getContent();if(j){j.initialize(true);}i._getAllContent=function(){var v1=this.getParent();var w1=[];if(v1){var x1=s1.call(v1);if(x1){w1.push(x1);}}return w1;};if(this._bNavigate){this.navigate(this._iStep);}}return i;};
r.prototype._handleAfterOpen=function(i){F.prototype._handleAfterOpen.apply(this,arguments);var j=this.getContent();if(j){j.fieldHelpOpen(true);}};
r.prototype.open=function(i){if(this.getNoDialog()&&!i){i=true;}this._bUseFilterBar=!i;t1.call(this);if(this._bOpenAfterPromise){this._bSuggestion=i;return;}var j=this.getContent();var v1=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(this._bSuggestion);delete this._bSuggestion;}}.bind(this);var w1=this._bOpen?this._callContentRequest(!!i,v1):this._fireOpen(!!i,v1);delete this._bOpen;if(!w1){this._bSuggestion=i;if(i){this._getPopover();}else{j1.call(this);}if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}this._bOpenAfterPromise=true;return;}this._bOpenHandled=true;j=this.getContent();if(j&&j.getFilterEnabled()&&!this._bNavigateRunning){if(!j.isSuspended()||i){this._bApplyFilter=true;}if(!this._oFilterConditionModel){a1.call(this);}else{r1.call(this);}}if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;H.call(this,this.getFilterValue());}if(i){if(!j){this._bOpenIfContent=true;}else{j.fieldHelpOpen(i);if(this._oFilterConditionModel&&!this.getFilterValue()&&!this._bNavigateRunning){this._oFilterConditionModel.checkUpdate(true,true);}F.prototype.open.apply(this,[i]);}}else{q1.call(this);var x1=this.getAggregation("_popover");if(x1){if(x1.isOpen()){this.close();}x1.$().remove();}var y1=j1.call(this);if(y1){var z1=y1.getContent()[0];z1.setShowTokenizer(this.getMaxConditions()!==1&&!!j);z1.setFormatOptions(this._getFormatOptions());z1.bindProperty("conditions",{path:"$help>/conditions"});var A1=this.getFilterFields();if(A1){z1.bindProperty("filterConditions",{path:"filter>/conditions/"+A1});}if(j){j.fieldHelpOpen(false);G.call(this);}this._aOldConditions=this.getConditions();y1.open();this._bDialogOpen=true;}else{this._bOpen=true;}}this._bOpenHandled=false;return;};
r.prototype.toggleOpen=function(i){if(this.getNoDialog()&&!i){i=true;}if(i){F.prototype.toggleOpen.apply(this,[i]);}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{var j=j1.call(this);if(j){if(j.isOpen()){var v1=j.oPopup.getOpenState();if(v1!=="CLOSED"&&v1!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(i);}}else{this.open(i);}}};
r.prototype.close=function(){if(!this._bDialogOpen){F.prototype.close.apply(this,arguments);}else{this._bUseFilterBar=false;var i=this.getAggregation("_dialog");if(i){this._bClosing=true;i.close();var j=i.getContent()[0];j.unbindProperty("conditions",true);j.unbindProperty("filterConditions",true);}this._bReopen=false;delete this._bOpen;delete this._bOpenAfterPromise;}};
r.prototype.isOpen=function(i){var j=F.prototype.isOpen.apply(this,arguments);if(!j&&(!i||!this._bClosing)){var v1=this.getAggregation("_dialog");if(v1){j=v1.isOpen();}}return j;};
r.prototype.getDomRef=function(){if(!this._bDialogOpen){return F.prototype.getDomRef.apply(this,arguments);}else{var i=this.getAggregation("_dialog");if(i){return i.getDomRef();}}};
function _(){if(!this._oFilterConditionModel){return;}var i=this._oFilterConditionModel.getAllConditions();var j=false;for(var v1 in i){if(i[v1].length>0){j=true;break;}}if(j){this._oFilterConditionModel.removeAllConditions();}}
r.prototype._handleAfterClose=function(i){var j=this.getContent();if(j){if(!j.getAsyncKeyText()){_.call(this);}j.fieldHelpClose();}this._bApplyFilter=false;F.prototype._handleAfterClose.apply(this,arguments);};
function s(i){if(i.object==this){var j;if(i.name==="content"){i1.call(this,i.mutation,i.child);}if(i.name==="filterBar"){p1.call(this,i.mutation,i.child);}if(i.name==="conditions"){E.call(this,i.current);}if(i.name==="filterValue"){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{H.call(this,i.current);}}if(i.name==="showConditionPanel"){o1.call(this,i.current);}if(i.name==="title"){j=this.getAggregation("_dialog");if(j){j.setTitle(i.current);}}if(i.name==="filterFields"){j=this.getAggregation("_dialog");if(j){var v1=j.getContent()[0];v1.setSearchEnabled(!!i.current);if(j.isOpen()){if(i.current){v1.bindProperty("filterConditions",{path:"filter>/conditions/"+i.current});}else{v1.unbindProperty("filterConditions",true);}}}}if(i.name==="inParameters"){I.call(this,i.child,i.mutation);}}else if(i.object.isA("sap.ui.mdc.field.InParameter")){if(i.name==="value"){L.call(this,i.object.getHelpPath(),i.current,i.old,i.object.getUseConditions());}if(i.name==="helpPath"){N.call(this,i.current,i.old,i.object.getValue(),i.object.getUseConditions());}}}
r.prototype.openByTyping=function(){if(!this._bDetermineSearchSupportedCalled&&!this.isOpen()&&!this._bOpen&&!this._bOpenIfContent&&!this._bOpenAfterPromise){this.initControlDelegate();if(this.bDelegateInitialized){return t.call(this);}else{this._bDetermineSearchSupportedCalled=true;return this.awaitControlDelegate().then(function(){return t.call(this);}.bind(this));}}return!!this.getFilterFields();};
function t(){this.fireOpen({suggestion:true});this._bDetermineSearchSupportedCalled=true;var i=this.getControlDelegate().determineSearchSupported(this.getPayload(),this);if(i instanceof Promise){return i.then(function(){return!!this.getFilterFields();}.bind(this));}else{return!!this.getFilterFields();}}
r.prototype.isFocusInHelp=function(){if(!this.getNoDialog()){var i=this.getAggregation("_dialog");if((i&&i.isOpen())||(this._bDialogRequested&&this._bOpen)){return true;}}if(this._bFocusPopover){return true;}return false;};
r.prototype.navigate=function(i){var j=this.getContent();var v1=this.getAggregation("_popover");t1.call(this);if(!v1||!v1.isOpen()){var w1=function(){this.navigate(i);}.bind(this);var x1=this._bNavigate?this._callContentRequest(true,w1):this._fireOpen(true,w1);if(!x1){j=this.getContent();this._bNavigate=false;this._iStep=null;if(j){this._getPopover();if(!this._oFilterConditionModel){a1.call(this);}}return;}}this._bNavigate=false;this._iStep=null;j=this.getContent();if(j){v1=this._getPopover();this._bApplyFilter=true;this._bNavigateRunning=true;if(!this._oFilterConditionModel){a1.call(this);}else{P.call(this);}this._oFilterConditionModel.checkUpdate(true,true);}if(!v1){this._bNavigate=true;this._iStep=i;return;}if(j){j.navigate(i);}};
function u(i){var j=this._getPopover();var v1=i.getParameter("key");var w1=i.getParameter("description");var x1=i.getParameter("inParameters");var y1=i.getParameter("outParameters");var z1=i.getParameter("leave");var A1=i.getParameter("itemId");var B1;if(z1){this._oField.focus();return;}if(v1===undefined){this._bFocusPopover=true;}if(!j.isOpen()){this._bOpenHandled=true;this.open(true);this._bOpenHandled=false;}this._bNavigateRunning=false;if(v1===undefined){this._bFocusPopover=false;return;}B1=C.createItemCondition(v1,w1);B1.validated=b.Validated;if(x1){B1.inParameters=Q.call(this,x1);}if(y1){B1.outParameters=T.call(this,y1);}this.setProperty("conditions",[B1],true);this.fireNavigate({value:w1,key:v1,condition:B1,itemId:A1});}
r.prototype._getTextOrKey=function(i,j,v1,w1,x1,y1){var z1="";var A1=this.getContent();if(A1){var B1=A1.getListBinding();if(!B1){this.fireDataRequested();}if(v1&&!v1.getModel()){return null;}var C1=this.oBindingContexts[undefined];var D1=this.getInParameters();var E1=false;if(v1&&f.hasChanged(C1,v1)){E1=true;}var F1=v.call(this,D1,E1,v1,C1);z1=S.resolve().then(function(){return x.call(this,F1);}.bind(this)).then(function(){return S.resolve().then(function(){if(j){return A1.getTextForKey(i,Y.call(this,w1,D1,false,F1,v1),X.call(this,x1,true),y1);}else{return A1.getKeyForText(i,Y.call(this,undefined,D1,false,F1,v1),y1);}}.bind(this)).then(function(z1){w.call(this,F1,E1);return y.call(this,z1);}.bind(this)).unwrap();}.bind(this)).unwrap();}return z1;};
function v(j,v1,w1,x1){var y1=[];for(var i=0;i<j.length;i++){var z1=j[i];var A1=z1.getBinding("value");if(A1){var B1=A1.getPath();var C1=A1.getContext();if(v1&&(C1===x1||(!C1&&x1))){if(w1.getProperty(B1)===undefined){var D1=A1.getModel();y1.push(D1.bindProperty(B1,w1));}}else{if(!C1||C1.getProperty(B1)===undefined||A1.getValue()===undefined||!e(z1.validateProperty("value",C1.getProperty(B1)),z1.getValue())){y1.push(A1);}}}}return y1;}
function w(j,v1){if(!v1){return;}for(var i=0;i<j.length;i++){j[i].destroy();}}
function x(i){if(i.length===0){return null;}this.initControlDelegate();if(this.bDelegateInitialized){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}else{return this.awaitControlDelegate().then(function(){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}.bind(this));}}
function y(i){if(i&&typeof i==="object"){i=m({},i);if(i.inParameters){i.inParameters=Q.call(this,i.inParameters);}if(i.outParameters){i.outParameters=T.call(this,i.outParameters);}}return i;}
r.prototype._isTextOrKeyRequestSupported=function(){var i=this.getContent();return!!i;};
r.prototype.isUsableForValidation=function(){var i=this.getContent();return!!i;};
function z(v1){var w1=v1.getParameter("selectedItems");var x1=v1.getParameter("itemPress");var y1;var z1=this.getConditions();var A1;var i=0;var j=0;var B1=false;var C1=this.getMaxConditions();for(i=z1.length-1;i>=0;i--){A1=z1[i];A1.inParameters=W.call(this,A1.inParameters);A1.outParameters=X.call(this,A1.outParameters);if(A1.validated===b.Validated){B1=false;for(j=0;j<w1.length;j++){y1=w1[j];if(A1.values[0]===y1.key&&(!A1.inParameters||!y1.inParameters||e(A1.inParameters,y1.inParameters))&&(!A1.outParameters||!y1.outParameters||e(A1.outParameters,y1.outParameters))){B1=true;if(A1.values[1]!==y1.description&&y1.description){if(A1.values.length===1){A1.values.push(y1.description);}else{A1.values[1]=y1.description;}}break;}}if(!B1){z1.splice(i,1);}}}for(i=0;i<w1.length;i++){y1=w1[i];B1=false;for(j=0;j<z1.length;j++){A1=z1[j];if(A1.validated===b.Validated&&A1.values[0]===y1.key&&(!A1.inParameters||e(A1.inParameters,y1.inParameters))&&(!A1.outParameters||e(A1.outParameters,y1.outParameters))){B1=true;A1.inParameters=y1.inParameters;A1.outParameters=y1.outParameters;break;}}if(!B1){A1=C.createItemCondition(y1.key,y1.description,y1.inParameters,y1.outParameters);A1.validated=b.Validated;z1.push(A1);}}if(C1>0&&z1.length>C1){z1.splice(0,z1.length-C1);}for(i=0;i<z1.length;i++){A1=z1[i];if(A1.inParameters){A1.inParameters=Q.call(this,A1.inParameters);}else{delete A1.inParameters;}if(A1.outParameters){A1.outParameters=T.call(this,A1.outParameters);}else{delete A1.outParameters;}}if(this._bDialogOpen){this.setProperty("conditions",z1,true);}else{var D1=false;var E1=false;if(this.getMaxConditions()===1||x1){this.close();E1=true;}if(this.getMaxConditions()===1){D1=true;}this.setProperty("conditions",z1,true);this.fireSelect({conditions:z1,add:D1,close:E1});}}
function A(i){var j=i.getParameter("contentChange");var v1=this.getContent();var w1=v1.getAsyncKeyText();if(j){var x1=this.getAggregation("_popover");var y1=this.getAggregation("_dialog");if(v1){if(v1.getFilterEnabled()&&!this._oFilterConditionModel&&((x1&&this._bOpenIfContent)||y1)){a1.call(this);}if(x1&&this._bOpenIfContent){var z1=this._getField();if(z1){v1.fieldHelpOpen(true);x1.openBy(this._getControlForSuggestion());Z.call(this);}this._bOpenIfContent=false;}else if(y1){var A1=y1.getContent()[0];h1.call(this,A1,v1.getDialogContent());}}}if(!w1){this.fireDataUpdate();}}
function E(j){var v1=false;for(var i=0;i<j.length;i++){var w1=j[i];if(!w1.validated){a.checkConditionValidated(w1);v1=true;}}if(v1){this.setConditions(j);}else{G.call(this);}}
function G(){if(!this._oField){return;}var j=this.getContent();if(j){var v1=this.getConditions();var w1=[];for(var i=0;i<v1.length;i++){var x1=v1[i];if(x1.validated===b.Validated){w1.push({key:x1.values[0],description:x1.values[1],inParameters:W.call(this,x1.inParameters),outParameters:X.call(this,x1.outParameters)});}}if(!e(w1,j.getSelectedItems())){j.setSelectedItems(w1);}}}
function H(i){if(!this._oFilterConditionModel){return;}var j=this.getFilterFields();if(!j){return;}var v1=this._oFilterConditionModel.getConditions(j);var w1=v1.length>0?v1[0].values[0]:"";if(i===w1){return;}if(i){this._bOwnFilterChange=true;}this._oFilterConditionModel.removeAllConditions(j);i=i.trim();if(i){this._bOwnFilterChange=false;var x1=C.createCondition("StartsWith",[i],undefined,undefined,b.NotValidated);this._oFilterConditionModel.addCondition(j,x1);}}
function I(i,j){var v1=i.getHelpPath();var w1=false;if(j==="remove"){this._oObserver.unobserve(i);if(this._getField()&&this.isOpen()){w1=K.call(this,v1);}}else{this._oObserver.observe(i,{properties:true});if(this._getField()&&this.isOpen()){var x1=i.getValue();var y1=i.getUseConditions();w1=K.call(this,v1);w1=J.call(this,v1,x1,y1)||w1;G.call(this);}}}
function J(j,v1,w1){var x1;var y1;var z1;var A1=false;if(this._oFilterConditionModel&&j&&v1){x1=this.getFilterBar();if(this._bUseFilterBar&&x1){y1=x1.getInternalConditions();if(!y1[j]){y1[j]=[];}}if(w1){if(Array.isArray(v1)){for(var i=0;i<v1.length;i++){z1=m({},v1[i]);if(z1.inParameters){z1.inParameters=W.call(this,z1.inParameters);}if(z1.outParameters){z1.outParameters=X.call(this,z1.outParameters);}this._oFilterConditionModel.addCondition(j,z1);if(this._bUseFilterBar&&x1){y1[j].push(z1);}A1=true;}}}else{z1=C.createItemCondition(v1);z1.validated=b.Validated;this._oFilterConditionModel.addCondition(j,z1);if(this._bUseFilterBar&&x1){y1[j].push(z1);}A1=true;}}if(A1&&this._bUseFilterBar&&x1){x1.setInternalConditions(y1);}return A1;}
function K(i){var j=false;if(this._oFilterConditionModel&&i&&this._oFilterConditionModel.getConditions(i).length>0){this._oFilterConditionModel.removeAllConditions(i);j=true;}var v1=this.getFilterBar();if(this._bUseFilterBar&&v1){var w1=v1.getInternalConditions();if(w1[i]&&w1[i].length>0){w1[i]=[];v1.setInternalConditions(w1);j=true;}}return j;}
function L(i,j,v1,w1){if(this._bNoInOutFilterUpdate){return;}if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.sUpdateTimer=undefined;this.fireDataUpdate();}.bind(this),0);}if(!this._getField()||!this.isOpen()){return;}var x1=false;x1=K.call(this,i);x1=J.call(this,i,j,w1)||x1;G.call(this);}
function N(i,j,v1,w1){if(!this._getField()||!this.isOpen()){return;}var x1=false;x1=K.call(this,j);x1=J.call(this,i,v1,w1)||x1;}
function P(){var j=this.getInParameters();var v1=false;for(var i=0;i<j.length;i++){var w1=j[i];var x1=w1.getHelpPath();var y1=w1.getValue();var z1=w1.getUseConditions();v1=K.call(this,x1)||v1;v1=J.call(this,x1,y1,z1)||v1;}if(this._oFilterConditionModel&&!v1&&this._bApplyFilter&&this._bPendingFilterUpdate){this._bPendingFilterUpdate=false;this._oFilterConditionModel.checkUpdate(true,true);}}
r.prototype.onFieldChange=function(){var v1=this.getOutParameters();t1.call(this);var w1=v.call(this,v1,false);S.resolve().then(function(){return x.call(this,w1);}.bind(this)).then(function(){if(this.bIsDestroyed){return;}var x1=this.getConditions();for(var i=0;i<x1.length;i++){var y1=x1[i];if(y1.outParameters){for(var z1 in y1.outParameters){for(var j=0;j<v1.length;j++){var A1=v1[j];var B1=A1.getValue();var C1=A1.getUseConditions();var D1=true;if(A1.getMode()===O.WhenEmpty){if(C1){D1=!B1||(Array.isArray(B1)&&B1.length===0);}else{D1=!B1;}}if(D1){if(C1){var E1;if(!A1.getHelpPath()){E1=C.createCondition("EQ",[A1.getFixedValue()],undefined,undefined,b.NotValidated);}else if(A1.getFieldPath()===z1){E1=C.createCondition("EQ",[y1.outParameters[z1]],undefined,undefined,b.Validated);}else{continue;}if(!B1){B1=[];}if(!Array.isArray(B1)){throw new Error("Value on OutParameter must be an array "+A1);}if(a.indexOfCondition(E1,B1)<0){E1.validated=b.Validated;B1.push(E1);A1.setValue(B1);}}else{if(!A1.getHelpPath()){A1.setValue(A1.getFixedValue());}else if(A1.getFieldPath()===z1){A1.setValue(y1.outParameters[z1]);}}}}}}}}.bind(this)).unwrap();};
function Q(i){return U.call(this,i,this.getInParameters());}
function T(i){return U.call(this,i,this.getOutParameters());}
function U(j,v1){if(!j||v1.length===0){return null;}var w1={};for(var i=0;i<v1.length;i++){var x1=v1[i];var y1=x1.getHelpPath();var z1=x1.getFieldPath();if(y1&&z1){for(var A1 in j){if(y1===A1){w1[z1]=j[A1];break;}}}else if(!y1&&z1&&x1.getFixedValue){w1[z1]=x1.getFixedValue();}}return w1;}
function W(i){return Y.call(this,i,this.getInParameters());}
function X(i,j){return Y.call(this,i,this.getOutParameters(),j);}
function Y(v1,w1,x1,y1,z1){var A1;var B1;var C1;var D1;var i=0;if(w1.length>0){if(!v1){if(!x1){var E1=this.getBindingContext();for(i=0;i<w1.length;i++){B1=w1[i];C1=B1.getHelpPath();var F1=B1.getValue();if(y1||z1){var G1=B1.getBinding("value");var H1=false;if(G1){for(var j=0;j<y1.length;j++){if(G1.getPath()===y1[j].getPath()){F1=y1[j].getValue();H1=true;break;}}if(!H1&&z1&&G1.getContext()!==z1&&G1.getContext()===E1){F1=z1.getProperty(G1.getPath());}}}if(C1&&F1){if(!A1){A1={};}if(B1.getUseConditions()){if(F1.length>0){A1[C1]=F1[0].values[0];}}else{A1[C1]=F1;}}}}}else{for(var I1 in v1){for(i=0;i<w1.length;i++){B1=w1[i];C1=B1.getHelpPath();D1=B1.getFieldPath();if(D1&&D1===I1&&C1){if(!A1){A1={};}A1[C1]=v1[I1];}}}}}return A1;}
function Z(){if(!this._oFilterConditionModel||(!this.isOpen()&&!this._bNavigateRunning&&!this._bOpen)||this._bClosing||!this._bApplyFilter){this._bPendingFilterUpdate=true;return;}if(this._bFilterWaitingForBinding){return;}var i=this.getInParameters();var j=v.call(this,i,false);var v1=x.call(this,j);if(v1 instanceof Promise){v1.then(function(){this._bFilterWaitingForBinding=false;this._oFilterConditionModel.checkUpdate(true,true);}.bind(this));this._bFilterWaitingForBinding=true;return;}var w1=this.getContent();if(w1){var x1=this._oFilterConditionModel.getAllConditions();var y1=c.createConditionTypesMapFromFilterBar(x1,this.getFilterBar());var z1=c.createFilters(x1,y1);var A1=[];var B1=this._oFilterConditionModel.getConditions("$search");var C1;if(z1){A1.push(z1);}if(B1.length>0){C1=B1[0].values[0];}w1.applyFilters(A1,C1);}}
function $(i){if(this._bOwnFilterChange){return;}var j=this.getFilterFields();if(j&&!this._bUpdateFilterAfterClose){var v1=this._oFilterConditionModel.getConditions(j);var w1=v1.length>0?v1[0].values[0]:"";if(w1!==this.getFilterValue()){this.setProperty("filterValue",w1,true);}}Z.call(this);}
function a1(){if(!n&&!this._bFilterConditionModelRequested){n=sap.ui.require("sap/ui/mdc/condition/ConditionModel");if(!n){sap.ui.require(["sap/ui/mdc/condition/ConditionModel"],b1.bind(this));this._bFilterConditionModelRequested=true;}}if(n){var i=this.getFilterValue();this._oFilterConditionModel=new n();if(i){H.call(this,i);}P.call(this);var j=this._oFilterConditionModel.bindProperty("/conditions",this._oFilterConditionModel.getContext("/conditions"));j.attachChange($.bind(this));this.setModel(this._oFilterConditionModel,"filter");}}
function b1(i){n=i;this._bFilterConditionModelRequested=false;if(!this._bIsBeingDestroyed){a1.call(this);}}
r.prototype.getMaxConditions=function(){if(this._oField&&this._oField.getMaxConditionsForHelp){return this._oField.getMaxConditionsForHelp();}else if(this._oField&&this._oField.getMaxConditions){return this._oField.getMaxConditions();}else{return 1;}};
r.prototype.getDisplay=function(){if(this._oField&&this._oField.getDisplay){return this._oField.getDisplay();}};
r.prototype.getRequired=function(){if(this._oField&&this._oField.getRequired){return this._oField.getRequired();}else{return false;}};
r.prototype.getDataType=function(){if(this._oField.getDataType){return this._oField.getDataType();}else{return"sap.ui.model.type.String";}};
r.prototype._getFormatOptions=function(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}};
r.prototype._getKeyPath=function(){var i=this.getKeyPath();if(!i&&this._oField&&this._oField.getFieldPath&&this._oField.getFieldPath()){i=this._oField.getFieldPath();}return i;};
r.prototype.clone=function(i,j){var v1=this.getContent();var w1=this.getFilterBar();if(v1){v1.detachEvent("navigate",u,this);v1.detachEvent("selectionChange",z,this);v1.detachEvent("dataUpdate",A,this);}if(w1){w1.detachEvent("search",q1,this);}var x1=F.prototype.clone.apply(this,arguments);if(v1){v1.attachEvent("navigate",u,this);v1.attachEvent("selectionChange",z,this);v1.attachEvent("dataUpdate",A,this);}if(w1){w1.attachEvent("search",q1,this);}return x1;};
function c1(){var i;if((!k||!B||!V||!l)&&!this._bDialogRequested){k=sap.ui.require("sap/m/Dialog");B=sap.ui.require("sap/m/Button");V=sap.ui.require("sap/ui/mdc/field/ValueHelpPanel");l=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");o=sap.ui.require("sap/ui/model/base/ManagedObjectModel");if(!k||!B||!V||!l||!o){sap.ui.require(["sap/m/Dialog","sap/m/Button","sap/ui/mdc/field/ValueHelpPanel","sap/ui/mdc/field/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"],f1.bind(this));this._bDialogRequested=true;}}if(k&&B&&V&&l&&o&&!this._bDialogRequested){if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}var j=new B(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),type:p.Emphasized,press:k1.bind(this)});var v1=new B(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:l1.bind(this)});this._oManagedObjectModel=new o(this);var w1=g1.call(this);i=new k(this.getId()+"-dialog",{contentHeight:d1(),contentWidth:e1(),horizontalScrolling:false,verticalScrolling:false,title:this.getTitle(),resizable:true,draggable:true,content:[w1],afterOpen:m1.bind(this),afterClose:n1.bind(this),buttons:[j,v1]});i.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_dialog",i,true);i.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");o1.call(this,this.getShowConditionPanel());}return i;}
function d1(){if(D.system.desktop){return"700px";}if(D.system.tablet){return D.orientation.landscape?"600px":"600px";}}
function e1(){if(D.system.desktop){return"1080px";}if(D.system.tablet){return D.orientation.landscape?"920px":"600px";}}
function f1(i,j,v1,w1,x1){k=i;B=j;V=v1;l=w1;o=x1;this._bDialogRequested=false;if(!this._bIsBeingDestroyed){c1.call(this);if(this._bOpen){this.open();}}}
function g1(){var i=this.getContent();var j=this.getFilterBar();var v1=new V(this.getId()+"-VHP",{height:"100%",showFilterbar:!!j,searchEnabled:!!this.getFilterFields(),formatOptions:this._getFormatOptions(),search:u1.bind(this)});v1.setModel(this._oManagedObjectModel,"$help");if(i){i.initialize(false);h1.call(this,v1,i.getDialogContent());}if(j){v1.setFilterbar(j);}return v1;}
function h1(i,j){i.setTable(j);}
function i1(i,j){var v1=this.getAggregation("_popover");var w1=this.getAggregation("_dialog");if(i==="remove"){j.detachEvent("navigate",u,this);j.detachEvent("selectionChange",z,this);j.detachEvent("dataUpdate",A,this);j=undefined;}else{j.attachEvent("navigate",u,this);j.attachEvent("selectionChange",z,this);j.attachEvent("dataUpdate",A,this);G.call(this);}this.fireDataUpdate();if(this._bNavigate){this.navigate(this._iStep);}else if(v1){v1.invalidate();var x1=this.getFilterValue();if(x1){H.call(this,x1);}P.call(this);if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}if(j&&this._bOpenIfContent){j.initialize(true);var y1=this._getField();if(y1){j.fieldHelpOpen(true);v1.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else if(j&&this._bOpenIfContent){this._bOpenIfContent=false;this.open(true);}if(w1){if(j){j.initialize(false);if(j.getFilterEnabled()&&!this._oFilterConditionModel){a1.call(this);}var z1=w1.getContent()[0];z1.setShowTokenizer(this.getMaxConditions()!==1);h1.call(this,z1,j.getDialogContent());if(w1.isOpen()||this._bOpen){j.fieldHelpOpen(false);}}}}
function j1(){var i=this.getAggregation("_dialog");if(!i){i=c1.call(this);}return i;}
function k1(i){this.close();var j=this.getConditions();j=C._removeEmptyConditions(j);a.updateConditionsValues(j,this._getFormatOptions().operators);this._bNoConditionModelUpdate=true;this.setProperty("conditions",j,true);this._bOK=true;}
function l1(i){this.close();this.setProperty("conditions",this._aOldConditions,true);}
function m1(i){}
function n1(i){this._bDialogOpen=false;this._aOldConditions=undefined;this._bUseFilterBar=false;this._bApplyFilter=false;this._handleAfterClose(i);if(this._bOK){var j=this.getConditions();this.fireSelect({conditions:j,add:false,close:true});}this._bOK=undefined;}
function o1(i){var j=this.getAggregation("_dialog");if(j&&this._oField){var v1=j.getContent()[0];if(i){if(!v1._oDefineConditionPanel){var w1=new l(this.getId()+"-DCP",{label:"{$help>/title}"});v1.setDefineConditions(w1);}}else{v1.setDefineConditions();}}}
function p1(i,j){if(i==="remove"){j.detachEvent("search",q1,this);j=undefined;}else{j.attachEvent("search",q1,this);}var v1=this.getAggregation("_dialog");if(v1){var w1=v1.getContent()[0];w1.setFilterbar(j);w1.setShowFilterbar(!!j);P.call(this);q1.call(this);}}
function q1(j){if(!this._oFilterConditionModel||!this._bUseFilterBar){return;}var v1=this.getFilterBar();if(v1){var w1=this._oFilterConditionModel.getAllConditions();var x1=v1.getInternalConditions();var y1=this.getFilterFields();var i=0;var z1;var A1;for(z1 in w1){if(z1!==y1){for(i=0;i<w1[z1].length;i++){A1=m({},w1[z1][i]);if(!x1[z1]||a.indexOfCondition(A1,x1[z1])<0){this._oFilterConditionModel.removeCondition(z1,A1);}}}}for(z1 in x1){for(i=0;i<x1[z1].length;i++){A1=m({},x1[z1][i]);if(!w1[z1]||a.indexOfCondition(A1,w1[z1])<0){this._oFilterConditionModel.addCondition(z1,A1);}}}if(!this._bApplyFilter&&(j||v1.getLiveMode())){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}}}
function r1(){if(!this._oFilterConditionModel){return;}var i=this.getFilterBar();if(i){var j=this._oFilterConditionModel.getAllConditions();var v1=i.getInternalConditions();var w1=this.getFilterFields();var x1=false;var y1;for(y1 in v1){if(y1!==w1){if(j[y1]&&j[y1].length>0){this._oFilterConditionModel.removeAllConditions(y1);}if(v1[y1].length>0){v1[y1]=[];x1=true;}}}j=this._oFilterConditionModel.getAllConditions();for(y1 in j){if(y1!==w1){if(j[y1].length>0){this._oFilterConditionModel.removeAllConditions(y1);}}}if(x1){i.setInternalConditions(v1);}}P.call(this);}
function s1(){var i=this.getContent();if(i){return i.getSuggestionContent();}}
function t1(){var i=this._oField?this._oField.getBindingContext():null;this.setBindingContext(i);}
function u1(i){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}
r.prototype.getScrollDelegate=function(){var i=this.getAggregation("_dialog");if(i&&(i.isOpen()||i.oPopup.getOpenState()===q.OPENING)){var j=this.getContent();var v1=j&&j.getDialogContent();if(v1&&v1.getScrollDelegate){return v1.getScrollDelegate();}else{return undefined;}}else{return F.prototype.getScrollDelegate.apply(this,arguments);}};
r.prototype._fireOpen=function(i){if(!this._bOpenHandled){return F.prototype._fireOpen.apply(this,arguments);}return true;};
r.prototype.getRoleDescription=function(i){if(!i||i===1){return null;}else if(!this.getContent()&&this.getShowConditionPanel()&&!this.getNoDialog()){return null;}else{if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");}};
return r;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpContentWrapperBase',['sap/ui/core/Element'],function(E){"use strict";
var F=E.extend("sap.ui.mdc.field.FieldValueHelpContentWrapperBase",{metadata:{library:"sap.ui.mdc",properties:{selectedItems:{type:"object[]",defaultValue:[]}},defaultProperty:"selectedItems",events:{navigate:{parameters:{key:{type:"any"},description:{type:"string"},leave:{type:"boolean"},itemId:{type:"string"}}},selectionChange:{parameters:{selectedItems:{type:"object[]"},itemPress:{type:"boolean"}}},dataUpdate:{parameters:{contentChange:{type:"boolean"}}}}}});
F.prototype.init=function(){};
F.prototype.exit=function(){};
F.prototype.initialize=function(s){return this;};
F.prototype.setSelectedItems=function(s){this.setProperty("selectedItems",s,true);return this;};
F.prototype.getDialogContent=function(){return undefined;};
F.prototype.getSuggestionContent=function(){return undefined;};
F.prototype.fieldHelpOpen=function(s){this._bSuggestion=s;return this;};
F.prototype.fieldHelpClose=function(){delete this._bSuggestion;return this;};
F.prototype.getFilterEnabled=function(){return true;};
F.prototype.navigate=function(s){};
F.prototype.getTextForKey=function(k,i,o,n){return"";};
F.prototype.getKeyForText=function(t,i,n){return undefined;};
F.prototype.getListBinding=function(){return undefined;};
F.prototype.getAsyncKeyText=function(){return false;};
F.prototype.applyFilters=function(f,s){};
F.prototype.isSuspended=function(){return false;};
F.prototype._getFieldHelp=function(){var f=this.getParent();if(!f||!f.isA("sap.ui.mdc.field.FieldValueHelp")){throw new Error(this.getId()+" must be assigned to a sap.ui.mdc.field.FieldValueHelp");}return f;};
F.prototype._getKeyPath=function(){var f=this._getFieldHelp();return f._getKeyPath();};
F.prototype._getDescriptionPath=function(){var f=this._getFieldHelp();return f.getDescriptionPath();};
F.prototype._getInParameters=function(){var f=this._getFieldHelp();var h=[];if(f){h=_(f.getInParameters());}return h;};
F.prototype._getOutParameters=function(){var f=this._getFieldHelp();var h=[];if(f){h=_(f.getOutParameters());}return h;};
function _(p){var h=[];for(var i=0;i<p.length;i++){var P=p[i];var H=P.getHelpPath();if(H){h.push(H);}}return h;}
F.prototype._getMaxConditions=function(){var f=this._getFieldHelp();return f.getMaxConditions();};
F.prototype._getDelegate=function(){var f=this._getFieldHelp();return{delegate:f.getControlDelegate(),payload:f.getPayload()};};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpDelegate',['sap/ui/mdc/field/FieldHelpBaseDelegate','sap/ui/model/FilterType'],function(F,a){"use strict";var b=Object.assign({},F);
b.determineSearchSupported=function(p,f){};
b.isSearchSupported=function(p,l){return false;};
b.executeSearch=function(p,l,s){};
b.executeFilter=function(p,l,f,c,r){if(l.isA("sap.ui.model.json.JSONListBinding")){l.filter(f,a.Application);c();}else{l.attachEventOnce("dataReceived",c);l.initialize();l.filter(f,a.Application);l.getContexts(0,r);}};
b.checkBindingsPending=function(p,B){return null;};
return b;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpMTableWrapper',['sap/ui/mdc/field/FieldValueHelpContentWrapperBase','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/FilterType','sap/ui/base/ManagedObjectObserver','sap/base/strings/capitalize','sap/m/library','sap/base/util/deepEqual','sap/base/Log'],function(F,C,a,b,P,c,M,d,l,e,L){"use strict";var f=l.ListMode;var S=l.Sticky;var g;
var h=F.extend("sap.ui.mdc.field.FieldValueHelpMTableWrapper",{metadata:{library:"sap.ui.mdc",aggregations:{table:{type:"sap.m.Table",multiple:false}},defaultAggregation:"table"}});
h._init=function(){g=undefined;};
h.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(n.bind(this));this._oObserver.observe(this,{properties:["selectedItems"],aggregations:["table"]});this._oTablePromise=new Promise(function(R){this._oTablePromiseResolve=R;}.bind(this));this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oPromises={};this._oTableDelegate={onsapprevious:z};};
h.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oScrollContainer){this._oScrollContainer.destroy();delete this._oScrollContainer;}this._oObserver.disconnect();this._oObserver=undefined;delete this._oTablePromise;delete this._oTablePromiseResolve;};
h.prototype.invalidate=function(O){if(O){var T=this.getTable();if(T&&O===T){if(O.bOutput&&!this._bIsBeingDestroyed){var i=this.getParent();if(i){i.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};
h.prototype.initialize=function(i){if(i||this._oScrollContainer){return this;}if(!g&&!this._bScrollContainerRequested){g=sap.ui.require("sap/m/ScrollContainer");if(!g){sap.ui.require(["sap/m/ScrollContainer"],_.bind(this));this._bScrollContainerRequested=true;}}if(g&&!this._bScrollContainerRequested){this._oScrollContainer=new g(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){var j=[];var T=this._oWrapper&&this._oWrapper.getTable();if(T){j.push(T);}return j;};}return this;};
function _(i){g=i;this._bScrollContainerRequested=false;if(!this._bIsBeingDestroyed){this.initialize();this.fireDataUpdate({contentChange:true});}}
h.prototype.getDialogContent=function(){return this._oScrollContainer;};
h.prototype.getSuggestionContent=function(){return this.getTable();};
h.prototype.fieldHelpOpen=function(i){F.prototype.fieldHelpOpen.apply(this,arguments);var T=this.getTable();if(T){q.call(this,T,i);v.call(this);if(i){var j=T.getSelectedItem();T.scrollToIndex(T.indexOfItem(j));}}return this;};
h.prototype.navigate=function(i){var T=this.getTable();if(!y(T)){this._bNavigate=true;this._iStep=i;return;}if(this._getMaxConditions()!==1){T.focus();this.fireNavigate();return;}var j=T.getSelectedItem();var I=T.getItems();var A=I.length;var B=0;if(j){B=T.indexOfItem(j);B=B+i;}else if(i>=0){B=i-1;}else{B=A+i;}if(B<0){B=0;}else if(B>=A-1){B=A-1;}var D=I[B];if(D&&D!==j){D.setSelected(true);var V=w.call(this,D);T.scrollToIndex(B);this._bNoTableUpdate=true;this.setSelectedItems([{key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters}]);this._bNoTableUpdate=false;this.fireNavigate({key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters,itemId:D.getId()});}};
h.prototype.getTextForKey=function(K,I,O,N){if(K===null||K===undefined){return null;}var T=this.getTable();if(y(T)){var R={key:K,description:""};var j=T.getItems();var A;var B;var D=false;if(I){A=[];for(var E in I){A.push(E);}}if(O){B=[];for(var G in O){B.push(G);}}for(var i=0;i<j.length;i++){var H=j[i];var V=w.call(this,H,A,B);if(V.key===K&&(!V.inParameters||!I||e(I,V.inParameters))&&(!V.outParameters||!O||e(O,V.outParameters))){R.description=V.description;R.inParameters=V.inParameters;R.outParameters=V.outParameters;D=true;break;}}if(D){return R;}}if(N){throw new b(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[K]));}else{return k.call(this,this._getKeyPath,K,"description",I,O,true);}};
h.prototype.getKeyForText=function(T,I,N){if(!T){return null;}var j=this.getTable();if(y(j)){var R={key:undefined,description:T};var A=j.getItems();var B;var D=false;if(I){B=[];for(var E in I){B.push(E);}}for(var i=0;i<A.length;i++){var G=A[i];var V=w.call(this,G,B);if(V.description===T&&(!V.inParameters||!I||e(I,V.inParameters))){R.key=V.key;R.inParameters=V.inParameters;R.outParameters=V.outParameters;D=true;break;}}if(D){return R;}}if(N){throw new P(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[T]));}else{return k.call(this,this._getDescriptionPath,T,"key",I,undefined,false);}};
function k(i,V,R,I,O,U){var j=i.call(this);if(this._oPromises[j]&&this._oPromises[j][V]){return this._oPromises[j][V];}if(!this._oPromises[j]){this._oPromises[j]={};}this._oPromises[j][V]=new Promise(function(A,B){this._oTablePromise.then(function(T){var D=j;j=i.call(this);if(!j){B(new Error("missing FieldPath"));return;}if(j!==D){if(!this._oPromises[j]){this._oPromises[j]={};}this._oPromises[j][V]=this._oPromises[D][V];delete this._oPromises[D][V];}var E=this.getListBinding();var G=E.getModel();var H=E.getPath();var J=new a(j,"EQ",V);var K=E.getContext();var N=[];if(I){for(var Q in I){N.push(new a(Q,"EQ",I[Q]));}}if(O){for(var W in O){if(!I||!I.hasOwnProperty(W)||I[W]!==O[W]){N.push(new a(W,"EQ",O[W]));}}}if(N.length>0){N.push(J);J=new a({filters:N,and:true});}try{var X=G.bindList(H,K);var Y=function(){var a1=X.getContexts();if(a1.length===1){var b1=x.call(this,a1[0]);var c1={key:b1.key,description:b1.description,inParameters:b1.inParameters,outParameters:b1.outParameters};A(c1);}else if(V===""&&a1.length===0){A(null);}else{var d1;var e1;var f1=false;if(a1.length>1){d1=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[V]);f1=true;}else{d1=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[V]);}if(U){e1=new b(d1);}else{e1=new P(d1);}e1._bNotUnique=f1;B(e1);}setTimeout(function(){X.destroy();},0);delete this._oPromises[j][V];};var Z=this._getDelegate();if(Z.delegate){Z.delegate.executeFilter(Z.payload,X,J,Y.bind(this),2);}}catch($){B($);}}.bind(this));}.bind(this));return this._oPromises[j][V];}
h.prototype.getListBinding=function(){var T=this.getTable();var i;if(T){i=T.getBinding("items");}return i;};
h.prototype.getAsyncKeyText=function(){return true;};
h.prototype.applyFilters=function(i,j){var A=this.getListBinding();if(!A){this._oTablePromise.then(function(T){if(!this._bIsBeingDestroyed){this.applyFilters(i,j);}}.bind(this));return;}var D=this._getDelegate();var U=true;var B=A.getFilterInfo();if(!i){i=[];}if(i.length===0&&!B){U=false;}if(D.delegate&&D.delegate.isSearchSupported(D.payload,A)){if(!A.isSuspended()&&U){A.suspend();}D.delegate.executeSearch(D.payload,A,j);L.info("ValueHelp-Search: "+j);}if(U){A.filter(i,c.Application);L.info("ValueHelp-Filter: "+m.call(this,i));}if(A.isSuspended()){A.resume();}};
h.prototype.isSuspended=function(){var i=this.getListBinding();if(!i){return true;}return i.isSuspended();};
function m(i){var R;if(!i){return"";}if(Array.isArray(i)){R="";i.forEach(function(i,I,j){R+=m.call(this,i);if(j.length-1!=I){R+=" or ";}},this);return"("+R+")";}else if(i._bMultiFilter){R="";var A=i.bAnd;i.aFilters.forEach(function(i,I,j){R+=m.call(this,i);if(j.length-1!=I){R+=A?" and ":" or ";}},this);return"("+R+")";}else{R=i.sPath+" "+i.sOperator+" '"+i.oValue1+"'";if(i.sOperator==="BT"){R+="...'"+i.oValue2+"'";}return R;}}
h.prototype.clone=function(i,j){var T=this.getTable();if(T){T.detachEvent("itemPress",r,this);T.detachEvent("selectionChange",s,this);T.detachEvent("updateFinished",u,this);}var A=F.prototype.clone.apply(this,arguments);if(T){T.attachEvent("itemPress",r,this);T.attachEvent("selectionChange",s,this);T.attachEvent("updateFinished",u,this);}return A;};
function n(i){if(i.name==="table"){o.call(this,i.mutation,i.child);}if(i.name==="selectedItems"){v.call(this);}}
function o(i,T){if(i==="remove"){T.detachEvent("itemPress",r,this);T.detachEvent("selectionChange",s,this);T.detachEvent("updateFinished",u,this);T.detachEvent("modelContextChange",p,this);T.removeDelegate(this._oTableDelegate);T=undefined;this._oTablePromise=new Promise(function(R){this._oTablePromiseResolve=R;}.bind(this));}else{T.setMode(f.SingleSelectMaster);T.setRememberSelections(false);T.attachEvent("itemPress",r,this);T.attachEvent("selectionChange",s,this);T.attachEvent("updateFinished",u,this);T.addDelegate(this._oTableDelegate,true,this);q.call(this,T,this._bSuggestion);v.call(this);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}if(this.getListBinding()){this._oTablePromiseResolve(T);}else{T.attachEvent("modelContextChange",p,this);}}this.fireDataUpdate({contentChange:true});}
function p(E){if(this.getListBinding()){var T=E.getSource();this._oTablePromiseResolve(T);T.detachEvent("modelContextChange",p,this);}}
function q(T,i){if(T&&this.getParent()){if(i){if(this._sTableWidth){T.setWidth(this._sTableWidth);}if(this._getMaxConditions()===1){T.setMode(f.SingleSelectMaster);}else{T.setMode(f.MultiSelect);}}else{if(T.getWidth()!=="100%"){this._sTableWidth=T.getWidth();T.setWidth("100%");}if(this._getMaxConditions()===1){T.setMode(f.SingleSelectLeft);}else{T.setMode(f.MultiSelect);}}var j=T.getSticky();if(!j||j.length===0){T.setSticky([S.ColumnHeaders]);}}}
function r(E){var i=E.getParameter("listItem");if(!this._bSuggestion||this._getMaxConditions()!==1){i.setSelected(!i.getSelected());}t.call(this,true);}
function s(E){if(!this._bSuggestion||this._getMaxConditions()!==1){t.call(this,false);}}
function t(I){var A=[];var T=this.getTable();if(T){var B=this.getSelectedItems();var D=T.getItems();var i=0;var E;var V;if(B.length>0){for(i=0;i<D.length;i++){E=D[i];V=w.call(this,E);if(!V){throw new Error("Key of item cannot be determined"+this);}for(var j=B.length-1;j>=0;j--){var G=B[j];if(G.key===V.key&&(!V.inParameters||!G.inParameters||e(G.inParameters,V.inParameters))&&(!V.outParameters||!G.outParameters||e(G.outParameters,V.outParameters))){B.splice(j,1);break;}}}}if(B.length>0){A=B;}B=T.getSelectedItems();for(i=0;i<B.length;i++){E=B[i];V=w.call(this,E);if(!V){throw new Error("Key of item cannot be determined"+this);}A.push({key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters});}}this._bNoTableUpdate=true;this.setSelectedItems(A);this._bNoTableUpdate=false;this.fireSelectionChange({selectedItems:A,itemPress:I});}
function u(E){if(!this.getParent()){return;}v.call(this);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}if(E.getParameter("reason")!==d(C.Filter)){this.fireDataUpdate({contentChange:false});}}
function v(){if(this._bNoTableUpdate){return;}var T=this.getTable();if(y(T)){var A=this.getSelectedItems();var I=T.getItems();var U=false;for(var j=0;j<I.length;j++){var B=I[j];var D=false;if(A.length>0){var V=w.call(this,B);for(var i=0;i<A.length;i++){var E=A[i];if(V.key===E.key&&(!V.inParameters||!E.inParameters||e(E.inParameters,V.inParameters))&&(!V.outParameters||!E.outParameters||e(E.outParameters,V.outParameters))){D=true;if(V.description!==E.description){E.description=V.description;U=true;}break;}}}if(B.getSelected()!==D){B.setSelected(D);}}}if(U){this._bNoTableUpdate=true;this.setSelectedItems(A);this._bNoTableUpdate=false;}}
function w(i,I,O){var V;var B=i.getBindingContext();if(B){V=x.call(this,B,I,O);}if(!V){var K=this._getKeyPath();var j;var D;if(!K&&i.getCells){var A=i.getCells();if(A.length>0&&A[0].getText){j=A[0].getText();}if(A.length>1&&A[1].getText){D=A[1].getText();}if(j!==undefined){V={key:j,description:D};}}}if(!V){throw new Error("Key could not be determined from item "+this);}return V;}
function x(B,I,O){var K=this._getKeyPath();var D=this._getDescriptionPath();var j=B.getObject();var A;var E;if(!I){I=this._getInParameters();}if(!O){O=this._getOutParameters();}var G=I.length>0?{}:null;var H=O.length>0?{}:null;var J;if(j){if(K&&j.hasOwnProperty(K)){A=j[K];}if(D&&j.hasOwnProperty(D)){E=j[D];}var i=0;for(i=0;i<I.length;i++){J=I[i];if(j.hasOwnProperty(J)){G[J]=j[J];}}for(i=0;i<O.length;i++){J=O[i];if(j.hasOwnProperty(J)){H[J]=j[J];}else{L.error("FieldValueHelpMTableWrapper","cannot find out-parameter '"+J+"' in item data!");}}}if(A===null||A===undefined){return false;}return{key:A,description:E,inParameters:G,outParameters:H};}
function y(T){if(!T){return false;}var B=T.getBinding("items");if(B&&(B.isSuspended()||B.getLength()===0)){return false;}return true;}
function z(E){if(!this._bSuggestion){return;}var T=this.getTable();var i=jQuery(E.target).control(0);switch(E.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(T.indexOfItem(i)===0){this.fireNavigate({key:undefined,description:undefined,leave:true});E.preventDefault();E.stopPropagation();E.stopImmediatePropagation(true);}}break;default:break;}}
return h;});
sap.ui.predefine('sap/ui/mdc/field/InParameter',['sap/ui/core/Element'],function(E){"use strict";
var I=E.extend("sap.ui.mdc.field.InParameter",{metadata:{library:"sap.ui.mdc",properties:{value:{type:"any",byValue:true},helpPath:{type:"string"}},defaultProperty:"value"}});
I.prototype.init=function(){this.attachEvent("modelContextChange",_,this);};
I.prototype.exit=function(){};
I.prototype.bindProperty=function(n,b){if(n==="value"&&!b.formatter){b.targetType="raw";}E.prototype.bindProperty.apply(this,arguments);};
I.prototype.getFieldPath=function(){var b=this.getBinding("value");var p=b&&b.getPath();if(p){if(p.startsWith("/conditions/")){p=p.slice(12);}else if(p.startsWith("/")){p=p.slice(1);}}if(!p){p=this.getHelpPath();}return p;};
function _(e){var b=this.getBinding("value");this._bBound=false;this._bConditionModel=false;if(b){this._bBound=true;var m=b.getModel();if(m&&m.isA("sap.ui.mdc.condition.ConditionModel")){this._bConditionModel=true;}}}
I.prototype.getUseConditions=function(){var u=false;if(this._bConditionModel){u=true;}else if(!this._bBound){var v=this.getValue();if(Array.isArray(v)&&(v.length===0||v[0].hasOwnProperty("operator"))){u=true;}}return u;};
return I;});
sap.ui.predefine('sap/ui/mdc/field/ListFieldHelp',['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/library'],function(F,C,a,b,P,M,c,l){"use strict";var L;var D;var m;var d;
var e=F.extend("sap.ui.mdc.field.ListFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{filterList:{type:"boolean",group:"Appearance",defaultValue:true},useFirstMatch:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"}},defaultAggregation:"items"}});
e._init=function(){F._init.apply(this,arguments);L=undefined;D=undefined;m=undefined;d=undefined;};
e.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oManagedObjectModel=new M(this);this._oObserver=new c(g.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions"],aggregations:["items"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
e.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._iDataUpdateTimer){clearTimeout(this._iDataUpdateTimer);this._iDataUpdateTimer=null;}};
e.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);if((!L||!D||!m)&&!this._bListRequested){L=sap.ui.require("sap/m/List");D=sap.ui.require("sap/m/DisplayListItem");m=sap.ui.require("sap/m/library");d=sap.ui.require("sap/ui/model/Filter");if(!L||!D||!m){sap.ui.require(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter"],f.bind(this));this._bListRequested=true;}}if(i){_.call(this);}return i;};
function _(){if(!this._oList&&L&&D&&m&&!this._bListRequested){var i=new D(this.getId()+"-item",{type:m.ListType.Active,label:"{$field>text}",value:"{$field>additionalText}"});var t=new d("text",o.bind(this));this._oList=new L(this.getId()+"-List",{width:"100%",showNoData:false,mode:m.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$field>items",template:i,filters:t},itemPress:j.bind(this)});this._oList.setModel(this._oManagedObjectModel,"$field");this._oList.bindElement({path:"/",model:"$field"});q.call(this);this._setContent(this._oList);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);this._iStep=null;}}}
function f(i,t,u,v){L=i;D=t;m=u;d=v;this._bListRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
e.prototype.open=function(S){return F.prototype.open.apply(this,arguments);};
e.prototype._handleAfterClose=function(E){if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;n.call(this);}F.prototype._handleAfterClose.apply(this,arguments);};
function g(i){if(i.object===this){if(i.name==="items"){if(i.mutation==="insert"){this._oObserver.observe(i.child,{properties:true});}else{this._oObserver.unobserve(i.child);}h.call(this);}if(i.name==="conditions"){if(!this._bConditionUpdate){q.call(this);}}if(i.name==="filterValue"){if(this._oList){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{n.call(this);}}}}else{h.call(this);}}
function h(){if(!this._iDataUpdateTimer){this._iDataUpdateTimer=setTimeout(function(){this._iDataUpdateTimer=null;this.fireDataUpdate();}.bind(this),0);}}
e.prototype.openByTyping=function(){return true;};
e.prototype.openByClick=function(){return!this.getFilterList();};
e.prototype.navigate=function(S){var t=this._getPopover();if(!t||!this._oList){this._bNavigate=true;this._iStep=S;return;}var u=this._oList.getSelectedItem();var I=this._oList.getItems();var v=I.length;var w=0;var x=this.getFilterList();var y=this.getFilterValue();if(!x&&!u){var i=0;if(S>=0){for(i=0;i<I.length;i++){if(p.call(this,I[i].getLabel(),y)){w=i;break;}}}else{for(i=I.length-1;i>=0;i--){if(p.call(this,I[i].getLabel(),y)){w=i;break;}}}}else if(u){w=this._oList.indexOfItem(u);w=w+S;if(w<0){w=0;}else if(w>=v-1){w=v-1;}}else if(S>=0){w=S-1;}else{w=v+S;}var z=I[w];if(z&&z!==u){var O=k.call(this,z);var K=r.call(this,O);z.setSelected(true);var A=s.call(this,K,z.getLabel());if(!t.isOpen()){this.open();}this._oList.scrollToIndex(w);this.fireNavigate({key:K,value:z.getLabel(),condition:A,itemId:z.getId()});}};
e.prototype._getTextOrKey=function(v,K,B,I,O,N){if(v===null||v===undefined){return null;}else if(!v&&!K){return null;}var t=this.getItems();var u;var i=0;for(i=0;i<t.length;i++){u=t[i];if(K){if(r.call(this,u)===v){return u.getText();}}else if(u.getText()===v){return r.call(this,u);}}if(K&&v===""){return null;}if(!K&&this.getUseFirstMatch()){for(i=0;i<t.length;i++){u=t[i];var T=u.getText();if(p.call(this,T,v)){return{key:r.call(this,u),description:T};}}}var E=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);if(K){throw new b(E);}else{throw new P(E);}};
function j(E){var i=E.getParameter("listItem");var S=i.getSelected();if(S){var O=k.call(this,i);var K=r.call(this,O);s.call(this,K,i.getLabel());this.close();this.fireSelect({conditions:this.getConditions(),add:true,close:true});}}
function k(i){var t=i.getBindingContextPath();return this._oManagedObjectModel.getProperty(t);}
function n(){var B=this._oList.getBinding("items");B.update();this._oList.updateItems();this._oList.invalidate();q.call(this);}
function o(t){var i=this.getFilterList();return!i||p.call(this,t,this.getFilterValue());}
function p(t,i){return!i||(typeof i==="string"&&t.toLowerCase().startsWith(i.toLowerCase()));}
function q(){if(this._oList){var t=this.getConditions();var S;var u=this.getFilterValue();var U=this.getUseFirstMatch();var v=false;if(t.length>0&&(t[0].validated===a.Validated||t[0].operator==="EQ")){S=t[0].values[0];}var I=this._oList.getItems();for(var i=0;i<I.length;i++){var w=I[i];var O=k.call(this,w);if(t.length>0&&r.call(this,O)===S){w.setSelected(true);}else if(t.length===0&&U&&u&&!v&&p.call(this,w.getLabel(),u)){w.setSelected(true);v=true;}else{w.setSelected(false);}}}}
function r(i){var B=i.getBinding("key");if(B){return B.getInternalValue();}else{return i.getKey();}}
function s(K,v){this._bConditionUpdate=true;var i=C.createItemCondition(K,v);i.validated=a.Validated;this.setProperty("conditions",[i],true);this._bConditionUpdate=false;return i;}
return e;});
sap.ui.predefine('sap/ui/mdc/field/OutParameter',['sap/ui/mdc/field/InParameter','sap/ui/mdc/enum/OutParameterMode'],function(I,O){"use strict";
var a=I.extend("sap.ui.mdc.field.OutParameter",{metadata:{library:"sap.ui.mdc",properties:{fixedValue:{type:"any",defaultValue:null},mode:{type:"sap.ui.mdc.enum.OutParameterMode",defaultValue:O.Always}},defaultProperty:"value"}});
return a;});
sap.ui.predefine('sap/ui/mdc/filterbar/FilterBarBase',['sap/ui/mdc/p13n/P13nBuilder','sap/ui/core/library','sap/ui/mdc/p13n/AdaptationController','sap/ui/mdc/p13n/FlexUtil','sap/ui/Device','sap/ui/mdc/Control','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/base/Log','sap/ui/mdc/condition/ConditionModel','sap/ui/mdc/condition/Condition','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/condition/ConditionConverter','sap/m/MessageBox',"sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterConverter","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/mdc/util/FilterUtil","sap/m/Button","sap/m/library"],function(P,c,A,F,D,C,m,d,M,a,L,b,e,I,f,g,h,j,S,k,l,n,B,o){"use strict";var V=c.ValueState;
var p=C.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{conditions:{type:"object"}},filtersChanged:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}});
var q=o.ButtonType;p.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";p.CONDITION_MODEL_NAME="$filters";var E={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2};
p.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new a(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems"]});this._createInnerLayout();this._bPersistValues=false;this._aProperties=null;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(r){this._fResolveInitialFiltersApplied=r;}.bind(this));this._bIgnoreChanges=false;this._oAdaptationController=null;this._bSearchTriggered=false;this.setProperty("adaptationConfig",{liveMode:false,retrievePropertyInfo:this._getNonHiddenPropertyInfoSet,itemConfig:{changeOperations:{add:"addFilter",remove:"removeFilter",move:"moveFilter"}},onReset:function(){this.getAdaptationController().resetP13n().then(function(){this.getInbuiltFilter()._setXConditions(this.getFilterConditions(),true);}.bind(this));},filterConfig:{changeOperations:{add:"addFilter",remove:"removeFilter",move:"moveFilter"},adaptationUI:this.retrieveInbuiltFilter,applyFilterChangeOn:this,containerSettings:{verticalScrolling:false,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_TITLE")}}});};
p.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._bPersistValues=false;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true);};
p.prototype._isPhone=function(){return(D.system.phone)?true:false;};
p.prototype._isLiveMode=function(){if(this._isPhone()){return false;}return this.getLiveMode();};
p.prototype._getConditionModel=function(){return this._oConditionModel;};
p.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:q.Emphasized});}return this._btnSearch;};
p.prototype.getConditionModelName=function(){return this._getConditionModelName();};
p.prototype._getConditionModelName=function(){return p.CONDITION_MODEL_NAME;};
p.prototype._createConditionModel=function(){this._oConditionModel=new b();this.setModel(this._oConditionModel,this._getConditionModelName());};
p.prototype.applySettings=function(s,i){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this);this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};
p.prototype.setSuspendSelection=function(v){this.setProperty("suspendSelection",v);if(!v){if(this._bSearchTriggered){this._bSearchTriggered=false;this.triggerSearch();}}return this;};
p.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,p.INNER_MODEL_NAME);return this;};
p.prototype.getCurrentState=function(){var s={};if(this._bPersistValues){var i=[];var r=m({},this.getFilterConditions());for(var K in r){if(!this._getPropertyByName(K)){i.push(K);}}i.forEach(function(K){delete r[K];});s.filter=r;}var t=this.getFilterItems();var u=[];t.forEach(function(v,w){u.push({name:v.getFieldPath()});});s.items=u;return s;};
p.prototype.getAssignedFilterNames=function(){var N,i=null,r=this._getConditionModel();if(r){i=[];var s=r.getConditions("$search");if(s&&s.length>0){i.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}this._getNonHiddenPropertyInfoSet().forEach(function(t){N=I.getPropertyKey(t);var s=r.getConditions(N);if(s&&s.length>0){i.push(t.label||N);}});}return i;};
p.prototype._getAssignedFiltersText=function(){var t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t;};
p.prototype._getAssignedFiltersExpandedText=function(){var i=0,r=0,s=this._getConditionModel();if(s){var t=s.getAllConditions();for(var u in t){var v=this._getPropertyByName(u);if(v&&!v.hiddenFilter&&(t[u].length>0)){++i;if(!(((u==="$search")&&this.getAggregation("basicSearchField"))||this._getFilterField(u))){++r;}}}}if(!i&&!r){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");}if(!r){if(i===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[i]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[i]);}if((i===1)){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[i,r]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[i,r]);};
p.prototype._getAssignedFiltersCollapsedText=function(r){var s;r=r||[];if(r.length){s=Object.keys(r).map(function(i){return r[i];}).join(", ");if(r.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[r.length,s]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[r.length,s]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};
p.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText();};
p.prototype._reportModelChange=function(t){this._handleAssignedFilterNames();if(this.getLiveMode()||t){this.triggerSearch();}};
p.prototype._isFlexSupported=function(i){return j.isFlexSupported({element:this});};
p.prototype._handleConditionModelPropertyChange=function(i){if(!this._bIgnoreChanges){var s=i.getParameter("path");if(s.indexOf("/conditions/")===0){var r=s.substring("/conditions/".length);if(this._bPersistValues&&this._isFlexSupported()){var O={};O[r]=this._stringifyConditions(r,i.getParameter("value"));this._cleanupConditions(O[r]);this.retrieveAdaptationController().then(function(t){t.createConditionChanges(O);});}else{this._reportModelChange(false);}}}};
p.prototype._toExternal=function(i,r){var s=m({},r);s=f.toString(s,i.typeConfig,this.getTypeUtil());this._cleanupCondition(s);if(r.inParameters&&(Object.keys(r.inParameters).length>0)){Object.keys(r.inParameters).forEach(function(K){var t=this._getPropertyByName(K);if(t){var u=e.createCondition("EQ",[r.inParameters[K]]);var v=f.toString(u,t.typeConfig,this.getTypeUtil());if(!s.inParameters){s.inParameters={};}s.inParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toExternal: could not find property info for "+K);}}.bind(this));}if(r.outParameters&&(Object.keys(r.outParameters).length>0)){Object.keys(r.outParameters).forEach(function(K){var O=this._getPropertyByName(K);if(O){var t=e.createCondition("EQ",[r.outParameters[K]]);var u=f.toString(t,O.typeConfig,this.getTypeUtil());if(!s.outParameters){s.outParameters={};}s.outParameters[K]=u.values[0];}else{L.error("mdc.FilterBar._toExternal: could not find property info for "+K);}}.bind(this));}return s;};
p.prototype._toInternal=function(i,r){var s=m({},r);s=f.toType(s,i.typeConfig,this.getTypeUtil());if(r.inParameters&&(Object.keys(r.inParameters).length>0)){Object.keys(r.inParameters).forEach(function(K){var t=this._getPropertyByName(K);if(t){var u=e.createCondition("EQ",[r.inParameters[K]]);var v=f.toType(u,t.typeConfig,this.getTypeUtil());if(!s.inParameters){s.inParameters={};}s.inParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toInternal: could not find property info for "+K);}}.bind(this));}if(r.outParameters&&(Object.keys(r.outParameters).length>0)){Object.keys(r.outParameters).forEach(function(K){var O=this._getPropertyByName(K);if(O){var t=e.createCondition("EQ",[r.outParameters[K]]);var v=f.toType(t,O.typeConfig,this.getTypeUtil());if(!s.outParameters){s.outParameters={};}s.outParameters[K]=v.values[0];}else{L.error("mdc.FilterBar._toInternal: could not find property info for "+K);}}.bind(this));}return s;};
p.prototype._cleanupCondition=function(i){if(i){if(i.hasOwnProperty("isEmpty")){delete i.isEmpty;}}};
p.prototype._cleanupConditions=function(i){if(i){i.forEach(function(r){this._cleanupCondition(r);},this);}};
p.prototype._stringifyCondition=function(i,r){var R=r;if(r&&r.values){if(r.values.length>0){R=this._toExternal(i,r);}else{R=m({},r);this._cleanupCondition(R);}}return R;};
p.prototype._stringifyConditions=function(s,i){var r=this._getPropertyByName(s);var R=i;if(r&&i){R=[];i.forEach(function(t){R.push(this._stringifyCondition(r,t));},this);}return R;};
p.prototype._handleAssignedFilterNames=function(i){if(!this._oMetadataAppliedPromise){return;}this._oMetadataAppliedPromise.then(function(){if(this._bIsBeingDestroyed){return;}if(!i){if(this._btnAdapt){var r=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(r.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",r.length),false);}}var t=this._getAssignedFiltersText();var O={conditionsBased:!i,filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this.fireFiltersChanged(O);}.bind(this));};
p.prototype.onReset=function(i){this._getConditionModel().oConditionModel.removeAllConditions();};
p.prototype.onSearch=function(i){this.triggerSearch();};
p.prototype.triggerSearch=function(){return this.valid(true);};
p.prototype.valid=function(i){i=typeof i=="boolean"?i:true;if(this.getSuspendSelection()&&i){this._bSearchTriggered=true;return Promise.resolve();}return this.initialized().then(function(){if(!this._oSearchPromise){this._oSearchPromise=new Promise(function(s,t){this._fResolvedSearchPromise=s;this._fRejectedSearchPromise=t;}.bind(this));var r=function(){this._validate(i);this._oSearchPromise=null;};setTimeout(r.bind(this),0);}return this._oSearchPromise;}.bind(this));};
p.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null;}};
p.prototype._getRequiredFieldsWithoutValues=function(){var r=[];this._getRequiredPropertyNames().forEach(function(N){var i=this._getConditionModel().getConditions(N);if(!i||i.length===0){r.push(N);}}.bind(this));return r;};
p.prototype._checkAsyncValidation=function(){var r=E.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){r=E.AsyncValidation;}return r;};
p.prototype._checkRequiredFields=function(){var r=E.NoError;var R=this._getRequiredFieldsWithoutValues();R.forEach(function(N){var i=this._getFilterField(N);if(i){if(i.getValueState()===V.None){i.setValueState(V.Error);i.setValueStateText(this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING"));}}else{L.error("Mandatory filter field '"+N+"' not visible on FilterBarBase has no value.");}r=E.RequiredHasNoValue;}.bind(this));return r;};
p.prototype._checkFieldsInErrorState=function(){var r=E.NoError;this._getNonRequiredPropertyNames().some(function(N){var i=this._getFilterField(N);if(i&&(i.getValueState()!==V.None)){r=E.FieldInErrorState;}return r!==E.NoError;}.bind(this));return r;};
p.prototype._handleFilterItemSubmit=function(i){var r=i.getParameter("promise");if(r){r.then(function(){this.triggerSearch();}.bind(this));}};
p.prototype._handleFilterItemChanges=function(i){if(this._bIgnoreChanges){return;}var r=i.oSource;if(r.getRequired()&&(r.getValueState()===V.Error)&&i.getParameter("valid")){r.setValueState(V.None);return;}if(!this._aFIChanges){this._aFIChanges=[];}this._aFIChanges.push({name:r.getFieldPath(),promise:i.getParameter("promise")});};
p.prototype._checkFilters=function(){var r=this._checkAsyncValidation();if(r!==E.NoError){return r;}r=this._checkRequiredFields();if(r!==E.NoError){return r;}r=this._checkFieldsInErrorState();if(r!==E.NoError){return r;}return r;};
p.prototype._setFocusOnFirstErroneousField=function(){this.getFilterItems().some(function(i){if(i.getValueState()!==V.None){setTimeout(i["focus"].bind(i),0);return true;}return false;});};
p.prototype._handleAsyncValidation=function(i){if(this._aFIChanges&&(this._aFIChanges.length>0)){var N=this._aFIChanges.slice();this._aFIChanges=null;var r=[];N.forEach(function(s){r.push(s.promise);});Promise.all(r).then(function(s){s.forEach(function(t,u){var v=this._getFilterField(N[u].name);if(v&&v.getRequired()&&(v.getValueState()===V.Error)){v.setValueState(V.None);}},this);this._validate(i);}.bind(this),function(s){this._validate(i);}.bind(this));}};
p.prototype._validate=function(i){var s,r;r=this._checkFilters();if(r===E.AsyncValidation){this._handleAsyncValidation(i);return;}var t=function(){this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;}.bind(this);if(r===E.NoError){if(i){this.fireSearch();}this._fResolvedSearchPromise();t();}else{if(r===E.RequiredHasNoValue){s=this._oRb.getText("filterbar.REQUIRED_CONDITION_MISSING");}else{s=this._oRb.getText("filterbar.VALIDATION_ERROR");}if(this.getShowMessages()&&!this._isLiveMode()){try{g.error(s,{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":"",onClose:this._setFocusOnFirstErroneousField.bind(this)});}catch(x){L.error(x.message);}}else{L.warning("search was not triggered. "+s);}this._fRejectedSearchPromise();t();}};
p.prototype.setInternalConditions=function(i){var r=this._getConditionModel();if(r){r.setConditions(i);}};
p.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true);};
p.prototype.hasProperty=function(N){return this._getPropertyByName(N);};
p.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]);};
p.prototype.initialized=function(){return this.waitForInitialization();};
p.prototype._getModelConditions=function(i,r,K){var s={};if(i){var t=i.getAllConditions();for(var u in t){if(t[u]&&(K||t[u].length>0)){s[u]=m([],t[u]);if(!r){this._cleanupConditions(s[u]);var v=this._stringifyConditions(u,s[u]);s[u]=v;}}}}return s;};
p.prototype.removeCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var r=this._getPropertyByName(s);if(r){var t=this._toInternal(r,x);if(i.indexOf(s,t)>=0){i.removeCondition(s,t);}}}}.bind(this));};
p.prototype.addCondition=function(s,x){return this.initialized().then(function(){var i=this._getConditionModel();if(i){var r=this._getPropertyByName(s);if(r){var t=this._toInternal(r,x);if(i.indexOf(s,t)<0){var u=[{sFieldPath:r}];S.checkConditionOperatorSanity(u);if(u&&u.length>0){this._cleanUpFilterFieldInErrorStateByName(s);i.addCondition(s,t);}}}}}.bind(this));};
p.prototype._setXConditions=function(i,r){var s,t,u=this._getConditionModel();if(r){u.removeAllConditions();}if(i){for(var v in i){t=i[v];s=this._getPropertyByName(v);if(s){if(t.length===0){u.removeAllConditions(v);}else{t.forEach(function(w){if(s.maxConditions!==-1){u.removeAllConditions(v);}var N=this._toInternal(s,w);u.addCondition(v,N);}.bind(this));}}}}};
p.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false);};
p.prototype._storeChanges=function(i){if(i&&i.length){var H=j.hasVariantManagement({element:this});try{h.add({changes:i,ignoreVariantManagement:!H});}catch(r){L.error("error while saving changes - "+r.message);}}};
p.prototype._getRequiredPropertyNames=function(){var r=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(i.required){r.push(I.getPropertyKey(i));}});return r;};
p.prototype._getNonRequiredPropertyNames=function(){var N=[];this._getNonHiddenPropertyInfoSet().forEach(function(i){if(!i.required){N.push(I.getPropertyKey(i));}});return N;};
p.prototype._insertFilterFieldtoContent=function(i,r){if(!this._cLayoutItem){return;}var s=this._cLayoutItem;var t=new s();t.setFilterField(i);this._oFilterBarLayout.insertFilterField(t,r);};
p.prototype._filterItemInserted=function(i){if(!i.getVisible()){return;}if(i.setWidth){i.setWidth("");}this._applyFilterItemInserted(i);this._handleAssignedFilterNames(true);};
p.prototype._applyFilterItemInserted=function(r){var s,t;t=this.indexOfAggregation("filterItems",r);if(this.getAggregation("basicSearchField")){t++;}s=t;var u=this.getFilterItems();for(var i=0;i<s;i++){if(!u[i].getVisible()){t--;}}this._insertFilterFieldtoContent(r,t);if(!this._oObserver.isObserved(r,{properties:["visible"]})){this._oObserver.observe(r,{properties:["visible"]});}};
p.prototype._filterItemRemoved=function(i){this._applyFilterItemRemoved(i.getFieldPath());this._handleAssignedFilterNames(true);};
p.prototype._applyFilterItemRemoved=function(s){this._removeFilterFieldFromContentByName(s);};
p.prototype._removeFilterFieldFromContent=function(i){this._removeFilterFieldFromContentByName(i.getFieldPath());};
p.prototype._removeFilterFieldFromContentByName=function(s){var i=this._getFilterItemLayoutByName(s);if(i){this._oFilterBarLayout.removeFilterField(i);i.destroy();}};
p.prototype._observeChanges=function(i){if(i.type==="aggregation"&&i.name==="filterItems"){switch(i.mutation){case"insert":i.child.attachChange(this._handleFilterItemChanges,this);i.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(i.child);break;case"remove":i.child.detachChange(this._handleFilterItemChanges,this);i.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(i.child);break;default:L.error("operation "+i.mutation+" not yet implemented");}}else if(i.type==="property"){var r;if(i.object.isA&&i.object.isA("sap.ui.mdc.FilterField")){r=i.object;if(r){if(i.current){this._filterItemInserted(r);}else{this._filterItemRemoved(r);}this._oFilterBarLayout.rerender();}}}};
p.prototype._getFilterItemLayout=function(i){return this._getFilterItemLayoutByName(i.getFieldPath());};
p.prototype._getFilterItemLayoutByName=function(s){var i=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(r){if(r._getFieldPath()===s){i=r;}return i!==null;});}return i;};
p.prototype._getFilterField=function(N){var i=null;this.getFilterItems().some(function(r){if(r&&r.getFieldPath&&(r.getFieldPath()===N)){i=r;}return i!==null;});return i;};
p.prototype._retrieveMetadata=function(){if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise;}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(r){this._fResolveMetadataApplied=r;}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._aProperties=[];var r=function(){this._fResolveMetadataApplied();this._fResolveMetadataApplied=null;}.bind(this);if(this.bDelegateInitialized&&this.getControlDelegate().fetchProperties){try{this.getControlDelegate().fetchProperties(this).then(function(s){this._aProperties=s;r();}.bind(this),function(s){L.error(s);r();});}catch(i){L.error("Exception during fetchProperties occured: "+i.message);r();}}else{L.error("Provided delegate '"+this.getDelegate().path+"' not valid.");r();}}}.bind(this));return this._oMetadataAppliedPromise;};
p.prototype.setBasicSearchField=function(i){var O=this.getAggregation("basicSearchField");if(O){this._removeFilterFieldFromContent(O);O.detachSubmit(this._handleFilterItemSubmit,this);}this.setAggregation("basicSearchField",i);if(i){i.attachSubmit(this._handleFilterItemSubmit,this);if(!this._oObserver.isObserved(i,{properties:["visible"]})){this._oObserver.observe(i,{properties:["visible"]});}this._insertFilterFieldtoContent(i,0);}return this;};
p.prototype.getPropertyInfoSet=function(){return this._aProperties||[];};
p.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(i){if(!i.hiddenFilter){if(I.getPropertyKey(i)!=="$search"){v.push(i);}}return true;});return v;};
p.prototype._getNonHiddenPropertyByName=function(N){var i=null;this._getNonHiddenPropertyInfoSet().some(function(r){if(I.getPropertyKey(r)===N){i=r;}return i!=null;});return i;};
p.prototype._getPropertyByName=function(N){return n.getPropertyByKey(this.getPropertyInfoSet(),N);};
p.prototype._cleanUpFilterFieldInErrorStateByName=function(s){var i=null;var r=this.getFilterItems();r.some(function(t){if(t.getFieldPath()===s){i=t;}return i!=null;});if(i){this._cleanUpFilterFieldInErrorState(i);}};
p.prototype._cleanUpAllFilterFieldsInErrorState=function(){var i=this.getFilterItems();i.forEach(function(r){this._cleanUpFilterFieldInErrorState(r);}.bind(this));};
p.prototype._cleanUpFilterFieldInErrorState=function(i){if(i.getRequired()&&(i.getValueState()!==V.None)){i.setValueState(V.None);}};
p.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;this._oFlexPromise=this._getWaitForChangesPromise();Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]).then(function(v){this._oFlexPromise=null;this._changesApplied();}.bind(this));};
p.prototype._getWaitForChangesPromise=function(){return j.waitForChanges({element:this});};
p.prototype._suspendBinding=function(i){if(i){var r=i.getBinding("conditions");if(r){if(!this._aBindings){this._aBindings=[];}r.suspend();this._aBindings.push(i);}}};
p.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(i){if(!i.bIsDestroyed){var r=i.getBinding("conditions");if(r){r.resume();}}});this._aBindings=null;}};
p.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};
p.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges();this._changesApplied();this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null;};
p.prototype._applyFilterConditionsChanges=function(){var i;var s=this.getProperty("filterConditions");if(Object.keys(s).length>0){i=m([],s);this._setXConditions(i,true,true);}};
p.prototype.setVariantBackreference=function(v){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",v);l.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true});}else{L.error("the association 'variant' may only be assigned once and may not change afterwards.");}};
p.prototype._handleVariantSwitch=function(v){this._cleanUpAllFilterFieldsInErrorState();this._bExecuteOnSelect=false;if(v.hasOwnProperty("executeOnSelect")&&v.executeOnSelect){this._bExecuteOnSelect=true;}if(!this._oFlexPromise&&this._bInitialFiltersApplied){this._changesApplied();}};
p.prototype._hasAssignedVariantManagement=function(){var v=this.getVariantBackreference();if(v&&sap.ui.getCore().byId(v)&&sap.ui.getCore().byId(v).isA("sap.ui.fl.variants.VariantManagement")){return true;}return false;};
p.prototype._changesApplied=function(){this._bIgnoreChanges=false;this._bIgnoreChanges=false;this._reportModelChange(this._bExecuteOnSelect);this._bExecuteOnSelect=undefined;};
p.prototype._getView=function(){return I.getView(this);};
p.prototype.getConditions=function(){var i=this._bPersistValues?this.getCurrentState().filter:this._getXConditions();if(i&&i["$search"]){delete i["$search"];}return i;};
p.prototype.getSearch=function(){var s=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return s[0]?s[0].values[0]:"";};
p.prototype.exit=function(){if(this._hasAssignedVariantManagement()){l.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});}if(this.bDelegateInitialized&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this);}C.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._bPersistValues=null;this._oDelegate=null;this._aProperties=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oSearchPromise=null;this._aBindings=null;};
return p;});
sap.ui.predefine('sap/ui/mdc/filterbar/IFilterContainer',['sap/ui/core/Element'],function(E){"use strict";
var I=E.extend("sap.ui.mdc.filterbar.IFilterContainer");
I.prototype.init=function(){E.prototype.init.apply(this,arguments);this.oLayout=null;};
I.prototype.getInner=function(){return this.oLayout;};
I.prototype.insertFilterField=function(c,i){};
I.prototype.removeFilterField=function(c){};
I.prototype.getFilterFields=function(){};
I.prototype.exit=function(){E.prototype.exit.apply(this,arguments);if(this.oLayout){this.oLayout.destroy();this.oLayout=null;}};
return I;});
sap.ui.predefine('sap/ui/mdc/filterbar/aligned/FilterContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/ui/layout/AlignedFlowLayout'],function(I,A){"use strict";
var F=I.extend("sap.ui.mdc.filterbar.aligned.FilterContainer");
F.prototype.init=function(){I.prototype.init.apply(this,arguments);this.oLayout=new A();};
F.prototype.addButton=function(c){this.oLayout.addEndContent(c);};
F.prototype.insertFilterField=function(c,i){this.oLayout.insertContent(c,i);};
F.prototype.removeFilterField=function(c){this.oLayout.removeContent(c);};
F.prototype.getFilterFields=function(){return this.oLayout.getContent();};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/aligned/FilterItemLayout',['sap/ui/layout/VerticalLayout','sap/ui/layout/VerticalLayoutRenderer','sap/m/Label'],function(V,a,L){"use strict";
var F=V.extend("sap.ui.mdc.filterbar.aligned.FilterItemLayout",{
metadata:{library:"sap.ui.mdc"},
renderer:{apiVersion:2,render:a.render}
});
F.prototype._setLabel=function(f){this._oLabel=new L(f.getId()+"-label");this._oLabel.setParent(this);f.connectLabel(this._oLabel);if(f.getFieldPath()==="$search"){this._oLabel.setText("\u2008");}else{this._oLabel.addStyleClass("sapUiMdcFilterBarBaseLabel");}};
F.prototype._getFilterField=function(){return this._oFilterField;};
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._setLabel(f);this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getContent=function(){var c=[];c.push(this._oLabel);c.push(this._oFilterField);return c;};
F.prototype.exit=function(){this._oFilterField=null;this._sFieldPath=null;if(this._oLabel&&!this._oLabel.bIsDestroyed){this._oLabel.destroy();this._oLabel=undefined;}V.prototype.exit.apply(this,arguments);};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/AdaptationFilterBar',["sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/m/Toolbar","sap/m/ToolbarSpacer"],function(G,F,T,a,b,c,d,e,f){"use strict";
var A=b.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{
metadata:{library:"sap.ui.mdc",properties:{adaptationControl:{type:"object"},advancedMode:{type:"boolean",defaultValue:true}},events:{change:{}}},
renderer:c
});
A.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bPersistValues=true;};
A.prototype.setLiveMode=function(l,s){b.prototype.setLiveMode.apply(this,arguments);if(l){this._createGoToolbar();}else{this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);}var O=function(E){var C=E.getParameter("container");C.removeAllContent();if(!l){this._handleModal(E.getParameter("reason"));}if(this.getAdvancedMode()){this._executeRequestedRemoves();}this.getAdaptationController().detachAfterP13nContainerCloses(O);}.bind(this);this.getAdaptationControl()._oAdaptationController.attachEvent("afterP13nContainerCloses",O);this._oConditionModel.attachPropertyChange(function(E){var k=E.getParameter("path").substring(12);if(this.oAdaptationModel){var i=this.oAdaptationModel.getProperty("/items").find(function(o){return o.name==k;});if(i){i.isFiltered=this._getConditionModel().getConditions(k).length>0?true:false;}}}.bind(this));return this;};
A.prototype.switchViewMode=function(v){this._oFilterBarLayout.getInner().switchViewMode(v);};
A.prototype.getViewMode=function(v){return this._oFilterBarLayout.getInner().getViewMode();};
A.prototype._handleModal=function(C){var g=C==="Ok";if(g){var m=this._getModelConditions(this._getConditionModel(),false,true);if(this._bPersistValues){this.getAdaptationController().createConditionChanges(m);}else{this.getAdaptationControl()._setXConditions(m,true);}}else{this._setXConditions(this.getAdaptationControl().getFilterConditions(),true);}};
A.prototype._createGoToolbar=function(){if(!this._btnSearch){var s=this._getSearchButton();s.attachPress(function(){this.getAdaptationControl().triggerSearch();}.bind(this));this._oFilterBarLayout.getInner().setFooterToolbar(new e({content:[new f(),this._getSearchButton()]}));}};
A.prototype.setP13nModel=function(p){this.oAdaptationModel=p;};
A.prototype._getWaitForChangesPromise=function(){return d.waitForChanges({element:this.getAdaptationControl()});};
A.prototype.getAdaptationController=function(){return this.getAdaptationControl().getAdaptationController();};
A.prototype.retrieveAdaptationController=function(){return this.getAdaptationControl().retrieveAdaptationController();};
A.prototype.applyConditionsAfterChangesApplied=function(){b.prototype.applyConditionsAfterChangesApplied.apply(this,arguments);this.triggerSearch();};
A.prototype.initialized=function(){var p=this.getAdaptationControl().awaitControlDelegate().then(function(P){return P.fetchProperties(this.getAdaptationControl()).then(function(g){return g;});}.bind(this));return Promise.all([p,b.prototype.initialized.apply(this,arguments)]).then(function(r){var P=r[0];this._aProperties=P;}.bind(this));};
A.prototype.createFilterFields=function(){return this.initialized().then(function(){var C=this._bPersistValues?this.getAdaptationControl().getFilterConditions():this.getAdaptationControl()._getXConditions();this._setXConditions(C,true);if(this._bFilterFieldsCreated){return this;}var D=this.getAdaptationControl().getControlDelegate();this._mOriginalsForClone={};var g=[];this.oAdaptationModel.getProperty("/items").forEach(function(i,I){var o;if(this.getAdvancedMode()){o=this._checkExisting(i,D);}else{o=D.getFilterDelegate().addFilterItem(i,this.getAdaptationControl());}o.then(function(h){var j;if(this.getAdvancedMode()){if(h._bTemporaryOriginal){delete o._bTemporaryOriginal;this._mOriginalsForClone[h.getFieldPath()]=h;}j=h.clone();}else{j=h;}this.addAggregation("filterItems",j);}.bind(this));g.push(o);}.bind(this));return Promise.all(g).then(function(){if(this._oFilterBarLayout.getInner().setP13nModel){this._oFilterBarLayout.getInner().setP13nModel(this.oAdaptationModel);}this._bFilterFieldsCreated=true;return this;}.bind(this));}.bind(this));};
A.prototype._checkExisting=function(i,D){var o;var E=this.getAdaptationControl().getFilterItems().reduce(function(m,g){m[g.getFieldPath()]=g;return m;},{});if(E[i.name]){o=Promise.resolve(E[i.name]);}else{o=D.addItem(i.name,this.getAdaptationControl()).then(function(g){if(!g){throw new Error("No FilterField could be created for property: '"+i.name+"'.");}g._bTemporaryOriginal=true;return g;});}return o;};
A.prototype._executeRequestedRemoves=function(){var E=this._oFilterBarLayout.getInner().getSelectedFields();var o=[];Object.keys(this._mOriginalsForClone).forEach(function(k){var D=this.getAdaptationControl().getControlDelegate();if(E.indexOf(k)<0){var r=D.removeItem.call(D,k,this.getAdaptationControl()).then(function(C){if(C&&this._mOriginalsForClone[k]){this._mOriginalsForClone[k].destroy();delete this._mOriginalsForClone[k];}}.bind(this));o.push(r);}else{delete this._mOriginalsForClone[k];}}.bind(this));return Promise.all(o);};
A.prototype.setAdvancedMode=function(g,s){this.setProperty("advancedMode",g,s);this._createInnerLayout();return this;};
A.prototype._createInnerLayout=function(){this._cLayoutItem=this.getAdvancedMode()?F:a;this._oFilterBarLayout=this.getAdvancedMode()?new G():new T();this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);this.addStyleClass("sapUIAdaptationFilterBar");if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(function(){this.fireChange();}.bind(this));}};
A.prototype.exit=function(){b.prototype.exit.apply(this,arguments);this.oAdaptationModel=null;this._mOriginalsForClone=null;};
return A;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/FilterColumnLayout',['sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/Label'],function(C,a,L){"use strict";
var F=C.extend("sap.ui.mdc.filterbar.p13n.FilterColumnLayout",{
metadata:{library:"sap.ui.mdc"},
renderer:a
});
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._sLabel=f.getLabel();this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getCells=function(){var c=[];var l=new L({text:this._sLabel});l.setParent(this);c.push(l);c.push(this._oFilterField);return c;};
F.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oFilterField=null;this._sFieldPath=null;};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/FilterGroupLayout',['sap/m/CustomListItem','sap/m/CustomListItemRenderer','sap/m/Label'],function(C,a,L){"use strict";
var F=C.extend("sap.ui.mdc.filterbar.p13n.FilterGroupLayout",{renderer:a});
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getContent=function(){var c=[];var l=new L({text:this._oFilterField.getLabel(),required:"{$p13n>required}"});l.addStyleClass("sapUiMdcFilterBarBaseLabel");l.setParent(this);c.push(l);c.push(this._oFilterField);return c;};
F.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oFilterField=null;this._sFieldPath=null;};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/GroupContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/ui/mdc/p13n/panels/GroupPanelBase'],function(I,G){"use strict";
var a=I.extend("sap.ui.mdc.filterbar.p13n.GroupContainer");
a.prototype.init=function(){I.prototype.init.apply(this,arguments);this.mFilterItems={};this.mFilterFields={};this.oLayout=new G({enableListView:true,expandFirstGroup:true,enableReorder:true,defaultView:"group"});this.oLayout.setItemFactory(function(i,b){var k=this.oLayout.getModel(this.oLayout.P13N_MODEL).getProperty(b.sPath).name;var f,F=this.mFilterItems[k];f=F.bIsDestroyed?F.clone():F;f.bindProperty("selected",{path:this.oLayout.P13N_MODEL+">selected"});var o=this.mFilterFields[k];f.setFilterField(o);this.mFilterItems[k]=f;return f;}.bind(this));};
a.prototype.insertFilterField=function(c,i){this.mFilterItems[c._getFieldPath()]=c;this.mFilterFields[c._getFieldPath()]=c._oFilterField;};
a.prototype.removeFilterField=function(c){this.oLayout.removeItem(c);};
a.prototype.getFilterFields=function(){var f=[];var o=this.oLayout._oListControl.getItems();o.forEach(function(O){var p=O.getContent()[0];var i=p.getContent()[0].getItems();i.forEach(function(b){f.push(b);});});return f;};
a.prototype.exit=function(){this.mFilterItems=null;this.mFilterFields=null;I.prototype.exit.apply(this,arguments);};
return a;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/TableContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/m/Table','sap/m/Column','sap/m/Text'],function(I,T,C,a){"use strict";
var b=I.extend("sap.ui.mdc.filterbar.p13n.TableContainer");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.oLayout=new T({sticky:["ColumnHeaders"],growing:true,columns:[new C({header:new a({text:r.getText("filter.AdaptationFilterBar_FIELD_COLUMN")})}),new C({header:new a({text:r.getText("filter.AdaptationFilterBar_FIELD_VALUE_COLUMN")})})]});};
b.prototype.insertFilterField=function(c,i){this.oLayout.insertItem(c,i);};
b.prototype.removeFilterField=function(c){this.oLayout.removeItem(c);};
b.prototype.getFilterFields=function(){return this.oLayout.getItems();};
return b;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/FilterBar',["sap/m/library","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/vh/FilterContainer","sap/m/Button"],function(l,F,a,b,c,B){"use strict";
var d=F.extend("sap.ui.mdc.filterbar.vh.FilterBar",{
metadata:{properties:{showFilterFields:{type:"boolean",defaultValue:true}}},
renderer:a
});
var e=l.ButtonType;
d.prototype._createInnerLayout=function(){this._cLayoutItem=b;this._oFilterBarLayout=new c(this.getId()+"-innerLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._oBtnFilters=new B(this.getId()+"-btnShowFilters",{type:e.Transparent,press:this._onToggleFilters.bind(this)}).setText(this._oRb.getText("valuehelp."+(this.getProperty("showFilterFields")?"HIDE":"SHOW")+"ADVSEARCH"));this._oFilterBarLayout.addControl(this._oBtnFilters);this._oFilterBarLayout.addControl(this._getSearchButton().bindProperty("visible","{$sap.ui.filterbar.mdc.FilterBarBase>/liveMode}"));};
d.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oBasicSearchField=null;this._oBtnFilters=null;};
d.prototype._onToggleFilters=function(E){this.setProperty("showFilterFields",!this.getProperty("showFilterFields"),true);this._oBtnFilters.setText(this._oRb.getText("valuehelp."+(this.getProperty("showFilterFields")?"HIDE":"SHOW")+"ADVSEARCH"));};
d.prototype.setBasicSearchField=function(o){if(this._oBasicSearchField){if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField);}}this._oBasicSearchField=o;if(this._oFilterBarLayout){this._oFilterBarLayout.insertControl(o,0);}};
d.prototype.getBasicSearchField=function(){return this._oBasicSearchField;};
return d;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/FilterContainer',["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/VBox"],function(I,A,T,a,V){"use strict";
var F=I.extend("sap.ui.mdc.filterbar.vh.FilterContainer",{metadata:{aggregations:{_layout:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
F.prototype.init=function(){this.oToolbar=new T(this.getId()+"-tbr",{content:[new a()]});this.oAlgnLayout=new A(this.getId()+"-aflayout",{visible:"{$sap.ui.filterbar.mdc.FilterBarBase>/showFilterFields}"}).addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.oLayout=new V(this.getId()+"-vbox",{items:[this.oToolbar,this.oAlgnLayout]});this.setAggregation("_layout",this.oLayout,true);};
F.prototype.addControl=function(c){this.oToolbar.addContent(c);};
F.prototype.insertControl=function(c,i){this.oToolbar.insertContent(c,i);};
F.prototype.removeControl=function(c){this.oToolbar.removeContent(c);};
F.prototype.insertFilterField=function(c,i){this.oAlgnLayout.insertContent(c,i);};
F.prototype.addEndContent=function(c){this.oAlgnLayout.addEndContent(c);};
F.prototype.removeFilterField=function(c){this.oAlgnLayout.removeContent(c);};
F.prototype.getFilterFields=function(){return this.oAlgnLayout.getContent();};
return F;});
sap.ui.predefine('sap/ui/mdc/flexibility/Chart.flexibility',['./SortFlex','./ChartItemFlex'],function(S,C){"use strict";return{addItem:C.addItem,removeItem:C.removeItem,moveItem:C.moveItem,"setChartType":{layers:{USER:true},changeHandler:{createChange:function(p){if(!p.control){throw new Error("Invalid control. The existing control object is mandatory");}return{selectorElement:p.control,changeSpecificData:{changeType:"setChartType",content:{chartType:p.chartType}}};},completeChangeContent:function(c,s){},applyChange:function(c,o,p){c.setRevertData(p.modifier.getProperty(o,"chartType"));p.modifier.setProperty(o,"chartType",c.getContent().chartType);},revertChange:function(c,o,p){p.modifier.setProperty(o,"chartType",c.getRevertData());c.resetRevertData();}}},removeSort:S.removeSort,addSort:S.addSort,moveSort:S.moveSort};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/ChartItemFlex',['./ItemBaseFlex'],function(I){"use strict";var c=Object.assign({},I);
c.beforeAddItem=function(D,d,C,p,o){return D.addItem.call(D,d,C,p,o.role);};
c.findItem=function(m,i,n){return i.find(function(o){var k=m.getProperty(o,"key");return k===n;});};
c.addItem=c.createAddChangeHandler();c.removeItem=c.createRemoveChangeHandler();c.moveItem=c.createMoveChangeHandler();return c;});
sap.ui.predefine('sap/ui/mdc/flexibility/ColumnFlex',['sap/ui/fl/apply/api/FlexRuntimeInfoAPI','./ItemBaseFlex'],function(F,I){"use strict";var c=Object.assign({},I);var r=function(C){if(C&&C.isA&&C.isA("sap.ui.mdc.Table")&&C.isTableBound()){if(!C._bWaitForBindChanges){C._bWaitForBindChanges=true;F.waitForChanges({element:C}).then(function(){C.checkAndRebind();delete C._bWaitForBindChanges;});}}};
c.findItem=function(m,C,n){return C.find(function(o){var d=m.getProperty(o,"dataProperty");return d===n;});};
c.afterApply=function(C,t,i){if(C==="addColumn"&&!i||(C==="removeColumn"&&i)){r(t);}};
c.addColumn=c.createAddChangeHandler();c.removeColumn=c.createRemoveChangeHandler();c.moveColumn=c.createMoveChangeHandler();return c;});
sap.ui.predefine('sap/ui/mdc/flexibility/ConditionFlex',['sap/base/util/merge','sap/ui/mdc/condition/FilterOperatorUtil'],function(m,F){"use strict";var d=function(C){var f=C.getAdaptationConfig?C.getAdaptationConfigAttribute("filterConfig"):null;return f?f.applyFilterChangeOn:null;};var a=function(C,o,b,p,i){var f=d(b);if(f&&f.applyConditionsAfterChangesApplied){f.applyConditionsAfterChangesApplied();}return new Promise(function(e){var g,h=null,M=p.modifier;g=m({},M.getProperty(b,"filterConditions"));if(g){for(var s in g){if(s===o.name){h=g[s];break;}}}if(!h){g[o.name]=[];h=g[o.name];}var n=F.indexOfCondition(o.condition,h);if(n<0){h.push(o.condition);M.setProperty(b,"filterConditions",g);if(!i){C.setRevertData({name:o.name,condition:o.condition});}if(f&&f.addCondition){f.addCondition(o.name,o.condition).then(function(){e();});}else{e();}}else{e();}});};var r=function(C,o,b,p,i){var f=d(b);if(f&&f.applyConditionsAfterChangesApplied){f.applyConditionsAfterChangesApplied();}return new Promise(function(e){var g,h,n=-1,M=p.modifier;g=m({},M.getProperty(b,"filterConditions"));if(g){for(var s in g){if(s===o.name){h=g[s];break;}}}if(h&&(h.length>0)){n=F.indexOfCondition(o.condition,h);if(n>=0){h.splice(n,1);M.setProperty(b,"filterConditions",g);if(!i){C.setRevertData({name:o.name,condition:o.condition});}if(f&&f.removeCondition){f.removeCondition(o.name,o.condition).then(function(){e();});}else{e();}}else{e();}}else{e();}});};var c={};c.addCondition={"changeHandler":{applyChange:function(C,o,p){return a(C,C.getContent(),o,p,false);},completeChangeContent:function(C,b,p){},revertChange:function(C,o,p){return r(C,C.getRevertData(),o,p,true).then(function(){C.resetRevertData();});}},"layers":{"USER":true}};c.removeCondition={"changeHandler":{applyChange:function(C,o,p){return r(C,C.getContent(),o,p,false);},completeChangeContent:function(C,b,p){},revertChange:function(C,o,p){return a(C,C.getRevertData(),o,p,true).then(function(){C.resetRevertData();});}},"layers":{"USER":true}};return c;});
sap.ui.predefine('sap/ui/mdc/flexibility/FilterBar.flexibility',['./FilterItemFlex','./ConditionFlex'],function(F,C){"use strict";return{"addFilter":F.createAddChangeHandler(),"removeFilter":F.createRemoveChangeHandler(),"moveFilter":F.createMoveChangeHandler(),"addCondition":C.addCondition,"removeCondition":C.removeCondition};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/FilterItemFlex',['./ItemBaseFlex'],function(I){"use strict";var f=Object.assign({},I);
f.findItem=function(m,F,n){return F.find(function(o){var s;if(m.targets==="jsControlTree"){s=o.getFieldPath();}else{s=o.getAttribute("conditions");if(s){var e,S=s.indexOf("/conditions/");if(S>=0){s=s.slice(S+12);e=s.indexOf("}");if(e>=0){s=s.slice(0,e);}}}}return s===n;});};
f.beforeApply=function(c){if(c.applyConditionsAfterChangesApplied){c.applyConditionsAfterChangesApplied();}};
f.addFilter=f.createAddChangeHandler();f.removeFilter=f.createRemoveChangeHandler();f.moveFilter=f.createMoveChangeHandler();return f;},true);
sap.ui.predefine('sap/ui/mdc/flexibility/ItemBaseFlex',["sap/ui/fl/changeHandler/Base","sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F,a){"use strict";var I={_bSupressFlickering:true,beforeAddItem:function(D,d,c,p){return D.addItem.call(D,d,c,p);},afterRemoveItem:function(D,i,c,p){return D.removeItem.call(D,i,c,p);},findItem:function(m,d,n){return;},beforeApply:function(c,C,i){return;},afterApply:function(c,C,i){return;},determineAggregation:function(m,c){var d=m.getControlMetadata(c).getDefaultAggregation().name;var D=m.getAggregation(c,d);return{name:d,items:D};},_getExistingAggregationItem:function(c,p,C){var m=p.modifier;var A=this.determineAggregation(m,C);var b=A.items;var o;if(b){o=this.findItem(m,b,c.name);}return o;},_getDelegate:function(d,s,f){sap.ui.require([d],s,f);},_getOperationText:function(i){return i?"reverted ":"applied ";},_getChangeTypeText:function(A){return A?"add":"remove";},_delayInvalidate:function(c){if(c&&c.isInvalidateSuppressed&&!c.isInvalidateSuppressed()){c.iSuppressInvalidate=1;a.waitForChanges({element:c}).then(function(){c.iSuppressInvalidate=0;c.invalidate();});}},_applyAdd:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}return new Promise(function(r,b){var m=p.modifier,o=i?c.getRevertData():c.getContent();var d=o.name;var A=this.determineAggregation(m,C);var D=A.items;var e=o.index>-1?o.index:D.length;var f=this._getExistingAggregationItem(o,p,C);var P=f?Promise.resolve(f):new Promise(function(r,b){var m=p.modifier;this._getDelegate(m.getProperty(C,"delegate").name,function(g){this.beforeAddItem(g,d,C,p,o).then(function(h){if(h){r(h);}else{b();}});}.bind(this),b);}.bind(this));P.then(function(f){if(!f){b(new Error("No item in"+A.name+"  created. Change to "+this._getChangeTypeText(!i)+"cannot be "+this._getOperationText(i)+"at this moment"));return;}if(D.indexOf(f)<0){m.insertAggregation(C,A.name,f,e);}else{F.markAsNotApplicable("Specified change is already existing",true);}if(i){c.resetRevertData();}else{c.setRevertData({id:m.getId(f),name:o.name,index:e});}this.afterApply(c.getChangeType(),C,i);r();}.bind(this),function(){b(new Error("Change to "+this._getChangeTypeText(!i)+"cannot be"+this._getOperationText(i)+"at this moment"));}.bind(this));}.bind(this));},_applyRemove:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}return new Promise(function(r,b){var m=p.modifier,o=i?c.getRevertData():c.getContent();var A=this.determineAggregation(m,C);var d=this._getExistingAggregationItem(o,p,C);if(!d){if(i){b(new Error("No item found in "+A.name+". Change to "+this._getChangeTypeText(i)+"cannot be "+this._getOperationText(i)+"at this moment"));return;}else{F.markAsNotApplicable("Specified change is already existing",true);}}var e=m.findIndexInParentAggregation(d);m.removeAggregation(C,A.name,d);if(i){c.resetRevertData();}else{c.setRevertData({id:m.getId(d),name:o.name,index:e});}this._getDelegate(m.getProperty(C,"delegate").name,function(D){this.afterRemoveItem(D,d,C,p).then(function(f){if(f){m.destroy(d);}this.afterApply(c.getChangeType(),C,i);r();}.bind(this));}.bind(this),b);}.bind(this));},_applyMove:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}return new Promise(function(r,b){var m=p.modifier;var o=i?c.getRevertData():c.getContent();var d=this._getExistingAggregationItem(o,p,C);var A=this.determineAggregation(m,C);if(!d){b(new Error("No corresponding item found in "+A.name+" found. Change to move item cannot be "+this._getOperationText(i)+"at this moment"));return;}var O=m.findIndexInParentAggregation(d);if(C.moveColumn){C.moveColumn(d,o.index);}else{m.removeAggregation(C,A.name,d);m.insertAggregation(C,A.name,d,o.index);}if(i){c.resetRevertData();}else{c.setRevertData({id:m.getId(d),name:o.name,index:O});}this.afterApply(c.getChangeType(),C,i);r();}.bind(this));},_removeIndexFromChange:function(c){delete c.getContent().index;},createChangeHandler:function(A,c,r){return{"changeHandler":{applyChange:function(C,o,p){return A(C,o,p);},completeChangeContent:function(C,m,p){c(C,m,p);},revertChange:function(C,o,p){return r(C,o,p,true);}},"layers":{"USER":true}};},createAddChangeHandler:function(){var A=this._applyAdd.bind(this);var c=function(){};var r=this._applyRemove.bind(this);return this.createChangeHandler(A,c,r);},createRemoveChangeHandler:function(){var A=this._applyRemove.bind(this);var c=this._removeIndexFromChange.bind(this);var r=this._applyAdd.bind(this);return this.createChangeHandler(A,c,r);},createMoveChangeHandler:function(){var A=this._applyMove.bind(this);var c=function(){};var r=A;return this.createChangeHandler(A,c,r);}};return I;});
sap.ui.predefine('sap/ui/mdc/flexibility/Panel.flexibility',['sap/ui/fl/changeHandler/Base'],function(B){"use strict";return{createChanges:function(p,d){var n=d.filter(function(D){return!sap.ui.getCore().byId(D.id);});var N={};return n.reduce(function(r,D){if(!N[D.id]){N[D.id]=true;r.push(D);}return r;},[]).map(function(D){return{selectorElement:p,changeSpecificData:{changeType:"createItem",content:{selector:D.id}}};});},createItem:{layers:{USER:true},changeHandler:{applyChange:function(c,p,P){var s=c.getContent().selector;return new Promise(function(r){p.getModel();sap.ui.require(['sap/ui/mdc/link/PanelItem',P.modifier.getProperty(p,"metadataHelperPath")],function(a,M){if(P.modifier.bySelector(s,P.appComponent,P.view)){return r();}var m=M.retrieveAllMetadata(p);var i=function(I,b){var f=-1;b.some(function(e,g){if(e.getId()===I){f=g;return true;}});return f;};var I=P.modifier.getControlIdBySelector(s,P.appComponent);var b=P.modifier.getAggregation(p,"items");var d=-1;var o=null;m.some(function(f){var g=i(f.id,b);if(g>-1){d=g;}if(f.id===I){o=f;return true;}});if(!o){return r();}var e=P.modifier.createControl("sap.ui.mdc.link.PanelItem",P.appComponent,P.view,o.id,{text:o.text,description:o.description,href:o.href,target:o.target,icon:o.icon,visible:o.visible});P.modifier.insertAggregation(p,"items",e,d+1);return r();});});},revertChange:function(c,p,P){if(c.getContent()&&c.getContent().selector){var i=c.getContent().selector.id;var I=P.modifier.bySelector(i,P.appComponent,P.view);if(!I){return B.markAsNotApplicable("revertChange of createItem: the item with id "+i+" is not existing and therefore can not be removed.",true);}P.modifier.removeAggregation(p,"items",I);}},completeChangeContent:function(c,s,p){if(s.content){var S=p.modifier.getSelector(s.content.selector,p.appComponent);var C=c.getDefinition();C.content={selector:S};}}}}};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/PanelItem.flexibility',["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl"],function(H,U){"use strict";return{createChanges:function(d){return d.map(function(D){var c=sap.ui.getCore().byId(D.id);if(!c){throw new Error("Invalid 'id'. For the id "+D.id+" no existing control could be found");}return{selectorElement:c,changeSpecificData:{changeType:D.visible?"revealItem":"hideItem"}};});},revealItem:{layers:{USER:true},changeHandler:U},hideItem:{layers:{USER:true},changeHandler:H}};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/SortFlex',["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F){"use strict";var r=function(c){var e=c&&c.isA&&c.isA("sap.ui.mdc.Table")&&c.isTableBound();var E=c&&c.isA&&c.isA("sap.ui.mdc.Chart");if(e||E){if(!c._bWaitForBindChanges){c._bWaitForBindChanges=true;F.waitForChanges({element:c}).then(function(){if(e){c.checkAndRebind();}else if(E){c.rebind();}delete c._bWaitForBindChanges;});}}};var f=function(c,C,s,i){if(i){c.resetRevertData();}else{c.setRevertData(s);}r(C);};var a=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var o=i?c.getRevertData():c.getContent();var s=M.getProperty(C,"sortConditions");var v=s?s.sorters:[];var e={name:o.name,descending:o.descending};v.splice(o.index,0,e);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();});};var R=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();var s=M.getProperty(C,"sortConditions");var v=s?s.sorters:[];if(!v){d();}var g=v.filter(function(o){return o.name===e.name;});var I=v.indexOf(g[0]);v.splice(I,1);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();});};var m=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();var s=M.getProperty(C,"sortConditions");var v=s?s.sorters:[];var g=v.filter(function(o){return o.name===e.name;});var O=v.indexOf(g[0]);v.splice(e.index,0,v.splice(O,1)[0]);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();});};var S={};S.removeSort={"changeHandler":{applyChange:function(c,C,p){return R(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return a(c,C,p,true);}},"layers":{"USER":true}};S.addSort={"changeHandler":{applyChange:function(c,C,p){return a(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return R(c,C,p,true);}},"layers":{"USER":true}};S.moveSort={"changeHandler":{applyChange:function(c,C,p){return m(c,C,p);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return m(c,C,p,true);}},"layers":{"USER":true}};return S;});
sap.ui.predefine('sap/ui/mdc/flexibility/Table.flexibility',['./SortFlex','./ColumnFlex','./ConditionFlex'],function(S,C,a){"use strict";return{"hideControl":"default","unhideControl":"default",addColumn:C.createAddChangeHandler(),removeColumn:C.createRemoveChangeHandler(),moveColumn:C.createMoveChangeHandler(),removeSort:S.removeSort,addSort:S.addSort,moveSort:S.moveSort,addCondition:a.addCondition,removeCondition:a.removeCondition};});
sap.ui.predefine('sap/ui/mdc/flp/FlpLinkDelegate',["sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/link/SemanticObjectMapping","sap/ui/mdc/link/SemanticObjectMappingItem","sap/ui/mdc/link/SemanticObjectUnavailableAction"],function(L,a,F,b,S,i,c,d,e){"use strict";var f=Object.assign({},L);
f.fetchLinkItems=function(p,B,I){var C=B?B.getObject(B.getPath()):undefined;var g=[];if(I){I.initialize(f._getSemanticObjects(p));g.forEach(function(o){I.addIntent(b.IntentType.API,{text:o.getText(),intent:o.getHref()});});}var s=f._calculateSemanticAttributes(C,p,I);return f._retrieveNavigationTargets("",s,p,I).then(function(l,o){return Promise.resolve(l);});};
f.fetchLinkType=function(p){var s={};var P=null;var h=function(g){return g.filter(function(j){return!s[j];}).length===0;};var A=function(g){return g.some(function(j){return s[j]&&(s[j].exists===true);});};var r=function(){if(!P){P=new Promise(function(g){var C=F.getService("CrossApplicationNavigation");if(!C){S.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");return g({});}C.getDistinctSemanticObjects().then(function(D){D.forEach(function(j){s[j]={exists:true};});P=null;return g(s);},function(){S.error("FlpLinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return g({});});});}return P;};var H=function(g){if(h(g)){return Promise.resolve(A(g));}return r().then(function(){return A(g);});};if(p&&p.semanticObjects){return H(p.semanticObjects).then(function(g){return Promise.resolve({type:!!g?2:0,directLink:undefined});});}else{throw new Error("no payload or semanticObjects found");}};
f._calculateSemanticAttributes=function(C,p,I){var s=f._getSemanticObjects(p);var m=f._convertSemanticObjectMapping(f._getSemanticObjectMappings(p));if(!s.length){s.push("");}var r={};s.forEach(function(g){if(I){I.addContextObject(g,C);}r[g]={};for(var A in C){var o=null,t=null;if(I){o=I.getSemanticObjectAttribute(g,A);if(!o){o=I.createAttributeStructure();I.addSemanticObjectAttribute(g,A,o);}}if(C[A]===undefined||C[A]===null){if(o){o.transformations.push({value:undefined,description:"\u2139 Undefined and null values have been removed in FlpLinkDelegate."});}continue;}if(i(C[A])){if(o){o.transformations.push({value:undefined,description:"\u2139 Plain objects has been removed in FlpLinkDelegate."});}continue;}var h=(m&&m[g]&&m[g][A])?m[g][A]:A;if(o&&A!==h){t={value:undefined,description:"\u2139 The attribute "+A+" has been renamed to "+h+" in FlpLinkDelegate.",reason:"\ud83d\udd34 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+g+" with source attribute "+A+" and target attribute "+h+". You can modify the annotation if the mapping result is not what you expected."};}if(r[g][h]){S.error("FlpLinkDelegate: The attribute "+A+" can not be renamed to the attribute "+h+" due to a clash situation. This can lead to wrong navigation later on.");}r[g][h]=C[A];if(o){if(t){o.transformations.push(t);var j=I.createAttributeStructure();j.transformations.push({value:C[A],description:"\u2139 The attribute "+h+" with the value "+C[A]+" has been added due to a mapping rule regarding the attribute "+A+" in FlpLinkDelegate."});I.addSemanticObjectAttribute(g,h,j);}}}});return r;};
f._retrieveNavigationTargets=function(A,s,p,I){if(!p.semanticObjects){return new Promise(function(r){r([]);});}var g=p.semanticObjects;var h=p.sourceControl;var N={ownNavigation:undefined,availableActions:[]};return sap.ui.getCore().loadLibrary('sap.ui.fl',{async:true}).then(function(){return new Promise(function(r){sap.ui.require(['sap/ui/fl/Utils'],function(U){var C=F.getService("CrossApplicationNavigation");var u=F.getService("URLParsing");if(!C||!u){S.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return r(N.availableActions,N.ownNavigation);}var o=sap.ui.getCore().byId(h);var j=U.getAppComponentForControl(o);var P=g.map(function(k){return[{semanticObject:k,params:s?s[k]:undefined,appStateKey:A,ui5Component:j,sortResultsBy:"text"}];});return new Promise(function(){C.getLinks(P).then(function(l){if(!l||!l.length){return r(N.availableActions,N.ownNavigation);}var k=f._getSemanticObjectUnavailableActions(p);var m=f._convertSemanticObjectUnavailableAction(k);var q=C.hrefForExternal();if(q&&q.indexOf("?")!==-1){q=q.split("?")[0];}if(q){q+="?";}var t=function(w,x){return!!m&&!!m[w]&&m[w].indexOf(x)>-1;};var v=function(w){var x=u.parseShellHash(w.intent);if(t(x.semanticObject,x.action)){return;}var H=C.hrefForExternal({target:{shellHash:w.intent}},j);if(w.intent&&w.intent.indexOf(q)===0){N.ownNavigation=new a({href:H,text:w.text});return;}var y=new a({key:(x.semanticObject&&x.action)?(x.semanticObject+"-"+x.action):undefined,text:w.text,description:undefined,href:H,icon:undefined,initiallyVisible:(w.tags&&w.tags.indexOf("superiorAction")>-1)});N.availableActions.push(y);if(I){I.addSemanticObjectIntent(x.semanticObject,{intent:y.getHref(),text:y.getText()});}};for(var n=0;n<g.length;n++){l[n][0].forEach(v);}return r(N.availableActions,N.ownNavigation);},function(){S.error("FlpLinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return r(N.availableActions,N.ownNavigation);});});});});});};
f._getSemanticObjects=function(p){return p.semanticObjects?p.semanticObjects:[];};
f._getSemanticObjectUnavailableActions=function(p){var s=[];if(p.semanticObjectUnavailableActions){p.semanticObjectUnavailableActions.forEach(function(o){s.push(new e({semanticObject:o.semanticObject,actions:o.actions}));});}return s;};
f._getSemanticObjectMappings=function(p){var s=[];var g=[];if(p.semanticObjectMappings){p.semanticObjectMappings.forEach(function(o){g=[];if(o.items){o.items.forEach(function(h){g.push(new d({key:h.key,value:h.value}));});}s.push(new c({semanticObject:o.semanticObject,items:g}));});}return s;};
f._convertSemanticObjectMapping=function(s){if(!s.length){return undefined;}var m={};s.forEach(function(o){if(!o.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+o.getSemanticObject()+"' is not valid");}m[o.getSemanticObject()]=o.getItems().reduce(function(M,I){M[I.getKey()]=I.getValue();return M;},{});});return m;};
f._convertSemanticObjectUnavailableAction=function(s){if(!s.length){return undefined;}var m={};s.forEach(function(o){if(!o.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+o.getSemanticObject()+"' is not valid");}m[o.getSemanticObject()]=o.getActions();});return m;};
return f;},true);
sap.ui.predefine('sap/ui/mdc/link/ContactDetails',['sap/ui/core/XMLComposite','sap/m/Text','sap/m/Link','sap/m/Label'],function(X,T,L,c){"use strict";
var C=X.extend("sap.ui.mdc.link.ContactDetails",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.ContactDetailsItem",multiple:true,singularName:"item"}}}});
C.prototype.applySettings=function(){X.prototype.applySettings.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var v=this._getCompositeAggregation();v.getItems().forEach(function(s,i){this._addEmailsToSimpleForm(this.getItems()[i],s,r);this._addPhonesToSimpleForm(this.getItems()[i],s,r);this._addAddressesToSimpleForm(this.getItems()[i],s,r);},this);};
C.prototype._addEmailsToSimpleForm=function(o,s,r){o.getEmails().filter(function(a){return!a.processed&&!!a.getTypes()&&(a.getTypes().indexOf("preferred")>-1||a.getTypes().indexOf("work")>-1);}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1&&b.getTypes().indexOf("preferred")<0){return-1;}if(b.getTypes().indexOf("preferred")>-1&&a.getTypes().indexOf("preferred")<0){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("email",r.getText("info.POPOVER_CONTACT_SECTION_EMAIL"),a,s);a.processed=true;},this);};
C.prototype._addPhonesToSimpleForm=function(o,s,r){o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("work")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_PHONE"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("cell")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_MOBILE"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("fax")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_FAX"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("preferred")>-1;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_PHONE"),a,s);a.processed=true;},this);};
C.prototype._addAddressesToSimpleForm=function(o,s,r){o.getAddresses().filter(function(a){return!a.processed&&!!a.getTypes()&&(a.getTypes().indexOf("preferred")>-1||a.getTypes().indexOf("work")>-1);}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1&&b.getTypes().indexOf("preferred")<0){return-1;}if(b.getTypes().indexOf("preferred")>-1&&a.getTypes().indexOf("preferred")<0){return 1;}return 0;}).forEach(function(a){this._addLabeledAddress(a,s,r);a.processed=true;},this);};
C.prototype._addLabeledAddress=function(o,s,r){var a=function(S,d,e,R,f){var v=[];if(S){v.push(S);}if(d&&e){v.push(d+" "+e);}else{if(d){v.push(d);}if(e){v.push(e);}}if(R){v.push(R);}if(f){v.push(f);}return v.join(', ');};var A=function(S,d,e,R,f){return!!(S||d||e||R||f);};var p;var b;if(o.getBindingPath("street")&&o.getBindingPath("code")&&o.getBindingPath("locality")&&o.getBindingPath("region")&&o.getBindingPath("country")){p=[{path:o.getBindingPath("street")?o.getBindingPath("street"):"$notExisting"},{path:o.getBindingPath("code")?o.getBindingPath("code"):"$notExisting"},{path:o.getBindingPath("locality")?o.getBindingPath("locality"):"$notExisting"},{path:o.getBindingPath("region")?o.getBindingPath("region"):"$notExisting"},{path:o.getBindingPath("country")?o.getBindingPath("country"):"$notExisting"}];b=new T();b.bindProperty("text",{parts:p,formatter:a});b.bindProperty("visible",{parts:p,formatter:A});}else{b=new T({text:a(o.getStreet(),o.getCode(),o.getLocality(),o.getRegion(),o.getCountry()),visible:A(o.getStreet(),o.getCode(),o.getLocality(),o.getRegion(),o.getCountry())});}var l=new c({text:r.getText("info.POPOVER_CONTACT_SECTION_ADR"),labelFor:b.getId()});s.addContent(l);s.addContent(b);};
C.prototype._addLabeledLink=function(l,s,o,S){var a;if(o.getBindingPath("uri")){a=new L();a.bindProperty("href",{path:o.getBindingPath("uri"),formatter:function(v){return(l==="email"?"mailto:":"tel:")+v;}});a.bindProperty("text",{path:o.getBindingPath("uri")});a.bindProperty("visible",{path:o.getBindingPath("uri"),formatter:function(v){return!!v;}});}else{a=new L({href:l==="email"?"mailto:":"tel:"+o.getUri(),text:o.getUri(),visible:!!o.getUri()});}var b=new c({text:s,labelFor:a.getId()});S.addContent(b);S.addContent(a);};
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsAddressItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsAddressItem",{metadata:{library:"sap.ui.mdc",properties:{street:{type:"string"},code:{type:"string"},locality:{type:"string"},region:{type:"string"},country:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsAddressType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsEmailItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsEmailItem",{metadata:{library:"sap.ui.mdc",properties:{uri:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsEmailType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsItem",{metadata:{library:"sap.ui.mdc",properties:{sectionTitle:{type:"string",defaultValue:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_CONTACT_SECTION_TITLE")},photo:{type:"string"},formattedName:{type:"string"},role:{type:"string"},title:{type:"string"},org:{type:"string"},parameters:{type:"object"}},defaultAggregation:"emails",aggregations:{emails:{type:"sap.ui.mdc.link.ContactDetailsEmailItem",multiple:true,singularName:"email"},phones:{type:"sap.ui.mdc.link.ContactDetailsPhoneItem",multiple:true,singularName:"phone"},addresses:{type:"sap.ui.mdc.link.ContactDetailsAddressItem",multiple:true,singularName:"address"}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsPhoneItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsPhoneItem",{metadata:{library:"sap.ui.mdc",properties:{uri:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsPhoneType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/Factory',[],function(){"use strict";return{getService:function(s){switch(s){case"CrossApplicationNavigation":return sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("CrossApplicationNavigation");case"URLParsing":return sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("URLParsing");default:return null;}}};},true);
sap.ui.predefine('sap/ui/mdc/link/LinkItem',['sap/ui/core/Element'],function(E){"use strict";
var L=E.extend("sap.ui.mdc.link.LinkItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string"},target:{type:"string",defaultValue:"_self"},icon:{type:"string"},initiallyVisible:{type:"boolean",defaultValue:false}}}});
return L;});
sap.ui.predefine('sap/ui/mdc/link/Log',['sap/ui/base/Object','sap/base/util/isEmptyObject'],function(B,c){"use strict";
var L=B.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset();}});
L.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this;};
L.prototype.isEmpty=function(){return!(!c(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length);};
L.prototype.initialize=function(s){this.reset();s.forEach(function(S){this.createSemanticObjectStructure(S);}.bind(this));};
L.prototype.addContextObject=function(s,C){for(var a in C){var A=this.createAttributeStructure();this.addSemanticObjectAttribute(s,a,A);A.transformations.push({value:C[a],description:"\u2139 The attribute "+a+" with the value "+C[a]+" is initially taken from the binding context."});}};
L.prototype.createSemanticObjectStructure=function(s){this._oLog.semanticObjects[s]={attributes:{},intents:[]};};
L.prototype.createAttributeStructure=function(){return{transformations:[]};};
L.prototype.addSemanticObjectIntent=function(s,i){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].intents.push(i);return this;};
L.prototype.addSemanticObjectAttribute=function(s,a,A){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].attributes[a]=A;return this;};
L.prototype.getSemanticObjectAttribute=function(s,a){return(this._oLog.semanticObjects[s]&&this._oLog.semanticObjects[s].attributes[a])?this._oLog.semanticObjects[s].attributes[a]:undefined;};
L.prototype.addIntent=function(t,i){switch(t){case L.IntentType.API:this._oLog.intents.api.push(i);break;case L.IntentType.BREAKOUT:this._oLog.intents.breakout.push(i);break;default:throw"Intent type "+t+" is not supported yet.";}return this;};
L.prototype.getFormattedText=function(){var g=function(v){return(typeof v==="string")?"'"+v+"'":v;};var r=function(a,A){var o={value:"\u2022\u0020"+A+" : ",description:""};a.forEach(function(b,I){o.value=o.value+(I>0?"\u0020 \u279c \u0020":"")+g(b["value"]);o.description=o.description+"\u2026 \u0020 "+b["description"]+"\n";if(b["reason"]){o.description=o.description+"\u2026 \u0020 "+b["reason"]+"\n";}});return o;};var R=function(I){var a="";I.forEach(function(o){a+="\u2022\u0020'"+o.text+"' : "+o.intent+"\n";});return a;};var s=function(e){try{var l=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){var C=window.Intl.Collator(l,{numeric:true});e.sort(function(a,b){return C.compare(a,b);});}else{e.sort(function(a,b){return a.localeCompare(b,l,{numeric:true});});}}catch(E){}};var t="";for(var S in this._oLog.semanticObjects){t=t+"\n\u2b24"+" "+S+"\n";if(c(this._oLog.semanticObjects[S].attributes)){t+="\u2026\u2026 \u0020\ud83d\udd34 No semantic attributes available for semantic object "+S+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n";}else{var d=Object.keys(this._oLog.semanticObjects[S].attributes);s(d);for(var i=0;i<d.length;i++){var A=d[i];var T=r(this._oLog.semanticObjects[S].attributes[A].transformations,A);t+=T.value+"\n";t+=T.description;}}if(this._oLog.semanticObjects[S].intents.length){t+="\nIntents returned by FLP for semantic object "+S+":\n";t+=R(this._oLog.semanticObjects[S].intents);}}if(this._oLog.intents.api.length){t+="\nIntents defined in items aggregation:\n";t+=R(this._oLog.intents.api);}if(this._oLog.intents.breakout.length){t+="\nIntents returned by modifyItemsCallback callback:\n";t+=R(this._oLog.intents.breakout);}return t;};
L.prototype._getLogFormattedText=function(){return(!this.isEmpty())?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available";};
L.IntentType={BREAKOUT:"Breakout",API:"Api"};return L;});
sap.ui.predefine('sap/ui/mdc/link/Panel',['sap/ui/core/XMLComposite','sap/ui/mdc/library','sap/m/HBox','sap/m/VBox','sap/m/Text','sap/m/Image','sap/m/Link','sap/ui/core/CustomData','sap/base/Log','sap/m/SelectDialog','sap/m/StandardListItem','sap/ui/mdc/link/SelectionDialog','sap/ui/mdc/link/SelectionDialogItem','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/flexibility/PanelItem.flexibility','sap/ui/mdc/flexibility/Panel.flexibility'],function(X,m,H,V,T,I,L,C,a,S,b,c,d,J,B,M,P,e){"use strict";
var f=X.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/link/Panel.designtime",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--idSectionAdditionalContent",aggregation:"items"}}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}}});
f.prototype.init=function(){X.prototype.init.call(this);var o=new J({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,showResetEnabled:false,runtimeItems:[],contentTitle:""});o.setDefaultBindingMode(B.TwoWay);o.setSizeLimit(1000);this.setModel(o,"$sapuimdclinkPanel");this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]});};
f.prototype.applySettings=function(){X.prototype.applySettings.apply(this,arguments);var o=this._getInternalModel();o.setProperty("/countAdditionalContent",this.getAdditionalContent().length);};
f.prototype.exit=function(o){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};
f.prototype.onPressLink=function(E){if(this.getBeforeNavigationCallback()&&E.getParameter("target")!=="_blank"){var h=E.getParameter("href");E.preventDefault();this.getBeforeNavigationCallback()(E).then(function(n){if(n){window.location.href=h;}});}};
f.prototype.onPressLinkPersonalization=function(){this.openSelectionDialog(false,true,undefined);};
f.prototype.openSelectionDialog=function(F,s,g){return sap.ui.getCore().loadLibrary('sap.ui.fl',{async:true}).then(function(){sap.ui.require(['sap/ui/fl/write/api/ControlPersonalizationWriteAPI','sap/ui/fl/apply/api/FlexRuntimeInfoAPI',this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(h,i,j){if(!i.isFlexSupported({element:this})){a.error("No AppComponent fount for control "+this+". Without AppComponent the personalization is not available.");return Promise.resolve();}return i.waitForChanges({element:this}).then(function(){return new Promise(function(r){var A=j.retrieveAllMetadata(this);var k=A.some(function(v){return!!v.icon;});var l=jQuery.extend(true,[],this._getInternalModel().getProperty("/runtimeItems"));var n=j.retrieveBaseline(this);var o=n;this._getInternalModel().setProperty("/baselineItems",o);var p=function(t){t.close();t.destroy();this.fireAfterSelectionDialogClose();}.bind(this);var R=[];var q=function(v,w){R.push({id:v,visible:w});};var u=function(t){var v=f._showResetButtonEnabled(o,t.getItems());this._getInternalModel().setProperty("/showResetEnabled",v);};this.fireBeforeSelectionDialogOpen();var U=false;var t=new c({showItemAsLink:!F,showReset:s,showResetEnabled:{path:'$selectionDialog>/showResetEnabled'},items:A.map(function(v){var w=f._getItemById(v.id,l);var x=this._isItemBaseline(v);var y=v.icon;if(k&&!y){y="sap-icon://chain-link";}return new d({key:v.id,text:v.text,description:v.description,href:v.href,target:v.target,icon:y,visible:w?w.visible:false,isBaseline:x});}.bind(this)),visibilityChanged:function(E){var v=E.getParameter("key");q(v,E.getParameter("visible"));u.call(this,E.getSource());}.bind(this),ok:function(){var v=this;var w=function(){var x=e.createChanges(v,R);var y=[];h.add({changes:x,ignoreVariantManagement:true}).then(function(z){y=y.concat(z);var D=P.createChanges(R);return h.add({changes:D,ignoreVariantManagement:true});}).then(function(z){y=y.concat(z);return h.save({selector:v,changes:y});}).then(function(){p(t);return r(true);});};if(U){h.reset({selectors:this.getItems()}).then(function(){w();});}else{w();}}.bind(this),cancel:function(){p(t);return r(true);},reset:function(){R=[];U=true;}});if(g){t.addStyleClass(g);}u.call(this,t);jQuery.sap.syncStyleClass("sapUiSizeCompact",this,t);t.setModel(this._getInternalModel(),"$selectionDialog");this.addDependent(t);t.open();}.bind(this));}.bind(this));}.bind(this));}.bind(this));};
f._showResetButtonEnabled=function(g,s){var h=false;var i=f._mapSelectionDialogItems(s);var j=f._getVisibleItems(i);var k=f._getVisibleItems(g);if(j.length!==g.length){h=true;}else if(k.length&&j.length){var A=f._allItemsIncludedInArray(k,j);var l=f._allItemsIncludedInArray(j,k);h=!A||!l;}return h;};
f._allItemsIncludedInArray=function(g,h){var A=true;g.forEach(function(i){var j=f._getItemsById(i.id,h);if(j.length===0){A=false;}});return A;};
f._getItemsById=function(i,g){return g.filter(function(o){return o.id===i;});};
f._getItemById=function(i,A){return f._getItemsById(i,A)[0];};
f._getVisibleItems=function(g){return g.filter(function(i){return i.id!==undefined&&i.visible;});};
f._mapSelectionDialogItems=function(s){return s.map(function(o){return{id:o.getKey(),visible:o.getVisible()};});};
f.prototype._isItemBaseline=function(i){var g=this._getInternalModel().getProperty("/baselineItems");return!!f._getItemsById(i.id,g).length;};
f.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel");};
f.prototype._propagateDefaultIcon=function(s){if(!s){return;}var o=this._getInternalModel();o.getProperty("/runtimeItems").forEach(function(g,i){if(!!g.icon){return;}o.setProperty("/runtimeItems/"+i+"/icon","sap-icon://chain-link");});};
function _(o){var g=this._getInternalModel();if(o.object.isA("sap.ui.mdc.link.Panel")){switch(o.name){case"additionalContent":var A=o.child?[o.child]:o.children;g.setProperty("/countAdditionalContent",A.length);break;case"items":var i=o.child?[o.child]:o.children;i.forEach(function(p){var r=g.getProperty("/runtimeItems/");switch(o.mutation){case"insert":g.setProperty("/countItemsWithIcon",p.getIcon()?g.getProperty("/countItemsWithIcon")+1:g.getProperty("/countItemsWithIcon"));g.setProperty("/countItemsWithoutIcon",p.getIcon()?g.getProperty("/countItemsWithoutIcon"):g.getProperty("/countItemsWithoutIcon")+1);r.splice(this.indexOfItem(p),0,p.getJson());g.setProperty("/runtimeItems",r);this._propagateDefaultIcon(g.getProperty("/countItemsWithIcon")>0&&g.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(p,{properties:["visible"]});break;case"remove":g.setProperty("/countItemsWithIcon",p.getIcon()?g.getProperty("/countItemsWithIcon")-1:g.getProperty("/countItemsWithIcon"));g.setProperty("/countItemsWithoutIcon",p.getIcon()?g.getProperty("/countItemsWithoutIcon"):g.getProperty("/countItemsWithoutIcon")-1);r.splice(this.indexOfItem(p),1);g.setProperty("/runtimeItems",r);this._propagateDefaultIcon(g.getProperty("/countItemsWithIcon")>0&&g.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(p);p.destroy();break;default:a.error("Mutation '"+o.mutation+"' is not supported yet.");}},this);break;case"enablePersonalization":this.byId("idSectionPersonalizationButton").setVisible(o.current);break;default:a.error("The property or aggregation '"+o.name+"' has not been registered.");}}else if(o.object.isA("sap.ui.mdc.link.PanelItem")){switch(o.name){case"visible":var p=o.object;var h=this.indexOfItem(p);if(p.getVisibleChangedByUser()){g.setProperty("/runtimeItems/"+h+"/visible",p.getVisible());}else{g.setProperty("/baselineItems/"+h+"/visible",p.getVisible());g.setProperty("/runtimeItems/"+h+"/visible",p.getVisible());}break;default:a.error("The '"+o.name+"' of PanelItem is not supported yet.");}}this._updateContentTitle();}
f.prototype.getContentTitle=function(){var o=this._getInternalModel();return o.getProperty("/contentTitle");};
f.prototype._updateContentTitle=function(){var o=this._getInternalModel();var A=this.getAdditionalContent();var g="idSectionPersonalizationButton";if(A.length>0){g=A[0];}else{var i=this.getItems();if(i.length>0){g=i[0];}}o.setProperty("/contentTitle",g);};
return f;});
sap.ui.predefine('sap/ui/mdc/link/PanelItem',['sap/ui/core/Element'],function(E){"use strict";
var P=E.extend("sap.ui.mdc.link.PanelItem",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/link/PanelItem.designtime",properties:{text:{type:"string"},description:{type:"string"},href:{type:"string"},target:{type:"string",defaultValue:undefined},icon:{type:"string"},visible:{type:"boolean",defaultValue:true},visibleChangedByUser:{type:"boolean"}}}});
P.prototype.getJson=function(){return{id:this.getId(),text:this.getText(),description:this.getDescription(),href:this.getHref(),icon:this.getIcon(),target:this.getTarget(),visible:this.getVisible(),visibleChangedByUser:this.getVisibleChangedByUser()};};
return P;});
sap.ui.predefine('sap/ui/mdc/link/PanelListItem',['sap/ui/core/XMLComposite'],function(X){"use strict";
var P=X.extend("sap.ui.mdc.link.PanelListItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string"},icon:{type:"string"},target:{type:"string",defaultValue:undefined},visible:{type:"boolean",defaultValue:true}},events:{pressLink:{allowPreventDefault:true,parameters:{target:{type:"string"}}}}}});
P.prototype.onPress=function(e){if(!this.firePressLink({href:e.getSource().getHref(),target:e.getSource().getTarget()})){e.preventDefault();}};
return P;});
sap.ui.predefine('sap/ui/mdc/link/SelectionDialog',['sap/ui/core/XMLComposite','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/base/ManagedObjectObserver','sap/base/Log','sap/ui/Device','sap/ui/model/json/JSONModel','sap/m/MessageBox'],function(X,F,a,M,L,D,J,b){"use strict";
var S=X.extend("sap.ui.mdc.link.SelectionDialog",{metadata:{library:"sap.ui.mdc",properties:{showItemAsLink:{type:"boolean",defaultValue:true,invalidate:true},showReset:{type:"boolean",defaultValue:false,invalidate:true},showResetEnabled:{type:"boolean",defaultValue:false,invalidate:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SelectionDialogItem",multiple:true,singularName:"item"}},events:{visibilityChanged:{key:{type:"string"},visible:{type:"boolean"}},ok:{},cancel:{},reset:{}}}});
S.prototype.init=function(){var d=new J(D);d.setDefaultBindingMode("OneWay");d.setSizeLimit(1000);this.setModel(d,"device");this._getManagedObjectModel().setSizeLimit(1000);this._bUnconfirmedResetPressed=false;};
S.prototype.open=function(){this._getManagedObjectModel().setProperty("/@custom/countOfItems",this._getTable().getItems().length);this._updateCountOfSelectedItems();this._getCompositeAggregation().open();};
S.prototype.close=function(){this._getCompositeAggregation().close();};
S.prototype.onSelectionChange=function(e){e.getParameter("listItems").forEach(function(t){this._selectTableItem(t);},this);};
S.prototype.onSearchFieldLiveChange=function(e){var f=[];var s=e.getSource();var c=s?s.getValue():"";if(c){f.push(new F([new F("text",a.Contains,c),new F("tooltip",a.Contains,c),new F("description",a.Contains,c)],false));}this._getTable().getBinding("items").filter(f);};
S.prototype.onPressOk=function(){this.fireOk();};
S.prototype.onPressCancel=function(){this.fireCancel();};
S.prototype.onPressReset=function(){this._resetSelection();this.fireReset();};
S.prototype.onAfterClose=function(){this.fireCancel();};
S.prototype.onPressLink=function(e){var h=e.getParameter("href");if(this.getParent().getBeforeNavigationCallback()&&e.getParameter("target")!=="_blank"){e.preventDefault();this.getParent().getBeforeNavigationCallback()(e).then(function(n){if(n){window.location.href=h;}});}else if(e.getParameter("target")!=="_blank"){e.preventDefault();b.show(sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_QUESTION"),{icon:b.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_TITLE"),actions:[b.Action.YES,b.Action.NO],onClose:function(A){if(A===b.Action.YES){window.location.href=h;}},styleClass:this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}};
S.prototype._selectTableItem=function(t){this._updateCountOfSelectedItems();this.fireVisibilityChanged({key:this._getKeyByTableItem(t),visible:t.getSelected()});};
S.prototype._getTable=function(){return sap.ui.getCore().byId(this.getId()+"--idList")||null;};
S.prototype._getSelectedTableContextPaths=function(){return this._getTable().getSelectedContextPaths();};
S.prototype._getKeyByTableItem=function(t){var i=this._getTable().indexOfItem(t);return i<0?null:this._getTable().getBinding("items").getContexts()[i].getObject().getKey();};
S.prototype._updateCountOfSelectedItems=function(){this._getManagedObjectModel().setProperty("/@custom/countOfSelectedItems",this._getSelectedTableContextPaths().length);};
S.prototype._resetSelection=function(){var t=this._getTable();if(t){t.getItems().forEach(function(T){var i=t.indexOfItem(T);var I=t.getBinding("items").getContexts()[i].getObject().getIsBaseline();if(T.getSelected()!==I){T.setSelected(I);this._selectTableItem(T);}}.bind(this));}};
return S;});
sap.ui.predefine('sap/ui/mdc/link/SelectionDialogItem',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SelectionDialogItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string",defaultValue:undefined},target:{type:"string"},icon:{type:"string"},visible:{type:"boolean",defaultValue:false},isBaseline:{type:"boolean",defaultValue:false}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectMapping',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectMappingItem',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectUnavailableAction',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/odata/json/FilterBarDelegate',["sap/ui/mdc/FilterBarDelegate",'sap/base/util/merge','sap/ui/mdc/util/IdentifierUtil'],function(F,m,I){"use strict";var J=Object.assign({},F);
J._createFilterField=function(p,f,P){var M=P.modifier;var n=p.path||p.name;var s={};if(f.getId){s.id=f.getId();}else{s.id=f.id;}var S=M.getControlIdBySelector(s,P.appComponent);var i=S+"--filter--"+I.replace(n);return M.createControl("sap.ui.mdc.FilterField",P.appComponent,P.view,i,{dataType:p.typeConfig.className,conditions:"{$filters>/conditions/"+n+'}',required:p.required,label:p.label,maxConditions:p.maxConditions,delegate:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},true).then(function(o){if(p.fieldHelp){var a=p.fieldHelp;if(P.view.getId){a=P.view.getId()+"--"+p.fieldHelp;}else{a=P.viewId+"--"+p.fieldHelp;}M.setAssociation(o,"fieldHelp",a);}if(p.filterOperators){if(f.getId){M.setProperty(o,"operators",p.filterOperators);}else{M.setProperty(o,"operators",p.filterOperators.join(','));}}if(p.tooltip){M.setProperty(o,"tooltip",p.tooltip);}if(p.constraints){M.setProperty(o,"dataTypeConstraints",p.constraints);}if(p.formatOptions){M.setProperty(o,"dataTypeFormatOptions",p.formatOptions);}if(p.display){M.setProperty(o,"display",p.display);}return o;});};
J.addItem=function(p,f,P){return J.fetchProperties().then(function(a){var o=null;a.some(function(b){if(p===I.getPropertyKey(b)){o=b;}return o!==null;});if(o){return Promise.resolve(J._createFilterField(o,f,P));}else{return Promise.resolve(null);}});};
J.removeItem=function(f,o,p){return Promise.resolve(true);};
J.fetchProperties=function(f){return new Promise(function(r,a){r([]);});};
return J;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FieldBaseDelegate',["sap/ui/mdc/field/FieldBaseDelegate","sap/ui/mdc/odata/v4/TypeUtil"],function(F,T){"use strict";var O=Object.assign({},F);
O.getDataTypeClass=function(p,t){return T.getDataTypeClassName(t);};
O.getBaseType=function(p,t,f,c){return T.getBaseType(t,f,c);};
O.initializeTypeFromBinding=function(p,t,v){var r={};if(t&&(t.isA("sap.ui.model.odata.type.Unit")||t.isA("sap.ui.model.odata.type.Currency"))&&Array.isArray(v)&&v.length>2&&v[2]!==undefined){t.formatValue(v,"string");r.bTypeInitialized=true;r.mCustomUnits=v[2];}return r;};
O.initializeInternalUnitType=function(p,t,o){if(o&&o.mCustomUnits!==undefined){t.formatValue([null,null,o.mCustomUnits],"string");}};
O.getDefaultFieldValueHelpDelegate=function(p){return{name:"sap/ui/mdc/odata/v4/FieldValueHelpDelegate",payload:{}};};
O.getTypeUtil=function(p){return T;};
return O;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FieldValueHelpDelegate',['sap/ui/mdc/field/FieldValueHelpDelegate','sap/ui/model/FilterType','sap/ui/mdc/odata/v4/TypeUtil'],function(F,a,T){"use strict";var O=Object.assign({},F);
O.isSearchSupported=function(p,l){return!!l.changeParameters;};
O.executeSearch=function(p,l,s){if(s){l.changeParameters({$search:s});}else{l.changeParameters({$search:undefined});}};
O.executeFilter=function(p,l,f,c,r){var _=false;var h=function(P){if(P.mParameters.detailedReason){return;}if(!_){_=true;l.detachEvent("change",h);c();}};l.attachEvent("change",h);l.attachEventOnce("dataReceived",h);l.initialize();l.filter(f,a.Application);l.getContexts(0,r);};
O.checkBindingsPending=function(p,b){var P=[];for(var i=0;i<b.length;i++){var B=b[i];if(B&&B.requestValue){P.push(B.requestValue());}}if(P.length>0){return Promise.all(P);}return null;};
O.getTypeUtil=function(p){return T;};
return O;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FilterBarDelegate',['./ODataMetaModelUtil','sap/ui/mdc/enum/FieldDisplay',"sap/ui/fl/Utils","sap/ui/mdc/FilterBarDelegate",'sap/base/util/ObjectPath','sap/base/util/merge','sap/ui/mdc/odata/v4/TypeUtil','sap/ui/mdc/condition/FilterOperatorUtil',"sap/ui/model/FilterOperator","sap/ui/model/Filter",'sap/ui/mdc/util/IdentifierUtil','sap/ui/core/util/reflection/JsControlTreeModifier','sap/base/Log'],function(O,F,a,b,c,m,T,d,M,e,I,J,L){"use strict";var f=Object.assign({},b);var D={"Edm.Boolean":"Bool","Edm.Byte":"Int","Edm.DateTime":"Date","Edm.DateTimeOffset":"DateTimeOffset","Edm.Decimal":"Decimal","Edm.Double":"Float","Edm.Float":"Float","Edm.Guid":"Guid","Edm.Int16":"Int","Edm.Int32":"Int","Edm.Int64":"Int","Edm.SByte":"Int","Edm.Single":"Float","Edm.String":"String","Edm.Time":"TimeOfDay"};var g={};
f._fetchPropertiesByMetadata=function(o,p){var h,i,C,j,k;if(p){var l=p.modifier;h=l.getProperty(o,"delegate");i=h.payload.modelName===null?undefined:h.payload.modelName;C=h.payload.collectionName;j=p.appComponent.getModel(i);}else{h=o.getProperty("delegate");i=h.payload.modelName===null?undefined:h.payload.modelName;C=h.payload.collectionName;j=o.getModel(i);}k=o.getId?o.getId():o.id;var n={getDelegate:function(){return{payload:{modelName:i,collectionName:C}};},getModel:function(s){return j;},getId:function(){return k;}};return this.fetchProperties(n);};
f._ensureSingleRangeEQOperators=function(){var o;if(!d.getOperator("SINGLE_RANGE_EQ")){o=m({},d.getOperator("EQ"));o.name="SINGLE_RANGE_EQ";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GE,C.values[0]),new e(s,M.LE,C.values[0])],and:true});};d.addOperator(o);}if(!d.getOperator("SINGLE_RANGE_EQ")){o=m({},d.getOperator("EQ"));o.name="SINGLE_RANGE_EQ";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GE,C.values[0]),new e(s,M.LE,C.values[0])],and:true});};d.addOperator(o);}};
f._ensureMultiRangeBTEXOperator=function(){if(!d.getOperator("MULTI_RANGE_BTEX")){var o=m({},d.getOperator("BT"));o.name="MULTI_RANGE_BTEX";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GT,C.values[0]),new e(s,M.LT,C.values[1])],and:true});};d.addOperator(o);}};
f._getFilterOperators=function(s){var o=null,h=null;switch(s){case"SingleValue":case"MultiValue":o="EQ";break;case"SingleRange":o="SINGLE_RANGE_EQ,SINGLE_RANGE_EQ,LE,GE";this._ensureSingleRangeEQOperators();break;case"MultiRange":o="EQ,LE,LT,GE,GT,BT,MULTI_RANGE_BTEX";this._ensureMultiRangeBTEXOperator();break;case"SearchExpression":o="StartsWith,EndsWith,Contains";break;case"MultiRangeOrSearchExpression":o="StartsWith,EndsWith,Contains,EQ,LE,LT,GE,GT,BT,MULTI_RANGE_BTEX";this._ensureMultiRangeBTEXOperator();break;default:break;}if(o){h=o.split(',');}return h;};
f._createFilterField=function(p,o,P){var h=P?P.modifier:J;var A=P?P.appComponent:a.getAppComponentForControl(o);var v=P?P.view:a.getViewForControl(o);var V=P?P.viewId:null;var n=p.path||p.name;var s={};if(o.getId){s.id=o.getId();}else{s.id=o.id;}var S=h.getControlIdBySelector(s,A);var i=S+"--filter--"+I.replace(n);var E=sap.ui.getCore().byId(i);if(E){return Promise.resolve(E);}return h.createControl("sap.ui.mdc.FilterField",A,v,i,{dataType:p.typeConfig.className,conditions:"{$filters>/conditions/"+n+'}',required:p.required,label:p.label||p.name,maxConditions:p.maxConditions,delegate:{name:"sap/ui/mdc/odata/v4/FieldBaseDelegate",payload:{}}},true).then(function(j){if(p.fieldHelp){var k=p.fieldHelp;if(!V){k=v.createId(p.fieldHelp);}else{k=V+"--"+p.fieldHelp;}h.setAssociation(j,"fieldHelp",k);}if(p.filterOperators){if(o.getId){h.setProperty(j,"operators",p.filterOperators);}else{h.setProperty(j,"operators",p.filterOperators.join(','));}}if(p.tooltip){h.setProperty(j,"tooltip",p.tooltip);}if(p.constraints){h.setProperty(j,"dataTypeConstraints",p.constraints);}if(p.formatOptions){h.setProperty(j,"dataTypeFormatOptions",p.formatOptions);}if(p.display){h.setProperty(j,"display",p.display);}return j;});};
f._createFilter=function(p,o,P){return this._fetchPropertiesByMetadata(o,P).then(function(h){var i=h.find(function(j){return(I.getPropertyKey(j)===p);});if(!i){return null;}return Promise.resolve(this._createFilterField(i,o,P));}.bind(this));};
f.addItem=function(p,o,P){return Promise.resolve(this._createFilter(p,o,P));};
f.removeItem=function(o,h,p){return Promise.resolve(true);};
f._getFieldGroupsByFilterFacetsAnnotation=function(o,E){};
f._getNavigationPropertyForParameter=function(E){var o;for(var k in E){o=E[k];if(o){if(o.$kind==="NavigationProperty"){return k;}}}return null;};
f._fetchPropertyInfo=function(o,E,n,h,k){var i=o.getObject(E+"/"+"@com.sap.vocabularies.UI.v1.TextArrangement");var H=false;if(o.getObject(E+"/"+k+"@com.sap.vocabularies.UI.v1.HiddenFilter")){H=true;}var j=false;if(o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.IsDigitSequence")){j=true;}var l=null;var p=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.FilterDefaultValue");if(p){var v=p["$"+D[h.$Type]];switch(h.$Type){case"Edm.DateTimeOffset":l=v;break;default:l=v;}}var s=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Label")||k;var t=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.QuickInfo")||null;var C={};if(h.$MaxLength||h.$Precision||h.$Scale||j){if(h.$MaxLength){C.maxLength=h.$MaxLength;}if(h.$Precision){C.precision=h.$Precision;}if(h.$Scale){C.scale=h.$Scale;}if(j){C.isDigitSequence=j;}}else{C=null;}var q,r=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Text");if(r){var u=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Text@com.sap.vocabularies.UI.v1.TextArrangement")||i;if(u){if(u.$EnumMember==="com.sap.vocabularies.UI.v1.TextArrangementType/TextOnly"){q=F.Description;}else if(u.$EnumMember==="com.sap.vocabularies.UI.v1.TextArrangementType/TextLast"){q=F.ValueDescription;}else{q=F.DescriptionValue;}}else{q=F.DescriptionValue;}}var P={name:k,label:s,tooltip:t,hiddenFilter:H};if(q){P.display=q;}if(h.$Type==="Edm.DateTimeOffset"){if(!C){C={};}C.V4=true;}if(C){P.constraints=C;}if(l){P.defaultFilterConditions=[{fieldPath:k,operator:"EQ",values:[l]}];}P.name=n?n+"/"+k:k;P.typeConfig=T.getTypeConfig(h.$Type,P.formatOptions,P.constraints);return P;};
f._fetchEntitySet=function(o,E,v,n,p){return Promise.all([o.requestObject(E+"/"),o.requestObject(E+"@")]).then(function(r){var h=r[0];var i=r[1]||{};if(!h){return Promise.resolve([]);}var j,P,k=[],l=[],N=[],R=[],s=[],A={},q={},t=false;var u=o.getObject(E);if(u&&u.$NavigationPropertyBinding){q=u.$NavigationPropertyBinding;}var w=i["@Org.OData.Capabilities.V1.FilterRestrictions"];if(w){if(w.NonFilterableProperties){N=w.NonFilterableProperties.map(function(C){return C.$PropertyPath;});}if(w.RequiredProperties){R=w.RequiredProperties.map(function(C){return C.$PropertyPath;});}if(w.FilterExpressionRestrictions){w.FilterExpressionRestrictions.forEach(function(C){A[C.Property.$PropertyPath]=C.AllowedExpressions;});}}w=o.getObject(E+"/"+"@com.sap.vocabularies.UI.v1.SelectionFields");if(w){s=w.map(function(C){return C.$PropertyPath;});}var x=o.getObject(E+"/@sapui.name");var G=x;var y=o.getObject(E+"@com.sap.vocabularies.Common.v1.Label");if(!y){y=G.split(".")[1];}v.push(x);w=o.getObject(E+"/"+"@com.sap.vocabularies.Common.v1.ResultContext");if(w){t=true;p.parameterNavigationName=f._getNavigationPropertyForParameter(h);}if(!n){var S=x.split('.');p.parameterEntityType=S[S.length-1];}for(var K in h){j=h[K];if(j){if(t&&(K==="$Key")){p.parameters=m([],j);}else if(j.$kind==="Property"){if(N.indexOf(K)>=0){continue;}if(o.getObject(E+"/"+K+"@com.sap.vocabularies.UI.v1.Hidden")){continue;}if(j.$isCollection){L.warning("Complex property with type "+j.$Type+" has been ignored");continue;}P=f._fetchPropertyInfo(o,E,n,j,K,p);if(P){P.group=G;P.groupLabel=y;P.required=R.indexOf(K)>=0;P.visible=s.indexOf(K)>=0;if(A[K]){var z=f._getFilterOperators(A[K]);if(z){P.filterOperators=z;}}P.maxConditions=O.isMultiValueFilterExpression(A[K])?-1:1;if(t&&p&&(p.parameters.indexOf(K)>-1)){P.path=null;P.name=K;P.required=true;p.parameterTypes[K]=j.$Type;k.push(P);}else if(!t){k.push(P);}}}else if(!t&&(j.$kind==="NavigationProperty")&&(!j.$isCollection)){var B=q[K];if(B&&(v.indexOf(j.$Type)===-1)){l.push(f._fetchEntitySet(o,'/'+B,v,K,p));}}}}return Promise.all(l).then(function(C){C.forEach(function(H){k=k.concat(H);});return k;});});};
f._setModel=function(){var s=this.getPayload().modelName;s=s===null?undefined:s;var o=this.getModel(s);if(o){this.detachModelContextChange(f._setModel,this);f._fModelProvided(o);}};
f._waitForMetaModel=function(o,p){return new Promise(function(r,h){var s=p===null?undefined:p;var i=o.getModel(s);if(i){r(i);}if(!o.attachModelContextChange){h();}f._fModelProvided=r;o.attachModelContextChange(f._setModel,o);});};
f.fetchProperties=function(o){var s=o.getDelegate().payload.modelName;var E=o.getDelegate().payload.collectionName;return new Promise(function(r,h){var i;var C=o.getId()+'->'+E;if(g[C]){r(g[C]);return;}this._waitForMetaModel(o,s).then(function(j){if(!j||!E){h("model or entity set name not available");return;}i=j.getMetaModel();if(!i){h("metadata model not available");}else{var v=[];var p={parameterNavigationName:null,parameters:[],parameterTypes:{}};f._fetchEntitySet(i,'/'+E,v,null,p).then(function(P){if(p.parameterNavigationName&&(p.parameters.length>0)){window[o.getId()+'->'+E+"-Parameters"]=p;P.sort(function(l,n){var q=l.path||l.name;var t=n.path||n.name;if((!(p.parameters.indexOf(q)>-1)&&!(p.parameters.indexOf(t)>-1))||((p.parameters.indexOf(q)>-1)&&(p.parameters.indexOf(t)>-1))){return 0;}if((p.parameters.indexOf(q)>-1)&&!(p.parameters.indexOf(t)>-1)){return-1;}if(!(p.parameters.indexOf(q)>-1)&&(p.parameters.indexOf(t)>-1)){return 1;}});}var k=P.reduce(function(l,n){l[n.name]=n;return l;},{});P=Object.keys(k).map(function(n){return k[n];});g[C]=P;r(P);});}},function(){h("model not obtained");});}.bind(this));};
f.cleanup=function(o){var s=o.getId()+"->";Object.keys(g).forEach(function(k){if(k.indexOf(s)===0){delete window[s+k+"-Parameters"];delete g[k];}});};
f.getTypeUtil=function(p){return T;};
return f;});
sap.ui.predefine('sap/ui/mdc/odata/v4/TableDelegate',["sap/ui/mdc/TableDelegate",'sap/ui/core/Core','sap/ui/mdc/util/FilterUtil','sap/ui/mdc/odata/v4/util/DelegateUtil','sap/ui/mdc/odata/v4/FilterBarDelegate','./ODataMetaModelUtil','sap/ui/mdc/odata/v4/TypeUtil','sap/ui/model/Filter','sap/base/Log'],function(T,C,F,D,a,O,b,c,L){"use strict";var d=Object.assign({},T);
d.fetchProperties=function(t){var m=t.getDelegate().payload,M;M=t.getModel(m.model);return new Promise(function(r){if(!M){t.attachModelContextChange({resolver:r},o);}else{e(t,M).then(r);}});};
function o(E,f){var t=E.getSource();var m=t.getDelegate().payload;var M=t.getModel(m.model);if(M){e(t,M).then(f.resolver);t.detachModelContextChange(o);}}
function e(t,m){var M=t.getDelegate().payload,p=[],P,f,g;var E="/"+M.collectionName;var h=m.getMetaModel();return Promise.all([h.requestObject(E+"/"),h.requestObject(E+"@")]).then(function(r){var i=r[0],j=r[1];var s=j["@Org.OData.Capabilities.V1.SortRestrictions"]||{};var S=O.getSortRestrictionsInfo(s);var k=j["@Org.OData.Capabilities.V1.FilterRestrictions"];var l=O.getFilterRestrictionsInfo(k);for(var K in i){f=i[K];if(f&&f.$kind==="Property"){if(f.$isCollection){L.warning("Complex property with type "+f.$Type+" has been ignored");continue;}g=h.getObject(E+"/"+K+"@");P={name:K,label:g["@com.sap.vocabularies.Common.v1.Label"]||K,description:g["@com.sap.vocabularies.Common.v1.Text"]&&g["@com.sap.vocabularies.Common.v1.Text"].$Path,maxLength:f.$MaxLength,precision:f.$Precision,scale:f.$Scale,type:f.$Type,sortable:S[K]?S[K].sortable:true,filterable:l[K]?l[K].filterable:true,typeConfig:t.getTypeUtil().getTypeConfig(f.$Type),fieldHelp:undefined,maxConditions:O.isMultiValueFilterExpression(l.propertyInfo[K])?-1:1};p.push(P);}}t.data("$tablePropertyInfo",p);return p;});}
d.updateBindingInfo=function(m,M,B){if(!m){return;}if(M&&B){B.path=B.path||M.collectionPath||"/"+M.collectionName;B.model=B.model||M.model;}if(!B){B={};}var f=C.byId(m.getFilter()),g=m.isFilteringEnabled(),h;var i,j;var k=[];if(g){h=m.getConditions();var t=m.data("$tablePropertyInfo");i=F.getFilterInfo(m,h,t);if(i.filters){k.push(i.filters);}}if(f){h=f.getConditions();if(h){var p=f.getPropertyInfoSet?f.getPropertyInfoSet():null;var P=D.getParameterNames(f);j=F.getFilterInfo(f,h,p,P);if(j.filters){k.push(j.filters);}var s=D.getParametersInfo(f,h);if(s){B.path=s;}}var S=f.getSearch();if(S){if(!B.parameters){B.parameters={};}B.parameters.$search=S;}}B.filters=new c(k,true);};
d.getFilterDelegate=function(){return{addFilterItem:function(p,t){return a._createFilterField(p,t);}};};
d.getTypeUtil=function(p){return b;};
return d;});
sap.ui.predefine('sap/ui/mdc/odata/v4/util/DelegateUtil',['sap/ui/mdc/util/FilterUtil',"sap/ui/mdc/condition/ConditionConverter",'sap/base/Log','sap/base/util/merge',"sap/ui/model/odata/v4/ODataUtils"],function(F,C,L,m,O){"use strict";var D={_getParameters:function(M){var p=null;if(M&&M.getDelegate()&&M.getDelegate().payload&&M.getDelegate().payload.collectionName){var e=M.getDelegate().payload.collectionName;if(window[M.getId()+'->'+e+"-Parameters"]){p=window[M.getId()+'->'+e+"-Parameters"];}}return p;},_getParameterPath:function(M,c,p){var i,f,I={},o;var P,e;if(!p||(p.parameters.length<=0)){return null;}var a=M.getPropertyInfoSet?M.getPropertyInfoSet():null;if(!a){return null;}var E=M.getDelegate().payload.collectionName;for(f in c){var b=F.getPropertyByKey(a,f);if(b&&(p.parameters.indexOf(f)>=0)){I[f]=[];for(i=0;i<c[f].length;i++){o=m({},c[f][i]);I[f].push(C.toType(o,b.typeConfig,M.getTypeUtil()));}}else if(!b){L.error("no such property: "+f);}}P=[];for(i=0;i<p.parameters.length;i++){f=p.parameters[i];if(I[f]&&(I[f].length>0)){e=p.parameterTypes[f];P.push(f+'='+encodeURIComponent(O.formatLiteral(I[f][0].values[0],e)));}else{L.error("no value found parameter '"+f+"'");}}return'/'+E+'('+P.toString()+")/"+p.parameterNavigationName;},getParametersInfo:function(M,c){var p=D._getParameters(M);return D._getParameterPath(M,c,p);},getParameterNames:function(M){var p=null,P=D._getParameters(M);if(P){p=P.parameters;}return p;}};return D;},true);
sap.ui.predefine('sap/ui/mdc/p13n/AdaptationController',["sap/base/util/UriParameters","sap/ui/base/ManagedObject","sap/ui/mdc/p13n/FlexUtil","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/base/Log","./P13nBuilder"],function(S,M,F,J,m,L,P){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var u=new S(window.location.search);
var A=M.extend("sap.ui.mdc.AdaptationController",{
library:"sap.ui.mdc",
metadata:{properties:{adaptationControl:{type:"object"},liveMode:{type:"boolean",defaultValue:false},itemConfig:{type:"object"},sortConfig:{type:"object",defaultValue:{changeOperations:{add:"addSort",remove:"removeSort",move:"moveSort"},adaptationUI:"sap/ui/mdc/p13n/panels/SortPanel",containerSettings:{title:r.getText("sort.PERSONALIZATION_DIALOG_TITLE")}}},filterConfig:{type:"object",defaultValue:{adaptationUI:null,initializeControl:null,containerSettings:{title:r.getText("filter.PERSONALIZATION_DIALOG_TITLE")}}},stateRetriever:{type:"function"},retrievePropertyInfo:{type:"function"},afterChangesCreated:{type:"function"},onReset:{type:"function"}},events:{beforeP13nContainerOpens:{container:{type:"object"}},afterP13nContainerCloses:{container:{type:"object"},reason:{type:"string"}}}}
});
A.prototype.init=function(){this.oAdaptationModel=new J();this.oAdaptationModel.setSizeLimit(10000);this.oState={};this.bIsDialogOpen=false;};
A.prototype.showP13n=function(s,p){if(u.getAll("sap-ui-xx-p13nLiveMode")[0]==="true"){this.setLiveMode(true);L.warning("Please note that the p13n liveMode is experimental");}if(!this.bIsDialogOpen){this.bIsDialogOpen=true;return this._retrievePropertyInfo().then(function(a){return this.createP13n(p,a).then(function(o){var v=u.getAll("sap-ui-xx-filterView")[0];if(v==="list"&&o&&o.getContent()[0]&&o.getContent()[0]._oFilterBarLayout&&o.getContent()[0]._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.GroupPanelBase")){o.getContent()[0]._oFilterBarLayout.getInner().switchViewMode("list");}this._openP13nControl(o,s);return o;}.bind(this),function(){this.bIsDialogOpen=false;L.warning("P13n container creation failed");}.bind(this));}.bind(this));}};
A.prototype.createP13n=function(p,a){return new Promise(function(b,c){this.aPropertyInfo=a;this._retrieveControl(this.getAdaptationControl().getDelegate().name).then(function(d){if(!(a instanceof Array)){c("Please provide a property info array to create a p13n control");}this.oAdaptationControlDelegate=d;this.sP13nType=p;this._retrieveP13nContainer().then(function(C){var o=C.getContent()[0];var e=this._prepareAdaptationData(a);this._setP13nModelData(e);o.setP13nModel(this.oAdaptationModel);if(o.setLiveMode){o.setLiveMode(this.getLiveMode());}var f=this.getTypeConfig(p).initializeControl;f.call(o).then(function(){this.getAdaptationControl().addDependent(C);b(C);}.bind(this));}.bind(this));}.bind(this),c);}.bind(this));};
A.prototype.createSortChanges=function(n,a){return this._executeAfterAsyncActions(function(){var c=m({},this.getStateRetriever().call(this.getAdaptationControl(),this.oAdaptationControlDelegate));var p=c.sorters||[];var s=this.getSortConfig();var f=function(o){return o.name+o.descending;};var b=function(i){return i.hasOwnProperty("sorted")&&i.sorted===false?false:true;};var N=a?n:this._getFilledArray(p,n,"sorted").filter(b);var d=F.getArrayDeltaChanges(p,N,f,this.getAdaptationControl(),s.changeOperations);if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,d,"Sort");}return d;}.bind(this));};
A.prototype.createItemChanges=function(n){return this._executeAfterAsyncActions(function(){var a=this.getAdaptationControl();var c=m({},this.getStateRetriever().call(a,this.oAdaptationControlDelegate));var p=c.items;var i=this.getItemConfig();var s=function(o){var d=o.name;if(i&&i.additionalDeltaAttributes&&i.additionalDeltaAttributes instanceof Array){i.additionalDeltaAttributes.forEach(function(b){d+=o[b];});}return d;};var f=function(o){return o.hasOwnProperty("visible")&&o.visible===false?false:true;};var N=this._getFilledArray(p,n,"visible").filter(f);var I=F.getArrayDeltaChanges(p,N,s,this.getAdaptationControl(),i.changeOperations);if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,I,"Item");}return I;}.bind(this));};
A.prototype.createConditionChanges=function(n){return this._executeAfterAsyncActions(function(){var c=[];var C=m({},this.getStateRetriever().call(this.getAdaptationControl(),this.oAdaptationControlDelegate));var p=C.filter;var a=this.getAdaptationControl();for(var f in n){var v=this._hasProperty(f).valid;if(!v){L.warning("property '"+f+"' not supported");continue;}c=c.concat(F.getConditionDeltaChanges(f,n[f],p[f],a));}if(this.getAfterChangesCreated()){this.getAfterChangesCreated()(this,c,"Value");}return c;}.bind(this));};
A.prototype._retrievePropertyInfo=function(){return new Promise(function(a,b){if(this.aPropertyInfo){a(this.aPropertyInfo);}else if(this.getRetrievePropertyInfo()){this.aPropertyInfo=this.getRetrievePropertyInfo().call(this.getAdaptationControl());a(this.aPropertyInfo);}else{this._retrieveControl(this.getAdaptationControl().getDelegate().name).then(function(d){this.oAdaptationControlDelegate=d;d.fetchProperties(this.getAdaptationControl()).then(function(p){this.aPropertyInfo=p;a(this.aPropertyInfo);}.bind(this));}.bind(this));}}.bind(this));};
A.prototype._executeAfterAsyncActions=function(c){return new Promise(function(a,b){this._retrievePropertyInfo().then(function(p){a(c());});}.bind(this));};
A.prototype.getTypeConfig=function(p){var o=this["get"+p+"Config"]?this["get"+p+"Config"]():undefined;return{changeOperations:o?o.changeOperations:{},ignoreIndex:o?o.ignoreIndex:false,adaptationUI:o?o.adaptationUI:undefined,initializeControl:o&&o.initializeControl?o.initializeControl:function(){return Promise.resolve();},containerSettings:o&&o.containerSettings?o.containerSettings:{},sortData:o&&o.hasOwnProperty("sortData")?o.sortData:true};};
A.prototype._openP13nControl=function(p,s){this.fireBeforeP13nContainerOpens({container:p});if(this.getLiveMode()){p.openBy(s);}else{p.open();}};
A.prototype._getFilledArray=function(p,n,R){var N=m([],p);var a=m([],n);var e=P.arrayToMap(p);a.forEach(function(i){var E=e[i.name];if(!i.hasOwnProperty(R)||i[R]){var b=i.position;if(E){b=b>-1?b:E.position;var o=E.position;N.splice(b,0,N.splice(o,1)[0]);}else{b=b>-1?b:N.length;N.splice(b,0,i);}N[b]=i;}else if(E){N[E.position][R]=false;}});return N;};
A.prototype._prepareAdaptationData=function(p){var a=this.getAdaptationControl();var c=m({},this.getStateRetriever().call(a,this.oAdaptationControlDelegate));var i=this._getTypeIgnoreValues(this.sP13nType);var s=this.getTypeConfig(this.sP13nType).sortData;return P.prepareP13nData(c,p,i,s?this.sP13nType:"generic");};
A.prototype._getTypeIgnoreValues=function(p){var i;if(this.sP13nType=="Sort"){i=[{ignoreKey:"sortable",ignoreValue:false}];}if(this.sP13nType=="Filter"){i=[{ignoreKey:"filterable",ignoreValue:false}];}return i;};
A.prototype._setP13nModelData=function(p){this.oAdaptationModel.setProperty("/items",p.items);this.oAdaptationModel.setProperty("/itemsGrouped",p.itemsGrouped);this.oState=m({},p);};
A.prototype.resetP13n=function(){return F.discardChanges({selector:this.getAdaptationControl()}).then(function(){var p=this._prepareAdaptationData(this.aPropertyInfo);this.oState=m({},p);this.oAdaptationModel.setProperty("/items",p.items);this.oAdaptationModel.setProperty("/itemsGrouped",p.itemsGrouped);}.bind(this));};
A.prototype._retrieveP13nContainer=function(){return new Promise(function(a,b){var l=this.getLiveMode();var v=this.getTypeConfig(this.sP13nType).adaptationUI;var p=function(o){if(l&&!this.bInitialized&&o.attachChange){o.attachChange(function(){this._handleChange();}.bind(this));}this._createP13nContainer(o).then(function(d){a(d);});}.bind(this);if(typeof v==="string"){var s=v;this._retrieveControl(s).then(function(d){var e=new d();p(e);});}else if(v instanceof Function){var c=v.call(this.getAdaptationControl());if(c instanceof Promise){c.then(function(o){p(o);});}else{p(c);}}else if(v.isA("sap.ui.core.Control")){var o=v;p(o);}else{b(new Error("Please provide either a BasePanel derivation or a custom Control as personalization UI for AdaptationController"));}}.bind(this));};
A.prototype._retrieveControl=function(p){return new Promise(function(a,b){sap.ui.require([p],function(C){a(C);},b);});};
A.prototype._createP13nContainer=function(p){var c;if(this.getLiveMode()){c=this._createPopover(p);}else{c=this._createModalDialog(p);}return c.then(function(C){C.addStyleClass("sapUiMdcPersonalizationDialog");if(!this.getLiveMode()){C.setEscapeHandler(function(d){this._closeDialog(C,"Cancel");d.resolve();}.bind(this));}C.toggleStyleClass("sapUiSizeCompact",!!jQuery(this.getAdaptationControl()).closest(".sapUiSizeCompact").length);return C;}.bind(this));};
A.prototype._addResetInfo=function(s){if(this.getOnReset()){s.reset={title:s.title,onExecute:this.getOnReset().bind(this.getAdaptationControl())};}};
A.prototype._createPopover=function(p){var a=function(e){var o=e.getSource();this.fireAfterP13nContainerCloses({reason:"autoclose",container:o});o.destroy();this.bIsDialogOpen=false;}.bind(this);var s=Object.assign({verticalScrolling:true,afterClose:a},this.getTypeConfig(this.sP13nType).containerSettings);this._addResetInfo(s);return P.createP13nPopover(p,s);};
A.prototype._createModalDialog=function(p){var d=function(e){var o=e.getSource().getParent();this._handleChange();this._closeDialog(o,"Ok");}.bind(this);var D=function(e){var c=e.getSource().getParent();this._closeDialog(c,"Cancel");}.bind(this);var s=Object.assign({verticalScrolling:true,confirm:{handler:d},cancel:D},this.getTypeConfig(this.sP13nType).containerSettings);this._addResetInfo(s);return P.createP13nDialog(p,s);};
A.prototype._closeDialog=function(c,R){c.close();this.bIsDialogOpen=false;this.fireAfterP13nContainerCloses({reason:R,container:c});c.destroy();};
A.prototype._handleChange=function(){var c=[],i=[],C=[];var f=function(o){return this.sP13nType=="Sort"?o.isSorted:o.selected;}.bind(this);i=this.oState.items.filter(f);C=this.oAdaptationModel.getData().items.filter(f);var s=function(o){var d=o.name;if(o.hasOwnProperty("descending")){d=d+o.descending;}if(o.role){d=d+o.role;}return d;};var a=this.getTypeConfig(this.sP13nType).changeOperations;var I=this.getTypeConfig(this.sP13nType).ignoreIndex;if(a){c=F.getArrayDeltaChanges(i,C,s,this.getAdaptationControl(),a,I);}else{c=[];}this.oState=m({},this.oAdaptationModel.getData());this.getAfterChangesCreated()(this,c,"Item");};
A.prototype._hasProperty=function(n){var i={valid:false,property:undefined};this.aPropertyInfo.some(function(p){var v=p.name===n||n=="$search";v=v?v:p.path===n;if(v){i.valid=true;i.property=p;}return v;});return i;};
A.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);if(this.oAdaptationModel){this.oAdaptationModel.destroy();}this.oAdaptationModel=null;this.aPropertyInfo=null;this.oAdaptationModel=null;this.oState=null;this.bIsDialogOpen=null;this.sP13nType=null;this.oAdaptationControlDelegate=null;this.mChangeOperations=null;};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/FlexUtil',['sap/base/util/array/diff','sap/base/util/deepEqual','sap/ui/mdc/condition/FilterOperatorUtil'],function(d,a,F){"use strict";var b={getArrayDeltaChanges:function(e,c,s,C,m,i){var I=m["add"];var r=m["remove"];var M=m["move"];var R=d(e,c,s);var f=function(o,A){return A.filter(function(E){return E&&(E.name===o.name);})[0];};var g=function(P){var o={name:P.name};if(P.index>=0&&!i){o.index=P.index;}if(P.role){o.role=P.role;}if(P.hasOwnProperty("descending")){o.descending=P.descending==="true"||P.descending===true;}return o;};var h=[];var p=e.slice(0);R.forEach(function(o){if(o.type==="delete"&&p[o.index]===undefined){p.splice(o.index,1);return;}var P,E,l;if(o.type==="insert"){E=f(c[o.index],p);if(E){E.index=p.indexOf(E);p.splice(E.index,1,undefined);h.push(this.createAddRemoveChange(C,r,g(E)));}}P=o.type==="delete"?p[o.index]:c[o.index];P.index=o.index;if(o.type==="delete"){p.splice(P.index,1);}else{p.splice(P.index,0,P);}if(M){l=h.length;if(l){E=h[l-1];E=E?E.changeSpecificData.content:undefined;}if(E&&E.name===P.name&&o.index!=E.index){h.pop();h.push(this.createMoveChange(E.id,E.name,o.index,M,C,M!=="moveSort"));return;}}h.push(this.createAddRemoveChange(C,o.type==="delete"?r:I,g(P)));}.bind(this));return h;},getConditionDeltaChanges:function(f,o,O,c){var C,e=[];var g=o;var s=O?O:[];if(a(g,s)){return e;}var r=function(g,s){var R;do{R=false;for(var i=0;i<g.length;i++){var n=F.indexOfCondition(g[i],s);if(n>-1){g.splice(i,1);s.splice(n,1);R=true;break;}}}while(R);};r(g,s);if((g.length>0)||(s.length>0)){s.forEach(function(h){C=b.createConditionChange("removeCondition",c,f,h);if(C){e.push(C);}});g.forEach(function(h){C=b.createConditionChange("addCondition",c,f,h);if(C){e.push(C);}});}return e;},createAddRemoveChange:function(c,o,C){var A={selectorElement:c,changeSpecificData:{changeType:o,content:C}};return A;},createMoveChange:function(i,p,n,m,c,P){var M={selectorElement:c,changeSpecificData:{changeType:m,content:{id:i,name:p,index:n}}};if(!P){delete M.changeSpecificData.content.id;}return M;},createConditionChange:function(c,C,f,o){var e={selectorElement:C,changeSpecificData:{changeType:c,content:{name:f,condition:o}}};return e;},handleChanges:function(c){return new Promise(function(r,e){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.add({changes:c}).then(function(D){r(D);},e);});});},discardChanges:function(p){return new Promise(function(r,c){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.restore(p).then(function(){r();},c);});});}};return b;});
sap.ui.predefine('sap/ui/mdc/p13n/P13nBuilder',["sap/m/Button","sap/m/Bar","sap/m/Title","sap/base/util/merge","sap/m/MessageBox"],function(B,a,T,m,M){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var P={createP13nPopover:function(p,d){return new Promise(function(b,c){sap.ui.require(["sap/m/ResponsivePopover"],function(R){P["_checkSettings"](p,d,c);var o=new R({title:d.title,horizontalScrolling:d.hasOwnProperty("horizontalScrolling")?d.horizontalScrolling:false,verticalScrolling:d.hasOwnProperty("verticalScrolling")?d.verticalScrolling:false,contentWidth:d.contentWidth?d.contentWidth:"24rem",resizable:d.hasOwnProperty("resizable")?d.resizable:true,contentHeight:d.contentHeight?d.contentHeight:"35rem",placement:d.placement?d.placement:"Bottom",content:p,afterClose:d.afterClose?d.afterClose:function(){}});if(d.reset){var C=this._createResetHeader({title:d.title,reset:d.reset.onExecute,idResetButton:d.reset.idButton,warningText:d.reset.warningText});o.setCustomHeader(C);}b(o);},c);});},createP13nDialog:function(p,d){return new Promise(function(b,c){P["_checkSettings"](p,d,c);var i=d.id;sap.ui.require(["sap/m/Dialog","sap/m/Button"],function(D,B){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var C=new D(i,{title:d.title,horizontalScrolling:d.hasOwnProperty("horizontalScrolling")?d.horizontalScrolling:false,verticalScrolling:d.hasOwnProperty("verticalScrolling")?d.verticalScrolling:true,contentWidth:d.contentWidth?d.contentWidth:"40rem",contentHeight:d.contentHeight?d.contentHeight:"55rem",draggable:true,resizable:true,stretch:"{device>/system/phone}",content:p,buttons:[new B(i?i+"-confirmBtn":undefined,{text:d.confirm&&d.confirm.text?d.confirm.text:R.getText("p13nDialog.OK"),type:"Emphasized",press:function(){if(d.confirm&&d.confirm.handler){d.confirm.handler.apply(C,arguments);}}}),new B(i?i+"-cancelBtn":undefined,{text:R.getText("p13nDialog.CANCEL"),press:function(){d.cancel.apply(C,arguments);}})]});if(d.reset){var o=P._createResetHeader({title:d.title,idResetButton:d.reset.idButton,reset:d.reset.onExecute,warningText:d.reset.warningText});C.setCustomHeader(o);}var A=d.additionalButtons;if(A instanceof Array){A.forEach(function(e){if(!e.isA("sap.m.Button")){c("Please only provide sap.m.Button instances as 'additionalButtons'");}C.addButton(e);});}b(C);},c);});},_createResetHeader:function(s){var b=new a({contentLeft:[new T({text:s.title})]});if(s.reset){var i=s.idResetButton;b.addContentRight(new B(i,{text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.RESET"),press:function(){var R=s.warningText?s.warningText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_RESET_WARNING");M.warning(R,{actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK,onClose:function(A){if(A===M.Action.OK){s.reset();}}});}}));}return b;},prepareP13nData:function(c,i,I,p){I=I?I:[];var b=[],d={};var e=c.items||[];var s=c.sorters||[];var E=this.arrayToMap(e);var f=this.arrayToMap(s);var g=c.filter||{};i.forEach(function(o){var h={};if(P._isExcludeProperty(o,I)){return;}var k=o.name;var j=E[k];h.selected=j?true:false;h.position=j?j.position:-1;h=m(h,o,j);h.label=o.label||o.name;h.tooltip=o.tooltip?o.tooltip:o.label;h.visibleInDialog=o.hasOwnProperty("visibleInDialog")?o.visibleInDialog:true;if(p=="Sort"){h.isSorted=f[k]?true:false;h.sortPosition=f[k]?f[k].position:-1;h.descending=f[k]?f[k].descending:false;}if(c.filter){var l=g[k];h.isFiltered=l&&l.length>0?true:false;}h.group=h.group?h.group:"BASIC";d[h.group]=d[h.group]?d[h.group]:[];d[h.group].push(h);b.push(h);});if(p){this._sortP13nData(p,b);}return{items:b,itemsGrouped:this._builtGroupStructure(d)};},_sortP13nData:function(p,i){var b=this._getSortAttributes()[p];var s=b.position;var S=b.visible;var l=sap.ui.getCore().getConfiguration().getLocale().toString();var c=window.Intl.Collator(l,{});i.sort(function(f,F){if(f[S]&&F[S]){return(f[s]||0)-(F[s]||0);}else if(f[S]){return-1;}else if(F[S]){return 1;}else if(!f[S]&&!F[S]){return c.compare(f.label,F.label);}});},_getSortAttributes:function(){return{Item:{position:"position",visible:"selected"},Sort:{position:"sortPosition",visible:"isSorted"},Filter:{position:"position",visible:"selected"},generic:{position:undefined,visible:undefined}};},_builtGroupStructure:function(i){var g=[];Object.keys(i).forEach(function(G){this._sortP13nData("generic",i[G]);g.push({group:G,groupLabel:i[G][0].groupLabel||r.getText("p13nDialog.FILTER_DEFAULT_GROUP"),groupVisible:true,items:i[G]});}.bind(this));return g;},_isExcludeProperty:function(p,i){return i.some(function(k){var I=k.ignoreKey;var v=k.ignoreValue;return p[I]===v;});},_checkSettings:function(p,d,o){if(!d){o("Please provide a settings object for p13n creation");}if(!d.title&&!d.customHeader){o("Please provide a title or customHeader in the settings object for p13n creation");}},arrayToMap:function(A){return A.reduce(function(b,p,i){b[p.name]=p;b[p.name].position=i;return b;},{});}};return P;});
sap.ui.predefine('sap/ui/mdc/p13n/StateUtil',['./AdaptationController','./FlexUtil','sap/ui/fl/apply/api/FlexRuntimeInfoAPI','sap/ui/mdc/condition/FilterOperatorUtil','sap/base/Log'],function(A,F,a,b,L){"use strict";var o=new A();var S={applyExternalState:function(c,s){return new Promise(function(r,d){var v=this.checkXStateInterface(c);if(!v){d("The control needs to implement IxState");}S.retrieveExternalState(c).then(function(C){var e=C.hasOwnProperty("sorters");var f=C.hasOwnProperty("filter");var i=C.hasOwnProperty("items");var g,h,I,j=[];if(e&&s.sorters){g=o.createSortChanges(s.sorters,false);}if(f&&s.filter){this.checkConditionOperatorSanity(s.filter);h=o.createConditionChanges(s.filter);}if(i&&s.items&&s.items.length>0){I=o.createItemChanges(s.items);}Promise.all([g,h,I]).then(function(R){R.forEach(function(k){if(k&&k.length>0){j=j.concat(k);}});r(F.handleChanges(j));});}.bind(this),d);}.bind(this));},retrieveExternalState:function(c){return new Promise(function(r,d){o.setAdaptationControl(c);o.setStateRetriever(c.getCurrentState);o.setItemConfig(c.getAdaptationConfigAttribute("itemConfig"));var v=this.checkXStateInterface(c);if(!v){d("The control needs to implement then interface IxState.");}c.initialized().then(function(){a.waitForChanges({element:c}).then(function(){r(c.getCurrentState());});});}.bind(this));},checkXStateInterface:function(c){if(!c){return false;}if(!a.isFlexSupported({element:c})){return false;}if(!c.isA("sap.ui.mdc.IxState")){return false;}return true;},checkConditionOperatorSanity:function(c){for(var f in c){var C=c[f];for(var i=0;i<C.length;i++){var d=C[i];var O=d.operator;if(!b.getOperator(O)){C.splice(i,1);if(c[f].length==0){delete c[f];}L.warning("The provided conditions for field '"+f+"' contain unsupported operators - these conditions will be neglected.");}}}}};return S;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/BasePanel',['sap/ui/core/Control','sap/m/Column','sap/m/Text','sap/ui/model/Filter',"sap/m/Table","sap/m/OverflowToolbar","sap/m/SearchField","sap/m/ToolbarSpacer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/core/dnd/DragDropInfo"],function(C,a,T,F,b,O,S,c,d,e,B,D){"use strict";
var f=C.extend("sap.ui.mdc.p13n.panels.BasePanel",{
library:"sap.ui.mdc",
metadata:{library:"sap.ui.mdc",associations:{},defaultAggregation:"items",aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},template:{type:"sap.ui.core.Control",multiple:false}},events:{change:{reason:{type:"String"},item:{type:"Object"}}}},
init:function(){this._oListControl=this._createUI();this._oListControl.bPreventMassSelection=true;this._setInnerLayout();},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}
});
f.prototype.P13N_MODEL="$p13n";
f.prototype._setInnerLayout=function(){this.setAggregation("_content",this._oListControl);};
f.prototype._createUI=function(){this._moveTopButton=new d(this.getId()+"IDButtonMoveToTop",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_TOP"),icon:"sap-icon://collapse-group",press:[this._onPressButtonMoveToTop,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this._moveUpButton=new d(this.getId()+"IDButtonMoveUp",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_UP"),icon:"sap-icon://slim-arrow-up",press:[this._onPressButtonMoveUp,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this._moveDownButton=new d(this.getId()+"IDButtonMoveDown",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_DOWN"),icon:"sap-icon://slim-arrow-down",press:[this._onPressButtonMoveDown,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this._moveBottomButton=new d(this.getId()+"IDButtonMoveToBottom",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_BOTTOM"),icon:"sap-icon://expand-group",press:[this._onPressButtonMoveToBottom,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this._oDragDropInfo=new D({enabled:false,sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",drop:[this._onRearrange,this]});this.oReorderButton=new B(this.getId()+"IDshowSelectedBtn",{text:{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?this.getResourceText("p13nDialog.SELECT"):this.getResourceText("p13nDialog.REORDER");}.bind(this)},press:[this._onPressToggleMode,this]});var o=this._createInnerListControl();return o;};
f.prototype._createInnerListControl=function(){return new b(this.getId()+"idBasePanelTable",Object.assign(this._getListControlConfig(),{headerToolbar:new O({content:[this._getSearchField(),new c(),this._moveTopButton,this._moveUpButton,this._moveDownButton,this._moveBottomButton,this.oReorderButton]})}));};
f.prototype._getListControlConfig=function(){return{mode:"MultiSelect",rememberSelections:false,itemPress:[this._onItemPressed,this],selectionChange:[this._onSelectionChange,this],sticky:["HeaderToolbar","ColumnHeaders"],dragDropConfig:this._oDragDropInfo};};
f.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new S(this.getId()+"IDSearchField",{liveChange:[this._onSearchFieldLiveChange,this],width:"100%",layoutData:new e({shrinkable:true,moveToOverflow:true,priority:"High",maxWidth:"16rem"})});}return this._oSearchField;};
f.prototype.setTemplate=function(t){this.setAggregation("template",t);if(t){this._oSelectionBindingInfo=t.getBindingInfo("selected");if(this._oSelectionBindingInfo&&this._oSelectionBindingInfo.parts){this._oSelectionBindingInfo={parts:this._oSelectionBindingInfo.parts};}}this._bindListItems();return this;};
f.prototype.setPanelColumns=function(v){var g;if(v instanceof Array){g=v;}else{g=[v];}this._addTableColumns(g);};
f.prototype.setP13nModel=function(p){this.setModel(p,this.P13N_MODEL);this.setPanelMode(false);};
f.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL);};
f.prototype.getResourceText=function(t){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundle.getText(t):this.oResourceBundle;};
f.prototype._addTableColumns=function(g){this._oListControl.removeAllColumns();g.forEach(function(v){var o;if(typeof v=="string"){o=new a({header:new T({text:v})});}else{o=v;}this._oListControl.addColumn(o);},this);};
f.prototype._bindListItems=function(m){var t=this.getTemplate();if(t){t.bindProperty("type",{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?"Active":"Inactive";}});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",templateShareable:false,template:this.getTemplate().clone()},m));}};
f.prototype._onSelectionChange=function(E){var l=E.getParameter("listItems");var s=E.getParameter("selectAll");var g=!s&&l.length>1;l.forEach(function(t){this._selectTableItem(t,s||g);},this);if(s||g){this.fireChange();}if(g){this._moveTopButton.setEnabled(false);this._moveUpButton.setEnabled(false);this._moveDownButton.setEnabled(false);this._moveBottomButton.setEnabled(false);}};
f.prototype._onItemPressed=function(E){var t=E.getParameter('listItem');this._oSelectedItem=t;this._updateEnableOfMoveButtons(t);};
f.prototype._onSearchFieldLiveChange=function(E){this._oListControl.getBinding("items").filter(new F("label","Contains",E.getSource().getValue()));};
f.prototype._onPressButtonMoveToTop=function(){this._moveSelectedItem(0);};
f.prototype._onPressButtonMoveUp=function(){this._moveSelectedItem("Up");};
f.prototype._onPressButtonMoveDown=function(){this._moveSelectedItem("Down");};
f.prototype._onPressButtonMoveToBottom=function(){var i=this._oListControl.getItems().length-1;this._moveSelectedItem(i);};
f.prototype._onPressToggleMode=function(E){this._togglePanelMode();};
f.prototype.getPanelMode=function(){return this.getP13nModel()?this.getP13nModel().getProperty("/reorderMode"):false;};
f.prototype.setPanelMode=function(r){return this.getP13nModel().setProperty("/reorderMode",r);};
f.prototype._togglePanelMode=function(){var r=!this.getPanelMode();this.setPanelMode(r);if(r){this._updateModelItems();}this.switchListMode(r?"None":"MultiSelect");this._filterBySelected(r,this._oListControl);this._oSearchField.setVisible(!r);this._oSearchField.setValue("");this._setMoveButtonVisibility(r);this._moveTopButton.setEnabled(false);this._moveUpButton.setEnabled(false);this._moveDownButton.setEnabled(false);this._moveBottomButton.setEnabled(false);this._oDragDropInfo.setEnabled(r);};
f.prototype._setMoveButtonVisibility=function(v){this._moveTopButton.setVisible(v);this._moveUpButton.setVisible(v);this._moveDownButton.setVisible(v);this._moveBottomButton.setVisible(v);};
f.prototype._updateModelItems=function(){var g=this.getP13nModel().getProperty("/items");var s=[],o=[];g.forEach(function(h){if(h.selected){s.push(h);}else{o.push(h);}});this.getP13nModel().setProperty("/items",s.concat(o));};
f.prototype._filterBySelected=function(s,l){l.getBinding("items").filter(s?new F("selected","EQ",true):[]);};
f.prototype.switchListMode=function(m){if(this._oSelectionBindingInfo){if(m==="None"){this.getTemplate().unbindProperty("selected");}else{this.getTemplate().bindProperty("selected",this._oSelectionBindingInfo);}this._oListControl.unbindAggregation("items");}this._oListControl.setMode(m);if(this._oSelectionBindingInfo){this._bindListItems();}};
f.prototype._selectTableItem=function(t,s){this._updateEnableOfMoveButtons(t);this._oSelectedItem=t;if(!s){var i=this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath);this.fireChange({reason:i.selected?"Add":"Remove",item:i});}};
f.prototype._moveSelectedItem=function(n){var s=this._oSelectedItem;var i=this._oListControl.indexOfItem(s);if(i<0){return;}var N=(typeof n=="number")?n:i+(n=="Up"?-1:1);this._moveTableItem(s,N);};
f.prototype._moveTableItem=function(i,n){var I=this._oListControl.getItems();var g=this.getP13nModel().getProperty("/items");var o=g.indexOf(i.getBindingContext(this.P13N_MODEL).getObject());n=(n<=0)?0:Math.min(n,I.length-1);n=g.indexOf(I[n].getBindingContext(this.P13N_MODEL).getObject());if(n==o){return;}g.splice(n,0,g.splice(o,1)[0]);this.getP13nModel().setProperty("/items",g);this._oSelectedItem=I[n];this._updateEnableOfMoveButtons(this._oSelectedItem);this.fireChange({reason:"Move",item:this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath)});};
f.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var g=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var i=this._oListControl.indexOfItem(o);var h=this._oListControl.indexOfItem(g);var A=h+(s=="Before"?0:1)+(i<h?-1:0);this._moveTableItem(o,A);};
f.prototype._updateEnableOfMoveButtons=function(t){var i=this._oListControl.getItems().indexOf(t);var u=true,g=true;if(i==0){u=false;}if(i==this._oListControl.getItems().length-1){g=false;}this._moveTopButton.setEnabled(u);this._moveUpButton.setEnabled(u);this._moveDownButton.setEnabled(g);this._moveBottomButton.setEnabled(g);t.focus();};
f.prototype.exit=function(){this._oSelectionBindingInfo=null;this._oSelectedItem=null;this._oListControl=null;this._moveTopButton=null;this._moveUpButton=null;this._moveDownButton=null;this._moveBottomButton=null;this._oSearchField=null;};
return f;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/ChartItemPanel',["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/ui/mdc/library"],function(B,L,C,S,T,I,M){"use strict";
var a=B.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{
library:"sap.ui.mdc",
metadata:{},
init:function(){B.prototype.init.apply(this,arguments);var c=new C({selected:"{"+this.P13N_MODEL+">selected}",cells:[new L({wrapping:true,text:"{"+this.P13N_MODEL+">label}",tooltip:"{"+this.P13N_MODEL+">tooltip}"}),new T({wrapping:true,text:"{"+this.P13N_MODEL+">kind}"}),new S({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,enabled:"{"+this.P13N_MODEL+">selected}",items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new I({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})}})]});this.setTemplate(c);this.setPanelColumns([this.getResourceText("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION"),this.getResourceText("chart.PERSONALIZATION_DIALOG_COLUMN_TYPE"),this.getResourceText("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")]);},
renderer:{}
});
a.prototype.setP13nModel=function(p){B.prototype.setP13nModel.apply(this,arguments);var i=[];this.getP13nModel().getProperty("/items").forEach(function(o){o.availableRoles=this._getChartItemTextByKey(o.kind);i.push(o);}.bind(this));this.getP13nModel().setProperty("/items",i);};
a.prototype.onChangeOfRole=function(e){var s=e.getParameter("selectedItem");if(s){var t=e.getSource().getParent();this.fireChange();this._updateEnableOfMoveButtons(t);}};
a.prototype._getChartItemTextByKey=function(k){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={Dimension:[{key:M.ChartItemRoleType.category,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],Measure:[{key:M.ChartItemRoleType.axis1,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[k];};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/GroupPanelBase',["./BasePanel","sap/m/Label","sap/m/CustomListItem","sap/m/Panel","sap/m/Select","sap/ui/core/Item","sap/m/Toolbar","sap/m/List",'sap/ui/model/Filter',"sap/ui/layout/FixFlex","sap/m/Page","sap/m/ColumnListItem","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/m/Column","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/Table"],function(B,L,C,P,S,I,T,a,F,b,c,d,H,e,f,g,h,i,j){"use strict";
var G=B.extend("sap.ui.mdc.p13n.panels.GroupPanelBase",{
library:"sap.ui.mdc",
metadata:{properties:{itemFactory:{type:"function"},expandFirstGroup:{type:"boolean"},allowSelection:{type:"boolean",defaultValue:true},grouping:{type:"boolean",defaultValue:true},enableReorder:{type:"boolean",defaultValue:true},enableListView:{type:"boolean",defaultValue:true},defaultView:{type:"String"}},aggregations:{footerToolbar:{type:"sap.m.IBar",multiple:false}}},
renderer:{}
});
G.prototype.GROUP_KEY="group";G.prototype.LIST_KEY="list";
G.prototype.init=function(){this._mView={};B.prototype.init.apply(this,arguments);this._sView=this.LIST_KEY;};
G.prototype.addCustomView=function(v){var o=v.item;var k=o.getKey();var l=v.content;var O=v.search;if(O){this._getSearchField().attachLiveChange(O);}this._mView[k]=l;if(this._oViewSwitch&&!this._oViewSwitch.getVisible()){this._oViewSwitch.setVisible(true);}this._oViewSwitch.addItem(o);};
G.prototype._setInnerLayout=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new S({items:[new I({key:"all",text:this.getResourceText("p13nDialog.GROUPMODE_ALL")}),new I({key:"visible",text:this.getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new I({key:"active",text:this.getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new I({key:"visibleactive",text:this.getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")})],change:this._onGroupModeChange.bind(this)});}if(!this._oViewSwitch){this._oViewSwitch=new h({visible:false,items:[new i({tooltip:this.getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new i({tooltip:this.getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(E){var k=E.getParameter("item").getKey();this.switchViewMode(k);}.bind(this)});}var o=this._createContainer();this.addStyleClass("sapUiMDCGroupPanelBase");this.setAggregation("_content",o);};
G.prototype._createContainer=function(){var o=new c({showHeader:false,content:[new b({minFlexSize:1,fixContent:[new H({justifyContent:"SpaceBetween",items:[new H({items:[this._oGroupModeSelect]}),this._oViewSwitch]}),this._getSearchField()],flexContent:[this._oListControl]})]});return o;};
G.prototype.setItemFactory=function(k){this.setProperty("itemFactory",k);this._createInnerListControl();return this;};
G.prototype.setAllowSelection=function(A){this.setProperty("allowSelection",A);this._oGroupModeSelect.setVisible(A);this._updateTemplate();return this;};
G.prototype.setEnableReorder=function(r){this.setProperty("enableReorder",r);this._oReorderList.removeDragDropConfig();return this;};
G.prototype.setEnableListView=function(E){this.setProperty("enableListView",E);this._oViewSwitch.setVisible(E);if(E){this._mView[this.LIST_KEY]=this._oReorderList;}else{var o=this._oViewSwitch.getItems()[0];this._oViewSwitch.removeItem(o);this._sView=this.GROUP_KEY;}return this;};
G.prototype._getDefaultGroupTemplate=function(){var k=this.getItemFactory();var E=this.getExpandFirstGroup();var l=new a({selectionChange:function(r){var s=r.getParameter("listItem").getBindingContext(this.P13N_MODEL).sPath;var t=this.getP13nModel().getProperty(s);this.fireChange({reason:t.selected?"Add":"Remove",item:t});}.bind(this),showSeparators:"None",mode:this.getAllowSelection()?"MultiSelect":"None",items:{path:this.P13N_MODEL+">items",key:"name",factory:k}});var m=this.P13N_MODEL;var p=new P({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(m)){var r=E&&(this.getBindingContext(m).sPath.split("/")[2]==="0");return r;}else{return false;}}},width:"100%",headerToolbar:[new T({content:[new L({text:"{"+this.P13N_MODEL+">groupLabel}",design:"Bold"})]})],content:[l]});var n=this.getGrouping();if(!n&&!l.hasStyleClass("sapUiMDCPanelPadding")){l.addStyleClass("sapUiMDCPanelPadding");}else{l.removeStyleClass("sapUiMDCPanelPadding");}var o=n?p:l;var q=new C({visible:"{"+this.P13N_MODEL+">groupVisible}",content:[o]});return q;};
G.prototype._updateTemplate=function(){var o=this.getPanelMode()?this._getSimpleLayout():this._getDefaultGroupTemplate();this.setTemplate(o);};
G.prototype._getSearchField=function(){var s=B.prototype._getSearchField.apply(this,arguments);s.setPlaceholder(this.getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"));return s;};
G.prototype.setGrouping=function(A){this.setProperty("grouping",A);this._updateTemplate();return this;};
G.prototype._createInnerListControl=function(){var r=this.getPanelMode();if(!this._oReorderList){this._oReorderList=new j(this._getListControlConfig());this._oReorderList.bPreventMassSelection=true;this._oReorderList.setMode("MultiSelect");this._mView[this.LIST_KEY]=this._oReorderList;}if(!this._oGroupList){this._oGroupList=new a(this._getListControlConfig());this._oGroupList.setMode("None");this._mView[this.GROUP_KEY]=this._oGroupList;}this._oListControl=r?this._oReorderList:this._oGroupList;this._setMoveButtonVisibility(r);this._updateContainer(r);return this._oListControl;};
G.prototype.setFooterToolbar=function(o){this.setAggregation("footerToolbar",o);this.getAggregation("_content").setFooter(o.clone());return this;};
G.prototype.setGroupExpanded=function(s,E){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var k=p.getBindingContext(this.P13N_MODEL).sPath;var l=this.getP13nModel().getProperty(k);if(l.group===s){p.setExpanded(E);}},this);};
G.prototype._onGroupModeChange=function(E){this._sModeKey=E.getParameters().selectedItem.getKey();this._filterByModeAndSearch();};
G.prototype._togglePanelVisibility=function(p){var o=p.getContent()[0];var s=p.getBindingContext(this.P13N_MODEL).sPath;var k=this.getP13nModel().getProperty(s);k.groupVisible=o.getVisibleItems().length<1?false:true;this.getP13nModel().setProperty(s,k);};
G.prototype._onSearchFieldLiveChange=function(E){this._sSearchString=E.getSource().getValue();this._filterByModeAndSearch();};
G.prototype._isCustomView=function(){return this._sView!=this.GROUP_KEY&&this._sView!=this.LIST_KEY;};
G.prototype._filterByModeAndSearch=function(){var k=[],o;var l;if(this._isCustomView()){return;}if(this._sSearchString){k=[new F("label","Contains",this._sSearchString),new F("tooltip","Contains",this._sSearchString)];l=new F(k,false);}var A=function(){if(l){l=new F([new F(k),o],true);}else{l=o;}};if(this._sModeKey==="visible"){o=new F("selected","EQ",true);A();}if(this._sModeKey==="active"){o=new F("isFiltered","EQ",true);A();}if(this._sModeKey==="visibleactive"){o=o=new F([new F("isFiltered","EQ",true),new F("selected","EQ",true)],true);A();}l=l?l:[];this._getSearchField().setValue(this._sSearchString);if(!this.getPanelMode()){if(this.getGrouping()){this._oListControl.getItems().forEach(function(O){var p=O.getContent()[0];var m=p.getContent()[0];m.getBinding("items").filter(l,true);this._togglePanelVisibility(p);}.bind(this));}}else{this._oListControl.getBinding("items").filter(l,true);}};
G.prototype.getSelectedFields=function(){if(!this.getAllowSelection()){return;}var s=[];if(this.getPanelMode()){this._loopItems(this._oListControl,function(o,k){if(o.getSelected()){s.push(k);}});}else{this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var k=p.getContent()[0];this._loopItems(k,function(l,K){if(l.getSelected()){s.push(K);}});}.bind(this));}return s;};
G.prototype._loopItems=function(l,k){l.getItems().forEach(function(o){var p=o.getBindingContextPath();var K=this.getP13nModel().getProperty(p).name;k.call(this,o,K);}.bind(this));};
G.prototype.switchListMode=function(){return;};
G.prototype._filterBySelected=function(s,l){return;};
G.prototype.switchViewMode=function(v){var k=true;if(!this._mView[v]){throw new Error("Please provide either 'Group' or 'List' as view mode or define a custom view via 'addCustomView'");}if(v==this._sView){return;}else{this._sView=v;this._oViewSwitch.setSelectedKey(v);if(this._isCustomView()){k=false;var o=this._createContainer();o.getContent()[0].setFlexContent(this._mView[v]);this.setAggregation("_content",o);}else{var r=this.getPanelMode();if(v==this.LIST_KEY&&r||v==this.GROUP_KEY&&!r){this._createInnerListControl();}else{this._togglePanelMode();}}}this._oGroupModeSelect.setVisible(k&&this.getAllowSelection());};
G.prototype.getViewMode=function(){return this._sView;};
G.prototype._togglePanelMode=function(){if(this._moveTopButton.getParent()){this._moveTopButton.getParent().removeAllItems();}var r=!this.getPanelMode();this.setPanelMode(r);this._createInnerListControl();this._filterByModeAndSearch();this._getSearchField().setVisible(true);};
G.prototype._updateContainer=function(r){if(r){var o=this._createContainer();this.setAggregation("_content",o);this.setPanelColumns([this.getResourceText("p13nDialog.LIST_VIEW_COLUMN"),new g({width:"25%",hAlign:"Center",vAlign:"Middle",header:new f({text:this.getResourceText("p13nDialog.LIST_VIEW_ACTIVE")})})]);}else{this._setInnerLayout();}this._updateTemplate();};
G.prototype._getSimpleLayout=function(){this._bDefaultTemplateUsed=true;var p=new d({selected:"{"+this.P13N_MODEL+">selected}",type:"Active",cells:[new L({wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new H({justifyContent:"Center",items:[new e({src:"sap-icon://circle-task-2",size:"0.5rem",color:sap.ui.core.IconColor.Neutral,visible:{path:this.P13N_MODEL+">isFiltered",formatter:function(k){if(k){return true;}else{return false;}}}})]})]});var t=this;if(this.getEnableReorder()){p.attachBrowserEvent("mouseenter",function(E){var o=this.getCells()[1].getItems()[0];o.setVisible(false);t._oSelectedItem=this;t._updateEnableOfMoveButtons(this);});p.attachBrowserEvent("mouseleave",function(E){var v=!!t.getP13nModel().getProperty(this.getBindingContextPath()).isFiltered;var o=this.getCells()[1].getItems()[0];if(t._oSelectedItem){t._oSelectedItem.getCells()[1].removeItem(t._moveTopButton);t._oSelectedItem.getCells()[1].removeItem(t._moveUpButton);t._oSelectedItem.getCells()[1].removeItem(t._moveDownButton);t._oSelectedItem.getCells()[1].removeItem(t._moveBottomButton);}o.setVisible(v);});}return p;};
G.prototype._updateEnableOfMoveButtons=function(t){if(!this.getEnableReorder()){return;}B.prototype._updateEnableOfMoveButtons.apply(this,arguments);t.getCells()[1].addItem(this._moveTopButton);t.getCells()[1].addItem(this._moveUpButton);t.getCells()[1].addItem(this._moveDownButton);t.getCells()[1].addItem(this._moveBottomButton);};
G.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];this._togglePanelVisibility(p);}.bind(this));};
G.prototype.getPanelMode=function(){if(!this.getEnableListView()){return false;}else{return this.getP13nModel()?this.getP13nModel().getProperty("/reorderMode"):true;}};
G.prototype.setP13nModel=function(p){var k=!!this.getP13nModel();B.prototype.setP13nModel.apply(this,arguments);if(!k){this.setPanelMode(true);}if(this.getGrouping()&&!this.getPanelMode()){this._checkAllPanels();}this._bindListItems();var D=this.getDefaultView();if(D){this.switchViewMode(D);}};
G.prototype._bindListItems=function(){var r=this.getPanelMode();this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+(r===true?">/items":">/itemsGrouped"),key:"name",templateShareable:false,template:this.getTemplate().clone()}));};
G.prototype.exit=function(){Object.keys(this._mView).forEach(function(k){if((this._sView!==k)&&this._mView[k]){this._mView[k].destroy();}}.bind(this));B.prototype.exit.apply(this,arguments);this._oGroupList=null;this._oReorderList=null;this._sSearchString=null;this._oResetBtn=null;this._mView=null;this._sView=null;};
return G;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/SelectionPanel',["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/model/Filter"],function(B,L,C,H,V,F){"use strict";
var S=B.extend("sap.ui.mdc.p13n.panels.SelectionPanel",{
library:"sap.ui.mdc",
metadata:{},
init:function(){B.prototype.init.apply(this,arguments);var s=new C({selected:"{"+this.P13N_MODEL+">selected}",cells:new V({items:[new L({design:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?"Bold":"Standard";}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new L({visible:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?true:false;}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">groupLabel}"})]})});this.setTemplate(s);this.setPanelColumns(this.getResourceText("fieldsui.COLUMNS"));},
renderer:{}
});
S.prototype._onSearchFieldLiveChange=function(e){var f=new F([new F("label","Contains",e.getSource().getValue()),new F("groupLabel","Contains",e.getSource().getValue())]);this._oListControl.getBinding("items").filter(f,false);};
return S;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/SortPanel',["./BasePanel","sap/m/ColumnListItem","sap/m/Label","sap/m/Select","sap/ui/core/Item","sap/m/HBox","sap/m/VBox","sap/ui/model/Filter"],function(B,C,L,S,I,H,V,F){"use strict";
var a=B.extend("sap.ui.mdc.p13n.panels.SortPanel",{
library:"sap.ui.mdc",
metadata:{},
init:function(){B.prototype.init.apply(this,arguments);var s=new C({selected:"{"+this.P13N_MODEL+">isSorted}",cells:[new V({items:[new L({design:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?"Bold":"Standard";}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new L({visible:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?true:false;}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">groupLabel}"})]}),new S("IDsortOrderSelect",{width:"100%",selectedKey:"{"+this.P13N_MODEL+">descending}",change:[this.onChangeOfSortOrder,this],enabled:"{"+this.P13N_MODEL+">isSorted}",items:[new I({key:false,text:this.getResourceText("sort.PERSONALIZATION_DIALOG_OPTION_ASCENDING")}),new I({key:true,text:this.getResourceText("sort.PERSONALIZATION_DIALOG_OPTION_DESCENDING")})]})]});this.setTemplate(s);this.setPanelColumns([this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION"),this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_SORTORDER")]);},
renderer:{}
});
a.prototype._filterBySelected=function(s){this._oListControl.getBinding("items").filter(s?new F("isSorted","EQ",true):[]);};
a.prototype._updateModelItems=function(){var f=this.getP13nModel().getProperty("/items");var s=[],o=[];f.forEach(function(b){if(b.isSorted){s.push(b);}else{o.push(b);}});this.getP13nModel().setProperty("/items",s.concat(o));};
a.prototype.onChangeOfSortOrder=function(e){var s=e.getParameter("selectedItem");if(s){this.fireChange();}};
a.prototype._onSearchFieldLiveChange=function(e){var f=new F([new F("label","Contains",e.getSource().getValue()),new F("groupLabel","Contains",e.getSource().getValue())]);this._oListControl.getBinding("items").filter(f,false);};
a.prototype._onPressToggleMode=function(e){var p=this.getPanelMode()?[this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION"),this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_SORTORDER")]:this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION");this.setPanelColumns(p);this._togglePanelMode();};
return a;});
sap.ui.predefine('sap/ui/mdc/table/Column',["sap/ui/core/Element","sap/m/Label","sap/ui/core/Core","sap/base/Log"],function(E,L,C,a){"use strict";
var b=E.extend("sap.ui.mdc.table.Column",{metadata:{library:"sap.ui.mdc",defaultAggregation:"template",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"float",group:"Behavior",defaultValue:8},header:{type:"string"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",defaultValue:"Begin"},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},initialIndex:{type:"int",defaultValue:-1},dataProperties:{type:"string[]",defaultValue:[]},dataProperty:{type:"string"}},events:{},aggregations:{template:{type:"sap.ui.core.Control",multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false}}}});
b.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};};
b.prototype.setDataProperties=function(d){this.setProperty("dataProperties",d);if(!this.getDataProperty()){this.setProperty("dataProperty",this.getDataProperties()[0]);}a.error("The property 'dataProperties' is deprecated, please use the property 'dataProperty' instead",this);return this;};
b.prototype.getTemplate=function(c){var t=this.getAggregation("template");if(c&&this._oTemplateClone&&this._oTemplateClone.bIsDestroyed){this._oTemplateClone=null;}if(!this._oTemplateClone&&t){this._oTemplateClone=t.clone();}return c?this._oTemplateClone:t;};
b.prototype.getCreationTemplate=function(c){var o=this.getAggregation("creationTemplate");if(c&&this._oCreationTemplateClone&&this._oCreationTemplateClone.bIsDestroyed){this._oCreationTemplateClone=null;}if(!this._oCreationTemplateClone&&o){this._oCreationTemplateClone=o.clone();}return c?this._oCreationTemplateClone:o;};
b.prototype.setHeaderVisible=function(h){if(this.getHeaderVisible()===h){return this;}this.setProperty("headerVisible",h,true);this._updateColumnHeaderControl();return this;};
b.prototype.setHeader=function(h){this.setProperty("header",h,true);this._updateColumnHeaderControl();var l=document.getElementById(this.getId());if(l){l.textContent=this.getHeader();}return this;};
b.prototype.setHAlign=function(h){this.setProperty("hAlign",h,true);this._updateColumnHeaderControl();return this;};
b.prototype._updateColumnHeaderControl=function(){if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.setWidth(this.getHeaderVisible()?null:"0px");this._oColumnHeaderLabel.setWrapping(this._bMobileTable&&this.getHeaderVisible());this._oColumnHeaderLabel.setText(this.getHeader());this._oColumnHeaderLabel.setTextAlign(this.getHAlign());}};
b.prototype.setParent=function(p){var P=this.getParent();E.prototype.setParent.apply(this,arguments);if(p&&p.isA("sap.ui.mdc.Table")){if(p.getDomRef()){this._addAriaStaticDom();}else{this.oAfterRenderingDelegate={onAfterRendering:function(){this._addAriaStaticDom();this.getParent().removeDelegate(this.oAfterRenderingDelegate);}};p.addDelegate(this.oAfterRenderingDelegate,this);}}else if(!p){P.removeDelegate(this.oAfterRenderingDelegate);this._removeAriaStaticDom();}};
b.prototype.getColumnHeaderControl=function(m){if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.destroy();}this._oColumnHeaderLabel=new L(this.getId()+"-innerColumnHeader",{wrappingType:m?"Hyphenated":null});this._bMobileTable=m;this._updateColumnHeaderControl();return this._oColumnHeaderLabel;};
b.prototype._removeAriaStaticDom=function(){var d=document.getElementById(this.getId());if(d){d.parentNode.removeChild(d);}};
b.prototype._addAriaStaticDom=function(){var i=document.createElement("div");i.setAttribute("id",this.getId());i.setAttribute("class","sapUiInvisibleText");i.setAttribute("aria-hidden","true");var h=document.createTextNode(this.getHeader());i.appendChild(h);var s=C.getStaticAreaRef();if(i&&s){s.appendChild(i);}};
b.prototype.exit=function(){if(this._oTemplateClone){this._oTemplateClone.destroy();this._oTemplateClone=null;}if(this._oCreationTemplateClone){this._oCreationTemplateClone.destroy();this._oCreationTemplateClone=null;}if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.destroy();this._oColumnHeaderLabel=null;}this._removeAriaStaticDom();};
return b;});
sap.ui.predefine('sap/ui/mdc/table/CreationRow',["../library","sap/ui/core/Element"],function(L,E){"use strict";var T=L.TableType;
var C=E.extend("sap.ui.mdc.table.CreationRow",{metadata:{library:"sap.ui.mdc",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true},busy:{type:"boolean",group:"Behavior",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{apply:{allowPreventDefault:true}}}});
C.prototype.init=function(){this._sTableType="";this._oInnerCreationRow=null;this._mBindingContexts={};};
C.prototype.exit=function(){if(this._oInnerCreationRow){this._oInnerCreationRow.destroy();this._oInnerCreationRow=null;}this._mBindingContexts=null;};
C.prototype.setBusy=function(b){this.setProperty('busy',b,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setBusy(b);}return this;};
C.prototype.setBindingContext=function(o,m){E.prototype.setBindingContext.call(this,o,m);this._mBindingContexts[m]={context:o,modelName:m};if(this._oInnerCreationRow){this._oInnerCreationRow.setBindingContext(o,m);}return this;};
C.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setApplyEnabled(e);}return this;};
C.prototype.setVisible=function(v){this.setProperty("visible",v,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setVisible(v);this._getTable()._oTable.getRowMode().setHideEmptyRows(v);}return this;};
C.prototype._onInnerApply=function(e){if(!this.fireApply()){e.preventDefault();}};
C.prototype.update=function(){return this._updateInnerCreationRow();};
C.prototype._updateInnerCreationRow=function(){var t=this._getTable();var n=t?t._getStringType():"";var p;if(this._sTableType===n||!t||!t._oTable){return Promise.resolve();}this._sTableType=n;if(n===T.Table){p=this._createGridTableCreationRow();t._oTable.getRowMode().setHideEmptyRows(this.getVisible());}else{p=this._createResponsiveTableCreationRow();}return p.then(function(I){i(t,I);});};
function g(m){return new Promise(function(r,a){sap.ui.require([m],function(M){r(M);},function(e){a(e);});});}
C.prototype._createGridTableCreationRow=function(){return g("sap/ui/table/CreationRow").then(function(C){c(this);this._oInnerCreationRow=new C(this.getId()+"-inner",{visible:this.getVisible(),applyEnabled:this.getApplyEnabled(),apply:[this._onInnerApply,this]});for(var m in this._mBindingContexts){var b=this._mBindingContexts[m];this._oInnerCreationRow.setBindingContext(b.context,b.modelName);}return this._oInnerCreationRow;}.bind(this));};
C.prototype._createResponsiveTableCreationRow=function(){c(this);return Promise.resolve();};
function i(m,I){if(m&&m._oTable&&I){m._oTable.setCreationRow(I);}}
function c(m){if(m&&m._oInnerCreationRow){m._oInnerCreationRow.destroy();m._oInnerCreationRow=null;}}
C.prototype._getTable=function(){var p=this.getParent();return p&&p.isA("sap.ui.mdc.Table")?p:null;};
return C;});
sap.ui.predefine('sap/ui/mdc/table/GridTableType',["./TableTypeBase","../library"],function(T,l){"use strict";var I,a,b,c,d,e,f,g;var R=l.RowCountMode;var h=l.RowAction;
var G=T.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.RowCountMode",defaultValue:R.Auto},rowCount:{type:"int",defaultValue:10},selectionLimit:{type:"int",defaultValue:200},showHeaderSelector:{type:"boolean",defaultValue:true}}}});
G.prototype.updateRelevantTableProperty=function(t,p,v){if(!t||!t.isA("sap.ui.table.Table")){return;}if(p==="rowCountMode"){var r=t.getRowMode();var H=false;if(r&&(v===R.Fixed&&!r.isA("sap.ui.table.rowmodes.FixedRowMode")||v===R.Auto&&!r.isA("sap.ui.table.rowmodes.AutoRowMode"))){H=r.getHideEmptyRows();r.destroy();r=null;}if(!r){var i=v===R.Fixed?e:f;t.setRowMode(new i({hideEmptyRows:H}));}this._updateTableRowCount(t,v,this.getRowCount());}else if(p==="rowCount"){this._updateTableRowCount(t,this.getRowCountMode(),v);}else if(p==="selectionLimit"){t.getPlugins()[0].setLimit(v).setEnableNotification(v>0);}else if(p==="showHeaderSelector"){t.getPlugins()[0].setShowHeaderSelector(v);}};
G.prototype._updateTableRowCount=function(t,m,v){if(m===R.Fixed){t.getRowMode().setRowCount(v);}else{t.getRowMode().setMinRowCount(v);}};
G.updateDefault=function(t){if(t){t.setRowMode(new f({minRowCount:10}));}};
G.loadGridTableLib=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=sap.ui.getCore().loadLibrary("sap.ui.table",true);}return this._oGridTableLibLoaded;};
G.loadTableModules=function(){if(!I){return new Promise(function(r,i){this.loadGridTableLib().then(function(){sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/plugins/MultiSelectionPlugin","sap/ui/table/rowmodes/FixedRowMode","sap/ui/table/rowmodes/AutoRowMode","sap/ui/table/RowSettings"],function(j,k,h,m,M,F,A,n){I=j;a=k;b=h;c=m;d=M;e=F;f=A;g=n;r();},function(){i("Failed to load some modules");});});}.bind(this));}else{return Promise.resolve();}};
G.createTable=function(i,s){return new I(i,s);};
G.createColumn=function(i,s){return new a(i,s);};
G.createNavigationRowAction=function(i,E){return new b(i+"--rowAction",{items:new c(i+"--rowActionItem",{type:h.Navigation,press:E})});};
G.createMultiSelectionPlugin=function(t,E){return new d(t.getId()+"--multiSelectPlugin",{selectionMode:T.getSelectionMode(t),selectionChange:E});};
G.updateSelection=function(t){var s=T.getSelectionMode(t);t._oTable.getPlugins()[0].setSelectionMode(s);};
G.updateNavigation=function(t,r){t._oTable.setRowActionTemplate(this.createNavigationRowAction(t.getId(),[r,t]));t._oTable.setRowActionCount(1);};
G.clearNavigation=function(t){var i=t._oTable.getRowActionTemplate();if(i){i.destroy();}t._oTable.setRowActionTemplate();t._oTable.setRowActionCount();};
G.updateRowAction=function(t,n,r){this.clearNavigation(t);if(n){this.updateNavigation(t,r);}};
G.updateRowSettings=function(t,r){var i=new g(undefined,r.getAllSettings());t.getRowSettingsTemplate().destroy();t.setRowSettingsTemplate(i);};
return G;});
sap.ui.predefine('sap/ui/mdc/table/PropertyHelper',["sap/ui/mdc/util/PropertyHelper"],function(P){"use strict";
var a=P.extend("sap.ui.mdc.table.PropertyHelper");
function i(C){if(!C||!C.isA||!C.isA("sap.ui.mdc.table.Column")){return false;}return true;}
function g(w){if(w.indexOf("em")>0){return Math.round(parseFloat(w));}if(w.indexOf("px")>0){return Math.round(parseInt(w)/16);}return"";}
a.prototype.getTable=function(){return this.getParent();};
a.prototype.getColumnExportSettings=function(C,s){if(!i(C)){return null;}var p=this.getProperty(C.getDataProperty());if(!p){return null;}s=s===true;var d=[];var e;var E=this.getExportSettings(p);var o;var f=[];var A;var h;var j;var k;if(this.isComplex(p)){e=this.getPropertiesFromComplexProperty(p);if(!s&&E){o=c(this,C,p,E);e.forEach(function(l){f.push(this.getPath(l));},this);o.property=f;d.push(o);}else{e.forEach(function(l,I){var m=this.getExportSettings(l),n=c(this,C,l,m);n.property=this.getPath(l);if(I>0){n.columnId=C.getId()+"-additionalProperty"+I;}d.push(n);},this);}}else if(!s&&E){o=c(this,C,p,E);o.property=this.getPath(p);d.push(o);}else{o=c(this,C,p,E);o.property=this.getPath(p);o.displayUnit=!s?true:false;d.push(o);A=s&&E&&E.unitProperty?E.unitProperty:null;if(A){h=b(this,A);j=this.getExportSettings(h);k=c(this,C,h,j);k.property=this.getPath(h);k.columnId=C.getId()+"-additionalProperty";d.push(k);}}return d;};
function b(p,s){var o=p.getPropertyMap()[s];if(!o){o=p.getProperties().find(function(C){return s===C.path;});}if(p.isComplex(o)){throw new Error("The 'unitProperty' points to a complex property");}return o;}
function c(p,C,o,e){return Object.assign({columnId:C.getId(),label:p.getLabel(o),width:g(C.getWidth()),textAlign:C.getHAlign(),type:"String"},e);}
return a;});
sap.ui.predefine('sap/ui/mdc/table/ResponsiveTableType',["sap/ui/core/Core","./TableTypeBase","../library","sap/m/Button","sap/ui/Device"],function(C,T,l,B,D){"use strict";var I,a,b;var G=l.GrowingMode;var R=l.RowAction;
var c=T.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.GrowingMode",defaultValue:G.Basic},showDetailsButton:{type:"boolean",group:"Misc",defaultValue:false}}}});
c.prototype.updateRelevantTableProperty=function(t,p,v){if(t&&t.isA("sap.m.Table")){if(p==="growingMode"){t.setGrowingScrollToLoad(v===G.Scroll);t.setGrowing(v!==G.None);}else if(p==="showDetailsButton"){this.updateShowDetailsButton(t,v);}}};
c.updateDefault=function(t){if(t){t.setGrowing(true);t.setGrowingScrollToLoad(false);}};
c.prototype.updateShowDetailsButton=function(t,v){if(v&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);this._renderShowDetailsButton();t.attachEvent("popinChanged",this._onPopinChanged,this);t.setHiddenInPopin(D.system.phone?["Low","Medium"]:["Low"]);}else if(!v&&this._oShowDetailsButton){t.detachEvent("popinChanged",this._onPopinChanged,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton;}};
c.loadTableModules=function(){if(!I){return new Promise(function(r,d){sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],function(e,f,g){I=e;a=f;b=g;r();},function(){d("Failed to load some modules");});});}else{return Promise.resolve();}};
c.createTable=function(i,s){return new I(i,s);};
c.createColumn=function(i,s){return new a(i,s);};
c.createTemplate=function(i,s){return new b(i,s);};
c.updateSelection=function(t){t._oTable.setMode(T.getSelectionMode(t));};
c.updateNavigation=function(t){t._oTemplate.setType(R.Navigation);};
c.updateRowAction=function(t,n){var s=t.hasListeners("rowPress")?"Active":"Inactive";t._oTemplate.setType(s);if(n){this.updateNavigation(t);}};
c.updateRowSettings=function(r,o){r.unbindProperty("navigated");r.unbindProperty("highlight");r.unbindProperty("highlightText");r.applySettings(o.getAllSettings());};
c.prototype._renderShowDetailsButton=function(){var r=C.getLibraryResourceBundle("sap.ui.mdc"),t;t=this.bHideDetails?r.getText("table.SHOWDETAILS_TEXT"):r.getText("table.HIDEDETAILS_TEXT");this._oShowDetailsButton.setTooltip(t);this._oShowDetailsButton.setText(t);};
c.prototype._toggleShowDetails=function(v){if(!this._oShowDetailsButton||(v===this.bHideDetails)){return;}var t=this.getRelevantTable();this.bHideDetails=v;this.bHideDetails?t.setHiddenInPopin(["Low"]):t.setHiddenInPopin([]);this._renderShowDetailsButton();};
c.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){this.bHideDetails=true;this._oShowDetailsButton=new B(this.getId()+"-showHideDetails",{visible:false,press:[function(){this._toggleShowDetails(!this.bHideDetails);},this]});}return this._oShowDetailsButton;};
c.prototype._onPopinChanged=function(e){var h=e.getParameter("hasPopin");var H=e.getParameter("hiddenInPopin");var v=e.getSource().getVisibleItems().length;if(v&&(H.length||(h&&!this.bHideDetails))){this._oShowDetailsButton.setVisible(true);}else{this._oShowDetailsButton.setVisible(false);}};
return c;});
sap.ui.predefine('sap/ui/mdc/table/TableSettings',["sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/base/util/merge","sap/m/library","sap/m/MenuButton"],function(O,a,m,M,b){"use strict";var r;var T={createSortButton:function(i,e){if(!r){this._loadResourceBundle();}return this._createButton(i+"-sort",{icon:"sap-icon://sort",text:r.getText("table.SETTINGS_SORT"),press:e,tooltip:r.getText("table.SETTINGS_SORT"),layoutData:new a({closeOverflowOnInteraction:false})});},createColumnsButton:function(i,e){if(!r){this._loadResourceBundle();}return this._createButton(i+"-settings",{icon:"sap-icon://action-settings",text:r.getText("table.SETTINGS_COLUMN"),press:e,tooltip:r.getText("table.SETTINGS_COLUMN"),layoutData:new a({closeOverflowOnInteraction:false})});},createFilterButton:function(i,e){if(!r){this._loadResourceBundle();}return this._createButton(i+"-filter",{icon:"sap-icon://filter",text:r.getText("filter.PERSONALIZATION_DIALOG_TITLE"),press:e,tooltip:r.getText("filter.PERSONALIZATION_DIALOG_TITLE"),layoutData:new a({closeOverflowOnInteraction:false})});},createExportButton:function(i,e){if(!r){this._loadResourceBundle();}var o=new b(i+"-export",{icon:"sap-icon://excel-attachment",tooltip:r.getText("table.EXPORT_BUTTON_TEXT"),type:M.ButtonType.Ghost,buttonMode:M.MenuButtonMode.Split,useDefaultActionOnly:true,defaultAction:e.default});sap.ui.getCore().loadLibrary("sap.ui.unified",{async:true}).then(function(){sap.ui.require(["sap/m/Menu","sap/m/MenuItem"],function(c,d){var f=new c({items:[new d({text:r.getText("table.QUICK_EXPORT"),press:e.default}),new d({text:r.getText("table.EXPORT_WITH_SETTINGS"),press:e.exportAs})]});o.setMenu(f);});});return o;},_createButton:function(i,s){return new O(i,s);},_loadResourceBundle:function(){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");},showPanel:function(c,p,s,i){T["showP13n"+p](c,s);},showP13nColumns:function(c,s){var A=c.getAdaptationController();A.showP13n(s,"Item");},showP13nSort:function(c,s){var A=c.getAdaptationController();A.showP13n(s,"Sort");},showP13nFilter:function(c,s){var A=c.getAdaptationController();c.retrieveInbuiltFilter().then(function(){A.showP13n(s,"Filter");});},createSort:function(c,p,R){var s={selected:true,name:p,descending:false};c.getCurrentState().sorters.forEach(function(P){if(P.name==p){s.descending=!P.descending;}});var A=c.getAdaptationController();var i=[s];A.createSortChanges(i,true);},moveColumn:function(c,d,n){if(d!=n){this._moveItem(c,d,n,"moveColumn");}},_moveItem:function(c,d,n,s){var v=c.getCurrentState(c).items||[];var o=v[d];var A=c.getAdaptationController();A.createItemChanges([{name:o.name,position:n}]);}};return T;});
sap.ui.predefine('sap/ui/mdc/table/TableTypeBase',["sap/ui/core/Element"],function(E){"use strict";
var T=E.extend("sap.ui.mdc.table.TableTypeBase",{metadata:{library:"sap.ui.mdc",properties:{}}});
T.prototype.setProperty=function(p,v,s){E.prototype.setProperty.call(this,p,v,true);var t=this.getRelevantTable();if(t){this.updateRelevantTableProperty(t,p,v);}return this;};
T.prototype.updateRelevantTableProperty=function(t,p,v){};
T.prototype.getRelevantTable=function(){var t=this.getParent();if(t&&t.isA("sap.ui.mdc.Table")){t=t._oTable;}else{t=null;}return t;};
T.prototype.updateTableSettings=function(a){var p=Object.assign({},a,this.getMetadata().getProperties()),P,t=this.getRelevantTable();if(t){for(P in p){this.updateRelevantTableProperty(t,P,this.getProperty(P));}}};
T.getSelectionMode=function(t){var s=t.getSelectionMode();switch(s){case"Single":s=t._bMobileTable?"SingleSelectLeft":"Single";break;case"Multi":s=t._bMobileTable?"MultiSelect":"MultiToggle";break;default:s="None";}return s;};
return T;});
sap.ui.predefine('sap/ui/mdc/table/V4AnalyticsTableType',["sap/ui/core/Core","./GridTableType"],function(C,G){"use strict";var I;
var V=G.extend("sap.ui.mdc.table.V4AnalyticsTableType",{metadata:{properties:{}}});
V.loadTableModules=function(){return Promise.all([G.loadTableModules(),new Promise(function(r,a){sap.ui.require(["sap/ui/table/plugins/V4Aggregation"],function(b){I=b;r();},function(){a("Failed to load V4Aggregation plugin");});})]);};
V.createV4AggregationPlugin=function(t){var v=C.byId(t.getId()+"--mV4Aggregation");return v?v:new I(t.getId()+"--mV4Aggregation");};
V.prototype.updateTableSettings=function(){this.getRelevantTable().addDependent(V.createV4AggregationPlugin(this.getParent()));G.prototype.updateTableSettings.call(this,G.getMetadata().getProperties());};
return V;});
sap.ui.predefine('sap/ui/mdc/util/FilterUtil',['sap/ui/mdc/util/IdentifierUtil',"sap/ui/mdc/condition/ConditionConverter",'sap/ui/mdc/condition/FilterConverter','sap/base/Log','sap/base/util/merge'],function(I,C,F,L,m){"use strict";var a={getPropertyByKey:function(p,k){var P=null;p.some(function(o){if(I.getPropertyKey(o)===k){P=o;}return P!=null;});return P;},getFilterInfo:function(M,c,p,b){var f={};if(!M){L.error("not an mdc control");return f;}if(!M.bDelegateInitialized||!M.getTypeUtil()){L.error("typeUtil not available");return f;}b=b?b:[];var i,s,d={},o;var e={};if(p&&p.length>0){for(s in c){if(b.indexOf(s)<0){var P=a.getPropertyByKey(p,s);if(P){e[s]={type:P.typeConfig.typeInstance};d[s]=[];for(i=0;i<c[s].length;i++){o=m({},c[s][i]);d[s].push(C.toType(o,P.typeConfig,M.getTypeUtil()));}}else{L.error("no such property: "+s);}}}if(Object.keys(d).length>0){f.filters=F.createFilters(d,e);}}return f;}};return a;},true);
sap.ui.predefine('sap/ui/mdc/util/FormatUtil',[],function(){"use strict";var F={getWidth:function(p,m,M){var w=p.precision||p.maxLength,W;if(!m){m=20;}if(!M){M=3;}if(p.type==="Edm.DateTime"&&p.type==="Edm.Date"){w="9em";}else if(w){if(w==="Max"){w=m+"";}W=parseInt(w);if(!isNaN(W)){W+=0.75;if(W>m){W=m;}else if(W<M){W=M;}w=W+"em";}else{w=null;}}if(!w){if(p.type==="Edm.Boolean"){w=M+"em";}else{w=m+"em";}}return w;}};return F;},true);
sap.ui.predefine('sap/ui/mdc/util/IdentifierUtil',['sap/ui/base/DataType'],function(D){"use strict";var I={replace:function(n){var t=D.getType("sap.ui.core.ID");if(!t.isValid(n)){n=n.replace(/[^A-Za-z0-9_.:]+/g,"__mdc__");if(!t.isValid(n)){n="__mdc__"+n;}}return n;},getFilterFieldId:function(f,k){return f.getId()+"--filter--"+I.replace(k);},getPropertyKey:function(p){return p.name;},getView:function(c){var v=null;if(c){var o=c.getParent();while(o){if(o.isA("sap.ui.core.mvc.View")){v=o;break;}o=o.getParent();}}return v;}};return I;},true);
sap.ui.predefine('sap/ui/mdc/util/PropertyHelper',["sap/ui/base/Object","sap/ui/base/DataType","sap/base/Log","sap/base/util/deepClone","sap/base/util/isPlainObject"],function(B,D,L,d,a){"use strict";var A={name:{type:"string",mandatory:true,allowedForComplexProperty:true},label:{type:"string",mandatory:true,allowedForComplexProperty:true},path:{type:"string",defaultValue:"attribute:name"},groupLabel:{type:"string",defaultValue:"",allowedForComplexProperty:true},visible:{type:"boolean",defaultValue:true,allowedForComplexProperty:true},propertyInfos:{type:"string[]",allowedForComplexProperty:true},exportSettings:{type:"object",defaultValue:null,allowedForComplexProperty:true},typeConfig:{type:"object",defaultValue:null},maxConditions:{type:"int",defaultValue:null},filterable:{type:"boolean",defaultValue:true},sortable:{type:"boolean",defaultValue:true},fieldHelp:{type:"string",defaultValue:""}};var m=Object.keys(A).filter(function(h){return A[h].mandatory;});var _=new WeakMap();
function s(o){return JSON.stringify(o,function(k,v){return v===undefined?null:v;})||"";}
function r(M,o){var h=s(o);L.warning("Invalid property definition: "+M+(h?"\n"+h:""));}
function t(M,o){var h=s(o);throw new Error("Invalid property definition: "+M+(h?"\n"+h:""));}
function c(h){var C=[];h.forEach(function(o){var i;var T;if(o.typeConfig&&"typeInstance"in o.typeConfig){T=o.typeConfig.typeInstance;delete o.typeConfig.typeInstance;}i=d(o);if(T){o.typeConfig.typeInstance=T;i.typeConfig.typeInstance=T;}C.push(i);});return Object.freeze(C);}
function b(o){var k=Object.getOwnPropertyNames(o);for(var i=0;i<k.length;i++){var v=o[k[i]];if(a(v)||Array.isArray(v)){if(k[i]==="_relatedProperties"){Object.freeze(v);}else{b(v);}}}return Object.freeze(o);}
function p(h,i){h.forEach(function(o){var j=[];var I=g(o);for(var k in A){var l=A[k];if(I&&!l.allowedForComplexProperty){continue;}if("defaultValue"in l&&o[k]==null){if(typeof l.defaultValue==="string"&&l.defaultValue.startsWith("attribute:")){j.push({source:l.defaultValue.substring(l.defaultValue.indexOf(":")+1),target:k});}else{o[k]=l.defaultValue;}}}j.forEach(function(n){o[n.target]=o[n.source];});if(I){Object.defineProperty(o,"_relatedProperties",{value:o.propertyInfos.map(function(K){return i[K];})});}b(o);});}
function e(h){var i={};h.forEach(function(o){i[o.name]=o;});return Object.freeze(i);}
function f(o,v,F){var h=o.getProperty(v);if(o.isComplex(h)){return o.getPropertiesFromComplexProperty(h).filter(function(h){return F.call(o,h);});}else if(F.call(o,h)){return[h];}return h?[]:null;}
var P=B.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(h,o){B.call(this);var i=B.isA(o,["sap.ui.base.ManagedObject"]);if(o!=null&&!i){throw new Error("The type of the parent is invalid");}this.validateProperties(h);var C=c(h);_.set(this,{oParent:i?o:null,aProperties:C,mProperties:e(C)});p(_.get(this).aProperties,_.get(this).mProperties);}});
P.prototype.validateProperties=function(h){if(!Array.isArray(h)){t("Property infos must be an array.");}var u=new Set();for(var i=0;i<h.length;i++){this.validateProperty(h[i],h);u.add(h[i].name);}if(u.size!==h.length){t("Properties do not have unique names.");}};
P.prototype.validateProperty=function(o,h){if(!a(o)){t("Property info must be a plain object.",o);}var i;var I=g(o);for(i in o){if(!(i in A)){r("Property contains invalid attribute '"+i+"'.",o);}else if(I&&!A[i].allowedForComplexProperty){r("Complex property contains invalid attribute '"+i+"'.",o);}else if(!D.getType(A[i].type).isValid(o[i])&&(A[i].mandatory||o[i]!=null)){t("The value of '"+i+"' is invalid.",o);}}m.forEach(function(M){if(!(M in o)){r("Property does not contain mandatory attribute '"+M+"'.",o);}});if(I){var S=o.propertyInfos;var u=new Set(S);if(S.length===0){t("Complex property does not reference existing properties",S);}if(u.size!==S.length){t("Complex property contains duplicate keys in the 'propertyInfos' attribute.",S);}h.forEach(function(C){if(u.has(C.name)){if(g(C)){t("Complex property references other complex properties.",C);}u.delete(C.name);}});if(u.size>0){t("Complex property references non-existing properties.",o);}}};
P.prototype.getParent=function(){var o=_.get(this);return o?o.oParent:null;};
P.prototype.getProperties=function(){var o=_.get(this);return o?o.aProperties:null;};
P.prototype.getPropertyMap=function(){var o=_.get(this);return o?o.mProperties:null;};
P.prototype.getProperty=function(v){var h=this.getPropertyMap();if(typeof v==="string"){return h[v]||null;}if(v&&v.name&&typeof v.name==="string"){var F=h[v.name];if(F&&F===v){return F;}}return null;};
P.prototype.isComplex=function(v){var o=this.getProperty(v);return o?g(o):null;};
function g(o){return o?"propertyInfos"in o:false;}
P.prototype.getKeysFromComplexProperty=function(v){var o=this.getProperty(v);return o?o.propertyInfos||[]:null;};
P.prototype.getPropertiesFromComplexProperty=function(v){var o=this.getProperty(v);return o?o._relatedProperties||[]:null;};
P.prototype.isSortable=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return false;}return o?o.sortable:null;};
P.prototype.getSortableProperties=function(v){return f(this,v,this.isSortable);};
P.prototype.getAllSortableProperties=function(){return this.getProperties().filter(function(o){return this.isSortable(o);},this);};
P.prototype.isFilterable=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return false;}return o?o.filterable:null;};
P.prototype.getFilterableProperties=function(v){return f(this,v,this.isFilterable);};
P.prototype.getAllFilterableProperties=function(){return this.getProperties().filter(function(o){return this.isFilterable(o);},this);};
P.prototype.getLabel=function(v){var o=this.getProperty(v);return o?o.label:null;};
P.prototype.getGroupLabel=function(v){var o=this.getProperty(v);return o?o.groupLabel:null;};
P.prototype.getPath=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return null;}return o?o.path:null;};
P.prototype.isVisible=function(v){var o=this.getProperty(v);return o?o.visible:null;};
P.prototype.getVisibleProperties=function(v){return f(this,v,this.isVisible);};
P.prototype.getAllVisibleProperties=function(){return this.getProperties().filter(function(o){return this.isVisible(o);},this);};
P.prototype.getExportSettings=function(v){var o=this.getProperty(v);return o&&o.exportSettings?o.exportSettings:null;};
P.prototype.getName=function(v){var o=this.getProperty(v);return o?o.name:null;};
P.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);_.delete(this);};
return P;});
/*
 * !OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/chart/DimensionItem',["./Item",'sap/ui/base/SyncPromise',"sap/ui/mdc/library"],function(I,S,M){"use strict";var D,T,H;var _={category:true,category2:true,series:true};
var a=I.extend("sap.ui.mdc.chart.DimensionItem",{metadata:{"abstract":true,library:"sap.ui.mdc",properties:{textFormatter:{type:"function"},textProperty:{type:"string"},displayText:{type:"boolean",defaultValue:true},role:{type:"string",defaultValue:"category"},inResult:{type:"boolean",defaultValue:false},level:{type:"int",defaultValue:undefined},timeUnit:{type:"string",defaultValue:undefined},criticality:{type:"object",multiple:"false"}}}});
a.prototype.getSettings=function(m){var s={label:this.getLabel()||m.label,role:this.getRole(),name:this.getKey(),textProperty:this.getTextProperty(),displayText:this.getDisplayText()};if(this._isHierarchyDimension()){s.level=this.getLevel();}return s;};
a.prototype.toChart=function(c){return new S(function(r){this._oVizItem=c.getDimensionByName(this.getKey());if(this._oVizItem){var o=this._oVizItem.getRole();this._oVizItem.setRole(this.getRole());if(this._observer){this._observer.propertyChange(this,"role",o,this.getRole());}r(this);}else{this.toVizChartItem().then(function(i){this._oVizItem=i;c.addDimension(this._oVizItem,true);if(this._observer){this._observer.propertyChange(this,"role",null,this.getRole());}r(this);}.bind(this));}}.bind(this));};
a.prototype.toVizChartItem=function(m){if(!this._pToVizItem){this._pToVizItem=new S(function(r){m=m||{};var b,d,v;if(this._isHierarchyDimension()){b=H;d="sap/chart/data/HierarchyDimension";}else if(this._isTimeDimension()){b=T;d="sap/chart/data/TimeDimension";}else{b=D;d="sap/chart/data/Dimension";}if(b){v=new b(this.getSettings(m));r(v);}else{sap.ui.require([d],function(c){b=c;v=new b(this.getSettings(m));r(v);}.bind(this));}}.bind(this));}return this._pToVizItem;};
a.prototype.setRole=function(r){if(!_[r]){throw new TypeError("Invalide Measure role: "+r);}this.setProperty("role",r,true);var c=this.getParent();if(c){c.oChartPromise.then(function(v){this.toChart(v);}.bind(this));}return this;};
a.prototype.getVizItemType=function(){return M.ChartItemType.Dimension;};
a.prototype._isHierarchyDimension=function(){return false;};
a.prototype._isTimeDimension=function(){if(this.getVizItemType()=="Measure"){return false;}switch(this.getType()){case"date":case"time":case"datetime":return true;default:return false;}};
return a;},true);
sap.ui.predefine('sap/ui/mdc/chart/Item',["sap/ui/core/Element"],function(E){"use strict";
var I=E.extend("sap.ui.mdc.chart.Item",{metadata:{"abstract":true,library:"sap.ui.mdc",properties:{key:{type:"string"},label:{type:"string"},visible:{type:"boolean",defaultValue:true},type:{type:"string",defaultValue:"string"}}}});
I.prototype.getSettings=function(m){throw new Error("sap.ui.mdc.chart.Item - getSettings not implemented see sap.ui.mdc.chart.DimensionItem or sap.ui.mdc.chart.MeasureItem");};
I.prototype.toVizChartItem=function(m){throw new Error("sap.ui.mdc.chart.Item - getChartVizItem not implemented see sap.ui.mdc.chart.DimensionItem or sap.ui.mdc.chart.MeasureItem");};
I.prototype.setRole=function(r){throw new Error("sap.ui.mdc.chart.Item - setRole not implemented see sap.ui.mdc.chart.DimensionItem or sap.ui.mdc.chart.MeasureItem");};
I.prototype.getVizItemType=function(){throw new Error("sap.ui.mdc.chart.Item - getVizItemType not implemented see sap.ui.mdc.chart.DimensionItem or sap.ui.mdc.chart.MeasureItem");};
return I;},true);
sap.ui.predefine('sap/ui/mdc/chart/MeasureItem',["./Item",'sap/ui/base/SyncPromise',"sap/ui/mdc/library"],function(I,S,M){"use strict";var a;var _={axis1:true,axis2:true,axis3:true};
var b=I.extend("sap.ui.mdc.chart.MeasureItem",{metadata:{"abstract":true,library:"sap.ui.mdc",properties:{propertyPath:{type:"string"},role:{type:"string",defaultValue:"axis1"},dataPoint:{type:"object"},aggregationMethod:{type:"string",defaultValue:undefined}}}});
b.prototype.getCriticality=function(){var d=this.getDataPoint();return d?d.criticality:null;};
b.prototype.setDataPoint=function(v){if(!this.isPropertyInitial("dataPoint")){throw new Error("Data point is readonly");}return this.setProperty("dataPoint",v);};
b.createVizChartItem=function(s){return new S(function(r){var v;if(a){v=new a(s);r(v);}else{sap.ui.require(["sap/chart/data/Measure"],function(c){a=c;v=new a(s);r(v);});}});};
b.getVizItemSettings=function(m){var s={label:m.label,role:m.role||"axis1",name:m.key};var A=m.aggregationMethod;if(A){s.analyticalInfo={"with":A,propertyPath:m.propertyPath};}return s;};
b.prototype.getSettings=function(m){if(m&&m.key==this.getKey()){m.label=this.getLabel()||m.label;m.role=this.getRole();}else{m={key:this.getKey(),label:this.getLabel(),role:this.getRole(),propertyPath:this.getPropertyPath(),aggregationMethod:this.getAggregationMethod(),dataPoint:this.getDataPoint()};}return b.getVizItemSettings(m);};
b.prototype.toChart=function(c){return new S(function(r){var v=c.getMeasureByName(this.getKey());if(v){var o=v.getRole();v.setRole(this.getRole());if(this._observer){this._observer.propertyChange(this,"role",o,this.getRole());}}else{this.toVizChartItem().then(function(i){c.addMeasure(i,true);if(this._observer){this._observer.propertyChange(this,"role",null,this.getRole());}}.bind(this));}}.bind(this));};
b.prototype.toVizChartItem=function(m){if(!this._pToVizItem){this._pToVizItem=new S(function(r){m=m||{};b.createVizChartItem(this.getSettings(m)).then(function(v){r(v);});}.bind(this));}return this._pToVizItem;};
b.prototype.setRole=function(r){if(!_[r]){throw new TypeError("Invalide Measure role: "+r);}this.setProperty("role",r,true);var c=this.getParent();if(c){c.oChartPromise.then(function(v){this.toChart(v);}.bind(this));}return this;};
b.prototype.getVizItemType=function(){return M.ChartItemType.Measure;};
b.prototype.getAdditionalColoringMeasures=function(){var A=[];var c=this.getCriticality();if(c&&c.DynamicThresholds){A=c.DynamicThresholds.usedMeasures;}return A;};
return b;},true);
sap.ui.predefine('sap/ui/mdc/chart/SelectionDetailsActions',["sap/ui/core/Element"],function(E){"use strict";
var S=E.extend("sap.ui.mdc.chart.SelectionDetailsActions",{metadata:{library:"sap.ui.mdc",aggregations:{detailsItemActions:{type:"sap.ui.core.Item",multiple:true},detailsActions:{type:"sap.ui.core.Item",multiple:true},actionGroups:{type:"sap.ui.core.Item",multiple:true}}}});
return S;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/AggregationBaseDelegate',['sap/ui/mdc/BaseDelegate'],function(B){"use strict";var A=Object.assign(B,{fetchProperties:function(c){return Promise.resolve([]);},addItem:function(p,c,P){return Promise.resolve();},removeItem:function(i,c,p){return Promise.resolve(true);}});return A;},true);
sap.ui.predefine('sap/ui/mdc/BaseDelegate',['sap/ui/mdc/util/TypeUtil'],function(T){"use strict";var B={getTypeUtil:function(p){return T;}};return B;},true);
sap.ui.predefine('sap/ui/mdc/Chart',["sap/ui/core/Core","sap/ui/mdc/Control","./chart/ChartSettings","sap/ui/base/SyncPromise","sap/ui/mdc/util/loadModules","./ChartRenderer","sap/ui/base/ManagedObjectObserver","sap/ui/model/json/JSONModel","sap/ui/mdc/library","sap/ui/model/base/ManagedObjectModel","sap/ui/model/Sorter","sap/base/Log","sap/base/util/deepEqual","sap/ui/Device","sap/ui/mdc/chart/ToolbarHandler","sap/ui/mdc/mixin/FilterIntegrationMixin"],function(C,a,b,S,l,c,M,J,d,e,f,L,g,D,T,F){"use strict";var h,m,n,o,p,q="sap.ui.mdc.IFilter";
var r=a.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate"}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string"},chartType:{type:"string",group:"Misc",defaultValue:"column"},selectionMode:{type:"string",group:"Misc",defaultValue:"MULTIPLE"},p13nMode:{type:"sap.ui.mdc.ChartP13nMode[]"},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},vizProperties:{type:"object",group:"Misc"},_colorings:{type:"object",visibility:"_hidden",byValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"}},aggregations:{data:{multiple:true},items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--toolbar",aggregation:"actions"}},_chart:{type:"sap.chart.Chart",multiple:false},_toolbar:{type:"sap.ui.mdc.ActionToolbar",multiple:false},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false}},associations:{filter:{type:q,multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}},dataPointsSelected:{parameters:{dataContext:{type:"object"}}}}}});
var _=function(v){if(!this.oChartPromise){return;}this.oChartPromise.then(function(i){if(this.bIsDestroyed){return;}v=v||this.getSelectionMode();i.setSelectionMode(v);if(v!=="NONE"){this._prepareSelection();}}.bind(this));};F.call(r.prototype);
r.prototype.init=function(){this._oObserver=new M(this.update.bind(this));this._oAdaptationController=null;this._oObserver.observe(this,{aggregations:["items","_chart"],properties:["ignoreToolbarActions","p13nMode"]});this._oManagedObjectModel=new e(this);this.setModel(this._oManagedObjectModel,"$mdcChart");a.prototype.init.apply(this,arguments);var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.setProperty("adaptationConfig",{itemConfig:{changeOperations:{add:"addItem",remove:"removeItem",move:"moveItem"},containerSettings:{title:R.getText("chart.PERSONALIZATION_DIALOG_TITLE")},adaptationUI:"sap/ui/mdc/p13n/panels/ChartItemPanel",additionalDeltaAttributes:["role"]}});};
r.prototype.initModules=function(i){this.initControlDelegate(i[0]);h=i[1];o=i[2];p=i[3];};
function s(){return["sap/chart/Chart","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/MeasureItem"];}
r.prototype.applySettings=function(i,j){var A;if(i){A=i.actions;delete i.actions;}var k=(i&&i.delegate)||this.getDelegate();var v=k&&k.name;var w=[v].concat(s());this.oChartPromise=l(w).then(function y(x){this.initModules(x);if(this.bIsDestroyed){return S.reject();}return this.getControlDelegate().fetchProperties(this);}.bind(this)).then(function x(P){return this.retrieveAdaptationController().then(function(){return P;});}.bind(this)).then(function x(P){if(this.bIsDestroyed){return S.reject();}var I={};P.forEach(function(y){I[y.name]=y;});return this._createInnerChart(i,I);}.bind(this)).then(function x(I){this._createDrillBreadcrumbs();T.createToolbar(this,A);return I;}.bind(this)).catch(function x(E){if(E){L.error("The control could not be initialized.",E,this.getMetadata().getName());}}.bind(this));if(!i||i.selectionMode===undefined){_.apply(this);}return a.prototype.applySettings.apply(this,arguments);};
r.prototype.bindAggregation=function(N,B,i){if(N=="data"){this.oDataInfo=B;var j=this.getAggregation("_chart");if(j&&this.bDelegateInitialized){this.getControlDelegate().rebindChart(this,B,i);}else if(this.oChartPromise){this.oChartPromise.then(function(j){this.getControlDelegate().rebindChart(this,B,i);}.bind(this));}return this;}return a.prototype.bindAggregation.apply(this,arguments);};
r.prototype.getBindingInfo=function(N){if(N=="data"){return this.oDataInfo;}return a.prototype.getBindingInfo.apply(this,arguments);};
r.prototype.setLegendVisible=function(v){this.setVizProperties({'legend':{'visible':v},'sizeLegend':{'visible':v}});return this.setProperty("legendVisible",v);};
r.prototype._createInnerChart=function(k,I){k=k||{};var v={},w,V=[],x=[],y=[],z={};v.chartType='{$mdcChart>/chartType}';v.dimensions=[];v.measures=[];v.id=this.getId()+"--innerChart";v.height='100%';v.width='100%';v.vizProperties='{$mdcChart>/vizProperties}';k.items=k.items||[];function A(j){if(this&&this.getVizItemType()=="Dimension"){v.dimensions.push(j);}else{v.measures.push(j);}}function B(w,H){if(w.getCriticality()){H._addCriticality(w);}y.push(w.getKey());if(w.getAdditionalColoringMeasures){for(var j=0;j<w.getAdditionalColoringMeasures().length;j++){if(x.indexOf(w.getAdditionalColoringMeasures()[j])==-1){x.push(w.getAdditionalColoringMeasures()[j]);}}}}function E(){var K,j;for(var i=0;i<x.length;i++){K=x[i];if(y.indexOf(K)==-1){j=this.getControlDelegate().retrieveAggregationItem("items",I[K]);j=p.getVizItemSettings(j.settings);V.push(p.createVizChartItem(j).then(A));}}}for(var i=0;i<k.items.length;i++){w=k.items[i];B(w,this);if(I[w.getKey()]){z=this.getControlDelegate().retrieveAggregationItem("items",I[w.getKey()]).settings;}else{z=undefined;}V.push(w.toVizChartItem(z).then(A.bind(w)));}E();var G=function(j){this.fireDataPointsSelected({dataContext:j.getParameters()});};return Promise.all(V).then(function(){var j=new h(v);j.setVisibleDimensions([]);j.setVisibleMeasures([]);j.setInResultDimensions([]);j.attachSelectData(function(H){G.call(this,H);}.bind(this));j.attachDeselectData(function(H){G.call(this,H);}.bind(this));this._oObserver.observe(j,{bindings:["data"],aggregations:["dimensions","measures"]});this.setAggregation("_chart",j);return j;}.bind(this));};
r.prototype.setSelectionMode=function(v){this.setProperty("selectionMode",v,true);v=this.getSelectionMode();_.call(this,v);return this;};
r.prototype.addItem=function(i,j){var k=this.getAggregation("_chart");if(k){i.toChart(k);}else if(this.oChartPromise){this.oChartPromise.then(function(k){if(k){this.toChart(k);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.addAggregation("items",i,j);};
r.prototype.insertItem=function(i,I,j){if(i.getCriticality()){this._addCriticality(i);}var k=this.getAggregation("_chart");if(k){i.toChart(k);}else if(this.oChartPromise){this.oChartPromise.then(function(k){if(k){this.toChart(k);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.insertAggregation("items",i,I,j);};
r.prototype.removeItem=function(i,j){this._oObserver.unobserve(i);return this.removeAggregation("items",i,j);};
r.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this.oChartPromise=null;this._oSelectionHandlerPromise=null;var i=this.getAggregation("_chart");if(i){i.destroy();}};
r.prototype.getItemsByKeys=function(I){var j=[],k=this.getItems();I.forEach(function(v){for(var i=k.length-1;i>=0;i--){if(k[i].getKey()==v){j.push(k[i]);break;}}});return j;};
r.prototype._showDrillDown=function(){if(n){if(!this._oDrillDownPopover){n.createDrillDownPopover(this);}return n.showDrillDownPopover(this);}return new Promise(function(i,j){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(k){n=k;n.createDrillDownPopover(this);n.showDrillDownPopover(this).then(function(v){i(v);});}.bind(this));}.bind(this));};
r.prototype._createDrillBreadcrumbs=function(){if(n){if(!this._oDrillBreadcrumbs){return n.createDrillBreadcrumbs(this);}return Promise.resolve(this._oDrillBreadcrumbs);}return new Promise(function(i,j){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(k){n=k;n.createDrillBreadcrumbs(this).then(function(v){i(v);});}.bind(this));}.bind(this));};
r.prototype._getPropertyData=function(){return new Promise(function(i,j){if(!this.aFetchedProperties){return this.oChartPromise.then(function(){return this.getControlDelegate().fetchProperties(this);}.bind(this)).then(function(k){this.aFetchedProperties=k;i(k);}.bind(this));}else{i(this.aFetchedProperties);}}.bind(this));};
r.prototype.getAvailableChartTypes=function(){var j=[];var k=this.getAggregation("_chart");if(k){var A=k.getAvailableChartTypes().available;if(j){var v=C.getLibraryResourceBundle("sap.chart.messages");for(var i=0;i<A.length;i++){var w=A[i].chart;j.push({key:w,icon:o.mMatchingIcon[w],text:v.getText("info/"+w),selected:(w==this.getChartType())});}}}return j;};
r.prototype.getTypeInfo=function(){var i=this.getChartType(),j=C.getLibraryResourceBundle("sap.ui.mdc");var I={icon:o.mMatchingIcon[i],text:j.getText("chart.CHART_TYPE_TOOLTIP",[i])};return I;};
r.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel;};
r.prototype.update=function(i){var j=this.getAggregation("_chart");if(j){this._update(j,i);}else if(this.oChartPromise){this.oChartPromise.then(function(j){if(j){this._update(j,i);}}.bind(this));}};
r.prototype._update=function(j,k){var I=this.getItems(),v,w,V=[],x=[],y=[],z={};if(k.name==="ignoreToolbarActions"||k.name==="p13nMode"){T.updateToolbar(this);return;}if(k.name==="data"&&k.type==="binding"&&k.mutation==="prepare"&&k.object.isA("sap.chart.Chart")){k.bindingInfo.sorter=this._getSorters();}this._aInResultProperties=[];for(var i=0;i<I.length;i++){w=I[i];v=w.getVizItemType()=="Measure"?j.getMeasureByName(w.getKey()):j.getDimensionByName(w.getKey());if(!v){continue;}if(w.getVisible()){if(w.getVizItemType()=="Measure"){V.push(v.getName());if(w.getDataPoint()){z[v.getName()]=w.getDataPoint();}}else{x.push(v.getName());}this._aInResultProperties.push(v.getName());}if(w.getVizItemType()=="Dimension"){if(w.getInResult()){y.push(v.getName());this._aInResultProperties.push(v.getName());}}}var R=false;if(!g(x,j.getVisibleDimensions())){j.setVisibleDimensions(x);R=true;}if(!g(V,j.getVisibleMeasures())){j.setVisibleMeasures(V);R=true;}if(!g(y,j.getInResultDimensions())){j.setInResultDimensions(y);R=true;}if(R){this.rebind();this._updateSemanticalPattern(j,V,z);this._updateColoring(j,x,V);}if(n&&this.getAggregation("_breadcrumbs")){n._updateDrillBreadcrumbs(this,this.getAggregation("_breadcrumbs"));}};
r.prototype._updateSemanticalPattern=function(i,v,j){for(var k=0;k<v.length;k++){var w=j[v[k]];if(w){if(w.targetValue||w.foreCastValue){var A=i.getMeasureByName(v[k]);A.setSemantics("actual");if(w.targetValue!=null){var R=i.getMeasureByName(w.targetValue);if(R){R.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+w.targetValue+" is not a valid measure");}}if(w.foreCastValue){var P=i.getMeasureByName(w.foreCastValue);if(P){P.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+w.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:w.targetValue,projectedValueMeasure:w.foreCastValue});}}}};
r.prototype._updateColoring=function(i,v,V,j){var w=this.getProperty("_colorings"),k;if(w&&w.Criticality){var A;for(k=0;k<v.length;k++){if(w.Criticality.DimensionValues[v[k]]){A={coloring:"Criticality",parameters:{dimension:v[k]}};delete w.Criticality.MeasureValues;break;}}if(!A){delete w.Criticality.DimensionValues;for(var x in w.Criticality.MeasureValues){if(V.indexOf(x)==-1){delete w.Criticality.MeasureValues[x];}}A={coloring:"Criticality",parameters:{measure:V}};}if(A){i.setColorings(w);i.setActiveColoring(A);}}};
r.prototype._prepareSelection=function(){if(m){m.prepareChart(this);}else{this._oSelectionHandlerPromise=l(["sap/ui/mdc/chart/SelectionHandler"]).then(function(i){m=i[0];if(this.bIsDestroyed){return;}m.prepareChart(this);}.bind(this));}};
r.prototype._getSorters=function(){var i;var j=this.getSortConditions()?this.getSortConditions().sorters:[];j.forEach(function(k){if(this._aInResultProperties.indexOf(k.name)!=-1){var v=new f(k.name,k.descending);if(i){i.push(v);}else{i=[v];}}}.bind(this));return i;};
r.prototype.rebind=function(){if(!this.bDelegateInitialized){return;}var B=this.oDataInfo,i=this.getControlDelegate();if(i){i.updateBindingInfo(this,B);}if(!this.isInnerChartBound()){return;}if(B){B.sorter=this._getSorters();B.binding.bHasAnalyticalInfo=true;}this.bindAggregation("data",B);this._updateInnerChartNoDataText();this._renderOverlay(false);};
r.prototype.isInnerChartBound=function(){return this.getAggregation("_chart")?this.getAggregation("_chart").isBound("data"):false;};
r.prototype._onFiltersChanged=function(E){if(this.isInnerChartBound()&&E.getParameter("conditionsBased")){this._renderOverlay(true);}};
r.prototype._renderOverlay=function(i){if(this.getAggregation("_chart")){var $=this.getAggregation("_chart").$(),j=$.find(".sapUiMdcChartOverlay");if(i&&j.length===0){j=jQuery("<div>").addClass("sapUiOverlay sapUiMdcChartOverlay").css("z-index","1");$.append(j);}else if(!i){j.remove();}}};
r.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this._updateInnerChartNoDataText();return this;};
r.prototype._onFilterProvided=function(){this._updateInnerChartNoDataText();};
r.prototype._updateInnerChartNoDataText=function(){var i=this.getAggregation("_chart");if(!i){return;}i.setCustomMessages({'NO_DATA':this._getNoDataText()});};
r.prototype._getNoDataText=function(){var N=this.getNoDataText();if(N){return N;}var R=C.getLibraryResourceBundle("sap.ui.mdc");if(!this.isInnerChartBound()){if(this.getFilter()){return R.getText("chart.NO_DATA_WITH_FILTERBAR");}return R.getText("chart.NO_DATA");}return R.getText("chart.NO_RESULTS");};
r.prototype._addCriticality=function(i){var j=this.getProperty("_colorings");j=j||{Criticality:{DimensionValues:{},MeasureValues:{}}};var k=i.getCriticality(),v={};if(i.getVizItemType()=="Dimension"){for(var K in k){v[K]={Values:k[K]};}j.Criticality.DimensionValues[i.getKey()]=v;}else{for(var K in k){v[K]=k[K];}j.Criticality.MeasureValues[i.getKey()]=v;}this.setProperty("_colorings",j);};
r.prototype.getCollectionModel=function(){var B=this.getBindingInfo("data");return B?this.getModel(B.model):null;};
r.prototype.getCollectionPath=function(){var B=this.getBindingInfo("data");return B?B.path:null;};
r.prototype.done=function(){return this.oChartPromise;};
r.prototype.initialized=function(){return this.oChartPromise;};
var t=function(i){var P=[];if(i){i.getItems().forEach(function(j,I){P.push({name:j.getKey(),role:j.getRole()});});}return P;};var u=function(i){return i.getSortConditions()?i.getSortConditions().sorters:[];};
r.prototype.isFilteringEnabled=function(){var P=this.getP13nMode()||[];return P.indexOf("Filter");};
r.prototype.getCurrentState=function(){var i={};var P=this.getP13nMode();if(P){if(P.indexOf("Item")>-1){i.items=t(this);}if(P.indexOf("Sort")>-1){i.sorters=u(this);}}return i;};
return r;},true);
sap.ui.predefine('sap/ui/mdc/ChartDelegate',["sap/ui/mdc/AggregationBaseDelegate","sap/ui/base/SyncPromise","sap/ui/mdc/chart/MeasureItem","sap/ui/mdc/chart/DimensionItem","sap/ui/core/Core","sap/ui/mdc/util/FilterUtil"],function(A,S,M,D,C,F){"use strict";var a=Object.assign({},A);a.Metadata={items:[],properties:[],sortable:true,filterable:true};a.MetadataProperty={kind:"",role:"",contextDefiningProperties:[],className:"",aggregationMethod:"","default":true,custom:false,name:"",propertyPath:"",label:"",textProperty:"",sortable:true,sortDirection:"",filterable:true,allowedExpressions:[]};
a.retrieveAllMetadata=function(c){return Promise.resolve(a.Metadata);};
a.fetchProperties=function(c){var p=[this.MetadataProperty];return Promise.resolve(p);};
a.retrieveAggregationItem=function(s,m){return{};};
a.updateBindingInfo=function(m,b){if(m&&m.getAggregation("_chart")&&b){var f=C.byId(m.getFilter());if(f){var c=f.getConditions();if(c){if(!b){b={};}var p=f.getPropertyInfoSet?f.getPropertyInfoSet():null;var o=F.getFilterInfo(f,c,p);b.filters=o.filters;}}}};
a.rebindChart=function(m,b){if(m&&m.getAggregation("_chart")&&b){m.getAggregation("_chart").bindData(b);}};
a.createChartItem=function(n,c,r){return this.fetchProperties(c).then(function(p){var P=p.find(function(d){return d.name===n;});if(!P){return null;}var o=null,i=c.getId()+"--"+n,s="create"+P.kind+"Item",I=this[s];if(typeof I==="function"){var b=this.retrieveAggregationItem(P.kind,P).settings;o=I.call(this,i,b);if(r){o.setRole(r);}}return o;}.bind(this));};
a.createDimensionItem=function(i,s){return new D(i,s);};
a.createMeasureItem=function(i,s){return new M(i,s);};
a.addItem=function(p,c,P,r){if(typeof c.getModel==="function"){return this.createChartItem(p,c,r);}return S.resolve(null);};
a.removeItem=function(p,c,P){return S.resolve(true);};
return a;});
sap.ui.predefine('sap/ui/mdc/ChartRenderer',['./library'],function(l){"use strict";var C={apiVersion:2};C.CSS_CLASS="sapUiMDCChart";
C.render=function(r,c){r.openStart("div",c);r.class(C.CSS_CLASS);r.class("sapUiFixFlex");r.style("overflow","hidden");r.style("height",c.getHeight());r.style("width",c.getWidth());r.style("min-height",c.getMinHeight());r.style("min-width",c.getMinWidth());r.openEnd();this.renderToolbar(r,c.getAggregation("_toolbar"));this.renderBreadcrumbs(r,c.getAggregation("_breadcrumbs"));this.renderChart(r,c.getAggregation("_chart"));r.close("div");};
C.renderToolbar=function(r,t){if(t){r.openStart("div");r.class("sapUiFixFlexFixed");r.openEnd();r.renderControl(t);r.close("div");}};
C.renderBreadcrumbs=function(r,d){if(d){r.renderControl(d);}};
C.renderChart=function(r,c){if(c){r.openStart("div");r.class("sapUiFixFlexFlexible");r.style("overflow","hidden");r.openEnd();r.openStart("div");r.class("sapUiFixFlexFlexibleContainer");r.openEnd();r.renderControl(c);r.close("div");r.close("div");}};
return C;},true);
sap.ui.predefine('sap/ui/mdc/Control',["sap/ui/core/Control","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(C,D,A){"use strict";
var a=C.extend("sap.ui.mdc.Control",{
metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"},adaptationConfig:{type:"object",group:"Data",visiblity:"hidden"}}},
renderer:C.renderer
});
D.call(a.prototype);A.call(a.prototype);return a;});
sap.ui.predefine('sap/ui/mdc/Element',["sap/ui/core/Element","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(C,D,A){"use strict";
var E=C.extend("sap.ui.mdc.Element",{
metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"},adaptationConfig:{type:"object",group:"Data",visiblity:"hidden"}}},
renderer:C.renderer
});
D.call(E.prototype);A.call(E.prototype);return E;});
sap.ui.predefine('sap/ui/mdc/Field',['sap/ui/base/ManagedObjectObserver','sap/ui/mdc/field/FieldBase','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/BindingMode','sap/ui/model/Context'],function(M,F,a,b,C,c,B,d,e,m,f,g){"use strict";
var h=F.extend("sap.ui.mdc.Field",{
metadata:{library:"sap.ui.mdc",properties:{value:{type:"any",defaultValue:null},additionalValue:{type:"any",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},promise:{type:"Promise"}}}},defaultProperty:"value"},
renderer:a
});
h.prototype.init=function(){this._vValue=null;this._vAdditionalValue=null;F.prototype.init.apply(this,arguments);this.setMaxConditions(1);this._oObserver.observe(this,{properties:["value","additionalValue"]});};
h.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;delete this._bPendingConditionUpdate;}this._oBindingContext=undefined;};
h.prototype.bindProperty=function(N,r){if(N==="value"&&!r.formatter){r.targetType="raw";if(r.type&&(!this._oDataType||this._oDataType.getMetadata().getName()!==r.type.getMetadata().getName())){this._oDataType=r.type;this._updateConditionType();this.invalidate();}}F.prototype.bindProperty.apply(this,arguments);};
h.prototype._handleModelContextChange=function(E){F.prototype._handleModelContextChange.apply(this,arguments);var r=this.getBinding("value");if(r){var s=r.isA("sap.ui.model.CompositeBinding")?null:r.getContext();if(g.hasChanged(this._oBindingContext,s)){this._oBindingContext=s;this._updateConditionType();if(this._bParseError||this.getFieldHelp()){this._oManagedObjectModel.checkUpdate(true,true);this._bParseError=false;}}if(!this._oDataType){this._oDataType=r.getType();this.invalidate();}}};
h.prototype._initDataType=function(){F.prototype._initDataType.apply(this,arguments);var r=this.getBinding("value");if(r){this._oDataType=r.getType();}};
h.prototype.setMaxConditions=function(r){if(r!==1){throw new Error("Only one condition allowed for Field "+this);}return this.setProperty("maxConditions",r,true);};
h.prototype._observeChanges=function(r){F.prototype._observeChanges.apply(this,arguments);if(r.name==="value"){var v=l.call(this,r.current,r.old);if(this._vAdditionalValue!==null&&q.call(this)&&!n.call(this,v,this._vValue,true)){this._vAdditionalValue=this.getAdditionalValue();}this._vValue=v;o.call(this,r.current);j.call(this);}if(r.name==="additionalValue"){this._vAdditionalValue=r.current;j.call(this);}if(r.name==="conditions"){if(this._getContent().length<=1){p.call(this,r.current);}}};
function _(){return this._vValue;}
function i(){return this._vAdditionalValue;}
function j(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){j.call(this);}}.bind(this));return;}if(this.getDisplay()===b.Value){k.call(this,_.call(this),i.call(this));}else if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){k.call(this,_.call(this),i.call(this));this._iConditionUpdateTimer=undefined;this._bPendingConditionUpdate=false;}.bind(this),0);this._bPendingConditionUpdate=true;}}
function k(v,A){var r=this.getConditions();if(this._checkValueInitial(v)&&!A){if(r.length>0){this.setConditions([]);}}else{var O=r[0]&&r[0].values[0];var s=r[0]&&r[0].values[1]?r[0].values[1]:null;if(!r[0]||r[0].operator!=="EQ"||!n.call(this,O,v)||s!==A){var t=C.createItemCondition(v,A);t.validated=d.Validated;this.setConditions([t]);}}}
function l(v,O){var D=this._oDataType?this._oDataType.getMetadata().getName():this.getDataType();if(v&&O&&(D==="sap.ui.model.odata.type.Unit"||D==="sap.ui.model.odata.type.Currency")&&!v[2]&&O[2]!==undefined){v=m([],v);v[2]=O[2];if(this._bPendingChange){var r=this.getConditions()[0];if(r){if(v[0]===O[0]&&v[0]!==r.values[0][0]){v[0]=r.values[0][0];}if(v[1]===O[1]&&v[1]!==r.values[0][1]){v[1]=r.values[0][1];}}}}return v;}
function n(v,V,u){var E=v===V;var D=this._oDataType?this._oDataType.getMetadata().getName():this.getDataType();if(!E&&this.getTypeUtil().getBaseType(D)===B.Unit&&Array.isArray(v)&&Array.isArray(V)){var N=v[0];var U=v[1];var r=v.length>=3?v[2]:null;var s=V[0];var t=V[1];var w=V.length>=3?V[2]:null;if(N===s&&U===t&&(((this._bUnitSet||u)&&(!r||!w))||e(r,w))){E=true;}if((r||w)&&!u){this._bUnitSet=true;}}return E;}
function o(v){if(!this._bTypeInitialized){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){o.call(this,v);}}.bind(this));return;}var r=this.getBinding("value");var D=r?r.getType():this._oDataType;this._oTypeInitialization=this.getControlDelegate().initializeTypeFromBinding(this.getPayload(),D,v);this._bTypeInitialized=this._oTypeInitialization.bTypeInitialized;if(this._bTypeInitialized&&this._oUnitOriginalType){this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oDataType,this._oTypeInitialization);}}}
h.prototype._fireChange=function(r,v,w,P){var V;if(r){if(v){V=this._getResultForPromise(r);}else{V=w;}}if(this._getContent().length>1){if(r){p.call(this,this.getConditions());}else if(P){P=P.then(function(R){p.call(this,this.getConditions());return R;}.bind(this));}}this.fireChange({value:V,valid:v,promise:P});};
h.prototype._getResultForPromise=function(r){var v;if(r.length===0&&this._oDataType){v=this._oDataType.parseValue("","string",[]);}else if(r.length===1){v=r[0].values[0];}return v;};
function p(r){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){p.call(this,r);}}.bind(this));return;}var v=null;var A=null;var O=this.getValue();var s=this.getAdditionalValue();if(r.length===0&&O===null&&s===null){return;}v=this._getResultForPromise(r);if(r.length===0&&!s){A=s;}else if(r.length===1&&r[0].values.length>1){A=r[0].values[1];}this._vValue=v;this._vAdditionalValue=A;if(!n.call(this,v,O,true)){this.setProperty("value",v,true);}if(A!==s&&!q.call(this)){this.setProperty("additionalValue",A,true);}}
h.prototype._getOperators=function(){return["EQ"];};
function q(){var r=this.getBinding("additionalValue");if(r&&r.getBindingMode()===f.OneWay){return true;}return false;}
return h;});
sap.ui.predefine('sap/ui/mdc/FilterField',['sap/ui/mdc/field/FieldBase','sap/ui/mdc/field/FieldBaseRenderer','sap/base/util/merge'],function(F,a,m){"use strict";
var b=F.extend("sap.ui.mdc.FilterField",{
metadata:{library:"sap.ui.mdc",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},
renderer:a
});
b.prototype.init=function(){F.prototype.init.apply(this,arguments);};
b.prototype.exit=function(){F.prototype.exit.apply(this,arguments);};
b.prototype._fireChange=function(c,v,w,p){var V;if(c){if(v){if(c.length==1){V=c[0].values[0];}}else{V=w;}}this.fireChange({value:V,valid:v,conditions:m([],c),promise:p});};
b.prototype._getOperators=function(){var o=this.getOperators();if(o.length===0){o=F.prototype._getOperators.apply(this,arguments);}return o;};
return b;});
sap.ui.predefine('sap/ui/mdc/chart/DrillStackHandler',["sap/ui/core/Core","sap/m/ResponsivePopover","sap/m/List","sap/m/Bar","sap/m/SearchField","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/m/library","sap/ui/Device","sap/ui/mdc/chart/DimensionItem","sap/ui/mdc/chart/ChartSettings"],function(C,R,L,B,S,c,I,M,D,d,e){"use strict";var f;var P=M.PlacementType;var g=M.ListType;var h=M.ListMode;
function _(o){var a=o.getAggregation("_chart").getDrillStack();var s=[];a.forEach(function(b){b.dimension.forEach(function(i){if(i!=null&&i!=""&&s.indexOf(i)==-1){s.push(i);}});});return s;}
function j(p){var i=p.filter(function(o){return o.kind=="Dimension";});if(i){i.sort(function(a,b){if(a.label&&b.label){return a.label.localeCompare(b.label);}});}return i;}
var k=function(){};
k.createDrillDownPopover=function(o){var l=new L({mode:h.SingleSelectMaster,selectionChange:function(a){var b=a.getParameter("listItem");if(b){var A=o.getAdaptationController();A.createItemChanges([{name:b.data("dim").name,position:o.getItems().length}]);}p.close();}});var s=new B();var p=new R({contentWidth:"25rem",contentHeight:"20rem",placement:P.Bottom,subHeader:s});var r=C.getLibraryResourceBundle("sap.ui.mdc");if(D.system.desktop){var i=new I({text:r.getText("chart.CHART_DRILLDOWN_TITLE")});p.setShowHeader(false);p.addContent(i);p.addAriaLabelledBy(i);}else{p.setTitle(r.getText("chart.CHART_DRILLDOWN_TITLE"));}p.addContent(l);o._oDrillDownPopover=p;return p;};
k.showDrillDownPopover=function(o){var F=o.getControlDelegate().fetchProperties(o);return F.then(function(p){var a=o._oDrillDownPopover;var b=a.getContent()[1];var l,s,m,n;b.destroyItems();l=_(o);s=j(p);for(var i=0;i<s.length;i++){m=s[i];if(l.indexOf(m.name)>-1){continue;}n=new c({title:m.label,type:g.Active});n.data("dim",m);b.addItem(n);}return new Promise(function(r,q){a.attachEventOnce("afterOpen",function u(t){r(a);});a.openBy(o._oDrillDownBtn);});});};
k.createDrillBreadcrumbs=function(o){return new Promise(function(r,a){sap.ui.require(["sap/m/Breadcrumbs"],function(b){var i=o.getAggregation("_chart");if(i){var l=new b();o.setAggregation("_breadcrumbs",l);this._updateDrillBreadcrumbs(o,l).then(function(){r(l);});}}.bind(this));}.bind(this));};
k.createCrumb=function(o,a){var i=o.getAggregation("_chart");var b=new f({text:a.dimensionText,press:function s(l){var m=o.getAggregation("_breadcrumbs"),n=m.indexOfLink(l.getSource());var p=i.getDrillStack()[i.getDrillStack().length-1].dimension,q=p.slice(n+1);i.fireDeselectData();var r=o.getItemsByKeys(q);var F=r.map(function(t){return{name:t.getKey(),visible:false};});o.getAdaptationController().createItemChanges(F);this._updateDrillBreadcrumbs(o,m);}.bind(this)});b.data("key",a.dimensionKey);return b;};
k._updateDrillBreadcrumbs=function(o,a){return new Promise(function(r,b){sap.ui.require(["sap/m/Link"],function(l){f=l;if(!a){return;}var m=o.getAggregation("_chart");if(!m){return;}var v=m.getDrillStack();var n=[];if(v){v.reverse();v.forEach(function(s,t,u){if(s.dimension.length>0&&typeof m.getDimensionByName(s.dimension[s.dimension.length-1])!='undefined'){var w=m.getDimensionByName(s.dimension[s.dimension.length-1]).getLabel();var x=m.getDimensionByName(s.dimension[s.dimension.length-1]).getName();if(t==0){a.setCurrentLocationText(w);}else{var y={dimensionKey:x,dimensionText:w};var z=this.createCrumb(o,y);n.push(z);}}else{if(t==0){a.setVisible(false);}}},this);}var p=a.getLinks();n.reverse();var q=false;if(p.length!==n.length){q=true;}else{for(var i=0;i<n.length;i++){if(n[i].getText()!=p[i].getText()){q=true;break;}}}if(q){if(a.getLinks()){a.destroyLinks();}for(var i=0;i<n.length;i++){a.addLink(n[i]);}}r(a);}.bind(this));}.bind(this));};
return k;});
sap.ui.predefine('sap/ui/mdc/chart/ToolbarHandler',["sap/ui/mdc/library","../ActionToolbar","sap/m/Title","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/ChartSettings"],function(M,A,T,O,a,C,b){"use strict";var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var d={createToolbar:function(o,u){u=u||[];if(!o.getAggregation("_toolbar")){var t=new A(o.getId()+"--toolbar",{design:"Transparent",begin:[new T(o.getId()+"-title",{text:o.getHeader()})],actions:u});o.setAggregation("_toolbar",t);this.updateToolbar(o);}},updateToolbar:function(o){var t=o.getAggregation("_toolbar");if(!t){return;}t.destroyEnd();if(!o.getIgnoreToolbarActions().length||o.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.ZoomInOut)){var i=o.getAggregation("_chart"),z,Z;z=new O({tooltip:c.getText("chart.TOOLBAR_ZOOM_IN"),icon:"sap-icon://zoom-in",enabled:"{= ${$mdcChart>/_chart/getZoomInfo/enabled} && ${$mdcChart>/_chart/getZoomInfo/currentZoomLevel} < 1}",press:function f(e){this.handleZoomIn(i,z,Z);}.bind(this)});Z=new O({tooltip:c.getText("chart.TOOLBAR_ZOOM_OUT"),icon:"sap-icon://zoom-out",enabled:"{= ${$mdcChart>/_chart/getZoomInfo/enabled} && ${$mdcChart>/_chart/getZoomInfo/currentZoomLevel} > 0}",press:function f(e){this.handleZoomOut(i,z,Z);}.bind(this)});t.addEnd(z);t.addEnd(Z);if(i){i.attachRenderComplete(function g(e){var f=i.getZoomInfo();this.handleInnerChartRenderCompleted(f,z,Z);},this);}}if(!o.getIgnoreToolbarActions().length||o.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.DrillDownUp)<0){o._oDrillDownBtn=new O(o.getId()+"-drillDown",{icon:"sap-icon://drill-down",tooltip:c.getText("chart.CHART_DRILLDOWN_TITLE"),press:[o._showDrillDown,o]});t.addEnd(o._oDrillDownBtn);}if(!o.getIgnoreToolbarActions().length||o.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.Legend)<0){t.addEnd(new a({type:"Transparent",text:c.getText("chart.LEGENDBTN_TEXT"),tooltip:c.getText("chart.LEGENDBTN_TOOLTIP"),icon:"sap-icon://legend",pressed:"{$mdcChart>/legendVisible}"}));}var p=o.getP13nMode()||[];if(p.indexOf("Item")>-1){t.addEnd(new O(o.getId()+"-chart_settings",{icon:"sap-icon://action-settings",tooltip:c.getText('chart.PERSONALIZATION_DIALOG_TITLE'),press:function(e){var s=e.getSource();o._getPropertyData().then(function(P){b.showPanel(o,"Chart",s,P);});}}));}if(p.indexOf("Sort")>-1){t.addEnd(new O(o.getId()+"-sort_settings",{icon:"sap-icon://sort",tooltip:c.getText('sort.PERSONALIZATION_DIALOG_TITLE'),press:function(e){var s=e.getSource();o._getPropertyData().then(function(P){b.showPanel(o,"Sort",s,P);});}}));}if(p.indexOf("Type")>-1){t.addEnd(new C(o));}},handleInnerChartRenderCompleted:function(z,Z,o){this.toggleZoomButtonsEnabledState(z,Z,o);},handleZoomIn:function(i,z,Z){i.zoom({direction:"in"});var o=i.getZoomInfo();this.toggleZoomButtonsEnabledState(o,z,Z);},handleZoomOut:function(i,z,Z){i.zoom({direction:"out"});var o=i.getZoomInfo();this.toggleZoomButtonsEnabledState(o,z,Z);},toggleZoomButtonsEnabledState:function(z,Z,o){var v=z.currentZoomLevel;if(v==null){Z.setEnabled(false);o.setEnabled(false);return;}if(v===0){Z.setEnabled(true);o.setEnabled(false);if(o.getFocusDomRef()===document.activeElement){Z.focus();}return;}if(v===1){o.setEnabled(true);Z.setEnabled(false);if(Z.getFocusDomRef()===document.activeElement){o.focus();}return;}Z.setEnabled(true);o.setEnabled(true);}};return d;});
sap.ui.predefine('sap/ui/mdc/condition/Condition',['sap/base/Log','sap/ui/mdc/enum/ConditionValidated'],function(L,C){"use strict";var a={createItemCondition:function(k,d,i,o){var v=C.NotValidated;var V=[k,d];if(d===null||d===undefined){V.pop();}else{v=C.Validated;}return this.createCondition("EQ",V,i,o,v);},createCondition:function(o,v,i,O,V){var c={operator:o,values:v,isEmpty:null,validated:V};if(i){c.inParameters=i;}if(O){c.outParameters=O;}return c;},_removeEmptyConditions:function(c){for(var i=c.length-1;i>-1;i--){if(c[i].isEmpty){c.splice(parseInt(i),1);}}return c;}};return a;},true);
sap.ui.predefine('sap/ui/mdc/condition/ConditionConverter',['sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/BaseType','sap/ui/mdc/util/DateUtil','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/base/util/merge'],function(C,B,D,F,O,m){"use strict";var d="yyyy-MM-ddTHH:mm:ssZ";var s="yyyy-MM-dd";var t="HH:mm:ss";var a={toString:function(o,T,g){var v=b(o.values,_(o,g)||T);if(o.operator==="EQ"){v=[v[0]];}var i;var h;if(o.inParameters){i=m({},o.inParameters);}if(o.outParameters){h=m({},o.outParameters);}var r=C.createCondition(o.operator,v,i,h,o.validated);return r;},toType:function(o,T,g){var v=e(o.values,_(o,g)||T);var i;var h;if(o.inParameters){i=m({},o.inParameters);}if(o.outParameters){h=m({},o.outParameters);}var r=C.createCondition(o.operator,v,i,h,o.validated);return r;}};
function _(o,T){var g=F.getOperator(o.operator);if(g&&g.valueTypes[0]&&(g.valueTypes[0]!==O.ValueType.Self&&g.valueTypes[0]!==O.ValueType.Static)){return T.getTypeConfig(g._createLocalType(g.valueTypes[0]));}}
function b(v,T){var r=[];for(var i=0;i<v.length;i++){var V=v[i];r.push(c(V,T));}return r;}
function c(v,T){var g=T.baseType;var o=T.typeInstance;switch(g){case B.DateTime:return D.typeToString(v,o,d);case B.Date:return D.typeToString(v,o,s);case B.Time:return D.typeToString(v,o,t);case B.Boolean:return v;case B.Numeric:if(o.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||o.getMetadata().getName()==="sap.ui.model.odata.type.Decimal"){return v.toString();}return v;default:return o.formatValue(v,"string");}}
function e(v,T){var r=[];for(var i=0;i<v.length;i++){var V=v[i];r.push(f(V,T));}return r;}
function f(v,T){var g=T.baseType;var o=T.typeInstance;switch(g){case B.DateTime:return D.stringToType(v,o,d);case B.Date:return D.stringToType(v,o,s);case B.Time:return D.stringToType(v,o,t);case B.Boolean:return v;case B.Numeric:if(o.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||o.getMetadata().getName()==="sap.ui.model.odata.type.Decimal"){return o.parseValue(v,"string");}return v;default:return T.typeInstance.parseValue(v,"string");}}
return a;},true);
sap.ui.predefine('sap/ui/mdc/condition/ConditionModel',['sap/ui/mdc/condition/ConditionModelPropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/model/ChangeReason','sap/ui/mdc/condition/FilterOperatorUtil','sap/base/util/merge','sap/base/util/deepEqual','sap/base/Log','sap/ui/mdc/condition/Condition',"sap/ui/mdc/condition/FilterConverter"],function(C,J,F,b,c,m,d,L,e,f){"use strict";
var g=J.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){J.apply(this,arguments);this.setSizeLimit(1000);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{});}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{});}}});
g.prototype.bindProperty=function(p,o,P){var E=p;if(p.startsWith("/conditions/")){var s=p.slice(12);this._getFieldPathProperty(s);s=h.call(this,s);E="/conditions/"+s;}var B=new C(this,E,o,P);B._sOriginapPath=p;return B;};
g.prototype.getContext=function(p){if(p.startsWith("/conditions/")){var s=p.slice(12);s=h.call(this,s);p="/conditions/"+s;}return J.prototype.getContext.apply(this,[p]);};
g.prototype.bindList=function(p,o,s,a,P){var B=J.prototype.bindList.apply(this,arguments);B.enableExtendedChangeDetection(true);return B;};
g.prototype.destroy=function(){J.prototype.destroy.apply(this,arguments);};
g.prototype.clone=function(s){var o=new g();o._sName=this._sName+"_clone";var a={};if(typeof s==="string"){var j=this.getConditions(s);for(var i=0;i<j.length;i++){var k=j[i];var M=h.call(this,s);if(!a[M]){a[M]=[];}a[M].push(m({},k));}}else{a=m({},this.getAllConditions());}o.setConditions(a);return o;};
g.prototype.merge=function(s,S,a){this.removeAllConditions(s);var o=m({},S.getAllConditions());for(var M in o){if(!(typeof a==="string")||M===a){var j=e._removeEmptyConditions(o[M]);for(var i=0;i<j.length;i++){var k=j[i];this.addCondition(M,k);}}}this.checkUpdate(true,true);};
g.prototype.getConditions=function(s){return _.call(this,s);};
function _(s,a){var o=this.getProperty("/conditions");var i;if(typeof s=="string"){s=h.call(this,s);if(!o[s]&&a){o[s]=[];}i=o[s]||[];}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!");}return i;}
g.prototype.getAllConditions=function(v){var o=this.getProperty("/conditions");var r={};for(var M in o){var a=this.getProperty("/fieldPath");var i=a[M];var s=i?i.fieldPath:M;if(v&&[].concat(v).indexOf(s)===-1){continue;}r[s]=m([],o[M]);}return r;};
g.prototype.indexOf=function(s,o){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var a=this.getConditions(s);var i=c.indexOfCondition(o,a);return i;};
g.prototype.exist=function(o,s){if(typeof s==="string"){return this.indexOf(s,o)>=0;}else{throw new Error("sFieldPath must be provided "+this);}};
g.prototype.setConditions=function(o){var i=0;var a;this.setProperty("/conditions",{},undefined,true);if(Array.isArray(o)){throw new Error("setConditions with an Array of condition is not supported! "+this);}else{this._bNoSingleEvent=true;for(var M in o){this._getFieldPathProperty(M);for(i=0;i<o[M].length;i++){a=o[M][i];this.insertCondition(M,-1,a,true);}this.firePropertyChange({reason:b.Add,path:"/conditions/"+M,context:undefined,value:o[M]});}this.checkUpdate(true,true);this._bNoSingleEvent=false;}return this;};
g.prototype.addCondition=function(s,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}return this.insertCondition(s,-1,o,a);};
g.prototype.insertCondition=function(s,I,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}if(!o){return this;}var j;c.checkConditionsEmpty(o);c.updateConditionsValues(o);this._getFieldPathProperty(s);if(!a){var i=this.indexOf(s,o);if(i>=0){return this;}}j=_.call(this,s,true);if(I==-1){j.push(o);}else{j.splice(I,0,o);}if(!this._bNoSingleEvent){this.checkUpdate(true,true);this.firePropertyChange({reason:b.Add,path:"/conditions/"+s,context:undefined,value:j});}return this;};
g.prototype.createItemCondition=function(s,k,D){L.error("ConditionModel","createItemCondition is deprecated");return e.createItemCondition(k,D);};
g.prototype.createCondition=function(s,o,v){L.error("ConditionModel","createCondition is deprecated");return e.createCondition(o,v);};
g.prototype.removeCondition=function(s,v){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var i=-1;if(typeof v==="object"){i=this.indexOf(s,v);}else if(typeof v==="number"){i=v;}if(i>=0){var a=this.getConditions(s);if(a.length>i){a.splice(i,1);this.checkUpdate(true,true);this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:a});return true;}}return false;};
g.prototype.removeAllConditions=function(s){var o=this.getProperty("/conditions");if(typeof s==="string"){var E=h.call(this,s);if(o[E]&&o[E].length>0){o[E]=[];this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:o[s]});}}else{for(var M in o){if(o[M]&&o[M].length>0){o[M]=[];var a=this.getProperty("/fieldPath");var O=a[M].fieldPath;this.firePropertyChange({reason:b.Remove,path:"/conditions/"+O,context:undefined,value:o[M]});}}}this.checkUpdate(true,true);return this;};
g.prototype._getFieldPathProperty=function(s){var E=h.call(this,s);var o=this.getProperty("/fieldPath");if(!o[E]){o[E]={fieldPath:s};}var a=this.getProperty("/conditions");if(!a[E]){a[E]=[];}return o[E];};
g.prototype.getFilters=function(s){L.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return f.createFilters(this.getAllConditions(),{});};
g.prototype.serialize=function(){var o=m({},this.getAllConditions());for(var M in o){var a=o[M];a.forEach(function(i){delete i.isEmpty;},this);if(a.length===0){delete o[M];}}return'{"conditions":'+JSON.stringify(o)+"}";};
g.prototype.parse=function(o){var i=function(k,v){var a;if(!isNaN(parseInt(k))&&(typeof v==='string')){a=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(v);if(a){return new Date(v);}}return v;};this.setConditions(JSON.parse(o,i).conditions);};
function h(s){if(s){var p=s.split("/");if(p.length>1){s="";for(var i=0;i<p.length;i++){var P=p[i];if(i>0){if(!isNaN(P)||!isNaN(p[i-1])){s=s+"/";}else{s=s+"\\";}}s=s+P;}}}return s;}
return g;});
sap.ui.predefine('sap/ui/mdc/condition/ConditionModelPropertyBinding',['sap/ui/model/ChangeReason','sap/ui/model/json/JSONPropertyBinding','sap/base/util/merge','sap/base/util/deepEqual'],function(C,J,m,d){"use strict";
var a=J.extend("sap.ui.mdc.condition.ConditionModelPropertyBinding",{constructor:function(M,p,c,P){J.apply(this,arguments);this.oValue=_.call(this,this._getValue());}});
a.prototype.getValue=function(){return _.call(this,this.oValue);};
a.prototype.setValue=function(v){if(this.bSuspended){return;}if(!d(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=_.call(this,v);this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this._sOriginapPath,context:this.oContext,value:v});}}};
a.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!d(v,this.oValue)||f){this.oValue=_.call(this,v);this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
function _(v){var c;if(!v){c=v;}else if(Array.isArray(v)){c=m([],v);}else if(v instanceof Date){c=new Date(v);}else if(typeof v==="object"){c=m({},v);}else{c=v;}return c;}
return a;});
sap.ui.predefine('sap/ui/mdc/condition/FilterConverter',["sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(F,a,b,L){"use strict";var c={createConditionTypesMapFromFilterBar:function(C,f){var r={};for(var s in C){if(f){var p=f._getPropertyByName(s);var d=p&&p.typeConfig&&p.typeConfig.typeInstance;r[s]={type:d};}}return r;},createFilters:function(C,o,f){var i,l,d,O=[],e,g,n,h,A;var k=function(g,t,P){var v="L1";var S,N,u;if(g.sPath&&g.sPath.indexOf(P)>-1){S=g.sPath.split(P);if(S.length===2){N=S[0];u=S[1];g.sPath=v+"/"+u;return{path:N,operator:t,variable:v};}else{throw new Error("FilterConverter: not supported binding "+g.sPath);}}return false;};var m=function(g){var t=k(g,b.Any,"*/");if(t){return t;}else{return k(g,b.All,"+/");}};for(var s in C){l=[];d=[];A=null;var p=C[s];for(i=0;i<p.length;i++){h=p[i];e=F.getOperator(h.operator);if(!e){continue;}var D;if(o){if(o[s]){D=o[s].type;if(!D){L.warning("FilterConverter","Not able to retrieve the type of path '"+s+"!");}}}try{g=e.getModelFilter(h,s,D);}catch(q){L.error("FilterConverter","Not able to convert the condition for path '"+s+"' into a filter! The type is missing!");continue;}if(f){g=f(h,s,D,g);if(!g){continue;}}if(!e.exclude){if(g.sPath==="$search"){continue;}var $=/^\*(.+)\*$/.exec(g.sPath);if($){var r=$[1].split(',');for(var j=0;j<r.length;j++){l.push(new a(r[j],g.sOperator,g.oValue1));}continue;}A=m(g);l.push(g);}else{A=m(g);d.push(g);}}g=undefined;if(l.length===1){g=l[0];}else if(l.length>1){g=new a({filters:l,and:false});}if(g){d.unshift(g);}n=undefined;if(d.length===1){n=d[0];}else if(d.length>1){n=new a({filters:d,and:true});}if(A){A.condition=n;n=new a(A);}if(n){O.push(n);}}if(O.length===1){g=O[0];}else if(O.length>1){g=new a({filters:O,and:true});}else{g=null;}L.info("FilterConverter",c.prettyPrintFilters(g));return g;},prettyPrintFilters:function(f){var r;if(!f){return"";}if(f._bMultiFilter){r="";var A=f.bAnd;f.aFilters.forEach(function(f,i,d){r+=c.prettyPrintFilters(f);if(d.length-1!=i){r+=A?" and ":" or ";}},this);return"("+r+")";}else{if(f.sOperator===b.Any||f.sOperator===b.All){r=f.sPath+" "+f.sOperator+" "+c.prettyPrintFilters(f.oCondition);}else{r=f.sPath+" "+f.sOperator+" '"+f.oValue1+"'";if(f.sOperator===b.BT){r+="...'"+f.oValue2+"'";}}return r;}}};return c;},true);
sap.ui.predefine('sap/ui/mdc/condition/FilterOperatorUtil',['sap/ui/model/FilterOperator','sap/ui/model/Filter','sap/ui/model/ValidateException','sap/base/Log','sap/base/util/merge','sap/ui/mdc/enum/FieldDisplay','./Operator','./RangeOperator','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/core/date/UniversalDateUtils'],function(M,F,V,L,m,a,O,R,B,C,U){"use strict";var b={_mOperators:{equal:new O({name:"EQ",filterOperator:M.EQ,tokenParse:"^=([^=].*)$",tokenFormat:"{1} ({0})",valueTypes:[O.ValueType.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(c,t,d){d=d||a.DescriptionValue;var e=this.valueTypes.length;var v=c.values;var T=(c&&c.validated===C.Validated)||v.length===2?"":"=";var s=T+this.displayFormats[d];if(!v[1]){s=T+this.displayFormats["Value"];e=1;}for(var i=0;i<e;i++){var r,f=v[i];if(f===null||f===undefined){f="";}if(i==0&&t&&(typeof t.formatValue==="function")){r=t.formatValue(f,"string");}else{r=f;}s=r==null?null:s.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}return s;},parse:function(t,T,d,D){d=d||a.DescriptionValue;var r=O.prototype.parse.apply(this,[t,T,d,D]);if(D&&(!r||r[0]===null||r[0]===undefined)&&d!==a.Value){d=a.Value;r=O.prototype.parse.apply(this,[t,T,d,D]);}if(r&&(r[1]===null||r[1]===undefined)&&d===a.Value){r=[r[0]];}return r;},getValues:function(t,d,D){var c=t.match(this.tokenParseRegExp);var v;if(c||(D&&t)){var s;var T=this.displayFormats[d];var k=T.indexOf("{0}");var i=T.indexOf("{1}");var K;var e;if(c){s=c[1];}else if(D){s=t;}if(k>=0&&i>=0){if(s.lastIndexOf("(")>0&&(s.lastIndexOf(")")===s.length-1||s.lastIndexOf(")")===-1)){var E=s.length;if(s[E-1]===")"){E--;}var f=s.substring(0,s.lastIndexOf("("));if(f[f.length-1]===" "){f=f.substring(0,f.length-1);}var g=s.substring(s.lastIndexOf("(")+1,E);if(k<i){K=f;e=g;}else{K=g;e=f;}}else if(k<i){K=s;}else{e=s;}}else if(k>=0){K=s;}else{e=s;}v=[K];if(i>=0){v.push(e);}}return v;},isEmpty:function(c,t){var i=false;var v=c.values[0];if((v===null||v===undefined||v==="")&&!c.values[1]){i=true;}return i;},getCheckValue:function(c){return{value:c.values[0]};},checkValidated:function(c){if(c.values.length===2&&c.values[0]!==undefined&&c.values[1]!==null&&c.values[1]!==undefined){c.validated=C.Validated;}else{c.validated=C.NotValidated;}},validateInput:true}),between:new O({name:"BT",filterOperator:M.BT,tokenParse:"^([^!].*)\\.\\.\\.(.+)$",tokenFormat:"{0}...{1}",valueTypes:[O.ValueType.Self,O.ValueType.Self],validate:function(v,t){if(v.length<2){throw new V("Between must have two values");}if(v[0]===v[1]){throw new V("Between must have two different values");}O.prototype.validate.apply(this,[v,t]);}}),betweenExclBoundaries:new O({name:"BTEX",filterOperator:M.BT,tokenParse:"^([^!].*)\\.\\.(.+)$",tokenFormat:"{0}..{1}",valueTypes:[O.ValueType.Self,O.ValueType.Self],getModelFilter:function(c,f,t){return new F({filters:[new F(f,M.GT,c.values[0]),new F(f,M.LT,c.values[1])],and:true});},validate:function(v,t){if(v.length<2){throw new V("Between must have two values");}if(v[0]===v[1]){throw new V("Between must have two different values");}O.prototype.validate.apply(this,[v,t]);}}),notBetween:new O({name:"NOTBT",filterOperator:M.NB,tokenParse:"^!(.+)\\.\\.\\.(.+)$",tokenFormat:"!({0}...{1})",valueTypes:[O.ValueType.Self,O.ValueType.Self],exclude:true,validate:function(v,t){if(v.length<2){throw new V("NotBetween must have two values");}if(v[0]===v[1]){throw new V("NotBetween must have two different values");}O.prototype.validate.apply(this,[v,t]);}}),notBetweenExclBoundaries:new O({name:"NOTBTEX",filterOperator:M.NB,tokenParse:"^!(.+)\\.\\.(.+)$",tokenFormat:"!({0}..{1})",valueTypes:[O.ValueType.Self,O.ValueType.Self],exclude:true,getModelFilter:function(c,f,t){return new F({filters:[new F(f,M.LE,c.values[0]),new F(f,M.GE,c.values[1])],and:false});},validate:function(v,t){if(v.length<2){throw new V("NotBetween must have two values");}if(v[0]===v[1]){throw new V("NotBetween must have two different values");}O.prototype.validate.apply(this,[v,t]);}}),lowerThan:new O({name:"LT",filterOperator:M.LT,tokenParse:"^<([^=].*)$",tokenFormat:"<{0}",valueTypes:[O.ValueType.Self]}),notLowerThan:new O({name:"NOTLT",filterOperator:M.GE,tokenParse:"^!<([^=].*)$",tokenFormat:"!(<{0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterThan:new O({name:"GT",filterOperator:M.GT,tokenParse:"^>([^=].*)$",tokenFormat:">{0}",valueTypes:[O.ValueType.Self]}),notGreaterThan:new O({name:"NOTGT",filterOperator:M.LE,tokenParse:"^!>([^=].*)$",tokenFormat:"!(>{0})",valueTypes:[O.ValueType.Self],exclude:true}),lessEqual:new O({name:"LE",filterOperator:M.LE,tokenParse:"^<=(.+)$",tokenFormat:"<={0}",valueTypes:[O.ValueType.Self]}),notLessEqual:new O({name:"NOTLE",filterOperator:M.GT,tokenParse:"^!<=(.+)$",tokenFormat:"!(<={0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterEqual:new O({name:"GE",filterOperator:M.GE,tokenParse:"^>=(.+)$",tokenFormat:">={0}",valueTypes:[O.ValueType.Self]}),notGreaterEqual:new O({name:"NOTGE",filterOperator:M.LT,tokenParse:"^!>=(.+)$",tokenFormat:"!(>={0})",valueTypes:[O.ValueType.Self],exclude:true}),startsWith:new O({name:"StartsWith",filterOperator:M.StartsWith,tokenParse:"^([^!\\*]+.*)\\*$",tokenFormat:"{0}*",valueTypes:[O.ValueType.Self]}),notStartsWith:new O({name:"NotStartsWith",filterOperator:M.NotStartsWith,tokenParse:"^!([^\\*].*)\\*$",tokenFormat:"!({0}*)",valueTypes:[O.ValueType.Self],exclude:true}),endsWith:new O({name:"EndsWith",filterOperator:M.EndsWith,tokenParse:"^\\*(.*[^\\*])$",tokenFormat:"*{0}",valueTypes:[O.ValueType.Self]}),notEndsWith:new O({name:"NotEndsWith",filterOperator:M.NotEndsWith,tokenParse:"^!\\*(.*[^\\*])$",tokenFormat:"!(*{0})",valueTypes:[O.ValueType.Self],exclude:true}),contains:new O({name:"Contains",filterOperator:M.Contains,tokenParse:"^\\*(.*)\\*$",tokenFormat:"*{0}*",valueTypes:[O.ValueType.Self]}),notContains:new O({name:"NotContains",filterOperator:M.NotContains,tokenParse:"^!\\*(.*)\\*$",tokenFormat:"!(*{0}*)",valueTypes:[O.ValueType.Self],exclude:true}),notEqual:new O({name:"NE",filterOperator:M.NE,tokenParse:"^!=(.+)$",tokenFormat:"!(={0})",valueTypes:[O.ValueType.Self],exclude:true}),empty:new O({name:"Empty",filterOperator:M.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",valueTypes:[],getModelFilter:function(c,f,t){var i=false;if(t){var r=t.parseValue("","string");try{t.validateValue(r);i=r===null;}catch(e){i=false;}}if(i){return new F({filters:[new F(f,M.EQ,""),new F(f,M.EQ,null)],and:false});}else{return new F(f,this.filterOperator,"");}}}),notEmpty:new O({name:"NotEmpty",filterOperator:M.NE,tokenParse:"^!<#tokenText#>$",tokenFormat:"!(<#tokenText#>)",valueTypes:[],exclude:true,getModelFilter:function(c,f,t){return new F({path:f,operator:this.filterOperator,value1:""});}}),yesterday:new R({name:"YESTERDAY",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.yesterday();},formatRange:function(r,d){return d.formatValue(r[0],"string");}}),today:new R({name:"TODAY",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.today();},formatRange:function(r,d){return d.formatValue(r[0],"string");}}),tomorrow:new R({name:"TOMORROW",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.tomorrow();},formatRange:function(r,d){return d.formatValue(r[0],"string");}}),lastDays:new R({name:"LASTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.lastDays(d);}}),todayXYDays:new R({name:"TODAYXYDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)","(\\d+)"],additionalInfo:"",calcRange:function(x,y){var s=x>=0?U.ranges.lastDays(x)[0]:U.ranges.nextDays(-x)[1];var e=y>=0?U.ranges.nextDays(y)[1]:U.ranges.lastDays(-y)[0];if(s.oDate.getTime()>e.oDate.getTime()){e=[s,s=e][0];}return[U.resetStartTime(s),U.resetEndTime(e)];}}),nextDays:new R({name:"NEXTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.nextDays(d);}}),lastWeek:new R({name:"LASTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.lastWeek();}}),currentWeek:new R({name:"CURRENTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.currentWeek();}}),nextWeek:new R({name:"NEXTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.nextWeek();}}),lastWeeks:new R({name:"LASTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.lastWeeks(d);}}),nextWeeks:new R({name:"NEXTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.nextWeeks(d);}}),lastMonth:new R({name:"LASTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.lastMonth();}}),currentMonth:new R({name:"CURRENTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.currentMonth();}}),nextMonth:new R({name:"NEXTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.nextMonth();}}),lastMonths:new R({name:"LASTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.lastMonths(d);}}),nextMonths:new R({name:"NEXTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.nextMonths(d);}}),lastQuarter:new R({name:"LASTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.lastQuarter();}}),currentQuarter:new R({name:"CURRENTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.currentQuarter();}}),nextQuarter:new R({name:"NEXTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.nextQuarter();}}),lastQuarters:new R({name:"LASTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.lastQuarters(d);}}),nextQuarters:new R({name:"NEXTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.nextQuarters(d);}}),firstQuarter:new R({name:"FIRSTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.quarter(1);}}),secondQuarter:new R({name:"SECONDQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.quarter(2);}}),thirdQuarter:new R({name:"THIRDQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.quarter(3);}}),fourthQuarter:new R({name:"FOURTHQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.quarter(4);}}),lastYear:new R({name:"LASTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.lastYear();}}),currentYear:new R({name:"CURRENTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.currentYear();}}),nextYear:new R({name:"NEXTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.nextYear();}}),lastYears:new R({name:"LASTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.lastYears(d);}}),nextYears:new R({name:"NEXTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(d){return U.ranges.nextYears(d);}}),yearToDate:new R({name:"YEARTODATE",valueTypes:[O.ValueType.Static],calcRange:function(){return U.ranges.yearToDate();}})},_mDefaultOpsForType:{},addOperator:function(o){b._mOperators[o.name]=o;},setOperatorsForType:function(t,o,d){var c=[];o.forEach(function(e){if(typeof e==="string"){c.push(b.getOperator(e));}else{c.push(e);}});b._mDefaultOpsForType[t]={operators:c};if(d){if(typeof d==="string"){d=b.getOperator(d);}b._mDefaultOpsForType[t].defaultOperator=d;}},getOperatorsForType:function(t){var o=[];for(var i=0;i<b._mDefaultOpsForType[t].operators.length;i++){o.push(b._mDefaultOpsForType[t].operators[i].name);}return o;},getDefaultOperator:function(t){return b._mDefaultOpsForType[t].defaultOperator||b._mOperators.equal;},getMatchingOperators:function(o,v){var c=[];for(var i=0;i<o.length;i++){var d=this.getOperator(o[i]);if(d){c.push(d);}}return _.call(this,c,v);},getOperator:function(o){for(var n in b._mOperators){var c=b._mOperators[n];if(c.name===o){return c;}}return undefined;},getEQOperator:function(){return b._mOperators.equal;},onlyEQ:function(o){if(o.length===1&&o[0]==="EQ"){return true;}else{return false;}},checkConditionsEmpty:function(c){if(!Array.isArray(c)){c=[c];}c.forEach(function(o){var d=this.getOperator(o.operator);if(d){o.isEmpty=d.isEmpty(o);}}.bind(this));},updateConditionsValues:function(c){if(!Array.isArray(c)){c=[c];}for(var i=0;i<c.length;i++){this.updateConditionValues(c[i]);}},updateConditionValues:function(c){var o=this.getOperator(c.operator);if(o&&c.validated!==C.Validated){var v=o.valueTypes.length;if(o.valueTypes.length===2&&o.valueTypes[1]===null&&(c.values.length<2||c.values[1]===null||c.values[1]===undefined)){v=v-1;}if(o.valueTypes[0]==="static"){c.values=[];}else{while(c.values.length!=v){if(c.values.length<v){c.values.push(null);}if(c.values.length>v){c.values=c.values.slice(0,c.values.length-1);}}}}},indexOfCondition:function(c,d){var I=-1;for(var i=0;i<d.length;i++){if(this.compareConditions(c,d[i])){I=i;break;}}return I;},compareConditions:function(c,o){var e=false;if(c.operator===o.operator){var d=this.getOperator(c.operator);if(d){e=d.compareConditions(c,o);}}return e;},compareConditionsArray:function(c,d){var e=false;if(c.length===d.length){e=true;for(var i=0;i<c.length;i++){if(!this.compareConditions(c[i],d[i])){e=false;break;}}}return e;},checkConditionValidated:function(c){var o=this.getOperator(c.operator);if(!c.validated&&o&&o.checkValidated){o.checkValidated(c);}}};b.setOperatorsForType(B.String,[b._mOperators.contains,b._mOperators.equal,b._mOperators.between,b._mOperators.startsWith,b._mOperators.endsWith,b._mOperators.empty,b._mOperators.lessEqual,b._mOperators.lowerThan,b._mOperators.greaterEqual,b._mOperators.greaterThan,b._mOperators.notContains,b._mOperators.notEqual,b._mOperators.notBetween,b._mOperators.notStartsWith,b._mOperators.notEndsWith,b._mOperators.notEmpty,b._mOperators.notLessEqual,b._mOperators.notLowerThan,b._mOperators.notGreaterEqual,b._mOperators.notGreaterThan],b._mOperators.equal);b.setOperatorsForType(B.Date,[b._mOperators.equal,b._mOperators.greaterEqual,b._mOperators.lessEqual,b._mOperators.lowerThan,b._mOperators.greaterThan,b._mOperators.between,b._mOperators.notEqual,b._mOperators.notBetween,b._mOperators.notLessEqual,b._mOperators.notLowerThan,b._mOperators.notGreaterEqual,b._mOperators.notGreaterThan,b._mOperators.today,b._mOperators.yesterday,b._mOperators.tomorrow,b._mOperators.todayXYDays,b._mOperators.lastDays,b._mOperators.nextDays,b._mOperators.currentWeek,b._mOperators.lastWeek,b._mOperators.lastWeeks,b._mOperators.nextWeek,b._mOperators.nextWeeks,b._mOperators.currentMonth,b._mOperators.lastMonth,b._mOperators.lastMonths,b._mOperators.nextMonth,b._mOperators.nextMonths,b._mOperators.currentQuarter,b._mOperators.lastQuarter,b._mOperators.lastQuarters,b._mOperators.nextQuarter,b._mOperators.nextQuarters,b._mOperators.firstQuarter,b._mOperators.secondQuarter,b._mOperators.thirdQuarter,b._mOperators.fourthQuarter,b._mOperators.currentYear,b._mOperators.lastYear,b._mOperators.lastYears,b._mOperators.nextYear,b._mOperators.nextYears,b._mOperators.yearToDate]);b.setOperatorsForType(B.DateTime,[b._mOperators.equal,b._mOperators.between,b._mOperators.lessEqual,b._mOperators.lowerThan,b._mOperators.greaterEqual,b._mOperators.greaterThan,b._mOperators.notEqual,b._mOperators.notBetween,b._mOperators.notLessEqual,b._mOperators.notLowerThan,b._mOperators.notGreaterEqual,b._mOperators.notGreaterThan]);b.setOperatorsForType(B.Numeric,[b._mOperators.equal,b._mOperators.between,b._mOperators.lessEqual,b._mOperators.lowerThan,b._mOperators.greaterEqual,b._mOperators.greaterThan,b._mOperators.notEqual,b._mOperators.notBetween,b._mOperators.notLessEqual,b._mOperators.notLowerThan,b._mOperators.notGreaterEqual,b._mOperators.notGreaterThan]);b.setOperatorsForType(B.Time,[b._mOperators.equal,b._mOperators.between,b._mOperators.lessEqual,b._mOperators.lowerThan,b._mOperators.greaterEqual,b._mOperators.greaterThan,b._mOperators.notEqual,b._mOperators.notBetween,b._mOperators.notLessEqual,b._mOperators.notLowerThan,b._mOperators.notGreaterEqual,b._mOperators.notGreaterThan]);b.setOperatorsForType(B.Boolean,[b._mOperators.equal,b._mOperators.notEqual]);
function _(o,v){var r=[];for(var i=0;i<o.length;i++){var c=o[i];if(c&&c.test&&c.test(v)){r.push(c);}}return r;}
return b;},true);
sap.ui.predefine('sap/ui/mdc/condition/Operator',['sap/ui/base/Object','sap/ui/model/Filter','sap/ui/model/ParseException','sap/ui/Device','sap/base/Log','sap/base/util/ObjectPath','./Condition','sap/ui/mdc/enum/ConditionValidated',"sap/base/strings/escapeRegExp"],function(B,F,P,D,L,O,C,a,e){"use strict";var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});
var b=B.extend("sap.ui.mdc.condition.Operator",{constructor:function(c){B.apply(this,arguments);if(!c){throw new Error("Operator configuration missing");}if(!c.name){L.warning("Operator configuration expects a name property");}if(!c.filterOperator&&!c.getModelFilter){throw new Error("Operator configuration for "+c.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter");}this.name=c.name;this.filterOperator=c.filterOperator;this.valueTypes=c.valueTypes;this.paramTypes=c.paramTypes;this.displayFormats=c.displayFormats;var t="operators."+this.name;var l=t+".longText";var T=t+".tokenText";this.longText=c.longText||_(l)||"";this.tokenText=c.tokenText||_(T)||"";if(this.longText===l){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y");}if(this.tokenText===T){this.tokenText=this.longText;}if(this.tokenText){var r;var s;if(c.tokenParse){s=e(this.tokenText);if(D.browser.msie){s=s.replace(/\$/g,"$$$");}this.tokenParse=c.tokenParse.replace(/#tokenText#/g,s);for(var i=0;i<this.valueTypes.length;i++){var R=this.paramTypes?this.paramTypes[i]:this.valueTypes[i];this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+i+"|"+i+"\\\\\\$"+"|"+"\\\\\\{"+i+"\\\\\\}","g"),R);}r=this.tokenParse;}else{r=e(this.tokenText);}this.tokenParseRegExp=new RegExp(r,"i");if(c.tokenFormat){s=this.tokenText;if(D.browser.msie){s=s.replace(/\$/g,"$$$");}this.tokenFormat=c.tokenFormat.replace(/\#tokenText\#/g,s);}else{this.tokenFormat=this.tokenText;}}if(c.format){this.format=c.format;}if(c.parse){this.parse=c.parse;}if(c.validate){this.validate=c.validate;}if(c.getModelFilter){this.getModelFilter=c.getModelFilter;}if(c.isEmpty){this.isEmpty=c.isEmpty;}if(c.createControl){this.createControl=c.createControl;}if(c.splitText){this.splitText=c.splitText;}if(c.getCheckValue){this.getCheckValue=c.getCheckValue;}if(c.getValues){this.getValues=c.getValues;}if(c.checkValidated){this.checkValidated=c.checkValidated;}if(c.additionalInfo!==undefined){this.additionalInfo=c.additionalInfo;}this.exclude=!!c.exclude;this.validateInput=!!c.validateInput;}});
b.ValueType={Self:"self",Static:"static"};
function _(k,t){var c=k+(t?"."+t:""),T;if(m.hasText(c)){T=m.getText(c);}else if(t){T=m.getText(k);}else{T=c;}return T;}
b.prototype.getTypeText=function(k,t){return _(k,t);};
b.prototype.getModelFilter=function(c,f,t){var v=c.values[0];var o;var d;var g=f.split(",");if(Array.isArray(v)&&g.length>1){v=v[0];f=g[0];d=new F({path:g[1],operator:"EQ",value1:c.values[0][1]});}if(d&&v===undefined){o=d;d=undefined;}else if(this.valueTypes.length==1){o=new F({path:f,operator:this.filterOperator,value1:v});}else{var V=c.values[1];if(Array.isArray(V)&&g.length>1){V=V[0];}o=new F({path:f,operator:this.filterOperator,value1:v,value2:V});}if(d){o=new F({filters:[o,d],and:true});}if(c.inParameters){var h=[o];for(var i in c.inParameters){h.push(new F({path:i,operator:"EQ",value1:c.inParameters[i]}));}o=new F({filters:h,and:true});}return o;};
b.prototype.isEmpty=function(c,t){var d=false;if(c){for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]!==b.ValueType.Static){var v=c.values[i];if(v===null||v===undefined||v===""){d=true;break;}}}}return d;};
b.prototype.format=function(c,t,d){var V=c.values;var T=this.tokenFormat;var f=this.valueTypes.length;for(var i=0;i<f;i++){if(this.valueTypes[i]!==b.ValueType.Static){var v=V[i]!==undefined&&V[i]!==null?V[i]:"";if(this.valueTypes[i]!==b.ValueType.Self){t=this._createLocalType(this.valueTypes[i]);}var r=t?t.formatValue(v,"string"):v;T=T.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}}return T;};
b.prototype.parse=function(t,T,d,c){var v=this.getValues(t,d,c);var r;if(v){r=[];for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]&&[b.ValueType.Self,b.ValueType.Static].indexOf(this.valueTypes[i])===-1){T=this._createLocalType(this.valueTypes[i]);}try{if(this.valueTypes[i]!==b.ValueType.Static){var V;if(this.valueTypes[i]){V=this._parseValue(v[i],T);}else{V=v[i];}r.push(V);}}catch(f){L.warning(f.message);throw f;}}}return r;};
b.prototype._parseValue=function(v,t){if(v===undefined){return v;}var c;if(t instanceof sap.ui.model.CompositeType&&t._aCurrentValue&&t.getParseWithValues()){c=t._aCurrentValue;}var V=t?t.parseValue(v,"string",c):v;if(c&&Array.isArray(V)){for(var j=0;j<V.length;j++){if(V[j]===undefined){V[j]=c[j];}}}return V;};
b.prototype.validate=function(v,t){var c=this.valueTypes.length;for(var i=0;i<c;i++){var V=v[i]!==undefined&&v[i]!==null?v[i]:"";if(this.valueTypes[i]&&this.valueTypes[i]!==b.ValueType.Static){if([b.ValueType.Self,b.ValueType.Static].indexOf(this.valueTypes[i])===-1){t=this._createLocalType(this.valueTypes[i]);}if(t){t.validateValue(V);}}}};
b.prototype._createLocalType=function(t){if(!this._oType){var T;var f;var c;if(typeof t==="string"){T=t;}else if(t&&typeof t==="object"){T=t.name;f=t.formatOptions;c=t.constraints;}sap.ui.requireSync(T.replace(/\./g,"/"));var o=O.get(T||"");this._oType=new o(f,c);}return this._oType;};
b.prototype.test=function(t){return this.tokenParseRegExp.test(t);};
b.prototype.getValues=function(t,d,c){var M=t.match(this.tokenParseRegExp);var v;if(M||(c&&t)){v=[];for(var i=0;i<this.valueTypes.length;i++){var V;if(M){V=M[i+1];}else if(c){if(i>0){break;}V=t;}v.push(V);}}return v;};
b.prototype.getCondition=function(t,T,d,c){if(this.test(t)||(c&&t)){var v=this.parse(t,T,d,c);if(v.length==this.valueTypes.length||this.valueTypes[0]===b.ValueType.Static||(v.length===1&&this.valueTypes.length===2&&!this.valueTypes[1])){var o=C.createCondition(this.name,v);this.checkValidated(o);return o;}else{throw new P("Parsed value don't meet operator");}}return null;};
b.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false;}return true;};
b.prototype.getCheckValue=function(c){if(this.valueTypes[0]&&this.valueTypes[0]===b.ValueType.Static){return{};}else{return{values:c.values};}};
b.prototype.compareConditions=function(c,o){var E=false;if(c.operator===this.name&&c.operator===o.operator){var d=this.getCheckValue(c);var f=this.getCheckValue(o);if(c.inParameters&&o.inParameters){d.inParameters=c.inParameters;f.inParameters=o.inParameters;}if(c.outParameters&&o.outParameters){d.outParameters=c.outParameters;f.outParameters=o.outParameters;}if(c.validated&&o.validated){d.validated=c.validated;f.validated=o.validated;}var s=JSON.stringify(d);var g=JSON.stringify(f);if(s===g){E=true;}}return E;};
b.prototype.checkValidated=function(c){c.validated=a.NotValidated;};
return b;});
sap.ui.predefine('sap/ui/mdc/condition/RangeOperator',['sap/ui/mdc/condition/Operator','sap/ui/model/Filter','sap/ui/mdc/util/DateUtil','sap/base/Log'],function(O,F,D,L){"use strict";
var R=O.extend("sap.ui.mdc.condition.RangeOperator",{constructor:function(c){c.filterOperator="RANGE";c.tokenParse=c.tokenParse||"^#tokenText#$";c.tokenFormat=c.tokenFormat||"#tokenText#";O.apply(this,arguments);if(c.label!==undefined){this.aLabels=c.label;}if(c.calcRange){this.calcRange=c.calcRange;}if(c.formatRange){this.formatRange=c.formatRange;}else if(this.calcRange){this.formatRange=function(r,d){return d.formatValue(r[0],"string")+" - "+d.formatValue(r[1],"string");};}}});
R.prototype.getModelFilter=function(c,f,t){var r=this._getRange(c.values,t);return new F({path:f,operator:"BT",value1:r[0],value2:r[1]});};
R.prototype._getRange=function(v,t){var r;if(v){if(v.length===2){r=this.calcRange(v[0],v[1]);}else{r=this.calcRange(v[0]);}}else{r=this.calcRange();}for(var i=0;i<2;i++){if(t instanceof sap.ui.model.odata.type.Date||t instanceof sap.ui.model.type.Date){r[i].oDate=D.localToUtc(r[i].oDate);}r[i]=D.universalDateToType(r[i],t);}return r;};
R.prototype.getStaticText=function(t){var r=this._getRange(null,t);return this.formatRange(r,t);};
return R;},true);
sap.ui.predefine('sap/ui/mdc/enum/BaseType',function(){"use strict";var B={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};return B;},true);
sap.ui.predefine('sap/ui/mdc/enum/ConditionValidated',function(){"use strict";var C={NotValidated:"NotValidated",Validated:"Validated"};return C;},true);
sap.ui.predefine('sap/ui/mdc/enum/EditMode',function(){"use strict";var E={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};return E;},true);
sap.ui.predefine('sap/ui/mdc/enum/FieldDisplay',function(){"use strict";var F={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};return F;},true);
sap.ui.predefine('sap/ui/mdc/enum/OutParameterMode',function(){"use strict";var O={Always:"Always",WhenEmpty:"WhenEmpty"};return O;},true);
sap.ui.predefine('sap/ui/mdc/field/ConditionType',['sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/type/String','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/base/util/merge','sap/ui/base/SyncPromise'],function(S,F,P,V,a,b,c,C,B,d,m,e){"use strict";
var f=S.extend("sap.ui.mdc.field.ConditionType",{constructor:function(A,D){S.apply(this,arguments);this.sName="Condition";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}});
f.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._bDestroyed=true;};
f.prototype.formatValue=function(A,I){if(A==undefined||A==null||this._bDestroyed){return null;}if(typeof A!=="object"||!A.operator||!A.values||!Array.isArray(A.values)){throw new F("No valid condition provided");}if(!I){I="string";}var T=l.call(this);var O=n.call(this);var D=this.oFormatOptions.isUnit;var E=this.oFormatOptions.preventGetDescription;r.call(this,A,O);if(D){A=m({},A);if(A.values[0]&&Array.isArray(A.values[0])){A.values[0]=A.values[0][1];}if(A.operator!=="EQ"){A.operator="EQ";if(A.values[1]){A.values.splice(1,1);}}}r.call(this,A,T);switch(this.getPrimitiveType(I)){case"string":case"any":var G=k.call(this);if(!E&&A.operator==="EQ"&&G!==b.Value&&A.validated===d.Validated&&!A.values[1]){var H=this.oFormatOptions.bindingContext;return e.resolve().then(function(){return z.call(this,A.values[0],A.inParameters,A.outParameters,H);}.bind(this)).then(function(J){if(J){A=m({},A);if(typeof J==="object"){A=t.call(this,A,J);}else if(A.values.length===1){A.values.push(J);}else{A.values[1]=J;}}return _.call(this,A);}.bind(this)).catch(function(J){if(J instanceof F&&x.call(this)){return _.call(this,A);}else{throw J;}}.bind(this)).unwrap();}return _.call(this,A);default:if(T&&A.values.length>=1){return T.formatValue(A.values[0],I);}throw new F("Don't know how to format Condition to "+I);}};
function _(A){var D=k.call(this);var T=l.call(this);if(this.oFormatOptions.hideOperator&&A.values.length===1){return T.formatValue(A.values[0],"string");}var O=c.getOperator(A.operator);if(!O){throw new F("No valid condition provided, Operator wrong.");}return O.format(A,T,D);}
f.prototype.parseValue=function(A,I){if(this._bDestroyed){return null;}if(!I){I="string";}else if(I==="any"&&typeof A==="string"){I="string";}var N=this.oFormatOptions.navigateCondition;if(N){var O=this.formatValue(N,I);if(O===A){return m({},N);}}var D=k.call(this);var E=w.call(this);var T=l.call(this);var G=n.call(this);var H=o.call(this);var J=this.oFormatOptions.isUnit;var K;if(A===null||A===undefined||(A===""&&!E)){if(!q.call(this,T)&&!J){return null;}}s.call(this,T);s.call(this,G);switch(this.getPrimitiveType(I)){case"string":var L;var M=false;var U=false;if(H.length===1){L=c.getOperator(H[0]);U=true;}else{var Q=c.getMatchingOperators(H,A);if(Q.length===0){L=c.getDefaultOperator(v.call(this,T));if(L&&H.indexOf(L.name)<0){L=undefined;}if(E&&!q.call(this,T)&&H.indexOf("EQ")>=0){M=!!L&&L.name!=="EQ";L=c.getEQOperator();}U=true;}else{L=Q[0];}}if(L){var R;var W=q.call(this,T);if(!W&&L.validateInput&&E){R=h.call(this,L,A,T,U,M,H,D,true);if(R instanceof Promise){return u.call(this,R);}else{return R;}}else if(A===""&&!W){return g.call(this,null,T);}else{try{if(A===""&&W&&U){R=C.createCondition(L.name,[T.parseValue(A,"string",T._aCurrentValue)],undefined,undefined,d.NotValidated);}else{R=L.getCondition(A,T,D,U);}}catch(X){if(X instanceof P&&G){G.parseValue(A,"string",G._aCurrentValue);}throw X;}}if(R){return g.call(this,R,T);}}throw new P("Cannot parse value "+A);default:if(T){if(H.length===1){K=H[0];}else{K=c.getDefaultOperator(v.call(this,T)).name;if(K&&H.indexOf(K)<0){K=undefined;}}if(K){return C.createCondition(K,[T.parseValue(A,I)],undefined,undefined,d.NotValidated);}}throw new P("Don't know how to parse Condition from "+I);}};
function g(A,T){var I=this.oFormatOptions.isUnit;var O=n.call(this);var U=null;if(I){var M;if(O._aCurrentValue){M=O._aCurrentValue[0];}if(A){if(A.operator!=="EQ"){throw new P("unsupported operator");}U=A.values[0];A.values=[[M,U]];}else{A=C.createCondition("EQ",[[M,null]],undefined,undefined,d.NotValidated);}r.call(this,A,O);}else if(A){var N=T.getMetadata().getName();var D=this.oFormatOptions.delegate;var E=this.oFormatOptions.payload;if(D&&D.getTypeUtil(E).getBaseType(N)===B.Unit&&!A.values[0][1]&&T._aCurrentValue){U=T._aCurrentValue[1]?T._aCurrentValue[1]:null;A.values[0][1]=U;if(A.operator==="BT"){A.values[1][1]=U;}}r.call(this,A,T);r.call(this,A,O);}return A;}
function h(O,A,T,U,D,E,G,H){var K;var I;var J=true;var L=true;var M=false;var N;var Q;var R=this.oFormatOptions.bindingContext;var W;if(A===""){W=[];K=A;N=A;}else{W=O.getValues(A,G,U);K=H?W[0]:W[1];I=H?W[1]:W[0];M=G!==b.Value;L=G===b.Value||G===b.ValueDescription;N=L?K||I:I||K;}var X=function(Z){if(Z&&!(Z instanceof P)&&!(Z instanceof F)){throw Z;}if(!Z._bNotUnique){if(A===""){return null;}if(H&&W[0]&&W[1]){return h.call(this,O,A,T,U,D,E,G,false);}if(D){return i.call(this,T,E,A,G);}}if(x.call(this)){return j.call(this,T,E,A,G);}throw new P(Z.message);};var Y=function($){if($){return C.createCondition(O.name,[$.key,$.description],$.inParameters,$.outParameters,d.Validated);}else if(A===""){return null;}else{return X.call(this,new P(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[A])));}};try{Q=T.parseValue(N,"string");T.validateValue(Q);}catch(Z){if(Z&&!(Z instanceof P)&&!(Z instanceof V)){throw Z;}J=false;L=false;Q=undefined;}return e.resolve().then(function(){return y.call(this,N,Q,R,L,J,M);}.bind(this)).then(function($){var a1=Y.call(this,$);return g.call(this,a1,T);}.bind(this)).catch(function(Z){var $=X.call(this,Z);return g.call(this,$,T);}.bind(this)).unwrap();}
function i(T,O,A,D){var E=c.getDefaultOperator(v.call(this,T));var G;if(E&&O.indexOf(E.name)>=0){G=E.getCondition(A,T,b.Value,true);G.validated=d.NotValidated;}return G;}
function j(T,O,A,D){var E;if(O.length===1){E=c.getOperator(O[0]);}else if(O.indexOf("EQ")>=0){E=c.getOperator("EQ");}if(!E){throw new P("Cannot parse value "+A);}var G=E.getCondition(A,T,b.Value,true);if(G){G.validated=d.NotValidated;}return G;}
f.prototype.validateValue=function(A){var T=l.call(this);var O=n.call(this);var D=o.call(this);var I=this.oFormatOptions.isUnit;if(A===undefined||this._bDestroyed){return null;}else if(A===null){if(c.onlyEQ(D)){try{if(T.hasOwnProperty("_sParsedEmptyString")&&T._sParsedEmptyString!==null){T.validateValue(T._sParsedEmptyString);}else{T.validateValue(null);}}catch(E){if(E instanceof V){throw E;}else{return null;}}}return null;}if(typeof A!=="object"||!A.operator||!A.values||!Array.isArray(A.values)){throw new V(this._oResourceBundle.getText("field.VALUE_NOT_VALID"));}var G=c.getOperator(A.operator,D);if(I){A=m({},A);if(A.values[0]&&Array.isArray(A.values[0])){A.values[0]=A.values[0][1];}G=c.getEQOperator();}if(!G){throw new V("No valid condition provided, Operator wrong.");}try{G.validate(A.values,T);}catch(H){if(H instanceof V&&O){G.validate(A.values,O);}throw H;}};
function k(){var D=this.oFormatOptions.display;if(!D){D=b.Value;}return D;}
function l(){var T=this.oFormatOptions.valueType;if(!T){if(!this._oDefaultType){this._oDefaultType=new a();}T=this._oDefaultType;}return T;}
function n(){return this.oFormatOptions.originalDateType;}
function o(){var O=this.oFormatOptions.operators;if(!O||O.length===0){O=c.getOperatorsForType(B.String);}return O;}
function p(){var I=this.oFormatOptions.fieldHelpID;if(I){var A=sap.ui.getCore().byId(I);if(A&&A.isUsableForValidation()){return A;}}return null;}
function q(T){return T&&T.isA("sap.ui.model.CompositeType");}
function r(A,T){if(q.call(this,T)&&A&&A.values[0]){T._aCurrentValue=A.values[0];}}
function s(T){if(q.call(this,T)&&!T._aCurrentValue){T._aCurrentValue=[];}}
function t(A,R){A.values=[R.key,R.description];if(R.inParameters){A.inParameters=R.inParameters;}if(R.outParameters){A.outParameters=R.outParameters;}return A;}
function u(A){if(this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(A);}return A;}
function v(T){var A=T.getMetadata().getName();var D=T.oFormatOptions;var E=T.oConstraints;var G=this.oFormatOptions.delegate;var H=this.oFormatOptions.payload;var I=G?G.getTypeUtil(H).getBaseType(A,D,E):B.String;if(I===B.Unit){I=B.Numeric;}return I;}
function w(){var A=p.call(this);var D=this.oFormatOptions.delegate;var E=this.oFormatOptions.payload;if(D){return D.isInputValidationEnabled(E,A);}else{return!!A;}}
function x(){var A=p.call(this);var D=this.oFormatOptions.delegate;var E=this.oFormatOptions.payload;if(D){return D.isInvalidInputAllowed(E,A);}else if(A){return!A.getValidateInput();}else{return true;}}
function y(A,D,E,G,H,I){var J=p.call(this);var K=this.oFormatOptions.delegate;var L=this.oFormatOptions.payload;if(K){return K.getItemForValue(L,J,A,D,E,G,H,I);}else if(J){return J.getItemForValue(A,D,undefined,undefined,E,G,H,I);}}
function z(K,I,O,A){var D=p.call(this);var E=this.oFormatOptions.delegate;var G=this.oFormatOptions.payload;if(E){return E.getDescription(G,D,K,I,O,A);}else if(D){return D.getTextForKey(K,I,O,A);}}
return f;});
sap.ui.predefine('sap/ui/mdc/field/ConditionsType',['sap/ui/mdc/field/ConditionType','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/base/util/merge','sap/ui/base/SyncPromise'],function(C,S,F,P,V,m,a){"use strict";
var b=S.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(f,o){S.apply(this,arguments);this.sName="Conditions";f=_(f);this._oConditionType=new C(f,this.oConstraints);}});
b.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined;}this._bDestroyed=true;};
b.prototype.setFormatOptions=function(f){S.prototype.setFormatOptions.apply(this,arguments);f=_(f);if(this._oConditionType){this._oConditionType.setFormatOptions(f);}};
function _(f){f=m({},f);if(f.asyncParsing){delete f.asyncParsing;}return f;}
b.prototype.setConstraints=function(o){S.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints);}};
b.prototype.formatValue=function(f,I){if(f==undefined||f==null||this._bDestroyed){return null;}if(!Array.isArray(f)){throw new F("No valid conditions provided");}var v;if(!I||I==="string"||I==="any"){v="";}else if(I==="float"||I==="int"){v=0;}var M=e.call(this);var s=[];var g=function(o,I){return a.resolve().then(function(){return this._oConditionType.formatValue(o,I);}.bind(this));};for(var i=0;i<f.length;i++){s.push(g.call(this,f[i],I));if(M>0&&i>=M-1){break;}}return a.all(s).then(function(h){return c(h,v);}).unwrap();};
function c(f,v){for(var i=0;i<f.length;i++){if(v){v=v+"; "+f[i];}else{v=f[i];}}return v;}
b.prototype.parseValue=function(v,i){if(this._bDestroyed){return null;}if(e.call(this)!==1){throw new P("Only one condition supported for parsing");}var o=a.resolve().then(function(){return this._oConditionType.parseValue(v,i);}.bind(this)).then(function(o){return d.call(this,o);}.bind(this)).unwrap();if(o instanceof Promise&&this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(o);}return o;};
function d(o){var I=this.oFormatOptions.isUnit;if(I){var u=o&&o.values[0][1];var f=o&&o.inParameters;var O=o&&o.outParameters;var g=this.oFormatOptions.getConditions();for(var i=0;i<g.length;i++){g[i].values[0][1]=u;g[i].values[0].splice(2);if(g[i].operator==="BT"){g[i].values[1][1]=u;g[i].values[1].splice(2);}if(f||g[i].inParameters){g[i].inParameters=f;}if(O||g[i].outParameters){g[i].outParameters=O;}}if(g.length===0){g.push(o);}return g;}else if(o){return[o];}else{return[];}}
b.prototype.validateValue=function(f){if(f===undefined||f===null||this._bDestroyed){return;}if(!Array.isArray(f)){throw new V("No valid conditions provided");}for(var i=0;i<f.length;i++){var o=f[i];this._oConditionType.validateValue(o);}var M=e.call(this);if(f.length===0&&M===1){this._oConditionType.validateValue(null);}};
function e(){var M=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){M=this.oFormatOptions.maxConditions;}return M;}
return b;});
sap.ui.predefine('sap/ui/mdc/field/DefineConditionPanel',['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/Field','sap/ui/mdc/field/ListFieldHelp','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/model/resource/ResourceModel','sap/ui/model/type/String','sap/ui/core/InvisibleText','sap/ui/core/ListItem','sap/ui/layout/Grid','sap/ui/layout/GridData','sap/m/library','sap/m/ScrollContainer','sap/m/Button','sap/m/Panel'],function(C,M,m,d,a,F,O,E,b,B,c,e,L,f,J,R,S,I,g,G,h,l,j,k,P){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var n=l.ButtonType;
var D=C.extend("sap.ui.mdc.field.DefineConditionPanel",{
metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},formatOptions:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false}},events:{}},
_oManagedObjectModel:null,
renderer:{apiVersion:2,render:function(i,Z){i.openStart("section",Z);i.class("sapUiMdcDefineConditionPanel");i.openEnd();i.renderControl(Z.getAggregation("_content"));i.close("section");}},
init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);C.prototype.init.apply(this,arguments);this._oManagedObjectModel=new f(this);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["conditions","formatOptions"]});z.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition");},
exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;},
byId:function(i){return sap.ui.getCore().byId(this.getId()+"--"+i);},
onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}if(this.getConditions().length===0){this.updateDefineConditions();}},
removeCondition:function(i){var Z=i.oSource;var $=Z.getBindingContext("$this").getObject();var a1=this.getConditions();var b1=F.indexOfCondition($,a1);a1.splice(b1,1);this.setProperty("conditions",a1,true);},
addCondition:function(i){var Z=this.getConditions();var $=this.getFormatOptions();var a1=$.maxConditions;if(a1===-1||Z.length<a1){this.addDummyCondition(Z.length+1);if(this.getConditions().length===a1){this._bFocusLastCondition=true;}}},
addDummyCondition:function(i){var Z=s.call(this);var $=u.call(this);var a1=w.call(this,$);var b1=F.getDefaultOperator(a1);var c1=Z.indexOf(b1.name)>=0?b1.name:Z[0];var d1=a.createCondition(c1,[null],undefined,undefined,c.NotValidated);F.updateConditionValues(d1);F.checkConditionsEmpty(d1,Z);var e1=this.getConditions();if(i!==undefined){e1.splice(i,0,d1);}else{e1.push(d1);}this.setProperty("conditions",e1,true);},
updateDefineConditions:function(){var i=this.getConditions().filter(function(Z){return Z.validated!==c.Validated;});y.call(this,i,true,false);if(i.length===0){this.addDummyCondition();}},
onChange:function(i){var Z=s.call(this);var $=this.getConditions();F.checkConditionsEmpty($,Z);F.updateConditionsValues($,Z);this.setProperty("conditions",$,true);},
onSelectChange:function(i){var Z=i.getSource();var $=Z.getValue();var a1=Z._sOldKey;var b1=F.getOperator($);var c1=a1&&F.getOperator(a1);if(b1&&c1){var d1;var e1;var f1;var g1=false;if(!d(b1.valueTypes[0],c1.valueTypes[0])&&b1.valueTypes[0]!==O.ValueType.Static){d1=Z.getBindingContext("$this").getObject();e1=this.getConditions();f1=F.indexOfCondition(d1,e1);if(f1>=0){d1=e1[f1];if(d1.values.length>0&&d1.values[0]!==null){d1.values[0]=null;g1=true;}if(d1.values.length>1&&d1.values[1]!==null){d1.values[1]=null;g1=true;}}}if(!b1.valueTypes[1]&&c1.valueTypes[1]){if(!d1){d1=Z.getBindingContext("$this").getObject();e1=this.getConditions();f1=F.indexOfCondition(d1,e1);d1=e1[f1];}if(f1>=0){if(d1.values.length>1&&d1.values[1]){d1.values=d1.values.slice(0,1);g1=true;}}}if(g1){this.setProperty("conditions",e1,true);}}delete Z._sOldKey;},
onPaste:function(Z){var $,a1=Z.srcControl;if(window.clipboardData){$=window.clipboardData.getData("Text");}else{$=Z.originalEvent.clipboardData.getData('text/plain');}var b1=$.split(/\r\n|\r|\n/g);if(b1&&b1.length>1){setTimeout(function(){var c1=s.call(this);var d1=u.call(this);var e1=w.call(this,d1);var f1=b1.length;var g1=this.getConditions();for(var i=0;i<f1;i++){if(b1[i]){var h1=b1[i];var i1=h1.split(/\t/g);var j1;if(i1.length==2&&i1[0]&&i1[1]){j1=F.getOperator("BT");}else{i1=[h1.trim()];j1=F.getDefaultOperator(e1);}h1=j1?j1.format(a.createCondition(j1.name,i1)):i1[0];if(j1){var k1=j1.getCondition(h1,d1,b.Value,true);if(k1){k1.validated=c.NotValidated;F.checkConditionsEmpty(k1,c1);g1.push(k1);}}}}this.setProperty("conditions",g1,true);if(a1.setDOMValue){a1.setDOMValue("");}}.bind(this),0);}}
});
function _(i){if(i.name==="value"){p.call(this,i.object,i.current,i.old);}if(i.name==="formatOptions"){var Z=this.getConditions();var $=i.current&&i.current.operators;var a1=i.old&&i.old.operators;var b1=false;if(!d($,a1)){b1=true;t.call(this);}var c1=i.current&&i.current.valueType&&i.current.valueType.getMetadata().getName();var d1=i.old&&i.old.valueType&&i.old.valueType.getMetadata().getName();if(c1!==d1&&Z.length>0){if(!b1){t.call(this);}this._bUpdateType=true;K.call(this);this._bUpdateType=false;y.call(this,Z,true,true);}}if(i.name==="conditions"){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this.updateDefineConditions();K.call(this);}.bind(this),0);}}
function p(Z,$,a1){Z._sOldKey=a1;var b1=0;if($&&a1){var c1=F.getOperator($);var d1=F.getOperator(a1);var e1=Z.getParent();var f1;b1=e1.indexOfContent(Z);if(c1.createControl||d1.createControl){f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===0){f1.destroy();}f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===1){f1.destroy();}}else{if(c1.valueTypes[0]!==d1.valueTypes[0]){f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===0){f1.unbindProperty("value");}}if(c1.valueTypes[1]!==d1.valueTypes[1]&&d1.valueTypes[1]){f1=e1.getContent()[b1+3];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===1){f1.unbindProperty("value");}}}}if(!$){var g1=Z.getBindingContext("$this").getObject();if(g1){var h1=this.getConditions();b1=F.indexOfCondition(g1,h1);if(b1>=0){g1=h1[b1];g1.operator=a1;this.setProperty("conditions",h1,true);}}}var i1=this.oOperatorModel.getData();var j1;for(var i=0;i<i1.length;i++){var k1=i1[i];if(k1.key===$){j1=k1.additionalText;break;}}Z.setAdditionalValue(j1);this.onChange();}
function q(i,Z,$,a1){var b1=F.getOperator(i.operator);if(!b1){return null;}var c1=r.call(this,b1.name,Z);var d1=this._oManagedObjectModel.getContext(a1.getPath()+"values/"+Z+"/");var e1;if(b1.createControl){e1=b1.createControl(c1,b1,"$this>",Z);}else{e1=new e($,{delegate:x.call(this),value:{path:"$this>",type:c1,mode:'TwoWay',targetType:'raw'},editMode:{path:"$condition>operator",formatter:Q},width:"100%"});}if(e1.getMetadata().hasProperty("placeholder")){if(Z===0){e1.bindProperty("placeholder",{path:"$condition>operator",formatter:W});}else{e1.bindProperty("placeholder",{path:"$condition>operator",formatter:X});}}e1._iValueIndex=Z;if(e1.attachChange){e1.attachChange(this.onChange.bind(this));}e1.onpaste=this.onPaste.bind(this);e1.setLayoutData(new h({span:{path:"$condition>",formatter:V.bind(this)}}));e1.setBindingContext(d1,"$this");e1.setBindingContext(a1,"$condition");return e1;}
function r(i,Z){var $=u.call(this);var a1=F.getOperator(i);if(a1.valueTypes[Z]&&[O.ValueType.Self,O.ValueType.Static].indexOf(a1.valueTypes[Z])===-1){$=a1._createLocalType(a1.valueTypes[Z]);}var b1=false;if(a1.valueTypes[Z]===O.ValueType.Static){b1=true;$=v.call(this);}var c1=b1?B.String:w.call(this,$);var d1;var e1;var f1;var g1;switch(c1){case B.Boolean:if($.oConstraints&&$.oConstraints.hasOwnProperty("nullable")&&$.oConstraints.nullable===false){e1=sap.ui.require($.getMetadata().getName().replace(/\./g,"/"));f1=m({},$.oFormatOptions);g1=m($.oConstraints,{nullable:true});d1=new e1(f1,g1);}else{d1=$;}break;case B.Numeric:if($.oFormatOptions&&$.oFormatOptions.hasOwnProperty("emptyString")&&$.oFormatOptions.emptyString===null){d1=$;}else{e1=sap.ui.require($.getMetadata().getName().replace(/\./g,"/"));f1=m($.oFormatOptions,{emptyString:null});d1=new e1(f1,$.oConstraints);}break;case B.Date:case B.Time:case B.DateTime:d1=$;break;default:d1=$;break;}return d1;}
function s(){var i=this.getFormatOptions();var Z=i&&i.operators;if(!Z||Z.length===0){Z=F.getOperatorsForType(B.String);}return Z;}
function t(){if(!this.oOperatorModel){return;}var Z=u.call(this);var $=s.call(this);var a1=o.getText("valuehelp.INCLUDE");var b1=o.getText("valuehelp.EXCLUDE");var c1=[];for(var i=0;i<$.length;i++){var d1=$[i];var e1=F.getOperator(d1);if(!e1||(e1.showInSuggest!==undefined&&e1.showInSuggest==false)){continue;}var f1=e1.textKey||"operators."+e1.name+".longText";var g1=e1.getTypeText(f1,Z.getName().toLowerCase());if(g1===f1){g1=e1.longText;}var h1=e1.additionalInfo;if(h1===undefined){if(h1!==""&&e1.formatRange){h1=e1.formatRange(e1._getRange(undefined,Z),Z);}else{h1=e1.exclude?b1:a1;}}c1.push({key:e1.name,additionalText:g1,info:h1});}this.oOperatorModel.setData(c1);}
function u(){var i=this.getFormatOptions();var Z=i&&i.valueType;if(!Z){Z=v.call(this);}return Z;}
function v(){if(!this._oDefaultType){this._oDefaultType=new S();}return this._oDefaultType;}
function w(i){var Z=i.getMetadata().getName();var $=i.oFormatOptions;var a1=i.oConstraints;var b1=this.getFormatOptions().delegate;var c1=this.getFormatOptions().payload;var d1=b1?b1.getTypeUtil(c1).getBaseType(Z,$,a1):B.String;if(d1===B.Unit){d1=B.Numeric;}return d1;}
function x(){var i=this.getFormatOptions();var Z=i.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";var $=i.payload;return{name:Z,payload:$};}
function y(Z,$,a1){var b1=u.call(this);var c1=[];var i=0;for(i=0;i<Z.length;i++){var d1=Z[i];var e1=F.getOperator(d1.operator);if(e1&&e1.valueTypes[0]===O.ValueType.Static&&(d1.values.length===0||a1)){if(e1.getStaticText){var f1=e1.getStaticText(b1);if(d1.values.length>0){d1.values[0]=f1;}else{d1.values.push(f1);}c1.push(i);}}}if(c1.length>0){this.setProperty("conditions",Z,true);}}
function z(){var i=new I(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});var Z=new P({headerText:"{$this>/label}",expanded:true,height:"100%",backgroundDesign:"Transparent"}).addStyleClass("sapMdcDefineconditionPanel");Z.addDependent(new L(this.getId()+"--rowSelect-help",{items:{path:'om>/',templateShareable:false,template:new g({key:"{om>key}",text:"{om>additionalText}",additionalText:"{om>info}"})},filterList:false,useFirstMatch:true}));var $=new G(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");N.call(this,undefined,$,0,null,0);Z.addContent(i);Z.addContent($);var a1=new k(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:n.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new h({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{path:"$this>/conditions",formatter:A.bind(this)},visibleM:{path:"$this>/conditions",formatter:A.bind(this)},visibleL:{path:"$this>/conditions",formatter:A.bind(this)},visibleXL:{path:"$this>/conditions",formatter:A.bind(this)}})});$.addContent(a1);this.setAggregation("_content",Z);}
function A(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;return $===-1||i.length<$;}
function H(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;return $!==1;}
function K(){var Z=this.getConditions();var $=this.byId("conditions");var a1;var b1=-1;var c1=0;for(var i=0;i<Z.length;i++){var d1=Z[i];if(d1.validated!==c.Validated){var e1=this._oManagedObjectModel.getContext("/conditions/"+i+"/");b1++;if(!this.oOperatorModel){this.oOperatorModel=new J();this.setModel(this.oOperatorModel,"om");t.call(this);}a1=$.getContent();if(a1[c1]&&a1[c1].isA("sap.ui.mdc.Field")){c1=Y.call(this,d1,$,c1,e1,b1);}else{c1=N.call(this,d1,$,c1,e1,b1);}}}a1=$.getContent();while(a1[c1]&&a1[c1]!==this.byId("addBtn")){a1[c1].destroy();c1++;}if(this._bFocusLastCondition){a1[0].focus();this._bFocusLastCondition=false;}}
function N(Z,$,a1,b1,c1){var d1=this.getId()+"--"+c1;if(!this._oOperatorFieldType){this._oOperatorFieldType=new S({},{minLength:1});}var e1=new e(d1+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:"Description",fieldHelp:this.getId()+"--rowSelect-help",change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new h({span:{path:"$this>/conditions",formatter:U.bind(this)},linebreak:true})).setBindingContext(b1,"$this");this._oObserver.observe(e1,{properties:["value"]});$.insertContent(e1,a1);a1++;var f1=new k(d1+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:n.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new h({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:T},visibleS:{path:"$this>/conditions",formatter:H.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(b1,"$this");$.insertContent(f1,a1);a1++;if(Z){for(var i=0;i<Z.values.length;i++){var g1=q.call(this,Z,i,d1+"-values"+i,b1);if(g1){$.insertContent(g1,a1);a1++;}}}var h1=new k(d1+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:n.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new h({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:T},visibleS:false,visibleM:{path:"$this>/conditions",formatter:H.bind(this)},visibleL:{path:"$this>/conditions",formatter:H.bind(this)},visibleXL:{path:"$this>/conditions",formatter:H.bind(this)}})).setBindingContext(b1,"$this");$.insertContent(h1,a1);a1++;return a1;}
function Q(i){if(!i){return E.Display;}var Z=F.getOperator(i);var $=false;if(Z&&Z.valueTypes[0]===O.ValueType.Static){$=true;}return $?E.Display:E.Editable;}
function T(i){var Z=i&&F.getOperator(i);if(!Z||!Z.valueTypes[0]){return"XL8 L8 M8 S0";}else{return"";}}
function U(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;var a1="XL3 L3 M3 ";if($===1){a1+="S12";}else{a1+="S10";}return a1;}
function V(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;var a1=i&&F.getOperator(i.operator);var b1="";if(a1&&a1.valueTypes[1]){b1="XL4 L4 M4 ";}else{b1="XL8 L8 M8 ";}if($===1){b1+="S12";}else{b1+="S10";}return b1;}
function W(i){var Z=i&&F.getOperator(i);if(Z&&Z.aLabels){return Z.aLabels[0];}else if(Z&&Z.valueTypes[1]){return o.getText("valuehelp.DEFINECONDITIONS_FROM");}else{return o.getText("valuehelp.DEFINECONDITIONS_VALUE");}}
function X(i){var Z=i&&F.getOperator(i);if(Z&&Z.aLabels){return Z.aLabels[1];}else if(Z&&Z.valueTypes[1]){return o.getText("valuehelp.DEFINECONDITIONS_TO");}}
function Y(Z,$,a1,b1,c1){var d1=this.getId()+"--"+c1;var e1=$.getContent();var f1;var g1=e1[a1];g1.setBindingContext(b1,"$this");a1++;var h1=e1[a1];h1.setBindingContext(b1,"$this");a1++;var i1;var j1=e1[a1];var k1;if(j1.hasOwnProperty("_iValueIndex")&&j1._iValueIndex===0){var l1=Q(Z.operator);if(Z.values.length>0||l1===E.Display){i1=this._oManagedObjectModel.getContext(b1.getPath()+"values/0/");j1.setBindingContext(i1,"$this");j1.setBindingContext(b1,"$condition");if(j1.getMetadata().hasProperty("value")&&(this._bUpdateType||!j1.getBindingInfo("value"))){f1=r.call(this,Z.operator,0);j1.bindProperty("value",{path:"$this>",type:f1});}a1++;k1=e1[a1];if(k1.hasOwnProperty("_iValueIndex")&&k1._iValueIndex===1){if(Z.values.length>1){i1=this._oManagedObjectModel.getContext(b1.getPath()+"values/1/");k1.setBindingContext(i1,"$this");if(k1.getMetadata().hasProperty("value")&&(this._bUpdateType||!k1.getBindingInfo("value"))){f1=r.call(this,Z.operator,1);k1.bindProperty("value",{path:"$this>",type:f1});}a1++;}else{k1.destroy();}}else if(Z.values.length>1){k1=q.call(this,Z,1,d1+"-values1",b1);if(k1){$.insertContent(k1,a1);a1++;}}}else{j1.destroy();k1=e1[a1+1];if(k1&&k1.hasOwnProperty("_iValueIndex")&&k1._iValueIndex===1){k1.destroy();}}}else if(Z.values.length>0){for(var i=0;i<Z.values.length;i++){var m1=q.call(this,Z,i,d1+"-values"+i,b1);if(m1){$.insertContent(m1,a1);a1++;}}}e1=$.getContent();var n1=e1[a1];n1.setBindingContext(b1,"$this");a1++;return a1;}
return D;});
sap.ui.predefine('sap/ui/mdc/field/FieldBase',['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/mdc/enum/BaseType','sap/ui/mdc/util/DateUtil','sap/ui/core/library','sap/ui/mdc/Control','sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/base/util/isEmptyObject','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/BindingMode','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/restricted/_debounce','sap/ui/events/KeyCodes'],function(q,D,E,F,a,b,C,c,d,B,e,f,g,L,M,O,h,m,k,l,n,o,p,r,P,V,s,t,S,u,K){"use strict";var v=f.ValueState;var w=f.CalendarType;var T=f.TextAlign;var x=f.TextDirection;
var y=g.extend("sap.ui.mdc.field.FieldBase",{
metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enum.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enum.FieldDisplay",defaultValue:F.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:x.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:v.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.field.FieldHelpBase",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},
_oManagedObjectModel:null
});
M.call(y.prototype);var z={Default:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Text",createEdit:u1,createEditMulti:w1,createEditMultiLine:x1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false},defaultEnterHandler:true},Search:{edit:"sap/m/SearchField",display:"sap/m/Text",createEdit:v1,createDisplay:y1,useDefaultFieldHelp:false,defaultEnterHandler:false},Date:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DatePicker",create:z1},"BT":{name:"sap/m/DateRangeSelection",create:A1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Time:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/TimePicker",create:z1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},DateTime:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DateTimePicker",create:z1}},createEdit:u1,createEditMulti:w1,createDisplay:y1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Link:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Link",createEdit:u1,createEditMulti:w1,createEditMultiLine:x1,createDisplay:B1,useDefaultFieldHelp:false,defaultEnterHandler:true},Boolean:{edit:"sap/ui/mdc/field/FieldInput",display:"sap/m/Text",createEdit:C1,createDisplay:y1,useDefaultFieldHelp:{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true},defaultEnterHandler:true},Unit:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token"],display:"sap/m/Text",createEdit:D1,createEditMulti:E1,createDisplay:y1,useDefaultFieldHelp:false,defaultEnterHandler:true}};var A={onsapprevious:G1,onsapnext:G1,onsapup:G1,onsapdown:G1,onsapbackspace:G1};var G={onsapenter:Q};var H;var I;
y._init=function(){H={};if(I&&I.bool&&I.bool.control){I.bool.control.destroy();}if(I&&I.defineConditions&&I.defineConditions.control){I.defineConditions.control.destroy();}I={bool:{name:"sap/ui/mdc/field/BoolFieldHelp",id:"BoolDefaultHelp",getDelegate:"getDefaultFieldHelpBaseDelegate",properties:{},control:undefined},defineConditions:{name:"sap/ui/mdc/field/FieldValueHelp",id:"Field-DefineConditions-Help",getDelegate:"getDefaultFieldValueHelpDelegate",properties:{showConditionPanel:true},control:undefined}};};
y._init();
y.prototype.init=function(){g.prototype.init.apply(this,arguments);this._oManagedObjectModel=new s(this);this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","ariaLabelledBy"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;};
y.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",i2,this);}var j=this.getContent();if(j){n1.call(this,j);}var u2=this.getContentEdit();if(u2){n1.call(this,u2);}var v2=this.getContentDisplay();if(v2){n1.call(this,v2);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined;}var w2=Y1.call(this);if(w2){w2.detachEvent("dataUpdate",c2,this);if(this._bConnected){d2.call(this);w2.connect();}}T1.call(this);delete this._fnLiveChangeTimer;};
y.prototype.applySettings=function(){g.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate();}return this;};
y.prototype.setProperty=function(i,j,u2){if(i!=="width"&&i!=="editMode"&&i!=="multipleLines"){u2=true;}return g.prototype.setProperty.apply(this,[i,j,u2]);};
y.prototype.onBeforeRendering=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){p1.call(this);}.bind(this));return;}p1.call(this);};
y.prototype.onAfterRendering=function(){};
y.prototype.onfocusin=function(i){e2.call(this);};
y.prototype.onsapfocusleave=function(i){T1.call(this);};
function _(i){var j=i.getParameters().fieldGroupIds;if(j.indexOf(this.getId())>-1){i.bCancelBubble=true;if(this._bPendingChange){var u2=document.activeElement;var v2=Y1.call(this);if(!(u2&&v2&&n(v2.getDomRef(),u2))){var w2=q2.call(this);if(w2){N.call(this,undefined,undefined,undefined,w2);}else{N.call(this,this.getConditions(),!this._bParseError);}}}}}
y.prototype.onsapup=function(i){var j=Y1.call(this);var u2=i.srcControl;if(j&&(!this._bIsMeasure||u2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(-1);}};
y.prototype.onsapdown=function(i){var j=Y1.call(this);var u2=i.srcControl;if(j&&(!this._bIsMeasure||u2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(1);}};
y.prototype.onsapenter=function(i){var j=Y1.call(this);if(j&&j.isOpen(true)){j.close();}};
y.prototype.onsapescape=function(i){this.onsapenter(i);};
y.prototype.ontap=function(i){var j=Y1.call(this);if(j&&j.openByClick()&&!j.isOpen(true)){j.open(true);}};
y.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var u2=this.getContent();if(u2){n1.call(this,u2);}var v2=this.getContentEdit();if(v2){n1.call(this,v2);}var w2=this.getContentDisplay();if(w2){n1.call(this,w2);}var x2=this.getFieldInfo();if(x2){x2.detachEvent("dataUpdate",i2,this);}var y2=g.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(u2){m1.call(this,u2);}if(v2){m1.call(this,v2);}if(w2){m1.call(this,w2);}if(x2){x2.attachEvent("dataUpdate",i2,this);}return y2;};
y.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};
function J(i,j,u2,v2){if(this._getContent().length>1){this._bPendingChange=true;}else{N.call(this,i,j,u2,v2);}}
function N(i,j,u2,v2){if(!v2){if(j){v2=Promise.resolve(this._getResultForPromise(i));}else{v2=Promise.reject(u2);}}this._fireChange(i,j,u2,v2);this._bPendingChange=false;}
y.prototype._fireChange=function(i,j,u2,v2){};
function Q(i){var j=this.getEditMode();if(b1(j)&&(this.hasListeners("submit")||this._bPendingChange)){var u2=q2.call(this);var v2=false;if(u2){v2=true;}else if(this._bParseError){u2=Promise.reject();}else{u2=Promise.resolve(this._getResultForPromise(this.getConditions()));}if(this._bPendingChange){if(v2){N.call(this,undefined,undefined,undefined,u2);}else{N.call(this,this.getConditions(),!this._bParseError,undefined,u2);}}this.fireSubmit({promise:u2});}}
function R(){if(!this._oDataType){var i=this.getDataType();if(typeof i==="string"){this._oDataType=this.getTypeUtil().getDataTypeInstance(i,this.getDataTypeFormatOptions(),this.getDataTypeConstraints());this._oDataType._bCreatedByField=true;}}return this._oDataType;}
y.prototype._initDataType=function(){if(this._oDataType){this._oDataType.destroy();this._oDataType=undefined;}if(this._oDateOriginalType){if(this._oDateOriginalType._bCreatedByField){this._oDateOriginalType.destroy();}this._oDateOriginalType=undefined;}if(this._oUnitOriginalType){if(this._oUnitOriginalType._bCreatedByField){this._oUnitOriginalType.destroy();}this._oUnitOriginalType=undefined;}delete this._sDisplayFormat;delete this._sValueFormat;delete this._sCalendarType;};
function U(){if(this._oDataType&&typeof this._oDataType==="object"){return this._oDataType.getMetadata().getName();}else if(this.bDelegateInitialized){return this.getControlDelegate().getDataTypeClass(this.getPayload(),this.getDataType());}else{return this.getDataType();}}
function W(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oConstraints){return this._oDataType.oConstraints;}else{return this.getDataTypeConstraints();}}
function X(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oFormatOptions){return this._oDataType.oFormatOptions;}else{return this.getDataTypeFormatOptions();}}
function Y(i,j,u2){var v2=this.getTypeUtil().getBaseType(i,j,u2);switch(v2){case B.Date:this._sValueFormat="yyyy-MM-dd";break;case B.DateTime:this._sValueFormat="yyyy-MM-dd'T'HH:mm:ss";break;case B.Time:this._sValueFormat="HH:mm:ss";break;default:return;}this._sDisplayFormat="medium";if(j){if(j.style){this._sDisplayFormat=j.style;}else if(j.pattern){this._sDisplayFormat=j.pattern;}if(j.calendarType){this._sCalendarType=j.calendarType;}}}
function Z(){var i=R.call(this);var j=i.getMetadata().getName();var u2=i.oFormatOptions;var v2=i.oConstraints;Y.call(this,j,u2,v2);if(!u2||u2.style||!u2.pattern||u2.pattern!==this._sValueFormat||!u2.calendarType||u2.calendarType!==w.Gregorian){this._oDateOriginalType=this._oDataType;this._oDataType=e.createInternalType(i,this._sValueFormat);k2.call(this);}}
function $(){var i=R.call(this);var j=i.getMetadata().getName();var u2=i.oFormatOptions;var v2=l(i.oConstraints)?undefined:i.oConstraints;if(!u2||!u2.hasOwnProperty("showMeasure")||u2.showMeasure){u2=m({},u2);u2.showMeasure=false;u2.strictParsing=true;if(i.hasOwnProperty("bParseAsString")){u2.parseAsString=i.bParseAsString;}if(u2.customCurrencies){delete u2.customCurrencies;}if(u2.customUnits){delete u2.customUnits;}var w2=O.get(j);this._oUnitOriginalType=this._oDataType;this._oDataType=new w2(u2,v2);this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oDataType,this._oTypeInitialization);k2.call(this);}}
function a1(i,j){var u2=Y1.call(this);if(u2&&this._bConnected){Z1.call(this,i,u2);}}
y.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};
function b1(i){if(i===E.Editable||i===E.EditableReadOnly||i===E.EditableDisplay){return true;}else{return false;}}
function c1(i){if(i===E.Editable){return true;}else{return false;}}
function d1(i){if(i&&i!==E.Disabled){return true;}else{return false;}}
function e1(i){if(i&&i!==E.Editable){return true;}else{return false;}}
y.prototype._handleModelContextChange=function(i){};
function f1(i){this.setValueState(v.Error);this.setValueStateText(i);}
function g1(){this.setValueState(v.None);this.setValueStateText();}
y.prototype._observeChanges=function(j){var u2=function(){if(this.getAggregation("_content",[]).length>0){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){p1.call(this);}.bind(this));}else{p1.call(this);}}};if(j.name==="dataType"){if(this._oDataType){var v2=function(y2){var z2=this.getTypeUtil().getDataTypeClass(j.current);if(!(this._oDataType instanceof z2)){this._initDataType();this.destroyAggregation("_content");k2.call(this);}}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){v2.call(this,j.current);}.bind(this));return;}v2.call(this,j.current);}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oDataType){this._initDataType();this.destroyAggregation("_content");k2.call(this);}}if(j.name==="maxConditions"){u2.call(this);k2.call(this);}if(j.name==="conditions"){this._bParseError=false;a1.call(this,j.current,j.old);var w2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var x2=this._aAsyncChanges[i];if(x2.waitForUpdate&&h(x2.result,j.current)){Q1.call(this,x2);w2=true;break;}}if(w2){this._aAsyncChanges.splice(i,1);}}if(j.name==="display"){r1.call(this);k2.call(this);}if(j.name==="fieldHelp"&&j.ids){W1.call(this,j.ids,j.mutation);k2.call(this);}if(j.name==="fieldInfo"&&j.child){h2.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentEdit"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentDisplay"&&j.child){l1.call(this,j.child,j.mutation,j.name);}if(j.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate.call(this);}if(j.name==="ariaLabelledBy"&&j.ids){h1.call(this,j.ids,j.mutation);}};
y.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};
y.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=q1.call(this);}return i;};
y.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._bIsMeasure){return i[1];}else{return i[0];}}else{return this;}};
y.prototype.getMaxConditionsForHelp=function(){if(this._bIsMeasure){return 1;}else{return this.getMaxConditions();}};
y.prototype.enhanceAccessibilityState=function(i,j){var u2=this.getParent();if(u2&&u2.enhanceAccessibilityState){u2.enhanceAccessibilityState(this,j);}return j;};
y.prototype.getAccessibilityInfo=function(){var i=this._getContent();if(i.length>0&&i[0].getAccessibilityInfo){return i[0].getAccessibilityInfo();}else{return{};}};
function h1(j,u2){var v2=this.getAggregation("_content",[]);var w2=this.getContent();if(w2){v2.push(w2);}w2=this.getContentDisplay();if(w2){v2.push(w2);}w2=this.getContentEdit();if(w2){v2.push(w2);}for(var i=0;i<v2.length;i++){w2=v2[i];if(w2.getMetadata().getAllAssociations().ariaLabelledBy){if(u2==="remove"){w2.removeAriaLabelledBy(j);}else if(u2==="insert"){w2.addAriaLabelledBy(j);}}}}
function i1(j){var u2=this.getAriaLabelledBy();for(var i=0;i<u2.length;i++){var v2=u2[i];j.addAriaLabelledBy(v2);}}
function j1(i,j){var u2={aria:{}};var v2=Y1.call(this);if(v2){var w2=v2.getRoleDescription(this.getMaxConditionsForHelp());u2["role"]="combobox";if(w2){u2.aria["roledescription"]=w2;}u2.aria["haspopup"]="listbox";u2["autocomplete"]="off";if(i){u2.aria["expanded"]="true";u2.aria["controls"]=v2.getContentId();if(j){u2.aria["activedescendant"]=j;}}else{u2.aria["expanded"]="false";}}this.setProperty("_ariaAttributes",u2,true);}
y.prototype.connectLabel=function(i){t1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};
function k1(){var j=L.getReferencingLabels(this);for(var i=0;i<j.length;i++){var u2=sap.ui.getCore().byId(j[i]);u2.invalidate();}}
function l1(i,j,u2){if(j==="remove"){n1.call(this,i);I1.call(this,i);if(this._oContentConditionTypes){delete this._oContentConditionTypes[u2];}i.setModel(null,"$field");}else if(j==="insert"){H1.call(this,i,true);m1.call(this,i);if(this.getAggregation("_content",[]).length>0){r1.call(this);}if(!this._oContentConditionTypes){this._oContentConditionTypes={};}if(!this._oContentConditionTypes[u2]){this._oContentConditionTypes[u2]={};}var v2;var w2;for(w2 in i.getMetadata().getAllProperties()){if(i.getBindingPath(w2)==="/conditions"){v2=i.getBindingInfo(w2);if(v2&&v2.type&&v2.type instanceof d){this._oContentConditionTypes[u2].oConditionsType=v2.type;}this._sBoundProperty=w2;}if(w2==="editable"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:b1});}if(w2==="enabled"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:d1});}if(w2==="displayOnly"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/editMode",formatter:e1});}if(w2==="required"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/required"});}if(w2==="textAlign"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/textAlign"});}if(w2==="textDirection"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/textDirection"});}if(w2==="valueState"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/valueState"});}if(w2==="valueStateText"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/valueStateText"});}if(w2==="placeholder"&&!i.getBindingPath(w2)&&i.isPropertyInitial(w2)){i.bindProperty(w2,{path:"$field>/placeholder"});}}for(var x2 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(x2)==="/conditions"){v2=i.getBindingInfo(x2);if(v2&&v2.template){for(w2 in v2.template.getMetadata().getAllProperties()){var y2=v2.template.getBindingInfo(w2);if(y2&&y2.type&&y2.type instanceof c){this._oContentConditionTypes[u2].oConditionType=y2.type;break;}}}}if(x2==="tooltip"&&!i.getBindingPath(x2)&&!i.getAggregation(x2)){i.bindProperty(x2,{path:"$field>/tooltip"});}}if(i.getMetadata().getAllAssociations().ariaLabelledBy){i1.call(this,i);}}}
function m1(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",P1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",S1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",U1,this);}}
function n1(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",P1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",S1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",U1,this);}}
function o1(){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined;}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined;}var i=this.getEditMode();var j;var u2;if(this.getContent()){if(this._oContentConditionTypes.content){j=this._oContentConditionTypes.content.oConditionType;u2=this._oContentConditionTypes.content.oConditionsType;}}else if(i===E.Display&&this.getContentDisplay()){if(this._oContentConditionTypes.contentDisplay){j=this._oContentConditionTypes.contentDisplay.oConditionType;u2=this._oContentConditionTypes.contentDisplay.oConditionsType;}}else if(i!==E.Display&&this.getContentEdit()){if(this._oContentConditionTypes.contentEdit){j=this._oContentConditionTypes.contentEdit.oConditionType;u2=this._oContentConditionTypes.contentEdit.oConditionsType;}}if(j){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();}this._oConditionType=j;}if(u2){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();}this._oConditionsType=u2;}k2.call(this);}
function p1(){o1.call(this);X1.call(this,this.getFieldHelp());j1.call(this,false);var j=this.getEditMode();if(this.getContent()||this._bIsBeingDestroyed||(j===E.Display&&this.getContentDisplay())||(j!==E.Display&&this.getContentEdit())){r1.call(this);var u2=this._getContent();if(u2.length===1){t1.call(this,u2[0]);}return;}var v2=U.call(this);var w2=W.call(this);var x2=X.call(this);var y2=this.getTypeUtil().getBaseType(v2,x2,w2);var z2=this.getMaxConditions();var A2=this._getOperators();var B2;var C2;var D2;var E2=this.getAggregation("_content",[]);var F2;var G2;if(E2.length>0){F2=E2[0];G2=F2.getMetadata().getName().replace(/\./g,"/");}B2=z[y2];if(!B2){if(this.getFieldInfo()&&this._bTriggerable){B2=z.Link;}else{var H2=new RegExp("^\\*(.*)\\*|\\$search$");if(H2.test(this.getFieldPath())&&this.getMaxConditions()===1){B2=z.Search;}else{B2=z.Default;}}}if(j===E.Display){C2=B2.display;D2=B2.createDisplay;}else if(z2!==1){C2=B2.editMulti;D2=B2.createEditMulti;}else if(this.getMultipleLines()){C2=B2.editMultiLine;D2=B2.createEditMultiLine;}else if(A2.length===1&&B2.editOperator&&B2.editOperator[A2[0]]){C2=B2.editOperator[A2[0]].name;D2=B2.editOperator[A2[0]].create;}else{C2=B2.edit;D2=B2.createEdit;}if(!C2){throw new Error("No control defined for type "+v2+" in "+this);}var I2;if(Array.isArray(C2)){I2=C2;C2=I2[0];}else{I2=[C2];}if(C2!==G2){this._bHideOperator=M1.call(this,A2);if(F2){r1.call(this);if(F2.isA("sap.m.DateTimeField")){this._initDataType();}k2.call(this);}var J2;var i=0;for(i=0;i<I2.length;i++){var K2=I2[i];if(!H[K2]){H[K2]={};}if(!H[K2].control){H[K2].control=sap.ui.require(K2);if(!H[K2].control){J2=undefined;}}if(i===0){J2=H[K2].control;}}if(!J2){if(H[C2].promise){H[C2].promise.then(p1.bind(this));return;}else{H[C2].promise=new Promise(function(O2){H[C2].resolve=O2;sap.ui.require(I2,s1.bind(this));}.bind(this)).then(p1.bind(this));return;}}if(L1.call(this,B2,A2,j,z2)){J1.call(this,B2.useDefaultFieldHelp.name);}else if(this._sDefaultFieldHelp){delete this._sDefaultFieldHelp;}var L2=q1.call(this);var M2=D2.call(this,J2,L2);for(i=0;i<M2.length;i++){var N2=M2[i];N2.attachEvent("parseError",N1,this);N2.attachEvent("validationError",O1,this);H1.call(this,N2,B2.defaultEnterHandler);t1.call(this,N2);if(this._bConnected&&((i===0&&!this._bIsMeasure)||(i===1&&this._bIsMeasure))){f2.call(this,N2);}this.addAggregation("_content",N2);}k1.call(this);if(M2.length>1){this.attachValidateFieldGroup(_,this);}}}
function q1(){return this.getId()+"-inner";}
function r1(){if(this._getContent().length>1){this.detachValidateFieldGroup(_,this);}this.destroyAggregation("_content");if(this._oDateOriginalType){this._oDataType=this._oDateOriginalType;this._oDateOriginalType=undefined;}else if(this._oUnitOriginalType){this._oDataType=this._oUnitOriginalType;this._oUnitOriginalType=undefined;}if(this._bParseError){this._bParseError=false;g1.call(this);}if(this._bIsMeasure){this._bIsMeasure=false;}}
function s1(){for(var i=0;i<arguments.length;i++){var j=arguments[i];var u2=j.getMetadata().getName();u2=u2.replace(/\./g,"/");H[u2].control=j;if(H[u2].resolve){H[u2].resolve();delete H[u2].resolve;}}}
function t1(i){i.setModel(this._oManagedObjectModel,"$field");}
function u1(i,j){var u2=m2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:g2.call(this),showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this),liveChange:S1.bind(this),valueHelpRequest:$1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}
function v1(i,j){this._bHideOperator=true;var u2=m2.call(this);k2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2,mode:p.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:Q.bind(this),change:P1.bind(this),liveChange:S1.bind(this)});i1.call(this,v2);this._sBoundProperty="value";return[v2];}
function w1(i,j){var u2=sap.ui.require("sap/m/Token");var v2=l2.call(this);var w2=new u2(j+"-token",{text:{path:'$field>',type:v2}});var x2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",valueHelpIconSrc:g2.call(this),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:w2},dependents:[w2],change:P1.bind(this),liveChange:S1.bind(this),tokenUpdate:V1.bind(this),valueHelpRequest:$1.bind(this)});x2._setPreferUserInteraction(true);i1.call(this,x2);return[x2];}
function x1(i,j){var u2=m2.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:P1.bind(this),liveChange:S1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}
function y1(i,j){var u2=m2.call(this);var v2=new i(j,{text:{path:"$field>/conditions",type:u2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}"});this._sBoundProperty="text";return[v2];}
function z1(i,j){this._bHideOperator=true;var u2=m2.call(this);Z.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this)});if(v2.setDisplayFormatType){v2.setDisplayFormatType(this._sCalendarType);}v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}
function A1(i,j){var u2=m2.call(this);Z.call(this);var v2=new i(j,{value:{path:"$field>/conditions",type:u2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,delimiter:"...",displayFormatType:this._sCalendarType,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:P1.bind(this)});v2._setPreferUserInteraction(true);i1.call(this,v2);this._sBoundProperty="value";return[v2];}
function B1(i,j){var u2=this.getFieldInfo();var v2=m2.call(this);var w2=new i(j,{text:{path:"$field>/conditions",type:v2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:U1.bind(this),wrapping:true});if(u2){u2.getDirectLinkHrefAndTarget().then(j2.bind(this));}i1.call(this,w2);this._sBoundProperty="text";return[w2];}
function C1(i,j){return u1.call(this,i,j);}
function D1(i,j){$.call(this);this._bIsMeasure=true;var u2=m2.call(this);var v2=[];var w2=new i(j,{value:{path:"$field>/conditions",type:u2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",valueHelpIconSrc:"sap-icon://slim-arrow-down",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],change:P1.bind(this),liveChange:S1.bind(this)});w2._setPreferUserInteraction(true);i1.call(this,w2);v2.push(w2);v2=F1.call(this,v2,j,i);this._sBoundProperty="value";return v2;}
function E1(i,j){$.call(this);this._bIsMeasure=true;var u2=sap.ui.require("sap/m/Token");var v2=sap.ui.require("sap/m/Input");var w2=l2.call(this);var x2=[];var y2=new u2(j+"-token",{text:{path:'$field>',type:w2}});var z2=new o({path:"values",test:function(B2){if(!Array.isArray(B2[0])||B2[0][0]){return true;}else{return false;}}});var A2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:b1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],tokens:{path:"$field>/conditions",template:y2,filters:[z2]},dependents:[y2],change:P1.bind(this),liveChange:S1.bind(this),tokenUpdate:V1.bind(this)});A2._setPreferUserInteraction(true);i1.call(this,A2);x2.push(A2);x2=F1.call(this,x2,j,v2);this._sBoundProperty="value";return x2;}
function F1(i,j,u2){var v2=n2.call(this);if(this.getEditMode()===E.EditableDisplay){i[0].bindProperty("description",{path:"$field>/conditions",type:v2});i[0].setWidth("100%");i[0].setFieldWidth("70%");}else{var w2=new u2(j+"-unit",{value:{path:"$field>/conditions",type:v2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c1},enabled:{path:"$field>/editMode",formatter:d1},valueState:"{$field>/valueState}",valueHelpIconSrc:g2.call(this),valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",fieldGroupIds:[this.getId()],change:P1.bind(this),liveChange:S1.bind(this),valueHelpRequest:$1.bind(this)});w2._setPreferUserInteraction(true);i1.call(this,w2);i.push(w2);}return i;}
function G1(i){var j=false;var u2=Y1.call(this);if(!u2){return;}else if(u2.isOpen()){j=true;}else{switch(i.type){case"sapprevious":case"sapup":if(i.keyCode===K.ARROW_UP){j=true;}break;case"sapnext":case"sapdown":if(i.keyCode===K.ARROW_DOWN){j=true;}break;default:break;}}if(j){i.stopPropagation();i.stopImmediatePropagation(true);switch(i.type){case"sapup":this.onsapup(i);break;case"sapdown":this.onsapdown(i);break;default:break;}}}
function H1(i,j){i.addDelegate(A,true,this);if(j){i.addDelegate(G,false,this);}}
function I1(i){i.removeDelegate(A);i.removeDelegate(G);}
function J1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=I[i].id;var j=I[i].control;if(j&&j.bIsDestroyed){I[i].control=undefined;j=undefined;}if(!j){if(I[i].promise){I[i].promise.then(K1.bind(this));}var u2=sap.ui.require(I[i].name);if(!u2&&!I[i].promise){I[i].promise=new Promise(function(x2){I[i].resolve=x2;sap.ui.require([I[i].name],function(y2){J1.call(this,i);}.bind(this));}.bind(this)).then(K1.bind(this));}if(u2){var v2=this.bDelegateInitialized&&this.getControlDelegate()[I[i].getDelegate]();var w2=m({delegate:v2},I[i].properties);j=new u2(I[i].id,w2);I[i].control=j;j.connect(this);if(I[i].resolve){I[i].resolve();delete I[i].resolve;}if(!I[i].promise){K1.call(this);}}}else{K1.call(this);}}
function K1(){W1.call(this,"BoolDefaultHelp","insert");var i=this.getAggregation("_content",[])[0];if(i){i.setValueHelpIconSrc(g2.call(this));}}
function L1(i,j,u2,v2){if(i.useDefaultFieldHelp&&!this.getFieldHelp()&&u2!==E.Display){if(j.length===1){var w2=M1.call(this,j);if(v2===1){if(!(i.editOperator&&i.editOperator[j[0]])&&(i.useDefaultFieldHelp.oneOperatorSingle||!w2)){return true;}}else if(i.useDefaultFieldHelp.oneOperatorMulti||!w2){return true;}}else{return true;}}return false;}
function M1(i){if(i.length===1){var j=b.getOperator(i[0]);return!j||j.isSingleValue();}else{return false;}}
function N1(i){this._bParseError=true;}
function O1(u2){this._bParseError=true;var v2=u2.getParameter("newValue");var w2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var x2=this._aAsyncChanges[i];if(x2.waitForUpdate&&Array.isArray(x2.result)){if(x2.result.length===0&&v2===""){x2.reject(u2.getParameter("exception"));w2=true;}else{for(var j=0;j<x2.result.length;j++){var y2=x2.result[j];if(h(y2.values[0],v2)||(y2.operator==="BT"&&h(y2.values[1],v2))){x2.reject(u2.getParameter("exception"));w2=true;break;}}}if(w2){break;}}}if(w2){this._aAsyncChanges.splice(i,1);}}
function P1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var u2=this._aAsyncChanges.length;if(u2>0&&!this._aAsyncChanges[u2-1].changeFired){this._aAsyncChanges[u2-1].changeFired=true;this._aAsyncChanges[u2-1].changeEvent=j;J.call(this,undefined,undefined,undefined,this._aAsyncChanges[u2-1].promise);return;}var v2={changeEvent:j};Q1.call(this,v2);}
function Q1(i){var j=this.getConditions();var u2;var v2=true;var w2;var x2;var y2=i.changeEvent.source;var z2=false;var A2=true;var B2=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){v2=i.changeEvent.parameters["valid"];if(!v2&&i.changeEvent.parameters.hasOwnProperty("value")){w2=i.changeEvent.parameters["value"];}}var C2=false;var D2=this._sBoundProperty&&y2.getBinding(this._sBoundProperty);if(D2&&D2.getBindingMode()!==p.OneWay&&D2.getPath()==="/conditions"&&v2){x2=j[0];u2=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){u2=i.changeEvent.parameters["value"];if(v2){C2=true;}}else{x2=j[0];u2=j[0]&&j[0].values[0];}if(C2){g1.call(this);var E2;var F2;if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;y2.setDOMValue("");return;}x2=S.resolve().then(function(){var H2=this.getMaxConditions();if(this._oNavigateCondition){v2=true;return this._oNavigateCondition;}else if(u2===""&&H2!==1){return null;}else{E2=l2.call(this);var I2=E2.parseValue(u2);var J2=this._aAsyncChanges.length;if(J2>0&&!this._aAsyncChanges[J2-1].changeFired){F2=this._aAsyncChanges[J2-1];F2.changeFired=true;F2.changeEvent=i.changeEvent;J.call(this,undefined,undefined,undefined,F2.promise);}return I2;}}.bind(this)).then(function(x2){A2=R1.call(this,x2,j,E2,v2,u2,y2,F2||i);A2=A2||B2;return x2;}.bind(this)).catch(function(H2){if(H2&&!(H2 instanceof P)&&!(H2 instanceof r)&&!(H2 instanceof V)){throw H2;}v2=false;w2=u2;this._bParseError=true;f1.call(this,H2.message);if(F2&&F2.reject){if(s2.call(this,F2)){F2.reject(H2);}}else if(z2){J.call(this,j,v2,w2);}}.bind(this)).unwrap();if(x2 instanceof Promise){z2=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){w2=i.changeEvent.parameters["value"];v2=false;}var G2=Y1.call(this);if(G2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===y2.getId()){G2.close();}G2.setFilterValue("");if(!z2&&v2){Z1.call(this,j,G2);G2.onFieldChange();}T1.call(this);}if(this._oNavigateCondition){this._oNavigateCondition=undefined;k2.call(this);}if(i.resolve){r2.call(this,i);}else if(!z2&&A2){J.call(this,j,v2,w2);}}
function R1(i,j,u2,v2,w2,x2,y2){var z2=this.getMaxConditions();var A2=false;if(i===null&&z2!==1){return true;}if(u2){u2.validateValue(i);}if(v2){if(i){if(this._bIsMeasure&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(z2!==1&&b.indexOfCondition(i,j)>=0){throw new P(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[w2]));}else{if(z2>0&&z2<=j.length){j.splice(0,j.length-z2+1);}j.push(i);}}else if(z2===1){j=[];}if(!h(j,this.getConditions())){this.setProperty("conditions",j,true);A2=true;}if(z2!==1){x2.setValue("");}}if(y2.resolve){var B2=Y1.call(this);if(B2&&this._bConnected){Z1.call(this,j,B2);B2.onFieldChange();}y2.result=j;r2.call(this,y2);s2.call(this,y2);}return A2;}
function S1(j){var u2;var v2;var w2=false;var x2=j.getSource();this._oNavigateCondition=undefined;k2.call(this);if("value"in j.getParameters()){u2=j.getParameter("value");}else if("newValue"in j.getParameters()){u2=j.getParameter("newValue");}if("escPressed"in j.getParameters()){w2=j.getParameter("escPressed");}if("previousValue"in j.getParameters()){v2=j.getParameter("previousValue");}else{var y2=this.getConditions();v2=y2[0]&&y2[0].values[0];}this._bParseError=false;var z2=Y1.call(this);if(z2&&(!this._bIsMeasure||x2.getShowValueHelp())){if(w2){if(z2.isOpen(true)){z2.close();T1.call(this);}}else{var A2=this._getOperators();var B2=false;for(var i=0;i<A2.length;i++){var C2=b.getOperator(A2[i]);if(C2.validateInput){B2=true;break;}}if(B2){this._bIgnoreInputValue=false;this._vLiveChangeValue=u2;if(!this._fnLiveChangeTimer){this._fnLiveChangeTimer=u(function(){var E2=this.getDisplay();var F2="";if(this._vLiveChangeValue){var C2=b.getEQOperator();var G2=C2.getValues(this._vLiveChangeValue,E2,true);if(G2[0]){F2=G2[0];if(G2[1]){F2=F2+" ";}}if(G2[1]){F2=F2+G2[1];}}var D2=z2.openByTyping();if(this._bConnected&&this._getContent()[0]&&D2&&!(D2 instanceof Promise)&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){z2.setFilterValue(F2);if(this.getMaxConditionsForHelp()===1&&z2.getConditions().length>0){z2.setConditions([]);}z2.open(true);j1.call(this,true);delete this._vLiveChangeValue;}}.bind(this),300,{leading:false,trailing:true});z2.initBeforeOpen(true);}var D2=z2.openByTyping();if(D2 instanceof Promise){D2.then(function(){var E2=document.activeElement;if(E2&&(n(this.getDomRef(),E2))&&this._fnLiveChangeTimer){this._fnLiveChangeTimer();}}.bind(this));}this._fnLiveChangeTimer();}}}this.fireLiveChange({value:u2,escPressed:w2,previousValue:v2});}
function T1(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue;}}
function U1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(u2){if(!u2){j.open(this._getContent()[0]);j1.call(this,true);}}.bind(this));}this.firePress();}
function V1(j){if(j.getParameter("type")==="removed"){var u2=j.getParameter("removedTokens");var v2=this.getConditions();var w2;var i;for(i=0;i<u2.length;i++){var x2=u2[i];var y2=x2.getBindingContext("$field").sPath;var z2=parseInt(y2.slice(y2.lastIndexOf("/")+1));v2[z2].delete=true;}for(i=v2.length-1;i>=0;i--){if(v2[i].delete){if(this._bIsMeasure){w2=v2[i].values[0][1];}v2.splice(i,1);}}if(this._bIsMeasure&&w2&&v2.length===0){v2=[C.createItemCondition([undefined,w2],undefined)];}this.setProperty("conditions",v2,true);N.call(this,v2,true);j.preventDefault(true);}}
function W1(i,j){if(j==="remove"){var u2=sap.ui.getCore().byId(i);if(u2){u2.detachEvent("select",_1,this);u2.detachEvent("navigate",a2,this);u2.detachEvent("dataUpdate",c2,this);u2.detachEvent("disconnect",d2,this);u2.detachEvent("afterClose",b2,this);}this.setProperty("_fieldHelpEnabled",false,true);}else if(j==="insert"){X1.call(this,i);}a1.call(this,this.getConditions());}
function X1(i){if(i&&!this.getProperty("_fieldHelpEnabled")){var j=sap.ui.getCore().byId(i);if(j){j.attachEvent("dataUpdate",c2,this);this.setProperty("_fieldHelpEnabled",true,true);}}}
function Y1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}
function Z1(j,u2){if(!u2){u2=Y1.call(this);}if(this._bIsMeasure){var v2=[];for(var i=0;i<j.length;i++){var w2=j[i];if(w2.values[0]&&w2.values[0][1]){var x2=C.createItemCondition(w2.values[0][1],undefined,w2.inParameters,w2.outParameters);v2.push(x2);}}u2.setConditions(v2);}else{u2.setConditions(j);}}
function $1(i){var j=Y1.call(this);if(j){j.setFilterValue("");var u2=this.getConditions();Z1.call(this,u2,j);j.toggleOpen(false);j1.call(this,true);if(!j.isFocusInHelp()){var v2=i.getSource();if(v2.bValueHelpRequested){v2.bValueHelpRequested=false;}}}}
function _1(j){var u2=this.getConditions();var v2=j.getParameter("conditions");var w2=j.getParameter("add");var x2=j.getParameter("close");var y2=j.oSource;var z2=this.getMaxConditions();var A2;var B2=this.getControlForSuggestion();var C2;var i=0;if(this._bIsMeasure){if(v2.length>1){throw new Error("Only one item must be selected! "+this);}if(v2[0].operator!=="EQ"){throw new Error("Only EQ allowed! "+this);}if(u2.length>0){for(i=0;i<u2.length;i++){u2[i].values[0][1]=v2[0].values[0];if(u2[i].operator==="BT"){u2[i].values[1][1]=v2[0].values[0];}if(v2[0].inParameters){u2[i].inParameters=v2[0].inParameters;}if(v2[0].outParameters){u2[i].outParameters=v2[0].outParameters;}}}else{A2=m({},v2[0]);A2.values[0]=[undefined,A2.values[0]];A2.values[1]=undefined;u2.push(A2);if(this._oConditionType){C2=this._oConditionType.formatValue(A2);}else if(this._oConditionsType){C2=this._oConditionsType.formatValue(u2);}}}else{if(!w2){u2=[];}for(i=0;i<v2.length;i++){A2=v2[i];if(!t2.call(this,A2.operator)){continue;}var D2=w2?-1:b.indexOfCondition(A2,u2);if(D2===-1){u2.push(A2);}else if(A2.values[1]!==u2[D2].values[1]&&u2[D2].values[1]){u2[D2].values[1]=A2.values[1];}}}if(z2>0&&z2<u2.length){u2.splice(0,u2.length-z2);}if(B2&&B2.setDOMValue){if(this.getMaxConditionsForHelp()===1&&u2.length>0){if(this._bIsMeasure&&this._oUnitConditionsType){C2=this._oUnitConditionsType.formatValue(u2);}else if(this._oConditionType){C2=this._oConditionType.formatValue(u2[0]);}else if(this._oConditionsType){C2=this._oConditionsType.formatValue(u2);}if(C2 instanceof Promise){C2.then(function(F2){B2.setDOMValue("");B2.setDOMValue(F2);});}else{B2.setDOMValue("");B2.setDOMValue(C2);}}else if(x2){B2.setDOMValue("");y2.setFilterValue("");this._bIgnoreInputValue=false;}else{this._bIgnoreInputValue=true;}}var E2=this.getConditions();if(!h(u2,E2)){this._oNavigateCondition=undefined;k2.call(this);this.setProperty("conditions",u2,true);if(!b.compareConditionsArray(u2,E2)){y2.onFieldChange();J.call(this,u2,true);}}}
function a2(i){var j=i.getParameter("value");var u2=i.getParameter("key");var v2=i.getParameter("condition");var w2=i.getParameter("itemId");var x2;var y2;var z2=this.getControlForSuggestion();if(v2){this._oNavigateCondition=m({},v2);u2=v2.values[0];j=v2.values[1];}else{this._oNavigateCondition=C.createItemCondition(u2,j);}if(this._bIsMeasure){var A2=this.getConditions();if(A2.length>0){this._oNavigateCondition.operator=A2[0].operator;this._oNavigateCondition.values[0]=[A2[0].values[0][0],this._oNavigateCondition.values[0]];if(A2[0].operator==="BT"){this._oNavigateCondition.values[1]=[A2[0].values[1][0],this._oNavigateCondition.values[0][1]];}else{this._oNavigateCondition.values[1]=undefined;}}else{this._oNavigateCondition.values=[[undefined,this._oNavigateCondition.values[0]],undefined];}}this._bPreventGetDescription=true;k2.call(this);if(this.getDisplay()!==F.Value){x2=u2;}else if(j){x2=j;}else{x2=u2;}if(z2&&z2.setDOMValue){if(!y2){if(this._bIsMeasure&&this._oUnitConditionsType&&this._oNavigateCondition){y2=this._oUnitConditionsType.formatValue([this._oNavigateCondition]);}else if(this._oConditionType&&this._oNavigateCondition){y2=this._oConditionType.formatValue(this._oNavigateCondition);}else if(this._oConditionsType&&this._oNavigateCondition){y2=this._oConditionsType.formatValue([this._oNavigateCondition]);}else{y2=j||u2;}}z2.setDOMValue(y2);z2._doSelect();}this._bPreventGetDescription=false;k2.call(this);j1.call(this,true,w2);this._bIgnoreInputValue=false;this.fireLiveChange({value:x2});}
function b2(i){if(this._bIgnoreInputValue){var j=this.getControlForSuggestion();this._bIgnoreInputValue=false;j.setDOMValue("");}j1.call(this,false);}
function c2(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==F.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}
function d2(i){var j=Y1.call(this);j.detachEvent("select",_1,this);j.detachEvent("navigate",a2,this);j.detachEvent("disconnect",d2,this);j.detachEvent("afterClose",b2,this);this._bConnected=false;}
function e2(){var i=Y1.call(this);if(i&&!this._bConnected){i.connect(this);this._bConnected=true;i.attachEvent("select",_1,this);i.attachEvent("navigate",a2,this);i.attachEvent("disconnect",d2,this);i.attachEvent("afterClose",b2,this);var j=this.getConditions();Z1.call(this,j,i);var u2=this.getControlForSuggestion();f2.call(this,u2);}}
function f2(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var u2=Y1.call(this.getParent());if(u2){var v2=sap.ui.getCore().byId(j.relatedControlId);if(v2){if(n(u2.getDomRef(),v2.getFocusDomRef())){j.stopPropagation();return;}else{u2.skipOpening();}}}this.orgOnsapfocusleave(j);};}}
function g2(){var i=Y1.call(this);if(i){return i.getIcon();}}
function h2(i,j){if(j==="remove"){i.detachEvent("dataUpdate",i2,this);}else if(j==="insert"){i.attachEvent("dataUpdate",i2,this);i2.call(this);}}
function i2(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(u2){j._bTriggerable=u2;if(j.getAggregation("_content",[]).length>0&&j.getEditMode()===E.Display){p1.call(j);if(j._bTriggerable){i.getDirectLinkHrefAndTarget().then(j2.bind(j));}}});}
function j2(i){if(i){var j=this.getAggregation("_content",[])[0];j.setHref(i.href);j.setTarget(i.target);}}
y.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=p2.bind(this);}return{valueType:R.call(this),originalDateType:this._oDateOriginalType||this._oUnitOriginalType,display:this._bIsMeasure?F.Value:this.getDisplay(),fieldHelpID:this._bIsMeasure?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,operators:this._getOperators(),hideOperator:this._bHideOperator,maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription};};
function k2(){if(this._oConditionType||this._oConditionsType){var i=this._getFormatOptions();if(this._oConditionType){this._oConditionType.setFormatOptions(i);}if(this._oConditionsType){this._oConditionsType.setFormatOptions(i);}if(this._oUnitConditionsType){i=o2.call(this);this._oUnitConditionsType.setFormatOptions(i);}}}
y.prototype._updateConditionType=function(){k2.call(this);};
function l2(){if(!this._oConditionType){var i=this._getFormatOptions();this._oConditionType=new c(i);this._oConditionType._bCreatedByField=true;}return this._oConditionType;}
function m2(){if(!this._oConditionsType){var i=this._getFormatOptions();this._oConditionsType=new d(i);this._oConditionsType._bCreatedByField=true;}return this._oConditionsType;}
y.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""||(typeof(i)==="string"&&i.match(/^0+$/))){var j=R.call(this);var u2=j.parseValue("","string");if(u2===i){return true;}else{try{j.validateValue(u2);}catch(v2){return true;}}}else{var w2=U.call(this);if(this.getTypeUtil().getBaseType(w2)===B.Unit&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};
function n2(){if(!this._oUnitConditionsType){var i=o2.call(this);this._oUnitConditionsType=new d(i);this._oUnitConditionsType._bCreatedByField=true;}return this._oUnitConditionsType;}
function o2(){if(!this._asyncParsingCall){this._asyncParsingCall=p2.bind(this);}return{valueType:undefined,originalDateType:R.call(this),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,operators:["EQ"],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,isUnit:true,getConditions:this.getConditions.bind(this)};}
function p2(i){var j=Y1.call(this);if(j&&j.isOpen()){var u2=document.activeElement;if(u2&&(n(this.getDomRef(),u2)||n(j.getDomRef(),u2))){j.close();}}var v2={};var w2=new Promise(function(x2,y2){v2.resolve=x2;v2.reject=y2;i.then(function(z2){v2.result=z2;this._bParseError=false;var A2=this.getConditions();if(h(z2,A2)){r2.call(this,v2);s2.call(this,v2);}else{v2.waitForUpdate=true;}}.bind(this)).catch(function(z2){if(z2&&!(z2 instanceof P)&&!(z2 instanceof r)&&!(z2 instanceof V)){throw z2;}this._bParseError=true;y2(z2);s2.call(this,v2);}.bind(this));}.bind(this));v2.promise=w2;this._aAsyncChanges.push(v2);}
function q2(){var j=[];for(var i=0;i<this._aAsyncChanges.length;i++){j.push(this._aAsyncChanges[i].promise);}if(j.length>0){return Promise.all(j).then(function(){return this._getResultForPromise(this.getConditions());}.bind(this));}return null;}
y.prototype._getResultForPromise=function(i){return i;};
function r2(i){i.resolve(this._getResultForPromise(i.result));}
function s2(j){var u2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){u2=true;break;}}if(u2){this._aAsyncChanges.splice(i,1);}return u2;}
y.prototype._getOperators=function(){var i=new RegExp("^\\*(.*)\\*|\\$search$");if(i.test(this.getFieldPath())&&this.getMaxConditions()===1){return["Contains"];}var j=U.call(this);var u2=W.call(this);var v2=X.call(this);var w2=this.getTypeUtil().getBaseType(j,v2,u2);if(w2===B.Unit){w2=B.Numeric;}return b.getOperatorsForType(w2);};
function t2(j){var u2=this._getOperators();for(var i=0;i<u2.length;i++){if(j===u2[i]){return true;}}return false;}
return y;});
sap.ui.predefine('sap/ui/mdc/field/FieldBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/IconPool'],function(R,I){"use strict";I.insertFontFaceStyle();
var F=R.extend("sap.ui.mdc.field.FieldBaseRenderer");
F=Object.assign(F,{apiVersion:2});
F.render=function(r,f){var c=f._getContent();var w=f.getWidth();r.openStart("div",f);r.class("sapUiMdcFieldBase");if(c.length>1){r.class("sapUiMdcFieldBaseMoreFields");}r.style("width",w);r.openEnd();for(var i=0;i<c.length;i++){var C=c[i];r.renderControl(C);}r.close("div");};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInputRenderer',['sap/ui/core/Renderer','sap/m/InputRenderer'],function(R,I){"use strict";var F=R.extend(I);F.apiVersion=2;
F.addOuterClasses=function(r,i){I.addOuterClasses.apply(this,arguments);r.class("sapUiMdcFieldInput");};
F.getAriaRole=function(i){var a=i.getAriaAttributes();if(a.role){return a.role;}else{return I.getAriaRole.apply(this,arguments);}};
F.getAccessibilityState=function(i){var a=i.getAriaAttributes();var A=I.getAccessibilityState.apply(this,arguments);if(a.aria){for(var s in a.aria){A[s]=a.aria[s];}}return A;};
F.writeInnerAttributes=function(r,i){I.writeInnerAttributes.apply(this,arguments);var a=i.getAriaAttributes();for(var A in a){if(A!=="aria"&&A!=="role"){r.attr(A,a[A]);}}};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldMultiInputRenderer',['sap/ui/core/Renderer','sap/m/MultiInputRenderer'],function(R,M){"use strict";var F=R.extend(M);F.apiVersion=2;
F.addOuterClasses=function(r,m){M.addOuterClasses.apply(this,arguments);r.class("sapUiMdcFieldMultiInput");};
F.getAriaRole=function(m){var a=m.getAriaAttributes();if(a.role){return a.role;}else{return M.getAriaRole.apply(this,arguments);}};
F.getAccessibilityState=function(m){var a=m.getAriaAttributes();var A=M.getAccessibilityState.apply(this,arguments);if(a.aria){for(var s in a.aria){A[s]=a.aria[s];}}return A;};
F.writeInnerAttributes=function(r,m){M.writeInnerAttributes.apply(this,arguments);var a=m.getAriaAttributes();for(var A in a){if(A!=="aria"&&A!=="role"){r.attr(A,a[A]);}}};
return F;});
sap.ui.predefine('sap/ui/mdc/field/ValueHelpPanel',['sap/ui/core/XMLComposite','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/base/ManagedObjectObserver','sap/base/strings/formatMessage','sap/ui/model/resource/ResourceModel','sap/m/Tokenizer','sap/ui/mdc/enum/ConditionValidated'],function(X,J,F,M,f,R,T,C){"use strict";
var V=X.extend("sap.ui.mdc.field.ValueHelpPanel",{
metadata:{library:"sap.ui.mdc",properties:{showTokenizer:{type:"boolean",group:"Data",defaultValue:true},showFilterbar:{type:"boolean",group:"Data",defaultValue:true},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},filterConditions:{type:"object[]",group:"Data",defaultValue:[]},searchEnabled:{type:"boolean",group:"Data",defaultValue:true},formatOptions:{type:"object",defaultValue:{}},_filterBarVisible:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"}},events:{search:{}}},
fragment:"sap.ui.mdc.field.ValueHelpPanel",
init:function(){var m=this._getManagedObjectModel();m.setSizeLimit(1000000);if(!this._oTokenizer){this._oTokenizer=this.byId("VHPTokenizer");this._oTokenizer._oScroller.setHorizontal(true);}this._oTokenizerPanel=this.byId("VHPTokenizerPanel");var s=this.byId("SearchField");s.getFieldPath=a.bind(this);this._oAdvButton=this.byId("AdvancedFilter");this._oFilterVBox=this.byId("filterbarVBox");this._oFilterVBox._oValueHelpPanel=this;this._oFilterVBox.getItemsOriginal=this._oFilterVBox.getItems;this._oFilterVBox.getItems=function(){var i=this.getItemsOriginal();if(this._oValueHelpPanel._oFilterbar&&this._oValueHelpPanel.getProperty("_filterBarVisible")){i.push(this._oValueHelpPanel._oFilterbar);}return i;};this._oTablePanel=this.byId("tablePanel");this._oTablePanel._oValueHelpPanel=this;this._oTablePanel.getContentOriginal=this._oTablePanel.getContent;this._oTablePanel.getContent=function(){var c=this.getContentOriginal();if(this._oValueHelpPanel._oTable){c.push(this._oValueHelpPanel._oTable);}return c;};this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["formatOptions","showFilterbar","showTokenizer","_filterBarVisible"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");},
exit:function(){if(!this.getShowTokenizer()){this._oTokenizerPanel.destroy();}if(this._oDefineConditionPanel&&!this._oDefineConditionPanel.getParent()){this._oDefineConditionPanel.destroy();}this._oObserver.disconnect();this._oObserver=undefined;this._oTablePanel=null;this._oFilterVBox=null;this._oAdvButton=null;this._oResourceBundle=null;},
onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}},
setFilterbar:function(o){var s=this.getShowFilterbar();if(this._oFilterbar){this._oFilterbar.removeStyleClass("sapMdcValueHelpPanelFilterbar");if(this._bFilterbarParentSet){this._oFilterbar.setParent();delete this._bFilterbarParentSet;}}this._oFilterbar=o;if(o){o.addStyleClass("sapMdcValueHelpPanelFilterbar");if(!o.getParent()){o.setParent(this);this._bFilterbarParentSet=true;}o.getParent().getDirection=this._oFilterVBox.getDirection.bind(this._oFilterVBox);if(o.getLiveMode&&!o.getLiveMode()){o.setShowGoButton(false);}}var i=this.byId("iconTabBar");i.getItems()[0].setVisible(i.getItems()[0].getContent().length>0);i.setSelectedKey("selectFromList");this._updateITBHeaderVisiblity();this.setProperty("_filterBarVisible",s&&!!this._oFilterbar,true);},
setTable:function(t){if(this._oTable){if(this._bTableParentSet&&this._oTable.getParent()){this._oTable.setParent();}delete this._bTableParentSet;}this._oTable=t;if(t){if(!t.getParent()){t.setParent(this);this._bTableParentSet=true;}}this._oTablePanel.invalidate();var i=this.byId("iconTabBar");i.getItems()[0].setVisible(i.getItems()[0].getContent().length>0);i.setSelectedKey("selectFromList");this._updateITBHeaderVisiblity();},
getTable:function(){if(this._oTable){return this._oTable;}else{return undefined;}},
setDefineConditions:function(d){var i=this.byId("iconTabBar");var p=this.byId("defineConditionPanel");if(this._oDefineConditionPanel){p.removeContent(this._oDefineConditionPanel);this._oDefineConditionPanel.destroy();}this._oDefineConditionPanel=d;i.getItems()[1].setVisible(!!this._oDefineConditionPanel);this._updateITBHeaderVisiblity();},
_updateITBHeaderVisiblity:function(){var i=this.byId("iconTabBar");if(i.getItems()[0].getVisible()&&i.getItems()[1].getVisible()){i.removeStyleClass("sapMdcNoHeader");}else{i.addStyleClass("sapMdcNoHeader");}if(i.getItems()[1].getVisible()&&i.getSelectedKey()!=="selectFromList"){b.call(this);}},
_handleTokenUpdate:function(e){if(e.getParameter("type")==="removed"){var r=e.getParameter("removedTokens");var c=this.getConditions();var i;for(i=0;i<r.length;i++){var o=r[i];var p=o.getBindingContext("$this").sPath;var I=parseInt(p.slice(p.lastIndexOf("/")+1));c[I].delete=true;}for(i=c.length-1;i>=0;i--){if(c[i].delete){c.splice(i,1);}}this.setProperty("conditions",c,true);}},
_onToggleAdvancedFilter:function(e){this.setProperty("_filterBarVisible",!this.getProperty("_filterBarVisible"),true);},
_onGo:function(e){this._oFilterbar.triggerSearch();},
_onRemoveAllConditions:function(e){this.setProperty("conditions",[],true);},
iconTabSelect:function(e){var k=e.getParameter("key");if(k==="defineCondition"){b.call(this);}},
_formatListTabTitle:function(t,c){var d=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true&&o.validated===C.Validated){d++;}}if(d===0){t=this._oResourceBundle.getText("valuehelp.SELECTFROMLISTNONUMBER");}return f(t,d);},
_formatDefineTabTitle:function(t,c){var d=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true&&o.validated!==C.Validated){d++;}}if(d===0){t=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONSNONUMBER");}return f(t,d);},
_formatTableTitle:function(t){var i=0;t=this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER");return f(t,i);},
_formatTokenizerTitle:function(t,c){var d=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true){d++;}}if(d===0){t=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER");}return f(t,d);},
_handleSearch:function(e){this.fireSearch();}
});
function _(c){if(c.name==="formatOptions"){var B=this._oTokenizer.getBindingInfo("tokens");if(B&&B.template){B=B.template.getBindingInfo("text");if(B&&B.type){B.type.setFormatOptions(c.current);}}}if(c.name==="showTokenizer"){var v=this.byId("rootVBox");var l=this._oTokenizer.getBinding("tokens");if(c.current){if(l){l.resume();}v.insertItem(this._oTokenizerPanel,1);}else{if(l){l.suspend();}v.removeItem(this._oTokenizerPanel);}}if(c.name==="showFilterbar"){this.setProperty("_filterBarVisible",c.current&&!!this._oFilterbar,true);}if(c.name==="_filterBarVisible"){this._oTablePanel.invalidate();this._oAdvButton.setText(this._oResourceBundle.getText("valuehelp."+(this.getProperty("_filterBarVisible")?"HIDE":"SHOW")+"ADVSEARCH"));}}
function a(){var B=this.getBindingPath("filterConditions");if(B&&B.startsWith("/conditions/")){return B.slice(12);}else{return"";}}
function b(){if(this._oDefineConditionPanel){if(!this._oDefineConditionPanel.getModel("$VHP")){var m=this._getManagedObjectModel();this._oDefineConditionPanel.setModel(m,"$VHP");var o=this._oDefineConditionPanel.getMetadata();if(o.hasProperty("formatOptions")&&!this._oDefineConditionPanel.getBindingPath("formatOptions")&&this._oDefineConditionPanel.isPropertyInitial("formatOptions")){this._oDefineConditionPanel.bindProperty("formatOptions",{path:"$VHP>/formatOptions"});}if(o.hasProperty("conditions")&&!this._oDefineConditionPanel.getBindingPath("conditions")&&this._oDefineConditionPanel.isPropertyInitial("conditions")){this._oDefineConditionPanel.bindProperty("conditions",{path:"$VHP>/conditions"});}}var p=this.byId("defineConditionPanel");p.addContent(this._oDefineConditionPanel);}}
return V;});
sap.ui.predefine('sap/ui/mdc/filterbar/FilterBarBaseRenderer',[],function(){"use strict";var F={apiVersion:2};F.CSS_CLASS="sapUiMdcFilterBarBase";
F.render=function(r,c){r.openStart("div",c);r.class(F.CSS_CLASS);r.openEnd();var i=c.getAggregation("layout")?c.getAggregation("layout").getInner():null;r.renderControl(i);r.close("div");};
return F;},true);
sap.ui.predefine('sap/ui/mdc/library',["sap/ui/core/Core","sap/ui/core/library","sap/m/library"],function(){"use strict";sap.ui.getCore().initLibrary({version:"1.84.17",name:"sap.ui.mdc",dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/mdc/designtime/library.designtime",types:["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.TableRowAction","sap.ui.mdc.FilterExpression"],interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],controls:["sap.ui.mdc.Chart","sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.field.ValueHelpPanel","sap.ui.mdc.field.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.link.Panel","sap.ui.mdc.link.ContactDetails"],elements:["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.V4AnalyticsTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.DimensionItem","sap.ui.mdc.chart.MeasureItem","sap.ui.mdc.field.CustomFieldHelp","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldHelpBase","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.FieldValueHelp","sap.ui.mdc.field.FieldValueHelpContentWrapperBase","sap.ui.mdc.field.FieldValueHelpMTableWrapper","sap.ui.mdc.field.ListFieldHelp","sap.ui.mdc.field.BoolFieldHelp","sap.ui.mdc.field.ConditionFieldHelp","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.link.ContactDetailsAddressItem","sap.ui.mdc.link.ContactDetailsEmailItem","sap.ui.mdc.link.ContactDetailsItem","sap.ui.mdc.link.ContactDetailsPhoneItem","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.InParameter","sap.ui.mdc.field.OutParameter"],extensions:{flChangeHandlers:{"sap.ui.mdc.Table":"sap/ui/mdc/flexibility/Table","sap.ui.mdc.Chart":"sap/ui/mdc/flexibility/Chart","sap.ui.mdc.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.p13n.AdaptationFilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.link.PanelItem":"sap/ui/mdc/flexibility/PanelItem","sap.ui.mdc.link.Panel":"sap/ui/mdc/flexibility/Panel"}},noLibraryCSS:false});var t=sap.ui.mdc;t.FilterBarP13nMode={Item:"Item",Value:"Value"};t.TableType={Table:"Table",ResponsiveTable:"ResponsiveTable"};t.TableP13nMode={Column:"Column",Sort:"Sort",Filter:"Filter"};t.GrowingMode={None:"None",Basic:"Basic",Scroll:"Scroll"};t.RowCountMode={Auto:"Auto",Fixed:"Fixed"};t.ChartToolbarActionType={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend",FullScreen:"FullScreen"};t.ChartP13nMode={Item:"Item",Sort:"Sort",Type:"Type"};t.SelectionMode={None:"None",Single:"Single",Multi:"Multi"};t.RowAction={Navigation:"Navigation"};t.FilterExpression={Interval:"Interval",Single:"Single",Multi:"Multi"};t.ChartItemType={Dimension:"Dimension",Measure:"Measure"};t.ChartItemRoleType={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};t.ContactDetailsAddressType={work:"work",home:"home",preferred:"preferred"};t.ContactDetailsEmailType={work:"work",home:"home",preferred:"preferred"};t.ContactDetailsPhoneType={work:"work",home:"home",cell:"cell",fax:"fax",preferred:"preferred"};return t;});
sap.ui.predefine('sap/ui/mdc/link/FakeFlpConnector',["sap/ui/thirdparty/jquery",'sap/ui/mdc/link/Factory'],function(q,F){"use strict";
function a(){}
a.enableFakeConnector=function(s){if(a.getServiceReal){return;}a.getServiceReal=F.getService;F.getService=a._createFakeService(s);};
a.enableFakeConnectorForTesting=function(s,t){if(a.getServiceReal){return;}a.getServiceReal=F.getService;F.getService=a._createFakeService(s,t);};
a._createFakeService=function(s,t){return function(S){switch(S){case"CrossApplicationNavigation":return{hrefForExternal:function(T,c){if(t){t.hrefForExternal=t.hrefForExternal||{calls:[]};t.hrefForExternal.calls.push({target:T,comp:c});}if(!T){return null;}return T.target.shellHash;},getDistinctSemanticObjects:function(){var b=[];for(var c in s){b.push(c);}var d=q.Deferred();setTimeout(function(){d.resolve(b);},0);return d.promise();},getLinks:function(p){var l=[];if(!Array.isArray(p)){s[p.semanticObject]?l=s[p.semanticObject].links:l=[];}else{p.forEach(function(P){s[P[0].semanticObject]?l.push([s[P[0].semanticObject].links]):l.push([[]]);});}var d=q.Deferred();setTimeout(function(){d.resolve(l);},0);return d.promise();}};case"URLParsing":return{parseShellHash:function(i){var f=function(L){var c=L.filter(function(l){return l.intent===i;});return c[0];};for(var b in s){var l=f(s[b].links);if(l){return{semanticObject:b,action:l.action};}}return{semanticObject:null,action:null};}};default:return a.getServiceReal(S);}};};
a.disableFakeConnector=function(){if(a.getServiceReal){F.getService=a.getServiceReal;a.getServiceReal=undefined;}};
return a;},true);
sap.ui.predefine('sap/ui/mdc/mixin/AdaptationMixin',["sap/ui/mdc/util/loadModules",'sap/base/util/merge','sap/base/Log'],function(l,m,L){"use strict";var A;var F;var a={};
a.retrieveAdaptationController=function(){if(!this.getProperty("adaptationConfig")){throw new Error("Please provide an adaptation config for this control before instantiating an adaptation controller.");}var o=function(){if(!this._oAdaptationController){this._oAdaptationController=new A(Object.assign({stateRetriever:function(c,d){return this.getCurrentState();},adaptationControl:this,afterChangesCreated:function(b,c){F.handleChanges(c);}},this.getProperty("adaptationConfig")));}return this._oAdaptationController;};return l(["sap/ui/mdc/p13n/AdaptationController","sap/ui/mdc/p13n/FlexUtil"]).then(function(b){A=b[0];F=b[1];}).then(function(){if(!this.bIsDestroyed){return o.call(this);}}.bind(this));};
a.getAdaptationController=function(){if(!this._oAdaptationController){throw new Error("An adaptation controller instance is not (yet) available. You must call retrieveAdaptationController before calling getAdaptationController.");}return this._oAdaptationController;};
a.getAdaptationConfigAttribute=function(s){var o=this.getAdaptationConfig();if(!o){throw new Error("Please provide an adaptation config for this control before calling getAdaptationConfigAttribute.");}return o&&o[s];};
a.enhanceAdaptationConfig=function(d){var n=m(this.getAdaptationConfig(),d);if(this._oAdaptationController){Object.keys(d).forEach(function(k){this._oAdaptationController.setProperty(k,n[k]);}.bind(this));}this.setProperty("adaptationConfig",n);return this;};
a.retrieveInbuiltFilter=function(r,b){if(!this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=new Promise(function(c,d){sap.ui.require(["sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],function(e){if(this.bIsDestroyed){d("exit");return;}if(!this._oP13nFilter){this._oP13nFilter=new e(this.getId()+"-p13nFilter",{adaptationControl:this,advancedMode:b,filterConditions:this.getFilterConditions()});if(r instanceof Function){r.call(this,this._oP13nFilter);}this.enhanceAdaptationConfig({filterConfig:{initializeControl:this._oP13nFilter.createFilterFields}});this.addDependent(this._oP13nFilter);c(this._oP13nFilter);}else{c(this._oP13nFilter);}}.bind(this));}.bind(this));}return this._oInbuiltFilterPromise;};
a.getInbuiltFilter=function(){return this._oP13nFilter;};
a.getRTASettingsActionHandler=function(p,P){return new Promise(function(r,b){this.retrieveAdaptationController().then(function(o){var c=o.getLiveMode();if(c){o.setLiveMode(false);}var R=o.getAfterChangesCreated();var f=o.getOnReset();var e=function(E){var C=E.getParameter("container");C.isPopupAdaptationAllowed=function(){return false;};C.addStyleClass(p.styleClass);};o.attachEvent("beforeP13nContainerOpens",e);var t=[];o.setAfterChangesCreated(function(g,C,s){if(g.sP13nType==="Filter"){if(s==="Item"){t=C;}else if(s==="Value"){r(t.concat(C));t=[];}}else{r(C);}});o.setOnReset();var d=function(E){var s=E.getParameter("reason");if(s=="Cancel"){r([]);}if(c){o.setLiveMode(c);}o._executeAfterAsyncActions(function(g){setTimeout(function(){o.setAfterChangesCreated(R);o.setOnReset(f);},0);});o.detachEvent("beforeP13nContainerOpens",e);o.detachEvent("afterP13nContainerCloses",d);};o.attachEvent("afterP13nContainerCloses",d);o.showP13n(this,P);});}.bind(this));};
a.exit=function(e){return function(){if(this._oAdaptationController){this._oAdaptationController.destroy();this._oAdaptationController=null;}if(this._oP13nFilter){this._oP13nFilter.destroy();this._oP13nFilter=null;}if(this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=null;}if(e){e.apply(this,arguments);}};};
return function(){this.retrieveAdaptationController=a.retrieveAdaptationController;this.getAdaptationController=a.getAdaptationController;this.enhanceAdaptationConfig=a.enhanceAdaptationConfig;this.getAdaptationConfigAttribute=a.getAdaptationConfigAttribute;this.getRTASettingsActionHandler=a.getRTASettingsActionHandler;this.retrieveInbuiltFilter=a.retrieveInbuiltFilter;this.getInbuiltFilter=a.getInbuiltFilter;this.exit=a.exit(this.exit);};},true);
sap.ui.predefine('sap/ui/mdc/mixin/DelegateMixin',["sap/ui/mdc/util/loadModules","sap/base/Log"],function(l,L){"use strict";var _=function(c){if(!c||!c.name){throw new Error("Delegate configuration '"+(c&&JSON.stringify(c))+"' invalid");}};var a=function(r){if(!this.bIsDestroyed){if(r instanceof Error){this.fnRejectDelegate(r);}else{this._oDelegate=r[0];this.fnResolveDelegate(this._oDelegate);this.bDelegateInitialized=true;}}this.bDelegateLoading=false;delete this.fnResolveDelegate;delete this.fnRejectDelegate;};var D={};
D.init=function(i){return function(){this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=new Promise(function(r,b){this.fnResolveDelegate=r;this.fnRejectDelegate=b;}.bind(this));this._oPropertyHelper=null;this._bPropertyHelperIsBeingInitialized=false;this._pInitPropertyHelper=new Promise(function(r,b){this._fnResolveInitPropertyHelper=r;this._fnRejectInitPropertyHelper=b;}.bind(this));if(i){i.apply(this,arguments);}};};
D.applySettings=function(A){return function(s){A.apply(this,arguments);this._bDelegateLocked=true;return this;};};
D.setDelegate=function(s){return function(c){if(this._bDelegateLocked){throw new Error("Runtime delegate configuration is not permitted.");}_(c);s.call(this,c);this._oPayload=c&&c.payload;return this;};};
D.initControlDelegate=function(p){if(this.bIsDestroyed){L.warning("Delegate module initialization omitted as control is being destroyed.");}else if(!this._oDelegate&&!this.bDelegateLoading){if(p){a.call(this,[p]);}else{var d=this.getDelegate();_(d);this.bDelegateLoading=true;l(d.name).then(a.bind(this)).catch(a.bind(this));}}else{L.warning("Delegate module already initialized.");}return this._oDelegateInitialized;};
D.getPayload=function(){if(!this._oPayload){var d=this.getDelegate();this._oPayload=d&&d.payload;}return this._oPayload;};
D.getTypeUtil=function(){if(!this._oTypeUtil){if(!this._oDelegate){throw new Error("A delegate instance providing typeUtil is not (yet) available.");}this._oTypeUtil=this._oDelegate.getTypeUtil&&this._oDelegate.getTypeUtil(this._oPayload);}return this._oTypeUtil;};
D.getControlDelegate=function(){if(!this._oDelegate){throw new Error("A delegate instance is not (yet) available. You must call initControlDelegate before calling getControlDelegate.");}return this._oDelegate;};
D.awaitControlDelegate=function(){return this._oDelegateInitialized;};
D.initPropertyHelper=function(C){if(C&&(!C.getMetadata||!C.getMetadata().isA("sap.ui.mdc.util.PropertyHelper"))){throw new Error("The custom property helper must be sap.ui.mdc.util.PropertyHelper or a subclass of it.");}if(!this.bIsDestroyed&&!this._oPropertyHelper&&!this._bPropertyHelperIsBeingInitialized){this._bPropertyHelperIsBeingInitialized=true;this.awaitControlDelegate().then(function(d){if(this.bIsDestroyed){return;}return Promise.all([C||l("sap/ui/mdc/util/PropertyHelper"),d.fetchProperties(this)]);}.bind(this)).then(function(r){if(this.bIsDestroyed){return;}var P=r[0][0]?r[0][0]:r[0];var p=r[1];this._oPropertyHelper=new P(p,this);this._bPropertyHelperIsBeingInitialized=false;this._fnResolveInitPropertyHelper(this._oPropertyHelper);}.bind(this)).catch(function(e){this._fnRejectInitPropertyHelper(e);}.bind(this));}return this._pInitPropertyHelper;};
D.awaitPropertyHelper=function(){return this._pInitPropertyHelper;};
D.getPropertyHelper=function(){if(!this._oPropertyHelper){throw new Error("A property helper is not (yet) available. You must first initialize the delegate and the property helper.");}return this._oPropertyHelper;};
D.exit=function(e){return function(){this.fnResolveDelegate=null;this.fnRejectDelegate=null;this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=null;this._oDelegate=null;this._oPayload=null;this._oTypeUtil=null;if(this._oPropertyHelper){this._oPropertyHelper.destroy();}this._oPropertyHelper=null;this._fnResolveInitPropertyHelper=null;this._fnRejectInitPropertyHelper=null;this._bPropertyHelperIsBeingInitialized=false;this._pInitPropertyHelper=null;if(e){e.apply(this,arguments);}};};
return function(){this.applySettings=D.applySettings(this.applySettings);this.exit=D.exit(this.exit);this.init=D.init(this.init);this.setDelegate=D.setDelegate(this.setDelegate);this.awaitControlDelegate=D.awaitControlDelegate;this.getControlDelegate=D.getControlDelegate;this.getPayload=D.getPayload;this.getTypeUtil=D.getTypeUtil;this.initControlDelegate=D.initControlDelegate;this.initPropertyHelper=D.initPropertyHelper;this.awaitPropertyHelper=D.awaitPropertyHelper;this.getPropertyHelper=D.getPropertyHelper;};},true);
sap.ui.predefine('sap/ui/mdc/mixin/FilterIntegrationMixin',["sap/ui/core/Core","sap/base/Log"],function(C,L){"use strict";var F={};var I="sap.ui.mdc.IFilter";
F.setFilter=function(f){if(this._validateFilter(f)){this._deregisterFilter();this.setAssociation("filter",f,true);this._registerFilter();this._onFilterProvided();}return this;};
F._onFilterProvided=function(){return;};
F._registerFilter=function(){var f=C.byId(this.getFilter());if(f){f.attachSearch(this.rebind,this);f.attachFiltersChanged(this._onFiltersChanged,this);}};
F._deregisterFilter=function(){var f=C.byId(this.getFilter());if(f){f.detachSearch(this.rebind,this);f.detachFiltersChanged(this._onFiltersChanged,this);}};
var _=function(c){if(!(c&&c.getMetadata()&&c.getMetadata().hasAssociation("filter"))){throw new Error("Please add the 'filter' association to your control metadata"+c);}if(!(c.rebind instanceof Function)){throw new Error("Please implement the method 'rebind' for the control "+c);}if(!(c.isFilteringEnabled instanceof Function)){throw new Error("Please implement the method isFilteringEnabled for the control "+c);}};
F._validateFilter=function(f){_(this);var o=typeof f==="object"?f:C.byId(f);if(!o||o.isA(I)){return true;}throw new Error("\""+f+"\" is not valid for association \"filter\" of mdc.Table. Please use an object that implements \""+I+"\" interface");};
F.checkAndRebind=function(){if(this.bIsDestroyed){return;}var p;var a;var f=C.byId(this.getFilter()),i=this.isFilteringEnabled();if(i||f){if(f){p=f.valid(false);}if(i){a=this.retrieveInbuiltFilter().then(function(o){return o.valid(false);});}Promise.all([p,a]).then(function(){this.rebind();}.bind(this),function(){});}else{this.rebind();}};
return function(){this.setFilter=F.setFilter;this._registerFilter=F._registerFilter;this._deregisterFilter=F._deregisterFilter;this._validateFilter=F._validateFilter;this._onFilterProvided=F._onFilterProvided;this.checkAndRebind=F.checkAndRebind;};},true);
sap.ui.predefine('sap/ui/mdc/odata/TypeUtil',['sap/ui/mdc/util/TypeUtil','sap/ui/mdc/enum/BaseType','sap/base/util/ObjectPath'],function(B,a,O){"use strict";var T=Object.assign({},B,{getPrimitiveType:function(d){var t={"Edm.Binary":"boolean","Edm.Boolean":"boolean","Edm.Byte":"boolean","Edm.Date":"date","Edm.DateTimeOffset":"dateTime","Edm.Decimal":"int","Edm.Double":"boolean","Edm.Duration":"float","Edm.Guid":"string","Edm.Int16":"int","Edm.Int32":"int","Edm.Int64":"int","Edm.SByte":"boolean","Edm.Single":"float","Edm.String":"string","Edm.TimeOfDay":"time"};return t[d]||"object";},getDataTypeClassName:function(t){var e={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};if(e[t]){t=e[t];}else if(t&&t.startsWith("Edm.")){throw new Error("Invalid data type "+t);}else{t=B.getDataTypeClassName(t);}return t;},getBaseType:function(t,f,c){switch(t){case"sap.ui.model.odata.type.DateTime":if(c&&(c.displayFormat==="Date"||c.isDateOnly)){return a.Date;}else{return a.DateTime;}break;case"sap.ui.model.odata.type.DateTimeOffset":return a.DateTime;case"sap.ui.model.odata.type.Time":return a.Time;case"sap.ui.model.odata.type.Boolean":return a.Boolean;case"sap.ui.model.odata.type.Byte":case"sap.ui.model.odata.type.SByte":case"sap.ui.model.odata.type.Decimal":case"sap.ui.model.odata.type.Int16":case"sap.ui.model.odata.type.Int32":case"sap.ui.model.odata.type.Int64":case"sap.ui.model.odata.type.Single":case"sap.ui.model.odata.type.Double":return a.Numeric;default:return B.getBaseType(t,f,c);}}});return T;},true);
sap.ui.predefine('sap/ui/mdc/odata/v4/ChartDelegate',["sap/ui/mdc/library","sap/ui/mdc/ChartDelegate","sap/ui/base/SyncPromise","./ODataMetaModelUtil","sap/base/util/merge",'sap/ui/core/Core','sap/ui/mdc/util/FilterUtil','sap/ui/mdc/odata/v4/util/DelegateUtil','sap/ui/mdc/odata/v4/TypeUtil'],function(M,B,S,a,m,C,F,D,T){"use strict";var A="@Org.OData.Aggregation.V1";
function f(H){this.name=H[0];this.label=H[1]instanceof Object?H[1]["$Path"]:H[1]||this.name;this.textProperty=H[2];this.type=T.getPrimitiveType(H[3]);if(H[4]||H[5]){var c=H[4],s=H[5];if(s){switch(s){case"year":this.timeUnit="fiscalyear";break;case"yearPeriod":this.timeUnit="fiscalyearperiod";break;default:this.timeUnit=undefined;break;}}if(c&&!this.timeUnit){switch(c){case"yearMonth":this.timeUnit="yearmonth";break;case"date":this.timeUnit="yearmonthday";break;case"yearQuarter":this.timeUnit="yearquarter";break;case"yearWeek":this.timeUnit="yearweek";break;default:this.timeUnit=undefined;break;}}}this.criticality=H[6];return this;}
function h(R){var g=R[0],c=R[1];var H={},p={},I;p.inChart=g||c||false;if(p.inChart){p.chartItems=[];if(g){H.kind=M.ChartItemType.Dimension;H.role=M.ChartItemRoleType.category;I=m({},H);p.chartItems.push(I);}if(c){H.kind=M.ChartItemType.Measure;H.role=M.ChartItemRoleType.axis1;H.contextDefiningProperties=R[4]||[];var s=R[2]||[],d=R[3];for(var i=0;i<s.length;i++){I=m({},H);I.aggregationMethod=s[i]instanceof Object?s[i]["$Path"]:s[i];I.default=I.aggregationMethod==d instanceof Object?d[i]["$Path"]:d[i];p.chartItems.push(I);}}}var o=this.getModel();return Promise.all([o.requestObject("@sapui.name",this),o.requestObject("@com.sap.vocabularies.Common.v1.Label",this),o.requestObject("@com.sap.vocabularies.Common.v1.Text/$Path",this),o.requestObject("$Type",this),a.fetchCalendarTag(o,this),a.fetchFiscalTag(o,this),a.fetchCriticality(o,this)]).then(f.bind(p));}
function r(e,p,o,c){var k,P,d=[],I=[],s,g=[],j,l,K={};var n=a.getAllCustomAggregates(c);for(var q in n){I.push(m({},n[q],{propertyPath:q,kind:M.ChartItemType.Measure,role:M.ChartItemRoleType.axis1,sortable:n[q].sortable,filterable:n[q].filterable}));}var t=a.getAllAggregatableProperties(c);for(var u in t){k=t[u].propertyPath;K[k]=K[k]||{};K[k][t[u].aggregationMethod]={name:t[u].name,label:t[u].label};}var v=a.getSortRestrictionsInfo(c["@Org.OData.Capabilities.V1.SortRestrictions"]),w=a.getFilterRestrictionsInfo(c["@Org.OData.Capabilities.V1.FilterRestrictions"]);function x(P){g.push(P);a.addSortInfoForProperty(P,v);a.addFilterInfoForProperty(P,w);if(P.inChart){for(var i=0;i<P.chartItems.length;i++){var y=P.chartItems[i];y.propertyPath=P.name;y.type=P.type;y.timeUnit=P.timeUnit;y.criticality=P.criticality;if(y.kind==M.ChartItemType.Measure){var z=y.aggregationMethod instanceof Object?y.aggregationMethod["$Path"]:y.aggregationMethod;if(K[y.propertyPath]&&K[y.propertyPath][z]){y.name=K[y.propertyPath][y.aggregationMethod].name;y.label=K[y.propertyPath][y.aggregationMethod].label;}else{y.name=z+y.propertyPath;y.label=P.label+" ("+z+")";}y.customAggregate=false;y.sortable=true;y.sortDirection="both";y.filterable=true;}else{y.name=P.name;y.textProperty=P.textProperty;y.label=P.label;y.sortable=P.sortable;y.sortDirection=P.sortDirection;y.filterable=P.filterable;y.allowedExpressions=P.allowedExpressions;}I.push(y);}}}for(k in e){if(k[0]!=="$"){P=e[k];if(P&&P.$kind&&(P.$kind=="Property")){s=p+k+A;d.push(Promise.all([o.requestObject(s+".Groupable"),o.requestObject(s+".Aggregatable"),o.requestObject(s+".SupportedAggregationMethods"),o.requestObject(s+".RecommendedAggregationMethod"),o.requestObject(s+".ContextDefiningProperties")]).then(h.bind(o.getMetaContext(p+k))).then(x));}}}return Promise.all(d).then(function(){return[l,j,g,I];});}
var b=Object.assign({},B);b.MetadataProperty={kind:"Measure",role:"axis1",contextDefiningProperties:[],className:"sap.ui.mcd.chart.MeasureItem",aggregationMethod:"sum","default":true,custom:false,name:"sumSalesAmount",propertyPath:"SalesAmount",label:"Total Sales Amount",textProperty:"",sortable:true,sortDirection:"both",filterable:true,allowedExpressions:[]};
b.fetchProperties=function(c){return this.retrieveAllMetadata(c).then(function(o){return o.properties;});};
b.retrieveAggregationItem=function(s,o){var c;var d={className:"",settings:{key:o.name,label:o.label||o.name,type:o.type}};switch(o.kind){case M.ChartItemType.Dimension:d.className="sap.ui.mdc.chart.DimensionItem";c={textProperty:o.textProperty,timeUnit:o.timeUnit,displayText:true,criticality:o.criticality};break;case M.ChartItemType.Measure:d.className="sap.ui.mdc.chart.MeasureItem";c={propertyPath:o.propertyPath,aggregationMethod:o.aggregationMethod};break;}d.settings=Object.assign(d.settings,c);return d;};
b.getModel=function(c){var v=c.getDelegate().model,o=c.getModel(v);if(o){return S.resolve(o);}return new S(function(d,e){function g(){var o=c.getModel(v);if(o){c.detachModelContextChange(g,c);return d(o);}}c.attachModelContextChange(g,c);});};
b.retrieveAllMetadata=function(c){var o=this.getModel(c);function d(e){var g=c.getDelegate(),p="/"+g.payload.collectionName,i=e&&e.getMetaModel();if(p.endsWith("/")){throw new Error("The leading path for metadata calculation is the entity set not the path");}var s=p,t=p+"/";function j(R){var l={sortable:R[0],filterable:R[1],attributes:R[2],properties:R[3]};return l;}var k=[i.requestObject(t),i.requestObject(s)];return Promise.all(k).then(function(l){var E=l[0];var n=[a.fetchAllAnnotations(i,t),a.fetchAllAnnotations(i,s)];return Promise.all(n).then(function(q){var u=Object.assign(q[0],q[1]);return r(E,t,i,u);});}).then(j);}return o.then(d);};
b.updateBindingInfo=function(o,c){var d=C.byId(o.getFilter());if(d){var e=d.getConditions();if(e){if(!c){c={};}var p=d.getPropertyInfoSet?d.getPropertyInfoSet():null;var P=D.getParameterNames(d);var g=F.getFilterInfo(d,e,p,P);if(g){c.filters=g.filters;}var s=D.getParametersInfo(d,e);if(s){c.path=s;}}var i=d.getSearch();if(i){if(!c){c={};}if(!c.parameters){c.parameters={};}c.parameters.$search=i;}}};
b.rebindChart=function(o,c){B.rebindChart(o,c);};
b.getTypeUtil=function(p){return T;};
return b;});
sap.ui.predefine('sap/ui/mdc/odata/v4/ODataMetaModelUtil',["sap/ui/mdc/util/TypeUtil"],function(T){"use strict";var u=function(){};
u.fetchAllAnnotations=function(m,e){var c=m.getMetaContext(e);return m.requestObject("@",c).then(function(a){return a;});};
u.getAllCustomAggregates=function(a){var c={},A;for(var s in a){if(s.startsWith("@Org.OData.Aggregation.V1.CustomAggregate")){A=s.replace("@Org.OData.Aggregation.V1.CustomAggregate#","");var b=A.split("@");if(b.length==2){if(b[1]=="Org.OData.Aggregation.V1.ContextDefiningProperties"){c[b[0]].contextDefiningProperties=a[s];}if(b[1]=="com.sap.vocabularies.Common.v1.Label"){c[b[0]].label=a[s];}}else if(b.length==1){c[b[0]]={name:b[0],propertyPath:b[0],label:"Custom Aggregate ("+A+")",sortable:true,sortOrder:"both",custom:true};}}}return c;};
u.getAllAggregatableProperties=function(a){var A={},p,P;if(a["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"]){p=a["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"];for(var i=0;i<p.length;i++){P=p[i];A[P.Value]={name:P.Value,propertyPath:P.AggregatableProperty.$PropertyPath,aggregationMethod:P.AggregationMethod,label:P["@com.sap.vocabularies.Common.v1.Label"]||"Aggregatable property ("+P.Value+")",sortable:true,sortOrder:"both",custom:false};}}return A;};
u.getAllDataPoints=function(a){var d={};for(var A in a){if(A.startsWith("@com.sap.vocabularies.UI.v1.DataPoint")){var q=A.replace("@com.sap.vocabularies.UI.v1.DataPoint#","");var v=a[A].Value.$Path;d[v]=d[v]||{};d[v][q]=u.createDataPointProperty(a[A]);}}return d;};
u.createDataPointProperty=function(d){var D={};if(d.TargetValue){D.targetValue=d.TargetValue.$Path;}if(d.ForeCastValue){D.foreCastValue=d.ForeCastValue.$Path;}var c=null;if(d.Criticality){if(d.Criticality.$Path){c={Calculated:d.Criticality.$Path};}else{c={Static:d.Criticality.$EnumMember.replace("com.sap.vocabularies.UI.v1.CriticalityType/","")};}}else if(d.CriticalityCalculation){var t={};var C=u._buildThresholds(t,d.CriticalityCalculation);if(C){c={ConstantThresholds:t};}else{c={DynamicThresholds:t};}}if(c){D.criticality=c;}return D;};
u._buildThresholds=function(t,c){var k=["AcceptanceRangeLowValue","AcceptanceRangeHighValue","ToleranceRangeLowValue","ToleranceRangeHighValue","DeviationRangeLowValue","DeviationRangeHighValue"];var C=true,K;t.ImprovementDirection=c.ImprovementDirection.$EnumMember.replace("com.sap.vocabularies.UI.v1.ImprovementDirectionType/","");var d={oneSupplied:false,usedMeasures:[]};var o={oneSupplied:false};for(var i=0;i<k.length;i++){K=k[i];d[K]=c[K]?c[K].$Path:undefined;d.oneSupplied=d.oneSupplied||d[K];if(!d.oneSupplied){o[K]=c[K];o.oneSupplied=o.oneSupplied||o[K];}else if(d[K]){d.usedMeasures.push((d[K]));}}if(d.oneSupplied){C=false;for(var i=0;i<k.length;i++){if(d[k[i]]){t[k[i]]=d[k[i]];}}t.usedMeasures=d.usedMeasures;}else{var a;t.AggregationLevels=[];if(o.oneSupplied){a={VisibleDimensions:null};for(var i=0;i<k.length;i++){if(o[k[i]]){a[k[i]]=o[k[i]];}}t.AggregationLevels.push(a);}if(c.ConstantThresholds&&c.ConstantThresholds.length>0){for(var i=0;i<c.ConstantThresholds.length;i++){var A=c.ConstantThresholds[i];var v=A.AggregationLevel?[]:null;if(A.AggregationLevel&&A.AggregationLevel.length>0){for(var j=0;j<A.AggregationLevel.length;j++){v.push(A.AggregationLevel[j].$PropertyPath);}}a={VisibleDimensions:v};for(var j=0;j<k.length;j++){var n=A[k[j]];if(n){a[k[j]]=n;}}t.AggregationLevels.push(a);}}}return C;};
u.getSortRestrictionsInfo=function(s){var i,p,S={sortable:true,propertyInfo:{}};if(s){S.sortable=(s.Sortable!=null)?s.Sortable:true;if(s.NonSortableProperties){for(i=0;i<s.NonSortableProperties.length;i++){p=s.NonSortableProperties[i].$PropertyPath;S[p]={sortable:false};}}if(s.AscendingOnlyProperties){for(i=0;i<s.AscendingOnlyProperties;i++){p=s.AscendingOnlyProperties[i].$PropertyPath;S[p]={sortable:true,sortDirection:"asc"};}}if(s.AscendingOnlyProperties){for(i=0;i<s.DescendingOnlyProperties;i++){p=s.DescendingOnlyProperties[i].$PropertyPath;S[p]={sortable:true,sortDirection:"desc"};}}}return S;};
u.addSortInfoForProperty=function(p,s){var P=s[p.name];p.sortable=s.sortable&&P?P.sortable:true;if(p.sortable){p.sortDirection=P?P.sortDirection:"both";}};
u.getFilterRestrictionsInfo=function(f){var i,p,F={filterable:true,propertyInfo:{}};if(f){F.filterable=(f.Filterable!=null)?f.Filterable:true;F.requiresFilter=(f.RequiresFilter!=null)?f.RequiresFilter:false;F.requiredProperties=[];if(F.RequiredProperties){for(i=0;i<f.NonFilterableProperties;i++){p=f.NonFilterableProperties[i].$PropertyPath;F.requiredProperties.push(p);}}if(f.NonFilterableProperties){for(i=0;i<f.NonFilterableProperties.length;i++){p=f.NonFilterableProperties[i].$PropertyPath;F[p]={filterable:false};}}if(f.FilterExpressionRestrictions){for(i=0;i<f.FilterExpressionRestrictions;i++){p=f.FilterExpressionRestrictions[i].$PropertyPath;F[p]={filterable:true,allowedExpressions:f.FilterExpressionRestrictions[i].AllowedExpressions};}}}return F;};
u.isMultiValueFilterExpression=function(f){var i=true;switch(f){case"SearchExpression":case"SingleRange":case"SingleValue":i=false;break;default:break;}return i;};
u.addFilterInfoForProperty=function(p,f){var P=f[p.name];p.filterable=f.filterable&&P?P.filterable:true;if(p.filterable){p.allowedExpressions=P?P.allowedExpressions:null;}};
u.fetchCalendarTag=function(m,c){var C="@com.sap.vocabularies.Common.v1.";return Promise.all([m.requestObject(C+"IsCalendarYear",c),m.requestObject(C+"IsCalendarHalfyear",c),m.requestObject(C+"IsCalendarQuarter",c),m.requestObject(C+"IsCalendarMonth",c),m.requestObject(C+"IsCalendarWeek",c),m.requestObject(C+"IsDayOfCalendarMonth",c),m.requestObject(C+"IsDayOfCalendarYear",c),m.requestObject(C+"IsCalendarYearHalfyear",c),m.requestObject(C+"IsCalendarYearQuarter",c),m.requestObject(C+"IsCalendarYearMonth",c),m.requestObject(C+"IsCalendarYearWeek",c),m.requestObject(C+"IsCalendarDate",c)]).then(function(t){if(t[0]){return"year";}if(t[1]){return"halfYear";}if(t[2]){return"quarter";}if(t[3]){return"month";}if(t[4]){return"week";}if(t[5]){return"dayOfMonth";}if(t[6]){return"dayOfYear";}if(t[7]){return"yearHalfYear";}if(t[8]){return"yearQuarter";}if(t[9]){return"yearMonth";}if(t[10]){return"yearWeek";}if(t[11]){return"date";}return undefined;});};
u.fetchFiscalTag=function(m,c){var C="@com.sap.vocabularies.Common.v1.";return Promise.all([m.requestObject(C+"IsFiscalYear",c),m.requestObject(C+"IsFiscalPeriod",c),m.requestObject(C+"IsFiscalYearPeriod",c),m.requestObject(C+"IsFiscalQuarter",c),m.requestObject(C+"IsFiscalYearQuarter",c),m.requestObject(C+"IsFiscalWeek",c),m.requestObject(C+"IsFiscalYearWeek",c),m.requestObject(C+"IsDayOfFiscalYear",c),m.requestObject(C+"IsFiscalYearVariant",c)]).then(function(t){if(t[0]){return"year";}if(t[1]){return"period";}if(t[2]){return"yearPeriod";}if(t[3]){return"quarter";}if(t[4]){return"yearQuarter";}if(t[5]){return"week";}if(t[6]){return"yearWeek";}if(t[7]){return"dayOfYear";}if(t[8]){return"yearVariant";}return undefined;});};
u.fetchCriticality=function(m,c){var U="@com.sap.vocabularies.UI.v1";return m.requestObject(U+".ValueCriticality",c).then(function(v){var C,V;if(v){C={VeryPositive:[],Positive:[],Critical:[],VeryNegative:[],Negative:[],Neutral:[]};for(var i=0;i<v.length;i++){V=v[i];if(V.Criticality.$EnumMember.endsWith("VeryPositive")){C.VeryPositive.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Positive")){C.Positive.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Critical")){C.Critical.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("VeryNegative")){C.VeryNegative.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Negative")){C.Negative.push(V.Value);}else{C.Neutral.push(V.Value);}}for(var k in C){if(C[k].length==0){delete C[k];}}}return C;});};
return u;});
sap.ui.predefine('sap/ui/mdc/odata/v4/TypeUtil',['sap/ui/mdc/odata/TypeUtil','sap/ui/mdc/enum/BaseType'],function(O,B){"use strict";var a=Object.assign({},O);
a.getBaseType=function(t,f,c){switch(t){case"sap.ui.model.odata.type.Date":return B.Date;case"sap.ui.model.odata.type.TimeOfDay":return B.Time;case"sap.ui.model.odata.type.Unit":case"sap.ui.model.odata.type.Currency":if(!f||!f.hasOwnProperty("showMeasure")||f.showMeasure){return B.Unit;}else{return B.Numeric;}break;default:return O.getBaseType(t,f,c);}};
a.getDataTypeClassName=function(t){var e={"Edm.Date":"sap.ui.model.odata.type.Date","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};if(e[t]){t=e[t];}else{t=O.getDataTypeClassName(t);}return t;};
return a;},true);
sap.ui.predefine('sap/ui/mdc/table/RowSettings',['sap/ui/core/Element'],function(E){"use strict";
var R=E.extend("sap.ui.mdc.table.RowSettings",{metadata:{library:"sap.ui.mdc",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});
R.prototype.getAllSettings=function(){var s={},t=this.clone();if(this.isBound("navigated")){s.navigated=t.getBindingInfo("navigated");}else{s.navigated=this.getNavigated();}if(this.isBound("highlight")){s.highlight=t.getBindingInfo("highlight");}else{s.highlight=this.getHighlight();}if(this.isBound("highlightText")){s.highlightText=t.getBindingInfo("highlightText");}else{s.highlightText=this.getHighlightText();}return s;};
return R;});
sap.ui.predefine('sap/ui/mdc/util/DateUtil',['sap/ui/core/library','sap/ui/core/date/UniversalDate','sap/base/util/merge'],function(c,U,m){"use strict";var C=c.CalendarType;var D={typeToUniversalDate:function(d,t){var s=this.typeToString(d,t,"yyyyMMdd");var y=parseInt(s.slice(0,4));var M=parseInt(s.slice(4,6))-1;var i=parseInt(s.slice(6,8));var u=new U(U.UTC(y,M,i));return u;},universalDateToType:function(d,t){var y=d.getUTCFullYear();var M=d.getUTCMonth()+1;var i=d.getUTCDate();var s=y.toString()+((M<10)?"0":"")+M.toString()+((i<10)?"0":"")+i.toString();var v=this.stringToType(s,t,"yyyyMMdd");return v;},createInternalType:function(t,p){var T=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));var o=m({},t.oConstraints);var f=m({},t.oFormatOptions);if(f.style){delete f.style;}f.pattern=p;f.calendarType=C.Gregorian;if(o&&o.isDateOnly){delete o.isDateOnly;o.displayFormat="Date";}if(t.bV4){if(!o){o={};}o.V4=true;}return new T(f,o);},typeToString:function(d,t,p){var i=this.createInternalType(t,p);var s=i.formatValue(d,"string");return s;},stringToType:function(d,t,p){var i=this.createInternalType(t,p);var v=i.parseValue(d,"string");return v;},localToUtc:function(d){return new Date(Date.UTC(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes(),d.getSeconds(),d.getMilliseconds()));},utcToLocal:function(d){return new Date(d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds(),d.getUTCMilliseconds());}};return D;},true);
sap.ui.predefine('sap/ui/mdc/util/TypeUtil',['sap/ui/mdc/enum/BaseType','sap/base/util/ObjectPath'],function(B,O){"use strict";var T={getDataTypeClassName:function(t){var m={"Boolean":"sap.ui.model.type.Boolean","Currency":"sap.ui.model.type.Currency","Date":"sap.ui.model.type.Date","DateTime":"sap.ui.model.type.DateTime","Float":"sap.ui.model.type.Float","Integer":"sap.ui.model.type.Integer","String":"sap.ui.model.type.String","Time":"sap.ui.model.type.Time","Unit":"sap.ui.model.type.Unit"};if(m[t]){t=m[t];}return t;},getBaseType:function(t,f,c){switch(t){case"sap.ui.model.type.Date":return B.Date;case"sap.ui.model.type.DateTime":return B.DateTime;case"sap.ui.model.type.Time":return B.Time;case"sap.ui.model.type.Boolean":return B.Boolean;case"sap.ui.model.type.Unit":case"sap.ui.model.type.Currency":if(!f||!f.hasOwnProperty("showMeasure")||f.showMeasure){return B.Unit;}else{return B.Numeric;}break;case"sap.ui.model.type.Integer":case"sap.ui.model.type.Float":return B.Numeric;default:return B.String;}},getBaseTypeForType:function(t){return this.getBaseType(t.getMetadata&&t.getMetadata().getName(),t.oFormatOptions,t.oConstraints);},getDataTypeClass:function(d){var a=O.get(this.getDataTypeClassName(d)||"");if(!a){throw new Error("DataType '"+d+"' cannot be determined");}return a;},getDataTypeInstance:function(d,f,c){var a=this.getDataTypeClass(d);return new a(f,c);},getTypeConfig:function(t,f,c){var o,d;if(t instanceof sap.ui.model.SimpleType){o=t;}else{var D=this.getDataTypeClassName(t);d=D?t:undefined;o=this.getDataTypeInstance(D||t,f,c);}return{className:d,typeInstance:o,baseType:this.getBaseTypeForType(o)};}};return T;},true);
sap.ui.predefine('sap/ui/mdc/util/loadModules',["sap/ui/base/SyncPromise","sap/base/assert"],function(S,a){"use strict";return function l(m){a(typeof m==="string"||Array.isArray(m),"vModulePaths"+" param either must be a single string or an array of strings. - sap.ui.mdc.util.loadModules");var M;if(typeof m==="string"){M=[m];}else{M=m;}var o=new Map();M.forEach(function(s){var v=sap.ui.require(s);o.set(s,v);});var n=M.filter(function(s){return o.get(s)===undefined;});if(n.length===0){var b=Array.from(o.values());return S.resolve(b);}return new S(function(r,c){function d(){var N=Array.from(arguments);n.forEach(function(s,i){o.set(s,N[i]);});var b=Array.from(o.values());r(b);}sap.ui.require(n,d,c);});};});
sap.ui.require.preload({
	"sap/ui/mdc/field/ValueHelpPanel.control.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:fl="sap.ui.fl.variants" xmlns:mvc="sap.ui.core.mvc" xmlns:mdc="sap.ui.mdc" xmlns:l="sap.ui.layout"><VBox id="rootVBox" fitContainer="true" class="sapMdcValueHelpPanel"><IconTabBar id="iconTabBar" expandable="false" upperCase="false" stretchContentHeight="true" class="sapUiNoContentPadding" select="iconTabSelect"><layoutData><FlexItemData growFactor="1" shrinkFactor="1"/></layoutData><items><IconTabFilter id="fromList" text="{parts:[\'$i18n&gt;valuehelp.SELECTFROMLIST\',\'$this&gt;/conditions\'],formatter:\'._formatListTabTitle\'}" key="selectFromList" visible="false"><l:FixFlex><l:fixContent><Toolbar id="toolbar" width="100%" visible="{= ${$this&gt;/searchEnabled} || ${$this&gt;/showFilterbar}}"><mdc:FilterField id="SearchField" dataType="sap.ui.model.type.String" maxConditions="1" conditions="{path:\'$this&gt;/filterConditions\'}" placeholder="{$i18n&gt;filterbar.SEARCH}" width="50%" visible="{$this&gt;/searchEnabled}" submit="_handleSearch"/><ToolbarSpacer/><Button id="AdvancedFilter" type="Transparent" press="_onToggleAdvancedFilter" visible="{$this&gt;/showFilterbar}"><layoutData><ToolbarLayoutData shrinkable="true"/></layoutData></Button><Button id="Go" press="_onGo" text="{$i18n&gt;filterbar.GO}" type="Emphasized" visible="{$this&gt;/showFilterbar}"/></Toolbar><VBox id="filterbarVBox" visible="{$this&gt;/_filterBarVisible}"/></l:fixContent><l:flexContent><Panel id="tablePanel" headerText="{parts:[\'$i18n&gt;valuehelp.TABLETITLE\'],formatter:\'._formatTableTitle\'}" class="sapMdcTablePanel" expanded="true" height="100%"><layoutData><FlexItemData growFactor="1" shrinkFactor="1" minHeight="100%"/></layoutData></Panel></l:flexContent></l:FixFlex></IconTabFilter><IconTabFilter id="defineCondition" text="{parts:[\'$i18n&gt;valuehelp.DEFINECONDITIONS\',\'$this&gt;/conditions\'],formatter:\'._formatDefineTabTitle\'}" key="defineCondition" visible="false"><ScrollContainer id="defineConditionPanel" height="100%" horizontal="false" vertical="true"/></IconTabFilter></items></IconTabBar><Panel id="VHPTokenizerPanel" class="sapMdcTokenizerPanel" backgroundDesign="Transparent" expanded="true" headerText="{parts:[\'$i18n&gt;valuehelp.TOKENIZERTITLE\',\'$this&gt;/conditions\'],formatter:\'._formatTokenizerTitle\'}"><HBox fitContainer="true" width="100%"><items><Tokenizer id="VHPTokenizer" class="sapMdcTokenizer" width="100%" visible="{path:\'$this&gt;/showTokenizer\'}" tokenUpdate="_handleTokenUpdate" tokens="{path:\'$this&gt;/conditions\',filters:[{path:\'isEmpty\',operator:\'NE\',value1:true}],templateShareable:false}"><Token id="VHPToken" text="{path:\'$this&gt;\',type:\'sap.ui.mdc.field.ConditionType\'}"/><layoutData><FlexItemData growFactor="1" maxWidth="calc(100% - 2rem)"/></layoutData></Tokenizer><Button id="removeAllBtn" press="_onRemoveAllConditions" type="Transparent" icon="sap-icon://decline" tooltip="{$i18n&gt;valuehelp.REMOVEALLTOKEN}" class="sapUiTinyMarginBegin"><layoutData><FlexItemData growFactor="0" baseSize="2rem"/></layoutData></Button></items></HBox></Panel></VBox></core:FragmentDefinition>',
	"sap/ui/mdc/link/ContactDetails.control.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:f="sap.ui.layout.form"><m:VBox items="{path:\'$this&gt;/items\',templateShareable:false}" aria-labelledby="IDContactDetailsTitle"><f:SimpleForm id="IDSimpleForm" editable="false" layout="ResponsiveGridLayout"><core:Title id="IDContactDetailsTitle" text="{$this&gt;sectionTitle}"/><m:Label text="" labelFor="IDImage" visible="{= !!${$this&gt;photo}}"/><m:Image id="IDImage" src="{$this&gt;photo}" decorative="false" width="5rem" height="5rem" visible="{= !!${$this&gt;photo}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_NAME}" labelFor="IDName" visible="{= !!${$this&gt;formattedName}}"/><m:Text id="IDName" text="{$this&gt;formattedName}" visible="{= !!${$this&gt;formattedName}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_ROLE}" labelFor="IDRole" visible="{= !!${$this&gt;role}}"/><m:Text id="IDRole" text="{$this&gt;role}" visible="{= !!${$this&gt;role}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_JOBTITLE}" labelFor="IDTitle" visible="{= !!${$this&gt;title}}"/><m:Text id="IDTitle" text="{$this&gt;title}" visible="{= !!${$this&gt;title}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_DEPARTMENT}" labelFor="IDOrg" visible="{= !!${$this&gt;org}}"/><m:Text id="IDOrg" text="{$this&gt;org}" visible="{= !!${$this&gt;org}}"/></f:SimpleForm></m:VBox></core:FragmentDefinition>',
	"sap/ui/mdc/link/Panel.control.xml":'<core:FragmentDefinition xmlns:mdcLink="sap.ui.mdc.link" xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout"><l:VerticalLayout width="calc(100% - 2rem)" class="mdcbaseinfoPanel"><m:VBox id="idSectionAdditionalContent" fitContainer="false"/><m:VBox fitContainer="false" class="mdcbaseinfoPanelSeparator" visible="{= ${$sapuimdclinkPanel&gt;/countAdditionalContent} &gt; 0 &amp;&amp; ${$sapuimdcLink&gt;/metadata}.length &gt; 0}"/><m:VBox id="idSectionLinks" fitContainer="false" class="mdcbaseinfoPanelSectionLinks" items="{path:\'$sapuimdclinkPanel&gt;/runtimeItems\',templateShareable:false}"><mdcLink:PanelListItem key="{$sapuimdclinkPanel&gt;id}" visible="{$sapuimdclinkPanel&gt;visible}" text="{$sapuimdclinkPanel&gt;text}" description="{$sapuimdclinkPanel&gt;description}" href="{$sapuimdclinkPanel&gt;href}" icon="{$sapuimdclinkPanel&gt;icon}" target="{$sapuimdclinkPanel&gt;target}" pressLink="onPressLink"/></m:VBox><m:HBox visible="{= ${$sapuimdcLink&gt;/metadata}.length &gt; 0}" id="idSectionPersonalizationButton" justifyContent="End" class="mdcbaseinfoPanelPersonalizationButton"><m:Button id="idPersonalizationButton" type="Transparent" text="{$this.i18n&gt;info.POPOVER_DEFINE_LINKS}" press="onPressLinkPersonalization"/></m:HBox></l:VerticalLayout></core:FragmentDefinition>',
	"sap/ui/mdc/link/PanelListItem.control.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout"><l:HorizontalLayout id="idLayout" class="mdcbaseinfoPanelListItem"><m:HBox id="idContainer" visible="{$this&gt;visible}"><m:layoutData><m:FlexItemData styleClass="{= ${$this&gt;description} ? \'mdcbaseinfoPanelItemsGroup\' : \'mdcbaseinfoPanelItemsWithoutGroup\'}"/></m:layoutData><m:ImageContent src="{$this&gt;icon}" visible="{= ${$this&gt;icon} ? true:false}"/><m:VBox><m:Link text="{$this&gt;text}" href="{$this&gt;href}" target="{$this&gt;target}" visible="{= ${$this&gt;href} ? true:false}" press="onPress" wrapping="true"/><m:Label text="{$this&gt;text}" visible="{= ${$this&gt;href} ? false:true}" wrapping="true"/><m:Text text="{$this&gt;description}" visible="{= ${$this&gt;description} ? true:false}" wrapping="true"/></m:VBox></m:HBox></l:HorizontalLayout></core:FragmentDefinition>',
	"sap/ui/mdc/link/SelectionDialog.control.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:mdcLink="sap.ui.mdc.link" xmlns:core="sap.ui.core"><m:Dialog horizontalScrolling="false" contentWidth="25rem" contentHeight="35rem" draggable="true" resizable="true" title="{$this.i18n&gt;info.SELECTION_DIALOG_ALIGNEDTITLE}" stretch="{device&gt;/system/phone}" afterClose="onAfterClose" class="mdcbaseinfoSelectionDialog"><m:content><m:Table id="idList" mode="MultiSelect" includeItemInSelection="false" selectionChange="onSelectionChange" items="{path:\'$this&gt;/items\',templateShareable:false}"><m:headerToolbar><m:OverflowToolbar><m:SearchField id="idSearchField" liveChange="onSearchFieldLiveChange" width="100%"><m:layoutData><m:OverflowToolbarLayoutData shrinkable="true" moveToOverflow="true" priority="High"/></m:layoutData></m:SearchField></m:OverflowToolbar></m:headerToolbar><m:columns><m:Column><m:Text text="{$this.i18n&gt;info.SELECTION_DIALOG_INFO_TOOLBAR} ({path:\'$this&gt;/@custom/countOfSelectedItems\'}/{path:\'$this&gt;/@custom/countOfItems\'}) "/></m:Column></m:columns><m:items><m:ColumnListItem id="idListItem" selected="{path:\'$this&gt;visible\'}"><mdcLink:PanelListItem visible="true" text="{$this&gt;text}" description="{$this&gt;description}" href="{= ${$this&gt;/showItemAsLink} ? ${$this&gt;href}:null}" target="{$this&gt;target}" icon="{$this&gt;icon}" pressLink="onPressLink"/></m:ColumnListItem></m:items></m:Table></m:content><m:buttons><m:Button id="idOk" text="{$this.i18n&gt;p13nDialog.OK}" press="onPressOk" type="Emphasized"><m:layoutData><m:OverflowToolbarLayoutData priority="NeverOverflow"/></m:layoutData></m:Button><m:Button id="idCancel" text="{$this.i18n&gt;p13nDialog.CANCEL}" press="onPressCancel"><m:layoutData><m:OverflowToolbarLayoutData priority="NeverOverflow"/></m:layoutData></m:Button><m:Button visible="{$this&gt;/showReset}" enabled="{$this&gt;/showResetEnabled}" id="idReset" text="{$this.i18n&gt;p13nDialog.RESET}" press="onPressReset"><m:layoutData><m:OverflowToolbarLayoutData priority="NeverOverflow"/></m:layoutData></m:Button></m:buttons></m:Dialog></core:FragmentDefinition>',
	"sap/ui/mdc/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.mdc","type":"library","embeds":[],"applicationVersion":{"version":"1.84.17"},"title":"UI5 library: sap.ui.mdc","description":"UI5 library: sap.ui.mdc","ach":"CA-UI5-CMP","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.17"},"sap.m":{"minVersion":"1.84.17"},"sap.ui.layout":{"minVersion":"1.84.17","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.mdc.Chart","sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.field.ValueHelpPanel","sap.ui.mdc.field.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.link.Panel","sap.ui.mdc.link.ContactDetails"],"elements":["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.V4AnalyticsTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.DimensionItem","sap.ui.mdc.chart.MeasureItem","sap.ui.mdc.field.CustomFieldHelp","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldHelpBase","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.FieldValueHelp","sap.ui.mdc.field.FieldValueHelpContentWrapperBase","sap.ui.mdc.field.FieldValueHelpMTableWrapper","sap.ui.mdc.field.ListFieldHelp","sap.ui.mdc.field.BoolFieldHelp","sap.ui.mdc.field.ConditionFieldHelp","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.link.ContactDetailsAddressItem","sap.ui.mdc.link.ContactDetailsEmailItem","sap.ui.mdc.link.ContactDetailsItem","sap.ui.mdc.link.ContactDetailsPhoneItem","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.InParameter","sap.ui.mdc.field.OutParameter"],"types":["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.TableRowAction","sap.ui.mdc.FilterExpression"],"interfaces":["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState"]}}}}'
},"sap/ui/mdc/library-preload"
);
//# sourceMappingURL=library-preload.js.map