/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/base/DataType","sap/base/Log","sap/base/util/deepClone","sap/base/util/isPlainObject"],function(B,D,L,d,a){"use strict";var A={name:{type:"string",mandatory:true,allowedForComplexProperty:true},label:{type:"string",mandatory:true,allowedForComplexProperty:true},path:{type:"string",defaultValue:"attribute:name"},groupLabel:{type:"string",defaultValue:"",allowedForComplexProperty:true},visible:{type:"boolean",defaultValue:true,allowedForComplexProperty:true},propertyInfos:{type:"string[]",allowedForComplexProperty:true},exportSettings:{type:"object",defaultValue:null,allowedForComplexProperty:true},typeConfig:{type:"object",defaultValue:null},maxConditions:{type:"int",defaultValue:null},filterable:{type:"boolean",defaultValue:true},sortable:{type:"boolean",defaultValue:true},fieldHelp:{type:"string",defaultValue:""}};var m=Object.keys(A).filter(function(h){return A[h].mandatory;});var _=new WeakMap();function s(o){return JSON.stringify(o,function(k,v){return v===undefined?null:v;})||"";}function r(M,o){var h=s(o);L.warning("Invalid property definition: "+M+(h?"\n"+h:""));}function t(M,o){var h=s(o);throw new Error("Invalid property definition: "+M+(h?"\n"+h:""));}function c(h){var C=[];h.forEach(function(o){var i;var T;if(o.typeConfig&&"typeInstance"in o.typeConfig){T=o.typeConfig.typeInstance;delete o.typeConfig.typeInstance;}i=d(o);if(T){o.typeConfig.typeInstance=T;i.typeConfig.typeInstance=T;}C.push(i);});return Object.freeze(C);}function b(o){var k=Object.getOwnPropertyNames(o);for(var i=0;i<k.length;i++){var v=o[k[i]];if(a(v)||Array.isArray(v)){if(k[i]==="_relatedProperties"){Object.freeze(v);}else{b(v);}}}return Object.freeze(o);}function p(h,i){h.forEach(function(o){var j=[];var I=g(o);for(var k in A){var l=A[k];if(I&&!l.allowedForComplexProperty){continue;}if("defaultValue"in l&&o[k]==null){if(typeof l.defaultValue==="string"&&l.defaultValue.startsWith("attribute:")){j.push({source:l.defaultValue.substring(l.defaultValue.indexOf(":")+1),target:k});}else{o[k]=l.defaultValue;}}}j.forEach(function(n){o[n.target]=o[n.source];});if(I){Object.defineProperty(o,"_relatedProperties",{value:o.propertyInfos.map(function(K){return i[K];})});}b(o);});}function e(h){var i={};h.forEach(function(o){i[o.name]=o;});return Object.freeze(i);}function f(o,v,F){var h=o.getProperty(v);if(o.isComplex(h)){return o.getPropertiesFromComplexProperty(h).filter(function(h){return F.call(o,h);});}else if(F.call(o,h)){return[h];}return h?[]:null;}var P=B.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(h,o){B.call(this);var i=B.isA(o,["sap.ui.base.ManagedObject"]);if(o!=null&&!i){throw new Error("The type of the parent is invalid");}this.validateProperties(h);var C=c(h);_.set(this,{oParent:i?o:null,aProperties:C,mProperties:e(C)});p(_.get(this).aProperties,_.get(this).mProperties);}});P.prototype.validateProperties=function(h){if(!Array.isArray(h)){t("Property infos must be an array.");}var u=new Set();for(var i=0;i<h.length;i++){this.validateProperty(h[i],h);u.add(h[i].name);}if(u.size!==h.length){t("Properties do not have unique names.");}};P.prototype.validateProperty=function(o,h){if(!a(o)){t("Property info must be a plain object.",o);}var i;var I=g(o);for(i in o){if(!(i in A)){r("Property contains invalid attribute '"+i+"'.",o);}else if(I&&!A[i].allowedForComplexProperty){r("Complex property contains invalid attribute '"+i+"'.",o);}else if(!D.getType(A[i].type).isValid(o[i])&&(A[i].mandatory||o[i]!=null)){t("The value of '"+i+"' is invalid.",o);}}m.forEach(function(M){if(!(M in o)){r("Property does not contain mandatory attribute '"+M+"'.",o);}});if(I){var S=o.propertyInfos;var u=new Set(S);if(S.length===0){t("Complex property does not reference existing properties",S);}if(u.size!==S.length){t("Complex property contains duplicate keys in the 'propertyInfos' attribute.",S);}h.forEach(function(C){if(u.has(C.name)){if(g(C)){t("Complex property references other complex properties.",C);}u.delete(C.name);}});if(u.size>0){t("Complex property references non-existing properties.",o);}}};P.prototype.getParent=function(){var o=_.get(this);return o?o.oParent:null;};P.prototype.getProperties=function(){var o=_.get(this);return o?o.aProperties:null;};P.prototype.getPropertyMap=function(){var o=_.get(this);return o?o.mProperties:null;};P.prototype.getProperty=function(v){var h=this.getPropertyMap();if(typeof v==="string"){return h[v]||null;}if(v&&v.name&&typeof v.name==="string"){var F=h[v.name];if(F&&F===v){return F;}}return null;};P.prototype.isComplex=function(v){var o=this.getProperty(v);return o?g(o):null;};function g(o){return o?"propertyInfos"in o:false;}P.prototype.getKeysFromComplexProperty=function(v){var o=this.getProperty(v);return o?o.propertyInfos||[]:null;};P.prototype.getPropertiesFromComplexProperty=function(v){var o=this.getProperty(v);return o?o._relatedProperties||[]:null;};P.prototype.isSortable=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return false;}return o?o.sortable:null;};P.prototype.getSortableProperties=function(v){return f(this,v,this.isSortable);};P.prototype.getAllSortableProperties=function(){return this.getProperties().filter(function(o){return this.isSortable(o);},this);};P.prototype.isFilterable=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return false;}return o?o.filterable:null;};P.prototype.getFilterableProperties=function(v){return f(this,v,this.isFilterable);};P.prototype.getAllFilterableProperties=function(){return this.getProperties().filter(function(o){return this.isFilterable(o);},this);};P.prototype.getLabel=function(v){var o=this.getProperty(v);return o?o.label:null;};P.prototype.getGroupLabel=function(v){var o=this.getProperty(v);return o?o.groupLabel:null;};P.prototype.getPath=function(v){var o=this.getProperty(v);if(this.isComplex(o)){return null;}return o?o.path:null;};P.prototype.isVisible=function(v){var o=this.getProperty(v);return o?o.visible:null;};P.prototype.getVisibleProperties=function(v){return f(this,v,this.isVisible);};P.prototype.getAllVisibleProperties=function(){return this.getProperties().filter(function(o){return this.isVisible(o);},this);};P.prototype.getExportSettings=function(v){var o=this.getProperty(v);return o&&o.exportSettings?o.exportSettings:null;};P.prototype.getName=function(v){var o=this.getProperty(v);return o?o.name:null;};P.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);_.delete(this);};return P;});
