/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_ODataMetaModelUtils","sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/base/EventProvider","sap/ui/core/cache/CacheManager","sap/ui/thirdparty/datajs","sap/ui/thirdparty/jquery"],function(U,a,L,e,b,u,E,C,O,q){"use strict";var c="sap.ui.model.odata.ODataMetadata";var d=E.extend("sap.ui.model.odata.ODataMetadata",{constructor:function(m,p){E.apply(this,arguments);this.bLoaded=false;this.bFailed=false;this.mEntityTypes={};this.mRequestHandles={};this.sUrl=m;this.bAsync=p.async;this.sUser=p.user;this.bWithCredentials=p.withCredentials;this.sPassword=p.password;this.mHeaders=p.headers;this.sCacheKey=p.cacheKey;this.oLoadEvent=null;this.oFailedEvent=null;this.oMetadata=null;this.bMessageScopeSupported=false;this.mNamespaces=p.namespaces||{sap:"http://www.sap.com/Protocols/SAPData",m:"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata","":"http://schemas.microsoft.com/ado/2007/06/edmx"};var t=this;this.pLoadedWithReject=new Promise(function(r,f){t.fnResolve=r;t.fnReject=f;});this.pLoaded=this.pLoadedWithReject.catch(function(o){return new Promise(function(r,f){t.fnResolve=r;});});function w(p){C.set(t.sCacheKey,JSON.stringify({metadata:t.oMetadata,params:p}));}function l(o){L.error("[ODataMetadata] initial loading of metadata failed");if(o&&o.message){L.error("Error: "+o.message);}}if(this.sCacheKey){C.get(this.sCacheKey).then(function(M){if(M){var o=JSON.parse(M);this.oMetadata=o.metadata;this._handleLoaded(this.oMetadata,o.params,false);}else{this._loadMetadata().then(w).catch(l);}}.bind(this)).catch(l);}else{this._loadMetadata().catch(l);}},metadata:{publicMethods:["getServiceMetadata","attachFailed","detachFailed","attachLoaded","detachLoaded","refresh"]}});d._returnsCollection=function(f){if(f&&f.returnType&&f.returnType.startsWith("Collection(")){return true;}return false;};d.prototype._setNamespaces=function(n){this.mNamespaces=n;};d.prototype._handleLoaded=function(m,p,s){var f=[];this.oMetadata=this.oMetadata?this.merge(this.oMetadata,m,f):m;this.oRequestHandle=null;p.entitySets=f;this.fnResolve(p);if(this.bAsync&&!s){this.fireLoaded(this);}else if(!this.bAsync&&!s){this.bLoaded=true;this.bFailed=false;this.oLoadEvent=setTimeout(this.fireLoaded.bind(this,p),0);}};d.prototype._loadMetadata=function(s,S){var t=this;s=s||this.sUrl;var r=this._createRequest(s);return new Promise(function(f,h){var R;function _(m,o){if(!m||!m.dataServices){var p={message:"Invalid metadata document",request:r,response:o};i(p);return;}t.sMetadataBody=o.body;t.oRequestHandle=null;var P={metadataString:t.sMetadataBody};var l=o.headers["Last-Modified"];if(l){P.lastModified=l;}var j=o.headers["eTag"];if(j){P.eTag=j;}t._handleLoaded(m,P,S);f(P);}function i(o){var p={message:o.message,request:o.request,response:o.response};if(o.response){p.statusCode=o.response.statusCode;p.statusText=o.response.statusText;p.responseText=o.response.body;}if(R&&R.bSuppressErrorHandlerCall){return;}if(t.bAsync){delete t.mRequestHandles[R.id];}h(p);t.fnReject(p);if(t.bAsync&&!S){t.fireFailed(p);}else if(!t.bAsync&&!S){t.bFailed=true;t.oFailedEvent=setTimeout(t.fireFailed.bind(t,p),0);}}R=O.request(r,_,i,O.metadataHandler);if(t.bAsync){R.id=u();t.mRequestHandles[R.id]=R;}});};d.prototype.refresh=function(){return this._loadMetadata();};d.prototype.getServiceMetadata=function(){return this.oMetadata;};d.prototype.isLoaded=function(){return this.bLoaded;};d.prototype.loaded=function(r){return r?this.pLoadedWithReject:this.pLoaded;};d.prototype.isFailed=function(){return this.bFailed;};d.prototype.fireLoaded=function(p){this.bLoaded=true;this.bFailed=false;this.fireEvent("loaded",p);L.debug(this+" - loaded was fired");return this;};d.prototype.attachLoaded=function(D,f,l){this.attachEvent("loaded",D,f,l);return this;};d.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};d.prototype.fireFailed=function(p){this.bFailed=true;this.fireEvent("failed",p);return this;};d.prototype.attachFailed=function(D,f,l){this.attachEvent("failed",D,f,l);return this;};d.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};d.prototype._getEntityAssociationEnd=function(o,n){var s;if(!this._checkMetadataLoaded()){return null;}this._mGetEntityAssociationEndCache=this._mGetEntityAssociationEndCache||{};s=o.namespace+"."+o.name+"/"+n;if(this._mGetEntityAssociationEndCache[s]===undefined){var N=o?U.findObject(o.navigationProperty,n):null,A=N?U.getObject(this.oMetadata.dataServices.schema,"association",N.relationship):null,f=A?U.findObject(A.end,N.toRole,"role"):null;this._mGetEntityAssociationEndCache[s]=f;}return this._mGetEntityAssociationEndCache[s];};function g(s){var m={};for(var i=0;i<s.length;i++){var S=s[i];if(S.entityContainer){for(var j=0;j<S.entityContainer.length;j++){var o=S.entityContainer[j];if(o.entitySet){for(var k=0;k<o.entitySet.length;k++){if(o.entitySet[k].name!=null){m[o.entitySet[k].name]=o.entitySet[k];}}}}}}return m;}d.prototype._findEntitySetByName=function(n){if(!this.mEntitySets){this.mEntitySets=g(this.oMetadata.dataServices.schema);}return this.mEntitySets[n];};d.prototype._getEntityTypeByPath=function(p){if(!p){a(undefined,"sPath not defined!");return null;}if(this.mEntityTypes[p]){return this.mEntityTypes[p];}if(!this._checkMetadataLoaded()){return null;}var s=p.replace(/^\/|\/$/g,""),P=s.split("/"),l=P.length,o,f,h,r,t=this;if(P[0].indexOf("(")!=-1){P[0]=P[0].substring(0,P[0].indexOf("("));}if(l>1){o=t._getEntityTypeByPath(P[0]);for(var i=1;i<P.length;i++){if(o){if(P[i].indexOf("(")!=-1){P[i]=P[i].substring(0,P[i].indexOf("("));}r=t._getEntityTypeByNavProperty(o,P[i]);if(r){o=r;}h=o;}}}else{f=this._splitName(this._getEntityTypeName(P[0]));h=this._getObjectMetadata("entityType",f.name,f.namespace);if(h){h.entityType=this._getEntityTypeName(P[0]);}}if(!h){var F=P[P.length-1];var j=this._getFunctionImportMetadata(F,"GET");if(!j){j=this._getFunctionImportMetadata(F,"POST");}if(j&&j.entitySet){h=Object.assign({},this._getEntityTypeByPath(j.entitySet));if(h){h.entityType=this._getEntityTypeName(j.entitySet);h.isFunction=true;}}}if(h){this.mEntityTypes[p]=h;}return h;};d.prototype._getEntityTypeByName=function(n){var o,t=this,s,N,f;if(!n){a(undefined,"sName not defined!");return null;}f=this._splitName(n);N=f.namespace;s=f.name;if(!this._checkMetadataLoaded()){return null;}if(this.mEntityTypes[n]){o=this.mEntityTypes[n];}else{q.each(this.oMetadata.dataServices.schema,function(i,S){if(S.entityType&&(!N||S.namespace===N)){q.each(S.entityType,function(k,h){if(h.name===s){o=h;t.mEntityTypes[n]=o;o.namespace=S.namespace;return false;}});}});}return o;};d.prototype._checkMetadataLoaded=function(){if(!this.oMetadata||b(this.oMetadata)){a(undefined,"No metadata loaded!");return false;}return true;};d.prototype._getAnnotation=function(p){var n,P,m,M,o,s,f;P=p.split('/#');M=P[1].split('/');if(!P[0]){o=this._getEntityTypeByName(M[0]);a(o,M[0]+" is not a valid EntityType");if(!o){return;}s=P[1].substr(P[1].indexOf('/')+1);f=this._getPropertyMetadata(o,s);a(f,s+" is not a valid property path");if(!f){return;}m=s.substr(s.indexOf(f.name));m=m.substr(m.indexOf('/')+1);}else{o=this._getEntityTypeByPath(P[0]);a(o,P[0]+" is not a valid path");if(!o){return;}p=P[0].replace(/^\/|\/$/g,"");s=p;while(!f&&s.indexOf("/")>0){s=s.substr(s.indexOf('/')+1);f=this._getPropertyMetadata(o,s);}a(f,s+" is not a valid property path");if(!f){return;}m=M.join('/');}n=this._getAnnotationObject(o,f,m);return n;};d.prototype._getAnnotationObject=function(o,f,m){var A,p,h,n,s;if(!f){return;}n=f;p=m.split('/');if(p[0].indexOf('.')>-1){return this._getV4AnnotationObject(o,f,p);}else{if(p.length>1){n=n[p[0]];if(!n&&f.extensions){for(var i=0;i<f.extensions.length;i++){var j=f.extensions[i];if(j.name==p[0]){n=j;break;}}}m=p.splice(0,1);h=this._getAnnotationObject(o,n,p.join('/'));}else{if(p[0].indexOf('@')>-1){s=p[0].substr(1);A=s.split(':');h=n[A[0]];if(!h&&n.extensions){for(var i=0;i<n.extensions.length;i++){var j=n.extensions[i];if(j.name===A[1]&&j.namespace===this.mNamespaces[A[0]]){h=j.value;break;}}}}else{A=p[0].split(':');h=n[A[0]];h=n[p[0]];if(!h&&n.extensions){for(var i=0;i<n.extensions.length;i++){var j=n.extensions[i];if(j.name===A[1]&&j.namespace===this.mNamespaces[A[0]]){h=j;break;}}}}}}return h;};d.prototype._getV4AnnotationObject=function(o,f,p){var A,h=[];if(p.length>1){a(p.length==1,"'"+p.join('/')+"' is not a valid annotation path");return;}var t=o.namespace?o.namespace+".":"";t+=o.name+"/"+f.name;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.annotations){q.each(s.annotations,function(k,f){if(f.target===t&&!f.qualifier){h.push(f.annotation);return false;}});}});if(h){q.each(h,function(i,k){q.each(k,function(j,l){if(l.term===p[0]){A=l;}});});}return A;};d.prototype._splitName=function(f){var i={};if(f){var s=f.lastIndexOf(".");i.name=f.substr(s+1);i.namespace=f.substr(0,s);}return i;};d.prototype._getEntityTypeName=function(s){var f,o;if(s){o=this._findEntitySetByName(s);if(o){f=o.entityType;}}return f;};d.prototype._getObjectMetadata=function(o,s,n){var f;if(s&&n){q.each(this.oMetadata.dataServices.schema,function(i,S){if(S[o]&&S.namespace===n){q.each(S[o],function(j,h){if(h.name===s){f=h;f.namespace=S.namespace;return false;}});return!f;}});}return f;};d.prototype.getUseBatch=function(){var f=false;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.entityContainer){q.each(s.entityContainer,function(k,o){if(o.extensions){q.each(o.extensions,function(l,h){if(h.name==="use-batch"&&h.namespace==="http://www.sap.com/Protocols/SAPData"){f=(typeof h.value==='string')?(h.value.toLowerCase()==='true'):!!h.value;return false;}});}});}});return f;};d.prototype._getFunctionImportMetadataIterate=function(f,s){var o=[];e(this.oMetadata.dataServices.schema,function(S,h){if(h["entityContainer"]){e(h["entityContainer"],function(i,j){if(j["functionImport"]){e(j["functionImport"],function(F,k){if(f(k)){o.push(k);if(s){return false;}}});}return!(s&&o.length===1);});}return!(s&&o.length===1);});return o;};d.prototype._getFirstMatchingFunctionImportMetadata=function(f){var o=this._getFunctionImportMetadataIterate(f,true);return o.length===1?o[0]:null;};d.prototype._getFunctionImportMetadataByName=function(f){if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}return this._getFunctionImportMetadataIterate(function(F){return F.name===f;});};d.prototype._getFunctionImportMetadata=function(f,m){if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}return this._getFirstMatchingFunctionImportMetadata(function(F){return F.name===f&&F.httpMethod===m;});};d.prototype._getEntityTypeByNavProperty=function(m,n){if(!m.navigationProperty){return undefined;}for(var i=0;i<m.navigationProperty.length;++i){var N=m.navigationProperty[i];if(N.name===n){return this._getEntityTypeByNavPropertyObject(N);}}return undefined;};d.prototype._getEntityTypeByNavPropertyObject=function(n){var t;var A=this._splitName(n.relationship);var m=this._getObjectMetadata("association",A.name,A.namespace);if(m){var f=m.end[0];if(f.role!==n.toRole){f=m.end[1];}var o=this._splitName(f.type);t=this._getObjectMetadata("entityType",o.name,o.namespace);if(t){t.entityType=f.type;}}return t;};d.prototype._getNavigationPropertyNames=function(o){var n=[];if(o.navigationProperty){q.each(o.navigationProperty,function(k,N){n.push(N.name);});}return n;};d.prototype._getNavPropertyRefInfo=function(o,p){var n,A,f,h,P,D,j,r,k,s,K,t=this;e(o.navigationProperty,function(i,N){f=t._splitName(N.relationship);A=t._getObjectMetadata("association",f.name,f.namespace);if(!A||!A.referentialConstraint){return;}D=A.referentialConstraint.dependent;k=A.end.find(function(k){return k.role===D.role;});if(k.type!==o.namespace+"."+o.name){return;}j=D.propertyRef.some(function(l){return l.name===p;});if(!j){return;}P=A.referentialConstraint.principal;r=P.role;h=t._getAssociationSetByAssociation(N.relationship);k=h.end.find(function(k){return k.role===r;});s=k.entitySet;K=P.propertyRef.map(function(l){return l.name;});n={name:N.name,entitySet:s,keys:K};});return n;};d.prototype._getPropertyMetadata=function(o,p){var P,t=this;if(!o){return;}p=p.replace(/^\/|\/$/g,"");var f=p.split("/");q.each(o.property,function(k,h){if(h.name===f[0]){P=h;return false;}});if(f.length>1){if(!P){while(o&&f.length>1){o=this._getEntityTypeByNavProperty(o,f[0]);f.shift();}if(o){P=t._getPropertyMetadata(o,f[0]);}}else if(!P.type.toLowerCase().startsWith("edm.")){var n=this._splitName(P.type);P=this._getPropertyMetadata(this._getObjectMetadata("complexType",n.name,n.namespace),f[1]);}}return P;};d.prototype.destroy=function(){delete this.oMetadata;var t=this;q.each(this.mRequestHandles,function(k,r){r.bSuppressErrorHandlerCall=true;r.abort();delete t.mRequestHandles[k];});if(!!this.oLoadEvent){clearTimeout(this.oLoadEvent);}if(!!this.oFailedEvent){clearTimeout(this.oFailedEvent);}E.prototype.destroy.apply(this,arguments);};d.prototype._fillElementCaches=function(){var t=this;if(this._entitySetMap||!this._checkMetadataLoaded()){return;}this._entitySetMap={};this.oMetadata.dataServices.schema.forEach(function(s){(s.entityContainer||[]).forEach(function(m){(m.entitySet||[]).forEach(function(f){var o=t._getEntityTypeByName(f.entityType);o.__navigationPropertiesMap={};(o.navigationProperty||[]).forEach(function(p){o.__navigationPropertiesMap[p.name]=p;});f.__entityType=o;t._entitySetMap[f.entityType]=f;});});});};d.prototype._createRequest=function(s){var D={"sap-cancel-on-close":true},l={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()};q.extend(D,this.mHeaders,l);var r={headers:D,requestUri:s,method:'GET',user:this.sUser,password:this.sPassword,async:this.bAsync};if(this.bAsync){r.withCredentials=this.bWithCredentials;}return r;};d.prototype._getEntitySetByPath=function(s){var o;this._fillElementCaches();o=this._getEntityTypeByPath(s);if(o){return this._entitySetMap[o.entityType];}};d.prototype._addUrl=function(v){var f=[].concat(v);return Promise.all(f.map(function(s){return this._loadMetadata(s,true);},this));};d.prototype.merge=function(t,s,f){var h=this;if(this.mEntitySets){delete this.mEntitySets;}q.each(t.dataServices.schema,function(i,T){q.each(s.dataServices.schema,function(j,S){if(S.namespace===T.namespace){if(S.entityType){if(!h.mEntityTypeNames){h.mEntityTypeNames={};T.entityType.map(function(o){h.mEntityTypeNames[o.name]=true;});}T.entityType=!T.entityType?[]:T.entityType;for(var i=0;i<S.entityType.length;i++){if(!(S.entityType[i].name in h.mEntityTypeNames)){T.entityType.push(S.entityType[i]);h.mEntityTypeNames[S.entityType[i].name]=true;}}}if(T.entityContainer&&S.entityContainer){q.each(T.entityContainer,function(k,m){q.each(S.entityContainer,function(l,n){if(n.entitySet){if(n.name===m.name){if(!h.mEntitySetNames){h.mEntitySetNames={};m.entitySet.map(function(o){h.mEntitySetNames[o.name]=true;});}m.entitySet=!m.entitySet?[]:m.entitySet;for(var i=0;i<n.entitySet.length;i++){if(!(n.entitySet[i].name in h.mEntitySetNames)){m.entitySet.push(n.entitySet[i]);h.mEntitySetNames[n.entitySet[i].name]=true;}}n.entitySet.forEach(function(o){f.push(o);});}}});});}if(S.annotations){T.annotations=!T.annotations?[]:T.annotations;T.annotations=T.annotations.concat(S.annotations);}}});});return t;};d.prototype._getEntitySetByType=function(f){var s=f.namespace+"."+f.name;var S=this.oMetadata.dataServices.schema;for(var i=0;i<S.length;++i){var h=S[i].entityContainer;if(h){for(var n=0;n<h.length;++n){var j=h[n].entitySet;if(j){for(var m=0;m<j.length;++m){if(j[m].entityType===s){return j[m];}}}}}}return null;};d.prototype._calculateCanonicalPath=function(p){var s,i,P,t;if(p){i=p.lastIndexOf(")");if(i!==-1){t=p.substr(0,i+1);var o=this._getEntitySetByPath(t);if(o){if(o.__entityType.isFunction){s=p;}else{P=p.split("/");if(t==="/"+P[1]){if(!(P[2]in o.__entityType.__navigationPropertiesMap)){s=p;}}else{P=t.split("/");t='/'+o.name+P[P.length-1].substr(P[P.length-1].indexOf("("))+p.substr(i+1);if(t!==p){s=t;}}}}}}return s;};d.prototype._getAssociationSetByAssociation=function(A){var s=this.oMetadata.dataServices.schema;for(var i=0;i<s.length;++i){var f=s[i].entityContainer;if(f){for(var n=0;n<f.length;++n){var S=f[n].associationSet;if(S){for(var m=0;m<S.length;++m){if(S[m].association===A){return S[m];}}}}}}return null;};d.prototype._isMessageScopeSupported=function(){var s=this.oMetadata.dataServices.schema,o,f;if(!this.bMessageScopeSupported&&s){for(var i=0;i<s.length;++i){f=s[i].entityContainer;if(f){for(var n=0;n<f.length;++n){o=f[n];if(o.extensions&&Array.isArray(o.extensions)){for(var m=0;m<o.extensions.length;++m){if(o.extensions[m].name==="message-scope-supported"&&o.extensions[m].namespace===this.mNamespaces.sap){if(o.extensions[m].value==="true"){this.bMessageScopeSupported=true;break;}}}}}}}}return this.bMessageScopeSupported;};d.prototype._isCollection=function(p){var f=false;var i=p.lastIndexOf("/");if(i>0){var s=p.substring(0,i);var o=this._getEntityTypeByPath(s);if(o){var A=this._getEntityAssociationEnd(o,p.substring(i+1));if(A&&A.multiplicity==="*"){f=true;}}}else{f=true;}return f;};d.prototype._getReducedPath=function(p){var A,i,k,n,N,o,s,S=p.split("/"),f;if(S.length<4){return p;}this._fillElementCaches();for(i=1;i<S.length-2;i+=1){f=this._getEntityTypeByPath(S.slice(0,i+1).join('/'));N=f&&f.__navigationPropertiesMap[S[i+1].split("(")[0]];if(!N){continue;}s=S[i+2].split("(")[0];n=this._getEntityTypeByNavPropertyObject(N);o=n&&n.__navigationPropertiesMap[s];if(!o||N.relationship!==o.relationship){continue;}k=S[i+2].slice(s.length);A=this._getEntityAssociationEnd(n,s);if(A.multiplicity!=="*"||k&&S[i].endsWith(k)){S.splice(i+1,2);return this._getReducedPath(S.join("/"));}}return S.join("/");};d.prototype.getKeyPropertyNamesByPath=function(p){var A,o,i=p.lastIndexOf("/");if(i>0){o=this._getEntityTypeByPath(p.slice(0,i));if(o){A=this._getEntityAssociationEnd(o,p.slice(i+1).split("(")[0]);o=A?this._getEntityTypeByName(A.type):undefined;}}else{o=this._getEntityTypeByPath(p);}if(o){return o.key.propertyRef.map(function(k){return k.name;});}};d.prototype._getCanonicalPathOfFunctionImport=function(f,F){var A,m,h,i,k,p,P,j=f.extensions,s=f.returnType,I="",l=false;if(j){for(i=0;i<j.length;i+=1){if(j[i].name==="action-for"){A=j[i].value;break;}}}if(d._returnsCollection(f)){l=true;s=s.slice(11,-1);}if(A){h=this._getEntityTypeByName(A);}else if(f.entitySet){h=this._getEntityTypeByPath(f.entitySet);}else if(s){h=this._getEntityTypeByName(s);}if(h){m=this._getEntitySetByType(h);if(m&&h.key&&h.key.propertyRef){if(l){return"/"+m.name;}P=h.key.propertyRef;if(P.length===1){p=P[0].name;if(F[p]){I=F[p];}}else{k=[];for(i=0;i<P.length;i+=1){p=P[i].name;if(F[p]){k.push(p+"="+F[p]);}}I=k.join(",");}return"/"+m.name+"("+I+")";}else if(!m){L.error("Cannot determine path of the entity set for the function import '"+f.name+"'",this,c);}else{L.error("Cannot determine keys of the entity type '"+h.entityType+"' for the function import '"+f.name+"'",this,c);}}return"";};return d;});
