/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','./ODataUtils','./CountMode','./ODataContextBinding','./ODataListBinding','./ODataMetadata','./ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/FilterProcessor','sap/ui/model/odata/ODataMetaModel','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs',"sap/base/util/isEmptyObject","sap/base/util/uid","sap/base/util/merge","sap/base/Log","sap/base/assert","sap/base/security/encodeURL","sap/ui/thirdparty/jquery","sap/base/util/isPlainObject"],function(B,C,M,O,a,b,c,d,e,f,F,g,U,h,m,u,n,L,o,p,q,r){"use strict";var s=M.extend("sap.ui.model.odata.ODataModel",{constructor:function(S,j,i,P,H,t,w,l){M.apply(this,arguments);var k,R,v,A=null,x,y,D,z,E,G,I=this;if(typeof(S)==="object"){j=S;S=j.serviceUrl;}if(typeof j==="object"){i=j.user;P=j.password;H=j.headers;t=j.tokenHandling;l=j.loadMetadataAsync;w=j.withCredentials;v=j.maxDataServiceVersion;k=j.useBatch;R=j.refreshAfterChange;A=j.annotationURI;x=j.loadAnnotationsJoined;D=j.defaultCountMode;y=j.metadataNamespaces;z=j.serviceUrlParams;E=j.metadataUrlParams;G=j.skipMetadataAnnotationParsing;j=j.json;}this.oServiceData={};this.sDefaultBindingMode=B.OneWay;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.bCountSupported=true;this.bJSON=j;this.bCache=true;this.aPendingRequestHandles=[];this.oRequestQueue={};this.aBatchOperations=[];this.oHandler;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=k===true;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=v;this.bLoadMetadataAsync=!!l;this.bLoadAnnotationsJoined=x===undefined?true:x;this.sAnnotationURI=A;this.sDefaultCountMode=D||a.Both;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.bSkipMetadataAnnotationParsing=G;this.oHeaders={};this.setHeaders(H);this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];if(S.indexOf("?")==-1){this.sServiceUrl=S;}else{var J=S.split("?");this.sServiceUrl=J[0];if(J[1]){this.aUrlParams.push(J[1]);}}if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");var K=this._createRequestUrl("$metadata",undefined,E);if(!s.mServiceData[K]){s.mServiceData[K]={};}this.oServiceData=s.mServiceData[K];if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.sUser=i;this.sPassword=P;this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();if(!this.oServiceData.oMetadata){this.oServiceData.oMetadata=new d(K,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:y,withCredentials:this.bWithCredentials});}this.oMetadata=this.oServiceData.oMetadata;this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var N=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){if(!this.bLoadMetadataAsync){this.addAnnotationXML(this.oMetadata.sMetadataBody,!!this.sAnnotationURI);}else{this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(Q,T){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(T["metadataString"],Q);}.bind(this,!!this.sAnnotationURI));}}if(this.sAnnotationURI){if(this.bLoadMetadataAsync){this.pAnnotationsLoaded=this.pAnnotationsLoaded.then(N.addUrl.bind(N,this.sAnnotationURI));}else{this.pAnnotationsLoaded=Promise.all([this.pAnnotationsLoaded,N.addUrl(this.sAnnotationURI)]);}}}if(z){this.aUrlParams=this.aUrlParams.concat(O._createUrlParamsArray(z));}this.onMetadataLoaded=function(Q){I._initializeMetadata();I.initialize();};this.onMetadataFailed=function(Q){I.fireMetadataFailed(Q.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}this.oHandler=h.jsonHandler;}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHandler=h.atomHandler;}this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["DataServiceVersion"]="2.0";},metadata:{publicMethods:["create","remove","update","submitChanges","getServiceMetadata","read","hasPendingChanges","refresh","refreshMetadata","resetChanges","isCountSupported","setCountSupported","setDefaultCountMode","getDefaultCountMode","forceNoCache","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch"]}});s.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed"};s.mServiceData={};s.prototype.fireRejectChange=function(P){this.fireEvent("rejectChange",P);return this;};s.prototype.attachRejectChange=function(D,i,l){this.attachEvent("rejectChange",D,i,l);return this;};s.prototype.detachRejectChange=function(i,l){this.detachEvent("rejectChange",i,l);return this;};s.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(j){if(!!j){t.metadataLoadEvent=setTimeout(i.bind(t),0);}else{if(t.oMetadata){t.fireMetadataLoaded({metadata:t.oMetadata});L.debug("ODataModel fired metadataloaded");}}};if(this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&(this.oAnnotations.bInitialized||this.oAnnotations.isFailed())){i(!this.bLoadMetadataAsync);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(D);}};s.prototype.fireAnnotationsLoaded=function(P){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsLoaded",P),0);}else{this.fireEvent("annotationsLoaded",P);}return this;};s.prototype.attachAnnotationsLoaded=function(D,i,l){this.attachEvent("annotationsLoaded",D,i,l);return this;};s.prototype.detachAnnotationsLoaded=function(i,l){this.detachEvent("annotationsLoaded",i,l);return this;};s.prototype.fireAnnotationsFailed=function(P){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsFailed",P),0);}else{this.fireEvent("annotationsFailed",P);}L.debug("ODataModel fired annotationsFailed");return this;};s.prototype.attachAnnotationsFailed=function(D,i,l){this.attachEvent("annotationsFailed",D,i,l);return this;};s.prototype.detachAnnotationsFailed=function(i,l){this.detachEvent("annotationsFailed",i,l);return this;};s.prototype.fireMetadataLoaded=function(P){this.fireEvent("metadataLoaded",P);return this;};s.prototype.attachMetadataLoaded=function(D,i,l){this.attachEvent("metadataLoaded",D,i,l);return this;};s.prototype.detachMetadataLoaded=function(i,l){this.detachEvent("metadataLoaded",i,l);return this;};s.prototype.fireMetadataFailed=function(P){this.fireEvent("metadataFailed",P);return this;};s.prototype.attachMetadataFailed=function(D,i,l){this.attachEvent("metadataFailed",D,i,l);return this;};s.prototype.detachMetadataFailed=function(i,l){this.detachEvent("metadataFailed",i,l);return this;};s.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){this.oMetadata.refresh();}};s.prototype._createRequestUrl=function(P,i,j,k,l){var t,R,v,w="";if(P&&P.indexOf('?')!=-1){v=P.substr(P.indexOf('?')+1);P=P.substr(0,P.indexOf('?'));}R=this._normalizePath(P,i);if(!k){w=this.sServiceUrl+R;}else{w=R.substr(R.indexOf('/')+1);}t=O._createUrlParamsArray(j);if(this.aUrlParams){t=t.concat(this.aUrlParams);}if(v){t.push(v);}if(t.length>0){w+="?"+t.join("&");}if(l===undefined){l=true;}if(l===false){var x=q.now();var y=w.replace(/([?&])_=[^&]*/,"$1_="+x);w=y+((y===w)?(/\?/.test(w)?"&":"?")+"_="+x:"");}return w;};s.prototype._loadData=function(P,i,S,E,j,H,k){var R,l,t=this;function _(D,z){var A=D,G={};if(z.statusCode==204){if(S){S(null);}if(k){k(null);}t.fireRequestCompleted({url:l.requestUri,type:"GET",async:l.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});return;}if(!A){L.fatal("The following problem occurred: No data was retrieved by service: "+z.requestUri);t.fireRequestCompleted({url:l.requestUri,type:"GET",async:l.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false});return false;}if(t.bUseBatch){var I=t._getBatchErrors(D);if(I.length>0){v(I[0]);return false;}if(A.__batchResponses&&A.__batchResponses.length>0){A=A.__batchResponses[0].data;}else{L.fatal("The following problem occurred: No data was retrieved by service: "+z.requestUri);}}x=x.concat(A.results);if(A.__next){var J=new U(A.__next);l.requestUri=J.absoluteTo(z.requestUri).toString();w(l);}else{if(A.results){var V,K;for(K in x){V=x[K];if(x===V){continue;}A.results[K]=V;}}if(A.results&&!Array.isArray(A.results)){A=A.results;}t._importData(A,G);if(t.sChangeKey&&G){var N=t.sChangeKey.substr(t.sChangeKey.lastIndexOf('/')+1);if(G[N]){delete t.oRequestQueue[t.sChangeKey];t.sChangeKey=null;}}if(S){S(A);}t.checkUpdate(false,false,G);if(k){k(A);}t.fireRequestCompleted({url:l.requestUri,type:"GET",async:l.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});}}function v(z){if(t.bTokenHandling&&z.response){var T=t._getHeader("x-csrf-token",z.response.headers);if(!l.bTokenReset&&z.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();l.bTokenReset=true;w();return;}}var A=t._handleError(z);if(E){E(z,R&&R.bAborted);}t.fireRequestCompleted({url:l.requestUri,type:"GET",async:l.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false,errorobject:A});if(!R||!R.bAborted){A.url=l.requestUri;t.fireRequestFailed(A);}}function w(){if(t.bUseBatch){t.updateSecurityToken();var z=U.parse(l.requestUri).query;var A=t._createRequestUrl(P,null,z,t.bUseBatch);l=t._createRequest(A,"GET",true);if(t.bTokenHandling){delete l.headers["x-csrf-token"];}var D=t._createBatchRequest([l],true);R=t._request(D,_,v,h.batchHandler,undefined,t.getServiceMetadata());}else{R=t._request(l,_,v,t.oHandler,undefined,t.getServiceMetadata());}if(H){var W={abort:function(){R.bAborted=true;R.abort();}};H(W);}}var x=[];var y=this._createRequestUrl(P,null,i,null,j||this.bCache);l=this._createRequest(y,"GET",true);if(t.bTokenHandling){delete l.headers["x-csrf-token"];}this.fireRequestSent({url:l.requestUri,type:"GET",async:l.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]}});w();};s.prototype._importData=function(D,k){var t=this,l,K,R,E;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._importData(j,k));});return l;}else{K=this._getKey(D);E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){R=t._importData(P,k);if(Array.isArray(R)){E[N]={__list:R};}else{E[N]={__ref:R};}}else if(!P||!P.__deferred){E[N]=P;}});k[K]=true;return K;}};s.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._removeReferences(j));});return l;}else{q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};s.prototype._restoreReferences=function(D){var t=this,l,R=[];if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._restoreReferences(j));});return l;}else{q.each(D,function(P,i){if(i&&i["__ref"]){var k=t._getObject("/"+i["__ref"]);o(k,"ODataModel inconsistent: "+i["__ref"]+" not found!");if(k){delete i["__ref"];D[P]=k;t._restoreReferences(k);}}else if(i&&i["__list"]){q.each(i["__list"],function(j,E){var k=t._getObject("/"+i["__list"][j]);o(k,"ODataModel inconsistent: "+i["__list"][j]+" not found!");if(k){R.push(k);t._restoreReferences(k);}});delete i["__list"];i.results=R;R=[];}});return D;}};s.prototype.removeData=function(){this.oData={};};s.prototype.initialize=function(){var i=this.getBindings();q.each(i,function(I,j){j.initialize();});};s.prototype.refresh=function(i,R){if(R){this.removeData();}this._refresh(i);};s.prototype._refresh=function(i,j,E){var k=this.getBindings();q.each(k,function(I,l){l.refresh(i,j,E);});};s.prototype.checkUpdate=function(i,A,j,k){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(i,false,j);}.bind(this),0);}return;}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;}var l=this.getBindings();q.each(l,function(I,t){if(!k||this.isMetaModelPath(t.getPath())){t.checkUpdate(i,j);}}.bind(this));};s.prototype.bindProperty=function(P,i,j){var k=new e(this,P,i,j);return k;};s.prototype.bindList=function(P,i,S,j,k){var l=new c(this,P,i,S,j,k);return l;};s.prototype.bindTree=function(P,i,j,k){var l=new f(this,P,i,j,k);return l;};s.prototype.createBindingContext=function(P,i,j,k,R){var R=!!R,l=this.resolve(P,i);if(typeof i=="function"){k=i;i=null;}if(typeof j=="function"){k=j;j=null;}if(!l){if(k){k(null);}return null;}var D=this._getObject(P,i),K,N,t=this;if(!R){R=this._isReloadNeeded(l,D,j);}if(!R){K=this._getKey(D);N=this.getContext('/'+K);if(k){k(N);}return N;}if(k){var I=!P.startsWith("/");if(l){var v=[],w=this.createCustomParams(j);if(w){v.push(w);}this._loadData(l,v,function(D){K=D?t._getKey(D):undefined;if(K&&i&&I){var x=i.getPath();x=x.substr(1);if(t.oData[x]){t.oData[x][P]={__ref:K};}}N=t.getContext('/'+K);k(N);},function(){k(null);});}else{k(null);}}};s.prototype._isReloadNeeded=function(j,D,P){var N,k=[],S,l=[];if(!j){return false;}if(!D){return true;}if(P&&P["expand"]){N=P["expand"].replace(/\s/g,"");k=N.split(',');}if(k){for(var i=0;i<k.length;i++){var t=k[i].indexOf("/");if(t!==-1){var v=k[i].slice(0,t);var w=k[i].slice(t+1);k[i]=[v,w];}}}for(var i=0;i<k.length;i++){var x=k[i];if(Array.isArray(x)){var y=D[x[0]];var z=x[1];if(!y||(y&&y.__deferred)){return true;}else{if(y){if(y.__list&&y.__list.length>0){for(var A=0;A<y.__list.length;A++){var E="/"+y.__list[A];var G=this.getObject(E);var R=this._isReloadNeeded(E,G,{expand:z});if(R){return true;}}}else if(y.__ref){var E="/"+y.__ref;var G=this.getObject(E);var R=this._isReloadNeeded(E,G,{expand:z});if(R){return true;}}}}}else{if(D[x]===undefined||(D[x]&&D[x].__deferred)){return true;}}}if(P&&P["select"]){S=P["select"].replace(/\s/g,"");l=S.split(',');}for(var i=0;i<l.length;i++){if(D[l[i]]===undefined){return true;}}if(l.length==0){var H=this.oMetadata._getEntityTypeByPath(j);if(!H){return false;}else{for(var i=0;i<H.property.length;i++){if(D[H.property[i].name]===undefined){return true;}}}}return false;};s.prototype.destroyBindingContext=function(i){};s.prototype.createCustomParams=function(P){var i=[],j,S={expand:true,select:true};for(var N in P){if(N in S){i.push("$"+N+"="+p(P[N]));}if(N=="custom"){j=P[N];for(var N in j){if(N.indexOf("$")==0){L.warning("Trying to set OData parameter "+N+" as custom query option!");}else{i.push(N+"="+p(j[N]));}}}}return i.join("&");};s.prototype.bindContext=function(P,i,j){var k=new b(this,P,i,j);return k;};s.prototype.setCountSupported=function(i){this.bCountSupported=i;};s.prototype.isCountSupported=function(){return this.bCountSupported;};s.prototype.setDefaultCountMode=function(i){this.sDefaultCountMode=i;};s.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};s.prototype._getKey=function(i,D){var k,j;if(i instanceof C){k=i.getPath().substr(1);}else if(i&&i.__metadata&&i.__metadata.uri){j=i.__metadata.uri;k=j.substr(j.lastIndexOf("/")+1);}if(D){k=decodeURIComponent(k);}return k;};s.prototype.getKey=function(i,D){return this._getKey(i,D);};s.prototype.createKey=function(j,k,D){var E=this.oMetadata._getEntityTypeByPath(j),K=j,t=this,N,v,P;o(E,"Could not find entity type of collection \""+j+"\" in service metadata!");K+="(";if(E.key.propertyRef.length==1){N=E.key.propertyRef[0].name;o(N in k,"Key property \""+N+"\" is missing in object!");P=this.oMetadata._getPropertyMetadata(E,N);v=O.formatValue(k[N],P.type);K+=D?v:encodeURIComponent(v);}else{q.each(E.key.propertyRef,function(i,l){if(i>0){K+=",";}N=l.name;o(N in k,"Key property \""+N+"\" is missing in object!");P=t.oMetadata._getPropertyMetadata(E,N);v=O.formatValue(k[N],P.type);K+=N;K+="=";K+=D?v:encodeURIComponent(v);});}K+=")";return K;};s.prototype.getProperty=function(P,i,I){var v=this._getObject(P,i);if(I==null||I==undefined){return v;}if(!r(v)){return v;}v=n({},v);if(I==true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};s.prototype._getObject=function(P,i){var N=this.isLegacySyntax()?this.oData:null,R=this.resolve(P,i),S,D,j,k,K,l;if(this.oMetadata&&R&&R.indexOf('/#')>-1){if(this.isMetaModelPath(R)){S=R.indexOf('/##');l=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);j=R.substr(S+3);k=l.getMetaContext(D);N=l.getProperty(j,k);}else{N=this.oMetadata._getAnnotation(R);}}else{if(i){K=i.getPath();K=K.substr(1);N=this.oData[K];}if(!P){return N;}var t=P.split("/"),I=0;if(!t[0]){N=this.oData;I++;}while(N&&t[I]){N=N[t[I]];if(N){if(N.__ref){N=this.oData[N.__ref];}else if(N.__list){N=N.__list;}else if(N.__deferred){N=undefined;}}I++;}}return N;};s.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};s.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];};s.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};s.prototype.refreshSecurityToken=function(S,E,A){var t=this,i,T;A=A===true;i=this._createRequestUrl("/");var R=this._createRequest(i,"GET",A);R.headers["x-csrf-token"]="Fetch";function _(D,k){if(k){T=t._getHeader("x-csrf-token",k.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T;}else{t.resetSecurityToken();t.bTokenHandling=false;}}if(S){S(D,k);}}function j(k){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(k);if(E){E(k);}}return this._request(R,_,j,undefined,undefined,this.getServiceMetadata());};s.prototype._submitRequest=function(R,i,S,E,H,I){var t=this,j,k={};function _(D,w){if(i&&H){var x=t._getBatchErrors(D);if(x.length>0){l(x[0]);return false;}if(D.__batchResponses&&D.__batchResponses.length>0){j=D.__batchResponses[0].data;if(!j&&D.__batchResponses[0].__changeResponses){j=D.__batchResponses[0].__changeResponses[0].data;}}D=j;}if(I){if(D&&D.__batchResponses){q.each(D.__batchResponses,function(y,w){if(w&&w.data){t._importData(w.data,k);}});}}t._handleETag(R,w,i);t._updateRequestQueue(R,i);if(t._isRefreshNeeded(R,w)){t._refresh(false,R.keys,R.entityTypes);}if(S){S(D,w);}}function l(w){if(t.bTokenHandling&&w.response){var T=t._getHeader("x-csrf-token",w.response.headers);if(!R.bTokenReset&&w.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();R.bTokenReset=true;v();return;}}t._handleError(w);if(E){E(w);}}function v(){if(t.bTokenHandling){delete R.headers["x-csrf-token"];}if(t.bTokenHandling&&R.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){R.headers["x-csrf-token"]=t.oServiceData.securityToken;}}if(i){return t._request(R,_,l,h.batchHandler,undefined,t.getServiceMetadata());}else{return t._request(R,_,l,t.oHandler,undefined,t.getServiceMetadata());}}return v();};s.prototype._createBatchRequest=function(t,A){var v,R,w={},P={},K={},E={};P.__batchRequests=t;v=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){v+="?"+this.aUrlParams.join("&");}q.extend(w,this.mCustomHeaders,this.oHeaders);delete w["Content-Type"];R={headers:w,requestUri:v,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:A};if(A){R.withCredentials=this.bWithCredentials;}q.each(t,function(i,x){if(x["__changeRequests"]){q.each(x["__changeRequests"],function(j,y){if(y.keys&&y.method!="POST"){q.each(y.keys,function(k,l){K[k]=l;});}else if(y.entityTypes&&y.method=="POST"){q.each(y.entityTypes,function(l,k){E[l]=k;});}});}});R.keys=K;R.entityTypes=E;return R;};s.prototype._handleETag=function(R,k,l){var t,E,v,w,x,y;if(l){x=R.data.__batchRequests;y=k.data.__batchResponses;if(y&&x){for(var i=0;i<x.length;i++){v=x[i].__changeRequests;if(y[i]){w=y[i].__changeResponses;if(v&&w){for(var j=0;j<v.length;j++){if(v[j].method=="MERGE"||v[j].method=="PUT"){t=v[j].requestUri.replace(this.sServiceUrl+'/','');if(!t.startsWith("/")){t="/"+t;}E=this._getObject(t);if(E&&E.__metadata&&w[j].headers&&w[j].headers.ETag){E.__metadata.etag=w[j].headers.ETag;}}}}}else{L.warning("could not update ETags for batch request: corresponding response for request missing");}}}else{L.warning("could not update ETags for batch request: no batch responses/requests available");}}else{t=R.requestUri.replace(this.sServiceUrl+'/','');if(!t.startsWith("/")){t="/"+t;}E=this._getObject(t);if(E&&E.__metadata&&k.headers.ETag){E.__metadata.etag=k.headers.ETag;}}};s.prototype._handleBatchErrors=function(R,D){this._getBatchErrors(D);this._handleETag();};s.prototype._getBatchErrors=function(D){var E=[],i;q.each(D.__batchResponses,function(I,j){if(j.message){i="The following problem occurred: "+j.message;if(j.response){i+=j.response.statusCode+","+j.response.statusText+","+j.response.body;}E.push(j);L.fatal(i);}if(j.__changeResponses){q.each(j.__changeResponses,function(I,k){if(k.message){i="The following problem occurred: "+k.message;if(k.response){i+=k.response.statusCode+","+k.response.statusText+","+k.response.body;}E.push(k);L.fatal(i);}});}});return E;};s.prototype._handleError=function(E){var P={},t;var i="The following problem occurred: "+E.message;P.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()=="required"){this.resetSecurityToken();}}i+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.responseText=E.response.body;}L.fatal(i);return P;};s.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};s.prototype._getETag=function(P,i,E){var j,k,I;if(E){j=E;}else{if(i&&i.__metadata){j=i.__metadata.etag;}else if(P){k=P.replace(this.sServiceUrl+'/','');I=k.indexOf("?");if(I>-1){k=k.substr(0,I);}if(this.oData.hasOwnProperty(k)){j=this.getProperty('/'+k+'/__metadata/etag');}}}return j;};s.prototype._createRequest=function(i,j,A,P,E){var k={},l;q.extend(k,this.mCustomHeaders,this.oHeaders);l=this._getETag(i,P,E);if(l&&j!="GET"){k["If-Match"]=l;}if(this.bJSON&&j!="DELETE"&&this.sMaxDataServiceVersion==="2.0"){k["Content-Type"]="application/json";}if(j=="MERGE"&&!this.bUseBatch){k["x-http-method"]="MERGE";j="POST";}var R={headers:k,requestUri:i,method:j,user:this.sUser,password:this.sPassword,async:A};if(P){R.data=P;}if(A){R.withCredentials=this.bWithCredentials;}return R;};s.prototype._isRefreshNeeded=function(R,i){var j=false,E,k=[],t=this;if(!this.bRefreshAfterChange){return j;}if(R.data&&Array.isArray(R.data.__batchRequests)){if(i){k=t._getBatchErrors(i.data);q.each(k,function(I,l){if(l.response&&l.response.statusCode=="412"){E=l.response.statusCode;return false;}});if(!!E){return false;}}q.each(R.data.__batchRequests,function(I,l){if(Array.isArray(l.__changeRequests)){q.each(l.__changeRequests,function(I,v){j=j||t._isRefreshNeeded(v);return!j;});}return!j;});}else{if(R.method==="GET"){return false;}else{if(i&&i.statusCode=="412"){j=false;}else{j=true;}}}return j;};s.prototype.update=function(P,D,i){var S,E,j,R,k,l,t,v,w,x,K,y,A=false;if(i instanceof C||arguments.length>3){l=i;S=arguments[3];E=arguments[4];j=arguments[5];}else{l=i.context||i.oContext;S=i.success||i.fnSuccess;E=i.error||i.fnError;t=i.eTag||i.sETag;j=typeof(i.merge)=="undefined"?i.bMerge===true:i.merge===true;A=typeof(i.async)=="undefined"?i.bAsync===true:i.async===true;y=i.urlParameters;}k=this._createRequestUrl(P,l,y,this.bUseBatch);if(j){R=this._createRequest(k,"MERGE",A,D,t);}else{R=this._createRequest(k,"PUT",A,D,t);}P=this._normalizePath(P,l);x=this._getObject(P);R.keys={};if(x){K=this._getKey(x);R.keys[K]=true;}if(this.bUseBatch){w=this._createBatchRequest([{__changeRequests:[R]}],A);v=this._submitRequest(w,this.bUseBatch,S,E,true);}else{v=this._submitRequest(R,this.bUseBatch,S,E);}return v;};s.prototype.create=function(P,D,i){var R,j,k,l,E,t,S,v,A=false,w;if(i&&typeof(i)=="object"&&!(i instanceof C)){t=i.context;S=i.success;w=i.urlParameters;v=i.error;A=i.async===true;}else{t=i;S=arguments[3];v=arguments[4];}k=this._createRequestUrl(P,t,w,this.bUseBatch);R=this._createRequest(k,"POST",A,D);P=this._normalizePath(P,t);E=this.oMetadata._getEntityTypeByPath(P);R.entityTypes={};if(E){R.entityTypes[E.entityType]=true;}if(this.bUseBatch){j=this._createBatchRequest([{__changeRequests:[R]}],A);l=this._submitRequest(j,this.bUseBatch,S,v,true);}else{l=this._submitRequest(R,this.bUseBatch,S,v);}return l;};s.prototype.remove=function(P,i){var j,E,S,k,l,R,t,v,K,w,_,x,y,z,A=false,D=this;if((i instanceof C)||arguments[2]){j=i;k=arguments[2];l=arguments[3];}else if(i){j=i.context||i.oContext;k=i.success||i.fnSuccess;l=i.error||i.fnError;v=i.eTag||i.sETag;w=i.payload||i.oPayload;A=typeof(i.async)=="undefined"?i.bAsync===true:i.async===true;z=i.urlParameters;}_=function(G,H){E=t.substr(t.lastIndexOf('/')+1);if(E.indexOf('?')!=-1){E=E.substr(0,E.indexOf('?'));}delete D.oData[E];delete D.mContexts["/"+E];if(k){k(G,H);}};t=this._createRequestUrl(P,j,z,this.bUseBatch);R=this._createRequest(t,"DELETE",A,w,v);P=this._normalizePath(P,j);S=this._getObject(P);R.keys={};if(S){K=this._getKey(S);R.keys[K]=true;}if(this.bUseBatch){x=this._createBatchRequest([{__changeRequests:[R]}],A);y=this._submitRequest(x,this.bUseBatch,_,l,true);}else{y=this._submitRequest(R,this.bUseBatch,_,l);}return y;};s.prototype.callFunction=function(i,P){var R,j,k,l,t,v,w,S,E,A,x="GET",y={},z=this;if(P&&typeof(P)=="object"){x=P.method?P.method:x;v=P.urlParameters;w=P.context;S=P.success;E=P.error;A=P.async===true;}else{x=P;v=arguments[2];w=arguments[3];S=arguments[4];E=arguments[5];A=arguments[6]===true;}t=this.oMetadata._getFunctionImportMetadata(i,x);o(t,"Function "+i+" not found in the metadata !");if(t){k=this._createRequestUrl(i,w,null,this.bUseBatch);var D=U(k);if(t.parameter!=null){q.each(v,function(G,H){var I=t.parameter.filter(function(K){return K.name==G&&K.mode=="In";});if(I.length>0){var J=I[0];y[G]=O.formatValue(H,J.type);}else{L.warning("Parameter "+G+" is not defined for function call "+i+"!");}});}if(x==="GET"){return z.read(i,w,y,true,S,E);}else{q.each(y,function(G,H){D.addQuery(G,H);});R=this._createRequest(D.toString(),x,A);if(this.bUseBatch){j=this._createBatchRequest([{__changeRequests:[R]}],A);l=this._submitRequest(j,this.bUseBatch,S,E,true);}else{l=this._submitRequest(R,this.bUseBatch,S,E);}return l;}}};s.prototype.read=function(P,i){var R,j,k,l,t,v,A,S,E,w,x,y,z,D,G,H,I;if(i&&typeof(i)=="object"&&!(i instanceof C)){t=i.context;v=i.urlParameters;A=i.async!==false;S=i.success;E=i.error;w=i.filters;x=i.sorters;}else{t=i;v=arguments[2];A=arguments[3]!==false;S=arguments[4];E=arguments[5];}A=A!==false;I=O._createUrlParamsArray(v);z=O.createSortParams(x);if(z){I.push(z);}if(w&&!this.oMetadata){L.fatal("Tried to use filters in read method before metadata is available.");}else{H=this._normalizePath(P,t);G=this.oMetadata&&this.oMetadata._getEntityTypeByPath(H);D=F.groupFilters(w);y=O.createFilterParams(D,this.oMetadata,G);if(y){I.push(y);}}j=this._createRequestUrl(P,t,I,this.bUseBatch);R=this._createRequest(j,"GET",A);if(this.bUseBatch){l=this._createBatchRequest([R],A);k=this._submitRequest(l,this.bUseBatch,S,E,true);}else{k=this._submitRequest(R,this.bUseBatch,S,E);}return k;};s.prototype.createBatchOperation=function(P,i,D,j){var k={},E,S,K,l;q.extend(k,this.mCustomHeaders,this.oHeaders);if(P.startsWith("/")){P=P.substr(1);}if(j){E=j.sETag;}if(i!="GET"){E=this._getETag(P,D,E);if(E){k["If-Match"]=E;}}if(this.bJSON){if(i!="DELETE"&&i!="GET"&&this.sMaxDataServiceVersion==="2.0"){k["Content-Type"]="application/json";}}else{k["Content-Type"]="application/atom+xml";}var R={requestUri:P,method:i.toUpperCase(),headers:k};if(D){R.data=D;}if(i!="GET"&&i!="POST"){if(P&&P.indexOf("/")!=0){P='/'+P;}S=this._getObject(P);if(S){K=this._getKey(S);R.keys={};R.keys[K]=true;}}else if(i=="POST"){var N=P;if(P.indexOf('?')!=-1){N=P.substr(0,P.indexOf('?'));}l=this.oMetadata._getEntityTypeByPath(N);if(l){R.entityTypes={};R.entityTypes[l.entityType]=true;}}return R;};s.prototype.addBatchReadOperations=function(R){if(!Array.isArray(R)||R.length<=0){L.warning("No array with batch operations provided!");return false;}var t=this;q.each(R,function(i,j){if(j.method!="GET"){L.warning("Batch operation should be a GET operation!");return false;}t.aBatchOperations.push(j);});};s.prototype.addBatchChangeOperations=function(i){if(!Array.isArray(i)||i.length<=0){return false;}q.each(i,function(I,j){if(j.method!="POST"&&j.method!="PUT"&&j.method!="MERGE"&&j.method!="DELETE"){L.warning("Batch operation should be a POST/PUT/MERGE/DELETE operation!");return false;}});this.aBatchOperations.push({__changeRequests:i});};s.prototype.clearBatch=function(){this.aBatchOperations=[];};s.prototype.submitBatch=function(S,E,A,i){var R,j,t=this;function _(D,v){if(S){S(D,v,t._getBatchErrors(D));}}if(!(typeof(S)=="function")){var k=A;var l=E;A=S;S=l;E=k;}A=A!==false;if(this.aBatchOperations.length<=0){L.warning("No batch operations in batch. No request will be triggered!");return false;}R=this._createBatchRequest(this.aBatchOperations,A);j=this._submitRequest(R,true,_,E,false,i);this.clearBatch();return j;};s.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};s.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};s.prototype.submitChanges=function(S,E,P){var R,i,t=this,j,k,T,l,v,K;if(this.sChangeKey){j=this.sChangeKey.replace(this.sServiceUrl,'');v=this._getObject(j);i=v;if(r(v)){i=n({},v);if(i.__metadata){T=i.__metadata.type;l=i.__metadata.etag;delete i.__metadata;if(T||l){i.__metadata={};}if(T){i.__metadata.type=T;}if(!!l){i.__metadata.etag=l;}}q.each(i,function(y,z){if(z&&z.__deferred){delete i[y];}});var w=this.oMetadata._getEntityTypeByPath(j);if(w){var N=this.oMetadata._getNavigationPropertyNames(w);q.each(N,function(I,y){delete i[y];});}i=this._removeReferences(i);}if(P&&P.sETag){k=P.sETag;}R=this._createRequest(this.sChangeKey,"MERGE",true,i,k);if(this.sUrlParams){R.requestUri+="?"+this.sUrlParams;}R.keys={};if(v){K=this._getKey(v);R.keys[K]=true;}this.oRequestQueue[this.sChangeKey]=R;}if(m(this.oRequestQueue)){return undefined;}if(this.bUseBatch){var x=[];q.each(this.oRequestQueue,function(K,y){delete y._oRef;var z=n({},y);y._oRef=z;z.requestUri=z.requestUri.replace(t.sServiceUrl+'/','');z.data._bCreate?delete z.data._bCreate:false;x.push(z);});R=this._createBatchRequest([{__changeRequests:x}],true);this._submitRequest(R,this.bUseBatch,S,E,true);}else{q.each(this.oRequestQueue,function(K,y){delete y._oRef;var z=n({},y);y._oRef=z;if(z.data&&z.data._bCreate){delete z.data._bCreate;}t._submitRequest(z,this.bUseBatch,S,E,true);});}return undefined;};s.prototype._updateRequestQueue=function(R,k){var l,t,v,w=this;if(k){l=R.data.__batchRequests;if(l){for(var i=0;i<l.length;i++){t=l[i].__changeRequests;if(t){for(var j=0;j<t.length;j++){v=t[j];q.each(this.oRequestQueue,function(K,x){if(x._oRef===v&&K!==w.sChangeKey){delete w.oRequestQueue[K];delete w.oData[K];delete w.mContexts["/"+K];}else if(w.sChangeKey&&K===w.sChangeKey){delete w.oRequestQueue[K];w.sChangeKey=null;}});}}}}}else{q.each(this.oRequestQueue,function(K,x){if(x._oRef===R&&K!==w.sChangeKey){delete w.oRequestQueue[K];delete w.oData[K];delete w.mContexts["/"+K];}else if(w.sChangeKey&&K===w.sChangeKey){delete w.oRequestQueue[K];w.sChangeKey=null;}});}};s.prototype.resetChanges=function(S,E){var P;if(this.sChangeKey){P=this.sChangeKey.replace(this.sServiceUrl,'');this._loadData(P,null,S,E);}};s.prototype.setProperty=function(P,v,j,A){var k,E={},D={},l=this._createRequestUrl(P,j),t=P.substring(0,P.lastIndexOf("/")),K,w,x={},y=false;if(!this.resolve(P,j)){return false;}l=l.replace(this.sServiceUrl+'/','');l=l.substring(0,l.indexOf("/"));l=this.sServiceUrl+'/'+l;k=P.substr(P.lastIndexOf("/")+1);D=this._getObject(t,j);if(!D){return false;}w=t.split("/");for(var i=w.length-1;i>=0;i--){E=this._getObject(w.join("/"),j);if(E){K=this._getKey(E);if(K){break;}}w.splice(i-1,1);}if(!K){K=this._getKey(j);}if(K){x[K]=true;}if(D._bCreate){D[k]=v;y=true;this.checkUpdate(false,A,x);}else{if(!this.sChangeKey){this.sChangeKey=l;}if(this.sChangeKey==l){D[k]=v;y=true;this.checkUpdate(false,A,x);}else{this.fireRejectChange({rejectedValue:v,oldValue:D[k]});}}return y;};s.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}};s.prototype.setHeaders=function(H){var i={},t=this;if(H){q.each(H,function(j,k){if(t._isHeaderPrivate(j)){L.warning("Not allowed to modify private header: "+j);}else{i[j]=k;}});this.mCustomHeaders=i;}else{this.mCustomHeaders={};}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};s.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};s.prototype._getHeader=function(i,H){var j;for(j in H){if(j.toLowerCase()===i.toLowerCase()){return H[j];}}return null;};s.prototype.hasPendingChanges=function(){return this.sChangeKey!=null;};s.prototype.updateBindings=function(i){this.checkUpdate(i);};s.prototype.forceNoCache=function(i){this.bCache=!i;};s.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};s.prototype.setUseBatch=function(i){this.bUseBatch=i;};s.prototype.formatValue=function(v,t){return O.formatValue(v,t);};s.prototype.deleteCreatedEntry=function(i){if(i){var P=i.getPath();delete this.mContexts[P];if(P.startsWith("/")){P=P.substr(1);}delete this.oRequestQueue[P];delete this.oData[P];}};s.prototype.createEntry=function(P,v){var E={},k,j,R;if(!P.startsWith("/")){P="/"+P;}var l=this.oMetadata._getEntityTypeByPath(P);if(!l){o(l,"No Metadata for collection "+P+" found");return undefined;}if(typeof v==="object"&&!Array.isArray(v)){E=v;}else{for(var i=0;i<l.property.length;i++){var t=l.property[i];var w=v&&v.indexOf(t.name)>-1;if(!v||w){E[t.name]=this._createPropertyValue(t.type);if(w){v.splice(v.indexOf(t.name),1);}}}if(v){o(v.length===0,"No metadata for the following properties found: "+v.join(","));}}E._bCreate=true;k=P.substring(1)+"('"+u()+"')";this.oData[k]=E;E.__metadata={type:""+l.entityType};j=this._createRequestUrl(P);R=this._createRequest(j,"POST",true,E);R.entityTypes={};R.entityTypes[l.entityType]=true;this.oRequestQueue[k]=R;return this.getContext("/"+k);};s.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var N=T.namespace;var j=T.name;if(N.toUpperCase()!=='EDM'){var k={};var l=this.oMetadata._getObjectMetadata("complexType",j,N);o(l,"Complex type "+t+" not found in the metadata !");for(var i=0;i<l.property.length;i++){var P=l.property[i];k[P.name]=this._createPropertyValue(P.type);}return k;}else{return this._getDefaultPropertyValue(j,N);}};s.prototype._getDefaultPropertyValue=function(t,N){return undefined;};s.prototype._normalizePath=function(P,i){if(P&&P.indexOf('?')!=-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!P.startsWith("/")){P='/'+P;L.warning(this+" path "+P+" should be absolute if no Context is set");}return this.resolve(P,i);};s.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};s.prototype.isList=function(P,i){var P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};s.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};s.prototype._request=function(R,S,E,H,i,j){if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(l){return function(){if(t.aPendingRequestHandles){var I=t.aPendingRequestHandles.indexOf(k);if(I>-1){t.aPendingRequestHandles.splice(I,1);}}if(!(k&&k.bSuppressErrorHandlerCall)){l.apply(this,arguments);}};}var k=h.request(R,w(S||h.defaultSuccess),w(E||h.defaultError),H,i,j);if(R.async!==false){this.aPendingRequestHandles.push(k);}return k;};s.prototype.destroy=function(){this.bDestroyed=true;if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(!!this.oMetadataLoadEvent){clearTimeout(this.oMetadataLoadEvent);}if(!!this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}M.prototype.destroy.apply(this,arguments);};s.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){var i=sap.ui.requireSync("sap/ui/model/odata/ODataAnnotations");this.oAnnotations=new i({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync,headers:this.mCustomHeaders});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};s.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};s.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};s.prototype.addAnnotationUrl=function(v){var j=[].concat(v),k=[],A=[],E=[],t=this;q.each(j,function(i,l){var I=l.indexOf("$metadata");if(I>=0){if(I==0){l=t.sServiceUrl+'/'+l;}k.push(l);}else{A.push(l);}});return this.oMetadata._addUrl(k).then(function(P){return Promise.all(q.map(P,function(i){E=E.concat(i.entitySets);return t.addAnnotationXML(i["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(P){return{annotations:P.annotations,entitySets:E};});};s.prototype.addAnnotationXML=function(x,S){return new Promise(function(i,j){this._getAnnotationParser().setXML(null,x,{success:i,error:j,fireEvents:!S});}.bind(this));};s.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new g(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.oMetadata.isLoaded()&&(!this.oAnnotations||this.oAnnotations.isLoaded())?null:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);});}return this.oMetaModel;};return s;});
