/*
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","../utils/TableUtils","sap/ui/unified/MenuItem"],function(P,T,M){"use strict";var V=P.extend("sap.ui.table.plugins.V4Aggregation",{metadata:{library:"sap.ui.table",properties:{},events:{}}});V.prototype.init=function(){this.aGroupMenuItems=[];this.aAggregateMenuItems=[];this.aContextMenuItems=[];};V.prototype.isApplicable=function(t){return t.getMetadata().getName()==="sap.ui.table.Table";};V.prototype.onActivate=function(t){P.prototype.onActivate.apply(this,arguments);T.Grouping.setGroupMode(t);T.Hook.register(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.register(t,T.Hook.Keys.Table.OpenMenu,this.onOpenMenu,this);T.Hook.register(t,T.Hook.Keys.Column.MenuItemNotification,this.notifyColumnAboutMenuItems,this);};V.prototype.onDeactivate=function(t){P.prototype.onDeactivate.apply(this,arguments);T.Grouping.clearMode(t);T.Hook.deregister(t,T.Hook.Keys.Row.UpdateState,this.updateRowState,this);T.Hook.deregister(t,T.Hook.Keys.Table.OpenMenu,this.onOpenMenu,this);T.Hook.deregister(t,T.Hook.Keys.Column.MenuItemNotification,this.notifyColumnAboutMenuItems,this);this.aGroupMenuItems.concat(this.aAggregateMenuItems,this.aContextMenuItems).forEach(function(i){i.destroy();});this.aGroupMenuItems=[];this.aAggregateMenuItems=[];this.aContextMenuItems=[];var B=t.getBinding("rows");if(B){B.setAggregation();}};V.prototype.onTableRowsBound=function(B){this.updateAggregation();};V.prototype.updateRowState=function(s){if(typeof s.context.getValue("@$ui5.node.isExpanded")==="boolean"){s.type=s.Type.GroupHeader;}else if(s.context.getValue("@$ui5.node.isTotal")){s.type=s.Type.Summary;}s.title="todo";s.expandable=s.type===s.Type.GroupHeader;s.expanded=s.context.getValue("@$ui5.node.isExpanded")===true;s.level=s.context.getValue("@$ui5.node.level");};V.prototype.setGroupLevels=function(G){this._aGroupLevels=G;};V.prototype.getGroupLevels=function(){return this._aGroupLevels||[];};V.prototype.expandRow=function(r){var B=this.getTableBinding();if(B&&T.isA(r,"sap.ui.table.Row")){if(B.expand){B.expand(r.getIndex());}else{sap.ui.require(["sap/m/MessageToast"],function(e){e.show("not yet ;)");});}}};V.prototype.collapseRow=function(r){var B=this.getTableBinding();if(B&&T.isA(r,"sap.ui.table.Row")){if(B.collapse){B.collapse(r.getIndex());}else{sap.ui.require(["sap/m/MessageToast"],function(e){e.show("not yet ;)");});}}};function g(i){var C;if(i.isA("sap.ui.table.Table")){C=i.getColumns();}else{C=[i];}return C.reduce(function(G,o){var p=o.data("propertyInfo");if(o.getVisible()&&p){for(var s in p){if(p[s].groupable&&G.indexOf(s)===-1){G.push(s);}}}return G;},[]);}function a(i){var C;if(i.isA("sap.ui.table.Table")){C=i.getColumns();}else{C=[i];}return C.reduce(function(A,o){var p=o.data("propertyInfo");if(o.getVisible()&&p){for(var s in p){if(p[s].aggregatable&&A.indexOf(s)===-1){A.push(s);}}}return A;},[]);}function b(C){var A=a(C);var p=C.data("propertyInfo");var e=[];for(var i=0;i<A.length;i++){var s=A[i];var o=p[A[i]];var D=Object.assign({grandtotal:true,subtotals:true},o.aggregationDetails);var f={grandTotal:D.grandtotal===true,subtotals:D.subtotals===true};if(f.grandTotal&&f.subtotals){e.push({name:s,menuText:"All Totals",config:f});}if(f.grandTotal){e.push({name:s,menuText:"GrandTotal",config:{grandTotal:true}});}if(f.subtotals){e.push({name:s,menuText:"Subtotals",config:{subtotals:true}});}if(D.custom){for(var h in D.custom){var j=D.custom[h];e.push({name:h,menuText:h,config:j});}}}return e;}function c(t){return g(t).reduce(function(G,s){G[s]={};return G;},{});}function d(t){var A=a(t).reduce(function(A,s){A[s]={};return A;},{});return t.getColumns().reduce(function(A,C){var e=C.data("extendedState");if(e&&e.aggregations){e.aggregations.forEach(function(o){A[o.name]=o.config;});}return A;},A);}V.prototype.updateAggregation=function(){var t=this.getTable();var B=this.getTableBinding();var A={aggregate:d(t),group:c(t),groupLevels:this.getGroupLevels()};B.setAggregation(A);};V.prototype.onOpenMenu=function(C,m){var t=this;var o=this.getTable();if(C.isOfType(T.CELLTYPE.COLUMNHEADER)){var e=o.getColumns()[C.columnIndex];var G=g(e);var A=b(e);if(G.length>0){var f=function(p){var i=this.getGroupLevels();if(this.getGroupLevels().indexOf(p)===-1){i.push(p);this.setGroupLevels(i);}else{i.splice(i.indexOf(p),1);this.setGroupLevels(i);}this.updateAggregation();}.bind(this);G.forEach(function(s,i){if(!this.aGroupMenuItems[i]||this.aGroupMenuItems[i].bIsDestroyed){this.aGroupMenuItems[i]=new M(this.getId()+"-group"+"-"+i,{text:T.getResourceText("TBL_GROUP")+": "+s,icon:this.getGroupLevels().indexOf(s)>-1?"sap-icon://accept":null,select:function(){f(s);}});}else{this.aGroupMenuItems[i].mEventRegistry.select[0].fFunction=function(){f(s);};this.aGroupMenuItems[i].setText(T.getResourceText("TBL_GROUP")+": "+s);this.aGroupMenuItems[i].setIcon(this.getGroupLevels().indexOf(s)>-1?"sap-icon://accept":null);}m.addItem(this.aGroupMenuItems[i]);}.bind(this));}if(A.length>0){var h=function(k){var E=e.data("extendedState");var l=true;if(!E){E={aggregations:[]};}for(var i=0;i<E.aggregations.length;i++){var n=E.aggregations[i];if(n.name===k.name){E.aggregations.splice(i,1);l=false;break;}}if(l){E.aggregations.push(k);}e.data("extendedState",E);this.updateAggregation();}.bind(this);var j=function(i){var E=e.data("extendedState");if(!E||!E.aggregations){return{icon:null,enabled:true};}return{icon:E.aggregations.some(function(k){return k.name===i.name&&k.menuText===i.menuText;})?"sap-icon://accept":null,enabled:!E.aggregations.some(function(k){return k.name===i.name;})||E.aggregations.some(function(k){return k.menuText===i.menuText;})};};A.forEach(function(i,I){if(!this.aAggregateMenuItems[I]||this.aAggregateMenuItems[I].bIsDestroyed){var k=j(i);this.aAggregateMenuItems[I]=new M(this.getId()+"-aggregate"+"-"+I,{text:i.menuText,icon:k.icon,enabled:k.enabled,select:function(){h(i);}});}else{var k=j(i);this.aAggregateMenuItems[I].mEventRegistry.select[0].fFunction=function(){h(i);};this.aAggregateMenuItems[I].setText(i.menuText);this.aAggregateMenuItems[I].setIcon(k.icon);this.aAggregateMenuItems[I].setEnabled(k.enabled);}m.addItem(this.aAggregateMenuItems[I]);}.bind(this));}}else if(C.isOfType(T.CELLTYPE.ANYCONTENTCELL)){var r=this.getTable().getRows()[C.rowIndex];if(r.isGroupHeader()){if(this.aContextMenuItems[0]){this.aContextMenuItems[0].destroy();}this.aContextMenuItems[0]=new M(this.getId()+"-expandrow",{text:"expand index ("+r.getIndex()+")",select:function(){t.expandRow(r);}});m.addItem(this.aContextMenuItems[0]);if(this.aContextMenuItems[1]){this.aContextMenuItems[1].destroy();}this.aContextMenuItems[1]=new M(this.getId()+"-collapserow",{text:"collapse ("+r.getIndex()+")",select:function(){t.collapseRow(r);}});m.addItem(this.aContextMenuItems[1]);}}};V.prototype.notifyColumnAboutMenuItems=function(C){return g(C).length>0||b(C).length>0;};return V;});
