//@ui5-bundle sap/ui/testrecorder/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/testrecorder/Bootstrap',[],function(){"use strict";return{init:function(s,d){sap.ui.require(["sap/ui/testrecorder/Recorder"],function(R){if(s[0].toLowerCase()==="true"||s[0].toLowerCase()==="silent"){R.start(s);}});}};});
sap.ui.predefine('sap/ui/testrecorder/CommunicationBus',["sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBConfig"],function(C,a){"use strict";var r;
var R=C.extend("sap.ui.testrecorder.CommunicationBus",{constructor:function(){if(!r){var c=new a({modulePath:"sap/ui/test",receivingWindow:"testRecorder",uriParams:{origin:"sap-ui-testrecorder-origin",frameId:"sap-ui-testrecorder-frame-identifier"}});C.call(this,c);}else{return r;}}});
r=new R();return r;},true);
sap.ui.predefine('sap/ui/testrecorder/CommunicationChannels',[],function(){"use strict";return{REQUEST_ALL_CONTROLS_DATA:"REQUEST_ALL_CONTROLS_DATA",RECEIVE_ALL_CONTROLS_DATA:"RECEIVE_ALL_CONTROL_DATA",REQUEST_CONTROL_DATA:"REQUEST_CONTROL_DATA",RECEIVE_CONTROL_DATA:"RECEIVE_CONTROL_DATA",REQUEST_CODE_SNIPPET:"REQUEST_CODE_SNIPPET",RECEIVE_CODE_SNIPPET:"RECEIVE_CODE_SNIPPET",CLEAR_SNIPPETS:"CLEAR_SNIPPETS",SET_DIALECT:"SET_DIALECT",DIALECT_CHANGED:"DIALECT_CHANGED",UPDATE_SETTINGS:"UPDATE_SETTINGS",HIGHLIGHT_CONTROL:"HIGHLIGHT_CONTROL",SELECT_CONTROL_IN_TREE:"SELECT_CONTROL_IN_TREE",SHOW_CONTEXT:"SHOW_CONTEXT",CONTEXT_MENU_HIGHLIGHT:" CONTEXT_MENU_HIGHLIGHT",CONTEXT_MENU_PRESS:"CONTEXT_MENU_PRESS",CONTEXT_MENU_ENTER_TEXT:"CONTEXT_MENU_ENTER_TEXT",MINIMIZE_IFRAME:"MINIMIZE_IFRAME",SHOW_IFRAME:"SHOW_IFRAME",OPEN_NEW_WINDOW:"OPEN_NEW_WINDOW",CLOSE_IFRAME:"CLOSE_IFRAME",DOCK_IFRAME_BOTTOM:"DOCK_IFRAME_BOTTOM",DOCK_IFRAME_RIGHT:"DOCK_IFRAME_RIGHT",DOCK_IFRAME_LEFT:"DOCK_IFRAME_LEFT"};});
sap.ui.predefine('sap/ui/testrecorder/Constants',[],function(){"use strict";var I="sap-ui-test-recorder-frame";var a=1001;var R=a+1;var b=R+1;var c="3px";var F={BOTTOM:"50%",SIDE:"100%"};var d={BOTTOM:"100%",SIDE:"40%"};var e={LEFT_SIDE:"40%",RIGHT_SIDE:"60%"};return{HIGHLIGHTER_ID:"ui5-test-recorder-highlighter",CONTEXTMENU_ID:"ui5-test-recorder-contextmenu",IFRAME_ID:I,RESIZE_OVERLAY_ID:I+"resize-overlay",DOCK:{BOTTOM:"BOTTOM",RIGHT:"RIGHT",LEFT:"LEFT"},RESIZE_HANDLE:{BOTTOM:{id:I+"resizehandle-bottom",width:d.BOTTOM,height:c,left:"0",top:F.BOTTOM},RIGHT:{id:I+"resizehandle-right",width:c,height:F.SIDE,left:e.RIGHT_SIDE,top:"0"},LEFT:{id:I+"resizehandle-left",width:c,height:F.SIDE,left:e.LEFT_SIDE,top:"0"}},FRAME:{BOTTOM:{width:d.BOTTOM,height:F.BOTTOM,left:"0",top:"unset",bottom:"0"},RIGHT:{width:d.SIDE,height:F.SIDE,left:e.RIGHT_SIDE,top:"0"},LEFT:{width:d.SIDE,height:F.SIDE,left:"0",top:"0"},MINIMIZED:{width:"180px",height:"32px"}},IFRAME_ZINDEX:a,RESIZE_OVERLAY_ZINDEX:R,RESIZE_HANDLE_ZINDEX:b};},true);
sap.ui.predefine('sap/ui/testrecorder/DialectRegistry',["sap/ui/base/Object","sap/ui/testrecorder/Dialects"],function(B,D){"use strict";var a=D.UIVERI5;var d=null;
var b=B.extend("sap.ui.testrecorder.DialectRegistry",{constructor:function(){if(!d){Object.apply(this,arguments);this.setActiveDialect(a);}else{return d;}}});
b.prototype.getActiveDialect=function(){return this._sDialect;};
b.prototype.setActiveDialect=function(s){for(var k in D){if(s===D[k]){this._sDialect=s;}}};
d=new b();return d;});
sap.ui.predefine('sap/ui/testrecorder/Dialects',[],function(){"use strict";return{OPA5:"OPA5",RAW:"RAW",UIVERI5:"UIVERI5"};});
sap.ui.predefine('sap/ui/testrecorder/Recorder',["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/testrecorder/CommunicationBus"],function(L,M,C){"use strict";var u=null;var c=null;var r=null;var R=null;
var a=M.extend("sap.ui.testrecorder.Recorder",{constructor:function(){if(!R){M.apply(this,arguments);}else{L.warning("Only one Recorder allowed");return R;}}});
a.prototype.start=function(t){if(this._hasStarted){return;}this._hasStarted=true;this._testRecorderConfig=t||sap.ui.getCore().getConfiguration().getTestRecorderMode();if(this._testRecorderConfig&&!this._testRecorderConfig.indexOf("silent")>-1&&!this._isInIframe()){sap.ui.require(["sap/ui/testrecorder/UIContextInjector","sap/ui/testrecorder/inspector/ControlInspector","sap/ui/testrecorder/interaction/RecordListener"],function(U,b,d){u=U;c=b;r=d;u.injectFrame(this._testRecorderConfig,this._stop.bind(this));C.allowFrame(u.getCommunicationInfo());c.init();r.init();}.bind(this));}};
a.prototype._stop=function(){this._hasStarted=false;c.stop();r.stop();};
a.prototype._isInIframe=function(){try{if(window.self!==window.top){var t="#sap-ui-test-recorder-frame";if(window.top.$&&window.top.$(t).length&&window.top.$(t)[0].contentWindow===window.self){return true;}else{return false;}}}catch(e){return true;}};
R=new a();return R;},true);
sap.ui.predefine('sap/ui/testrecorder/UIContextInjector',["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/base/Object","sap/base/util/restricted/_debounce","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/Constants"],function(q,U,B,_,C,a,c){"use strict";var u=null;var r=false;
var b=B.extend("sap.ui.testrecorder.UIContextInjector",{constructor:function(){if(!u){this._sIdentifier=j();Object.apply(this,arguments);}else{return u;}}});
b.prototype.injectFrame=function(t,o){window.communicationWindows=window.communicationWindows||{};this._generateTestRecorderUrl();this.fnOnClose=o;this._isInIframe=t.indexOf("window")===-1;this._onResizeHandleMouseover=d.bind(this);this._onResizeHandleMousedown=f.bind(this);this._onResizeHandleMouseleave=g.bind(this);this._onDocumentMouseup=h.bind(this);this._onDocumentMousemove=i.bind(this);if(this._isInIframe){this.dockFrameBottom();}else{this._openWindow();}window.communicationWindows.testRecorder.addEventListener("beforeunload",function(){if(!this._dockStarted&&!this._closeTriggered){this.close();}}.bind(this));C.subscribe(a.MINIMIZE_IFRAME,this.minimizeFrame.bind(this));C.subscribe(a.SHOW_IFRAME,this.unminimizeFrame.bind(this));C.subscribe(a.CLOSE_IFRAME,this.close.bind(this));C.subscribe(a.OPEN_NEW_WINDOW,this.openNewWindow.bind(this));C.subscribe(a.DOCK_IFRAME_BOTTOM,this.dockFrameBottom.bind(this));C.subscribe(a.DOCK_IFRAME_RIGHT,this.dockFrameRight.bind(this));C.subscribe(a.DOCK_IFRAME_LEFT,this.dockFrameLeft.bind(this));};
b.prototype.minimizeFrame=function(){this._iframe.style.width=c.FRAME.MINIMIZED.width;this._iframe.style.height=c.FRAME.MINIMIZED.height;Object.values(this._resizeHandles).forEach(function(e){e.style.display="none";});};
b.prototype.unminimizeFrame=function(){switch(this._sRememberedDockSide){case c.DOCK.RIGHT:this.dockFrameRight();break;case c.DOCK.LEFT:this.dockFrameLeft();break;case c.DOCK.BOTTOM:default:this.dockFrameBottom();break;}};
b.prototype.dockFrameBottom=function(){this._dockFrame(c.DOCK.BOTTOM);};
b.prototype.dockFrameRight=function(){this._dockFrame(c.DOCK.RIGHT);};
b.prototype.dockFrameLeft=function(){this._dockFrame(c.DOCK.LEFT);};
b.prototype._dockFrame=function(s){if(!this._iframe){this._dockStarted=true;this.close();this._openFrame();}this._sRememberedDockSide=s;for(var F in c.FRAME[s]){this._iframe.style[F]=c.FRAME[s][F];}Object.values(this._resizeHandles).forEach(function(e){e.style.display="none";});this._resizeHandles[s].style.display="block";for(var H in c.RESIZE_HANDLE[s]){this._resizeHandles[s].style[H]=c.RESIZE_HANDLE[s][H];}};
b.prototype.openNewWindow=function(){this._dockStarted=true;this.close();this._openWindow();};
b.prototype._openWindow=function(){window.communicationWindows.testRecorder=window.open(this._sUrl,"sapUiTestRecorder","width=1024,height=700,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=yes");window.communicationWindows.testRecorder.document.title="Test Recorder";k();this._isInIframe=false;this._dockStarted=false;this._closeTriggered=false;};
b.prototype._openFrame=function(){var F=document.createElement("IFRAME");var e=document.createElement("DIV");var m=this._createResizeHandle(q.extend(c.RESIZE_HANDLE.BOTTOM,{cursor:"n-resize",resize:function(p,P){p.style.top=P.y+"px";this._iframe.style.height="calc(100% - "+P.y+"px)";}.bind(this)}));var n=this._createResizeHandle(q.extend(c.RESIZE_HANDLE.RIGHT,{cursor:"e-resize",resize:function(p,P){p.style.left=P.x+"px";this._iframe.style.left=P.x+"px";this._iframe.style.width="calc(100% - "+P.x+"px)";}.bind(this)}));var o=this._createResizeHandle(q.extend(c.RESIZE_HANDLE.LEFT,{cursor:"w-resize",resize:function(p,P){p.style.left=P.x+"px";this._iframe.style.width=P.x+"px";}.bind(this)}));e.id=c.RESIZE_OVERLAY_ID;e.style.position="absolute";e.style.width="100%";e.style.height="100%";e.style.top="0";e.style.left="0";e.style["z-index"]=c.RESIZE_OVERLAY_ZINDEX;e.style.display="none";F.id=c.IFRAME_ID;F.src=this._sUrl;F.style.position="absolute";F.style.border="none";F.style.borderRadius="1px";F.style["z-index"]=c.IFRAME_ZINDEX;F.style.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(m);document.body.appendChild(n);document.body.appendChild(o);document.body.appendChild(e);document.body.appendChild(F);window.communicationWindows.testRecorder=F.contentWindow;k();this._iframe=F;this._resizeOverlay=e;this._resizeHandles={BOTTOM:m,RIGHT:n,LEFT:o};this._dockStarted=false;this._isInIframe=true;this._closeTriggered=false;};
b.prototype.close=function(){if(this._closeTriggered){return;}this._closeTriggered=true;if(this._isInIframe){var e=this._iframe&&this._iframe.contentWindow;if(e){e.onerror=q.noop;this._iframe.src="about:blank";e.document.write('');e.close();if(typeof CollectGarbage=="function"){CollectGarbage();}this._iframe.remove();this._resizeOverlay.remove();Object.values(this._resizeHandles).forEach(function(m){m.remove();});this._iframe=null;this._resizeOverlay=null;this._resizeHandles={};}}else if(window.communicationWindows.testRecorder){window.communicationWindows.testRecorder.close();}if(!this._dockStarted){window.communicationWindows={};this.fnOnClose();}};
b.prototype.getCommunicationInfo=function(){return{origin:this._sOrigin,identifier:this._sIdentifier,url:this._sUrl};};
b.prototype._generateTestRecorderUrl=function(){var m=new U().search(true);var I=["sap-language"];var e=["sap-ui-testRecorder"];var s=Object.keys(m).map(function(o){if(e.indexOf(o)===-1&&o.startsWith("sap-ui-")||I.indexOf(o)>-1){return"&"+o+"="+m[o];}}).join("");this._sUrl=sap.ui.require.toUrl("sap/ui/testrecorder/ui/overlay.html")+"?sap-ui-testrecorder-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-testrecorder-frame-identifier="+this._sIdentifier+s;var n=new U(this._sUrl);this._sOrigin=(n.protocol()||window.location.protocol.replace(':',''))+'://'+(n.host()||window.location.host);};
b.prototype._createResizeHandle=function(o){var e=document.createElement("DIV");e.id=o.id;e.style.position="absolute";e.style.width=o.width;e.style.height=o.height;e.style.left=o.left;e.style.top=o.top;e.style["z-index"]=c.RESIZE_HANDLE_ZINDEX;e.style.cursor=o.cursor;e.style.display="none";e.onmouseover=this._onResizeHandleMouseover(e);e.onmousedown=this._onResizeHandleMousedown(e,o.resize);e.onmouseleave=this._onResizeHandleMouseleave(e);return e;};
function d(e){return function(){e.style.background="#0854a0";};}
function f(m,R){return function(e){e.preventDefault();r=true;this._resizeOverlay.style.display="block";document.onmouseup=this._onDocumentMouseup;document.onmousemove=this._onDocumentMousemove(m,R);}.bind(this);}
function g(e){return function(){if(!r){e.style.background="transparent";}};}
function h(){r=false;this._resizeOverlay.style.display="none";document.onmouseup=null;document.onmousemove=null;}
function i(m,R){return _(function(e){e.preventDefault();var L=150;R(m,{x:Math.max(Math.min(e.clientX,window.innerWidth-L),L),y:Math.max(Math.min(e.clientY,window.innerHeight-L),L)});},50);}
function j(){return''+Date.now();}
function k(){var e=window.document.getElementById("sap-ui-bootstrap");if(e.dataset.sapUiLanguage){l(function(m){m.dataset.sapUiLanguage=e.dataset.sapUiLanguage;});}if(e.dataset.sapUiConfig){e.dataset.sapUiConfig.split(",").forEach(function(s){if(s.startsWith("language:")){l(function(m){m.dataset.sapUiConfig=m.dataset.sapUiConfig?m.dataset.sapUiConfig+","+s:s;});}});}if(window["sap-ui-config"].language){window.communicationWindows.testRecorder["sap-ui-config"]=window.communicationWindows.testRecorder["sap-ui-config"]||{};window.communicationWindows.testRecorder["sap-ui-config"].language=window["sap-ui-config"].language;}}
function l(D){var e=window.communicationWindows.testRecorder.document.getElementById("sap-ui-bootstrap");if(e){D(e);}else{setTimeout(function(){l(D);},10);}}
u=new b();return u;},true);
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/CodeSnippetProvider',["sap/ui/base/Object","sap/ui/testrecorder/codeSnippets/OPA5ControlSnippetGenerator","sap/ui/testrecorder/codeSnippets/RawControlSnippetGenerator","sap/ui/testrecorder/codeSnippets/UIVeri5ControlSnippetGenerator","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects"],function(B,O,R,U,D,a){"use strict";var c=null;
var C=B.extend("sap.ui.testrecorder.codeSnippets.ControlSnippetProvider",{constructor:function(){if(!c){Object.apply(this,arguments);}else{return c;}}});
C.prototype.getSnippet=function(d){var g=C.getGenerator(D.getActiveDialect());return g.getSnippet(d).then(function(s){return s;});};
C.getGenerator=function(d){switch(d){case a.OPA5:return O;case a.RAW:return R;case a.UIVERI5:return U;default:return R;}};
c=new C();return c;});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator',["sap/ui/thirdparty/jquery","sap/ui/base/Object"],function($,B){"use strict";
var C=B.extend("sap.ui.testrecorder.codeSnippets.ControlSnippetGenerator",{});
C.prototype.getSnippet=function(d){return new Promise(function(r,a){if(!d||!d.controlSelector){a(new Error("Control selector is required!"));}var s=this._generate($.extend(true,{},d));r(s);}.bind(this));};
C.prototype._generate=function(){return"";};
C.prototype._getSelectorAsString=function(c){var s=JSON.stringify(c,undefined,4);return s.replace(/\"([^(\")"]+)\":/g,"$1:");};
C.prototype._getIndentation=function(t){var r="";for(var i=0;i<t*4;i+=1){r+=" ";}return r;};
return C;});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/OPA5ControlSnippetGenerator',["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator","sap/ui/testrecorder/interaction/Commands"],function(C,a){"use strict";
var O=C.extend("sap.ui.testrecorder.codeSnippets.OPA5ControlSnippetGenerator",{});
O.prototype._generate=function(d){var i=d.controlSelector.interaction&&d.controlSelector.interaction.idSuffix;var A=this._getActionAsString(d.action,i);if(A){d.controlSelector.actions=[];}delete d.controlSelector.interaction;var s=this._getSelectorAsString(d.controlSelector);return"this.waitFor("+this._getSelectorWithAction(s,A)+");";};
O.prototype._getActionAsString=function(A,i){i=i?'idSuffix: "'+i+'"':"";var p;switch(A){case a.PRESS:p=i&&"{\n"+this._getIndentation(3)+i+"\n"+this._getIndentation(2)+"}";return"new Press("+p+")";case a.ENTER_TEXT:p="{\n"+this._getIndentation(2)+(i&&i+",\n"+this._getIndentation(2))+'text: "test"'+"\n"+this._getIndentation(1)+"}";return"new EnterText("+p+")";default:return"";}};
O.prototype._getSelectorWithAction=function(s,A){return s.replace('actions: []','actions: '+A);};
return new O();});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/POMethodUtil',["sap/ui/base/Object","sap/ui/testrecorder/interaction/Commands"],function(B,C){"use strict";var p=null;
var P=B.extend("sap.ui.testrecorder.codeSnippets.POMethodUtil",{constructor:function(){if(!p){Object.apply(this,arguments);}else{return p;}}});
P.prototype.getPOMethod=function(s,S){if(S&&S.formatAsPOMethod){var a=s.map(function(a){return a.replace(/^/gm,"    ");}).join("\n\n");return this._getMethodName(S)+": function () {\n"+a+"\n}";}else{return s.join("\n\n");}};
P.prototype._getMethodName=function(s){if(s.multipleSnippets){switch(s.action){case C.PRESS:case C.ENTER_TEXT:return"iInteractWithTheControls";default:return"iAssertTheUIState";}}else{switch(s.action){case C.PRESS:return"iPressTheControl";case C.ENTER_TEXT:return"iEnterTextInTheControl";default:return"iAssertTheControlState";}}};
p=new P();return p;});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/RawControlSnippetGenerator',["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator"],function(C){"use strict";
var R=C.extend("sap.ui.testrecorder.codeSnippets.RawControlSnippetGenerator",{});
R.prototype._generate=function(d){return JSON.stringify(d.controlSelector,undefined,4);};
return new R();});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/RawSnippetUtil',["sap/ui/base/Object"],function(B){"use strict";var r=null;
var R=B.extend("sap.ui.testrecorder.codeSnippets.RawSnippetUtil",{constructor:function(){if(!r){Object.apply(this,arguments);}else{return r;}}});
R.prototype.getJSON=function(s,S){if(S.multipleSnippets){var a=s.map(function(b){return b.replace(/^/gm,"        ");}).join(",\n");return"{\n    \"selectors\": [\n"+a+"\n    ]\n}";}else{return s[0];}};
r=new R();return r;});
sap.ui.predefine('sap/ui/testrecorder/codeSnippets/UIVeri5ControlSnippetGenerator',["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator","sap/ui/testrecorder/interaction/Commands"],function(C,a){"use strict";
var U=C.extend("sap.ui.testrecorder.codeSnippets.UIVeri5ControlSnippetGenerator",{});
U.prototype._generate=function(d){var e="element(by.control("+this._getSelectorAsString(d.controlSelector)+"))";return e+this._getActionAsString(d.action)+";";};
U.prototype._getActionAsString=function(A){switch(A){case a.PRESS:return".click()";case a.ENTER_TEXT:return'.sendKeys("test")';default:return"";}};
return new U();});
sap.ui.predefine('sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator',["sap/ui/base/Object","sap/ui/test/RecordReplay"],function(B,R){"use strict";
var C=B.extend("sap.ui.testrecorder.controlSelectors.ControlSelectorGenerator",{});
C.prototype.getSelector=function(d){var D=_(d);return R.findControlSelectorByDOMElement({domElement:D,settings:d.settings}).then(function(s){return s;});};
function _(d){if(d.domElementId&&typeof d.domElementId==="string"){return document.getElementById(d.domElementId);}else if(d.controlId){return sap.ui.getCore().byId(d.controlId).getFocusDomRef();}}
return new C();});
sap.ui.predefine('sap/ui/testrecorder/inspector/ControlAPI',["sap/ui/base/Object","sap/ui/core/support/ToolsAPI","sap/ui/test/_ControlFinder"],function(B,T,_){"use strict";
var C=B.extend("sap.ui.testrecorder.inspector.ControlAPI",{});
var D="default";var a="none";
C.prototype.getFrameworkData=function(){var f=T.getFrameworkInformation();return{framework:{name:f.commonInformation.frameworkName,version:f.commonInformation.version}};};
C.prototype.getAllControlData=function(){var r=T.getRenderedControlTree();return{renderedControls:r};};
C.prototype.getControlData=function(d){var c;if(d.controlId){c=d.controlId;}else if(d.domElementId){c=_._getControlForElement(d.domElementId).getId();}var p=this._getFormattedProperties(c);var b=this._getFormattedBindings(c);return{properties:p,bindings:b};};
C.prototype._getFormattedProperties=function(c){var A=T.getControlProperties(c);A.own=[A.own];var f={};["own","inherited"].forEach(function(t){f[t]=[];A[t].forEach(function(p){Object.keys(p.properties).forEach(function(P){var m=p.properties[P];f[t].push({inheritedFrom:p.meta.controlName,property:P,value:m.value===undefined?"":m.value,type:m.type});});});});return f;};
C.prototype._getFormattedBindings=function(c){var A=T.getControlBindings(c);var s=A.contextPath?A.contextPath+"/":"";var S=Object.keys(A.properties)[0]&&A.properties[Object.keys(A.properties)[0]];var b=S&&S.model.names[0]||D;var f={context:[{path:A.contextPath||a,model:b}],properties:[],aggregations:[]};Object.keys(A.properties).forEach(function(p){var P=A.properties[p];f.properties.push({property:p,relativePath:P.path,absolutePath:s+P.path,model:P.model.names[0]||D});});Object.keys(A.aggregations).forEach(function(d){var m=A.aggregations[d].model;f.aggregations.push({aggregation:d,relativePath:m.path,absolutePath:s+m.path,model:m.names[0]||D});});return f;};
return new C();},true);
sap.ui.predefine('sap/ui/testrecorder/inspector/ControlInspector',["sap/ui/base/Object","sap/ui/thirdparty/jquery","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/mutationObservers/AppMutationObserver","sap/ui/testrecorder/mutationObservers/ElementMutationObserver","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/inspector/ControlAPI","sap/ui/testrecorder/inspector/ControlInspectorRepo","sap/ui/testrecorder/Constants","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects","sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator","sap/ui/testrecorder/codeSnippets/POMethodUtil","sap/ui/testrecorder/codeSnippets/RawSnippetUtil","sap/ui/testrecorder/codeSnippets/CodeSnippetProvider","sap/ui/testrecorder/ui/models/SharedModel"],function(B,$,C,a,A,E,H,_,b,c,d,D,e,f,P,R,g,S){"use strict";var o=null;var h=new H(d.HIGHLIGHTER_ID);var s=Object.assign({},S.getData().settings);
var i=B.extend("sap.ui.testrecorder.inspector.ControlInspector",{constructor:function(){if(!o){Object.apply(this,arguments);this._appObserver=new A(this.getAllControlData.bind(this));this._selectedElementObserver=new E(this.getControlData.bind(this));}else{return o;}}});
i.prototype.init=function(){this._appObserver.start();C.subscribe(a.REQUEST_ALL_CONTROLS_DATA,this.getAllControlData.bind(this));C.subscribe(a.REQUEST_CONTROL_DATA,this.getControlData.bind(this));C.subscribe(a.REQUEST_CODE_SNIPPET,this.getCodeSnippet.bind(this));C.subscribe(a.HIGHLIGHT_CONTROL,this.highlightControl.bind(this));C.subscribe(a.SET_DIALECT,this.setDialect.bind(this));C.subscribe(a.UPDATE_SETTINGS,this.updateSettings.bind(this));C.subscribe(a.CLEAR_SNIPPETS,this.clearSnippets.bind(this));};
i.prototype.getAllControlData=function(){C.publish(a.RECEIVE_ALL_CONTROLS_DATA,{renderedControls:b.getAllControlData().renderedControls,framework:b.getFrameworkData().framework});c.clear();};
i.prototype.getControlData=function(m){var k=m.domElementId?document.getElementById(m.domElementId):sap.ui.getCore().byId(m.controlId).getDomRef();this._selectedElementObserver.stop();this._selectedElementObserver.start(k);var l=b.getControlData(m);C.publish(a.RECEIVE_CONTROL_DATA,l);};
i.prototype.getCodeSnippet=function(m){var k=Object.assign({},m,{settings:s});var l=c.findSelector(m.domElementId);var n=l?Promise.resolve(l):f.getSelector(k);return n.then(function(p){l=p;return g.getSnippet({controlSelector:p,action:k.action,settings:s});}).then(function(p){c.save(m,l,p);var q=s.multipleSnippets?c.getSnippets():[p];if(D.getActiveDialect()===e.RAW){return R.getJSON(q,s);}else{return P.getPOMethod(q,$.extend({action:m.action},s));}}).then(function(p){C.publish(a.RECEIVE_CODE_SNIPPET,{codeSnippet:p});}).catch(function(p){C.publish(a.RECEIVE_CODE_SNIPPET,{error:"Could not generate code snippet for "+JSON.stringify(m)+". Details: "+p,domElementId:k.domElementId});});};
i.prototype.highlightControl=function(m){if(m.domElementId){h.highlight(m.domElementId);}else if(m.controlId){var k=_._findElements({id:m.controlId})[0];if(k){h.highlight(k.id);}}};
i.prototype.setDialect=function(k){if(D.getActiveDialect()!==k){D.setActiveDialect(k);C.publish(a.DIALECT_CHANGED,{dialect:k});c.getRequests().forEach(this.getCodeSnippet.bind(this));}};
i.prototype.updateSettings=function(m){Object.assign(s,m);var r=c.getRequests();if(j(m,"multipleSnippets")){this.clearSnippets();if(r.length){this.getCodeSnippet(r[r.length-1]);}}if(j(m,["preferViewId"])){c.clear();}if(j(m,["formatAsPOMethod","preferViewId"])){if(s.multipleSnippets){r.forEach(this.getCodeSnippet.bind(this));}else if(r.length){this.getCodeSnippet(r[r.length-1]);}}};
i.prototype.clearSnippets=function(){c.clear();C.publish(a.RECEIVE_CODE_SNIPPET,{codeSnippet:""});};
i.prototype.stop=function(){this._appObserver.stop();this._selectedElementObserver.stop();};
function j(m,k){var K=$.isArray(k)?k:[k];return K.filter(function(l){return m[l]!==null&&m[l]!==undefined;}).length;}
o=new i();return o;},true);
sap.ui.predefine('sap/ui/testrecorder/inspector/ControlInspectorRepo',["sap/ui/base/Object"],function(B){"use strict";var c=null;var r=[];var R=100;
var C=B.extend("sap.ui.testrecorder.inspector.ControlInspectorRepo",{constructor:function(){if(!c){Object.apply(this,arguments);}else{return c;}}});
C.prototype.findSelector=function(d){var m=r.filter(function(a){return a.domElementId===d&&a.selector;});return m[0]&&m[0].selector||null;};
C.prototype.save=function(m,s,S){var n=Object.assign({selector:s,snippet:S},m);var u=-1;r.forEach(function(a,i){if(a.domElementId===m.domElementId){u=i;}});if(u>-1){r[u]=n;}else{if(r.length===R){r.shift();}r.push(n);}};
C.prototype.clear=function(){r=[];};
C.prototype.getRequests=function(){return r.map(function(d){return{domElementId:d.domElementId,action:d.action};});};
C.prototype.getSelectors=function(){return r.map(function(d){return d.selector;});};
C.prototype.getSnippets=function(){return r.map(function(d){return d.snippet;});};
C.prototype.getAll=function(){return r;};
c=new C();return c;});
sap.ui.predefine('sap/ui/testrecorder/interaction/CommandExecutor',["sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/interaction/Highlight","sap/ui/testrecorder/interaction/Press","sap/ui/testrecorder/interaction/EnterText"],function(C,H,P,E){"use strict";return{execute:function(c,d){switch(c){case"HIGHLIGHT":H.execute(d.domElementId);break;case"PRESS":P.execute(d.domElementId);break;case"ENTER_TEXT":E.execute(d.domElementId);break;default:throw new Error("Command "+c+" is not known! Known commands are: "+Object.keys(C));}}};});
sap.ui.predefine('sap/ui/testrecorder/interaction/Commands',[],function(){"use strict";return{HIGHLIGHT:"HIGHLIGHT",PRESS:"PRESS",ENTER_TEXT:"ENTER_TEXT"};});
sap.ui.predefine('sap/ui/testrecorder/interaction/ContextMenu',["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/testrecorder/Constants","sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/interaction/CommandExecutor","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function($,B,c,C,a,b,d){"use strict";var e=5;var f=null;var s={};var m={};
var g=B.extend("sap.ui.testrecorder.interaction.ContextMenu",{});
g.show=function(D){s=D.domElementId;if(f===null&&!document.getElementById(c.CONTEXTMENU_ID)){f=_(D);}if(D.items){var h=Object.keys(m).filter(function(I){return!(D.items[I]||D.items[I]===undefined);});var v=Object.keys(m).filter(function(I){return D.items[I]||D.items[I]===undefined;});if(h.length===Object.keys(m).length){this.hide();return this;}h.forEach(function(I){m[I].hide();});v.forEach(function(I){m[I].show();});}var V=$(window).width();var i=$(window).height();var M=f.width();var j=f.height();var k=D.location.x+M+e>=V?D.location.x-M:D.location.x;var l=D.location.y+j+e>=i?D.location.y-j:D.location.y;f.css("top",(l+e)+"px");f.css("left",(k+e)+"px");g._show();return this;};
g.hide=function(){if(f){f.hide();}};
g._show=function(){if(f){f.show();}};
function _(D){var f=$("<div></div>");var h=$("<div></div>");var i=$("<div></div>");var j=$("<div></div>");m={highlight:h,press:i,enterText:j};h.text("Highlight");i.text("Press");j.text("Enter Text");h.on("click",function(){g.hide();var k={domElementId:s};if(D.withEvents){b.publish(d.CONTEXT_MENU_HIGHLIGHT,k);}else{a.execute(C.HIGHLIGHT,k);}});i.on("click",function(){g.hide();var k={domElementId:s};if(D.withEvents){b.publish(d.CONTEXT_MENU_PRESS,k);}else{a.execute(C.PRESS,k);}});j.on("click",function(){g.hide();var k={domElementId:s};if(D.withEvents){b.publish(d.CONTEXT_MENU_ENTER_TEXT,k);}else{a.execute(C.ENTER_TEXT,k);}});f.attr("id",c.CONTEXTMENU_ID);f.css("min-width","150px");f.css("position","absolute");f.css("z-index",1001);f.css("border","1px solid rgb(200, 142, 250)");f.css("border-radius","3px");f.css("background","#fff");f.css("box-sizing","border-box");[h,j,i].forEach(function(k){k.css("padding","16px");k.css("cursor","pointer");k.on("mouseenter",function(){k.css("background-color","#ebf5fe");}).on("mouseleave",function(){k.css("background-color","transparent");});});[h,i].forEach(function(k){k.css("border-bottom","1px solid #d9d9d9");});f.append(h);f.append(i);f.append(j);$(document.body).append(f);return f;}
return g;});
sap.ui.predefine('sap/ui/testrecorder/interaction/EnterText',["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/interaction/Commands"],function(H,_,c,C,a,b){"use strict";var h=new H(c.HIGHLIGHTER_ID);return{execute:function(d){var r=_._getIdentifiedDOMElementId("#"+d);h.highlight(r);C.publish(a.SELECT_CONTROL_IN_TREE,{rootElementId:r,interactionElementId:d,action:b.ENTER_TEXT});}};});
sap.ui.predefine('sap/ui/testrecorder/interaction/Highlight',["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function(H,_,c,C,a){"use strict";var h=new H(c.HIGHLIGHTER_ID);return{execute:function(d,o){var r=_._getIdentifiedDOMElementId("#"+d);h.highlight(r);C.publish(a.SELECT_CONTROL_IN_TREE,{rootElementId:r,interactionElementId:d});}};});
sap.ui.predefine('sap/ui/testrecorder/interaction/Press',["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/interaction/Commands"],function(H,_,c,C,a,b){"use strict";var h=new H(c.HIGHLIGHTER_ID);return{execute:function(d){var r=_._getIdentifiedDOMElementId("#"+d);h.highlight(r);C.publish(a.SELECT_CONTROL_IN_TREE,{rootElementId:r,interactionElementId:d,action:b.PRESS});}};});
sap.ui.predefine('sap/ui/testrecorder/interaction/RecordListener',["sap/ui/base/Object","sap/ui/testrecorder/interaction/ContextMenu","sap/ui/testrecorder/interaction/CommandExecutor","sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function(B,C,a,b,c,d){"use strict";var r=null;
var R=B.extend("sap.ui.testrecorder.interaction.RecordListener",{constructor:function(){if(!r){Object.apply(this,arguments);this._fnClickListener=this._onClick.bind(this);this._fnContextmenuListener=this._onContextmenu.bind(this);}else{return r;}}});
R.prototype.init=function(){document.addEventListener("click",this._fnClickListener);document.addEventListener("contextmenu",this._fnContextmenuListener);c.subscribe(d.CONTEXT_MENU_HIGHLIGHT,this._onContextHighlight.bind(this));c.subscribe(d.CONTEXT_MENU_PRESS,this._onContextPress.bind(this));c.subscribe(d.CONTEXT_MENU_ENTER_TEXT,this._onContextEnterText.bind(this));};
R.prototype.stop=function(){C.hide();document.removeEventListener("click",this._fnClickListener);document.removeEventListener("contextmenu",this._fnContextmenuListener);};
R.prototype._onClick=function(e){e.preventDefault();e.stopPropagation();C.hide();};
R.prototype._onContextmenu=function(e){e.preventDefault();var D=_(e.target);C.show({domElementId:D,location:{x:e.pageX,y:e.pageY}});};
R.prototype._onContextHighlight=function(D){a.execute(b.HIGHLIGHT,D);};
R.prototype._onContextPress=function(D){a.execute(b.PRESS,D);};
R.prototype._onContextEnterText=function(D){a.execute(b.ENTER_TEXT,D);};
function _(D){if(D.id){return D.id;}else if(D.parentElement){return _(D.parentElement);}else{return"";}}
r=new R();return r;},true);
sap.ui.predefine('sap/ui/testrecorder/library',["sap/ui/core/library","sap/ui/core/Core","sap/ui/support/library"],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.testrecorder",dependencies:["sap.ui.core","sap.ui.support"],interfaces:[],controls:[],elements:[],noLibraryCSS:true,version:"1.84.17",extensions:{"sap.ui.support":{internalRules:true}}});return sap.ui.testrecorder;});
sap.ui.predefine('sap/ui/testrecorder/mutationObservers/AppMutationObserver',["sap/ui/testrecorder/mutationObservers/MutationObserver"],function(M){"use strict";
var A=M.extend("sap.ui.testrecorder.mutationObservers.AppMutationObserver",{
metadata:{library:"sap.ui.testrecorder"},
_getOptions:function(){return{subtree:true,childList:true};}
});
return A;});
sap.ui.predefine('sap/ui/testrecorder/mutationObservers/ElementMutationObserver',["sap/ui/testrecorder/mutationObservers/MutationObserver"],function(M){"use strict";
var E=M.extend("sap.ui.testrecorder.mutationObservers.ElementMutationObserver",{
metadata:{library:"sap.ui.testrecorder"},
_onObservation:function(m){if(this._isValidMutation(m)){this._fnObservationCb({domElementId:this._oTarget.id});}},
_getOptions:function(){return{subtree:true,attributes:true};}
});
return E;});
sap.ui.predefine('sap/ui/testrecorder/mutationObservers/MutationObserver',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/testrecorder/Constants"],function($,M,c){"use strict";
var a=M.extend("sap.ui.testrecorder.mutationObservers.MutationObserver",{
metadata:{library:"sap.ui.testrecorder"},
constructor:function(C){this._fnObservationCb=C;this._observer=new window.MutationObserver(this._onObservation.bind(this));},
start:function(t){this._oTarget=t||document.body;this._observer.observe(this._oTarget,this._getOptions());},
stop:function(){this._observer.disconnect();},
_getOptions:function(){return{};},
_onObservation:function(m){if(this._isValidMutation(m)){this._fnObservationCb();}},
_isValidMutation:function(m){var i=true;m.forEach(function(o){if(this._isRecorderElement(o)){i=false;}}.bind(this));return i;},
_isRecorderElement:function(m){return[c.HIGHLIGHTER_ID,c.CONTEXTMENU_ID].filter(function(i){return m.target.id===i||(m.addedNodes.length&&m.addedNodes[0].id===i)||(m.removedNodes.length&&m.removedNodes[0].id===i);}).length;}
});
return a;});
sap.ui.predefine('sap/ui/testrecorder/ui/Overlay',["sap/ui/core/Core","sap/ui/core/mvc/XMLView","sap/m/Page"],function(C,X,P){"use strict";C.attachInit(function(){X.create({viewName:"sap.ui.testrecorder.ui.views.Main"}).then(function(x){var p=new P("page",{showHeader:false,backgroundDesign:"Solid",content:[x]});p.placeAt("content");});});});
sap.ui.predefine('sap/ui/testrecorder/ui/controllers/Main.controller',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/util/Storage","sap/ui/core/mvc/Controller","sap/ui/testrecorder/ui/models/SharedModel","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/Binding","sap/m/MessageToast","sap/m/Dialog","sap/m/CheckBox","sap/m/Button","sap/m/VBox","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/testrecorder/interaction/ContextMenu"],function($,D,S,C,a,b,c,J,R,B,M,d,e,f,V,E,g){"use strict";return C.extend("sap.ui.testrecorder.ui.controllers.Main",{onInit:function(){this._minimized=false;this._treeSelectionId=null;this._localStorage=new S(S.Type.local,"sap-ui-test-recorder");$.sap.includeStyleSheet("sap/ui/testrecorder/ui/styles/overlay.css");this.elementTree=new E(null,{filter:{issues:false,search:true},onSelectionChanged:this._onTreeSelectionChanged.bind(this),onContextMenu:this._onTreeContextMenu.bind(this)});this._setupModels();this.toggleHeaderToolbars();},onBeforeRendering:function(){b.publish(c.REQUEST_ALL_CONTROLS_DATA);},onAfterRendering:function(){b.subscribe(c.RECEIVE_ALL_CONTROLS_DATA,this._onUpdateAllControls.bind(this));b.subscribe(c.RECEIVE_CONTROL_DATA,this._onReceiveControlDetails.bind(this));b.subscribe(c.RECEIVE_CODE_SNIPPET,this._onUpdateCodeSnippet.bind(this));b.subscribe(c.SELECT_CONTROL_IN_TREE,this._onUpdateSelection.bind(this));b.subscribe(c.DIALECT_CHANGED,this._changeDialect.bind(this));},toggleHeaderToolbars:function(){this.byId("ttMaximizeHeaderBar").setVisible(this._minimized);},toggleMinimize:function(){this._minimized=!this._minimized;this.toggleHeaderToolbars();if(this._minimized){b.publish(c.MINIMIZE_IFRAME);}else{b.publish(c.SHOW_IFRAME);}},dockBottom:function(){b.publish(c.DOCK_IFRAME_BOTTOM);},dockRight:function(){b.publish(c.DOCK_IFRAME_RIGHT);},dockLeft:function(){b.publish(c.DOCK_IFRAME_LEFT);},openWindow:function(){b.publish(c.OPEN_NEW_WINDOW);},close:function(){b.publish(c.CLOSE_IFRAME);},copyCodeSnippet:function(){var s=this.byId("codeEditor").getValue();var h=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',s);}else{o.originalEvent.clipboardData.setData('text/plain',s);}o.preventDefault();};if(D.browser.msie&&window.clipboardData){window.clipboardData.setData("text",s);}else{document.addEventListener('copy',h);document.execCommand('copy');document.removeEventListener('copy',h);}},clearCodeSnippet:function(){b.publish(c.CLEAR_SNIPPETS);this.byId("codeEditor").setValue("");},openSettingsDialog:function(){if(!this.settingsDialog){this.settingsDialog=new d({title:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.Title"),content:[new V({items:[new e({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.IDCheckBox.Text"),name:"preferViewId",selected:this.model.getProperty("/settings/preferViewId"),select:this._onSelectCheckBox.bind(this)}),new e({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.POMethodCheckBox.Text"),name:"formatAsPOMethod",selected:this.model.getProperty("/settings/formatAsPOMethod"),select:this._onSelectCheckBox.bind(this)})]})],endButton:new f({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.CloseButton.Text"),press:this.closeSettingsDialog.bind(this)})});this.getView().addDependent(this.settingsDialog);}this.settingsDialog.open();},closeSettingsDialog:function(){if(this.settingsDialog){this.settingsDialog.close();}},_setupModels:function(){this.model=a;this.getView().setModel(this.model);this.model.setProperty("/isInIframe",!window.opener);var s=this._localStorage.get("dialect");var p=this._localStorage.get("settings-preferViewId");var F=this._localStorage.get("settings-formatAsPOMethod");if(s){this.model.setProperty("/selectedDialect",s);b.publish(c.SET_DIALECT,s);}if(p!==null&&p!=="undefined"){this.model.setProperty("/settings/preferViewId",p);}if(F!==null&&F!=="undefined"){this.model.setProperty("/settings/formatAsPOMethod",F);}b.publish(c.UPDATE_SETTINGS,this.model.getProperty("/settings"));var h=new B(a,"/",a.getContext("/selectedDialect"));h.attachChange(function(){b.publish(c.SET_DIALECT,this.model.getProperty("/selectedDialect"));}.bind(this));var i=new R({bundleName:"sap.ui.core.messagebundle"});this.getView().setModel(i,"i18n");this.getView().setModel(new J({framework:{}}),"framework");this.getView().setModel(new J({controls:{bindings:{},properties:{},codeSnippet:"",renderedControls:[]}}),"controls");},_onUpdateAllControls:function(m){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());this._clearControlData();if(m.framework){this.getView().getModel("controls").setProperty("/framework",m.framework);}if(m.renderedControls){this.getView().getModel("controls").setProperty("/renderedControls",m.renderedControls);this.elementTree.setData({controls:m.renderedControls});}if(!this._minimized){M.show(this.getView().getModel("i18n").getProperty("TestRecorder.ControlTree.MessageToast"),{duration:1000});}},_onReceiveControlDetails:function(m){if(m.properties){this.getView().getModel("controls").setProperty("/properties",m.properties);}if(m.bindings){this.getView().getModel("controls").setProperty("/bindings",m.bindings);}},_onUpdateCodeSnippet:function(m){if(m.codeSnippet!==undefined){this.getView().getModel("controls").setProperty("/codeSnippet",m.codeSnippet);}else if(m.error){var n=this.getView().getModel("i18n").getResourceBundle().getText("TestRecorder.Inspect.Snippet.NotFound.Text","#"+m.domElementId);this.getView().getModel("controls").setProperty("/codeSnippet",n);}},_onUpdateSelection:function(m){this.elementTree.setSelectedElement(m.rootElementId,false);this._clearControlData();b.publish(c.REQUEST_CONTROL_DATA,{domElementId:m.rootElementId});b.publish(c.REQUEST_CODE_SNIPPET,{domElementId:m.interactionElementId,action:m.action});b.publish(c.HIGHLIGHT_CONTROL,{domElementId:m.rootElementId});},_onTreeSelectionChanged:function(h){this._clearControlData();b.publish(c.REQUEST_CONTROL_DATA,{domElementId:h});b.publish(c.REQUEST_CODE_SNIPPET,{domElementId:h});b.publish(c.HIGHLIGHT_CONTROL,{domElementId:h});},_onTreeContextMenu:function(m){m=m||{};m.withEvents=true;m.items={highlight:false};g.show(m);},_clearControlData:function(){this.getView().getModel("controls").setProperty("/properties",{});this.getView().getModel("controls").setProperty("/bindings",{});this.getView().getModel("controls").setProperty("/codeSnippet","");},_changeDialect:function(m){this._localStorage.put("dialect",m.dialect);},_onSelectCheckBox:function(o){var s=o.getParameter("selected");var h=o.getSource().getName();var m={};m[h]=s;this.model.setProperty("/settings/"+h,s);this._localStorage.put("settings-"+h,s);b.publish(c.UPDATE_SETTINGS,m);},_onChangeMultiple:function(o){var s=o.getParameter("state");b.publish(c.UPDATE_SETTINGS,{multipleSnippets:s});},_onCodeEditorChange:function(o){var h=this.byId("codeEditor");var l=h.getValue().split("\n").length;if(l){h._oEditor.scrollToLine(l);}}});});
sap.ui.predefine('sap/ui/testrecorder/ui/models/SharedModel',["sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/testrecorder/Dialects"],function(R,J,D){"use strict";var i=new R({bundleName:"sap.ui.core.messagebundle"});var m=new J({iFrameTitle:i.getProperty("TestRecorder.TitleBar.Title"),dialects:[{key:D.RAW,label:i.getProperty("TestRecorder.Inspect.Snippet.Dialect.Raw")},{key:D.OPA5,label:i.getProperty("TestRecorder.Inspect.Snippet.Dialect.OPA5")},{key:D.UIVERI5,label:i.getProperty("TestRecorder.Inspect.Snippet.Dialect.UIVeri5")}],selectedDialect:D.UIVERI5,settings:{preferViewId:false,formatAsPOMethod:true,multipleSnippets:false}});return m;});
sap.ui.require.preload({
	"sap/ui/testrecorder/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.testrecorder","type":"library","embeds":[],"applicationVersion":{"version":"1.84.17"},"title":"UI5 library: sap.ui.testrecorder","description":"UI5 library: sap.ui.testrecorder","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.17"}}},"library":{"i18n":false,"css":false,"content":{"controls":[],"elements":[],"interfaces":[]}}}}',
	"sap/ui/testrecorder/ui/views/Main.view.xml":'<mvc:View height="100%" viewName="sap.ui.testrecorder.ui.views.Main" controllerName="sap.ui.testrecorder.ui.controllers.Main" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:c="sap.ui.core" xmlns:l="sap.ui.layout" xmlns:f="sap.ui.layout.form" xmlns:code="sap.ui.codeeditor"><Page showHeader="false"><l:FixFlex><l:fixContent><Bar id="ttMaximizeHeaderBar" class="sapContrast ttPageBar ttMiniPageBar"><contentMiddle><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"/><Text text="{/iFrameTitle}"/><c:Icon src="sap-icon://full-screen" press="toggleMinimize"/></contentMiddle></Bar><Bar id="ttStandardHeaderBar" class="sapContrast ttPageBar ttStandardPageBar"><contentLeft><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"/><Text text="{/iFrameTitle}"/></contentLeft><contentMiddle><Text text="{controls&gt;/framework/name} {controls&gt;/framework/version}"/></contentMiddle><contentRight><c:Icon src="sap-icon://settings" press="openSettingsDialog" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Settings.Tooltip}"/><c:Icon src="sap-icon://minimize" press="toggleMinimize" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Minimize.Tooltip}" visible="{/isInIframe}"/><c:Icon src="sap-icon://slim-arrow-down" press="dockBottom" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Dock.Bottom.Tooltip}"/><c:Icon src="sap-icon://slim-arrow-left" press="dockLeft" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Dock.Left.Tooltip}"/><c:Icon src="sap-icon://slim-arrow-right" press="dockRight" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Dock.Right.Tooltip}"/><c:Icon src="sap-icon://popup-window" press="openWindow" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.New.Tooltip}" visible="{/isInIframe}"/><c:Icon src="sap-icon://decline" press="close" tooltip="{i18n&gt;TestRecorder.TitleBar.Window.Close.Tooltip}"/></contentRight></Bar></l:fixContent><l:flexContent><l:ResponsiveSplitter defaultPane="tree-pane"><l:PaneContainer><l:SplitPane requiredParentWidth="300" id="tree-pane"><Panel height="100%"><c:HTML id="elementTreeContainer" content="&lt;control-tree&gt;  &lt;/control-tree&gt;"/></Panel></l:SplitPane><l:SplitPane requiredParentWidth="400"><Panel><ScrollContainer vertical="true"><VBox><HBox alignItems="Center"><Label text="{i18n&gt;TestRecorder.Inspect.Snippet.Dropdown.Label}" labelFor="SelectDialect" class="sapUiSmallMarginEnd"/><Select id="SelectDialect" forceSelection="false" selectedKey="{/selectedDialect}" items="{/dialects}" class="sapUiSmallMarginEnd"><c:Item key="{key}" text="{label}"/></Select><Label text="{i18n&gt;TestRecorder.Inspect.Snippet.MultiSwitch.Label}" labelFor="multiSwitch" class="sapUiSmallMarginEnd"/><Switch id="multiSwitch" state="{/settings/multipleSnippets}" type="AcceptReject" change="_onChangeMultiple"/></HBox></VBox><code:CodeEditor id="codeEditor" value="{path:\'controls&gt;/codeSnippet\',events:{change:\'._onCodeEditorChange\'}}" height="calc(100vh - 180px)" width="100%" type="javascript" colorTheme="theme-ambiance" lineNumbers="false"/><HBox justifyContent="End" alignItems="Center"><Button text="{i18n&gt;TestRecorder.Inspect.Snippet.Copy.Text}" press="copyCodeSnippet"/><Button text="{i18n&gt;TestRecorder.Inspect.Snippet.Clear.Text}" press="clearCodeSnippet" class="sapUiSmallMarginBegin"/></HBox></ScrollContainer></Panel></l:SplitPane><l:SplitPane requiredParentWidth="900px"><Panel class="ttCommonInfoPanel"><IconTabBar id="tabBar" class="sapUiResponsiveContentPadding" stretchContentHeight="true"><items><IconTabFilter key="properties" text="{i18n&gt;TestRecorder.Inspect.Properties.Title}"><Table items="{controls&gt;/properties/own}" headerText="{i18n&gt;TestRecorder.Inspect.Properties.Own.Header.Text}"><columns><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Property.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Value.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Type.Text}"/></Column></columns><ColumnListItem><Text text="{controls&gt;property}"/><Text text="{controls&gt;value}"/><Text text="{controls&gt;type}"/></ColumnListItem></Table><Table items="{controls&gt;/properties/inherited}" headerText="{i18n&gt;TestRecorder.Inspect.Properties.Inherited.Header.Text}"><columns><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Property.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Value.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Type.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Properties.Inherited.Text}"/></Column></columns><ColumnListItem><Text text="{controls&gt;property}"/><Text text="{controls&gt;value}"/><Text text="{controls&gt;type}"/><Text text="{controls&gt;inheritedFrom}"/></ColumnListItem></Table></IconTabFilter><IconTabFilter key="bindings" text="{i18n&gt;TestRecorder.Inspect.Bindings.Title}"><Table items="{controls&gt;/bindings/context}" headerText="{i18n&gt;TestRecorder.Inspect.Bindings.Context.Header.Text}"><columns><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Path.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Model.Text}"/></Column></columns><ColumnListItem><Text text="{controls&gt;path}"/><Text text="{controls&gt;model}"/></ColumnListItem></Table><Table items="{controls&gt;/bindings/properties}" headerText="{i18n&gt;TestRecorder.Inspect.Bindings.Properties.Header.Text}"><columns><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Property.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.RelativePath.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.AbsolutePath.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Model.Text}"/></Column></columns><ColumnListItem><Text text="{controls&gt;property}"/><Text text="{controls&gt;relativePath}"/><Text text="{controls&gt;absolutePath}"/><Text text="{controls&gt;model}"/></ColumnListItem></Table><Table items="{controls&gt;/bindings/aggregations}" headerText="{i18n&gt;TestRecorder.Inspect.Bindings.Aggregations.Header.Text}"><columns><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Aggregation.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.RelativePath.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.AbsolutePath.Text}"/></Column><Column><Text text="{i18n&gt;TestRecorder.Inspect.Bindings.Model.Text}"/></Column></columns><ColumnListItem><Text text="{controls&gt;aggregation}"/><Text text="{controls&gt;relativePath}"/><Text text="{controls&gt;absolutePath}"/><Text text="{controls&gt;model}"/></ColumnListItem></Table></IconTabFilter></items></IconTabBar></Panel></l:SplitPane></l:PaneContainer></l:ResponsiveSplitter></l:flexContent></l:FixFlex></Page></mvc:View>'
},"sap/ui/testrecorder/library-preload"
);
//# sourceMappingURL=library-preload.js.map