/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*
 * Provides constants for key codes. Useful in the implementation of keypress/keydown event handlers.
 */
sap.ui.define(['jquery.sap.global', 'sap/ui/events/KeyCodes'],
	function(jQuery, KeyCodes) {
	"use strict";

	/**
	 * Enumeration of key codes.
	 *
	 * @enum {int}
	 * @public
	 * @since 0.9.0
	 * @deprecated since 1.58 use {@link module:sap/ui/events/KeyCodes} instead
	 */
	jQuery.sap.KeyCodes = KeyCodes;

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.BACKSPACE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.TAB
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ENTER
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SHIFT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.CONTROL
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ALT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.BREAK
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.CAPS_LOCK
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ESCAPE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SPACE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.PAGE_UP
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.PAGE_DOWN
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.END
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.HOME
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ARROW_LEFT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ARROW_UP
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ARROW_RIGHT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.ARROW_DOWN
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.PRINT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.INSERT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DELETE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_0
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_1
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_2
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_3
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_4
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_5
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_6
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_7
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_8
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DIGIT_9
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.A
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.B
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.C
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.D
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.E
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.G
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.H
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.I
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.J
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.K
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.L
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.M
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.N
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.O
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.P
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.Q
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.R
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.S
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.T
	 * @public
	 */


	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.U
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.V
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.W
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.X
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.Y
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.Z
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.WINDOWS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.CONTEXT_MENU
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.TURN_OFF
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SLEEP
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_0
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_1
	 * @public
	 */


	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_2
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_3
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_4
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_5
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_6
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_7
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_8
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_9
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_ASTERISK
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_PLUS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_MINUS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_COMMA
	 * @public
	 */


	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUMPAD_SLASH
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F1
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F2
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F3
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F4
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F5
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F6
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F7
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F8
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F9
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F10
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F11
	 * @public
	 */


	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.F12
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.NUM_LOCK
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SCROLL_LOCK
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.OPEN_BRACKET
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.PLUS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.COMMA
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SLASH
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.DOT
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.PIPE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SEMICOLON
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.MINUS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.GREAT_ACCENT
	 * @public
	 */


	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.EQUALS
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.SINGLE_QUOTE
	 * @public
	 */

	/**
	 * @type number
	 * @name jQuery.sap.KeyCodes.BACKSLASH
	 * @public
	 */
	return jQuery;

});
