/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IntervalTrigger","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/m/Text"],function(C,I,D,U,T){"use strict";var a=60000;var B=C.extend("sap.f.cards.BaseHeader",{metadata:{library:"sap.f","abstract":true,properties:{dataTimestamp:{type:"string",defaultValue:""},dataTimestampUpdating:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{_dataTimestamp:{type:"sap.m.Text",multiple:false,visibility:"hidden"},toolbar:{type:"sap.ui.core.Control",multiple:false},_error:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});B.prototype.exit=function(){this._removeTimestampListener();};B.prototype.onBeforeRendering=function(){var t=this.getToolbar();if(t){t.addStyleClass("sapFCardHeaderToolbar");}};B.prototype.setDataTimestamp=function(d){var o=this.getDataTimestamp();if(o&&!d){this.destroyAggregation("_dataTimestamp");this._removeTimestampListener();}this.setProperty("dataTimestamp",d);if(d){this._updateDataTimestamp();this._addTimestampListener();}return this;};B.prototype.setDataTimestampUpdating=function(d){var t=this._createDataTimestamp();this.setProperty("dataTimestampUpdating",d);if(d){t.setText("updating...");t.addStyleClass("sapFCardDataTimestampUpdating");this._removeTimestampListener();}else{t.removeStyleClass("sapFCardDataTimestampUpdating");}return this;};B.prototype._createDataTimestamp=function(){var d=this.getAggregation("_dataTimestamp");if(!d){d=new T({wrapping:false,textAlign:"End"});d.addStyleClass("sapFCardDataTimestamp");this.setAggregation("_dataTimestamp",d);}return d;};B.prototype._updateDataTimestamp=function(){var d=this._createDataTimestamp(),s=this.getDataTimestamp(),o,u,f;if(!s){d.setText("");return;}o=D.getDateTimeInstance({relative:true});u=new U(s);f=o.format(u);if(u.getTime()+59000>(new Date()).getTime()){f="now";}d.setText(f);d.removeStyleClass("sapFCardDataTimestampUpdating");};B.prototype._addTimestampListener=function(){B.getTimestampIntervalTrigger().addListener(this._updateDataTimestamp,this);this._bHasTimestampListener=true;};B.prototype._removeTimestampListener=function(){if(!this._bHasTimestampListener){return;}B.getTimestampIntervalTrigger().removeListener(this._updateDataTimestamp,this);this._bHasTimestampListener=false;};B.getTimestampIntervalTrigger=function(){if(!B._oTimestampIntervalTrigger){B._oTimestampIntervalTrigger=new I(a);}return B._oTimestampIntervalTrigger;};B.prototype.getAriaRole=function(){return this.hasListeners("press")?"button":"heading";};B.prototype.getAriaHeadingLevel=function(){return this.hasListeners("press")?undefined:"3";};B.prototype.getAriaRoleDescription=function(){return this.hasListeners("press")?this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER"):this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER");};return B;});
