/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library"],function(C,I,A,K,L,a,l){"use strict";var b=l.AvatarType;var c=l.AvatarImageFitType;var d=l.AvatarColor;var e=l.AvatarSize;var f=l.AvatarShape;var g=Object.keys(d).filter(function(s){return s.indexOf("Accent")!==-1;});var h=C.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:f.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:e.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:c.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:d.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"}});h.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";h.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";h.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_EDIT")};h.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null;};h.prototype.exit=function(){if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}if(this._badgeRef){this._badgeRef.destroy();}this._sPickedRandomColor=null;};h.prototype.setDetailBox=function(o){var i=this.getDetailBox();if(o){if(o===i){return this;}if(i){this.detachPress(this._fnLightBoxOpen,i);}this._fnLightBoxOpen=o.open;this.attachPress(this._fnLightBoxOpen,o);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,i);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",o);};h.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),i=o.getDetailBox();if(i){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=i.open;o.attachPress(o._fnLightBoxOpen,i);}return o;};h.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};h.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img");}return this;};h.prototype.ontap=function(){this.firePress({});};h.prototype.onkeydown=function(E){if(E.which===K.SHIFT||E.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(E.which===K.SPACE){this._bSpacePressed=true;E.preventDefault();}if(E.which===K.ENTER){this.firePress({});}};h.prototype.onkeyup=function(E){if(E.which===K.SPACE){if(!this._bShouldInterupt){this.firePress({});}this._bShouldInterupt=false;this._bSpacePressed=false;E.stopPropagation();}};h.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){L.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;return false;}return true;};h.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=b.Icon;this._bIsDefaultIcon=I.getIconInfo(s)?false:true;}else{this._bIsDefaultIcon=true;this._sActualType=b.Image;this.preloadedImage=new window.Image();this.preloadedImage.src=s;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this);}return this;};h.prototype._getDisplayIcon=function(s){return I.isIconURI(s)&&I.getIconInfo(s)?I.createControlByURI({src:s}):null;};h.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=b.Initials;}else{L.warning("No src and initials were provided",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};h.prototype._getImageFallbackType=function(){var i=this.getInitials();this._sImageFallbackType=i&&this._areInitialsValid(i)?b.Initials:b.Icon;return this._sImageFallbackType;};h.prototype._getDefaultIconPath=function(D){var s=null,F=this.getFallbackIcon();if(F&&I.isIconURI(F)){s=F;}else if(D===f.Circle){s=h.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===f.Square){s=h.DEFAULT_SQUARE_PLACEHOLDER;}return s;};h.prototype._getIcon=function(){var s=this.getSrc(),i=this.getAggregation("_icon"),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!i){i=I.createControlByURI({alt:"Image placeholder",src:s});this.setAggregation("_icon",i);}else if(i.getSrc()!==s){i.setSrc(s);}return i;};h.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP");};h.prototype._getBadgeIconSource=function(){var B;if(this.getDetailBox()){B="sap-icon://zoom-in";}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){B=this.getBadgeIcon();}else{L.warning("No valid Icon URI source for badge affordance was provided");}}return B;};h.prototype._getBadgeTooltip=function(){var B=this._getDefaultTooltip(),s=this.getBadgeIcon();if(this.getBadgeTooltip()){B=this.getBadgeTooltip();}else if(s&&h.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){B=h.AVATAR_BADGE_TOOLTIP[s];}return B;};h.prototype._getBadge=function(){var B=this._getBadgeIconSource(),s=this._getBadgeTooltip();if(!B){return;}if(!this._badgeRef){this.setAggregation("_badge",new a({src:B,tooltip:s}));}this._badgeRef=this.getAggregation("_badge");return this._badgeRef;};h.prototype._onImageLoad=function(){delete this.preloadedImage;};h.prototype._onImageError=function(){var F=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+F);delete this.preloadedImage;};h.prototype._getActualBackgroundColor=function(){var B=this.getBackgroundColor();if(B===d.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor;}B=this._sPickedRandomColor=d[g[g.length*Math.random()<<0]];}else{this._sPickedRandomColor=null;}return B;};return h;});
