/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'./InputBase','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./DateTimePickerRenderer','./TimePickerSliders','./SegmentedButton','./SegmentedButtonItem','./ResponsivePopover','./Button',"sap/ui/events/KeyCodes","sap/ui/core/IconPool"],function(q,I,D,a,b,l,C,c,d,L,e,T,S,f,R,B,K,g){"use strict";var P=l.PlacementType,h=l.ButtonType,k="Phone";var m=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}}});var n={Short:"short",Medium:"medium",Long:"long",Full:"full"};var o=C.extend("sap.m.internal.DateTimePickerPopup",{metadata:{library:"sap.m",aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMDateTimePopupCont").class("sapMTimePickerDropDown");i.openEnd();var v=j.getAggregation("_switcher");if(v){i.openStart("div");i.class("sapMTimePickerSwitch");i.openEnd();i.renderControl(v);i.close("div");}var w=j.getCalendar();if(w){i.renderControl(w);}i.openStart("div");i.class("sapMTimePickerSep");i.openEnd();i.close("div");var x=j.getTimeSliders();if(x){i.renderControl(x);}i.close("div");}},init:function(){},onBeforeRendering:function(){var i=this.getAggregation("_switcher");if(!i){var j=sap.ui.getCore().getLibraryResourceBundle("sap.m");var v=j.getText("DATETIMEPICKER_DATE");var w=j.getText("DATETIMEPICKER_TIME");i=new S(this.getId()+"-Switch",{selectedKey:"Cal",items:[new f(this.getId()+"-Switch-Cal",{key:"Cal",text:v}),new f(this.getId()+"-Switch-Sli",{key:"Sli",text:w})]});i.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",i,true);}if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){i.setVisible(true);i.setSelectedKey("Cal");}else{i.setVisible(false);}},onAfterRendering:function(){if(this.getAggregation('timeSliders')&&this.getAggregation('timeSliders').getAggregation("_columns")){this.getAggregation('timeSliders').getAggregation("_columns")[0].setIsExpanded(false);}if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var i=this.getAggregation("_switcher");var j=i.getSelectedKey();this._switchVisibility(j);}},_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},_switchVisibility:function(i){var j=this.getCalendar();var v=this.getTimeSliders();if(!j||!v){return;}if(i=="Cal"){j.$().css("display","");v.$().css("display","none");}else{j.$().css("display","none");v.$().css("display","");v._updateSlidersValues();v._onOrientationChanged();v.openFirstSlider();}},switchToTime:function(){var i=this.getAggregation("_switcher");if(i&&i.getVisible()){i.setSelectedKey("Sli");this._switchVisibility("Sli");}},getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();},onkeydown:function(E){var i=E.keyCode===K.TAB&&!E.shiftKey;var j=E.keyCode===K.TAB&&E.shiftKey;if(i&&E.target.classList.contains('sapUiCalHeadBLast')){this.getAggregation('timeSliders').getDomRef().children[0].focus();}if(j&&E.target.classList.contains('sapUiCalItem')){var v=this.oParent.getAggregation("footer").getAggregation("content").length-1;this.oParent.getAggregation("footer").getAggregation("content")[v].focus();}}});m.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};m.prototype.getIconSrc=function(){return g.getIconURI("date-time");};m.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;c.media.detachHandler(this._handleWindowResize,this);};m.prototype.setDisplayFormat=function(i){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setDisplayFormat(t.call(this));}return this;};m.prototype.setMinutesStep=function(M){this.setProperty('minutesStep',M,true);if(this._oSliders){this._oSliders.setMinutesStep(M);}return this;};m.prototype._getDefaultValueStyle=function(){return n.Medium;};m.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};m.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};m.prototype.setSecondsStep=function(i){this.setProperty('secondsStep',i,true);if(this._oSliders){this._oSliders.setSecondsStep(i);}return this;};m.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var j=-1;if(M.style){j=M.style.indexOf("/");}if(i){var v=q.extend({},M);if(j>0){v.style=v.style.substr(0,j);}this._oDisplayFormatDate=d.getInstance(v);}return d.getDateTimeInstance(M);};m.prototype._checkStyle=function(v){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(v.indexOf("/")>0){var w=[n.Short,n.Medium,n.Long,n.Long];var x=false;for(var i=0;i<w.length;i++){var y=w[i];for(var j=0;j<w.length;j++){var z=w[j];if(v==y+"/"+z){x=true;break;}}if(x){break;}}return x;}return false;};m.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};m.prototype._getLocaleBasedPattern=function(i){var j=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),v=i.indexOf("/");if(v>0){return j.getCombinedDateTimePattern(i.substr(0,v),i.substr(v+1));}else{return j.getCombinedDateTimePattern(i,i);}};m.prototype._createPopup=function(){var i,j,v,O,w,x;if(!this._oPopup){v=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=v.getText("TIMEPICKER_SET");w=v.getText("TIMEPICKER_CANCEL");this._oPopupContent=new o(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oOKButton=new B(this.getId()+"-OK",{text:O,type:h.Emphasized,press:_.bind(this)});var H=this._getValueStateHeader();this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:this._oOKButton,content:[H,this._oPopupContent],afterOpen:r.bind(this),afterClose:s.bind(this)});H.setPopup(this._oPopup._oControl);if(c.system.phone){i=this.$("inner").attr("aria-labelledby");j=i?document.getElementById(i).getAttribute("aria-label"):"";this._oPopup.setTitle(j);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new B(this.getId()+"-Cancel",{text:w,press:p.bind(this)}));}this._oPopup.addStyleClass("sapMDateTimePopup");x=this._oPopup.getAggregation("_popup");if(x.setShowArrow){x.setShowArrow(false);}this.setAggregation("_popup",this._oPopup,true);}};m.prototype._openPopup=function(){if(!this._oPopup){return;}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);var i=this._oPopup.getAggregation("_popup");i.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var j=this._oPopup.getContent()[1]&&this._oPopup.getContent()[1].getTimeSliders();if(j){setTimeout(j._updateSlidersValues.bind(j),0);}};m.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(u,this);}if(!this._oSliders){this._oSliders=new T(this.getId()+"-Sliders",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),displayFormat:t.call(this),localeId:this.getLocaleId()})._setShouldOpenSliderAfterRendering(true);this._oPopupContent.setTimeSliders(this._oSliders);}};m.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};m.prototype._fillDateRange=function(){var i=this.getDateValue(),j=true;if(i){i=new Date(i.getTime());this._oOKButton.setEnabled(true);}else{j=false;i=this.getInitialFocusedDateValue();if(!i){i=new Date();this._oCalendar.removeAllSelectedDates();}var M=this._oMaxDate.getTime();if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}this._oOKButton.setEnabled(false);}this._oCalendar.focusDate(i);if(j){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}}this._oSliders._setTimeValues(i);};m.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oSliders.getTimeValues();var v=this._oSliders._getDisplayFormatPattern();if(v.search("h")>=0||v.search("H")>=0){i.setHours(j.getHours());}if(v.search("m")>=0){i.setMinutes(j.getMinutes());}if(v.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};m.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};m.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};function _(E){this._handleCalendarSelect();}function p(E){this.onsaphide(E);if(!this.getDateValue()){this._oCalendar.removeAllSelectedDates();}}m.prototype._handleWindowResize=function(i){var j=this.getAggregation("_popup").getContent()[1].getAggregation("_switcher"),v=this.getAggregation("_popup").getContent()[1].getCalendar(),w=this.getAggregation("_popup").getContent()[1].getTimeSliders();if(i.name===k){j.setVisible(true);this.getAggregation("_popup").getContent()[1]._switchVisibility(j.getSelectedKey());}else{j.setVisible(false);w.$().css("display","");v.$().css("display","");}};function r(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();c.media.attachHandler(this._handleWindowResize,this);}function s(){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._oCalendar._closePickers();c.media.detachHandler(this._handleWindowResize,this);}function t(){var i=this.getDisplayFormat();var j;var v=this.getBinding("value");if(v&&v.oType&&(v.oType instanceof a)){i=v.oType.getOutputPattern();}else if(v&&v.oType&&v.oType.oFormat){i=v.oType.oFormat.oFormatOptions.pattern;}else{i=this.getDisplayFormat();}if(!i){i=n.Medium;}var w=i.indexOf("/");if(w>0&&this._checkStyle(i)){i=i.substr(w+1);}if(i==n.Short||i==n.Medium||i==n.Long||i==n.Full){var x=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var y=L.getInstance(x);j=y.getTimePattern(i);}else{j=i;}return j;}function u(E){this._oOKButton.setEnabled(true);this._oPopupContent.switchToTime();}return m;});
