/*!
* OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/library','sap/ui/Device','sap/ui/base/ManagedObject','sap/m/Link','sap/m/Text','sap/m/Button','sap/m/ResponsivePopover','sap/m/HyphenationSupport',"./ExpandableTextRenderer"],function(l,C,a,c,D,M,L,T,B,R,H,E){"use strict";var r=C.getLibraryResourceBundle("sap.m");var b=r.getText("EXPANDABLE_TEXT_SHOW_MORE");var d=r.getText("EXPANDABLE_TEXT_SHOW_LESS");var e=r.getText("MSGBOX_CLOSE");var f=c.TextAlign;var g=c.TextDirection;var A=c.aria.HasPopup;var W=l.WrappingType;var P=l.PlacementType;var h=l.ExpandableTextOverflowMode;var i=l.EmptyIndicatorMode;function j(t){return t.replace(/ {2,}/g,' ').replace(/\t{2,}/g,' ');}var k=a.extend("sap.m.ExpandableText",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IHyphenation"],library:"sap.m",properties:{text:{type:"string",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:g.Inherit},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false},overflowMode:{type:"sap.m.ExpandableTextOverflowMode",group:"Appearance",defaultValue:h.InPlace},maxCharacters:{type:"int",group:"Appearance",defaultValue:100},expanded:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:i.Off}},aggregations:{_showMoreLink:{type:'sap.m.Link',multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/ExpandableText.designtime"}});k.prototype.getText=function(n){var t=this.getProperty("text");if(n){return t.replace(/\r\n|\n\r|\r/g,"\n");}return t;};k.prototype.getTextDomRef=function(){if(!this.getVisible()){return null;}return this.getDomRef("string");};k.prototype._isExpandable=function(){var t=this.getText();if(!this.getRenderWhitespace()){t=j(t);}return t.length>this._getMaxCharacters()+b.length;};k.prototype._getMaxCharacters=function(){return Math.max(0,this.getMaxCharacters());};k.prototype._getDisplayedText=function(){var t=this.getText(true);if(this.getProperty("expanded")||!this._isExpandable()){return t;}if(!this.getRenderWhitespace()){t=j(t);}return t.substring(0,this._getMaxCharacters());};k.prototype._getShowMoreLink=function(){var s=this.getAggregation('_showMoreLink');if(!s){s=new L(this.getId()+'-showMoreLink',{text:this.getProperty("expanded")?d:b,press:function(o){var t,m,p;if(this.getOverflowMode()===h.InPlace){m=!this.getProperty("expanded");s.setText(m?d:b);this.setProperty("expanded",m);}else{t=new T({text:M.escapeSettingsValue(this.getText()),textDirection:this.getTextDirection(),wrappingType:this.getWrappingType(),textAlign:this.getTextAlign(),renderWhitespace:this.getRenderWhitespace()}).addStyleClass("sapUiSmallMargin").addStyleClass("sapMExTextPopover");p=this._oPopover;if(p&&p.isOpen()){p.close();return;}if(!p){p=this._oPopover=new R({showHeader:false,placement:P.HorizontalPreferredRight,beforeClose:this._onPopoverBeforeClose.bind(this)});if(D.system.phone){p.setEndButton(new B({text:e,press:function(){p.close();}}));}this.addDependent(p);}s.setText(d);s.rerender();p.removeAllAriaLabelledBy();p.destroyContent();p.addAriaLabelledBy(t);p.addContent(t);p.openBy(o.getSource());}}.bind(this)});this.setAggregation("_showMoreLink",s,true);}s.setAriaHasPopup(this.getOverflowMode()===h.InPlace?A.None:A.Dialog);return s;};k.prototype._onPopoverBeforeClose=function(){this._getShowMoreLink().setText(b);};k.prototype.exit=function(){if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};k.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};k.prototype.getTextsToBeHyphenated=function(){return{"main":this._getDisplayedText(true)};};k.prototype.getDomRefsForHyphenatedTexts=function(){return{"main":this.getTextDomRef()};};H.mixInto(k.prototype);return k;});
