/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","./library","sap/ui/core/Control","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls",'sap/ui/core/ResizeHandler',"sap/ui/core/IconPool",'sap/ui/core/theming/Parameters','sap/ui/dom/units/Rem',"sap/ui/Device","./OverflowToolbarRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(c,l,C,T,I,a,b,O,d,e,R,f,P,D,g,h,L,q){"use strict";var j=l.PlacementType;var B=l.ButtonType;var A=c.aria.HasPopup;var k=l.OverflowToolbarPriority;var m=a.extend("sap.m.OverflowToolbar",{metadata:{properties:{asyncMode:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/OverflowToolbar.designtime"}});m.ARIA_ROLE_DESCRIPTION="OVERFLOW_TOOLBAR_ROLE_DESCRIPTION";m.CONTENT_SIZE_TOLERANCE=1;m.prototype._callToolbarMethod=function(F,i){return a.prototype[F].apply(this,i);};m.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._aControlSizes={};this._iFrameRequest=null;this._iOverflowToolbarButtonSize=0;this._oOverflowToolbarButtonClone=null;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];this.addStyleClass("sapMOTB");this._sAriaRoleDescription=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(m.ARIA_ROLE_DESCRIPTION);this._fnMediaChangeRef=this._fnMediaChange.bind(this);g.media.attachHandler(this._fnMediaChangeRef);};m.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}if(this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone.destroy();}if(this._iFrameRequest){window.cancelAnimationFrame(this._iFrameRequest);this._iFrameRequest=null;}g.media.detachHandler(this._fnMediaChangeRef);};m.prototype.setAsyncMode=function(v){return this.setProperty("asyncMode",v,true);};m.prototype.onAfterRendering=function(){this._bInvalidatedAndNotRendered=false;if(this._bContentVisibilityChanged){this._bControlsInfoCached=false;this._bContentVisibilityChanged=false;}if(this.getAsyncMode()){this._doLayoutAsync().then(this._applyFocus.bind(this));}else{this._doLayout();this._applyFocus();}};m.prototype.onsapfocusleave=function(){this._resetChildControlFocusInfo();};m.prototype.setWidth=function(w){this.setProperty("width",w);this._bResized=true;return this;};m.prototype._doLayout=function(){var o=sap.ui.getCore(),w;if(!o.isThemeApplied()){L.debug("OverflowToolbar: theme not applied yet, skipping calculations",this);return;}this._recalculateOverflowButtonSize();w=this.$().is(":visible")?this.$().width():0;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._deregisterToolbarResize();if(w>0){if(!this._isControlsInfoCached()||(this._bNeedUpdateOnControlsCachedSizes&&this._bResized)){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);this.fireEvent("_controlWidthChanged");}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;this._bListenForInvalidationEvents=true;this._bResized=false;};m.prototype._doLayoutAsync=function(){return new Promise(function(r,i){this._iFrameRequest=window.requestAnimationFrame(function(){this._doLayout();r();}.bind(this));}.bind(this));};m.prototype._applyFocus=function(){var F,$=this.$().lastFocusableDomRef();if(this.sFocusedChildControlId){F=sap.ui.getCore().byId(this.sFocusedChildControlId);}if(F&&F.getDomRef()){F.focus();}else if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=true;}else if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){$&&$.focus();this._bOverflowButtonWasFocused=false;}};m.prototype._preserveChildControlFocusInfo=function(){var s=sap.ui.getCore().getCurrentFocusedControlId();if(this._getControlsIds().indexOf(s)!==-1){this._bControlWasFocused=true;this.sFocusedChildControlId=s;}else if(s===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;this.sFocusedChildControlId="";}};m.prototype._resetChildControlFocusInfo=function(){this._bControlWasFocused=false;this._bOverflowButtonWasFocused=false;this.sFocusedChildControlId="";};m.prototype._registerToolbarResize=function(){if(a.isRelativeWidth(this.getWidth())){var r=this._handleResize.bind(this);this._sResizeListenerId=R.register(this,r);}};m.prototype._deregisterToolbarResize=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};m.prototype._handleResize=function(){this._bResized=true;if(this._bInvalidatedAndNotRendered){return;}this._callDoLayout();};m.prototype._fnMediaChange=function(){this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;this._callDoLayout();};m.prototype._callDoLayout=function(){if(this.getAsyncMode()){this._doLayoutAsync();}else{this._doLayout();}};m.prototype._cacheControlsInfo=function(){var v,H,i=parseInt(this.$().css("padding-right"))||0,r=parseInt(this.$().css("padding-left"))||0;this._iOldContentSize=this._iContentSize;this._iContentSize=0;this._bNeedUpdateOnControlsCachedSizes=false;this.getContent().forEach(this._updateControlsCachedSizes,this);if(g.system.phone){this._iContentSize-=1;}if(this._aPopoverOnlyControls.length){v=this._aPopoverOnlyControls.filter(function(o){return o.getVisible();});H=(v.length>0);if(H){this._iContentSize+=this._getOverflowButtonSize();}}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize+i+r+1});}};m.prototype._updateControlsCachedSizes=function(o){var p,i,w;p=this._getControlPriority(o);i=this._calculateControlSize(o);this._aControlSizes[o.getId()]=i;w=a.getOrigWidth(o.getId());if(w&&a.isRelativeWidth(w)){this._bNeedUpdateOnControlsCachedSizes=true;}if(p!==k.AlwaysOverflow){this._iContentSize+=i;}};m.prototype._calculateControlSize=function(o){return this._getOptimalControlWidth(o,this._aControlSizes[o.getId()]);};m.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};m.prototype._flushButtonsToPopover=function(){this._aButtonsToMoveToPopover.forEach(this._moveButtonToPopover,this);};m.prototype._invalidateIfHashChanged=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this._preserveChildControlFocusInfo();this.invalidate();}};m.prototype._addOverflowButton=function(){if(!this._getOverflowButtonNeeded()){this._iCurrentContentSize+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}};m.prototype._aggregateMovableControls=function(){var G={},i=[],n,p,s,o,r;this._aMovableControls.forEach(function(t){n=m._getControlGroup(t);p=m._oPriorityOrder;if(n){s=this._getControlPriority(t);o=this._getControlIndex(t);G[n]=G[n]||[];r=G[n];r.unshift(t);if(!r._priority||p[r._priority]<p[s]){r._priority=s;}if(!r._index||r._index<o){r._index=o;}}else{i.push(t);}},this);Object.keys(G).forEach(function(t){i.push(G[t]);});return i;};m.prototype._extractControlsToMoveToOverflow=function(n,t){var i,M;for(i=0;i<n.length;i++){M=n[i];if(M.length){M.forEach(this._addToPopoverArrAndUpdateContentSize,this);}else{this._addToPopoverArrAndUpdateContentSize(M);}if(this._getControlPriority(M)!==k.Disappear){this._addOverflowButton();}if(this._iCurrentContentSize<=t){break;}}};m.prototype._addToPopoverArrAndUpdateContentSize=function(o){this._aButtonsToMoveToPopover.unshift(o);this._iCurrentContentSize-=this._aControlSizes[o.getId()];};m.prototype._sortByPriorityAndIndex=function(v,i){var p=m._oPriorityOrder,s=this._getControlPriority(v),n=this._getControlPriority(i),o=p[s]-p[n];if(o!==0){return o;}else{return this._getControlIndex(i)-this._getControlIndex(v);}};m.prototype._setControlsOverflowAndShrinking=function(t){var i;this._iCurrentContentSize=this._iContentSize;this._aButtonsToMoveToPopover=[];if(this._bSkipOptimization){this._bSkipOptimization=false;}else{i=this._getPopover()._getContentIdsHash();}this._resetToolbar();this._collectPopoverOnlyControls();this._markControlsWithShrinkableLayoutData();if(this._iCurrentContentSize<=(t+m.CONTENT_SIZE_TOLERANCE)){this._flushButtonsToPopover();this._invalidateIfHashChanged(i);return;}this._moveControlsToPopover(t);this._flushButtonsToPopover();if(this._iCurrentContentSize>t){this._checkContents();}this._invalidateIfHashChanged(i);};m.prototype._markControlsWithShrinkableLayoutData=function(){this.getContent().forEach(this._markControlWithShrinkableLayoutData,this);};m.prototype._collectPopoverOnlyControls=function(){var p=this._aPopoverOnlyControls.length,i,o;if(p){for(i=p-1;i>=0;i--){o=this._aPopoverOnlyControls[i];if(o.getVisible()){this._aButtonsToMoveToPopover.unshift(o);}}if(this._aButtonsToMoveToPopover.length>0){this._setOverflowButtonNeeded(true);}}};m.prototype._moveControlsToPopover=function(t){var i=[];if(this._aMovableControls.length){i=this._aggregateMovableControls();i.sort(this._sortByPriorityAndIndex.bind(this));this._extractControlsToMoveToOverflow(i,t);}};m.prototype._markControlWithShrinkableLayoutData=function(o){var w,i;o.removeStyleClass(a.shrinkClass);w=a.getOrigWidth(o.getId());if(!a.isRelativeWidth(w)){return;}i=o.getLayoutData();if(i&&i.isA("sap.m.ToolbarLayoutData")&&i.getShrinkable()){o.addStyleClass(a.shrinkClass);}};m.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(this._restoreButtonInToolbar,this);this._setOverflowButtonNeeded(false);this.getContent().forEach(this._removeShrinkingClass);};m.prototype._removeShrinkingClass=function(o){o.removeStyleClass(a.shrinkClass);};m.prototype._moveButtonToPopover=function(o){this._getPopover().addAssociatedContent(o);};m.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getPopover().removeAssociatedContent(v);};m.prototype._resetAndInvalidateToolbar=function(H){if(this._bIsBeingDestroyed){return;}this._resetToolbar();this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;if(H){this._bSkipOptimization=true;}if(this.$().length){this._preserveChildControlFocusInfo();this.invalidate();}};m.prototype.invalidate=function(){this._bInvalidatedAndNotRendered=true;C.prototype.invalidate.apply(this,arguments);};m.prototype._getVisibleContent=function(){var t=this.getContent(),p=this._getPopover()._getAllContent();return t.filter(function(o){return p.indexOf(o)===-1;});};m.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(o){return o.getVisible();});};m.prototype._getToggleButton=function(i){return new T({ariaHasPopup:A.Menu,id:this.getId()+i,icon:f.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:I.getStaticId("sap.ui.core","Icon.overflow"),type:B.Transparent});};m.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=this._getToggleButton("-overflowButton");this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};m.prototype._getOverflowButtonClone=function(){if(!this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone=this._getToggleButton("-overflowButtonClone").addStyleClass("sapMTBHiddenElement");}return this._oOverflowToolbarButtonClone;};m.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),s=this._getBestPopoverPlacement();if(p.getPlacement()!==s){p.setPlacement(s);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};m.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new d(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:g.system.phone?false:true,contentWidth:g.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset(),ariaLabelledBy:I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")});p._adaptPositionParams=function(){d.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(g.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};m.prototype._shiftPopupShadow=function(){var p=this._getPopover(),s=p.getCurrentPosition();if(s===j.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(s===j.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};m.prototype._popOverClosedHandler=function(){this._getOverflowButton().setPressed(false);if(q(document.activeElement).control(0)){return;}this._getOverflowButton().focus();};m.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};m.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};m.prototype._updateContentInfoInControlsCollections=function(){this.getContent().forEach(function(o){if(o){this._removeContentFromControlsCollections(o);this._moveControlInSuitableCollection(o,this._getControlPriority(o));}},this);};m.prototype._moveControlInSuitableCollection=function(o,p){var i=p!==k.NeverOverflow,n=p===k.AlwaysOverflow;if(e.supportsControl(o)&&n){this._aPopoverOnlyControls.push(o);}else{if(e.supportsControl(o)&&i&&o.getVisible()){this._aMovableControls.push(o);}else{this._aToolbarOnlyControls.push(o);}}};m.prototype._removeContentFromControlsCollections=function(o){var i,n,p;for(i=0;i<this._aAllCollections.length;i++){n=this._aAllCollections[i];p=n.indexOf(o);if(p!==-1){n.splice(p,1);}}};m.prototype._clearAllControlsCollections=function(){this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];};m.prototype.onLayoutDataChange=function(E){this._resetAndInvalidateToolbar(true);E&&this._updateContentInfoInControlsCollections();};m.prototype.addContent=function(o){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o));}this._informNewFlexibleContentAdded(o);return this._callToolbarMethod("addContent",arguments);};m.prototype.insertContent=function(o,i){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o));}this._informNewFlexibleContentAdded(o);return this._callToolbarMethod("insertContent",arguments);};m.prototype.removeContent=function(){var v=this._callToolbarMethod("removeContent",arguments);if(v){this._getPopover().removeAssociatedContent(v.getId());}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(v);this._removeContentFromControlsCollections(v);return v;};m.prototype.removeAllContent=function(){var i=this._callToolbarMethod("removeAllContent",arguments);i.forEach(this._deregisterControlListener,this);i.forEach(this._removeContentFromControlsCollections,this);this._resetAndInvalidateToolbar(false);this._clearAllControlsCollections();return i;};m.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);setTimeout(function(){this._resetAndInvalidateToolbar(false);}.bind(this),0);this._clearAllControlsCollections();return this._callToolbarMethod("destroyContent",arguments);};m.prototype._informNewFlexibleContentAdded=function(o){if(o&&o.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null});}};m.prototype._registerControlListener=function(o){var i;if(o){o.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(o.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=o.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){o.attachEvent(E,this._onInvalidationEventFired,this);},this);}}}};m.prototype._deregisterControlListener=function(o){var i;if(o){o.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(o.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=o.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){o.detachEvent(E,this._onInvalidationEventFired,this);},this);}}}};m.prototype._onContentPropertyChangedOverflowToolbar=function(E){var s=E.getSource(),o,p;this._updateContentInfoInControlsCollections();if(!this._bListenForControlPropertyChanges){return;}o=e.getControlConfig(s);p=E.getParameter("name");if(p!=='visible'&&!s.getVisible()){return;}if(typeof o!=="undefined"&&o.noInvalidationProps.indexOf(p)!==-1){return;}if(p==="visible"){this._bContentVisibilityChanged=true;}if(s.isA("sap.m.IOverflowToolbarFlexibleContent")&&s.getVisible()){this.fireEvent("_contentSizeChange",{contentSize:null});}this._resetAndInvalidateToolbar(true);};m.prototype._onInvalidationEventFired=function(E){var s=E.getSource();if(!this._bListenForInvalidationEvents){return;}if(s.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null});}this._resetAndInvalidateToolbar(true);};m.prototype._getOverflowButtonSize=function(){return this._iOverflowToolbarButtonSize;};m.prototype._getBestPopoverPlacement=function(){var H=this.getHTMLTag();if(H==="Footer"){return j.Top;}else if(H==="Header"){return j.Bottom;}return j.Vertical;};m.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};m.prototype._getControlIndex=function(v){return v.length?v._index:this.indexOfContent(v);};m.prototype._getOptimalControlWidth=function(o,i){var n,p=o.getLayoutData(),s=p&&p.isA("sap.m.ToolbarLayoutData")?p.getShrinkable():false,M=s?this._getMinWidthOfShrinkableControl(o):0,v=o.getVisible(),S;if(o.isA("sap.m.ToolbarSpacer")){S=parseInt(o.$().css('width'));M=(o.getWidth()&&S)?S:0;n=m._getOptimalWidthOfShrinkableControl(o,M);}else if(s&&M>0&&v){n=m._getOptimalWidthOfShrinkableControl(o,M);}else{n=v?m._getControlWidth(o):0;}if(n===null){n=typeof i!=="undefined"?i:0;}return n;};m.prototype._getMinWidthOfShrinkableControl=function(o){var M=o.$().css("min-width"),i=parseInt(M),r=a.isRelativeWidth(M);if(r){return(i*this.$().width())/100;}else{return i;}};m.prototype._getControlPriority=function(v){var i,o,p,G;if(v.length){return v._priority;}i=v.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1;G=i&&v.getOverflowToolbarConfig().getCustomImportance;if(i&&typeof G==="function"){return G();}o=v.getLayoutData&&v.getLayoutData();if(o&&o instanceof O){if(o.getMoveToOverflow()===false){return k.NeverOverflow;}if(o.getStayInOverflow()===true){return k.AlwaysOverflow;}p=o.getPriority();if(p===k.Never){return k.NeverOverflow;}if(p===k.Always){return k.AlwaysOverflow;}return p;}return k.High;};m._getControlMargins=function(o){return o.$().outerWidth(true)-o.$().outerWidth();};m._getOptimalWidthOfShrinkableControl=function(o,M){return M+m._getControlMargins(o);};m._getControlWidth=function(o){var i=o&&o.getDomRef();if(i&&o.$().is(":visible")){return Math.round(i.getBoundingClientRect().width+m._getControlMargins(o));}return null;};m._getControlGroup=function(o){var i=o.getLayoutData();if(i instanceof O){return i.getGroup();}};m._oPriorityOrder=(function(){var p={};p[k.Disappear]=1;p[k.Low]=2;p["Medium"]=3;p[k.High]=4;return p;})();m.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};m.prototype._recalculateOverflowButtonSize=function(){var o=this._getOverflowButtonClone().$(),i;if(!this._getOverflowButtonSize()&&o.width()>0){i=o.outerWidth(true);this._iOverflowToolbarButtonSize=i?i:0;}};m.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();this._iOverflowToolbarButtonSize=0;this._recalculateOverflowButtonSize();for(var i in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(i)){this._aControlSizes[i]=0;}}};m.prototype.closeOverflow=function(){this._getPopover().close();};return m;});
