/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar","sap/ui/core/ContextMenuSupport","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/core/library","sap/ui/Device","sap/ui/core/Element","./TitlePropagationSupport","./PageRenderer","sap/ui/thirdparty/jquery"],function(l,C,S,T,B,a,b,R,c,D,E,d,P,q){"use strict";var A=c.AccessibleLandmarkRole;var e=l.ButtonType;var f=l.PageBackgroundDesign;var g=c.TitleLevel;var h=l.TitleAlignment;var i="div";var H="header";var F="footer";var j=C.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:f.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:e.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:h.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent",forwarding:{getter:"_getInternalHeader",aggregation:"contentRight"}},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},dnd:{draggable:false,droppable:true},designtime:"sap/m/designtime/Page.designtime"}});b.apply(j.prototype);R.call(j.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPageSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPageFooter:not(.sapMPageFloatingFooter) .sapMIBar"},floatingFooter:{selector:".sapMPageFloatingFooter.sapMPageFooter"}});d.call(j.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});j.FOOTER_ANIMATION_DURATION=350;j.prototype.init=function(){this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};j.prototype._hasScrolling=function(){return this.getEnableScrolling();};j.prototype.onBeforeRendering=function(){var o=this.getCustomHeader()||this.getAggregation("_internalHeader");if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null;}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new S(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true});}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel());}this._ensureNavButton();if(o&&o.setTitleAlignment){o.setProperty("titleAlignment",this.getTitleAlignment(),true);}};j.prototype.onAfterRendering=function(){this.$().toggleClass("sapMPageBusyCoversAll",!this.getContentOnlyBusy());this._sBusySection=this.getContentOnlyBusy()?'cont':null;};j.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._navBtn){this._navBtn.destroy();this._navBtn=null;}if(this._appIcon){this._appIcon.destroy();this._appIcon=null;}};j.prototype.setBackgroundDesign=function(s){var k=this.getBackgroundDesign();this.setProperty("backgroundDesign",s,true);this.$().removeClass("sapMPageBg"+k).addClass("sapMPageBg"+this.getBackgroundDesign());return this;};j.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new T(this.getId()+"-title",{level:this.getTitleLevel()});this._headerTitle.setText(t);if(w){this._updateHeaderContent(this._headerTitle,"middle",0);}this.setProperty("title",t,true);return this;};j.prototype._ensureNavButton=function(){if(!this.getShowNavButton()){return;}var s=this.getNavButtonTooltip()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){this._navBtn=new B(this.getId()+"-navButton",{press:function(){this.fireNavButtonPress();this.fireNavButtonTap();}.bind(this)});}this._navBtn.setType(this.getNavButtonType());this._navBtn.setTooltip(s);};j.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this;}this.setProperty("showNavButton",s,true);if(s){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1);}this._updateHeaderContent(this._navBtn,"left",0);}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1);}return this;};j.prototype.setShowFooter=function(s){if(this.getDomRef()){(s)?this.$().addClass("sapMPageWithFooter"):this.$().removeClass("sapMPageWithFooter");}var $=q(this.getDomRef()).find(".sapMPageFooter").last(),u=sap.ui.getCore().getConfiguration().getAnimation();if(!this.getFloatingFooter()){this.setProperty("showFooter",s);return this;}this.setProperty("showFooter",s,true);$.removeClass("sapUiHidden");$.toggleClass("sapMPageFooterControlShow",s);$.toggleClass("sapMPageFooterControlHide",!s);if(s){return this;}if(u){setTimeout(function(){$.toggleClass("sapUiHidden",!s);},j.FOOTER_ANIMATION_DURATION);}else{$.toggleClass("sapUiHidden",!s);}return this;};j.prototype._updateHeaderContent=function(o,s,k){var I=this._getInternalHeader();if(I){switch(s){case"left":if(k==-1){if(I.getContentLeft()){I.removeContentLeft(o);}}else{if(I.indexOfContentLeft(o)!=k){I.insertContentLeft(o,k);I.invalidate();}}break;case"middle":if(k==-1){if(I.getContentMiddle()){I.removeContentMiddle(o);}}else{if(I.indexOfContentMiddle(o)!=k){I.insertContentMiddle(o,k);I.invalidate();}}break;case"right":if(k==-1){if(I.getContentRight()){I.removeContentRight(o);}}else{if(I.indexOfContentRight(o)!=k){I.insertContentRight(o,k);I.invalidate();}}break;default:break;}}};j.prototype._getInternalHeader=function(){var I=this.getAggregation("_internalHeader");if(!I){this.setAggregation("_internalHeader",new a(this.getId()+"-intHeader",{titleAlignment:this.getTitleAlignment()}),true);I=this.getAggregation("_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0);}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0);}}return I;};j.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o.addStyleClass("sapMPageHeader");}return this._getInternalHeader().addStyleClass("sapMPageHeader");};j.prototype.getScrollDelegate=function(){return this._oScroller;};j.prototype._formatLandmarkInfo=function(L,p){if(L){var r=L["get"+p+"Role"]()||"",s=L["get"+p+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:s};}return{};};j.prototype._getHeaderTag=function(L){if(L&&L.getHeaderRole()!==A.None){return i;}return H;};j.prototype._getSubHeaderTag=function(L){if(L&&L.getSubHeaderRole()!==A.None){return i;}return H;};j.prototype._getFooterTag=function(L){if(L&&L.getFooterRole()!==A.None){return i;}return F;};j.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t);}return this;};j.prototype.scrollToElement=function(o,t,O){if(o instanceof E){o=o.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(o,t,O);}return this;};j.prototype.setCustomHeader=function(o){this.setAggregation("customHeader",o);this.toggleStyleClass("sapFShellBar-CTX",o&&o.isA("sap.f.ShellBar"));if(o&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":o});}return this;};j.prototype._getAdaptableContent=function(){return this._getAnyHeader();};return j;});
