/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./Button','./Select','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/ResizeHandler','sap/ui/core/ListItem','sap/ui/core/IconPool','./SegmentedButtonRenderer'],function(l,B,S,C,E,I,R,L,a,c){"use strict";var d=C.extend("sap.m.SegmentedButton",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent"],library:"sap.m",designtime:"sap/m/designtime/SegmentedButton.designtime",publicMethods:["createButton"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button",deprecated:true},items:{type:"sap.m.SegmentedButtonItem",multiple:true,singularName:"item",bindable:"bindable"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},associations:{selectedButton:{deprecated:true,type:"sap.m.Button",multiple:false},selectedItem:{type:"sap.m.SegmentedButtonItem",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{button:{type:"sap.m.Button"},id:{type:"string"},key:{type:"string"}}},selectionChange:{parameters:{item:{type:"sap.m.SegmentedButtonItem"}}}},dnd:{draggable:true,droppable:false}}});E.call(d.prototype);d.prototype.init=function(){this._aWidths=[];this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this.addDelegate(this._oItemNavigation);this.removeButton=function(b){var r=d.prototype.removeButton.call(this,b);this.setSelectedButton(this.getButtons()[0]);this._fireChangeEvent();return r;};};d.prototype.onBeforeRendering=function(){var b=this._getVisibleButtons();this._bCustomButtonWidth=b.some(function(o){return o.getWidth();});if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.setSelectedKey(this.getProperty("selectedKey"));if(!this.getSelectedButton()){this._selectDefaultButton();}};d.prototype.onAfterRendering=function(){var b=this._getVisibleButtons(),p;if(!this._sResizeListenerId){p=this.getDomRef().parentNode;if(p){this._sResizeListenerId=R.register(p,this._handleContainerResize.bind(this));}}this._setItemNavigation();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};d.prototype._handleContainerResize=function(){var b=this._getVisibleButtons();this._clearAutoWidthAppliedToControl();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};d.prototype._clearAutoWidthAppliedToControl=function(){var b=this._getVisibleButtons(),e=b.length,o,i=0;if(!this.getWidth()){this.$().css("width","");}while(i<e){o=b[i];if(!o.getWidth()){o.$().css("width","");}i++;}};d.prototype._getRenderedButtonWidths=function(b){return b.map(function(o){var e=o.getDomRef();return e&&e.getBoundingClientRect?e.getBoundingClientRect().width:o.$().outerWidth();});};d.prototype._getButtonWidth=function(b){var e=b.length,w,n=0,s=0,f=0,p,P,i=0;if(this._bCustomButtonWidth){while(i<e){w=b[i].getWidth();if(w){if(w.indexOf("%")!==-1){s+=parseInt(w.slice(0,-1));}else{f+=parseInt(w.slice(0,-2));}}else{n++;}i++;}if(n===0){return false;}p=(100-s)/n;P=(f/n);if(p<0){p=0;}if(P<0){P=0;}if(P>0){return"calc("+p+"% - "+P+"px)";}else{return p+"%";}}else{return(100/e)+"%";}};d.prototype._updateWidth=function(){if(this.$().length===0||this.hasStyleClass("sapMSegmentedButtonNoAutoWidth")){return;}var s=this.getWidth(),b=this._getVisibleButtons(),e=b.length,m=(this._aWidths.length>0)?Math.max.apply(Math,this._aWidths):0,f=(100/e),p=this.$().parent().innerWidth(),w=this._getButtonWidth(b),g,o,i;if(!s){if((m*e)>p){this.addStyleClass("sapMSegBFit");}else if(m>0){this.$().width((m*e)+1);this.removeStyleClass("sapMSegBFit");}i=0;while(i<e){o=b[i];o.$().css("width",o.getWidth()?o.getWidth():w);i++;}}else if(s&&!this._bCustomButtonWidth){i=0;while(i<e){b[i].$().css("width",f+"%");i++;}}g=this.$().width();if(this._previousWidth!==undefined&&g!==this._previousWidth&&!this._bInOverflow){this.fireEvent("_containerWidthChanged");}this._previousWidth=g;};d.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}this._bCustomButtonWidth=null;this._aWidths=null;};d.prototype._setItemNavigation=function(){var b,D=this.getDomRef();if(D){this._oItemNavigation.setRootDomRef(D);b=this.$().find(".sapMSegBBtn:not(.sapMSegBBtnDis)");this._oItemNavigation.setItemDomRefs(b);this._focusSelectedButton();}};d.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,listenForEvents:["select"],autoCloseEvents:["select"],propsUnrelatedToSize:["enabled","selectedKey"],invalidationEvents:["_containerWidthChanged"],onBeforeEnterOverflow:this._onBeforeEnterOverflow,onAfterExitOverflow:this._onAfterExitOverflow};};d.prototype._onBeforeEnterOverflow=function(o){o._toSelectMode();};d.prototype._onAfterExitOverflow=function(o){if(o._bForcedSelectMode){o._toSelectMode();}else{o._toNormalMode();}};d.prototype.getFormDoNotAdjustWidth=function(){return true;};d.prototype.createButton=function(t,u,e,T){var b=new B();if(t!==null){b.setText(t);}if(u!==null){b.setIcon(u);}if(e||e===undefined){b.setEnabled(true);}else{b.setEnabled(false);}if(T){b.setTextDirection(T);}this.addButton(b);return b;};(function(){d.prototype.addButton=function(b){if(b){p(b,this);this.addAggregation('buttons',b);this._syncSelect();this._fireChangeEvent();}return this;};d.prototype.insertButton=function(b,i){if(b){p(b,this);this.insertAggregation('buttons',b,i);this._syncSelect();this._fireChangeEvent();}return this;};function p(b,P){b.attachPress(function(e){P._buttonPressed(e);});b.attachEvent("_change",P._syncSelect,P);b.attachEvent("_change",P._fireChangeEvent,P);var o=B.prototype.setEnabled;b.setEnabled=function(e){b.$().toggleClass("sapMSegBBtnDis",!e).toggleClass("sapMFocusable",e);o.apply(b,arguments);};b.setVisible=function(v){B.prototype.setVisible.apply(this,arguments);P.invalidate();};}})();d.prototype.getSelectedKey=function(){var b=this.getButtons(),e=this.getItems(),s=this.getSelectedButton(),i=0;if(e.length>0){for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this.setProperty("selectedKey",e[i].getKey(),true);return e[i].getKey();}}}return"";};d.prototype.setSelectedKey=function(k){var b=this.getButtons(),e=this.getItems(),i=0;if(!k){this.setProperty("selectedKey",k,true);return this;}if(e.length>0&&b.length>0){for(;i<e.length;i++){if(e[i]&&e[i].getKey()===k){this.setSelectedItem(e[i]);break;}}}this.setProperty("selectedKey",k,true);return this;};d.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b);if(r){delete r.setEnabled;r.detachEvent("_change",this._syncSelect,this);r.detachEvent("_change",this._fireChangeEvent,this);this._syncSelect();}return r;};d.prototype.removeAllButtons=function(){var b=this.getButtons();if(b){for(var i=0;i<b.length;i++){var o=b[i];if(o){delete o.setEnabled;this.removeAggregation("buttons",o);o.detachEvent("_change",this._syncSelect,this);o.detachEvent("_change",this._fireChangeEvent,this);}}this._syncSelect();}return b;};d.prototype.addItem=function(i){this.addAggregation("items",i);this.addButton(i.oButton);return this;};d.prototype.removeItem=function(i){var r;if(i!==null&&i!==undefined){r=this.removeAggregation("items",i);this.removeButton(i.oButton);}if(i&&i instanceof sap.m.SegmentedButtonItem&&this.getSelectedButton()===i.oButton.getId()){this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");}this.setSelectedItem(this.getItems()[0]);return r;};d.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b);this.insertButton(i.oButton,b);return this;};d.prototype.removeAllItems=function(s){var r=this.removeAllAggregation("items",s);this.removeAllButtons();this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");return r;};d.prototype._buttonPressed=function(e){var b=e.getSource(),i;if(this.getSelectedButton()!==b.getId()){this.getButtons().forEach(function(o){o.$().removeClass("sapMSegBBtnSel");o.$().attr("aria-selected",false);});i=this.getItems().filter(function(o){return o.oButton===b;})[0];b.$().addClass("sapMSegBBtnSel");b.$().attr("aria-selected",true);this.setAssociation('selectedButton',b,true);this.setProperty("selectedKey",this.getSelectedKey(),true);this.setAssociation('selectedItem',i,true);this.fireSelectionChange({item:i});this.fireSelect({button:b,id:b.getId(),key:this.getSelectedKey()});}};d.prototype._selectDefaultButton=function(){var b=this._getVisibleButtons();if(b.length>0){this.setAssociation('selectedButton',b[0],true);if(this.getItems().length>0){this.setAssociation('selectedItem',this.getItems()[0],true);}}};d.prototype.setSelectedButton=function(b){var s=this.getSelectedButton(),e=this.getButtons();this.setAssociation("selectedButton",b);if(s!==this.getSelectedButton()){if(!this.getSelectedButton()&&e.length>1){this._selectDefaultButton();}this._focusSelectedButton();}this._syncSelect();return this;};d.prototype.setSelectedItem=function(i){var o=typeof i==="string"&&i!==""?sap.ui.getCore().byId(i):i,b=o instanceof sap.m.SegmentedButtonItem,v=b?o.oButton:i;this.setAssociation("selectedItem",i,true);this.setSelectedButton(v);return this;};d.prototype._focusSelectedButton=function(){var b=this.getButtons(),s=this.getSelectedButton(),i=0;for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this._oItemNavigation&&this._oItemNavigation.setFocusedIndex(i);break;}}};d.prototype.onsappagedown=function(e){this._oItemNavigation.onsapend(e);};d.prototype.onsappageup=function(e){this._oItemNavigation.onsaphome(e);};d.prototype.onsapspace=function(e){e.preventDefault();};d.prototype._fnSelectFormFactory=function(){return new S(this.getId()+"-select").attachChange(this._selectChangeHandler,this).addStyleClass("sapMSegBSelectWrapper");};d.prototype._selectChangeHandler=function(e){var s=e.getParameter("selectedItem"),n=parseInt(s.getKey()),b=this.getButtons()[n],f=b.getId();b.firePress();this.setSelectedButton(f);};d.prototype._fireChangeEvent=function(){this.fireEvent("_change");};d.prototype._syncSelect=function(){var k=0,s=0,b,e,o=this.getAggregation("_select");if(!o){return;}o.destroyItems();this._getVisibleButtons().forEach(function(f){b=f.getText();e=f.getIcon();o.addItem(new L({key:k.toString(),icon:e?e:"",text:b?b:f.getTooltip_AsString(),enabled:f.getEnabled()}));if(f.getId()===this.getSelectedButton()){s=k;}k++;},this);o.setSelectedKey(s.toString());};d.prototype._toSelectMode=function(){this._bInOverflow=true;this.addStyleClass("sapMSegBSelectWrapper");if(!this.getAggregation("_select")){this.setAggregation("_select",this._fnSelectFormFactory(),true);}this._syncSelect();this._syncAriaAssociations();};d.prototype._toNormalMode=function(){delete this._bInOverflow;this.removeStyleClass("sapMSegBSelectWrapper");};d.prototype._syncAriaAssociations=function(){var s=this.getAggregation("_select");this.getAriaLabelledBy().forEach(function(o){if(s.getAriaLabelledBy().indexOf(o)===-1){s.addAriaLabelledBy(o);}});this.getAriaDescribedBy().forEach(function(D){if(s.getAriaLabelledBy().indexOf(D)===-1){s.addAriaLabelledBy(D);}});};d.prototype._overwriteImageOnload=function(i){var t=this;if(i.onload===sap.m.Image.prototype.onload){i.onload=function(){if(sap.m.Image.prototype.onload){sap.m.Image.prototype.onload.apply(this,arguments);}window.setTimeout(function(){t._updateWidth();},20);};}};d.prototype._getIconAriaLabel=function(i){var o=a.getIconInfo(i.getSrc()),r="";if(o){r=o.text?o.text:o.name;}return r;};d.prototype._getVisibleButtons=function(){return this.getButtons().filter(function(b){return b.getVisible();});};d.prototype.clone=function(){var s=this.getSelectedButton(),e=this.removeAllAggregation("buttons"),o=C.prototype.clone.apply(this,arguments),f=e.map(function(b){return b.getId();}).indexOf(s),i;if(f>-1){o.setSelectedButton(o.getButtons()[f]);}for(i=0;i<e.length;i++){this.addAggregation("buttons",e[i]);}return o;};return d;});
