/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./Popover','./SelectList','./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement','sap/ui/core/Icon','sap/ui/core/IconPool','./Button','./Bar','./Title','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/core/Item','sap/ui/Device','sap/ui/core/InvisibleText','./SelectRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes",'./Text','sap/m/SimpleFixFlex','sap/base/Log','sap/ui/core/ValueStateSupport',"sap/ui/core/InvisibleMessage"],function(D,P,S,l,C,a,E,L,I,b,B,c,T,V,M,d,f,g,h,j,k,K,m,n,o,p,q){"use strict";var r=l.SelectListKeyboardNavigationMode;var s=l.PlacementType;var t=d.ValueState;var u=d.TextDirection;var v=d.TextAlign;var w=l.SelectType;var x=d.InvisibleMessageMode;var y=a.extend("sap.m.Select",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent","sap.f.IShellBar","sap.ui.core.ISemanticFormContent"],library:"sap.m",properties:{name:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},type:{type:"sap.m.SelectType",group:"Appearance",defaultValue:w.Default},autoAdjustWidth:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:v.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:u.Inherit},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:t.None},valueStateText:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},resetOnMissingKey:{type:"boolean",group:"Behavior",defaultValue:false},forceSelection:{type:"boolean",group:"Behavior",defaultValue:true},wrapItemsText:{type:"boolean",group:"Behavior",defaultValue:false},columnRatio:{type:"sap.m.SelectColumnRatio",group:"Appearance",defaultValue:"3:2"},required:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable",forwarding:{getter:"getList",aggregation:"items"}},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"},_valueIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_pickerHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_pickerValueStateContent:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"},previousSelectedItem:{type:"sap.ui.core.Item"}}}},designtime:"sap/m/designtime/Select.designtime"}});b.insertFontFaceStyle();E.apply(y.prototype,[true]);M.call(y.prototype);function H(i){if(this._isIconOnly()&&!this.isOpen()){return;}if(i){this.setSelection(i);this.setValue(i.getText());this.scrollToItem(i);}}y.prototype._attachHiddenSelectHandlers=function(){var e=this._getHiddenSelect();e.on("focus",this._addFocusClass.bind(this));e.on("blur",this._removeFocusClass.bind(this));};y.prototype.focus=function(){this._getHiddenSelect().trigger("focus");a.prototype.focus.call(this,arguments);};y.prototype._addFocusClass=function(){this.$().addClass("sapMSltFocused");};y.prototype._removeFocusClass=function(){this.$().removeClass("sapMSltFocused");};y.prototype._detachHiddenSelectHandlers=function(){var e=this._getHiddenSelect();if(e){e.off("focus");e.off("blur");}};y.prototype._getHiddenSelect=function(){return this.$("hiddenSelect");};y.prototype._getHiddenInput=function(){return this.$("hiddenInput");};y.prototype._announceValueStateText=function(){var e=this._getValueStateText();if(this._oInvisibleMessage){this._oInvisibleMessage.announce(e,x.Assertive);}};y.prototype._getValueStateText=function(){var e=this.getValueState(),i,z;if(e===t.None){return"";}i=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+e.toUpperCase());z=i+" "+(this.getValueStateText()||p.getAdditionalText(this));return z;};y.prototype._isFocused=function(){return this.getFocusDomRef()===document.activeElement;};y.prototype._isIconOnly=function(){return this.getType()===w.IconOnly;};y.prototype._handleFocusout=function(e){this._bFocusoutDueRendering=this.bRenderingPhase;if(this._bFocusoutDueRendering){this._bProcessChange=false;return;}if(this._bProcessChange){if(!this.isOpen()||e.target===this.getAggregation("picker")){this._checkSelectionChange();}else{this._revertSelection();}this._bProcessChange=false;}else{this._bProcessChange=true;}};y.prototype._checkSelectionChange=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.fireChange({selectedItem:i,previousSelectedItem:this._oSelectionOnFocus});}};y.prototype._revertSelection=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.setSelection(this._oSelectionOnFocus);this.setValue(this._getSelectedItemText());}};y.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};y.prototype.getOverflowToolbarConfig=function(){var e=["enabled","selectedKey"];if(!this.getAutoAdjustWidth()||this._bIsInOverflow){e.push("selectedItemId");}var i={canOverflow:true,autoCloseEvents:["change"],invalidationEvents:["_itemTextChange"],propsUnrelatedToSize:e};i.onBeforeEnterOverflow=function(z){var A=z.getParent();if(!A.isA("sap.m.OverflowToolbar")){return;}z._prevSelectType=z.getType();z._bIsInOverflow=true;if(z.getType()!==w.Default){z.setProperty("type",w.Default,true);}};i.onAfterExitOverflow=function(z){var A=z.getParent();if(!A.isA("sap.m.OverflowToolbar")){return;}z._bIsInOverflow=false;if(z.getType()!==z._prevSelectType){z.setProperty("type",z._prevSelectType,true);}};return i;};y.prototype.getList=function(){if(this._bIsBeingDestroyed){return null;}return this._oList;};y.prototype.findFirstEnabledItem=function(i){var e=this.getList();return e?e.findFirstEnabledItem(i):null;};y.prototype.findLastEnabledItem=function(i){var e=this.getList();return e?e.findLastEnabledItem(i):null;};y.prototype.setSelectedIndex=function(i,_){var e;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);e=_[i];if(e){this.setSelection(e);}};y.prototype.scrollToItem=function(i){var e=this.getPicker().getDomRef(),z=i&&i.getDomRef();if(!e||!z){return;}var A=e.querySelector('.sapUiSimpleFixFlexFlexContent'),F=e.querySelector('.sapMSltPickerValueState'),G=F?F.clientHeight:0,J=A.scrollTop,N=z.offsetTop-G,O=A.clientHeight,Q=z.offsetHeight;if(J>N){A.scrollTop=N;}else if((N+Q)>(J+O)){A.scrollTop=Math.ceil(N+Q-O);}};y.prototype.setValue=function(e){var i=this.getDomRef(),z=i&&i.querySelector(".sapMSelectListItemText"),F=!this.isOpen()&&this._isFocused()&&this._oInvisibleMessage;if(z){z.textContent=e;}this._setHiddenSelectValue();this._getValueIcon();if(F){this._oInvisibleMessage.announce(e,x.Assertive);}};y.prototype._setHiddenSelectValue=function(){var e=this._getHiddenSelect(),i=this._getHiddenInput(),z=this.getSelectedKey(),A=this._getSelectedItemText();i.attr("value",z||"");e.text(A);};y.prototype._getValueIcon=function(){if(this._bIsBeingDestroyed){return null;}var e=this.getAggregation("_valueIcon"),i=this.getSelectedItem(),z=!!(i&&i.getIcon&&i.getIcon()),A=z?i.getIcon():"sap-icon://pull-down";if(!e){e=new I(this.getId()+"-labelIcon",{src:A,visible:false});this.setAggregation("_valueIcon",e,true);}if(e.getVisible()!==z){e.setVisible(z);e.toggleStyleClass("sapMSelectListItemIcon",z);}if(z&&i.getIcon()!==e.getSrc()){e.setSrc(A);}return e;};y.prototype._isShadowListRequired=function(){if(this.getAutoAdjustWidth()){return false;}else if(this.getWidth()==="auto"){return true;}return false;};y.prototype._handleAriaActiveDescendant=function(i){var e=this.getFocusDomRef(),z=i&&i.getDomRef(),A="aria-activedescendant";if(!e){return;}if(z&&this.isOpen()){e.setAttribute(A,i.getId());}else{e.removeAttribute(A);}};y.prototype.updateItems=function(R){S.prototype.updateItems.apply(this,arguments);this._oSelectionOnFocus=this.getSelectedItem();};y.prototype.refreshItems=function(){S.prototype.refreshItems.apply(this,arguments);};y.prototype.onBeforeOpen=function(e){var i=this["_onBeforeOpen"+this.getPickerType()],z=this.getRenderer().CSS_CLASS;this.addStyleClass(z+"Pressed");this.addStyleClass(z+"Expanded");this.closeValueStateMessage();this.addContent();this.addContentToFlex();i&&i.call(this);};y.prototype.onAfterOpen=function(e){var i=this.getFocusDomRef(),z=null;if(!i){return;}z=this.getSelectedItem();i.setAttribute("aria-expanded","true");i.setAttribute("aria-controls",this.getList().getId());if(z){i.setAttribute("aria-activedescendant",z.getId());this.scrollToItem(z);}};y.prototype.onBeforeClose=function(e){var i=this.getFocusDomRef(),z=this.getRenderer().CSS_CLASS;if(i){i.removeAttribute("aria-controls");i.removeAttribute("aria-activedescendant");if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===i)){this.openValueStateMessage();}}this.removeStyleClass(z+"Expanded");};y.prototype.onAfterClose=function(e){var i=this.getFocusDomRef(),z=this.getRenderer().CSS_CLASS,A=z+"Pressed";if(i){i.setAttribute("aria-expanded","false");i.removeAttribute("aria-activedescendant");}this.removeStyleClass(A);};y.prototype.getPicker=function(){if(this._bIsBeingDestroyed){return null;}return this.createPicker(this.getPickerType());};y.prototype.getValueStateTextInvisibleText=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oValueStateTextInvisibleText){this._oValueStateTextInvisibleText=new h({id:this.getId()+"-valueStateText-InvisibleText"});this._oValueStateTextInvisibleText.toStatic();}return this._oValueStateTextInvisibleText;};y.prototype.getSimpleFixFlex=function(){if(this._bIsBeingDestroyed){return null;}else if(this.oSimpleFixFlex){return this.oSimpleFixFlex;}this.oSimpleFixFlex=new n({id:this.getPickerValueStateContentId(),fixContent:this._getPickerValueStateContent().addStyleClass(this.getRenderer().CSS_CLASS+"PickerValueState"),flexContent:this.createList()});return this.oSimpleFixFlex;};y.prototype.setPickerType=function(e){this._sPickerType=e;};y.prototype.getPickerType=function(){return this._sPickerType;};y.prototype._getPickerValueStateContent=function(){if(!this.getAggregation("_pickerValueStateContent")){this.setAggregation("_pickerValueStateContent",new m({wrapping:true,text:this._getTextForPickerValueStateContent()}));}return this.getAggregation("_pickerValueStateContent");};y.prototype._updatePickerValueStateContentText=function(){var e=this.getPicker(),i=e&&e.getContent()[0].getFixContent(),z;if(i){z=this._getTextForPickerValueStateContent();i.setText(z);}};y.prototype._getTextForPickerValueStateContent=function(){var e=this.getValueStateText(),i;if(e){i=e;}else{i=this._getDefaultTextForPickerValueStateContent();}return i;};y.prototype._getDefaultTextForPickerValueStateContent=function(){var e=this.getValueState(),R,i;if(e===t.None){i="";}else{R=C.getLibraryResourceBundle("sap.ui.core");i=R.getText("VALUE_STATE_"+e.toUpperCase());}return i;};y.prototype._updatePickerValueStateContentStyles=function(){var e=this.getValueState(),i=t,z=this.getRenderer().CSS_CLASS,A=z+"Picker",F=A+e+"State",G=A+"WithSubHeader",J=this.getPicker(),N=J&&J.getContent()[0].getFixContent();if(N){this._removeValueStateClassesForPickerValueStateContent(J);N.addStyleClass(F);if(e!==i.None){J.addStyleClass(G);}else{J.removeStyleClass(G);}}};y.prototype._removeValueStateClassesForPickerValueStateContent=function(e){var i=t,z=this.getRenderer().CSS_CLASS,A=z+"Picker",F=e.getContent()[0].getFixContent();Object.keys(i).forEach(function(G){var O=A+G+"State";F.removeStyleClass(O);});};y.prototype._createPopover=function(){var e=this;var i=new P({showArrow:false,showHeader:false,placement:s.VerticalPreferredBottom,offsetX:0,offsetY:0,initialFocus:this,ariaLabelledBy:this._getPickerHiddenLabelId()});i.addEventDelegate({ontouchstart:function(z){var A=this.getDomRef("cont");if((z.target===A)||(z.srcControl instanceof f)){e._bProcessChange=false;}}},i);this._decoratePopover(i);return i;};y.prototype._decoratePopover=function(e){var i=this;e.open=function(){return this.openBy(i);};};y.prototype._onBeforeRenderingPopover=function(){var e=this.getPicker(),W=this.$().outerWidth()+"px";if(e){e.setContentMinWidth(W);}};y.prototype._createDialog=function(){var e=this,i=this._getPickerHeader(),z=new D({stretch:true,ariaLabelledBy:this._getPickerHiddenLabelId(),customHeader:i,beforeOpen:function(){e.updatePickerHeaderTitle();}});return z;};y.prototype._getPickerTitle=function(){var e=this.getPicker(),i=e&&e.getCustomHeader();if(i){return i.getContentMiddle()[0];}return null;};y.prototype._getPickerHeader=function(){var i=b.getIconURI("decline"),R;if(!this.getAggregation("_pickerHeader")){R=C.getLibraryResourceBundle("sap.m");this.setAggregation("_pickerHeader",new c({titleAlignment:l.TitleAlignment.Auto,contentMiddle:new T({text:R.getText("SELECT_PICKER_TITLE_TEXT")}),contentRight:new B({icon:i,press:this.close.bind(this)})}));}return this.getAggregation("_pickerHeader");};y.prototype._getPickerHiddenLabelId=function(){return h.getStaticId("sap.m","INPUT_AVALIABLE_VALUES");};y.prototype.getPickerValueStateContentId=function(){return this.getId()+"-valueStateText";};y.prototype.updatePickerHeaderTitle=function(){var e=this.getPicker();if(!e){return;}var i=this.getLabels();if(i.length){var z=i[0],A=this._getPickerTitle();if(z&&(typeof z.getText==="function")){A&&A.setText(z.getText());}}};y.prototype._onBeforeOpenDialog=function(){};y.prototype.init=function(){this.setPickerType(g.system.phone?"Dialog":"Popover");this.createPicker(this.getPickerType());this._oSelectionOnFocus=null;this.bRenderingPhase=false;this._bFocusoutDueRendering=false;this._bProcessChange=false;this.sTypedChars="";this.iTypingTimeoutID=-1;this._oValueStateMessage=new V(this);this._bValueStateMessageOpened=false;this._sAriaRoleDescription=C.getLibraryResourceBundle("sap.m").getText("SELECT_ROLE_DESCRIPTION");this._oInvisibleMessage=null;};y.prototype.onBeforeRendering=function(){if(!this._oInvisibleMessage){this._oInvisibleMessage=q.getInstance();}this.bRenderingPhase=true;this.synchronizeSelection({forceSelection:this.getForceSelection()});this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();this._detachHiddenSelectHandlers();if(this._isIconOnly()){this.setAutoAdjustWidth(true);}};y.prototype.onAfterRendering=function(){this.bRenderingPhase=false;this._setHiddenSelectValue();this._attachHiddenSelectHandlers();};y.prototype.exit=function(){var e=this.getValueStateMessage(),i=this._getValueIcon();this._oSelectionOnFocus=null;if(this._oValueStateTextInvisibleText){this._oValueStateTextInvisibleText.destroy();this._oValueStateTextInvisibleText=null;}if(e){this.closeValueStateMessage();e.destroy();}if(i){i.destroy();}this._oValueStateMessage=null;this._bValueStateMessageOpened=false;};y.prototype.ontouchstart=function(e){e.setMarked();if(this.getEnabled()&&this.getEditable()){this.addStyleClass(this.getRenderer().CSS_CLASS+"Pressed");this.focus();}};y.prototype.ontouchend=function(e){e.setMarked();if(this.getEnabled()&&this.getEditable()&&!this.isOpen()&&this.isOpenArea(e.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS+"Pressed");}};y.prototype.ontap=function(e){var i=this.getRenderer().CSS_CLASS;e.setMarked();if(!this.getEnabled()||!this.getEditable()){return;}if(this.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(i+"Pressed");return;}if(g.system.phone){this.focus();}this.open();}if(this.isOpen()){this.addStyleClass(i+"Pressed");}};y.prototype.onSelectionChange=function(e){var i=e.getParameter("selectedItem"),z=this.getSelectedItem();this.close();this.setSelection(i);this.fireChange({selectedItem:i,previousSelectedItem:z});this.setValue(this._getSelectedItemText());};y.prototype.onkeypress=function(e){if(!this.getEditable()){return;}e.setMarked();var i=String.fromCharCode(e.which),z;this.sTypedChars+=i;z=(/^(.)\1+$/i).test(this.sTypedChars)?i:this.sTypedChars;clearTimeout(this.iTypingTimeoutID);this.iTypingTimeoutID=setTimeout(function(){this.sTypedChars="";this.iTypingTimeoutID=-1;}.bind(this),1000);H.call(this,this.searchNextItemByText(z));};y.prototype.onsapshow=function(e){if(!this.getEditable()){return;}e.setMarked();if(e.which===K.F4){e.preventDefault();}this.toggleOpenState();};y.prototype.onsaphide=y.prototype.onsapshow;y.prototype.onmousedown=function(e){e.preventDefault();this._getHiddenSelect().trigger("focus");};y.prototype.onsapescape=function(e){if(!this.getEditable()||this._bSpaceDown){return;}if(this.isOpen()){e.setMarked();this.close();this._revertSelection();}};y.prototype.onsapenter=function(e){e.preventDefault();if(!this.getEditable()){return;}if(this.isOpen()){e.setMarked();}this.close();this._checkSelectionChange();};y.prototype.onkeydown=function(e){if(e.which===K.SPACE){this._bSpaceDown=true;}if([K.ARROW_DOWN,K.ARROW_UP,K.SPACE].indexOf(e.which)>-1){e.preventDefault();}if(e.which===K.SHIFT||e.which===K.ESCAPE){this._bSupressNextAction=this._bSpaceDown;}};y.prototype.onkeyup=function(e){if(!this.getEditable()){return;}if(e.which===K.SPACE){if(!e.shiftKey&&!this._bSupressNextAction){e.setMarked();if(this.isOpen()){this._checkSelectionChange();}this.toggleOpenState();}this._bSpaceDown=false;this._bSupressNextAction=false;}};y.prototype.onsapdown=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var N,i=this.getSelectableItems();N=i[i.indexOf(this.getSelectedItem())+1];H.call(this,N);};y.prototype.onsapup=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var i,z=this.getSelectableItems();i=z[z.indexOf(this.getSelectedItem())-1];H.call(this,i);};y.prototype.onsaphome=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var F=this.getSelectableItems()[0];H.call(this,F);};y.prototype.onsapend=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.findLastEnabledItem(this.getSelectableItems());H.call(this,i);};y.prototype.onsappagedown=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems(),z=this.getSelectedItem();this.setSelectedIndex(i.indexOf(z)+10,i);z=this.getSelectedItem();if(z){this.setValue(z.getText());}this.scrollToItem(z);};y.prototype.onsappageup=function(e){if(!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems(),z=this.getSelectedItem();this.setSelectedIndex(i.indexOf(z)-10,i);z=this.getSelectedItem();if(z){this.setValue(z.getText());}this.scrollToItem(z);};y.prototype.onsaptabnext=function(e){if(this.isOpen()){this.close();this._checkSelectionChange();}};y.prototype.onsaptabprevious=y.prototype.onsaptabnext;y.prototype.onfocusin=function(e){if(!this._bFocusoutDueRendering&&!this._bProcessChange){this._oSelectionOnFocus=this.getSelectedItem();}this._bProcessChange=true;setTimeout(function(){if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&(document.activeElement===this.getFocusDomRef())){this.openValueStateMessage();}}.bind(this),100);};y.prototype.onfocusout=function(e){this._handleFocusout(e);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};y.prototype.onsapfocusleave=function(e){var i=this.getAggregation("picker");if(!e.relatedControlId||!i){return;}var z=C.byId(e.relatedControlId),F=z&&z.getFocusDomRef();if(g.system.desktop&&k(i.getFocusDomRef(),F)){this.focus();}};y.prototype.getFocusDomRef=function(){return this._getHiddenSelect()[0];};y.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};y.prototype.setSelection=function(i){var e=this.getList(),z;if(e){e.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof f)?i.getId():i,true);if(typeof i==="string"){i=C.byId(i);}z=i?i.getKey():"";this.setProperty("selectedKey",z,true);this._handleAriaActiveDescendant(i);};y.prototype.setColumnRatio=function(R){var e=this.getList();this.setProperty("columnRatio",R,true);if(e&&this.getShowSecondaryValues()){e.setProperty("_columnRatio",this.getColumnRatio());}return this;};y.prototype.isSelectionSynchronized=function(){return S.prototype.isSelectionSynchronized.apply(this,arguments);};y.prototype.synchronizeSelection=function(){S.prototype.synchronizeSelection.apply(this,arguments);};y.prototype.addContent=function(e){};y.prototype.addContentToFlex=function(){};y.prototype.createPicker=function(e){var i=this.getAggregation("picker"),z=this.getRenderer().CSS_CLASS;if(i){return i;}i=this["_create"+e]();this.setAggregation("picker",i,true);i.setHorizontalScrolling(false).setVerticalScrolling(false).addStyleClass(z+"Picker").addStyleClass(z+"Picker-CTX").addStyleClass("sapUiNoContentPadding").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getSimpleFixFlex());return i;};y.prototype.searchNextItemByText=function(e){var z=this.getItems(),A=this.getSelectedIndex(),F=z.splice(A+1,z.length-A),G=z.splice(0,z.length-1);z=F.concat(G);for(var i=0,J;i<z.length;i++){J=z[i];var N=typeof e==="string"&&e!=="";if(J.getEnabled()&&!(J instanceof sap.ui.core.SeparatorItem)&&J.getText().toLowerCase().startsWith(e.toLowerCase())&&N){return J;}}return null;};y.prototype.createList=function(){var e=r,i=g.system.phone?e.Delimited:e.None;this._oList=new S({width:"100%",keyboardNavigationMode:i,hideDisabledItems:true}).addStyleClass(this.getRenderer().CSS_CLASS+"List-CTX").addEventDelegate({ontap:function(z){var A=z.srcControl;if(A.getEnabled()){this._checkSelectionChange();this.close();}}},this).attachSelectionChange(this.onSelectionChange,this);this._oList.setProperty("_tabIndex","-1");this._oList.toggleStyleClass("sapMSelectListWrappedItems",this.getWrapItemsText());return this._oList;};y.prototype.setWrapItemsText=function(W){var e=this.getPicker();if(this._oList){this._oList.toggleStyleClass("sapMSelectListWrappedItems",W);}if(e&&this.getPickerType()==="Popover"){e.toggleStyleClass("sapMPickerWrappedItems",W);}return this.setProperty("wrapItemsText",W,true);};y.prototype.hasContent=function(){return this.getItems().length>0;};y.prototype.onBeforeRenderingPicker=function(){var O=this["_onBeforeRendering"+this.getPickerType()];O&&O.call(this);};y.prototype.onAfterRenderingPicker=function(){var O=this["_onAfterRendering"+this.getPickerType()];O&&O.call(this);};y.prototype.open=function(){var e=this.getPicker();this.focus();if(e){e.open();}return this;};y.prototype.toggleOpenState=function(){if(this.isOpen()){this.close();}else{this.open();}return this;};y.prototype.getVisibleItems=function(){var e=this.getList();return e?e.getVisibleItems():[];};y.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};y.prototype.getSelectedIndex=function(){var e=this.getSelectedItem();return e?this.indexOfItem(this.getSelectedItem()):-1;};y.prototype.getDefaultSelectedItem=function(i){return this.getForceSelection()?this.findFirstEnabledItem():null;};y.prototype.getSelectableItems=function(){var e=this.getList();if(!e){return[];}return e.getSelectableItems();};y.prototype.getOpenArea=function(){return this.getDomRef();};y.prototype.isOpenArea=function(e){var O=this.getOpenArea();return O&&O.contains(e);};y.prototype.getFormFormattedValue=function(){var i=this.getSelectedItem();return i?i.getText():"";};y.prototype.getFormValueProperty=function(){return"selectedKey";};y.prototype.findItem=function(e,i){var z=this.getList();return z?z.findItem(e,i):null;};y.prototype.clearSelection=function(){this.setSelection(null);};y.prototype.onItemChange=function(e){var i=this.getAssociation("selectedItem"),z=e.getParameter("id"),A=e.getParameter("name"),N=e.getParameter("newValue"),O,F,G,J;if(A==="key"&&!this.isBound("selectedKey")){F=this.getSelectedKey();G=this.getItemByKey(N);if(N===F&&i!==z&&G&&z===G.getId()){this.setSelection(G);return;}O=e.getParameter("oldValue");if(i===z&&F===O&&!this.getItemByKey(O)){this.setSelectedKey(N);return;}J=this.getItemByKey(F);if(i===z&&N!==F&&J){this.setSelection(J);return;}}if(A==="text"&&i===z){this.fireEvent("_itemTextChange");this.setValue(N);}};y.prototype.fireChange=function(e){this._oSelectionOnFocus=e.selectedItem;return this.fireEvent("change",e);};y.prototype.addAggregation=function(A,O,e){if(A==="items"&&!e&&!this.isInvalidateSuppressed()){this.invalidate(O);}return a.prototype.addAggregation.apply(this,arguments);};y.prototype.destroyAggregation=function(A,e){if(A==="items"&&!e&&!this.isInvalidateSuppressed()){this.invalidate();}return a.prototype.destroyAggregation.apply(this,arguments);};y.prototype.setAssociation=function(A,i,e){var z=this.getList();if(z&&(A==="selectedItem")){S.prototype.setAssociation.apply(z,arguments);}return a.prototype.setAssociation.apply(this,arguments);};y.prototype.setProperty=function(i,z,A){var F=this.getList();if((i==="selectedKey")||(i==="selectedItemId")){F&&S.prototype.setProperty.apply(F,arguments);}try{a.prototype.setProperty.apply(this,arguments);}catch(e){o.warning('Update failed due to exception. Loggable in support mode log',null,null,function(){return{exception:e};});}return this;};y.prototype.removeAllAssociation=function(A,e){var i=this.getList();if(i&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(i,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};y.prototype.clone=function(){var e=a.prototype.clone.apply(this,arguments),i=this.getSelectedItem(),z=this.getSelectedKey();if(!this.isBound("selectedKey")&&!e.isSelectionSynchronized()){if(i&&(z==="")){e.setSelectedIndex(this.indexOfItem(i));}else{e.setSelectedKey(z);}}return e;};y.prototype._updatePickerAriaLabelledBy=function(e){var i=this.getPicker(),z;if(!i){return;}z=this.getValueStateTextInvisibleText().getId();if(e===t.None){i.removeAriaLabelledBy(z);}else{i.addAriaLabelledBy(z);}};y.prototype.getLabels=function(){var e=this.getAriaLabelledBy().concat(L.getReferencingLabels(this));e=e.filter(function(i,z){return e.indexOf(i)===z;}).map(function(i){return C.byId(i);});return e;};y.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};y.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};y.prototype.getValueStateMessage=function(){return this._oValueStateMessage;};y.prototype.openValueStateMessage=function(){var e=this.getValueStateMessage();if(e&&!this._bValueStateMessageOpened){this._bValueStateMessageOpened=true;e.open();}};y.prototype.closeValueStateMessage=function(){var e=this.getValueStateMessage();if(e&&this._bValueStateMessageOpened){this._bValueStateMessageOpened=false;e.close();}};y.prototype.shouldValueStateMessageBeOpened=function(){return!this._isIconOnly()&&(this.getValueState()!==t.None)&&this.getEnabled()&&this.getEditable()&&!this._bValueStateMessageOpened;};y.prototype.setShowSecondaryValues=function(A){var e=!this._isShadowListRequired();this.setProperty("showSecondaryValues",A,e);var i=this.getList(),z=A?this.getColumnRatio():null;if(i){i.setShowSecondaryValues(A);i.setProperty("_columnRatio",z);}return this;};y.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};y.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};y.prototype.findAggregatedObjects=function(){var e=this.getList();if(e){return S.prototype.findAggregatedObjects.apply(e,arguments);}return[];};y.prototype.getItems=function(){var e=this.getList();return e?e.getItems():[];};y.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=C.byId(i);}if(!(i instanceof f)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));this._oSelectionOnFocus=i;return this;};y.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText());this._oSelectionOnFocus=this.getSelectedItem();return this;};y.prototype._isKeyAvailable=function(e){var A=this._oList.getItems().map(function(i){return i.getKey();});return A.indexOf(e)>-1;};y.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e==="");if(!i&&!this._isKeyAvailable(e)&&this.getResetOnMissingKey()){i=true;}if(!this.getForceSelection()&&i){this.setSelection(null);this.setValue("");return this.setProperty("selectedKey",e);}var z=this.getItemByKey(e);if(z||i){if(!z&&i){z=this.getDefaultSelectedItem();}this.setSelection(z);this.setValue(this._getSelectedItemText(z));this._oSelectionOnFocus=z;return this;}return this.setProperty("selectedKey",e);};y.prototype.setValueState=function(e){var O=this.getValueState();if(e===O){return this;}this.setProperty("valueState",e);this._updatePickerAriaLabelledBy(e);if(this._isFocused()){this._announceValueStateText();}var i=this.getDomRefForValueState();if(!i){return this;}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&document.activeElement===i){this.openValueStateMessage();}else{this.closeValueStateMessage();}this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();return this;};y.prototype.setValueStateText=function(e){var i=this.getValueStateTextInvisibleText();this.setProperty("valueStateText",e);if(i){i.setText(e);}if(this.getDomRefForValueState()){this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();}if(this._isFocused()){this._announceValueStateText();}return this;};y.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};y.prototype.getSelectedItem=function(){var e=this.getAssociation("selectedItem");return(e===null)?null:C.byId(e)||null;};y.prototype.getFirstItem=function(){return this.getItems()[0]||null;};y.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};y.prototype.getEnabledItems=function(i){var e=this.getList();return e?e.getEnabledItems(i):[];};y.prototype.getItemByKey=function(e){var i=this.getList();return i?i.getItemByKey(e):null;};y.prototype.removeItem=function(i){var e;i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){e=this.findFirstEnabledItem();if(e){this.setSelection(e);}}this.setValue(this._getSelectedItemText());if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};y.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}for(var i=0;i<e.length;i++){e[i].detachEvent("_change",this.onItemChange,this);}return e;};y.prototype.destroyItems=function(){this.destroyAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}return this;};y.prototype.isOpen=function(){var e=this.getAggregation("picker");return!!(e&&e.isOpen());};y.prototype.close=function(){var e=this.getAggregation("picker");if(e){e.close();}return this;};y.prototype.getDomRefForValueState=function(){return this.getFocusDomRef();};y.prototype._isRequired=function(){return this.getRequired()||L.isRequired(this);};y.prototype.getAccessibilityInfo=function(){var i=this._isIconOnly(),e={role:this.getRenderer().getAriaRole(this),focusable:this.getEnabled(),enabled:this.getEnabled(),readonly:i?undefined:this.getEnabled()&&!this.getEditable()};if(i){var z=this.getTooltip_AsString();if(!z){var A=b.getIconInfo(this.getIcon());z=A&&A.text?A.text:"";}e.type=C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON");e.description=z;}else if(this.getType()==="Default"){e.type=C.getLibraryResourceBundle("sap.m").getText("SELECT_ROLE_DESCRIPTION");e.description=this._getSelectedItemText();}return e;};y.prototype.getIdForLabel=function(){return this.getId()+"-hiddenSelect";};return y;});
