/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateTypeRange','sap/ui/unified/library','sap/ui/core/LocaleData','sap/ui/core/Locale','sap/ui/core/delegate/ItemNavigation','sap/ui/core/dnd/DragDropInfo','sap/ui/core/CustomData','sap/ui/events/KeyCodes','sap/base/Log','sap/ui/core/Core','./Link','./PlanningCalendarLegend','./SinglePlanningCalendarMonthGridRenderer'],function(C,D,c,d,e,u,L,f,I,g,h,K,l,m,n,P,S){"use strict";var A=1.5625;var o=1.5;var p=2.125;var q=1.75;var r=C.extend("sap.m.SinglePlanningCalendarMonthGrid",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_appsPlaceholders:{type:"sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true,associations:{legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},moreLinkPress:{parameters:{date:{type:"object"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}},appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"}}}}}});r.prototype.init=function(){this._aLinks=[];this._handleMorePress=this._handleMorePress.bind(this);this._oDateFormat=D.getDateTimeInstance({pattern:"YYYYMMdd"});this._oFormatAriaApp=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+this._getCoreLocaleData().getTimePattern("medium")});this._oFormatAriaFullDayCell=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY"});this.setStartDate(new Date());this._configureAppointmentsDragAndDrop();};r.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}for(var i=0;i<this._aLinks.length;i++){if(this._aLinks[i]){this._aLinks[i].destroy();}}delete this._aLinks;};r.prototype.onBeforeRendering=function(){var a=this.getStartDate();this._oAppointmentsToRender=this._calculateAppointmentsNodes(a);this._createAppointmentsDndPlaceholders(a);};r.prototype.onAfterRendering=function(){this._initItemNavigation();};r.prototype._getColumns=function(){return 7;};r.prototype._getRows=function(){return 6;};r.prototype._getDateFormatter=function(){return this._oDateFormat;};r.prototype._getAppointmetsForADay=function(a){return this._oAppointmentsToRender.filter(function(b){return b.start.valueOf()===a.valueOf();});};r.prototype._getPreviousAppointmetsForADay=function(a){return this._oAppointmentsToRender.filter(function(b){return b.start.valueOf()<a.valueOf()&&b.end.valueOf()>=a.valueOf();}).map(function(b){var i={data:b.data,start:b.start,end:b.end,len:b.len,level:b.level,width:b.width};i.width-=d._daysBetween(a,b.start);i.hasPrevious=true;return i;},this);};r.prototype.ontap=function(E){this._fireSelectionEvent(E);};r.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this._fireSelectionEvent(E);E.preventDefault();}};r.prototype._findSrcControl=function(E){if(!E.target.parentElement||!E.target.parentElement.classList.contains("sapUiCalendarRowApps")){return E.srcControl;}var a=E.target.parentElement.getAttribute("data-sap-ui-related");return this.getAppointments().find(function(b){return b.sId===a;});};r.prototype._fireSelectionEvent=function(E){var a=this._findSrcControl(E),t=E.target,i=t&&t.classList.contains("sapMSPCMonthDay"),b=t&&t.classList.contains("sapMLnk"),T,j,k;if(a&&a.isA("sap.m.SinglePlanningCalendarMonthGrid")&&i&&!b){T=parseInt(t.getAttribute("sap-ui-date"));j=new Date(T);j=new Date(j.getFullYear(),j.getMonth(),j.getDate());k=new Date(j);k.setDate(k.getDate()+1);this.fireEvent("cellPress",{startDate:j,endDate:k});this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});}else if(a&&a.isA("sap.ui.unified.CalendarAppointment")){if(t.parentElement&&t.parentElement.getAttribute("id")){var v=t.parentElement.getAttribute("id");var B=t.parentElement.getAttribute("data-sap-ui-related");var w=v.replace(B+"-","");a._setAppointmentPartSuffix(w);}this.fireAppointmentSelect({appointment:a,appointments:this._toggleAppointmentSelection(a,!(E.ctrlKey||E.metaKey))});}};r.prototype._toggleAppointmentSelection=function(a,R){var b=[],j=a&&a.getDomRef(),k,t,i;if(R){k=this.getAppointments();for(i=0,t=k.length;i<t;i++){if((!a||k[i].getId()!==a.getId())&&k[i].getSelected()){k[i].setProperty("selected",false);b.push(k[i]);}}}if(a){a.setProperty("selected",!a.getSelected());b.push(a);this._sSelectedAppointment=a.getSelected()&&j?a:undefined;}else{this._sSelectedAppointment=undefined;}return b;};r.prototype._getMoreLink=function(a,b,i){var M=m.getLibraryResourceBundle("sap.m").getText("SPC_MORE_LINK",[a.toString()]),j=new n({text:M,press:this._handleMorePress}).addCustomData(new h({key:"date",value:b.valueOf().toString(),writeToDom:true}));if(this._aLinks[i]){this._aLinks[i].destroy();}this._aLinks[i]=j;return j;};r.prototype._handleMorePress=function(E){var t=parseInt(E.getSource().getCustomData()[0].getValue()),a=new Date(t);a=new Date(a.getFullYear(),a.getMonth(),a.getDate());this.fireEvent("moreLinkPress",{date:a});};r.prototype._getCoreLocaleData=function(){var a=m.getConfiguration().getFormatSettings().getFormatLocale().toString(),b=new f(a);return L.getInstance(b);};r.prototype._getCells=function(){return this._getVisibleDays(this.getStartDate());};r.prototype._getVerticalLabels=function(){var a=this._getVisibleDays(this.getStartDate()),b=this._getColumns(),R=[],j=m.getConfiguration().getFormatLocale().toString(),k=this._getCoreLocaleData();for(var i=0;i<this._getRows();i++){R.push(d.calculateWeekNumber(a[i*b].toUTCJSDate(),a[i*b].getYear(),j,k));}return R;};r.prototype._getVisibleDays=function(a){var b,j,k,t,F,v,V=[];if(!a){return V;}b=c.fromLocalJSDate(a);v=this._getCoreLocaleData().getFirstDayOfWeek();F=new c(b);F.setDate(1);t=F.getDay()-v;if(t<0){t=7+t;}if(t>0){F.setDate(1-t);}j=new c(F);for(var i=0;i<this._getColumns()*this._getRows();i++){k=new c(j);V.push(k);j.setDate(j.getDate()+1);}return V;};r.prototype._getAppointmentsToRender=function(){return this._oAppointmentsToRender;};r.prototype._calculateAppointmentsNodes=function(t){var v=this._getVisibleDays(t),F=v[0],w=v[v.length-1],x=this.getAppointments().filter(function(a){var b=a.getStartDate()&&a.getEndDate();if(!b){l.warning("Appointment "+a.getId()+" has no start or no end date. It is ignored.");}return b;}).map(function(a){var b=c.fromLocalJSDate(a.getStartDate()),G=c.fromLocalJSDate(a.getEndDate());return{data:a,start:b,end:G,len:d._daysBetween(G,b)};}).filter(function(a){return d._isBetween(a.start,F,w,true)||d._isBetween(a.end,F,w,true)||(d._isBetween(F,a.start,w,true)&&d._isBetween(w,F,a.end,true));}).sort(function G(a,b){return a.start.valueOf()-b.start.valueOf();}),V=[],y,z,E,B,i,j,k;for(i=0;i<v.length;i++){V.push([]);}for(i=0;i<x.length;i++){y=x[i];z=d._daysBetween(y.start,v[0]);E=z+y.len;z=z>0?z:0;E=E<v.length?E:v.length-1;y.width=y.len+1;B=V[z].indexOf(true);if(B===-1){B=V[z].length;}y.level=B;for(j=z;j<=E;j++){V[j][B]=false;for(k=0;k<B;k++){if(V[j][k]===undefined){V[j][k]=true;}}}}this._aAppsLevelsPerDay=V;return x;};r.prototype._getMoreCountPerCell=function(a){var b=this._aAppsLevelsPerDay[a];var M=this._getMaxAppointments();var j=0;var k=0;if(b.length<=M){return 0;}for(var i=0;i<b.length;i++){if(!b[i]){j++;}if(i<M-1){k++;}}return j-k;};r.prototype._configureAppointmentsDragAndDrop=function(){this.addDragDropConfig(new g({sourceAggregation:"appointments",targetAggregation:"_appsPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()){E.preventDefault();return false;}var H=function(){var O=jQuery(".sapMSinglePCOverlay");setTimeout(function(){O.addClass("sapMSinglePCOverlayDragging");});jQuery(document).one("dragend",function(){O.removeClass("sapMSinglePCOverlayDragging");});};H();}.bind(this),dragEnter:function(E){var a=E.getParameter("dragSession"),b=function(){var i=jQuery(a.getIndicator());i.css("min-height",a.getDropControl().$().outerHeight());i.css("min-width",a.getDropControl().$().outerWidth());};if(!a.getIndicator()){setTimeout(b,0);}else{b();}},drop:function(E){var a=E.getParameter("dragSession"),b=a.getDragControl(),i=a.getDropControl(),j=i.getDate(),k=c.fromLocalJSDate(b.getStartDate()),t=c.fromLocalJSDate(b.getEndDate()),O=d._daysBetween(j,k),v=new c(k),w=new c(t),B=E.getParameter("browserEvent"),x=(B.metaKey||B.ctrlKey);v.setDate(v.getDate()+O);w.setDate(w.getDate()+O);this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(k.valueOf()===j.valueOf()){return;}this.fireAppointmentDrop({appointment:b,startDate:v.toLocalJSDate(),endDate:w.toLocalJSDate(),copy:x});}.bind(this)}));};r.prototype._initItemNavigation=function(){var R=this.getDomRef();this._aGridCells=this.$().find(".sapMSPCMonthDay").toArray();if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._itemNavigationBorderReached,this);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(this._aGridCells);this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this._oItemNavigation.setTableMode(false).setColumns(this._getColumns(),true);this._oItemNavigation.setPageSize(this._aGridCells.length);};r.prototype._itemNavigationBorderReached=function(E){var G,F,i=E.getParameter("event"),O;if(i.target.classList.contains("sapMSPCMonthDay")){G=i.target;F=parseInt(G.getAttribute("sap-ui-date"));switch(i.keyCode){case K.ARROW_LEFT:O=-1;break;case K.ARROW_UP:O=-this._getColumns();break;case K.ARROW_RIGHT:O=1;break;case K.ARROW_DOWN:O=this._getColumns();break;default:break;}this.fireEvent("borderReached",{startDate:F,offset:O});}};r.prototype._createAppointmentsDndPlaceholders=function(a){var b=this._getVisibleDays(a);this.destroyAggregation("_appsPlaceholders");for(var i=0;i<b.length;i++){var j=new s({date:b[i]});this.addAggregation("_appsPlaceholders",j,true);}};var s=C.extend("sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",{metadata:{properties:{date:{type:"object",group:"Data"}}},renderer:{apiVersion:2,render:function(R,a){R.openStart("div",a).class("sapMSinglePCPlaceholder").openEnd().close("div");}}});r.prototype._getCellStartInfo=function(a){var b=m.getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_START_TIME");return b+": "+this._oFormatAriaFullDayCell.format(a)+"; ";};r.prototype._getAppointmentAnnouncementInfo=function(a){var U=m.getLibraryResourceBundle("sap.ui.unified"),b=U.getText("CALENDAR_START_TIME"),E=U.getText("CALENDAR_END_TIME"),F=this._oFormatAriaApp.format(a.getStartDate()),i=this._oFormatAriaApp.format(a.getEndDate()),j=b+": "+F+"; "+E+": "+i;return j+"; "+P.findLegendItemForItem(m.byId(this._sLegendId),a);};r.prototype._getMaxAppointments=function(){return this._isCompact()?4:3;};r.prototype._getDensitySizes=function(){return this._isCompact()?{appHeight:A,cellHeaderHeight:o}:{appHeight:p,cellHeaderHeight:q};};r.prototype._isCompact=function(){var a=this.getDomRef()||(this.getParent()&&this.getParent().getDomRef&&this.getParent().getDomRef()||(this.getParent()&&this.getParent().getRootNode&&this.getParent().getRootNode()));while(a&&a.classList){if(a.classList.contains("sapUiSizeCompact")){return true;}a=a.parentNode;}return false;};r.prototype._getSpecialDates=function(){var a=this.getSpecialDates();for(var i=0;i<a.length;i++){var N=a[i].getSecondaryType()===u.CalendarDayType.NonWorking&&a[i].getType()!==u.CalendarDayType.NonWorking;if(N){var b=new e();b.setType(u.CalendarDayType.NonWorking);b.setStartDate(a[i].getStartDate());if(a[i].getEndDate()){b.setEndDate(a[i].getEndDate());}a.push(b);}}return a;};r.prototype.applyFocusInfo=function(){this._sSelectedAppointment&&this._sSelectedAppointment.focus();return this;};return r;});
