/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","./TimePickerInternals","./Input","./InputRenderer","sap/ui/core/Renderer","./SegmentedButton","./SegmentedButtonItem","sap/ui/core/InvisibleText","sap/ui/events/KeyCodes","./TimePickerInputsRenderer","sap/ui/thirdparty/jquery"],function(l,c,T,I,a,R,S,b,d,K,e,q){"use strict";var f=l.InputType,g=c.TextAlign,h=1000;var i=T.extend("sap.m.TimePickerInputs",{metadata:{aggregations:{_inputs:{type:"sap.m.Input",multiple:true,visibility:"hidden"},_texts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}}}});i.prototype.onAfterRendering=function(){if(!this._clickAttached){this._attachClickEvent();}};i.prototype._attachClickEvent=function(){var E=this.getDomRef();E.addEventListener("click",q.proxy(this._clickHandler,this),false);this._clickAttached=true;};i.prototype._clickHandler=function(E){var k=this.getAggregation("_inputs"),A=this._getActiveInput();if(A===-1){A=this._lastActiveInput;}!document.activeElement.classList.contains("sapMSegBBtn")&&k&&k[A]&&k[A].focus();};i.prototype.onkeydown=function(E){var k=E.which||E.keyCode,m=E.key,p,n=this.getAggregation("_inputs"),A=this._getActiveInput(),s=A>-1&&n[A]?n[A].getId().slice(-1):"",N=["0","1","2","3","4","5","6","7","8","9"],v,B="",o,r=false,t,u;if(m===":"){E.preventDefault();this._kbdBuffer="";this._resetCooldown(true);this._switchNextInput(true);}else if(k===K.ENTER){p=this.getParent().getParent();p&&p._handleNumericOkPress();}else if(k===K.P||k===K.A){E.preventDefault();u=this._getFormatButton();u&&u.setSelectedKey(k===K.P?"pm":"am");}else if((k===K.ARROW_UP||k===K.ARROW_DOWN)&&!E.altKey&&!E.metaKey){E.preventDefault();t=this._getActiveInputObject();t&&t.getEnabled()&&this._keyboardUpdateInput(t,k===K.ARROW_UP?1:-1);if(s==="H"){this._handleHoursChange(t.getValue());}}else if(s!==""&&N.indexOf(m)!==-1){E.preventDefault();B=this._kbdBuffer+m;o=parseInt(B);this._resetCooldown(true);if(o>this._inputsProperties[s].max){v=this._formatNumberToString(parseInt(this._kbdBuffer),this._inputsProperties[s].prependZero,this._inputsProperties[s].max,"");n[A].setValue(v);this._handleHoursChange(v);this._inputsProperties[s].value=v;setTimeout(function(){this._switchNextInput();this._kbdBuffer=m;A=this._getActiveInput();s=n[A].getId().slice(-1);v=this._formatNumberToString(parseInt(m),this._inputsProperties[s].prependZero,this._inputsProperties[s].max,"");n[A].setValue(v);this._inputsProperties[s].value=v;this._resetCooldown(true);}.bind(this),0);}else{this._kbdBuffer=B;v=this._formatNumberToString(parseInt(this._kbdBuffer),this._inputsProperties[s].prependZero,this._inputsProperties[s].max,"");n[A].setValue(v);this._inputsProperties[s].value=v;if(this._kbdBuffer.length===2||parseInt(this._kbdBuffer+"0")>this._inputsProperties[s].max){this._resetCooldown(this._kbdBuffer.length===2?false:true);if(s==="H"){r=this._handleHoursChange(this._kbdBuffer);}this._kbdBuffer="";if(!r||s!=="H"){setTimeout(function(){this._switchNextInput();}.bind(this),0);}}}}else if(k!==K.ARROW_LEFT&&k!==K.ARROW_RIGHT&&k!==K.BACKSPACE&&k!==K.DELETE&&k!==K.TAB){E.preventDefault();}};i.prototype._keyboardUpdateInput=function(o,D){var s=parseInt(o.getValue()),A=o.getId().slice(-1),m=this._inputsProperties[A].min,M=this._inputsProperties[A].max,k=this._inputsProperties[A].step;s+=D*k;if(s>M){s=M;}else if(s<m){s=m;}o.setValue(this._formatNumberToString(s,this._inputsProperties[A].prependZero,this._inputsProperties[A].max,""));};i.prototype._resetCooldown=function(s){if(this._typeCooldownId){clearTimeout(this._typeCooldownId);}if(s){this._startCooldown();}};i.prototype._startCooldown=function(){this._typeCooldownId=setTimeout(function(){var k=this.getAggregation("_inputs");this._kbdBuffer="";this._typeCooldownId=null;k&&k[this._activeInput]&&k[this._activeInput].getDomRef("inner").select();}.bind(this),h);};i.prototype.setValue=function(v){var H=this._getHoursInput(),F=this._getValueFormatPattern(),k=F.indexOf("HH"),m=F.indexOf("H"),n=H&&H.getValue()==="24",o=T._isHoursValue24(v,k,m),D;if(n&&this._isFormatSupport24()&&!o){v=T._replaceZeroHoursWith24(v,k,m);}v=this.validateProperty("value",v);this.setProperty("value",v,true);if(v){D=this._parseValue(o?T._replace24HoursWithZero(v,k,m):v);}if(D){this._setTimeValues(D,o);}return this;};i.prototype._switchNextInput=function(w){var A=this._getActiveInput(),k=this.getAggregation("_inputs"),m=k.length,s=A;if(!k){return;}do{A++;if(A>=k.length){A=w?0:m-1;}}while(!k[A].getEnabled()&&A!==s&&(w||A<m-1));if(A!==s&&k[A].getEnabled()){this._switchInput(A);}};i.prototype.getTimeValues=function(){var H=this._getHoursInput(),m=this._getMinutesInput(),s=this._getSecondsInput(),F=this._getFormatButton(),k=null,A=null,D=new Date();if(H){k=parseInt(H.getValue());}if(F){A=F.getSelectedKey();}if(A==="am"&&k===12){k=0;}else if(A==="pm"&&k!==12){k+=12;}if(k!==null){D.setHours(k.toString());}if(m){D.setMinutes(m.getValue());}if(s){D.setSeconds(s.getValue());}return D;};i.prototype._getActiveInput=function(){return this._activeInput;};i.prototype._getActiveInputObject=function(){var A=this._getActiveInput(),k=this.getAggregation("_inputs");return k&&k[A]?k[A]:null;};i.prototype._setTimeValues=function(D,H){var o=this._getHoursInput(),m=this._getMinutesInput(),s=this._getSecondsInput(),F=this._getFormatButton(),v=this.getValueFormat(),k,A=null;D=D||new Date();if(Object.prototype.toString.call(D)!=="[object Date]"||isNaN(D)){throw new Error("Date must be a JavaScript date object; "+this);}if(!H){var V=this._formatValue(D,true);this.setProperty("value",V,true);k=D.getHours();}else{k=24;}if((v.indexOf("a")!==-1||v==="")&&F){A=k>=12?"pm":"am";k=(k>12)?k-12:k;k=(k===0?12:k);}o&&o.setValue(this._formatNumberToString(k,this._inputsProperties.H.prependZero,this._inputsProperties.H.max,""));m&&m.setValue(this._formatNumberToString(D.getMinutes(),this._inputsProperties.M.prependZero,this._inputsProperties.M.max,""));s&&s.setValue(this._formatNumberToString(D.getSeconds(),this._inputsProperties.S.prependZero,this._inputsProperties.S.max,""));F&&F.setSelectedKey(A);if(H){m&&m.setValue("00").setEnabled(false);s&&s.setValue("00").setEnabled(false);}else{m&&m.setEnabled(true);s&&s.setEnabled(true);}if(o){this._inputsProperties.H.value=k;}if(m){this._inputsProperties.M.value=m.getValue();}if(s){this._inputsProperties.S.value=s.getValue();}};i.prototype._getHoursInput=function(){var o=this.getAggregation("_inputs");return o&&this._inputIndexes&&o[this._inputIndexes.H]?o[this._inputIndexes.H]:null;};i.prototype._getMinutesInput=function(){var o=this.getAggregation("_inputs");return o&&this._inputIndexes&&o[this._inputIndexes.M]?o[this._inputIndexes.M]:null;};i.prototype._getSecondsInput=function(){var o=this.getAggregation("_inputs");return o&&this._inputIndexes&&o[this._inputIndexes.S]?o[this._inputIndexes.S]:null;};i.prototype._destroyControls=function(){this.destroyAggregation("_inputs");this.destroyAggregation("_buttonAmPm");};i.prototype._createControls=function(){var F=this._getDisplayFormatPattern(),s=this.getId(),k=this._isFormatSupport24(),m=this.getSupport2400(),n=0,o=0,p=0,r="",t=this.getAggregation("_texts"),M=0,u,v,w=0,H,P=false,x,y,z,V,D;this._inputIndexes={};this._inputsProperties={};if(F===undefined){return;}x=F.indexOf("HH");y=F.indexOf("H");if(!t){this.addAggregation("_texts",new d(s+"-textH",{text:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_HOURS")}).toStatic());this.addAggregation("_texts",new d(s+"-textM",{text:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_MINUTES")}).toStatic());this.addAggregation("_texts",new d(s+"-textS",{text:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_SECONDS")}).toStatic());}if(x!==-1){H=true;P=true;u=(m)?24:23;}else if(y!==-1){H=true;u=(m)?24:23;}else if(F.indexOf("hh")!==-1){H=true;P=true;M=1;u=12;}else if(F.indexOf("h")!==-1){H=true;M=1;u=12;}if(H){this.addAggregation("_inputs",new j(s+"-inputH",{type:f.Number,tooltip:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_HOURS"),textAlign:g.Center,width:"2.875rem",value:n,ariaLabelledBy:s+"-textH"}));this._inputsProperties.H={min:M,max:u,prependZero:P,step:1,value:n,format24:k};this._inputIndexes.H=w++;}if(F.indexOf("m")!==-1){P=F.indexOf("mm")!==-1;u=59;this.addAggregation("_inputs",new j(s+"-inputM",{type:f.Number,tooltip:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_MINUTES"),textAlign:g.Center,width:"2.875rem",value:o,ariaLabelledBy:s+"-textM"}));this._inputsProperties.M={min:0,max:u,prependZero:P,step:this.getMinutesStep(),value:o};this._inputIndexes.M=w++;}if(F.indexOf("s")!==-1){P=F.indexOf("ss")!==-1;u=59;this.addAggregation("_inputs",new j(s+"-inputS",{type:f.Number,tooltip:this._oResourceBundle.getText("TIMEPICKER_INPUTS_ENTER_SECONDS"),textAlign:g.Center,width:"2.875rem",value:p,ariaLabelledBy:s+"-textS"}));this._inputsProperties.S={min:0,max:u,prependZero:P,step:this.getSecondsStep(),value:p};this._inputIndexes.S=w++;}if(F.indexOf("a")!==-1){this.setAggregation("_buttonAmPm",new S(s+"-format",{items:[new b({text:this._sAM,key:"am"}),new b({text:this._sPM,key:"pm"})],selectedKey:r,tooltip:this._oResourceBundle.getText("TIMEPICKER_AMPM_BUTTON_TOOLTIP")}));}v=this.getAggregation("_inputs");this._inputCount=v.length;this._switchInput(0);for(w=0;w<this._inputCount;w++){this._attachEvents(v[w]);}V=this.getValue();if(V){z=T._isHoursValue24(V,x,y);D=this._parseValue(z?T._replace24HoursWithZero(V,x,y):V);if(D){this._setTimeValues(D,z);}}};i.prototype._attachEvents=function(o){o.onfocusin=function(E){var s=E.currentTarget.id.slice(-1),k=this.getAggregation("_inputs");this._activeInput=this._inputIndexes[s];k[this._activeInput].addStyleClass("sapMFocus");k[this._activeInput].getDomRef("inner").select();}.bind(this);o.onfocusout=function(E){var s=E.currentTarget.id.slice(-1),k=this.getAggregation("_inputs");if(this._inputsProperties[s].value===""){this._inputsProperties[s].value="00";k[this._activeInput].setValue("00");}else if(s!=="H"){k[this._activeInput].setValue(k[this._activeInput].getValue());}if(s==="H"&&!this._inputsProperties[s].format24&&parseInt(this._inputsProperties[s].value)===0){this._inputsProperties[s].value="12";k[this._activeInput].setValue("12");}k[this._activeInput].removeStyleClass("sapMFocus");this._lastActiveInput=this._activeInput;this._activeInput=-1;}.bind(this);o.attachLiveChange(function(E){var A=E.getParameter("id").slice(-1),v=E.getParameter("value");if(v!==this._inputsProperties[A].value.toString()){this._inputsProperties[A].value=v;this._kbdBuffer=v;}}.bind(this));};i.prototype._switchInput=function(k){var m=this.getAggregation("_inputs");if(k>=this._inputCount){k=0;}m[k].focus();this._activeInput=k;};i.prototype._handleHoursChange=function(v){var m=this._getMinutesInput(),s=this._getSecondsInput();if(!this.getSupport2400()){return;}if(v==="24"){if(m&&m.getEnabled()){this._sMinutes=m.getValue();m.setEnabled(false).setValue("00");}if(s&&s.getEnabled()){this._sSeconds=s.getValue();s.setEnabled(false).setValue("00");}this._getHoursInput().focus();return true;}else{if(m&&!m.getEnabled()){m.setEnabled(true).setValue(this._sMinutes);}if(s&&!s.getEnabled()){s.setEnabled(true).setValue(this._sSeconds);}this._getHoursInput().focus();return false;}};var C=R.extend(a);C.apiVersion=2;C.writeInnerAttributes=function(r,o){a.writeInnerAttributes.call(this,r,o);r.attr("pattern","[0-9]*");r.attr("inputmode","numeric");};var j=I.extend("sap.m.internal.CustomNumericInput",{renderer:C});return i;});
