/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./WheelSliderRenderer','sap/ui/core/IconPool','sap/ui/Device',"sap/ui/events/KeyCodes","sap/m/Button","sap/ui/thirdparty/jquery"],function(C,W,I,D,K,B,q){"use strict";var a=C.extend("sap.m.WheelSlider",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"},_arrowUp:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{expanded:{},collapsed:{},selectedKeyChange:{parameters:{newKey:{type:"string"}}}}},renderer:W});var S=sap.ui.getCore().getConfiguration().getAnimation()?200:0;var L=32;var A=32;var M=1.0;a.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._bEnabled=true;if(D.system.desktop){this._fnHandleTypeValues=t.call(this);}this._onTouchStart=q.proxy(o,this);this._onTouchMove=q.proxy(c,this);this._onTouchEnd=q.proxy(d,this);this._onMouseWheel=this._onMouseWheel.bind(this);this._initArrows();};a.prototype.exit=function(){var s=this._getSliderContainerDomRef();if(s){s.stop();}this._stopAnimation();if(s[0]){this._detachEvents();}};a.prototype.onBeforeRendering=function(){if(this._getSliderContainerDomRef()[0]){this._detachEvents();}};a.prototype.onAfterRendering=function(){if(this._marginTop){this._previousMarginTop=this._marginTop;}if(this._marginBottom){this._previousMarginBottom=this._marginBottom;}if(this.getItems().length){this._updateDynamicLayout(this.getIsExpanded());}this._attachEvents();};a.prototype.onThemeChanged=function(e){this.invalidate();};a.prototype._handleTap=function(e){var s,i,g;if(!this.getIsExpanded()){if(D.system.desktop){this.focus();}else{this.setIsExpanded(true);}}else{s=e.srcElement||e.originalTarget;if(s&&s.tagName.toLowerCase()==="li"){i=q(s).text();g=F.call(this,i);this._iClickedIndex=Array.prototype.slice.call(s.parentElement.children).indexOf(s);this._bOneTimeValueSelectionAnimation=true;this.setSelectedKey(g);this.fireSelectedKeyChange({newKey:g});}else{this._addSelectionStyle();this.focus();}}};a.prototype.setSelectedKey=function(v,r){var s=r!==undefined?!r:true,i=b(this.getItems(),function(E){return E.getKey()===v;}),i,$,e;this.setProperty("selectedKey",v,s);if(!s||i===-1){return this;}i-=this.iMinIndex;if(this.getDomRef()){$=this._getSliderContainerDomRef();e=this._getItemHeightInPx();if(this._bOneTimeValueSelectionAnimation){$.scrollTop((i-this._iClickedIndex+this._iSelectedItemIndex)*e-this._selectionOffset);this._animatingSnap=true;$.animate({scrollTop:i*e-this._selectionOffset},S,'linear',function(){$.clearQueue();this._animatingSnap=false;this._bOneTimeValueSelectionAnimation=false;}.bind(this));}else{$.scrollTop(i*e-this._selectionOffset);}this._removeSelectionStyle();this._iSelectedItemIndex=i;this._addSelectionStyle();}return this;};a.prototype.setIsExpanded=function(v,s){this.setProperty("isExpanded",v,true);if(!this.getDomRef()){return this;}var T=this.$();if(v){T.addClass("sapMWSExpanded");this._updateDynamicLayout(true);if(!s){this.fireExpanded({ctrl:this});}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null&&this._animatingTargetIndex!==undefined){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}T.removeClass("sapMWSExpanded");this._updateDynamicLayout(false);if(!s){this.fireCollapsed({ctrl:this});}}return this;};a.prototype.onfocusin=function(e){if(D.system.desktop&&!this.getIsExpanded()){this.setIsExpanded(true);}};a.prototype.onfocusout=function(e){var s=e.relatedTarget?e.relatedTarget.id:null,g=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(s&&g.indexOf(s)!==-1){return;}if(D.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false);}};a.prototype._onMouseWheel=function(e){var O,g,w;e.preventDefault();e.stopPropagation();if(!this.getIsExpanded()){return false;}O=e.originalEvent;g=O.detail?(-O.detail>0):(O.wheelDelta>0);w=O.detail?(-O.detail/3):(O.wheelDelta/120);if(!w){return false;}this._handleWheelScroll(g,w);};a.prototype._handleWheelScroll=function(e,w){var r=e?Math.ceil:Math.floor,R;if(!this._aWheelDeltas){this._aWheelDeltas=[];}this._aWheelDeltas.push(w);if(!this._bWheelScrolling){this._bWheelScrolling=true;this._stopAnimation();this._animating=true;this._intervalId=setInterval(function(){if(!this._aWheelDeltas.length){this._stopAnimation();this._bWheelScrolling=false;}else{R=this._aWheelDeltas[0];this._aWheelDeltas=[];R=r(R);if(R){this._offsetValue(R);}}}.bind(this),150);}return false;};a.prototype.onsappageup=function(e){if(this.getIsExpanded()){var i=this.getItems()[0],k=i.getKey();this.setSelectedKey(k,true);this.fireSelectedKeyChange({newKey:k});}};a.prototype.onsappagedown=function(e){if(this.getIsExpanded()){var l=this.getItems()[this.getItems().length-1],k=l.getKey();this.setSelectedKey(k,true);this.fireSelectedKeyChange({newKey:k});}};a.prototype.onsapup=function(e){if(this.getIsExpanded()){this._offsetAnimateValue(-1);}};a.prototype.onsapdown=function(e){if(this.getIsExpanded()){this._offsetAnimateValue(1);}};a.prototype.onkeydown=function(e){var k=e.which||e.keyCode,g=K;if(k>=g.NUMPAD_0&&k<=g.NUMPAD_9){k=this._convertNumPadToNumKeyCode(k);}if((k>=g.A&&k<=g.Z)||(k>=g.DIGIT_0&&k<=g.DIGIT_9)){this._fnHandleTypeValues(e.timeStamp,k);}};a.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMWSInner");};a.prototype._getItemHeightInPx=function(){return this.$("content").find("li")[0].getBoundingClientRect().height;};a.prototype._updateSelectionFrameLayout=function(){var $,i,e,g,s=this.$().offset(),h=s?s.top:0,j=this.$().parents(".sapMWSContainer").offset(),k=j?j.top:0;if(this.getDomRef()){g=this._getItemHeightInPx();$=this.$().find(".sapMWSSelectionFrame");e=h-k;i=(this.$().height()-g+L)/2+e;$.css("top",i);}};a.prototype._updateConstrainedMargins=function(i){var e=this._getItemHeightInPx(),$,v,V,g,h,j,m,k;if(this.getDomRef()){e=this._getItemHeightInPx();$=this.$().find(".SliderValues3,.SliderValues4,.SliderValues5,.SliderValues6,.SliderValues7,.SliderValues8,.SliderValues9,.SliderValues10,.SliderValues11,.SliderValues12");if(!$.length){return;}if(i){v=this.getItems().length;V=e*Math.floor(v/2);g=e*Math.ceil(v/2);j=this.$().parents().hasClass('sapUiSizeCompact')?A:0;h=(this.$().height()-e+L)/2;m=h-V-L-j;k=this.$().height()-h-g-j;m=Math.max(m,0);k=Math.max(k,0);}else{m=0;k=0;}$.css("margin-top",m);$.css("margin-bottom",k);}};a.prototype._updateDynamicLayout=function(i){if(this.getDomRef()){this._updateConstrainedMargins(i);if(i){this._updateSelectionFrameLayout();}this._updateMargins();this._updateSelectionOffset();this._reselectCurrentItem();this.$().attr('aria-expanded',i);}};a.prototype._getSelectionFrameTopOffset=function(){var $=this._getSliderContainerDomRef().find(".sapMWSSelectionFrame"),e=$.offset();return e.top;};a.prototype._animateScroll=function(s){var $=this._getSliderContainerDomRef(),p=$.scrollTop(),e=25,g=this.getIsCyclic(),h=0.9,i=0.05;this._animating=true;this._intervalId=setInterval(function(){p=p-s*e;if(!g){if(p>this._maxScrollTop){p=this._maxScrollTop;s=0;}if(p<this._minScrollTop){p=this._minScrollTop;s=0;}}$.scrollTop(p);s*=h;if(Math.abs(s)<i){this._stopAnimation();var j=this._getItemHeightInPx();var O=this._selectionOffset?(this._selectionOffset%j):0;var k=Math.round((p+O)/j)*j-O;this._iSelectedIndex=Math.round((p+this._selectionOffset)/j);if(this._animatingSnap){return;}this._animatingSnap=true;$.animate({scrollTop:k},S,'linear',function(){$.clearQueue();this._animatingSnap=false;if($.css("visibility")==="visible"&&!this._animating){this._scrollerSnapped(this._iSelectedIndex);}}.bind(this));}}.bind(this),e);};a.prototype.getSelectedItemIndex=function(){var s=this.getSelectedKey();if(!s){return 0;}return b(this.getItems(),function(e){return e.getKey()===s;});};a.prototype._reselectCurrentItem=function(){var s=this.getSelectedItemIndex(),e;if(s===-1){return;}e=this.getItems()[s].getKey();this.setSelectedKey(e);};a.prototype._updateSelectionOffset=function(){var s=this._getSelectionFrameTopOffset(),$=this._getSliderContainerDomRef(),e=$.offset();if(this.getIsCyclic()&&this.getIsExpanded()){this._selectionOffset=s-e.top;}else{this._selectionOffset=0;}};a.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}};a.prototype._startDrag=function(p){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[];}this._dragSession.pageY=p;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop();};a.prototype._doDrag=function(p,T){if(this._dragSession){this._dragSession.offsetY=p-this._dragSession.pageY;this._dragSession.positions.push({pageY:p,timeStamp:T});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10);}if(this._bIsDrag){this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY);}}};a.prototype._endDrag=function(p,T){if(this._dragSession){var O,e;for(var i=this._dragSession.positions.length-1;i>=0;i--){O=T-this._dragSession.positions[i].timeStamp;e=p-this._dragSession.positions[i].pageY;if(O>100){break;}}var s=(e/O);this._stopAnimation();this._dragSession=null;s=Math.min(s,M);s=Math.max(s,-M);this._animateScroll(s);}};a.prototype._updateMargins=function(){var s=this._getSelectionFrameTopOffset(),$=this._getSliderContainerDomRef(),e=$.offset(),i,l,g,h;if(!this.getIsCyclic()){l=this.$("content");h=this._getItemHeightInPx();g=this.$().height();if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=s-e.top;this._maxScrollTop=h*(this.getItems().length-1);i=$.height();this._marginBottom=i-this._marginTop-h;if(this._marginBottom<0){this._marginBottom=g-this._marginTop-h;}}else{this._marginTop=0;this._marginBottom=g-h;}if(this._previousMarginTop!==this._marginTop){l.css("margin-top",this._marginTop);this._previousMarginTop=this._marginTop;}if(this._previousMarginBottom!==this._marginBottom){l.css("margin-bottom",this._marginBottom);this._previousMarginBottom=this._marginBottom;}}};a.prototype._scrollerSnapped=function(i){var s=i,e=this.getItems().length,n;if(!this.getIsCyclic()){s=i;}var g=s+this.iMinIndex;if(this.getIsCyclic()){while(g<0){g=g+e;}while(g>=e){g=g-e;}}else{g=Math.min(e-1,g);}n=this.getItems()[g].getKey();var r=this.getIsCyclic()||(this.iPreviousMiddle>g&&this.iMinIndex>0)||(this.iPreviousMiddle<g&&this.iMaxIndex<e-1);this.setSelectedKey(n,r);this.fireSelectedKeyChange({newKey:n});};a.prototype._addSelectionStyle=function(){var $=this.$("content").find("li"),s=$.eq(this._iSelectedItemIndex).text(),e,g;if(!s){return;}g=s;if(g&&g.length>1&&g.indexOf('0')===0){g=g.substring(1);}$.eq(this._iSelectedItemIndex).addClass("sapMWSItemSelected");e=this.getDomRef("valDescription");if(e.innerText!==g){e.innerText=g;}};a.prototype._removeSelectionStyle=function(){var $=this.$("content").find("li");$.eq(this._iSelectedItemIndex).removeClass("sapMWSItemSelected");};a.prototype._attachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(D.system.combi){e.addEventListener("touchstart",this._onTouchStart,false);e.addEventListener("touchmove",this._onTouchMove,false);document.addEventListener("touchend",this._onTouchEnd,false);e.addEventListener("mousedown",this._onTouchStart,false);document.addEventListener("mousemove",this._onTouchMove,false);document.addEventListener("mouseup",this._onTouchEnd,false);}else{if(D.system.phone||D.system.tablet){e.addEventListener("touchstart",this._onTouchStart,false);e.addEventListener("touchmove",this._onTouchMove,false);document.addEventListener("touchend",this._onTouchEnd,false);}else{e.addEventListener("mousedown",this._onTouchStart,false);document.addEventListener("mousemove",this._onTouchMove,false);document.addEventListener("mouseup",this._onTouchEnd,false);}}this.$().on('selectstart',f);this.$().on(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onMouseWheel);};function f(){return false;}a.prototype._detachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(D.system.combi){e.removeEventListener("touchstart",this._onTouchStart,false);e.removeEventListener("touchmove",this._onTouchMove,false);document.removeEventListener("touchend",this._onTouchEnd,false);e.removeEventListener("mousedown",this._onTouchStart,false);document.removeEventListener("mousemove",this._onTouchMove,false);document.removeEventListener("mouseup",this._onTouchEnd,false);}else{if(D.system.phone||D.system.tablet){e.removeEventListener("touchstart",this._onTouchStart,false);e.removeEventListener("touchmove",this._onTouchMove,false);document.removeEventListener("touchend",this._onTouchEnd,false);}else{e.removeEventListener("mousedown",this._onTouchStart,false);document.removeEventListener("mousemove",this._onTouchMove,false);document.removeEventListener("mouseup",this._onTouchEnd,false);}}this.$().off('selectstart',f);this.$().off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onMouseWheel);};a.prototype._offsetAnimateValue=function(i){var s=this._getSliderContainerDomRef(),e,g=this._getItemHeightInPx(),h,j,k=this.getIsCyclic();this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null&&this._animatingTargetIndex!==undefined){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}j=this._iSelectedItemIndex+i;e=s.scrollTop();h=e+i*g;if(!k){if(j<0||j>=this.getItems().length){return;}if(h>this._maxScrollTop){h=this._maxScrollTop;}if(h<this._minScrollTop){h=this._minScrollTop;}}this._animatingSnap=true;this._animatingTargetIndex=j;s.animate({scrollTop:h},S,'linear',function(){s.clearQueue();this._animatingSnap=false;this._animatingTargetIndex=null;if(s.css("visibility")==="visible"){this._scrollerSnapped(j);}}.bind(this));};a.prototype._offsetValue=function(O){var s=this._getSliderContainerDomRef().scrollTop(),e=this.getIsCyclic(),i=this._getItemHeightInPx();s=s-O*i;if(!e){if(s>this._maxScrollTop){s=this._maxScrollTop;}if(s<this._minScrollTop){s=this._minScrollTop;}}this._getSliderContainerDomRef().scrollTop(s);this._iSelectedIndex=Math.round((s+this._selectionOffset)/i);this._scrollerSnapped(this._iSelectedIndex);};a.prototype._initArrows=function(){var e,g;e=new B({icon:I.getIconURI("slim-arrow-up"),press:function(E){this._offsetAnimateValue(-1);}.bind(this),type:'Transparent'});e.addEventDelegate({onAfterRendering:function(){e.$().attr("tabindex",-1);}});this.setAggregation("_arrowUp",e);g=new B({icon:I.getIconURI("slim-arrow-down"),press:function(E){this._offsetAnimateValue(1);}.bind(this),type:'Transparent'});g.addEventDelegate({onAfterRendering:function(){g.$().attr("tabindex",-1);}});this.setAggregation("_arrowDown",g);};a.prototype._convertNumPadToNumKeyCode=function(k){var e=K;if(k>=e.NUMPAD_0&&k<=e.NUMPAD_9){k-=48;}return k;};function b(e,p){if(e==null){throw new TypeError('findIndex called with null or undefined array');}if(typeof p!=='function'){throw new TypeError('predicate must be a function');}var l=e.length;var T=arguments[1];var v;for(var i=0;i<l;i++){v=e[i];if(p.call(T,v,i,e)){return i;}}return-1;}var o=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._stopAnimation();this._startDrag(p);if(!D.system.desktop){e.preventDefault();}this._mousedown=true;};var c=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var g=this._dragSession.positions.some(function(h){return Math.abs(h.pageY-p)>5;});if(g){this._bIsDrag=true;}}this._doDrag(p,e.timeStamp);this._mousedown=true;};var d=function(e){var p=e.changedTouches&&e.changedTouches.length?e.changedTouches[0].pageY:e.pageY;if(this._bIsDrag===false){this._handleTap(e);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(p,e.timeStamp);this._mousedown=false;};var F=function(T){var i=this.getItems();var e=b(i,function(g){return g.getText()===T;});return i[e].getKey();};var t=function(){var l=-1,i=-1,w=1000,s="",T=function(e,k){var m;if(l+w<e){s="";}else{if(i!==-1){clearTimeout(i);i=-1;}}s+=String.fromCharCode(k).toLowerCase();m=this.getItems().filter(function(g){return g.getText().indexOf(s)===0;});if(m.length>1){i=setTimeout(function(){this.setSelectedKey(m[0].getKey(),true);s="";i=-1;}.bind(this),w);}else if(m.length===1){this.setSelectedKey(m[0].getKey(),true);s="";}else{s="";}l=e;};return T;};return a;});
