/**
 * Distributed under the BSD license:
 *
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modifications SAP SE or an SAP affiliate company and OpenUI5 contributors. All rights reserved.
 */
(function(){var A="ace";var g=(function(){return this;})();if(!g&&typeof window!="undefined")g=window;if(!A&&typeof requirejs!=="undefined")return;var d=function(m,b,p){if(typeof m!=="string"){if(d.original)d.original.apply(this,arguments);else{console.error("dropping module because define wasn\'t a string.");console.trace();}return;}if(arguments.length==2)p=b;if(!d.modules[m]){d.payloads[m]=p;d.modules[m]=null;}};d.modules={};d.payloads={};var _=function(p,m,c){if(typeof m==="string"){var b=a(p,m);if(b!=undefined){c&&c();return b;}}else if(Object.prototype.toString.call(m)==="[object Array]"){var f=[];for(var i=0,l=m.length;i<l;++i){var h=a(p,m[i]);if(h==undefined&&r.original)return;f.push(h);}return c&&c.apply(null,f)||true;}};var r=function(m,c){var p=_("",m,c);if(p==undefined&&r.original)return r.original.apply(this,arguments);return p;};var n=function(p,m){if(m.indexOf("!")!==-1){var c=m.split("!");return n(p,c[0])+"!"+n(p,c[1]);}if(m.charAt(0)=="."){var b=p.split("/").slice(0,-1).join("/");m=b+"/"+m;while(m.indexOf(".")!==-1&&f!=m){var f=m;m=m.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"");}}return m;};var a=function(p,m){m=n(p,m);var b=d.modules[m];if(!b){b=d.payloads[m];if(typeof b==='function'){var c={};var f={id:m,uri:'',exports:c,packaged:true};var h=function(b,j){return _(m,b,j);};var i=b(h,c,f);c=i||f.exports;d.modules[m]=c;delete d.payloads[m];}b=d.modules[m]=c||b;}return b;};function e(b){var c=g;if(b){if(!g[b])g[b]={};c=g[b];}if(!c.define||!c.define.packaged){d.original=c.define;c.define=d;c.define.packaged=true;}if(!c.require||!c.require.packaged){r.original=c.require;c.require=r;c.require.packaged=true;}}e(A);})();ace.define("ace/lib/fixoldbrowsers",[],function(r,e,m){"use strict";if(typeof Element!="undefined"&&!Element.prototype.remove){Object.defineProperty(Element.prototype,"remove",{enumerable:false,writable:true,configurable:true,value:function(){this.parentNode&&this.parentNode.removeChild(this);}});}});ace.define("ace/lib/useragent",[],function(r,e,m){"use strict";e.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"};e.getOS=function(){if(e.isMac){return e.OS.MAC;}else if(e.isLinux){return e.OS.LINUX;}else{return e.OS.WINDOWS;}};var _=typeof navigator=="object"?navigator:{};var o=(/mac|win|linux/i.exec(_.platform)||["other"])[0].toLowerCase();var u=_.userAgent||"";var a=_.appName||"";e.isWin=(o=="win");e.isMac=(o=="mac");e.isLinux=(o=="linux");e.isIE=(a=="Microsoft Internet Explorer"||a.indexOf("MSAppHost")>=0)?parseFloat((u.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((u.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]);e.isOldIE=e.isIE&&e.isIE<9;e.isGecko=e.isMozilla=u.match(/ Gecko\/\d+/);e.isOpera=typeof opera=="object"&&Object.prototype.toString.call(window.opera)=="[object Opera]";e.isWebKit=parseFloat(u.split("WebKit/")[1])||undefined;e.isChrome=parseFloat(u.split(" Chrome/")[1])||undefined;e.isEdge=parseFloat(u.split(" Edge/")[1])||undefined;e.isAIR=u.indexOf("AdobeAIR")>=0;e.isAndroid=u.indexOf("Android")>=0;e.isChromeOS=u.indexOf(" CrOS ")>=0;e.isIOS=/iPad|iPhone|iPod/.test(u)&&!window.MSStream;if(e.isIOS)e.isMac=true;e.isMobile=e.isIOS||e.isAndroid;});ace.define("ace/lib/dom",[],function(r,e,m){"use strict";var u=r("./useragent");var X="http://www.w3.org/1999/xhtml";e.buildDom=function q(f,p,g){if(typeof f=="string"&&f){var t=document.createTextNode(f);if(p)p.appendChild(t);return t;}if(!Array.isArray(f)){if(f&&f.appendChild&&p)p.appendChild(f);return f;}if(typeof f[0]!="string"||!f[0]){var h=[];for(var i=0;i<f.length;i++){var j=q(f[i],p,g);j&&h.push(j);}return h;}var k=document.createElement(f[0]);var o=f[1];var l=1;if(o&&typeof o=="object"&&!Array.isArray(o))l=2;for(var i=l;i<f.length;i++)q(f[i],k,g);if(l==2){Object.keys(o).forEach(function(n){var v=o[n];if(n==="class"){k.className=Array.isArray(v)?v.join(" "):v;}else if(typeof v=="function"||n=="value"||n[0]=="$"){k[n]=v;}else if(n==="ref"){if(g)g[v]=k;}else if(n==="style"){if(typeof v=="string")k.style.cssText=v;}else if(v!=null){k.setAttribute(n,v);}});}if(p)p.appendChild(k);return k;};e.getDocumentHead=function(f){if(!f)f=document;return f.head||f.getElementsByTagName("head")[0]||f.documentElement;};e.createElement=function(t,n){return document.createElementNS?document.createElementNS(n||X,t):document.createElement(t);};e.removeChildren=function(f){f.innerHTML="";};e.createTextNode=function(t,f){var g=f?f.ownerDocument:document;return g.createTextNode(t);};e.createFragment=function(f){var g=f?f.ownerDocument:document;return g.createDocumentFragment();};e.hasCssClass=function(f,n){var g=(f.className+"").split(/\s+/g);return g.indexOf(n)!==-1;};e.addCssClass=function(f,n){if(!e.hasCssClass(f,n)){f.className+=" "+n;}};e.removeCssClass=function(f,n){var g=f.className.split(/\s+/g);while(true){var i=g.indexOf(n);if(i==-1){break;}g.splice(i,1);}f.className=g.join(" ");};e.toggleCssClass=function(f,n){var g=f.className.split(/\s+/g),h=true;while(true){var i=g.indexOf(n);if(i==-1){break;}h=false;g.splice(i,1);}if(h)g.push(n);f.className=g.join(" ");return h;};e.setCssClass=function(n,f,i){if(i){e.addCssClass(n,f);}else{e.removeCssClass(n,f);}};e.hasCssString=function(i,f){var g=0,h;f=f||document;if((h=f.querySelectorAll("style"))){while(g<h.length)if(h[g++].id===i)return true;}};var s;var c=[];e.useStrictCSP=function(v){s=v;if(v==false)a();else if(!c)c=[];};function a(){var f=c;c=null;f&&f.forEach(function(i){b(i[0],i[1]);});}function b(f,i,t){if(typeof document=="undefined")return;if(c){if(t){a();}else if(t===false){return c.push([f,i]);}}if(s)return;throw new Error("The method importCssString can not be used without strictCSP due to CSP inline styles violations");}e.importCssString=b;e.importCssStylsheet=function(f,g){e.buildDom(["link",{rel:"stylesheet",href:f}],e.getDocumentHead(g));};e.scrollbarWidth=function(f){var i=e.createElement("ace_inner");i.style.width="100%";i.style.minWidth="0px";i.style.height="200px";i.style.display="block";var o=e.createElement("ace_outer");var g=o.style;g.position="absolute";g.left="-10000px";g.overflow="hidden";g.width="200px";g.minWidth="0px";g.height="150px";g.display="block";o.appendChild(i);var h=f.documentElement;h.appendChild(o);var n=i.offsetWidth;g.overflow="scroll";var w=i.offsetWidth;if(n==w){w=o.clientWidth;}h.removeChild(o);return n-w;};e.computedStyle=function(f,g){return window.getComputedStyle(f,"")||{};};e.setStyle=function(f,p,v){if(f[p]!==v){f[p]=v;}};e.HAS_CSS_ANIMATION=false;e.HAS_CSS_TRANSFORMS=false;e.HI_DPI=u.isWin?typeof window!=="undefined"&&window.devicePixelRatio>=1.5:true;if(u.isChromeOS)e.HI_DPI=false;if(typeof document!=="undefined"){var d=document.createElement("div");if(e.HI_DPI&&d.style.transform!==undefined)e.HAS_CSS_TRANSFORMS=true;if(!u.isEdge&&typeof d.style.animationName!=="undefined")e.HAS_CSS_ANIMATION=true;d=null;}if(e.HAS_CSS_TRANSFORMS){e.translate=function(f,t,g){f.style.transform="translate("+Math.round(t)+"px, "+Math.round(g)+"px)";};}else{e.translate=function(f,t,g){f.style.top=Math.round(g)+"px";f.style.left=Math.round(t)+"px";};}});ace.define("ace/lib/oop",[],function(r,e,m){"use strict";e.inherits=function(c,s){c.super_=s;c.prototype=Object.create(s.prototype,{constructor:{value:c,enumerable:false,writable:true,configurable:true}});};e.mixin=function(o,a){for(var k in a){o[k]=a[k];}return o;};e.implement=function(p,a){e.mixin(p,a);};});ace.define("ace/lib/keys",[],function(r,e,m){"use strict";var o=r("./oop");var K=(function(){var a={MODIFIER_KEYS:{16:'Shift',17:'Ctrl',18:'Alt',224:'Meta',91:'MetaLeft',92:'MetaRight',93:'ContextMenu'},KEY_MODS:{"ctrl":1,"alt":2,"option":2,"shift":4,"super":8,"meta":8,"command":8,"cmd":8,"control":1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9",'-13':"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:' ',48:'0',49:'1',50:'2',51:'3',52:'4',53:'5',54:'6',55:'7',56:'8',57:'9',59:';',61:'=',65:'a',66:'b',67:'c',68:'d',69:'e',70:'f',71:'g',72:'h',73:'i',74:'j',75:'k',76:'l',77:'m',78:'n',79:'o',80:'p',81:'q',82:'r',83:'s',84:'t',85:'u',86:'v',87:'w',88:'x',89:'y',90:'z',107:'+',109:'-',110:'.',186:';',187:'=',188:',',189:'-',190:'.',191:'/',192:'`',219:'[',220:'\\',221:']',222:"'",111:'/',106:'*'}};var n,i;for(i in a.FUNCTION_KEYS){n=a.FUNCTION_KEYS[i].toLowerCase();a[n]=parseInt(i,10);}for(i in a.PRINTABLE_KEYS){n=a.PRINTABLE_KEYS[i].toLowerCase();a[n]=parseInt(i,10);}o.mixin(a,a.MODIFIER_KEYS);o.mixin(a,a.PRINTABLE_KEYS);o.mixin(a,a.FUNCTION_KEYS);a.enter=a["return"];a.escape=a.esc;a.del=a["delete"];a[173]='-';(function(){var b=["cmd","ctrl","alt","shift"];for(var i=Math.pow(2,b.length);i--;){a.KEY_MODS[i]=b.filter(function(x){return i&a.KEY_MODS[x];}).join("-")+"-";}})();a.KEY_MODS[0]="";a.KEY_MODS[-1]="input-";return a;})();o.mixin(e,K);e.keyCodeToString=function(k){var a=K[k];if(typeof a!="string")a=String.fromCharCode(k);return a.toLowerCase();};});ace.define("ace/lib/event",[],function(r,a,m){"use strict";var k=r("./keys");var u=r("./useragent");var p=null;var t=0;var b;function d(){b=false;try{document.createComment("").addEventListener("test",function(){},{get passive(){b={passive:false};}});}catch(e){}}function g(){if(b==undefined)d();return b;}function E(e,l,o){this.elem=e;this.type=l;this.callback=o;}E.prototype.destroy=function(){f(this.elem,this.type,this.callback);this.elem=this.type=this.callback=undefined;};var c=a.addListener=function(e,l,o,q){e.addEventListener(l,o,g());if(q)q.$toDestroy.push(new E(e,l,o));};var f=a.removeListener=function(e,l,o){e.removeEventListener(l,o,g());};a.stopEvent=function(e){a.stopPropagation(e);a.preventDefault(e);return false;};a.stopPropagation=function(e){if(e.stopPropagation)e.stopPropagation();};a.preventDefault=function(e){if(e.preventDefault)e.preventDefault();};a.getButton=function(e){if(e.type=="dblclick")return 0;if(e.type=="contextmenu"||(u.isMac&&(e.ctrlKey&&!e.altKey&&!e.shiftKey)))return 2;return e.button;};a.capture=function(l,o,q){var s=l&&l.ownerDocument||document;function v(e){o&&o(e);q&&q(e);f(s,"mousemove",o);f(s,"mouseup",v);f(s,"dragstart",v);}c(s,"mousemove",o);c(s,"mouseup",v);c(s,"dragstart",v);return v;};a.addMouseWheelListener=function(l,o,q){if("onmousewheel"in l){c(l,"mousewheel",function(e){var s=8;if(e.wheelDeltaX!==undefined){e.wheelX=-e.wheelDeltaX/s;e.wheelY=-e.wheelDeltaY/s;}else{e.wheelX=0;e.wheelY=-e.wheelDelta/s;}o(e);},q);}else if("onwheel"in l){c(l,"wheel",function(e){var s=0.35;switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=e.deltaX*s||0;e.wheelY=e.deltaY*s||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=(e.deltaX||0)*5;e.wheelY=(e.deltaY||0)*5;break;}o(e);},q);}else{c(l,"DOMMouseScroll",function(e){if(e.axis&&e.axis==e.HORIZONTAL_AXIS){e.wheelX=(e.detail||0)*5;e.wheelY=0;}else{e.wheelX=0;e.wheelY=(e.detail||0)*5;}o(e);},q);}};a.addMultiMouseDownListener=function(l,o,q,s,v){var w=0;var x,y,z;var A={2:"dblclick",3:"tripleclick",4:"quadclick"};function B(e){if(a.getButton(e)!==0){w=0;}else if(e.detail>1){w++;if(w>4)w=1;}else{w=1;}if(u.isIE){var C=Math.abs(e.clientX-x)>5||Math.abs(e.clientY-y)>5;if(!z||C)w=1;if(z)clearTimeout(z);z=setTimeout(function(){z=null;},o[w-1]||600);if(w==1){x=e.clientX;y=e.clientY;}}e._clicks=w;q[s]("mousedown",e);if(w>4)w=0;else if(w>1)return q[s](A[w],e);}if(!Array.isArray(l))l=[l];l.forEach(function(e){c(e,"mousedown",B,v);});};var h=function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0);};a.getModifierString=function(e){return k.KEY_MODS[h(e)];};function n(l,e,o){var q=h(e);if(!u.isMac&&p){if(e.getModifierState&&(e.getModifierState("OS")||e.getModifierState("Win")))q|=8;if(p.altGr){if((3&q)!=3)p.altGr=0;else return;}if(o===18||o===17){var s="location"in e?e.location:e.keyLocation;if(o===17&&s===1){if(p[o]==1)t=e.timeStamp;}else if(o===18&&q===3&&s===2){var v=e.timeStamp-t;if(v<50)p.altGr=true;}}}if(o in k.MODIFIER_KEYS){o=-1;}if(!q&&o===13){var s="location"in e?e.location:e.keyLocation;if(s===3){l(e,q,-o);if(e.defaultPrevented)return;}}if(u.isChromeOS&&q&8){l(e,q,o);if(e.defaultPrevented)return;else q&=~8;}if(!q&&!(o in k.FUNCTION_KEYS)&&!(o in k.PRINTABLE_KEYS)){return false;}return l(e,q,o);}a.addCommandKeyListener=function(l,o,q){if(u.isOldGecko||(u.isOpera&&!("KeyboardEvent"in window))){var s=null;c(l,"keydown",function(e){s=e.keyCode;},q);c(l,"keypress",function(e){return n(o,e,s);},q);}else{var v=null;c(l,"keydown",function(e){p[e.keyCode]=(p[e.keyCode]||0)+1;var w=n(o,e,e.keyCode);v=e.defaultPrevented;return w;},q);c(l,"keypress",function(e){if(v&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)){a.stopEvent(e);v=null;}},q);c(l,"keyup",function(e){p[e.keyCode]=null;},q);if(!p){i();c(window,"focus",i);}}};function i(){p=Object.create(null);}if(typeof window=="object"&&window.postMessage&&!u.isOldIE){var j=1;a.nextTick=function(l,w){w=w||window;var o="zero-timeout-message-"+(j++);var q=function(e){if(e.data==o){a.stopPropagation(e);f(w,"message",q);l();}};c(w,"message",q);w.postMessage(o,"*");};}a.$idleBlocked=false;a.onIdle=function(e,l){return setTimeout(function o(){if(!a.$idleBlocked){e();}else{setTimeout(o,100);}},l);};a.$idleBlockId=null;a.blockIdle=function(e){if(a.$idleBlockId)clearTimeout(a.$idleBlockId);a.$idleBlocked=true;a.$idleBlockId=setTimeout(function(){a.$idleBlocked=false;},e||100);};a.nextFrame=typeof window=="object"&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame);if(a.nextFrame)a.nextFrame=a.nextFrame.bind(window);else a.nextFrame=function(e){setTimeout(e,17);};});ace.define("ace/range",[],function(r,e,m){"use strict";var c=function(p,a){return p.row-a.row||p.column-a.column;};var R=function(s,a,b,d){this.start={row:s,column:a};this.end={row:b,column:d};};(function(){this.isEqual=function(a){return this.start.row===a.start.row&&this.end.row===a.end.row&&this.start.column===a.start.column&&this.end.column===a.end.column;};this.toString=function(){return("Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]");};this.contains=function(a,b){return this.compare(a,b)==0;};this.compareRange=function(a){var b,d=a.end,s=a.start;b=this.compare(d.row,d.column);if(b==1){b=this.compare(s.row,s.column);if(b==1){return 2;}else if(b==0){return 1;}else{return 0;}}else if(b==-1){return-2;}else{b=this.compare(s.row,s.column);if(b==-1){return-1;}else if(b==1){return 42;}else{return 0;}}};this.comparePoint=function(p){return this.compare(p.row,p.column);};this.containsRange=function(a){return this.comparePoint(a.start)==0&&this.comparePoint(a.end)==0;};this.intersects=function(a){var b=this.compareRange(a);return(b==-1||b==0||b==1);};this.isEnd=function(a,b){return this.end.row==a&&this.end.column==b;};this.isStart=function(a,b){return this.start.row==a&&this.start.column==b;};this.setStart=function(a,b){if(typeof a=="object"){this.start.column=a.column;this.start.row=a.row;}else{this.start.row=a;this.start.column=b;}};this.setEnd=function(a,b){if(typeof a=="object"){this.end.column=a.column;this.end.row=a.row;}else{this.end.row=a;this.end.column=b;}};this.inside=function(a,b){if(this.compare(a,b)==0){if(this.isEnd(a,b)||this.isStart(a,b)){return false;}else{return true;}}return false;};this.insideStart=function(a,b){if(this.compare(a,b)==0){if(this.isEnd(a,b)){return false;}else{return true;}}return false;};this.insideEnd=function(a,b){if(this.compare(a,b)==0){if(this.isStart(a,b)){return false;}else{return true;}}return false;};this.compare=function(a,b){if(!this.isMultiLine()){if(a===this.start.row){return b<this.start.column?-1:(b>this.end.column?1:0);}}if(a<this.start.row)return-1;if(a>this.end.row)return 1;if(this.start.row===a)return b>=this.start.column?0:-1;if(this.end.row===a)return b<=this.end.column?0:1;return 0;};this.compareStart=function(a,b){if(this.start.row==a&&this.start.column==b){return-1;}else{return this.compare(a,b);}};this.compareEnd=function(a,b){if(this.end.row==a&&this.end.column==b){return 1;}else{return this.compare(a,b);}};this.compareInside=function(a,b){if(this.end.row==a&&this.end.column==b){return 1;}else if(this.start.row==a&&this.start.column==b){return-1;}else{return this.compare(a,b);}};this.clipRows=function(f,l){if(this.end.row>l)var a={row:l+1,column:0};else if(this.end.row<f)var a={row:f,column:0};if(this.start.row>l)var s={row:l+1,column:0};else if(this.start.row<f)var s={row:f,column:0};return R.fromPoints(s||this.start,a||this.end);};this.extend=function(a,b){var d=this.compare(a,b);if(d==0)return this;else if(d==-1)var s={row:a,column:b};else var f={row:a,column:b};return R.fromPoints(s||this.start,f||this.end);};this.isEmpty=function(){return(this.start.row===this.end.row&&this.start.column===this.end.column);};this.isMultiLine=function(){return(this.start.row!==this.end.row);};this.clone=function(){return R.fromPoints(this.start,this.end);};this.collapseRows=function(){if(this.end.column==0)return new R(this.start.row,0,Math.max(this.start.row,this.end.row-1),0);else return new R(this.start.row,0,this.end.row,0);};this.toScreenRange=function(s){var a=s.documentToScreenPosition(this.start);var b=s.documentToScreenPosition(this.end);return new R(a.row,a.column,b.row,b.column);};this.moveBy=function(a,b){this.start.row+=a;this.start.column+=b;this.end.row+=a;this.end.column+=b;};}).call(R.prototype);R.fromPoints=function(s,a){return new R(s.row,s.column,a.row,a.column);};R.comparePoints=c;R.comparePoints=function(p,a){return p.row-a.row||p.column-a.column;};e.Range=R;});ace.define("ace/lib/lang",[],function(r,e,m){"use strict";e.last=function(a){return a[a.length-1];};e.stringReverse=function(s){return s.split("").reverse().join("");};e.stringRepeat=function(s,c){var a='';while(c>0){if(c&1)a+=s;if(c>>=1)s+=s;}return a;};var t=/^\s\s*/;var b=/\s\s*$/;e.stringTrimLeft=function(s){return s.replace(t,'');};e.stringTrimRight=function(s){return s.replace(b,'');};e.copyObject=function(o){var c={};for(var k in o){c[k]=o[k];}return c;};e.copyArray=function(a){var c=[];for(var i=0,l=a.length;i<l;i++){if(a[i]&&typeof a[i]=="object")c[i]=this.copyObject(a[i]);else c[i]=a[i];}return c;};e.deepCopy=function d(o){if(typeof o!=="object"||!o)return o;var c;if(Array.isArray(o)){c=[];for(var k=0;k<o.length;k++){c[k]=d(o[k]);}return c;}if(Object.prototype.toString.call(o)!=="[object Object]")return o;c={};for(var k in o)c[k]=d(o[k]);return c;};e.arrayToMap=function(a){var c={};for(var i=0;i<a.length;i++){c[a[i]]=1;}return c;};e.createMap=function(p){var a=Object.create(null);for(var i in p){a[i]=p[i];}return a;};e.arrayRemove=function(a,v){for(var i=0;i<=a.length;i++){if(v===a[i]){a.splice(i,1);}}};e.escapeRegExp=function(s){return s.replace(/([.*+?^${}()|[\]\/\\])/g,'\\$1');};e.escapeHTML=function(s){return(""+s).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;");};e.getMatchOffsets=function(s,a){var c=[];s.replace(a,function(d){c.push({offset:arguments[arguments.length-2],length:d.length});});return c;};e.deferredCall=function(f){var a=null;var c=function(){a=null;f();};var d=function(g){d.cancel();a=setTimeout(c,g||0);return d;};d.schedule=d;d.call=function(){this.cancel();f();return d;};d.cancel=function(){clearTimeout(a);a=null;return d;};d.isPending=function(){return a;};return d;};e.delayedCall=function(f,d){var a=null;var c=function(){a=null;f();};var _=function(g){if(a==null)a=setTimeout(c,g||d);};_.delay=function(g){a&&clearTimeout(a);a=setTimeout(c,g||d);};_.schedule=_;_.call=function(){this.cancel();f();};_.cancel=function(){a&&clearTimeout(a);a=null;};_.isPending=function(){return a;};return _;};});ace.define("ace/clipboard",[],function(r,e,m){"use strict";var $;m.exports={lineMode:false,pasteCancelled:function(){if($&&$>Date.now()-50)return true;return $=false;},cancel:function(){$=Date.now();}};});ace.define("ace/keyboard/textinput",[],function(r,a,m){"use strict";var b=r("../lib/event");var u=r("../lib/useragent");var d=r("../lib/dom");var l=r("../lib/lang");var c=r("../clipboard");var B=u.isChrome<18;var U=u.isIE;var H=u.isChrome>63;var M=400;var K=r("../lib/keys");var f=K.KEY_MODS;var g=u.isIOS;var v=g?/\s/:/\n/;var h=u.isMobile;var T=function(j,k){var n=d.createElement("textarea");n.className="ace_text-input";n.setAttribute("wrap","off");n.setAttribute("autocorrect","off");n.setAttribute("autocapitalize","off");n.setAttribute("spellcheck",false);n.style.opacity="0";j.insertBefore(n,j.firstChild);var o=false;var q=false;var s=false;var w=false;var x='';if(!h)n.style.fontSize="1px";var y=false;var z=false;var A="";var C=0;var D=0;var E=0;try{var F=document.activeElement===n;}catch(e){}b.addListener(n,"blur",function(e){if(z)return;k.onBlur(e);F=false;},k);b.addListener(n,"focus",function(e){if(z)return;F=true;if(u.isEdge){try{if(!document.hasFocus())return;}catch(e){}}k.onFocus(e);if(u.isEdge)setTimeout(G);else G();},k);this.$focusScroll=false;this.focus=function(){if(x||H||this.$focusScroll=="browser")return n.focus({preventScroll:true});var i=n.style.top;n.style.position="fixed";n.style.top="0px";try{var f1=n.getBoundingClientRect().top!=0;}catch(e){return;}var g1=[];if(f1){var t=n.parentElement;while(t&&t.nodeType==1){g1.push(t);t.setAttribute("ace_nocontext",true);if(!t.parentElement&&t.getRootNode)t=t.getRootNode().host;else t=t.parentElement;}}n.focus({preventScroll:true});if(f1){g1.forEach(function(p){p.removeAttribute("ace_nocontext");});}setTimeout(function(){n.style.position="";if(n.style.top=="0px")n.style.top=i;},0);};this.blur=function(){n.blur();};this.isFocused=function(){return F;};k.on("beforeEndOperation",function(){var i=k.curOp;var p=i&&i.command&&i.command.name;if(p=="insertstring")return;var t=p&&(i.docChanged||i.selectionChanged);if(s&&t){A=n.value="";Z();}G();});var G=g?function(i){if(!F||(o&&!i)||w)return;if(!i)i="";var p="\n ab"+i+"cde fg\n";if(p!=n.value)n.value=A=p;var t=4;var f1=4+(i.length||(k.selection.isEmpty()?0:1));if(C!=t||D!=f1){n.setSelectionRange(t,f1);}C=t;D=f1;}:function(){if(s||w)return;if(!F&&!N)return;s=true;var i=0;var p=0;var t="";if(k.session){var f1=k.selection;var g1=f1.getRange();var h1=f1.cursor.row;i=g1.start.column;p=g1.end.column;t=k.session.getLine(h1);if(g1.start.row!=h1){var i1=k.session.getLine(h1-1);i=g1.start.row<h1-1?0:i;p+=i1.length+1;t=i1+"\n"+t;}else if(g1.end.row!=h1){var j1=k.session.getLine(h1+1);p=g1.end.row>h1+1?j1.length:p;p+=t.length+1;t=t+"\n"+j1;}else if(h&&h1>0){t="\n"+t;p+=1;i+=1;}if(t.length>M){if(i<M&&p<M){t=t.slice(0,M);}else{t="\n";if(i==p){i=p=0;}else{i=0;p=1;}}}}var k1=t+"\n\n";if(k1!=A){n.value=A=k1;C=D=k1.length;}if(N){C=n.selectionStart;D=n.selectionEnd;}if(D!=p||C!=i||n.selectionEnd!=D){try{n.setSelectionRange(i,p);C=i;D=p;}catch(e){}}s=false;};this.resetSelection=G;if(F)k.onFocus();var I=function(n){return n.selectionStart===0&&n.selectionEnd>=A.length&&n.value===A&&A&&n.selectionEnd!==D;};var J=function(e){if(s)return;if(o){o=false;}else if(I(n)){k.selectAll();G();}else if(h&&n.selectionStart!=C){G();}};var L=null;this.setInputHandler=function(i){L=i;};this.getInputHandler=function(){return L;};var N=false;var O=function(p,t){if(N)N=false;if(q){G();if(p)k.onPaste(p);q=false;return"";}else{var f1=n.selectionStart;var g1=n.selectionEnd;var h1=C;var i1=A.length-D;var j1=p;var k1=p.length-f1;var l1=p.length-g1;var i=0;while(h1>0&&A[i]==p[i]){i++;h1--;}j1=j1.slice(i);i=1;while(i1>0&&A.length-i>C-1&&A[A.length-i]==p[p.length-i]){i++;i1--;}k1-=i-1;l1-=i-1;var m1=j1.length-i+1;if(m1<0){h1=-m1;m1=0;}j1=j1.slice(0,m1);if(!t&&!j1&&!k1&&!h1&&!i1&&!l1)return"";w=true;var n1=false;if(u.isAndroid&&j1==". "){j1="  ";n1=true;}if(j1&&!h1&&!i1&&!k1&&!l1||y){k.onTextInput(j1);}else{k.onTextInput(j1,{extendLeft:h1,extendRight:i1,restoreStart:k1,restoreEnd:l1});}w=false;A=p;C=f1;D=g1;E=l1;return n1?"\n":j1;}};var P=function(e){if(s)return Y();if(e&&e.inputType){if(e.inputType=="historyUndo")return k.execCommand("undo");if(e.inputType=="historyRedo")return k.execCommand("redo");}var i=n.value;var p=O(i,true);if(i.length>M+100||v.test(p)||h&&C<1&&C==D){G();}};var Q=function(e,i,p){var t=e.clipboardData||window.clipboardData;if(!t||B)return;var f1=U||p?"Text":"text/plain";try{if(i){return t.setData(f1,i)!==false;}else{return t.getData(f1);}}catch(e){if(!p)return Q(e,i,true);}};var R=function(e,i){var p=k.getCopyText();if(!p)return b.preventDefault(e);if(Q(e,p)){if(g){G(p);o=p;setTimeout(function(){o=false;},10);}i?k.onCut():k.onCopy();b.preventDefault(e);}else{o=true;n.value=p;n.select();setTimeout(function(){o=false;G();i?k.onCut():k.onCopy();});}};var S=function(e){R(e,true);};var V=function(e){R(e,false);};var W=function(e){var i=Q(e);if(c.pasteCancelled())return;if(typeof i=="string"){if(i)k.onPaste(i,e);if(u.isIE)setTimeout(G);b.preventDefault(e);}else{n.value="";q=true;}};b.addCommandKeyListener(n,k.onCommandKey.bind(k),k);b.addListener(n,"select",J,k);b.addListener(n,"input",P,k);b.addListener(n,"cut",S,k);b.addListener(n,"copy",V,k);b.addListener(n,"paste",W,k);if(!('oncut'in n)||!('oncopy'in n)||!('onpaste'in n)){b.addListener(j,"keydown",function(e){if((u.isMac&&!e.metaKey)||!e.ctrlKey)return;switch(e.keyCode){case 67:V(e);break;case 86:W(e);break;case 88:S(e);break;}},k);}var X=function(e){if(s||!k.onCompositionStart||k.$readOnly)return;s={};if(y)return;if(e.data)s.useTextareaForIME=false;setTimeout(Y,0);k._signal("compositionStart");k.on("mousedown",$);var i=k.getSelectionRange();i.end.row=i.start.row;i.end.column=i.start.column;s.markerRange=i;s.selectionStart=C;k.onCompositionStart(s);if(s.useTextareaForIME){A=n.value="";C=0;D=0;}else{if(n.msGetInputContext)s.context=n.msGetInputContext();if(n.getInputContext)s.context=n.getInputContext();}};var Y=function(){if(!s||!k.onCompositionUpdate||k.$readOnly)return;if(y)return $();if(s.useTextareaForIME){k.onCompositionUpdate(n.value);}else{var i=n.value;O(i);if(s.markerRange){if(s.context){s.markerRange.start.column=s.selectionStart=s.context.compositionStartOffset;}s.markerRange.end.column=s.markerRange.start.column+D-s.selectionStart+E;}}};var Z=function(e){if(!k.onCompositionEnd||k.$readOnly)return;s=false;k.onCompositionEnd();k.off("mousedown",$);if(e)P();};function $(){z=true;n.blur();n.focus();z=false;}var _=l.delayedCall(Y,50).schedule.bind(null,null);function a1(e){if(e.keyCode==27&&n.value.length<n.selectionStart){if(!s)A=n.value;C=D=-1;G();}_();}b.addListener(n,"compositionstart",X,k);b.addListener(n,"compositionupdate",Y,k);b.addListener(n,"keyup",a1,k);b.addListener(n,"keydown",_,k);b.addListener(n,"compositionend",Z,k);this.getElement=function(){return n;};this.setCommandMode=function(i){y=i;n.readOnly=false;};this.setReadOnly=function(i){if(!y)n.readOnly=i;};this.setCopyWithEmptySelection=function(i){};this.onContextMenu=function(e){N=true;G();k._emit("nativecontextmenu",{target:k,domEvent:e});this.moveToMouse(e,true);};this.moveToMouse=function(e,i){if(!x)x=n.style.cssText;n.style.cssText=(i?"z-index:100000;":"")+(u.isIE?"opacity:0.1;":"")+"text-indent: -"+(C+D)*k.renderer.characterWidth*0.5+"px;";var p=k.container.getBoundingClientRect();var t=d.computedStyle(k.container);var f1=p.top+(parseInt(t.borderTopWidth)||0);var g1=p.left+(parseInt(p.borderLeftWidth)||0);var h1=p.bottom-f1-n.clientHeight-2;var i1=function(e){d.translate(n,e.clientX-g1-2,Math.min(e.clientY-f1-2,h1));};i1(e);if(e.type!="mousedown")return;k.renderer.$isMousePressed=true;clearTimeout(b1);if(u.isWin)b.capture(k.container,i1,c1);};this.onContextMenuClose=c1;var b1;function c1(){clearTimeout(b1);b1=setTimeout(function(){if(x){n.style.cssText=x;x='';}k.renderer.$isMousePressed=false;if(k.renderer.$keepTextAreaAtCursor)k.renderer.$moveTextAreaToCursor();},0);}var d1=function(e){k.textInput.onContextMenu(e);c1();};b.addListener(n,"mouseup",d1,k);b.addListener(n,"mousedown",function(e){e.preventDefault();c1();},k);b.addListener(k.renderer.scroller,"contextmenu",d1,k);b.addListener(n,"contextmenu",d1,k);if(g)e1(j,k,n);function e1(j,k,n){var t=null;var i=false;n.addEventListener("keydown",function(e){if(t)clearTimeout(t);i=true;},true);n.addEventListener("keyup",function(e){t=setTimeout(function(){i=false;},100);},true);var p=function(e){if(document.activeElement!==n)return;if(i||s||k.$mouseHandler.isMousePressed)return;if(o){return;}var f1=n.selectionStart;var g1=n.selectionEnd;var h1=null;var i1=0;if(f1==0){h1=K.up;}else if(f1==1){h1=K.home;}else if(g1>D&&A[g1]=="\n"){h1=K.end;}else if(f1<C&&A[f1-1]==" "){h1=K.left;i1=f.option;}else if(f1<C||(f1==C&&D!=C&&f1==g1)){h1=K.left;}else if(g1>D&&A.slice(0,g1).split("\n").length>2){h1=K.down;}else if(g1>D&&A[g1-1]==" "){h1=K.right;i1=f.option;}else if(g1>D||(g1==D&&D!=C&&f1==g1)){h1=K.right;}if(f1!==g1)i1|=f.shift;if(h1){var j1=k.onCommandKey({},i1,h1);if(!j1&&k.commands){h1=K.keyCodeToString(h1);var k1=k.commands.findKeyCommand(i1,h1);if(k1)k.execCommand(k1);}C=f1;D=g1;G("");}};document.addEventListener("selectionchange",p);k.on("destroy",function(){document.removeEventListener("selectionchange",p);});}};a.TextInput=T;a.$setUserAgentForTests=function(_,e){h=_;g=e;};});ace.define("ace/mouse/default_handlers",[],function(r,e,m){"use strict";var u=r("../lib/useragent");var D=0;var S=550;function a(d){d.$clickSelection=null;var f=d.editor;f.setDefaultHandler("mousedown",this.onMouseDown.bind(d));f.setDefaultHandler("dblclick",this.onDoubleClick.bind(d));f.setDefaultHandler("tripleclick",this.onTripleClick.bind(d));f.setDefaultHandler("quadclick",this.onQuadClick.bind(d));f.setDefaultHandler("mousewheel",this.onMouseWheel.bind(d));var e=["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"];e.forEach(function(x){d[x]=this[x];},this);d.selectByLines=this.extendSelectionBy.bind(d,"getLineRange");d.selectByWords=this.extendSelectionBy.bind(d,"getWordRange");}(function(){this.onMouseDown=function(d){var i=d.inSelection();var p=d.getDocumentPosition();this.mousedownEvent=d;var f=this.editor;var g=d.getButton();if(g!==0){var s=f.getSelectionRange();var h=s.isEmpty();if(h||g==1)f.selection.moveToPosition(p);if(g==2){f.textInput.onContextMenu(d.domEvent);if(!u.isMozilla)d.preventDefault();}return;}this.mousedownEvent.time=Date.now();if(i&&!f.isFocused()){f.focus();if(this.$focusTimeout&&!this.$clickSelection&&!f.inMultiSelectMode){this.setState("focusWait");this.captureMouse(d);return;}}this.captureMouse(d);this.startSelect(p,d.domEvent._clicks>1);return d.preventDefault();};this.startSelect=function(p,w){p=p||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var d=this.editor;if(!this.mousedownEvent)return;if(this.mousedownEvent.getShiftKey())d.selection.selectToPosition(p);else if(!w)d.selection.moveToPosition(p);if(!w)this.select();if(d.renderer.scroller.setCapture){d.renderer.scroller.setCapture();}d.setStyle("ace_selecting");this.setState("select");};this.select=function(){var d,f=this.editor;var g=f.renderer.screenToTextCoordinates(this.x,this.y);if(this.$clickSelection){var h=this.$clickSelection.comparePoint(g);if(h==-1){d=this.$clickSelection.end;}else if(h==1){d=this.$clickSelection.start;}else{var o=b(this.$clickSelection,g);g=o.cursor;d=o.anchor;}f.selection.setSelectionAnchor(d.row,d.column);}f.selection.selectToPosition(g);f.renderer.scrollCursorIntoView();};this.extendSelectionBy=function(d){var f,g=this.editor;var h=g.renderer.screenToTextCoordinates(this.x,this.y);var i=g.selection[d](h.row,h.column);if(this.$clickSelection){var j=this.$clickSelection.comparePoint(i.start);var k=this.$clickSelection.comparePoint(i.end);if(j==-1&&k<=0){f=this.$clickSelection.end;if(i.end.row!=h.row||i.end.column!=h.column)h=i.start;}else if(k==1&&j>=0){f=this.$clickSelection.start;if(i.start.row!=h.row||i.start.column!=h.column)h=i.end;}else if(j==-1&&k==1){h=i.end;f=i.start;}else{var o=b(this.$clickSelection,h);h=o.cursor;f=o.anchor;}g.selection.setSelectionAnchor(f.row,f.column);}g.selection.selectToPosition(h);g.renderer.scrollCursorIntoView();};this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null;this.editor.unsetStyle("ace_selecting");if(this.editor.renderer.scroller.releaseCapture){this.editor.renderer.scroller.releaseCapture();}};this.focusWait=function(){var d=c(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);var t=Date.now();if(d>D||t-this.mousedownEvent.time>this.$focusTimeout)this.startSelect(this.mousedownEvent.getDocumentPosition());};this.onDoubleClick=function(d){var p=d.getDocumentPosition();var f=this.editor;var s=f.session;var g=s.getBracketRange(p);if(g){if(g.isEmpty()){g.start.column--;g.end.column++;}this.setState("select");}else{g=f.selection.getWordRange(p.row,p.column);this.setState("selectByWords");}this.$clickSelection=g;this.select();};this.onTripleClick=function(d){var p=d.getDocumentPosition();var f=this.editor;this.setState("selectByLines");var g=f.getSelectionRange();if(g.isMultiLine()&&g.contains(p.row,p.column)){this.$clickSelection=f.selection.getLineRange(g.start.row);this.$clickSelection.end=f.selection.getLineRange(g.end.row).end;}else{this.$clickSelection=f.selection.getLineRange(p.row);}this.select();};this.onQuadClick=function(d){var f=this.editor;f.selectAll();this.$clickSelection=f.getSelectionRange();this.setState("selectAll");};this.onMouseWheel=function(d){if(d.getAccelKey())return;if(d.getShiftKey()&&d.wheelY&&!d.wheelX){d.wheelX=d.wheelY;d.wheelY=0;}var f=this.editor;if(!this.$lastScroll)this.$lastScroll={t:0,vx:0,vy:0,allowed:0};var p=this.$lastScroll;var t=d.domEvent.timeStamp;var g=t-p.t;var v=g?d.wheelX/g:p.vx;var h=g?d.wheelY/g:p.vy;if(g<S){v=(v+p.vx)/2;h=(h+p.vy)/2;}var i=Math.abs(v/h);var j=false;if(i>=1&&f.renderer.isScrollableBy(d.wheelX*d.speed,0))j=true;if(i<=1&&f.renderer.isScrollableBy(0,d.wheelY*d.speed))j=true;if(j){p.allowed=t;}else if(t-p.allowed<S){var k=Math.abs(v)<=1.5*Math.abs(p.vx)&&Math.abs(h)<=1.5*Math.abs(p.vy);if(k){j=true;p.allowed=t;}else{p.allowed=0;}}p.t=t;p.vx=v;p.vy=h;if(j){f.renderer.scrollBy(d.wheelX*d.speed,d.wheelY*d.speed);return d.stop();}};}).call(a.prototype);e.DefaultHandlers=a;function c(d,f,g,h){return Math.sqrt(Math.pow(g-d,2)+Math.pow(h-f,2));}function b(d,f){if(d.start.row==d.end.row)var g=2*f.column-d.start.column-d.end.column;else if(d.start.row==d.end.row-1&&!d.start.column&&!d.end.column)var g=f.column-4;else var g=2*f.row-d.start.row-d.end.row;if(g<0)return{cursor:d.start,anchor:d.end};else return{cursor:d.end,anchor:d.start};}});ace.define("ace/tooltip",[],function(r,e,m){"use strict";var o=r("./lib/oop");var d=r("./lib/dom");function T(p){this.isOpen=false;this.$element=null;this.$parentNode=p;}(function(){this.$init=function(){this.$element=d.createElement("div");this.$element.className="ace_tooltip";this.$element.style.display="none";this.$parentNode.appendChild(this.$element);return this.$element;};this.getElement=function(){return this.$element||this.$init();};this.setText=function(t){this.getElement().textContent=t;};this.setHtml=function(h){throw new Error("Can not set html for tooltip to avoid any CSP inline styles violations");};this.setTextLines=function(t){if(!Array.isArray(t)){throw new Error("setTextLines expects an array");}var a=this.getElement();a.innerHTML="";t.forEach(function(b,c){a.appendChild(d.createTextNode(b));if(c<(t.length-1)){a.appendChild(d.createElement("br"));}});};this.setPosition=function(x,y){this.getElement().style.left=x+"px";this.getElement().style.top=y+"px";};this.setClassName=function(c){d.addCssClass(this.getElement(),c);};this.show=function(t,x,y){if(t!=null)this.setText(t);if(x!=null&&y!=null)this.setPosition(x,y);if(!this.isOpen){this.getElement().style.display="block";this.isOpen=true;}};this.hide=function(){if(this.isOpen){this.getElement().style.display="none";this.isOpen=false;}};this.getHeight=function(){return this.getElement().offsetHeight;};this.getWidth=function(){return this.getElement().offsetWidth;};this.destroy=function(){this.isOpen=false;if(this.$element&&this.$element.parentNode){this.$element.parentNode.removeChild(this.$element);}};}).call(T.prototype);e.Tooltip=T;});ace.define("ace/mouse/default_gutter_handler",[],function(r,a,m){"use strict";var d=r("../lib/dom");var o=r("../lib/oop");var b=r("../lib/event");var T=r("../tooltip").Tooltip;function G(f){var g=f.editor;var h=g.renderer.$gutterLayer;var t=new c(g.container);f.editor.setDefaultHandler("guttermousedown",function(e){if(!g.isFocused()||e.getButton()!=0)return;var p=h.getRegion(e);if(p=="foldWidgets")return;var q=e.getDocumentPosition().row;var u=g.session.selection;if(e.getShiftKey())u.selectTo(q,0);else{if(e.domEvent.detail==2){g.selectAll();return e.preventDefault();}f.$clickSelection=g.selection.getLineRange(q);}f.setState("selectByLines");f.captureMouse(e);return e.preventDefault();});var i,j,k;function s(){var e=j.getDocumentPosition().row;var p=h.$annotations[e];if(!p)return l();var q=g.session.getLength();if(e==q){var u=g.renderer.pixelToScreenCoordinates(0,j.y).row;var v=j.$pos;if(u>g.session.documentToScreenRow(v.row,v.column))return l();}if(k==p)return;k=p.text.join("<br/>");t.setTextLines(p.text);t.show();g._signal("showGutterTooltip",t);g.on("mousewheel",l);if(f.$tooltipFollowsMouse){n(j);}else{var w=j.domEvent.target;var x=w.getBoundingClientRect();var y=t.getElement().style;y.left=x.right+"px";y.top=x.bottom+"px";}}function l(){if(i)i=clearTimeout(i);if(k){t.hide();k=null;g._signal("hideGutterTooltip",t);g.off("mousewheel",l);}}function n(e){t.setPosition(e.x,e.y);}f.editor.setDefaultHandler("guttermousemove",function(e){var p=e.domEvent.target||e.domEvent.srcElement;if(d.hasCssClass(p,"ace_fold-widget"))return l();if(k&&f.$tooltipFollowsMouse)n(e);j=e;if(i)return;i=setTimeout(function(){i=null;if(j&&!f.isMousePressed)s();else l();},50);});b.addListener(g.renderer.$gutter,"mouseout",function(e){j=null;if(!k||i)return;i=setTimeout(function(){i=null;l();},50);},g);g.on("changeSession",l);}function c(p){T.call(this,p);}o.inherits(c,T);(function(){this.setPosition=function(x,y){var w=window.innerWidth||document.documentElement.clientWidth;var e=window.innerHeight||document.documentElement.clientHeight;var f=this.getWidth();var h=this.getHeight();x+=15;y+=15;if(x+f>w){x-=(x+f)-w;}if(y+h>e){y-=20+h;}T.prototype.setPosition.call(this,x,y);};}).call(c.prototype);a.GutterHandler=G;});ace.define("ace/mouse/mouse_event",[],function(r,e,m){"use strict";var a=r("../lib/event");var u=r("../lib/useragent");var M=e.MouseEvent=function(d,b){this.domEvent=d;this.editor=b;this.x=this.clientX=d.clientX;this.y=this.clientY=d.clientY;this.$pos=null;this.$inSelection=null;this.propagationStopped=false;this.defaultPrevented=false;};(function(){this.stopPropagation=function(){a.stopPropagation(this.domEvent);this.propagationStopped=true;};this.preventDefault=function(){a.preventDefault(this.domEvent);this.defaultPrevented=true;};this.stop=function(){this.stopPropagation();this.preventDefault();};this.getDocumentPosition=function(){if(this.$pos)return this.$pos;this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY);return this.$pos;};this.inSelection=function(){if(this.$inSelection!==null)return this.$inSelection;var b=this.editor;var s=b.getSelectionRange();if(s.isEmpty())this.$inSelection=false;else{var p=this.getDocumentPosition();this.$inSelection=s.contains(p.row,p.column);}return this.$inSelection;};this.getButton=function(){return a.getButton(this.domEvent);};this.getShiftKey=function(){return this.domEvent.shiftKey;};this.getAccelKey=u.isMac?function(){return this.domEvent.metaKey;}:function(){return this.domEvent.ctrlKey;};}).call(M.prototype);});ace.define("ace/mouse/dragdrop_handler",[],function(r,a,m){"use strict";var d=r("../lib/dom");var b=r("../lib/event");var u=r("../lib/useragent");var A=200;var S=200;var c=5;function D(g){var h=g.editor;var i=d.createElement("div");i.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5";i.textContent="\xa0";var a=["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"];a.forEach(function(x){g[x]=this[x];},this);h.on("mousedown",this.onMouseDown.bind(g));var j=h.container;var k,x,y;var t,l;var n,o=0;var p;var q;var s;var v;var w;this.onDragStart=function(e){if(this.cancelDrag||!j.draggable){var K=this;setTimeout(function(){K.startSelect();K.captureMouse(e);},0);return e.preventDefault();}l=h.getSelectionRange();var L=e.dataTransfer;L.effectAllowed=h.getReadOnly()?"copy":"copyMove";h.container.appendChild(i);L.setDragImage&&L.setDragImage(i,0,0);setTimeout(function(){h.container.removeChild(i);});L.clearData();L.setData("Text",h.session.getTextRange());q=true;this.setState("drag");};this.onDragEnd=function(e){j.draggable=false;q=false;this.setState(null);if(!h.getReadOnly()){var K=e.dataTransfer.dropEffect;if(!p&&K=="move")h.session.remove(h.getSelectionRange());h.$resetCursorStyle();}this.editor.unsetStyle("ace_dragging");this.editor.renderer.setCursorStyle("");};this.onDragEnter=function(e){if(h.getReadOnly()||!I(e.dataTransfer))return;x=e.clientX;y=e.clientY;if(!k)E();o++;e.dataTransfer.dropEffect=p=J(e);return b.preventDefault(e);};this.onDragOver=function(e){if(h.getReadOnly()||!I(e.dataTransfer))return;x=e.clientX;y=e.clientY;if(!k){E();o++;}if(G!==null)G=null;e.dataTransfer.dropEffect=p=J(e);return b.preventDefault(e);};this.onDragLeave=function(e){o--;if(o<=0&&k){F();p=null;return b.preventDefault(e);}};this.onDrop=function(e){if(!n)return;var K=e.dataTransfer;if(q){switch(p){case"move":if(l.contains(n.row,n.column)){l={start:n,end:n};}else{l=h.moveText(l,n);}break;case"copy":l=h.moveText(l,n,true);break;}}else{var L=K.getData('Text');l={start:n,end:h.session.insert(n,L)};h.focus();p=null;}F();return b.preventDefault(e);};b.addListener(j,"dragstart",this.onDragStart.bind(g),h);b.addListener(j,"dragend",this.onDragEnd.bind(g),h);b.addListener(j,"dragenter",this.onDragEnter.bind(g),h);b.addListener(j,"dragover",this.onDragOver.bind(g),h);b.addListener(j,"dragleave",this.onDragLeave.bind(g),h);b.addListener(j,"drop",this.onDrop.bind(g),h);function z(e,K){var L=Date.now();var M=!K||e.row!=K.row;var N=!K||e.column!=K.column;if(!v||M||N){h.moveCursorToPosition(e);v=L;w={x:x,y:y};}else{var O=f(w.x,w.y,x,y);if(O>c){v=null;}else if(L-v>=S){h.renderer.scrollCursorIntoView();v=null;}}}function B(e,K){var L=Date.now();var M=h.renderer.layerConfig.lineHeight;var N=h.renderer.layerConfig.characterWidth;var O=h.renderer.scroller.getBoundingClientRect();var P={x:{left:x-O.left,right:O.right-x},y:{top:y-O.top,bottom:O.bottom-y}};var Q=Math.min(P.x.left,P.x.right);var R=Math.min(P.y.top,P.y.bottom);var T={row:e.row,column:e.column};if(Q/N<=2){T.column+=(P.x.left<P.x.right?-3:+2);}if(R/M<=1){T.row+=(P.y.top<P.y.bottom?-1:+1);}var U=e.row!=T.row;var V=e.column!=T.column;var W=!K||e.row!=K.row;if(U||(V&&!W)){if(!s)s=L;else if(L-s>=A)h.renderer.scrollCursorIntoView(T);}else{s=null;}}function C(){var e=n;n=h.renderer.screenToTextCoordinates(x,y);z(n,e);B(n,e);}function E(){l=h.selection.toOrientedRange();k=h.session.addMarker(l,"ace_selection",h.getSelectionStyle());h.clearSelection();if(h.isFocused())h.renderer.$cursorLayer.setBlinking(false);clearInterval(t);C();t=setInterval(C,20);o=0;b.addListener(document,"mousemove",H);}function F(){clearInterval(t);h.session.removeMarker(k);k=null;h.selection.fromOrientedRange(l);if(h.isFocused()&&!q)h.$resetCursorStyle();l=null;n=null;o=0;s=null;v=null;b.removeListener(document,"mousemove",H);}var G=null;function H(){if(G==null){G=setTimeout(function(){if(G!=null&&k)F();},20);}}function I(e){var K=e.types;return!K||Array.prototype.some.call(K,function(L){return L=='text/plain'||L=='Text';});}function J(e){var K=['copy','copymove','all','uninitialized'];var L=['move','copymove','linkmove','all','uninitialized'];var M=u.isMac?e.altKey:e.ctrlKey;var N="uninitialized";try{N=e.dataTransfer.effectAllowed.toLowerCase();}catch(e){}var O="none";if(M&&K.indexOf(N)>=0)O="copy";else if(L.indexOf(N)>=0)O="move";else if(K.indexOf(N)>=0)O="copy";return O;}}(function(){this.dragWait=function(){var i=Date.now()-this.mousedownEvent.time;if(i>this.editor.getDragDelay())this.startDrag();};this.dragWaitEnd=function(){var t=this.editor.container;t.draggable=false;this.startSelect(this.mousedownEvent.getDocumentPosition());this.selectEnd();};this.dragReadyEnd=function(e){this.editor.$resetCursorStyle();this.editor.unsetStyle("ace_dragging");this.editor.renderer.setCursorStyle("");this.dragWaitEnd();};this.startDrag=function(){this.cancelDrag=false;var e=this.editor;var t=e.container;t.draggable=true;e.renderer.$cursorLayer.setBlinking(false);e.setStyle("ace_dragging");var g=u.isWin?"default":"move";e.renderer.setCursorStyle(g);this.setState("dragReady");};this.onMouseDrag=function(e){var t=this.editor.container;if(u.isIE&&this.state=="dragReady"){var g=f(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);if(g>3)t.dragDrop();}if(this.state==="dragWait"){var g=f(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y);if(g>0){t.draggable=false;this.startSelect(this.mousedownEvent.getDocumentPosition());}}};this.onMouseDown=function(e){if(!this.$dragEnabled)return;this.mousedownEvent=e;var g=this.editor;var i=e.inSelection();var h=e.getButton();var j=e.domEvent.detail||1;if(j===1&&h===0&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var k=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in k)k.unselectable="on";if(g.getDragDelay()){if(u.isWebKit){this.cancelDrag=true;var l=g.container;l.draggable=true;}this.setState("dragWait");}else{this.startDrag();}this.captureMouse(e,this.onMouseDrag.bind(this));e.defaultPrevented=true;}};}).call(D.prototype);function f(e,g,h,i){return Math.sqrt(Math.pow(h-e,2)+Math.pow(i-g,2));}a.DragdropHandler=D;});ace.define("ace/mouse/touch_handler",[],function(r,a,m){"use strict";var M=r("./mouse_event").MouseEvent;var b=r("../lib/event");var d=r("../lib/dom");a.addTouchListeners=function(c,f){var g="scroll";var s;var i;var j;var l;var k;var n;var o=0;var p;var q=0;var X=0;var Y=0;var u;var v;function z(){var h=window.navigator&&window.navigator.clipboard;var t=false;var w=function(){var e=f.getCopyText();var y=f.session.getUndoManager().hasUndo();v.replaceChild(d.buildDom(t?["span",!e&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],e&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],e&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],h&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],y&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),v.firstChild);};var x=function(e){var y=e.target.getAttribute("action");if(y=="more"||!t){t=!t;return w();}if(y=="paste"){h.readText().then(function(F){f.execCommand(y,F);});}else if(y){if(y=="cut"||y=="copy"){if(h)h.writeText(f.getCopyText());else document.execCommand("copy");}f.execCommand(y);}v.firstChild.style.display="none";t=false;if(y!="openCommandPallete")f.focus();};v=d.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){g="menu";e.stopPropagation();e.preventDefault();f.textInput.focus();},ontouchend:function(e){e.stopPropagation();e.preventDefault();x(e);},onclick:x},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],f.container);}function A(){if(!v)z();var e=f.selection.cursor;var h=f.renderer.textToScreenCoordinates(e.row,e.column);var t=f.renderer.textToScreenCoordinates(0,0).pageX;var w=f.renderer.scrollLeft;var x=f.container.getBoundingClientRect();v.style.top=h.pageY-x.top-3+"px";if(h.pageX-x.left<x.width-70){v.style.left="";v.style.right="10px";}else{v.style.right="";v.style.left=t+w-x.left+"px";}v.style.display="";v.firstChild.style.display="none";f.on("input",B);}function B(e){if(v)v.style.display="none";f.off("input",B);}function C(){k=null;clearTimeout(k);var e=f.selection.getRange();var h=e.contains(p.row,p.column);if(e.isEmpty()||!h){f.selection.moveToPosition(p);f.selection.selectWord();}g="wait";A();}function D(){k=null;clearTimeout(k);f.selection.moveToPosition(p);var e=q>=2?f.selection.getLineRange(p.row):f.session.getBracketRange(p);if(e&&!e.isEmpty()){f.selection.setRange(e);}else{f.selection.selectWord();}g="wait";}b.addListener(c,"contextmenu",function(e){if(!u)return;var t=f.textInput.getElement();t.focus();},f);b.addListener(c,"touchstart",function(e){var F=e.touches;if(k||F.length>1){clearTimeout(k);k=null;j=-1;g="zoom";return;}u=f.$mouseHandler.isMousePressed=true;var h=f.renderer.layerConfig.lineHeight;var w=f.renderer.layerConfig.lineHeight;var t=e.timeStamp;l=t;var G=F[0];var x=G.clientX;var y=G.clientY;if(Math.abs(s-x)+Math.abs(i-y)>h)j=-1;s=e.clientX=x;i=e.clientY=y;X=Y=0;var H=new M(e,f);p=H.getDocumentPosition();if(t-j<500&&F.length==1&&!o){q++;e.preventDefault();e.button=0;D();}else{q=0;var I=f.selection.cursor;var J=f.selection.isEmpty()?I:f.selection.anchor;var K=f.renderer.$cursorLayer.getPixelPosition(I,true);var L=f.renderer.$cursorLayer.getPixelPosition(J,true);var N=f.renderer.scroller.getBoundingClientRect();var O=f.renderer.layerConfig.offset;var P=f.renderer.scrollLeft;var Q=function(x,y){x=x/w;y=y/h-0.75;return x*x+y*y;};if(e.clientX<N.left){g="zoom";return;}var R=Q(e.clientX-N.left-K.left+P,e.clientY-N.top-K.top+O);var S=Q(e.clientX-N.left-L.left+P,e.clientY-N.top-L.top+O);if(R<3.5&&S<3.5)g=R>S?"cursor":"anchor";if(S<3.5)g="anchor";else if(R<3.5)g="cursor";else g="scroll";k=setTimeout(C,450);}j=t;},f);b.addListener(c,"touchend",function(e){u=f.$mouseHandler.isMousePressed=false;if(n)clearInterval(n);if(g=="zoom"){g="";o=0;}else if(k){f.selection.moveToPosition(p);o=0;A();}else if(g=="scroll"){E();B();}else{A();}clearTimeout(k);k=null;},f);b.addListener(c,"touchmove",function(e){if(k){clearTimeout(k);k=null;}var h=e.touches;if(h.length>1||g=="zoom")return;var w=h[0];var x=s-w.clientX;var y=i-w.clientY;if(g=="wait"){if(x*x+y*y>4)g="cursor";else return e.preventDefault();}s=w.clientX;i=w.clientY;e.clientX=w.clientX;e.clientY=w.clientY;var t=e.timeStamp;var F=t-l;l=t;if(g=="scroll"){var G=new M(e,f);G.speed=1;G.wheelX=x;G.wheelY=y;if(10*Math.abs(x)<Math.abs(y))x=0;if(10*Math.abs(y)<Math.abs(x))y=0;if(F!=0){X=x/F;Y=y/F;}f._emit("mousewheel",G);if(!G.propagationStopped){X=Y=0;}}else{var H=new M(e,f);var p=H.getDocumentPosition();if(g=="cursor")f.selection.moveCursorToPosition(p);else if(g=="anchor")f.selection.setSelectionAnchor(p.row,p.column);f.renderer.scrollCursorIntoView(p);e.preventDefault();}},f);function E(){o+=60;n=setInterval(function(){if(o--<=0){clearInterval(n);n=null;}if(Math.abs(X)<0.01)X=0;if(Math.abs(Y)<0.01)Y=0;if(o<20)X=0.9*X;if(o<20)Y=0.9*Y;var e=f.session.getScrollTop();f.renderer.scrollBy(10*X,10*Y);if(e==f.session.getScrollTop())o=0;},10);}};});ace.define("ace/lib/net",[],function(r,e,m){"use strict";var d=r("./dom");e.get=function(u,c){var x=new XMLHttpRequest();x.open('GET',u,true);x.onreadystatechange=function(){if(x.readyState===4){c(x.responseText);}};x.send(null);};e.loadScript=function(p,c){var h=d.getDocumentHead();var s=document.createElement('script');s.src=p;h.appendChild(s);s.onload=s.onreadystatechange=function(_,i){if(i||!s.readyState||s.readyState=="loaded"||s.readyState=="complete"){s=s.onload=s.onreadystatechange=null;if(!i)c();}};};e.qualifyURL=function(u){var a=document.createElement('a');a.href=u;return a.href;};});ace.define("ace/lib/event_emitter",[],function(r,a,m){"use strict";var E={};var s=function(){this.propagationStopped=true;};var p=function(){this.defaultPrevented=true;};E._emit=E._dispatchEvent=function(b,e){this._eventRegistry||(this._eventRegistry={});this._defaultHandlers||(this._defaultHandlers={});var l=this._eventRegistry[b]||[];var d=this._defaultHandlers[b];if(!l.length&&!d)return;if(typeof e!="object"||!e)e={};if(!e.type)e.type=b;if(!e.stopPropagation)e.stopPropagation=s;if(!e.preventDefault)e.preventDefault=p;l=l.slice();for(var i=0;i<l.length;i++){l[i](e,this);if(e.propagationStopped)break;}if(d&&!e.defaultPrevented)return d(e,this);};E._signal=function(b,e){var l=(this._eventRegistry||{})[b];if(!l)return;l=l.slice();for(var i=0;i<l.length;i++)l[i](e,this);};E.once=function(e,c){var _=this;this.on(e,function n(){_.off(e,n);c.apply(null,arguments);});if(!c){return new Promise(function(b){c=b;});}};E.setDefaultHandler=function(e,c){var h=this._defaultHandlers;if(!h)h=this._defaultHandlers={_disabled_:{}};if(h[e]){var o=h[e];var d=h._disabled_[e];if(!d)h._disabled_[e]=d=[];d.push(o);var i=d.indexOf(c);if(i!=-1)d.splice(i,1);}h[e]=c;};E.removeDefaultHandler=function(e,c){var h=this._defaultHandlers;if(!h)return;var d=h._disabled_[e];if(h[e]==c){if(d)this.setDefaultHandler(e,d.pop());}else if(d){var i=d.indexOf(c);if(i!=-1)d.splice(i,1);}};E.on=E.addEventListener=function(e,c,b){this._eventRegistry=this._eventRegistry||{};var l=this._eventRegistry[e];if(!l)l=this._eventRegistry[e]=[];if(l.indexOf(c)==-1)l[b?"unshift":"push"](c);return c;};E.off=E.removeListener=E.removeEventListener=function(e,c){this._eventRegistry=this._eventRegistry||{};var l=this._eventRegistry[e];if(!l)return;var i=l.indexOf(c);if(i!==-1)l.splice(i,1);};E.removeAllListeners=function(e){if(!e)this._eventRegistry=this._defaultHandlers=undefined;if(this._eventRegistry)this._eventRegistry[e]=undefined;if(this._defaultHandlers)this._defaultHandlers[e]=undefined;};a.EventEmitter=E;});ace.define("ace/lib/app_config",[],function(r,a,m){"no use strict";var o=r("./oop");var E=r("./event_emitter").EventEmitter;var b={setOptions:function(d){Object.keys(d).forEach(function(k){this.setOption(k,d[k]);},this);},getOptions:function(d){var e={};if(!d){var f=this.$options;d=Object.keys(f).filter(function(k){return!f[k].hidden;});}else if(!Array.isArray(d)){e=d;d=Object.keys(e);}d.forEach(function(k){e[k]=this.getOption(k);},this);return e;},setOption:function(n,v){if(this["$"+n]===v)return;var d=this.$options[n];if(!d){return w('misspelled option "'+n+'"');}if(d.forwardTo)return this[d.forwardTo]&&this[d.forwardTo].setOption(n,v);if(!d.handlesSet)this["$"+n]=v;if(d&&d.set)d.set.call(this,v);},getOption:function(n){var d=this.$options[n];if(!d){return w('misspelled option "'+n+'"');}if(d.forwardTo)return this[d.forwardTo]&&this[d.forwardTo].getOption(n);return d&&d.get?d.get.call(this):this["$"+n];}};function w(d){if(typeof console!="undefined"&&console.warn)console.warn.apply(console,arguments);}function c(d,f){var e=new Error(d);e.data=f;if(typeof console=="object"&&console.error)console.error(e);setTimeout(function(){throw e;});}var A=function(){this.$defaultOptions={};};(function(){o.implement(this,E);this.defineOptions=function(d,p,e){if(!d.$options)this.$defaultOptions[p]=d.$options={};Object.keys(e).forEach(function(k){var f=e[k];if(typeof f=="string")f={forwardTo:f};f.name||(f.name=k);d.$options[f.name]=f;if("initialValue"in f)d["$"+f.name]=f.initialValue;});o.implement(d,b);return this;};this.resetOptions=function(d){Object.keys(d.$options).forEach(function(k){var e=d.$options[k];if("value"in e)d.setOption(k,e.value);});};this.setDefaultValue=function(p,n,v){if(!p){for(p in this.$defaultOptions)if(this.$defaultOptions[p][n])break;if(!this.$defaultOptions[p][n])return false;}var d=this.$defaultOptions[p]||(this.$defaultOptions[p]={});if(d[n]){if(d.forwardTo)this.setDefaultValue(d.forwardTo,n,v);else d[n].value=v;}};this.setDefaultValues=function(p,d){Object.keys(d).forEach(function(k){this.setDefaultValue(p,k,d[k]);},this);};this.warn=w;this.reportError=c;}).call(A.prototype);a.AppConfig=A;});ace.define("ace/config",[],function(r,a,b){"no use strict";var c=r("./lib/lang");var o=r("./lib/oop");var n=r("./lib/net");var d=r("./lib/dom");var A=r("./lib/app_config").AppConfig;b.exports=a=new A();var g=(function(){return this||typeof window!="undefined"&&window;})();var f={packaged:false,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:true,sharedPopups:false,useStrictCSP:null};a.get=function(e){if(!f.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return f[e];};a.set=function(e,v){if(f.hasOwnProperty(e))f[e]=v;else if(this.setDefaultValue("",e,v)==false)throw new Error("Unknown config key: "+e);if(e=="useStrictCSP")d.useStrictCSP(v);};a.all=function(){return c.copyObject(f);};a.$modes={};a.moduleUrl=function(e,i){if(f.$moduleUrls[e])return f.$moduleUrls[e];var j=e.split("/");i=i||j[j.length-2]||"";var s=i=="snippets"?"/":"-";var l=j[j.length-1];if(i=="worker"&&s=="-"){var m=new RegExp("^"+i+"[\\-_]|[\\-_]"+i+"$","g");l=l.replace(m,"");}if((!l||l==i)&&j.length>1)l=j[j.length-2];var q=f[i+"Path"];if(q==null){q=f.basePath;}else if(s=="/"){i=s="";}if(q&&q.slice(-1)!="/")q+="/";return q+i+s+l+this.get("suffix");};a.setModuleUrl=function(e,s){return f.$moduleUrls[e]=s;};a.$loading={};a.loadModule=function(m,i){var b,j;if(Array.isArray(m)){j=m[0];m=m[1];}try{b=r(m);}catch(e){}if(b&&!a.$loading[m])return i&&i(b);if(!a.$loading[m])a.$loading[m]=[];a.$loading[m].push(i);if(a.$loading[m].length>1)return;var l=function(){r([m],function(b){a._emit("load.module",{name:m,module:b});var q=a.$loading[m];a.$loading[m]=null;q.forEach(function(i){i&&i(b);});});};if(!a.get("packaged"))return l();n.loadScript(a.moduleUrl(m,j),l);h();};var h=function(){if(!f.basePath&&!f.workerPath&&!f.modePath&&!f.themePath&&!Object.keys(f.$moduleUrls).length){console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver");h=function(){};}};k(true);function k(e){if(!g||!g.document)return;f.packaged=e||r.packaged||b.packaged||(g.define&&define.packaged);var s={};var q="";var t=(document.currentScript||document._currentScript);var u=t&&t.ownerDocument||document;var v=u.getElementsByTagName("script");for(var i=0;i<v.length;i++){var w=v[i];var x=w.src||w.getAttribute("src");if(!x)continue;var y=w.attributes;for(var j=0,l=y.length;j<l;j++){var z=y[j];if(z.name.indexOf("data-ace-")===0){s[p(z.name.replace(/^data-ace-/,""))]=z.value;}}var m=x.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);if(m)q=m[1];}if(q){s.base=s.base||q;s.packaged=true;}s.basePath=s.base;s.workerPath=s.workerPath||s.base;s.modePath=s.modePath||s.base;s.themePath=s.themePath||s.base;delete s.base;for(var B in s)if(typeof s[B]!=="undefined")a.set(B,s[B]);}a.init=k;function p(s){return s.replace(/-(.)/g,function(m,e){return e.toUpperCase();});}a.version="1.4.13";});ace.define("ace/mouse/mouse_handler",[],function(r,a,m){"use strict";var b=r("../lib/event");var u=r("../lib/useragent");var D=r("./default_handlers").DefaultHandlers;var c=r("./default_gutter_handler").GutterHandler;var M=r("./mouse_event").MouseEvent;var d=r("./dragdrop_handler").DragdropHandler;var f=r("./touch_handler").addTouchListeners;var g=r("../config");var h=function(i){var _=this;this.editor=i;new D(this);new c(this);new d(this);var j=function(e){var w=!document.hasFocus||!document.hasFocus()||!i.isFocused()&&document.activeElement==(i.textInput&&i.textInput.getElement());if(w)window.focus();i.focus();};var k=i.renderer.getMouseEventTarget();b.addListener(k,"click",this.onMouseEvent.bind(this,"click"),i);b.addListener(k,"mousemove",this.onMouseMove.bind(this,"mousemove"),i);b.addMultiMouseDownListener([k,i.renderer.scrollBarV&&i.renderer.scrollBarV.inner,i.renderer.scrollBarH&&i.renderer.scrollBarH.inner,i.textInput&&i.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",i);b.addMouseWheelListener(i.container,this.onMouseWheel.bind(this,"mousewheel"),i);f(i.container,i);var l=i.renderer.$gutter;b.addListener(l,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),i);b.addListener(l,"click",this.onMouseEvent.bind(this,"gutterclick"),i);b.addListener(l,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),i);b.addListener(l,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),i);b.addListener(k,"mousedown",j,i);b.addListener(l,"mousedown",j,i);if(u.isIE&&i.renderer.scrollBarV){b.addListener(i.renderer.scrollBarV.element,"mousedown",j,i);b.addListener(i.renderer.scrollBarH.element,"mousedown",j,i);}i.on("mousemove",function(e){if(_.state||_.$dragDelay||!_.$dragEnabled)return;var n=i.renderer.screenToTextCoordinates(e.x,e.y);var o=i.session.selection.getRange();var p=i.renderer;if(!o.isEmpty()&&o.insideStart(n.row,n.column)){p.setCursorStyle("default");}else{p.setCursorStyle("");}},i);};(function(){this.onMouseEvent=function(n,e){if(!this.editor.session)return;this.editor._emit(n,new M(e,this.editor));};this.onMouseMove=function(n,e){var l=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;if(!l||!l.length)return;this.editor._emit(n,new M(e,this.editor));};this.onMouseWheel=function(n,e){var i=new M(e,this.editor);i.speed=this.$scrollSpeed*2;i.wheelX=e.wheelX;i.wheelY=e.wheelY;this.editor._emit(n,i);};this.setState=function(s){this.state=s;};this.captureMouse=function(i,j){this.x=i.x;this.y=i.y;this.isMousePressed=true;var k=this.editor;var l=this.editor.renderer;l.$isMousePressed=true;var s=this;var o=function(e){if(!e)return;if(u.isWebKit&&!e.which&&s.releaseMouse)return s.releaseMouse();s.x=e.clientX;s.y=e.clientY;j&&j(e);s.mouseEvent=new M(e,s.editor);s.$mouseMoved=true;};var n=function(e){k.off("beforeEndOperation",q);clearInterval(t);if(k.session)p();s[s.state+"End"]&&s[s.state+"End"](e);s.state="";s.isMousePressed=l.$isMousePressed=false;if(l.$keepTextAreaAtCursor)l.$moveTextAreaToCursor();s.$onCaptureMouseMove=s.releaseMouse=null;e&&s.onMouseEvent("mouseup",e);k.endOperation();};var p=function(){s[s.state]&&s[s.state]();s.$mouseMoved=false;};if(u.isOldIE&&i.domEvent.type=="dblclick"){return setTimeout(function(){n(i);});}var q=function(e){if(!s.releaseMouse)return;if(k.curOp.command.name&&k.curOp.selectionChanged){s[s.state+"End"]&&s[s.state+"End"]();s.state="";s.releaseMouse();}};k.on("beforeEndOperation",q);k.startOperation({command:{name:"mouse"}});s.$onCaptureMouseMove=o;s.releaseMouse=b.capture(this.editor.container,o,n);var t=setInterval(p,20);};this.releaseMouse=null;this.cancelContextMenu=function(){var s=function(e){if(e&&e.domEvent&&e.domEvent.type!="contextmenu")return;this.editor.off("nativecontextmenu",s);if(e&&e.domEvent)b.stopEvent(e.domEvent);}.bind(this);setTimeout(s,10);this.editor.on("nativecontextmenu",s);};this.destroy=function(){if(this.releaseMouse)this.releaseMouse();};}).call(h.prototype);g.defineOptions(h.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:(u.isMac?150:0)},dragEnabled:{initialValue:true},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:true}});a.MouseHandler=h;});ace.define("ace/mouse/fold_handler",[],function(r,a,m){"use strict";var d=r("../lib/dom");function F(b){b.on("click",function(e){var p=e.getDocumentPosition();var s=b.session;var f=s.getFoldAt(p.row,p.column,1);if(f){if(e.getAccelKey())s.removeFold(f);else s.expandFold(f);e.stop();}var t=e.domEvent&&e.domEvent.target;if(t&&d.hasCssClass(t,"ace_inline_button")){if(d.hasCssClass(t,"ace_toggle_wrap")){s.setOption("wrap",!s.getUseWrapMode());b.renderer.scrollCursorIntoView();}}});b.on("gutterclick",function(e){var g=b.renderer.$gutterLayer.getRegion(e);if(g=="foldWidgets"){var c=e.getDocumentPosition().row;var s=b.session;if(s.foldWidgets&&s.foldWidgets[c])b.session.onFoldWidgetClick(c,e);if(!b.isFocused())b.focus();e.stop();}});b.on("gutterdblclick",function(e){var g=b.renderer.$gutterLayer.getRegion(e);if(g=="foldWidgets"){var c=e.getDocumentPosition().row;var s=b.session;var f=s.getParentFoldRangeData(c,true);var h=f.range||f.firstRange;if(h){c=h.start.row;var i=s.getFoldAt(c,s.getLine(c).length,1);if(i){s.removeFold(i);}else{s.addFold("...",h);b.renderer.scrollCursorIntoView({row:h.start.row,column:0});}}e.stop();}});}a.FoldHandler=F;});ace.define("ace/keyboard/keybinding",[],function(r,a,m){"use strict";var k=r("../lib/keys");var b=r("../lib/event");var K=function(e){this.$editor=e;this.$data={editor:e};this.$handlers=[];this.setDefaultHandler(e.commands);};(function(){this.setDefaultHandler=function(c){this.removeKeyboardHandler(this.$defaultHandler);this.$defaultHandler=c;this.addKeyboardHandler(c,0);};this.setKeyboardHandler=function(c){var h=this.$handlers;if(h[h.length-1]==c)return;while(h[h.length-1]&&h[h.length-1]!=this.$defaultHandler)this.removeKeyboardHandler(h[h.length-1]);this.addKeyboardHandler(c,1);};this.addKeyboardHandler=function(c,p){if(!c)return;if(typeof c=="function"&&!c.handleKeyboard)c.handleKeyboard=c;var i=this.$handlers.indexOf(c);if(i!=-1)this.$handlers.splice(i,1);if(p==undefined)this.$handlers.push(c);else this.$handlers.splice(p,0,c);if(i==-1&&c.attach)c.attach(this.$editor);};this.removeKeyboardHandler=function(c){var i=this.$handlers.indexOf(c);if(i==-1)return false;this.$handlers.splice(i,1);c.detach&&c.detach(this.$editor);return true;};this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1];};this.getStatusText=function(){var d=this.$data;var e=d.editor;return this.$handlers.map(function(h){return h.getStatusText&&h.getStatusText(e,d)||"";}).filter(Boolean).join(" ");};this.$callKeyboardHandlers=function(h,c,d,e){var t;var s=false;var f=this.$editor.commands;for(var i=this.$handlers.length;i--;){t=this.$handlers[i].handleKeyboard(this.$data,h,c,d,e);if(!t||!t.command)continue;if(t.command=="null"){s=true;}else{s=f.exec(t.command,this.$editor,t.args,e);}if(s&&e&&h!=-1&&t.passEvent!=true&&t.command.passEvent!=true){b.stopEvent(e);}if(s)break;}if(!s&&h==-1){t={command:"insertstring"};s=f.exec("insertstring",this.$editor,c);}if(s&&this.$editor._signal)this.$editor._signal("keyboardActivity",t);return s;};this.onCommandKey=function(e,h,c){var d=k.keyCodeToString(c);return this.$callKeyboardHandlers(h,d,c,e);};this.onTextInput=function(t){return this.$callKeyboardHandlers(-1,t);};}).call(K.prototype);a.KeyBinding=K;});ace.define("ace/lib/bidiutil",[],function(r,e,m){"use strict";var A=['\u0621','\u0641'];var a=['\u063A','\u064a'];var d=0,h=0;var l=false,b=false,f=false,g=false,k=false,n=false;var o=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,0x11,2,0,1],[0,3,5,5,4,1,0],[0,3,0x15,0x15,4,0,1],[0,3,5,5,4,2,0]];var p=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,0x21,3,1,1]];var q=0,s=1;var L=0;var R=1;var E=2;var t=3;var O=4;var B=5;var S=6;var u=7;var W=8;var C=9;var v=10;var w=11;var N=12;var x=13;var y=14;var P=15;var z=16;var D=17;var F=18;var U=[F,F,F,F,F,F,F,F,F,S,B,S,W,B,F,F,F,F,F,F,F,F,F,F,F,F,F,F,B,B,B,S,W,O,O,w,w,w,O,O,O,O,O,v,C,v,C,C,E,E,E,E,E,E,E,E,E,E,C,O,O,O,O,O,O,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,O,O,O,O,O,O,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,L,O,O,O,O,F,F,F,F,F,F,B,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,C,O,w,w,w,w,O,O,O,O,L,O,O,F,O,O,w,w,E,E,O,L,O,O,O,E,L,O,O,O,O,O];var G=[W,W,W,W,W,W,W,W,W,W,W,F,F,F,L,R,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,W,B,x,y,P,z,D,C,w,w,w,w,w,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,C,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,W];function _(c,M,Q,T){var V=d?p:o,X=null,Y=null,Z=null,$=0,a1=null,b1=null,c1=-1,i=null,ix=null,e1=[];if(!T){for(i=0,T=[];i<Q;i++){T[i]=J(c[i]);}}h=d;l=false;b=false;f=false;g=false;for(ix=0;ix<Q;ix++){X=$;e1[ix]=Y=I(c,T,e1,ix);$=V[X][Y];a1=$&0xF0;$&=0x0F;M[ix]=Z=V[$][5];if(a1>0){if(a1==0x10){for(i=c1;i<ix;i++){M[i]=1;}c1=-1;}else{c1=-1;}}b1=V[$][6];if(b1){if(c1==-1){c1=ix;}}else{if(c1>-1){for(i=c1;i<ix;i++){M[i]=Z;}c1=-1;}}if(T[ix]==B){M[ix]=0;}h|=Z;}if(g){for(i=0;i<Q;i++){if(T[i]==S){M[i]=d;for(var j=i-1;j>=0;j--){if(T[j]==W){M[j]=d;}else{break;}}}}}}function H(c,i,j){if(h<c){return;}if(c==1&&d==s&&!f){j.reverse();return;}var M=j.length,Q=0,T,V,X,Y;while(Q<M){if(i[Q]>=c){T=Q+1;while(T<M&&i[T]>=c){T++;}for(V=Q,X=T-1;V<X;V++,X--){Y=j[V];j[V]=j[X];j[X]=Y;}Q=T;}Q++;}}function I(j,M,Q,T){var V=M[T],X,Y,Z,i;switch(V){case L:case R:l=false;case O:case t:return V;case E:return l?t:E;case u:l=true;b=true;return R;case W:return O;case C:if(T<1||(T+1)>=M.length||((X=Q[T-1])!=E&&X!=t)||((Y=M[T+1])!=E&&Y!=t)){return O;}if(l){Y=t;}return Y==X?Y:O;case v:X=T>0?Q[T-1]:B;if(X==E&&(T+1)<M.length&&M[T+1]==E){return E;}return O;case w:if(T>0&&Q[T-1]==E){return E;}if(l){return O;}i=T+1;Z=M.length;while(i<Z&&M[i]==w){i++;}if(i<Z&&M[i]==E){return E;}return O;case N:Z=M.length;i=T+1;while(i<Z&&M[i]==N){i++;}if(i<Z){var c=j[T],$=(c>=0x0591&&c<=0x08FF)||c==0xFB1E;X=M[i];if($&&(X==R||X==u)){return R;}}if(T<1||(X=M[T-1])==B){return O;}return Q[T-1];case B:l=false;f=true;return d;case S:g=true;return O;case x:case y:case z:case D:case P:l=false;case F:return O;}}function J(c){var i=c.charCodeAt(0),j=i>>8;if(j==0){return((i>0x00BF)?L:U[i]);}else if(j==5){return(/[\u0591-\u05f4]/.test(c)?R:L);}else if(j==6){if(/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(c))return N;else if(/[\u0660-\u0669\u066b-\u066c]/.test(c))return t;else if(i==0x066A)return w;else if(/[\u06f0-\u06f9]/.test(c))return E;else return u;}else if(j==0x20&&i<=0x205F){return G[i&0xFF];}else if(j==0xFE){return(i>=0xFE70?u:O);}return O;}function K(c){return(c>='\u064b'&&c<='\u0655');}e.L=L;e.R=R;e.EN=E;e.ON_R=3;e.AN=4;e.R_H=5;e.B=6;e.RLE=7;e.DOT="\xB7";e.doBidiReorder=function(c,j,M){if(c.length<2)return{};var Q=c.split(""),T=new Array(Q.length),V=new Array(Q.length),X=[];d=M?s:q;_(Q,X,Q.length,j);for(var i=0;i<T.length;T[i]=i,i++);H(2,X,T);H(1,X,T);for(var i=0;i<T.length-1;i++){if(j[i]===t){X[i]=e.AN;}else if(X[i]===R&&((j[i]>u&&j[i]<x)||j[i]===O||j[i]===F)){X[i]=e.ON_R;}else if((i>0&&Q[i-1]==='\u0644')&&/\u0622|\u0623|\u0625|\u0627/.test(Q[i])){X[i-1]=X[i]=e.R_H;i++;}}if(Q[Q.length-1]===e.DOT)X[Q.length-1]=e.B;if(Q[0]==='\u202B')X[0]=e.RLE;for(var i=0;i<T.length;i++){V[i]=X[T[i]];}return{'logicalFromVisual':T,'bidiLevels':V};};e.hasBidiCharacters=function(c,j){var M=false;for(var i=0;i<c.length;i++){j[i]=J(c.charAt(i));if(!M&&(j[i]==R||j[i]==u||j[i]==t))M=true;}return M;};e.getVisualFromLogicalIdx=function(c,j){for(var i=0;i<j.logicalFromVisual.length;i++){if(j.logicalFromVisual[i]==c)return i;}return 0;};});ace.define("ace/bidihandler",[],function(r,e,m){"use strict";var b=r("./lib/bidiutil");var l=r("./lib/lang");var a=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;var B=function(s){this.session=s;this.bidiMap={};this.currentRow=null;this.bidiUtil=b;this.charWidths=[];this.EOL="\xAC";this.showInvisibles=true;this.isRtlDir=false;this.$isRtl=false;this.line="";this.wrapIndent=0;this.EOF="\xB6";this.RLE="\u202B";this.contentWidth=0;this.fontMetrics=null;this.rtlLineOffset=0;this.wrapOffset=0;this.isMoveLeftOperation=false;this.seenBidi=a.test(s.getValue());};(function(){this.isBidiRow=function(s,d,c){if(!this.seenBidi)return false;if(s!==this.currentRow){this.currentRow=s;this.updateRowLine(d,c);this.updateBidiMap();}return this.bidiMap.bidiLevels;};this.onChange=function(d){if(!this.seenBidi){if(d.action=="insert"&&a.test(d.lines.join("\n"))){this.seenBidi=true;this.currentRow=null;}}else{this.currentRow=null;}};this.getDocumentRow=function(){var d=0;var c=this.session.$screenRowCache;if(c.length){var i=this.session.$getRowCacheIndex(c,this.currentRow);if(i>=0)d=this.session.$docRowCache[i];}return d;};this.getSplitIndex=function(){var s=0;var c=this.session.$screenRowCache;if(c.length){var d,p=this.session.$getRowCacheIndex(c,this.currentRow);while(this.currentRow-s>0){d=this.session.$getRowCacheIndex(c,this.currentRow-s-1);if(d!==p)break;p=d;s++;}}else{s=this.currentRow;}return s;};this.updateRowLine=function(d,s){if(d===undefined)d=this.getDocumentRow();var c=(d===this.session.getLength()-1),f=c?this.EOF:this.EOL;this.wrapIndent=0;this.line=this.session.getLine(d);this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE;if(this.session.$useWrapMode){var g=this.session.$wrapData[d];if(g){if(s===undefined)s=this.getSplitIndex();if(s>0&&g.length){this.wrapIndent=g.indent;this.wrapOffset=this.wrapIndent*this.charWidths[b.L];this.line=(s<g.length)?this.line.substring(g[s-1],g[s]):this.line.substring(g[g.length-1]);}else{this.line=this.line.substring(0,g[s]);}}if(s==g.length)this.line+=(this.showInvisibles)?f:b.DOT;}else{this.line+=this.showInvisibles?f:b.DOT;}var h=this.session,j=0,k;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(n,i){if(n==='\t'||h.isFullWidth(n.charCodeAt(0))){k=(n==='\t')?h.getScreenTabSize(i+j):2;j+=k-1;return l.stringRepeat(b.DOT,k);}return n;});if(this.isRtlDir){this.fontMetrics.$main.textContent=(this.line.charAt(this.line.length-1)==b.DOT)?this.line.substr(0,this.line.length-1):this.line;this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width;}};this.updateBidiMap=function(){var t=[];if(b.hasBidiCharacters(this.line,t)||this.isRtlDir){this.bidiMap=b.doBidiReorder(this.line,t,this.isRtlDir);}else{this.bidiMap={};}};this.markAsDirty=function(){this.currentRow=null;};this.updateCharacterWidths=function(f){if(this.characterWidth===f.$characterSize.width)return;this.fontMetrics=f;var c=this.characterWidth=f.$characterSize.width;var d=f.$measureCharWidth("\u05d4");this.charWidths[b.L]=this.charWidths[b.EN]=this.charWidths[b.ON_R]=c;this.charWidths[b.R]=this.charWidths[b.AN]=d;this.charWidths[b.R_H]=d*0.45;this.charWidths[b.B]=this.charWidths[b.RLE]=0;this.currentRow=null;};this.setShowInvisibles=function(s){this.showInvisibles=s;this.currentRow=null;};this.setEolChar=function(c){this.EOL=c;};this.setContentWidth=function(w){this.contentWidth=w;};this.isRtlLine=function(c){if(this.$isRtl)return true;if(c!=undefined)return(this.session.getLine(c).charAt(0)==this.RLE);else return this.isRtlDir;};this.setRtlDirection=function(c,i){var d=c.getCursorPosition();for(var f=c.selection.getSelectionAnchor().row;f<=d.row;f++){if(!i&&c.session.getLine(f).charAt(0)===c.session.$bidiHandler.RLE)c.session.doc.removeInLine(f,0,1);else if(i&&c.session.getLine(f).charAt(0)!==c.session.$bidiHandler.RLE)c.session.doc.insert({column:0,row:f},c.session.$bidiHandler.RLE);}};this.getPosLeft=function(c){c-=this.wrapIndent;var d=(this.line.charAt(0)===this.RLE)?1:0;var f=(c>d)?(this.session.getOverwrite()?c:c-1):d;var v=b.getVisualFromLogicalIdx(f,this.bidiMap),g=this.bidiMap.bidiLevels,h=0;if(!this.session.getOverwrite()&&c<=d&&g[v]%2!==0)v++;for(var i=0;i<v;i++){h+=this.charWidths[g[i]];}if(!this.session.getOverwrite()&&(c>d)&&(g[v]%2===0))h+=this.charWidths[g[v]];if(this.wrapIndent)h+=this.isRtlDir?(-1*this.wrapOffset):this.wrapOffset;if(this.isRtlDir)h+=this.rtlLineOffset;return h;};this.getSelections=function(s,c){var d=this.bidiMap,f=d.bidiLevels,g,h=[],o=0,j=Math.min(s,c)-this.wrapIndent,k=Math.max(s,c)-this.wrapIndent,n=false,p=false,q=0;if(this.wrapIndent)o+=this.isRtlDir?(-1*this.wrapOffset):this.wrapOffset;for(var t,v=0;v<f.length;v++){t=d.logicalFromVisual[v];g=f[v];n=(t>=j)&&(t<k);if(n&&!p){q=o;}else if(!n&&p){h.push({left:q,width:o-q});}o+=this.charWidths[g];p=n;}if(n&&(v===f.length)){h.push({left:q,width:o-q});}if(this.isRtlDir){for(var i=0;i<h.length;i++){h[i].left+=this.rtlLineOffset;}}return h;};this.offsetToCol=function(p){if(this.isRtlDir)p-=this.rtlLineOffset;var c=0,p=Math.max(p,0),o=0,v=0,d=this.bidiMap.bidiLevels,f=this.charWidths[d[v]];if(this.wrapIndent)p-=this.isRtlDir?(-1*this.wrapOffset):this.wrapOffset;while(p>o+f/2){o+=f;if(v===d.length-1){f=0;break;}f=this.charWidths[d[++v]];}if(v>0&&(d[v-1]%2!==0)&&(d[v]%2===0)){if(p<o)v--;c=this.bidiMap.logicalFromVisual[v];}else if(v>0&&(d[v-1]%2===0)&&(d[v]%2!==0)){c=1+((p>o)?this.bidiMap.logicalFromVisual[v]:this.bidiMap.logicalFromVisual[v-1]);}else if((this.isRtlDir&&v===d.length-1&&f===0&&(d[v-1]%2===0))||(!this.isRtlDir&&v===0&&(d[v]%2!==0))){c=1+this.bidiMap.logicalFromVisual[v];}else{if(v>0&&(d[v-1]%2!==0)&&f!==0)v--;c=this.bidiMap.logicalFromVisual[v];}if(c===0&&this.isRtlDir)c++;return(c+this.wrapIndent);};}).call(B.prototype);e.BidiHandler=B;});ace.define("ace/selection",[],function(a,b,m){"use strict";var o=a("./lib/oop");var c=a("./lib/lang");var E=a("./lib/event_emitter").EventEmitter;var R=a("./range").Range;var S=function(s){this.session=s;this.doc=s.getDocument();this.clearSelection();this.cursor=this.lead=this.doc.createAnchor(0,0);this.anchor=this.doc.createAnchor(0,0);this.$silent=false;var d=this;this.cursor.on("change",function(e){d.$cursorChanged=true;if(!d.$silent)d._emit("changeCursor");if(!d.$isEmpty&&!d.$silent)d._emit("changeSelection");if(!d.$keepDesiredColumnOnChange&&e.old.column!=e.value.column)d.$desiredColumn=null;});this.anchor.on("change",function(){d.$anchorChanged=true;if(!d.$isEmpty&&!d.$silent)d._emit("changeSelection");});};(function(){o.implement(this,E);this.isEmpty=function(){return this.$isEmpty||(this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column);};this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row;};this.getCursor=function(){return this.lead.getPosition();};this.setSelectionAnchor=function(r,d){this.$isEmpty=false;this.anchor.setPosition(r,d);};this.getAnchor=this.getSelectionAnchor=function(){if(this.$isEmpty)return this.getSelectionLead();return this.anchor.getPosition();};this.getSelectionLead=function(){return this.lead.getPosition();};this.isBackwards=function(){var d=this.anchor;var l=this.lead;return(d.row>l.row||(d.row==l.row&&d.column>l.column));};this.getRange=function(){var d=this.anchor;var l=this.lead;if(this.$isEmpty)return R.fromPoints(l,l);return this.isBackwards()?R.fromPoints(l,d):R.fromPoints(d,l);};this.clearSelection=function(){if(!this.$isEmpty){this.$isEmpty=true;this._emit("changeSelection");}};this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE);};this.setRange=this.setSelectionRange=function(r,d){var s=d?r.end:r.start;var e=d?r.start:r.end;this.$setSelection(s.row,s.column,e.row,e.column);};this.$setSelection=function(d,e,f,g){if(this.$silent)return;var w=this.$isEmpty;var h=this.inMultiSelectMode;this.$silent=true;this.$cursorChanged=this.$anchorChanged=false;this.anchor.setPosition(d,e);this.cursor.setPosition(f,g);this.$isEmpty=!R.comparePoints(this.anchor,this.cursor);this.$silent=false;if(this.$cursorChanged)this._emit("changeCursor");if(this.$cursorChanged||this.$anchorChanged||w!=this.$isEmpty||h)this._emit("changeSelection");};this.$moveSelection=function(d){var l=this.lead;if(this.$isEmpty)this.setSelectionAnchor(l.row,l.column);d.call(this);};this.selectTo=function(r,d){this.$moveSelection(function(){this.moveCursorTo(r,d);});};this.selectToPosition=function(p){this.$moveSelection(function(){this.moveCursorToPosition(p);});};this.moveTo=function(r,d){this.clearSelection();this.moveCursorTo(r,d);};this.moveToPosition=function(p){this.clearSelection();this.moveCursorToPosition(p);};this.selectUp=function(){this.$moveSelection(this.moveCursorUp);};this.selectDown=function(){this.$moveSelection(this.moveCursorDown);};this.selectRight=function(){this.$moveSelection(this.moveCursorRight);};this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft);};this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart);};this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd);};this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd);};this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart);};this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight);};this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft);};this.getWordRange=function(r,d){if(typeof d=="undefined"){var e=r||this.lead;r=e.row;d=e.column;}return this.session.getWordRange(r,d);};this.selectWord=function(){this.setSelectionRange(this.getWordRange());};this.selectAWord=function(){var d=this.getCursor();var r=this.session.getAWordRange(d.row,d.column);this.setSelectionRange(r);};this.getLineRange=function(r,e){var d=typeof r=="number"?r:this.lead.row;var f;var g=this.session.getFoldLine(d);if(g){d=g.start.row;f=g.end.row;}else{f=d;}if(e===true)return new R(d,0,f,this.session.getLine(f).length);else return new R(d,0,f+1,0);};this.selectLine=function(){this.setSelectionRange(this.getLineRange());};this.moveCursorUp=function(){this.moveCursorBy(-1,0);};this.moveCursorDown=function(){this.moveCursorBy(1,0);};this.wouldMoveIntoSoftTab=function(d,t,e){var s=d.column;var f=d.column+t;if(e<0){s=d.column-t;f=d.column;}return this.session.isTabStop(d)&&this.doc.getLine(d.row).slice(s,f).split(" ").length-1==t;};this.moveCursorLeft=function(){var d=this.lead.getPosition(),f;if(f=this.session.getFoldAt(d.row,d.column,-1)){this.moveCursorTo(f.start.row,f.start.column);}else if(d.column===0){if(d.row>0){this.moveCursorTo(d.row-1,this.doc.getLine(d.row-1).length);}}else{var t=this.session.getTabSize();if(this.wouldMoveIntoSoftTab(d,t,-1)&&!this.session.getNavigateWithinSoftTabs()){this.moveCursorBy(0,-t);}else{this.moveCursorBy(0,-1);}}};this.moveCursorRight=function(){var d=this.lead.getPosition(),f;if(f=this.session.getFoldAt(d.row,d.column,1)){this.moveCursorTo(f.end.row,f.end.column);}else if(this.lead.column==this.doc.getLine(this.lead.row).length){if(this.lead.row<this.doc.getLength()-1){this.moveCursorTo(this.lead.row+1,0);}}else{var t=this.session.getTabSize();var d=this.lead;if(this.wouldMoveIntoSoftTab(d,t,1)&&!this.session.getNavigateWithinSoftTabs()){this.moveCursorBy(0,t);}else{this.moveCursorBy(0,1);}}};this.moveCursorLineStart=function(){var r=this.lead.row;var d=this.lead.column;var s=this.session.documentToScreenRow(r,d);var f=this.session.screenToDocumentPosition(s,0);var e=this.session.getDisplayLine(r,null,f.row,f.column);var l=e.match(/^\s*/);if(l[0].length!=d&&!this.session.$useEmacsStyleLineStart)f.column+=l[0].length;this.moveCursorToPosition(f);};this.moveCursorLineEnd=function(){var l=this.lead;var d=this.session.getDocumentLastRowColumnPosition(l.row,l.column);if(this.lead.column==d.column){var e=this.session.getLine(d.row);if(d.column==e.length){var t=e.search(/\s+$/);if(t>0)d.column=t;}}this.moveCursorTo(d.row,d.column);};this.moveCursorFileEnd=function(){var r=this.doc.getLength()-1;var d=this.doc.getLine(r).length;this.moveCursorTo(r,d);};this.moveCursorFileStart=function(){this.moveCursorTo(0,0);};this.moveCursorLongWordRight=function(){var r=this.lead.row;var d=this.lead.column;var l=this.doc.getLine(r);var e=l.substring(d);this.session.nonTokenRe.lastIndex=0;this.session.tokenRe.lastIndex=0;var f=this.session.getFoldAt(r,d,1);if(f){this.moveCursorTo(f.end.row,f.end.column);return;}if(this.session.nonTokenRe.exec(e)){d+=this.session.nonTokenRe.lastIndex;this.session.nonTokenRe.lastIndex=0;e=l.substring(d);}if(d>=l.length){this.moveCursorTo(r,l.length);this.moveCursorRight();if(r<this.doc.getLength()-1)this.moveCursorWordRight();return;}if(this.session.tokenRe.exec(e)){d+=this.session.tokenRe.lastIndex;this.session.tokenRe.lastIndex=0;}this.moveCursorTo(r,d);};this.moveCursorLongWordLeft=function(){var r=this.lead.row;var d=this.lead.column;var f;if(f=this.session.getFoldAt(r,d,-1)){this.moveCursorTo(f.start.row,f.start.column);return;}var s=this.session.getFoldStringAt(r,d,-1);if(s==null){s=this.doc.getLine(r).substring(0,d);}var l=c.stringReverse(s);this.session.nonTokenRe.lastIndex=0;this.session.tokenRe.lastIndex=0;if(this.session.nonTokenRe.exec(l)){d-=this.session.nonTokenRe.lastIndex;l=l.slice(this.session.nonTokenRe.lastIndex);this.session.nonTokenRe.lastIndex=0;}if(d<=0){this.moveCursorTo(r,0);this.moveCursorLeft();if(r>0)this.moveCursorWordLeft();return;}if(this.session.tokenRe.exec(l)){d-=this.session.tokenRe.lastIndex;this.session.tokenRe.lastIndex=0;}this.moveCursorTo(r,d);};this.$shortWordEndIndex=function(r){var i=0,d;var w=/\s/;var t=this.session.tokenRe;t.lastIndex=0;if(this.session.tokenRe.exec(r)){i=this.session.tokenRe.lastIndex;}else{while((d=r[i])&&w.test(d))i++;if(i<1){t.lastIndex=0;while((d=r[i])&&!t.test(d)){t.lastIndex=0;i++;if(w.test(d)){if(i>2){i--;break;}else{while((d=r[i])&&w.test(d))i++;if(i>2)break;}}}}}t.lastIndex=0;return i;};this.moveCursorShortWordRight=function(){var r=this.lead.row;var d=this.lead.column;var e=this.doc.getLine(r);var f=e.substring(d);var g=this.session.getFoldAt(r,d,1);if(g)return this.moveCursorTo(g.end.row,g.end.column);if(d==e.length){var l=this.doc.getLength();do{r++;f=this.doc.getLine(r);}while(r<l&&/^\s*$/.test(f));if(!/^\s+/.test(f))f="";d=0;}var i=this.$shortWordEndIndex(f);this.moveCursorTo(r,d+i);};this.moveCursorShortWordLeft=function(){var r=this.lead.row;var d=this.lead.column;var f;if(f=this.session.getFoldAt(r,d,-1))return this.moveCursorTo(f.start.row,f.start.column);var l=this.session.getLine(r).substring(0,d);if(d===0){do{r--;l=this.doc.getLine(r);}while(r>0&&/^\s*$/.test(l));d=l.length;if(!/\s+$/.test(l))l="";}var e=c.stringReverse(l);var i=this.$shortWordEndIndex(e);return this.moveCursorTo(r,d-i);};this.moveCursorWordRight=function(){if(this.session.$selectLongWords)this.moveCursorLongWordRight();else this.moveCursorShortWordRight();};this.moveCursorWordLeft=function(){if(this.session.$selectLongWords)this.moveCursorLongWordLeft();else this.moveCursorShortWordLeft();};this.moveCursorBy=function(r,d){var s=this.session.documentToScreenPosition(this.lead.row,this.lead.column);var e;if(d===0){if(r!==0){if(this.session.$bidiHandler.isBidiRow(s.row,this.lead.row)){e=this.session.$bidiHandler.getPosLeft(s.column);s.column=Math.round(e/this.session.$bidiHandler.charWidths[0]);}else{e=s.column*this.session.$bidiHandler.charWidths[0];}}if(this.$desiredColumn)s.column=this.$desiredColumn;else this.$desiredColumn=s.column;}if(r!=0&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]){var w=this.session.lineWidgets[this.lead.row];if(r<0)r-=w.rowsAbove||0;else if(r>0)r+=w.rowCount-(w.rowsAbove||0);}var f=this.session.screenToDocumentPosition(s.row+r,s.column,e);if(r!==0&&d===0&&f.row===this.lead.row&&f.column===this.lead.column){}this.moveCursorTo(f.row,f.column+d,d===0);};this.moveCursorToPosition=function(p){this.moveCursorTo(p.row,p.column);};this.moveCursorTo=function(r,d,k){var f=this.session.getFoldAt(r,d,1);if(f){r=f.start.row;d=f.start.column;}this.$keepDesiredColumnOnChange=true;var l=this.session.getLine(r);if(/[\uDC00-\uDFFF]/.test(l.charAt(d))&&l.charAt(d-1)){if(this.lead.row==r&&this.lead.column==d+1)d=d-1;else d=d+1;}this.lead.setPosition(r,d);this.$keepDesiredColumnOnChange=false;if(!k)this.$desiredColumn=null;};this.moveCursorToScreen=function(r,d,k){var p=this.session.screenToDocumentPosition(r,d);this.moveCursorTo(p.row,p.column,k);};this.detach=function(){this.lead.detach();this.anchor.detach();};this.fromOrientedRange=function(r){this.setSelectionRange(r,r.cursor==r.start);this.$desiredColumn=r.desiredColumn||this.$desiredColumn;};this.toOrientedRange=function(d){var r=this.getRange();if(d){d.start.column=r.start.column;d.start.row=r.start.row;d.end.column=r.end.column;d.end.row=r.end.row;}else{d=r;}d.cursor=this.isBackwards()?d.start:d.end;d.desiredColumn=this.$desiredColumn;return d;};this.getRangeOfMovements=function(f){var s=this.getCursor();try{f(this);var d=this.getCursor();return R.fromPoints(s,d);}catch(e){return R.fromPoints(s,s);}finally{this.moveCursorToPosition(s);}};this.toJSON=function(){if(this.rangeCount){var d=this.ranges.map(function(r){var e=r.clone();e.isBackwards=r.cursor==r.start;return e;});}else{var d=this.getRange();d.isBackwards=this.isBackwards();}return d;};this.fromJSON=function(d){if(d.start==undefined){if(this.rangeList&&d.length>1){this.toSingleRange(d[0]);for(var i=d.length;i--;){var r=R.fromPoints(d[i].start,d[i].end);if(d[i].isBackwards)r.cursor=r.start;this.addRange(r,true);}return;}else{d=d[0];}}if(this.rangeList)this.toSingleRange(d);this.setSelectionRange(d,d.isBackwards);};this.isEqual=function(d){if((d.length||this.rangeCount)&&d.length!=this.rangeCount)return false;if(!d.length||!this.ranges)return this.getRange().isEqual(d);for(var i=this.ranges.length;i--;){if(!this.ranges[i].isEqual(d[i]))return false;}return true;};}).call(S.prototype);b.Selection=S;});ace.define("ace/tokenizer",[],function(a,e,b){"use strict";var c=a("./config");var M=2000;var T=function(r){this.states=r;this.regExps={};this.matchMappings={};for(var k in this.states){var s=this.states[k];var d=[];var m=0;var f=this.matchMappings[k]={defaultToken:"text"};var g="g";var h=[];for(var i=0;i<s.length;i++){var j=s[i];if(j.defaultToken)f.defaultToken=j.defaultToken;if(j.caseInsensitive)g="gi";if(j.regex==null)continue;if(j.regex instanceof RegExp)j.regex=j.regex.toString().slice(1,-1);var l=j.regex;var n=new RegExp("(?:("+l+")|(.))").exec("a").length-2;if(Array.isArray(j.token)){if(j.token.length==1||n==1){j.token=j.token[0];}else if(n-1!=j.token.length){this.reportError("number of classes and regexp groups doesn't match",{rule:j,groupCount:n-1});j.token=j.token[0];}else{j.tokenArray=j.token;j.token=null;j.onMatch=this.$arrayTokens;}}else if(typeof j.token=="function"&&!j.onMatch){if(n>1)j.onMatch=this.$applyToken;else j.onMatch=j.token;}if(n>1){if(/\\\d/.test(j.regex)){l=j.regex.replace(/\\([0-9]+)/g,function(o,p){return"\\"+(parseInt(p,10)+m+1);});}else{n=1;l=this.removeCapturingGroups(j.regex);}if(!j.splitRegex&&typeof j.token!="string")h.push(j);}f[m]=i;m+=n;d.push(l);if(!j.onMatch)j.onMatch=null;}if(!d.length){f[0]=0;d.push("$");}h.forEach(function(j){j.splitRegex=this.createSplitterRegexp(j.regex,g);},this);this.regExps[k]=new RegExp("("+d.join(")|(")+")|($)",g);}};(function(){this.$setMaxTokenCount=function(m){M=m|0;};this.$applyToken=function(s){var v=this.splitRegex.exec(s).slice(1);var t=this.token.apply(this,v);if(typeof t==="string")return[{type:t,value:s}];var d=[];for(var i=0,l=t.length;i<l;i++){if(v[i])d[d.length]={type:t[i],value:v[i]};}return d;};this.$arrayTokens=function(s){if(!s)return[];var v=this.splitRegex.exec(s);if(!v)return"text";var t=[];var d=this.tokenArray;for(var i=0,l=d.length;i<l;i++){if(v[i+1])t[t.length]={type:d[i],value:v[i+1]};}return t;};this.removeCapturingGroups=function(s){var r=s.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(x,y){return y?"(?:":x;});return r;};this.createSplitterRegexp=function(s,f){if(s.indexOf("(?=")!=-1){var d=0;var i=false;var l={};s.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(m,g,p,h,j,k){if(i){i=j!="]";}else if(j){i=true;}else if(h){if(d==l.stack){l.end=k+1;l.stack=-1;}d--;}else if(p){d++;if(p.length!=1){l.stack=d;l.start=k;}}return m;});if(l.end!=null&&/^\)*$/.test(s.substr(l.end)))s=s.substring(0,l.start)+s.substr(l.end);}if(s.charAt(0)!="^")s="^"+s;if(s.charAt(s.length-1)!="$")s+="$";return new RegExp(s,(f||"").replace("g",""));};this.getLineTokens=function(l,s){if(s&&typeof s!="string"){var d=s.slice(0);s=d[0];if(s==="#tmp"){d.shift();s=d.shift();}}else var d=[];var f=s||"start";var g=this.states[f];if(!g){f="start";g=this.states[f];}var m=this.matchMappings[f];var r=this.regExps[f];r.lastIndex=0;var h,t=[];var j=0;var k=0;var n={type:null,value:""};while(h=r.exec(l)){var o=m.defaultToken;var p=null;var v=h[0];var q=r.lastIndex;if(q-v.length>j){var u=l.substring(j,q-v.length);if(n.type==o){n.value+=u;}else{if(n.type)t.push(n);n={type:o,value:u};}}for(var i=0;i<h.length-2;i++){if(h[i+1]===undefined)continue;p=g[m[i]];if(p.onMatch)o=p.onMatch(v,f,d,l);else o=p.token;if(p.next){if(typeof p.next=="string"){f=p.next;}else{f=p.next(f,d);}g=this.states[f];if(!g){this.reportError("state doesn't exist",f);f="start";g=this.states[f];}m=this.matchMappings[f];j=q;r=this.regExps[f];r.lastIndex=q;}if(p.consumeLineEnd)j=q;break;}if(v){if(typeof o==="string"){if((!p||p.merge!==false)&&n.type===o){n.value+=v;}else{if(n.type)t.push(n);n={type:o,value:v};}}else if(o){if(n.type)t.push(n);n={type:null,value:""};for(var i=0;i<o.length;i++)t.push(o[i]);}}if(j==l.length)break;j=q;if(k++>M){if(k>2*l.length){this.reportError("infinite loop with in ace tokenizer",{startState:s,line:l});}while(j<l.length){if(n.type)t.push(n);n={value:l.substring(j,j+=500),type:"overflow"};}f="start";d=[];break;}}if(n.type)t.push(n);if(d.length>1){if(d[0]!==f)d.unshift("#tmp",f);}return{tokens:t,state:d.length?d:f};};this.reportError=c.reportError;}).call(T.prototype);e.Tokenizer=T;});ace.define("ace/mode/text_highlight_rules",[],function(b,e,m){"use strict";var l=b("../lib/lang");var T=function(){this.$rules={"start":[{token:"empty_line",regex:'^$'},{defaultToken:"text"}]};};(function(){this.addRules=function(r,a){if(!a){for(var k in r)this.$rules[k]=r[k];return;}for(var k in r){var s=r[k];for(var i=0;i<s.length;i++){var d=s[i];if(d.next||d.onMatch){if(typeof d.next=="string"){if(d.next.indexOf(a)!==0)d.next=a+d.next;}if(d.nextState&&d.nextState.indexOf(a)!==0)d.nextState=a+d.nextState;}}this.$rules[a+k]=s;}};this.getRules=function(){return this.$rules;};this.embedRules=function(H,a,d,s,f){var g=typeof H=="function"?new H().getRules():H;if(s){for(var i=0;i<s.length;i++)s[i]=a+s[i];}else{s=[];for(var k in g)s.push(a+k);}this.addRules(g,a);if(d){var h=Array.prototype[f?"push":"unshift"];for(var i=0;i<s.length;i++)h.apply(this.$rules[s[i]],l.deepCopy(d));}if(!this.$embeds)this.$embeds=[];this.$embeds.push(a);};this.getEmbeds=function(){return this.$embeds;};var p=function(a,s){if(a!="start"||s.length)s.unshift(this.nextState,a);return this.nextState;};var c=function(a,s){s.shift();return s.shift()||"start";};this.normalizeRules=function(){var a=0;var d=this.$rules;function f(k){var s=d[k];s.processed=true;for(var i=0;i<s.length;i++){var g=s[i];var t=null;if(Array.isArray(g)){t=g;g={};}if(!g.regex&&g.start){g.regex=g.start;if(!g.next)g.next=[];g.next.push({defaultToken:g.token},{token:g.token+".end",regex:g.end||g.start,next:"pop"});g.token=g.token+".start";g.push=true;}var n=g.next||g.push;if(n&&Array.isArray(n)){var h=g.stateName;if(!h){h=g.token;if(typeof h!="string")h=h[0]||"";if(d[h])h+=a++;}d[h]=n;g.next=h;f(h);}else if(n=="pop"){g.next=c;}if(g.push){g.nextState=g.next||g.push;g.next=p;delete g.push;}if(g.rules){for(var r in g.rules){if(d[r]){if(d[r].push)d[r].push.apply(d[r],g.rules[r]);}else{d[r]=g.rules[r];}}}var j=typeof g=="string"?g:g.include;if(j){if(Array.isArray(j))t=j.map(function(x){return d[x];});else t=d[j];}if(t){var o=[i,1].concat(t);if(g.noEscape)o=o.filter(function(x){return!x.next;});s.splice.apply(s,o);i--;}if(g.keywordMap){g.token=this.createKeywordMapper(g.keywordMap,g.defaultToken||"text",g.caseInsensitive);delete g.defaultToken;}}}Object.keys(d).forEach(f,this);};this.createKeywordMapper=function(d,f,g,s){var k=Object.create(null);this.$keywordList=[];Object.keys(d).forEach(function(h){var a=d[h];var j=a.split(s||"|");for(var i=j.length;i--;){var w=j[i];this.$keywordList.push(w);if(g)w=w.toLowerCase();k[w]=h;}},this);d=null;return g?function(v){return k[v.toLowerCase()]||f;}:function(v){return k[v]||f;};};this.getKeywords=function(){return this.$keywords;};}).call(T.prototype);e.TextHighlightRules=T;});ace.define("ace/mode/behaviour",[],function(r,e,m){"use strict";var B=function(){this.$behaviours={};};(function(){this.add=function(n,a,c){switch(undefined){case this.$behaviours:this.$behaviours={};case this.$behaviours[n]:this.$behaviours[n]={};}this.$behaviours[n][a]=c;};this.addBehaviours=function(b){for(var k in b){for(var a in b[k]){this.add(k,a,b[k][a]);}}};this.remove=function(n){if(this.$behaviours&&this.$behaviours[n]){delete this.$behaviours[n];}};this.inherit=function(a,f){if(typeof a==="function"){var b=new a().getBehaviours(f);}else{var b=a.getBehaviours(f);}this.addBehaviours(b);};this.getBehaviours=function(f){if(!f){return this.$behaviours;}else{var a={};for(var i=0;i<f.length;i++){if(this.$behaviours[f[i]]){a[f[i]]=this.$behaviours[f[i]];}}return a;}};}).call(B.prototype);e.Behaviour=B;});ace.define("ace/token_iterator",[],function(r,e,m){"use strict";var R=r("./range").Range;var T=function(s,i,a){this.$session=s;this.$row=i;this.$rowTokens=s.getTokens(i);var t=s.getTokenAt(i,a);this.$tokenIndex=t?t.index:-1;};(function(){this.stepBackward=function(){this.$tokenIndex-=1;while(this.$tokenIndex<0){this.$row-=1;if(this.$row<0){this.$row=0;return null;}this.$rowTokens=this.$session.getTokens(this.$row);this.$tokenIndex=this.$rowTokens.length-1;}return this.$rowTokens[this.$tokenIndex];};this.stepForward=function(){this.$tokenIndex+=1;var a;while(this.$tokenIndex>=this.$rowTokens.length){this.$row+=1;if(!a)a=this.$session.getLength();if(this.$row>=a){this.$row=a-1;return null;}this.$rowTokens=this.$session.getTokens(this.$row);this.$tokenIndex=0;}return this.$rowTokens[this.$tokenIndex];};this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex];};this.getCurrentTokenRow=function(){return this.$row;};this.getCurrentTokenColumn=function(){var a=this.$rowTokens;var t=this.$tokenIndex;var c=a[t].start;if(c!==undefined)return c;c=0;while(t>0){t-=1;c+=a[t].value.length;}return c;};this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()};};this.getCurrentTokenRange=function(){var t=this.$rowTokens[this.$tokenIndex];var c=this.getCurrentTokenColumn();return new R(this.$row,c,this.$row,c+t.value.length);};}).call(T.prototype);e.TokenIterator=T;});ace.define("ace/mode/behaviour/cstyle",[],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("../behaviour").Behaviour;var T=r("../../token_iterator").TokenIterator;var l=r("../../lib/lang");var S=["text","paren.rparen","rparen","paren","punctuation.operator"];var a=["text","paren.rparen","rparen","paren","punctuation.operator","comment"];var c;var b={};var d={'"':'"',"'":"'"};var i=function(f){var h=-1;if(f.multiSelect){h=f.selection.index;if(b.rangeCount!=f.multiSelect.rangeCount)b={rangeCount:f.multiSelect.rangeCount};}if(b[h])return c=b[h];c=b[h]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""};};var g=function(s,f,h,j){var k=s.end.row-s.start.row;return{text:h+f+j,selection:[0,s.start.column+1,k,s.end.column+(k?0:1)]};};var C=function(f){this.add("braces","insertion",function(s,h,j,k,t){var n=j.getCursorPosition();var p=k.doc.getLine(n.row);if(t=='{'){i(j);var q=j.getSelectionRange();var u=k.doc.getTextRange(q);if(u!==""&&u!=="{"&&j.getWrapBehavioursEnabled()){return g(q,u,'{','}');}else if(C.isSaneInsertion(j,k)){if(/[\]\}\)]/.test(p[n.column])||j.inMultiSelectMode||f&&f.braces){C.recordAutoInsert(j,k,"}");return{text:'{}',selection:[1,1]};}else{C.recordMaybeInsert(j,k,"{");return{text:'{',selection:[1,1]};}}}else if(t=='}'){i(j);var v=p.substring(n.column,n.column+1);if(v=='}'){var w=k.$findOpeningBracket('}',{column:n.column+1,row:n.row});if(w!==null&&C.isAutoInsertedClosing(n,p,t)){C.popAutoInsertedClosing();return{text:'',selection:[1,1]};}}}else if(t=="\n"||t=="\r\n"){i(j);var x="";if(C.isMaybeInsertedClosing(n,p)){x=l.stringRepeat("}",c.maybeInsertedBrackets);C.clearMaybeInsertedClosing();}var v=p.substring(n.column,n.column+1);if(v==='}'){var y=k.findMatchingBracket({row:n.row,column:n.column+1},'}');if(!y)return null;var z=this.$getIndent(k.getLine(y.row));}else if(x){var z=this.$getIndent(p);}else{C.clearMaybeInsertedClosing();return;}var A=z+k.getTabString();return{text:'\n'+A+'\n'+z+x,selection:[1,A.length,1,A.length]};}else{C.clearMaybeInsertedClosing();}});this.add("braces","deletion",function(s,h,j,k,n){var p=k.doc.getTextRange(n);if(!n.isMultiLine()&&p=='{'){i(j);var q=k.doc.getLine(n.start.row);var t=q.substring(n.end.column,n.end.column+1);if(t=='}'){n.end.column++;return n;}else{c.maybeInsertedBrackets--;}}});this.add("parens","insertion",function(s,h,j,k,t){if(t=='('){i(j);var n=j.getSelectionRange();var p=k.doc.getTextRange(n);if(p!==""&&j.getWrapBehavioursEnabled()){return g(n,p,'(',')');}else if(C.isSaneInsertion(j,k)){C.recordAutoInsert(j,k,")");return{text:'()',selection:[1,1]};}}else if(t==')'){i(j);var q=j.getCursorPosition();var u=k.doc.getLine(q.row);var v=u.substring(q.column,q.column+1);if(v==')'){var w=k.$findOpeningBracket(')',{column:q.column+1,row:q.row});if(w!==null&&C.isAutoInsertedClosing(q,u,t)){C.popAutoInsertedClosing();return{text:'',selection:[1,1]};}}}});this.add("parens","deletion",function(s,h,j,k,n){var p=k.doc.getTextRange(n);if(!n.isMultiLine()&&p=='('){i(j);var q=k.doc.getLine(n.start.row);var t=q.substring(n.start.column+1,n.start.column+2);if(t==')'){n.end.column++;return n;}}});this.add("brackets","insertion",function(s,h,j,k,t){if(t=='['){i(j);var n=j.getSelectionRange();var p=k.doc.getTextRange(n);if(p!==""&&j.getWrapBehavioursEnabled()){return g(n,p,'[',']');}else if(C.isSaneInsertion(j,k)){C.recordAutoInsert(j,k,"]");return{text:'[]',selection:[1,1]};}}else if(t==']'){i(j);var q=j.getCursorPosition();var u=k.doc.getLine(q.row);var v=u.substring(q.column,q.column+1);if(v==']'){var w=k.$findOpeningBracket(']',{column:q.column+1,row:q.row});if(w!==null&&C.isAutoInsertedClosing(q,u,t)){C.popAutoInsertedClosing();return{text:'',selection:[1,1]};}}}});this.add("brackets","deletion",function(s,h,j,k,n){var p=k.doc.getTextRange(n);if(!n.isMultiLine()&&p=='['){i(j);var q=k.doc.getLine(n.start.row);var t=q.substring(n.start.column+1,n.start.column+2);if(t==']'){n.end.column++;return n;}}});this.add("string_dquotes","insertion",function(s,h,j,k,t){var q=k.$mode.$quotes||d;if(t.length==1&&q[t]){if(this.lineCommentStart&&this.lineCommentStart.indexOf(t)!=-1)return;i(j);var n=t;var p=j.getSelectionRange();var u=k.doc.getTextRange(p);if(u!==""&&(u.length!=1||!q[u])&&j.getWrapBehavioursEnabled()){return g(p,u,n,n);}else if(!u){var v=j.getCursorPosition();var w=k.doc.getLine(v.row);var x=w.substring(v.column-1,v.column);var y=w.substring(v.column,v.column+1);var z=k.getTokenAt(v.row,v.column);var A=k.getTokenAt(v.row,v.column+1);if(x=="\\"&&z&&/escape/.test(z.type))return null;var D=z&&/string|escape/.test(z.type);var E=!A||/string|escape/.test(A.type);var F;if(y==n){F=D!==E;if(F&&/string\.end/.test(A.type))F=false;}else{if(D&&!E)return null;if(D&&E)return null;var G=k.$mode.tokenRe;G.lastIndex=0;var H=G.test(x);G.lastIndex=0;var I=G.test(x);if(H||I)return null;if(y&&!/[\s;,.})\]\\]/.test(y))return null;var J=w[v.column-2];if(x==n&&(J==n||G.test(J)))return null;F=true;}return{text:F?n+n:"",selection:[1,1]};}}});this.add("string_dquotes","deletion",function(s,h,j,k,n){var q=k.$mode.$quotes||d;var p=k.doc.getTextRange(n);if(!n.isMultiLine()&&q.hasOwnProperty(p)){i(j);var t=k.doc.getLine(n.start.row);var u=t.substring(n.start.column+1,n.start.column+2);if(u==p){n.end.column++;return n;}}});};C.isSaneInsertion=function(f,s){var h=f.getCursorPosition();var j=new T(s,h.row,h.column);if(!this.$matchTokenType(j.getCurrentToken()||"text",S)){if(/[)}\]]/.test(f.session.getLine(h.row)[h.column]))return true;var k=new T(s,h.row,h.column+1);if(!this.$matchTokenType(k.getCurrentToken()||"text",S))return false;}j.stepForward();return j.getCurrentTokenRow()!==h.row||this.$matchTokenType(j.getCurrentToken()||"text",a);};C.$matchTokenType=function(t,f){return f.indexOf(t.type||t)>-1;};C.recordAutoInsert=function(f,s,h){var j=f.getCursorPosition();var k=s.doc.getLine(j.row);if(!this.isAutoInsertedClosing(j,k,c.autoInsertedLineEnd[0]))c.autoInsertedBrackets=0;c.autoInsertedRow=j.row;c.autoInsertedLineEnd=h+k.substr(j.column);c.autoInsertedBrackets++;};C.recordMaybeInsert=function(f,s,h){var j=f.getCursorPosition();var k=s.doc.getLine(j.row);if(!this.isMaybeInsertedClosing(j,k))c.maybeInsertedBrackets=0;c.maybeInsertedRow=j.row;c.maybeInsertedLineStart=k.substr(0,j.column)+h;c.maybeInsertedLineEnd=k.substr(j.column);c.maybeInsertedBrackets++;};C.isAutoInsertedClosing=function(f,h,j){return c.autoInsertedBrackets>0&&f.row===c.autoInsertedRow&&j===c.autoInsertedLineEnd[0]&&h.substr(f.column)===c.autoInsertedLineEnd;};C.isMaybeInsertedClosing=function(f,h){return c.maybeInsertedBrackets>0&&f.row===c.maybeInsertedRow&&h.substr(f.column)===c.maybeInsertedLineEnd&&h.substr(0,f.column)==c.maybeInsertedLineStart;};C.popAutoInsertedClosing=function(){c.autoInsertedLineEnd=c.autoInsertedLineEnd.substr(1);c.autoInsertedBrackets--;};C.clearMaybeInsertedClosing=function(){if(c){c.maybeInsertedBrackets=0;c.maybeInsertedRow=-1;}};o.inherits(C,B);e.CstyleBehaviour=C;});ace.define("ace/unicode",[],function(r,e,m){"use strict";var w=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2];var c=0;var s=[];for(var i=0;i<w.length;i+=2){s.push(c+=w[i]);if(w[i+1])s.push(45,c+=w[i+1]);}e.wordChars=String.fromCharCode.apply(null,s);});ace.define("ace/mode/text",[],function(b,e,c){"use strict";var d=b("../config");var T=b("../tokenizer").Tokenizer;var f=b("./text_highlight_rules").TextHighlightRules;var C=b("./behaviour/cstyle").CstyleBehaviour;var u=b("../unicode");var g=b("../lib/lang");var h=b("../token_iterator").TokenIterator;var R=b("../range").Range;var M=function(){this.HighlightRules=f;};(function(){this.$defaultBehaviour=new C();this.tokenRe=new RegExp("^["+u.wordChars+"\\$_]+","g");this.nonTokenRe=new RegExp("^(?:[^"+u.wordChars+"\\$_]|\\s])+","g");this.getTokenizer=function(){if(!this.$tokenizer){this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig);this.$tokenizer=new T(this.$highlightRules.getRules());}return this.$tokenizer;};this.lineCommentStart="";this.blockComment="";this.toggleCommentLines=function(s,a,j,k){var l=a.doc;var n=true;var o=true;var p=Infinity;var t=a.getTabSize();var q=false;if(!this.lineCommentStart){if(!this.blockComment)return false;var r=this.blockComment.start;var v=this.blockComment.end;var w=new RegExp("^(\\s*)(?:"+g.escapeRegExp(r)+")");var x=new RegExp("(?:"+g.escapeRegExp(v)+")\\s*$");var y=function(m,i){if(A(m,i))return;if(!n||/\S/.test(m)){l.insertInLine({row:i,column:m.length},v);l.insertInLine({row:i,column:p},r);}};var z=function(G,i){var m;if(m=G.match(x))l.removeInLine(i,G.length-m[0].length,G.length);if(m=G.match(w))l.removeInLine(i,m[1].length,m[0].length);};var A=function(m,G){if(w.test(m))return true;var H=a.getTokens(G);for(var i=0;i<H.length;i++){if(H[i].type==="comment")return true;}};}else{if(Array.isArray(this.lineCommentStart)){var w=this.lineCommentStart.map(g.escapeRegExp).join("|");var r=this.lineCommentStart[0];}else{var w=g.escapeRegExp(this.lineCommentStart);var r=this.lineCommentStart;}w=new RegExp("^(\\s*)(?:"+w+") ?");q=a.getUseSoftTabs();var z=function(G,i){var m=G.match(w);if(!m)return;var H=m[1].length,I=m[0].length;if(!D(G,H,I)&&m[0][I-1]==" ")I--;l.removeInLine(i,H,I);};var B=r+" ";var y=function(m,i){if(!n||/\S/.test(m)){if(D(m,p,p))l.insertInLine({row:i,column:p},B);else l.insertInLine({row:i,column:p},r);}};var A=function(m,i){return w.test(m);};var D=function(i,m,G){var H=0;while(m--&&i.charAt(m)==" ")H++;if(H%t!=0)return false;var H=0;while(i.charAt(G++)==" ")H++;if(t>2)return H%t!=t-1;else return H%t==0;};}function E(m){for(var i=j;i<=k;i++)m(l.getLine(i),i);}var F=Infinity;E(function(m,i){var G=m.search(/\S/);if(G!==-1){if(G<p)p=G;if(o&&!A(m,i))o=false;}else if(F>m.length){F=m.length;}});if(p==Infinity){p=F;n=false;o=false;}if(q&&p%t!=0)p=Math.floor(p/t)*t;E(o?z:y);};this.toggleBlockComment=function(s,a,r,j){var k=this.blockComment;if(!k)return;if(!k.start&&k[0])k=k[0];var l=new h(a,j.row,j.column);var t=l.getCurrentToken();var m=a.selection;var n=a.selection.toOrientedRange();var o,p;if(t&&/comment/.test(t.type)){var q,v;while(t&&/comment/.test(t.type)){var i=t.value.indexOf(k.start);if(i!=-1){var w=l.getCurrentTokenRow();var x=l.getCurrentTokenColumn()+i;q=new R(w,x,w,x+k.start.length);break;}t=l.stepBackward();}var l=new h(a,j.row,j.column);var t=l.getCurrentToken();while(t&&/comment/.test(t.type)){var i=t.value.indexOf(k.end);if(i!=-1){var w=l.getCurrentTokenRow();var x=l.getCurrentTokenColumn()+i;v=new R(w,x,w,x+k.end.length);break;}t=l.stepForward();}if(v)a.remove(v);if(q){a.remove(q);o=q.start.row;p=-k.start.length;}}else{p=k.start.length;o=r.start.row;a.insert(r.end,k.end);a.insert(r.start,k.start);}if(n.start.row==o)n.start.column+=p;if(n.end.row==o)n.end.column+=p;a.selection.fromOrientedRange(n);};this.getNextLineIndent=function(s,l,t){return this.$getIndent(l);};this.checkOutdent=function(s,l,i){return false;};this.autoOutdent=function(s,a,r){};this.$getIndent=function(l){return l.match(/^\s*/)[0];};this.createWorker=function(s){return null;};this.createModeDelegates=function(m){this.$embeds=[];this.$modes={};for(var i in m){if(m[i]){var M=m[i];var a=M.prototype.$id;var j=d.$modes[a];if(!j)d.$modes[a]=j=new M();if(!d.$modes[i])d.$modes[i]=j;this.$embeds.push(i);this.$modes[i]=j;}}var k=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"];for(var i=0;i<k.length;i++){(function(s){var l=k[i];var n=s[l];s[k[i]]=function(){return this.$delegator(l,arguments,n);};}(this));}};this.$delegator=function(m,a,j){var s=a[0]||"start";if(typeof s!="string"){if(Array.isArray(s[2])){var l=s[2][s[2].length-1];var k=this.$modes[l];if(k)return k[m].apply(k,[s[1]].concat([].slice.call(a,1)));}s=s[0]||"start";}for(var i=0;i<this.$embeds.length;i++){if(!this.$modes[this.$embeds[i]])continue;var n=s.split(this.$embeds[i]);if(!n[0]&&n[1]){a[0]=n[1];var k=this.$modes[this.$embeds[i]];return k[m].apply(k,a);}}var r=j.apply(this,a);return j?r:undefined;};this.transformAction=function(s,a,i,j,p){if(this.$behaviour){var k=this.$behaviour.getBehaviours();for(var l in k){if(k[l][a]){var r=k[l][a].apply(this,arguments);if(r){return r;}}}}};this.getKeywords=function(i){if(!this.completionKeywords){var j=this.$tokenizer.rules;var k=[];for(var m in j){var n=j[m];for(var r=0,l=n.length;r<l;r++){if(typeof n[r].token==="string"){if(/keyword|support|storage/.test(n[r].token))k.push(n[r].regex);}else if(typeof n[r].token==="object"){for(var a=0,L=n[r].token.length;a<L;a++){if(/keyword|support|storage/.test(n[r].token[a])){var m=n[r].regex.match(/\(.+?\)/g)[a];k.push(m.substr(1,m.length-2));}}}}}this.completionKeywords=k;}if(!i)return this.$keywordList;return k.concat(this.$keywordList||[]);};this.$createKeywordList=function(){if(!this.$highlightRules)this.getTokenizer();return this.$keywordList=this.$highlightRules.$keywordList||[];};this.getCompletions=function(s,a,p,i){var k=this.$keywordList||this.$createKeywordList();return k.map(function(w){return{name:w,value:w,score:0,meta:"keyword"};});};this.$id="ace/mode/text";}).call(M.prototype);e.Mode=M;});ace.define("ace/apply_delta",[],function(r,e,m){"use strict";function t(d,a){console.log("Invalid Delta:",d);throw"Invalid Delta: "+a;}function p(d,a){return a.row>=0&&a.row<d.length&&a.column>=0&&a.column<=d[a.row].length;}function v(d,a){if(a.action!="insert"&&a.action!="remove")t(a,"delta.action must be 'insert' or 'remove'");if(!(a.lines instanceof Array))t(a,"delta.lines must be an Array");if(!a.start||!a.end)t(a,"delta.start/end must be an present");var s=a.start;if(!p(d,a.start))t(a,"delta.start must be contained in document");var b=a.end;if(a.action=="remove"&&!p(d,b))t(a,"delta.end must contained in document for 'remove' actions");var n=b.row-s.row;var c=(b.column-(n==0?s.column:0));if(n!=a.lines.length-1||a.lines[n].length!=c)t(a,"delta.range must match delta lines");}e.applyDelta=function(d,a,b){var c=a.start.row;var s=a.start.column;var l=d[c]||"";switch(a.action){case"insert":var f=a.lines;if(f.length===1){d[c]=l.substring(0,s)+a.lines[0]+l.substring(s);}else{var g=[c,1].concat(a.lines);d.splice.apply(d,g);d[c]=l.substring(0,s)+d[c];d[c+a.lines.length-1]+=l.substring(s);}break;case"remove":var h=a.end.column;var i=a.end.row;if(c===i){d[c]=l.substring(0,s)+l.substring(h);}else{d.splice(c,i-c+1,l.substring(0,s)+d[i].substring(h));}break;}};});ace.define("ace/anchor",[],function(r,e,m){"use strict";var o=r("./lib/oop");var E=r("./lib/event_emitter").EventEmitter;var A=e.Anchor=function(d,a,c){this.$onChange=this.onChange.bind(this);this.attach(d);if(typeof c=="undefined")this.setPosition(a.row,a.column);else this.setPosition(a,c);};(function(){o.implement(this,E);this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column);};this.getDocument=function(){return this.document;};this.$insertRight=false;this.onChange=function(d){if(d.start.row==d.end.row&&d.start.row!=this.row)return;if(d.start.row>this.row)return;var p=a(d,{row:this.row,column:this.column},this.$insertRight);this.setPosition(p.row,p.column,true);};function $(p,b,c){var C=c?p.column<=b.column:p.column<b.column;return(p.row<b.row)||(p.row==b.row&&C);}function a(d,p,b){var c=d.action=="insert";var f=(c?1:-1)*(d.end.row-d.start.row);var g=(c?1:-1)*(d.end.column-d.start.column);var h=d.start;var i=c?h:d.end;if($(p,h,b)){return{row:p.row,column:p.column};}if($(i,p,!b)){return{row:p.row+f,column:p.column+(p.row==i.row?g:0)};}return{row:h.row,column:h.column};}this.setPosition=function(b,c,n){var p;if(n){p={row:b,column:c};}else{p=this.$clipPositionToDocument(b,c);}if(this.row==p.row&&this.column==p.column)return;var d={row:this.row,column:this.column};this.row=p.row;this.column=p.column;this._signal("change",{old:d,value:p});};this.detach=function(){this.document.off("change",this.$onChange);};this.attach=function(d){this.document=d||this.document;this.document.on("change",this.$onChange);};this.$clipPositionToDocument=function(b,c){var p={};if(b>=this.document.getLength()){p.row=Math.max(0,this.document.getLength()-1);p.column=this.document.getLine(p.row).length;}else if(b<0){p.row=0;p.column=0;}else{p.row=b;p.column=Math.min(this.document.getLine(p.row).length,Math.max(0,c));}if(c<0)p.column=0;return p;};}).call(A.prototype);});ace.define("ace/document",[],function(r,e,m){"use strict";var o=r("./lib/oop");var a=r("./apply_delta").applyDelta;var E=r("./lib/event_emitter").EventEmitter;var R=r("./range").Range;var A=r("./anchor").Anchor;var D=function(t){this.$lines=[""];if(t.length===0){this.$lines=[""];}else if(Array.isArray(t)){this.insertMergedLines({row:0,column:0},t);}else{this.insert({row:0,column:0},t);}};(function(){o.implement(this,E);this.setValue=function(t){var l=this.getLength()-1;this.remove(new R(0,0,l,this.getLine(l).length));this.insert({row:0,column:0},t);};this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter());};this.createAnchor=function(b,c){return new A(this,b,c);};if("aaa".split(/a/).length===0){this.$split=function(t){return t.replace(/\r\n|\r/g,"\n").split("\n");};}else{this.$split=function(t){return t.split(/\r\n|\r|\n/);};}this.$detectNewLine=function(t){var b=t.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=b?b[1]:"\n";this._signal("changeNewLineMode");};this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n";}};this.$autoNewLine="";this.$newLineMode="auto";this.setNewLineMode=function(n){if(this.$newLineMode===n)return;this.$newLineMode=n;this._signal("changeNewLineMode");};this.getNewLineMode=function(){return this.$newLineMode;};this.isNewLine=function(t){return(t=="\r\n"||t=="\r"||t=="\n");};this.getLine=function(b){return this.$lines[b]||"";};this.getLines=function(f,l){return this.$lines.slice(f,l+1);};this.getAllLines=function(){return this.getLines(0,this.getLength());};this.getLength=function(){return this.$lines.length;};this.getTextRange=function(b){return this.getLinesForRange(b).join(this.getNewLineCharacter());};this.getLinesForRange=function(b){var c;if(b.start.row===b.end.row){c=[this.getLine(b.start.row).substring(b.start.column,b.end.column)];}else{c=this.getLines(b.start.row,b.end.row);c[0]=(c[0]||"").substring(b.start.column);var l=c.length-1;if(b.end.row-b.start.row==l)c[l]=c[l].substring(0,b.end.column);}return c;};this.insertLines=function(b,l){console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead.");return this.insertFullLines(b,l);};this.removeLines=function(f,l){console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead.");return this.removeFullLines(f,l);};this.insertNewLine=function(p){console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead.");return this.insertMergedLines(p,["",""]);};this.insert=function(p,t){if(this.getLength()<=1)this.$detectNewLine(t);return this.insertMergedLines(p,this.$split(t));};this.insertInLine=function(p,t){var s=this.clippedPos(p.row,p.column);var b=this.pos(p.row,p.column+t.length);this.applyDelta({start:s,end:b,action:"insert",lines:[t]},true);return this.clonePos(b);};this.clippedPos=function(b,c){var l=this.getLength();if(b===undefined){b=l;}else if(b<0){b=0;}else if(b>=l){b=l-1;c=undefined;}var d=this.getLine(b);if(c==undefined)c=d.length;c=Math.min(Math.max(c,0),d.length);return{row:b,column:c};};this.clonePos=function(p){return{row:p.row,column:p.column};};this.pos=function(b,c){return{row:b,column:c};};this.$clipPosition=function(p){var l=this.getLength();if(p.row>=l){p.row=Math.max(0,l-1);p.column=this.getLine(l-1).length;}else{p.row=Math.max(0,p.row);p.column=Math.min(Math.max(p.column,0),this.getLine(p.row).length);}return p;};this.insertFullLines=function(b,l){b=Math.min(Math.max(b,0),this.getLength());var c=0;if(b<this.getLength()){l=l.concat([""]);c=0;}else{l=[""].concat(l);b--;c=this.$lines[b].length;}this.insertMergedLines({row:b,column:c},l);};this.insertMergedLines=function(p,l){var s=this.clippedPos(p.row,p.column);var b={row:s.row+l.length-1,column:(l.length==1?s.column:0)+l[l.length-1].length};this.applyDelta({start:s,end:b,action:"insert",lines:l});return this.clonePos(b);};this.remove=function(b){var s=this.clippedPos(b.start.row,b.start.column);var c=this.clippedPos(b.end.row,b.end.column);this.applyDelta({start:s,end:c,action:"remove",lines:this.getLinesForRange({start:s,end:c})});return this.clonePos(s);};this.removeInLine=function(b,s,c){var d=this.clippedPos(b,s);var f=this.clippedPos(b,c);this.applyDelta({start:d,end:f,action:"remove",lines:this.getLinesForRange({start:d,end:f})},true);return this.clonePos(d);};this.removeFullLines=function(f,l){f=Math.min(Math.max(0,f),this.getLength()-1);l=Math.min(Math.max(0,l),this.getLength()-1);var d=l==this.getLength()-1&&f>0;var b=l<this.getLength()-1;var s=(d?f-1:f);var c=(d?this.getLine(s).length:0);var g=(b?l+1:l);var h=(b?0:this.getLine(g).length);var i=new R(s,c,g,h);var j=this.$lines.slice(f,l+1);this.applyDelta({start:i.start,end:i.end,action:"remove",lines:this.getLinesForRange(i)});return j;};this.removeNewLine=function(b){if(b<this.getLength()-1&&b>=0){this.applyDelta({start:this.pos(b,this.getLine(b).length),end:this.pos(b+1,0),action:"remove",lines:["",""]});}};this.replace=function(b,t){if(!(b instanceof R))b=R.fromPoints(b.start,b.end);if(t.length===0&&b.isEmpty())return b.start;if(t==this.getTextRange(b))return b.end;this.remove(b);var c;if(t){c=this.insert(b.start,t);}else{c=b.start;}return c;};this.applyDeltas=function(d){for(var i=0;i<d.length;i++){this.applyDelta(d[i]);}};this.revertDeltas=function(d){for(var i=d.length-1;i>=0;i--){this.revertDelta(d[i]);}};this.applyDelta=function(d,b){var i=d.action=="insert";if(i?d.lines.length<=1&&!d.lines[0]:!R.comparePoints(d.start,d.end)){return;}if(i&&d.lines.length>20000){this.$splitAndapplyLargeDelta(d,20000);}else{a(this.$lines,d,b);this._signal("change",d);}};this.$safeApplyDelta=function(d){var b=this.$lines.length;if(d.action=="remove"&&d.start.row<b&&d.end.row<b||d.action=="insert"&&d.start.row<=b){this.applyDelta(d);}};this.$splitAndapplyLargeDelta=function(d,M){var b=d.lines;var l=b.length-M+1;var c=d.start.row;var f=d.start.column;for(var g=0,t=0;g<l;g=t){t+=M-1;var h=b.slice(g,t);h.push("");this.applyDelta({start:this.pos(c+g,f),end:this.pos(c+t,f=0),action:d.action,lines:h},true);}d.lines=b.slice(g);d.start.row=c+g;d.start.column=f;this.applyDelta(d,true);};this.revertDelta=function(d){this.$safeApplyDelta({start:this.clonePos(d.start),end:this.clonePos(d.end),action:(d.action=="insert"?"remove":"insert"),lines:d.lines.slice()});};this.indexToPosition=function(b,s){var c=this.$lines||this.getAllLines();var n=this.getNewLineCharacter().length;for(var i=s||0,l=c.length;i<l;i++){b-=c[i].length+n;if(b<0)return{row:i,column:b+c[i].length+n};}return{row:l-1,column:b+c[l-1].length+n};};this.positionToIndex=function(p,s){var l=this.$lines||this.getAllLines();var n=this.getNewLineCharacter().length;var b=0;var c=Math.min(p.row,l.length);for(var i=s||0;i<c;++i)b+=l[i].length+n;return b+p.column;};}).call(D.prototype);e.Document=D;});ace.define("ace/background_tokenizer",[],function(r,e,m){"use strict";var o=r("./lib/oop");var E=r("./lib/event_emitter").EventEmitter;var B=function(t,a){this.running=false;this.lines=[];this.states=[];this.currentLine=0;this.tokenizer=t;var s=this;this.$worker=function(){if(!s.running){return;}var w=new Date();var c=s.currentLine;var b=-1;var d=s.doc;var f=c;while(s.lines[c])c++;var l=d.getLength();var p=0;s.running=false;while(c<l){s.$tokenizeRow(c);b=c;do{c++;}while(s.lines[c]);p++;if((p%5===0)&&(new Date()-w)>20){s.running=setTimeout(s.$worker,20);break;}}s.currentLine=c;if(b==-1)b=c;if(f<=b)s.fireUpdateEvent(f,b);};};(function(){o.implement(this,E);this.setTokenizer=function(t){this.tokenizer=t;this.lines=[];this.states=[];this.start(0);};this.setDocument=function(d){this.doc=d;this.lines=[];this.states=[];this.stop();};this.fireUpdateEvent=function(f,l){var d={first:f,last:l};this._signal("update",{data:d});};this.start=function(s){this.currentLine=Math.min(s||0,this.currentLine,this.doc.getLength());this.lines.splice(this.currentLine,this.lines.length);this.states.splice(this.currentLine,this.states.length);this.stop();this.running=setTimeout(this.$worker,700);};this.scheduleStart=function(){if(!this.running)this.running=setTimeout(this.$worker,700);};this.$updateOnChange=function(d){var s=d.start.row;var l=d.end.row-s;if(l===0){this.lines[s]=null;}else if(d.action=="remove"){this.lines.splice(s,l+1,null);this.states.splice(s,l+1,null);}else{var a=Array(l+1);a.unshift(s,1);this.lines.splice.apply(this.lines,a);this.states.splice.apply(this.states,a);}this.currentLine=Math.min(s,this.currentLine,this.doc.getLength());this.stop();};this.stop=function(){if(this.running)clearTimeout(this.running);this.running=false;};this.getTokens=function(a){return this.lines[a]||this.$tokenizeRow(a);};this.getState=function(a){if(this.currentLine==a)this.$tokenizeRow(a);return this.states[a]||"start";};this.$tokenizeRow=function(a){var l=this.doc.getLine(a);var s=this.states[a-1];var d=this.tokenizer.getLineTokens(l,s,a);if(this.states[a]+""!==d.state+""){this.states[a]=d.state;this.lines[a+1]=null;if(this.currentLine>a+1)this.currentLine=a+1;}else if(this.currentLine==a){this.currentLine=a+1;}return this.lines[a]=d.tokens;};}).call(B.prototype);e.BackgroundTokenizer=B;});ace.define("ace/search_highlight",[],function(r,e,m){"use strict";var l=r("./lib/lang");var o=r("./lib/oop");var R=r("./range").Range;var S=function(a,c,t){this.setRegexp(a);this.clazz=c;this.type=t||"text";};(function(){this.MAX_RANGES=500;this.setRegexp=function(a){if(this.regExp+""==a+"")return;this.regExp=a;this.cache=[];};this.update=function(h,a,s,c){if(!this.regExp)return;var b=c.firstRow,d=c.lastRow;for(var i=b;i<=d;i++){var f=this.cache[i];if(f==null){f=l.getMatchOffsets(s.getLine(i),this.regExp);if(f.length>this.MAX_RANGES)f=f.slice(0,this.MAX_RANGES);f=f.map(function(g){return new R(i,g.offset,i,g.offset+g.length);});this.cache[i]=f.length?f:"";}for(var j=f.length;j--;){a.drawSingleLineMarker(h,f[j].toScreenRange(s),this.clazz,c);}}};}).call(S.prototype);e.SearchHighlight=S;});ace.define("ace/edit_session/fold_line",[],function(r,e,m){"use strict";var R=r("../range").Range;function F(f,a){this.foldData=f;if(Array.isArray(a)){this.folds=a;}else{a=this.folds=[a];}var l=a[a.length-1];this.range=new R(a[0].start.row,a[0].start.column,l.end.row,l.end.column);this.start=this.range.start;this.end=this.range.end;this.folds.forEach(function(b){b.setFoldLine(this);},this);}(function(){this.shiftRow=function(s){this.start.row+=s;this.end.row+=s;this.folds.forEach(function(f){f.start.row+=s;f.end.row+=s;});};this.addFold=function(f){if(f.sameRow){if(f.start.row<this.startRow||f.endRow>this.endRow){throw new Error("Can't add a fold to this FoldLine as it has no connection");}this.folds.push(f);this.folds.sort(function(a,b){return-a.range.compareEnd(b.start.row,b.start.column);});if(this.range.compareEnd(f.start.row,f.start.column)>0){this.end.row=f.end.row;this.end.column=f.end.column;}else if(this.range.compareStart(f.end.row,f.end.column)<0){this.start.row=f.start.row;this.start.column=f.start.column;}}else if(f.start.row==this.end.row){this.folds.push(f);this.end.row=f.end.row;this.end.column=f.end.column;}else if(f.end.row==this.start.row){this.folds.unshift(f);this.start.row=f.start.row;this.start.column=f.start.column;}else{throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");}f.foldLine=this;};this.containsRow=function(a){return a>=this.start.row&&a<=this.end.row;};this.walk=function(c,a,b){var l=0,f=this.folds,d,g,s,h=true;if(a==null){a=this.end.row;b=this.end.column;}for(var i=0;i<f.length;i++){d=f[i];g=d.range.compareStart(a,b);if(g==-1){c(null,a,b,l,h);return;}s=c(null,d.start.row,d.start.column,l,h);s=!s&&c(d.placeholder,d.start.row,d.start.column,l);if(s||g===0){return;}h=!d.sameRow;l=d.end.column;}c(null,a,b,l,h);};this.getNextFoldTo=function(a,c){var f,b;for(var i=0;i<this.folds.length;i++){f=this.folds[i];b=f.range.compareEnd(a,c);if(b==-1){return{fold:f,kind:"after"};}else if(b===0){return{fold:f,kind:"inside"};}}return null;};this.addRemoveChars=function(a,c,l){var b=this.getNextFoldTo(a,c),f,d;if(b){f=b.fold;if(b.kind=="inside"&&f.start.column!=c&&f.start.row!=a){window.console&&window.console.log(a,c,f);}else if(f.start.row==a){d=this.folds;var i=d.indexOf(f);if(i===0){this.start.column+=l;}for(i;i<d.length;i++){f=d[i];f.start.column+=l;if(!f.sameRow){return;}f.end.column+=l;}this.end.column+=l;}}};this.split=function(a,c){var p=this.getNextFoldTo(a,c);if(!p||p.kind=="inside")return null;var f=p.fold;var b=this.folds;var d=this.foldData;var i=b.indexOf(f);var g=b[i-1];this.end.row=g.end.row;this.end.column=g.end.column;b=b.splice(i,b.length-i);var n=new F(d,b);d.splice(d.indexOf(this)+1,0,n);return n;};this.merge=function(f){var a=f.folds;for(var i=0;i<a.length;i++){this.addFold(a[i]);}var b=this.foldData;b.splice(b.indexOf(f),1);};this.toString=function(){var a=[this.range.toString()+": ["];this.folds.forEach(function(f){a.push("  "+f.toString());});a.push("]");return a.join("\n");};this.idxToPosition=function(a){var l=0;for(var i=0;i<this.folds.length;i++){var f=this.folds[i];a-=f.start.column-l;if(a<0){return{row:f.start.row,column:f.start.column+a};}a-=f.placeholder.length;if(a<0){return f.start;}l=f.end.column;}return{row:this.end.row,column:this.end.column+a};};}).call(F.prototype);e.FoldLine=F;});ace.define("ace/range_list",[],function(c,e,m){"use strict";var R=c("./range").Range;var d=R.comparePoints;var f=function(){this.ranges=[];this.$bias=1;};(function(){this.comparePoints=d;this.pointIndex=function(p,a,s){var l=this.ranges;for(var i=s||0;i<l.length;i++){var r=l[i];var b=d(p,r.end);if(b>0)continue;var g=d(p,r.start);if(b===0)return a&&g!==0?-i-2:i;if(g>0||(g===0&&!a))return i;return-i-1;}return-i-1;};this.add=function(r){var a=!r.isEmpty();var s=this.pointIndex(r.start,a);if(s<0)s=-s-1;var b=this.pointIndex(r.end,a,s);if(b<0)b=-b-1;else b++;return this.ranges.splice(s,b-s,r);};this.addList=function(l){var r=[];for(var i=l.length;i--;){r.push.apply(r,this.add(l[i]));}return r;};this.substractPoint=function(p){var i=this.pointIndex(p);if(i>=0)return this.ranges.splice(i,1);};this.merge=function(){var r=[];var l=this.ranges;l=l.sort(function(a,b){return d(a.start,b.start);});var n=l[0],g;for(var i=1;i<l.length;i++){g=n;n=l[i];var h=d(g.end,n.start);if(h<0)continue;if(h==0&&!g.isEmpty()&&!n.isEmpty())continue;if(d(g.end,n.end)<0){g.end.row=n.end.row;g.end.column=n.end.column;}l.splice(i,1);r.push(n);n=g;i--;}this.ranges=l;return r;};this.contains=function(r,a){return this.pointIndex({row:r,column:a})>=0;};this.containsPoint=function(p){return this.pointIndex(p)>=0;};this.rangeAtPoint=function(p){var i=this.pointIndex(p);if(i>=0)return this.ranges[i];};this.clipRows=function(s,a){var l=this.ranges;if(l[0].start.row>a||l[l.length-1].start.row<s)return[];var b=this.pointIndex({row:s,column:0});if(b<0)b=-b-1;var g=this.pointIndex({row:a,column:0},b);if(g<0)g=-g-1;var h=[];for(var i=b;i<g;i++){h.push(l[i]);}return h;};this.removeAll=function(){return this.ranges.splice(0,this.ranges.length);};this.attach=function(s){if(this.session)this.detach();this.session=s;this.onChange=this.$onChange.bind(this);this.session.on('change',this.onChange);};this.detach=function(){if(!this.session)return;this.session.removeListener('change',this.onChange);this.session=null;};this.$onChange=function(a){var s=a.start;var b=a.end;var g=s.row;var h=b.row;var j=this.ranges;for(var i=0,n=j.length;i<n;i++){var r=j[i];if(r.end.row>=g)break;}if(a.action=="insert"){var l=h-g;var k=-s.column+b.column;for(;i<n;i++){var r=j[i];if(r.start.row>g)break;if(r.start.row==g&&r.start.column>=s.column){if(r.start.column==s.column&&this.$bias<=0){}else{r.start.column+=k;r.start.row+=l;}}if(r.end.row==g&&r.end.column>=s.column){if(r.end.column==s.column&&this.$bias<0){continue;}if(r.end.column==s.column&&k>0&&i<n-1){if(r.end.column>r.start.column&&r.end.column==j[i+1].start.column)r.end.column-=k;}r.end.column+=k;r.end.row+=l;}}}else{var l=g-h;var k=s.column-b.column;for(;i<n;i++){var r=j[i];if(r.start.row>h)break;if(r.end.row<h&&(g<r.end.row||g==r.end.row&&s.column<r.end.column)){r.end.row=g;r.end.column=s.column;}else if(r.end.row==h){if(r.end.column<=b.column){if(l||r.end.column>s.column){r.end.column=s.column;r.end.row=s.row;}}else{r.end.column+=k;r.end.row+=l;}}else if(r.end.row>h){r.end.row+=l;}if(r.start.row<h&&(g<r.start.row||g==r.start.row&&s.column<r.start.column)){r.start.row=g;r.start.column=s.column;}else if(r.start.row==h){if(r.start.column<=b.column){if(l||r.start.column>s.column){r.start.column=s.column;r.start.row=s.row;}}else{r.start.column+=k;r.start.row+=l;}}else if(r.start.row>h){r.start.row+=l;}}}if(l!=0&&i<n){for(;i<n;i++){var r=j[i];r.start.row+=l;r.end.row+=l;}}};}).call(f.prototype);e.RangeList=f;});ace.define("ace/edit_session/fold",[],function(r,e,m){"use strict";var R=r("../range_list").RangeList;var o=r("../lib/oop");var F=e.Fold=function(f,p){this.foldLine=null;this.placeholder=p;this.range=f;this.start=f.start;this.end=f.end;this.sameRow=f.start.row==f.end.row;this.subFolds=this.ranges=[];};o.inherits(F,R);(function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString();};this.setFoldLine=function(f){this.foldLine=f;this.subFolds.forEach(function(g){g.setFoldLine(f);});};this.clone=function(){var f=this.range.clone();var g=new F(f,this.placeholder);this.subFolds.forEach(function(s){g.subFolds.push(s.clone());});g.collapseChildren=this.collapseChildren;return g;};this.addSubFold=function(f){if(this.range.isEqual(f))return;a(f,this.start);var g=f.start.row,h=f.start.column;for(var i=0,l=-1;i<this.subFolds.length;i++){l=this.subFolds[i].range.compare(g,h);if(l!=1)break;}var n=this.subFolds[i];var p=0;if(l==0){if(n.range.containsRange(f))return n.addSubFold(f);else p=1;}var g=f.range.end.row,h=f.range.end.column;for(var j=i,l=-1;j<this.subFolds.length;j++){l=this.subFolds[j].range.compare(g,h);if(l!=1)break;}if(l==0)j++;var q=this.subFolds.splice(i,j-i,f);var s=l==0?q.length-1:q.length;for(var k=p;k<s;k++){f.addSubFold(q[k]);}f.setFoldLine(this.foldLine);return f;};this.restoreRange=function(f){return d(f,this.start);};}).call(F.prototype);function c(p,f){p.row-=f.row;if(p.row==0)p.column-=f.column;}function a(f,g){c(f.start,g);c(f.end,g);}function b(p,f){if(p.row==0)p.column+=f.column;p.row+=f.row;}function d(f,g){b(f.start,g);b(f.end,g);}});ace.define("ace/edit_session/folding",[],function(r,d,m){"use strict";var R=r("../range").Range;var F=r("./fold_line").FoldLine;var f=r("./fold").Fold;var T=r("../token_iterator").TokenIterator;function g(){this.getFoldAt=function(a,c,s){var b=this.getFoldLine(a);if(!b)return null;var e=b.folds;for(var i=0;i<e.length;i++){var h=e[i].range;if(h.contains(a,c)){if(s==1&&h.isEnd(a,c)&&!h.isEmpty()){continue;}else if(s==-1&&h.isStart(a,c)&&!h.isEmpty()){continue;}return e[i];}}};this.getFoldsInRange=function(a){var s=a.start;var e=a.end;var b=this.$foldData;var c=[];s.column+=1;e.column-=1;for(var i=0;i<b.length;i++){var h=b[i].range.compareRange(a);if(h==2){continue;}else if(h==-2){break;}var k=b[i].folds;for(var j=0;j<k.length;j++){var l=k[j];h=l.range.compareRange(a);if(h==-2){break;}else if(h==2){continue;}else if(h==42){break;}c.push(l);}}s.column-=1;e.column+=1;return c;};this.getFoldsInRangeList=function(a){if(Array.isArray(a)){var b=[];a.forEach(function(c){b=b.concat(this.getFoldsInRange(c));},this);}else{var b=this.getFoldsInRange(a);}return b;};this.getAllFolds=function(){var a=[];var b=this.$foldData;for(var i=0;i<b.length;i++)for(var j=0;j<b[i].folds.length;j++)a.push(b[i].folds[j]);return a;};this.getFoldStringAt=function(a,c,t,b){b=b||this.getFoldLine(a);if(!b)return null;var l={end:{column:0}};var s,e;for(var i=0;i<b.folds.length;i++){e=b.folds[i];var h=e.range.compareEnd(a,c);if(h==-1){s=this.getLine(e.start.row).substring(l.end.column,e.start.column);break;}else if(h===0){return null;}l=e;}if(!s)s=this.getLine(e.start.row).substring(l.end.column);if(t==-1)return s.substring(0,c-l.end.column);else if(t==1)return s.substring(c-l.end.column);else return s;};this.getFoldLine=function(a,s){var b=this.$foldData;var i=0;if(s)i=b.indexOf(s);if(i==-1)i=0;for(i;i<b.length;i++){var c=b[i];if(c.start.row<=a&&c.end.row>=a){return c;}else if(c.end.row>a){return null;}}return null;};this.getNextFoldLine=function(a,s){var b=this.$foldData;var i=0;if(s)i=b.indexOf(s);if(i==-1)i=0;for(i;i<b.length;i++){var c=b[i];if(c.end.row>=a){return c;}}return null;};this.getFoldedRowCount=function(a,l){var b=this.$foldData,c=l-a+1;for(var i=0;i<b.length;i++){var e=b[i],h=e.end.row,s=e.start.row;if(h>=l){if(s<l){if(s>=a)c-=l-s;else c=0;}break;}else if(h>=a){if(s>=a)c-=h-s;else c-=h-a+1;}}return c;};this.$addFoldLine=function(c){this.$foldData.push(c);this.$foldData.sort(function(a,b){return a.start.row-b.start.row;});return c;};this.addFold=function(p,a){var b=this.$foldData;var c=false;var e;if(p instanceof f)e=p;else{e=new f(a,p);e.collapseChildren=a.collapseChildren;}this.$clipRangeToDocument(e.range);var s=e.start.row;var h=e.start.column;var j=e.end.row;var k=e.end.column;var l=this.getFoldAt(s,h,1);var n=this.getFoldAt(j,k,-1);if(l&&n==l)return l.addSubFold(e);if(l&&!l.range.isStart(s,h))this.removeFold(l);if(n&&!n.range.isEnd(j,k))this.removeFold(n);var o=this.getFoldsInRange(e.range);if(o.length>0){this.removeFolds(o);if(!e.collapseChildren){o.forEach(function(u){e.addSubFold(u);});}}for(var i=0;i<b.length;i++){var q=b[i];if(j==q.start.row){q.addFold(e);c=true;break;}else if(s==q.end.row){q.addFold(e);c=true;if(!e.sameRow){var t=b[i+1];if(t&&t.start.row==j){q.merge(t);break;}}break;}else if(j<=q.start.row){break;}}if(!c)q=this.$addFoldLine(new F(this.$foldData,e));if(this.$useWrapMode)this.$updateWrapData(q.start.row,q.start.row);else this.$updateRowLengthCache(q.start.row,q.start.row);this.$modified=true;this._signal("changeFold",{data:e,action:"add"});return e;};this.addFolds=function(a){a.forEach(function(b){this.addFold(b);},this);};this.removeFold=function(a){var b=a.foldLine;var s=b.start.row;var e=b.end.row;var c=this.$foldData;var h=b.folds;if(h.length==1){c.splice(c.indexOf(b),1);}else if(b.range.isEnd(a.end.row,a.end.column)){h.pop();b.end.row=h[h.length-1].end.row;b.end.column=h[h.length-1].end.column;}else if(b.range.isStart(a.start.row,a.start.column)){h.shift();b.start.row=h[0].start.row;b.start.column=h[0].start.column;}else if(a.sameRow){h.splice(h.indexOf(a),1);}else{var n=b.split(a.start.row,a.start.column);h=n.folds;h.shift();n.start.row=h[0].start.row;n.start.column=h[0].start.column;}if(!this.$updating){if(this.$useWrapMode)this.$updateWrapData(s,e);else this.$updateRowLengthCache(s,e);}this.$modified=true;this._signal("changeFold",{data:a,action:"remove"});};this.removeFolds=function(a){var c=[];for(var i=0;i<a.length;i++){c.push(a[i]);}c.forEach(function(b){this.removeFold(b);},this);this.$modified=true;};this.expandFold=function(a){this.removeFold(a);a.subFolds.forEach(function(s){a.restoreRange(s);this.addFold(s);},this);if(a.collapseChildren>0){this.foldAll(a.start.row+1,a.end.row,a.collapseChildren-1);}a.subFolds=[];};this.expandFolds=function(a){a.forEach(function(b){this.expandFold(b);},this);};this.unfold=function(l,e){var a,b;if(l==null){a=new R(0,0,this.getLength(),0);if(e==null)e=true;}else if(typeof l=="number"){a=new R(l,0,l,this.getLine(l).length);}else if("row"in l){a=R.fromPoints(l,l);}else if(Array.isArray(l)){b=[];l.forEach(function(a){b=b.concat(this.unfold(a));},this);return b;}else{a=l;}b=this.getFoldsInRangeList(a);var o=b;while(b.length==1&&R.comparePoints(b[0].start,a.start)<0&&R.comparePoints(b[0].end,a.end)>0){this.expandFolds(b);b=this.getFoldsInRangeList(a);}if(e!=false){this.removeFolds(b);}else{this.expandFolds(b);}if(o.length)return o;};this.isRowFolded=function(a,s){return!!this.getFoldLine(a,s);};this.getRowFoldEnd=function(a,s){var b=this.getFoldLine(a,s);return b?b.end.row:a;};this.getRowFoldStart=function(a,s){var b=this.getFoldLine(a,s);return b?b.start.row:a;};this.getFoldDisplayLine=function(a,e,b,s,c){if(s==null)s=a.start.row;if(c==null)c=0;if(e==null)e=a.end.row;if(b==null)b=this.getLine(e).length;var h=this.doc;var t="";a.walk(function(p,i,j,l){if(i<s)return;if(i==s){if(j<c)return;l=Math.max(c,l);}if(p!=null){t+=p;}else{t+=h.getLine(i).substring(l,j);}},e,b);return t;};this.getDisplayLine=function(a,e,s,b){var c=this.getFoldLine(a);if(!c){var l;l=this.doc.getLine(a);return l.substring(b||0,e||l.length);}else{return this.getFoldDisplayLine(c,a,e,s,b);}};this.$cloneFoldData=function(){var a=[];a=this.$foldData.map(function(b){var c=b.folds.map(function(e){return e.clone();});return new F(a,c);});return a;};this.toggleFold=function(t){var s=this.selection;var a=s.getRange();var b;var c;if(a.isEmpty()){var e=a.start;b=this.getFoldAt(e.row,e.column);if(b){this.expandFold(b);return;}else if(c=this.findMatchingBracket(e)){if(a.comparePoint(c)==1){a.end=c;}else{a.start=c;a.start.column++;a.end.column--;}}else if(c=this.findMatchingBracket({row:e.row,column:e.column+1})){if(a.comparePoint(c)==1)a.end=c;else a.start=c;a.start.column++;}else{a=this.getCommentFoldRange(e.row,e.column)||a;}}else{var h=this.getFoldsInRange(a);if(t&&h.length){this.expandFolds(h);return;}else if(h.length==1){b=h[0];}}if(!b)b=this.getFoldAt(a.start.row,a.start.column);if(b&&b.range.toString()==a.toString()){this.expandFold(b);return;}var p="...";if(!a.isMultiLine()){p=this.getTextRange(a);if(p.length<4)return;p=p.trim().substring(0,2)+"..";}this.addFold(p,a);};this.getCommentFoldRange=function(a,c,b){var i=new T(this,a,c);var t=i.getCurrentToken();var e=t&&t.type;if(t&&/^comment|string/.test(e)){e=e.match(/comment|string/)[0];if(e=="comment")e+="|doc-start";var h=new RegExp(e);var j=new R();if(b!=1){do{t=i.stepBackward();}while(t&&h.test(t.type));i.stepForward();}j.start.row=i.getCurrentTokenRow();j.start.column=i.getCurrentTokenColumn()+2;i=new T(this,a,c);if(b!=-1){var l=-1;do{t=i.stepForward();if(l==-1){var s=this.getState(i.$row);if(!h.test(s))l=i.$row;}else if(i.$row>l){break;}}while(t&&h.test(t.type));t=i.stepBackward();}else t=i.getCurrentToken();j.end.row=i.getCurrentTokenRow();j.end.column=i.getCurrentTokenColumn()+t.value.length-2;return j;}};this.foldAll=function(s,e,a,t){if(a==undefined)a=100000;var b=this.foldWidgets;if(!b)return;e=e||this.getLength();s=s||0;for(var c=s;c<e;c++){if(b[c]==null)b[c]=this.getFoldWidget(c);if(b[c]!="start")continue;if(t&&!t(c))continue;var h=this.getFoldWidgetRange(c);if(h&&h.isMultiLine()&&h.end.row<=e&&h.start.row>=s){c=h.end.row;h.collapseChildren=a;this.addFold("...",h);}}};this.foldToLevel=function(l){this.foldAll();while(l-->0)this.unfold(null,false);};this.foldAllComments=function(){var s=this;this.foldAll(null,null,null,function(a){var t=s.getTokens(a);for(var i=0;i<t.length;i++){var b=t[i];if(b.type=="text"&&/^\s+$/.test(b.value))continue;if(/comment/.test(b.type))return true;return false;}});};this.$foldStyles={"manual":1,"markbegin":1,"markbeginend":1};this.$foldStyle="markbegin";this.setFoldStyle=function(s){if(!this.$foldStyles[s])throw new Error("invalid fold style: "+s+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle==s)return;this.$foldStyle=s;if(s=="manual")this.unfold();var a=this.$foldMode;this.$setFolding(null);this.$setFolding(a);};this.$setFolding=function(a){if(this.$foldMode==a)return;this.$foldMode=a;this.off('change',this.$updateFoldWidgets);this.off('tokenizerUpdate',this.$tokenizerUpdateFoldWidgets);this._signal("changeAnnotation");if(!a||this.$foldStyle=="manual"){this.foldWidgets=null;return;}this.foldWidgets=[];this.getFoldWidget=a.getFoldWidget.bind(a,this,this.$foldStyle);this.getFoldWidgetRange=a.getFoldWidgetRange.bind(a,this,this.$foldStyle);this.$updateFoldWidgets=this.updateFoldWidgets.bind(this);this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this);this.on('change',this.$updateFoldWidgets);this.on('tokenizerUpdate',this.$tokenizerUpdateFoldWidgets);};this.getParentFoldRangeData=function(a,b){var e=this.foldWidgets;if(!e||(b&&e[a]))return{};var i=a-1,h;while(i>=0){var c=e[i];if(c==null)c=e[i]=this.getFoldWidget(i);if(c=="start"){var j=this.getFoldWidgetRange(i);if(!h)h=j;if(j&&j.end.row>=a)break;}i--;}return{range:i!==-1&&j,firstRange:h};};this.onFoldWidgetClick=function(a,e){e=e.domEvent;var o={children:e.shiftKey,all:e.ctrlKey||e.metaKey,siblings:e.altKey};var b=this.$toggleFoldWidget(a,o);if(!b){var c=(e.target||e.srcElement);if(c&&/ace_fold-widget/.test(c.className))c.className+=" ace_invalid";}};this.$toggleFoldWidget=function(a,o){if(!this.getFoldWidget)return;var t=this.getFoldWidget(a);var l=this.getLine(a);var b=t==="end"?-1:1;var c=this.getFoldAt(a,b===-1?0:l.length,b);if(c){if(o.children||o.all)this.removeFold(c);else this.expandFold(c);return c;}var e=this.getFoldWidgetRange(a,true);if(e&&!e.isMultiLine()){c=this.getFoldAt(e.start.row,e.start.column,1);if(c&&e.isEqual(c.range)){this.removeFold(c);return c;}}if(o.siblings){var h=this.getParentFoldRangeData(a);if(h.range){var s=h.range.start.row+1;var i=h.range.end.row;}this.foldAll(s,i,o.all?10000:0);}else if(o.children){i=e?e.end.row:this.getLength();this.foldAll(a+1,i,o.all?10000:0);}else if(e){if(o.all)e.collapseChildren=10000;this.addFold("...",e);}return e;};this.toggleFoldWidget=function(t){var a=this.selection.getCursor().row;a=this.getRowFoldStart(a);var b=this.$toggleFoldWidget(a,{});if(b)return;var c=this.getParentFoldRangeData(a,true);b=c.range||c.firstRange;if(b){a=b.start.row;var e=this.getFoldAt(a,this.getLine(a).length,1);if(e){this.removeFold(e);}else{this.addFold("...",b);}}};this.updateFoldWidgets=function(a){var b=a.start.row;var l=a.end.row-b;if(l===0){this.foldWidgets[b]=null;}else if(a.action=='remove'){this.foldWidgets.splice(b,l+1,null);}else{var c=Array(l+1);c.unshift(b,1);this.foldWidgets.splice.apply(this.foldWidgets,c);}};this.tokenizerUpdateFoldWidgets=function(e){var a=e.data;if(a.first!=a.last){if(this.foldWidgets.length>a.first)this.foldWidgets.splice(a.first,this.foldWidgets.length);}};}d.Folding=g;});ace.define("ace/edit_session/bracket_match",[],function(r,e,m){"use strict";var T=r("../token_iterator").TokenIterator;var R=r("../range").Range;function B(){this.findMatchingBracket=function(p,c){if(p.column==0)return null;var a=c||this.getLine(p.row).charAt(p.column-1);if(a=="")return null;var b=a.match(/([\(\[\{])|([\)\]\}])/);if(!b)return null;if(b[1])return this.$findClosingBracket(b[1],p);else return this.$findOpeningBracket(b[2],p);};this.getBracketRange=function(p){var l=this.getLine(p.row);var b=true,a;var c=l.charAt(p.column-1);var d=c&&c.match(/([\(\[\{])|([\)\]\}])/);if(!d){c=l.charAt(p.column);p={row:p.row,column:p.column+1};d=c&&c.match(/([\(\[\{])|([\)\]\}])/);b=false;}if(!d)return null;if(d[1]){var f=this.$findClosingBracket(d[1],p);if(!f)return null;a=R.fromPoints(p,f);if(!b){a.end.column++;a.start.column--;}a.cursor=a.end;}else{var f=this.$findOpeningBracket(d[2],p);if(!f)return null;a=R.fromPoints(f,p);if(!b){a.start.column++;a.end.column--;}a.cursor=a.start;}return a;};this.getMatchingBracketRanges=function(p){var l=this.getLine(p.row);var c=l.charAt(p.column-1);var a=c&&c.match(/([\(\[\{])|([\)\]\}])/);if(!a){c=l.charAt(p.column);p={row:p.row,column:p.column+1};a=c&&c.match(/([\(\[\{])|([\)\]\}])/);}if(!a)return null;var s=new R(p.row,p.column-1,p.row,p.column);var b=a[1]?this.$findClosingBracket(a[1],p):this.$findOpeningBracket(a[2],p);if(!b)return[s];var d=new R(b.row,b.column,b.row,b.column+1);return[s,d];};this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"};this.$findOpeningBracket=function(b,p,t){var o=this.$brackets[b];var d=1;var i=new T(this,p.row,p.column);var a=i.getCurrentToken();if(!a)a=i.stepForward();if(!a)return;if(!t){t=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");}var v=p.column-i.getCurrentTokenColumn()-2;var c=a.value;while(true){while(v>=0){var f=c.charAt(v);if(f==o){d-=1;if(d==0){return{row:i.getCurrentTokenRow(),column:v+i.getCurrentTokenColumn()};}}else if(f==b){d+=1;}v-=1;}do{a=i.stepBackward();}while(a&&!t.test(a.type));if(a==null)break;c=a.value;v=c.length-1;}return null;};this.$findClosingBracket=function(b,p,t){var c=this.$brackets[b];var d=1;var i=new T(this,p.row,p.column);var a=i.getCurrentToken();if(!a)a=i.stepForward();if(!a)return;if(!t){t=new RegExp("(\\.?"+a.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");}var v=p.column-i.getCurrentTokenColumn();while(true){var f=a.value;var g=f.length;while(v<g){var h=f.charAt(v);if(h==c){d-=1;if(d==0){return{row:i.getCurrentTokenRow(),column:v+i.getCurrentTokenColumn()};}}else if(h==b){d+=1;}v+=1;}do{a=i.stepForward();}while(a&&!t.test(a.type));if(a==null)break;v=0;}return null;};}e.BracketMatch=B;});ace.define("ace/edit_session",[],function(r,a,d){"use strict";var o=r("./lib/oop");var f=r("./lib/lang");var B=r("./bidihandler").BidiHandler;var g=r("./config");var E=r("./lib/event_emitter").EventEmitter;var S=r("./selection").Selection;var T=r("./mode/text").Mode;var R=r("./range").Range;var D=r("./document").Document;var k=r("./background_tokenizer").BackgroundTokenizer;var p=r("./search_highlight").SearchHighlight;var q=function(t,m){this.$breakpoints=[];this.$decorations=[];this.$frontMarkers={};this.$backMarkers={};this.$markerId=1;this.$undoSelect=true;this.$foldData=[];this.id="session"+(++q.$uid);this.$foldData.toString=function(){return this.join("\n");};this.on("changeFold",this.onChangeFold.bind(this));this.$onChange=this.onChange.bind(this);if(typeof t!="object"||!t.getLine)t=new D(t);this.setDocument(t);this.selection=new S(this);this.$bidiHandler=new B(this);g.resetOptions(this);this.setMode(m);g._signal("session",this);};q.$uid=0;(function(){o.implement(this,E);this.setDocument=function(b){if(this.doc)this.doc.off("change",this.$onChange);this.doc=b;b.on("change",this.$onChange);if(this.bgTokenizer)this.bgTokenizer.setDocument(this.getDocument());this.resetCaches();};this.getDocument=function(){return this.doc;};this.$resetRowCache=function(b){if(!b){this.$docRowCache=[];this.$screenRowCache=[];return;}var l=this.$docRowCache.length;var i=this.$getRowCacheIndex(this.$docRowCache,b)+1;if(l>i){this.$docRowCache.splice(i,l);this.$screenRowCache.splice(i,l);}};this.$getRowCacheIndex=function(b,e){var l=0;var h=b.length-1;while(l<=h){var m=(l+h)>>1;var c=b[m];if(e>c)l=m+1;else if(e<c)h=m-1;else return m;}return l-1;};this.resetCaches=function(){this.$modified=true;this.$wrapData=[];this.$rowLengthCache=[];this.$resetRowCache(0);if(this.bgTokenizer)this.bgTokenizer.start(0);};this.onChangeFold=function(e){var b=e.data;this.$resetRowCache(b.start.row);};this.onChange=function(b){this.$modified=true;this.$bidiHandler.onChange(b);this.$resetRowCache(b.start.row);var c=this.$updateInternalDataOnChange(b);if(!this.$fromUndo&&this.$undoManager){if(c&&c.length){this.$undoManager.add({action:"removeFolds",folds:c},this.mergeUndoDeltas);this.mergeUndoDeltas=true;}this.$undoManager.add(b,this.mergeUndoDeltas);this.mergeUndoDeltas=true;this.$informUndoManager.schedule();}this.bgTokenizer&&this.bgTokenizer.$updateOnChange(b);this._signal("change",b);};this.setValue=function(b){this.doc.setValue(b);this.selection.moveTo(0,0);this.$resetRowCache(0);this.setUndoManager(this.$undoManager);this.getUndoManager().reset();};this.getValue=this.toString=function(){return this.doc.getValue();};this.getSelection=function(){return this.selection;};this.getState=function(b){return this.bgTokenizer.getState(b);};this.getTokens=function(b){return this.bgTokenizer.getTokens(b);};this.getTokenAt=function(b,e){var h=this.bgTokenizer.getTokens(b);var j,c=0;if(e==null){var i=h.length-1;c=this.getLine(b).length;}else{for(var i=0;i<h.length;i++){c+=h[i].value.length;if(c>=e)break;}}j=h[i];if(!j)return null;j.index=i;j.start=c-j.value.length;return j;};this.setUndoManager=function(b){this.$undoManager=b;if(this.$informUndoManager)this.$informUndoManager.cancel();if(b){var c=this;b.addSession(this);this.$syncInformUndoManager=function(){c.$informUndoManager.cancel();c.mergeUndoDeltas=false;};this.$informUndoManager=f.delayedCall(this.$syncInformUndoManager);}else{this.$syncInformUndoManager=function(){};}};this.markUndoGroup=function(){if(this.$syncInformUndoManager)this.$syncInformUndoManager();};this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}};this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager;};this.getTabString=function(){if(this.getUseSoftTabs()){return f.stringRepeat(" ",this.getTabSize());}else{return"\t";}};this.setUseSoftTabs=function(b){this.setOption("useSoftTabs",b);};this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs;};this.setTabSize=function(b){this.setOption("tabSize",b);};this.getTabSize=function(){return this.$tabSize;};this.isTabStop=function(b){return this.$useSoftTabs&&(b.column%this.$tabSize===0);};this.setNavigateWithinSoftTabs=function(n){this.setOption("navigateWithinSoftTabs",n);};this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs;};this.$overwrite=false;this.setOverwrite=function(b){this.setOption("overwrite",b);};this.getOverwrite=function(){return this.$overwrite;};this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite);};this.addGutterDecoration=function(b,c){if(!this.$decorations[b])this.$decorations[b]="";this.$decorations[b]+=" "+c;this._signal("changeBreakpoint",{});};this.removeGutterDecoration=function(b,c){this.$decorations[b]=(this.$decorations[b]||"").replace(" "+c,"");this._signal("changeBreakpoint",{});};this.getBreakpoints=function(){return this.$breakpoints;};this.setBreakpoints=function(b){this.$breakpoints=[];for(var i=0;i<b.length;i++){this.$breakpoints[b[i]]="ace_breakpoint";}this._signal("changeBreakpoint",{});};this.clearBreakpoints=function(){this.$breakpoints=[];this._signal("changeBreakpoint",{});};this.setBreakpoint=function(b,c){if(c===undefined)c="ace_breakpoint";if(c)this.$breakpoints[b]=c;else delete this.$breakpoints[b];this._signal("changeBreakpoint",{});};this.clearBreakpoint=function(b){delete this.$breakpoints[b];this._signal("changeBreakpoint",{});};this.addMarker=function(b,c,e,i){var h=this.$markerId++;var m={range:b,type:e||"line",renderer:typeof e=="function"?e:null,clazz:c,inFront:!!i,id:h};if(i){this.$frontMarkers[h]=m;this._signal("changeFrontMarker");}else{this.$backMarkers[h]=m;this._signal("changeBackMarker");}return h;};this.addDynamicMarker=function(m,i){if(!m.update)return;var b=this.$markerId++;m.id=b;m.inFront=!!i;if(i){this.$frontMarkers[b]=m;this._signal("changeFrontMarker");}else{this.$backMarkers[b]=m;this._signal("changeBackMarker");}return m;};this.removeMarker=function(m){var b=this.$frontMarkers[m]||this.$backMarkers[m];if(!b)return;var c=b.inFront?this.$frontMarkers:this.$backMarkers;delete(c[m]);this._signal(b.inFront?"changeFrontMarker":"changeBackMarker");};this.getMarkers=function(i){return i?this.$frontMarkers:this.$backMarkers;};this.highlight=function(b){if(!this.$searchHighlight){var h=new p(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(h);}this.$searchHighlight.setRegexp(b);};this.highlightLines=function(b,e,c,i){if(typeof e!="number"){c=e;e=b;}if(!c)c="ace_step";var h=new R(b,0,e,Infinity);h.id=this.addMarker(h,c,"fullLine",i);return h;};this.setAnnotations=function(b){this.$annotations=b;this._signal("changeAnnotation",{});};this.getAnnotations=function(){return this.$annotations||[];};this.clearAnnotations=function(){this.setAnnotations([]);};this.$detectNewLine=function(b){var m=b.match(/^.*?(\r?\n)/m);if(m){this.$autoNewLine=m[1];}else{this.$autoNewLine="\n";}};this.getWordRange=function(b,c){var l=this.getLine(b);var i=false;if(c>0)i=!!l.charAt(c-1).match(this.tokenRe);if(!i)i=!!l.charAt(c).match(this.tokenRe);if(i)var e=this.tokenRe;else if(/^\s+$/.test(l.slice(c-1,c+1)))var e=/\s/;else var e=this.nonTokenRe;var h=c;if(h>0){do{h--;}while(h>=0&&l.charAt(h).match(e));h++;}var j=c;while(j<l.length&&l.charAt(j).match(e)){j++;}return new R(b,h,b,j);};this.getAWordRange=function(b,c){var w=this.getWordRange(b,c);var l=this.getLine(w.end.row);while(l.charAt(w.end.column).match(/[ \t]/)){w.end.column+=1;}return w;};this.setNewLineMode=function(n){this.doc.setNewLineMode(n);};this.getNewLineMode=function(){return this.doc.getNewLineMode();};this.setUseWorker=function(b){this.setOption("useWorker",b);};this.getUseWorker=function(){return this.$useWorker;};this.onReloadTokenizer=function(e){var b=e.data;this.bgTokenizer.start(b.first);this._signal("tokenizerUpdate",e);};this.$modes=g.$modes;this.$mode=null;this.$modeId=null;this.setMode=function(b,c){if(b&&typeof b==="object"){if(b.getTokenizer)return this.$onChangeMode(b);var e=b;var h=e.path;}else{h=b||"ace/mode/text";}if(!this.$modes["ace/mode/text"])this.$modes["ace/mode/text"]=new T();if(this.$modes[h]&&!e){this.$onChangeMode(this.$modes[h]);c&&c();return;}this.$modeId=h;g.loadModule(["mode",h],function(m){if(this.$modeId!==h)return c&&c();if(this.$modes[h]&&!e){this.$onChangeMode(this.$modes[h]);}else if(m&&m.Mode){m=new m.Mode(e);if(!e){this.$modes[h]=m;m.$id=h;}this.$onChangeMode(m);}c&&c();}.bind(this));if(!this.$mode)this.$onChangeMode(this.$modes["ace/mode/text"],true);};this.$onChangeMode=function(m,$){if(!$)this.$modeId=m.$id;if(this.$mode===m)return;var b=this.$mode;this.$mode=m;this.$stopWorker();if(this.$useWorker)this.$startWorker();var c=m.getTokenizer();if(c.on!==undefined){var h=this.onReloadTokenizer.bind(this);c.on("update",h);}if(!this.bgTokenizer){this.bgTokenizer=new k(c);var _=this;this.bgTokenizer.on("update",function(e){_._signal("tokenizerUpdate",e);});}else{this.bgTokenizer.setTokenizer(c);}this.bgTokenizer.setDocument(this.getDocument());this.tokenRe=m.tokenRe;this.nonTokenRe=m.nonTokenRe;if(!$){if(m.attachToSession)m.attachToSession(this);this.$options.wrapMethod.set.call(this,this.$wrapMethod);this.$setFolding(m.foldingRules);this.bgTokenizer.start(0);this._emit("changeMode",{oldMode:b,mode:m});}};this.$stopWorker=function(){if(this.$worker){this.$worker.terminate();this.$worker=null;}};this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this);}catch(e){g.warn("Could not load worker",e);this.$worker=null;}};this.getMode=function(){return this.$mode;};this.$scrollTop=0;this.setScrollTop=function(b){if(this.$scrollTop===b||isNaN(b))return;this.$scrollTop=b;this._signal("changeScrollTop",b);};this.getScrollTop=function(){return this.$scrollTop;};this.$scrollLeft=0;this.setScrollLeft=function(b){if(this.$scrollLeft===b||isNaN(b))return;this.$scrollLeft=b;this._signal("changeScrollLeft",b);};this.getScrollLeft=function(){return this.$scrollLeft;};this.getScreenWidth=function(){this.$computeWidth();if(this.lineWidgets)return Math.max(this.getLineWidgetMaxWidth(),this.screenWidth);return this.screenWidth;};this.getLineWidgetMaxWidth=function(){if(this.lineWidgetsWidth!=null)return this.lineWidgetsWidth;var b=0;this.lineWidgets.forEach(function(w){if(w&&w.screenWidth>b)b=w.screenWidth;});return this.lineWidgetWidth=b;};this.$computeWidth=function(b){if(this.$modified||b){this.$modified=false;if(this.$useWrapMode)return this.screenWidth=this.$wrapLimit;var l=this.doc.getAllLines();var c=this.$rowLengthCache;var e=0;var h=0;var j=this.$foldData[h];var m=j?j.start.row:Infinity;var n=l.length;for(var i=0;i<n;i++){if(i>m){i=j.end.row+1;if(i>=n)break;j=this.$foldData[h++];m=j?j.start.row:Infinity;}if(c[i]==null)c[i]=this.$getStringScreenWidth(l[i])[0];if(c[i]>e)e=c[i];}this.screenWidth=e;}};this.getLine=function(b){return this.doc.getLine(b);};this.getLines=function(b,l){return this.doc.getLines(b,l);};this.getLength=function(){return this.doc.getLength();};this.getTextRange=function(b){return this.doc.getTextRange(b||this.selection.getRange());};this.insert=function(b,c){return this.doc.insert(b,c);};this.remove=function(b){return this.doc.remove(b);};this.removeFullLines=function(b,l){return this.doc.removeFullLines(b,l);};this.undoChanges=function(b,c){if(!b.length)return;this.$fromUndo=true;for(var i=b.length-1;i!=-1;i--){var e=b[i];if(e.action=="insert"||e.action=="remove"){this.doc.revertDelta(e);}else if(e.folds){this.addFolds(e.folds);}}if(!c&&this.$undoSelect){if(b.selectionBefore)this.selection.fromJSON(b.selectionBefore);else this.selection.setRange(this.$getUndoSelection(b,true));}this.$fromUndo=false;};this.redoChanges=function(b,c){if(!b.length)return;this.$fromUndo=true;for(var i=0;i<b.length;i++){var e=b[i];if(e.action=="insert"||e.action=="remove"){this.doc.$safeApplyDelta(e);}}if(!c&&this.$undoSelect){if(b.selectionAfter)this.selection.fromJSON(b.selectionAfter);else this.selection.setRange(this.$getUndoSelection(b,false));}this.$fromUndo=false;};this.setUndoSelect=function(e){this.$undoSelect=e;};this.$getUndoSelection=function(b,c){function e(l){return c?l.action!=="insert":l.action==="insert";}var h,j;for(var i=0;i<b.length;i++){var l=b[i];if(!l.start)continue;if(!h){if(e(l)){h=R.fromPoints(l.start,l.end);}else{h=R.fromPoints(l.start,l.start);}continue;}if(e(l)){j=l.start;if(h.compare(j.row,j.column)==-1){h.setStart(j);}j=l.end;if(h.compare(j.row,j.column)==1){h.setEnd(j);}}else{j=l.start;if(h.compare(j.row,j.column)==-1){h=R.fromPoints(l.start,l.start);}}}return h;};this.replace=function(b,c){return this.doc.replace(b,c);};this.moveText=function(b,c,e){var h=this.getTextRange(b);var i=this.getFoldsInRange(b);var j=R.fromPoints(c,c);if(!e){this.remove(b);var l=b.start.row-b.end.row;var m=l?-b.end.column:b.start.column-b.end.column;if(m){if(j.start.row==b.end.row&&j.start.column>b.end.column)j.start.column+=m;if(j.end.row==b.end.row&&j.end.column>b.end.column)j.end.column+=m;}if(l&&j.start.row>=b.end.row){j.start.row+=l;j.end.row+=l;}}j.end=this.insert(j.start,h);if(i.length){var n=b.start;var w=j.start;var l=w.row-n.row;var m=w.column-n.column;this.addFolds(i.map(function(x){x=x.clone();if(x.start.row==n.row)x.start.column+=m;if(x.end.row==n.row)x.end.column+=m;x.start.row+=l;x.end.row+=l;return x;}));}return j;};this.indentRows=function(b,e,i){i=i.replace(/\t/g,this.getTabString());for(var c=b;c<=e;c++)this.doc.insertInLine({row:c,column:0},i);};this.outdentRows=function(b){var c=b.collapseRows();var e=new R(0,0,0,0);var h=this.getTabSize();for(var i=c.start.row;i<=c.end.row;++i){var l=this.getLine(i);e.start.row=i;e.end.row=i;for(var j=0;j<h;++j)if(l.charAt(j)!=' ')break;if(j<h&&l.charAt(j)=='\t'){e.start.column=j;e.end.column=j+1;}else{e.start.column=0;e.end.column=j;}this.remove(e);}};this.$moveLines=function(b,l,c){b=this.getRowFoldStart(b);l=this.getRowFoldEnd(l);if(c<0){var e=this.getRowFoldStart(b+c);if(e<0)return 0;var h=e-b;}else if(c>0){var e=this.getRowFoldEnd(l+c);if(e>this.doc.getLength()-1)return 0;var h=e-l;}else{b=this.$clipRowToDocument(b);l=this.$clipRowToDocument(l);var h=l-b+1;}var i=new R(b,0,l,Number.MAX_VALUE);var j=this.getFoldsInRange(i).map(function(x){x=x.clone();x.start.row+=h;x.end.row+=h;return x;});var m=c==0?this.doc.getLines(b,l):this.doc.removeFullLines(b,l);this.doc.insertFullLines(b+h,m);j.length&&this.addFolds(j);return h;};this.moveLinesUp=function(b,l){return this.$moveLines(b,l,-1);};this.moveLinesDown=function(b,l){return this.$moveLines(b,l,1);};this.duplicateLines=function(b,l){return this.$moveLines(b,l,0);};this.$clipRowToDocument=function(b){return Math.max(0,Math.min(b,this.doc.getLength()-1));};this.$clipColumnToRow=function(b,c){if(c<0)return 0;return Math.min(this.doc.getLine(b).length,c);};this.$clipPositionToDocument=function(b,c){c=Math.max(0,c);if(b<0){b=0;c=0;}else{var l=this.doc.getLength();if(b>=l){b=l-1;c=this.doc.getLine(l-1).length;}else{c=Math.min(this.doc.getLine(b).length,c);}}return{row:b,column:c};};this.$clipRangeToDocument=function(b){if(b.start.row<0){b.start.row=0;b.start.column=0;}else{b.start.column=this.$clipColumnToRow(b.start.row,b.start.column);}var l=this.doc.getLength()-1;if(b.end.row>l){b.end.row=l;b.end.column=this.doc.getLine(l).length;}else{b.end.column=this.$clipColumnToRow(b.end.row,b.end.column);}return b;};this.$wrapLimit=80;this.$useWrapMode=false;this.$wrapLimitRange={min:null,max:null};this.setUseWrapMode=function(b){if(b!=this.$useWrapMode){this.$useWrapMode=b;this.$modified=true;this.$resetRowCache(0);if(b){var l=this.getLength();this.$wrapData=Array(l);this.$updateWrapData(0,l-1);}this._signal("changeWrapMode");}};this.getUseWrapMode=function(){return this.$useWrapMode;};this.setWrapLimitRange=function(m,b){if(this.$wrapLimitRange.min!==m||this.$wrapLimitRange.max!==b){this.$wrapLimitRange={min:m,max:b};this.$modified=true;this.$bidiHandler.markAsDirty();if(this.$useWrapMode)this._signal("changeWrapMode");}};this.adjustWrapLimit=function(b,$){var l=this.$wrapLimitRange;if(l.max<0)l={min:$,max:$};var w=this.$constrainWrapLimit(b,l.min,l.max);if(w!=this.$wrapLimit&&w>1){this.$wrapLimit=w;this.$modified=true;if(this.$useWrapMode){this.$updateWrapData(0,this.getLength()-1);this.$resetRowCache(0);this._signal("changeWrapLimit");}return true;}return false;};this.$constrainWrapLimit=function(w,m,b){if(m)w=Math.max(m,w);if(b)w=Math.min(b,w);return w;};this.getWrapLimit=function(){return this.$wrapLimit;};this.setWrapLimit=function(l){this.setWrapLimitRange(l,l);};this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max};};this.$updateInternalDataOnChange=function(b){var c=this.$useWrapMode;var e=b.action;var h=b.start;var i=b.end;var j=h.row;var l=i.row;var m=l-j;var n=null;this.$updating=true;if(m!=0){if(e==="remove"){this[c?"$wrapData":"$rowLengthCache"].splice(j,m);var w=this.$foldData;n=this.getFoldsInRange(b);this.removeFolds(n);var x=this.getFoldLine(i.row);var F=0;if(x){x.addRemoveChars(i.row,i.column,h.column-i.column);x.shiftRow(-m);var G=this.getFoldLine(j);if(G&&G!==x){G.merge(x);x=G;}F=w.indexOf(x)+1;}for(F;F<w.length;F++){var x=w[F];if(x.start.row>=i.row){x.shiftRow(-m);}}l=j;}else{var H=Array(m);H.unshift(j,0);var I=c?this.$wrapData:this.$rowLengthCache;I.splice.apply(I,H);var w=this.$foldData;var x=this.getFoldLine(j);var F=0;if(x){var J=x.range.compareInside(h.row,h.column);if(J==0){x=x.split(h.row,h.column);if(x){x.shiftRow(m);x.addRemoveChars(l,0,i.column-h.column);}}else if(J==-1){x.addRemoveChars(j,0,i.column-h.column);x.shiftRow(m);}F=w.indexOf(x)+1;}for(F;F<w.length;F++){var x=w[F];if(x.start.row>=j){x.shiftRow(m);}}}}else{m=Math.abs(b.start.column-b.end.column);if(e==="remove"){n=this.getFoldsInRange(b);this.removeFolds(n);m=-m;}var x=this.getFoldLine(j);if(x){x.addRemoveChars(j,h.column,m);}}if(c&&this.$wrapData.length!=this.doc.getLength()){console.error("doc.getLength() and $wrapData.length have to be the same!");}this.$updating=false;if(c)this.$updateWrapData(j,l);else this.$updateRowLengthCache(j,l);return n;};this.$updateRowLengthCache=function(c,l,b){this.$rowLengthCache[c]=null;this.$rowLengthCache[l]=null;};this.$updateWrapData=function(b,l){var c=this.doc.getAllLines();var e=this.getTabSize();var w=this.$wrapData;var h=this.$wrapLimit;var j;var m;var n=b;l=Math.min(l,c.length-1);while(n<=l){m=this.getFoldLine(n,m);if(!m){j=this.$getDisplayTokens(c[n]);w[n]=this.$computeWrapSplits(j,h,e);n++;}else{j=[];m.walk(function(x,n,F,G){var H;if(x!=null){H=this.$getDisplayTokens(x,j.length);H[0]=P;for(var i=1;i<H.length;i++){H[i]=t;}}else{H=this.$getDisplayTokens(c[n].substring(G,F),j.length);}j=j.concat(H);}.bind(this),m.end.row,c[m.end.row].length+1);w[m.start.row]=this.$computeWrapSplits(j,h,e);n=m.end.row+1;}}};var C=1,s=2,P=3,t=4,u=9,v=10,y=11,z=12;this.$computeWrapSplits=function(b,w,c){if(b.length==0){return[];}var e=[];var h=b.length;var l=0,j=0;var m=this.$wrapAsCode;var n=this.$indentedSoftWrap;var x=w<=Math.max(2*c,8)||n===false?0:Math.floor(w/2);function F(){var K=0;if(x===0)return K;if(n){for(var i=0;i<b.length;i++){var L=b[i];if(L==v)K+=1;else if(L==y)K+=c;else if(L==z)continue;else break;}}if(m&&n!==false)K+=c;return Math.min(K,x);}function G(K){var L=K-l;for(var i=l;i<K;i++){var M=b[i];if(M===12||M===2)L-=1;}if(!e.length){H=F();e.indent=H;}j+=L;e.push(j);l=K;}var H=0;while(h-l>w-H){var I=l+w-H;if(b[I-1]>=v&&b[I]>=v){G(I);continue;}if(b[I]==P||b[I]==t){for(I;I!=l-1;I--){if(b[I]==P){break;}}if(I>l){G(I);continue;}I=l+w;for(I;I<b.length;I++){if(b[I]!=t){break;}}if(I==b.length){break;}G(I);continue;}var J=Math.max(I-(w-(w>>2)),l-1);while(I>J&&b[I]<P){I--;}if(m){while(I>J&&b[I]<P){I--;}while(I>J&&b[I]==u){I--;}}else{while(I>J&&b[I]<v){I--;}}if(I>J){G(++I);continue;}I=l+w;if(b[I]==s)I--;G(I-H);}return e;};this.$getDisplayTokens=function(b,e){var h=[];var j;e=e||0;for(var i=0;i<b.length;i++){var c=b.charCodeAt(i);if(c==9){j=this.getScreenTabSize(h.length+e);h.push(y);for(var n=1;n<j;n++){h.push(z);}}else if(c==32){h.push(v);}else if((c>39&&c<48)||(c>57&&c<64)){h.push(u);}else if(c>=0x1100&&A(c)){h.push(C,s);}else{h.push(C);}}return h;};this.$getStringScreenWidth=function(b,m,e){if(m==0)return[0,0];if(m==null)m=Infinity;e=e||0;var c,h;for(h=0;h<b.length;h++){c=b.charCodeAt(h);if(c==9){e+=this.getScreenTabSize(e);}else if(c>=0x1100&&A(c)){e+=2;}else{e+=1;}if(e>m){break;}}return[e,h];};this.lineWidgets=null;this.getRowLength=function(b){var h=1;if(this.lineWidgets)h+=this.lineWidgets[b]&&this.lineWidgets[b].rowCount||0;if(!this.$useWrapMode||!this.$wrapData[b])return h;else return this.$wrapData[b].length+h;};this.getRowLineCount=function(b){if(!this.$useWrapMode||!this.$wrapData[b]){return 1;}else{return this.$wrapData[b].length+1;}};this.getRowWrapIndent=function(b){if(this.$useWrapMode){var c=this.screenToDocumentPosition(b,Number.MAX_VALUE);var e=this.$wrapData[c.row];return e.length&&e[0]<c.column?e.indent:0;}else{return 0;}};this.getScreenLastRowColumn=function(b){var c=this.screenToDocumentPosition(b,Number.MAX_VALUE);return this.documentToScreenColumn(c.row,c.column);};this.getDocumentLastRowColumn=function(b,c){var e=this.documentToScreenRow(b,c);return this.getScreenLastRowColumn(e);};this.getDocumentLastRowColumnPosition=function(b,c){var e=this.documentToScreenRow(b,c);return this.screenToDocumentPosition(e,Number.MAX_VALUE/10);};this.getRowSplitData=function(b){if(!this.$useWrapMode){return undefined;}else{return this.$wrapData[b];}};this.getScreenTabSize=function(b){return this.$tabSize-(b%this.$tabSize|0);};this.screenToDocumentRow=function(b,c){return this.screenToDocumentPosition(b,c).row;};this.screenToDocumentColumn=function(b,c){return this.screenToDocumentPosition(b,c).column;};this.screenToDocumentPosition=function(b,c,e){if(b<0)return{row:0,column:0};var h;var j=0;var m=0;var n;var w=0;var x=0;var F=this.$screenRowCache;var i=this.$getRowCacheIndex(F,b);var l=F.length;if(l&&i>=0){var w=F[i];var j=this.$docRowCache[i];var G=b>F[l-1];}else{var G=!l;}var H=this.getLength()-1;var I=this.getNextFoldLine(j);var J=I?I.start.row:Infinity;while(w<=b){x=this.getRowLength(j);if(w+x>b||j>=H){break;}else{w+=x;j++;if(j>J){j=I.end.row+1;I=this.getNextFoldLine(j,I);J=I?I.start.row:Infinity;}}if(G){this.$docRowCache.push(j);this.$screenRowCache.push(w);}}if(I&&I.start.row<=j){h=this.getFoldDisplayLine(I);j=I.start.row;}else if(w+x<=b||j>H){return{row:H,column:this.getLine(H).length};}else{h=this.getLine(j);I=null;}var K=0,L=Math.floor(b-w);if(this.$useWrapMode){var M=this.$wrapData[j];if(M){n=M[L];if(L>0&&M.length){K=M.indent;m=M[L-1]||M[M.length-1];h=h.substring(m);}}}if(e!==undefined&&this.$bidiHandler.isBidiRow(w+L,j,L))c=this.$bidiHandler.offsetToCol(e);m+=this.$getStringScreenWidth(h,c-K)[1];if(this.$useWrapMode&&m>=n)m=n-1;if(I)return I.idxToPosition(m);return{row:j,column:m};};this.documentToScreenPosition=function(b,c){if(typeof c==="undefined")var e=this.$clipPositionToDocument(b.row,b.column);else e=this.$clipPositionToDocument(b,c);b=e.row;c=e.column;var h=0;var j=null;var m=null;m=this.getFoldAt(b,c,1);if(m){b=m.start.row;c=m.start.column;}var n,w=0;var x=this.$docRowCache;var i=this.$getRowCacheIndex(x,b);var l=x.length;if(l&&i>=0){var w=x[i];var h=this.$screenRowCache[i];var F=b>x[l-1];}else{var F=!l;}var G=this.getNextFoldLine(w);var H=G?G.start.row:Infinity;while(w<b){if(w>=H){n=G.end.row+1;if(n>b)break;G=this.getNextFoldLine(n,G);H=G?G.start.row:Infinity;}else{n=w+1;}h+=this.getRowLength(w);w=n;if(F){this.$docRowCache.push(w);this.$screenRowCache.push(h);}}var I="";if(G&&w>=H){I=this.getFoldDisplayLine(G,b,c);j=G.start.row;}else{I=this.getLine(b).substring(0,c);j=b;}var J=0;if(this.$useWrapMode){var K=this.$wrapData[j];if(K){var L=0;while(I.length>=K[L]){h++;L++;}I=I.substring(K[L-1]||0,I.length);J=L>0?K.indent:0;}}if(this.lineWidgets&&this.lineWidgets[w]&&this.lineWidgets[w].rowsAbove)h+=this.lineWidgets[w].rowsAbove;return{row:h,column:J+this.$getStringScreenWidth(I)[0]};};this.documentToScreenColumn=function(b,c){return this.documentToScreenPosition(b,c).column;};this.documentToScreenRow=function(b,c){return this.documentToScreenPosition(b,c).row;};this.getScreenLength=function(){var b=0;var c=null;if(!this.$useWrapMode){b=this.getLength();var e=this.$foldData;for(var i=0;i<e.length;i++){c=e[i];b-=c.end.row-c.start.row;}}else{var l=this.$wrapData.length;var h=0,i=0;var c=this.$foldData[i++];var j=c?c.start.row:Infinity;while(h<l){var m=this.$wrapData[h];b+=m?m.length+1:1;h++;if(h>j){h=c.end.row+1;c=this.$foldData[i++];j=c?c.start.row:Infinity;}}}if(this.lineWidgets)b+=this.$getWidgetScreenLength();return b;};this.$setFontMetrics=function(b){if(!this.$enableVarChar)return;this.$getStringScreenWidth=function(e,m,h){if(m===0)return[0,0];if(!m)m=Infinity;h=h||0;var c,i;for(i=0;i<e.length;i++){c=e.charAt(i);if(c==="\t"){h+=this.getScreenTabSize(h);}else{h+=b.getCharacterWidth(c);}if(h>m){break;}}return[h,i];};};this.destroy=function(){if(this.bgTokenizer){this.bgTokenizer.setDocument(null);this.bgTokenizer=null;}this.$stopWorker();this.removeAllListeners();if(this.doc){this.doc.off("change",this.$onChange);}this.selection.detach();};this.isFullWidth=A;function A(c){if(c<0x1100)return false;return c>=0x1100&&c<=0x115F||c>=0x11A3&&c<=0x11A7||c>=0x11FA&&c<=0x11FF||c>=0x2329&&c<=0x232A||c>=0x2E80&&c<=0x2E99||c>=0x2E9B&&c<=0x2EF3||c>=0x2F00&&c<=0x2FD5||c>=0x2FF0&&c<=0x2FFB||c>=0x3000&&c<=0x303E||c>=0x3041&&c<=0x3096||c>=0x3099&&c<=0x30FF||c>=0x3105&&c<=0x312D||c>=0x3131&&c<=0x318E||c>=0x3190&&c<=0x31BA||c>=0x31C0&&c<=0x31E3||c>=0x31F0&&c<=0x321E||c>=0x3220&&c<=0x3247||c>=0x3250&&c<=0x32FE||c>=0x3300&&c<=0x4DBF||c>=0x4E00&&c<=0xA48C||c>=0xA490&&c<=0xA4C6||c>=0xA960&&c<=0xA97C||c>=0xAC00&&c<=0xD7A3||c>=0xD7B0&&c<=0xD7C6||c>=0xD7CB&&c<=0xD7FB||c>=0xF900&&c<=0xFAFF||c>=0xFE10&&c<=0xFE19||c>=0xFE30&&c<=0xFE52||c>=0xFE54&&c<=0xFE66||c>=0xFE68&&c<=0xFE6B||c>=0xFF01&&c<=0xFF60||c>=0xFFE0&&c<=0xFFE6;}}).call(q.prototype);r("./edit_session/folding").Folding.call(q.prototype);r("./edit_session/bracket_match").BracketMatch.call(q.prototype);g.defineOptions(q.prototype,"session",{wrap:{set:function(v){if(!v||v=="off")v=false;else if(v=="free")v=true;else if(v=="printMargin")v=-1;else if(typeof v=="string")v=parseInt(v,10)||false;if(this.$wrap==v)return;this.$wrap=v;if(!v){this.setUseWrapMode(false);}else{var c=typeof v=="number"?v:null;this.setWrapLimitRange(c,c);this.setUseWrapMode(true);}},get:function(){if(this.getUseWrapMode()){if(this.$wrap==-1)return"printMargin";if(!this.getWrapLimitRange().min)return"free";return this.$wrap;}return"off";},handlesSet:true},wrapMethod:{set:function(v){v=v=="auto"?this.$mode.type!="text":v!="text";if(v!=this.$wrapAsCode){this.$wrapAsCode=v;if(this.$useWrapMode){this.$useWrapMode=false;this.setUseWrapMode(true);}}},initialValue:"auto"},indentedSoftWrap:{set:function(){if(this.$useWrapMode){this.$useWrapMode=false;this.setUseWrapMode(true);}},initialValue:true},firstLineNumber:{set:function(){this._signal("changeBreakpoint");},initialValue:1},useWorker:{set:function(u){this.$useWorker=u;this.$stopWorker();if(u)this.$startWorker();},initialValue:true},useSoftTabs:{initialValue:true},tabSize:{set:function(t){t=parseInt(t);if(t>0&&this.$tabSize!==t){this.$modified=true;this.$rowLengthCache=[];this.$tabSize=t;this._signal("changeTabSize");}},initialValue:4,handlesSet:true},navigateWithinSoftTabs:{initialValue:false},foldStyle:{set:function(v){this.setFoldStyle(v);},handlesSet:true},overwrite:{set:function(v){this._signal("changeOverwrite");},initialValue:false},newLineMode:{set:function(v){this.doc.setNewLineMode(v);},get:function(){return this.doc.getNewLineMode();},handlesSet:true},mode:{set:function(v){this.setMode(v);},get:function(){return this.$modeId;},handlesSet:true}});a.EditSession=q;});ace.define("ace/search",[],function(r,a,b){"use strict";var l=r("./lib/lang");var o=r("./lib/oop");var R=r("./range").Range;var S=function(){this.$options={};};(function(){this.set=function(c){o.mixin(this.$options,c);return this;};this.getOptions=function(){return l.copyObject(this.$options);};this.setOptions=function(c){this.$options=c;};this.find=function(s){var c=this.$options;var i=this.$matchIterator(s,c);if(!i)return false;var f=null;i.forEach(function(e,g,h,j){f=new R(e,g,h,j);if(g==j&&c.start&&c.start.start&&c.skipCurrent!=false&&f.isEqual(c.start)){f=null;return false;}return true;});return f;};this.findAll=function(s){var c=this.$options;if(!c.needle)return[];this.$assembleRegExp(c);var e=c.range;var f=e?s.getLines(e.start.row,e.end.row):s.doc.getAllLines();var g=[];var h=c.re;if(c.$isMultiLine){var k=h.length;var m=f.length-k;var p;outer:for(var n=h.offset||0;n<=m;n++){for(var j=0;j<k;j++)if(f[n+j].search(h[j])==-1)continue outer;var q=f[n];var t=f[n+k-1];var u=q.length-q.match(h[0])[0].length;var v=t.match(h[k-1])[0].length;if(p&&p.end.row===n&&p.end.column>u){continue;}g.push(p=new R(n,u,n+k-1,v));if(k>2)n=n+k-2;}}else{for(var i=0;i<f.length;i++){var w=l.getMatchOffsets(f[i],h);for(var j=0;j<w.length;j++){var x=w[j];g.push(new R(i,x.offset,i,x.offset+x.length));}}}if(e){var y=e.start.column;var z=e.start.column;var i=0,j=g.length-1;while(i<j&&g[i].start.column<y&&g[i].start.row==e.start.row)i++;while(i<j&&g[j].end.column>z&&g[j].end.row==e.end.row)j--;g=g.slice(i,j+1);for(i=0,j=g.length;i<j;i++){g[i].start.row+=e.start.row;g[i].end.row+=e.start.row;}}return g;};this.replace=function(c,e){var f=this.$options;var g=this.$assembleRegExp(f);if(f.$isMultiLine)return e;if(!g)return;var m=g.exec(c);if(!m||m[0].length!=c.length)return null;e=c.replace(g,e);if(f.preserveCase){e=e.split("");for(var i=Math.min(c.length,c.length);i--;){var h=c[i];if(h&&h.toLowerCase()!=h)e[i]=e[i].toUpperCase();else e[i]=e[i].toLowerCase();}e=e.join("");}return e;};this.$assembleRegExp=function(c,$){if(c.needle instanceof RegExp)return c.re=c.needle;var n=c.needle;if(!c.needle)return c.re=false;if(!c.regExp)n=l.escapeRegExp(n);if(c.wholeWord)n=d(n,c);var m=c.caseSensitive?"gm":"gmi";c.$isMultiLine=!$&&/[\n\r]/.test(n);if(c.$isMultiLine)return c.re=this.$assembleMultilineRegExp(n,m);try{var f=new RegExp(n,m);}catch(e){f=false;}return c.re=f;};this.$assembleMultilineRegExp=function(n,m){var p=n.replace(/\r\n|\r|\n/g,"$\n^").split("\n");var c=[];for(var i=0;i<p.length;i++)try{c.push(new RegExp(p[i],m));}catch(e){return false;}return c;};this.$matchIterator=function(s,c){var e=this.$assembleRegExp(c);if(!e)return false;var f=c.backwards==true;var g=c.skipCurrent!=false;var h=c.range;var j=c.start;if(!j)j=h?h[f?"end":"start"]:s.selection.getRange();if(j.start)j=j[g!=f?"end":"start"];var k=h?h.start.row:0;var n=h?h.end.row:s.getLength()-1;if(f){var p=function(i){var m=j.row;if(t(m,j.column,i))return;for(m--;m>=k;m--)if(t(m,Number.MAX_VALUE,i))return;if(c.wrap==false)return;for(m=n,k=j.row;m>=k;m--)if(t(m,Number.MAX_VALUE,i))return;};}else{var p=function(i){var m=j.row;if(t(m,j.column,i))return;for(m=m+1;m<=n;m++)if(t(m,0,i))return;if(c.wrap==false)return;for(m=k,n=j.row;m<=n;m++)if(t(m,0,i))return;};}if(c.$isMultiLine){var q=e.length;var t=function(m,u,v){var w=f?m-q+1:m;if(w<0||w+q>s.getLength())return;var x=s.getLine(w);var y=x.search(e[0]);if(!f&&y<u||y===-1)return;for(var i=1;i<q;i++){x=s.getLine(w+i);if(x.search(e[i])==-1)return;}var z=x.match(e[q-1])[0].length;if(f&&z>u)return;if(v(w,y,w+q-1,z))return true;};}else if(f){var t=function(u,v,w){var x=s.getLine(u);var y=[];var m,z=0;e.lastIndex=0;while((m=e.exec(x))){var A=m[0].length;z=m.index;if(!A){if(z>=x.length)break;e.lastIndex=z+=1;}if(m.index+A>v)break;y.push(m.index,A);}for(var i=y.length-1;i>=0;i-=2){var B=y[i-1];var A=y[i];if(w(u,B,u,B+A))return true;}};}else{var t=function(i,u,v){var w=s.getLine(i);var x;var m;e.lastIndex=u;while((m=e.exec(w))){var y=m[0].length;x=m.index;if(v(i,x,i,x+y))return true;if(!y){e.lastIndex=x+=1;if(x>=w.length)return false;}}};}return{forEach:p};};}).call(S.prototype);function d(n,e){function w(c){if(/\w/.test(c)||e.regExp)return"\\b";return"";}return w(n[0])+n+w(n[n.length-1]);}a.Search=S;});ace.define("ace/keyboard/hash_handler",[],function(r,e,m){"use strict";var k=r("../lib/keys");var u=r("../lib/useragent");var K=k.KEY_MODS;function H(c,p){this.platform=p||(u.isMac?"mac":"win");this.commands={};this.commandKeyBinding={};this.addCommands(c);this.$singleCommand=true;}function M(c,p){H.call(this,c,p);this.$singleCommand=false;}M.prototype=H.prototype;(function(){this.addCommand=function(c){if(this.commands[c.name])this.removeCommand(c);this.commands[c.name]=c;if(c.bindKey)this._buildKeyHash(c);};this.removeCommand=function(c,a){var n=c&&(typeof c==='string'?c:c.name);c=this.commands[n];if(!a)delete this.commands[n];var b=this.commandKeyBinding;for(var d in b){var f=b[d];if(f==c){delete b[d];}else if(Array.isArray(f)){var i=f.indexOf(c);if(i!=-1){f.splice(i,1);if(f.length==1)b[d]=f[0];}}}};this.bindKey=function(a,c,p){if(typeof a=="object"&&a){if(p==undefined)p=a.position;a=a[this.platform];}if(!a)return;if(typeof c=="function")return this.addCommand({exec:c,bindKey:a,name:c.name||a});a.split("|").forEach(function(b){var d="";if(b.indexOf(" ")!=-1){var f=b.split(/\s+/);b=f.pop();f.forEach(function(b){var h=this.parseKeys(b);var i=K[h.hashId]+h.key;d+=(d?" ":"")+i;this._addCommandToBinding(d,"chainKeys");},this);d+=" ";}var h=this.parseKeys(b);var i=K[h.hashId]+h.key;this._addCommandToBinding(d+i,c,p);},this);};function g(c){return typeof c=="object"&&c.bindKey&&c.bindKey.position||(c.isDefault?-100:0);}this._addCommandToBinding=function(a,c,p){var b=this.commandKeyBinding,i;if(!c){delete b[a];}else if(!b[a]||this.$singleCommand){b[a]=c;}else{if(!Array.isArray(b[a])){b[a]=[b[a]];}else if((i=b[a].indexOf(c))!=-1){b[a].splice(i,1);}if(typeof p!="number"){p=g(c);}var d=b[a];for(i=0;i<d.length;i++){var o=d[i];var f=g(o);if(f>p)break;}d.splice(i,0,c);}};this.addCommands=function(c){c&&Object.keys(c).forEach(function(n){var a=c[n];if(!a)return;if(typeof a==="string")return this.bindKey(a,n);if(typeof a==="function")a={exec:a};if(typeof a!=="object")return;if(!a.name)a.name=n;this.addCommand(a);},this);};this.removeCommands=function(c){Object.keys(c).forEach(function(n){this.removeCommand(c[n]);},this);};this.bindKeys=function(a){Object.keys(a).forEach(function(b){this.bindKey(b,a[b]);},this);};this._buildKeyHash=function(c){this.bindKey(c.bindKey,c);};this.parseKeys=function(a){var p=a.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(x){return x;});var b=p.pop();var c=k[b];if(k.FUNCTION_KEYS[c])b=k.FUNCTION_KEYS[c].toLowerCase();else if(!p.length)return{key:b,hashId:-1};else if(p.length==1&&p[0]=="shift")return{key:b.toUpperCase(),hashId:-1};var h=0;for(var i=p.length;i--;){var d=k.KEY_MODS[p[i]];if(d==null){if(typeof console!="undefined")console.error("invalid modifier "+p[i]+" in "+a);return false;}h|=d;}return{key:b,hashId:h};};this.findKeyCommand=function f(h,a){var b=K[h]+a;return this.commandKeyBinding[b];};this.handleKeyboard=function(d,h,a,b){if(b<0)return;var c=K[h]+a;var f=this.commandKeyBinding[c];if(d.$keyChain){d.$keyChain+=" "+c;f=this.commandKeyBinding[d.$keyChain]||f;}if(f){if(f=="chainKeys"||f[f.length-1]=="chainKeys"){d.$keyChain=d.$keyChain||c;return{command:"null"};}}if(d.$keyChain){if((!h||h==4)&&a.length==1)d.$keyChain=d.$keyChain.slice(0,-c.length-1);else if(h==-1||b>0)d.$keyChain="";}return{command:f};};this.getStatusText=function(a,d){return d.$keyChain||"";};}).call(H.prototype);e.HashHandler=H;e.MultiHashHandler=M;});ace.define("ace/commands/command_manager",[],function(r,a,b){"use strict";var o=r("../lib/oop");var M=r("../keyboard/hash_handler").MultiHashHandler;var E=r("../lib/event_emitter").EventEmitter;var C=function(p,c){M.call(this,c,p);this.byName=this.commands;this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{});});};o.inherits(C,M);(function(){o.implement(this,E);this.exec=function(c,d,f){if(Array.isArray(c)){for(var i=c.length;i--;){if(this.exec(c[i],d,f))return true;}return false;}if(typeof c==="string")c=this.commands[c];if(!c)return false;if(d&&d.$readOnly&&!c.readOnly)return false;if(this.$checkCommandState!=false&&c.isAvailable&&!c.isAvailable(d))return false;var e={editor:d,command:c,args:f};e.returnValue=this._emit("exec",e);this._signal("afterExec",e);return e.returnValue===false?false:true;};this.toggleRecording=function(c){if(this.$inReplay)return;c&&c._emit("changeStatus");if(this.recording){this.macro.pop();this.off("exec",this.$addCommandToMacro);if(!this.macro.length)this.macro=this.oldMacro;return this.recording=false;}if(!this.$addCommandToMacro){this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args]);}.bind(this);}this.oldMacro=this.macro;this.macro=[];this.on("exec",this.$addCommandToMacro);return this.recording=true;};this.replay=function(e){if(this.$inReplay||!this.macro)return;if(this.recording)return this.toggleRecording(e);try{this.$inReplay=true;this.macro.forEach(function(x){if(typeof x=="string")this.exec(x,e);else this.exec(x[0],e,x[1]);},this);}finally{this.$inReplay=false;}};this.trimMacro=function(m){return m.map(function(x){if(typeof x[0]!="string")x[0]=x[0].name;if(!x[1])x=x[0];return x;});};}).call(C.prototype);a.CommandManager=C;});ace.define("ace/commands/default_commands",[],function(r,a,m){"use strict";var l=r("../lib/lang");var c=r("../config");var R=r("../range").Range;function b(w,d){return{win:w,mac:d};}a.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:b("Ctrl-,","Command-,"),exec:function(e){c.loadModule("ace/ext/settings_menu",function(m){m.init(e);e.showSettingsMenu();});},readOnly:true},{name:"goToNextError",description:"Go to next error",bindKey:b("Alt-E","F4"),exec:function(e){c.loadModule("./ext/error_marker",function(m){m.showErrorMarker(e,1);});},scrollIntoView:"animate",readOnly:true},{name:"goToPreviousError",description:"Go to previous error",bindKey:b("Alt-Shift-E","Shift-F4"),exec:function(e){c.loadModule("./ext/error_marker",function(m){m.showErrorMarker(e,-1);});},scrollIntoView:"animate",readOnly:true},{name:"selectall",description:"Select all",bindKey:b("Ctrl-A","Command-A"),exec:function(e){e.selectAll();},readOnly:true},{name:"centerselection",description:"Center selection",bindKey:b(null,"Ctrl-L"),exec:function(e){e.centerSelection();},readOnly:true},{name:"gotoline",description:"Go to line...",bindKey:b("Ctrl-L","Command-L"),exec:function(e,d){if(typeof d==="number"&&!isNaN(d))e.gotoLine(d);e.prompt({$type:"gotoLine"});},readOnly:true},{name:"fold",bindKey:b("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(false);},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"unfold",bindKey:b("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(true);},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:b("F2","F2"),exec:function(e){e.session.toggleFoldWidget();},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:b("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(true);},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"foldall",description:"Fold all",bindKey:b(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll();},scrollIntoView:"center",readOnly:true},{name:"foldAllComments",description:"Fold all comments",bindKey:b(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAllComments();},scrollIntoView:"center",readOnly:true},{name:"foldOther",description:"Fold other",bindKey:b("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll();e.session.unfold(e.selection.getAllRanges());},scrollIntoView:"center",readOnly:true},{name:"unfoldall",description:"Unfold all",bindKey:b("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold();},scrollIntoView:"center",readOnly:true},{name:"findnext",description:"Find next",bindKey:b("Ctrl-K","Command-G"),exec:function(e){e.findNext();},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"findprevious",description:"Find previous",bindKey:b("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious();},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:true},{name:"selectOrFindNext",description:"Select or find next",bindKey:b("Alt-K","Ctrl-G"),exec:function(e){if(e.selection.isEmpty())e.selection.selectWord();else e.findNext();},readOnly:true},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:b("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){if(e.selection.isEmpty())e.selection.selectWord();else e.findPrevious();},readOnly:true},{name:"find",description:"Find",bindKey:b("Ctrl-F","Command-F"),exec:function(d){c.loadModule("ace/ext/searchbox",function(e){e.Search(d);});},readOnly:true},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite();},readOnly:true},{name:"selecttostart",description:"Select to start",bindKey:b("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart();},multiSelectAction:"forEach",readOnly:true,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:b("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart();},multiSelectAction:"forEach",readOnly:true,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:b("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"golineup",description:"Go line up",bindKey:b("Up","Up|Ctrl-P"),exec:function(e,d){e.navigateUp(d.times);},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selecttoend",description:"Select to end",bindKey:b("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd();},multiSelectAction:"forEach",readOnly:true,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:b("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd();},multiSelectAction:"forEach",readOnly:true,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:b("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"golinedown",description:"Go line down",bindKey:b("Down","Down|Ctrl-N"),exec:function(e,d){e.navigateDown(d.times);},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectwordleft",description:"Select word left",bindKey:b("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotowordleft",description:"Go to word left",bindKey:b("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selecttolinestart",description:"Select to line start",bindKey:b("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotolinestart",description:"Go to line start",bindKey:b("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectleft",description:"Select left",bindKey:b("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotoleft",description:"Go to left",bindKey:b("Left","Left|Ctrl-B"),exec:function(e,d){e.navigateLeft(d.times);},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectwordright",description:"Select word right",bindKey:b("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotowordright",description:"Go to word right",bindKey:b("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selecttolineend",description:"Select to line end",bindKey:b("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotolineend",description:"Go to line end",bindKey:b("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectright",description:"Select right",bindKey:b("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"gotoright",description:"Go to right",bindKey:b("Right","Right|Ctrl-F"),exec:function(e,d){e.navigateRight(d.times);},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown();},readOnly:true},{name:"pagedown",description:"Page down",bindKey:b(null,"Option-PageDown"),exec:function(e){e.scrollPageDown();},readOnly:true},{name:"gotopagedown",description:"Go to page down",bindKey:b("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown();},readOnly:true},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp();},readOnly:true},{name:"pageup",description:"Page up",bindKey:b(null,"Option-PageUp"),exec:function(e){e.scrollPageUp();},readOnly:true},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp();},readOnly:true},{name:"scrollup",description:"Scroll up",bindKey:b("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight);},readOnly:true},{name:"scrolldown",description:"Scroll down",bindKey:b("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight);},readOnly:true},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd();},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"togglerecording",description:"Toggle recording",bindKey:b("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e);},readOnly:true},{name:"replaymacro",description:"Replay macro",bindKey:b("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e);},readOnly:true},{name:"jumptomatching",description:"Jump to matching",bindKey:b("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching();},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:true},{name:"selecttomatching",description:"Select to matching",bindKey:b("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(true);},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:true},{name:"expandToMatching",description:"Expand to matching",bindKey:b("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(true,true);},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:true},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:b(null,null),exec:function(){},passEvent:true,readOnly:true},{name:"copy",description:"Copy",exec:function(e){},readOnly:true},{name:"cut",description:"Cut",exec:function(e){var d=e.$copyWithEmptySelection&&e.selection.isEmpty();var f=d?e.selection.getLineRange():e.selection.getRange();e._emit("cut",f);if(!f.isEmpty())e.session.remove(f);e.clearSelection();},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,d){e.$handlePaste(d);},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:b("Ctrl-D","Command-D"),exec:function(e){e.removeLines();},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:b("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection();},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:b("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines();},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:b("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines();},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:b("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment();},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:b("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1);},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:b("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1);},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:b("Ctrl-H","Command-Option-F"),exec:function(d){c.loadModule("ace/ext/searchbox",function(e){e.Search(d,true);});}},{name:"undo",description:"Undo",bindKey:b("Ctrl-Z","Command-Z"),exec:function(e){e.undo();}},{name:"redo",description:"Redo",bindKey:b("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo();}},{name:"copylinesup",description:"Copy lines up",bindKey:b("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp();},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:b("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp();},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:b("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown();},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:b("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown();},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:b("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right");},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:b("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left");},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:b("Shift-Delete",null),exec:function(e){if(e.selection.isEmpty()){e.remove("left");}else{return false;}},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:b("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:b("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:b("Ctrl-Shift-Backspace",null),exec:function(e){var d=e.selection.getRange();d.start.column=0;e.session.remove(d);},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:b("Ctrl-Shift-Delete",null),exec:function(e){var d=e.selection.getRange();d.end.column=Number.MAX_VALUE;e.session.remove(d);},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:b("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:b("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:b("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent();},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:b("Tab","Tab"),exec:function(e){e.indent();},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:b("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent();},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:b("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent();},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,s){e.insert(s);},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,d){e.insert(l.stringRepeat(d.text||"",d.times||1));},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:b(null,"Ctrl-O"),exec:function(e){e.splitLine();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:b("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters();},multiSelectAction:function(e){e.transposeSelections(1);},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:b("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:b("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:b(null,null),exec:function(e){e.autoIndent();},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:b("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var d=e.selection.getRange();d.start.column=d.end.column=0;d.end.row++;e.selection.setRange(d,false);},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:true},{name:"joinlines",description:"Join lines",bindKey:b(null,null),exec:function(e){var d=e.selection.isBackwards();var s=d?e.selection.getSelectionLead():e.selection.getSelectionAnchor();var f=d?e.selection.getSelectionAnchor():e.selection.getSelectionLead();var g=e.session.doc.getLine(s.row).length;var h=e.session.doc.getTextRange(e.selection.getRange());var j=h.replace(/\n\s*/," ").length;var k=e.session.doc.getLine(s.row);for(var i=s.row+1;i<=f.row+1;i++){var n=l.stringTrimLeft(l.stringTrimRight(e.session.doc.getLine(i)));if(n.length!==0){n=" "+n;}k+=n;}if(f.row+1<(e.session.doc.getLength()-1)){k+=e.session.doc.getNewLineCharacter();}e.clearSelection();e.session.doc.replace(new R(s.row,0,f.row+2,0),k);if(j>0){e.selection.moveCursorTo(s.row,s.column);e.selection.selectTo(s.row,s.column+j);}else{g=e.session.doc.getLine(s.row).length>g?(g+1):g;e.selection.moveCursorTo(s.row,g);}},multiSelectAction:"forEach",readOnly:true},{name:"invertSelection",description:"Invert selection",bindKey:b(null,null),exec:function(e){var d=e.session.doc.getLength()-1;var f=e.session.doc.getLine(d).length;var g=e.selection.rangeList.ranges;var n=[];if(g.length<1){g=[e.selection.getRange()];}for(var i=0;i<g.length;i++){if(i==(g.length-1)){if(!(g[i].end.row===d&&g[i].end.column===f)){n.push(new R(g[i].end.row,g[i].end.column,d,f));}}if(i===0){if(!(g[i].start.row===0&&g[i].start.column===0)){n.push(new R(0,0,g[i].start.row,g[i].start.column));}}else{n.push(new R(g[i-1].end.row,g[i-1].end.column,g[i].start.row,g[i].start.column));}}e.exitMultiSelectMode();e.clearSelection();for(var i=0;i<n.length;i++){e.selection.addRange(n[i],false);}},readOnly:true,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(e){e.selection.clearSelection();e.navigateLineEnd();e.insert("\n");},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(e){e.selection.clearSelection();var d=e.getCursorPosition();e.selection.moveTo(d.row-1,Number.MAX_VALUE);e.insert("\n");if(d.row===0)e.navigateUp();},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command pallete",bindKey:b("F1","F1"),exec:function(e){e.prompt({$type:"commands"});},readOnly:true},{name:"modeSelect",description:"Change language mode...",bindKey:b(null,null),exec:function(e){e.prompt({$type:"modes"});},readOnly:true}];for(var i=1;i<9;i++){a.commands.push({name:"foldToLevel"+i,description:"Fold To Level "+i,level:i,exec:function(e){e.session.foldToLevel(this.level);},scrollIntoView:"center",readOnly:true});}});ace.define("ace/editor",[],function(f,g,h){"use strict";f("./lib/fixoldbrowsers");var o=f("./lib/oop");var k=f("./lib/dom");var n=f("./lib/lang");var u=f("./lib/useragent");var T=f("./keyboard/textinput").TextInput;var M=f("./mouse/mouse_handler").MouseHandler;var F=f("./mouse/fold_handler").FoldHandler;var K=f("./keyboard/keybinding").KeyBinding;var E=f("./edit_session").EditSession;var S=f("./search").Search;var R=f("./range").Range;var p=f("./lib/event_emitter").EventEmitter;var C=f("./commands/command_manager").CommandManager;var q=f("./commands/default_commands").commands;var v=f("./config");var w=f("./token_iterator").TokenIterator;var x=f("./clipboard");var y=function(r,s,a){this.$toDestroy=[];var c=r.getContainerElement();this.container=c;this.renderer=r;this.id="editor"+(++y.$uid);this.commands=new C(u.isMac?"mac":"win",q);if(typeof document=="object"){this.textInput=new T(r.getTextAreaContainer(),this);this.renderer.textarea=this.textInput.getElement();this.$mouseHandler=new M(this);new F(this);}this.keyBinding=new K(this);this.$search=new S().set({wrap:true});this.$historyTracker=this.$historyTracker.bind(this);this.commands.on("exec",this.$historyTracker);this.$initOperationListeners();this._$emitInputEvent=n.delayedCall(function(){this._signal("input",{});if(this.session&&this.session.bgTokenizer)this.session.bgTokenizer.scheduleStart();}.bind(this));this.on("change",function(_,b){b._$emitInputEvent.schedule(31);});this.setSession(s||a&&a.session||new E(""));v.resetOptions(this);if(a)this.setOptions(a);v._signal("editor",this);};y.$uid=0;(function(){o.implement(this,p);this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),true);this.commands.on("afterExec",this.endOperation.bind(this),true);this.$opResetTimer=n.delayedCall(this.endOperation.bind(this,true));this.on("change",function(){if(!this.curOp){this.startOperation();this.curOp.selectionBefore=this.$lastSel;}this.curOp.docChanged=true;}.bind(this),true);this.on("changeSelection",function(){if(!this.curOp){this.startOperation();this.curOp.selectionBefore=this.$lastSel;}this.curOp.selectionChanged=true;}.bind(this),true);};this.curOp=null;this.prevOp={};this.startOperation=function(c){if(this.curOp){if(!c||this.curOp.command)return;this.prevOp=this.curOp;}if(!c){this.previousCommand=null;c={};}this.$opResetTimer.schedule();this.curOp=this.session.curOp={command:c.command||{},args:c.args,scrollTop:this.renderer.scrollTop};this.curOp.selectionBefore=this.selection.toJSON();};this.endOperation=function(e){if(this.curOp&&this.session){if(e&&e.returnValue===false||!this.session)return(this.curOp=null);if(e==true&&this.curOp.command&&this.curOp.command.name=="mouse")return;this._signal("beforeEndOperation");if(!this.curOp)return;var c=this.curOp.command;var s=c&&c.scrollIntoView;if(s){switch(s){case"center-animate":s="animate";case"center":this.renderer.scrollCursorIntoView(null,0.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var r=this.selection.getRange();var v=this.renderer.layerConfig;if(r.start.row>=v.lastRow||r.end.row<=v.firstRow){this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead);}break;default:break;}if(s=="animate")this.renderer.animateScrolling(this.curOp.scrollTop);}var a=this.selection.toJSON();this.curOp.selectionAfter=a;this.$lastSel=this.selection.toJSON();this.session.getUndoManager().addSelection(a);this.prevOp=this.curOp;this.curOp=null;}};this.$mergeableCommands=["backspace","del","insertstring"];this.$historyTracker=function(e){if(!this.$mergeUndoDeltas)return;var a=this.prevOp;var m=this.$mergeableCommands;var s=a.command&&(e.command.name==a.command.name);if(e.command.name=="insertstring"){var t=e.args;if(this.mergeNextCommand===undefined)this.mergeNextCommand=true;s=s&&this.mergeNextCommand&&(!/\s/.test(t)||/\s/.test(a.args));this.mergeNextCommand=true;}else{s=s&&m.indexOf(e.command.name)!==-1;}if(this.$mergeUndoDeltas!="always"&&Date.now()-this.sequenceStartTime>2000){s=false;}if(s)this.session.mergeUndoDeltas=true;else if(m.indexOf(e.command.name)!==-1)this.sequenceStartTime=Date.now();};this.setKeyboardHandler=function(a,c){if(a&&typeof a==="string"&&a!="ace"){this.$keybindingId=a;var _=this;v.loadModule(["keybinding",a],function(h){if(_.$keybindingId==a)_.keyBinding.setKeyboardHandler(h&&h.handler);c&&c();});}else{this.$keybindingId=null;this.keyBinding.setKeyboardHandler(a);c&&c();}};this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler();};this.setSession=function(s){if(this.session==s)return;if(this.curOp)this.endOperation();this.curOp={};var a=this.session;if(a){this.session.off("change",this.$onDocumentChange);this.session.off("changeMode",this.$onChangeMode);this.session.off("tokenizerUpdate",this.$onTokenizerUpdate);this.session.off("changeTabSize",this.$onChangeTabSize);this.session.off("changeWrapLimit",this.$onChangeWrapLimit);this.session.off("changeWrapMode",this.$onChangeWrapMode);this.session.off("changeFold",this.$onChangeFold);this.session.off("changeFrontMarker",this.$onChangeFrontMarker);this.session.off("changeBackMarker",this.$onChangeBackMarker);this.session.off("changeBreakpoint",this.$onChangeBreakpoint);this.session.off("changeAnnotation",this.$onChangeAnnotation);this.session.off("changeOverwrite",this.$onCursorChange);this.session.off("changeScrollTop",this.$onScrollTopChange);this.session.off("changeScrollLeft",this.$onScrollLeftChange);var b=this.session.getSelection();b.off("changeCursor",this.$onCursorChange);b.off("changeSelection",this.$onSelectionChange);}this.session=s;if(s){this.$onDocumentChange=this.onDocumentChange.bind(this);s.on("change",this.$onDocumentChange);this.renderer.setSession(s);this.$onChangeMode=this.onChangeMode.bind(this);s.on("changeMode",this.$onChangeMode);this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this);s.on("tokenizerUpdate",this.$onTokenizerUpdate);this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer);s.on("changeTabSize",this.$onChangeTabSize);this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this);s.on("changeWrapLimit",this.$onChangeWrapLimit);this.$onChangeWrapMode=this.onChangeWrapMode.bind(this);s.on("changeWrapMode",this.$onChangeWrapMode);this.$onChangeFold=this.onChangeFold.bind(this);s.on("changeFold",this.$onChangeFold);this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this);this.session.on("changeFrontMarker",this.$onChangeFrontMarker);this.$onChangeBackMarker=this.onChangeBackMarker.bind(this);this.session.on("changeBackMarker",this.$onChangeBackMarker);this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this);this.session.on("changeBreakpoint",this.$onChangeBreakpoint);this.$onChangeAnnotation=this.onChangeAnnotation.bind(this);this.session.on("changeAnnotation",this.$onChangeAnnotation);this.$onCursorChange=this.onCursorChange.bind(this);this.session.on("changeOverwrite",this.$onCursorChange);this.$onScrollTopChange=this.onScrollTopChange.bind(this);this.session.on("changeScrollTop",this.$onScrollTopChange);this.$onScrollLeftChange=this.onScrollLeftChange.bind(this);this.session.on("changeScrollLeft",this.$onScrollLeftChange);this.selection=s.getSelection();this.selection.on("changeCursor",this.$onCursorChange);this.$onSelectionChange=this.onSelectionChange.bind(this);this.selection.on("changeSelection",this.$onSelectionChange);this.onChangeMode();this.onCursorChange();this.onScrollTopChange();this.onScrollLeftChange();this.onSelectionChange();this.onChangeFrontMarker();this.onChangeBackMarker();this.onChangeBreakpoint();this.onChangeAnnotation();this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit();this.renderer.updateFull();}else{this.selection=null;this.renderer.setSession(s);}this._signal("changeSession",{session:s,oldSession:a});this.curOp=null;a&&a._signal("changeEditor",{oldEditor:this});s&&s._signal("changeEditor",{editor:this});if(s&&s.bgTokenizer)s.bgTokenizer.scheduleStart();};this.getSession=function(){return this.session;};this.setValue=function(a,c){this.session.doc.setValue(a);if(!c)this.selectAll();else if(c==1)this.navigateFileEnd();else if(c==-1)this.navigateFileStart();return a;};this.getValue=function(){return this.session.getValue();};this.getSelection=function(){return this.selection;};this.resize=function(a){this.renderer.onResize(a);};this.setTheme=function(t,c){this.renderer.setTheme(t,c);};this.getTheme=function(){return this.renderer.getTheme();};this.setStyle=function(s){this.renderer.setStyle(s);};this.unsetStyle=function(s){this.renderer.unsetStyle(s);};this.getFontSize=function(){return this.getOption("fontSize")||k.computedStyle(this.container).fontSize;};this.setFontSize=function(s){this.setOption("fontSize",s);};this.$highlightBrackets=function(){if(this.$highlightPending){return;}var s=this;this.$highlightPending=true;setTimeout(function(){s.$highlightPending=false;var a=s.session;if(!a||!a.bgTokenizer)return;if(a.$bracketHighlight){a.$bracketHighlight.markerIds.forEach(function(i){a.removeMarker(i);});a.$bracketHighlight=null;}var r=a.getMatchingBracketRanges(s.getCursorPosition());if(!r&&a.$mode.getMatching)r=a.$mode.getMatching(s.session);if(!r)return;var m="ace_bracket";if(!Array.isArray(r)){r=[r];}else if(r.length==1){m="ace_error_bracket";}if(r.length==2){if(R.comparePoints(r[0].end,r[1].start)==0)r=[R.fromPoints(r[0].start,r[1].end)];else if(R.comparePoints(r[0].start,r[1].end)==0)r=[R.fromPoints(r[1].start,r[0].end)];}a.$bracketHighlight={ranges:r,markerIds:r.map(function(b){return a.addMarker(b,m,"text");})};},50);};this.$highlightTags=function(){if(this.$highlightTagPending)return;var s=this;this.$highlightTagPending=true;setTimeout(function(){s.$highlightTagPending=false;var a=s.session;if(!a||!a.bgTokenizer)return;var b=s.getCursorPosition();var c=new w(s.session,b.row,b.column);var t=c.getCurrentToken();if(!t||!/\b(?:tag-open|tag-name)/.test(t.type)){a.removeMarker(a.$tagHighlight);a.$tagHighlight=null;return;}if(t.type.indexOf("tag-open")!==-1){t=c.stepForward();if(!t)return;}var d=t.value;var e=t.value;var j=0;var l=c.stepBackward();if(l.value==='<'){do{l=t;t=c.stepForward();if(t){if(t.type.indexOf('tag-name')!==-1){e=t.value;if(d===e){if(l.value==='<'){j++;}else if(l.value==='</'){j--;}}}else if(d===e&&t.value==='/>'){j--;}}}while(t&&j>=0);}else{do{t=l;l=c.stepBackward();if(t){if(t.type.indexOf('tag-name')!==-1){if(d===t.value){if(l.value==='<'){j++;}else if(l.value==='</'){j--;}}}else if(t.value==='/>'){var m=0;var r=l;while(r){if(r.type.indexOf('tag-name')!==-1&&r.value===d){j--;break;}else if(r.value==='<'){break;}r=c.stepBackward();m++;}for(var i=0;i<m;i++){c.stepForward();}}}}while(l&&j<=0);c.stepForward();}if(!t){a.removeMarker(a.$tagHighlight);a.$tagHighlight=null;return;}var A=c.getCurrentTokenRow();var B=c.getCurrentTokenColumn();var D=new R(A,B,A,B+t.value.length);var G=a.$backMarkers[a.$tagHighlight];if(a.$tagHighlight&&G!=undefined&&D.compareRange(G.range)!==0){a.removeMarker(a.$tagHighlight);a.$tagHighlight=null;}if(!a.$tagHighlight)a.$tagHighlight=a.addMarker(D,"ace_bracket","text");},50);};this.focus=function(){var _=this;setTimeout(function(){if(!_.isFocused())_.textInput.focus();});this.textInput.focus();};this.isFocused=function(){return this.textInput.isFocused();};this.blur=function(){this.textInput.blur();};this.onFocus=function(e){if(this.$isFocused)return;this.$isFocused=true;this.renderer.showCursor();this.renderer.visualizeFocus();this._emit("focus",e);};this.onBlur=function(e){if(!this.$isFocused)return;this.$isFocused=false;this.renderer.hideCursor();this.renderer.visualizeBlur();this._emit("blur",e);};this.$cursorChange=function(){this.renderer.updateCursor();this.$highlightBrackets();this.$highlightTags();this.$updateHighlightActiveLine();};this.onDocumentChange=function(d){var a=this.session.$useWrapMode;var l=(d.start.row==d.end.row?d.end.row:Infinity);this.renderer.updateLines(d.start.row,l,a);this._signal("change",d);this.$cursorChange();};this.onTokenizerUpdate=function(e){var r=e.data;this.renderer.updateLines(r.first,r.last);};this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop());};this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft());};this.onCursorChange=function(){this.$cursorChange();this._signal("changeSelection");};this.$updateHighlightActiveLine=function(){var s=this.getSession();var a;if(this.$highlightActiveLine){if(this.$selectionStyle!="line"||!this.selection.isMultiLine())a=this.getCursorPosition();if(this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty())a=false;if(this.renderer.$maxLines&&this.session.getLength()===1&&!(this.renderer.$minLines>1))a=false;}if(s.$highlightLineMarker&&!a){s.removeMarker(s.$highlightLineMarker.id);s.$highlightLineMarker=null;}else if(!s.$highlightLineMarker&&a){var r=new R(a.row,a.column,a.row,Infinity);r.id=s.addMarker(r,"ace_active-line","screenLine");s.$highlightLineMarker=r;}else if(a){s.$highlightLineMarker.start.row=a.row;s.$highlightLineMarker.end.row=a.row;s.$highlightLineMarker.start.column=a.column;s._signal("changeBackMarker");}};this.onSelectionChange=function(e){var s=this.session;if(s.$selectionMarker){s.removeMarker(s.$selectionMarker);}s.$selectionMarker=null;if(!this.selection.isEmpty()){var r=this.selection.getRange();var a=this.getSelectionStyle();s.$selectionMarker=s.addMarker(r,"ace_selection",a);}else{this.$updateHighlightActiveLine();}var b=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(b);this._signal("changeSelection");};this.$getSelectionHighLightRegexp=function(){var s=this.session;var a=this.getSelectionRange();if(a.isEmpty()||a.isMultiLine())return;var b=a.start.column;var e=a.end.column;var l=s.getLine(a.start.row);var c=l.substring(b,e);if(c.length>5000||!/[\w\d]/.test(c))return;var r=this.$search.$assembleRegExp({wholeWord:true,caseSensitive:true,needle:c});var d=l.substring(b-1,e+1);if(!r.test(d))return;return r;};this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers();};this.onChangeBackMarker=function(){this.renderer.updateBackMarkers();};this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints();};this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations());};this.onChangeMode=function(e){this.renderer.updateText();this._emit("changeMode",e);};this.onChangeWrapLimit=function(){this.renderer.updateFull();};this.onChangeWrapMode=function(){this.renderer.onResize(true);};this.onChangeFold=function(){this.$updateHighlightActiveLine();this.renderer.updateFull();};this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange());};this.getCopyText=function(){var t=this.getSelectedText();var a=this.session.doc.getNewLineCharacter();var c=false;if(!t&&this.$copyWithEmptySelection){c=true;var r=this.selection.getAllRanges();for(var i=0;i<r.length;i++){var b=r[i];if(i&&r[i-1].start.row==b.start.row)continue;t+=this.session.getLine(b.start.row)+a;}}var e={text:t};this._signal("copy",e);x.lineMode=c?e.text:false;return e.text;};this.onCopy=function(){this.commands.exec("copy",this);};this.onCut=function(){this.commands.exec("cut",this);};this.onPaste=function(t,a){var e={text:t,event:a};this.commands.exec("paste",this,e);};this.$handlePaste=function(e){if(typeof e=="string")e={text:e};this._signal("paste",e);var t=e.text;var l=t===x.lineMode;var s=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode){if(l)s.insert({row:this.selection.lead.row,column:0},t);else this.insert(t);}else if(l){this.selection.rangeList.ranges.forEach(function(c){s.insert({row:c.start.row,column:0},t);});}else{var a=t.split(/\r\n|\r|\n/);var r=this.selection.rangeList.ranges;var b=a.length==2&&(!a[0]||!a[1]);if(a.length!=r.length||b)return this.commands.exec("insertstring",this,t);for(var i=r.length;i--;){var c=r[i];if(!c.isEmpty())s.remove(c);s.insert(c.start,a[i]);}}};this.execCommand=function(c,a){return this.commands.exec(c,this,a);};this.insert=function(t,a){var s=this.session;var m=s.getMode();var c=this.getCursorPosition();if(this.getBehavioursEnabled()&&!a){var b=m.transformAction(s.getState(c.row),'insertion',this,s,t);if(b){if(t!==b.text){if(!this.inVirtualSelectionMode){this.session.mergeUndoDeltas=false;this.mergeNextCommand=false;}}t=b.text;}}if(t=="\t")t=this.session.getTabString();if(!this.selection.isEmpty()){var r=this.getSelectionRange();c=this.session.remove(r);this.clearSelection();}else if(this.session.getOverwrite()&&t.indexOf("\n")==-1){var r=new R.fromPoints(c,c);r.end.column+=t.length;this.session.remove(r);}if(t=="\n"||t=="\r\n"){var l=s.getLine(c.row);if(c.column>l.search(/\S|$/)){var d=l.substr(c.column).search(/\S|$/);s.doc.removeInLine(c.row,c.column,c.column+d);}}this.clearSelection();var e=c.column;var i=s.getState(c.row);var l=s.getLine(c.row);var j=m.checkOutdent(i,l,t);s.insert(c,t);if(b&&b.selection){if(b.selection.length==2){this.selection.setSelectionRange(new R(c.row,e+b.selection[0],c.row,e+b.selection[1]));}else{this.selection.setSelectionRange(new R(c.row+b.selection[0],b.selection[1],c.row+b.selection[2],b.selection[3]));}}if(this.$enableAutoIndent){if(s.getDocument().isNewLine(t)){var A=m.getNextLineIndent(i,l.slice(0,c.column),s.getTabString());s.insert({row:c.row+1,column:0},A);}if(j)m.autoOutdent(i,s,c.row);}};this.autoIndent=function(){var s=this.session;var m=s.getMode();var a,e;if(this.selection.isEmpty()){a=0;e=s.doc.getLength()-1;}else{var b=this.getSelectionRange();a=b.start.row;e=b.end.row;}var c="";var d="";var l="";var i,j,r;var t=s.getTabString();for(var A=a;A<=e;A++){if(A>0){c=s.getState(A-1);d=s.getLine(A-1);l=m.getNextLineIndent(c,d,t);}i=s.getLine(A);j=m.$getIndent(i);if(l!==j){if(j.length>0){r=new R(A,0,A,j.length);s.remove(r);}if(l.length>0){s.insert({row:A,column:0},l);}}m.autoOutdent(c,s,A);}};this.onTextInput=function(t,c){if(!c)return this.keyBinding.onTextInput(t);this.startOperation({command:{name:"insertstring"}});var a=this.applyComposition.bind(this,t,c);if(this.selection.rangeCount)this.forEachSelection(a);else a();this.endOperation();};this.applyComposition=function(t,c){if(c.extendLeft||c.extendRight){var r=this.selection.getRange();r.start.column-=c.extendLeft;r.end.column+=c.extendRight;if(r.start.column<0){r.start.row--;r.start.column+=this.session.getLine(r.start.row).length+1;}this.selection.setRange(r);if(!t&&!r.isEmpty())this.remove();}if(t||!this.selection.isEmpty())this.insert(t,true);if(c.restoreStart||c.restoreEnd){var r=this.selection.getRange();r.start.column-=c.restoreStart;r.end.column-=c.restoreEnd;this.selection.setRange(r);}};this.onCommandKey=function(e,a,b){return this.keyBinding.onCommandKey(e,a,b);};this.setOverwrite=function(a){this.session.setOverwrite(a);};this.getOverwrite=function(){return this.session.getOverwrite();};this.toggleOverwrite=function(){this.session.toggleOverwrite();};this.setScrollSpeed=function(s){this.setOption("scrollSpeed",s);};this.getScrollSpeed=function(){return this.getOption("scrollSpeed");};this.setDragDelay=function(d){this.setOption("dragDelay",d);};this.getDragDelay=function(){return this.getOption("dragDelay");};this.setSelectionStyle=function(a){this.setOption("selectionStyle",a);};this.getSelectionStyle=function(){return this.getOption("selectionStyle");};this.setHighlightActiveLine=function(s){this.setOption("highlightActiveLine",s);};this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine");};this.setHighlightGutterLine=function(s){this.setOption("highlightGutterLine",s);};this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine");};this.setHighlightSelectedWord=function(s){this.setOption("highlightSelectedWord",s);};this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord;};this.setAnimatedScroll=function(s){this.renderer.setAnimatedScroll(s);};this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll();};this.setShowInvisibles=function(s){this.renderer.setShowInvisibles(s);};this.getShowInvisibles=function(){return this.renderer.getShowInvisibles();};this.setDisplayIndentGuides=function(d){this.renderer.setDisplayIndentGuides(d);};this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides();};this.setShowPrintMargin=function(s){this.renderer.setShowPrintMargin(s);};this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin();};this.setPrintMarginColumn=function(s){this.renderer.setPrintMarginColumn(s);};this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn();};this.setReadOnly=function(r){this.setOption("readOnly",r);};this.getReadOnly=function(){return this.getOption("readOnly");};this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e);};this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled");};this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e);};this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled");};this.setShowFoldWidgets=function(s){this.setOption("showFoldWidgets",s);};this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets");};this.setFadeFoldWidgets=function(a){this.setOption("fadeFoldWidgets",a);};this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets");};this.remove=function(d){if(this.selection.isEmpty()){if(d=="left")this.selection.selectLeft();else this.selection.selectRight();}var r=this.getSelectionRange();if(this.getBehavioursEnabled()){var s=this.session;var a=s.getState(r.start.row);var b=s.getMode().transformAction(a,'deletion',this,s,r);if(r.end.column===0){var t=s.getTextRange(r);if(t[t.length-1]=="\n"){var l=s.getLine(r.end.row);if(/^\s+$/.test(l)){r.end.column=l.length;}}}if(b)r=b;}this.session.remove(r);this.clearSelection();};this.removeWordRight=function(){if(this.selection.isEmpty())this.selection.selectWordRight();this.session.remove(this.getSelectionRange());this.clearSelection();};this.removeWordLeft=function(){if(this.selection.isEmpty())this.selection.selectWordLeft();this.session.remove(this.getSelectionRange());this.clearSelection();};this.removeToLineStart=function(){if(this.selection.isEmpty())this.selection.selectLineStart();if(this.selection.isEmpty())this.selection.selectLeft();this.session.remove(this.getSelectionRange());this.clearSelection();};this.removeToLineEnd=function(){if(this.selection.isEmpty())this.selection.selectLineEnd();var r=this.getSelectionRange();if(r.start.column==r.end.column&&r.start.row==r.end.row){r.end.column=0;r.end.row++;}this.session.remove(r);this.clearSelection();};this.splitLine=function(){if(!this.selection.isEmpty()){this.session.remove(this.getSelectionRange());this.clearSelection();}var c=this.getCursorPosition();this.insert("\n");this.moveCursorToPosition(c);};this.transposeLetters=function(){if(!this.selection.isEmpty()){return;}var c=this.getCursorPosition();var a=c.column;if(a===0)return;var l=this.session.getLine(c.row);var s,r;if(a<l.length){s=l.charAt(a)+l.charAt(a-1);r=new R(c.row,a-1,c.row,a+1);}else{s=l.charAt(a-1)+l.charAt(a-2);r=new R(c.row,a-2,c.row,a);}this.session.replace(r,s);this.session.selection.moveToPosition(r.end);};this.toLowerCase=function(){var a=this.getSelectionRange();if(this.selection.isEmpty()){this.selection.selectWord();}var r=this.getSelectionRange();var t=this.session.getTextRange(r);this.session.replace(r,t.toLowerCase());this.selection.setSelectionRange(a);};this.toUpperCase=function(){var a=this.getSelectionRange();if(this.selection.isEmpty()){this.selection.selectWord();}var r=this.getSelectionRange();var t=this.session.getTextRange(r);this.session.replace(r,t.toUpperCase());this.selection.setSelectionRange(a);};this.indent=function(){var s=this.session;var r=this.getSelectionRange();if(r.start.row<r.end.row){var a=this.$getSelectedRows();s.indentRows(a.first,a.last,"\t");return;}else if(r.start.column<r.end.column){var t=s.getTextRange(r);if(!/^\s+$/.test(t)){var a=this.$getSelectedRows();s.indentRows(a.first,a.last,"\t");return;}}var l=s.getLine(r.start.row);var b=r.start;var c=s.getTabSize();var d=s.documentToScreenColumn(b.row,b.column);if(this.session.getUseSoftTabs()){var e=(c-d%c);var i=n.stringRepeat(" ",e);}else{var e=d%c;while(l[r.start.column-1]==" "&&e){r.start.column--;e--;}this.selection.setSelectionRange(r);i="\t";}return this.insert(i);};this.blockIndent=function(){var r=this.$getSelectedRows();this.session.indentRows(r.first,r.last,"\t");};this.blockOutdent=function(){var s=this.session.getSelection();this.session.outdentRows(s.getRange());};this.sortLines=function(){var r=this.$getSelectedRows();var s=this.session;var l=[];for(var i=r.first;i<=r.last;i++)l.push(s.getLine(i));l.sort(function(a,b){if(a.toLowerCase()<b.toLowerCase())return-1;if(a.toLowerCase()>b.toLowerCase())return 1;return 0;});var d=new R(0,0,0,0);for(var i=r.first;i<=r.last;i++){var c=s.getLine(i);d.start.row=i;d.end.row=i;d.end.column=c.length;s.replace(d,l[i-r.first]);}};this.toggleCommentLines=function(){var s=this.session.getState(this.getCursorPosition().row);var r=this.$getSelectedRows();this.session.getMode().toggleCommentLines(s,this.session,r.first,r.last);};this.toggleBlockComment=function(){var c=this.getCursorPosition();var s=this.session.getState(c.row);var r=this.getSelectionRange();this.session.getMode().toggleBlockComment(s,this.session,r,c);};this.getNumberAt=function(r,c){var _=/[\-]?[0-9]+(?:\.[0-9]+)?/g;_.lastIndex=0;var s=this.session.getLine(r);while(_.lastIndex<c){var m=_.exec(s);if(m.index<=c&&m.index+m[0].length>=c){var a={value:m[0],start:m.index,end:m.index+m[0].length};return a;}}return null;};this.modifyNumber=function(a){var r=this.selection.getCursor().row;var b=this.selection.getCursor().column;var d=new R(r,b-1,r,b);var c=this.session.getTextRange(d);if(!isNaN(parseFloat(c))&&isFinite(c)){var e=this.getNumberAt(r,b);if(e){var i=e.value.indexOf(".")>=0?e.start+e.value.indexOf(".")+1:e.end;var j=e.start+e.value.length-i;var t=parseFloat(e.value);t*=Math.pow(10,j);if(i!==e.end&&b<i){a*=Math.pow(10,e.end-b-1);}else{a*=Math.pow(10,e.end-b);}t+=a;t/=Math.pow(10,j);var l=t.toFixed(j);var m=new R(r,e.start,r,e.end);this.session.replace(m,l);this.moveCursorTo(r,Math.max(e.start+1,b+l.length-e.value.length));}}else{this.toggleWord();}};this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]];this.toggleWord=function(){var r=this.selection.getCursor().row;var c=this.selection.getCursor().column;this.selection.selectWord();var a=this.getSelectedText();var b=this.selection.getWordRange().start.column;var d=a.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,'$1 ').split(/\s/);var e=c-b-1;if(e<0)e=0;var l=0,m=0;var t=this;if(a.match(/[A-Za-z0-9_]+/)){d.forEach(function(B,i){m=l+B.length;if(e>=l&&e<=m){a=B;t.selection.clearSelection();t.moveCursorTo(r,l+b);t.selection.selectTo(r,m+b);}l=m;});}var s=this.$toggleWordPairs;var A;for(var i=0;i<s.length;i++){var B=s[i];for(var j=0;j<=1;j++){var D=+!j;var G=a.match(new RegExp('^\\s?_?('+n.escapeRegExp(B[j])+')\\s?$','i'));if(G){var H=a.match(new RegExp('([_]|^|\\s)('+n.escapeRegExp(G[1])+')($|\\s)','g'));if(H){A=a.replace(new RegExp(n.escapeRegExp(B[j]),'i'),function(I){var J=B[D];if(I.toUpperCase()==I){J=J.toUpperCase();}else if(I.charAt(0).toUpperCase()==I.charAt(0)){J=J.substr(0,0)+B[D].charAt(0).toUpperCase()+J.substr(1);}return J;});this.insert(A);A="";}}}}};this.removeLines=function(){var r=this.$getSelectedRows();this.session.removeFullLines(r.first,r.last);this.clearSelection();};this.duplicateSelection=function(){var s=this.selection;var d=this.session;var r=s.getRange();var a=s.isBackwards();if(r.isEmpty()){var b=r.start.row;d.duplicateLines(b,b);}else{var c=a?r.start:r.end;var e=d.insert(c,d.getTextRange(r),false);r.start=c;r.end=e;s.setSelectionRange(r,a);}};this.moveLinesDown=function(){this.$moveLines(1,false);};this.moveLinesUp=function(){this.$moveLines(-1,false);};this.moveText=function(r,t,c){return this.session.moveText(r,t,c);};this.copyLinesUp=function(){this.$moveLines(-1,true);};this.copyLinesDown=function(){this.$moveLines(1,true);};this.$moveLines=function(d,c){var r,m;var s=this.selection;if(!s.inMultiSelectMode||this.inVirtualSelectionMode){var a=s.toOrientedRange();r=this.$getSelectedRows(a);m=this.session.$moveLines(r.first,r.last,c?0:d);if(c&&d==-1)m=0;a.moveBy(m,0);s.fromOrientedRange(a);}else{var b=s.rangeList.ranges;s.rangeList.detach(this.session);this.inVirtualSelectionMode=true;var e=0;var t=0;var l=b.length;for(var i=0;i<l;i++){var j=i;b[i].moveBy(e,0);r=this.$getSelectedRows(b[i]);var A=r.first;var B=r.last;while(++i<l){if(t)b[i].moveBy(t,0);var D=this.$getSelectedRows(b[i]);if(c&&D.first!=B)break;else if(!c&&D.first>B+1)break;B=D.last;}i--;e=this.session.$moveLines(A,B,c?0:d);if(c&&d==-1)j=i+1;while(j<=i){b[j].moveBy(e,0);j++;}if(!c)e=0;t+=e;}s.fromOrientedRange(s.ranges[0]);s.rangeList.attach(this.session);this.inVirtualSelectionMode=false;}};this.$getSelectedRows=function(r){r=(r||this.getSelectionRange()).collapseRows();return{first:this.session.getRowFoldStart(r.start.row),last:this.session.getRowFoldEnd(r.end.row)};};this.onCompositionStart=function(c){this.renderer.showComposition(c);};this.onCompositionUpdate=function(t){this.renderer.setCompositionText(t);};this.onCompositionEnd=function(){this.renderer.hideComposition();};this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow();};this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow();};this.isRowVisible=function(r){return(r>=this.getFirstVisibleRow()&&r<=this.getLastVisibleRow());};this.isRowFullyVisible=function(r){return(r>=this.renderer.getFirstFullyVisibleRow()&&r<=this.renderer.getLastFullyVisibleRow());};this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1;};this.$moveByPage=function(d,s){var r=this.renderer;var v=this.renderer.layerConfig;var a=d*Math.floor(v.height/v.lineHeight);if(s===true){this.selection.$moveSelection(function(){this.moveCursorBy(a,0);});}else if(s===false){this.selection.moveCursorBy(a,0);this.selection.clearSelection();}var b=r.scrollTop;r.scrollBy(0,a*v.lineHeight);if(s!=null)r.scrollCursorIntoView(null,0.5);r.animateScrolling(b);};this.selectPageDown=function(){this.$moveByPage(1,true);};this.selectPageUp=function(){this.$moveByPage(-1,true);};this.gotoPageDown=function(){this.$moveByPage(1,false);};this.gotoPageUp=function(){this.$moveByPage(-1,false);};this.scrollPageDown=function(){this.$moveByPage(1);};this.scrollPageUp=function(){this.$moveByPage(-1);};this.scrollToRow=function(r){this.renderer.scrollToRow(r);};this.scrollToLine=function(l,c,a,b){this.renderer.scrollToLine(l,c,a,b);};this.centerSelection=function(){var r=this.getSelectionRange();var a={row:Math.floor(r.start.row+(r.end.row-r.start.row)/2),column:Math.floor(r.start.column+(r.end.column-r.start.column)/2)};this.renderer.alignCursor(a,0.5);};this.getCursorPosition=function(){return this.selection.getCursor();};this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition());};this.getSelectionRange=function(){return this.selection.getRange();};this.selectAll=function(){this.selection.selectAll();};this.clearSelection=function(){this.selection.clearSelection();};this.moveCursorTo=function(r,c){this.selection.moveCursorTo(r,c);};this.moveCursorToPosition=function(a){this.selection.moveCursorToPosition(a);};this.jumpToMatching=function(s,e){var c=this.getCursorPosition();var a=new w(this.session,c.row,c.column);var b=a.getCurrentToken();var t=b||a.stepForward();if(!t)return;var m;var d=false;var j={};var i=c.column-t.start;var l;var r={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(t.value.match(/[{}()\[\]]/g)){for(;i<t.value.length&&!d;i++){if(!r[t.value[i]]){continue;}l=r[t.value[i]]+'.'+t.type.replace("rparen","lparen");if(isNaN(j[l])){j[l]=0;}switch(t.value[i]){case'(':case'[':case'{':j[l]++;break;case')':case']':case'}':j[l]--;if(j[l]===-1){m='bracket';d=true;}break;}}}else if(t.type.indexOf('tag-name')!==-1){if(isNaN(j[t.value])){j[t.value]=0;}if(b.value==='<'){j[t.value]++;}else if(b.value==='</'){j[t.value]--;}if(j[t.value]===-1){m='tag';d=true;}}if(!d){b=t;t=a.stepForward();i=0;}}while(t&&!d);if(!m)return;var A,B;if(m==='bracket'){A=this.session.getBracketRange(c);if(!A){A=new R(a.getCurrentTokenRow(),a.getCurrentTokenColumn()+i-1,a.getCurrentTokenRow(),a.getCurrentTokenColumn()+i-1);B=A.start;if(e||B.row===c.row&&Math.abs(B.column-c.column)<2)A=this.session.getBracketRange(B);}}else if(m==='tag'){if(t&&t.type.indexOf('tag-name')!==-1)var D=t.value;else return;A=new R(a.getCurrentTokenRow(),a.getCurrentTokenColumn()-2,a.getCurrentTokenRow(),a.getCurrentTokenColumn()-2);if(A.compare(c.row,c.column)===0){d=false;do{t=b;b=a.stepBackward();if(b){if(b.type.indexOf('tag-close')!==-1){A.setEnd(a.getCurrentTokenRow(),a.getCurrentTokenColumn()+1);}if(t.value===D&&t.type.indexOf('tag-name')!==-1){if(b.value==='<'){j[D]++;}else if(b.value==='</'){j[D]--;}if(j[D]===0)d=true;}}}while(b&&!d);}if(t&&t.type.indexOf('tag-name')){B=A.start;if(B.row==c.row&&Math.abs(B.column-c.column)<2)B=A.end;}}B=A&&A.cursor||B;if(B){if(s){if(A&&e){this.selection.setRange(A);}else if(A&&A.isEqual(this.getSelectionRange())){this.clearSelection();}else{this.selection.selectTo(B.row,B.column);}}else{this.selection.moveTo(B.row,B.column);}}};this.gotoLine=function(l,c,a){this.selection.clearSelection();this.session.unfold({row:l-1,column:c||0});this.exitMultiSelectMode&&this.exitMultiSelectMode();this.moveCursorTo(l-1,c||0);if(!this.isRowFullyVisible(l-1))this.scrollToLine(l-1,true,a);};this.navigateTo=function(r,c){this.selection.moveTo(r,c);};this.navigateUp=function(t){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var s=this.selection.anchor.getPosition();return this.moveCursorToPosition(s);}this.selection.clearSelection();this.selection.moveCursorBy(-t||-1,0);};this.navigateDown=function(t){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var s=this.selection.anchor.getPosition();return this.moveCursorToPosition(s);}this.selection.clearSelection();this.selection.moveCursorBy(t||1,0);};this.navigateLeft=function(t){if(!this.selection.isEmpty()){var s=this.getSelectionRange().start;this.moveCursorToPosition(s);}else{t=t||1;while(t--){this.selection.moveCursorLeft();}}this.clearSelection();};this.navigateRight=function(t){if(!this.selection.isEmpty()){var s=this.getSelectionRange().end;this.moveCursorToPosition(s);}else{t=t||1;while(t--){this.selection.moveCursorRight();}}this.clearSelection();};this.navigateLineStart=function(){this.selection.moveCursorLineStart();this.clearSelection();};this.navigateLineEnd=function(){this.selection.moveCursorLineEnd();this.clearSelection();};this.navigateFileEnd=function(){this.selection.moveCursorFileEnd();this.clearSelection();};this.navigateFileStart=function(){this.selection.moveCursorFileStart();this.clearSelection();};this.navigateWordRight=function(){this.selection.moveCursorWordRight();this.clearSelection();};this.navigateWordLeft=function(){this.selection.moveCursorWordLeft();this.clearSelection();};this.replace=function(r,a){if(a)this.$search.set(a);var b=this.$search.find(this.session);var c=0;if(!b)return c;if(this.$tryReplace(b,r)){c=1;}this.selection.setSelectionRange(b);this.renderer.scrollSelectionIntoView(b.start,b.end);return c;};this.replaceAll=function(r,a){if(a){this.$search.set(a);}var b=this.$search.findAll(this.session);var c=0;if(!b.length)return c;var s=this.getSelectionRange();this.selection.moveTo(0,0);for(var i=b.length-1;i>=0;--i){if(this.$tryReplace(b[i],r)){c++;}}this.selection.setSelectionRange(s);return c;};this.$tryReplace=function(r,a){var i=this.session.getTextRange(r);a=this.$search.replace(i,a);if(a!==null){r.end=this.session.replace(r,a);return r;}else{return null;}};this.getLastSearchOptions=function(){return this.$search.getOptions();};this.find=function(a,b,c){if(!b)b={};if(typeof a=="string"||a instanceof RegExp)b.needle=a;else if(typeof a=="object")o.mixin(b,a);var r=this.selection.getRange();if(b.needle==null){a=this.session.getTextRange(r)||this.$search.$options.needle;if(!a){r=this.session.getWordRange(r.start.row,r.start.column);a=this.session.getTextRange(r);}this.$search.set({needle:a});}this.$search.set(b);if(!b.start)this.$search.set({start:r});var d=this.$search.find(this.session);if(b.preventScroll)return d;if(d){this.revealRange(d,c);return d;}if(b.backwards)r.start=r.end;else r.end=r.start;this.selection.setRange(r);};this.findNext=function(a,b){this.find({skipCurrent:true,backwards:false},a,b);};this.findPrevious=function(a,b){this.find(a,{skipCurrent:true,backwards:true},b);};this.revealRange=function(r,a){this.session.unfold(r);this.selection.setSelectionRange(r);var s=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(r.start,r.end,0.5);if(a!==false)this.renderer.animateScrolling(s);};this.undo=function(){this.session.getUndoManager().undo(this.session);this.renderer.scrollCursorIntoView(null,0.5);};this.redo=function(){this.session.getUndoManager().redo(this.session);this.renderer.scrollCursorIntoView(null,0.5);};this.destroy=function(){if(this.$toDestroy){this.$toDestroy.forEach(function(e){e.destroy();});this.$toDestroy=null;}if(this.$mouseHandler)this.$mouseHandler.destroy();this.renderer.destroy();this._signal("destroy",this);if(this.session)this.session.destroy();if(this._$emitInputEvent)this._$emitInputEvent.cancel();this.removeAllListeners();};this.setAutoScrollEditorIntoView=function(e){if(!e)return;var r;var s=this;var a=false;if(!this.$scrollAnchor)this.$scrollAnchor=document.createElement("div");var b=this.$scrollAnchor;b.style.cssText="position:absolute";this.container.insertBefore(b,this.container.firstChild);var c=this.on("changeSelection",function(){a=true;});var d=this.renderer.on("beforeRender",function(){if(a)r=s.renderer.container.getBoundingClientRect();});var i=this.renderer.on("afterRender",function(){if(a&&r&&(s.isFocused()||s.searchBox&&s.searchBox.isFocused())){var j=s.renderer;var l=j.$cursorLayer.$pixelPos;var v=j.layerConfig;var t=l.top-v.offset;if(l.top>=0&&t+r.top<0){a=true;}else if(l.top<v.height&&l.top+r.top+v.lineHeight>window.innerHeight){a=false;}else{a=null;}if(a!=null){b.style.top=t+"px";b.style.left=l.left+"px";b.style.height=v.lineHeight+"px";b.scrollIntoView(a);}a=r=null;}});this.setAutoScrollEditorIntoView=function(e){if(e)return;delete this.setAutoScrollEditorIntoView;this.off("changeSelection",c);this.renderer.off("afterRender",i);this.renderer.off("beforeRender",d);};};this.$resetCursorStyle=function(){var s=this.$cursorStyle||"ace";var c=this.renderer.$cursorLayer;if(!c)return;c.setSmoothBlinking(/smooth/.test(s));c.isBlinking=!this.$readOnly&&s!="wide";k.setCssClass(c.element,"ace_slim-cursors",/slim/.test(s));};this.prompt=function(m,a,c){var e=this;v.loadModule("./ext/prompt",function(h){h.prompt(e,m,a,c);});};}).call(y.prototype);v.defineOptions(y.prototype,"editor",{selectionStyle:{set:function(s){this.onSelectionChange();this._signal("changeSelectionStyle",{data:s});},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine();},initialValue:true},highlightSelectedWord:{set:function(s){this.$onSelectionChange();},initialValue:true},readOnly:{set:function(r){this.textInput.setReadOnly(r);this.$resetCursorStyle();},initialValue:false},copyWithEmptySelection:{set:function(a){this.textInput.setCopyWithEmptySelection(a);},initialValue:false},cursorStyle:{set:function(a){this.$resetCursorStyle();},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[false,true,"always"],initialValue:true},behavioursEnabled:{initialValue:true},wrapBehavioursEnabled:{initialValue:true},enableAutoIndent:{initialValue:true},autoScrollEditorIntoView:{set:function(a){this.setAutoScrollEditorIntoView(a);}},keyboardHandler:{set:function(a){this.setKeyboardHandler(a);},get:function(){return this.$keybindingId;},handlesSet:true},value:{set:function(a){this.session.setValue(a);},get:function(){return this.getValue();},handlesSet:true,hidden:true},session:{set:function(a){this.setSession(a);},get:function(){return this.session;},handlesSet:true,hidden:true},showLineNumbers:{set:function(s){this.renderer.$gutterLayer.setShowLineNumbers(s);this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER);if(s&&this.$relativeLineNumbers)z.attach(this);else z.detach(this);},initialValue:true},relativeLineNumbers:{set:function(a){if(this.$showLineNumbers&&a)z.attach(this);else z.detach(this);}},placeholder:{set:function(m){if(!this.$updatePlaceholder){this.$updatePlaceholder=function(){var a=this.session&&(this.renderer.$composition||this.getValue());if(a&&this.renderer.placeholderNode){this.renderer.off("afterRender",this.$updatePlaceholder);k.removeCssClass(this.container,"ace_hasPlaceholder");this.renderer.placeholderNode.remove();this.renderer.placeholderNode=null;}else if(!a&&!this.renderer.placeholderNode){this.renderer.on("afterRender",this.$updatePlaceholder);k.addCssClass(this.container,"ace_hasPlaceholder");var e=k.createElement("div");e.className="ace_placeholder";e.textContent=this.$placeholder||"";this.renderer.placeholderNode=e;this.renderer.content.appendChild(this.renderer.placeholderNode);}else if(!a&&this.renderer.placeholderNode){this.renderer.placeholderNode.textContent=this.$placeholder||"";}}.bind(this);this.on("input",this.$updatePlaceholder);}this.$updatePlaceholder();}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var z={getText:function(s,r){return(Math.abs(s.selection.lead.row-r)||(r+1+(r<9?"\xb7":"")))+"";},getWidth:function(s,l,v){return Math.max(l.toString().length,(v.lastRow+1).toString().length,2)*v.characterWidth;},update:function(e,a){a.renderer.$loop.schedule(a.renderer.CHANGE_GUTTER);},attach:function(e){e.renderer.$gutterLayer.$renderer=this;e.on("changeSelection",this.update);this.update(null,e);},detach:function(e){if(e.renderer.$gutterLayer.$renderer==this)e.renderer.$gutterLayer.$renderer=null;e.off("changeSelection",this.update);this.update(null,e);}};g.Editor=y;});ace.define("ace/undomanager",[],function(a,e,m){"use strict";var U=function(){this.$maxRev=0;this.$fromUndo=false;this.reset();};(function(){this.addSession=function(c){this.$session=c;};this.add=function(d,c,i){if(this.$fromUndo)return;if(d==this.$lastDelta)return;if(!this.$keepRedoStack)this.$redoStack.length=0;if(c===false||!this.lastDeltas){this.lastDeltas=[];this.$undoStack.push(this.lastDeltas);d.id=this.$rev=++this.$maxRev;}if(d.action=="remove"||d.action=="insert")this.$lastDelta=d;this.lastDeltas.push(d);};this.addSelection=function(c,r){this.selections.push({value:c,rev:r||this.$rev});};this.startNewGroup=function(){this.lastDeltas=null;return this.$rev;};this.markIgnored=function(c,d){if(d==null)d=this.$rev+1;var j=this.$undoStack;for(var i=j.length;i--;){var r=j[i][0];if(r.id<=c)break;if(r.id<d)r.ignore=true;}this.lastDeltas=null;};this.getSelection=function(r,c){var d=this.selections;for(var i=d.length;i--;){var j=d[i];if(j.rev<r){if(c)j=d[i+1];return j;}}};this.getRevision=function(){return this.$rev;};this.getDeltas=function(c,d){if(d==null)d=this.$rev+1;var j=this.$undoStack;var r=null,x=0;for(var i=j.length;i--;){var y=j[i][0];if(y.id<d&&!r)r=i+1;if(y.id<=c){x=i+1;break;}}return j.slice(x,r);};this.getChangedRanges=function(c,d){if(d==null)d=this.$rev+1;};this.getChangedLines=function(c,d){if(d==null)d=this.$rev+1;};this.undo=function(c,d){this.lastDeltas=null;var i=this.$undoStack;if(!b(i,i.length))return;if(!c)c=this.$session;if(this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length)this.$redoStack=[];this.$fromUndo=true;var j=i.pop();var r=null;if(j){r=c.undoChanges(j,d);this.$redoStack.push(j);this.$syncRev();}this.$fromUndo=false;return r;};this.redo=function(c,d){this.lastDeltas=null;if(!c)c=this.$session;this.$fromUndo=true;if(this.$redoStackBaseRev!=this.$rev){var i=this.getDeltas(this.$redoStackBaseRev,this.$rev+1);w(this.$redoStack,i);this.$redoStackBaseRev=this.$rev;this.$redoStack.forEach(function(x){x[0].id=++this.$maxRev;},this);}var j=this.$redoStack.pop();var r=null;if(j){r=c.redoChanges(j,d);this.$undoStack.push(j);this.$syncRev();}this.$fromUndo=false;return r;};this.$syncRev=function(){var c=this.$undoStack;var d=c[c.length-1];var i=d&&d[0].id||0;this.$redoStackBaseRev=i;this.$rev=i;};this.reset=function(){this.lastDeltas=null;this.$lastDelta=null;this.$undoStack=[];this.$redoStack=[];this.$rev=0;this.mark=0;this.$redoStackBaseRev=this.$rev;this.selections=[];};this.canUndo=function(){return this.$undoStack.length>0;};this.canRedo=function(){return this.$redoStack.length>0;};this.bookmark=function(r){if(r==undefined)r=this.$rev;this.mark=r;};this.isAtBookmark=function(){return this.$rev===this.mark;};this.toJSON=function(){};this.fromJSON=function(){};this.hasUndo=this.canUndo;this.hasRedo=this.canRedo;this.isClean=this.isAtBookmark;this.markClean=this.bookmark;this.$prettyPrint=function(d){if(d)return s(d);return s(this.$undoStack)+"\n---\n"+s(this.$redoStack);};}).call(U.prototype);function b(c,d){for(var i=d;i--;){var j=c[i];if(j&&!j[0].ignore){while(i<d-1){var r=o(c[i],c[i+1]);c[i]=r[0];c[i+1]=r[1];i++;}return true;}}}var R=a("./range").Range;var f=R.comparePoints;var g=R.comparePoints;function $(d){var c=d.action=="insert";var j=d.start;var r=d.end;var x=(r.row-j.row)*(c?1:-1);var y=(r.column-j.column)*(c?1:-1);if(c)r=j;for(var i in this.marks){var z=this.marks[i];var f=g(z,j);if(f<0){continue;}if(f===0){if(c){if(z.bias==1){f=1;}else{z.bias==-1;continue;}}}var A=c?f:g(z,r);if(A>0){z.row+=x;z.column+=z.row==r.row?y:0;continue;}if(!c&&A<=0){z.row=j.row;z.column=j.column;if(A===0)z.bias=1;}}}function h(c){return{row:c.row,column:c.column};}function k(d){return{start:h(d.start),end:h(d.end),action:d.action,lines:d.lines.slice()};}function s(d){d=d||this;if(Array.isArray(d)){return d.map(s).join("\n");}var c="";if(d.action){c=d.action=="insert"?"+":"-";c+="["+d.lines+"]";}else if(d.value){if(Array.isArray(d.value)){c=d.value.map(l).join("\n");}else{c=l(d.value);}}if(d.start){c+=l(d);}if(d.id||d.rev){c+="\t("+(d.id||d.rev)+")";}return c;}function l(r){return r.start.row+":"+r.start.column+"=>"+r.end.row+":"+r.end.column;}function n(d,c){var i=d.action=="insert";var j=c.action=="insert";if(i&&j){if(f(c.start,d.end)>=0){q(c,d,-1);}else if(f(c.start,d.start)<=0){q(d,c,+1);}else{return null;}}else if(i&&!j){if(f(c.start,d.end)>=0){q(c,d,-1);}else if(f(c.end,d.start)<=0){q(d,c,-1);}else{return null;}}else if(!i&&j){if(f(c.start,d.start)>=0){q(c,d,+1);}else if(f(c.start,d.start)<=0){q(d,c,+1);}else{return null;}}else if(!i&&!j){if(f(c.start,d.start)>=0){q(c,d,+1);}else if(f(c.end,d.start)<=0){q(d,c,-1);}else{return null;}}return[c,d];}function o(d,c){for(var i=d.length;i--;){for(var j=0;j<c.length;j++){if(!n(d[i],c[j])){while(i<d.length){while(j--){n(c[j],d[i]);}j=c.length;i++;}return[d,c];}}}d.selectionBefore=c.selectionBefore=d.selectionAfter=c.selectionAfter=null;return[c,d];}function p(d,c){var i=d.action=="insert";var j=c.action=="insert";if(i&&j){if(f(d.start,c.start)<0){q(c,d,1);}else{q(d,c,1);}}else if(i&&!j){if(f(d.start,c.end)>=0){q(d,c,-1);}else if(f(d.start,c.start)<=0){q(c,d,+1);}else{q(d,R.fromPoints(c.start,d.start),-1);q(c,d,+1);}}else if(!i&&j){if(f(c.start,d.end)>=0){q(c,d,-1);}else if(f(c.start,d.start)<=0){q(d,c,+1);}else{q(c,R.fromPoints(d.start,c.start),-1);q(d,c,+1);}}else if(!i&&!j){if(f(c.start,d.end)>=0){q(c,d,-1);}else if(f(c.end,d.start)<=0){q(d,c,-1);}else{var r,x;if(f(d.start,c.start)<0){r=d;d=u(d,c.start);}if(f(d.end,c.end)>0){x=u(d,c.end);}t(c.end,d.start,d.end,-1);if(x&&!r){d.lines=x.lines;d.start=x.start;d.end=x.end;x=d;}return[c,r,x].filter(Boolean);}}return[c,d];}function q(d,c,i){t(d.start,c.start,c.end,i);t(d.end,c.start,c.end,i);}function t(c,d,i,j){if(c.row==(j==1?d:i).row){c.column+=j*(i.column-d.column);}c.row+=j*(i.row-d.row);}function u(c,d){var i=c.lines;var j=c.end;c.end=h(d);var r=c.end.row-c.start.row;var x=i.splice(r,i.length);var y=r?d.column:d.column-c.start.column;i.push(x[0].substring(0,y));x[0]=x[0].substr(y);var z={start:h(d),end:j,lines:x,action:c.action};return z;}function v(r,d){d=k(d);for(var j=r.length;j--;){var c=r[j];for(var i=0;i<c.length;i++){var x=c[i];var y=p(x,d);d=y[0];if(y.length!=2){if(y[2]){c.splice(i+1,1,y[1],y[2]);i++;}else if(!y[1]){c.splice(i,1);i--;}}}if(!c.length){r.splice(j,1);}}return r;}function w(r,d){for(var i=0;i<d.length;i++){var c=d[i];for(var j=0;j<c.length;j++){v(r,c[j]);}}}e.UndoManager=U;});ace.define("ace/layer/lines",[],function(r,e,m){"use strict";var d=r("../lib/dom");var L=function(a,c){this.element=a;this.canvasHeight=c||500000;this.element.style.height=(this.canvasHeight*2)+"px";this.cells=[];this.cellCache=[];this.$offsetCoefficient=0;};(function(){this.moveContainer=function(c){d.translate(this.element,0,-((c.firstRowScreen*c.lineHeight)%this.canvasHeight)-c.offset*this.$offsetCoefficient);};this.pageChanged=function(o,n){return(Math.floor((o.firstRowScreen*o.lineHeight)/this.canvasHeight)!==Math.floor((n.firstRowScreen*n.lineHeight)/this.canvasHeight));};this.computeLineTop=function(a,c,s){var b=c.firstRowScreen*c.lineHeight;var f=Math.floor(b/this.canvasHeight);var l=s.documentToScreenRow(a,0)*c.lineHeight;return l-(f*this.canvasHeight);};this.computeLineHeight=function(a,c,s){return c.lineHeight*s.getRowLineCount(a);};this.getLength=function(){return this.cells.length;};this.get=function(i){return this.cells[i];};this.shift=function(){this.$cacheCell(this.cells.shift());};this.pop=function(){this.$cacheCell(this.cells.pop());};this.push=function(c){if(Array.isArray(c)){this.cells.push.apply(this.cells,c);var f=d.createFragment(this.element);for(var i=0;i<c.length;i++){f.appendChild(c[i].element);}this.element.appendChild(f);}else{this.cells.push(c);this.element.appendChild(c.element);}};this.unshift=function(c){if(Array.isArray(c)){this.cells.unshift.apply(this.cells,c);var f=d.createFragment(this.element);for(var i=0;i<c.length;i++){f.appendChild(c[i].element);}if(this.element.firstChild)this.element.insertBefore(f,this.element.firstChild);else this.element.appendChild(f);}else{this.cells.unshift(c);this.element.insertAdjacentElement("afterbegin",c.element);}};this.last=function(){if(this.cells.length)return this.cells[this.cells.length-1];else return null;};this.$cacheCell=function(c){if(!c)return;c.element.remove();this.cellCache.push(c);};this.createCell=function(a,c,s,i){var b=this.cellCache.pop();if(!b){var f=d.createElement("div");if(i)i(f);this.element.appendChild(f);b={element:f,text:"",row:a};}b.row=a;return b;};}).call(L.prototype);e.Lines=L;});ace.define("ace/layer/gutter",[],function(r,e,m){"use strict";var d=r("../lib/dom");var o=r("../lib/oop");var l=r("../lib/lang");var E=r("../lib/event_emitter").EventEmitter;var L=r("./lines").Lines;var G=function(p){this.element=d.createElement("div");this.element.className="ace_layer ace_gutter-layer";p.appendChild(this.element);this.setShowFoldWidgets(this.$showFoldWidgets);this.gutterWidth=0;this.$annotations=[];this.$updateAnnotations=this.$updateAnnotations.bind(this);this.$lines=new L(this.element);this.$lines.$offsetCoefficient=1;};(function(){o.implement(this,E);this.setSession=function(s){if(this.session)this.session.off("change",this.$updateAnnotations);this.session=s;if(s)s.on("change",this.$updateAnnotations);};this.addGutterDecoration=function(b,c){if(window.console)console.warn&&console.warn("deprecated use session.addGutterDecoration");this.session.addGutterDecoration(b,c);};this.removeGutterDecoration=function(b,c){if(window.console)console.warn&&console.warn("deprecated use session.removeGutterDecoration");this.session.removeGutterDecoration(b,c);};this.setAnnotations=function(b){this.$annotations=[];for(var i=0;i<b.length;i++){var c=b[i];var f=c.row;var g=this.$annotations[f];if(!g)g=this.$annotations[f]={text:[]};var h=c.text;if(!h&&c.html){throw new Error("Html annotations are not allowed to avoid possibility for any CSP inline style compliance issues.");}h=h||"";if(g.text.indexOf(h)===-1)g.text.push(h);var t=c.type;if(t=="error")g.className=" ace_error";else if(t=="warning"&&g.className!=" ace_error")g.className=" ace_warning";else if(t=="info"&&(!g.className))g.className=" ace_info";}};this.$updateAnnotations=function(b){if(!this.$annotations.length)return;var f=b.start.row;var c=b.end.row-f;if(c===0){}else if(b.action=='remove'){this.$annotations.splice(f,c+1,null);}else{var g=new Array(c+1);g.unshift(f,1);this.$annotations.splice.apply(this.$annotations,g);}};this.update=function(c){this.config=c;var s=this.session;var f=c.firstRow;var b=Math.min(c.lastRow+c.gutterOffset,s.getLength()-1);this.oldLastRow=b;this.config=c;this.$lines.moveContainer(c);this.$updateCursorRow();var g=s.getNextFoldLine(f);var h=g?g.start.row:Infinity;var i=null;var j=-1;var k=f;while(true){if(k>h){k=g.end.row+1;g=s.getNextFoldLine(k,g);h=g?g.start.row:Infinity;}if(k>b){while(this.$lines.getLength()>j+1)this.$lines.pop();break;}i=this.$lines.get(++j);if(i){i.row=k;}else{i=this.$lines.createCell(k,c,this.session,a);this.$lines.push(i);}this.$renderCell(i,c,g,k);k++;}this._signal("afterRender");this.$updateGutterWidth(c);};this.$updateGutterWidth=function(c){var s=this.session;var g=s.gutterRenderer||this.$renderer;var f=s.$firstLineNumber;var b=this.$lines.last()?this.$lines.last().text:"";if(this.$fixedWidth||s.$useWrapMode)b=s.getLength()+f-1;var h=g?g.getWidth(s,b,c):b.toString().length*c.characterWidth;var p=this.$padding||this.$computePadding();h+=p.left+p.right;if(h!==this.gutterWidth&&!isNaN(h)){this.gutterWidth=h;this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px";this._signal("changeGutterWidth",h);}};this.$updateCursorRow=function(){if(!this.$highlightGutterLine)return;var p=this.session.selection.getCursor();if(this.$cursorRow===p.row)return;this.$cursorRow=p.row;};this.updateLineHighlight=function(){if(!this.$highlightGutterLine)return;var b=this.session.selection.cursor.row;this.$cursorRow=b;if(this.$cursorCell&&this.$cursorCell.row==b)return;if(this.$cursorCell)this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","");var c=this.$lines.cells;this.$cursorCell=null;for(var i=0;i<c.length;i++){var f=c[i];if(f.row>=this.$cursorRow){if(f.row>this.$cursorRow){var g=this.session.getFoldLine(this.$cursorRow);if(i>0&&g&&g.start.row==c[i-1].row)f=c[i-1];else break;}f.element.className="ace_gutter-active-line "+f.element.className;this.$cursorCell=f;break;}}};this.scrollLines=function(c){var b=this.config;this.config=c;this.$updateCursorRow();if(this.$lines.pageChanged(b,c))return this.update(c);this.$lines.moveContainer(c);var f=Math.min(c.lastRow+c.gutterOffset,this.session.getLength()-1);var g=this.oldLastRow;this.oldLastRow=f;if(!b||g<c.firstRow)return this.update(c);if(f<b.firstRow)return this.update(c);if(b.firstRow<c.firstRow)for(var h=this.session.getFoldedRowCount(b.firstRow,c.firstRow-1);h>0;h--)this.$lines.shift();if(g>f)for(var h=this.session.getFoldedRowCount(f+1,g);h>0;h--)this.$lines.pop();if(c.firstRow<b.firstRow){this.$lines.unshift(this.$renderLines(c,c.firstRow,b.firstRow-1));}if(f>g){this.$lines.push(this.$renderLines(c,g+1,f));}this.updateLineHighlight();this._signal("afterRender");this.$updateGutterWidth(c);};this.$renderLines=function(c,f,b){var g=[];var h=f;var i=this.session.getNextFoldLine(h);var j=i?i.start.row:Infinity;while(true){if(h>j){h=i.end.row+1;i=this.session.getNextFoldLine(h,i);j=i?i.start.row:Infinity;}if(h>b)break;var k=this.$lines.createCell(h,c,this.session,a);this.$renderCell(k,c,i,h);g.push(k);h++;}return g;};this.$renderCell=function(b,f,g,h){var i=b.element;var s=this.session;var t=i.childNodes[0];var j=i.childNodes[1];var k=s.$firstLineNumber;var n=s.$breakpoints;var p=s.$decorations;var q=s.gutterRenderer||this.$renderer;var u=this.$showFoldWidgets&&s.foldWidgets;var v=g?g.start.row:Number.MAX_VALUE;var w="ace_gutter-cell ";if(this.$highlightGutterLine){if(h==this.$cursorRow||(g&&h<this.$cursorRow&&h>=v&&this.$cursorRow<=g.end.row)){w+="ace_gutter-active-line ";if(this.$cursorCell!=b){if(this.$cursorCell)this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","");this.$cursorCell=b;}}}if(n[h])w+=n[h];if(p[h])w+=p[h];if(this.$annotations[h])w+=this.$annotations[h].className;if(i.className!=w)i.className=w;if(u){var c=u[h];if(c==null)c=u[h]=s.getFoldWidget(h);}if(c){var w="ace_fold-widget ace_"+c;if(c=="start"&&h==v&&h<g.end.row)w+=" ace_closed";else w+=" ace_open";if(j.className!=w)j.className=w;var x=f.lineHeight+"px";d.setStyle(j.style,"height",x);d.setStyle(j.style,"display","inline-block");}else{if(j){d.setStyle(j.style,"display","none");}}var y=(q?q.getText(s,h):h+k).toString();if(y!==t.data){t.data=y;}d.setStyle(b.element.style,"height",this.$lines.computeLineHeight(h,f,s)+"px");d.setStyle(b.element.style,"top",this.$lines.computeLineTop(h,f,s)+"px");b.text=y;return b;};this.$fixedWidth=false;this.$highlightGutterLine=true;this.$renderer="";this.setHighlightGutterLine=function(h){this.$highlightGutterLine=h;};this.$showLineNumbers=true;this.$renderer="";this.setShowLineNumbers=function(s){this.$renderer=!s&&{getWidth:function(){return 0;},getText:function(){return"";}};};this.getShowLineNumbers=function(){return this.$showLineNumbers;};this.$showFoldWidgets=true;this.setShowFoldWidgets=function(s){if(s)d.addCssClass(this.element,"ace_folding-enabled");else d.removeCssClass(this.element,"ace_folding-enabled");this.$showFoldWidgets=s;this.$padding=null;};this.getShowFoldWidgets=function(){return this.$showFoldWidgets;};this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var s=d.computedStyle(this.element.firstChild);this.$padding={};this.$padding.left=(parseInt(s.borderLeftWidth)||0)+(parseInt(s.paddingLeft)||0)+1;this.$padding.right=(parseInt(s.borderRightWidth)||0)+(parseInt(s.paddingRight)||0);return this.$padding;};this.getRegion=function(p){var b=this.$padding||this.$computePadding();var c=this.element.getBoundingClientRect();if(p.x<b.left+c.left)return"markers";if(this.$showFoldWidgets&&p.x>c.right-b.right)return"foldWidgets";};}).call(G.prototype);function a(b){var t=document.createTextNode('');b.appendChild(t);var f=d.createElement("span");b.appendChild(f);return b;}e.Gutter=G;});ace.define("ace/layer/marker",[],function(r,e,m){"use strict";var R=r("../range").Range;var d=r("../lib/dom");var M=function(p){this.element=d.createElement("div");this.element.className="ace_layer ace_marker-layer";p.appendChild(this.element);};(function(){this.$padding=0;this.setPadding=function(p){this.$padding=p;};this.setSession=function(s){this.session=s;};this.setMarkers=function(a){this.markers=a;};this.elt=function(c,a){var x=this.i!=-1&&this.element.childNodes[this.i];if(!x){x=document.createElement("div");this.element.appendChild(x);this.i=-1;}else{this.i++;}x.style.cssText=a;x.className=c;};this.update=function(c){if(!c)return;this.config=c;this.i=0;var h;for(var k in this.markers){var a=this.markers[k];if(!a.range){a.update(h,this,this.session,c);continue;}var b=a.range.clipRows(c.firstRow,c.lastRow);if(b.isEmpty())continue;b=b.toScreenRange(this.session);if(a.renderer){var t=this.$getTop(b.start.row,c);var l=this.$padding+b.start.column*c.characterWidth;a.renderer(h,b,l,t,c);}else if(a.type=="fullLine"){this.drawFullLineMarker(h,b,a.clazz,c);}else if(a.type=="screenLine"){this.drawScreenLineMarker(h,b,a.clazz,c);}else if(b.isMultiLine()){if(a.type=="text")this.drawTextMarker(h,b,a.clazz,c);else this.drawMultiLineMarker(h,b,a.clazz,c);}else{this.drawSingleLineMarker(h,b,a.clazz+" ace_start"+" ace_br15",c);}}if(this.i!=-1){while(this.i<this.element.childElementCount)this.element.removeChild(this.element.lastChild);}};this.$getTop=function(a,l){return(a-l.firstRowScreen)*l.lineHeight;};function g(t,a,b,c){return(t?1:0)|(a?2:0)|(b?4:0)|(c?8:0);}this.drawTextMarker=function(s,a,c,l,b){var f=this.session;var h=a.start.row;var i=a.end.row;var j=h;var p=0;var k=0;var n=f.getScreenLastRowColumn(j);var o=new R(j,a.start.column,j,k);for(;j<=i;j++){o.start.row=o.end.row=j;o.start.column=j==h?a.start.column:f.getRowWrapIndent(j);o.end.column=n;p=k;k=n;n=j+1<i?f.getScreenLastRowColumn(j+1):j==i?0:a.end.column;this.drawSingleLineMarker(s,o,c+(j==h?" ace_start":"")+" ace_br"+g(j==h||j==h+1&&a.start.column,p<k,k>n,j==i),l,j==i?0:1,b);}};this.drawMultiLineMarker=function(s,a,c,b,f){var p=this.$padding;var h=b.lineHeight;var t=this.$getTop(a.start.row,b);var l=p+a.start.column*b.characterWidth;f=f||"";if(this.session.$bidiHandler.isBidiRow(a.start.row)){var i=a.clone();i.end.row=i.start.row;i.end.column=this.session.getLine(i.start.row).length;this.drawBidiSingleLineMarker(s,i,c+" ace_br1 ace_start",b,null,f);}else{this.elt(c+" ace_br1 ace_start","height:"+h+"px;"+"right:0;"+"top:"+t+"px;left:"+l+"px;"+(f||""));}if(this.session.$bidiHandler.isBidiRow(a.end.row)){var i=a.clone();i.start.row=i.end.row;i.start.column=0;this.drawBidiSingleLineMarker(s,i,c+" ace_br12",b,null,f);}else{t=this.$getTop(a.end.row,b);var w=a.end.column*b.characterWidth;this.elt(c+" ace_br12","height:"+h+"px;"+"width:"+w+"px;"+"top:"+t+"px;"+"left:"+p+"px;"+(f||""));}h=(a.end.row-a.start.row-1)*b.lineHeight;if(h<=0)return;t=this.$getTop(a.start.row+1,b);var j=(a.start.column?1:0)|(a.end.column?0:8);this.elt(c+(j?" ace_br"+j:""),"height:"+h+"px;"+"right:0;"+"top:"+t+"px;"+"left:"+p+"px;"+(f||""));};this.drawSingleLineMarker=function(s,a,c,b,f,h){if(this.session.$bidiHandler.isBidiRow(a.start.row))return this.drawBidiSingleLineMarker(s,a,c,b,f,h);var i=b.lineHeight;var w=(a.end.column+(f||0)-a.start.column)*b.characterWidth;var t=this.$getTop(a.start.row,b);var l=this.$padding+a.start.column*b.characterWidth;this.elt(c,"height:"+i+"px;"+"width:"+w+"px;"+"top:"+t+"px;"+"left:"+l+"px;"+(h||""));};this.drawBidiSingleLineMarker=function(s,a,c,b,f,h){var i=b.lineHeight,t=this.$getTop(a.start.row,b),p=this.$padding;var j=this.session.$bidiHandler.getSelections(a.start.column,a.end.column);j.forEach(function(k){this.elt(c,"height:"+i+"px;"+"width:"+k.width+(f||0)+"px;"+"top:"+t+"px;"+"left:"+(p+k.left)+"px;"+(h||""));},this);};this.drawFullLineMarker=function(s,a,c,b,f){var t=this.$getTop(a.start.row,b);var h=b.lineHeight;if(a.start.row!=a.end.row)h+=this.$getTop(a.end.row,b)-t;this.elt(c,"height:"+h+"px;"+"top:"+t+"px;"+"left:0;right:0;"+(f||""));};this.drawScreenLineMarker=function(s,a,c,b,f){var t=this.$getTop(a.start.row,b);var h=b.lineHeight;this.elt(c,"height:"+h+"px;"+"top:"+t+"px;"+"left:0;right:0;"+(f||""));};}).call(M.prototype);e.Marker=M;});ace.define("ace/layer/text",[],function(r,a,b){"use strict";var o=r("../lib/oop");var d=r("../lib/dom");var l=r("../lib/lang");var L=r("./lines").Lines;var E=r("../lib/event_emitter").EventEmitter;var T=function(p){this.dom=d;this.element=this.dom.createElement("div");this.element.className="ace_layer ace_text-layer";p.appendChild(this.element);this.$updateEolChar=this.$updateEolChar.bind(this);this.$lines=new L(this.element);};(function(){o.implement(this,E);this.EOF_CHAR="\xB6";this.EOL_CHAR_LF="\xAC";this.EOL_CHAR_CRLF="\xa4";this.EOL_CHAR=this.EOL_CHAR_LF;this.TAB_CHAR="\u2014";this.SPACE_CHAR="\xB7";this.$padding=0;this.MAX_LINE_LENGTH=10000;this.$updateEolChar=function(){var c=this.session.doc;var u=c.getNewLineCharacter()=="\n"&&c.getNewLineMode()!="windows";var e=u?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e){this.EOL_CHAR=e;return true;}};this.setPadding=function(p){this.$padding=p;this.element.style.margin="0 "+p+"px";};this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0;};this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0;};this.$setFontMetrics=function(m){this.$fontMetrics=m;this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e);}.bind(this));this.$pollSizeChanges();};this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges();};this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges();};this.setSession=function(s){this.session=s;if(s)this.$computeTabString();};this.showInvisibles=false;this.showSpaces=false;this.showTabs=false;this.showEOL=false;this.setShowInvisibles=function(s){if(this.showInvisibles==s)return false;this.showInvisibles=s;if(typeof s=="string"){this.showSpaces=/tab/i.test(s);this.showTabs=/space/i.test(s);this.showEOL=/eol/i.test(s);}else{this.showSpaces=this.showTabs=this.showEOL=s;}this.$computeTabString();return true;};this.displayIndentGuides=true;this.setDisplayIndentGuides=function(c){if(this.displayIndentGuides==c)return false;this.displayIndentGuides=c;this.$computeTabString();return true;};this.$tabStrings=[];this.onChangeTabSize=this.$computeTabString=function(){var t=this.session.getTabSize();this.tabSize=t;var c=this.$tabStrings=[0];for(var i=1;i<t+1;i++){if(this.showTabs){var s=this.dom.createElement("span");s.className="ace_invisible ace_invisible_tab";s.textContent=l.stringRepeat(this.TAB_CHAR,i);c.push(s);}else{c.push(this.dom.createTextNode(l.stringRepeat(" ",i),this.element));}}if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var e="ace_indent-guide";var f=this.showSpaces?" ace_invisible ace_invisible_space":"";var g=this.showSpaces?l.stringRepeat(this.SPACE_CHAR,this.tabSize):l.stringRepeat(" ",this.tabSize);var h=this.showTabs?" ace_invisible ace_invisible_tab":"";var j=this.showTabs?l.stringRepeat(this.TAB_CHAR,this.tabSize):g;var s=this.dom.createElement("span");s.className=e+f;s.textContent=g;this.$tabStrings[" "]=s;var s=this.dom.createElement("span");s.className=e+h;s.textContent=j;this.$tabStrings["\t"]=s;}};this.updateLines=function(c,f,e){if(this.config.lastRow!=c.lastRow||this.config.firstRow!=c.firstRow){return this.update(c);}this.config=c;var g=Math.max(f,c.firstRow);var h=Math.min(e,c.lastRow);var i=this.element.childNodes;var j=0;for(var k=c.firstRow;k<g;k++){var m=this.session.getFoldLine(k);if(m){if(m.containsRow(g)){g=m.start.row;break;}else{k=m.end.row;}}j++;}var n=false;var k=g;var m=this.session.getNextFoldLine(k);var p=m?m.start.row:Infinity;while(true){if(k>p){k=m.end.row+1;m=this.session.getNextFoldLine(k,m);p=m?m.start.row:Infinity;}if(k>h)break;var q=i[j++];if(q){this.dom.removeChildren(q);this.$renderLine(q,k,k==p?m:false);if(n)q.style.top=this.$lines.computeLineTop(k,c,this.session)+"px";var s=(c.lineHeight*this.session.getRowLength(k))+"px";if(q.style.height!=s){n=true;q.style.height=s;}}k++;}if(n){while(j<this.$lines.cells.length){var t=this.$lines.cells[j++];t.element.style.top=this.$lines.computeLineTop(t.row,c,this.session)+"px";}}};this.scrollLines=function(c){var e=this.config;this.config=c;if(this.$lines.pageChanged(e,c))return this.update(c);this.$lines.moveContainer(c);var f=c.lastRow;var g=e?e.lastRow:-1;if(!e||g<c.firstRow)return this.update(c);if(f<e.firstRow)return this.update(c);if(!e||e.lastRow<c.firstRow)return this.update(c);if(c.lastRow<e.firstRow)return this.update(c);if(e.firstRow<c.firstRow)for(var h=this.session.getFoldedRowCount(e.firstRow,c.firstRow-1);h>0;h--)this.$lines.shift();if(e.lastRow>c.lastRow)for(var h=this.session.getFoldedRowCount(c.lastRow+1,e.lastRow);h>0;h--)this.$lines.pop();if(c.firstRow<e.firstRow){this.$lines.unshift(this.$renderLinesFragment(c,c.firstRow,e.firstRow-1));}if(c.lastRow>e.lastRow){this.$lines.push(this.$renderLinesFragment(c,e.lastRow+1,c.lastRow));}};this.$renderLinesFragment=function(c,f,e){var g=[];var h=f;var i=this.session.getNextFoldLine(h);var j=i?i.start.row:Infinity;while(true){if(h>j){h=i.end.row+1;i=this.session.getNextFoldLine(h,i);j=i?i.start.row:Infinity;}if(h>e)break;var k=this.$lines.createCell(h,c,this.session);var m=k.element;this.dom.removeChildren(m);d.setStyle(m.style,"height",this.$lines.computeLineHeight(h,c,this.session)+"px");d.setStyle(m.style,"top",this.$lines.computeLineTop(h,c,this.session)+"px");this.$renderLine(m,h,h==j?i:false);if(this.$useLineGroups()){m.className="ace_line_group";}else{m.className="ace_line";}g.push(k);h++;}return g;};this.update=function(c){this.$lines.moveContainer(c);this.config=c;var f=c.firstRow;var e=c.lastRow;var g=this.$lines;while(g.getLength())g.pop();g.push(this.$renderLinesFragment(c,f,e));};this.$textToken={"text":true,"rparen":true,"lparen":true};this.$renderToken=function(p,s,t,v){var c=this;var e=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g;var f=this.dom.createFragment(this.element);var m;var i=0;while(m=e.exec(v)){var g=m[1];var h=m[2];var j=m[3];var k=m[4];var n=m[5];if(!c.showSpaces&&h)continue;var q=i!=m.index?v.slice(i,m.index):"";i=m.index+m[0].length;if(q){f.appendChild(this.dom.createTextNode(q,this.element));}if(g){var u=c.session.getScreenTabSize(s+m.index);f.appendChild(c.$tabStrings[u].cloneNode(true));s+=u-1;}else if(h){if(c.showSpaces){var w=this.dom.createElement("span");w.className="ace_invisible ace_invisible_space";w.textContent=l.stringRepeat(c.SPACE_CHAR,h.length);f.appendChild(w);}else{f.appendChild(this.com.createTextNode(h,this.element));}}else if(j){var w=this.dom.createElement("span");w.className="ace_invisible ace_invisible_space ace_invalid";w.textContent=l.stringRepeat(c.SPACE_CHAR,j.length);f.appendChild(w);}else if(k){s+=1;var w=this.dom.createElement("span");w.style.width=(c.config.characterWidth*2)+"px";w.className=c.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk";w.textContent=c.showSpaces?c.SPACE_CHAR:k;f.appendChild(w);}else if(n){s+=1;var w=this.dom.createElement("span");w.style.width=(c.config.characterWidth*2)+"px";w.className="ace_cjk";w.textContent=n;f.appendChild(w);}}f.appendChild(this.dom.createTextNode(i?v.slice(i):v,this.element));if(!this.$textToken[t.type]){var x="ace_"+t.type.replace(/\./g," ace_");var w=this.dom.createElement("span");if(t.type=="fold")w.style.width=(t.value.length*this.config.characterWidth)+"px";w.className=x;w.appendChild(f);p.appendChild(w);}else{p.appendChild(f);}return s+v.length;};this.renderIndentGuide=function(p,v,m){var c=v.search(this.$indentGuideRe);if(c<=0||c>=m)return v;if(v[0]==" "){c-=c%this.tabSize;var e=c/this.tabSize;for(var i=0;i<e;i++){p.appendChild(this.$tabStrings[" "].cloneNode(true));}return v.substr(c);}else if(v[0]=="\t"){for(var i=0;i<c;i++){p.appendChild(this.$tabStrings["\t"].cloneNode(true));}return v.substr(c);}return v;};this.$createLineElement=function(p){var c=this.dom.createElement("div");c.className="ace_line";c.style.height=this.config.lineHeight+"px";return c;};this.$renderWrappedLine=function(p,t,s){var c=0;var e=0;var f=s[0];var g=0;var h=this.$createLineElement();p.appendChild(h);for(var i=0;i<t.length;i++){var j=t[i];var v=j.value;if(i==0&&this.displayIndentGuides){c=v.length;v=this.renderIndentGuide(h,v,f);if(!v)continue;c-=v.length;}if(c+v.length<f){g=this.$renderToken(h,g,j,v);c+=v.length;}else{while(c+v.length>=f){g=this.$renderToken(h,g,j,v.substring(0,f-c));v=v.substring(f-c);c=f;h=this.$createLineElement();p.appendChild(h);h.appendChild(this.dom.createTextNode(l.stringRepeat("\xa0",s.indent),this.element));e++;g=0;f=s[e]||Number.MAX_VALUE;}if(v.length!=0){c+=v.length;g=this.$renderToken(h,g,j,v);}}}if(s[s.length-1]>this.MAX_LINE_LENGTH)this.$renderOverflowMessage(h,g,null,"",true);};this.$renderSimpleLine=function(p,t){var s=0;var c=t[0];var v=c.value;if(this.displayIndentGuides)v=this.renderIndentGuide(p,v);if(v)s=this.$renderToken(p,s,c,v);for(var i=1;i<t.length;i++){c=t[i];v=c.value;if(s+v.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(p,s,c,v);s=this.$renderToken(p,s,c,v);}};this.$renderOverflowMessage=function(p,s,t,v,h){t&&this.$renderToken(p,s,t,v.slice(0,this.MAX_LINE_LENGTH-s));var c=this.dom.createElement("span");c.className="ace_inline_button ace_keyword ace_toggle_wrap";c.textContent=h?"<hide>":"<click to see more...>";p.appendChild(c);};this.$renderLine=function(p,c,f){if(!f&&f!=false)f=this.session.getFoldLine(c);if(f)var t=this.$getFoldLineTokens(c,f);else var t=this.session.getTokens(c);var e=p;if(t.length){var s=this.session.getRowSplitData(c);if(s&&s.length){this.$renderWrappedLine(p,t,s);var e=p.lastChild;}else{var e=p;if(this.$useLineGroups()){e=this.$createLineElement();p.appendChild(e);}this.$renderSimpleLine(e,t);}}else if(this.$useLineGroups()){e=this.$createLineElement();p.appendChild(e);}if(this.showEOL&&e){if(f)c=f.end.row;var i=this.dom.createElement("span");i.className="ace_invisible ace_invisible_eol";i.textContent=c==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR;e.appendChild(i);}};this.$getFoldLineTokens=function(c,f){var s=this.session;var e=[];function g(t,h,i){var j=0,k=0;while((k+t[j].value.length)<h){k+=t[j].value.length;j++;if(j==t.length)return;}if(k!=h){var v=t[j].value.substring(h-k);if(v.length>(i-h))v=v.substring(0,i-h);e.push({type:t[j].type,value:v});k=h+v.length;j+=1;}while(k<i&&j<t.length){var v=t[j].value;if(v.length+k>i){e.push({type:t[j].type,value:v.substring(0,i-k)});}else e.push(t[j]);k+=v.length;j+=1;}}var t=s.getTokens(c);f.walk(function(p,c,h,i,j){if(p!=null){e.push({type:"fold",value:p});}else{if(j)t=s.getTokens(c);if(t.length)g(t,i,h);}},f.end.row,this.session.getLine(f.end.row).length);return e;};this.$useLineGroups=function(){return this.session.getUseWrapMode();};this.destroy=function(){};}).call(T.prototype);a.Text=T;});ace.define("ace/layer/cursor",[],function(r,e,m){"use strict";var d=r("../lib/dom");var C=function(p){this.element=d.createElement("div");this.element.className="ace_layer ace_cursor-layer";p.appendChild(this.element);this.isVisible=false;this.isBlinking=true;this.blinkInterval=1000;this.smoothBlinking=false;this.cursors=[];this.cursor=this.addCursor();d.addCssClass(this.element,"ace_hidden-cursors");this.$updateCursors=this.$updateOpacity.bind(this);};(function(){this.$updateOpacity=function(v){var c=this.cursors;for(var i=c.length;i--;)d.setStyle(c[i].style,"opacity",v?"":"0");};this.$startCssAnimation=function(){var c=this.cursors;for(var i=c.length;i--;)c[i].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=true;setTimeout(function(){if(this.$isAnimating){d.addCssClass(this.element,"ace_animate-blinking");}}.bind(this));};this.$stopCssAnimation=function(){this.$isAnimating=false;d.removeCssClass(this.element,"ace_animate-blinking");};this.$padding=0;this.setPadding=function(p){this.$padding=p;};this.setSession=function(s){this.session=s;};this.setBlinking=function(b){if(b!=this.isBlinking){this.isBlinking=b;this.restartTimer();}};this.setBlinkInterval=function(b){if(b!=this.blinkInterval){this.blinkInterval=b;this.restartTimer();}};this.setSmoothBlinking=function(s){if(s!=this.smoothBlinking){this.smoothBlinking=s;d.setCssClass(this.element,"ace_smooth-blinking",s);this.$updateCursors(true);this.restartTimer();}};this.addCursor=function(){var a=d.createElement("div");a.className="ace_cursor";this.element.appendChild(a);this.cursors.push(a);return a;};this.removeCursor=function(){if(this.cursors.length>1){var a=this.cursors.pop();a.parentNode.removeChild(a);return a;}};this.hideCursor=function(){this.isVisible=false;d.addCssClass(this.element,"ace_hidden-cursors");this.restartTimer();};this.showCursor=function(){this.isVisible=true;d.removeCssClass(this.element,"ace_hidden-cursors");this.restartTimer();};this.restartTimer=function(){var u=this.$updateCursors;clearInterval(this.intervalId);clearTimeout(this.timeoutId);this.$stopCssAnimation();if(this.smoothBlinking){this.$isSmoothBlinking=false;d.removeCssClass(this.element,"ace_smooth-blinking");}u(true);if(!this.isBlinking||!this.blinkInterval||!this.isVisible){this.$stopCssAnimation();return;}if(this.smoothBlinking){this.$isSmoothBlinking=true;setTimeout(function(){if(this.$isSmoothBlinking){d.addCssClass(this.element,"ace_smooth-blinking");}}.bind(this));}if(d.HAS_CSS_ANIMATION){this.$startCssAnimation();}else{var b=function(){this.timeoutId=setTimeout(function(){u(false);},0.6*this.blinkInterval);}.bind(this);this.intervalId=setInterval(function(){u(true);b();},this.blinkInterval);b();}};this.getPixelPosition=function(p,o){if(!this.config||!this.session)return{left:0,top:0};if(!p)p=this.session.selection.getCursor();var a=this.session.documentToScreenPosition(p);var c=this.$padding+(this.session.$bidiHandler.isBidiRow(a.row,p.row)?this.session.$bidiHandler.getPosLeft(a.column):a.column*this.config.characterWidth);var b=(a.row-(o?this.config.firstRowScreen:0))*this.config.lineHeight;return{left:c,top:b};};this.isCursorInView=function(p,c){return p.top>=0&&p.top<c.maxHeight;};this.update=function(c){this.config=c;var s=this.session.$selectionMarkers;var i=0,a=0;if(s===undefined||s.length===0){s=[{cursor:null}];}for(var i=0,n=s.length;i<n;i++){var p=this.getPixelPosition(s[i].cursor,true);if((p.top>c.height+c.offset||p.top<0)&&i>1){continue;}var b=this.cursors[a++]||this.addCursor();var f=b.style;if(!this.drawCursor){if(!this.isCursorInView(p,c)){d.setStyle(f,"display","none");}else{d.setStyle(f,"display","block");d.translate(b,p.left,p.top);d.setStyle(f,"width",Math.round(c.characterWidth)+"px");d.setStyle(f,"height",c.lineHeight+"px");}}else{this.drawCursor(b,p,c,s[i],this.session);}}while(this.cursors.length>a)this.removeCursor();var o=this.session.getOverwrite();this.$setOverwrite(o);this.$pixelPos=p;this.restartTimer();};this.drawCursor=null;this.$setOverwrite=function(o){if(o!=this.overwrite){this.overwrite=o;if(o)d.addCssClass(this.element,"ace_overwrite-cursors");else d.removeCssClass(this.element,"ace_overwrite-cursors");}};this.destroy=function(){clearInterval(this.intervalId);clearTimeout(this.timeoutId);};}).call(C.prototype);e.Cursor=C;});ace.define("ace/scrollbar",[],function(r,e,m){"use strict";var o=r("./lib/oop");var d=r("./lib/dom");var a=r("./lib/event");var E=r("./lib/event_emitter").EventEmitter;var M=0x8000;var S=function(p){this.element=d.createElement("div");this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix;this.inner=d.createElement("div");this.inner.className="ace_scrollbar-inner";this.inner.textContent="\xa0";this.element.appendChild(this.inner);p.appendChild(this.element);this.setVisible(false);this.skipEvent=false;a.addListener(this.element,"scroll",this.onScroll.bind(this));a.addListener(this.element,"mousedown",a.preventDefault);};(function(){o.implement(this,E);this.setVisible=function(i){this.element.style.display=i?"":"none";this.isVisible=i;this.coeff=1;};}).call(S.prototype);var V=function(p,b){S.call(this,p);this.scrollTop=0;this.scrollHeight=0;b.$scrollbarWidth=this.width=d.scrollbarWidth(p.ownerDocument);this.inner.style.width=this.element.style.width=(this.width||15)+5+"px";this.$minWidth=0;};o.inherits(V,S);(function(){this.classSuffix='-v';this.onScroll=function(){if(!this.skipEvent){this.scrollTop=this.element.scrollTop;if(this.coeff!=1){var h=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-h)/(this.coeff-h);}this._emit("scroll",{data:this.scrollTop});}this.skipEvent=false;};this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0);};this.setHeight=function(h){this.element.style.height=h+"px";};this.setInnerHeight=this.setScrollHeight=function(h){this.scrollHeight=h;if(h>M){this.coeff=M/h;h=M;}else if(this.coeff!=1){this.coeff=1;}this.inner.style.height=h+"px";};this.setScrollTop=function(s){if(this.scrollTop!=s){this.skipEvent=true;this.scrollTop=s;this.element.scrollTop=s*this.coeff;}};}).call(V.prototype);var H=function(p,b){S.call(this,p);this.scrollLeft=0;this.height=b.$scrollbarWidth;this.inner.style.height=this.element.style.height=(this.height||15)+5+"px";};o.inherits(H,S);(function(){this.classSuffix='-h';this.onScroll=function(){if(!this.skipEvent){this.scrollLeft=this.element.scrollLeft;this._emit("scroll",{data:this.scrollLeft});}this.skipEvent=false;};this.getHeight=function(){return this.isVisible?this.height:0;};this.setWidth=function(w){this.element.style.width=w+"px";};this.setInnerWidth=function(w){this.inner.style.width=w+"px";};this.setScrollWidth=function(w){this.inner.style.width=w+"px";};this.setScrollLeft=function(s){if(this.scrollLeft!=s){this.skipEvent=true;this.scrollLeft=this.element.scrollLeft=s;}};}).call(H.prototype);e.ScrollBar=V;e.ScrollBarV=V;e.ScrollBarH=H;e.VScrollBar=V;e.HScrollBar=H;});ace.define("ace/renderloop",[],function(r,e,m){"use strict";var a=r("./lib/event");var R=function(o,w){this.onRender=o;this.pending=false;this.changes=0;this.$recursionLimit=2;this.window=w||window;var _=this;this._flush=function(t){_.pending=false;var c=_.changes;if(c){a.blockIdle(100);_.changes=0;_.onRender(c);}if(_.changes){if(_.$recursionLimit--<0)return;_.schedule();}else{_.$recursionLimit=2;}};};(function(){this.schedule=function(c){this.changes=this.changes|c;if(this.changes&&!this.pending){a.nextFrame(this._flush);this.pending=true;}};this.clear=function(c){var b=this.changes;this.changes=0;return b;};}).call(R.prototype);e.RenderLoop=R;});ace.define("ace/layer/font_metrics",[],function(g,i,m){var o=g("../lib/oop");var j=g("../lib/dom");var n=g("../lib/lang");var q=g("../lib/event");var s=g("../lib/useragent");var E=g("../lib/event_emitter").EventEmitter;var C=256;var U=typeof ResizeObserver=="function";var L=200;var F=i.FontMetrics=function(p){this.el=j.createElement("div");this.$setMeasureNodeStyles(this.el.style,true);this.$main=j.createElement("div");this.$setMeasureNodeStyles(this.$main.style);this.$measureNode=j.createElement("div");this.$setMeasureNodeStyles(this.$measureNode.style);this.el.appendChild(this.$main);this.el.appendChild(this.$measureNode);p.appendChild(this.el);this.$measureNode.textContent=n.stringRepeat("X",C);this.$characterSize={width:0,height:0};if(U)this.$addObserver();else this.checkForSizeChanges();};(function(){o.implement(this,E);this.$characterSize={width:0,height:0};this.$setMeasureNodeStyles=function(a,b){a.width=a.height="auto";a.left=a.top="0px";a.visibility="hidden";a.position="absolute";a.whiteSpace="pre";if(s.isIE<8){a["font-family"]="inherit";}else{a.font="inherit";}a.overflow=b?"hidden":"visible";};this.checkForSizeChanges=function(a){if(a===undefined)a=this.$measureSizes();if(a&&(this.$characterSize.width!==a.width||this.$characterSize.height!==a.height)){this.$measureNode.style.fontWeight="bold";var b=this.$measureSizes();this.$measureNode.style.fontWeight="";this.$characterSize=a;this.charSizes=Object.create(null);this.allowBoldFonts=b&&b.width===a.width&&b.height===a.height;this._emit("changeCharacterSize",{data:a});}};this.$addObserver=function(){var a=this;this.$observer=new window.ResizeObserver(function(e){a.checkForSizeChanges();});this.$observer.observe(this.$measureNode);};this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var a=this;return this.$pollSizeChangesTimer=q.onIdle(function c(){a.checkForSizeChanges();q.onIdle(c,500);},500);};this.setPolling=function(v){if(v){this.$pollSizeChanges();}else if(this.$pollSizeChangesTimer){clearInterval(this.$pollSizeChangesTimer);this.$pollSizeChangesTimer=0;}};this.$measureSizes=function(a){var b={height:(a||this.$measureNode).clientHeight,width:(a||this.$measureNode).clientWidth/C};if(b.width===0||b.height===0)return null;return b;};this.$measureCharWidth=function(c){this.$main.textContent=n.stringRepeat(c,C);var r=this.$main.getBoundingClientRect();return r.width/C;};this.getCharacterWidth=function(c){var w=this.charSizes[c];if(w===undefined){w=this.charSizes[c]=this.$measureCharWidth(c)/this.$characterSize.width;}return w;};this.destroy=function(){clearInterval(this.$pollSizeChangesTimer);if(this.$observer)this.$observer.disconnect();if(this.el&&this.el.parentNode)this.el.parentNode.removeChild(this.el);};this.$getZoom=function a(e){if(!e||!e.parentElement)return 1;return(window.getComputedStyle(e).zoom||1)*a(e.parentElement);};this.$initTransformMeasureNodes=function(){var t=function(t,l){return["div",{style:"position: absolute;top:"+t+"px;left:"+l+"px;"}];};this.els=j.buildDom([t(0,0),t(L,0),t(0,L),t(L,L)],this.el);};this.transformCoordinates=function(e,l){if(e){var z=this.$getZoom(this.el);e=y(1/z,e);}function t(G,H,r){var I=G[1]*H[0]-G[0]*H[1];return[(-H[1]*r[0]+H[0]*r[1])/I,(+G[1]*r[0]-G[0]*r[1])/I];}function v(a,b){return[a[0]-b[0],a[1]-b[1]];}function w(a,b){return[a[0]+b[0],a[1]+b[1]];}function y(a,b){return[a*b[0],a*b[1]];}if(!this.els)this.$initTransformMeasureNodes();function p(G){var r=G.getBoundingClientRect();return[r.left,r.top];}var a=p(this.els[0]);var b=p(this.els[1]);var c=p(this.els[2]);var d=p(this.els[3]);var h=t(v(d,b),v(d,c),v(w(b,c),w(d,a)));var A=y(1+h[0],v(b,a));var B=y(1+h[1],v(c,a));if(l){var x=l;var k=h[0]*x[0]/L+h[1]*x[1]/L+1;var D=w(y(x[0],A),y(x[1],B));return w(y(1/k/L,D),a);}var u=v(e,a);var f=t(v(A,y(h[0],u)),v(B,y(h[1],u)),u);return y(L,f);};}).call(F.prototype);});ace.define("ace/virtual_renderer",[],function(r,a,m){"use strict";var o=r("./lib/oop");var d=r("./lib/dom");var c=r("./config");var G=r("./layer/gutter").Gutter;var M=r("./layer/marker").Marker;var T=r("./layer/text").Text;var C=r("./layer/cursor").Cursor;var H=r("./scrollbar").HScrollBar;var V=r("./scrollbar").VScrollBar;var R=r("./renderloop").RenderLoop;var F=r("./layer/font_metrics").FontMetrics;var E=r("./lib/event_emitter").EventEmitter;var b=".ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;padding: 0;font: 12px/normal 'Monaco', 'Menlo', 'Ubuntu Mono', 'Consolas', 'source-code-pro', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;font-variant-ligatures: no-common-ligatures;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: '';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==\");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==\");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=\");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC\");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_error_bracket {position: absolute;border-bottom: 1px solid #DE5555;border-radius: 0;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII=\"),url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=\");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII=\"),url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC\");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==\");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==\");}.ace_fold-widget.ace_closed {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==\");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC\");}.ace_dark .ace_fold-widget.ace_end {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==\");}.ace_dark .ace_fold-widget.ace_closed {background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==\");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);transform-origin: left;white-space: pre;opacity: 0.7;margin: 0 10px;}";var u=r("./lib/useragent");var f=u.isIE;d.importCssString(b,"ace_editor.css",false);var g=function(h,t){var _=this;this.container=h||d.createElement("div");d.addCssClass(this.container,"ace_editor");if(d.HI_DPI)d.addCssClass(this.container,"ace_hidpi");this.setTheme(t);if(c.get("useStrictCSP")==null)c.set("useStrictCSP",false);this.$gutter=d.createElement("div");this.$gutter.className="ace_gutter";this.container.appendChild(this.$gutter);this.$gutter.setAttribute("aria-hidden",true);this.scroller=d.createElement("div");this.scroller.className="ace_scroller";this.container.appendChild(this.scroller);this.content=d.createElement("div");this.content.className="ace_content";this.scroller.appendChild(this.content);this.$gutterLayer=new G(this.$gutter);this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this));this.$markerBack=new M(this.content);var i=this.$textLayer=new T(this.content);this.canvas=i.element;this.$markerFront=new M(this.content);this.$cursorLayer=new C(this.content);this.$horizScroll=false;this.$vScroll=false;this.scrollBar=this.scrollBarV=new V(this.container,this);this.scrollBarH=new H(this.container,this);this.scrollBarV.on("scroll",function(e){if(!_.$scrollAnimation)_.session.setScrollTop(e.data-_.scrollMargin.top);});this.scrollBarH.on("scroll",function(e){if(!_.$scrollAnimation)_.session.setScrollLeft(e.data-_.scrollMargin.left);});this.scrollTop=0;this.scrollLeft=0;this.cursorPos={row:0,column:0};this.$fontMetrics=new F(this.container);this.$textLayer.$setFontMetrics(this.$fontMetrics);this.$textLayer.on("changeCharacterSize",function(e){_.updateCharacterSize();_.onResize(true,_.gutterWidth,_.$size.width,_.$size.height);_._signal("changeCharacterSize",e);});this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:true};this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1};this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0};this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0};this.$keepTextAreaAtCursor=!u.isIOS;this.$loop=new R(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView);this.$loop.schedule(this.CHANGE_FULL);this.updateCharacterSize();this.setPadding(4);c.resetOptions(this);c._signal("renderer",this);};(function(){this.CHANGE_CURSOR=1;this.CHANGE_MARKER=2;this.CHANGE_GUTTER=4;this.CHANGE_SCROLL=8;this.CHANGE_LINES=16;this.CHANGE_TEXT=32;this.CHANGE_SIZE=64;this.CHANGE_MARKER_BACK=128;this.CHANGE_MARKER_FRONT=256;this.CHANGE_FULL=512;this.CHANGE_H_SCROLL=1024;o.implement(this,E);this.updateCharacterSize=function(){if(this.$textLayer.allowBoldFonts!=this.$allowBoldFonts){this.$allowBoldFonts=this.$textLayer.allowBoldFonts;this.setStyle("ace_nobold",!this.$allowBoldFonts);}this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth();this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight();this.$updatePrintMargin();d.setStyle(this.scroller.style,"line-height",this.lineHeight+"px");};this.setSession=function(s){if(this.session)this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode);this.session=s;if(s&&this.scrollMargin.top&&s.getScrollTop()<=0)s.setScrollTop(-this.scrollMargin.top);this.$cursorLayer.setSession(s);this.$markerBack.setSession(s);this.$markerFront.setSession(s);this.$gutterLayer.setSession(s);this.$textLayer.setSession(s);if(!s)return;this.$loop.schedule(this.CHANGE_FULL);this.session.$setFontMetrics(this.$fontMetrics);this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null;this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this);this.onChangeNewLineMode();this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode);};this.updateLines=function(e,l,h){if(l===undefined)l=Infinity;if(!this.$changedLines){this.$changedLines={firstRow:e,lastRow:l};}else{if(this.$changedLines.firstRow>e)this.$changedLines.firstRow=e;if(this.$changedLines.lastRow<l)this.$changedLines.lastRow=l;}if(this.$changedLines.lastRow<this.layerConfig.firstRow){if(h)this.$changedLines.lastRow=this.layerConfig.lastRow;else return;}if(this.$changedLines.firstRow>this.layerConfig.lastRow)return;this.$loop.schedule(this.CHANGE_LINES);};this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT);this.$textLayer.$updateEolChar();this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR);};this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER);this.$textLayer.onChangeTabSize();};this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT);};this.updateFull=function(e){if(e)this.$renderChanges(this.CHANGE_FULL,true);else this.$loop.schedule(this.CHANGE_FULL);};this.updateFontSize=function(){this.$textLayer.checkForSizeChanges();};this.$changes=0;this.$updateSizeAsync=function(){if(this.$loop.pending)this.$size.$dirty=true;else this.onResize();};this.onResize=function(e,h,w,i){if(this.resizing>2)return;else if(this.resizing>0)this.resizing++;else this.resizing=e?1:0;var j=this.container;if(!i)i=j.clientHeight||j.scrollHeight;if(!w)w=j.clientWidth||j.scrollWidth;var k=this.$updateCachedSize(e,h,w,i);if(!this.$size.scrollerHeight||(!w&&!i))return this.resizing=0;if(e)this.$gutterLayer.$padding=null;if(e)this.$renderChanges(k|this.$changes,true);else this.$loop.schedule(k|this.$changes);if(this.resizing)this.resizing=0;this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null;};this.$updateCachedSize=function(e,h,w,i){i-=(this.$extraHeight||0);var j=0;var s=this.$size;var k={width:s.width,height:s.height,scrollerHeight:s.scrollerHeight,scrollerWidth:s.scrollerWidth};if(i&&(e||s.height!=i)){s.height=i;j|=this.CHANGE_SIZE;s.scrollerHeight=s.height;if(this.$horizScroll)s.scrollerHeight-=this.scrollBarH.getHeight();this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px";j=j|this.CHANGE_SCROLL;}if(w&&(e||s.width!=w)){j|=this.CHANGE_SIZE;s.width=w;if(h==null)h=this.$showGutter?this.$gutter.offsetWidth:0;this.gutterWidth=h;d.setStyle(this.scrollBarH.element.style,"left",h+"px");d.setStyle(this.scroller.style,"left",h+this.margin.left+"px");s.scrollerWidth=Math.max(0,w-h-this.scrollBarV.getWidth()-this.margin.h);d.setStyle(this.$gutter.style,"left",this.margin.left+"px");var l=this.scrollBarV.getWidth()+"px";d.setStyle(this.scrollBarH.element.style,"right",l);d.setStyle(this.scroller.style,"right",l);d.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight());if(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e){j|=this.CHANGE_FULL;}}s.$dirty=!w||!i;if(j)this._signal("resize",k);return j;};this.onGutterResize=function(w){var e=this.$showGutter?w:0;if(e!=this.gutterWidth)this.$changes|=this.$updateCachedSize(true,e,this.$size.width,this.$size.height);if(this.session.getUseWrapMode()&&this.adjustWrapLimit()){this.$loop.schedule(this.CHANGE_FULL);}else if(this.$size.$dirty){this.$loop.schedule(this.CHANGE_FULL);}else{this.$computeLayerConfig();}};this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-this.$padding*2;var l=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(l,this.$showPrintMargin&&this.$printMarginColumn);};this.setAnimatedScroll=function(s){this.setOption("animatedScroll",s);};this.getAnimatedScroll=function(){return this.$animatedScroll;};this.setShowInvisibles=function(s){this.setOption("showInvisibles",s);this.session.$bidiHandler.setShowInvisibles(s);};this.getShowInvisibles=function(){return this.getOption("showInvisibles");};this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides");};this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e);};this.setShowPrintMargin=function(s){this.setOption("showPrintMargin",s);};this.getShowPrintMargin=function(){return this.getOption("showPrintMargin");};this.setPrintMarginColumn=function(s){this.setOption("printMarginColumn",s);};this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn");};this.getShowGutter=function(){return this.getOption("showGutter");};this.setShowGutter=function(s){return this.setOption("showGutter",s);};this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets");};this.setFadeFoldWidgets=function(s){this.setOption("fadeFoldWidgets",s);};this.setHighlightGutterLine=function(s){this.setOption("highlightGutterLine",s);};this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine");};this.$updatePrintMargin=function(){if(!this.$showPrintMargin&&!this.$printMarginEl)return;if(!this.$printMarginEl){var e=d.createElement("div");e.className="ace_layer ace_print-margin-layer";this.$printMarginEl=d.createElement("div");this.$printMarginEl.className="ace_print-margin";e.appendChild(this.$printMarginEl);this.content.insertBefore(e,this.content.firstChild);}var s=this.$printMarginEl.style;s.left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px";s.visibility=this.$showPrintMargin?"visible":"hidden";if(this.session&&this.session.$wrap==-1)this.adjustWrapLimit();};this.getContainerElement=function(){return this.container;};this.getMouseEventTarget=function(){return this.scroller;};this.getTextAreaContainer=function(){return this.container;};this.$moveTextAreaToCursor=function(){if(this.$isMousePressed)return;var s=this.textarea.style;var e=this.$composition;if(!this.$keepTextAreaAtCursor&&!e){d.translate(this.textarea,-100,0);return;}var p=this.$cursorLayer.$pixelPos;if(!p)return;if(e&&e.markerRange)p=this.$cursorLayer.getPixelPosition(e.markerRange.start,true);var c=this.layerConfig;var i=p.top;var j=p.left;i-=c.offset;var h=e&&e.useTextareaForIME?this.lineHeight:f?0:1;if(i<0||i>c.height-h){d.translate(this.textarea,0,0);return;}var w=1;var k=this.$size.height-h;if(!e){i+=this.lineHeight;}else{if(e.useTextareaForIME){var v=this.textarea.value;w=this.characterWidth*(this.session.$getStringScreenWidth(v)[0]);}else{i+=this.lineHeight+2;}}j-=this.scrollLeft;if(j>this.$size.scrollerWidth-w)j=this.$size.scrollerWidth-w;j+=this.gutterWidth+this.margin.left;d.setStyle(s,"height",h+"px");d.setStyle(s,"width",w+"px");d.translate(this.textarea,Math.min(j,this.$size.scrollerWidth-w),Math.min(i,k));};this.getFirstVisibleRow=function(){return this.layerConfig.firstRow;};this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(this.layerConfig.offset===0?0:1);};this.getLastFullyVisibleRow=function(){var c=this.layerConfig;var l=c.lastRow;var t=this.session.documentToScreenRow(l,0)*c.lineHeight;if(t-this.session.getScrollTop()>c.height-c.lineHeight)return l-1;return l;};this.getLastVisibleRow=function(){return this.layerConfig.lastRow;};this.$padding=null;this.setPadding=function(p){this.$padding=p;this.$textLayer.setPadding(p);this.$cursorLayer.setPadding(p);this.$markerFront.setPadding(p);this.$markerBack.setPadding(p);this.$loop.schedule(this.CHANGE_FULL);this.$updatePrintMargin();};this.setScrollMargin=function(t,e,l,h){var s=this.scrollMargin;s.top=t|0;s.bottom=e|0;s.right=h|0;s.left=l|0;s.v=s.top+s.bottom;s.h=s.left+s.right;if(s.top&&this.scrollTop<=0&&this.session)this.session.setScrollTop(-s.top);this.updateFull();};this.setMargin=function(t,e,l,h){var s=this.margin;s.top=t|0;s.bottom=e|0;s.right=h|0;s.left=l|0;s.v=s.top+s.bottom;s.h=s.left+s.right;this.$updateCachedSize(true,this.gutterWidth,this.$size.width,this.$size.height);this.updateFull();};this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible;};this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e);};this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible;};this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e);};this.$updateScrollBarV=function(){var s=this.layerConfig.maxHeight;var e=this.$size.scrollerHeight;if(!this.$maxLines&&this.$scrollPastEnd){s-=(e-this.lineHeight)*this.$scrollPastEnd;if(this.scrollTop>s-e){s=this.scrollTop+e;this.scrollBarV.scrollTop=null;}}this.scrollBarV.setScrollHeight(s+this.scrollMargin.v);this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top);};this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h);this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left);};this.$frozen=false;this.freeze=function(){this.$frozen=true;};this.unfreeze=function(){this.$frozen=false;};this.$renderChanges=function(e,h){if(this.$changes){e|=this.$changes;this.$changes=0;}if((!this.session||!this.container.offsetWidth||this.$frozen)||(!e&&!h)){this.$changes|=e;return;}if(this.$size.$dirty){this.$changes|=e;return this.onResize(true);}if(!this.lineHeight){this.$textLayer.checkForSizeChanges();}this._signal("beforeRender",e);if(this.session&&this.session.$bidiHandler)this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var c=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){e|=this.$computeLayerConfig()|this.$loop.clear();if(c.firstRow!=this.layerConfig.firstRow&&c.firstRowScreen==this.layerConfig.firstRowScreen){var s=this.scrollTop+(c.firstRow-this.layerConfig.firstRow)*this.lineHeight;if(s>0){this.scrollTop=s;e=e|this.CHANGE_SCROLL;e|=this.$computeLayerConfig()|this.$loop.clear();}}c=this.layerConfig;this.$updateScrollBarV();if(e&this.CHANGE_H_SCROLL)this.$updateScrollBarH();d.translate(this.content,-this.scrollLeft,-c.offset);var w=c.width+2*this.$padding+"px";var i=c.minHeight+"px";d.setStyle(this.content.style,"width",w);d.setStyle(this.content.style,"height",i);}if(e&this.CHANGE_H_SCROLL){d.translate(this.content,-this.scrollLeft,-c.offset);this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left";}if(e&this.CHANGE_FULL){this.$changedLines=null;this.$textLayer.update(c);if(this.$showGutter)this.$gutterLayer.update(c);this.$markerBack.update(c);this.$markerFront.update(c);this.$cursorLayer.update(c);this.$moveTextAreaToCursor();this._signal("afterRender",e);return;}if(e&this.CHANGE_SCROLL){this.$changedLines=null;if(e&this.CHANGE_TEXT||e&this.CHANGE_LINES)this.$textLayer.update(c);else this.$textLayer.scrollLines(c);if(this.$showGutter){if(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES)this.$gutterLayer.update(c);else this.$gutterLayer.scrollLines(c);}this.$markerBack.update(c);this.$markerFront.update(c);this.$cursorLayer.update(c);this.$moveTextAreaToCursor();this._signal("afterRender",e);return;}if(e&this.CHANGE_TEXT){this.$changedLines=null;this.$textLayer.update(c);if(this.$showGutter)this.$gutterLayer.update(c);}else if(e&this.CHANGE_LINES){if(this.$updateLines()||(e&this.CHANGE_GUTTER)&&this.$showGutter)this.$gutterLayer.update(c);}else if(e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER){if(this.$showGutter)this.$gutterLayer.update(c);}else if(e&this.CHANGE_CURSOR){if(this.$highlightGutterLine)this.$gutterLayer.updateLineHighlight(c);}if(e&this.CHANGE_CURSOR){this.$cursorLayer.update(c);this.$moveTextAreaToCursor();}if(e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)){this.$markerFront.update(c);}if(e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)){this.$markerBack.update(c);}this._signal("afterRender",e);};this.$autosize=function(){var h=this.session.getScreenLength()*this.lineHeight;var e=this.$maxLines*this.lineHeight;var i=Math.min(e,Math.max((this.$minLines||1)*this.lineHeight,h))+this.scrollMargin.v+(this.$extraHeight||0);if(this.$horizScroll)i+=this.scrollBarH.getHeight();if(this.$maxPixelHeight&&i>this.$maxPixelHeight)i=this.$maxPixelHeight;var j=i<=2*this.lineHeight;var s=!j&&h>e;if(i!=this.desiredHeight||this.$size.height!=this.desiredHeight||s!=this.$vScroll){if(s!=this.$vScroll){this.$vScroll=s;this.scrollBarV.setVisible(s);}var w=this.container.clientWidth;this.container.style.height=i+"px";this.$updateCachedSize(true,this.$gutterWidth,w,i);this.desiredHeight=i;this._signal("autosize");}};this.$computeLayerConfig=function(){var s=this.session;var e=this.$size;var h=e.height<=2*this.lineHeight;var i=this.session.getScreenLength();var j=i*this.lineHeight;var l=this.$getLongestLine();var k=!h&&(this.$hScrollBarAlwaysVisible||e.scrollerWidth-l-2*this.$padding<0);var n=this.$horizScroll!==k;if(n){this.$horizScroll=k;this.scrollBarH.setVisible(k);}var S=this.$vScroll;if(this.$maxLines&&this.lineHeight>1)this.$autosize();var p=e.scrollerHeight+this.lineHeight;var q=!this.$maxLines&&this.$scrollPastEnd?(e.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;j+=q;var t=this.scrollMargin;this.session.setScrollTop(Math.max(-t.top,Math.min(this.scrollTop,j-e.scrollerHeight+t.bottom)));this.session.setScrollLeft(Math.max(-t.left,Math.min(this.scrollLeft,l+2*this.$padding-e.scrollerWidth+t.right)));var v=!h&&(this.$vScrollBarAlwaysVisible||e.scrollerHeight-j+q<0||this.scrollTop>t.top);var w=S!==v;if(w){this.$vScroll=v;this.scrollBarV.setVisible(v);}var x=this.scrollTop%this.lineHeight;var y=Math.ceil(p/this.lineHeight)-1;var z=Math.max(0,Math.round((this.scrollTop-x)/this.lineHeight));var A=z+y;var B,D;var I=this.lineHeight;z=s.screenToDocumentRow(z,0);var J=s.getFoldLine(z);if(J){z=J.start.row;}B=s.documentToScreenRow(z,0);D=s.getRowLength(z)*I;A=Math.min(s.screenToDocumentRow(A,0),s.getLength()-1);p=e.scrollerHeight+s.getRowLength(A)*I+D;x=this.scrollTop-B*I;var K=0;if(this.layerConfig.width!=l||n)K=this.CHANGE_H_SCROLL;if(n||w){K|=this.$updateCachedSize(true,this.gutterWidth,e.width,e.height);this._signal("scrollbarVisibilityChanged");if(w)l=this.$getLongestLine();}this.layerConfig={width:l,padding:this.$padding,firstRow:z,firstRowScreen:B,lastRow:A,lineHeight:I,characterWidth:this.characterWidth,minHeight:p,maxHeight:j,offset:x,gutterOffset:I?Math.max(0,Math.ceil((x+e.height-e.scrollerHeight)/I)):0,height:this.$size.scrollerHeight};if(this.session.$bidiHandler)this.session.$bidiHandler.setContentWidth(l-this.$padding);return K;};this.$updateLines=function(){if(!this.$changedLines)return;var e=this.$changedLines.firstRow;var l=this.$changedLines.lastRow;this.$changedLines=null;var h=this.layerConfig;if(e>h.lastRow+1){return;}if(l<h.firstRow){return;}if(l===Infinity){if(this.$showGutter)this.$gutterLayer.update(h);this.$textLayer.update(h);return;}this.$textLayer.updateLines(h,e,l);return true;};this.$getLongestLine=function(){var e=this.session.getScreenWidth();if(this.showInvisibles&&!this.session.$useWrapMode)e+=1;if(this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH)e=this.$textLayer.MAX_LINE_LENGTH+30;return Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth));};this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(true));this.$loop.schedule(this.CHANGE_MARKER_FRONT);};this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers());this.$loop.schedule(this.CHANGE_MARKER_BACK);};this.addGutterDecoration=function(e,h){this.$gutterLayer.addGutterDecoration(e,h);};this.removeGutterDecoration=function(e,h){this.$gutterLayer.removeGutterDecoration(e,h);};this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER);};this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e);this.$loop.schedule(this.CHANGE_GUTTER);};this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR);};this.hideCursor=function(){this.$cursorLayer.hideCursor();};this.showCursor=function(){this.$cursorLayer.showCursor();};this.scrollSelectionIntoView=function(e,l,h){this.scrollCursorIntoView(e,h);this.scrollCursorIntoView(l,h);};this.scrollCursorIntoView=function(e,h,$){if(this.$size.scrollerHeight===0)return;var p=this.$cursorLayer.getPixelPosition(e);var l=p.left;var t=p.top;var i=$&&$.top||0;var j=$&&$.bottom||0;var s=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;if(s+i>t){if(h&&s+i>t+this.lineHeight)t-=h*this.$size.scrollerHeight;if(t===0)t=-this.scrollMargin.top;this.session.setScrollTop(t);}else if(s+this.$size.scrollerHeight-j<t+this.lineHeight){if(h&&s+this.$size.scrollerHeight-j<t-this.lineHeight)t+=h*this.$size.scrollerHeight;this.session.setScrollTop(t+this.lineHeight+j-this.$size.scrollerHeight);}var k=this.scrollLeft;if(k>l){if(l<this.$padding+2*this.layerConfig.characterWidth)l=-this.scrollMargin.left;this.session.setScrollLeft(l);}else if(k+this.$size.scrollerWidth<l+this.characterWidth){this.session.setScrollLeft(Math.round(l+this.characterWidth-this.$size.scrollerWidth));}else if(k<=this.$padding&&l-k<this.characterWidth){this.session.setScrollLeft(0);}};this.getScrollTop=function(){return this.session.getScrollTop();};this.getScrollLeft=function(){return this.session.getScrollLeft();};this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight;};this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1);};this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight);};this.alignCursor=function(e,i){if(typeof e=="number")e={row:e,column:0};var p=this.$cursorLayer.getPixelPosition(e);var h=this.$size.scrollerHeight-this.lineHeight;var j=p.top-h*(i||0);this.session.setScrollTop(j);return j;};this.STEPS=8;this.$calcSteps=function(e,h){var i=0;var l=this.STEPS;var s=[];var j=function(t,x,k){return k*(Math.pow(t-1,3)+1)+x;};for(i=0;i<l;++i)s.push(j(i/this.STEPS,e,h-e));return s;};this.scrollToLine=function(l,e,h,i){var p=this.$cursorLayer.getPixelPosition({row:l,column:0});var j=p.top;if(e)j-=this.$size.scrollerHeight/2;var k=this.scrollTop;this.session.setScrollTop(j);if(h!==false)this.animateScrolling(k,i);};this.animateScrolling=function(e,h){var t=this.scrollTop;if(!this.$animatedScroll)return;var _=this;if(e==t)return;if(this.$scrollAnimation){var i=this.$scrollAnimation.steps;if(i.length){e=i[0];if(e==t)return;}}var s=_.$calcSteps(e,t);this.$scrollAnimation={from:e,to:t,steps:s};clearInterval(this.$timer);_.session.setScrollTop(s.shift());_.session.$scrollTop=t;this.$timer=setInterval(function(){if(!_.session)return clearInterval(_.$timer);if(s.length){_.session.setScrollTop(s.shift());_.session.$scrollTop=t;}else if(t!=null){_.session.$scrollTop=-1;_.session.setScrollTop(t);t=null;}else{_.$timer=clearInterval(_.$timer);_.$scrollAnimation=null;h&&h();}},10);};this.scrollToY=function(s){if(this.scrollTop!==s){this.$loop.schedule(this.CHANGE_SCROLL);this.scrollTop=s;}};this.scrollToX=function(s){if(this.scrollLeft!==s)this.scrollLeft=s;this.$loop.schedule(this.CHANGE_H_SCROLL);};this.scrollTo=function(x,y){this.session.setScrollTop(y);this.session.setScrollLeft(x);};this.scrollBy=function(e,h){h&&this.session.setScrollTop(this.session.getScrollTop()+h);e&&this.session.setScrollLeft(this.session.getScrollLeft()+e);};this.isScrollableBy=function(e,h){if(h<0&&this.session.getScrollTop()>=1-this.scrollMargin.top)return true;if(h>0&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom)return true;if(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left)return true;if(e>0&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right)return true;};this.pixelToScreenCoordinates=function(x,y){var e;if(this.$hasCssTransforms){e={top:0,left:0};var p=this.$fontMetrics.transformCoordinates([x,y]);x=p[1]-this.gutterWidth-this.margin.left;y=p[0];}else{e=this.scroller.getBoundingClientRect();}var h=x+this.scrollLeft-e.left-this.$padding;var i=h/this.characterWidth;var j=Math.floor((y+this.scrollTop-e.top)/this.lineHeight);var k=this.$blockCursor?Math.floor(i):Math.round(i);return{row:j,column:k,side:i-k>0?1:-1,offsetX:h};};this.screenToTextCoordinates=function(x,y){var e;if(this.$hasCssTransforms){e={top:0,left:0};var p=this.$fontMetrics.transformCoordinates([x,y]);x=p[1]-this.gutterWidth-this.margin.left;y=p[0];}else{e=this.scroller.getBoundingClientRect();}var h=x+this.scrollLeft-e.left-this.$padding;var i=h/this.characterWidth;var j=this.$blockCursor?Math.floor(i):Math.round(i);var k=Math.floor((y+this.scrollTop-e.top)/this.lineHeight);return this.session.screenToDocumentPosition(k,Math.max(j,0),h);};this.textToScreenCoordinates=function(e,h){var i=this.scroller.getBoundingClientRect();var p=this.session.documentToScreenPosition(e,h);var x=this.$padding+(this.session.$bidiHandler.isBidiRow(p.row,e)?this.session.$bidiHandler.getPosLeft(p.column):Math.round(p.column*this.characterWidth));var y=p.row*this.lineHeight;return{pageX:i.left+x-this.scrollLeft,pageY:i.top+y-this.scrollTop};};this.visualizeFocus=function(){d.addCssClass(this.container,"ace_focus");};this.visualizeBlur=function(){d.removeCssClass(this.container,"ace_focus");};this.showComposition=function(e){this.$composition=e;if(!e.cssText){e.cssText=this.textarea.style.cssText;}if(e.useTextareaForIME==undefined)e.useTextareaForIME=this.$useTextareaForIME;if(this.$useTextareaForIME){d.addCssClass(this.textarea,"ace_composition");this.textarea.style.cssText="";this.$moveTextAreaToCursor();this.$cursorLayer.element.style.display="none";}else{e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text");}};this.setCompositionText=function(t){var e=this.session.selection.cursor;this.addToken(t,"composition_placeholder",e.row,e.column);this.$moveTextAreaToCursor();};this.hideComposition=function(){if(!this.$composition)return;if(this.$composition.markerId)this.session.removeMarker(this.$composition.markerId);d.removeCssClass(this.textarea,"ace_composition");this.textarea.style.cssText=this.$composition.cssText;var e=this.session.selection.cursor;this.removeExtraToken(e.row,e.column);this.$composition=null;this.$cursorLayer.element.style.display="";};this.addToken=function(t,e,h,j){var s=this.session;s.bgTokenizer.lines[h]=null;var n={type:e,value:t};var k=s.getTokens(h);if(j==null){k.push(n);}else{var l=0;for(var i=0;i<k.length;i++){var p=k[i];l+=p.value.length;if(j<=l){var q=p.value.length-(l-j);var v=p.value.slice(0,q);var w=p.value.slice(q);k.splice(i,1,{type:p.type,value:v},n,{type:p.type,value:w});break;}}}this.updateLines(h,h);};this.removeExtraToken=function(e,h){this.updateLines(e,e);};this.setTheme=function(t,e){var _=this;this.$themeId=t;_._dispatchEvent('themeChange',{theme:t});if(!t||typeof t=="string"){var h=t||this.$options.theme.initialValue;c.loadModule(["theme",h],i);}else{i(t);}function i(m){if(_.$themeId!=t)return e&&e();if(!m||!m.cssClass)throw new Error("couldn't load module "+t+" or it didn't call define");if(m.$id)_.$themeId=m.$id;d.importCssString(m.cssText,m.cssClass,_.container);if(_.theme)d.removeCssClass(_.container,_.theme.cssClass);var p="padding"in m?m.padding:"padding"in(_.theme||{})?4:_.$padding;if(_.$padding&&p!=_.$padding)_.setPadding(p);_.$theme=m.cssClass;_.theme=m;d.addCssClass(_.container,m.cssClass);d.setCssClass(_.container,"ace_dark",m.isDark);if(_.$size){_.$size.width=0;_.$updateSizeAsync();}_._dispatchEvent('themeLoaded',{theme:m});e&&e();}};this.getTheme=function(){return this.$themeId;};this.setStyle=function(s,i){d.setCssClass(this.container,s,i!==false);};this.unsetStyle=function(s){d.removeCssClass(this.container,s);};this.setCursorStyle=function(s){d.setStyle(this.scroller.style,"cursor",s);};this.setMouseCursor=function(e){d.setStyle(this.scroller.style,"cursor",e);};this.attachToShadowRoot=function(){d.importCssString(b,"ace_editor.css",this.container);};this.destroy=function(){this.freeze();this.$fontMetrics.destroy();this.$cursorLayer.destroy();this.removeAllListeners();this.container.textContent="";};}).call(g.prototype);c.defineOptions(g.prototype,"renderer",{animatedScroll:{initialValue:false},showInvisibles:{set:function(v){if(this.$textLayer.setShowInvisibles(v))this.$loop.schedule(this.CHANGE_TEXT);},initialValue:false},showPrintMargin:{set:function(){this.$updatePrintMargin();},initialValue:true},printMarginColumn:{set:function(){this.$updatePrintMargin();},initialValue:80},printMargin:{set:function(v){if(typeof v=="number")this.$printMarginColumn=v;this.$showPrintMargin=!!v;this.$updatePrintMargin();},get:function(){return this.$showPrintMargin&&this.$printMarginColumn;}},showGutter:{set:function(s){this.$gutter.style.display=s?"block":"none";this.$loop.schedule(this.CHANGE_FULL);this.onGutterResize();},initialValue:true},fadeFoldWidgets:{set:function(s){d.setCssClass(this.$gutter,"ace_fade-fold-widgets",s);},initialValue:false},showFoldWidgets:{set:function(s){this.$gutterLayer.setShowFoldWidgets(s);this.$loop.schedule(this.CHANGE_GUTTER);},initialValue:true},displayIndentGuides:{set:function(s){if(this.$textLayer.setDisplayIndentGuides(s))this.$loop.schedule(this.CHANGE_TEXT);},initialValue:true},highlightGutterLine:{set:function(s){this.$gutterLayer.setHighlightGutterLine(s);this.$loop.schedule(this.CHANGE_GUTTER);},initialValue:true},hScrollBarAlwaysVisible:{set:function(v){if(!this.$hScrollBarAlwaysVisible||!this.$horizScroll)this.$loop.schedule(this.CHANGE_SCROLL);},initialValue:false},vScrollBarAlwaysVisible:{set:function(v){if(!this.$vScrollBarAlwaysVisible||!this.$vScroll)this.$loop.schedule(this.CHANGE_SCROLL);},initialValue:false},fontSize:{set:function(s){if(typeof s=="number")s=s+"px";this.container.style.fontSize=s;this.updateFontSize();},initialValue:12},fontFamily:{set:function(n){this.container.style.fontFamily=n;this.updateFontSize();}},maxLines:{set:function(v){this.updateFull();}},minLines:{set:function(v){if(!(this.$minLines<0x1ffffffffffff))this.$minLines=0;this.updateFull();}},maxPixelHeight:{set:function(v){this.updateFull();},initialValue:0},scrollPastEnd:{set:function(v){v=+v||0;if(this.$scrollPastEnd==v)return;this.$scrollPastEnd=v;this.$loop.schedule(this.CHANGE_SCROLL);},initialValue:0,handlesSet:true},fixedWidthGutter:{set:function(v){this.$gutterLayer.$fixedWidth=!!v;this.$loop.schedule(this.CHANGE_GUTTER);}},theme:{set:function(v){this.setTheme(v);},get:function(){return this.$themeId||this.theme;},initialValue:"./theme/textmate",handlesSet:true},hasCssTransforms:{},useTextareaForIME:{initialValue:!u.isMobile&&!u.isIE}});a.VirtualRenderer=g;});ace.define("ace/worker/worker_client",[],function(r,a,m){"use strict";var o=r("../lib/oop");var n=r("../lib/net");var E=r("../lib/event_emitter").EventEmitter;var c=r("../config");function $(w){var s="importScripts('"+n.qualifyURL(w)+"');";try{return new Blob([s],{"type":"application/javascript"});}catch(e){var B=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder;var d=new B();d.append(s);return d.getBlob("application/javascript");}}function b(w){if(typeof Worker=="undefined")return{postMessage:function(){},terminate:function(){}};if(c.get("loadWorkerFromBlob")){var d=$(w);var e=window.URL||window.webkitURL;var f=e.createObjectURL(d);return new Worker(f);}return new Worker(w);}var W=function(w){if(!w.postMessage)w=this.$createWorkerFromOldConfig.apply(this,arguments);this.$worker=w;this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this);this.changeListener=this.changeListener.bind(this);this.onMessage=this.onMessage.bind(this);this.callbackId=1;this.callbacks={};this.$worker.onmessage=this.onMessage;};(function(){o.implement(this,E);this.$createWorkerFromOldConfig=function(t,d,e,w,i){if(r.nameToUrl&&!r.toUrl)r.toUrl=r.nameToUrl;if(c.get("packaged")||!r.toUrl){w=w||c.moduleUrl(d,"worker");}else{var f=this.$normalizePath;w=w||f(r.toUrl("ace/worker/worker.js",null,"_"));var g={};t.forEach(function(h){g[h]=f(r.toUrl(h,null,"_").replace(/(\.js)?(\?.*)?$/,""));});}this.$worker=b(w);if(i){this.send("importScripts",i);}this.$worker.postMessage({init:true,tlns:g,module:d,classname:e});return this.$worker;};this.onMessage=function(e){var d=e.data;switch(d.type){case"event":this._signal(d.name,{data:d.data});break;case"call":var f=this.callbacks[d.id];if(f){f(d.data);delete this.callbacks[d.id];}break;case"error":this.reportError(d.data);break;case"log":window.console&&console.log&&console.log.apply(console,d.data);break;}};this.reportError=function(e){window.console&&console.error&&console.error(e);};this.$normalizePath=function(p){return n.qualifyURL(p);};this.terminate=function(){this._signal("terminate",{});this.deltaQueue=null;this.$worker.terminate();this.$worker=null;if(this.$doc)this.$doc.off("change",this.changeListener);this.$doc=null;};this.send=function(d,e){this.$worker.postMessage({command:d,args:e});};this.call=function(d,e,f){if(f){var i=this.callbackId++;this.callbacks[i]=f;e.push(i);}this.send(d,e);};this.emit=function(e,d){try{if(d.data&&d.data.err)d.data.err={message:d.data.err.message,stack:d.data.err.stack,code:d.data.err.code};this.$worker.postMessage({event:e,data:{data:d.data}});}catch(f){console.error(f.stack);}};this.attachToDocument=function(d){if(this.$doc)this.terminate();this.$doc=d;this.call("setValue",[d.getValue()]);d.on("change",this.changeListener);};this.changeListener=function(d){if(!this.deltaQueue){this.deltaQueue=[];setTimeout(this.$sendDeltaQueue,0);}if(d.action=="insert")this.deltaQueue.push(d.start,d.lines);else this.deltaQueue.push(d.start,d.end);};this.$sendDeltaQueue=function(){var q=this.deltaQueue;if(!q)return;this.deltaQueue=null;if(q.length>50&&q.length>this.$doc.getLength()>>1){this.call("setValue",[this.$doc.getValue()]);}else this.emit("change",{data:q});};}).call(W.prototype);var U=function(t,d,f){var g=null;var h=false;var s=Object.create(E);var i=[];var w=new W({messageBuffer:i,terminate:function(){},postMessage:function(e){i.push(e);if(!g)return;if(h)setTimeout(p);else p();}});w.setEmitSync=function(v){h=v;};var p=function(){var e=i.shift();if(e.command)g[e.command].apply(g,e.args);else if(e.event)s._signal(e.event,e.data);};s.postMessage=function(e){w.onMessage({data:e});};s.callback=function(e,j){this.postMessage({type:"call",id:j,data:e});};s.emit=function(e,j){this.postMessage({type:"event",name:e,data:j});};c.loadModule(["worker",d],function(M){g=new M[f](s);while(i.length)p();});return w;};a.UIWorkerClient=U;a.WorkerClient=W;a.createWorker=b;});ace.define("ace/placeholder",[],function(r,e,m){"use strict";var R=r("./range").Range;var E=r("./lib/event_emitter").EventEmitter;var o=r("./lib/oop");var P=function(s,l,p,a,b,c){var _=this;this.length=l;this.session=s;this.doc=s.getDocument();this.mainClass=b;this.othersClass=c;this.$onUpdate=this.onUpdate.bind(this);this.doc.on("change",this.$onUpdate);this.$others=a;this.$onCursorChange=function(){setTimeout(function(){_.onCursorChange();});};this.$pos=p;var u=s.getUndoManager().$undoStack||s.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=u.length;this.setup();s.selection.on("changeCursor",this.$onCursorChange);};(function(){o.implement(this,E);this.setup=function(){var _=this;var d=this.doc;var s=this.session;this.selectionBefore=s.selection.toJSON();if(s.selection.inMultiSelectMode)s.selection.toSingleRange();this.pos=d.createAnchor(this.$pos.row,this.$pos.column);var p=this.pos;p.$insertRight=true;p.detach();p.markerId=s.addMarker(new R(p.row,p.column,p.row,p.column+this.length),this.mainClass,null,false);this.others=[];this.$others.forEach(function(a){var b=d.createAnchor(a.row,a.column);b.$insertRight=true;b.detach();_.others.push(b);});s.setUndoSelect(false);};this.showOtherMarkers=function(){if(this.othersActive)return;var s=this.session;var _=this;this.othersActive=true;this.others.forEach(function(a){a.markerId=s.addMarker(new R(a.row,a.column,a.row,a.column+_.length),_.othersClass,null,false);});};this.hideOtherMarkers=function(){if(!this.othersActive)return;this.othersActive=false;for(var i=0;i<this.others.length;i++){this.session.removeMarker(this.others[i].markerId);}};this.onUpdate=function(d){if(this.$updating)return this.updateAnchors(d);var a=d;if(a.start.row!==a.end.row)return;if(a.start.row!==this.pos.row)return;this.$updating=true;var l=d.action==="insert"?a.end.column-a.start.column:a.start.column-a.end.column;var b=a.start.column>=this.pos.column&&a.start.column<=this.pos.column+this.length+1;var c=a.start.column-this.pos.column;this.updateAnchors(d);if(b)this.length+=l;if(b&&!this.session.$fromUndo){if(d.action==='insert'){for(var i=this.others.length-1;i>=0;i--){var f=this.others[i];var n={row:f.row,column:f.column+c};this.doc.insertMergedLines(n,d.lines);}}else if(d.action==='remove'){for(var i=this.others.length-1;i>=0;i--){var f=this.others[i];var n={row:f.row,column:f.column+c};this.doc.remove(new R(n.row,n.column,n.row,n.column-l));}}}this.$updating=false;this.updateMarkers();};this.updateAnchors=function(d){this.pos.onChange(d);for(var i=this.others.length;i--;)this.others[i].onChange(d);this.updateMarkers();};this.updateMarkers=function(){if(this.$updating)return;var _=this;var s=this.session;var u=function(p,c){s.removeMarker(p.markerId);p.markerId=s.addMarker(new R(p.row,p.column,p.row,p.column+_.length),c,null,false);};u(this.pos,this.mainClass);for(var i=this.others.length;i--;)u(this.others[i],this.othersClass);};this.onCursorChange=function(a){if(this.$updating||!this.session)return;var p=this.session.selection.getCursor();if(p.row===this.pos.row&&p.column>=this.pos.column&&p.column<=this.pos.column+this.length){this.showOtherMarkers();this._emit("cursorEnter",a);}else{this.hideOtherMarkers();this._emit("cursorLeave",a);}};this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId);this.hideOtherMarkers();this.doc.off("change",this.$onUpdate);this.session.selection.off("changeCursor",this.$onCursorChange);this.session.setUndoSelect(true);this.session=null;};this.cancel=function(){if(this.$undoStackDepth===-1)return;var u=this.session.getUndoManager();var a=(u.$undoStack||u.$undostack).length-this.$undoStackDepth;for(var i=0;i<a;i++){u.undo(this.session,true);}if(this.selectionBefore)this.session.selection.fromJSON(this.selectionBefore);};}).call(P.prototype);e.PlaceHolder=P;});ace.define("ace/mouse/multi_select_handler",[],function(r,a,m){var b=r("../lib/event");var u=r("../lib/useragent");function c(p,d){return p.row==d.row&&p.column==d.column;}function o(e){var d=e.domEvent;var f=d.altKey;var s=d.shiftKey;var g=d.ctrlKey;var h=e.getAccelKey();var j=e.getButton();if(g&&u.isMac)j=d.button;if(e.editor.inMultiSelectMode&&j==2){e.editor.textInput.onContextMenu(e.domEvent);return;}if(!g&&!f&&!h){if(j===0&&e.editor.inMultiSelectMode)e.editor.exitMultiSelectMode();return;}if(j!==0)return;var k=e.editor;var l=k.selection;var n=k.inMultiSelectMode;var p=e.getDocumentPosition();var q=l.getCursor();var t=e.inSelection()||(l.isEmpty()&&c(p,q));var v=e.x,w=e.y;var x=function(e){v=e.clientX;w=e.clientY;};var y=k.session;var z=k.renderer.pixelToScreenCoordinates(v,w);var A=z;var B;if(k.$mouseHandler.$enableJumpToDef){if(g&&f||h&&f)B=s?"block":"add";else if(f&&k.$blockSelectEnabled)B="block";}else{if(h&&!f){B="add";if(!n&&s)return;}else if(f&&k.$blockSelectEnabled){B="block";}}if(B&&u.isMac&&d.ctrlKey){k.$mouseHandler.cancelContextMenu();}if(B=="add"){if(!n&&t)return;if(!n){var C=l.toOrientedRange();k.addSelectionMarker(C);}var D=l.rangeList.rangeAtPoint(p);k.inVirtualSelectionMode=true;if(s){D=null;C=l.ranges[0]||C;k.removeSelectionMarker(C);}k.once("mouseup",function(){var i=l.toOrientedRange();if(D&&i.isEmpty()&&c(D.cursor,i.cursor))l.substractPoint(i.cursor);else{if(s){l.substractPoint(C.cursor);}else if(C){k.removeSelectionMarker(C);l.addRange(C);}l.addRange(i);}k.inVirtualSelectionMode=false;});}else if(B=="block"){e.stop();k.inVirtualSelectionMode=true;var E;var F=[];var G=function(){var i=k.renderer.pixelToScreenCoordinates(v,w);var q=y.screenToDocumentPosition(i.row,i.column,i.offsetX);if(c(A,i)&&c(q,l.lead))return;A=i;k.selection.moveToPosition(q);k.renderer.scrollCursorIntoView();k.removeSelectionMarkers(F);F=l.rectangularRangeBlock(A,z);if(k.$mouseHandler.$clickSelection&&F.length==1&&F[0].isEmpty())F[0]=k.$mouseHandler.$clickSelection.clone();F.forEach(k.addSelectionMarker,k);k.updateSelectionMarkers();};if(n&&!h){l.toSingleRange();}else if(!n&&h){E=l.toOrientedRange();k.addSelectionMarker(E);}if(s)z=y.documentToScreenPosition(l.lead);else l.moveToPosition(p);A={row:-1,column:-1};var H=function(e){G();clearInterval(J);k.removeSelectionMarkers(F);if(!F.length)F=[l.toOrientedRange()];if(E){k.removeSelectionMarker(E);l.toSingleRange(E);}for(var i=0;i<F.length;i++)l.addRange(F[i]);k.inVirtualSelectionMode=false;k.$mouseHandler.$clickSelection=null;};var I=G;b.capture(k.container,x,H);var J=setInterval(function(){I();},20);return e.preventDefault();}}a.onMouseDown=o;});ace.define("ace/commands/multi_select_commands",[],function(r,e,m){e.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(a){a.selectMoreLines(-1);},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:true},{name:"addCursorBelow",description:"Add cursor below",exec:function(a){a.selectMoreLines(1);},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:true},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(a){a.selectMoreLines(-1,true);},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:true},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(a){a.selectMoreLines(1,true);},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:true},{name:"selectMoreBefore",description:"Select more before",exec:function(a){a.selectMore(-1);},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:true},{name:"selectMoreAfter",description:"Select more after",exec:function(a){a.selectMore(1);},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:true},{name:"selectNextBefore",description:"Select next before",exec:function(a){a.selectMore(-1,true);},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:true},{name:"selectNextAfter",description:"Select next after",exec:function(a){a.selectMore(1,true);},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:true},{name:"toggleSplitSelectionIntoLines",description:"Split into lines",exec:function(a){if(a.multiSelect.rangeCount>1)a.multiSelect.joinSelections();else a.multiSelect.splitIntoLines();},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:true},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(a){a.multiSelect.splitIntoLines();},readOnly:true},{name:"alignCursors",description:"Align cursors",exec:function(a){a.alignCursors();},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(a){a.findAll();},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:true}];e.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(a){a.exitMultiSelectMode();},scrollIntoView:"cursor",readOnly:true,isAvailable:function(a){return a&&a.inMultiSelectMode;}}];var H=r("../keyboard/hash_handler").HashHandler;e.keyboardHandler=new H(e.multiSelectCommands);});ace.define("ace/multi_select",[],function(a,b,c){var R=a("./range_list").RangeList;var f=a("./range").Range;var S=a("./selection").Selection;var o=a("./mouse/multi_select_handler").onMouseDown;var g=a("./lib/event");var h=a("./lib/lang");var j=a("./commands/multi_select_commands");b.commands=j.defaultCommands.concat(j.multiSelectCommands);var k=a("./search").Search;var s=new k();function q(d,n,e){s.$options.wrap=true;s.$options.needle=n;s.$options.backwards=e==-1;return s.find(d);}var E=a("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers;};}).call(E.prototype);(function(){this.ranges=null;this.rangeList=null;this.addRange=function(r,$){if(!r)return;if(!this.inMultiSelectMode&&this.rangeCount===0){var d=this.toOrientedRange();this.rangeList.add(d);this.rangeList.add(r);if(this.rangeList.ranges.length!=2){this.rangeList.removeAll();return $||this.fromOrientedRange(r);}this.rangeList.removeAll();this.rangeList.add(d);this.$onAddRange(d);}if(!r.cursor)r.cursor=r.end;var e=this.rangeList.add(r);this.$onAddRange(r);if(e.length)this.$onRemoveRange(e);if(this.rangeCount>1&&!this.inMultiSelectMode){this._signal("multiSelect");this.inMultiSelectMode=true;this.session.$undoSelect=false;this.rangeList.attach(this.session);}return $||this.fromOrientedRange(r);};this.toSingleRange=function(r){r=r||this.ranges[0];var d=this.rangeList.removeAll();if(d.length)this.$onRemoveRange(d);r&&this.fromOrientedRange(r);};this.substractPoint=function(p){var r=this.rangeList.substractPoint(p);if(r){this.$onRemoveRange(r);return r[0];}};this.mergeOverlappingRanges=function(){var r=this.rangeList.merge();if(r.length)this.$onRemoveRange(r);};this.$onAddRange=function(r){this.rangeCount=this.rangeList.ranges.length;this.ranges.unshift(r);this._signal("addRange",{range:r});};this.$onRemoveRange=function(r){this.rangeCount=this.rangeList.ranges.length;if(this.rangeCount==1&&this.inMultiSelectMode){var l=this.rangeList.ranges.pop();r.push(l);this.rangeCount=0;}for(var i=r.length;i--;){var d=this.ranges.indexOf(r[i]);this.ranges.splice(d,1);}this._signal("removeRange",{ranges:r});if(this.rangeCount===0&&this.inMultiSelectMode){this.inMultiSelectMode=false;this._signal("singleSelect");this.session.$undoSelect=true;this.rangeList.detach(this.session);}l=l||this.ranges[0];if(l&&!l.isEqual(this.getRange()))this.fromOrientedRange(l);};this.$initRangeList=function(){if(this.rangeList)return;this.rangeList=new R();this.ranges=[];this.rangeCount=0;};this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()];};this.splitIntoLines=function(){var r=this.ranges.length?this.ranges:[this.getRange()];var n=[];for(var i=0;i<r.length;i++){var d=r[i];var e=d.start.row;var l=d.end.row;if(e===l){n.push(d.clone());}else{n.push(new f(e,d.start.column,e,this.session.getLine(e).length));while(++e<l)n.push(this.getLineRange(e,true));n.push(new f(l,0,l,d.end.column));}if(i==0&&!this.isBackwards())n=n.reverse();}this.toSingleRange();for(var i=n.length;i--;)this.addRange(n[i]);};this.joinSelections=function(){var r=this.rangeList.ranges;var l=r[r.length-1];var d=f.fromPoints(r[0].start,l.end);this.toSingleRange();this.setSelectionRange(d,l.cursor==l.start);};this.toggleBlockSelection=function(){if(this.rangeCount>1){var r=this.rangeList.ranges;var l=r[r.length-1];var d=f.fromPoints(r[0].start,l.end);this.toSingleRange();this.setSelectionRange(d,l.cursor==l.start);}else{var e=this.session.documentToScreenPosition(this.cursor);var i=this.session.documentToScreenPosition(this.anchor);var m=this.rectangularRangeBlock(e,i);m.forEach(this.addRange,this);}};this.rectangularRangeBlock=function(d,e,l){var r=[];var x=d.column<e.column;if(x){var m=d.column;var n=e.column;var p=d.offsetX;var w=e.offsetX;}else{var m=e.column;var n=d.column;var p=e.offsetX;var w=d.offsetX;}var y=d.row<e.row;if(y){var z=d.row;var A=e.row;}else{var z=e.row;var A=d.row;}if(m<0)m=0;if(z<0)z=0;if(z==A)l=true;var B;for(var C=z;C<=A;C++){var D=f.fromPoints(this.session.screenToDocumentPosition(C,m,p),this.session.screenToDocumentPosition(C,n,w));if(D.isEmpty()){if(B&&u(D.end,B))break;B=D.end;}D.cursor=x?D.start:D.end;r.push(D);}if(y)r.reverse();if(!l){var F=r.length-1;while(r[F].isEmpty()&&F>0)F--;if(F>0){var G=0;while(r[G].isEmpty())G++;}for(var i=F;i>=G;i--){if(r[i].isEmpty())r.splice(i,1);}}return r;};}).call(S.prototype);var t=a("./editor").Editor;(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor();this.renderer.updateBackMarkers();};this.addSelectionMarker=function(d){if(!d.cursor)d.cursor=d.end;var e=this.getSelectionStyle();d.marker=this.session.addMarker(d,"ace_selection",e);this.session.$selectionMarkers.push(d);this.session.selectionMarkerCount=this.session.$selectionMarkers.length;return d;};this.removeSelectionMarker=function(r){if(!r.marker)return;this.session.removeMarker(r.marker);var i=this.session.$selectionMarkers.indexOf(r);if(i!=-1)this.session.$selectionMarkers.splice(i,1);this.session.selectionMarkerCount=this.session.$selectionMarkers.length;};this.removeSelectionMarkers=function(r){var m=this.session.$selectionMarkers;for(var i=r.length;i--;){var d=r[i];if(!d.marker)continue;this.session.removeMarker(d.marker);var e=m.indexOf(d);if(e!=-1)m.splice(e,1);}this.session.selectionMarkerCount=m.length;};this.$onAddRange=function(e){this.addSelectionMarker(e.range);this.renderer.updateCursor();this.renderer.updateBackMarkers();};this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges);this.renderer.updateCursor();this.renderer.updateBackMarkers();};this.$onMultiSelect=function(e){if(this.inMultiSelectMode)return;this.inMultiSelectMode=true;this.setStyle("ace_multiselect");this.keyBinding.addKeyboardHandler(j.keyboardHandler);this.commands.setDefaultHandler("exec",this.$onMultiSelectExec);this.renderer.updateCursor();this.renderer.updateBackMarkers();};this.$onSingleSelect=function(e){if(this.session.multiSelect.inVirtualMode)return;this.inMultiSelectMode=false;this.unsetStyle("ace_multiselect");this.keyBinding.removeKeyboardHandler(j.keyboardHandler);this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec);this.renderer.updateCursor();this.renderer.updateBackMarkers();this._emit("changeSelection");};this.$onMultiSelectExec=function(e){var d=e.command;var i=e.editor;if(!i.multiSelect)return;if(!d.multiSelectAction){var r=d.exec(i,e.args||{});i.multiSelect.addRange(i.multiSelect.toOrientedRange());i.multiSelect.mergeOverlappingRanges();}else if(d.multiSelectAction=="forEach"){r=i.forEachSelection(d,e.args);}else if(d.multiSelectAction=="forEachLine"){r=i.forEachSelection(d,e.args,true);}else if(d.multiSelectAction=="single"){i.exitMultiSelectMode();r=d.exec(i,e.args||{});}else{r=d.multiSelectAction(i,e.args||{});}return r;};this.forEachSelection=function(d,e,l){if(this.inVirtualSelectionMode)return;var m=l&&l.keepOrder;var $=l==true||l&&l.$byLines;var n=this.session;var p=this.selection;var r=p.rangeList;var w=(m?p:r).ranges;var x;if(!w.length)return d.exec?d.exec(this,e||{}):d(this,e||{});var y=p._eventRegistry;p._eventRegistry={};var z=new S(n);this.inVirtualSelectionMode=true;for(var i=w.length;i--;){if($){while(i>0&&w[i].start.row==w[i-1].end.row)i--;}z.fromOrientedRange(w[i]);z.index=i;this.selection=n.selection=z;var A=d.exec?d.exec(this,e||{}):d(this,e||{});if(!x&&A!==undefined)x=A;z.toOrientedRange(w[i]);}z.detach();this.selection=n.selection=p;this.inVirtualSelectionMode=false;p._eventRegistry=y;p.mergeOverlappingRanges();if(p.ranges[0])p.fromOrientedRange(p.ranges[0]);var B=this.renderer.$scrollAnimation;this.onCursorChange();this.onSelectionChange();if(B&&B.from==B.to)this.renderer.animateScrolling(B.from);return x;};this.exitMultiSelectMode=function(){if(!this.inMultiSelectMode||this.inVirtualSelectionMode)return;this.multiSelect.toSingleRange();};this.getSelectedText=function(){var d="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var r=this.multiSelect.rangeList.ranges;var e=[];for(var i=0;i<r.length;i++){e.push(this.session.getTextRange(r[i]));}var n=this.session.getDocument().getNewLineCharacter();d=e.join(n);if(d.length==(e.length-1)*n.length)d="";}else if(!this.selection.isEmpty()){d=this.session.getTextRange(this.getSelectionRange());}return d;};this.$checkMultiselectChange=function(e,d){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var r=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&d==this.multiSelect.anchor)return;var p=d==this.multiSelect.anchor?r.cursor==r.start?r.end:r.start:r.cursor;if(p.row!=d.row||this.session.$clipPositionToDocument(p.row,p.column).column!=d.column)this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange());else this.multiSelect.mergeOverlappingRanges();}};this.findAll=function(n,d,e){d=d||{};d.needle=n||d.needle;if(d.needle==undefined){var r=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();d.needle=this.session.getTextRange(r);}this.$search.set(d);var l=this.$search.findAll(this.session);if(!l.length)return 0;var m=this.multiSelect;if(!e)m.toSingleRange(l[0]);for(var i=l.length;i--;)m.addRange(l[i],true);if(r&&m.rangeList.rangeAtPoint(r.start))m.addRange(r,true);return l.length;};this.selectMoreLines=function(d,e){var r=this.selection.toOrientedRange();var i=r.cursor==r.end;var l=this.session.documentToScreenPosition(r.cursor);if(this.selection.$desiredColumn)l.column=this.selection.$desiredColumn;var m=this.session.screenToDocumentPosition(l.row+d,l.column);if(!r.isEmpty()){var n=this.session.documentToScreenPosition(i?r.end:r.start);var p=this.session.screenToDocumentPosition(n.row+d,n.column);}else{var p=m;}if(i){var w=f.fromPoints(m,p);w.cursor=w.start;}else{var w=f.fromPoints(p,m);w.cursor=w.end;}w.desiredColumn=l.column;if(!this.selection.inMultiSelectMode){this.selection.addRange(r);}else{if(e)var x=r.cursor;}this.selection.addRange(w);if(x)this.selection.substractPoint(x);};this.transposeSelections=function(d){var e=this.session;var l=e.multiSelect;var m=l.ranges;for(var i=m.length;i--;){var r=m[i];if(r.isEmpty()){var n=e.getWordRange(r.start.row,r.start.column);r.start.row=n.start.row;r.start.column=n.start.column;r.end.row=n.end.row;r.end.column=n.end.column;}}l.mergeOverlappingRanges();var w=[];for(var i=m.length;i--;){var r=m[i];w.unshift(e.getTextRange(r));}if(d<0)w.unshift(w.pop());else w.push(w.shift());for(var i=m.length;i--;){var r=m[i];var n=r.clone();e.replace(r,w[i]);r.start.row=n.start.row;r.start.column=n.start.column;}l.fromOrientedRange(l.ranges[0]);};this.selectMore=function(d,e,i){var l=this.session;var m=l.multiSelect;var r=m.toOrientedRange();if(r.isEmpty()){r=l.getWordRange(r.start.row,r.start.column);r.cursor=d==-1?r.start:r.end;this.multiSelect.addRange(r);if(i)return;}var n=l.getTextRange(r);var p=q(l,n,d);if(p){p.cursor=d==-1?p.start:p.end;this.session.unfold(p);this.multiSelect.addRange(p);this.renderer.scrollCursorIntoView(null,0.5);}if(e)this.multiSelect.substractPoint(r.cursor);};this.alignCursors=function(){var e=this.session;var m=e.multiSelect;var n=m.ranges;var w=-1;var x=n.filter(function(r){if(r.cursor.row==w)return true;w=r.cursor.row;});if(!n.length||x.length==n.length-1){var y=this.selection.getRange();var z=y.start.row,A=y.end.row;var B=z==A;if(B){var C=this.session.getLength();var D;do{D=this.session.getLine(A);}while(/[=:]/.test(D)&&++A<C);do{D=this.session.getLine(z);}while(/[=:]/.test(D)&&--z>0);if(z<0)z=0;if(A>=C)A=C-1;}var F=this.session.removeFullLines(z,A);F=this.$reAlignText(F,B);this.session.insert({row:z,column:0},F.join("\n")+"\n");if(!B){y.start.column=0;y.end.column=F[F.length-1].length;}this.selection.setRange(y);}else{x.forEach(function(r){m.substractPoint(r.cursor);});var G=0;var H=Infinity;var I=n.map(function(r){var p=r.cursor;var D=e.getLine(p.row);var d=D.substr(p.column).search(/\S/g);if(d==-1)d=0;if(p.column>G)G=p.column;if(d<H)H=d;return d;});n.forEach(function(r,i){var p=r.cursor;var l=G-p.column;var d=I[i]-H;if(l>d)e.insert(p,h.stringRepeat(" ",l-d));else e.remove(new f(p.row,p.column,p.row,p.column-l+d));r.start.column=r.end.column=G;r.start.row=r.end.row=p.row;r.cursor=r.end;});m.fromOrientedRange(n[0]);this.renderer.updateCursor();this.renderer.updateBackMarkers();}};this.$reAlignText=function(l,d){var i=true,e=true;var p,r,w;return l.map(function(n){var m=n.match(/(\s*)(.*?)(\s*)([=:].*)/);if(!m)return[n];if(p==null){p=m[1].length;r=m[2].length;w=m[3].length;return m;}if(p+r+w!=m[1].length+m[2].length+m[3].length)e=false;if(p!=m[1].length)i=false;if(p>m[1].length)p=m[1].length;if(r<m[2].length)r=m[2].length;if(w>m[3].length)w=m[3].length;return m;}).map(d?y:i?e?z:y:A);function x(n){return h.stringRepeat(" ",n);}function y(m){return!m[2]?m[0]:x(p)+m[2]+x(r-m[2].length+w)+m[4].replace(/^([=:])\s+/,"$1 ");}function z(m){return!m[2]?m[0]:x(p+r-m[2].length)+m[2]+x(w)+m[4].replace(/^([=:])\s+/,"$1 ");}function A(m){return!m[2]?m[0]:x(p)+m[2]+x(w)+m[4].replace(/^([=:])\s+/,"$1 ");}};}).call(t.prototype);function u(p,d){return p.row==d.row&&p.column==d.column;}b.onSessionChange=function(e){var d=e.session;if(d&&!d.multiSelect){d.$selectionMarkers=[];d.selection.$initRangeList();d.multiSelect=d.selection;}this.multiSelect=d&&d.multiSelect;var i=e.oldSession;if(i){i.multiSelect.off("addRange",this.$onAddRange);i.multiSelect.off("removeRange",this.$onRemoveRange);i.multiSelect.off("multiSelect",this.$onMultiSelect);i.multiSelect.off("singleSelect",this.$onSingleSelect);i.multiSelect.lead.off("change",this.$checkMultiselectChange);i.multiSelect.anchor.off("change",this.$checkMultiselectChange);}if(d){d.multiSelect.on("addRange",this.$onAddRange);d.multiSelect.on("removeRange",this.$onRemoveRange);d.multiSelect.on("multiSelect",this.$onMultiSelect);d.multiSelect.on("singleSelect",this.$onSingleSelect);d.multiSelect.lead.on("change",this.$checkMultiselectChange);d.multiSelect.anchor.on("change",this.$checkMultiselectChange);}if(d&&this.inMultiSelectMode!=d.selection.inMultiSelectMode){if(d.selection.inMultiSelectMode)this.$onMultiSelect();else this.$onSingleSelect();}};function M(e){if(e.$multiselectOnSessionChange)return;e.$onAddRange=e.$onAddRange.bind(e);e.$onRemoveRange=e.$onRemoveRange.bind(e);e.$onMultiSelect=e.$onMultiSelect.bind(e);e.$onSingleSelect=e.$onSingleSelect.bind(e);e.$multiselectOnSessionChange=b.onSessionChange.bind(e);e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e);e.$multiselectOnSessionChange(e);e.on("changeSession",e.$multiselectOnSessionChange);e.on("mousedown",o);e.commands.addCommands(j.defaultCommands);v(e);}function v(d){if(!d.textInput)return;var i=d.textInput.getElement();var l=false;g.addListener(i,"keydown",function(e){var m=e.keyCode==18&&!(e.ctrlKey||e.shiftKey||e.metaKey);if(d.$blockSelectEnabled&&m){if(!l){d.renderer.setMouseCursor("crosshair");l=true;}}else if(l){r();}},d);g.addListener(i,"keyup",r,d);g.addListener(i,"blur",r,d);function r(e){if(l){d.renderer.setMouseCursor("");l=false;}}}b.MultiSelect=M;a("./config").defineOptions(t.prototype,"editor",{enableMultiselect:{set:function(d){M(this);if(d){this.on("changeSession",this.$multiselectOnSessionChange);this.on("mousedown",o);}else{this.off("changeSession",this.$multiselectOnSessionChange);this.off("mousedown",o);}},value:true},enableBlockSelect:{set:function(d){this.$blockSelectEnabled=d;},value:true}});});ace.define("ace/mode/folding/fold_mode",[],function(r,e,m){"use strict";var R=r("../../range").Range;var F=e.FoldMode=function(){};(function(){this.foldingStartMarker=null;this.foldingStopMarker=null;this.getFoldWidget=function(s,f,a){var l=s.getLine(a);if(this.foldingStartMarker.test(l))return"start";if(f=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(l))return"end";return"";};this.getFoldWidgetRange=function(s,f,a){return null;};this.indentationBlock=function(s,a,c){var b=/\S/;var l=s.getLine(a);var d=l.search(b);if(d==-1)return;var f=c||l.length;var g=s.getLength();var h=a;var i=a;while(++a<g){var j=s.getLine(a).search(b);if(j==-1)continue;if(j<=d){var t=s.getTokenAt(a,0);if(!t||t.type!=="string")break;}i=a;}if(i>h){var k=s.getLine(i).length;return new R(h,f,i,k);}};this.openingBracketBlock=function(s,b,a,c,t){var d={row:a,column:c+1};var f=s.$findClosingBracket(b,d,t);if(!f)return;var g=s.foldWidgets[f.row];if(g==null)g=s.getFoldWidget(f.row);if(g=="start"&&f.row>d.row){f.row--;f.column=s.getLine(f.row).length;}return R.fromPoints(d,f);};this.closingBracketBlock=function(s,b,a,c,t){var d={row:a,column:c};var f=s.$findOpeningBracket(b,d);if(!f)return;f.column++;d.column--;return R.fromPoints(f,d);};}).call(F.prototype);});ace.define("ace/theme/textmate",[],function(r,e,m){"use strict";e.isDark=false;e.cssClass="ace-tm";e.cssText=".ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==\") right repeat-y;}";e.$id="ace/theme/textmate";var d=r("../lib/dom");d.importCssString(e.cssText,e.cssClass,false);});ace.define("ace/line_widgets",[],function(r,a,m){"use strict";var d=r("./lib/dom");function L(s){this.session=s;this.session.widgetManager=this;this.session.getRowLength=this.getRowLength;this.session.$getWidgetScreenLength=this.$getWidgetScreenLength;this.updateOnChange=this.updateOnChange.bind(this);this.renderWidgets=this.renderWidgets.bind(this);this.measureWidgets=this.measureWidgets.bind(this);this.session._changedWidgets=[];this.$onChangeEditor=this.$onChangeEditor.bind(this);this.session.on("change",this.updateOnChange);this.session.on("changeFold",this.updateOnFold);this.session.on("changeEditor",this.$onChangeEditor);}(function(){this.getRowLength=function(b){var h;if(this.lineWidgets)h=this.lineWidgets[b]&&this.lineWidgets[b].rowCount||0;else h=0;if(!this.$useWrapMode||!this.$wrapData[b]){return 1+h;}else{return this.$wrapData[b].length+1+h;}};this.$getWidgetScreenLength=function(){var s=0;this.lineWidgets.forEach(function(w){if(w&&w.rowCount&&!w.hidden)s+=w.rowCount;});return s;};this.$onChangeEditor=function(e){this.attach(e.editor);};this.attach=function(e){if(e&&e.widgetManager&&e.widgetManager!=this)e.widgetManager.detach();if(this.editor==e)return;this.detach();this.editor=e;if(e){e.widgetManager=this;e.renderer.on("beforeRender",this.measureWidgets);e.renderer.on("afterRender",this.renderWidgets);}};this.detach=function(e){var b=this.editor;if(!b)return;this.editor=null;b.widgetManager=null;b.renderer.off("beforeRender",this.measureWidgets);b.renderer.off("afterRender",this.renderWidgets);var l=this.session.lineWidgets;l&&l.forEach(function(w){if(w&&w.el&&w.el.parentNode){w._inDocument=false;w.el.parentNode.removeChild(w.el);}});};this.updateOnFold=function(e,s){var l=s.lineWidgets;if(!l||!e.action)return;var f=e.data;var b=f.start.row;var c=f.end.row;var h=e.action=="add";for(var i=b+1;i<c;i++){if(l[i])l[i].hidden=h;}if(l[c]){if(h){if(!l[b])l[b]=l[c];else l[c].hidden=h;}else{if(l[b]==l[c])l[b]=undefined;l[c].hidden=h;}}};this.updateOnChange=function(b){var l=this.session.lineWidgets;if(!l)return;var s=b.start.row;var c=b.end.row-s;if(c===0){}else if(b.action=="remove"){var e=l.splice(s+1,c);if(!l[s]&&e[e.length-1]){l[s]=e.pop();}e.forEach(function(w){w&&this.removeLineWidget(w);},this);this.$updateRows();}else{var f=new Array(c);if(l[s]&&l[s].column!=null){if(b.start.column>l[s].column)s++;}f.unshift(s,0);l.splice.apply(l,f);this.$updateRows();}};this.$updateRows=function(){var l=this.session.lineWidgets;if(!l)return;var n=true;l.forEach(function(w,i){if(w){n=false;w.row=i;while(w.$oldWidget){w.$oldWidget.row=i;w=w.$oldWidget;}}});if(n)this.session.lineWidgets=null;};this.$registerLineWidget=function(w){if(!this.session.lineWidgets)this.session.lineWidgets=new Array(this.session.getLength());var o=this.session.lineWidgets[w.row];if(o){w.$oldWidget=o;if(o.el&&o.el.parentNode){o.el.parentNode.removeChild(o.el);o._inDocument=false;}}this.session.lineWidgets[w.row]=w;return w;};this.addLineWidget=function(w){this.$registerLineWidget(w);w.session=this.session;if(!this.editor)return w;var b=this.editor.renderer;if(w.html&&!w.el){throw new Error("Setting html as string for a line widget is not supported to avoid CSP inline styles violations.");}if(w.el){d.addCssClass(w.el,"ace_lineWidgetContainer");w.el.style.position="absolute";w.el.style.zIndex=5;b.container.appendChild(w.el);w._inDocument=true;if(!w.coverGutter){w.el.style.zIndex=3;}if(w.pixelHeight==null){w.pixelHeight=w.el.offsetHeight;}}if(w.rowCount==null){w.rowCount=w.pixelHeight/b.layerConfig.lineHeight;}var f=this.session.getFoldAt(w.row,0);w.$fold=f;if(f){var l=this.session.lineWidgets;if(w.row==f.end.row&&!l[f.start.row])l[f.start.row]=w;else w.hidden=true;}this.session._emit("changeFold",{data:{start:{row:w.row}}});this.$updateRows();this.renderWidgets(null,b);this.onWidgetChanged(w);return w;};this.removeLineWidget=function(w){w._inDocument=false;w.session=null;if(w.el&&w.el.parentNode)w.el.parentNode.removeChild(w.el);if(w.editor&&w.editor.destroy)try{w.editor.destroy();}catch(e){}if(this.session.lineWidgets){var b=this.session.lineWidgets[w.row];if(b==w){this.session.lineWidgets[w.row]=w.$oldWidget;if(w.$oldWidget)this.onWidgetChanged(w.$oldWidget);}else{while(b){if(b.$oldWidget==w){b.$oldWidget=w.$oldWidget;break;}b=b.$oldWidget;}}}this.session._emit("changeFold",{data:{start:{row:w.row}}});this.$updateRows();};this.getWidgetsAtRow=function(b){var l=this.session.lineWidgets;var w=l&&l[b];var c=[];while(w){c.push(w);w=w.$oldWidget;}return c;};this.onWidgetChanged=function(w){this.session._changedWidgets.push(w);this.editor&&this.editor.renderer.updateFull();};this.measureWidgets=function(e,b){var c=this.session._changedWidgets;var f=b.layerConfig;if(!c||!c.length)return;var g=Infinity;for(var i=0;i<c.length;i++){var w=c[i];if(!w||!w.el)continue;if(w.session!=this.session)continue;if(!w._inDocument){if(this.session.lineWidgets[w.row]!=w)continue;w._inDocument=true;b.container.appendChild(w.el);}w.h=w.el.offsetHeight;if(!w.fixedWidth){w.w=w.el.offsetWidth;w.screenWidth=Math.ceil(w.w/f.characterWidth);}var h=w.h/f.lineHeight;if(w.coverLine){h-=this.session.getRowLineCount(w.row);if(h<0)h=0;}if(w.rowCount!=h){w.rowCount=h;if(w.row<g)g=w.row;}}if(g!=Infinity){this.session._emit("changeFold",{data:{start:{row:g}}});this.session.lineWidgetWidth=null;}this.session._changedWidgets=[];};this.renderWidgets=function(e,b){var c=b.layerConfig;var l=this.session.lineWidgets;if(!l)return;var f=Math.min(this.firstRow,c.firstRow);var g=Math.max(this.lastRow,c.lastRow,l.length);while(f>0&&!l[f])f--;this.firstRow=c.firstRow;this.lastRow=c.lastRow;b.$cursorLayer.config=c;for(var i=f;i<=g;i++){var w=l[i];if(!w||!w.el)continue;if(w.hidden){w.el.style.top=-100-(w.pixelHeight||0)+"px";continue;}if(!w._inDocument){w._inDocument=true;b.container.appendChild(w.el);}var t=b.$cursorLayer.getPixelPosition({row:i,column:0},true).top;if(!w.coverLine)t+=c.lineHeight*this.session.getRowLineCount(w.row);w.el.style.top=t-c.offset+"px";var h=w.coverGutter?0:b.gutterWidth;if(!w.fixedWidth)h-=b.scrollLeft;w.el.style.left=h+"px";if(w.fullWidth&&w.screenWidth){w.el.style.minWidth=c.width+2*c.padding+"px";}if(w.fixedWidth){w.el.style.right=b.scrollBar.getWidth()+"px";}else{w.el.style.right="";}}};}).call(L.prototype);a.LineWidgets=L;});ace.define("ace/ext/error_marker",[],function(r,e,m){"use strict";var L=r("../line_widgets").LineWidgets;var d=r("../lib/dom");var R=r("../range").Range;function b(a,n,g){var h=0;var l=a.length-1;while(h<=l){var i=(h+l)>>1;var c=g(n,a[i]);if(c>0)h=i+1;else if(c<0)l=i-1;else return i;}return-(h+1);}function f(s,a,c){var g=s.getAnnotations().sort(R.comparePoints);if(!g.length)return;var i=b(g,{row:a,column:-1},R.comparePoints);if(i<0)i=-i-1;if(i>=g.length)i=c>0?0:g.length-1;else if(i===0&&c<0)i=g.length-1;var h=g[i];if(!h||!c)return;if(h.row===a){do{h=g[i+=c];}while(h&&h.row===a);if(!h)return g.slice();}var j=[];a=h.row;do{j[c<0?"unshift":"push"](h);h=g[i+=c];}while(h&&h.row==a);return j.length&&j;}e.showErrorMarker=function(a,c){var s=a.session;if(!s.widgetManager){s.widgetManager=new L(s);s.widgetManager.attach(a);}var p=a.getCursorPosition();var g=p.row;var o=s.widgetManager.getWidgetsAtRow(g).filter(function(w){return w.type=="errorMarker";})[0];if(o){o.destroy();}else{g-=c;}var h=f(s,g,c);var i;if(h){var j=h[0];p.column=(j.pos&&typeof j.column!="number"?j.pos.sc:j.column)||0;p.row=j.row;i=a.renderer.$gutterLayer.$annotations[p.row];}else if(o){return;}else{i={text:["Looks good!"],className:"ace_ok"};}a.session.unfold(p.row);a.selection.moveToPosition(p);var w={row:p.row,fixedWidth:true,coverGutter:true,el:d.createElement("div"),type:"errorMarker"};var k=w.el.appendChild(d.createElement("div"));var l=w.el.appendChild(d.createElement("div"));l.className="error_widget_arrow "+i.className;var n=a.renderer.$cursorLayer.getPixelPosition(p).left;l.style.left=n+a.renderer.gutterWidth-5+"px";w.el.className="error_widget_wrapper";k.className="error_widget "+i.className;i.text.forEach(function(t,u){k.appendChild(d.createTextNode(t));if(u<(i.text.length-1)){k.appendChild(d.createElement("br"));}});k.appendChild(d.createElement("div"));var q=function(_,t,u){if(t===0&&(u==="esc"||u==="return")){w.destroy();return{command:"null"};}};w.destroy=function(){if(a.$mouseHandler.isMousePressed)return;a.keyBinding.removeKeyboardHandler(q);s.widgetManager.removeLineWidget(w);a.off("changeSelection",w.destroy);a.off("changeSession",w.destroy);a.off("mouseup",w.destroy);a.off("change",w.destroy);};a.keyBinding.addKeyboardHandler(q);a.on("changeSelection",w.destroy);a.on("changeSession",w.destroy);a.on("mouseup",w.destroy);a.on("change",w.destroy);a.session.widgetManager.addLineWidget(w);w.el.onmousedown=a.focus.bind(a);a.renderer.scrollCursorIntoView(null,0.5,{bottom:w.el.offsetHeight});};d.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","error_marker.css",false);});ace.define("ace/ace",[],function(r,e,m){"use strict";r("./lib/fixoldbrowsers");var d=r("./lib/dom");var a=r("./lib/event");var R=r("./range").Range;var E=r("./editor").Editor;var b=r("./edit_session").EditSession;var U=r("./undomanager").UndoManager;var c=r("./virtual_renderer").VirtualRenderer;r("./worker/worker_client");r("./keyboard/hash_handler");r("./placeholder");r("./multi_select");r("./mode/folding/fold_mode");r("./theme/textmate");r("./ext/error_marker");e.config=r("./config");e.require=r;if(typeof define==="function")e.define=define;e.edit=function(f,o){if(typeof f=="string"){var _=f;f=document.getElementById(_);if(!f)throw new Error("ace.edit can't find div #"+_);}if(f&&f.env&&f.env.editor instanceof E)return f.env.editor;var v="";if(f&&/input|textarea/i.test(f.tagName)){var g=f;v=g.value;f=d.createElement("pre");g.parentNode.replaceChild(f,g);}else if(f){v=f.textContent;f.innerHTML="";}var h=e.createEditSession(v);var i=new E(new c(f),h,o);var j={document:h,editor:i,onResize:i.resize.bind(i,null)};if(g)j.textarea=g;a.addListener(window,"resize",j.onResize);i.on("destroy",function(){a.removeListener(window,"resize",j.onResize);j.editor.container.env=null;});i.container.env=i.env=j;return i;};e.createEditSession=function(t,f){var g=new b(t,f);g.setUndoManager(new U());return g;};e.Range=R;e.Editor=E;e.EditSession=b;e.UndoManager=U;e.VirtualRenderer=c;e.version=e.config.version;});(function(){ace.require(["ace/ace"],function(a){if(a){a.config.init(true);a.define=ace.define;}if(!window.ace)window.ace=a;for(var k in a)if(a.hasOwnProperty(k))window.ace[k]=a[k];window.ace["default"]=window.ace;if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=window.ace;}});})();
