/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['../Device','../Global','../base/Object','./CalendarType','./Locale','sap/ui/thirdparty/URI',"sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/Version","sap/base/Log","sap/base/assert","sap/base/util/extend","sap/base/util/isEmptyObject"],function(D,G,B,C,L,U,a,d,V,b,c,f,i){"use strict";var g=B.extend("sap.ui.core.Configuration",{constructor:function(l){this._oCore=l;function q(){function e(){if(D.os.android){var m=navigator.userAgent.match(/\s([a-z]{2}-[a-z]{2})[;)]/i);if(m){return m[1];}}return navigator.language;}return h((navigator.languages&&navigator.languages[0])||e()||navigator.userLanguage||navigator.browserLanguage)||new L("en");}var r={"theme":{type:"string",defaultValue:"base"},"language":{type:"Locale",defaultValue:q()},"formatLocale":{type:"Locale",defaultValue:null},"calendarType":{type:"string",defaultValue:null},"trailingCurrencyCode":{type:"boolean",defaultValue:true},"accessibility":{type:"boolean",defaultValue:true},"autoAriaBodyRole":{type:"boolean",defaultValue:false,noUrl:true},"animation":{type:"boolean",defaultValue:true},"animationMode":{type:g.AnimationMode,defaultValue:undefined},"rtl":{type:"boolean",defaultValue:null},"debug":{type:"boolean",defaultValue:false},"inspect":{type:"boolean",defaultValue:false},"originInfo":{type:"boolean",defaultValue:false},"noConflict":{type:"boolean",defaultValue:false,noUrl:true},"noDuplicateIds":{type:"boolean",defaultValue:true},"trace":{type:"boolean",defaultValue:false,noUrl:true},"modules":{type:"string[]",defaultValue:[],noUrl:true},"areas":{type:"string[]",defaultValue:null,noUrl:true},"onInit":{type:"code",defaultValue:undefined,noUrl:true},"uidPrefix":{type:"string",defaultValue:"__",noUrl:true},"ignoreUrlParams":{type:"boolean",defaultValue:false,noUrl:true},"preload":{type:"string",defaultValue:"auto"},"rootComponent":{type:"string",defaultValue:"",noUrl:true},"preloadLibCss":{type:"string[]",defaultValue:[]},"application":{type:"string",defaultValue:""},"appCacheBuster":{type:"string[]",defaultValue:[]},"bindingSyntax":{type:"string",defaultValue:"default",noUrl:true},"versionedLibCss":{type:"boolean",defaultValue:false},"manifestFirst":{type:"boolean",defaultValue:false},"flexibilityServices":{type:"string",defaultValue:"/sap/bc/lrep"},"whitelistService":{type:"string",defaultValue:null,noUrl:true},"allowlistService":{type:"string",defaultValue:null,noUrl:true},"frameOptions":{type:"string",defaultValue:"default",noUrl:true},"frameOptionsConfig":{type:"object",defaultValue:undefined,noUrl:true},"support":{type:"string[]",defaultValue:null},"testRecorder":{type:"string[]",defaultValue:null},"activeTerminologies":{type:"string[]",defaultValue:undefined},"securityTokenHandlers":{type:"function[]",defaultValue:[],noUrl:true},"xx-placeholder":{type:"boolean",defaultValue:true},"xx-rootComponentNode":{type:"string",defaultValue:"",noUrl:true},"xx-appCacheBusterMode":{type:"string",defaultValue:"sync"},"xx-appCacheBusterHooks":{type:"object",defaultValue:undefined,noUrl:true},"xx-disableCustomizing":{type:"boolean",defaultValue:false,noUrl:true},"xx-viewCache":{type:"boolean",defaultValue:true},"xx-test-mobile":{type:"boolean",defaultValue:false},"xx-depCache":{type:"boolean",defaultValue:false},"xx-libraryPreloadFiles":{type:"string[]",defaultValue:[]},"xx-componentPreload":{type:"string",defaultValue:""},"xx-designMode":{type:"boolean",defaultValue:false},"xx-supportedLanguages":{type:"string[]",defaultValue:[]},"xx-bootTask":{type:"function",defaultValue:undefined,noUrl:true},"xx-suppressDeactivationOfControllerCode":{type:"boolean",defaultValue:false},"xx-lesssupport":{type:"boolean",defaultValue:false},"xx-handleValidation":{type:"boolean",defaultValue:false},"xx-fiori2Adaptation":{type:"string[]",defaultValue:[]},"xx-cache-use":{type:"boolean",defaultValue:true},"xx-cache-excludedKeys":{type:"string[]",defaultValue:[]},"xx-cache-serialization":{type:"boolean",defaultValue:false},"xx-nosync":{type:"string",defaultValue:""},"xx-waitForTheme":{type:"string",defaultValue:""},"xx-hyphenation":{type:"string",defaultValue:""},"xx-flexBundleRequestForced":{type:"boolean",defaultValue:false},"xx-cssVariables":{type:"string",defaultValue:"false"},"statistics":{type:"boolean",defaultValue:false}};var u={"xx-test":"1.15","flexBoxPolyfill":"1.14","sapMeTabContainer":"1.14","sapMeProgessIndicator":"1.14","sapMGrowingList":"1.14","sapMListAsTable":"1.14","sapMDialogWithPadding":"1.14","sapCoreBindingSyntax":"1.24"};this.oFormatSettings=new g.FormatSettings(this);var w=this;function x(e,v){if(typeof v==="undefined"||v===null){return;}switch(r[e].type){case"boolean":if(typeof v==="string"){if(r[e].defaultValue){w[e]=v.toLowerCase()!="false";}else{w[e]=v.toLowerCase()==="true"||v.toLowerCase()==="x";}}else{w[e]=!!v;}break;case"string":w[e]=""+v;break;case"code":w[e]=typeof v==="function"?v:String(v);break;case"function":if(typeof v!=="function"){throw new Error("unsupported value");}w[e]=v;break;case"function[]":v.forEach(function(s){if(typeof s!=="function"){throw new Error("Not a function: "+s);}});w[e]=v.slice();break;case"string[]":if(Array.isArray(v)){w[e]=v;}else if(typeof v==="string"){w[e]=v.split(/[ ,;]/).map(function(s){return s.trim();});}else{throw new Error("unsupported value");}break;case"object":if(typeof v!=="object"){throw new Error("unsupported value");}w[e]=v;break;case"Locale":var N=h(v);if(N||r[e].defaultValue==null){w[e]=N;}else{throw new Error("unsupported value");}break;default:var m=r[e].type;if(typeof m==="object"){p(m,v,e);w[e]=v;}else{throw new Error("illegal state");}}}function y(s){var m=document.querySelector("META[name='"+s+"']"),e=m&&m.getAttribute("content");if(e){return e;}}function z(s){var e=y("sap-allowedThemeOrigins");return!!e&&e.split(",").some(function(m){return m==="*"||s===m.trim();});}function A(O){var m,s;try{m=new U(O).search("");var v=m.origin();if(v&&z(v)){s=m.toString();}else{s=m.absoluteTo(window.location.href).origin(window.location.origin).normalize().toString();}return s+(s.endsWith('/')?'':'/')+"UI5/";}catch(e){}}for(var n in r){w[n]=r[n].defaultValue;}var E=window["sap-ui-config"]||{};E.oninit=E.oninit||E["evt-oninit"];for(var n in r){if(E.hasOwnProperty(n.toLowerCase())){x(n,E[n.toLowerCase()]);}else if(!/^xx-/.test(n)&&E.hasOwnProperty("xx-"+n.toLowerCase())){x(n,E["xx-"+n.toLowerCase()]);}}if(E.libs){w.modules=E.libs.split(",").map(function(e){return e.trim()+".library";}).concat(w.modules);}var P="compatversion";var F=E[P];var H=V("1.14");this._compatversion={};function _(e){var v=!e?F||H.toString():E[P+"-"+e.toLowerCase()]||F||u[e]||H.toString();v=V(v.toLowerCase()==="edge"?G.version:v);return V(v.getMajor(),v.getMinor());}this._compatversion._default=_();for(var n in u){this._compatversion[n]=_(n);}if(!w.ignoreUrlParams){var I="sap-ui-";var J=a.fromQuery(window.location.search);if(J.has('sap-language')){var K=w.sapLogonLanguage=J.get('sap-language');var N=L.fromSAPLogonLanguage(K);if(N){w.language=N;}else if(K&&!J.get('sap-locale')&&!J.get('sap-ui-language')){b.warning("sap-language '"+K+"' is not a valid BCP47 language tag and will only be used as SAP logon language");}}if(J.has('sap-locale')){x("language",J.get('sap-locale'));}if(J.has('sap-rtl')){var K=J.get('sap-rtl');if(K==="X"||K==="x"){x('rtl',true);}else{x('rtl',false);}}if(J.has('sap-theme')){var K=J.get('sap-theme');if(K===""){w['theme']=r['theme'].defaultValue;}else{x('theme',K);}}if(J.has('sap-statistics')){var K=J.get('sap-statistics');x('statistics',K);}for(var n in r){if(r[n].noUrl){continue;}var K=J.get(I+n);if(K==null&&!/^xx-/.test(n)){K=J.get(I+"xx-"+n);}if(K===""){w[n]=r[n].defaultValue;}else{x(n,K);}}if(J.has('sap-ui-legacy-date-format')){this.oFormatSettings.setLegacyDateFormat(J.get('sap-ui-legacy-date-format'));}if(J.has('sap-ui-legacy-time-format')){this.oFormatSettings.setLegacyTimeFormat(J.get('sap-ui-legacy-time-format'));}if(J.has('sap-ui-legacy-number-format')){this.oFormatSettings.setLegacyNumberFormat(J.get('sap-ui-legacy-number-format'));}}w.sapparams=w.sapparams||{};w.sapparams['sap-language']=this.getSAPLogonLanguage();['sap-client','sap-server','sap-system'].forEach(function(s){if(!w.ignoreUrlParams&&J.get(s)){w.sapparams[s]=J.get(s);}else{w.sapparams[s]=y(s);}});this.derivedRTL=L._impliesRTL(w.language);var T=w.theme;var O;var Q=T.indexOf("@");if(Q>=0){O=A(T.slice(Q+1));if(O){w.theme=T.slice(0,Q);w.themeRoot=O;}else{w.theme=(E.theme&&E.theme!==T)?E.theme:"base";Q=-1;}}w.theme=this._normalizeTheme(w.theme,O);var R=w['languagesDeliveredWithCore']=L._coreI18nLocales;var S=w['xx-supportedLanguages'];if(S.length===0||(S.length===1&&S[0]==='*')){S=[];}else if(S.length===1&&S[0]==='default'){S=R||[];}w['xx-supportedLanguages']=S;var W=w['xx-fiori2Adaptation'];if(W.length===0||(W.length===1&&W[0]==='false')){W=false;}else if(W.length===1&&W[0]==='true'){W=true;}w['xx-fiori2Adaptation']=W;if(w["bindingSyntax"]==="default"){w["bindingSyntax"]=(w.getCompatibilityVersion("sapCoreBindingSyntax").compareTo("1.26")<0)?"simple":"complex";}w["allowlistService"]=w["allowlistService"]||w["whitelistService"];if(!w["allowlistService"]){var X=y('sap.allowlistService')||y('sap.whitelistService');if(X){w["allowlistService"]=X;if(w["frameOptions"]==="default"){w["frameOptions"]="trusted";}}}if(w["frameOptions"]==="default"||(w["frameOptions"]!=="allow"&&w["frameOptions"]!=="deny"&&w["frameOptions"]!=="trusted")){w["frameOptions"]="allow";}var Y=w["frameOptionsConfig"];if(Y){Y.allowlist=Y.allowlist||Y.whitelist;}if(w.flexibilityServices&&w.flexibilityServices!==r.flexibilityServices.defaultValue&&w.modules.indexOf("sap.ui.fl.library")==-1){w.modules.push("sap.ui.fl.library");}var Z=w['preloadLibCss'];if(Z.length>0){Z.appManaged=Z[0].slice(0,1)==="!";if(Z.appManaged){Z[0]=Z[0].slice(1);}if(Z[0]==="*"){Z.shift();w.modules.forEach(function(e){var m=e.match(/^(.*)\.library$/);if(m){Z.unshift(m[1]);}});}}if(w["xx-waitForTheme"]==="true"){w["xx-waitForTheme"]="rendering";}if(w["xx-waitForTheme"]!=="rendering"&&w["xx-waitForTheme"]!=="init"){w["xx-waitForTheme"]=undefined;}for(var n in r){if(w[n]!==r[n].defaultValue){b.info("  "+n+" = "+w[n]);}}if(this.getAnimationMode()===undefined){if(this.animation){this.setAnimationMode(g.AnimationMode.full);}else{this.setAnimationMode(g.AnimationMode.minimal);}}else{this.setAnimationMode(this.getAnimationMode());}},getVersion:function(){if(this._version){return this._version;}this._version=new V(G.version);return this._version;},getCompatibilityVersion:function(F){if(typeof(F)==="string"&&this._compatversion[F]){return this._compatversion[F];}return this._compatversion._default;},getTheme:function(){return this.theme;},getPlaceholder:function(){return this["xx-placeholder"];},_setTheme:function(T){this.theme=T;return this;},_normalizeTheme:function(T,s){if(T&&s==null&&T.match(/^sap_corbu$/i)){return"sap_fiori_3";}return T;},getLanguage:function(){return this.language.sLocaleId;},getLanguageTag:function(){return this.language.toLanguageTag();},getSAPLogonLanguage:function(){return(this.sapLogonLanguage&&this.sapLogonLanguage.toUpperCase())||this.language.getSAPLogonLanguage();},setLanguage:function(l,s){var e=h(l),O=this.getRTL(),m;o(e,"Configuration.setLanguage: sLanguage must be a valid BCP47 language tag");o(s==null||(typeof s==='string'&&/[A-Z0-9]{2,2}/i.test(s)),"Configuration.setLanguage: sSAPLogonLanguage must be null or be a string of length 2, consisting of digits and latin characters only",true);if(e.toString()!=this.getLanguageTag()||s!==this.sapLogonLanguage){this.language=e;this.sapLogonLanguage=s||undefined;this.sapparams['sap-language']=this.getSAPLogonLanguage();m=this._collect();m.language=this.getLanguageTag();this.derivedRTL=L._impliesRTL(e);if(O!=this.getRTL()){m.rtl=this.getRTL();}this._endCollect();}return this;},getLocale:function(){return this.language;},getSAPParam:function(n){return this.sapparams&&this.sapparams[n];},isUI5CacheOn:function(){return this["xx-cache-use"];},setUI5CacheOn:function(e){this["xx-cache-use"]=e;return this;},isUI5CacheSerializationSupportOn:function(){return this["xx-cache-serialization"];},setUI5CacheSerializationSupport:function(e){this["xx-cache-serialization"]=e;return this;},getUI5CacheExcludedKeys:function(){return this["xx-cache-excludedKeys"];},getCalendarType:function(){var n;if(this.calendarType){for(n in C){if(n.toLowerCase()===this.calendarType.toLowerCase()){this.calendarType=n;return this.calendarType;}}b.warning("Parameter 'calendarType' is set to "+this.calendarType+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale");}var l=this.oFormatSettings.getLegacyDateFormat();switch(l){case"1":case"2":case"3":case"4":case"5":case"6":return C.Gregorian;case"7":case"8":case"9":return C.Japanese;case"A":case"B":return C.Islamic;case"C":return C.Persian;}return this.getLocale().getPreferredCalendarType();},setCalendarType:function(s){var m;if(this.calendarType!==s){m=this._collect();this.calendarType=m.calendarType=s;this._endCollect();}return this;},getFormatLocale:function(){return(this.formatLocale||this.language).toString();},setFormatLocale:function(F){var e=h(F),m;o(F==null||typeof F==="string"&&e,"sFormatLocale must be a BCP47 language tag or Java Locale id or null");if(t(e)!==t(this.formatLocale)){this.formatLocale=e;m=this._collect();m.formatLocale=t(e);this._endCollect();}return this;},getLanguagesDeliveredWithCore:function(){return this["languagesDeliveredWithCore"];},getSupportedLanguages:function(){return this["xx-supportedLanguages"];},getAccessibility:function(){return this.accessibility;},getAutoAriaBodyRole:function(){return this.autoAriaBodyRole;},getAnimation:function(){return this.animation;},getAnimationMode:function(){return this.animationMode;},setAnimationMode:function(A){p(g.AnimationMode,A,"animationMode");this.animation=(A!==g.AnimationMode.minimal&&A!==g.AnimationMode.none);this.animationMode=A;if(this._oCore&&this._oCore._setupAnimation){this._oCore._setupAnimation();}},getRTL:function(){return this.rtl===null?this.derivedRTL:this.rtl;},getFiori2Adaptation:function(){return this["xx-fiori2Adaptation"];},setRTL:function(r){o(r===null||typeof r==="boolean","bRTL must be null or a boolean");var e=this.getRTL(),m;this.rtl=r;if(e!=this.getRTL()){m=this._collect();m.rtl=this.getRTL();this._endCollect();}return this;},getDebug:function(){return this.debug;},getInspect:function(){return this.inspect;},getOriginInfo:function(){return this.originInfo;},getNoDuplicateIds:function(){return this.noDuplicateIds;},getTrace:function(){return this.trace;},getUIDPrefix:function(){return this.uidPrefix;},getDesignMode:function(){return this["xx-designMode"];},getSuppressDeactivationOfControllerCode:function(){return this["xx-suppressDeactivationOfControllerCode"];},getControllerCodeDeactivated:function(){return this.getDesignMode()&&!this.getSuppressDeactivationOfControllerCode();},getApplication:function(){return this.application;},getRootComponent:function(){return this.rootComponent;},getAppCacheBuster:function(){return this.appCacheBuster;},getAppCacheBusterMode:function(){return this["xx-appCacheBusterMode"];},getAppCacheBusterHooks:function(){return this["xx-appCacheBusterHooks"];},getDisableCustomizing:function(){return this["xx-disableCustomizing"];},getViewCache:function(){return this["xx-viewCache"];},getPreload:function(){return this.preload;},getDepCache:function(){return this["xx-depCache"];},getManifestFirst:function(){return this.manifestFirst;},getFlexibilityServices:function(){if(!this.flexibilityServices){this.flexibilityServices=[];}if(typeof this.flexibilityServices==='string'){if(this.flexibilityServices[0]==="/"){this.flexibilityServices=[{url:this.flexibilityServices,layers:["ALL"],connector:"LrepConnector"}];}else{this.flexibilityServices=JSON.parse(this.flexibilityServices);}}return this.flexibilityServices;},setFlexibilityServices:function(F){this.flexibilityServices=F;},getComponentPreload:function(){return this['xx-componentPreload']||this.preload;},getFormatSettings:function(){return this.oFormatSettings;},getFrameOptions:function(){return this.frameOptions;},getWhitelistService:function(){return this.getAllowlistService();},getAllowlistService:function(){return this.allowlistService;},getSupportMode:function(){return this.support;},getTestRecorderMode:function(){return this["testRecorder"];},_collect:function(){var m=this.mChanges||(this.mChanges={__count:0});m.__count++;return m;},_endCollect:function(){var m=this.mChanges;if(m&&(--m.__count)===0){delete m.__count;this._oCore&&this._oCore.fireLocalizationChanged(m);delete this.mChanges;}},getStatistics:function(){var r=this.statistics;try{r=r||window.localStorage.getItem("sap-ui-statistics")=="X";}catch(e){}return r;},getNoNativeScroll:function(){return false;},getHandleValidation:function(){return this["xx-handleValidation"];},getHyphenation:function(){return this["xx-hyphenation"];},getActiveTerminologies:function(){return this["activeTerminologies"];},getSecurityTokenHandlers:function(){return this.securityTokenHandlers.slice();},setSecurityTokenHandlers:function(s){s.forEach(function(S){o(typeof S==="function","Not a function: "+S);});this.securityTokenHandlers=s.slice();},applySettings:function(s){function e(l,m){var n,q;for(n in m){q="set"+n.slice(0,1).toUpperCase()+n.slice(1);if(n==='formatSettings'&&l.oFormatSettings){e(l.oFormatSettings,m[n]);}else if(typeof l[q]==='function'){l[q](m[n]);}else{b.warning("Configuration.applySettings: unknown setting '"+n+"' ignored");}}}c(typeof s==='object',"mSettings must be an object");this._collect();e(this,s);this._endCollect();return this;}});g.AnimationMode={full:"full",basic:"basic",minimal:"minimal",none:"none"};function h(l){try{if(l&&typeof l==='string'){return new L(l);}}catch(e){}}function t(l){return l?l.toString():null;}var M={"":{pattern:null},"1":{pattern:"dd.MM.yyyy"},"2":{pattern:"MM/dd/yyyy"},"3":{pattern:"MM-dd-yyyy"},"4":{pattern:"yyyy.MM.dd"},"5":{pattern:"yyyy/MM/dd"},"6":{pattern:"yyyy-MM-dd"},"7":{pattern:"Gyy.MM.dd"},"8":{pattern:"Gyy/MM/dd"},"9":{pattern:"Gyy-MM-dd"},"A":{pattern:"yyyy/MM/dd"},"B":{pattern:"yyyy/MM/dd"},"C":{pattern:"yyyy/MM/dd"}};var j={"":{"short":null,medium:null,dayPeriods:null},"0":{"short":"HH:mm",medium:"HH:mm:ss",dayPeriods:null},"1":{"short":"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},"2":{"short":"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},"3":{"short":"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},"4":{"short":"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};var k={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},"X":{groupingSeparator:",",decimalSeparator:"."},"Y":{groupingSeparator:" ",decimalSeparator:","}};function o(e,m){if(!e){throw new Error(m);}}function p(e,v,P){var l=[];for(var K in e){if(e.hasOwnProperty(K)){if(e[K]===v){return;}l.push(e[K]);}}throw new Error("Unsupported Enumeration value for "+P+", valid values are: "+l.join(", "));}B.extend("sap.ui.core.Configuration.FormatSettings",{constructor:function(e){this.oConfiguration=e;this.mSettings={};this.sLegacyDateFormat=undefined;this.sLegacyTimeFormat=undefined;this.sLegacyNumberFormatSymbolSet=undefined;},getFormatLocale:function(){function e(m){var n=m.oConfiguration.language;if(!i(m.mSettings)){var l=n.toString();if(l.indexOf("-x-")<0){l=l+"-x-sapufmt";}else if(l.indexOf("-sapufmt")<=l.indexOf("-x-")){l=l+"-sapufmt";}n=new L(l);}return n;}return this.oConfiguration.formatLocale||e(this);},_set:function(K,v){var O=this.mSettings[K];if(v!=null){this.mSettings[K]=v;}else{delete this.mSettings[K];}if((O!=null||v!=null)&&!d(O,v)){var m=this.oConfiguration._collect();m[K]=v;this.oConfiguration._endCollect();}},getCustomUnits:function(){return this.mSettings["units"]?this.mSettings["units"]["short"]:undefined;},setCustomUnits:function(u){var m=null;if(u){m={"short":u};}this._set("units",m);return this;},addCustomUnits:function(u){var e=this.getCustomUnits();if(e){u=f({},e,u);}this.setCustomUnits(u);return this;},setUnitMappings:function(u){this._set("unitMappings",u);return this;},addUnitMappings:function(u){var e=this.getUnitMappings();if(e){u=f({},e,u);}this.setUnitMappings(u);return this;},getUnitMappings:function(){return this.mSettings["unitMappings"];},getDatePattern:function(s){c(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this.mSettings["dateFormats-"+s];},setDatePattern:function(s,P){o(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");this._set("dateFormats-"+s,P);return this;},getTimePattern:function(s){c(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this.mSettings["timeFormats-"+s];},setTimePattern:function(s,P){o(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");this._set("timeFormats-"+s,P);return this;},getNumberSymbol:function(T){c(T=="decimal"||T=="group"||T=="plusSign"||T=="minusSign","sType must be decimal, group, plusSign or minusSign");return this.mSettings["symbols-latn-"+T];},setNumberSymbol:function(T,s){o(T=="decimal"||T=="group"||T=="plusSign"||T=="minusSign","sType must be decimal, group, plusSign or minusSign");this._set("symbols-latn-"+T,s);return this;},getCustomCurrencies:function(){return this.mSettings["currency"];},setCustomCurrencies:function(m){o(typeof m==="object"||m==null,"mCurrencyDigits must be an object");Object.keys(m||{}).forEach(function(s){o(typeof s==="string");o(typeof m[s]==="object");});this._set("currency",m);return this;},addCustomCurrencies:function(m){var e=this.getCustomCurrencies();if(e){m=f({},e,m);}this.setCustomCurrencies(m);return this;},setFirstDayOfWeek:function(v){o(typeof v=="number"&&v>=0&&v<=6,"iValue must be an integer value between 0 and 6");this._set("weekData-firstDay",v);return this;},_setDayPeriods:function(w,T){c(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");this._set("dayPeriods-format-"+w,T);return this;},getLegacyDateFormat:function(){return this.sLegacyDateFormat||undefined;},setLegacyDateFormat:function(F){F=F?String(F).toUpperCase():"";o(!F||M.hasOwnProperty(F),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");var m=this.oConfiguration._collect();this.sLegacyDateFormat=m.legacyDateFormat=F;this.setDatePattern("short",M[F].pattern);this.setDatePattern("medium",M[F].pattern);this.oConfiguration._endCollect();return this;},getLegacyTimeFormat:function(){return this.sLegacyTimeFormat||undefined;},setLegacyTimeFormat:function(F){o(!F||j.hasOwnProperty(F),"sFormatId must be one of ['0','1','2','3','4'] or empty");var m=this.oConfiguration._collect();this.sLegacyTimeFormat=m.legacyTimeFormat=F=F||"";this.setTimePattern("short",j[F]["short"]);this.setTimePattern("medium",j[F]["medium"]);this._setDayPeriods("abbreviated",j[F].dayPeriods);this.oConfiguration._endCollect();return this;},getLegacyNumberFormat:function(){return this.sLegacyNumberFormat||undefined;},setLegacyNumberFormat:function(F){F=F?F.toUpperCase():"";o(!F||k.hasOwnProperty(F),"sFormatId must be one of [' ','X','Y'] or empty");var m=this.oConfiguration._collect();this.sLegacyNumberFormat=m.legacyNumberFormat=F;this.setNumberSymbol("group",k[F].groupingSeparator);this.setNumberSymbol("decimal",k[F].decimalSeparator);this.oConfiguration._endCollect();return this;},setLegacyDateCalendarCustomizing:function(m){o(Array.isArray(m),"aMappings must be an Array");var e=this.oConfiguration._collect();this.aLegacyDateCalendarCustomizing=e.legacyDateCalendarCustomizing=m;this.oConfiguration._endCollect();return this;},getLegacyDateCalendarCustomizing:function(){return this.aLegacyDateCalendarCustomizing;},setTrailingCurrencyCode:function(T){o(typeof T==="boolean","bTrailingCurrencyCode must be a boolean");this.oConfiguration.trailingCurrencyCode=T;return this;},getTrailingCurrencyCode:function(){return this.oConfiguration.trailingCurrencyCode;},getCustomLocaleData:function(){return this.mSettings;}});return g;});
