/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/BindingParser','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Interface','sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/performance/trace/Interaction','./Component','./Configuration','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager',"sap/ui/util/ActivityDetection","sap/ui/dom/getScrollbarSize","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/performance/Measurement","sap/ui/security/FrameOptions","sap/base/assert","sap/ui/dom/includeStylesheet","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/base/util/uid",'sap/ui/performance/trace/initTraces','sap/base/util/LoaderExtensions','sap/base/util/isEmptyObject','sap/base/util/each','sap/ui/VersionInfo','sap/ui/events/jquery/EventSimulation'],function(q,D,G,B,a,E,I,c,M,d,C,f,g,h,F,R,j,T,U,k,A,n,r,L,s,t,u,w,O,V,x,y,z,H,J,K,N){"use strict";if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}z();var P=U._oRenderLog;var Q={};var S={};var _;var W=function(b,e){var i=[],o=0,l=0;this.startTask=function(p){var v=i.length;i[v]={name:p,finished:false};o++;return v;};this.finishTask=function(p,v){if(!i[p]||i[p].finished){throw new Error("trying to finish non existing or already finished task");}i[p].finished=true;o--;if(v===false){l++;}if(o===0){L.info("Sync point '"+b+"' finished (tasks:"+i.length+", open:"+o+", failures:"+l+")");m();}};function m(){if(e){e(o,l);}e=null;}L.info("Sync point '"+b+"' created");};var X=c.extend("sap.ui.core.Core",{constructor:function(){var b=this,e="sap.ui.core.Core";if(sap.ui.getCore&&sap.ui.getCore()){L.error("Only the framework must create an instance of sap/ui/core/Core."+" To get access to its functionality, use sap.ui.getCore().");return sap.ui.getCore();}c.call(this);_=new E();["attachEvent","detachEvent","getEventingParent"].forEach(function(v){X.prototype[v]=_[v].bind(_);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;Object.defineProperty(this,"mElements",{get:function(){L.error("oCore.mElements was a private member and has been removed. Use one of the methods in sap.ui.core.Element.registry instead");return g.registry.all();},configurable:false});this.mObjects={"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;this._sRerenderTimer=this;this.aPrerenderingTasks=[];L.info("Creating Core",null,e);s.start("coreComplete","Core.js - complete");s.start("coreBoot","Core.js - boot");s.start("coreInit","Core.js - init");this.oConfiguration=new f(this);var o=this.oConfiguration["frameOptionsConfig"]||{};o.mode=this.oConfiguration.getFrameOptions();o.allowlistService=this.oConfiguration.getAllowlistService();this.oFrameOptions=new t(o);if(this.oConfiguration["bindingSyntax"]==="complex"){M.bindingParser=B.complexParser;}if(this.oConfiguration["xx-designMode"]==true){B._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=m.indexOf("sap.ui.core.library");if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&m.indexOf("sap.ui.core.plugin.LessSupport")==-1){L.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var p=this.oConfiguration.preload;if(window["sap-ui-debug"]===true){p="";}if(p==="auto"){if(window["sap-ui-optimized"]){p=sap.ui.loader.config().async?"async":"sync";}else{p="";}}this.oConfiguration.preload=p;var l=p==="async"||sap.ui.loader.config().async;this.oConfiguration['xx-libraryPreloadFiles'].forEach(function(v){var A1=String(v).trim().split(/\s*:\s*/),B1=A1[0],C1=A1[1];if(A1.length===1){C1=B1;B1='';}if(/^(?:none|js|json|both)$/.test(C1)){Z[B1]=C1;}});L.info("Declared modules: "+m,e);this._setupThemes();this._setupContentDirection();this._setupBrowser();this._setupOS();this._setupLang();this._setupAnimation();sap.ui.getCore=function(){return b.getInterface();};this.oRenderManager=new R();var p1=new W("UI5 Document Ready",function(v,A1){b.bDomReady=true;b.init();});var q1=p1.startTask("document.ready");var r1=p1.startTask("preload and boot");var s1=function(){L.trace("document is ready");p1.finishTask(q1);document.removeEventListener("DOMContentLoaded",s1);};if(document.readyState!=="loading"){s1();}else{document.addEventListener("DOMContentLoaded",s1);}var t1=new W("UI5 Core Preloads and Bootstrap Script",function(v,A1){L.trace("Core loaded: open="+v+", failures="+A1);b._boot(l,function(){p1.finishTask(r1);s.end("coreBoot");});});var u1=t1.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var v1=t1.startTask("load version info");var w1=function(v){if(v){L.trace("Loaded \"sap-ui-version.json\".");}else{L.error("Could not load \"sap-ui-version.json\".");}t1.finishTask(v1);};var x1=sap.ui.getVersionInfo({async:l,failOnError:false});if(x1 instanceof Promise){x1.then(w1,function(v){L.error("Unexpected error when loading \"sap-ui-version.json\": "+v);t1.finishTask(v1);});}else{w1(x1);}}this._polyfillFlexbox();var y1=t1.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;z1.call(this);t1.finishTask(y1);};function z1(){var v=this.oConfiguration["xx-bootTask"];if(v){var A1=t1.startTask("custom boot task");v(function(L1){t1.finishTask(A1,typeof L1==="undefined"||L1===true);});}if(p==="sync"||p==="async"){var B1=m.reduce(function(L1,M1){var N1=M1.search(/\.library$/);if(N1>=0){L1.push(M1.slice(0,N1));}return L1;},[]);var C1=this.loadLibraries(B1,{async:l,preloadOnly:true});if(l){var D1=t1.startTask("preload bootstrap libraries");C1.then(function(){t1.finishTask(D1);},function(){t1.finishTask(D1,false);});}}var E1=this.oConfiguration.getAppCacheBuster();if(E1&&E1.length>0){if(l){var F1=t1.startTask("require AppCachebuster");sap.ui.require(["sap/ui/core/AppCacheBuster"],function(G1){G1.boot(t1);t1.finishTask(F1);});}else{var G1=sap.ui.requireSync('sap/ui/core/AppCacheBuster');G1.boot(t1);}}if(this.oConfiguration.getSupportMode()!==null){var H1=t1.startTask("support info script");var I1=function(L1,M1){L1.initializeSupportMode(b.oConfiguration.getSupportMode(),l);M1.initSupportRules(b.oConfiguration.getSupportMode());t1.finishTask(H1);};if(l){sap.ui.require(["sap/ui/core/support/Support","sap/ui/support/Bootstrap"],I1,function(L1){L.error("Could not load support mode modules:",L1);});}else{L.warning("Synchronous loading of Support mode. Set preload configuration to 'async' or switch to asynchronous bootstrap to prevent these synchronous request.","SyncXHR",null,function(){return{type:"SyncXHR",name:"support-mode"};});I1(sap.ui.requireSync("sap/ui/core/support/Support"),sap.ui.requireSync("sap/ui/support/Bootstrap"));}}if(this.oConfiguration.getTestRecorderMode()!==null){var J1=t1.startTask("test recorder script");var K1=function(L1){L1.init(b.oConfiguration.getTestRecorderMode());t1.finishTask(J1);};if(l){sap.ui.require(["sap/ui/testrecorder/Bootstrap"],K1,function(L1){L.error("Could not load test recorder:",L1);});}else{L.warning("Synchronous loading of Test recorder mode. Set preload configuration to 'async' or switch to asynchronous bootstrap to prevent these synchronous request.","SyncXHR",null,function(){return{type:"SyncXHR",name:"test-recorder-mode"};});K1(sap.ui.requireSync("sap/ui/testrecorder/Bootstrap"));}}t1.finishTask(u1);}},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","attachThemeScopingChanged","detachThemeScopingChanged","fireThemeScopingChanged","notifyContentDensityChanged","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId","addPrerenderingTask"]}});X.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",ThemeScopingChanged:"themeScopingChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var Y="sap-ui-static";X.aFnDone=[];X.prototype._grantFriendAccess=function(){var b=this;h.prototype.register=function(m){b.registerElementClass(m);};g._updateFocusInfo=function(e){if(b.oFocusHandler){b.oFocusHandler.updateControlFocusInfo(e);}};};X.prototype._setupThemes=function(){var b="sap.ui.core.Core";var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(o){if(o.themeroots){for(var e in o.themeroots){var i=o.themeroots[e];if(typeof i==="string"){this.setThemeRoot(e,i);}else{for(var l in i){if(l.length>0){this.setThemeRoot(e,[l],i[l]);}else{this.setThemeRoot(e,i[l]);}}}}}}this.sTheme=this.oConfiguration.getTheme();document.documentElement.classList.add("sapUiTheme-"+this.sTheme);L.info("Declared theme "+this.sTheme,null,b);};X.prototype._setupContentDirection=function(){var b="sap.ui.core.Core",e=this.oConfiguration.getRTL()?"rtl":"ltr";document.documentElement.setAttribute("dir",e);L.info("Content direction set to '"+e+"'",null,b);};X.prototype._setupBrowser=function(){var e="sap.ui.core.Core";var i=document.documentElement;var b=D.browser;var l=b.name;if(l){if(l===b.BROWSER.SAFARI&&b.mobile){l="m"+l;}l=l+(b.version===-1?"":Math.floor(b.version));i.dataset.sapUiBrowser=l;L.debug("Browser-Id: "+l,null,e);}};X.prototype._setupOS=function(b){var b=document.documentElement;b.dataset.sapUiOs=D.os.name+D.os.versionStr;var o=null;switch(D.os.name){case D.os.OS.IOS:o="sap-ios";break;case D.os.OS.ANDROID:o="sap-android";break;case D.os.OS.BLACKBERRY:o="sap-bb";break;}if(o){b.classList.add(o);}};X.prototype._setupLang=function(){var b=document.documentElement;var e=function(){var l=this.oConfiguration.getLocale();l?b.setAttribute("lang",l.toString()):b.removeAttribute("lang");};e.call(this);this.attachLocalizationChanged(e,this);};X.prototype._setupAnimation=function(){if(this.oConfiguration){var b=document.documentElement;var e=this.oConfiguration.getAnimation();b.dataset.sapUiAnimation=e?"on":"off";if(typeof q!=="undefined"){q.fx.off=!e;}var i=this.oConfiguration.getAnimationMode();b.dataset.sapUiAnimationMode=i;}};X.prototype._polyfillFlexbox=function(){q.support.useFlexBoxPolyfill=false;};X.prototype._boot=function(b,e){var i=this.oConfiguration['preloadLibCss'];if(i&&i.length>0&&!i.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+i.join(","));}this.oConfiguration.modules.push("sap/ui/core/date/"+this.oConfiguration.getCalendarType());if(b){return this._requireModulesAsync().then(function(){e();});}L.warning("Modules and libraries declared via bootstrap-configuration are loaded synchronously. Set preload configuration to"+" 'async' or switch to asynchronous bootstrap to prevent these requests.","SyncXHR",null,function(){return{type:"SyncXHR",name:"legacy-module"};});this.oConfiguration.modules.forEach(function(l){var m=l.match(/^(.*)\.library$/);if(m){this.loadLibrary(m[1]);}else{sap.ui.requireSync(/^jquery\.sap\./.test(l)?l:l.replace(/\./g,"/"));}}.bind(this));e();};X.prototype._requireModulesAsync=function(){var l=[],b=[];this.oConfiguration.modules.forEach(function(e){var m=e.match(/^(.*)\.library$/);if(m){l.push(m[1]);}else{b.push(/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/"));}});return Promise.all([this.loadLibraries(l),new Promise(function(e){sap.ui.require(b,function(){e(Array.prototype.slice.call(arguments));});})]);};X.prototype.applyTheme=function(b,e){u(typeof b==="string","sThemeName must be a string");u(typeof e==="string"||typeof e==="undefined","sThemeBaseUrl must be a string or undefined");b=this.oConfiguration._normalizeTheme(b,e);if(e){this.setThemeRoot(b,e);}if(b&&this.sTheme!=b){var i=this.sTheme;var l=document.documentElement;this._updateThemeUrls(b,true);this.sTheme=b;this.oConfiguration._setTheme(b);l.classList.remove("sapUiTheme-"+i);l.classList.add("sapUiTheme-"+b);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false);}}};X.prototype._updateThemeUrl=function(l,b,e){var i,m=l.href.search(/[?#]/),o,p,v="library",p1=this.oConfiguration.getRTL()?"-RTL":"",q1,r1;var s1=/^sap-ui-theme(?:skeleton)?-(.*)$/i.exec(l.id);if(Array.isArray(s1)){i=s1[1];}else{i=l.id.slice(13);}if(m>-1){o=l.href.substring(0,m);p=l.href.substring(m);}else{o=l.href;p="";}o=o.substring(o.lastIndexOf("/")+1);if((r1=i.indexOf("-["))>0){v+=i.slice(r1+2,-1);i=i.slice(0,r1);}if(o===(v+".css")||o===(v+"-RTL.css")){o=v+p1+".css";}q1=this._getThemePath(i,b)+o+p;if(q1!=l.href){if(e){l.dataset.sapUiFoucmarker=l.id;}w(q1,l.id);}};X.prototype._updateThemeUrls=function(b,e){var o=document.querySelectorAll("link[id^=sap-ui-theme-],link[id^=sap-ui-themeskeleton-]");Array.prototype.forEach.call(o,function(i){this._updateThemeUrl(i,b,e);}.bind(this));};X.prototype._ensureThemeRoot=function(l,b){if(this._mThemeRoots){var p=this._mThemeRoots[b+" "+l]||this._mThemeRoots[b];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+b+"/";l1(l+".themes."+b,p);}}};X.prototype._getThemePath=function(l,b){this._ensureThemeRoot(l,b);return k1(l+".themes."+b,"/");};X.prototype.setThemeRoot=function(b,l,e,m){u(typeof b==="string","sThemeName must be a string");u((Array.isArray(l)&&typeof e==="string")||(typeof l==="string"&&e===undefined),"either the second parameter must be a string (and the third is undefined), or it must be an array and the third parameter is a string");if(!this._mThemeRoots){this._mThemeRoots={};}if(typeof l==="string"){m=e;e=l;l=undefined;}e=e+(e.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var o=l[i];this._mThemeRoots[b+" "+o]=e;}}else{this._mThemeRoots[b]=e;}if(m&&b===this.sTheme){this._updateThemeUrls(this.sTheme);}return this;};X.prototype.init=function(){if(this.bInitialized){return;}var b="sap.ui.core.Core.init()";L.info("Initializing",null,b);this.oFocusHandler=new F(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new j(this);this.oThemeCheck=new T(this);L.info("Initialized",null,b);s.end("coreInit");L.info("Starting Plugins",null,b);this.startPlugins();L.info("Plugins started",null,b);this._createUIAreas();this._setBodyAccessibilityRole();this.oThemeCheck.fireThemeChangedEvent(true);var e=this.oConfiguration['xx-waitForTheme'];if(this.isThemeApplied()||!e){X.aFnDone.push(d.notifyAsyncStep());this._executeInitialization();this.renderPendingUIUpdates("during Core init");s.end("coreComplete");}else if(e==="rendering"){X.aFnDone.push(d.notifyAsyncStep());this._executeInitialization();P.debug("delay initial rendering until theme has been loaded");_.attachEventOnce(X.M_EVENTS.ThemeChanged,function(){setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),D.browser.safari?50:0);},this);s.end("coreComplete");}else if(e==="init"){P.debug("delay init event and initial rendering until theme has been loaded");X.aFnDone.push(d.notifyAsyncStep());_.attachEventOnce(X.M_EVENTS.ThemeChanged,function(){this._executeInitialization();setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),D.browser.safari?50:0);s.end("coreComplete");},this);}};X.prototype._createUIAreas=function(){var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i]);}o.areas=undefined;}};X.prototype._executeOnInit=function(){var o=this.oConfiguration.onInit;if(o){if(typeof o==="function"){o();}else if(typeof o==="string"){var b=/^module\:((?:[_$.\-a-zA-Z0-9]+\/)*[_$.\-a-zA-Z0-9]+)$/.exec(o);if(b&&b[1]){setTimeout(sap.ui.require.bind(sap.ui,[b[1]]),0);}else{var e=O.get(o);if(typeof e==="function"){e();}else{L.warning("[Deprecated] Do not use inline JavaScript code with the oninit attribute."+" Use the module:... syntax or the name of a global function");window.eval(o);}}}this.oConfiguration.onInit=undefined;}};X.prototype._setupRootComponent=function(){var b="sap.ui.core.Core.init()",o=this.oConfiguration;var e=o.getRootComponent();if(e){L.info("Loading Root Component: "+e,null,b);var i=sap.ui.component({name:e});this.oRootComponent=i;var l=o["xx-rootComponentNode"];if(l&&i.isA('sap.ui.core.UIComponent')){var m=document.getElementById(l);if(m){L.info("Creating ComponentContainer for Root Component: "+e,null,b);var p=sap.ui.requireSync('sap/ui/core/ComponentContainer'),v=new p({component:i,propagateModel:true});v.placeAt(m);}}}else{var p1=o.getApplication();if(p1){L.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! "+"Please migrate from sap.ui.app.Application to sap.ui.core.Component.","SyncXHR",null,function(){return{type:"Deprecation",name:"sap.ui.core"};});L.info("Loading Application: "+p1,null,b);sap.ui.requireSync(p1.replace(/\./g,"/"));var q1=O.get(p1);u(q1!==undefined,"The specified application \""+p1+"\" could not be found!");var r1=new q1();u(c.isA(r1,'sap.ui.app.Application'),"The specified application \""+p1+"\" must be an instance of sap.ui.app.Application!");}}};X.prototype._setBodyAccessibilityRole=function(){var o=this.oConfiguration,b=document.body;if(o.getAccessibility()&&o.getAutoAriaBodyRole()&&!b.getAttribute("role")){b.setAttribute("role","application");}};X.prototype._executeInitListeners=function(){var b="sap.ui.core.Core.init()";var e=this.aInitListeners;this.aInitListeners=undefined;if(e&&e.length>0){L.info("Fire Loaded Event",null,b);e.forEach(function(i){i();});}};X.prototype._executeInitialization=function(){if(this.bInitialized){return;}this.bInitialized=true;this._executeOnInit();this._setupRootComponent();this._executeInitListeners();};X.prototype.isInitialized=function(){return this.bInitialized;};X.prototype.isThemeApplied=function(){return T.themeLoaded;};X.prototype.attachInitEvent=function(b){u(typeof b==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(b);}};X.prototype.attachInit=function(b){u(typeof b==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(b);}else{b();}};X.prototype.lock=function(){this.bLocked=true;};X.prototype.unlock=function(){this.bLocked=false;};X.prototype.isLocked=function(){return this.bLocked;};X.prototype.getConfiguration=function(){return this.oConfiguration;};X.prototype.getRenderManager=function(){return this.createRenderManager();};X.prototype.createRenderManager=function(){u(this.isInitialized(),"A RenderManager should be created only after the Core has been initialized");var o=new R();o._setFocusHandler(this.oFocusHandler);return o.getInterface();};X.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};var Z={};function $(l){u(typeof l==='string'&&l||typeof l==='object'&&typeof l.name==='string'&&l.name&&(l.json==null||typeof l.json==='boolean'),"lib must be a non-empty string or an object with at least a non-empty 'name' property and an optional (boolean) property 'json'");var b='both';var e=false;if(typeof l==='object'){if(l.json===true){b='json';}else if(l.json===false){b='js';}e=!!l.lazy;l=l.name;}var i=Z[l]||Z['']||'both';if(i==='both'){i=b;}else if(i!==b&&b!=='both'){i='none';}return{name:l,fileType:i,lazy:e};}function a1(l){var b=this;l=$(l);var i=l.name,m=l.fileType,o=i.replace(/\./g,'/'),v=this.oConfiguration.getDepCache();if(m==='none'||sap.ui.loader._.getModuleState(o+'/library.js')){return Promise.resolve(true);}var p1=S[i]||(S[i]={});if(p1.promise){return p1.promise;}if(l.lazy){L.debug("Lazy dependency to '"+i+"' encountered, loading library-preload-lazy.js");return sap.ui.loader._.loadJSResourceAsync(o+'/library-preload-lazy.js',true);}p1.pending=true;p1.async=true;var p;if(m!=='json'){var q1=o+(v?'/library-h2-preload.js':'/library-preload.js');p=sap.ui.loader._.loadJSResourceAsync(q1).then(function(){return e1(i);},function(e){if(m!=='js'){L.error("failed to load '"+q1+"' ("+(e&&e.message||e)+"), falling back to library-preload.json");return h1(i);}});}else{p=h1(i);}p1.promise=p.then(function(e){var r1=[],s1=c1(i);if(e&&e.length){var t1=e.filter(function(v1){return typeof v1==="string";});var u1=e.filter(function(v1){return typeof v1!=="string";});t1=N._getTransitiveDependencyForLibraries(t1);e=t1.concat(u1);r1=e.map(a1.bind(b));}if(s1&&V(s1._version).compareTo("1.9.0")>=0){r1.push(b.getLibraryResourceBundle(i,true));}return Promise.all(r1).then(function(){p1.pending=false;});});return p1.promise;}var b1=new Map();function c1(l){if(b1.has(l)){return b1.get(l);}var m=l.replace(/\./g,'/')+'/manifest.json';if(sap.ui.loader._.getModuleState(m)){var o=H.loadResource(m,{dataType:'json',async:false,failOnError:false});b1.set(l,o);return o;}}var d1=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function e1(l){var m=c1(l);var b=m&&m["sap.ui5"]&&m["sap.ui5"].dependencies&&m["sap.ui5"].dependencies.libs;if(b){return Object.keys(b).reduce(function(e,i){if(!b[i].lazy){e.push(i);}else if(d1.has(i)){e.push({name:i,lazy:true});}return e;},[]);}}function f1(o,b){var m=o.modules,e=function(i){return/^jquery\.sap\./.test(i)?i:i.replace(/\./g,"/");};if(V(o.version||"1.0").compareTo("2.0")<0){m={};for(var i in o.modules){m[e(i)+".js"]=o.modules[i];}}sap.ui.require.preload(m,o.name,b);}function g1(b){if(Array.isArray(b)){return b.map(function(e){return e.replace(/\.library-preload$/,'');});}return b;}function h1(l){var b=k1(l,"/library-preload.json");return Promise.resolve(q.ajax({dataType:"json",url:b})).then(function(e){if(e){f1(e,b);return g1(e.dependencies);}},function(e,i,m){L.error("failed to load '"+b+"': "+(m||i));});}function i1(l){l=$(l);var b=l.name,i=l.fileType,m=b.replace(/\./g,'/'),o=!!sap.ui.loader._.getModuleState(m+'/library.js');if(i==='none'||o){return;}var p=S[b]||(S[b]={});if(p.pending===false){return;}if(p.pending){if(l.lazy){return;}else if(p.async){L.warning("request to load "+b+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller");}else{L.warning("request to load "+b+" synchronously while sync loading is pending (cycle, ignored)");return;}}if(l.lazy){L.debug("Lazy dependency to '"+b+"' encountered, loading library-preload-lazy.js");try{sap.ui.requireSync(m+'/library-preload-lazy');}catch(e){L.error("failed to load '"+m+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")");}return;}p.pending=true;p.async=false;var v;p.promise=new Promise(function(s1,t1){v=s1;});var p1;if(i!=='json'){var q1=m+'/library-preload';try{sap.ui.requireSync(q1);p1=e1(b);}catch(e){L.error("failed to load '"+q1+"' ("+(e&&e.message||e)+")");var r1=e;while(r1&&r1.cause){r1=r1.cause;}if(r1&&r1.name==="XHRLoadError"&&i!=='js'){p1=j1(b);}}}else{p1=j1(b);}if(p1&&p1.length){p1.forEach(i1);}p.pending=false;v();}function j1(l){var b=k1(l,"/library-preload.json");var e;q.ajax({dataType:"json",async:false,url:b,success:function(i){if(i){f1(i,b);e=i.dependencies;}},error:function(i,m,o){L.error("failed to load '"+b+"': "+(o||m));}});return g1(e);}function k1(m,b){return sap.ui.require.toUrl(m.replace(/\./g,"/")+b);}function l1(m,b){H.registerResourcePath(m.replace(/\./g,"/"),b);}X.prototype.loadLibrary=function(l,v){u(typeof l==="string","sLibrary must be a string");u(v===undefined||typeof v==='boolean'||typeof v==='string'||typeof v==='object'&&(v.url==null||typeof v.url==='string')&&(v.async==null||typeof v.async==='boolean'),"vUrl must be empty or a string or an object with an optional property 'url' of type string and an optional boolean property 'async'");if(typeof v==='boolean'){v={async:v};}if(typeof v==='object'){if(v.async){if(v.url&&S[l]==null){l1(l,v.url);}return this.loadLibraries([l]).then(function(){return this.mLibraries[l];}.bind(this));}v=v.url;}if(!Q[l]){var m=l+".library";if(v){l1(l,v);}if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){i1(l);}sap.ui.requireSync(m.replace(/\./g,"/"));if(!Q[l]){L.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}}return this.mLibraries[l];};X.prototype.loadLibraries=function(l,o){u(Array.isArray(l),"aLibraries must be an array");o=Object.assign({async:true,preloadOnly:false},o);var p=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',b=o.async,e=!o.preloadOnly;function i(){return l.map(function(q1){if(typeof q1==='object'){q1=q1.name;}return q1.replace(/\./g,"/")+"/library";});}function m(){return new Promise(function(q1,r1){sap.ui.require(i(),function(){q1();},r1);});}function v(){i().forEach(sap.ui.requireSync);}if(b){l=N._getTransitiveDependencyForLibraries(l);var p1=p?Promise.all(l.map(a1.bind(this))):Promise.resolve(true);return e?p1.then(m):p1;}else{if(p){l.forEach(i1);}if(e){v();}}};X.prototype.createComponent=function(v,b,i,m){if(typeof v==="string"){v={name:v,url:b};if(typeof i==="object"){v.settings=i;}else{v.id=i;v.settings=m;}}if(v.async&&(v.manifest!==undefined||(v.manifestFirst===undefined&&v.manifestUrl===undefined))){if(v.manifest===undefined){v.manifest=false;}return C.create(v);}return sap.ui.component(v);};X.prototype.getRootComponent=function(){return this.oRootComponent;};X.prototype.initLibrary=function(l){u(typeof l==='string'||typeof l==='object',"oLibInfo must be a string or object");var b=typeof l==='string';if(b){l={name:l};}var e=l.name,m="sap.ui.core.Core.initLibrary()";if(b){L.error("[Deprecated] library "+e+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!e||Q[e]){return;}L.debug("Analyzing Library "+e,null,m);Q[e]=true;function o(r1,s1){var t1,u1;for(t1 in s1){u1=s1[t1];if(u1!==undefined){if(Array.isArray(r1[t1])){if(r1[t1].length===0){r1[t1]=u1;}else{r1[t1]=x(r1[t1].concat(u1));}}else if(r1[t1]===undefined){r1[t1]=u1;}else if(t1!="name"){L.warning("library info setting ignored: "+t1+"="+u1);}}}return r1;}O.create(e);this.mLibraries[e]=l=o(this.mLibraries[e]||{name:e,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},l);for(var i=0;i<l.dependencies.length;i++){var p=l.dependencies[i];L.debug("resolve Dependencies to "+p,null,m);if(Q[p]!==true){L.warning("Dependency from "+e+" to "+p+" has not been resolved by library itself",null,m);this.loadLibrary(p);}}a.registerInterfaceTypes(l.interfaces);for(var i=0;i<l.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(l.types[i])){sap.ui.loader._.declareModule(l.types[i].replace(/\./g,"/")+".js");var v=l.types[i].substring(0,l.types[i].lastIndexOf("."));if(O.get(v)===undefined){O.create(v);}}}var p1=l.controls.concat(l.elements);for(var i=0;i<p1.length;i++){sap.ui.lazyRequire(p1[i],"new extend getMetadata");}if(!l.noLibraryCSS){this._ensureThemeRoot(e,this.sTheme);this._ensureThemeRoot(e,"base");if(this.oConfiguration['preloadLibCss'].indexOf(e)<0){var q1=this._getLibraryCssQueryParams(l);this.includeLibraryTheme(e,undefined,q1);if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(false);}}}l.sName=l.name;l.aControls=l.controls;this.fireLibraryChanged({name:e,stereotype:"library",operation:"add",metadata:l});};function m1(l){var o=document.getElementById(l);if(o){o.dataset.sapUiFoucmarker=l;}}X.prototype.includeLibraryTheme=function(l,v,b){u(typeof l==="string","sLibName must be a string");u(v===undefined||typeof v==="string","sVariant must be a string or undefined");if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var e=(/^(true|x)$/i.test(this.oConfiguration['xx-cssVariables'])?"_skeleton":"");var i=(this.oConfiguration.getRTL()?"-RTL":"");var m,o=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){m="library"+v+e+i;}else{m=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var p="sap-ui-theme-"+o;m1(p);var p1;if(/^(true|x|additional)$/i.test(this.oConfiguration['xx-cssVariables'])){p1=this._getThemePath(l,this.sTheme)+"css_variables.css"+(b?b:"");L.info("Including "+p1+" -  sap.ui.core.Core.includeLibraryTheme()");w(p1,p);p="sap-ui-themeskeleton-"+o;m1(p);}p1=this._getThemePath(l,this.sTheme)+m+".css"+(b?b:"");L.info("Including "+p1+" -  sap.ui.core.Core.includeLibraryTheme()");w(p1,p);var q1=sap.ui.require("sap/ui/core/theming/Parameters");if(q1){q1._addLibraryTheme(o);}}};X.prototype._getLibraryCssQueryParams=function(l){var b;if(this.oConfiguration["versionedLibCss"]&&l){b="?version="+l.version;if(G.versioninfo){b+="&sap-ui-dist-version="+G.versioninfo.version;}}return b;};X.prototype.getLoadedLibraries=function(){return Object.assign({},this.mLibraries);};X.prototype.getLibraryResourceBundle=function(l,b,e){var m,i,v,o;if(typeof l==="boolean"){e=l;l=undefined;b=undefined;}if(typeof b==="boolean"){e=b;b=undefined;}function p(p1){if(p1==null||p1===true){return{bundleUrl:"messagebundle.properties"};}if(typeof p1==="string"){return{bundleUrl:p1};}if(typeof p1==="object"){return p1;}}u((l===undefined&&b===undefined)||typeof l==="string","sLibraryName must be a string or there is no argument given at all");u(b===undefined||typeof b==="string","sLocale must be a string or omitted");l=l||"sap.ui.core";b=b||this.getConfiguration().getLanguage();i=l+"/"+b;v=this.mResourceBundles[i];if(!v||(!e&&v instanceof Promise)){m=c1(l);if(m&&V(m._version).compareTo("1.9.0")>=0){o=m["sap.ui5"]&&m["sap.ui5"].library&&m["sap.ui5"].library.i18n;}o=p(o);if(o){v=r.create({url:k1(l+"/",o.bundleUrl),supportedLocales:o.supportedLocales,fallbackLocale:o.fallbackLocale,locale:b,async:e});if(v instanceof Promise){v=v.then(function(p1){this.mResourceBundles[i]=p1;return p1;}.bind(this));}this.mResourceBundles[i]=v;}}return e?Promise.resolve(v):v;};function n1(o,b){u(typeof o==="string"||typeof o==="object","oDomRef must be a string or object");u(b instanceof I||c.isA(b,"sap.ui.core.Control"),"oControl must be a Control or Interface");if(b){b.placeAt(o,"only");}}X.prototype.setRoot=n1;X.prototype.createUIArea=function(o){var b=this;u(typeof o==="string"||typeof o==="object","oDomRef must be a string or object");if(!o){throw new Error("oDomRef must not be null");}if(typeof(o)==="string"){var i=o;if(i==Y){o=this.getStaticAreaRef();}else{o=document.getElementById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!o.id||o.id.length==0){o.id=y();}var e=o.id;if(!this.mUIAreas[e]){this.mUIAreas[e]=new U(this,o);if(!J(this.oModels)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};b.mUIAreas[e]._propagateProperties(true,b.mUIAreas[e],p,true);}}else{this.mUIAreas[e].setRootNode(o);}return this.mUIAreas[e];};X.prototype.getUIArea=function(o){u(typeof o==="string"||typeof o==="object","o must be a string or object");var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};X.prototype.addInvalidatedUIArea=function(o){if(!this._sRerenderTimer){P.debug("Registering timer for delayed re-rendering");X.aFnDone.push(d.notifyAsyncStep());this._sRerenderTimer=setTimeout(this["renderPendingUIUpdates"].bind(this),0);}};X.MAX_RENDERING_ITERATIONS=20;X.prototype.renderPendingUIUpdates=function(b){P.debug("Render pending UI updates: start ("+(b||"by timer")+")");s.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var e=false,l=X.MAX_RENDERING_ITERATIONS>0,i=0;this._bRendering=true;do{if(l){i++;if(i>X.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+i+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(i>1){P.debug("Render pending UI updates: iteration "+i);}}if(this._sRerenderTimer){if(this._sRerenderTimer!==this){clearTimeout(this._sRerenderTimer);}this._sRerenderTimer=undefined;if(X.aFnDone.length>0){X.aFnDone.pop()();}}this.runPrerenderingTasks();var m=this.mUIAreas;for(var o in m){e=m[o].rerender()||e;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(e){this.fireUIUpdated();}P.debug("Render pending UI updates: finished");s.end("renderPendingUIUpdates");};X.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};X.prototype.attachUIUpdated=function(b,l){_.attachEvent(X.M_EVENTS.UIUpdated,b,l);};X.prototype.detachUIUpdated=function(b,l){_.detachEvent(X.M_EVENTS.UIUpdated,b,l);};X.prototype.fireUIUpdated=function(p){_.fireEvent(X.M_EVENTS.UIUpdated,p);};X.prototype.notifyContentDensityChanged=function(){this.fireThemeChanged();};X.prototype.attachThemeChanged=function(b,l){_.attachEvent(X.M_EVENTS.ThemeChanged,b,l);};X.prototype.detachThemeChanged=function(b,l){_.detachEvent(X.M_EVENTS.ThemeChanged,b,l);};X.prototype.fireThemeChanged=function(p){n(true);var b=sap.ui.require("sap/ui/core/theming/Parameters");if(b){b.reset(true);}p=p||{};if(!p.theme){p.theme=this.getConfiguration().getTheme();}var e=X.M_EVENTS.ThemeChanged;var o=q.Event(e);o.theme=p.theme;g.registry.forEach(function(i){i._handleEvent(o);});A.refresh();_.fireEvent(e,p);};X.prototype.attachThemeScopingChanged=function(b,l){_.attachEvent(X.M_EVENTS.ThemeScopingChanged,b,l);};X.prototype.detachThemeScopingChanged=function(b,l){_.detachEvent(X.M_EVENTS.ThemeScopingChanged,b,l);};X.prototype.fireThemeScopingChanged=function(p){_.fireEvent(X.M_EVENTS.ThemeScopingChanged,p);};X.prototype.attachLocalizationChanged=function(b,l){_.attachEvent(X.M_EVENTS.LocalizationChanged,b,l);};X.prototype.detachLocalizationChanged=function(b,l){_.detachEvent(X.M_EVENTS.LocalizationChanged,b,l);};X.prototype.fireLocalizationChanged=function(m){var e=X.M_EVENTS.LocalizationChanged,b=q.Event(e,{changes:m}),i=M._handleLocalizationChange;L.info("localization settings changed: "+Object.keys(m).join(","),null,"sap.ui.core.Core");K(this.oModels,function(p,o){if(o&&o._handleLocalizationChange){o._handleLocalizationChange();}});function l(p){K(this.mUIAreas,function(o,v){i.call(v,p);});C.registry.forEach(function(o){i.call(o,p);});g.registry.forEach(function(o){i.call(o,p);});}l.call(this,1);l.call(this,2);if(m.rtl!=undefined){document.documentElement.setAttribute("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);K(this.mUIAreas,function(p,o){o.invalidate();});L.info("RTL mode "+m.rtl?"activated":"deactivated");}g.registry.forEach(function(o){o._handleEvent(b);});_.fireEvent(e,{changes:m});};X.prototype.attachLibraryChanged=function(b,l){_.attachEvent(X.M_EVENTS.LibraryChanged,b,l);};X.prototype.detachLibraryChanged=function(b,l){_.detachEvent(X.M_EVENTS.LibraryChanged,b,l);};X.prototype.fireLibraryChanged=function(p){_.fireEvent(X.M_EVENTS.LibraryChanged,p);};X.prototype.applyChanges=function(){this.renderPendingUIUpdates("forced by applyChanges");};X.prototype.registerElementClass=function(m){var b=m.getName(),l=m.getLibraryName()||"",o=this.mLibraries[l],e=m.isA("sap.ui.core.Control")?'controls':'elements';if(!o){O.create(l);o=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(o[e].indexOf(b)<0){o[e].push(b);L.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};X.prototype.registerObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype(),e=this.getObject(b,i);if(e&&e!==o){L.error("adding object \""+b+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+b+"\" with duplicate id '"+i+"'");}this.mObjects[b][i]=o;};X.prototype.deregisterObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype();delete this.mObjects[b][i];};X.prototype.byId=g.registry.get;X.prototype.getControl=g.registry.get;X.prototype.getElementById=g.registry.get;X.prototype.getObject=function(b,i){u(i==null||typeof i==="string","sId must be a string when defined");u(this.mObjects[b]!==undefined,"sType must be a supported stereotype");return i==null?undefined:this.mObjects[b]&&this.mObjects[b][i];};X.prototype.getComponent=C.registry.get;X.prototype.getTemplate=function(i){L.warning("Synchronous loading of 'sap/ui/core/tmpl/Template'. Use 'sap/ui/core/tmpl/Template' module and"+" call Template.byId instead","SyncXHR",null,function(){return{type:"SyncXHR",name:"Core.prototype.getTemplate"};});var b=sap.ui.requireSync('sap/ui/core/tmpl/Template');return b.byId(i);};X.prototype.getStaticAreaRef=function(){var o=document.getElementById(Y),b,e;if(!o){o=document.createElement("div");e=document.createElement("span");b=this.getConfiguration();if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}o.setAttribute("id",Y);Object.assign(o.style,{"height":"0","width":"0","overflow":"hidden","float":b.getRTL()?"right":"left"});e.setAttribute("id",Y+"-firstfe");e.setAttribute("tabindex",-1);e.style.fontSize=0;o.appendChild(e);document.body.insertBefore(o,document.body.firstChild);this.createUIArea(o).bInitial=false;}return o;};X.prototype.isStaticAreaRef=function(o){return o&&(o.id===Y);};var o1;X.prototype.attachIntervalTimer=function(b,l){L.warning("Usage of sap.ui.getCore().attachIntervalTimer() is deprecated. "+"Please use 'IntervalTrigger.addListener()' from 'sap/ui/core/IntervalTrigger' module instead.","Deprecation",null,function(){return{type:"sap.ui.core.Core",name:"Core"};});if(!o1){o1=sap.ui.require("sap/ui/core/IntervalTrigger")||sap.ui.requireSync("sap/ui/core/IntervalTrigger");}o1.addListener(b,l);};X.prototype.detachIntervalTimer=function(b,l){if(o1){o1.removeListener(b,l);}};X.prototype.attachControlEvent=function(b,l){_.attachEvent(X.M_EVENTS.ControlEvent,b,l);};X.prototype.detachControlEvent=function(b,l){_.detachEvent(X.M_EVENTS.ControlEvent,b,l);};X.prototype.fireControlEvent=function(p){_.fireEvent(X.M_EVENTS.ControlEvent,p);};X.prototype._handleControlEvent=function(e,b){var o=q.Event(e.type);Object.assign(o,e);o.originalEvent=undefined;this.fireControlEvent({"browserEvent":o,"uiArea":b});};X.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};X.prototype.registerPlugin=function(p){u(typeof p==="object","oPlugin must be an object");if(!p){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return;}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this);}};X.prototype.unregisterPlugin=function(p){u(typeof p==="object","oPlugin must be an object");if(!p){return;}var b=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){b=i;break;}}if(b==-1){return;}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this);}this.aPlugins.splice(b,1);};X.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true);}}};X.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this);}}};X.prototype.setModel=function(m,b){u(m==null||c.isA(m,'sap.ui.model.Model'),"oModel must be an instance of sap.ui.model.Model, null or undefined");u(b===undefined||(typeof b==="string"&&!/^(undefined|null)?$/.test(b)),"sName must be a string or omitted");var e=this,p;if(!m&&this.oModels[b]){delete this.oModels[b];if(J(e.oModels)&&J(e.oBindingContexts)){p=M._oEmptyPropagatedProperties;}else{p={oModels:Object.assign({},e.oModels),oBindingContexts:{},aPropagationListeners:[]};}K(this.mUIAreas,function(i,o){if(m!=o.getModel(b)){o._propagateProperties(b,o,p,false,b);}});}else if(m&&m!==this.oModels[b]){this.oModels[b]=m;K(this.mUIAreas,function(i,o){if(m!=o.getModel(b)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};o._propagateProperties(b,o,p,false,b);}}.bind(this));}return this;};X.prototype.setMessageManager=function(m){this.oMessageManager=m;};X.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new k();}return this.oMessageManager;};X.prototype.byFieldGroupId=function(v){return g.registry.filter(function(e){return e.isA("sap.ui.core.Control")&&e.checkFieldGroupIds(v);});};X.prototype.getModel=function(b){u(b===undefined||(typeof b==="string"&&!/^(undefined|null)?$/.test(b)),"sName must be a string or omitted");return this.oModels[b];};X.prototype.hasModel=function(){return!J(this.oModels);};X.prototype.getEventBus=function(){if(!this.oEventBus){var b=sap.ui.require('sap/ui/core/EventBus');if(!b){L.warning("Synchronous loading of EventBus. Ensure that 'sap/ui/core/EventBus' module is loaded"+" before this function is called.","SyncXHR",null,function(){return{type:"SyncXHR",name:"core-eventbus"};});b=sap.ui.requireSync('sap/ui/core/EventBus');}var e=this.oEventBus=new b();this._preserveHandler=function(i){e.publish("sap.ui","__preserveContent",{domNode:i.domNode});};R.attachPreserveContent(this._preserveHandler);}return this.oEventBus;};X.prototype.attachValidationError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(X.M_EVENTS.ValidationError,o,b,l);return this;};X.prototype.detachValidationError=function(b,l){_.detachEvent(X.M_EVENTS.ValidationError,b,l);return this;};X.prototype.attachParseError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(X.M_EVENTS.ParseError,o,b,l);return this;};X.prototype.detachParseError=function(b,l){_.detachEvent(X.M_EVENTS.ParseError,b,l);return this;};X.prototype.attachFormatError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(X.M_EVENTS.FormatError,o,b,l);return this;};X.prototype.detachFormatError=function(b,l){_.detachEvent(X.M_EVENTS.FormatError,b,l);return this;};X.prototype.attachValidationSuccess=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(X.M_EVENTS.ValidationSuccess,o,b,l);return this;};X.prototype.detachValidationSuccess=function(b,l){_.detachEvent(X.M_EVENTS.ValidationSuccess,b,l);return this;};X.prototype.fireParseError=function(p){_.fireEvent(X.M_EVENTS.ParseError,p);return this;};X.prototype.fireValidationError=function(p){_.fireEvent(X.M_EVENTS.ValidationError,p);return this;};X.prototype.fireFormatError=function(p){_.fireEvent(X.M_EVENTS.FormatError,p);return this;};X.prototype.fireValidationSuccess=function(p){_.fireEvent(X.M_EVENTS.ValidationSuccess,p);return this;};X.prototype.isMobile=function(){return D.browser.mobile;};X.prototype._getEventProvider=function(){return _;};X.prototype.addPrerenderingTask=function(p,b){if(b){this.aPrerenderingTasks.unshift(p);}else{this.aPrerenderingTasks.push(p);}};X.prototype.runPrerenderingTasks=function(){var b=this.aPrerenderingTasks.slice();this.aPrerenderingTasks=[];b.forEach(function(p){p();});};X.prototype.destroy=function(){R.detachPreserveContent(this._preserveHandler);this.oFocusHandler.destroy();_.destroy();c.prototype.destroy.call(this);};sap.ui.setRoot=n1;return new X().getInterface();});
