/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','./library',"sap/base/assert","sap/base/Log","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/deepExtend","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(D,M,B,O,C,I,R,E,a,b,c,L,V,u,d,f,g,q,F,h,k){"use strict";var m=b.CSSSize;var n=b.OpenState;var s;var G;var r;var o="sapUiPopupResize";if(window.ResizeObserver){r=new window.ResizeObserver(function(e){w(q("#sap-ui-blocklayer-popup"),e[0].target);});}else{r={observe:function(e){var i=e.dataset[o];if(!i){i=a.register(e,function(j){w(q("#sap-ui-blocklayer-popup"),j.target);});e.dataset[o]=i;}},unobserve:function(e){var i=e.dataset[o];if(i){a.deregister(i);delete e.dataset[o];}}};}function p(){if(s){return s;}var S,i;try{S=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(S);}catch(e){L.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}i=new C();s.addDependent(i);s=i.getUIArea();i.destroy();return s;}function t(W){var e;if(typeof W==="string"){e=document.querySelector(W);}else if(W instanceof E){e=W.getDomRef();}else{e=W;}return e||window;}function v($){var e=["left","top","width","height","position"];if($[0]){e.forEach(function(i){$[0].style.removeProperty(i);});}}function w($,W){var e=W.getBoundingClientRect();$.css({width:e.width,height:e.height,display:"block",position:"absolute"}).position({my:"left top",at:"left top",of:W});}var P=M.extend("sap.ui.core.Popup",{constructor:function(e,i,S,j){c(arguments.length==0||(e&&typeof e==="object"),"oContent must be an object or there may be no arguments at all");c((i===undefined||i===true||i===false),"bModal must be true, false, or undefined");c((S===undefined||S===true||S===false),"bShadow must be true, false, or undefined");c((j===undefined||j===true||j===false),"bAutoClose must be true, false, or undefined");M.apply(this);this._popupUID=u();this.bOpen=false;this.eOpenState=n.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(e){this.setContent(e);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!i;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(S)==="boolean"?S:true;this._bAutoClose=!!j;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(l){if(l.isMarked("delayedMouseEvent")||l.isMarked("cancelAutoClose")){return;}if(this.eOpenState===n.CLOSING||this.eOpenState===n.CLOSED){return;}if(!this._contains(l.target)){this.close();}};}this._F6NavigationHandler=function(l){var J={},K=this._sF6NavMode,N;if(K=="DOCK"){if(this._bModal){K="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){N=this._getOfDom(this._oLastPosition.of);if(!N||N===document){N=null;K="NONE";}}}switch(K){case"SCOPE":J.scope=this._$()[0];break;case"DOCK":J.target=N;var $=q(N).parents("[data-sap-ui-popup]");J.scope=$.length?$[0]:null;break;default:J.skip=true;}F.handleF6GroupNavigation(l,J);};},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}});P.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[]);};P.prototype.addChildPopup=function(e){return this.addAssociation("childPopups",e);};P.prototype.removeChildPopup=function(e){return this.removeAssociation("childPopups",e);};P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch&&(D.browser.safari||!D.system.combi);P.prototype.preventBrowserFocus=D.support.touch&&!D.system.combi;B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var e=this.getDomString();this._$Ref=q(e).appendTo(sap.ui.getCore().getStaticAreaRef());}});P.Layer.prototype.init=function(e,Z){this._$Ref.css({"visibility":"visible","z-index":Z});this.update(e,Z);this._$Ref.insertAfter(e).show();};P.Layer.prototype.update=function(e,Z){if(e.length){var i=e.rect();this._$Ref.css({"left":i.left,"top":i.top});if(e.css("right")!="auto"&&e.css("right")!="inherit"){this._$Ref.css({"right":e.css("right"),"width":"auto"});}else{this._$Ref.css({"width":i.width,"right":"auto"});}if(e.css("bottom")!="auto"&&e.css("bottom")!="inherit"){this._$Ref.css({"bottom":e.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":i.height,"bottom":"auto"});}if(typeof(Z)==="number"){this._$Ref.css("z-index",Z);}}};P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};P.Layer.prototype.getDomString=function(){L.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+u()+"\"></div>";};P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var i=Math.pow(2,32)-1;P.setInitialZIndex=function(e){if(e>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(e,this.getLastZIndex());};P.getLastZIndex=function(){return l;};P.prototype.getLastZIndex=function(){return P.getLastZIndex();};P.getNextZIndex=function(){l+=10;if(l>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};P.prototype.getNextZIndex=function(){return P.getNextZIndex();};}());var x=function(e,i){if((!e&&i)||(e&&!i)){return false;}if(!e&&!i){return true;}var j=3;var l=Math.abs(e.left-i.left);var T=Math.abs(e.top-i.top);var W=Math.abs(e.width-i.width);var J=Math.abs(e.height-i.height);if(l>j||T>j||W>j||J>j){return false;}return true;};P.prototype.open=function(i,e,j,l,J,K,N,Q){c(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=n.CLOSED){return;}if(typeof(i)=="string"){Q=N;N=K;K=J;J=l;l=j;j=e;e=i;i=-1;}if(typeof N==="boolean"||typeof N==="function"||N===P.CLOSE_ON_SCROLL){Q=N;N=undefined;}if(i===undefined){i=-1;}c(i===-1||(typeof i==="number"&&i%1==0),"iDuration must be an integer (or omitted)");c(e===undefined||typeof e==="string","my must be a string or empty");c(j===undefined||typeof j==="string","at must be a string or empty");c(!l||typeof l==="object"||typeof l==="function","of must be empty or an object");c(!J||typeof J==="string","offset must be empty or a string");c(!K||typeof K==="string","collision must be empty or a string");c(!N||N===window||typeof N==="string"||N instanceof E||N instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");c(!Q||typeof Q==="boolean"||typeof Q==="function"||Q===P.CLOSE_ON_SCROLL,"followOf must be either empty or a boolean");this.eOpenState=n.OPENING;var s=p(),U;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof C){if(!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return s;};this._bUIAreaPatched=true;}U=this.oContent.getUIArea();if(P._bEnableUIAreaCheck&&U.getRootNode().id!==s.getRootNode().id){L.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(l)||this.isInPopup(this._oPosition.of)){var S=this.getParentPopupId(l)||this.getParentPopupId(this._oPosition.of);var T="";var W=this.getContent();if(W instanceof E){T=W.getId();}else if(typeof W==="object"){T=W.id;}this.addChildToPopup(S,T);this.addChildToPopup(S,this._popupUID);}var $=this._$(true);var X="fast";if((i===0)||(i>0)){X=i;}else if((this._durations.open===0)||(this._durations.open>0)){X=this._durations.open;}var Y;if(e||j||l||J||K||N){Y=this._createPosition(e,j,l,J,K,N);this._oPosition=Y;}else{Y=this._oPosition;if(!this._bOwnWithin&&G){this._oPosition.within=G;}}if(!Y.of){Y.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var Z=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==Z)){$.appendTo(Z);}$.css("z-index",this._iZIndex);L.debug("position popup content "+$.attr("id")+" at "+JSON.stringify(Y.at));this._applyPosition(Y);if(Q!==undefined){this.setFollowOf(Q);}$.toggleClass("sapUiShd",this._bShadow);var a1=$[0];if(a1){a1.style.display="none";a1.style.visibility="visible";}var b1=X==0;this._duringOpen(!b1);if(b1){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,X,this._opened.bind(this));}else{$.fadeIn(X,this._opened.bind(this));}};P.prototype._getDomRefToFocus=function(){var $=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=sap.ui.getCore().byId(this._sInitialFocusId);if(i){e=i.getFocusDomRef();}e=e||window.document.getElementById(this._sInitialFocusId);}e=e||$.firstFocusableDomRef();}return e;};P.prototype._opened=function(){if(this.eOpenState!==n.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus();}var i=this._getOfDom(this._oLastPosition.of);var j=q(i).rect();if(this._oLastOfRect&&j&&!x(this._oLastOfRect,j)){this._applyPosition(this._oLastPosition);}}this.eOpenState=n.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this.fireOpened();};P.prototype._duringOpen=function(e){var $=this._$(false,true),S=sap.ui.getCore().getStaticAreaRef(),i=document.getElementById(S.id+"-firstfe");P._clearSelection();this._setupUserSelection();if(h()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}.bind(this),500);}if(this._bModal){this._showBlockLayer();}if(!this.touchEnabled&&e&&i&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){i.focus({preventScroll:true});}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};P.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId;};P.prototype._contains=function(e){var i=this._$().get(0);if(!i){return false;}var j=g(i,e);var l;if(!j){l=this.getChildPopups();j=l.some(function(J){var K=(J?window.document.getElementById(J):null);var j=g(K,e);if(!j){var N="sap.ui.core.Popup.contains-"+J;var Q={domRef:e};sap.ui.getCore().getEventBus().publish("sap.ui",N,Q);j=Q.contains;}return j;});}if(!j){A.forEach(function(S){j=j||q(e).closest(S).length>0;});}return j;};P.prototype._containsEventBusWrapper=function(e,i,j){j.contains=this._contains(j.domRef);};P.prototype.onFocusEvent=function(e){var i=q.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=q.event.fix(arguments[2]);}var j=(i.type=="focus"||i.type=="activate")?"focus":"blur";var l=false;if(j=="focus"){var J=this._$().get(0);if(J){l=this._contains(i.target);L.debug("focus event on "+i.target.id+", contains: "+l);if(this._bModal&&!l){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus();}}.bind(this),0);}else{J.focus();}}}}else if(this._bAutoClose&&l&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}}}else if(j=="blur"){L.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return;}var K=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(K,"autocloseBlur");var N=this._oLastPosition&&this._oLastPosition.of;if(N){var Q=this.getParentPopupId(N);if(Q){var S="sap.ui.core.Popup.onFocusEvent-"+Q;sap.ui.getCore().getEventBus().publish("sap.ui",S,i);}}}.bind(this),K);}}}};P.prototype.setInitialFocusId=function(i){c(!i||typeof i==="string","sId must be a string or empty");this._sInitialFocusId=i;};P.prototype.close=function(i){if(P._autoCloseDebug){return;}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}c(i===undefined||(typeof i==="number"&&(i%1==0)),"iDuration must be empty or an integer");if(this.eOpenState==n.CLOSED||this.eOpenState==n.CLOSING){return;}var e="fast";if((i===0)||(i>0)){e=i;}else if((this._durations.close===0)||(this._durations.close>0)){e=this._durations.close;}this.eOpenState=n.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent){if(this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);S.removeContent(S.indexOfContent(this.oContent),true);}else if(this._bUIAreaPatched){delete this.oContent.getUIArea;}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(h()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}.bind(this),500);}if(this.isInPopup(this._oLastPosition.of)){var j=this.getParentPopupId(this._oLastPosition.of);var l="";var J=this.getContent();if(J instanceof E){l=J.getId();}else if(typeof J==="object"){l=J.id;}this.removeChildFromPopup(j,l);this.removeChildFromPopup(j,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(K){K.preventDefault();});}this._duringClose();if(e==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,e,this._closed.bind(this));}else{$.fadeOut(e,this._closed.bind(this));}};P.prototype._closed=function(){var $=this._$(false,true);if(this._bModal){this._hideBlockLayer();}P._clearSelection();this._restoreUserSelection();if($.length){var e=$.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}$=this._$(false,true);e=$.length?$[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=n.CLOSED;var i=this.getChildPopups();for(var j=0,l=i.length;j<l;j++){this.closePopup(i[j]);}this.fireClosed();};P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};P.getCurrentFocusInfo=function(){var e=null;var i=sap.ui.getCore().getCurrentFocusedControlId();if(i){var j=sap.ui.getCore().byId(i);e={'sFocusId':i,'oFocusInfo':j?j.getFocusInfo():{}};}else{var l=document.activeElement;e={'sFocusId':l.id,'oFocusedElement':l,'oFocusInfo':{}};}if(e){e.popup=this;}return e;};P.applyFocusInfo=function(e){var i={preventScroll:true};if(e){var j=sap.ui.getCore().byId(e.sFocusId);if(j){j.applyFocusInfo(Object.assign(i,e.oFocusInfo));}else{var l=((e.sFocusId?window.document.getElementById(e.sFocusId):null))||e.oFocusedElement;if(l){l.focus(i);}}}};P.prototype.setContent=function(e){c(typeof e==="object","oContent must be an object");this.oContent=e;return this;};P.prototype.getContent=function(){return this.oContent;};P.prototype.setPosition=function(e,i,j,l,J,K){c(typeof e==="string","my must be a string");c(typeof i==="string"||(typeof i==="object"&&(typeof i.left==="number")&&(typeof i.top==="number")),"my must be a string or an object with 'left' and 'top' properties");c(!j||typeof j==="object"||typeof j==="function","of must be empty or an object");c(!l||typeof l==="string","offset must be empty or a string");c(!J||typeof J==="string","collision must be empty or a string");c(!K||K===window||typeof K==="string"||K instanceof E||K instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");this._oPosition=this._createPosition(e,i,j,l,J,K);if(this.eOpenState!=n.CLOSED){this._applyPosition(this._oPosition);}return this;};P.prototype._createPosition=function(e,i,j,l,J,K){var N=false;if(e&&(e.indexOf("+")>=0||e.indexOf("-")>=0)){N=true;if(l&&l!="0 0"){L.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}l=null;}var Q=d({},this._oDefaultPosition,{my:e||this._oDefaultPosition.my,at:i||this._oDefaultPosition.at,of:j,offset:l,collision:J});if(K||G){Q.within=K||G;}this._bOwnWithin=!!K;if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(X,Y){P._bNewOffset=(Y!==undefined);}});}}var S=[];var T=[];if(P._bNewOffset||V(q.ui.version).compareTo("1.8.23")>0){if(l&&l!="0 0"){S=Q.my.split(" ");T=l.split(" ");var U=[parseInt(T[0])<0?"":"+",parseInt(T[1])<0?"":"+"];Q.my=S[0]+U[0]+T[0]+" "+S[1]+U[1]+T[1];Q.offset=null;}}else if(N){S=Q.my.split(" ");T=["",""];var W=S[0].indexOf("+");if(W<0){W=S[0].indexOf("-");}if(W>=0){T[0]=S[0].slice(W);S[0]=S[0].slice(0,W);}W=S[1].indexOf("+");if(W<0){W=S[1].indexOf("-");}if(W>=0){T[1]=S[1].slice(W);S[1]=S[1].slice(0,W);}Q.my=S[0]+" "+S[1];Q.offset=T[0]+" "+T[1];}return Q;};P.prototype._getPositionOffset=function(){var e=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var i=this._oPosition.my.split(" ");var j=i[0].indexOf("+");if(j<0){j=i[0].indexOf("-");}if(j>=0){e[0]=i[0].slice(j);}j=i[1].indexOf("+");if(j<0){j=i[1].indexOf("-");}if(j>=0){e[1]=i[1].slice(j);}}else if(this._oPosition.offset){e=this._oPosition.offset.split(" ");}return e;};P.prototype._applyPosition=function(e){var i=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var j=e.at;var l=$.get(0);if(typeof(j)==="string"){l.style.display="block";l.style.left="";l.style.right="";$.position(this._resolveReference(this._convertPositionRTL(e,i)));this._fixPositioning(e,i);}else if(m.isValid(j.left)&&m.isValid(j.top)){$.css({"left":j.left,"top":j.top});}else if(m.isValid(j.right)&&m.isValid(j.top)){$.css({"right":j.right,"top":j.top});}else if(typeof(j.left)==="number"&&typeof(j.top)==="number"){var J=$[0];if(J&&J.style.right){var K=$[0].getBoundingClientRect().width;$.css({"right":(document.documentElement.clientWidth-(j.left+K))+"px","top":j.top+"px"});}else{$.css({"left":j.left+"px","top":j.top+"px"});}}this._oLastPosition=e;this._oLastOfRect=this._calcOfRect(e.of);}};P.prototype._calcOfRect=function(e){var i=this._getOfDom(e);if(i){return q(i).rect();}return null;};P.prototype._getOfDom=function(e){if(e instanceof q.Event){return null;}var $;if(typeof(e)==="string"){$=q(document.getElementById(e));}else if(e instanceof q){$=e;}else{$=q(e instanceof E?e.getDomRef():e);}return $[0];};P.prototype._convertPositionRTL=function(e,i){var j=Object.assign({},e);if(i){var N=false;if(j.my&&(j.my.indexOf("+")>=0||j.my.indexOf("-")>=0)){N=true;}if((j.offset||N)&&((j.my.indexOf("begin")>-1)||(j.my.indexOf("end")>-1))&&((j.at.indexOf("begin")>-1)||(j.at.indexOf("end")>-1))){if(N){var l=j.my.split(" ");if(l.length==2){j.my="";if(l[0]){if(l[0].indexOf("begin")>-1||l[0].indexOf("end")>-1){if(l[0].indexOf("+")>-1){l[0]=l[0].replace("+","-");}else if(l[0].indexOf("-")>-1){l[0]=l[0].replace("-","+");}}j.my=l[0];}if(l[1]){if(l[1].indexOf("begin")>-1||l[1].indexOf("end")>-1){if(l[1].indexOf("+")>-1){l[1]=l[1].replace("+","-");}else if(l[1].indexOf("-")>-1){l[1]=l[1].replace("-","+");}}if(l[0]){j.my=j.my+" ";}j.my=j.my+l[1];}}}else{j.offset=this._mirrorOffset(j.offset);}}j.my=j.my.replace("begin","right").replace("end","left");j.at=j.at.replace("begin","right").replace("end","left");}else{j.my=j.my.replace("end","right").replace("begin","left");j.at=j.at.replace("end","right").replace("begin","left");}return j;};P.prototype._mirrorOffset=function(e){var i=String(e).trim().split(/\s/);var j=parseInt(i[0]);return(-j)+" "+i[i.length-1];};P.prototype._fixPositioning=function(e,i){var j=e.my;if(typeof(j)==="string"){if(P._isPositionFixingNeeded(j,i)){var $=this._$();var l=q(window).width()-$[0].getBoundingClientRect().width-$.offset().left;$.css({"right":l+"px","left":""});}}};P._isPositionFixingNeeded=function(e,i){return i&&((e.indexOf("right")>-1)||(e.indexOf("begin")>-1)||(e.indexOf("center")>-1))||!i&&((e.indexOf("right")>-1)||(e.indexOf("end")>-1));};P.prototype._resolveReference=function(e){var i,j=["of","within"];j.forEach(function(l){if(e[l]instanceof E){i=i||{};i[l]=e[l].getDomRef();}});return i?Object.assign({},e,i):e;};P.prototype.setShadow=function(S){c(typeof S==="boolean","bShowShadow must be boolean");this._bShadow=S;if(this.eOpenState!=n.CLOSED){this._$().toggleClass("sapUiShd",S);}return this;};P.prototype.setModal=function(e,i){c(typeof e==="boolean","bModal must be boolean");c(!i||typeof i==="string","sModalCSSClass must be empty or a string");var j=this._bModal;this._bModal=e;this._sModalCSSClass=i;if(this.isOpen()){if(j!==e){P._clearSelection();if(e){this._setupUserSelection();this._showBlockLayer();}else{this._hideBlockLayer();this._restoreUserSelection();}if(this.touchEnabled&&this._bAutoClose){if(!e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};P.prototype.getModal=function(){return this._bModal;};P.prototype.setNavigationMode=function(e){if(e!="NONE"&&e!="DOCK"&&e!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=e;};P.prototype.setAutoClose=function(e){c(typeof e==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==e){if(!this._bModal){if(e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=e;return this;};P.prototype.setExtraContent=function(e){c(Array.isArray(e),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[];}var j=function(S){return{onBeforeRendering:function(){var T=S.getDomRef();if(T&&this.isOpen()){T.removeEventListener("blur",this.fnEventHandler,true);}},onAfterRendering:function(){var T=S.getDomRef();if(T&&this.isOpen()){T.addEventListener("blur",this.fnEventHandler,true);}}};};var J,K,N,Q;for(var i=0,l=e.length;i<l;i++){K=e[i];if(K instanceof E){J=K.getId();}else if(typeof K==="object"){J=K.id;}else if(typeof K==="string"){J=K;}if(this.getChildPopups().indexOf(J)===-1){this.addChildPopup(J);Q={id:J};if(K instanceof E){N=j(K);K.addEventDelegate(N,this);Q.delegate=N;}this._aExtraContent.push(Q);}}return this;};P.prototype.setAutoCloseAreas=P.prototype.setExtraContent;P.prototype.setAnimations=function(e,i){c(e===null||typeof e==="function","fnOpen must be a function");c(i===null||typeof i==="function","fnClose must be a function");if(e&&(typeof(e)=="function")){this._animations.open=e;}if(i&&(typeof(i)=="function")){this._animations.close=i;}return this;};P.prototype.setDurations=function(i,e){c(i===null||(typeof i==="number"&&(i%1==0)),"iOpenDuration must be null or an integer");c(!e||(typeof e==="number"&&(e%1==0)),"iOpenDuration must be undefined or an integer");if((i>0)||(i===0)){this._durations.open=i;}if((e>0)||(e===0)){this._durations.close=e;}return this;};P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";P.prototype._fnCloseOnScroll=function(e){this.close();};P.prototype.setFollowOf=function(e){P.DockTrigger.removeListener(P.checkDocking,this);var U=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(e)==="function"){this._followOfHandler=e;U=true;}else if(typeof(e)==="boolean"){U=e;}else if(e===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;U=true;}else{this._bFollowOf=false;if(e!==null){L.error("Trying to set an invalid type to 'followOf: "+e);}}if(U&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===n.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};P.prototype.getAutoClose=function(){return this._bAutoClose;};P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};P.prototype.isOpen=function(){return this.bOpen;};P.prototype.getOpenState=function(){return this.eOpenState;};P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aExtraContent){var e;this._aExtraContent.forEach(function(i){if(i.delegate){e=q(document.getElementById(i.id)).control(0);if(e){e.removeEventDelegate(i.delegate);}}});}M.prototype.destroy.apply(this,arguments);};P.prototype.exit=function(){delete this._mEvents;};P.prototype._addFocusEventListeners=function(){if(!this.fnEventHandler){this.fnEventHandler=q.proxy(this.onFocusEvent,this);}var $=this._$();var e=this.getChildPopups();var j={};var i=0,l=0;if($.length){document.addEventListener("focus",this.fnEventHandler,true);$.get(0).addEventListener("blur",this.fnEventHandler,true);for(i=0,l=e.length;i<l;i++){j=(e[i]?window.document.getElementById(e[i]):null);if(j){j.addEventListener("blur",this.fnEventHandler,true);}}}};P.prototype._removeFocusEventListeners=function(){var $=this._$(false,true);if(!$.length){return;}var e=this.getChildPopups();var j={};var i=0,l=0;document.removeEventListener("focus",this.fnEventHandler,true);$.get(0).removeEventListener("blur",this.fnEventHandler,true);for(i=0,l=e.length;i<l;i++){j=(e[i]?window.document.getElementById(e[i]):null);if(j){j.removeEventListener("blur",this.fnEventHandler,true);}this.closePopup(e[i]);}this.fnEventHandler=null;};P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};P.prototype._deactivateFocusHandle=function(){if(this.fnEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};P.prototype._registerEventBusEvents=function(){var e=this;q.each(e._mEvents,function(i,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",i,l,e);});this._bEventBusEventsRegistered=true;};P.prototype._unregisterEventBusEvents=function(){var e=this;q.each(e._mEvents,function(i,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",i,l,e);});delete this._bEventBusEventsRegistered;};P.prototype._addFocusableArea=function(e,i,j){if(this.getChildPopups().indexOf(j.id)===-1){this.addChildPopup(j.id);}};P.prototype._removeFocusableArea=function(e,i,j){this.removeChildPopup(j.id);};P.prototype._closePopup=function(e,i,j){this.close(typeof this._durations.close==="string"?0:this._durations.close);};P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{L.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};P.prototype._$=function(e,i){var $;if(this.oContent instanceof C){$=this.oContent.$();if(e||($.length===0&&!i)){L.info("Rendering of popup content: "+this.oContent.getId());if($.length>0){R.preserveContent($[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());$=this.oContent.$();}}else if(this.oContent instanceof E){$=this.oContent.$();}else{$=q(this.oContent);}this._setIdentity($);return $;};function _(e){if(P._blockLayerStateProvider){P._blockLayerStateProvider.fireEvent("blockLayerStateChange",e);}}P.attachBlockLayerStateChange=function(e,i,l){if(!P._blockLayerStateProvider){P._blockLayerStateProvider=new k();}P._blockLayerStateProvider.attachEvent("blockLayerStateChange",e,i,l);};P.detachBlockLayerStateChange=function(e,l){if(P._blockLayerStateProvider){P._blockLayerStateProvider.detachEvent("blockLayerStateChange",e,l);}};function y($,W){if(W===window){v($);document.documentElement.classList.add("sapUiBLyBack");}else{w($,W);W.classList.add("sapUiBLyBack");r.observe(W);}}function z(W){if(W===window){document.documentElement.classList.remove("sapUiBLyBack");}else{W.classList.remove("sapUiBLyBack");r.unobserve(W);}}P.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:""),W;if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(e);}var l=P.blStack[P.blStack.length-1];if(l){W=t(l.popup._oLastPosition.within);z(W);}W=t(this._oLastPosition.within);y($,W);P.blStack.push({zIndex:this._iZIndex-2,popup:this});$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();if(P.blStack.length===1){_({visible:true,zIndex:P.blStack[0].zIndex});}};P.prototype._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e=$[0],i=this,l,W;W=t(this._oLastPosition.within);z(W);if($.length){if(P.blStack.length>1){P.blStack=P.blStack.filter(function(j){return j.popup!==i;});l=P.blStack[P.blStack.length-1];e.style.zIndex=l.zIndex;e.style.visibility="visible";e.style.display="block";W=t(l.popup._oLastPosition.within);y($,W);}else{l=P.blStack.pop();e.style.visibility="hidden";e.style.display="none";_({visible:false,zIndex:l.zIndex});}}};P.prototype._isFocusInsidePopup=function(){var e=this._$(false).get(0);if(e&&g(e,document.activeElement)){return true;}return false;};P.DockTrigger=I;P.checkDocking=function(){if(this.getOpenState()===n.OPEN){var e=this._getOfDom(this._oLastPosition.of),i;if(e){if((e===window)||(e===window.document)||g(document.documentElement,e)){i=q(e).rect();}else if(e.id){var N=window.document.getElementById(e.id);var j=q(N).rect();if(j&&!x(i,j)){i=j;this._oLastPosition.of=N;}}}if(!i){this.close();return;}else if(i.left===0&&i.top===0&&i.height===0&&i.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);e=this._getOfDom(this._oLastPosition.of);i=q(e).rect();if(!i){this.close();return;}}if(this._oLastOfRect){if(!x(this._oLastOfRect,i)){if(this._followOfHandler){var l=f({},this._oLastPosition),J=f({},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:J,currentOfRect:i});}else{this._applyPosition(this._oLastPosition);}}}}};P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};P.prototype.onmousedown=function(e,S){if(this._bMousedownCalled&&!S){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};P.prototype._increaseMyZIndex=function(e,j,J){var K=this.getParentPopup(this._oLastPosition.of);if(J&&J.type==="mousedown"||J&&J.isFromParentPopup||K.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(J&&!J.type||J&&J.type!="mousedown"||j==="mousedown"){var N=this.getChildPopups();for(var i=0,l=N.length;i<l;i++){this.increaseZIndex(N[i],true);}}}else if(K.length>0){var Q=q(K.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(Q,false);}};P.prototype.onAfterRendering=function(){var e=this.getContent();var $=e instanceof E?e.$():q(e);$.toggleClass("sapUiShd",this._bShadow);P._clearSelection();this._setupUserSelection();$.css("position","absolute");this._setIdentity($);var i=$[0];var l=i.style.left;var j=i.style.right;var J=i.style.top;var K=i.style.bottom;if(!(l&&l!="auto"||j&&j!="auto"||J&&J!="auto"||K&&K!="auto")){L.debug("reposition popup content "+$.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};P.prototype.onBeforeRendering=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};P.prototype.isInPopup=function(e){var $=this.getParentPopup(e);return $&&$.length>0;};P.prototype.getParentPopup=function(e){var T=e?e:this;var $=q(T instanceof E?T.getDomRef():T);return $.closest("[data-sap-ui-popup]");};P.prototype.getParentPopupId=function(e){var $=this.getParentPopup(e);return $.attr("data-sap-ui-popup");};P.prototype.addChildToPopup=function(e,i){var j="sap.ui.core.Popup.addFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};P.prototype.removeChildFromPopup=function(e,i){var j="sap.ui.core.Popup.removeFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};P.prototype.closePopup=function(e){var i="sap.ui.core.Popup.closePopup-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",i);};P.prototype.increaseZIndex=function(e,i){var j="sap.ui.core.Popup.increaseZIndex-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{isFromParentPopup:i?i:false});};P.prototype.focusTabChain=function(e){var S=e.event.target,N=e.that.getMetadata().getName(),i;if((!e.$FocusablesContent||!e.$FocusablesFooter)||(!e.$FocusablesContent.length&&!e.$FocusablesFooter.length)){return;}if(S.id===e.firstFocusable){L.debug("First dummy focus element was focused","",N);if(e.$FocusablesFooter.length>0){L.debug("Last footer element will be focused","",N);i=e.$FocusablesFooter[e.$FocusablesFooter.length-1];}else{L.debug("Last content element will be focused","",N);i=e.$FocusablesContent[e.$FocusablesContent.length-1];}}else if(S.id===e.lastFocusable){L.debug("Last dummy focus element was focues","",N);if(e.$FocusablesContent.length>0){L.debug("First content element will be focused","",N);i=e.$FocusablesContent[0];}else{L.debug("First footer element will be focused","",N);i=e.$FocusablesFooter[0];}}if(i){setTimeout(function(){var j=sap.ui.getCore().byId(i.id);if(j instanceof C){L.debug("Focus will be handled by "+j.getMetadata().getName(),"",N);}else{L.debug("oFocusDomRef will be focused","",N);}if(j){j.focus();}else if(i){i.focus();}return j?j.getId():i.id;},0);}};P.prototype._setupUserSelection=function(){var $=this._$(false,true);P._markAsUserSelectable($,this._bModal||P.blStack.length>0);if(this._bModal){if(P.blStack.length>0){var l=P.blStack[P.blStack.length-1];var e=function(i){return i.popup.getId();};if(P.blStack.map(e).indexOf(this.getId())===-1){P._markAsNotUserSelectable(l.popup._$(false,true),true);}else if(l.popup.getId()!==this.getId()){P._markAsNotUserSelectable($,true);}}else{P._markAsNotUserSelectable(q("html"),true);P._markExternalContentAsUserSelectable(true);}}};P.prototype._restoreUserSelection=function(){var $=this._$(false,true);P._markAsNotUserSelectable($,false);if(P.blStack.length>0){P._markAsUserSelectable(P.blStack[P.blStack.length-1].popup._$(false,true),true);}else{P._markAsUserSelectable(q("html"),false);P._markExternalContentAsNotUserSelectable(false);}};P._clearSelection=function(){var S=document.getSelection();if(!S.isCollapsed){S.removeAllRanges();}};P._markAsUserSelectable=function($,e){$.removeClass("sapUiNotUserSelectable");if(e){$.addClass("sapUiUserSelectable");}};P._markAsNotUserSelectable=function($,e){$.removeClass("sapUiUserSelectable");if(e){$.addClass("sapUiNotUserSelectable");}};var A=new Set(),H="[data-sap-ui-integration-popup-content]";A.add(H);P.addExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}S.forEach(Set.prototype.add.bind(A));if(e){P.markExternalContentAsSelectable();}};P.removeExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}if(e){P.markExternalContentAsNotSelectable();}S.forEach(function(i){if(i!==H){A.delete(i);}});};P.markExternalContentAsSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsUserSelectable(true);}};P.markExternalContentAsNotSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsNotUserSelectable(false);}};P._getExternalContent=function(){var e=[];if(A.size>0){A.forEach(function(S){var $=q(S);if($.length>0){e.push($);}});}return e;};P._markExternalContentAsUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsUserSelectable($,e);});};P._markExternalContentAsNotUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsNotUserSelectable($,e);});};P.setWithinArea=function(e){G=e;};P.getWithinArea=function(){return G;};P.getWithinAreaDomRef=function(){return t(G);};return P;});
