/*!
* OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./HyphenationTestingWords","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/core/Locale"],function(H,M,L,a){"use strict";var t={'bg':true,'ca':true,'hr':true,'cs':false,
// no valid license
'da':true,'nl':true,'en-us':true,'et':true,'fi':true,'fr':true,'de':true,'el-monoton':true,'hi':true,'hu':true,'it':true,'lt':true,'nb-no':true,'pl':false,'pt':true,'ru':true,'sr':false,'sl':true,'es':true,'sv':true,'th':true,'tr':true,'uk':true};var l={"bg":"Bulgarian","ca":"Catalan","hr":"Croatian","cs":"Czech","da":"Danish","nl":"Dutch","en":"English","et":"Estonian","fi":"Finnish","fr":"French","de":"German","el":"Greek","hi":"Hindi","hu":"Hungarian","it":"Italian","lt":"Lithuanian","nb":"Norwegian Bokmål","no":"Norwegian","pl":"Polish","pt":"Portuguese","ru":"Russian","sr":"Serbian","sl":"Slovenian","es":"Spanish","sv":"Swedish","th":"Thai","tr":"Turkish","uk":"Ukrainian"};var b={};var s={};var T={};var h=null;var f=null;var o={};function i(e){L.info("[UI5 Hyphenation] Initializing third-party module for language "+u(e),"sap.ui.core.hyphenation.Hyphenation.initialize()");var x=c();x.require[e]="FORCEHYPHENOPOLY";return d(sap.ui.require.toUrl("sap/ui/thirdparty/hyphenopoly/"),"Hyphenopoly_Loader.js").then(function(){delete x.require[e];return window.Hyphenopoly.hyphenators[e];});}function c(){if(!window.Hyphenopoly){window.Hyphenopoly={require:{},setup:{selectors:{".hyphenate":{hyphen:"\u00AD",leftmin:3,rightmin:3,compound:"all"}},hide:"DONT_HIDE"},handleEvent:{error:function(e){if(e.msg.match(/engine for language .* loaded, but no elements found./)){e.preventDefault();}}}};}return window.Hyphenopoly;}function d(P,F){return new Promise(function(e,x){var y=document.createElement('script');y.async=true;y.src=P+F;y.addEventListener('load',e);y.addEventListener('error',function(){return x('Error loading script: '+F);});y.addEventListener('abort',function(){return x(F+' Script loading aborted.');});document.head.appendChild(y);});}var g=(function x(){var e=["visibility:hidden;","-moz-hyphens:auto;","-webkit-hyphens:auto;","hyphens:auto;","width:48px;","font-size:12px;","line-height:12px;","border:none;","padding:0;","word-wrap:normal"];return e.join("");}());function j(e,x){if(!f){f=document.createElement("body");}var y=document.createElement("div");y.lang=e;y.id=e;y.style.cssText=g;y.appendChild(document.createTextNode(x));f.appendChild(y);}function k(e){if(f){e.appendChild(f);return f;}return null;}function m(){if(f){f.parentNode.removeChild(f);}}function n(e){return(e.style.hyphens==="auto"||e.style.webkitHyphens==="auto"||e.style.msHyphens==="auto"||e.style["-moz-hyphens"]==="auto");}function p(e){var x;if(e){x=new a(e);}else{x=sap.ui.getCore().getConfiguration().getLocale();}var y=x.getLanguage().toLowerCase();switch(y){case"en":y="en-us";break;case"nb":y="nb-no";break;case"no":y="nb-no";break;case"el":y="el-monoton";break;default:break;}return y;}function q(e){if(e){return new a(e).toString();}return sap.ui.getCore().getConfiguration().getLocale().toString();}function r(P){if(typeof P==="string"){return P.substring(0,2);}else{return null;}}function u(P){var e=r(P);if(l.hasOwnProperty(e)){return"'"+l[e]+"' (code:'"+e+"')";}else{return"'"+e+"'";}}function v(e){h.fireError(e);L.error("[UI5 Hyphenation] "+e,"sap.ui.core.hyphenation.Hyphenation");}var w=M.extend("sap.ui.core.hyphenation.Hyphenation",{metadata:{library:"sap.ui.core",events:{error:{parameters:{sErrorMessage:{type:"string"}}}}}});w.prototype.canUseNativeHyphenation=function(e){var x=q(e),y=p(e),C;if(!this.isLanguageSupported(y)){return null;}if(!b.hasOwnProperty(x)){j(x,H[y.toLowerCase()]);var z=k(document.documentElement);if(z!==null){var A=document.getElementById(x);if(n(A)&&A.offsetHeight>12){C=true;}else{C=false;}m();}b[x]=C;if(C){L.info("[UI5 Hyphenation] Browser-native hyphenation can be used for language "+u(x),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()");}else{L.info("[UI5 Hyphenation] Browser-native hyphenation is not supported by current platform for language "+u(x),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()");}}else{C=b[x];}return C;};w.prototype.canUseThirdPartyHyphenation=function(e){var x=p(e),C;if(!this.isLanguageSupported(e)){return null;}if(!T.hasOwnProperty(x)){C=t.hasOwnProperty(x)&&t[x];if(C){L.info("[UI5 Hyphenation] Third-party hyphenation can be used for language "+u(x),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()");}else{L.info("[UI5 Hyphenation] Third-party hyphenation is not supported for language "+u(x),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()");}T[x]=C;}else{C=T[x];}return C;};w.prototype.isLanguageSupported=function(e){var x=p(e),I;if(!s.hasOwnProperty(x)){I=H.hasOwnProperty(x);if(!I){L.info("[UI5 Hyphenation] Language "+u(x)+" is not known to the Hyphenation API","sap.ui.core.hyphenation.Hyphenation.isLanguageSupported()");}s[x]=I;}else{I=s[x];}return I;};w.prototype.hyphenate=function(e,x){var y=p(x);if(!o.hasOwnProperty(y)){v("Language "+u(y)+" is not initialized. You have to initialize it first with method 'initialize()'");return e;}return o[y](e);};w.prototype.getInitializedLanguages=function(){return Object.keys(o).map(function(e){return r(e);});};w.prototype.isLanguageInitialized=function(e){var e=p(e);return Object.keys(o).indexOf(e)!=-1;};w.prototype.initialize=function(e){var x=p(e);if(!t[x]){var y="Language "+u(e)+" can not be initialized. It is either not supported by the third-party module or an error occurred";v(y);return Promise.reject(y);}if(o[x]){return Promise.resolve();}var z;if(!this._pInitLanguage){z=this._pInitLanguage=i(x).then(function(A){o[x]=A;this._pInitLanguage=null;}.bind(this));}else{z=this._pInitLanguage.then(function(){return this.initialize(e);}.bind(this));}return z;};w.getInstance=function(){if(!h){h=new w();}return h;};return w;});
