//@ui5-bundle sap/ui/core/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/base/ManagedObjectObserver',['sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/base/EventProvider',"sap/base/util/array/uniqueSort",'sap/base/util/deepExtend'],function(B,M,E,u,d){"use strict";
var a=B.extend("sap.ui.base.ManagedObjectObserver",{constructor:function(C){if(!C&&typeof C!=="function"){throw new Error("Missing callback function in ManagedObjectObserver constructor");}this._fnCallback=C;}});
a.prototype.observe=function(i,C){if(!(i instanceof M)){if(i==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but observe was called for "+i);}p(i,C);c(i,this,C);};
a.prototype.unobserve=function(i,C){if(!(i instanceof M)){if(i==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but unobserve was called for "+i);}if(C){p(i,C);}r(i,this,C);};
a.prototype.isObserved=function(i,C){if(!(i instanceof M)){if(i==null){return false;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but isObserved was called for "+i);}return e(i,this,C);};
a.prototype.disconnect=function(){f(this);};
a.prototype.getConfiguration=function(i){return g(i,this);};
var O={},t=Object.create(null);
O.propertyChange=function(i,n,v,N){h("properties",i,n,function(){return{type:"property",old:v,current:N};});};
O.aggregationChange=function(i,n,s,v){h("aggregations",i,n,function(){return{type:"aggregation",mutation:s,children:Array.isArray(v)?v:null,child:!Array.isArray(v)?v:null};});};
O.parentChange=function(i,n,s,P){h("parent",i,n,function(){return{type:"parent",mutation:s,parent:P};});var q=s==="unset"?"remove":"insert";O.aggregationChange(P,n,q,i);};
O.associationChange=function(i,n,s,I){h("associations",i,n,function(){return{type:"association",mutation:s,ids:I};});};
O.eventChange=function(i,n,s,L,F,D){h("events",i,n,function(){return{type:"event",mutation:s,listener:L,func:F,data:D};});};
O.bindingChange=function(i,n,s,q,v){h("bindings",i,n,function(){return{type:"binding",mutation:s,bindingInfo:q,memberType:v};});};
O.objectDestroyed=function(i){h("destroy",i,null,function(){return{type:"destroy"};});var I=i.getId();if(t[I]){i.detachEvent("EventHandlerChange",H);delete t[I];}delete i._observer;};
function h(T,n,N,C){var I=n.getId(),q=t[I];if(q){var s;for(var i=0;i<q.listeners.length;i++){if(b(q.configurations[i],T,N)){if(!s){s=C();s.name=N;s.object=n;}var L=q.listeners[i];L._fnCallback(s);}}}}
function b(C,T,n){if(C==null||!T){return false;}if(T!="destroy"&&T!="parent"&&!n){return false;}return C[T]===true||(Array.isArray(C[T])&&C[T].indexOf(n)>-1);}
function c(T,L,C){j(T,L,C,false);}
function g(T,L){var i=T.getId();var n=t[i];if(n&&n.listeners){var I=n.listeners.indexOf(L);if(I>=0){var C=d({},n.configurations[I]);return C;}}return null;}
function r(T,L,C){C=C||g(T,L);j(T,L,C,true);}
function e(T,L,C){var i=T.getId(),n=t[i];C=C||g(T,L);if(!n){return false;}var I=n.listeners.indexOf(L);if(I===-1){return false;}else{return m(n.configurations[I].properties,C.properties)&&m(n.configurations[I].aggregations,C.aggregations)&&m(n.configurations[I].associations,C.associations)&&m(n.configurations[I].bindings,C.bindings)&&m(n.configurations[I].events,C.events)&&o(n.configurations[I].destroy,C.destroy)&&o(n.configurations[I].parent,C.parent);}}
function f(L){for(var n in t){var T=t[n];for(var i=0;i<T.listeners.length;i++){if(T.listeners[i]===L){T.listeners.splice(i,1);T.configurations.splice(i,1);}}if(T.listeners&&T.listeners.length===0){delete t[n];T.object._observer=undefined;}}}
function j(T,L,C,R){var i=T.getId(),n=t[i],q,I;if(R){if(!n){return;}I=n.listeners.indexOf(L);if(I>=0){q=n.configurations[I];}}else{if(!n){n=t[i]={listeners:[],configurations:[],object:T};}I=n.listeners.indexOf(L);if(I===-1){n.listeners.push(L);n.configurations.push(C);}else{q=n.configurations[I];}}if(q){q.properties=q.properties||[];l(q.properties,C.properties,R);q.aggregations=q.aggregations||[];l(q.aggregations,C.aggregations,R);q.associations=q.associations||[];l(q.associations,C.associations,R);q.bindings=q.bindings||[];l(q.bindings,C.bindings,R);q.events=q.events||[];l(q.events,C.events,R);if(C.destroy!=null){if(R){delete q.destroy;}else{q.destroy=C.destroy;}}if(C.parent!=null){if(R){delete q.parent;}else{q.parent=C.parent;}}}var s=k(T,"events");if(T._observer&&R){if(!s&&E.hasListener(T,"EventHandlerChange",H)){T.detachEvent("EventHandlerChange",H);}if(!s&&!k(T,"properties")&&!k(T,"aggregations")&&!k(T,"associations")&&!k(T,"destroy")&&!k(T,"parent")&&!k(T,"bindings")){delete T._observer;delete t[i];}}else if(!T._observer&&!R){if(s&&!E.hasListener(T,"EventHandlerChange",H)){T.attachEvent("EventHandlerChange",H);}T._observer=O;}}
function k(T,s){var i=T.getId(),n=t[i];if(n){var C=n.configurations.filter(function(q){return q.hasOwnProperty(s)&&q[s]&&(q[s]===true||q[s].length>0);});return C.length>0;}return false;}
function H(i){var T=i.getSource(),s=i.mParameters.EventId;if(T.getMetadata().hasEvent(s)){if(i.mParameters.type==="listenerAttached"){O.eventChange(T,s,"insert",i.mParameters.listener,i.mParameters.func,i.mParameters.data);}else if(i.mParameters.type==="listenerDetached"){O.eventChange(T,s,"remove",i.mParameters.listener,i.mParameters.func,i.mParameters.data);}}}
function l(n,A,R){if(!A){return;}for(var i=0;i<A.length;i++){var I=n.indexOf(A[i]);if(I>-1&&R){n.splice(I,1);}else if(I===-1&&!R){n.push(A[i]);}}}
function m(F,s){if(!Array.isArray(s)||s.length==0){return true;}if(!Array.isArray(F)||F.length==0){return false;}var U=u(F.concat(s));return F.length===U.length;}
function o(i,C){if(C==null){return true;}return i===C;}
function p(i,C){var n=i.getMetadata(),P=Object.keys(n.getAllProperties()),A=Object.keys(n.getAllAggregations()),q=Object.keys(n.getAllAssociations()),s=u(P.concat(A)),v=Object.keys(n.getAllEvents());C.properties=C.properties===true?P:C.properties;C.aggregations=C.aggregations===true?A:C.aggregations;C.associations=C.associations===true?q:C.associations;C.bindings=C.bindings===true?s:C.bindings;C.events=C.events===true?v:C.events;C.destroy=(C.destroy==null)?false:C.destroy;C.parent=(C.parent==null)?false:C.parent;}
return a;});
sap.ui.predefine('sap/ui/model/base/ManagedObjectModel',['../json/JSONModel','../json/JSONPropertyBinding','../json/JSONListBinding','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','../Context','../ChangeReason',"sap/base/util/uid","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/deepClone"],function(J,a,b,M,c,C,d,u,L,e,f){"use strict";var g="@custom",I="--";
function _(n,o,A,O){var p=A.get(o)||[],q,r;if(p&&!Array.isArray(p)&&!A.multiple){p=[p];}for(var i=0;i<p.length;i++){q=p[i];if(!(q instanceof M)){continue;}r=true;if(O){n._oObserver.observe(q,{properties:true,aggregations:true});}else{n._oObserver.unobserve(q,{properties:true,aggregations:true});}var s=q.getMetadata().getAllAggregations();for(var K in s){_(n,q,s[K],O);}}if(r){var K=o.getId()+"/@"+A.name;if(O){if(!n._mObservedCount.aggregations[K]){n._mObservedCount.aggregations[K]=0;}n._mObservedCount.aggregations[K]++;}else{delete n._mObservedCount.aggregations[K];}}}
function h(n){var s,i=n.length-1,p=[];while(!(n[i].node instanceof M)){if(s){p.splice(0,0,s);}s=n[i].path;i--;}return[n[i].node,n[i+1],p,s];}
function j(o){var D="",p;var t=typeof o;if(o==null||(t!="object"&&t!="function")){D=o;}else if(e(o)){D=JSON.stringify(o);}else if(o instanceof M){D=o.getId();for(p in o.mProperties){D=D+"$"+j(o.mProperties[p]);}}else if(Array.isArray(o)){for(var i=0;o.length;i++){D=D+"$"+j(o);}}else{L.warning("Could not stringify object "+o);D="$";}return D;}
var k=b.extend("sap.ui.model.base.ManagedObjectModelAggregationBinding",{
constructor:function(){b.apply(this,arguments);this._getOriginOfManagedObjectModelBinding();},
_mightBeAffectedByChangesInside:function(o){while(o){if(o.getParent()===this._oOriginMO){return true;}o=o.getParent();}return false;},
getEntryKey:function(o){var O=o.getObject();if(O instanceof M){return O.getId();}return b.prototype.getEntryKey.apply(this,arguments);},
getEntryData:function(o){var O=o.getObject();if(O instanceof M){return j(O);}return b.prototype.getEntryData.apply(this,arguments);},
_getContexts:function(s,i){var S;if(this._oAggregation){var o=this._oOriginMO.getBinding(this._sMember);if(o){var n=o.getModel();S=n.iSizeLimit;}var B=this._oOriginMO.getBindingInfo(this._sMember);if(B&&s>=0&&i&&S&&i>S){var U=false;if(s!=B.startIndex){B.startIndex=s;U=true;}if(i!=B.length){B.length=i;U=true;}if(U){this._oAggregation.update(this._oOriginMO,"change");}}}return b.prototype._getContexts.apply(this,arguments);},
_getOriginOfManagedObjectModelBinding:function(){if(!this._oOriginMO){var o=this.oModel,n=[];o._getObject(this.sPath,this.oContext,n);var v=h(n);this._oOriginMO=v[0];this._aPartsInJSON=v[2];this._sMember=v[3];this._oAggregation=this._oOriginMO.getMetadata().getAggregation(this._sMember);}},
getLength:function(){if(this._aPartsInJSON.length==0){var i=this._oOriginMO.getBinding(this._sMember);if(i&&i.isA("sap.ui.model.ListBinding")){return i.getLength();}}return b.prototype.getLength.apply(this,arguments);},
isLengthFinal:function(){if(this._aPartsInJSON.length==0){var i=this._oOriginMO.getBinding(this._sMember);if(i&&i.isA("sap.ui.model.ListBinding")){return i.isLengthFinal();}}return true;}
});
var l=a.extend("sap.ui.model.base.ManagedObjectModelPropertyBinding");
var m=J.extend("sap.ui.model.base.ManagedObjectModel",{constructor:function(o,D){if(!D&&typeof D!="object"){D={};}D[g]={};this._oObject=o;this._mObservedCount={properties:{},aggregations:{}};this.mListBinding={};J.apply(this,[D]);this._oObserver=new c(this.observerChanges.bind(this));this.setSizeLimit(1000000);}});
m.prototype.getAggregation=J.prototype.getProperty;
m.prototype.setData=function(D,i){var n={};n[g]=D;J.prototype.setData.apply(this,[n,i]);};
m.prototype.getJSON=function(){return JSON.stringify(this.oData[g]);};
m.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),n,O,P;if(!r){return false;}if(r.indexOf("/"+g)===0){return J.prototype.setProperty.apply(this,arguments);}n=r.lastIndexOf("/");O=r.substring(0,n||1);P=r.substr(n+1);var N=[],q=this._getObject(O,null,N);if(q){if(q instanceof M){var s=q.getMetadata().getManagedProperty(P);if(s){if(s.get(q)!==v){s.set(q,v);var F=function(B){var p=this.resolve(B.sPath,B.oContext);return p?p.startsWith(r):false;}.bind(this);this.checkUpdate(false,A,F);return true;}}else{L.warning("The setProperty method only supports properties, the path "+r+" does not point to a property",null,"sap.ui.model.base.ManagedObjectModel");}}else if(q[P]!==v){var V=h(N);var t=f(V[1].node),w=V[2];var x=t;for(var i=0;i<w.length;i++){x=x[w[i]];}x[P]=v;var y="/"+P;if(w.length>0){y="/"+w.join("/")+y;}var D=r.lastIndexOf(y);var z=r.substr(0,D);return this.setProperty(z,t,o);}}return false;};
m.prototype.addBinding=function(B){J.prototype.addBinding.apply(this,arguments);if(B instanceof k){var A=B.sPath.replace("/","");this.mListBinding[A]=B;}B.checkUpdate(false);};
m.prototype.removeBinding=function(B){J.prototype.removeBinding.apply(this,arguments);if(B instanceof k){var A=B.sPath.replace("/","");delete this.mListBinding[A];}this._observeBeforeEvaluating(B,false);};
m.prototype.firePropertyChange=function(p){if(p.reason===d.Binding){p.resolvedPath=this.resolve(p.path,p.context);}J.prototype.firePropertyChange.call(this,p);};
m.prototype.bindAggregation=function(p,o,P){return J.prototype.bindProperty.apply(this,arguments);};
m.prototype.bindProperty=function(p,o,P){var B=new l(this,p,o,P);return B;};
m.prototype.bindList=function(p,o,s,F,P){var B=new k(this,p,o,s,F,P);return B;};
m.prototype.getManagedObject=function(p,o){if(p instanceof C){o=p;p=o.getPath();}var O=this.getProperty(p,o);if(O instanceof M){return O;}return null;};
m.prototype.getRootObject=function(){return this._oObject;};
m.prototype._observePropertyChange=function(o,p){if(!o||!p){return;}var K=o.getId()+"/@"+p.name;if(!this._oObserver.isObserved(o,{properties:[p.name]})){this._oObserver.observe(o,{properties:[p.name]});this._mObservedCount.properties[K]=1;}else{this._mObservedCount.properties[K]++;}};
m.prototype._unobservePropertyChange=function(o,p){if(!o||!p){return;}var K=o.getId()+"/@"+p.name;this._mObservedCount.properties[K]--;if(this._mObservedCount.properties[K]==0){this._oObserver.unobserve(o,{properties:[p.name]});delete this._mObservedCount.properties[K];}};
m.prototype._observeAggregationChange=function(o,A){if(!o||!A){return;}var K=o.getId()+"/@"+A.name;if(!this._oObserver.isObserved(o,{aggregations:[A.name]})){this._oObserver.observe(o,{aggregations:[A.name]});this._mObservedCount.aggregations[K]=1;_(this,o,A,true);}else{this._mObservedCount.aggregations[K]++;}};
m.prototype._unobserveAggregationChange=function(o,A){if(!o||!A){return;}var K=o.getId()+"/@"+A.name;this._mObservedCount.aggregations[K]--;if(this._mObservedCount.aggregations[K]==0){this._oObserver.unobserve(o,{aggregations:[A.name]});delete this._mObservedCount.aggregations[K];}};
m.prototype._createId=function(i){var o=this._oObject;if(typeof o.createId==="function"){return o.createId(i);}if(!i){return o.getId()+I+u();}if(i.indexOf(o.getId()+I)!=0){return o.getId()+I+i;}return i;};
m.prototype._getSpecialNode=function(n,s,p,P){if(n instanceof M){if(s==="className"){if(n.getMetadata){return n.getMetadata().getName();}else{return typeof n;}}else if(s==="id"){return n.getId();}else if(s==="metadataContexts"){return n._oProviderData;}}else if(s==="binding"&&p&&P){return p.getBinding(P);}else if(s==="bound"&&p&&P){return p.isBound(P);}else if(s==="bindingInfo"&&p&&P){return p.getBindingInfo(P);}else if(Array.isArray(n)){if(s==="length"){return n.length;}else if(s.indexOf("id=")===0){var o=s.substring(3),F=null;for(var i=0;i<n.length;i++){if(n[i].getId()===this._createId(o)||n[i].getId()===o){F=n[i];break;}}return F;}}return null;};
m.prototype._getObject=function(p,o,n){var N=this._oObject,r="",t=this;if(n){n.push({path:"/",node:N});}this.aBindings.forEach(function(B){if(!B._bAttached){t._observeBeforeEvaluating(B,true);}});if(typeof p==="string"&&p.indexOf("/")!=0&&!o){return null;}if(o instanceof M){N=o;r=p;}else if(!o||o instanceof C){r=this.resolve(p,o);if(!r){return N;}if(r.indexOf("/"+g)===0){return J.prototype._getObject.apply(this,[p,o]);}}else{N=o;r=p;}if(!N){return null;}var P=r.split("/"),i=0;if(!P[0]){i++;}var q=null,s=null,v;while(N!==null&&P[i]){v=P[i];if(v=="id"){v="@id";}if(v.indexOf("@")===0){N=this._getSpecialNode(N,v.substring(1),q,s);}else if(N instanceof M){var w=N.getMetadata();if(w.isInstanceOf("sap.ui.core.IDScope")&&v.indexOf("#")===0){N=N.byId(v.substring(1));}else{q=N;s=v;var x=w.getManagedProperty(v);if(x){N=x.get(N);}else{var A=w.getManagedAggregation(v);if(A){N=A.get(N);}else{if(N&&N[v]&&typeof N[v]==="function"){N=N[v]();}else{N=null;}}}}}else if(Array.isArray(N)||e(N)){N=N[v];}else{if(N&&N[v]&&typeof N[v]==="function"){N=N[v]();}else{N=null;}}if(n){n.push({path:v,node:N});}i++;}return N;};
m.prototype.destroy=function(){for(var n in this._mAggregationObjects){var o=this._mAggregationObjects[n];if(o.object.invalidate.fn){o.object.invalidate=o.object.invalidate.fn;}}J.prototype.destroy.apply(this,arguments);};
m.prototype._observeBeforeEvaluating=function(B,o){if(!B.isResolved()){return;}var p=B.getPath();var i=B.getContext(),n=this._oObject,r;if(i instanceof M){n=i;r=p;}else if(!i||i instanceof C){r=this.resolve(p,i);if(!r){return;}if(r.indexOf("/"+g)===0){return;}}else{return;}var P=r.split("/");if(!P[0]){P.shift();}var s=P[0];if(n.getMetadata().isInstanceOf("sap.ui.core.IDScope")&&s.indexOf("#")===0){n=n.byId(s.substring(1));s=P[1];}if(n instanceof M){var N=n.getMetadata(),q=N.getManagedProperty(s);if(q){if(o===true){this._observePropertyChange(n,q);}else if(o===false){this._unobservePropertyChange(n,q);}}else{var A=N.getAggregation(s)||N.getAllPrivateAggregations()[s];if(A){if(o===true){this._observeAggregationChange(n,A);}else if(o===false){this._unobserveAggregationChange(n,A);}}}B._bAttached=o;}};
m.prototype.observerChanges=function(o){if(o.type=="aggregation"){var A={};if(o.child instanceof M){A=o.child.getMetadata().getAllAggregations();}if(o.mutation=="insert"){if(o.child instanceof M){this._oObserver.observe(o.child,{properties:true,aggregations:true});}for(var K in A){_(this,o.child,A[K],true);}if(this.mListBinding[o.name]){var i=this._oObject.getBinding(o.name);var n=this._oObject.getAggregation(o.name);if(i&&i.getCurrentContexts().length!=n.length){return;}}}else{if(o.child instanceof M){this._oObserver.unobserve(o.child,{properties:true,aggregations:true});}for(var K in A){_(this,o.child,A[K],false);}}}else if(o.type==="property"){this.aBindings.forEach(function(B){if(B._mightBeAffectedByChangesInside&&B._mightBeAffectedByChangesInside(o.object)){B.checkUpdate(true);}});}this.checkUpdate();};
m.prototype.checkUpdate=function(F,A,i){if(A){this.bForceUpdate=this.bForceUpdate||F;if(!this.sUpdateTimer){this.fnFilter=this.fnFilter||i;this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate,false,this.fnFilter);}.bind(this),0);}else if(this.fnFilter&&this.fnFilter!==i){this.fnFilter=undefined;}return;}F=this.bForceUpdate||F;i=!this.fnFilter||this.fnFilter===i?i:undefined;if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;this.fnFilter=undefined;}var B=this.aBindings.slice(0);B.forEach(function(o){if(!i||i(o)){o.checkUpdate(F);}});};
return m;});
/**
 * @license
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash strict include="omit,uniq,uniqBy,uniqWith,intersection,intersectionBy,intersectionWith,pick,pickBy,debounce,throttle,max,min,castArray,curry,merge,mergeWith,toArray,xor,xorBy,xorWith,isNil,difference,differenceBy,differenceWith,flatMap,flatMapDeep,flatMapDepth,isEqual,isEqualWith,without,flatten,flattenDeep,flattenDepth,compact,zipObject,zipObjectDeep,union,unionBy,unionWith"`
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Modifications SAP SE or an SAP affiliate company and OpenUI5 contributors. All rights reserved.
 */
sap.ui.predefine('sap/base/util/restricted/_/lodash.custom',function(){'use strict';var u;var V='4.17.21';var L=200;var F='Expected a function';var H='__lodash_hash_undefined__';var M=500;var P='__lodash_placeholder__';var C=1,a=2,b=4;var c=1,d=2;var W=1,f=2,g=4,h=8,i=16,j=32,k=64,l=128,m=256,o=512;var p=800,q=16;var I=1/0,r=9007199254740991,s=1.7976931348623157e+308,N=0/0;var t=4294967295;var w=[['ary',l],['bind',W],['bindKey',f],['curry',h],['curryRight',i],['flip',o],['partial',j],['partialRight',k],['rearg',m]];var v='[object Arguments]',x='[object Array]',y='[object AsyncFunction]',z='[object Boolean]',A='[object Date]',B='[object Error]',D='[object Function]',E='[object GeneratorFunction]',G='[object Map]',J='[object Number]',K='[object Null]',O='[object Object]',Q='[object Promise]',R='[object Proxy]',S='[object RegExp]',T='[object Set]',U='[object String]',X='[object Symbol]',Y='[object Undefined]',Z='[object WeakMap]';var $='[object ArrayBuffer]',_='[object DataView]',a1='[object Float32Array]',b1='[object Float64Array]',c1='[object Int8Array]',d1='[object Int16Array]',e1='[object Int32Array]',f1='[object Uint8Array]',g1='[object Uint8ClampedArray]',h1='[object Uint16Array]',i1='[object Uint32Array]';var j1=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,k1=/^\w*$/,l1=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var m1=/[\\^$.*+?()[\]{}|]/g;var n1=/^\s+/;var o1=/\s/;var p1=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,q1=/\{\n\/\* \[wrapped with (.+)\] \*/,r1=/,? & /;var s1=/\\(\\)?/g;var t1=/\w*$/;var u1=/^[-+]0x[0-9a-f]+$/i;var v1=/^0b[01]+$/i;var w1=/^\[object .+?Constructor\]$/;var x1=/^0o[0-7]+$/i;var y1=/^(?:0|[1-9]\d*)$/;var z1='\\ud800-\\udfff',A1='\\u0300-\\u036f',B1='\\ufe20-\\ufe2f',C1='\\u20d0-\\u20ff',D1=A1+B1+C1,E1='\\ufe0e\\ufe0f';var F1='['+z1+']',G1='['+D1+']',H1='\\ud83c[\\udffb-\\udfff]',I1='(?:'+G1+'|'+H1+')',J1='[^'+z1+']',K1='(?:\\ud83c[\\udde6-\\uddff]){2}',L1='[\\ud800-\\udbff][\\udc00-\\udfff]',M1='\\u200d';var N1=I1+'?',O1='['+E1+']?',P1='(?:'+M1+'(?:'+[J1,K1,L1].join('|')+')'+O1+N1+')*',Q1=O1+N1+P1,R1='(?:'+[J1+G1+'?',G1,K1,L1,F1].join('|')+')';var S1=RegExp(H1+'(?='+H1+')|'+R1+Q1,'g');var T1=RegExp('['+M1+z1+D1+E1+']');var U1={};U1[a1]=U1[b1]=U1[c1]=U1[d1]=U1[e1]=U1[f1]=U1[g1]=U1[h1]=U1[i1]=true;U1[v]=U1[x]=U1[$]=U1[z]=U1[_]=U1[A]=U1[B]=U1[D]=U1[G]=U1[J]=U1[O]=U1[S]=U1[T]=U1[U]=U1[Z]=false;var V1={};V1[v]=V1[x]=V1[$]=V1[_]=V1[z]=V1[A]=V1[a1]=V1[b1]=V1[c1]=V1[d1]=V1[e1]=V1[G]=V1[J]=V1[O]=V1[S]=V1[T]=V1[U]=V1[X]=V1[f1]=V1[g1]=V1[h1]=V1[i1]=true;V1[B]=V1[D]=V1[Z]=false;var W1=parseInt;var X1=typeof global=='object'&&global&&global.Object===Object&&global;var Y1=typeof self=='object'&&self&&self.Object===Object&&self;var Z1=X1||Y1||Function('return this')();var $1=typeof exports=='object'&&exports&&!exports.nodeType&&exports;var _1=$1&&typeof module=='object'&&module&&!module.nodeType&&module;var a2=_1&&_1.exports===$1;var b2=a2&&X1.process;var c2=(function(){try{var n=_1&&_1.require&&_1.require('util').types;if(n){return n;}return b2&&b2.binding&&b2.binding('util');}catch(e){}}());var d2=c2&&c2.isMap,e2=c2&&c2.isSet,f2=c2&&c2.isTypedArray;
function g2(e,n,_6){switch(_6.length){case 0:return e.call(n);case 1:return e.call(n,_6[0]);case 2:return e.call(n,_6[0],_6[1]);case 3:return e.call(n,_6[0],_6[1],_6[2]);}return e.apply(n,_6);}
function h2(e,K7){var n=-1,_6=e==null?0:e.length;while(++n<_6){if(K7(e[n],n,e)===false){break;}}return e;}
function i2(e,n){var _6=-1,R7=e==null?0:e.length,S7=0,T7=[];while(++_6<R7){var U7=e[_6];if(n(U7,_6,e)){T7[S7++]=U7;}}return T7;}
function j2(e,n){var _6=e==null?0:e.length;return!!_6&&q2(e,n,0)>-1;}
function k2(e,n,_6){var R7=-1,S7=e==null?0:e.length;while(++R7<S7){if(_6(n,e[R7])){return true;}}return false;}
function l2(e,K7){var n=-1,_6=e==null?0:e.length,R7=Array(_6);while(++n<_6){R7[n]=K7(e[n],n,e);}return R7;}
function m2(e,H7){var n=-1,_6=H7.length,R7=e.length;while(++n<_6){e[R7+n]=H7[n];}return e;}
function n2(e,n){var _6=-1,R7=e==null?0:e.length;while(++_6<R7){if(n(e[_6],_6,e)){return true;}}return false;}
function o2(e){return e.split('');}
function p2(e,n,_6,R7){var S7=e.length,T7=_6+(R7?1:-1);while((R7?T7--:++T7<S7)){if(n(e[T7],T7,e)){return T7;}}return-1;}
function q2(e,n,_6){return n===n?G2(e,n,_6):p2(e,r2,_6);}
function r2(e){return e!==e;}
function s2(e){return function(n){return n==null?u:n[e];};}
function t2(n,K7){var e=-1,_6=Array(n);while(++e<n){_6[e]=K7(e);}return _6;}
function u2(e){return e?e.slice(0,I2(e)+1).replace(n1,''):e;}
function v2(e){return function(n){return e(n);};}
function w2(e,n){return l2(n,function(_6){return e[_6];});}
function x2(e,n){return e.has(n);}
function y2(e,n){var _6=e.length,R7=0;while(_6--){if(e[_6]===n){++R7;}}return R7;}
function z2(e,n){return e==null?u:e[n];}
function A2(e){return T1.test(e);}
function B2(e){var n,_6=[];while(!(n=e.next()).done){_6.push(n.value);}return _6;}
function C2(U6){var e=-1,n=Array(U6.size);U6.forEach(function(_6,R7){n[++e]=[R7,_6];});return n;}
function D2(e,n){return function(_6){return e(n(_6));};}
function E2(e,n){var _6=-1,R7=e.length,S7=0,T7=[];while(++_6<R7){var U7=e[_6];if(U7===n||U7===P){e[_6]=P;T7[S7++]=_6;}}return T7;}
function F2(e){var n=-1,_6=Array(e.size);e.forEach(function(R7){_6[++n]=R7;});return _6;}
function G2(e,n,_6){var R7=_6-1,S7=e.length;while(++R7<S7){if(e[R7]===n){return R7;}}return-1;}
function H2(e){return A2(e)?J2(e):o2(e);}
function I2(e){var n=e.length;while(n--&&o1.test(e.charAt(n))){}return n;}
function J2(e){return e.match(S1)||[];}
var K2=Array.prototype,L2=Function.prototype,M2=Object.prototype;var N2=Z1['__core-js_shared__'];var O2=L2.toString;var P2=M2.hasOwnProperty;var Q2=(function(){var e=/[^.]+$/.exec(N2&&N2.keys&&N2.keys.IE_PROTO||'');return e?('Symbol(src)_1.'+e):'';}());var R2=M2.toString;var S2=O2.call(Object);var T2=RegExp('^'+O2.call(P2).replace(m1,'\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,'$1.*?')+'$');var U2=a2?Z1.Buffer:u,V2=Z1.Symbol,W2=Z1.Uint8Array,X2=U2?U2.allocUnsafe:u,Y2=D2(Object.getPrototypeOf,Object),Z2=Object.create,$2=M2.propertyIsEnumerable,_2=K2.splice,a3=V2?V2.isConcatSpreadable:u,b3=V2?V2.iterator:u,c3=V2?V2.toStringTag:u;var d3=(function(){try{var n=L5(Object,'defineProperty');n({},'',{});return n;}catch(e){}}());var e3=Object.getOwnPropertySymbols,f3=U2?U2.isBuffer:u,g3=D2(Object.keys,Object),h3=Math.max,i3=Math.min,j3=Date.now;var k3=L5(Z1,'DataView'),l3=L5(Z1,'Map'),m3=L5(Z1,'Promise'),n3=L5(Z1,'Set'),o3=L5(Z1,'WeakMap'),p3=L5(Object,'create');var q3=o3&&new o3;var r3={};var s3=s6(k3),t3=s6(l3),u3=s6(m3),v3=s6(n3),w3=s6(o3);var x3=V2?V2.prototype:u,y3=x3?x3.valueOf:u,z3=x3?x3.toString:u;
function A3(){}
var B3=(function(){function e(){}return function(n){if(!j7(n)){return{};}if(Z2){return Z2(n);}e.prototype=n;var _6=new e;e.prototype=u;return _6;};}());
function C3(){}
function D3(e){this.__wrapped__=e;this.__actions__=[];this.__dir__=1;this.__filtered__=false;this.__iteratees__=[];this.__takeCount__=t;this.__views__=[];}
D3.prototype=B3(C3.prototype);D3.prototype.constructor=D3;
function E3(e){var n=-1,_6=e==null?0:e.length;this.clear();while(++n<_6){var R7=e[n];this.set(R7[0],R7[1]);}}
function F3(){this.__data__=p3?p3(null):{};this.size=0;}
function G3(e){var n=this.has(e)&&delete this.__data__[e];this.size-=n?1:0;return n;}
function H3(e){var n=this.__data__;if(p3){var _6=n[e];return _6===H?u:_6;}return P2.call(n,e)?n[e]:u;}
function I3(e){var n=this.__data__;return p3?(n[e]!==u):P2.call(n,e);}
function J3(e,n){var _6=this.__data__;this.size+=this.has(e)?0:1;_6[e]=(p3&&n===u)?H:n;return this;}
E3.prototype.clear=F3;E3.prototype['delete']=G3;E3.prototype.get=H3;E3.prototype.has=I3;E3.prototype.set=J3;
function K3(e){var n=-1,_6=e==null?0:e.length;this.clear();while(++n<_6){var R7=e[n];this.set(R7[0],R7[1]);}}
function L3(){this.__data__=[];this.size=0;}
function M3(e){var n=this.__data__,_6=g4(n,e);if(_6<0){return false;}var R7=n.length-1;if(_6==R7){n.pop();}else{_2.call(n,_6,1);}--this.size;return true;}
function N3(e){var n=this.__data__,_6=g4(n,e);return _6<0?u:n[_6][1];}
function O3(e){return g4(this.__data__,e)>-1;}
function P3(e,n){var _6=this.__data__,R7=g4(_6,e);if(R7<0){++this.size;_6.push([e,n]);}else{_6[R7][1]=n;}return this;}
K3.prototype.clear=L3;K3.prototype['delete']=M3;K3.prototype.get=N3;K3.prototype.has=O3;K3.prototype.set=P3;
function Q3(e){var n=-1,_6=e==null?0:e.length;this.clear();while(++n<_6){var R7=e[n];this.set(R7[0],R7[1]);}}
function R3(){this.size=0;this.__data__={'hash':new E3,'map':new(l3||K3),'string':new E3};}
function S3(e){var n=J5(this,e)['delete'](e);this.size-=n?1:0;return n;}
function T3(e){return J5(this,e).get(e);}
function U3(e){return J5(this,e).has(e);}
function V3(e,n){var _6=J5(this,e),R7=_6.size;_6.set(e,n);this.size+=_6.size==R7?0:1;return this;}
Q3.prototype.clear=R3;Q3.prototype['delete']=S3;Q3.prototype.get=T3;Q3.prototype.has=U3;Q3.prototype.set=V3;
function W3(H7){var e=-1,n=H7==null?0:H7.length;this.__data__=new Q3;while(++e<n){this.add(H7[e]);}}
function X3(e){this.__data__.set(e,H);return this;}
function Y3(e){return this.__data__.has(e);}
W3.prototype.add=W3.prototype.push=X3;W3.prototype.has=Y3;
function Z3(e){var n=this.__data__=new K3(e);this.size=n.size;}
function $3(){this.__data__=new K3;this.size=0;}
function _3(e){var n=this.__data__,_6=n['delete'](e);this.size=n.size;return _6;}
function a4(e){return this.__data__.get(e);}
function b4(e){return this.__data__.has(e);}
function c4(e,n){var _6=this.__data__;if(_6 instanceof K3){var R7=_6.__data__;if(!l3||(R7.length<L-1)){R7.push([e,n]);this.size=++_6.size;return this;}_6=this.__data__=new Q3(R7);}_6.set(e,n);this.size=_6.size;return this;}
Z3.prototype.clear=$3;Z3.prototype['delete']=_3;Z3.prototype.get=a4;Z3.prototype.has=b4;Z3.prototype.set=c4;
function d4(e,n){var _6=b7(e),R7=!_6&&a7(e),S7=!_6&&!R7&&e7(e),T7=!_6&&!R7&&!S7&&r7(e),U7=_6||R7||S7||T7,V7=U7?t2(e.length,String):[],W7=V7.length;for(var X7 in e){if((n||P2.call(e,X7))&&!(U7&&(X7=='length'||(S7&&(X7=='offset'||X7=='parent'))||(T7&&(X7=='buffer'||X7=='byteLength'||X7=='byteOffset'))||X5(X7,W7)))){V7.push(X7);}}return V7;}
function e4(e,n,_6){if((_6!==u&&!eq(e[n],_6))||(_6===u&&!(n in e))){j4(e,n,_6);}}
function f4(e,n,_6){var R7=e[n];if(!(P2.call(e,n)&&eq(R7,_6))||(_6===u&&!(n in e))){j4(e,n,_6);}}
function g4(e,n){var _6=e.length;while(_6--){if(eq(e[_6][0],n)){return _6;}}return-1;}
function h4(e,n){return e&&k5(n,A7(n),e);}
function i4(e,n){return e&&k5(n,B7(n),e);}
function j4(e,n,_6){if(n=='__proto__'&&d3){d3(e,n,{'configurable':true,'enumerable':true,'value':_6,'writable':true});}else{e[n]=_6;}}
function k4(e,n,_6,R7,S7,T7){var U7,V7=n&C,W7=n&a,X7=n&b;if(_6){U7=S7?_6(e,R7,S7,T7):_6(e);}if(U7!==u){return U7;}if(!j7(e)){return e;}var Y7=b7(e);if(Y7){U7=S5(e);if(!V7){return j5(e,U7);}}else{var Z7=P5(e),$7=Z7==D||Z7==E;if(e7(e)){return b5(e,V7);}if(Z7==O||Z7==v||($7&&!S7)){U7=(W7||$7)?{}:T5(e);if(!V7){return W7?m5(e,i4(U7,e)):l5(e,h4(U7,e));}}else{if(!V1[Z7]){return S7?e:{};}U7=U5(e,Z7,V7);}}T7||(T7=new Z3);var _7=T7.get(e);if(_7){return _7;}T7.set(e,U7);if(o7(e)){e.forEach(function(c8){U7.add(k4(c8,n,_6,c8,e,T7));});}else if(l7(e)){e.forEach(function(c8,R7){U7.set(R7,k4(c8,n,_6,R7,e,T7));});}var a8=X7?(W7?E5:D5):(W7?B7:A7);var b8=Y7?u:a8(e);h2(b8||e,function(c8,R7){if(b8){R7=c8;c8=e[R7];}f4(U7,R7,k4(c8,n,_6,R7,e,T7));});return U7;}
function l4(e,H7,K7,n){var _6=-1,R7=j2,S7=true,T7=e.length,U7=[],V7=H7.length;if(!T7){return U7;}if(K7){H7=l2(H7,v2(K7));}if(n){R7=k2;S7=false;}else if(H7.length>=L){R7=x2;S7=false;H7=new W3(H7);}outer:while(++_6<T7){var W7=e[_6],X7=K7==null?W7:K7(W7);W7=(n||W7!==0)?W7:0;if(S7&&X7===X7){var Y7=V7;while(Y7--){if(H7[Y7]===X7){continue outer;}}U7.push(W7);}else if(!R7(H7,X7,n)){U7.push(W7);}}return U7;}
var m4=o5(q4);
function n4(e,K7,n){var _6=-1,R7=e.length;while(++_6<R7){var S7=e[_6],T7=K7(S7);if(T7!=null&&(U7===u?(T7===T7&&!q7(T7)):n(T7,U7))){var U7=T7,V7=S7;}}return V7;}
function o4(e,n,_6,R7,S7){var T7=-1,U7=e.length;_6||(_6=W5);S7||(S7=[]);while(++T7<U7){var V7=e[T7];if(n>0&&_6(V7)){if(n>1){o4(V7,n-1,_6,R7,S7);}else{m2(S7,V7);}}else if(!R7){S7[S7.length]=V7;}}return S7;}
var p4=p5();
function q4(e,K7){return e&&p4(e,K7,A7);}
function r4(e,n){n=a5(n,e);var _6=0,R7=n.length;while(e!=null&&_6<R7){e=e[r6(n[_6++])];}return(_6&&_6==R7)?e:u;}
function s4(e,n,_6){var R7=n(e);return b7(e)?R7:m2(R7,_6(e));}
function t4(e){if(e==null){return e===u?Y:K;}return(c3&&c3 in Object(e))?M5(e):h6(e);}
function u4(e,n){return e>n;}
function v4(e,n){return e!=null&&n in Object(e);}
function w4(e,K7,n){var _6=n?k2:j2,R7=e[0].length,S7=e.length,T7=S7,U7=Array(S7),V7=Infinity,W7=[];while(T7--){var X7=e[T7];if(T7&&K7){X7=l2(X7,v2(K7));}V7=i3(X7.length,V7);U7[T7]=!n&&(K7||(R7>=120&&X7.length>=120))?new W3(T7&&X7):u;}X7=e[0];var Y7=-1,Z7=U7[0];outer:while(++Y7<R7&&W7.length<V7){var $7=X7[Y7],_7=K7?K7($7):$7;$7=(n||$7!==0)?$7:0;if(!(Z7?x2(Z7,_7):_6(W7,_7,n))){T7=S7;while(--T7){var a8=U7[T7];if(!(a8?x2(a8,_7):_6(e[T7],_7,n))){continue outer;}}if(Z7){Z7.push(_7);}W7.push($7);}}return W7;}
function x4(e){return k7(e)&&t4(e)==v;}
function y4(e,n,_6,R7,S7){if(e===n){return true;}if(e==null||n==null||(!k7(e)&&!k7(n))){return e!==e&&n!==n;}return z4(e,n,_6,R7,y4,S7);}
function z4(e,n,_6,R7,S7,T7){var U7=b7(e),V7=b7(n),W7=U7?x:P5(e),X7=V7?x:P5(n);W7=W7==v?O:W7;X7=X7==v?O:X7;var Y7=W7==O,Z7=X7==O,$7=W7==X7;if($7&&e7(e)){if(!e7(n)){return false;}U7=true;Y7=false;}if($7&&!Y7){T7||(T7=new Z3);return(U7||r7(e))?z5(e,n,_6,R7,S7,T7):A5(e,n,W7,_6,R7,S7,T7);}if(!(_6&c)){var _7=Y7&&P2.call(e,'__wrapped__'),a8=Z7&&P2.call(n,'__wrapped__');if(_7||a8){var b8=_7?e.value():e,c8=a8?n.value():n;T7||(T7=new Z3);return S7(b8,c8,_6,R7,T7);}}if(!$7){return false;}T7||(T7=new Z3);return B5(e,n,_6,R7,S7,T7);}
function A4(e){return k7(e)&&P5(e)==G;}
function B4(e,n,_6,R7){var S7=_6.length,T7=S7,U7=!R7;if(e==null){return!T7;}e=Object(e);while(S7--){var V7=_6[S7];if((U7&&V7[2])?V7[1]!==e[V7[0]]:!(V7[0]in e)){return false;}}while(++S7<T7){V7=_6[S7];var W7=V7[0],X7=e[W7],Y7=V7[1];if(U7&&V7[2]){if(X7===u&&!(W7 in e)){return false;}}else{var Z7=new Z3;if(R7){var $7=R7(X7,Y7,W7,e,n,Z7);}if(!($7===u?y4(Y7,X7,c|d,R7,Z7):$7)){return false;}}}return true;}
function C4(e){if(!j7(e)||a6(e)){return false;}var n=h7(e)?T2:w1;return n.test(s6(e));}
function D4(e){return k7(e)&&P5(e)==T;}
function E4(e){return k7(e)&&i7(e.length)&&!!U1[t4(e)];}
function F4(e){if(typeof e=='function'){return e;}if(e==null){return J7;}if(typeof e=='object'){return b7(e)?L4(e[0],e[1]):K4(e);}return M7(e);}
function G4(e){if(!b6(e)){return g3(e);}var n=[];for(var _6 in Object(e)){if(P2.call(e,_6)&&_6!='constructor'){n.push(_6);}}return n;}
function H4(e){if(!j7(e)){return g6(e);}var n=b6(e),_6=[];for(var R7 in e){if(!(R7=='constructor'&&(n||!P2.call(e,R7)))){_6.push(R7);}}return _6;}
function I4(e,n){return e<n;}
function J4(e,K7){var n=-1,_6=c7(e)?Array(e.length):[];m4(e,function(R7,S7,e){_6[++n]=K7(R7,S7,e);});return _6;}
function K4(e){var n=K5(e);if(n.length==1&&n[0][2]){return d6(n[0][0],n[0][1]);}return function(_6){return _6===e||B4(_6,e,n);};}
function L4(e,n){if(Z5(e)&&c6(n)){return d6(r6(e),n);}return function(_6){var R7=y7(_6,e);return(R7===u&&R7===n)?z7(_6,e):y4(n,R7,c|d);};}
function M4(e,n,_6,R7,S7){if(e===n){return;}p4(n,function(T7,U7){S7||(S7=new Z3);if(j7(T7)){N4(e,n,U7,_6,M4,R7,S7);}else{var V7=R7?R7(l6(e,U7),T7,(U7+''),e,n,S7):u;if(V7===u){V7=T7;}e4(e,U7,V7);}},B7);}
function N4(e,n,_6,R7,S7,T7,U7){var V7=l6(e,_6),W7=l6(n,_6),X7=U7.get(W7);if(X7){e4(e,_6,X7);return;}var Y7=T7?T7(V7,W7,(_6+''),e,n,U7):u;var Z7=Y7===u;if(Z7){var $7=b7(W7),_7=!$7&&e7(W7),a8=!$7&&!_7&&r7(W7);Y7=W7;if($7||_7||a8){if(b7(V7)){Y7=V7;}else if(d7(V7)){Y7=j5(V7);}else if(_7){Z7=false;Y7=b5(W7,true);}else if(a8){Z7=false;Y7=g5(W7,true);}else{Y7=[];}}else if(n7(W7)||a7(W7)){Y7=V7;if(a7(V7)){Y7=w7(V7);}else if(!j7(V7)||h7(V7)){Y7=T5(W7);}}else{Z7=false;}}if(Z7){U7.set(W7,Y7);S7(Y7,W7,R7,T7,U7);U7['delete'](W7);}e4(e,_6,Y7);}
function O4(e,n){return P4(e,n,function(_6,R7){return z7(e,R7);});}
function P4(e,n,_6){var R7=-1,S7=n.length,T7={};while(++R7<S7){var U7=n[R7],V7=r4(e,U7);if(_6(V7,U7)){S4(T7,a5(U7,e),V7);}}return T7;}
function Q4(e){return function(n){return r4(n,e);};}
function R4(e,n){return n6(i6(e,n,J7),e+'');}
function S4(e,n,_6,R7){if(!j7(e)){return e;}n=a5(n,e);var S7=-1,T7=n.length,U7=T7-1,V7=e;while(V7!=null&&++S7<T7){var W7=r6(n[S7]),X7=_6;if(W7==='__proto__'||W7==='constructor'||W7==='prototype'){return e;}if(S7!=U7){var Y7=V7[W7];X7=R7?R7(Y7,W7,V7):u;if(X7===u){X7=j7(Y7)?Y7:(X5(n[S7+1])?[]:{});}}f4(V7,W7,X7);V7=V7[W7];}return e;}
var T4=!q3?J7:function(e,n){q3.set(e,n);return e;};var U4=!d3?J7:function(e,n){return d3(e,'toString',{'configurable':true,'enumerable':false,'value':I7(n),'writable':true});};
function V4(e,n,_6){var R7=-1,S7=e.length;if(n<0){n=-n>S7?0:(S7+n);}_6=_6>S7?S7:_6;if(_6<0){_6+=S7;}S7=n>_6?0:((_6-n)>>>0);n>>>=0;var T7=Array(S7);while(++R7<S7){T7[R7]=e[R7+n];}return T7;}
function W4(e){if(typeof e=='string'){return e;}if(b7(e)){return l2(e,W4)+'';}if(q7(e)){return z3?z3.call(e):'';}var n=(e+'');return(n=='0'&&(1/e)==-I)?'-0':n;}
function X4(e,K7,n){var _6=-1,R7=j2,S7=e.length,T7=true,U7=[],V7=U7;if(n){T7=false;R7=k2;}else if(S7>=L){var W7=K7?null:w5(e);if(W7){return F2(W7);}T7=false;R7=x2;V7=new W3;}else{V7=K7?[]:U7;}outer:while(++_6<S7){var X7=e[_6],Y7=K7?K7(X7):X7;X7=(n||X7!==0)?X7:0;if(T7&&Y7===Y7){var Z7=V7.length;while(Z7--){if(V7[Z7]===Y7){continue outer;}}if(K7){V7.push(Y7);}U7.push(X7);}else if(!R7(V7,Y7,n)){if(V7!==U7){V7.push(Y7);}U7.push(X7);}}return U7;}
function Y4(e,n){n=a5(n,e);e=j6(e,n);return e==null||delete e[r6(E6(n))];}
function Z4(e,K7,n){var _6=e.length;if(_6<2){return _6?X4(e[0]):[];}var R7=-1,S7=Array(_6);while(++R7<_6){var T7=e[R7],U7=-1;while(++U7<_6){if(U7!=R7){S7[R7]=l4(S7[R7]||T7,e[U7],K7,n);}}}return X4(o4(S7,1),K7,n);}
function $4(e,H7,n){var _6=-1,R7=e.length,S7=H7.length,T7={};while(++_6<R7){var U7=_6<S7?H7[_6]:u;n(T7,e[_6],U7);}return T7;}
function _4(e){return d7(e)?e:[];}
function a5(e,n){if(b7(e)){return e;}return Z5(e,n)?[e]:q6(x7(e));}
function b5(e,n){if(n){return e.slice();}var _6=e.length,R7=X2?X2(_6):new e.constructor(_6);e.copy(R7);return R7;}
function c5(e){var n=new e.constructor(e.byteLength);new W2(n).set(new W2(e));return n;}
function d5(e,n){var _6=n?c5(e.buffer):e.buffer;return new e.constructor(_6,e.byteOffset,e.byteLength);}
function e5(e){var n=new e.constructor(e.source,t1.exec(e));n.lastIndex=e.lastIndex;return n;}
function f5(e){return y3?Object(y3.call(e)):{};}
function g5(e,n){var _6=n?c5(e.buffer):e.buffer;return new e.constructor(_6,e.byteOffset,e.length);}
function h5(e,n,_6,R7){var S7=-1,T7=e.length,U7=_6.length,V7=-1,W7=n.length,X7=h3(T7-U7,0),Y7=Array(W7+X7),Z7=!R7;while(++V7<W7){Y7[V7]=n[V7];}while(++S7<U7){if(Z7||S7<T7){Y7[_6[S7]]=e[S7];}}while(X7--){Y7[V7++]=e[S7++];}return Y7;}
function i5(e,n,_6,R7){var S7=-1,T7=e.length,U7=-1,V7=_6.length,W7=-1,X7=n.length,Y7=h3(T7-V7,0),Z7=Array(Y7+X7),$7=!R7;while(++S7<Y7){Z7[S7]=e[S7];}var _7=S7;while(++W7<X7){Z7[_7+W7]=n[W7];}while(++U7<V7){if($7||S7<T7){Z7[_7+_6[U7]]=e[S7++];}}return Z7;}
function j5(e,n){var _6=-1,R7=e.length;n||(n=Array(R7));while(++_6<R7){n[_6]=e[_6];}return n;}
function k5(e,n,_6,R7){var S7=!_6;_6||(_6={});var T7=-1,U7=n.length;while(++T7<U7){var V7=n[T7];var W7=R7?R7(_6[V7],e[V7],V7,_6,e):u;if(W7===u){W7=e[V7];}if(S7){j4(_6,V7,W7);}else{f4(_6,V7,W7);}}return _6;}
function l5(e,n){return k5(e,N5(e),n);}
function m5(e,n){return k5(e,O5(e),n);}
function n5(e){return R4(function(n,_6){var R7=-1,S7=_6.length,T7=S7>1?_6[S7-1]:u,U7=S7>2?_6[2]:u;T7=(e.length>3&&typeof T7=='function')?(S7--,T7):u;if(U7&&Y5(_6[0],_6[1],U7)){T7=S7<3?u:T7;S7=1;}n=Object(n);while(++R7<S7){var V7=_6[R7];if(V7){e(n,V7,R7,T7);}}return n;});}
function o5(e,n){return function(_6,K7){if(_6==null){return _6;}if(!c7(_6)){return e(_6,K7);}var R7=_6.length,S7=n?R7:-1,T7=Object(_6);while((n?S7--:++S7<R7)){if(K7(T7[S7],S7,T7)===false){break;}}return _6;};}
function p5(e){return function(n,K7,_6){var R7=-1,S7=Object(n),T7=_6(n),U7=T7.length;while(U7--){var V7=T7[e?U7:++R7];if(K7(S7[V7],V7,S7)===false){break;}}return n;};}
function q5(e,n,_6){var R7=n&W,S7=r5(e);function T7(){var fn=(this&&this!==Z1&&this instanceof T7)?S7:e;return fn.apply(R7?_6:this,arguments);}return T7;}
function r5(e){return function(){var n=arguments;switch(n.length){case 0:return new e;case 1:return new e(n[0]);case 2:return new e(n[0],n[1]);case 3:return new e(n[0],n[1],n[2]);case 4:return new e(n[0],n[1],n[2],n[3]);case 5:return new e(n[0],n[1],n[2],n[3],n[4]);case 6:return new e(n[0],n[1],n[2],n[3],n[4],n[5]);case 7:return new e(n[0],n[1],n[2],n[3],n[4],n[5],n[6]);}var _6=B3(e.prototype),R7=e.apply(_6,n);return j7(R7)?R7:_6;};}
function s5(e,n,_6){var R7=r5(e);function S7(){var T7=arguments.length,U7=Array(T7),V7=T7,W7=H5(S7);while(V7--){U7[V7]=arguments[V7];}var X7=(T7<3&&U7[0]!==W7&&U7[T7-1]!==W7)?[]:E2(U7,W7);T7-=X7.length;if(T7<_6){return v5(e,n,t5,S7.placeholder,u,U7,X7,u,u,_6-T7);}var fn=(this&&this!==Z1&&this instanceof S7)?R7:e;return g2(fn,this,U7);}return S7;}
function t5(e,n,_6,R7,S7,T7,U7,V7,W7,X7){var Y7=n&l,Z7=n&W,$7=n&f,_7=n&(h|i),a8=n&o,b8=$7?u:r5(e);function c8(){var d8=arguments.length,e8=Array(d8),f8=d8;while(f8--){e8[f8]=arguments[f8];}if(_7){var g8=H5(c8),h8=y2(e8,g8);}if(R7){e8=h5(e8,R7,S7,_7);}if(T7){e8=i5(e8,T7,U7,_7);}d8-=h8;if(_7&&d8<X7){var i8=E2(e8,g8);return v5(e,n,t5,c8.placeholder,_6,e8,i8,V7,W7,X7-d8);}var j8=Z7?_6:this,fn=$7?j8[e]:e;d8=e8.length;if(V7){e8=k6(e8,V7);}else if(a8&&d8>1){e8.reverse();}if(Y7&&W7<d8){e8.length=W7;}if(this&&this!==Z1&&this instanceof c8){fn=b8||r5(fn);}return fn.apply(j8,e8);}return c8;}
function u5(e,n,_6,R7){var S7=n&W,T7=r5(e);function U7(){var V7=-1,W7=arguments.length,X7=-1,Y7=R7.length,Z7=Array(Y7+W7),fn=(this&&this!==Z1&&this instanceof U7)?T7:e;while(++X7<Y7){Z7[X7]=R7[X7];}while(W7--){Z7[X7++]=arguments[++V7];}return g2(fn,S7?_6:this,Z7);}return U7;}
function v5(e,n,_6,R7,S7,T7,U7,V7,W7,X7){var Y7=n&h,Z7=Y7?U7:u,$7=Y7?u:U7,_7=Y7?T7:u,a8=Y7?u:T7;n|=(Y7?j:k);n&=~(Y7?k:j);if(!(n&g)){n&=~(W|f);}var b8=[e,n,S7,_7,Z7,a8,$7,V7,W7,X7];var c8=_6.apply(u,b8);if(_5(e)){m6(c8,b8);}c8.placeholder=R7;return o6(c8,e,n);}
var w5=!(n3&&(1/F2(new n3([,-0]))[1])==I)?L7:function(H7){return new n3(H7);};
function x5(e,n,_6,R7,S7,T7,U7,V7){var W7=n&f;if(!W7&&typeof e!='function'){throw new TypeError(F);}var X7=R7?R7.length:0;if(!X7){n&=~(j|k);R7=S7=u;}U7=U7===u?U7:h3(u7(U7),0);V7=V7===u?V7:u7(V7);X7-=S7?S7.length:0;if(n&k){var Y7=R7,Z7=S7;R7=S7=u;}var $7=W7?u:F5(e);var _7=[e,n,_6,R7,S7,Y7,Z7,T7,U7,V7];if($7){f6(_7,$7);}e=_7[0];n=_7[1];_6=_7[2];R7=_7[3];S7=_7[4];V7=_7[9]=_7[9]===u?(W7?0:e.length):h3(_7[9]-X7,0);if(!V7&&n&(h|i)){n&=~(h|i);}if(!n||n==W){var a8=q5(e,n,_6);}else if(n==h||n==i){a8=s5(e,n,V7);}else if((n==j||n==(W|j))&&!S7.length){a8=u5(e,n,_6,R7);}else{a8=t5.apply(u,_7);}var b8=$7?T4:m6;return o6(b8(a8,_7),e,n);}
function y5(e){return n7(e)?u:e;}
function z5(e,n,_6,R7,S7,T7){var U7=_6&c,V7=e.length,W7=n.length;if(V7!=W7&&!(U7&&W7>V7)){return false;}var X7=T7.get(e);var Y7=T7.get(n);if(X7&&Y7){return X7==n&&Y7==e;}var Z7=-1,$7=true,_7=(_6&d)?new W3:u;T7.set(e,n);T7.set(n,e);while(++Z7<V7){var a8=e[Z7],b8=n[Z7];if(R7){var c8=U7?R7(b8,a8,Z7,n,e,T7):R7(a8,b8,Z7,e,n,T7);}if(c8!==u){if(c8){continue;}$7=false;break;}if(_7){if(!n2(n,function(b8,d8){if(!x2(_7,d8)&&(a8===b8||S7(a8,b8,_6,R7,T7))){return _7.push(d8);}})){$7=false;break;}}else if(!(a8===b8||S7(a8,b8,_6,R7,T7))){$7=false;break;}}T7['delete'](e);T7['delete'](n);return $7;}
function A5(e,n,_6,R7,S7,T7,U7){switch(_6){case _:if((e.byteLength!=n.byteLength)||(e.byteOffset!=n.byteOffset)){return false;}e=e.buffer;n=n.buffer;case $:if((e.byteLength!=n.byteLength)||!T7(new W2(e),new W2(n))){return false;}return true;case z:case A:case J:return eq(+e,+n);case B:return e.name==n.name&&e.message==n.message;case S:case U:return e==(n+'');case G:var V7=C2;case T:var W7=R7&c;V7||(V7=F2);if(e.size!=n.size&&!W7){return false;}var X7=U7.get(e);if(X7){return X7==n;}R7|=d;U7.set(e,n);var Y7=z5(V7(e),V7(n),R7,S7,T7,U7);U7['delete'](e);return Y7;case X:if(y3){return y3.call(e)==y3.call(n);}}return false;}
function B5(e,n,_6,R7,S7,T7){var U7=_6&c,V7=D5(e),W7=V7.length,X7=D5(n),Y7=X7.length;if(W7!=Y7&&!U7){return false;}var Z7=W7;while(Z7--){var $7=V7[Z7];if(!(U7?$7 in n:P2.call(n,$7))){return false;}}var _7=T7.get(e);var a8=T7.get(n);if(_7&&a8){return _7==n&&a8==e;}var b8=true;T7.set(e,n);T7.set(n,e);var c8=U7;while(++Z7<W7){$7=V7[Z7];var d8=e[$7],e8=n[$7];if(R7){var f8=U7?R7(e8,d8,$7,n,e,T7):R7(d8,e8,$7,e,n,T7);}if(!(f8===u?(d8===e8||S7(d8,e8,_6,R7,T7)):f8)){b8=false;break;}c8||(c8=$7=='constructor');}if(b8&&!c8){var g8=e.constructor,h8=n.constructor;if(g8!=h8&&('constructor'in e&&'constructor'in n)&&!(typeof g8=='function'&&g8 instanceof g8&&typeof h8=='function'&&h8 instanceof h8)){b8=false;}}T7['delete'](e);T7['delete'](n);return b8;}
function C5(e){return n6(i6(e,u,y6),e+'');}
function D5(e){return s4(e,A7,N5);}
function E5(e){return s4(e,B7,O5);}
var F5=!q3?L7:function(e){return q3.get(e);};
function G5(e){var n=(e.name+''),_6=r3[n],R7=P2.call(r3,n)?_6.length:0;while(R7--){var S7=_6[R7],T7=S7.func;if(T7==null||T7==e){return S7.name;}}return n;}
function H5(e){var n=P2.call(A3,'placeholder')?A3:e;return n.placeholder;}
function I5(){var e=A3.iteratee||K7;e=e===K7?F4:e;return arguments.length?e(arguments[0],arguments[1]):e;}
function J5(U6,e){var n=U6.__data__;return $5(e)?n[typeof e=='string'?'string':'hash']:n.map;}
function K5(e){var n=A7(e),_6=n.length;while(_6--){var R7=n[_6],S7=e[R7];n[_6]=[R7,S7,c6(S7)];}return n;}
function L5(e,n){var _6=z2(e,n);return C4(_6)?_6:u;}
function M5(n){var _6=P2.call(n,c3),R7=n[c3];try{n[c3]=u;var S7=true;}catch(e){}var T7=R2.call(n);if(S7){if(_6){n[c3]=R7;}else{delete n[c3];}}return T7;}
var N5=!e3?N7:function(e){if(e==null){return[];}e=Object(e);return i2(e3(e),function(n){return $2.call(e,n);});};var O5=!e3?N7:function(e){var n=[];while(e){m2(n,N5(e));e=Y2(e);}return n;};var P5=t4;if((k3&&P5(new k3(new ArrayBuffer(1)))!=_)||(l3&&P5(new l3)!=G)||(m3&&P5(m3.resolve())!=Q)||(n3&&P5(new n3)!=T)||(o3&&P5(new o3)!=Z)){P5=function(e){var n=t4(e),_6=n==O?e.constructor:u,R7=_6?s6(_6):'';if(R7){switch(R7){case s3:return _;case t3:return G;case u3:return Q;case v3:return T;case w3:return Z;}}return n;};}
function Q5(e){var n=e.match(q1);return n?n[1].split(r1):[];}
function R5(e,n,_6){n=a5(n,e);var R7=-1,S7=n.length,T7=false;while(++R7<S7){var U7=r6(n[R7]);if(!(T7=e!=null&&_6(e,U7))){break;}e=e[U7];}if(T7||++R7!=S7){return T7;}S7=e==null?0:e.length;return!!S7&&i7(S7)&&X5(U7,S7)&&(b7(e)||a7(e));}
function S5(e){var n=e.length,_6=new e.constructor(n);if(n&&typeof e[0]=='string'&&P2.call(e,'index')){_6.index=e.index;_6.input=e.input;}return _6;}
function T5(e){return(typeof e.constructor=='function'&&!b6(e))?B3(Y2(e)):{};}
function U5(e,n,_6){var R7=e.constructor;switch(n){case $:return c5(e);case z:case A:return new R7(+e);case _:return d5(e,_6);case a1:case b1:case c1:case d1:case e1:case f1:case g1:case h1:case i1:return g5(e,_6);case G:return new R7;case J:case U:return new R7(e);case S:return e5(e);case T:return new R7;case X:return f5(e);}}
function V5(e,n){var _6=n.length;if(!_6){return e;}var R7=_6-1;n[R7]=(_6>1?'& ':'')+n[R7];n=n.join(_6>2?', ':' ');return e.replace(p1,'{\n/* [wrapped with '+n+'] */\n');}
function W5(e){return b7(e)||a7(e)||!!(a3&&e&&e[a3]);}
function X5(e,n){var _6=typeof e;n=n==null?r:n;return!!n&&(_6=='number'||(_6!='symbol'&&y1.test(e)))&&(e>-1&&e%1==0&&e<n);}
function Y5(e,n,_6){if(!j7(_6)){return false;}var R7=typeof n;if(R7=='number'?(c7(_6)&&X5(n,_6.length)):(R7=='string'&&n in _6)){return eq(_6[n],e);}return false;}
function Z5(e,n){if(b7(e)){return false;}var _6=typeof e;if(_6=='number'||_6=='symbol'||_6=='boolean'||e==null||q7(e)){return true;}return k1.test(e)||!j1.test(e)||(n!=null&&e in Object(n));}
function $5(e){var n=typeof e;return(n=='string'||n=='number'||n=='symbol'||n=='boolean')?(e!=='__proto__'):(e===null);}
function _5(e){var n=G5(e),_6=A3[n];if(typeof _6!='function'||!(n in D3.prototype)){return false;}if(e===_6){return true;}var R7=F5(_6);return!!R7&&e===R7[0];}
function a6(e){return!!Q2&&(Q2 in e);}
function b6(e){var n=e&&e.constructor,_6=(typeof n=='function'&&n.prototype)||M2;return e===_6;}
function c6(e){return e===e&&!j7(e);}
function d6(e,n){return function(_6){if(_6==null){return false;}return _6[e]===n&&(n!==u||(e in Object(_6)));};}
function e6(e){var n=Y6(e,function(R7){if(_6.size===M){_6.clear();}return R7;});var _6=n.cache;return n;}
function f6(e,n){var _6=e[1],R7=n[1],S7=_6|R7,T7=S7<(W|f|l);var U7=((R7==l)&&(_6==h))||((R7==l)&&(_6==m)&&(e[7].length<=n[8]))||((R7==(l|m))&&(n[7].length<=n[8])&&(_6==h));if(!(T7||U7)){return e;}if(R7&W){e[2]=n[2];S7|=_6&W?0:g;}var V7=n[3];if(V7){var W7=e[3];e[3]=W7?h5(W7,V7,n[4]):V7;e[4]=W7?E2(e[3],P):n[4];}V7=n[5];if(V7){W7=e[5];e[5]=W7?i5(W7,V7,n[6]):V7;e[6]=W7?E2(e[5],P):n[6];}V7=n[7];if(V7){e[7]=V7;}if(R7&l){e[8]=e[8]==null?n[8]:i3(e[8],n[8]);}if(e[9]==null){e[9]=n[9];}e[0]=n[0];e[1]=S7;return e;}
function g6(e){var n=[];if(e!=null){for(var _6 in Object(e)){n.push(_6);}}return n;}
function h6(e){return R2.call(e);}
function i6(e,n,_6){n=h3(n===u?(e.length-1):n,0);return function(){var R7=arguments,S7=-1,T7=h3(R7.length-n,0),U7=Array(T7);while(++S7<T7){U7[S7]=R7[n+S7];}S7=-1;var V7=Array(n+1);while(++S7<n){V7[S7]=R7[S7];}V7[n]=_6(U7);return g2(e,this,V7);};}
function j6(e,n){return n.length<2?e:r4(e,V4(n,0,-1));}
function k6(e,n){var _6=e.length,R7=i3(n.length,_6),S7=j5(e);while(R7--){var T7=n[R7];e[R7]=X5(T7,_6)?S7[T7]:u;}return e;}
function l6(e,n){if(n==='constructor'&&typeof e[n]==='function'){return;}if(n=='__proto__'){return;}return e[n];}
var m6=p6(T4);var n6=p6(U4);
function o6(e,n,_6){var R7=(n+'');return n6(e,V5(R7,t6(Q5(R7),_6)));}
function p6(e){var n=0,_6=0;return function(){var R7=j3(),S7=q-(R7-_6);_6=R7;if(S7>0){if(++n>=p){return arguments[0];}}else{n=0;}return e.apply(u,arguments);};}
var q6=e6(function(e){var n=[];if(e.charCodeAt(0)===46){n.push('');}e.replace(l1,function(_6,R7,S7,T7){n.push(S7?T7.replace(s1,'$1'):(R7||_6));});return n;});
function r6(e){if(typeof e=='string'||q7(e)){return e;}var n=(e+'');return(n=='0'&&(1/e)==-I)?'-0':n;}
function s6(n){if(n!=null){try{return O2.call(n);}catch(e){}try{return(n+'');}catch(e){}}return'';}
function t6(e,n){h2(w,function(_6){var R7='_.'+_6[0];if((n&_6[1])&&!j2(e,R7)){e.push(R7);}});return e.sort();}
function u6(e){var n=-1,_6=e==null?0:e.length,R7=0,S7=[];while(++n<_6){var T7=e[n];if(T7){S7[R7++]=T7;}}return S7;}
var v6=R4(function(e,H7){return d7(e)?l4(e,o4(H7,1,d7,true)):[];});var w6=R4(function(e,H7){var K7=E6(H7);if(d7(K7)){K7=u;}return d7(e)?l4(e,o4(H7,1,d7,true),I5(K7,2)):[];});var x6=R4(function(e,H7){var n=E6(H7);if(d7(n)){n=u;}return d7(e)?l4(e,o4(H7,1,d7,true),u,n):[];});
function y6(e){var n=e==null?0:e.length;return n?o4(e,1):[];}
function z6(e){var n=e==null?0:e.length;return n?o4(e,I):[];}
function A6(e,n){var _6=e==null?0:e.length;if(!_6){return[];}n=n===u?1:u7(n);return o4(e,n);}
var B6=R4(function(e){var n=l2(e,_4);return(n.length&&n[0]===e[0])?w4(n):[];});var C6=R4(function(e){var K7=E6(e),n=l2(e,_4);if(K7===E6(n)){K7=u;}else{n.pop();}return(n.length&&n[0]===e[0])?w4(n,I5(K7,2)):[];});var D6=R4(function(e){var n=E6(e),_6=l2(e,_4);n=typeof n=='function'?n:u;if(n){_6.pop();}return(_6.length&&_6[0]===e[0])?w4(_6,u,n):[];});
function E6(e){var n=e==null?0:e.length;return n?e[n-1]:u;}
var F6=R4(function(e){return X4(o4(e,1,d7,true));});var G6=R4(function(e){var K7=E6(e);if(d7(K7)){K7=u;}return X4(o4(e,1,d7,true),I5(K7,2));});var H6=R4(function(e){var n=E6(e);n=typeof n=='function'?n:u;return X4(o4(e,1,d7,true),u,n);});
function I6(e){return(e&&e.length)?X4(e):[];}
function J6(e,K7){return(e&&e.length)?X4(e,I5(K7,2)):[];}
function K6(e,n){n=typeof n=='function'?n:u;return(e&&e.length)?X4(e,u,n):[];}
var L6=R4(function(e,H7){return d7(e)?l4(e,H7):[];});var M6=R4(function(e){return Z4(i2(e,d7));});var N6=R4(function(e){var K7=E6(e);if(d7(K7)){K7=u;}return Z4(i2(e,d7),I5(K7,2));});var O6=R4(function(e){var n=E6(e);n=typeof n=='function'?n:u;return Z4(i2(e,d7),u,n);});
function P6(e,H7){return $4(e||[],H7||[],f4);}
function Q6(e,H7){return $4(e||[],H7||[],S4);}
function R6(e,K7){return o4(U6(e,K7),1);}
function S6(e,K7){return o4(U6(e,K7),I);}
function T6(e,K7,n){n=n===u?1:u7(n);return o4(U6(e,K7),n);}
function U6(e,K7){var n=b7(e)?l2:J4;return n(e,I5(K7,3));}
var V6=function(){return Z1.Date.now();};
function W6(e,n,_6){n=_6?u:n;var R7=x5(e,h,u,u,u,u,u,n);R7.placeholder=W6.placeholder;return R7;}
function X6(e,n,_6){var R7,S7,T7,U7,V7,W7,X7=0,Y7=false,Z7=false,$7=true;if(typeof e!='function'){throw new TypeError(F);}n=v7(n)||0;if(j7(_6)){Y7=!!_6.leading;Z7='maxWait'in _6;T7=Z7?h3(v7(_6.maxWait)||0,n):T7;$7='trailing'in _6?!!_6.trailing:$7;}function _7(i8){var j8=R7,k8=S7;R7=S7=u;X7=i8;U7=e.apply(k8,j8);return U7;}function a8(i8){X7=i8;V7=setTimeout(d8,n);return Y7?_7(i8):U7;}function b8(i8){var j8=i8-W7,k8=i8-X7,l8=n-j8;return Z7?i3(l8,T7-k8):l8;}function c8(i8){var j8=i8-W7,k8=i8-X7;return(W7===u||(j8>=n)||(j8<0)||(Z7&&k8>=T7));}function d8(){var i8=V6();if(c8(i8)){return e8(i8);}V7=setTimeout(d8,b8(i8));}function e8(i8){V7=u;if($7&&R7){return _7(i8);}R7=S7=u;return U7;}function f8(){if(V7!==u){clearTimeout(V7);}X7=0;R7=W7=S7=V7=u;}function g8(){return V7===u?U7:e8(V6());}function h8(){var i8=V6(),j8=c8(i8);R7=arguments;S7=this;W7=i8;if(j8){if(V7===u){return a8(W7);}if(Z7){clearTimeout(V7);V7=setTimeout(d8,n);return _7(W7);}}if(V7===u){V7=setTimeout(d8,n);}return U7;}h8.cancel=f8;h8.flush=g8;return h8;}
function Y6(e,n){if(typeof e!='function'||(n!=null&&typeof n!='function')){throw new TypeError(F);}var _6=function(){var R7=arguments,S7=n?n.apply(this,R7):R7[0],T7=_6.cache;if(T7.has(S7)){return T7.get(S7);}var U7=e.apply(this,R7);_6.cache=T7.set(S7,U7)||T7;return U7;};_6.cache=new(Y6.Cache||Q3);return _6;}
Y6.Cache=Q3;
function Z6(e,n,_6){var R7=true,S7=true;if(typeof e!='function'){throw new TypeError(F);}if(j7(_6)){R7='leading'in _6?!!_6.leading:R7;S7='trailing'in _6?!!_6.trailing:S7;}return X6(e,n,{'leading':R7,'maxWait':n,'trailing':S7});}
function $6(){if(!arguments.length){return[];}var e=arguments[0];return b7(e)?e:[e];}
function eq(e,n){return e===n||(e!==e&&n!==n);}
var a7=x4(function(){return arguments;}())?x4:function(e){return k7(e)&&P2.call(e,'callee')&&!$2.call(e,'callee');};var b7=Array.isArray;
function c7(e){return e!=null&&i7(e.length)&&!h7(e);}
function d7(e){return k7(e)&&c7(e);}
var e7=f3||O7;
function f7(e,n){return y4(e,n);}
function g7(e,n,_6){_6=typeof _6=='function'?_6:u;var R7=_6?_6(e,n):u;return R7===u?y4(e,n,u,_6):!!R7;}
function h7(e){if(!j7(e)){return false;}var n=t4(e);return n==D||n==E||n==y||n==R;}
function i7(e){return typeof e=='number'&&e>-1&&e%1==0&&e<=r;}
function j7(e){var n=typeof e;return e!=null&&(n=='object'||n=='function');}
function k7(e){return e!=null&&typeof e=='object';}
var l7=d2?v2(d2):A4;
function m7(e){return e==null;}
function n7(e){if(!k7(e)||t4(e)!=O){return false;}var n=Y2(e);if(n===null){return true;}var _6=P2.call(n,'constructor')&&n.constructor;return typeof _6=='function'&&_6 instanceof _6&&O2.call(_6)==S2;}
var o7=e2?v2(e2):D4;
function p7(e){return typeof e=='string'||(!b7(e)&&k7(e)&&t4(e)==U);}
function q7(e){return typeof e=='symbol'||(k7(e)&&t4(e)==X);}
var r7=f2?v2(f2):E4;
function s7(e){if(!e){return[];}if(c7(e)){return p7(e)?H2(e):j5(e);}if(b3&&e[b3]){return B2(e[b3]());}var n=P5(e),_6=n==G?C2:(n==T?F2:H7);return _6(e);}
function t7(e){if(!e){return e===0?e:0;}e=v7(e);if(e===I||e===-I){var n=(e<0?-1:1);return n*s;}return e===e?e:0;}
function u7(e){var n=t7(e),_6=n%1;return n===n?(_6?n-_6:n):0;}
function v7(e){if(typeof e=='number'){return e;}if(q7(e)){return N;}if(j7(e)){var n=typeof e.valueOf=='function'?e.valueOf():e;e=j7(n)?(n+''):n;}if(typeof e!='string'){return e===0?e:+e;}e=u2(e);var _6=v1.test(e);return(_6||x1.test(e))?W1(e.slice(2),_6?2:8):(u1.test(e)?N:+e);}
function w7(e){return k5(e,B7(e));}
function x7(e){return e==null?'':W4(e);}
function y7(e,n,_6){var R7=e==null?u:r4(e,n);return R7===u?_6:R7;}
function z7(e,n){return e!=null&&R5(e,n,v4);}
function A7(e){return c7(e)?d4(e):G4(e);}
function B7(e){return c7(e)?d4(e,true):H4(e);}
var C7=n5(function(e,n,_6){M4(e,n,_6);});var D7=n5(function(e,n,_6,R7){M4(e,n,_6,R7);});var E7=C5(function(e,n){var _6={};if(e==null){return _6;}var R7=false;n=l2(n,function(T7){T7=a5(T7,e);R7||(R7=T7.length>1);return T7;});k5(e,E5(e),_6);if(R7){_6=k4(_6,C|a|b,y5);}var S7=n.length;while(S7--){Y4(_6,n[S7]);}return _6;});var F7=C5(function(e,n){return e==null?{}:O4(e,n);});
function G7(e,n){if(e==null){return{};}var _6=l2(E5(e),function(R7){return[R7];});n=I5(n);return P4(e,_6,function(R7,S7){return n(R7,S7[0]);});}
function H7(e){return e==null?[]:w2(e,A7(e));}
function I7(e){return function(){return e;};}
function J7(e){return e;}
function K7(e){return F4(typeof e=='function'?e:k4(e,C));}
function L7(){}
function M7(e){return Z5(e)?s2(r6(e)):Q4(e);}
function N7(){return[];}
function O7(){return false;}
function P7(e){return(e&&e.length)?n4(e,J7,u4):u;}
function Q7(e){return(e&&e.length)?n4(e,J7,I4):u;}
A3.castArray=$6;A3.compact=u6;A3.constant=I7;A3.curry=W6;A3.debounce=X6;A3.difference=v6;A3.differenceBy=w6;A3.differenceWith=x6;A3.flatMap=R6;A3.flatMapDeep=S6;A3.flatMapDepth=T6;A3.flatten=y6;A3.flattenDeep=z6;A3.flattenDepth=A6;A3.intersection=B6;A3.intersectionBy=C6;A3.intersectionWith=D6;A3.iteratee=K7;A3.keys=A7;A3.keysIn=B7;A3.map=U6;A3.memoize=Y6;A3.merge=C7;A3.mergeWith=D7;A3.omit=E7;A3.pick=F7;A3.pickBy=G7;A3.property=M7;A3.throttle=Z6;A3.toArray=s7;A3.toPlainObject=w7;A3.union=F6;A3.unionBy=G6;A3.unionWith=H6;A3.uniq=I6;A3.uniqBy=J6;A3.uniqWith=K6;A3.values=H7;A3.without=L6;A3.xor=M6;A3.xorBy=N6;A3.xorWith=O6;A3.zipObject=P6;A3.zipObjectDeep=Q6;A3.eq=eq;A3.get=y7;A3.hasIn=z7;A3.identity=J7;A3.isArguments=a7;A3.isArray=b7;A3.isArrayLike=c7;A3.isArrayLikeObject=d7;A3.isBuffer=e7;A3.isEqual=f7;A3.isEqualWith=g7;A3.isFunction=h7;A3.isLength=i7;A3.isMap=l7;A3.isNil=m7;A3.isObject=j7;A3.isObjectLike=k7;A3.isPlainObject=n7;A3.isSet=o7;A3.isString=p7;A3.isSymbol=q7;A3.isTypedArray=r7;A3.last=E6;A3.max=P7;A3.min=Q7;A3.stubArray=N7;A3.stubFalse=O7;A3.noop=L7;A3.now=V6;A3.toFinite=t7;A3.toInteger=u7;A3.toNumber=v7;A3.toString=x7;A3.VERSION=V;W6.placeholder=A3;return A3;});
/*!
 * Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
 * Version 2.0.0, see https://github.com/sindresorhus/p-cancelable/tree/v2.0.0
 */
sap.ui.predefine('sap/base/util/restricted/_CancelablePromise',function(){'use strict';
function _(o,a){var p;if(typeof Symbol==="undefined"||o[Symbol.iterator]==null){if(Array.isArray(o)||(p=b(o))||a&&o&&typeof o.length==="number"){if(p)o=p;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(f){throw f;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var y=true,z=false,A;return{s:function s(){p=o[Symbol.iterator]();},n:function n(){var s=p.next();y=s.done;return s;},e:function e(f){z=true;A=f;},f:function f(){try{if(!y&&p.return!=null)p.return();}finally{if(z)throw A;}}};}
function b(o,a){if(!o)return;if(typeof o==="string")return c(o,a);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return c(o,a);}
function c(a,e){if(e==null||e>a.length)e=a.length;for(var i=0,f=new Array(e);i<e;i++){f[i]=a[i];}return f;}
function d(o){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){d=function d(o){return typeof o;};}else{d=function d(o){return o&&typeof Symbol==="function"&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o;};}return d(o);}
function g(i,a){if(!(i instanceof a)){throw new TypeError("Cannot call a class as a function");}}
function h(a,p){for(var i=0;i<p.length;i++){var e=p[i];e.enumerable=e.enumerable||false;e.configurable=true;if("value"in e)e.writable=true;Object.defineProperty(a,e.key,e);}}
function j(a,p,s){if(p)h(a.prototype,p);if(s)h(a,s);return a;}
function k(s,a){if(typeof a!=="function"&&a!==null){throw new TypeError("Super expression must either be null or a function");}s.prototype=Object.create(a&&a.prototype,{constructor:{value:s,writable:true,configurable:true}});if(a)w(s,a);}
function l(D){var a=u();return function f(){var S=x(D),e;if(a){var N=x(this).constructor;e=Reflect.construct(S,arguments,N);}else{e=S.apply(this,arguments);}return m(this,e);};}
function m(s,a){if(a&&(d(a)==="object"||typeof a==="function")){return a;}return q(s);}
function q(s){if(s===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return s;}
function r(a){var e=typeof Map==="function"?new Map():undefined;r=function r(a){if(a===null||!v(a))return a;if(typeof a!=="function"){throw new TypeError("Super expression must either be null or a function");}if(typeof e!=="undefined"){if(e.has(a))return e.get(a);e.set(a,W);}function W(){return t(a,arguments,x(this).constructor);}W.prototype=Object.create(a.prototype,{constructor:{value:W,enumerable:false,writable:true,configurable:true}});return w(W,a);};return r(a);}
function t(e,f,i){if(u()){t=Reflect.construct;}else{t=function t(e,f,i){var a=[null];a.push.apply(a,f);var n=Function.bind.apply(e,a);var o=new n();if(i)w(o,i.prototype);return o;};}return t.apply(null,arguments);}
function u(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Date.prototype.toString.call(Reflect.construct(Date,[],function(){}));return true;}catch(e){return false;}}
function v(f){return Function.toString.call(f).indexOf("[native code]")!==-1;}
function w(o,p){w=Object.setPrototypeOf||function w(o,p){o.__proto__=p;return o;};return w(o,p);}
function x(o){x=Object.setPrototypeOf?Object.getPrototypeOf:function x(o){return o.__proto__||Object.getPrototypeOf(o);};return x(o);}
var C=function(a){k(C,a);var e=l(C);function C(f){var i;g(this,C);i=e.call(this,f||'Promise was canceled');i.name='CancelError';return i;}j(C,[{key:"isCanceled",get:function f(){return true;}}]);return C;}(r(Error));var P=function(){j(P,null,[{key:"fn",value:function f(a){return function(){for(var e=arguments.length,i=new Array(e),n=0;n<e;n++){i[n]=arguments[n];}return new P(function(o,p,s){i.push(s);a.apply(void 0,i).then(o,p);});};}}]);function P(e){var a=this;g(this,P);this._cancelHandlers=[];this._isPending=true;this._isCanceled=false;this._rejectOnCancel=true;this._promise=new Promise(function(f,i){a._reject=i;var o=function o(s){a._isPending=false;f(s);};var n=function n(s){a._isPending=false;i(s);};var p=function p(s){if(!a._isPending){throw new Error('The `onCancel` handler was attached after the promise settled.');}a._cancelHandlers.push(s);};Object.defineProperties(p,{shouldReject:{get:function s(){return a._rejectOnCancel;},set:function y(s){a._rejectOnCancel=s;}}});return e(o,n,p);});}j(P,[{key:"then",value:function e(o,a){return this._promise.then(o,a);}},{key:"catch",value:function a(o){return this._promise.catch(o);}},{key:"finally",value:function a(o){return this._promise.finally(o);}},{key:"cancel",value:function p(a){if(!this._isPending||this._isCanceled){return;}if(this._cancelHandlers.length>0){try{var e=_(this._cancelHandlers),f;try{for(e.s();!(f=e.n()).done;){var i=f.value;i();}}catch(n){e.e(n);}finally{e.f();}}catch(o){this._reject(o);}}this._isCanceled=true;if(this._rejectOnCancel){this._reject(new C(a));}}},{key:"isCanceled",get:function a(){return this._isCanceled;}}]);return P;}();Object.setPrototypeOf(P.prototype,Promise.prototype);P.CancelError=C;return P;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('jquery.sap.act',['sap/ui/util/ActivityDetection','jquery.sap.global'],function(A,q){"use strict";q.sap.act=A;return q;});
sap.ui.predefine('jquery.sap.encoder',['jquery.sap.global','sap/base/security/encodeXML','sap/base/security/encodeJS','sap/base/security/encodeURL','sap/base/security/encodeURLParameters','sap/base/security/encodeCSS','sap/base/security/URLListValidator','sap/base/security/URLWhitelist','sap/base/security/sanitizeHTML'],function(q,e,a,b,c,d,U,f,s){"use strict";q.sap.encodeHTML=e;q.sap.encodeXML=e;q.sap.escapeHTML=e;q.sap.encodeJS=a;q.sap.escapeJS=a;q.sap.encodeURL=b;q.sap.encodeURLParameters=c;q.sap.encodeCSS=d;q.sap.clearUrlWhitelist=U.clear;q.sap.addUrlWhitelist=U.add.bind(f);
q.sap.removeUrlWhitelist=function(i){U._delete(U.entries()[i]);};
q.sap.getUrlWhitelist=U.entries;q.sap.validateUrl=U.validate;q.sap._sanitizeHTML=s;return q;});
sap.ui.predefine('jquery.sap.events',['jquery.sap.global','sap/ui/events/ControlEvents','sap/ui/events/PseudoEvents','sap/ui/events/checkMouseEnterOrLeave','sap/ui/events/isSpecialKey','sap/ui/events/isMouseEventDelayed','sap/ui/events/F6Navigation','sap/ui/events/jquery/EventSimulation','sap/ui/events/KeyCodes','sap/base/util/defineCoupledProperty','sap/ui/events/jquery/EventExtension'],function(q,C,P,c,i,I,F,E,K,d){"use strict";q.sap.PseudoEvents=P.events;q.sap.ControlEvents=C.events;q.sap.disableTouchToMouseHandling=E.disableTouchToMouseHandling;d(q.sap,"touchEventMode",E,"touchEventMode");q.sap.bindAnyEvent=C.bindAnyEvent;q.sap.unbindAnyEvent=C.unbindAnyEvent;q.sap.checkMouseEnterOrLeave=c;
q.sap.isSpecialKey=function(e){if(e.key){return i(e);}function a(e){var k=e.which;return(k===K.SHIFT)||(k===K.CONTROL)||(k===K.ALT)||(k===K.CAPS_LOCK)||(k===K.NUM_LOCK);}function b(e){var k=e.which,A=(k>=37&&k<=40);switch(e.type){case"keydown":case"keyup":return A;case"keypress":return k===0;default:return false;}}var k=e.which,s=a(e)||b(e)||(k>=33&&k<=36)||(k>=44&&k<=46)||(k>=112&&k<=123)||(k===K.BREAK)||(k===K.BACKSPACE)||(k===K.TAB)||(k===K.ENTER)||(k===K.ESCAPE)||(k===K.SCROLL_LOCK);switch(e.type){case"keydown":case"keyup":return s;case"keypress":return(k===0||k===K.BACKSPACE||k===K.ESCAPE||k===K.ENTER)||false;default:return false;}};
q.sap.handleF6GroupNavigation=function(e,s){if(!e.key&&e.keyCode===K.F6){e.key="F6";}return F.handleF6GroupNavigation(e,s);};
q.sap._FASTNAVIGATIONKEY=F.fastNavigationKey;
q.sap._refreshMouseEventDelayedFlag=function(n){q.sap.isMouseEventDelayed=I.apply(this,arguments);};
q.sap._refreshMouseEventDelayedFlag(navigator);return q;});
sap.ui.predefine('jquery.sap.history',["jquery.sap.global","sap/base/Log","sap/base/util/uid","sap/base/strings/escapeRegExp"],function(q,L,u,e){"use strict";(function(w){var s="_skip",r=/\|id-[0-9]+-[0-9]+/,a=new RegExp(s+"[0-9]*$"),b=[],h=[],S={},c=0,d,I="|",H=[],f=false,g,j=false;
q.sap.history=function(B){if(!q.isPlainObject(B)){return;}if(!j){var W=q(w),C=(w.location.href.split("#")[1]||"");W.on('hashchange',l);if(Array.isArray(B.routes)){var i,D;for(i=0;i<B.routes.length;i++){D=B.routes[i];if(D.path&&D.handler){q.sap.history.addRoute(D.path,D.handler);}}}if(typeof B.defaultHandler==="function"){g=B.defaultHandler;}h.push(C);if(C.length>1){W.trigger("hashchange",[true]);}else{d=C;}j=true;}};
q.sap.history.addHistory=function(i,B,C,V){var U,D;if(C===undefined){C=true;}if(!V){D=p(i,B);U=o(D);if(U){D+=(I+U);}D+=(I+(C?"1":"0"));}else{D=n(d);}H.push(D);S[D]=true;w.location.hash=D;return D;};
q.sap.history.addVirtualHistory=function(){q.sap.history.addHistory("",undefined,false,true);};
q.sap.history.addRoute=function(i,B,T){if(T){B=q.proxy(B,T);}var R={};R.sIdentifier=i;R['action']=B;b.push(R);return this;};
q.sap.history.setDefaultHandler=function(i){g=i;};
q.sap.history.getDefaultHandler=function(){return g;};
q.sap.history.backToHash=function(i){i=i||"";var B;if(h.length===1){if(typeof g==="function"){g();}}else{B=k(d,i);if(B<0){w.history.go(B);}else{L.error("jQuery.sap.history.backToHash: "+i+"is not in the history stack or it's after the current hash");}}};
q.sap.history.backThroughPath=function(P){P=P||"";P=w.encodeURIComponent(P);var i;if(h.length===1){if(typeof g==="function"){g();}}else{i=k(d,P,true);if(i<0){w.history.go(i);}else{L.error("jQuery.sap.history.backThroughPath: there's no history state which has the "+P+" identifier in the history stack before the current hash");}}};
q.sap.history.back=function(i){if(h.length===1){if(typeof g==="function"){g(q.sap.history.NavType.Back);}}else{if(!i){i=1;}w.history.go(-1*i);}};
q.sap.history.NavType={Back:"_back",Forward:"_forward",Bookmark:"_bookmark",Unknown:"_unknown"};
function k(C,T,P){var B=h.indexOf(C),D,i,E;if(B>0){if(P){for(i=B-1;i>=0;i--){E=h[i];if(E.indexOf(T)===0&&!v(E)){return i-B;}}}else{D=h.indexOf(T);if((D===-1)&&T.length===0){return-1*B;}if((D>-1)&&(D<B)){return D-B;}}}return 0;}
function l(E,M){var i=(w.location.href.split("#")[1]||"");i=m(i);if(M||!S[i]){H.push(i);}if(!f){f=true;if(H.length>0){var B=H.shift();if(S[B]){t(B);delete S[B];}else{y(B);}d=B;}f=false;}}
function m(i,R){var B=i,C=i?i.indexOf("#"):-1;if(C===0){B=B.slice(C+1);}if(R){B=B.replace(r,"");}return B;}
function n(i){var P=i?i:"";if(v(P)){var B=P.lastIndexOf(s);P=P.slice(0,B);}return P+s+c++;}
function p(i,B){var E=encodeURIComponent(i);var C=encodeURIComponent(JSON.stringify(B));return E+I+C;}
function o(B){var C=h.indexOf(d),i,D;if(C>-1){for(i=0;i<C+1;i++){D=h[i];if(D.slice(0,D.length-2)===B){return u();}}}return"";}
function t(i){var B=h.indexOf(d);if(!(B===-1||B===h.length-1)){h.splice(B+1,h.length-1-B);}h.push(i);}
function v(i){return a.test(i);}
function x(C,F){var B=h.indexOf(C),i;if(B!==-1){if(F){for(i=B;i<h.length;i++){if(!v(h[i])){return i-B;}}}else{for(i=B;i>=0;i--){if(!v(h[i])){return i-B;}}return-1*(B+1);}}}
function y(i){var R,B,P,N,C;if(d===undefined){P=A(i);if(!P||!P.bBookmarkable){if(typeof g==="function"){g(q.sap.history.NavType.Bookmark);}return;}}if(i.length===0){if(typeof g==="function"){g(q.sap.history.NavType.Back);}}else{N=h.indexOf(i);if(N===0){P=A(i);if(!P||!P.bBookmarkable){if(typeof g==="function"){g(q.sap.history.NavType.Back);}return;}}if(v(i)){if(v(d)){B=x(i,false);w.history.go(B);}else{var D=new RegExp(e(d+s)+"[0-9]*$");if(D.test(i)){B=x(i,true);if(B){w.history.go(B);}else{w.history.back();}}else{B=x(i,false);w.history.go(B);}}}else{if(N===-1){C=q.sap.history.NavType.Unknown;h.push(i);}else{if(h.indexOf(d,N+1)===-1){C=q.sap.history.NavType.Forward;}else{C=q.sap.history.NavType.Back;}}P=A(i);if(P){R=z(P.sIdentifier);if(R){R.action.apply(null,[P.oStateData,C]);}}else{L.error("hash format error! The current Hash: "+i);}}}}
function z(B){var i;for(i=0;i<b.length;i++){if(b[i].sIdentifier===B){return b[i];}}}
function A(B){if(v(B)){var i=B.lastIndexOf(s);B=B.slice(0,i);}var P=B.split(I),R={};if(P.length===4||P.length===3){R.sIdentifier=w.decodeURIComponent(P[0]);R.oStateData=JSON.parse(w.decodeURIComponent(P[1]));if(P.length===4){R.uid=P[2];}R.bBookmarkable=P[P.length-1]==="0"?false:true;return R;}else{return null;}}
})(this);return q;});
sap.ui.predefine('jquery.sap.keycodes',['jquery.sap.global','sap/ui/events/KeyCodes'],function(q,K){"use strict";q.sap.KeyCodes=K;return q;});
sap.ui.predefine('jquery.sap.mobile',['jquery.sap.global','sap/ui/util/Mobile','sap/ui/Device'],function(q,M,D){"use strict";
function g(t,p){var d=Object.getOwnPropertyDescriptor(t,p);return d&&d.value;}
(function(){q.os=q.extend({os:D.os.name,version:D.os.versionStr,fVersion:D.os.version},g(q,"os"));q.os[D.os.name]=true;q.device=q.extend({},g(q,"device"));q.device.is=q.extend({standalone:window.navigator.standalone,landscape:D.orientation.landscape,portrait:D.orientation.portrait,iphone:D.os.ios&&D.system.phone,ipad:D.os.ios&&D.system.tablet,android_phone:D.system.phone&&D.os.android,android_tablet:D.system.tablet&&D.os.android,tablet:D.system.tablet,phone:D.system.phone,desktop:D.system.desktop},q.device.is);})();q.sap.initMobile=M.init;q.sap.setIcons=M.setIcons;q.sap.setMobileWebAppCapable=M.setWebAppCapable;return q;});
sap.ui.predefine('jquery.sap.promise',[],function(){"use strict";});
sap.ui.predefine('jquery.sap.properties',['jquery.sap.global','sap/base/util/Properties'],function(q,P){"use strict";q.sap.properties=P.create;return q;});
sap.ui.predefine('jquery.sap.resources',['sap/base/i18n/ResourceBundle','jquery.sap.global'],function(R,q){"use strict";
q.sap.resources=function(){return R.create.apply(R,arguments);};
q.sap.resources.isBundle=function(b){return b instanceof R;};
q.sap.resources._getFallbackLocales=R._getFallbackLocales;return q;});
sap.ui.predefine('jquery.sap.sjax',['jquery.sap.global'],function(q){"use strict";q.sap.sjaxSettings={complexResult:true,fallback:undefined};
q.sap.sjax=function a(o){var s=q.extend(true,{},q.sap.sjaxSettings,o,{async:false,success:function(d,t,x){r={success:true,data:d,status:t,statusCode:x&&x.status};},error:function(x,t,e){r={success:false,data:undefined,status:t,error:e,statusCode:x.status,errorResponse:x.responseText};}});var r;q.ajax(s);if(!s.complexResult){return r.success?r.data:s.fallback;}return r;};
q.sap.syncHead=function(u){return q.sap.sjax({type:'HEAD',url:u}).success;};
q.sap.syncGet=function s(u,d,D){return q.sap.sjax({url:u,data:d,type:'GET',dataType:D||'text'});};
q.sap.syncPost=function s(u,d,D){return q.sap.sjax({url:u,data:d,type:'POST',dataType:D||'text'});};
q.sap.syncGetText=function s(u,d,f){return q.sap.sjax({url:u,data:d,type:'GET',dataType:'text',fallback:f,complexResult:(arguments.length<3)});};
q.sap.syncGetJSON=function s(u,d,f){return q.sap.sjax({url:u,data:d||null,type:'GET',dataType:'json',fallback:f,complexResult:(arguments.length<3)});};
return q;});
sap.ui.predefine('jquery.sap.storage',['jquery.sap.global','sap/base/assert','sap/ui/util/Storage'],function(q,a,S){"use strict";var s={};
q.sap.storage=function(o,i){if(!o){o=S.Type.session;}if(typeof(o)==="string"&&S.Type[o]){var k=o;if(i&&i!="state.key_"){k=o+"_"+i;}if(!s[k]){s[k]=new S(o,i);}return s[k];}a(o instanceof Object&&o.clear&&o.setItem&&o.getItem&&o.removeItem,"storage: duck typing the storage");return new S(o,i);};
q.sap.storage.Storage=S;q.sap.storage.Type=S.Type;Object.assign(q.sap.storage,S);return q;});
sap.ui.predefine('jquery.sap.strings',['jquery.sap.global','sap/base/strings/capitalize','sap/base/strings/camelize','sap/base/strings/hyphenate','sap/base/strings/escapeRegExp','sap/base/strings/formatMessage'],function(q,c,a,h,e,f){"use strict";
q.sap.endsWith=function(s,E){if(typeof(E)!="string"||E==""){return false;}return s.endsWith(E);};
q.sap.endsWithIgnoreCase=function(s,E){if(typeof(E)!="string"||E==""){return false;}s=s.toUpperCase();E=E.toUpperCase();return s.endsWith(E);};
q.sap.startsWith=function(s,S){if(typeof(S)!="string"||S==""){return false;}return s.startsWith(S);};
q.sap.startsWithIgnoreCase=function(s,S){if(typeof(S)!="string"||S==""){return false;}s=s.toUpperCase();S=S.toUpperCase();return s.startsWith(S);};
q.sap.charToUpperCase=function(s,p){if(!s){return s;}if(!p||isNaN(p)||p<=0||p>=s.length){return c(s);}var C=s.charAt(p).toUpperCase();if(p>0){return s.substring(0,p)+C+s.substring(p+1);}return C+s.substring(p+1);};
q.sap.padLeft=function(s,p,l){if(!s){s="";}if(p&&p.length===1){return s.padStart(l,p);}while(s.length<l){s=p+s;}return s;};
q.sap.padRight=function(s,p,l){if(!s){s="";}if(p&&p.length===1){return s.padEnd(l,p);}while(s.length<l){s=s+p;}return s;};
q.sap.camelCase=a;q.sap.hyphen=h;q.sap.escapeRegExp=e;q.sap.formatMessage=f;return q;});
sap.ui.predefine('jquery.sap.trace',['jquery.sap.global','sap/ui/performance/trace/Passport','sap/ui/performance/trace/Interaction','sap/ui/performance/trace/FESR','sap/base/Log','sap/ui/Global'],function(q,P,I,F,L){"use strict";
function l(){if(!(window.performance&&window.performance.getEntries)){L.warning("Interaction tracking is not supported on browsers with insufficient performance API");}}
q.sap.interaction={};
q.sap.interaction.setActive=function(){l();I.setActive.apply(this,arguments);};
q.sap.interaction.getActive=I.getActive;q.sap.interaction.notifyStepStart=I.notifyStepStart;q.sap.interaction.notifyStepEnd=I.notifyStepEnd;q.sap.interaction.notifyEventStart=I.notifyEventStart;q.sap.interaction.notifyScrollEvent=I.notifyScrollEvent;q.sap.interaction.notifyEventEnd=I.notifyEventEnd;q.sap.interaction.setStepComponent=I.setStepComponent;q.sap.fesr={};
q.sap.fesr.setActive=function(){l();F.setActive.apply(this,arguments);};
q.sap.fesr.getActive=F.getActive;q.sap.fesr.getCurrentTransactionId=P.getTransactionId;q.sap.fesr.getRootId=P.getRootId;q.sap.fesr.addBusyDuration=I.addBusyDuration;q.sap.passport={};q.sap.passport.setActive=P.setActive;q.sap.passport.traceFlags=P.traceFlags;
function g(){var a=!!document.querySelector("meta[name=sap-ui-fesr][content=true]"),p=window.location.search.match(/[\?|&]sap-ui-(?:xx-)?fesr=(true|x|X|false)&?/);if(p){a=p[1]&&p[1]!="false";}return a;}
q.sap.interaction.notifyStepStart(null,true);F.setActive(g());if(/sap-ui-xx-e2e-trace=(true|x|X)/.test(location.search)){sap.ui.requireSync("sap/ui/core/support/trace/E2eTraceLib");}return q;});
sap.ui.predefine('jquery.sap.ui',['jquery.sap.global','sap/base/util/ObjectPath','sap/ui/dom/jquery/control'],function(q,O){"use strict";
function f(c){return c.getUIArea().getInterface();}
function u(){return sap.ui.getCore().getUIArea(this.id)!=null;}
function a(){return sap.ui.getCore().getUIArea(this.id);}
q.fn.root=function(r){if(r){sap.ui.getCore().setRoot(this.get(0),r);return this;}var c=this.control();if(c.length>0){return c.map(f);}var U=this.uiarea();if(U.length>0){return U;}this.each(function(){sap.ui.getCore().createUIArea(this);});return this;};
q.fn.uiarea=function(i){var U=this.slice("[id]").filter(u).map(a).get();return typeof(i)==="number"?U[i]:U;};
q.fn.sapui=function(c,i,C){return this.each(function(){var o=null;if(this){if(c.indexOf(".")==-1){c="sap.ui.commons."+c;}var b=O.get(c);if(b){if(typeof C=='object'&&typeof C.press=='function'){C.press=q.proxy(C.press,this);}o=new(b)(i,C);o.placeAt(this);}}});};
return q;});
sap.ui.predefine('jquery.sap.xml',['jquery.sap.global','sap/ui/util/XMLHelper'],function(q,X){"use strict";q.sap.parseXML=X.parse;
q.sap.serializeXML=function(x){var s="";if(window.ActiveXObject){s=x.xml;if(s){return s;}}if(window.XMLSerializer){return X.serialize(x);}return s;};
q.sap.isEqualNode=function(n,N){if(n===N){return true;}if(!n||!N){return false;}if(n.isEqualNode){return n.isEqualNode(N);}if(n.nodeType!=N.nodeType){return false;}if(n.nodeValue!=N.nodeValue){return false;}if(n.baseName!=N.baseName){return false;}if(n.nodeName!=N.nodeName){return false;}if(n.nameSpaceURI!=N.nameSpaceURI){return false;}if(n.prefix!=N.prefix){return false;}if(n.nodeType!=1){return true;}if(n.attributes.length!=N.attributes.length){return false;}for(var i=0;i<n.attributes.length;i++){if(!q.sap.isEqualNode(n.attributes[i],N.attributes[i])){return false;}}if(n.childNodes.length!=N.childNodes.length){return false;}for(var i=0;i<n.childNodes.length;i++){if(!q.sap.isEqualNode(n.childNodes[i],N.childNodes[i])){return false;}}return true;};
q.sap.getParseError=X.getParseError;return q;});
sap.ui.predefine('sap/base/security/URLListValidator',[],function(){"use strict";var r=/^(?:([^:\/?#]+):)?((?:\/\/((?:\[[^\]]+\]|[^\/?#:]+))(?::([0-9]+))?)?([^?#]*))(?:\?([^#]*))?(?:#(.*))?$/;var a=/^([a-z0-9-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*$/i;var b=/^([a-z0-9-._~!$&'()*+,;=:@\/?]|%[0-9a-f]{2})*$/i;var c=b;var d=/^([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+(?:\.([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i;var e=/^([0-9]{1,3}\.){3}[0-9]{1,3}$/;var f=/^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/;var g=/^\[[^\]]+\]$/;var h=/^\[(((([0-9a-f]{1,4}:){6}|(::([0-9a-f]{1,4}:){5})|(([0-9a-f]{1,4})?::([0-9a-f]{1,4}:){4})|((([0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){3})|((([0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){2})|((([0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:)|((([0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::))(([0-9a-f]{1,4}:[0-9a-f]{1,4})|(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])))|((([0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4})|((([0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::))\]$/i;var j=/^([a-z0-9]([a-z0-9\-]*[a-z0-9])?\.)*[a-z0-9]([a-z0-9\-]*[a-z0-9])?$/i;var u={};
u._createEntry=function(p,i,k,l){return new U(p,i,k,l);};
function U(p,i,k,l){Object.defineProperties(this,{protocol:{value:p&&p.toUpperCase(),enumerable:true},host:{value:i&&i.toUpperCase(),enumerable:true},port:{value:k,enumerable:true},path:{value:l,enumerable:true}});}
var A=[];
u.clear=function(){A=[];};
u.add=function(p,i,k,l){var E=this._createEntry(p,i,k,l);A.push(E);};
u._delete=function(E){A.splice(A.indexOf(E),1);};
u.entries=function(){return A.slice();};
u.validate=function(s){var k=r.exec(s);if(!k){return false;}var p=k[1],B=k[2],H=k[3],P=k[4],l=k[5],q=k[6],m=k[7];if(p){p=p.toUpperCase();if(A.length<=0){if(!/^(https?|ftp)/i.test(p)){return false;}}}if(H){if(e.test(H)){if(!f.test(H)){return false;}}else if(g.test(H)){if(!h.test(H)){return false;}}else if(!j.test(H)){return false;}H=H.toUpperCase();}if(l){if(p==="MAILTO"){var n=B.split(",");for(var i=0;i<n.length;i++){if(!d.test(n[i])){return false;}}}else{var C=l.split("/");for(var i=0;i<C.length;i++){if(!a.test(C[i])){return false;}}}}if(q){if(!b.test(q)){return false;}}if(m){if(!c.test(m)){return false;}}if(A.length>0){var F=false;for(var i=0;i<A.length;i++){if(!p||!A[i].protocol||p==A[i].protocol){var o=false;if(H&&A[i].host&&/^\*/.test(A[i].host)){if(!A[i]._hostRegexp){var t=A[i].host.slice(1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");A[i]._hostRegexp=RegExp(t+"$");}var v=A[i]._hostRegexp;if(v.test(H)){o=true;}}else if(!H||!A[i].host||H==A[i].host){o=true;}if(o){if((!H&&!P)||!A[i].port||P==A[i].port){if(A[i].path&&/\*$/.test(A[i].path)){if(!A[i]._pathRegexp){var w=A[i].path.slice(0,-1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");A[i]._pathRegexp=RegExp("^"+w);}var v=A[i]._pathRegexp;if(v.test(l)){F=true;}}else if(!A[i].path||l==A[i].path){F=true;}}}}if(F){break;}}if(!F){return false;}}return true;};
return u;});
sap.ui.predefine('sap/base/security/URLWhitelist',["sap/base/security/URLListValidator"],function(U){"use strict";return{"add":U.add,"delete":U._delete,"clear":U.clear,"entries":U.entries,"validate":U.validate,"_createEntry":function(p,h,a,b){return{protocol:p&&p.toUpperCase(),host:h&&h.toUpperCase(),port:a,path:b};}};});
sap.ui.predefine('sap/base/security/encodeJS',["sap/base/strings/toHex"],function(t){"use strict";var r=/[\x00-\x2b\x2d\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,j={};var J=function(c){var E=j[c];if(!E){var C=c.charCodeAt(0);if(C<256){E="\\x"+t(C,2);}else{E="\\u"+t(C,4);}j[c]=E;}return E;};var e=function(s){return s.replace(r,J);};return e;});
sap.ui.predefine('sap/base/security/encodeURL',["sap/base/strings/toHex"],function(t){"use strict";var r=/[\ud800-\udbff][\udc00-\udfff]|[\x00-\x2c\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\uffff]/g,u={};var U=function(c){var E=u[c];if(!E){var C=c.codePointAt(0);if(C<128){E="%"+t(C,2);}else if(C<2048){E="%"+t((C>>6)|192,2)+"%"+t((C&63)|128,2);}else if(C<65536){E="%"+t((C>>12)|224,2)+"%"+t(((C>>6)&63)|128,2)+"%"+t((C&63)|128,2);}else{E="%"+t((C>>18)|240,2)+"%"+t(((C>>12)&63)|128,2)+"%"+t(((C>>6)&63)|128,2)+"%"+t((C&63)|128,2);}u[c]=E;}return E;};var e=function(s){return s.replace(r,U);};return e;});
sap.ui.predefine('sap/base/security/encodeURLParameters',["./encodeURL"],function(e){"use strict";var E=function(p){if(!p){return"";}var u=[];Object.keys(p).forEach(function(n){var v=p[n];if(v instanceof String||typeof v==="string"){v=e(v);}u.push(e(n)+"="+v);});return u.join("&");};return E;});
sap.ui.predefine('sap/base/security/sanitizeHTML',["sap/base/assert","sap/base/security/URLListValidator","sap/ui/thirdparty/caja-html-sanitizer"],function(a,U){"use strict";var s=function(h,o){a(window.html&&window.html.sanitize,"Sanitizer should have been loaded");o=o||{uriRewriter:function(u){if(U.validate(u)){return u;}}};var t=o.tagPolicy||window.html.makeTagPolicy(o.uriRewriter,o.tokenPolicy);return window.html.sanitizeWithPolicy(h,t);};return s;});
sap.ui.predefine('sap/base/strings/camelize',[],function(){"use strict";var r=/-(.)/ig;var c=function(s){return s.replace(r,function(m,C){return C.toUpperCase();});};return c;});
sap.ui.predefine('sap/base/strings/capitalize',[],function(){"use strict";var c=function(s){return s.charAt(0).toUpperCase()+s.substring(1);};return c;});
sap.ui.predefine('sap/base/strings/hyphenate',[],function(){"use strict";var r=/([A-Z])/g;var h=function(s){return s.replace(r,function(m,c){return"-"+c.toLowerCase();});};return h;});
sap.ui.predefine('sap/base/strings/whitespaceReplacer',[],function(){"use strict";var w=function(i){var W=" ",u="\u00A0";if(typeof i!=="string"){return i;}return i.replaceAll("\t",W+W).replaceAll((W+W),(W+u));};return w;});
sap.ui.predefine('sap/base/util/Deferred',[],function(){"use strict";var D=function(){var t=this;this.promise=new Promise(function(r,a){t.resolve=r;t.reject=a;});};return D;});
sap.ui.predefine('sap/base/util/defineCoupledProperty',[],function(){"use strict";var d=function(t,T,s,S){var v=s[S];var p={configurable:true,get:function(){return v;},set:function(_){v=_;}};Object.defineProperty(t,T,p);Object.defineProperty(s,S,p);};return d;});
sap.ui.predefine('sap/base/util/includes',["sap/base/util/values"],function(v){"use strict";var i=function(c,V,f){if(typeof f!=='number'){f=0;}if(Array.isArray(c)||typeof c==='string'){if(f<0){f=(c.length+f)<0?0:c.length+f;}return c.includes(V,f);}else{return i(v(c),V,f);}};return i;});
sap.ui.predefine('sap/base/util/restricted/_castArray',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.castArray;});
sap.ui.predefine('sap/base/util/restricted/_compact',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.compact;});
sap.ui.predefine('sap/base/util/restricted/_curry',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.curry;});
sap.ui.predefine('sap/base/util/restricted/_debounce',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.debounce;});
sap.ui.predefine('sap/base/util/restricted/_difference',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.difference;});
sap.ui.predefine('sap/base/util/restricted/_differenceBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.differenceBy;});
sap.ui.predefine('sap/base/util/restricted/_differenceWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.differenceWith;});
sap.ui.predefine('sap/base/util/restricted/_flatMap',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMap;});
sap.ui.predefine('sap/base/util/restricted/_flatMapDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMapDeep;});
sap.ui.predefine('sap/base/util/restricted/_flatMapDepth',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMapDepth;});
sap.ui.predefine('sap/base/util/restricted/_flatten',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatten;});
sap.ui.predefine('sap/base/util/restricted/_flattenDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flattenDeep;});
sap.ui.predefine('sap/base/util/restricted/_flattenDepth',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flattenDepth;});
sap.ui.predefine('sap/base/util/restricted/_intersection',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersection;});
sap.ui.predefine('sap/base/util/restricted/_intersectionBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersectionBy;});
sap.ui.predefine('sap/base/util/restricted/_intersectionWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersectionWith;});
sap.ui.predefine('sap/base/util/restricted/_isEqual',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isEqual;});
sap.ui.predefine('sap/base/util/restricted/_isEqualWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isEqualWith;});
sap.ui.predefine('sap/base/util/restricted/_isNil',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isNil;});
sap.ui.predefine('sap/base/util/restricted/_max',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.max;});
sap.ui.predefine('sap/base/util/restricted/_merge',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.merge;});
sap.ui.predefine('sap/base/util/restricted/_mergeWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.mergeWith;});
sap.ui.predefine('sap/base/util/restricted/_min',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.min;});
sap.ui.predefine('sap/base/util/restricted/_omit',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.omit;});
sap.ui.predefine('sap/base/util/restricted/_pick',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.pick;});
sap.ui.predefine('sap/base/util/restricted/_pickBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.pickBy;});
sap.ui.predefine('sap/base/util/restricted/_throttle',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.throttle;});
sap.ui.predefine('sap/base/util/restricted/_toArray',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.toArray;});
sap.ui.predefine('sap/base/util/restricted/_union',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.union;});
sap.ui.predefine('sap/base/util/restricted/_unionBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.unionBy;});
sap.ui.predefine('sap/base/util/restricted/_unionWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.unionWith;});
sap.ui.predefine('sap/base/util/restricted/_uniq',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniq;});
sap.ui.predefine('sap/base/util/restricted/_uniqBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniqBy;});
sap.ui.predefine('sap/base/util/restricted/_uniqWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniqWith;});
sap.ui.predefine('sap/base/util/restricted/_without',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.without;});
sap.ui.predefine('sap/base/util/restricted/_xor',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xor;});
sap.ui.predefine('sap/base/util/restricted/_xorBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xorBy;});
sap.ui.predefine('sap/base/util/restricted/_xorWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xorWith;});
sap.ui.predefine('sap/base/util/restricted/_zipObject',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.zipObject;});
sap.ui.predefine('sap/base/util/restricted/_zipObjectDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.zipObjectDeep;});
sap.ui.predefine('sap/base/util/values',function(){"use strict";var v=function a(o){if(typeof o==="undefined"||o===null||o!==o){return[];}return Object.values(o);};return v;});
sap.ui.predefine('sap/ui/app/Application',['sap/base/assert','./ApplicationMetadata','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/model/Model','sap/ui/model/json/JSONModel','jquery.sap.sjax'],function(a,A,C,b,M,J,q){"use strict";
var c=C.extend("sap.ui.app.Application",{
metadata:{"abstract":true,properties:{root:"string",config:"any"},aggregations:{rootComponent:{type:"sap.ui.core.UIComponent",multiple:false}},publicMethods:["getView"],deprecated:true},
constructor:function(i,s){if(this.onError){this.onWindowError=this.onError;}if(this.onBeforeExit){this.onWindowBeforeUnload=this.onBeforeExit;}if(this.onExit){this.onWindowUnload=this.onExit;}C.apply(this,arguments);if(sap.ui.getApplication){throw new Error("Only one instance of sap.ui.app.Application is allowed");}sap.ui.getApplication=this._getInstance.bind(this);sap.ui.getCore().attachInit(function(){this._initRootComponent();this.main();}.bind(this));},
_initRootComponent:function(){var r=this.createRootComponent();if(r){this.setRootComponent(r);var o=new b({component:r});o.placeAt(this.getRoot()||document.body);}},
createRootComponent:function(){var r=this.getMetadata().getRootComponent();var R;if(r){R=sap.ui.component({name:r});}return R;},
getView:function(){return this.getRootComponent();},
_getInstance:function(){return this;},
main:function(){},
onBeforeExit:function(){},
onExit:function(){},
onError:null,
setConfig:function(v){if(typeof v==="string"){var u=v;v=new J();var r=q.sap.sjax({url:u,dataType:'json'});if(r.success){v.setData(r.data);}else{throw new Error("Could not load config file: "+u);}}if(typeof v==="object"&&!(v instanceof M)){v=new J(v);}a(v instanceof M,"the config property value must be a string, an object or an instance of sap.ui.model.Model");this.setProperty("config",v);},
destroy:function(s){delete sap.ui.getApplication;C.prototype.destroy.apply(this,arguments);}
},A);
return c;});
sap.ui.predefine('sap/ui/app/ApplicationMetadata',['sap/base/Log','sap/ui/core/ComponentMetadata','jquery.sap.sjax'],function(L,C,q){"use strict";var A=function(c,o){C.apply(this,arguments);};A.prototype=Object.create(C.prototype);A.prototype.constructor=A;
A.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
A.prototype.applySettings=function(c){var s=c.metadata;C.prototype.applySettings.call(this,c);if(s._src){L.warning("The metadata of the application "+this.getName()+" is loaded from file "+s._src+". This is a design time feature and not for productive usage!");var p=this.getName().replace(/\.\w+?$/,"");var u=sap.ui.require.toUrl(p.replace(/\./g,"/")+"/"+s._src);var r=q.sap.syncGetJSON(u);if(r.success){Object.assign(s,r.data);}else{L.error("Failed to load application metadata from \""+s._src+"\"! Reason: "+r.error);}}this._mRootComponent=s.rootComponent||null;};
A.prototype.getRootComponent=function(){return this._mRootComponent;};
return A;},true);
sap.ui.predefine('sap/ui/app/MockServer',['jquery.sap.global','sap/ui/core/util/MockServer'],function(q,M){"use strict";var a=M;return a;},true);
sap.ui.predefine('sap/ui/core/AppCacheBuster',['sap/ui/base/ManagedObject','sap/ui/thirdparty/URI','sap/base/Log','sap/base/util/extend','sap/base/strings/escapeRegExp','sap/ui/thirdparty/jquery','sap/ui/core/_IconRegistry','./Core'],function(M,U,L,a,b,q,_){"use strict";var c=sap.ui.getCore().getConfiguration();var l=c.getLanguage();var s=c.getAppCacheBusterMode()==="sync";var B=c.getAppCacheBusterMode()==="batch";var S={index:{},active:false};var v,d,f,x,E;var g=document.baseURI.replace(/\?.*|#.*/g,"");var u=U(sap.ui.require.toUrl("")+"/../");var o=u.toString();if(u.is("relative")){u=u.absoluteTo(g);}var h=u.normalize().toString();var r=U("resources").absoluteTo(h).toString();var F=new RegExp("^"+b(r));var i=function(e){if(e.length>0&&e.slice(-1)!=="/"){e+="/";}return e;};var R=function(h,e){var I=S.index;var j;var k;var m;if(Array.isArray(h)&&!B){h.forEach(function(D){R(D,e);});}else if(Array.isArray(h)&&B){var n=i(h[0]);var C=[];L.debug("sap.ui.core.AppCacheBuster.register(\""+n+"\"); // BATCH MODE!");var p=A.normalizeURL(n);L.debug("  --> normalized to: \""+p+"\"");h.forEach(function(D){k=i(D);var G=A.normalizeURL(k);if(!I[m]){C.push(G);}});if(C.length>0){var k=p+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,type:"POST",async:!s&&!!e,dataType:"json",contentType:"text/plain",data:C.join("\n"),success:function(D){A.onIndexLoaded(k,D);a(I,D);},error:function(){L.error("Failed to batch load AppCacheBuster index file from: \""+k+"\".");}};}}else{h=i(h);L.debug("sap.ui.core.AppCacheBuster.register(\""+h+"\");");m=A.normalizeURL(h);L.debug("  --> normalized to: \""+m+"\"");if(!I[m]){var k=m+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,async:!s&&!!e,dataType:"json",success:function(D){A.onIndexLoaded(k,D);I[m]=D;},error:function(){L.error("Failed to load AppCacheBuster index file from: \""+k+"\".");}};}}if(j){var t=A.onIndexLoad(j.url);if(t!=null){L.info("AppCacheBuster index file injected for: \""+k+"\".");j.success(t);}else{if(j.async){var w=e.startTask("load "+k);var y=j.success,z=j.error;Object.assign(j,{success:function(D){y.apply(this,arguments);e.finishTask(w);},error:function(){z.apply(this,arguments);e.finishTask(w,false);}});}L.info("Loading AppCacheBuster index file from: \""+k+"\".");q.ajax(j);}}};var A={boot:function(e){var C=c.getAppCacheBuster();if(C&&C.length>0){C=C.slice();var j=true;var V=String(C[0]).toLowerCase();if(C.length===1){if(V==="true"||V==="x"){var u=U(o);C=u.is("relative")?[u.toString()]:[];}else if(V==="false"){j=false;}}if(j){A.init();R(C,e);}}},init:function(){S.active=true;v=M.prototype.validateProperty;d=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");f=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href");var C=A.convertURL;var n=A.normalizeURL;var I=function(e){if(this.active===true&&e&&typeof(e)==="string"){e=n(e);return!e.match(F);}return false;}.bind(S);x=XMLHttpRequest.prototype.open;XMLHttpRequest.prototype.open=function(e,p){if(p&&I(p)){arguments[1]=C(p);}x.apply(this,arguments);};E=XMLHttpRequest.prototype.open;M.prototype.validateProperty=function(p,V){var t=this.getMetadata(),P=t.getProperty(p),w;if(P&&P.type==="sap.ui.core.URI"){w=Array.prototype.slice.apply(arguments);try{if(I(w[1])){w[1]=C(w[1]);}}catch(e){}}return v.apply(this,w||arguments);};_._convertUrl=function(e){return C(e);};var j=function(e){var p={get:e.get,set:function(t){if(I(t)){t=C(t);}e.set.call(this,t);},enumerable:e.enumerable,configurable:e.configurable};p.set._sapUiCoreACB=true;return p;};var k=false;try{Object.defineProperty(HTMLScriptElement.prototype,"src",j(d));}catch(m){L.error("Your browser doesn't support redefining the src property of the script tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}try{Object.defineProperty(HTMLLinkElement.prototype,"href",j(f));}catch(m){L.error("Your browser doesn't support redefining the href property of the link tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}if(k){this.exit();}},exit:function(){M.prototype.validateProperty=v;delete _._convertUrl;if(XMLHttpRequest.prototype.open===E){XMLHttpRequest.prototype.open=x;}var e;if((e=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLScriptElement.prototype,"src",d);}if((e=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLLinkElement.prototype,"href",f);}S.index={};S.active=false;S={index:{},active:false};},register:function(h){R(h);},convertURL:function(e){L.debug("sap.ui.core.AppCacheBuster.convertURL(\""+e+"\");");var I=S.index;if(I&&e&&!/^#/.test(e)){var n=A.normalizeURL(e);L.debug("  --> normalized to: \""+n+"\"");if(n&&A.handleURL(n)){for(var h in I){var m=I[h],j,k;if(h&&n.length>=h.length&&n.slice(0,h.length)===h){j=n.slice(h.length);k=j.match(/([^?#]*)/)[1];if(m[k]){e=h+"~"+m[k]+"~/"+j;L.debug("  ==> rewritten to \""+e+"\";");break;}}}}}return e;},normalizeURL:function(e){var u=U(e||"./");if(u.is("relative")){u=u.absoluteTo(g);}return u.normalizeProtocol().normalizeHostname().normalizePort().normalizePath().toString();},handleURL:function(e){return true;},onIndexLoad:function(e){return null;},onIndexLoaded:function(e,I){}};var H=c.getAppCacheBusterHooks();if(H){["handleURL","onIndexLoad","onIndexLoaded"].forEach(function(e){if(typeof H[e]==="function"){A[e]=H[e];}});}return A;},true);
sap.ui.predefine('sap/ui/core/BlockLayerUtils',['sap/ui/events/jquery/EventTriggerHook',"sap/base/Log","sap/ui/thirdparty/jquery"],function(E,L,q){"use strict";var B={},p=["focusin","focusout","keydown","keypress","keyup","mousedown","touchstart","touchmove","mouseup","touchend","click"],r=/^(?:area|base|br|col|embed|hr|img|input|keygen|link|menuitem|meta|param|source|track|wbr|tr)$/i;
B.block=function(c,b,s){var P,t,o,d;if(c){P=c.getDomRef(s);if(!P){P=c.getDomRef();}if(!P){L.warning("BlockLayer could not be rendered. The outer Control instance is not valid anymore or was not rendered yet.");return;}t=P.tagName;if(r.test(t)){L.warning("BusyIndicator cannot be placed in elements with tag '"+t+"'.");return;}d=a(P,b);o={$parent:q(P),$blockLayer:q(d)};if(o.$parent.css('position')=='static'){if(P.style&&P.style.position==="static"){o.originalPosition='static';}o.$parent.css('position','relative');o.positionChanged=true;}h.call(o,true);}else{L.warning("BlockLayer couldn't be created. No Control instance given.");}return o;};
B.unblock=function(b){if(b){if(b.originalPosition){b.$parent.css('position',b.originalPosition);}else if(b.positionChanged){b.$parent.css('position',"");}h.call(b,false);b.$blockLayer.remove();}};
B.addAriaAttributes=function(d){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");d.setAttribute("role","progressbar");d.setAttribute("aria-valuemin","0");d.setAttribute("aria-valuemax","100");d.setAttribute("aria-valuetext",R.getText("BUSY_VALUE_TEXT"));d.setAttribute("alt","");d.setAttribute("tabindex","0");d.setAttribute("title",R.getText("BUSY_TEXT"));};
B.toggleAnimationStyle=function(b,s){var $=q(b.$blockLayer.get(0));if(s){$.removeClass("sapUiHiddenBusyIndicatorAnimation");$.removeClass("sapUiBlockLayerOnly");}else{$.addClass("sapUiBlockLayerOnly");$.addClass("sapUiHiddenBusyIndicatorAnimation");}};
function a(b,s){var c=document.createElement("div");c.id=s;c.className="sapUiBlockLayer ";B.addAriaAttributes(c);b.appendChild(c);return c;}
function h(e){if(e){var P=this.$parent.get(0);if(P){this.fnRedirectFocus=b.bind(this);this.oTabbableBefore=c(this.fnRedirectFocus);this.oTabbableAfter=c(this.fnRedirectFocus);P.parentNode.insertBefore(this.oTabbableBefore,P);P.parentNode.insertBefore(this.oTabbableAfter,P.nextSibling);this._fnSuppressDefaultAndStopPropagationHandler=s.bind(this);this._aSuppressHandler=f.call(this,this._fnSuppressDefaultAndStopPropagationHandler);}else{L.warning("fnHandleInteraction called with bEnabled true, but no DOMRef exists!");}}else{if(this.oTabbableBefore){d(this.oTabbableBefore,this.fnRedirectFocus);delete this.oTabbableBefore;}if(this.oTabbableAfter){d(this.oTabbableAfter,this.fnRedirectFocus);delete this.oTabbableAfter;}delete this.fnRedirectFocus;g.call(this,this._fnSuppressDefaultAndStopPropagationHandler);}function s(o){var t=o.target===this.$blockLayer.get(0),T;if(t&&o.type==='keydown'&&o.keyCode===9){L.debug("Local Busy Indicator Event keydown handled: "+o.type);T=o.shiftKey?this.oTabbableBefore:this.oTabbableAfter;T.setAttribute("tabindex",-1);this.bIgnoreFocus=true;T.focus();this.bIgnoreFocus=false;T.setAttribute("tabindex",0);o.stopImmediatePropagation();}else if(t&&(o.type==='mousedown'||o.type==='touchstart')){L.debug("Local Busy Indicator click handled on busy area: "+o.target.id);o.stopImmediatePropagation();}else{L.debug("Local Busy Indicator Event Suppressed: "+o.type);o.preventDefault();o.stopImmediatePropagation();}}function b(){if(!this.bIgnoreFocus){this.$blockLayer.get(0).focus();}}function c(R){var o=document.createElement("span");o.setAttribute("tabindex",0);o.classList.add("sapUiBlockLayerTabbable");o.addEventListener('focusin',R);return o;}function d(o,R){if(o.parentNode){o.parentNode.removeChild(o);}o.removeEventListener('focusin',R);}function f(H){var S=[],P=this.$parent.get(0),o=this.$blockLayer.get(0);for(var i=0;i<p.length;i++){P.addEventListener(p[i],H,{capture:true,passive:false});S.push(E.suppress(p[i],P,o));}this.$blockLayer.on('keydown',H);return S;}function g(H){var i,P=this.$parent.get(0),o=this.$blockLayer.get(0);if(P){for(i=0;i<p.length;i++){P.removeEventListener(p[i],H,{capture:true,passive:false});}}if(this._aSuppressHandler){for(i=0;i<this._aSuppressHandler.length;i++){E.release(this._aSuppressHandler[i]);}}if(o){this.$blockLayer.off('keydown',H);}}}
return B;});
sap.ui.predefine('sap/ui/core/BusyIndicator',['sap/ui/thirdparty/jquery','../base/EventProvider','./Popup','./BusyIndicatorUtils','sap/ui/core/library',"sap/ui/performance/trace/FESR","sap/ui/performance/trace/Interaction","sap/base/Log","sap/base/assert","sap/base/util/now"],function(q,E,P,B,l,F,I,L,a,n){"use strict";var b=l.BusyIndicatorSize;var c=Object.assign(new E(),{oPopup:null,oDomRef:null,bOpenRequested:false,iDEFAULT_DELAY_MS:1000,sDOM_ID:"sapUiBusyIndicator"});c.M_EVENTS={Open:"Open",Close:"Close"};c._bShowIsDelayed=undefined;
c._init=function(){var r=document.createElement("div");r.id=this.sDOM_ID;var o=document.createElement("div");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var t=this._oResBundle.getText("BUSY_TEXT");delete this._oResBundle;o.className="sapUiBusy";o.setAttribute("tabindex","0");o.setAttribute("role","progressbar");o.setAttribute("alt","");o.setAttribute("title",t);r.appendChild(o);var d=B.getElement(b.Large);d.setAttribute("title",t);r.appendChild(d);this.oDomRef=r;this.oPopup=new P(r);this.oPopup.setModal(true,"sapUiBlyBusy");this.oPopup.setShadow(false);this.oPopup.attachOpened(function(e){this._onOpen(e);},this);};
c._onOpen=function(e){var d=document.getElementById(c.sDOM_ID);d.style.height="100%";d.style.width="100%";var A=d.querySelector(".sapUiLocalBusyIndicator");A.className+=" sapUiLocalBusyIndicatorFade";if(d){d.focus();}this.fireOpen({$Busy:this.oPopup._$()});};
c.show=function(d){L.debug("sap.ui.core.BusyIndicator.show (delay: "+d+") at "+new Date().getTime());a(d===undefined||(typeof d=="number"&&(d%1==0)),"iDelay must be empty or an integer");if(!document.body||!sap.ui.getCore().isInitialized()){if(c._bShowIsDelayed===undefined){sap.ui.getCore().attachInit(function(){if(c._bShowIsDelayed){c.show(d);}});}c._bShowIsDelayed=true;return;}if((d===undefined)||((d!=0)&&(parseInt(d)==0))||(parseInt(d)<0)){d=this.iDEFAULT_DELAY_MS;}if(F.getActive()){this._fDelayedStartTime=n()+d;}if(!this.oDomRef){this._init();}this.bOpenRequested=true;if(d===0){this._showNowIfRequested();}else{setTimeout(this["_showNowIfRequested"].bind(this),d);}};
c._showNowIfRequested=function(){L.debug("sap.ui.core.BusyIndicator._showNowIfRequested (bOpenRequested: "+this.bOpenRequested+") at "+new Date().getTime());if(!this.bOpenRequested){return;}var o=(window.scrollX===undefined?window.pageXOffset:window.scrollX);var O=(window.scrollY===undefined?window.pageYOffset:window.scrollY);var s=o+" "+O;this.bOpenRequested=false;this.oPopup.open(0,P.Dock.LeftTop,P.Dock.LeftTop,document,s);};
c.hide=function(){L.debug("sap.ui.core.BusyIndicator.hide at "+new Date().getTime());if(this._fDelayedStartTime){var f=n()-this._fDelayedStartTime;I.addBusyDuration((f>0)?f:0);delete this._fDelayedStartTime;}var d=c;if(c._bShowIsDelayed===true){c._bShowIsDelayed=false;}d.bOpenRequested=false;if(d.oDomRef){var A=d.oDomRef.querySelector(".sapUiLocalBusyIndicator");q(A).removeClass("sapUiLocalBusyIndicatorFade");this.fireClose({$Busy:this.oPopup._$()});d.oPopup.close(0);}};
c.attachOpen=function(f,o){this.attachEvent(c.M_EVENTS.Open,f,o);return this;};
c.detachOpen=function(f,o){this.detachEvent(c.M_EVENTS.Open,f,o);return this;};
c.attachClose=function(f,o){this.attachEvent(c.M_EVENTS.Close,f,o);return this;};
c.detachClose=function(f,o){this.detachEvent(c.M_EVENTS.Close,f,o);return this;};
c.fireOpen=function(p){this.fireEvent(c.M_EVENTS.Open,p);};
c.fireClose=function(p){this.fireEvent(c.M_EVENTS.Close,p);};
return c;},true);
sap.ui.predefine('sap/ui/core/BusyIndicatorUtils',['./BlockLayerUtils'],function(B){"use strict";var a=function(){};
a.getElement=function(s){var S="sapUiLocalBusyIndicatorSizeMedium";if(s==="Large"){S="sapUiLocalBusyIndicatorSizeBig";}var c=document.createElement("div");c.className="sapUiLocalBusyIndicator "+S+" sapUiLocalBusyIndicatorFade";B.addAriaAttributes(c);b(c);return c;};
function b(c,s){s=s||"sapUiLocalBusyIndicatorAnimStandard";var A=document.createElement("div");A.className="sapUiLocalBusyIndicatorAnimation "+s;A.appendChild(document.createElement("div"));A.appendChild(document.createElement("div"));A.appendChild(document.createElement("div"));c.appendChild(A);}
function h(o,s){var p=o.$parent.get(0),c=o.$blockLayer.get(0);var A=c.children[0],w=A.offsetWidth;if(p.offsetWidth<w){A.className="sapUiLocalBusyIndicatorAnimation sapUiLocalBusyIndicatorAnimSmall";}}
a.addHTML=function(o,s){var c=sap.ui.require("sap/ui/core/library").BusyIndicatorSize,S="sapUiLocalBusyIndicatorSizeMedium",A;switch(s){case c.Small:S="sapUiLocalBusyIndicatorSizeMedium";A="sapUiLocalBusyIndicatorAnimSmall";break;case c.Large:S="sapUiLocalBusyIndicatorSizeBig";A="sapUiLocalBusyIndicatorAnimStandard";break;case c.Auto:S="sapUiLocalBusyIndicatorSizeMedium";A="sapUiLocalBusyIndicatorAnimStandard";break;default:S="sapUiLocalBusyIndicatorSizeMedium";A="sapUiLocalBusyIndicatorAnimStandard";break;}if(!o){return;}var p=o.$parent.get(0),d=o.$blockLayer.get(0);p.className+=" sapUiLocalBusy";d.className+=" sapUiLocalBusyIndicator "+S+" sapUiLocalBusyIndicatorFade";b(d,A);if(s===c.Auto){h(o);}};
return a;},true);
sap.ui.predefine('sap/ui/core/CommandExecution',['sap/base/Log','sap/base/util/isEmptyObject','sap/ui/core/Component','sap/ui/core/Element','sap/ui/core/Shortcut'],function(L,a,C,E,S){"use strict";
var b=E.extend("sap.ui.core.CommandExecution",{
metadata:{library:"sap.ui.core",properties:{command:{type:"string"},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true}},events:{execute:{}}},
bSkipUpdate:false,
trigger:function(){if(this.getVisible()&&this.getEnabled()){this.fireExecute({});}},
setCommand:function(c){if(!this.getCommand()){this.setProperty("command",c,true);}else{L.error("The 'command' property can only be applied initially!");}return this;},
_getCommandInfo:function(){var c,o=this.getParent(),d=C.getOwnerComponentFor(this);while(!d&&o&&o.getParent()){d=C.getOwnerComponentFor(o);o=o.getParent();}if(d){c=d.getCommand(this.getCommand());}return c?Object.assign({},c):null;},
_updateContextData:function(c){var p=this.getParent();c[this.getCommand()]={};c[this.getCommand()].enabled=this.getEnabled();c[this.getCommand()].id=this.getId();c[this.getCommand()].visible=this.getVisible();this.getModel("$cmd").setProperty("/"+p.getId(),c);},
_createCommandData:function(p){if(!this.bSkipUpdate){this.bSkipUpdate=true;var P=this.getParent(),m=P.getModel("$cmd"),d=m.getData(),c=d[P.getId()];if(!c){c=Object.create(p);}else if(p!==Object.getPrototypeOf(c)){c=Object.create(p);}this._updateContextData(c);if(!P.getObjectBinding("$cmd")){P.bindElement("$cmd>/"+P.getId());}this.bSkipUpdate=false;}},
setParent:function(p){var t=this,c,o=this.getParent(),P,s,i;function g(){var d=p.oPropagatedProperties.oBindingContexts["$cmd"];return d?d.getObject():null;}function m(){if(p.getModel("$cmd")){var P=g();t.getParent().detachModelContextChange(m);t._createCommandData(P);}}E.prototype.setParent.apply(this,arguments);c=this._getCommandInfo();if(c&&this.getVisible()){if(p&&p!==o){s=c.shortcut;i=S.isRegistered(this.getParent(),s);if(!i){S.register(p,s,this.trigger.bind(this));}if(p.getModel("$cmd")){P=g();this._createCommandData(P);}else{p.attachModelContextChange(m);}if(!p._propagateProperties._sapui_fnOrig){var O=p._propagateProperties;p._propagateProperties=function(n,d,e,u,N,U){O.apply(p,arguments);var A=p.getBindingContext("$cmd");var f=arguments[1];if(A&&f.isA("sap.ui.core.CommandExecution")){var h=A.getObject();var j=Object.getPrototypeOf(h);P=g();if(j!==P){t._createCommandData.apply(f,[P]);}}};p._propagateProperties._sapui_fnOrig=O;}}if(o&&o!=p){s=c.shortcut;i=S.isRegistered(o,s);if(i){S.unregister(o,c.shortcut);}this._cleanupContext(o);}}return this;},
_cleanupContext:function(c){if(c.getBindingContext("$cmd")){var o=c.getBindingContext("$cmd").getObject();if(o){delete o[this.getCommand()];if(a(Object.assign({},o))){if(c._propagateProperties._sapui_fnOrig){c._propagateProperties=c._propagateProperties._sapui_fnOrig;}if(!c._bIsBeingDestroyed){c.unbindElement("$cmd");}}}}},
setVisible:function(v){var p=this.getParent(),c=this.getModel("$cmd");this.setProperty("visible",v,true);v=this.getProperty("visible");if(p){var o=this._getCommandInfo(),s=o.shortcut,i=S.isRegistered(p,s);if(v&&!i){S.register(p,s,this.trigger.bind(this));}else if(!v&&i){S.unregister(p,s);}}if(c){var d=this.getBindingContext("$cmd");c.setProperty(this.getCommand()+"/visible",v,d);}return this;},
setEnabled:function(v){var c=this.getModel("$cmd");this.setProperty("enabled",v,true);if(c){var o=this.getBindingContext("$cmd");c.setProperty(this.getCommand()+"/enabled",this.getProperty("enabled"),o);}return this;},
destroy:function(){var p=this.getParent();if(p){var c=this._getCommandInfo();S.unregister(this.getParent(),c.shortcut);this._cleanupContext(p);}E.prototype.destroy.apply(this,arguments);}
});
b.find=function(c,s){var i,o,A;A=c.getDependents();for(i=0;i<A.length;i++){if(A[i].isA("sap.ui.core.CommandExecution")&&A[i].getCommand()===s){o=A[i];}}if(!o&&c.getParent()){o=b.find(c.getParent(),s);}return o;};
return b;});
sap.ui.predefine('sap/ui/core/ComponentContainer',['sap/ui/base/ManagedObject','./Control','./Component','./library',"./ComponentContainerRenderer","sap/base/Log"],function(M,C,a,l,b,L){"use strict";var c=l.ComponentLifecycle;
var d=C.extend("sap.ui.core.ComponentContainer",{
metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:c.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null},manifest:{type:"any",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:{type:"sap.ui.core.UIComponent"}}},componentFailed:{allowPreventDefault:true,parameters:{reason:{type:"object"}}}},designtime:"sap/ui/core/designtime/ComponentContainer.designtime"},
renderer:b
});
function s(o,v,S,D){var f=typeof v==="string"?a.get(v):v;var O=o.getComponentInstance();if(O!==f){if(O){O.setContainer(undefined);if(D){O.destroy();}else{o._propagateProperties(true,O,M._oEmptyPropagatedProperties,true);}}o.setAssociation("component",f,S);f=o.getComponentInstance();if(f){f.setContainer(o);o.propagateProperties(true);}}}
d.prototype.getComponentInstance=function(){var f=this.getComponent();return f&&a.get(f);};
var p={"onAfterRendering":function(){if(this._placeholder){this._placeholder.show(this);}}};
d.prototype.showPlaceholder=function(S){var f;if(!sap.ui.getCore().getConfiguration().getPlaceholder()){return;}if(this._placeholder){this.hidePlaceholder();}if(S.placeholder){this._placeholder=S.placeholder;f=this._placeholder._load();}else{f=Promise.resolve();}if(this.getDomRef()&&this._placeholder){this._placeholder.show(this);}this.addEventDelegate(p,this);return f;};
d.prototype.hidePlaceholder=function(){if(this._placeholder){this._placeholder.hide();this.removeEventDelegate(p);this._placeholder=undefined;}};
d.prototype.setComponent=function(v,S){s(this,v,S,this.getLifecycle()===c.Container||(typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===c.Legacy));return this;};
d.prototype.applySettings=function(S,o){if(S){if(S.manifest==="true"||S.manifest==="false"){S.manifest=S.manifest==="true";}if(S.manifest&&S.async===undefined){S.async=true;}}C.prototype.applySettings.apply(this,arguments);};
function e(o){var n=o.getName();var m=o.getManifest();var u=o.getUrl();var S=o.getSettings();var f={name:n?n:undefined,manifest:m!==null?m:false,async:o.getAsync(),url:u?u:undefined,handleValidation:o.getHandleValidation(),settings:S!==null?S:undefined};return f;}
d.prototype._createComponent=function(){var o=a.getOwnerComponentFor(this),u=this.getUsage(),m=e(this);if(u){if(o){m=o._enhanceWithUsageConfig(u,m);}else{L.error("ComponentContainer \""+this.getId()+"\" does have a \"usage\", but no owner component!");}}if(this.getAutoPrefixId()){if(m.id){m.id=this.getId()+"-"+m.id;}if(m.settings&&m.settings.id){m.settings.id=this.getId()+"-"+m.settings.id;}}return a._createComponent(m,o);};
d.prototype.onBeforeRendering=function(){var o=this.getComponentInstance(),u=this.getUsage(),n=this.getName(),m=this.getManifest();if(!this._oComponentPromise&&!o&&(u||n||m)){o=this._createComponent();if(o instanceof Promise){this._oComponentPromise=o;o.then(function(o){delete this._oComponentPromise;this.setComponent(o);this.fireComponentCreated({component:o});}.bind(this),function(r){delete this._oComponentPromise;if(this.fireComponentFailed({reason:r})){L.error("Failed to load component for container "+this.getId(),r);}}.bind(this));}else if(o){this.setComponent(o,true);this.fireComponentCreated({component:o});}else{this.fireComponentFailed({reason:new Error("The component could not be created.")});}}if(o&&o.onBeforeRendering){o.onBeforeRendering();}};
d.prototype.onAfterRendering=function(){var o=this.getComponentInstance();if(o&&o.onAfterRendering){o.onAfterRendering();}};
d.prototype.exit=function(){s(this,undefined,true,this.getLifecycle()!==c.Application);};
d.prototype.propagateProperties=function(n){var o=this.getComponentInstance();if(o&&this.getPropagateModel()){this._propagateProperties(n,o);}C.prototype.propagateProperties.apply(this,arguments);};
d.prototype._propagateContextualSettings=function(){var o=this.getComponentInstance();if(o){o._applyContextualSettings(this._getContextualSettings());}};
return d;});
sap.ui.predefine('sap/ui/core/ComponentContainerRenderer',function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){var o=c.getComponentInstance();var w=c.getWidth();var h=c.getHeight();r.openStart("div",c);r.style("width",w);r.style("height",h);r.class("sapUiComponentContainer");r.openEnd();r.openStart("div",c.getId()+"-uiarea");if(w&&w!=="auto"){r.style("width","100%");}if(h&&h!=="auto"){r.style("height","100%");}r.openEnd();if(o){o.render(r);}r.close("div");r.close("div");};
return C;},true);
sap.ui.predefine('sap/ui/core/ComponentSupport',['sap/ui/base/DataType','sap/ui/core/ComponentContainer','sap/ui/core/library',"sap/base/Log","sap/base/util/ObjectPath","sap/base/strings/camelize"],function(D,C,a,L,O,c){"use strict";var b=a.ComponentLifecycle;var d=C.getMetadata();var e=function(){};
e.run=function(){var E=e._find();for(var i=0,l=E.length;i<l;i++){var o=E[i];L.debug("Parsing element "+o.outerHTML,"","sap/ui/core/ComponentSupport");var s=e._parse(o);e._applyDefaultSettings(s);L.debug("Creating ComponentContainer with the following settings",JSON.stringify(s,0,2),"sap/ui/core/ComponentSupport");new C(s).placeAt(o);o.removeAttribute("data-sap-ui-component");}};
e._find=function(){return document.querySelectorAll("[data-sap-ui-component]");};
e._parse=function(E){var s={};for(var i=0,l=E.attributes.length;i<l;i++){var A=E.attributes[i];var p=/^data-((?!sap-ui-component).+)/g.exec(A.name);if(p){var k=c(p[1]);var v=A.value;if(k!=="id"){var P=d.getProperty(k);var o=!P&&d.getEvent(k);if(!P&&!o){L.warning("Property or event \""+k+"\" will be ignored as it does not exist in sap.ui.core.ComponentContainer");continue;}if(P){var t=D.getType(P.type);if(!t){throw new Error("Property \""+P.name+"\" has no known type");}v=t.parseValue(v);}else if(o){var f=O.get(v);if(typeof f!=="function"){throw new Error("Callback handler for event \""+o.name+"\" not found");}v=f;}}s[k]=v;}}return s;};
e._applyDefaultSettings=function(s){s.async=true;if(s.manifest===undefined||s.manifest==="true"){s.manifest=true;}else if(s.manifest==="false"){L.error("Ignoring \"manifest=false\" for ComponentContainer of component \""+s.name+"\" as it is not supported by ComponentSupport. "+"Forcing \"manifest=true\"","","sap/ui/core/ComponentSupport");s.manifest=true;}s.lifecycle=s.lifecycle===undefined?b.Container:s.lifecycle;s.autoPrefixId=s.autoPrefixId===undefined?true:s.autoPrefixId;};
e.run();return e;});
sap.ui.predefine('sap/ui/core/ContextMenuSupport',["./Control"],function(C){"use strict";var a=function(){var c;if(!(this instanceof C)){return;}function o(e){e.stopPropagation();if(e.srcControl!==this){return;}e.preventDefault();this._oContextMenu.openAsContextMenu(e,this);}c={oncontextmenu:o};this.setContextMenu=function(b){if(b==null&&this.getContextMenu()){this._oContextMenu=null;this.removeEventDelegate(c,this);return;}else if(!b||!b.getMetadata||!b.getMetadata().isInstanceOf("sap.ui.core.IContextMenu")){return;}if(!this._oContextMenu){this.addEventDelegate(c,this);}this._oContextMenu=b;};this.getContextMenu=function(){return this._oContextMenu;};};return a;},true);
sap.ui.predefine('sap/ui/core/Control',['./CustomStyleClassSupport','./Element','./UIArea','./RenderManager','./BusyIndicatorUtils','./BlockLayerUtils',"sap/base/Log","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery"],function(C,E,U,R,B,a,L,I,q){"use strict";var b;
var c=E.extend("sap.ui.core.Control",{
metadata:{stereotype:"control","abstract":true,publicMethods:["placeAt","attachBrowserEvent","detachBrowserEvent","getControlsByFieldGroup","triggerValidateFieldGroup","checkFieldGroupIds"],library:"sap.ui.core",properties:{"blocked":{type:"boolean",defaultValue:false},"busy":{type:"boolean",defaultValue:false},"busyIndicatorDelay":{type:"int",defaultValue:1000},"busyIndicatorSize":{type:"sap.ui.core.BusyIndicatorSize",defaultValue:'Medium'},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"fieldGroupIds":{type:"string[]",defaultValue:[]}},events:{validateFieldGroup:{enableEventBubbling:true,parameters:{fieldGroupIds:{type:"string[]"}}}}},
constructor:function(i,s){this.bAllowTextSelection=true;E.apply(this,arguments);this.bOutput=this.getDomRef()!=null;},
renderer:null
});
c.prototype.clone=function(){var o=E.prototype.clone.apply(this,arguments);if(this.aBindParameters){for(var i=0,l=this.aBindParameters.length;i<l;i++){var p=this.aBindParameters[i];o.attachBrowserEvent(p.sEventType,p.fnHandler,p.oListener!==this?p.oListener:undefined);}}o.bAllowTextSelection=this.bAllowTextSelection;return o;};
C.apply(c.prototype);
c.prototype.isActive=function(){return document.getElementById(this.sId)!=null;};
c.prototype.invalidate=function(o){var u;if(this.bOutput&&(u=this.getUIArea())){if(!this._bIsBeingDestroyed){u.addInvalidatedControl(this);}}else{var p=this.getParent();if(p&&(this.bOutput||!(this.getVisible&&this.getVisible()===false))){p.invalidate(this);}}};
c.prototype.rerender=function(){U.rerenderControl(this);};
c.prototype.getDomRef=function(s){if(this.bOutput===false&&!this.oParent){return null;}return E.prototype.getDomRef.call(this,s);};
c.prototype.allowTextSelection=function(h){this.bAllowTextSelection=h;return this;};
c.prototype.attachBrowserEvent=function(s,h,l){if(s&&(typeof(s)==="string")){if(typeof h==="function"){if(!this.aBindParameters){this.aBindParameters=[];}l=l||this;var p=h.bind(l);this.aBindParameters.push({sEventType:s,fnHandler:h,oListener:l,fnProxy:p});if(!this._sapui_bInAfterRenderingPhase){this.$().on(s,p);}}}return this;};
c.prototype.detachBrowserEvent=function(s,h,l){if(s&&(typeof(s)==="string")){if(typeof(h)==="function"){var $=this.$(),i,p;l=l||this;if(this.aBindParameters){for(i=this.aBindParameters.length-1;i>=0;i--){p=this.aBindParameters[i];if(p.sEventType===s&&p.fnHandler===h&&p.oListener===l){this.aBindParameters.splice(i,1);$.off(s,p.fnProxy);}}}}}return this;};
c.prototype.getRenderer=function(){return R.getRenderer(this);};
c.prototype.placeAt=function(o,p){var h=sap.ui.getCore();if(h.isInitialized()){var i=o;if(typeof i==="string"){i=h.byId(o);}var j=false;if(!(i instanceof E)){i=h.createUIArea(o);j=true;}if(!i){return this;}if(!j){var k=i.getMetadata().getAggregation("content");var l=true;if(k){if(!k.multiple||k.type!="sap.ui.core.Control"){l=false;}}else if(!i.addContent||!i.insertContent||!i.removeAllContent){l=false;}if(!l){L.warning("placeAt cannot be processed because container "+i+" does not have an aggregation 'content'.");return this;}}if(typeof p==="number"){i.insertContent(this,p);}else{p=p||"last";switch(p){case"last":i.addContent(this);break;case"first":i.insertContent(this,0);break;case"only":i.removeAllContent();i.addContent(this);break;default:L.warning("Position "+p+" is not supported for function placeAt.");}}}else{var t=this;h.attachInitEvent(function(){t.placeAt(o,p);});}return this;};
c.prototype.onselectstart=function(o){if(!this.bAllowTextSelection){o.preventDefault();o.stopPropagation();}};
c.prototype.onBeforeRendering=function(o){};
c.prototype.onAfterRendering=function(o){};
c.prototype.getIdForLabel=function(){return this.getId();};
c.prototype.destroy=function(s){if(this.bIsDestroyed){return;}this._bIsBeingDestroyed=true;this._cleanupBusyIndicator();b=b||sap.ui.require("sap/ui/core/ResizeHandler");if(b){b.deregisterAllForControl(this.getId());}if(!this.getVisible()){var p=document.getElementById(R.createInvisiblePlaceholderId(this));if(p&&p.parentNode){p.parentNode.removeChild(p);}}E.prototype.destroy.call(this,s);};
var r={onBeforeRendering:function(){e.call(this);},onAfterRendering:function(){if(this.getBlocked()&&this.getDomRef()&&!this.getDomRef("blockedLayer")){this._oBlockState=a.block(this,this.getId()+"-blockedLayer",this._sBlockSection);q(this._oBlockState.$blockLayer.get(0)).addClass("sapUiBlockLayerOnly");}if(this.getBusy()&&this.getDomRef()&&!this._busyIndicatorDelayedCallId&&!this.getDomRef("busyIndicator")){var D=this.getBusyIndicatorDelay();if(D){this._busyIndicatorDelayedCallId=setTimeout(A.bind(this),D);}else{A.call(this);}}}};
function A(){if(!this.getBusy()){return;}var $=this.$(this._sBusySection);if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId;}if(!$||$.length===0){L.warning("BusyIndicator could not be rendered. The outer control instance is not valid anymore.");return;}if(this._sBlockSection===this._sBusySection){if(this._oBlockState){B.addHTML(this._oBlockState,this.getBusyIndicatorSize());a.toggleAnimationStyle(this._oBlockState,true);this._oBusyBlockState=this._oBlockState;}else{d.call(this);}}else{d.call(this);}}
function f(){this._oBlockState=a.block(this,this.getId()+"-blockedLayer",this._sBlockSection);q(this._oBlockState.$blockLayer.get(0)).addClass("sapUiBlockLayerOnly");}
function d(){if(this._oBusyBlockState){a.unblock(this._oBusyBlockState);}this._oBusyBlockState=a.block(this,this.getId()+"-busyIndicator",this._sBusySection);B.addHTML(this._oBusyBlockState,this.getBusyIndicatorSize());}
function e(){a.unblock(this._oBlockState);a.unblock(this._oBusyBlockState);delete this._oBlockState;delete this._oBusyBlockState;}
function g(F){if(F){e.call(this);return;}var $=this.$(this._sBusySection);$.removeClass('sapUiLocalBusy');if(this._sBlockSection===this._sBusySection){if(!this.getBlocked()&&!this.getBusy()){e.call(this);}else if(this.getBlocked()){a.toggleAnimationStyle(this._oBlockState||this._oBusyBlockState,false);this._oBlockState=this._oBusyBlockState;}else if(this._oBusyBlockState){a.unblock(this._oBusyBlockState);delete this._oBusyBlockState;}}else if(this._oBusyBlockState){a.unblock(this._oBusyBlockState);delete this._oBusyBlockState;}}
c.prototype.setBlocked=function(h,s){if(!!h==this.getProperty("blocked")){return this;}this._sBlockSection=s||this._sBlockSection;this.setProperty("blocked",h,true);if(h){this.addDelegate(r,false,this);}else{this.removeDelegate(r);}if(!this.getDomRef()){return this;}if(h){if(this._sBlockSection===this._sBusySection){if(!this._oBusyBlockState&&!this._oBlockState){f.call(this);}else{L.info("The control is already busy. Hence, no new block-layer was created for the shared section.");}}else{f.call(this);}}else{if(this._sBlockSection===this._sBusySection){if(!this.getBlocked()&&!this.getBusy()){e.call(this);}else if(this.getBusy()){L.info("The control is already busy. Hence, no new block-layer was created for the shared section.");}}else if(this._oBlockState){a.unblock(this._oBlockState);delete this._oBlockState;}}return this;};
c.prototype.setBusy=function(h,s){if(!!h==this.getProperty("busy")){return this;}this._sBusySection=s||this._sBusySection;this.setProperty("busy",h,true);if(h){I.notifyShowBusyIndicator(this);this.addDelegate(r,false,this);}else{this.removeDelegate(r);if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId;}}if(!this.getDomRef()){return this;}if(h){if(this.getBusyIndicatorDelay()<=0){A.call(this);}else{this._busyIndicatorDelayedCallId=setTimeout(A.bind(this),this.getBusyIndicatorDelay());}}else{g.call(this);I.notifyHideBusyIndicator(this);}return this;};
c.prototype.isBusy=c.prototype.getBusy;
c.prototype.setBusyIndicatorDelay=function(D){this.setProperty("busyIndicatorDelay",D,true);return this;};
c.prototype._cleanupBusyIndicator=function(){if(this._busyIndicatorDelayedCallId){clearTimeout(this._busyIndicatorDelayedCallId);delete this._busyIndicatorDelayedCallId;}g.call(this,true);};
c.prototype.getControlsByFieldGroupId=function(F){return this.findAggregatedObjects(true,function(o){if(o instanceof c){return o.checkFieldGroupIds(F);}return false;});};
c.prototype.checkFieldGroupIds=function(F){if(typeof F==="string"){F=F?F.split(","):[];}var h=this._getFieldGroupIds();if(Array.isArray(F)){return F.every(function(s){return h.indexOf(s)>=0;});}else if(!F){return h.length>0;}return false;};
c.prototype.triggerValidateFieldGroup=function(F){this.fireValidateFieldGroup({fieldGroupIds:F});};
return c;});
sap.ui.predefine('sap/ui/core/CustomData',['./Element'],function(E){"use strict";var C=E._CustomData;return C;});
sap.ui.predefine('sap/ui/core/CustomStyleClassSupport',['./Element',"sap/base/assert","sap/base/Log"],function(E,a,L){"use strict";var r=/\s/;var b=/\S+/g;var C=function(){if(!(this instanceof E)){return;}var o=this.clone;this.clone=function(){var c=o.apply(this,arguments);if(this.aCustomStyleClasses){c.aCustomStyleClasses=this.aCustomStyleClasses.slice();}if(this.mCustomStyleClassMap){c.mCustomStyleClassMap=Object.assign(Object.create(null),this.mCustomStyleClassMap);}return c;};this.addStyleClass=function(s,S){a(typeof s==="string","sStyleClass must be a string");if(!s||typeof s!=="string"||s.indexOf("\"")>-1||s.indexOf("'")>-1){return this;}var c=this.aCustomStyleClasses||(this.aCustomStyleClasses=[]),m=this.mCustomStyleClassMap||(this.mCustomStyleClassMap=Object.create(null)),d,M=false,e=[],h=g();function i(j){if(!m[j]){m[j]=true;c.push(j);if(h&&h.indexOf(j)>-1){e.push(j);}M=true;}}if(r.test(s)){d=s.match(b);d&&d.forEach(i);}else{i(s);}if(!M){return this;}var R=this.getDomRef();if(R){if(d){R.classList.add.apply(R.classList,d);}else{R.classList.add(s);}}else if(S===false){this.invalidate();}if(e.length>0){f(this,e,true);}return this;};this.removeStyleClass=function(s,S){a(typeof s==="string","sStyleClass must be a string");if(!s||typeof s!=="string"||!this.aCustomStyleClasses||!this.mCustomStyleClassMap){return this;}var c=this.aCustomStyleClasses,m=this.mCustomStyleClassMap,d,e=false,h=[],i=g(),n;function j(k){if(m[k]){e=true;n=c.indexOf(k);if(n!==-1){c.splice(n,1);delete m[k];if(i&&i.indexOf(k)>-1){h.push(k);}}}}if(r.test(s)){d=s.match(b);d&&d.forEach(j);}else{j(s);}if(e){var R=this.getDomRef();if(R){if(d){R.classList.remove.apply(R.classList,d);}else{R.classList.remove(s);}}else if(S===false){this.invalidate();}if(h.length>0){f(this,h,false);}}return this;};this.toggleStyleClass=function(s,A){a(typeof s==="string","sStyleClass must be a string");if(s&&typeof s==="string"){if(A===true){this.addStyleClass(s);}else if(A===false){this.removeStyleClass(s);}else if(A===undefined){this.hasStyleClass(s)?this.removeStyleClass(s):this.addStyleClass(s);}else{L.warning(this.toString()+"- toggleStyleClass(): bAdd should be a boolean or undefined, but is '"+A+"'");}}return this;};this.hasStyleClass=function(s){a(typeof s==="string","sStyleClass must be a string");if(s&&typeof s==="string"&&this.mCustomStyleClassMap){if(r.test(s)){var c=s.match(b);return c!=null&&c.every(function(d){return this.mCustomStyleClassMap[d];},this);}else{return!!this.mCustomStyleClassMap[s];}}return false;};this.getMetadata().addPublicMethods(["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"]);};var P;
function g(){if(!P){P=sap.ui.require("sap/ui/core/theming/Parameters");}if(P){return P._getScopes(true);}}
function f(e,s,i){sap.ui.getCore().fireThemeScopingChanged({scopes:s,added:i,element:e});}
return C;},true);
sap.ui.predefine('sap/ui/core/CustomizingConfiguration',['sap/base/Log'],function(L){"use strict";L.error("Since UI5 version 1.95, the private module 'sap/ui/core/CustomizingConfiguration' is functionally inactive. "+"Please be aware that this module has always been a private API and any monkey patching on this module will have no further effect. "+"You must remove the dependency to this file as this module will be removed in one of the following versions of UI5.");var C={log:function(){},activateForComponent:function(){},deactivateForComponent:function(){},activateForComponentInstance:function(){},deactivateForComponentInstance:function(){},getViewReplacement:function(){},getViewExtension:function(){},getControllerExtension:function(){},getControllerReplacement:function(){},getCustomProperties:function(){},hasCustomProperties:function(){}};return C;},true);
sap.ui.predefine('sap/ui/core/DeclarativeSupport',['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','./Control','./CustomData','./HTML','./mvc/View','./mvc/EventHandlerResolver','sap/base/Log','sap/base/util/ObjectPath','sap/base/assert','sap/base/strings/camelize'],function(q,D,M,C,a,H,V,E,L,O,b,c){"use strict";var d={};d.attributes={"data-sap-ui-type":true,"data-sap-ui-id":true,"data-sap-ui-aggregation":true,"data-sap-ui-default-aggregation":true,"data-sap-ui-binding":function(v,s){var B=M.bindingParser(v);s.objectBindings=s.objectBindings||{};s.objectBindings[B.model||undefined]=B;},"data-tooltip":function(v,s){s["tooltip"]=v;},"tooltip":function(v,s,f){s["tooltip"]=v;L.warning('[Deprecated] Control "'+s.id+'": The attribute "tooltip" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');},"class":true,"style":true,"id":true};
d.compile=function(e,v,i){var t=this;q(e).find("[data-sap-ui-type]").filter(function(){return q(this).parents("[data-sap-ui-type]").length===0;}).each(function(){t._compile(this,v,i);});};
d._compile=function(e,v,i){var $=q(e);var t=$.attr("data-sap-ui-type");var f=[];var I=t==="sap.ui.core.UIArea";if(I){var g=this;$.children().each(function(){var o=g._createControl(this,v);if(o){f.push(o);}});}else{var o=this._createControl(e,v);if(o){f.push(o);}}$.empty();var A=[];q.each(e.attributes,function(h,j){var n=j.name;if(!I||I&&/^data-/g.test(n.toLowerCase())){A.push(n);}});if(A.length>0){$.removeAttr(A.join(" "));}f.forEach(function(o){if(o instanceof C){if(v&&!i){v.addContent(o);}else{o.placeAt(e);if(v){v.connectControl(o);}}}});};
d._createControl=function(e,v){var $=q(e);var o=null;var t=$.attr("data-sap-ui-type");if(t){var f=sap.ui.requireSync(t.replace(/\./g,"/"));f=f||O.get(t);b(typeof f!=="undefined","Class not found: "+t);var s={};s.id=this._getId($,v);if(v&&v._sProcessingMode!=null&&f.getMetadata().hasSpecialSetting("processingMode")){s.processingMode=v._sProcessingMode;}this._addSettingsForAttributes(s,f,e,v);this._addSettingsForAggregations(s,f,e,v);var o;if(V.prototype.isPrototypeOf(f.prototype)&&typeof f._sType==="string"){o=V._create(s,undefined,f._sType);}else{o=new f(s);}if(e.className){o.addStyleClass(e.className);}$.removeAttr("data-sap-ui-type");}else{o=this._createHtmlControl(e,v);}return o;};
d._createHtmlControl=function(e,v){var h=new H();h.setDOMContent(e);this.compile(e,v,true);return h;};
d._addSettingsForAttributes=function(s,f,e,v){var t=this;var S=d.attributes;var B=M.bindingParser;var g=[];var r=/^data-custom-data:(.+)/i;q.each(e.attributes,function(i,A){var n=A.name;var h=A.value;if(!r.test(n)){if(typeof S[n]==="undefined"){n=t.convertAttributeToSettingName(n,s.id);var p=t._getProperty(f,n);if(p){var o=B(h,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(t.getPropertyDataType(p),o||h);}}else if(t._getAssociation(f,n)){var j=t._getAssociation(f,n);if(j.multiple){h=h.replace(/\s*,\s*|\s+/g,",");s[n]=h.split(",").map(function(I){return v?v.createId(I):I;});}else{s[n]=v?v.createId(h):h;}}else if(t._getAggregation(f,n)){var k=t._getAggregation(f,n);if(k.multiple){var o=B(h,v&&v.getController());if(o){s[n]=o;}else{throw new Error("Aggregation "+n+" with cardinality 0..n only allows binding paths as attribute value");}}else if(k.altTypes){var o=B(h,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(k.altTypes[0],o||h);}}else{throw new Error("Aggregation "+n+" not supported");}}else if(t._getEvent(f,n)){var l=v&&(v._oContainingView||v).getController();var m=E.resolveEventHandler(h,l);if(m){s[n]=m;}else{throw new Error('Control "'+s.id+'": The function "'+h+'" for the event "'+n+'" is not defined');}}else{b((n==="id"),"DeclarativeSupport encountered unknown setting '"+n+"' for class '"+f.getMetadata().getName()+"' (value:'"+h+"')");}}else if(typeof S[n]==="function"){S[n](h,s,f);}}else{n=c(r.exec(n)[1]);var o=B(h,v&&v.getController());g.push(new a({key:n,value:o||h}));}});if(g.length>0){s.customData=g;}return s;};
d._addSettingsForAggregations=function(s,f,e,v){var $=q(e);var g=this._getDefaultAggregation(f,e);var t=this;var A=f.getMetadata().getAllAggregations();$.children().each(function(){var h=q(this);var i=h.attr("data-sap-ui-aggregation");var T=h.attr("data-sap-ui-type");var u=false;if(!i){u=true;i=g;}if(i&&A[i]){var m=A[i].multiple;var j=function(o){var k=t._createControl(o,v);if(k){if(m){if(!s[i]){s[i]=[];}if(typeof s[i].path==="string"){b(!s[i].template,"list bindings support only a single template object");s[i].template=k;}else{s[i].push(k);}}else{s[i]=k;}}};if(u||(T&&!u)){j(this);}else{h.children().each(function(){j(this);});}}h.removeAttr("data-sap-ui-aggregation");h.removeAttr("data-sap-ui-type");});return s;};
d._getId=function(e,v){var $=q(e);var i=$.attr("id");if(i){if(v){i=v.createId(i);$.attr("data-sap-ui-id",i);}$.attr("id","");}return i;};
d._getProperty=function(f,n){return f.getMetadata().getProperty(n);};
d.convertValueToType=function(t,v){if(t instanceof D){v=t.parseValue(v);}return typeof v==="string"?M.bindingParser.escape(v):v;};
d.getPropertyDataType=function(p){var t=D.getType(p.type);if(!t){throw new Error("Property "+p.name+" has no known type");}return t;};
d.convertAttributeToSettingName=function(A,i,e){if(A.indexOf("data-")===0){A=A.substr(5);}else if(e){L.warning('[Deprecated] Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');}else{throw new Error('Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*".');}return c(A);};
d._getAssociation=function(f,n){return f.getMetadata().getAssociation(n);};
d._getAggregation=function(f,n){return f.getMetadata().getAggregation(n);};
d._getEvent=function(f,n){return f.getMetadata().getEvent(n);};
d._getDefaultAggregation=function(f,e){var $=q(e);var s=$.attr("data-sap-ui-default-aggregation")||f.getMetadata().getDefaultAggregationName();$.removeAttr("data-sap-ui-default-aggregation");return s;};
return d;},true);
sap.ui.predefine('sap/ui/core/EnabledPropagator',[],function(){"use strict";var E=function(d,l){if(!this.isA||!this.isA("sap.ui.core.Control")){throw new Error("EnabledPropagator only supports subclasses of Control");}this._bUseEnabledPropagator=true;var o=this.getEnabled;if(o===undefined){this.getEnabled=function(){return(this._bUseEnabledPropagator&&h(this))?false:this.getProperty("enabled");};d=(d===undefined)?true:Boolean(d);if(l){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:d});}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:d});this.getMetadata().addPublicMethods("getEnabled");}else{this.getEnabled=function(){return(this._bUseEnabledPropagator&&h(this))?false:o.apply(this,arguments);};}if(this.setEnabled===undefined){this.setEnabled=function(e){c(this,e);return this.setProperty("enabled",e);};this.getMetadata().addPublicMethods("setEnabled");}else{var O=this.setEnabled;this.setEnabled=function(e){c(this,e);return O.apply(this,arguments);};}this.useEnabledPropagator=function(u){this._bUseEnabledPropagator=u;};this.getMetadata().addPublicMethods("useEnabledPropagator");};
function h(C){for(var p=C.getParent();p&&!p.getEnabled&&p.getParent;p=p.getParent()){}return p&&p.getEnabled&&!p.getEnabled();}
function c(C,e){var d=C.getDomRef();if(!e&&d&&d.contains(document.activeElement)){var f=C.$().parent().closest(":focusable")[0];if(f){f.focus({preventScroll:true});}}}
return E;},true);
sap.ui.predefine('sap/ui/core/ExtensionPoint',["sap/base/Log","sap/base/util/ObjectPath","sap/ui/core/mvc/View","sap/ui/core/Component"],function(L,O,V,C){"use strict";
sap.ui.extensionpoint=function(c,e,f,t,a){L.warning("Do not use deprecated factory function 'sap.ui.extensionpoint'. Use 'sap.ui.core.ExtensionPoint.load' instead","sap.ui.extensionpoint",null,function(){return{type:"sap.ui.extensionpoint",name:e};});return E._factory(c,e,f,t,a);};
var E=sap.ui.extensionpoint;
E._factory=function(c,e,f,t,a,A){var o,v,r,s;if(c){if(c.isA("sap.ui.core.mvc.View")){s=c.sViewName;v=c;}else if(c.isA("sap.ui.core.Fragment")){s=c.getFragmentName();v=c._oContainingView;}o=C.getCustomizing(c,{type:"sap.ui.viewExtensions",name:s,extensionName:e});}if(o){if(o.className){L.info("Customizing: View extension found for extension point '"+e+"' in View '"+v.sViewName+"': "+o.className+": "+(o.viewName||o.fragmentName));var I=v&&o.id?v.createId(o.id):o.id;var F={async:A,id:I,type:o.type};if(A&&v._sProcessingMode){F.processingMode=v._sProcessingMode;}if(o.className==="sap.ui.core.Fragment"){var b=sap.ui.require("sap.ui.core.Fragment");F.fragmentName=o.fragmentName;F.containingView=v;if(A){if(b){r=b.load(F);}else{r=new Promise(function(R,i){sap.ui.require(["sap/ui/core/Fragment"],function(b){R(b.load(F));},i);});}}else{b=b||sap.ui.requireSync("sap/ui/core/Fragment");var d=new b(F);r=(Array.isArray(d)?d:[d]);}}else if(o.className==="sap.ui.core.mvc.View"){F.viewName=o.viewName;var g=V._create(F);if(A){r=g.loaded();}else{r=[g];}}else{L.warning("Customizing: Unknown extension className configured (and ignored) in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+o.className);}}else{L.warning("Customizing: no extension className configured in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+o.className);}}else if(E._fnExtensionProvider){var h=E._fnExtensionProvider(v);var j;if(v.isA("sap.ui.core.Fragment")){j=v._sExplicitId;var k=v.getController();v=k&&typeof k.isA==="function"&&k.isA("sap.ui.core.mvc.Controller")&&k.getView();if(v){j=v.getLocalId(j)||j;}}if(h){if(!v){L.warning("View instance could not be passed to ExtensionPoint Provider for extension point '"+e+"' "+"in fragment '"+j+"'.");}return[{providerClass:h,view:v,fragmentId:j,name:e,createDefault:f,targetControl:undefined,aggregationName:undefined,index:undefined,ready:function(i){var n=this._nextSibling;while(n!=null){n.index+=i.length;n=n._nextSibling;}},_isExtensionPoint:true,_nextSibling:null}];}}if(!r&&typeof f==='function'){r=f();}var p=function(r){if(r&&!Array.isArray(r)){r=[r];}if(r&&t){var m=t.getMetadata().getAggregation(a);if(m){for(var i=0,l=r.length;i<l;i++){t[m._sMutator](r[i]);}}else{L.error("Creating extension point failed - Tried to add extension point with name "+e+" to an aggregation of "+t.getId()+" in view "+v.sViewName+", but sAggregationName was not provided correctly and I could not find a default aggregation");}}return r||[];};if(r&&typeof r.then==='function'){return r.then(p);}else{return p(r);}};
E.registerExtensionProvider=function(e){if(e==null){delete E._fnExtensionProvider;}else if(typeof e=="function"){E._fnExtensionProvider=e;}else{L.error("ExtensionPoint provider must be a function!");}};
E.load=function(o){return Promise.resolve(E._factory(o.container,o.name,o.createDefaultContent,null,null,!!o.async));};
return E;});
sap.ui.predefine('sap/ui/core/Fragment',['sap/ui/thirdparty/jquery','../base/ManagedObject','./Element','./DeclarativeSupport','./XMLTemplateProcessor','sap/base/Log','sap/base/util/LoaderExtensions','sap/base/util/merge','sap/ui/core/Component','sap/ui/core/mvc/XMLProcessingMode'],function(q,M,E,D,X,L,a,m,C,b){"use strict";var r={},t={};
var F=M.extend("sap.ui.core.Fragment",{
metadata:{properties:{type:'string'},specialSettings:{async:{type:'boolean',visibility:'hidden'},fragmentName:'string',fragmentContent:'any',containingView:{type:'sap.ui.core.mvc.View',visibility:'hidden'},oController:{type:'sap.ui.core.mvc.Controller',visibility:'hidden'},sId:{type:'sap.ui.core.ID',visibility:'hidden'},sOwnerId:{type:'sap.ui.core.ID',visibility:'hidden'},processingMode:{type:'sap.ui.core.mvc.XMLProcessingMode',visibility:'hidden'}}},
constructor:function(i,s){M.apply(this,arguments);if(!this._bAsync){if(this._aContent&&this._aContent.length==1){return this._aContent[0];}else{return this._aContent;}}}
});
F.registerType=function(T,o){if(typeof(T)!=="string"){L.error("Ignoring non-string Fragment type: "+T);return;}if(t[T]){L.warning("sap.ui.core.Fragment.registerType(): Fragment type '"+T+"' is already defined. Overriding this type now!");}t[T]=o;};
F.prototype._initCompositeSupport=function(s){if(!s){throw new Error("Settings must be set");}if(!(s.fragmentName||s.fragmentContent)){throw new Error("Please provide a fragment name");}if(s.oController){this.oController=s.oController;}this._bAsync=s.async||false;this._sExplicitId=s.sId||s.id;this._sFragmentName=s.fragmentName;this.fnScopedRunWithOwner=s.containingView&&s.containingView.fnScopedRunWithOwner;if(!this.fnScopedRunWithOwner&&this._sOwnerId){var o=C.get(this._sOwnerId);this.fnScopedRunWithOwner=function(d){return o.runAsOwner(d);};}var c=F.getType(s.type);if(c){this._pContentPromise=c.init.apply(this,[s]);if(!this._pContentPromise){this._pContentPromise=Promise.resolve(this._aContent);}}else{throw new Error("No type for the fragment has been specified: "+s.type);}};
F.prototype.getFragmentName=function(){return this._sFragmentName;};
F.prototype.getController=function(){return this.oController;};
F.byId=function(s,i){if(!(typeof(s)==="string"&&typeof(i)==="string")){L.error("sap.ui.core.Fragment.byId: two strings must be given as parameters, but are: "+s+" and "+i);return undefined;}return sap.ui.getCore().byId(s+"--"+i);};
F.createId=function(s,i){if(!(typeof(s)==="string"&&typeof(i)==="string")){L.error("sap.ui.core.Fragment.createId: two strings must be given as parameters, but are: "+s+" and "+i);return undefined;}return s+"--"+i;};
F.prototype.createId=function(i){var c=this._sExplicitId?this._sExplicitId+"--"+i:i;if(this._oContainingView&&this._oContainingView!=this){c=this._oContainingView.createId(c);}return c;};
F.prototype.isSubView=function(){return true;};
sap.ui.fragment=function(n,T,c){var s;if(typeof(T)==="string"){s=T.toLowerCase();}else if(typeof(T)==="object"&&typeof(T.fragmentName)==="string"){s=T.fragmentName.toLowerCase();}else{s="";}L.info("Do not use deprecated factory function 'sap.ui."+s+"fragment'. Require 'sap/ui/core/Fragment' and use 'load()' instead","sap.ui."+s+"fragment",null,function(){return{type:"sap.ui."+s+"fragment",name:s?n+".fragment."+s:n};});return f(n,T,c);};
function f(n,T,c){var s={};if(typeof(n)==="string"){s.fragmentName=n;s.oController=c;s.type=T;}else if(typeof(n)==="object"){s=n;s.async=s.async===true?s.async:false;if(T){s.oController=T;}if(s.async){var d=function(){var O=s.sOwnerId||s.containingView&&s.containingView._sOwnerId;var e=C.get(O);if(e){return e.runAsOwner(function(){return new F(s);});}return new F(s);};var o=F.getType(s.type);if(s.fragmentName&&s.fragmentContent){delete s.fragmentName;}if(s.fragmentName&&typeof o.load=="function"){return new Promise(function(e,g){o.load(s).then(function(v){s.fragmentContent=v;e(d());}).catch(function(h){g(h);});});}else{return Promise.resolve(d());}}}else{L.error("sap.ui.fragment() must be called with Fragment name or config object as first parameter, but is: "+n);}return new F(s);}
F.load=function(o){var p=Object.assign({},o);if(p.name&&p.definition){L.error("The properties 'name' and 'definition' shouldn't be provided at the same time. The fragment definition will be used instead of the name. Fragment name was: "+p.name);delete p.name;}p.type=p.type||"XML";p.async=true;p.processingMode=p.processingMode||b.Sequential;p.fragmentName=p.fragmentName||p.name;p.fragmentContent=p.fragmentContent||p.definition;p.oController=p.controller;p.sOwnerId=M._sOwnerId;delete p.name;delete p.definition;delete p.controller;var c=f(p);return c.then(function(d){return d._pContentPromise;});};
F.getType=function(T){return t[T];};
sap.ui.xmlfragment=function(i,v,c){if(typeof(i)==="string"){if(typeof(v)==="string"){return sap.ui.fragment({fragmentName:v,sId:i,type:"XML"},c);}else{return sap.ui.fragment(i,"XML",v);}}else{i.type="XML";return sap.ui.fragment(i,v);}};
sap.ui.jsfragment=function(n,v,c){if(typeof n==="string"&&typeof v==="object"){if(v.createContent){r[n]=v;sap.ui.loader._.declareModule(n.replace(/\./g,"/")+".fragment.js");}else{return sap.ui.fragment(n,"JS",v);}}else if(typeof n==="string"&&v===undefined){return sap.ui.fragment(n,"JS");}else if(typeof n==="object"){n.type="JS";return sap.ui.fragment(n,v);}else if(arguments.length>=3){return sap.ui.fragment({id:n,fragmentName:v,type:"JS"},c);}else{L.error("sap.ui.jsfragment() was called with wrong parameter set: "+n+" + "+v);}};
sap.ui.htmlfragment=function(i,v,c){if(typeof(i)==="string"){if(typeof(v)==="string"){return sap.ui.fragment({fragmentName:v,sId:i,type:"HTML"},c);}else{return sap.ui.fragment(i,"HTML",v);}}else{i.type="HTML";return sap.ui.fragment(i,v);}};
F.registerType("XML",{load:function(s){return X.loadTemplatePromise(s.fragmentName,"fragment").then(function(d){return d;});},init:function(s){this._aContent=[];if(s.fragmentContent){if(typeof(s.fragmentContent)==="string"){this._xContent=q.parseXML(s.fragmentContent).documentElement;}else{this._xContent=s.fragmentContent;}}else{L.warning("Synchronous loading of fragment, due to Fragment.init() call for '"+s.fragmentName+"'. Use 'sap/ui/core/Fragment' module with Fragment.load() instead.","SyncXHR",null,function(){return{type:"SyncXHR",name:"Fragment"};});this._xContent=X.loadTemplate(s.fragmentName,"fragment");}this._oContainingView=this._sExplicitId?this:(s.containingView||this);if((this._oContainingView===this)){this._oContainingView.oController=(s.containingView&&s.containingView.oController)||s.oController;}this._sProcessingMode=s.processingMode;var S=this._oContainingView._fnSettingsPreprocessor;var p={fnRunWithPreprocessor:function(d){return M.runWithPreprocessors(d,{settings:S});}};var c=X.parseTemplatePromise(this._xContent,this,this._bAsync,p).then(function(d){this._aContent=d;if(this._aContent&&this._aContent.length&&s.objectBindings){this._aContent.forEach(function(o,i){if(o instanceof E){for(var g in s.objectBindings){o.bindObject(s.objectBindings[g]);}}});}return this._aContent.length>1?this._aContent:this._aContent[0];}.bind(this));if(!this._bAsync){try{c.unwrap();}catch(e){L.error("An Error occured during XML processing of '"+this.getMetadata().getName()+"' with id '"+this.getId()+"':\n"+e.stack);}}return c;}});F.registerType("JS",{load:function(s){var c=s.fragmentName.replace(/\./g,"/")+".fragment";return new Promise(function(d,e){sap.ui.require([c],function(g){d(g);},e);});},init:function(s){this._aContent=[];if(s.fragmentContent){m(this,s.fragmentContent);}else{if(!r[s.fragmentName]){sap.ui.requireSync(s.fragmentName.replace(/\./g,"/")+".fragment");}m(this,r[s.fragmentName]);}this._oContainingView=s.containingView||this;return M.runWithPreprocessors(function(){var c;if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){c=this.createContent(s.oController||this._oContainingView.oController);}.bind(this));}else{c=this.createContent(s.oController||this._oContainingView.oController);}if(c instanceof Promise){return c.then(function(d){this._aContent=this._aContent.concat(d);return this._aContent.length>1?this._aContent:this._aContent[0];}.bind(this));}else{return new Promise(function(d,e){this._aContent=this._aContent.concat(c);d(this._aContent.length>1?this._aContent:this._aContent[0]);}.bind(this));}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor});}});(function(){var _={};var c=function(T){var u=sap.ui.require.toUrl(T.replace(/\./g,"/"))+".fragment.html";var h=_[u];var R;if(!h){R=T.replace(/\./g,"/")+".fragment.html";h=a.loadResource(R);_[u]=h;}return h;};F.registerType("HTML",{load:function(s){var d=s.fragmentName.replace(/\./g,"/")+".fragment";return a.loadResource(d+".html",{async:true}).then(function(o){return o;});},init:function(s){this._aContent=[];this.getContent=function(){return this._aContent;};this.addContent=function(j){this._aContent.push(j);};this._oContainingView=s.containingView||this;this._sProcessingMode=s.processingMode;var h=s.fragmentContent||c(s.fragmentName);this._oTemplate=document.createElement("div");if(typeof h==="string"){this._oTemplate.innerHTML=h;}else{var n=h;var d=document.createDocumentFragment();for(var i=0;i<n.length;i++){d.appendChild(n.item(i));}this._oTemplate.appendChild(d);}var o=this._oTemplate.getElementsByTagName("template")[0];var p=this.getMetadata().getAllProperties();if(o){var e=this;q.each(o.attributes,function(I,A){var N=D.convertAttributeToSettingName(A.name,e.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(sap.ui.core.mvc.HTMLView._mAllowedSettings[N]){s[N]=v;}}});this._oTemplate=o;}if(this._oTemplate.content){var g=this._oTemplate.content;this._oTemplate=document.createElement("div");this._oTemplate.appendChild(g);}return M.runWithPreprocessors(function(){if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){D.compile(this._oTemplate,this);}.bind(this));}else{D.compile(this._oTemplate,this);}var j=this.getContent();if(j&&j.length===1){this._aContent=[j[0]];return new Promise(function(k,l){k(this._aContent[0]);}.bind(this));}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor});}});}());return F;});
sap.ui.predefine('sap/ui/core/HTML',['sap/ui/thirdparty/jquery',"sap/base/Log",'./Control','./RenderManager',"./HTMLRenderer","sap/base/security/sanitizeHTML"],function(q,L,C,R,H,b){"use strict";var c=R.RenderPrefixes;
var d=C.extend("sap.ui.core.HTML",{
metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}},
renderer:H
});
d.prototype.getDomRef=function(s){var i=s?this.getId()+"-"+s:this.getId();return document.getElementById(c.Dummy+i)||document.getElementById(i);};
d.prototype.setContent=function(e){function p(s){if(q.parseHTML){var a=q.parseHTML(s);if(a){var f=0,g=a.length;while(f<g&&a[f].nodeType!=1){f++;}while(f<g&&a[g-1].nodeType!=1){g--;}if(f>0||g<a.length){a=a.slice(f,g);}return q(a);}}return q(s);}if(this.getSanitizeContent()){L.trace("sanitizing HTML content for "+this);e=b(e);}this.setProperty("content",e,true);if(this.getDomRef()){var $=p(this.getContent());q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{this.invalidate();}return this;};
d.prototype.setSanitizeContent=function(s){this.setProperty("sanitizeContent",s,true);if(s){this.setContent(this.getContent());}return this;};
d.prototype.onBeforeRendering=function(){if(!this.getPreferDOM()){return;}var D=this.getDomRef();if(D&&!R.isPreservedContent(D)){for(var i=D.id,n;D&&D.getAttribute("data-sap-ui-preserve")==i;D=n){n=D.nextElementSibling;R.preserveContent(D,true,false);}}};
d.prototype.onAfterRendering=function(){if(!this.getVisible()){return;}var $=q(document.getElementById(c.Dummy+this.getId()));var a=R.findPreservedContent(this.getId());var e;var i=false;if((!this.getPreferDOM()||a.length==0)){a.remove();e=new q(this.getContent());$.replaceWith(e);}else if(a.length>0){$.replaceWith(a);e=a;i=true;}else{$.remove();}this._postprocessNewContent(e);this.fireAfterRendering({isPreservedDOM:i});};
d.prototype._postprocessNewContent=function($){if($&&$.length>0){if($.length>1){L.warning("[Unsupported Feature]: "+this+" has rendered "+$.length+" root nodes!");}else{var s=$.attr("id");if(s&&s!=this.getId()){L.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+s+"'!");}}if(this.getPreferDOM()){R.markPreservableContent($,this.getId());}if($.find("#"+this.getId().replace(/(:|\.)/g,'\\$1')).length===0){$.filter(":not([id])").first().attr("id",this.getId());}}else{L.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false;}};
d.prototype.setDOMContent=function(D){var $=q(D);if(this.getDomRef()){q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{$.appendTo(R.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate();}this._postprocessNewContent($);}return this;};
d.prototype.setTooltip=function(){L.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return C.prototype.setTooltip.apply(this,arguments);};
"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(m){d.prototype[m]=function(){L.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return C.prototype[m].apply(this,arguments);};});return d;});
sap.ui.predefine('sap/ui/core/HTMLRenderer',['./RenderManager'],function(R){"use strict";var a=R.RenderPrefixes;var H={apiVersion:2,render:function(r,c){r.openStart("div",a.Dummy+c.getId());r.style("display","none");r.openEnd();r.close("div");}};return H;},true);
sap.ui.predefine('sap/ui/core/History',['sap/ui/base/Object',"sap/ui/util/Storage"],function(B,S){"use strict";
var H=B.extend("sap.ui.core.History",{
constructor:function(i,s){B.apply(this);if(!s){s={};}var h=s.prefix?s.prefix:document.location.pathname;this._iMaxHistory=s.max?s.max:100;this._sHistoryId=h+i;this._oStorage=new S(S.Type.local);this._fFilter=s.filter?s.filter:function(a,v){return a&&(!v||(v&&((typeof v=="string"?a.toLowerCase().startsWith(v.toLowerCase()):false))));};this._fCheckHistory=s.checkHistory?s.checkHistory:function(a){return a;};},
_initHistory:function(){if(!this._aHistory){var h=this._oStorage.get(this._sHistoryId);if(typeof(h)==="string"){h=h.split(",");}else if(!h){h=[];}this._aHistory=this._fCheckHistory(h);}return this._aHistory;},
get:function(v){var h=this._initHistory();var r=[];for(var i=0;i<h.length;i++){if(this._fFilter(h[i],v)){r.push(h[i]);}}return r;},
remove:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]==v){h.splice(i,1);break;}}},
add:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]===v){h.splice(i,1);break;}}h.unshift(v);if(h.length>this._iMaxHistory){h.splice(this._iMaxHistory);}this._oStorage.put(this._sHistoryId,h);},
clear:function(){this._oStorage.remove(this._sHistoryId);this._aHistory=null;}
});
return H;});
sap.ui.predefine('sap/ui/core/Icon',['sap/base/assert','../Device','./Control','./_IconRegistry','./InvisibleText','./library',"./IconRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/Log"],function(a,D,C,_,I,l,b,K,q,L){"use strict";var c=l.IconColor;var d=l.CSSColor;var i=function(v){if(v!=null&&v!==""&&!d.isValid(v)&&!(v in c)){L.error("\""+v+"\" is not of type sap.ui.core.CSSColor nor of type sap.ui.core.IconColor.");return false;}else{return true;}};
var e=C.extend("sap.ui.core.Icon",{
metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}},
renderer:b
});
e.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(E){if(this.hasListeners("press")){E.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),$;if(A||s){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===1)){$=this.$();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};e.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(E){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors(D.system.desktop?"hover":undefined);}};
e.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};
e.prototype.onmouseout=function(){this._restoreColors();};
e.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(E){if(this.hasListeners("press")){E.setMarked();}this.firePress({});};
e.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){E.preventDefault();var $=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};
e.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};
e.prototype._restoreColors=function(m){var s,B;if(m==="hover"){s=this.getHoverColor();B=this.getHoverBackgroundColor();}s=s||this.getColor();B=B||this.getBackgroundColor();this._addColorClass(s||"","color");this._addColorClass(B||"","background-color");};
e.prototype._addColorClass=function(s,f){var $=this.$(),t=this;var g="";if(f==="color"){g="sapUiIconColor";}else if(f==="background-color"){g="sapUiIconBGColor";}else{return;}q.each(c,function(p,P){t.removeStyleClass(g+P);});if(s in c){$.css(f,"");this.addStyleClass(g+s);}else{$.css(f,s);}};
e.prototype.setSrc=function(s){a(s==null||_.isIconURI(s),this+": Property 'src' (value: '"+s+"') should be a valid Icon URI (sap-icon://...)");return this.setProperty("src",s);};
e.prototype.setColor=function(s){if(i(s)){this.setProperty("color",s,true);this._addColorClass(s,"color");}return this;};
e.prototype.setActiveColor=function(s){if(i(s)){this.setProperty("activeColor",s,true);}return this;};
e.prototype.setHoverColor=function(s){if(i(s)){this.setProperty("hoverColor",s,true);}return this;};
e.prototype.setBackgroundColor=function(s){if(i(s)){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");}return this;};
e.prototype.setActiveBackgroundColor=function(s){if(i(s)){this.setProperty("activeBackgroundColor",s,true);}return this;};
e.prototype.setHoverBackgroundColor=function(s){if(i(s)){this.setProperty("hoverBackgroundColor",s,true);}return this;};
e.prototype.attachEvent=function(E){C.prototype.attachEvent.apply(this,arguments);if(E=="press"&&this.hasListeners("press")){this.invalidate();}return this;};
e.prototype.detachEvent=function(E){C.prototype.detachEvent.apply(this,arguments);if(E=="press"&&!this.hasListeners("press")){this.invalidate();}return this;};
e.prototype._getOutputTitle=function(o){var t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&o&&o.text)){return t||o.text;}};
e.prototype._getIconLabel=function(o){var A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),s=A||t||(u&&o&&(o.text||o.name));if(s){return s;}};
e.prototype._createInvisibleText=function(t){var o=this.getAggregation("_invisibleText");if(!o){o=new I(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",o,true);}else{o.setProperty("text",t,true);}return o;};
e.prototype._getAccessibilityAttributes=function(o){var f=this.getAriaLabelledBy(),A={},s=this._getIconLabel(o),g;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else if(this.hasListeners("press")){A.role="button";}else{A.role="img";}if(f.length>0){if(s){g=this._createInvisibleText(s);f.push(g.getId());}A.labelledby=f.join(" ");}else if(s){A.label=s;}return A;};
e.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var o=_.getIconInfo(this.getSrc(),undefined,"sync");return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(o?o.text||o.name:""),focusable:h};};
return e;});
sap.ui.predefine('sap/ui/core/IconPool',['sap/ui/core/Icon','sap/ui/core/_IconRegistry',"sap/base/Log","sap/ui/thirdparty/jquery",'./Core'],function(I,_,L,q){"use strict";var a={};
a.createControlByURI=function(s,c){if(typeof s==="string"){s={src:s};}if(s&&s.src){var S=s.src,C=c;if(a.isIconURI(S)){C=I;if(s.tap){s.press=s.tap;delete s.tap;}}if(typeof C==="function"){s=C.getMetadata().removeUnknownSettings(s);return new C(s);}}};
a.addIcon=_.addIcon;a.getIconURI=_.getIconURI;a.getIconInfo=_.getIconInfo;
a.fontLoaded=function(c){var f=_.getFontRegistry();if(f[c]){if(f[c].metadataLoaded instanceof Promise){return f[c].metadataLoaded;}else if(f[c].metadataLoaded===true){return Promise.resolve();}}};
a.isIconURI=_.isIconURI;a.getIconCollectionNames=_.getIconCollectionNames;a.getIconNames=_.getIconNames;a.insertFontFaceStyle=_.insertFontFaceStyle;
a.registerFont=function(c){c.collectionName=c.collectionName||c.fontFamily;if(!c.fontURI){L.error("The configuration parameter fontURI is missing, cannot register the font '"+c.collectionName+"'!");return;}if(c.fontFamily===_.sapIconFontFamily){L.error("The font family"+_.sapIconFontFamily+" is already registered");return;}if(c.fontURI.substr(c.fontURI.length-1)!=="/"){c.fontURI+="/";}var f=_.getFontRegistry();if(!f[c.collectionName]||f[c.collectionName].metadataLoaded===false){f[c.collectionName]={config:c,inserted:false};}else{L.warning("The font '"+c.collectionName+"' is already registered");}if(!c.lazy){_._loadFontMetadata(c.collectionName,true);}};
var i={"application/msword":"sap-icon://doc-attachment","application/vnd.openxmlformats-officedocument.wordprocessingml.document":"sap-icon://doc-attachment","application/rtf":"sap-icon://doc-attachment","application/pdf":"sap-icon://pdf-attachment","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":"sap-icon://excel-attachment","application/vnd.ms-excel":"sap-icon://excel-attachment","application/msexcel":"sap-icon://excel-attachment","application/vnd.ms-powerpoint":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.slideshow":"sap-icon://ppt-attachment","application/mspowerpoint":"sap-icon://ppt-attachment","application/xml":"sap-icon://attachment-html","application/xhtml+xml":"sap-icon://attachment-html","application/x-httpd-php":"sap-icon://attachment-html","application/x-javascript":"sap-icon://attachment-html","application/gzip":"sap-icon://attachment-zip-file","application/x-rar-compressed":"sap-icon://attachment-zip-file","application/x-tar":"sap-icon://attachment-zip-file","application/zip":"sap-icon://attachment-zip-file","audio/voxware":"sap-icon://attachment-audio","audio/x-aiff":"sap-icon://attachment-audio","audio/x-midi":"sap-icon://attachment-audio","audio/x-mpeg":"sap-icon://attachment-audio","audio/x-pn-realaudio":"sap-icon://attachment-audio","audio/x-pn-realaudio-plugin":"sap-icon://attachment-audio","audio/x-qt-stream":"sap-icon://attachment-audio","audio/x-wav":"sap-icon://attachment-audio","image/png":"sap-icon://attachment-photo","image/tiff":"sap-icon://attachment-photo","image/bmp":"sap-icon://attachment-photo","image/jpeg":"sap-icon://attachment-photo","image/gif":"sap-icon://attachment-photo","text/plain":"sap-icon://attachment-text-file","text/comma-separated-values":"sap-icon://attachment-text-file","text/css":"sap-icon://attachment-text-file","text/html":"sap-icon://attachment-text-file","text/javascript":"sap-icon://attachment-text-file","text/richtext":"sap-icon://attachment-text-file","text/rtf":"sap-icon://attachment-text-file","text/tab-separated-values":"sap-icon://attachment-text-file","text/xml":"sap-icon://attachment-text-file","video/mpeg":"sap-icon://attachment-video","video/quicktime":"sap-icon://attachment-video","video/x-msvideo":"sap-icon://attachment-video","application/x-shockwave-flash":"sap-icon://attachment-video"};
a.getIconForMimeType=function(m){return i[m]||"sap-icon://document";};
return a;},true);
sap.ui.predefine('sap/ui/core/IconRenderer',['./_IconRegistry','./library',"sap/base/security/encodeCSS"],function(_,l,e){"use strict";var I=l.IconColor;var a={apiVersion:2};
a.render=function(r,c){var i=_.getIconInfo(c.getSrc(),undefined,"mixed"),w=c.getWidth(),h=c.getHeight(),C=c.getColor(),b=c.getBackgroundColor(),s=c.getSize(),t=c._getOutputTitle(i),L,o,A,d=false;if(i instanceof Promise){i.then(c.invalidate.bind(c));}else if(i){d=true;L=c.getAriaLabelledBy();A=c._getAccessibilityAttributes(i);o=c.getAggregation("_invisibleText");}r.openStart("span",c);r.class("sapUiIcon");if(d){r.accessibilityState(c,A);r.attr("data-sap-ui-icon-content",i.content);r.style("font-family","'"+e(i.fontFamily)+"'");if(!i.suppressMirroring){r.class("sapUiIconMirrorInRTL");}}if(c.hasListeners("press")){r.class("sapUiIconPointer");if(!c.getNoTabStop()){r.attr("tabindex","0");}}r.style("width",w);r.style("height",h);r.style("line-height",h);r.style("font-size",s);if(C&&!(C in I)){r.style("color",C);}if(b&&!(b in I)){r.style("background-color",b);}r.openEnd();if(t){r.openStart("span").class("sapUiIconTitle").attr("title",t).attr("aria-hidden",true).openEnd().close("span");}if(L&&L.length&&o){r.renderControl(o);}r.close("span");};
return a;},true);
sap.ui.predefine('sap/ui/core/IndicationColorSupport',['./library'],function(l){"use strict";var I=l.IndicationColor;var a={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[I.Indication01]=r.getText("INDICATION_STATE_INDICATION01");t[I.Indication02]=r.getText("INDICATION_STATE_INDICATION02");t[I.Indication03]=r.getText("INDICATION_STATE_INDICATION03");t[I.Indication04]=r.getText("INDICATION_STATE_INDICATION04");t[I.Indication05]=r.getText("INDICATION_STATE_INDICATION05");t[I.Indication06]=r.getText("INDICATION_STATE_INDICATION06");t[I.Indication07]=r.getText("INDICATION_STATE_INDICATION07");t[I.Indication08]=r.getText("INDICATION_STATE_INDICATION08");}};
a.getAdditionalText=function(v){var i=null;if(v&&v.getValueState){i=v.getIndicationColor();}else if(I[v]){i=v;}if(i){e();return t[i];}return null;};
return a;},true);
sap.ui.predefine('sap/ui/core/InvisibleMessage',["./library","sap/ui/base/ManagedObject","sap/base/Log"],function(c,M,L){"use strict";var i;var I=c.InvisibleMessageMode;
var a=M.extend("sap.ui.core.InvisibleMessage",{constructor:function(){if(i){L.warning('This is a singleton, therefore you are not able to create another instance of this class.');return i;}i=this;M.apply(this,arguments);}});
a.getInstance=function(){if(!i){i=new a("__invisiblemessage",{});}return i;};
a.prototype.init=function(){var C=sap.ui.getCore(),s=C.getStaticAreaRef();s.insertAdjacentHTML("beforeend",this.getPoliteInstance());s.insertAdjacentHTML("beforeend",this.getAssertiveInstance());};
a.prototype.announce=function(t,m){var C=sap.ui.getCore(),s=C.getStaticAreaRef(),p=s.querySelector(".sapUiInvisibleMessagePolite"),A=s.querySelector(".sapUiInvisibleMessageAssertive");if(!p||!A){return;}var n=m===I.Assertive?A:p;n.textContent="";n.textContent=t;if(m!==I.Assertive&&m!==I.Polite){L.info('You have entered an invalid mode. Valid values are: '+'"Polite" '+'and "Assertive".'+' The framework will automatically set the mode to "Polite".');}setTimeout(function(){if(n.textContent===t){n.textContent="";}},3000);};
a.prototype.getPoliteInstance=function(){var s=this.getId();return'<span id="'+s+'-polite'+'" data-sap-ui="'+s+'-polite'+'" class="sapUiInvisibleMessagePolite" role="status" aria-live="polite">'+'</span>';};
a.prototype.getAssertiveInstance=function(){var s=this.getId();return'<span id="'+s+'-assertive'+'" data-sap-ui="'+s+'-assertive'+'" class="sapUiInvisibleMessageAssertive" role="status" aria-live="assertive">'+'</span>';};
return a;});
sap.ui.predefine('sap/ui/core/InvisibleText',["./Control","sap/base/Log","sap/base/security/encodeXML","./library"],function(C,L,a){"use strict";
var I=C.extend("sap.ui.core.InvisibleText",{
metadata:{library:"sap.ui.core",publicMethods:["toStatic"],properties:{text:{type:"string",defaultValue:""}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("span",c);r.class("sapUiInvisibleText");r.attr("aria-hidden","true");r.openEnd();r.text(c.getText()||"");r.close("span");}}
});
function m(w){return function(){L.warning(w+" is not supported by control sap.ui.core.InvisibleText.");return this;};}
I.prototype.setBusy=m("Property busy");I.prototype.setBusyIndicatorDelay=m("Property busy");I.prototype.setBusyIndicatorSize=m("Property busy");I.prototype.setVisible=m("Property visible");I.prototype.setTooltip=m("Aggregation tooltip");
I.prototype.setText=function(T){this.setProperty("text",T,true);this.$().html(a(this.getText()||""));return this;};
I.prototype.getRendererMarkup=function(){var i=this.getId();return'<span id="'+i+'" data-sap-ui="'+i+'" class="sapUiInvisibleText" aria-hidden="true">'+a(this.getText())+'</span>';};
I.prototype.toStatic=function(){var c=sap.ui.getCore();try{var s=c.getStaticAreaRef();s.insertAdjacentHTML("beforeend",this.getRendererMarkup());this.bOutput=true;}catch(e){this.placeAt("sap-ui-static");}return this;};
var t=Object.create(null);
I.getStaticId=function(l,T){var s="",k,b,o;if(sap.ui.getCore().getConfiguration().getAccessibility()&&T){k=l+"|"+T;s=t[k];if(s==null){b=sap.ui.getCore().getLibraryResourceBundle(l);o=new I().setText(b.getText(T));o.toStatic();s=t[k]=o.getId();}}return s;};
sap.ui.getCore().attachLocalizationChanged(function(e){var c=sap.ui.getCore(),k,p,b,T;for(k in t){p=k.indexOf('|');b=c.getLibraryResourceBundle(k.slice(0,p));T=c.byId(t[k]);T&&T.setText(b.getText(k.slice(p+1)));}});return I;});
sap.ui.predefine('sap/ui/core/Item',['./Element','./library'],function(E,l){"use strict";var T=l.TextDirection;
var I=E.extend("sap.ui.core.Item",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Misc",defaultValue:T.Inherit},key:{type:"string",group:"Data",defaultValue:null}}}});
return I;});
sap.ui.predefine('sap/ui/core/LayoutData',['./Element',"sap/ui/thirdparty/jquery",'./library'],function(E,q){"use strict";
var L=E.extend("sap.ui.core.LayoutData",{metadata:{"abstract":true,library:"sap.ui.core"}});
L.prototype.invalidate=function(){var p=this.getParent();if(p&&p.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){p=p.getParent();}if(p){var l=p.getParent();if(l){var e=q.Event("LayoutDataChange");e.srcControl=p;l._handleEvent(e);}}};
L.prototype.setLayoutData=function(l){return this;};
return L;});
sap.ui.predefine('sap/ui/core/ListItem',['./Item','./library'],function(I){"use strict";
var L=I.extend("sap.ui.core.ListItem",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},additionalText:{type:"string",group:"Data",defaultValue:null}}}});
return L;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicator',['./Control','./theming/Parameters',"./LocalBusyIndicatorRenderer",'./library'],function(C,P,L){"use strict";
var a=C.extend("sap.ui.core.LocalBusyIndicator",{
metadata:{deprecated:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'}}},
renderer:L
});
a.prototype.init=function(){var r="sap.ui.core.LocalBusyIndicator:";var p="sapUiLocalBusyIndicatorBoxSize";p=P.get(r+p);this._iBoxSize=8;p="sapUiLocalBusyIndicatorBoxColor";this._sBoxColor=P.get(r+p);p="sapUiLocalBusyIndicatorBoxColorActive";this._sBoxColorActive=P.get(r+p);this._animateProxy=A.bind(this);};
a.prototype.exit=function(){clearTimeout(this._delayedCallId);delete this._delayedCallId;};
a.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype.onAfterRendering=function(){var w=parseInt(this.getWidth());var h=parseInt(this.getHeight());var $=this.$();$.css("width",w+"px");$.css("height",h+"px");var b=this.$("animation");var l=Math.floor(w/2);l-=Math.floor((5*this._iBoxSize)/2);var t=Math.floor(h/2)-Math.floor(this._iBoxSize/2);b.css("left",l+"px");b.css("top",t+"px");if(!this._$left){this._$left=this.$("leftBox");}if(!this._$middle){this._$middle=this.$("middleBox");}if(!this._$right){this._$right=this.$("rightBox");}this._delayedCallId=setTimeout(this._animateProxy,0);};
var A=function(){if(this.getDomRef()){var t=this;var $,b,c;var d="",e="";if(t._$left){$=t._$left;}else{return;}if(t._$middle){b=t._$middle;}else{return;}if(t._$right){c=t._$right;}else{return;}if(t._sBoxColor){d=t._sBoxColor;}else{return;}if(t._sBoxColorActive){e=t._sBoxColorActive;}else{return;}$.css("background-color",e);setTimeout(function(){$.css("background-color",d);b.css("background-color",e);setTimeout(function(){b.css("background-color",d);c.css("background-color",e);setTimeout(function(){c.css("background-color",d);},150);},150);},150);this._delayedCallId=setTimeout(this._animateProxy,1200);}};return a;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorRenderer',function(){"use strict";var r=function(R,c){var I=c.getId();var s=I+"-animation";var b=["-leftBox","-middleBox","-rightBox"];R.openStart('div',s);R.class("sapUiLocalBusyIndicatorAnimation");R.openEnd();for(var i=0;i<b.length;i++){R.openStart('div',I+b[i]);R.class("sapUiLocalBusyIndicatorBox");R.openEnd();R.close("div");}R.close("div");};var L={apiVersion:2};
L.render=function(R,c){R.openStart("div",c);R.class("sapUiLocalBusyIndicator");R.openEnd();r(R,c);R.close("div");};
return L;},true);
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorSupport',['./Control',"sap/base/Log"],function(C,L){"use strict";var a=function(){if(this===C.prototype){this.setDelay=this.setBusyIndicatorDelay;}else{L.error("Only controls can use the LocalBusyIndicator",this);}};return a;},true);
sap.ui.predefine('sap/ui/core/LocaleData',['sap/base/util/extend','sap/ui/base/Object','./CalendarType','./Locale','sap/base/assert','sap/base/util/LoaderExtensions'],function(e,B,C,L,a,b){"use strict";
var c=B.extend("sap.ui.core.LocaleData",{
constructor:function(o){this.oLocale=o;B.apply(this);this.mData=h(o);},
_get:function(){return this._getDeep(this.mData,arguments);},
_getMerged:function(){return this._get.apply(this,arguments);},
_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},
getOrientation:function(){return this._get("orientation");},
getCurrentLanguageName:function(){var o=this.getLanguages();var s;var i=this.oLocale.getModernLanguage();var S=this.oLocale.getScript();if(i==="sr"&&S==="Latn"){i="sh";S=null;}if(this.oLocale.getRegion()){s=o[i+"_"+this.oLocale.getRegion()];}if(!s&&S){s=o[i+"_"+S];}if(!s){s=o[i];}return s;},
getLanguages:function(){return this._get("languages");},
getScripts:function(){return this._get("scripts");},
getTerritories:function(){return this._get("territories");},
getMonths:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","format",w);},
getMonthsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","stand-alone",w);},
getDays:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(g(s),"days","format",w);},
getDaysStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(g(s),"days","stand-alone",w);},
getQuarters:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","format",w);},
getQuartersStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","stand-alone",w);},
getDayPeriods:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","format",w);},
getDayPeriodsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","stand-alone",w);},
getDatePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateFormats",s);},
getTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"timeFormats",s);},
getDateTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateTimeFormats",s);},
getCombinedDateTimePattern:function(D,t,s){a(D=="short"||D=="medium"||D=="long"||D=="full","sStyle must be short, medium, long or full");a(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(D,s),j=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return i.replace("{0}",T).replace("{1}",j);},
getCustomDateTimePattern:function(s,i){var A=this._get(g(i),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,i);},
getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),j,n,D,o,p;if(i){j=i.split("-");n=j[0];D=j[1];o=I[n];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},
getCombinedIntervalPattern:function(p,s){var i=this._get(g(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},
getCustomIntervalPattern:function(s,G,i){var A=this._get(g(i),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,i,G);},
_getFormatPattern:function(s,A,i,D){var p,P,I;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}I=A[s];p=I&&I[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(K){return p[K];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,i,D);}if(P&&P.length===1){return P[0];}return P;},
_createFormatPattern:function(s,A,j,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,n,S,G,P,q,r,u,v=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,w,i;if(D){if(typeof D==="string"){u=d[D]?d[D].group:"";if(u){w=m[u].index>t[t.length-1].index;}r=D;}else{w=true;if(t[0].symbol==="y"&&o&&o.pattern.G){S=d["G"];G=m[S.group];t.splice(0,0,{symbol:"G",group:S.group,match:S.match,index:G.index,field:G.field,length:1});}for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){w=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){r=T.symbol;break;}}if((r=="h"||r=="K")&&D.DayPeriod){r="a";}}if(w){return[this.getCustomDateTimePattern(s,j)];}if(o&&o.missingTokens.length===0){P=o.pattern[r];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){n=this._get(g(j),"dateTimeFormats","availableFormats");if(v.test(s)&&"ahHkKjJms".indexOf(r)>=0){P=this._getMixedFormatPattern(s,n,j,D);}else{q=this._getFormatPattern(s,n,j);P=this.getCombinedIntervalPattern(q,j);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(v.test(s)){p=[this._getMixedFormatPattern(s,A,j)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,j);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},
_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=d[S];G=m[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},
_findBestMatch:function(t,s,A){var T,j,o,n,p,D,q,F,r,u,v={distance:10000,firstDiffPos:-1};for(var w in A){if(w==="intervalFormatFallback"||w.indexOf("B")>-1){continue;}T=this._parseSkeletonFormat(w);D=0;j=[];q=true;if(t.length<T.length){continue;}p=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];n=T[p];if(F===t.length){F=i;}if(n){r=d[o.symbol];u=d[n.symbol];if(o.symbol===n.symbol){if(o.length===n.length){if(F===i){F=t.length;}}else{if(o.length<r.numericCeiling?n.length<u.numericCeiling:n.length>=u.numericCeiling){D+=Math.abs(o.length-n.length);}else{D+=5;}}p++;continue;}else{if(o.match==n.match){D+=Math.abs(o.length-n.length)+10;p++;continue;}}}j.push(o);D+=50-i;}if(p<T.length){q=false;}if(q&&(D<v.distance||(D===v.distance&&F>v.firstDiffPos))){v.distance=D;v.firstDiffPos=F;v.missingTokens=j;v.pattern=A[w];v.patternTokens=T;}}if(v.pattern){return v;}},
_expandFields:function(p,P,t){var s=(typeof p==="string");var n;if(s){n=[p];}else{n=p;}var r=n.map(function(o){var G={},q={},R="",Q=false,i=0,S,u,v,N,w,x,y,z;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){q[T.group]=T;});while(i<o.length){z=o.charAt(i);if(Q){R+=z;if(z=="'"){Q=false;}}else{y=d[z];if(y&&G[y.group]&&q[y.group]){w=G[y.group];x=q[y.group];S=w.length;v=x.length;u=1;while(o.charAt(i+1)==z){i++;u++;}if(S===v||((S<y.numericCeiling)?(u>=y.numericCeiling):(u<y.numericCeiling))){N=u;}else{N=Math.max(u,S);}for(var j=0;j<N;j++){R+=z;}}else{R+=z;if(z=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},
_appendItems:function(p,j,s){var A=this._get(g(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,n,o;j.forEach(function(t){n=A[t.group];D="'"+this.getDisplayName(t.field)+"'";o="";for(var i=0;i<t.length;i++){o+=t.symbol;}p[I]=n.replace(/\{0\}/,P).replace(/\{1\}/,o).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},
_getMixedFormatPattern:function(s,A,i,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,j=/MMMM|LLLL/,n=/MMM|LLL/,o=/E|e|c/,R,p,t,S,q,T,u,v;R=r.exec(s);p=R[1];t=R[2];q=this._getFormatPattern(p,A,i);if(D){T=this.getCustomIntervalPattern(t,D,i);}else{T=this._getFormatPattern(t,A,i);}if(j.test(p)){S=o.test(p)?"full":"long";}else if(n.test(p)){S="medium";}else{S="short";}u=this.getDateTimePattern(S,i);v=u.replace(/\{1\}/,q).replace(/\{0\}/,T);return v;},
getNumberSymbol:function(t){a(t=="decimal"||t=="group"||t=="plusSign"||t=="minusSign"||t=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+t);},
getLenientNumberSymbols:function(t){a(t=="plusSign"||t=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[t];},
getDecimalPattern:function(){return this._get("decimalFormat").standard;},
getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},
getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},
getPercentPattern:function(){return this._get("percentFormat").standard;},
getMiscPattern:function(n){a(n=="approximately"||n=="atLeast"||n=="atMost"||n=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[n];},
getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},
getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},
getWeekendStart:function(){return this._get("weekData-weekendStart");},
getWeekendEnd:function(){return this._get("weekData-weekendEnd");},
getCustomCurrencyCodes:function(){var i=this._get("currency")||{},j={};Object.keys(i).forEach(function(s){j[s]=s;});return j;},
getCurrencyDigits:function(s){var i=this._get("currency");if(i){if(i[s]&&i[s].hasOwnProperty("digits")){return i[s].digits;}else if(i["DEFAULT"]&&i["DEFAULT"].hasOwnProperty("digits")){return i["DEFAULT"].digits;}}var D=this._get("currencyDigits",s);if(D==null){D=this._get("currencyDigits","DEFAULT");if(D==null){D=2;}}return D;},
getCurrencySymbol:function(s){var o=this.getCurrencySymbols();return(o&&o[s])||s;},
getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),i;for(i in o){if(o[i]===s){return i;}}return s;},
getCurrencySymbols:function(){var i=this._get("currency"),j={},I;for(var s in i){I=i[s].isoCode;if(i[s].symbol){j[s]=i[s].symbol;}else if(I){j[s]=this._get("currencySymbols")[I];}}return Object.assign({},this._get("currencySymbols"),j);},
getUnitDisplayName:function(u){var U=this.getUnitFormat(u);return(U&&U["displayName"])||"";},
getRelativePatterns:function(s,S){if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(j){o=this._get("dateFields",j+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14));p.push({scale:j,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(K){p.push({scale:j,sign:i,pattern:t["relativeTimePattern-count-"+K]});});}}}.bind(this));return p;},
getRelativePattern:function(s,D,F,S){var p,t,K,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");K=s+"-"+S;if(D===0||D===-2||D===2){p=this._get("dateFields",K,"relative-type-"+D);}if(!p){t=this._get("dateFields",K,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},
getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},
getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},
getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},
getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},
getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},
getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},
getDisplayName:function(t,s){a(t=="second"||t=="minute"||t=="hour"||t=="zone"||t=="day"||t=="weekday"||t=="week"||t=="month"||t=="quarter"||t=="year"||t=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(s===undefined){s="wide";}a(s==="wide"||s==="short"||s==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var S=["era","weekday","zone"],K=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",K,"displayName");},
getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},
getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getCurrencyFormat:function(s,n,p){var F;var o=this._get("currencyFormat-"+s);if(!o){if(s==="sap-short"){throw new Error("Failed to get CLDR data for property \"currencyFormat-sap-short\"");}o=this._get("currencyFormat-short");}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getListFormat:function(t,s){var F=this._get("listPattern-"+(t||"standard")+"-"+(s||"wide"));if(F){return F;}return{};},
getResolvedUnitFormat:function(u){u=this.getUnitFromMapping(u)||u;return this.getUnitFormat(u);},
getUnitFormat:function(u){return this._get("units","short",u);},
getUnitFormats:function(){return this._getMerged("units","short");},
getUnitFromMapping:function(s){return this._get("unitMappings",s);},
getEras:function(w,s){a(w=="wide"||w=="abbreviated"||w=="narrow","sWidth must be wide, abbreviate or narrow");var E=this._get(g(s),"era-"+w),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},
getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},
getCalendarWeek:function(s,w){a(s=="wide"||s=="narrow","sStyle must be wide or narrow");var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),K="date.week.calendarweek."+s;return o.getText(K,w);},
firstDayStartsFirstWeek:function(){return this._get("weekData-algorithm")==="FIRSTDAY_STARTS_FIRSTWEEK";},
getPreferredCalendarType:function(){var s=this._get("calendarPreference"),j=s?s.split(" "):[],n,t,i;for(i=0;i<j.length;i++){n=j[i].split("-")[0];for(t in C){if(n===t.toLowerCase()){return t;}}}return C.Gregorian;},
getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},
getPluralCategories:function(){var p=this._get("plurals"),i=Object.keys(p);i.push("other");return i;},
getPluralCategory:function(n){var p=this._get("plurals");if(typeof n==="number"){n=n.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(n)){return s;}}return"other";},
_parsePluralRule:function(r){var O="or",j="and",n="%",p="=",q="!=",s="n",t="i",u="f",v="t",w="v",x="w",R="..",S=",";var i=0,T;T=r.split(" ");function y(o){if(T[i]===o){i++;return true;}return false;}function z(){var o=T[i];i++;return o;}function A(){var J,I;J=D();if(y(O)){I=A();return function(o){return J(o)||I(o);};}return J;}function D(){var J,K;J=E();if(y(j)){K=D();return function(o){return J(o)&&K(o);};}return J;}function E(){var J,K,N;J=F();if(y(p)){N=true;}else if(y(q)){N=false;}else{throw new Error("Expected '=' or '!='");}K=H();if(N){return function(o){return K(o).indexOf(J(o))>=0;};}else{return function(o){return K(o).indexOf(J(o))===-1;};}}function F(){var J;J=G();if(y(n)){var K=parseInt(z());return function(o){return J(o)%K;};}return J;}function G(){if(y(s)){return function(o){return o.n;};}else if(y(t)){return function(o){return o.i;};}else if(y(u)){return function(o){return o.f;};}else if(y(v)){return function(o){return o.t;};}else if(y(w)){return function(o){return o.v;};}else if(y(x)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+z());}}function H(){var V=[],J=z(),P=J.split(S),K,N,Q;P.forEach(function(o){K=o.split(R);if(K.length===1){V.push(parseInt(o));}else{N=parseInt(K[0]);Q=parseInt(K[1]);for(var i=N;i<=Q;i++){V.push(i);}}});return function(o){return V;};}var I=A();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var J=V.indexOf("."),K,N,P,o;if(J===-1){K=V;N="";P="";}else{K=V.substr(0,J);N=V.substr(J+1);P=N.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(K),v:N.length,w:P.length,f:parseInt(N),t:parseInt(P)};return I(o);};}
});
var m={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var d={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"iw":"he","ji":"yi"};var f=(function(){var j=L._cldrLocales,r={},i;if(j){for(i=0;i<j.length;i++){r[j[i]]=true;}}return r;}());var l={};
function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}
function h(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function i(n,p){var q,v,t;if(!p){return;}for(q in p){if(p.hasOwnProperty(q)){v=n[q];t=p[q];if(v===undefined){n[q]=t;}else if(v===null){delete n[q];}else if(typeof v==='object'&&typeof t==='object'){i(v,t);}}}}function j(I){if(!l[I]&&(!f||f[I]===true)){var n=l[I]=b.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(n&&n.__fallbackLocale){i(n,j(n.__fallbackLocale));delete n.__fallbackLocale;}}return l[I];}s=(s&&M[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}if(s==="sh"||(s==="sr"&&S==="Latn")){s="sr_Latn";}var I=s+"_"+r;if(s&&r){D=j(I);}if(!D&&s){D=j(s);}l[I]=D||j("en");return l[I];}
var k=c.extend("sap.ui.core.CustomLocaleData",{
constructor:function(o){c.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},
_get:function(){var A=Array.prototype.slice.call(arguments),s,K;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}K=A.join("-");var v=this.mCustomData[K];if(v==null){v=this._getDeep(this.mCustomData,arguments);if(v==null){v=this._getDeep(this.mData,arguments);}}return v;},
_getMerged:function(){var D=this._getDeep(this.mData,arguments);var i=this._getDeep(this.mCustomData,arguments);return e({},D,i);}
});
c.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new k(o):new c(o);};
return c;});
sap.ui.predefine('sap/ui/core/Message',['./Element','./library',"sap/base/Log"],function(E,l,L){"use strict";var M=l.MessageType;
var a=E.extend("sap.ui.core.Message",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},level:{type:"sap.ui.core.MessageType",group:"Misc",defaultValue:M.None},readOnly:{type:"boolean",group:"Misc",defaultValue:false}}}});
a.prototype.getDefaultIcon=function(s){var m=sap.ui.require.toUrl("sap/ui/core/themes/"+sap.ui.getCore().getConfiguration().getTheme());var i=m+"/img/message/";if(s&&s=="32x32"){i+="32x32/";}else{i+="16x16/";}var u="";switch(this.getProperty("level")){case M.Error:u=i+"Message_Icon_Error.png";break;case M.Information:u=i+"Message_Icon_Information.png";break;case M.Warning:u=i+"Message_Icon_Warning.png";break;case M.Success:u=i+"Message_Icon_Success.png";break;case M.None:default:u=this.getProperty("icon");break;}return u;};
a.prototype.compareByType=function(o){return a.compareByType(this,o);};
a.compareByType=function(m,o){if(!m&&!o){return 0;}if(m&&!o){return 1;}if(!m&&o){return-1;}var s=m.getLevel();var b=o.getLevel();if(s===b){return 0;}switch(s){case M.Error:return 1;case M.Warning:return b===M.Error?-1:1;case M.Success:return b===M.Error||b===M.Warning?-1:1;case M.Information:return b===M.None?1:-1;case M.None:return-1;default:L.error("Comparison error",this);return 0;}};
return a;});
sap.ui.predefine('sap/ui/core/Placeholder',['sap/ui/base/Object','sap/base/util/Deferred','sap/base/util/LoaderExtensions','sap/ui/core/BlockLayerUtils'],function(B,D,L,a){"use strict";var p=[];
var P=B.extend("sap.ui.core.Placeholder",{
constructor:function(m){B.call(this);if(!m.html){throw new Error("A HTML page defining the placeholders content must be given!");}this.bShow=false;this.placeholderHTML=m.html;},
show:function(c,b){this.bShow=true;return this._load().then(function(s){if(s&&this.bShow&&!c.getDomRef().contains(this.placeholder)){if(this.blockState){a.unblock(this.blockState);}this.blockState=a.block(c,c.getId()+"--placeholder",b);var d=this.blockState.$blockLayer[0];d.className+=" sapUiPlaceholder";d.insertAdjacentHTML("beforeend",s);this.placeholder=d;}return s;}.bind(this));},
hide:function(){this.bShow=false;if(this.placeholder&&this.blockState){a.unblock(this.blockState);this.placeholder=undefined;this.blockState=undefined;}if(this.pLoaded){this.pLoaded.resolve();}},
_load:function(){if(!this.pLoaded){this.pLoaded=new D();if(this.placeholderHTML){L.loadResource(this.placeholderHTML,{async:true,dataType:"html"}).then(function(s){this.placeholderContent=s;this.pLoaded.resolve(s);}.bind(this));}else{this.pLoaded.reject();}}return this.pLoaded.promise;}
});
P.registerProvider=function(f){p.push(f);};
P.hasProviders=function(){return p.length>0;};
P.getPlaceholderFromProviders=function(c){var o;if(c){p.some(function(f){o=f(c);return!!o;});}return o;};
return P;});
sap.ui.predefine('sap/ui/core/Popup',['sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','./library',"sap/base/assert","sap/base/Log","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/deepExtend","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(D,M,B,O,C,I,R,E,a,b,c,L,V,u,d,f,g,q,F,h,k){"use strict";var m=b.CSSSize;var n=b.OpenState;var s;var G;var r;var o="sapUiPopupResize";if(window.ResizeObserver){r=new window.ResizeObserver(function(e){w(q("#sap-ui-blocklayer-popup"),e[0].target);});}else{r={observe:function(e){var i=e.dataset[o];if(!i){i=a.register(e,function(j){w(q("#sap-ui-blocklayer-popup"),j.target);});e.dataset[o]=i;}},unobserve:function(e){var i=e.dataset[o];if(i){a.deregister(i);delete e.dataset[o];}}};}
function p(){if(s){return s;}var S,i;try{S=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(S);}catch(e){L.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}i=new C();s.addDependent(i);s=i.getUIArea();i.destroy();return s;}
function t(W){var e;if(typeof W==="string"){e=document.querySelector(W);}else if(W instanceof E){e=W.getDomRef();}else{e=W;}return e||window;}
function v($){var e=["left","top","width","height","position"];if($[0]){e.forEach(function(i){$[0].style.removeProperty(i);});}}
function w($,W){var e=W.getBoundingClientRect();$.css({width:e.width,height:e.height,display:"block",position:"absolute"}).position({my:"left top",at:"left top",of:W});}
var P=M.extend("sap.ui.core.Popup",{
constructor:function(e,i,S,j){c(arguments.length==0||(e&&typeof e==="object"),"oContent must be an object or there may be no arguments at all");c((i===undefined||i===true||i===false),"bModal must be true, false, or undefined");c((S===undefined||S===true||S===false),"bShadow must be true, false, or undefined");c((j===undefined||j===true||j===false),"bAutoClose must be true, false, or undefined");M.apply(this);this._popupUID=u();this.bOpen=false;this.eOpenState=n.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(e){this.setContent(e);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!i;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(S)==="boolean"?S:true;this._bAutoClose=!!j;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(l){if(l.isMarked("delayedMouseEvent")||l.isMarked("cancelAutoClose")){return;}if(this.eOpenState===n.CLOSING||this.eOpenState===n.CLOSED){return;}if(!this._contains(l.target)){this.close();}};}this._F6NavigationHandler=function(l){var J={},K=this._sF6NavMode,N;if(K=="DOCK"){if(this._bModal){K="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){N=this._getOfDom(this._oLastPosition.of);if(!N||N===document){N=null;K="NONE";}}}switch(K){case"SCOPE":J.scope=this._$()[0];break;case"DOCK":J.target=N;var $=q(N).parents("[data-sap-ui-popup]");J.scope=$.length?$[0]:null;break;default:J.skip=true;}F.handleF6GroupNavigation(l,J);};},
metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}
});
P.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[]);};
P.prototype.addChildPopup=function(e){return this.addAssociation("childPopups",e);};
P.prototype.removeChildPopup=function(e){return this.removeAssociation("childPopups",e);};
P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch&&(D.browser.safari||!D.system.combi);P.prototype.preventBrowserFocus=D.support.touch&&!D.system.combi;
B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var e=this.getDomString();this._$Ref=q(e).appendTo(sap.ui.getCore().getStaticAreaRef());}});
P.Layer.prototype.init=function(e,Z){this._$Ref.css({"visibility":"visible","z-index":Z});this.update(e,Z);this._$Ref.insertAfter(e).show();};
P.Layer.prototype.update=function(e,Z){if(e.length){var i=e.rect();this._$Ref.css({"left":i.left,"top":i.top});if(e.css("right")!="auto"&&e.css("right")!="inherit"){this._$Ref.css({"right":e.css("right"),"width":"auto"});}else{this._$Ref.css({"width":i.width,"right":"auto"});}if(e.css("bottom")!="auto"&&e.css("bottom")!="inherit"){this._$Ref.css({"bottom":e.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":i.height,"bottom":"auto"});}if(typeof(Z)==="number"){this._$Ref.css("z-index",Z);}}};
P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};
P.Layer.prototype.getDomString=function(){L.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};
P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});
P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+u()+"\"></div>";};
P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var i=Math.pow(2,32)-1;
P.setInitialZIndex=function(e){if(e>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(e,this.getLastZIndex());};
P.getLastZIndex=function(){return l;};
P.prototype.getLastZIndex=function(){return P.getLastZIndex();};
P.getNextZIndex=function(){l+=10;if(l>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};
P.prototype.getNextZIndex=function(){return P.getNextZIndex();};
}());var x=function(e,i){if((!e&&i)||(e&&!i)){return false;}if(!e&&!i){return true;}var j=3;var l=Math.abs(e.left-i.left);var T=Math.abs(e.top-i.top);var W=Math.abs(e.width-i.width);var J=Math.abs(e.height-i.height);if(l>j||T>j||W>j||J>j){return false;}return true;};
P.prototype.open=function(i,e,j,l,J,K,N,Q){c(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=n.CLOSED){return;}if(typeof(i)=="string"){Q=N;N=K;K=J;J=l;l=j;j=e;e=i;i=-1;}if(typeof N==="boolean"||typeof N==="function"||N===P.CLOSE_ON_SCROLL){Q=N;N=undefined;}if(i===undefined){i=-1;}c(i===-1||(typeof i==="number"&&i%1==0),"iDuration must be an integer (or omitted)");c(e===undefined||typeof e==="string","my must be a string or empty");c(j===undefined||typeof j==="string","at must be a string or empty");c(!l||typeof l==="object"||typeof l==="function","of must be empty or an object");c(!J||typeof J==="string","offset must be empty or a string");c(!K||typeof K==="string","collision must be empty or a string");c(!N||N===window||typeof N==="string"||N instanceof E||N instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");c(!Q||typeof Q==="boolean"||typeof Q==="function"||Q===P.CLOSE_ON_SCROLL,"followOf must be either empty or a boolean");this.eOpenState=n.OPENING;var s=p(),U;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof C){if(!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return s;};this._bUIAreaPatched=true;}U=this.oContent.getUIArea();if(P._bEnableUIAreaCheck&&U.getRootNode().id!==s.getRootNode().id){L.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(l)||this.isInPopup(this._oPosition.of)){var S=this.getParentPopupId(l)||this.getParentPopupId(this._oPosition.of);var T="";var W=this.getContent();if(W instanceof E){T=W.getId();}else if(typeof W==="object"){T=W.id;}this.addChildToPopup(S,T);this.addChildToPopup(S,this._popupUID);}var $=this._$(true);var X="fast";if((i===0)||(i>0)){X=i;}else if((this._durations.open===0)||(this._durations.open>0)){X=this._durations.open;}var Y;if(e||j||l||J||K||N){Y=this._createPosition(e,j,l,J,K,N);this._oPosition=Y;}else{Y=this._oPosition;if(!this._bOwnWithin&&G){this._oPosition.within=G;}}if(!Y.of){Y.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var Z=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==Z)){$.appendTo(Z);}$.css("z-index",this._iZIndex);L.debug("position popup content "+$.attr("id")+" at "+JSON.stringify(Y.at));this._applyPosition(Y);if(Q!==undefined){this.setFollowOf(Q);}$.toggleClass("sapUiShd",this._bShadow);var a1=$[0];if(a1){a1.style.display="none";a1.style.visibility="visible";}var b1=X==0;this._duringOpen(!b1);if(b1){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,X,this._opened.bind(this));}else{$.fadeIn(X,this._opened.bind(this));}};
P.prototype._getDomRefToFocus=function(){var $=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=sap.ui.getCore().byId(this._sInitialFocusId);if(i){e=i.getFocusDomRef();}e=e||window.document.getElementById(this._sInitialFocusId);}e=e||$.firstFocusableDomRef();}return e;};
P.prototype._opened=function(){if(this.eOpenState!==n.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus();}var i=this._getOfDom(this._oLastPosition.of);var j=q(i).rect();if(this._oLastOfRect&&j&&!x(this._oLastOfRect,j)){this._applyPosition(this._oLastPosition);}}this.eOpenState=n.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this.fireOpened();};
P.prototype._duringOpen=function(e){var $=this._$(false,true),S=sap.ui.getCore().getStaticAreaRef(),i=document.getElementById(S.id+"-firstfe");P._clearSelection();this._setupUserSelection();if(h()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}.bind(this),500);}if(this._bModal){this._showBlockLayer();}if(!this.touchEnabled&&e&&i&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){i.focus({preventScroll:true});}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};
P.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId;};
P.prototype._contains=function(e){var i=this._$().get(0);if(!i){return false;}var j=g(i,e);var l;if(!j){l=this.getChildPopups();j=l.some(function(J){var K=(J?window.document.getElementById(J):null);var j=g(K,e);if(!j){var N="sap.ui.core.Popup.contains-"+J;var Q={domRef:e};sap.ui.getCore().getEventBus().publish("sap.ui",N,Q);j=Q.contains;}return j;});}if(!j){A.forEach(function(S){j=j||q(e).closest(S).length>0;});}return j;};
P.prototype._containsEventBusWrapper=function(e,i,j){j.contains=this._contains(j.domRef);};
P.prototype.onFocusEvent=function(e){var i=q.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=q.event.fix(arguments[2]);}var j=(i.type=="focus"||i.type=="activate")?"focus":"blur";var l=false;if(j=="focus"){var J=this._$().get(0);if(J){l=this._contains(i.target);L.debug("focus event on "+i.target.id+", contains: "+l);if(this._bModal&&!l){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus();}}.bind(this),0);}else{J.focus();}}}}else if(this._bAutoClose&&l&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}}}else if(j=="blur"){L.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return;}var K=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(K,"autocloseBlur");var N=this._oLastPosition&&this._oLastPosition.of;if(N){var Q=this.getParentPopupId(N);if(Q){var S="sap.ui.core.Popup.onFocusEvent-"+Q;sap.ui.getCore().getEventBus().publish("sap.ui",S,i);}}}.bind(this),K);}}}};
P.prototype.setInitialFocusId=function(i){c(!i||typeof i==="string","sId must be a string or empty");this._sInitialFocusId=i;};
P.prototype.close=function(i){if(P._autoCloseDebug){return;}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}c(i===undefined||(typeof i==="number"&&(i%1==0)),"iDuration must be empty or an integer");if(this.eOpenState==n.CLOSED||this.eOpenState==n.CLOSING){return;}var e="fast";if((i===0)||(i>0)){e=i;}else if((this._durations.close===0)||(this._durations.close>0)){e=this._durations.close;}this.eOpenState=n.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent){if(this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);S.removeContent(S.indexOfContent(this.oContent),true);}else if(this._bUIAreaPatched){delete this.oContent.getUIArea;}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(h()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}.bind(this),500);}if(this.isInPopup(this._oLastPosition.of)){var j=this.getParentPopupId(this._oLastPosition.of);var l="";var J=this.getContent();if(J instanceof E){l=J.getId();}else if(typeof J==="object"){l=J.id;}this.removeChildFromPopup(j,l);this.removeChildFromPopup(j,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(K){K.preventDefault();});}this._duringClose();if(e==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,e,this._closed.bind(this));}else{$.fadeOut(e,this._closed.bind(this));}};
P.prototype._closed=function(){var $=this._$(false,true);if(this._bModal){this._hideBlockLayer();}P._clearSelection();this._restoreUserSelection();if($.length){var e=$.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}$=this._$(false,true);e=$.length?$[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=n.CLOSED;var i=this.getChildPopups();for(var j=0,l=i.length;j<l;j++){this.closePopup(i[j]);}this.fireClosed();};
P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
P.getCurrentFocusInfo=function(){var e=null;var i=sap.ui.getCore().getCurrentFocusedControlId();if(i){var j=sap.ui.getCore().byId(i);e={'sFocusId':i,'oFocusInfo':j?j.getFocusInfo():{}};}else{var l=document.activeElement;e={'sFocusId':l.id,'oFocusedElement':l,'oFocusInfo':{}};}if(e){e.popup=this;}return e;};
P.applyFocusInfo=function(e){var i={preventScroll:true};if(e){var j=sap.ui.getCore().byId(e.sFocusId);if(j){j.applyFocusInfo(Object.assign(i,e.oFocusInfo));}else{var l=((e.sFocusId?window.document.getElementById(e.sFocusId):null))||e.oFocusedElement;if(l){l.focus(i);}}}};
P.prototype.setContent=function(e){c(typeof e==="object","oContent must be an object");this.oContent=e;return this;};
P.prototype.getContent=function(){return this.oContent;};
P.prototype.setPosition=function(e,i,j,l,J,K){c(typeof e==="string","my must be a string");c(typeof i==="string"||(typeof i==="object"&&(typeof i.left==="number")&&(typeof i.top==="number")),"my must be a string or an object with 'left' and 'top' properties");c(!j||typeof j==="object"||typeof j==="function","of must be empty or an object");c(!l||typeof l==="string","offset must be empty or a string");c(!J||typeof J==="string","collision must be empty or a string");c(!K||K===window||typeof K==="string"||K instanceof E||K instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");this._oPosition=this._createPosition(e,i,j,l,J,K);if(this.eOpenState!=n.CLOSED){this._applyPosition(this._oPosition);}return this;};
P.prototype._createPosition=function(e,i,j,l,J,K){var N=false;if(e&&(e.indexOf("+")>=0||e.indexOf("-")>=0)){N=true;if(l&&l!="0 0"){L.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}l=null;}var Q=d({},this._oDefaultPosition,{my:e||this._oDefaultPosition.my,at:i||this._oDefaultPosition.at,of:j,offset:l,collision:J});if(K||G){Q.within=K||G;}this._bOwnWithin=!!K;if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(X,Y){P._bNewOffset=(Y!==undefined);}});}}var S=[];var T=[];if(P._bNewOffset||V(q.ui.version).compareTo("1.8.23")>0){if(l&&l!="0 0"){S=Q.my.split(" ");T=l.split(" ");var U=[parseInt(T[0])<0?"":"+",parseInt(T[1])<0?"":"+"];Q.my=S[0]+U[0]+T[0]+" "+S[1]+U[1]+T[1];Q.offset=null;}}else if(N){S=Q.my.split(" ");T=["",""];var W=S[0].indexOf("+");if(W<0){W=S[0].indexOf("-");}if(W>=0){T[0]=S[0].slice(W);S[0]=S[0].slice(0,W);}W=S[1].indexOf("+");if(W<0){W=S[1].indexOf("-");}if(W>=0){T[1]=S[1].slice(W);S[1]=S[1].slice(0,W);}Q.my=S[0]+" "+S[1];Q.offset=T[0]+" "+T[1];}return Q;};
P.prototype._getPositionOffset=function(){var e=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var i=this._oPosition.my.split(" ");var j=i[0].indexOf("+");if(j<0){j=i[0].indexOf("-");}if(j>=0){e[0]=i[0].slice(j);}j=i[1].indexOf("+");if(j<0){j=i[1].indexOf("-");}if(j>=0){e[1]=i[1].slice(j);}}else if(this._oPosition.offset){e=this._oPosition.offset.split(" ");}return e;};
P.prototype._applyPosition=function(e){var i=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var j=e.at;var l=$.get(0);if(typeof(j)==="string"){l.style.display="block";l.style.left="";l.style.right="";$.position(this._resolveReference(this._convertPositionRTL(e,i)));this._fixPositioning(e,i);}else if(m.isValid(j.left)&&m.isValid(j.top)){$.css({"left":j.left,"top":j.top});}else if(m.isValid(j.right)&&m.isValid(j.top)){$.css({"right":j.right,"top":j.top});}else if(typeof(j.left)==="number"&&typeof(j.top)==="number"){var J=$[0];if(J&&J.style.right){var K=$[0].getBoundingClientRect().width;$.css({"right":(document.documentElement.clientWidth-(j.left+K))+"px","top":j.top+"px"});}else{$.css({"left":j.left+"px","top":j.top+"px"});}}this._oLastPosition=e;this._oLastOfRect=this._calcOfRect(e.of);}};
P.prototype._calcOfRect=function(e){var i=this._getOfDom(e);if(i){return q(i).rect();}return null;};
P.prototype._getOfDom=function(e){if(e instanceof q.Event){return null;}var $;if(typeof(e)==="string"){$=q(document.getElementById(e));}else if(e instanceof q){$=e;}else{$=q(e instanceof E?e.getDomRef():e);}return $[0];};
P.prototype._convertPositionRTL=function(e,i){var j=Object.assign({},e);if(i){var N=false;if(j.my&&(j.my.indexOf("+")>=0||j.my.indexOf("-")>=0)){N=true;}if((j.offset||N)&&((j.my.indexOf("begin")>-1)||(j.my.indexOf("end")>-1))&&((j.at.indexOf("begin")>-1)||(j.at.indexOf("end")>-1))){if(N){var l=j.my.split(" ");if(l.length==2){j.my="";if(l[0]){if(l[0].indexOf("begin")>-1||l[0].indexOf("end")>-1){if(l[0].indexOf("+")>-1){l[0]=l[0].replace("+","-");}else if(l[0].indexOf("-")>-1){l[0]=l[0].replace("-","+");}}j.my=l[0];}if(l[1]){if(l[1].indexOf("begin")>-1||l[1].indexOf("end")>-1){if(l[1].indexOf("+")>-1){l[1]=l[1].replace("+","-");}else if(l[1].indexOf("-")>-1){l[1]=l[1].replace("-","+");}}if(l[0]){j.my=j.my+" ";}j.my=j.my+l[1];}}}else{j.offset=this._mirrorOffset(j.offset);}}j.my=j.my.replace("begin","right").replace("end","left");j.at=j.at.replace("begin","right").replace("end","left");}else{j.my=j.my.replace("end","right").replace("begin","left");j.at=j.at.replace("end","right").replace("begin","left");}return j;};
P.prototype._mirrorOffset=function(e){var i=String(e).trim().split(/\s/);var j=parseInt(i[0]);return(-j)+" "+i[i.length-1];};
P.prototype._fixPositioning=function(e,i){var j=e.my;if(typeof(j)==="string"){if(P._isPositionFixingNeeded(j,i)){var $=this._$();var l=q(window).width()-$[0].getBoundingClientRect().width-$.offset().left;$.css({"right":l+"px","left":""});}}};
P._isPositionFixingNeeded=function(e,i){return i&&((e.indexOf("right")>-1)||(e.indexOf("begin")>-1)||(e.indexOf("center")>-1))||!i&&((e.indexOf("right")>-1)||(e.indexOf("end")>-1));};
P.prototype._resolveReference=function(e){var i,j=["of","within"];j.forEach(function(l){if(e[l]instanceof E){i=i||{};i[l]=e[l].getDomRef();}});return i?Object.assign({},e,i):e;};
P.prototype.setShadow=function(S){c(typeof S==="boolean","bShowShadow must be boolean");this._bShadow=S;if(this.eOpenState!=n.CLOSED){this._$().toggleClass("sapUiShd",S);}return this;};
P.prototype.setModal=function(e,i){c(typeof e==="boolean","bModal must be boolean");c(!i||typeof i==="string","sModalCSSClass must be empty or a string");var j=this._bModal;this._bModal=e;this._sModalCSSClass=i;if(this.isOpen()){if(j!==e){P._clearSelection();if(e){this._setupUserSelection();this._showBlockLayer();}else{this._hideBlockLayer();this._restoreUserSelection();}if(this.touchEnabled&&this._bAutoClose){if(!e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};
P.prototype.getModal=function(){return this._bModal;};
P.prototype.setNavigationMode=function(e){if(e!="NONE"&&e!="DOCK"&&e!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=e;};
P.prototype.setAutoClose=function(e){c(typeof e==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==e){if(!this._bModal){if(e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=e;return this;};
P.prototype.setExtraContent=function(e){c(Array.isArray(e),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[];}var j=function(S){return{onBeforeRendering:function(){var T=S.getDomRef();if(T&&this.isOpen()){T.removeEventListener("blur",this.fnEventHandler,true);}},onAfterRendering:function(){var T=S.getDomRef();if(T&&this.isOpen()){T.addEventListener("blur",this.fnEventHandler,true);}}};};var J,K,N,Q;for(var i=0,l=e.length;i<l;i++){K=e[i];if(K instanceof E){J=K.getId();}else if(typeof K==="object"){J=K.id;}else if(typeof K==="string"){J=K;}if(this.getChildPopups().indexOf(J)===-1){this.addChildPopup(J);Q={id:J};if(K instanceof E){N=j(K);K.addEventDelegate(N,this);Q.delegate=N;}this._aExtraContent.push(Q);}}return this;};
P.prototype.setAutoCloseAreas=P.prototype.setExtraContent;
P.prototype.setAnimations=function(e,i){c(e===null||typeof e==="function","fnOpen must be a function");c(i===null||typeof i==="function","fnClose must be a function");if(e&&(typeof(e)=="function")){this._animations.open=e;}if(i&&(typeof(i)=="function")){this._animations.close=i;}return this;};
P.prototype.setDurations=function(i,e){c(i===null||(typeof i==="number"&&(i%1==0)),"iOpenDuration must be null or an integer");c(!e||(typeof e==="number"&&(e%1==0)),"iOpenDuration must be undefined or an integer");if((i>0)||(i===0)){this._durations.open=i;}if((e>0)||(e===0)){this._durations.close=e;}return this;};
P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";
P.prototype._fnCloseOnScroll=function(e){this.close();};
P.prototype.setFollowOf=function(e){P.DockTrigger.removeListener(P.checkDocking,this);var U=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(e)==="function"){this._followOfHandler=e;U=true;}else if(typeof(e)==="boolean"){U=e;}else if(e===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;U=true;}else{this._bFollowOf=false;if(e!==null){L.error("Trying to set an invalid type to 'followOf: "+e);}}if(U&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===n.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};
P.prototype.getAutoClose=function(){return this._bAutoClose;};
P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};
P.prototype.isOpen=function(){return this.bOpen;};
P.prototype.getOpenState=function(){return this.eOpenState;};
P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aExtraContent){var e;this._aExtraContent.forEach(function(i){if(i.delegate){e=q(document.getElementById(i.id)).control(0);if(e){e.removeEventDelegate(i.delegate);}}});}M.prototype.destroy.apply(this,arguments);};
P.prototype.exit=function(){delete this._mEvents;};
P.prototype._addFocusEventListeners=function(){if(!this.fnEventHandler){this.fnEventHandler=q.proxy(this.onFocusEvent,this);}var $=this._$();var e=this.getChildPopups();var j={};var i=0,l=0;if($.length){document.addEventListener("focus",this.fnEventHandler,true);$.get(0).addEventListener("blur",this.fnEventHandler,true);for(i=0,l=e.length;i<l;i++){j=(e[i]?window.document.getElementById(e[i]):null);if(j){j.addEventListener("blur",this.fnEventHandler,true);}}}};
P.prototype._removeFocusEventListeners=function(){var $=this._$(false,true);if(!$.length){return;}var e=this.getChildPopups();var j={};var i=0,l=0;document.removeEventListener("focus",this.fnEventHandler,true);$.get(0).removeEventListener("blur",this.fnEventHandler,true);for(i=0,l=e.length;i<l;i++){j=(e[i]?window.document.getElementById(e[i]):null);if(j){j.removeEventListener("blur",this.fnEventHandler,true);}this.closePopup(e[i]);}this.fnEventHandler=null;};
P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};
P.prototype._deactivateFocusHandle=function(){if(this.fnEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};
P.prototype._registerEventBusEvents=function(){var e=this;q.each(e._mEvents,function(i,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",i,l,e);});this._bEventBusEventsRegistered=true;};
P.prototype._unregisterEventBusEvents=function(){var e=this;q.each(e._mEvents,function(i,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",i,l,e);});delete this._bEventBusEventsRegistered;};
P.prototype._addFocusableArea=function(e,i,j){if(this.getChildPopups().indexOf(j.id)===-1){this.addChildPopup(j.id);}};
P.prototype._removeFocusableArea=function(e,i,j){this.removeChildPopup(j.id);};
P.prototype._closePopup=function(e,i,j){this.close(typeof this._durations.close==="string"?0:this._durations.close);};
P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{L.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};
P.prototype._$=function(e,i){var $;if(this.oContent instanceof C){$=this.oContent.$();if(e||($.length===0&&!i)){L.info("Rendering of popup content: "+this.oContent.getId());if($.length>0){R.preserveContent($[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());$=this.oContent.$();}}else if(this.oContent instanceof E){$=this.oContent.$();}else{$=q(this.oContent);}this._setIdentity($);return $;};
function _(e){if(P._blockLayerStateProvider){P._blockLayerStateProvider.fireEvent("blockLayerStateChange",e);}}
P.attachBlockLayerStateChange=function(e,i,l){if(!P._blockLayerStateProvider){P._blockLayerStateProvider=new k();}P._blockLayerStateProvider.attachEvent("blockLayerStateChange",e,i,l);};
P.detachBlockLayerStateChange=function(e,l){if(P._blockLayerStateProvider){P._blockLayerStateProvider.detachEvent("blockLayerStateChange",e,l);}};
function y($,W){if(W===window){v($);document.documentElement.classList.add("sapUiBLyBack");}else{w($,W);W.classList.add("sapUiBLyBack");r.observe(W);}}
function z(W){if(W===window){document.documentElement.classList.remove("sapUiBLyBack");}else{W.classList.remove("sapUiBLyBack");r.unobserve(W);}}
P.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:""),W;if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(e);}var l=P.blStack[P.blStack.length-1];if(l){W=t(l.popup._oLastPosition.within);z(W);}W=t(this._oLastPosition.within);y($,W);P.blStack.push({zIndex:this._iZIndex-2,popup:this});$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();if(P.blStack.length===1){_({visible:true,zIndex:P.blStack[0].zIndex});}};
P.prototype._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e=$[0],i=this,l,W;W=t(this._oLastPosition.within);z(W);if($.length){if(P.blStack.length>1){P.blStack=P.blStack.filter(function(j){return j.popup!==i;});l=P.blStack[P.blStack.length-1];e.style.zIndex=l.zIndex;e.style.visibility="visible";e.style.display="block";W=t(l.popup._oLastPosition.within);y($,W);}else{l=P.blStack.pop();e.style.visibility="hidden";e.style.display="none";_({visible:false,zIndex:l.zIndex});}}};
P.prototype._isFocusInsidePopup=function(){var e=this._$(false).get(0);if(e&&g(e,document.activeElement)){return true;}return false;};
P.DockTrigger=I;
P.checkDocking=function(){if(this.getOpenState()===n.OPEN){var e=this._getOfDom(this._oLastPosition.of),i;if(e){if((e===window)||(e===window.document)||g(document.documentElement,e)){i=q(e).rect();}else if(e.id){var N=window.document.getElementById(e.id);var j=q(N).rect();if(j&&!x(i,j)){i=j;this._oLastPosition.of=N;}}}if(!i){this.close();return;}else if(i.left===0&&i.top===0&&i.height===0&&i.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);e=this._getOfDom(this._oLastPosition.of);i=q(e).rect();if(!i){this.close();return;}}if(this._oLastOfRect){if(!x(this._oLastOfRect,i)){if(this._followOfHandler){var l=f({},this._oLastPosition),J=f({},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:J,currentOfRect:i});}else{this._applyPosition(this._oLastPosition);}}}}};
P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};
P.prototype.onmousedown=function(e,S){if(this._bMousedownCalled&&!S){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};
P.prototype._increaseMyZIndex=function(e,j,J){var K=this.getParentPopup(this._oLastPosition.of);if(J&&J.type==="mousedown"||J&&J.isFromParentPopup||K.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(J&&!J.type||J&&J.type!="mousedown"||j==="mousedown"){var N=this.getChildPopups();for(var i=0,l=N.length;i<l;i++){this.increaseZIndex(N[i],true);}}}else if(K.length>0){var Q=q(K.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(Q,false);}};
P.prototype.onAfterRendering=function(){var e=this.getContent();var $=e instanceof E?e.$():q(e);$.toggleClass("sapUiShd",this._bShadow);P._clearSelection();this._setupUserSelection();$.css("position","absolute");this._setIdentity($);var i=$[0];var l=i.style.left;var j=i.style.right;var J=i.style.top;var K=i.style.bottom;if(!(l&&l!="auto"||j&&j!="auto"||J&&J!="auto"||K&&K!="auto")){L.debug("reposition popup content "+$.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};
P.prototype.onBeforeRendering=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};
P.prototype.isInPopup=function(e){var $=this.getParentPopup(e);return $&&$.length>0;};
P.prototype.getParentPopup=function(e){var T=e?e:this;var $=q(T instanceof E?T.getDomRef():T);return $.closest("[data-sap-ui-popup]");};
P.prototype.getParentPopupId=function(e){var $=this.getParentPopup(e);return $.attr("data-sap-ui-popup");};
P.prototype.addChildToPopup=function(e,i){var j="sap.ui.core.Popup.addFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};
P.prototype.removeChildFromPopup=function(e,i){var j="sap.ui.core.Popup.removeFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};
P.prototype.closePopup=function(e){var i="sap.ui.core.Popup.closePopup-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",i);};
P.prototype.increaseZIndex=function(e,i){var j="sap.ui.core.Popup.increaseZIndex-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{isFromParentPopup:i?i:false});};
P.prototype.focusTabChain=function(e){var S=e.event.target,N=e.that.getMetadata().getName(),i;if((!e.$FocusablesContent||!e.$FocusablesFooter)||(!e.$FocusablesContent.length&&!e.$FocusablesFooter.length)){return;}if(S.id===e.firstFocusable){L.debug("First dummy focus element was focused","",N);if(e.$FocusablesFooter.length>0){L.debug("Last footer element will be focused","",N);i=e.$FocusablesFooter[e.$FocusablesFooter.length-1];}else{L.debug("Last content element will be focused","",N);i=e.$FocusablesContent[e.$FocusablesContent.length-1];}}else if(S.id===e.lastFocusable){L.debug("Last dummy focus element was focues","",N);if(e.$FocusablesContent.length>0){L.debug("First content element will be focused","",N);i=e.$FocusablesContent[0];}else{L.debug("First footer element will be focused","",N);i=e.$FocusablesFooter[0];}}if(i){setTimeout(function(){var j=sap.ui.getCore().byId(i.id);if(j instanceof C){L.debug("Focus will be handled by "+j.getMetadata().getName(),"",N);}else{L.debug("oFocusDomRef will be focused","",N);}if(j){j.focus();}else if(i){i.focus();}return j?j.getId():i.id;},0);}};
P.prototype._setupUserSelection=function(){var $=this._$(false,true);P._markAsUserSelectable($,this._bModal||P.blStack.length>0);if(this._bModal){if(P.blStack.length>0){var l=P.blStack[P.blStack.length-1];var e=function(i){return i.popup.getId();};if(P.blStack.map(e).indexOf(this.getId())===-1){P._markAsNotUserSelectable(l.popup._$(false,true),true);}else if(l.popup.getId()!==this.getId()){P._markAsNotUserSelectable($,true);}}else{P._markAsNotUserSelectable(q("html"),true);P._markExternalContentAsUserSelectable(true);}}};
P.prototype._restoreUserSelection=function(){var $=this._$(false,true);P._markAsNotUserSelectable($,false);if(P.blStack.length>0){P._markAsUserSelectable(P.blStack[P.blStack.length-1].popup._$(false,true),true);}else{P._markAsUserSelectable(q("html"),false);P._markExternalContentAsNotUserSelectable(false);}};
P._clearSelection=function(){var S=document.getSelection();if(!S.isCollapsed){S.removeAllRanges();}};
P._markAsUserSelectable=function($,e){$.removeClass("sapUiNotUserSelectable");if(e){$.addClass("sapUiUserSelectable");}};
P._markAsNotUserSelectable=function($,e){$.removeClass("sapUiUserSelectable");if(e){$.addClass("sapUiNotUserSelectable");}};
var A=new Set(),H="[data-sap-ui-integration-popup-content]";A.add(H);
P.addExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}S.forEach(Set.prototype.add.bind(A));if(e){P.markExternalContentAsSelectable();}};
P.removeExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}if(e){P.markExternalContentAsNotSelectable();}S.forEach(function(i){if(i!==H){A.delete(i);}});};
P.markExternalContentAsSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsUserSelectable(true);}};
P.markExternalContentAsNotSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsNotUserSelectable(false);}};
P._getExternalContent=function(){var e=[];if(A.size>0){A.forEach(function(S){var $=q(S);if($.length>0){e.push($);}});}return e;};
P._markExternalContentAsUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsUserSelectable($,e);});};
P._markExternalContentAsNotUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsNotUserSelectable($,e);});};
P.setWithinArea=function(e){G=e;};
P.getWithinArea=function(){return G;};
P.getWithinAreaDomRef=function(){return t(G);};
return P;});
sap.ui.predefine('sap/ui/core/ScrollBar',['sap/ui/Device','./Control','./library',"./ScrollBarRenderer","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery"],function(D,C,l,S,I,L,c,E,q){"use strict";var a=l.ScrollBarAction;
var b=C.extend("sap.ui.core.ScrollBar",{
metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}},
renderer:S
});
b.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(E.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};
b.prototype.onBeforeRendering=function(){this.$("sb").off("scroll",this.onscroll);};
b.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var s=this.getContentSize();this._bStepMode=!s;var i=this.getSize();if(i.endsWith("px")){i=i.substr(0,i.length-2);}else{i=this.getVertical()?this.$().height():this.$().width();}var d=null;var $=this.$("ffsize");if(D.browser.firefox){d=$.outerHeight();if(d===0){d=window.getComputedStyle(q("body").get(0))["font-size"];if(d.endsWith("px")){d=d.substr(0,d.length-2);}d=parseInt(d);}}$.remove();if(D.browser.webkit){if(!document.width){d=Math.round(40/(window.outerWidth/q(document).width()));}else{d=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(D.browser.firefox){this._iFactor=d;}else if(D.browser.webkit){this._iFactor=d;}else{this._iFactor=Math.floor(i*0.125);}this._iFactorPage=D.browser.firefox?i-d:Math.floor(i*0.875);}else{if(D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(i*0.8);}else if(D.browser.webkit){this._iFactor=d;this._iFactorPage=Math.floor(i*0.875);}else{this._iFactor=7;this._iFactorPage=i-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var e=this._iSteps*this._iFactor;if(e>this._iMaxContentDivSize){this._iFactor=this._iFactor/(e/this._iMaxContentDivSize);}var f=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(f);}else{var f=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(f);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.on("scroll",q.proxy(this.onscroll,this));if(E.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize());this._oTouchScroller.setDimensions(0,0,o.width,o.height);var g=this._$ScrollDomRef.get(0);if(g){var r=g.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+g.clientLeft,r.top+g.clientTop);this._bSkipTouchHandling=false;}}};
b.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(c(this._$ScrollDomRef[0],e.target)){this._doScroll(a.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};
b.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};
b.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};
b.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var g=a.Drag;if(d==this._iFactor){g=a.Step;}else if(d==this._iFactorPage){g=a.Page;}else if(this._bMouseWheel){g=a.MouseWheel;}if(this._bLargeDataScrolling&&g===a.Drag){this._eAction=g;this._bForward=f;}else{this._doScroll(g,f);}e.preventDefault();e.stopPropagation();return false;};
b.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};
b.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};
b.prototype.ontouchend=b.prototype.onmouseup;
b.prototype._handleTouchScroll=function(i,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:i;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};
b.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(E.touchEventMode==="ON"){this._$OwnerDomRef.off(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.off(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.off(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.off(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.on(D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(E.touchEventMode==="ON"){this._$OwnerDomRef.on(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.on(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.on(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.on(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype._getTouchEventType=function(t){return E.touchEventMode==="SIM"?("sap"+t):t;};
b.prototype.pageUp=function(){this._doScroll(a.Page,false);};
b.prototype.pageDown=function(){this._doScroll(a.Page,true);};
b.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};
b.prototype.setCheckedScrollPosition=function(s,d){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var e=i;if(this._bStepMode){i=Math.min(i,this.getSteps());e=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!d;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(e);}else{if(D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-e);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-e);}else{this._$ScrollDomRef.scrollLeft(e);}}if(E.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};
b.prototype.setContentSize=function(s){this.setProperty("contentSize",s,true);this._bStepMode=false;var $=this.$("sbcnt");if($){if(this.getVertical()){$.height(s);}else{$.width(s);}}return this;};
b.prototype._doScroll=function(A,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);L.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);L.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}this._bSuppressScroll=false;this._iOldScrollPos=s;this._bMouseWheel=false;I.notifyScrollEvent({type:A});};
b.prototype.onThemeChanged=function(){this.rerender();};
b.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};
b.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};
return b;});
sap.ui.predefine('sap/ui/core/ScrollBarRenderer',['sap/ui/Device',"sap/ui/dom/getScrollbarSize"],function(D,g){"use strict";var S={apiVersion:2};
S.render=function(r,s){var R=sap.ui.getCore().getConfiguration().getRTL();r.openStart("div",s);r.class("sapUiScrollBar");var a;if(D.support.touch){a="sapUiScrollBarTouch";r.class(a);}var v=s.getVertical();var b=s.getSize();var c=s.getContentSize();var B=g(a);var w=B.width;var h=B.height;if(v){r.style("overflow","hidden");r.style("width",w+"px");r.style("height",b);r.openEnd();r.openStart("div",s.getId()+"-sb");r.style("width",(w*2)+"px");r.style("height","100%");r.style("overflow-y","scroll");r.style("overflow-x","hidden");if(R){r.style("margin-right","-"+w+"px");}else{r.style("margin-left","-"+w+"px");}r.openEnd();r.openStart("div",s.getId()+"-sbcnt");r.style("width",w+"px");r.style("height",c);r.openEnd();r.close("div");r.close("div");r.openStart("div");r.openEnd();r.openStart("span",s.getId()+"-ffsize");r.style("position","absolute");r.style("top","-9000px");r.style("left","-9000px");r.style("visibility","hidden");r.style("line-height","normal");r.openEnd();r.text("FF Size");r.close("span");r.close("div");}else{r.style("overflow","hidden");r.style("height",h+"px");r.style("width",b);r.openEnd();r.openStart("div",s.getId()+"-sb");r.style("height",(h*2)+"px");r.style("margin-top","-"+h+"px");r.style("overflow-x","scroll");r.style("overflow-y","hidden");r.openEnd();r.openStart("div",s.getId()+"-sbcnt");r.style("height",h+"px");r.style("width",c);r.openEnd();r.close("div");r.close("div");}r.close("div");};
return S;},true);
sap.ui.predefine('sap/ui/core/SeparatorItem',['./Item','./library'],function(I){"use strict";
var S=I.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});
return S;});
sap.ui.predefine('sap/ui/core/Shortcut',["sap/ui/core/util/ShortcutHelper",'sap/base/assert'],function(S,a){"use strict";var b={register:function(s,v,c){if(!s){throw new Error("Shortcut.register: oScopeControl must be given.");}if(typeof c!=="function"){throw new Error("Shortcut.register: a function fnCallback must be given.");}var n=S.getNormalizedShortcutSpec(v);S.validateKeyCombination(n);var e=S.findShortcut(s,n);if(e){throw new Error("Same shortcut is already registered on this element");}function w(){var f=document.activeElement,o=document.createElement("span"),g=sap.ui.getCore().getStaticAreaRef();o.setAttribute("tabindex",0);o.setAttribute("id","sap-ui-shortcut-focus");o.style.position="absolute";o.style.top="50%";o.style.bottom="50%";o.style.left="50%";o.style.right="50%";g.appendChild(o);o.focus();f.focus();g.removeChild(o);c.apply(null,arguments);}var d={};d["onkeydown"]=S.handleKeydown.bind(null,n,v,w);s.addEventDelegate(d);var D=s.data("sap.ui.core.Shortcut");if(!D){D=[];s.data("sap.ui.core.Shortcut",D);}D.push({shortcutSpec:n,platformIndependentShortcutString:S.getNormalizedShortcutString(n),delegate:d});},isRegistered:function(s,v){a(s,"Shortcut.isRegistered: oScopeControl must be given.");var n=S.getNormalizedShortcutSpec(v);return!!S.findShortcut(s,n);},unregister:function(s,v){a(s,"Shortcut.unregister: oScopeControl must be given.");var n=S.getNormalizedShortcutSpec(v);var o=S.findShortcut(s,n);if(o){s.removeEventDelegate(o.delegate);var d=s.data("sap.ui.core.Shortcut");var i=d.indexOf(o);d.splice(i,1);return true;}return false;}};return b;});
sap.ui.predefine('sap/ui/core/ShortcutHint',["sap/base/Log","sap/ui/core/Core","sap/ui/core/CommandExecution"],function(L,C,a){"use strict";var S=function(c,o){this.oControl=c;this.oConfig=o;};
S.prototype._getShortcutText=function(){var t;if(this.oConfig.commandName){t=this._getShortcutHintFromCommandExecution(this.oControl,this.oConfig.commandName);}else if(this.oConfig.message){t=this.oConfig.message;}else if(this.oConfig.messageBundleKey){t=this._getShortcutHintFromMessageBundle(this.oControl,this.oConfig.messageBundleKey);}return t;};
S.prototype._getShortcutHintFromCommandExecution=function(c,s){try{return a.find(c,s)._getCommandInfo().shortcut;}catch(e){L.error("Error on retrieving command shortcut. Command "+s+" was not found!");}};
S.prototype._getShortcutHintFromMessageBundle=function(c,m){var r=C.getLibraryResourceBundle(c.getMetadata().getLibraryName());return r.getText(m);};
return S;});
sap.ui.predefine('sap/ui/core/ShortcutHintsMixin',["sap/ui/base/EventProvider","./Element","./ShortcutHint","./Popup","./InvisibleText","sap/ui/dom/containsOrEquals","sap/ui/events/checkMouseEnterOrLeave","sap/ui/Device"],function(E,a,S,P,I,c,b,D){"use strict";var d=function(C){this.sControlId=C.getId();this._hintConfigs=[];};
d.init=function(C){C._shortcutHintsMixin=new d(C);};
d.addConfig=function(C,o,i){if(D.system.phone){return;}if(/sap-ui-xx-noshortcuthints=true/.test(document.location.search)){return;}var M=C._shortcutHintsMixin;if(!M){d.init(C);M=C._shortcutHintsMixin;}M._hintConfigs.push(o);M.initHint(o,i);};
d.hideAll=function(){var C;for(var s in h.mControls){C=a.registry.get(s);if(C){C._shortcutHintsMixin.hideShortcutHint();}}};
d.isDOMIDRegistered=function(s){return h.mDOMNodes[s]&&!!h.mDOMNodes[s].length;};
d.isControlRegistered=function(C){return!!h.mControls[C];};
d.prototype._attachToEvents=function(){var C;if(!d.isControlRegistered(this.sControlId)){C=a.registry.get(this.sControlId);C.addEventDelegate(H,this);}};
d.prototype.register=function(s,C,o){this._attachToEvents();if(!d.isControlRegistered(this.sControlId)){var i=a.registry.get(this.sControlId);i._originalExit=i.exit;i.exit=function(){if(i._originalExit){i._originalExit.apply(i,arguments);}this.deregister();}.bind(this);}h.mControls[this.sControlId]=true;if(!h.mDOMNodes[s]){h.mDOMNodes[s]=[];}h.mDOMNodes[s].push(new S(o,C));};
d.prototype.deregister=function(){var n=this.getRegisteredShortcutInfos(),i;delete h.mControls[this.sControlId];for(i=0;i<n.length;i++){delete h.mDOMNodes[n[i].id];}};
d.prototype.initHint=function(C,o){var i=this._getShortcutHintInfo(C);if(i.message){this.register(i.id,{message:i.message},o);}else if(i.messageBundleKey){this.register(i.id,{messageBundleKey:i.messageBundleKey},o);}else if(i.event){var n=E.getEventList(o)[i.event],A=[];if(n){A=n.reduce(function(r,L){if(L.fFunction&&L.fFunction._sapui_commandName){r.push(L.fFunction._sapui_commandName);}return r;},[]);}if(A.length){this.register(i.id,{commandName:A[0]},o);}else{o.attachEvent("EventHandlerChange",function(p){var F=p.getParameter("func");if(p.getParameter("type")==="listenerAttached"&&F&&F._sapui_commandName&&p.getParameter("EventId")===i.event){this.register(i.id,{commandName:F._sapui_commandName},o);}},this);}}};
d.prototype._getShortcutHintInfos=function(){return this._hintConfigs.map(this._getShortcutHintInfo,this);};
d.prototype._getShortcutHintInfo=function(o){var i;if(o.domrefid){i=o.domrefid;}else if(o.domrefid_suffix){i=this.sControlId+o.domrefid_suffix;}else{i=this.sControlId;}return{id:i,event:o.event,position:o.position,messageBundleKey:o.messageBundleKey,message:o.message,addAccessibilityLabel:o.addAccessibilityLabel};};
d.prototype.getRegisteredShortcutInfos=function(){return this._getShortcutHintInfos().filter(function(i){return d.isDOMIDRegistered(i.id);},this);};
d.prototype.showShortcutHint=function(o){var t,p=o[0].position||"0 8",M=P.Dock.CenterTop,O=P.Dock.CenterBottom,i=e(),s=o[0].ref,n=_(o[0].id),T;if(!k(s)||!j(s)){return;}T=this._getControlTooltips();if(T[o[0].id]){n=T[o[0].id].tooltip+" ("+n+")";}if(!i){i=f(n);}i.oContent.children[0].textContent=n;if(!i.isOpen()){i.open(1000,M,O,s,p,"flipfit",function(q){i.oContent.style.visibility="hidden";if(t){clearTimeout(t);}t=setTimeout(function(){if(!k(s)||!j(s)){return;}i.oContent.style.visibility="visible";},1000);i._applyPosition(i._oLastPosition);});}};
d.prototype.hideShortcutHint=function(){var p=e();if(p&&p.isOpen()){p.close();}};
d.prototype._findShortcutOptionsForRef=function(n){var o,p=this.getRegisteredShortcutInfos(),i,r=[];for(i=0;i<p.length;i++){o=p[i];o.ref=document.getElementById(o.id);if(c(o.ref,n)){r.push(o);}}return r;};
d.prototype._getControlTooltips=function(){var i=this.getRegisteredShortcutInfos(),C=a.registry.get(this.sControlId);return i.reduce(function(r,o){var t=C._getTitleAttribute&&C._getTitleAttribute(o.id);if(!t){t=C.getTooltip();}if(t){r[o.id]={tooltip:t};}return r;},{});};
d.prototype._updateShortcutHintAccLabel=function(o){var i,s,C;if(!o.addAccessibilityLabel){return;}C=a.registry.get(this.sControlId);if(!C.getAriaDescribedBy){return;}i=g(C);s=i.getId();i.setText(_(o.id));if(!i.getText()){C.removeAriaDescribedBy(s);}else if(C.getAriaDescribedBy().indexOf(s)===-1){C.addAriaDescribedBy(s);}};
var h=Object.create(null);h.mControls={};h.mDOMNodes={};var H={"onfocusin":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}d.hideAll();this._updateShortcutHintAccLabel(s[0]);this.showShortcutHint(s);},"onfocusout":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}this.hideShortcutHint();},"onmouseover":function(o){var s=this._findShortcutOptionsForRef(o.target),i;if(!s.length){return;}i=s[0].ref;if(!m(i)){return;}if(b(o,i)){d.hideAll();this.showShortcutHint(s);}},"onmouseout":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}if(b(o,s[0].ref)){if(c(s[0].ref,document.activeElement)){return;}this.hideShortcutHint();}},"onAfterRendering":function(){var n=this.getRegisteredShortcutInfos(),o,s;for(var i=0;i<n.length;i++){s=n[i].id;o=document.getElementById(s);o.setAttribute("aria-keyshortcuts",_(s));}}};
function _(s){var i=h.mDOMNodes[s];if(!i||!i.length){return;}return i.map(function(o){return o._getShortcutText();}).join(", ");}
function g(C){if(!C._shortcutInvisibleText){var F=C.exit;C._shortcutInvisibleText=new I();C._shortcutInvisibleText.toStatic();C.exit=function(){this._shortcutInvisibleText.destroy();F.call(this);};}return C._shortcutInvisibleText;}
function e(){return d._popup;}
function f(t){var p,C,T;C=document.createElement("span");C.classList.add("sapUiHintContainer");T=document.createElement("div");T.classList.add("sapUiHintText");T.textContent=t;C.appendChild(T);p=new P(C,false,false,false);p.setAnimations(function($,i,n){setTimeout(n,i);},function($,i,n){n();});d._popup=p;return p;}
function j(o){var r;if(!o){return false;}r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));}
function k(i){return i.offsetWidth>0||i.offsetHeight>0||i.getClientRects().length>0;}
function l(i){var t=i.tabIndex;return t!=null&&t>=0&&(i.getAttribute("disabled")==null||i.getAttribute("tabindex"));}
function m(i){return i.nodeType==1&&k(i)&&l(i);}
return d;});
sap.ui.predefine('sap/ui/core/StashedControlSupport',["sap/base/assert"],function(a){"use strict";var S={},s={};
S.mixInto=function(c){a(!c.prototype.unstash,"StashedControlSupport: fnClass already has method 'unstash', sideeffects possible",c.getMetadata().getName());if(c.getMetadata().isA("sap.ui.core.Fragment")||c.getMetadata().isA("sap.ui.core.mvc.View")){throw new Error("Stashing is not supported for sap.ui.coreFragment or sap.ui.core.mvc.View");}m(c);};
function m(c){c.prototype.unstash=function(){if(this.isStashed()){var o=u(this);o.stashed=false;return o;}return this;};c.prototype.isStashed=function(){return!!s[this.getId()];};var C=c.prototype.clone;c.prototype.clone=function(){if(this.isStashed()){throw new Error("A stashed control cannot be cloned, id: '"+this.getId()+"'.");}return C.apply(this,arguments);};var d=c.prototype.destroy;c.prototype.destroy=function(){delete s[this.getId()];d.apply(this,arguments);};}
function u(w){var W;var i;var t;var o=s[w.getId()];W=w.getParent();if(W){t=W.getMetadata().getAggregation(w.sParentAggregationName);i=t.indexOf(W,w);t.remove(W,w);}w.destroy();var C=sap.ui.require("sap/ui/core/Component");var O=C&&W&&C.getOwnerComponentFor(W);var b;var f=o.fnCreate;if(O){b=O.runAsOwner(f);}else{b=f();}if(i>=0){b.forEach(function(c){t.insert(W,c,i);});}delete s[w.getId()];return b[0];}
function g(A,p){var b=[];for(var i in s){var P=sap.ui.getCore().byId(s[i].wrapperId);var I=A?P:i;var o=P&&P.getParent();if(!p||(o&&o.getId()===p)){b.push(I);}}return b;}
S.getStashedControlIds=function(p){return g(false,p);};
S.getStashedControls=function(p){return g(true,p);};
S.createStashedControl=function(b){var o={wrapperId:b.wrapperId,fnCreate:b.fnCreate};s[b.wrapperId]=o;return o;};
return S;});
sap.ui.predefine('sap/ui/core/Title',['./Element','./library'],function(E,l){"use strict";var T=l.TitleLevel;
var a=E.extend("sap.ui.core.Title",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},emphasized:{type:"boolean",group:"Appearance",defaultValue:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/TooltipBase',['./Control','./Popup','./library',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,P,l,K,q){"use strict";var O=l.OpenState;
var T=C.extend("sap.ui.core.TooltipBase",{
metadata:{"abstract":true,library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},openDuration:{type:"int",group:"Behavior",defaultValue:200},closeDuration:{type:"int",group:"Behavior",defaultValue:200},myPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin top'},atPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin bottom'},offset:{type:"string",group:"Behavior",defaultValue:'10 3'},collision:{type:"sap.ui.core.Collision",group:"Behavior",defaultValue:'flip'},openDelay:{type:"int",group:"Misc",defaultValue:500},closeDelay:{type:"int",group:"Misc",defaultValue:100}},events:{closed:{}}},
renderer:null
});
T.prototype._getPopup=function(){var p=new P();p.setShadow(true);T.prototype._getPopup=function(){return p;};return p;};
T.prototype.onfocusin=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();this.sStoredTooltip=null;if(d.title&&d.title!=""){this.sStoredTooltip=d.title;d.title="";}var p=this._getPopup();if(!(p.isOpen()&&p.getContent()==this)){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v==null||v==""){d.setAttribute("aria-describedby",i);}else if(v.indexOf(i)==-1){d.setAttribute("aria-describedby",v+" "+i);}}};
T.prototype.onfocusout=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();if(this.sStoredTooltip){d.title=this.sStoredTooltip;}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v&&v.indexOf(i)>=0){if(v.trim()==i){d.removeAttribute("aria-describedby");}else{v=v.replace(i,"");d.setAttribute("aria-describedby",v);}}}if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay());};
T.prototype.isStandardTooltip=function(t){return typeof t==="string"&&!!t.trim();};
T.prototype.onmouseover=function(e){var E=q(e.target).control(0),c=q(e.currentTarget).control(0),L=q(e.relatedTarget).control(0);if(!E){return;}if(E===this){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}e.stopPropagation();e.preventDefault();return;}if(c===E||!this.isStandardTooltip(E.getTooltip())){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}if(L){if(L.getParent()){if(L.getParent()===c&&c===E){var o=L.getTooltip();if(!this.isStandardTooltip(o)&&(!o||!(o instanceof T))){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}}}}if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);}T.sOpenTimeout=setTimeout(this["openPopup"].bind(this,this._currentControl),this.getOpenDelay());e.stopPropagation();e.preventDefault();}};
T.prototype.onmouseout=function(e){if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.sCloseNowTimeout){this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay());}this.restoreStandardTooltips();e.stopPropagation();e.preventDefault();};
T.prototype.closePopup=function(){var p=this._getPopup();if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);}this.sCloseNowTimeout=undefined;p.attachClosed(this.handleClosed,this);p.close();this.restoreStandardTooltips();};
T.prototype.handleClosed=function(){this._getPopup().detachClosed(this.handleClosed,this);this.fireClosed();};
T.prototype.openPopup=function(s){if(!this.getVisible()){return;}if(s.getTooltip()!=null){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;return;}var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){return;}var d=s.getDomRef();p.setContent(this);p.setPosition(this.getMyPosition(),this.getAtPosition(),d,this.getOffset(),this.getCollision());p.setDurations(this.getOpenDuration(),this.getCloseDuration());p.open();this.removeStandardTooltips();}};
T.prototype.removeStandardTooltips=function(){var d=this._currentControl.getDomRef();if(!this.aStoredTooltips){this.aStoredTooltips=[];}else{return;}var t="";while(d&&!(d===document)){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}d=d.parentNode;}if(this._currentControl.getTooltipDomRefs){var D=this._currentControl.getTooltipDomRefs();for(var i=0;i<D.length;i++){d=D[i];if(d){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}}}}};
T.prototype.restoreStandardTooltips=function(){var p=this._getPopup();var e=p.getOpenState();if(e===O.OPEN||e===O.OPENING){return;}if(T.sOpenTimeout){return;}if(this.aStoredTooltips){for(var i=0;i<this.aStoredTooltips.length;i++){var d=this.aStoredTooltips[i].domref;d.title=this.aStoredTooltips[i].tooltip;}}this.aStoredTooltips=null;};
T.prototype.setParent=function(p,a){var _=this._getPopup();if(_&&_.isOpen()){this.closePopup();}C.prototype.setParent.apply(this,arguments);};
T.prototype.onkeydown=function(e){if(e.ctrlKey&&e.which==K.I){var E=q(e.target).control(0);if(E!=null){if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();this.openPopup(this._currentControl);e.preventDefault();e.stopPropagation();}}}else if(e.which==K.ESCAPE){if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}var w=this.oPopup&&this.oPopup.isOpen();this.closePopup();if(w){e.preventDefault();e.stopPropagation();}}};
T.prototype._closeOrPreventOpen=function(){var p=this._getPopup();if(p.isOpen()){this.closePopup();}else if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}};
return T;});
sap.ui.predefine('sap/ui/core/UIComponent',['../base/ManagedObject','./Component','sap/ui/core/mvc/ViewType','sap/ui/core/mvc/XMLProcessingMode','./UIComponentMetadata','./mvc/Controller','./mvc/View','sap/base/util/ObjectPath','sap/base/Log','sap/ui/core/Core'],function(M,C,V,X,U,a,b,O,L){"use strict";
var c=C.extend("sap.ui.core.UIComponent",{
constructor:function(i,s){var d=false;try{if(typeof i!=="string"){s=i;i=undefined;}if(s&&s.hasOwnProperty("_routerHashChanger")){this._oRouterHashChanger=s._routerHashChanger;delete s._routerHashChanger;}if(s&&s.hasOwnProperty("_propagateTitle")){this._bRoutingPropagateTitle=s._propagateTitle;delete s._propagateTitle;}C.apply(this,arguments);d=true;}finally{if(!d){this._destroyCreatedInstances();}}},
metadata:{"abstract":true,rootView:null,publicMethods:["render"],aggregations:{"rootControl":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designtime:"sap/ui/core/designtime/UIComponent.designtime",routing:{}}
},U);
c._fnOnInstanceInitialized=null;c._fnOnInstanceDestroy=null;
c.prototype.init=function(){var t=this;var p={};var r;if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}function s(r){var F=function(){if(typeof c._fnOnInstanceInitialized==="function"){c._fnOnInstanceInitialized(t);}};var A=function(i){t.setAggregation("rootControl",i);};if(r instanceof Promise){t.pRootControlLoaded=t.pRootControlLoaded.then(function(i){A(i);F();return i;});}else if(r instanceof b&&r.oAsyncState&&r.oAsyncState.promise){A(r);t.pRootControlLoaded=t.pRootControlLoaded.then(function(i){F();return i;});}else{A(r);F();}}function d(r,o){var i;if(r instanceof Promise){i=t.pRootControlLoaded.then(function(j){return(j instanceof b)?j.getId():undefined;});}else if(r instanceof b){i=r.getId();}if(i){if(o.targetParent===undefined){o.targetParent=i;}if(t._oTargets){t._oTargets._setRootViewId(i);}}}var R=this._getManifestEntry("/sap.ui5/routing",true)||{},o=R.config||{},v=R.routes;if(this.isA("sap.ui.core.IAsyncContentCreation")){o.async=true;}if(v){var f;var e=this._getRouterClassName();if(e){f=g(e);}else{f=sap.ui.require("sap/ui/core/routing/Router")||sap.ui.requireSync("sap/ui/core/routing/Router");}this._oRouter=new f(v,o,this,R.targets,this._oRouterHashChanger);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews();}else if(R.targets){var h=sap.ui.require("sap/ui/core/routing/Views")||sap.ui.requireSync("sap/ui/core/routing/Views");this._oViews=new h({component:this});var T;if(o.targetsClass){T=g(o.targetsClass);}else{T=sap.ui.require("sap/ui/core/routing/Targets")||sap.ui.requireSync("sap/ui/core/routing/Targets");}this._oTargets=new T({targets:R.targets,config:o,views:this._oViews});}this.runAsOwner(function(){M.runWithPreprocessors(function(){r=t.createContent();},p);});if(r instanceof Promise){if(this.isA("sap.ui.core.IAsyncContentCreation")){this.pRootControlLoaded=r;}else{throw new Error("Interface 'sap.ui.core.IAsyncContentCreation' must be implemented for component '"+this.getMetadata().getComponentName()+"' when 'createContent' is implemented asynchronously");}}else if(r instanceof b&&r.oAsyncState&&r.oAsyncState.promise){this.pRootControlLoaded=r.loaded();}else{this.pRootControlLoaded=Promise.resolve(r);}d(r,o);s(r);};
function g(r){var f;if(typeof r==="string"){f=O.get(r);if(!f){L.error("The specified class for router or targets '"+r+"' is undefined.",this);}}else{f=r;}return f;}
c.prototype.rootControlLoaded=function(){if(!this.pRootControlLoaded){L.error("Mandatory init() not called for UIComponent: '"+this.getManifestObject().getComponentName()+"'. This is likely caused by a missing super call in the component's init implementation.",null,"sap.ui.support",function(){return{type:"missingInitInUIComponent"};});}return this.pRootControlLoaded||Promise.resolve(this.getRootControl());};
c.prototype.destroy=function(){if(typeof c._fnOnInstanceDestroy==="function"){c._fnOnInstanceDestroy(this);}this._destroyCreatedInstances();return C.prototype.destroy.apply(this,arguments);};
c.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter;}else{if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}if(this._oViews){this._oViews.destroy();this._oViews=null;}}};
c.getRouterFor=function(o){var v=o;if(v instanceof a){v=v.getView();}if(v instanceof b){var d=C.getOwnerComponentFor(v);if(d){return d.getRouter();}else{return undefined;}}};
c.prototype.getRouter=function(){return this._oRouter;};
c.prototype.hasNativeRouter=function(){return this._oRouter===this.getRouter();};
c.prototype.getTargets=function(){return this._oTargets;};
c.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId");};
c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"---"+i;}return i;};
c.prototype.getLocalId=function(i){var p=this.getId()+"---";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};
c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"---")===0);};
c.prototype.createContent=function(){var r=this._getManifestEntry("/sap.ui5/rootView",true);if(r&&typeof r==="string"){return b._create({viewName:r,type:V.XML});}else if(r&&typeof r==="object"){if(!r.type&&!b._getModuleName(r)){r.type=V.XML;}if(r.id){r.id=this.createId(r.id);}if(r.async&&r.type===V.XML){r.processingMode=X.Sequential;}if(this.isA("sap.ui.core.IAsyncContentCreation")){return b.create(r);}return b._create(r);}else if(r){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!");}return null;};
c.prototype.getRootControl=function(){return this.getAggregation("rootControl");};
c.prototype.render=function(r){var o=this.getRootControl();if(o&&r){r.renderControl(o);}};
c.prototype.getUIArea=function(){return(this.oContainer?this.oContainer.getUIArea():null);};
c.prototype.getEventingParent=function(){return this.getUIArea();};
c.prototype.setContainer=function(o){this.oContainer=o;if(o){this._applyContextualSettings(o._getContextualSettings());}else{this._oContextualSettings=M._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings();}}.bind(this),0);}}return this;};
c.prototype.onBeforeRendering=function(){};
c.prototype.onAfterRendering=function(){};
c.prototype._getRouterClassName=function(){var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{};return R.routerClass;};
return c;});
sap.ui.predefine('sap/ui/core/UIComponentMetadata',['./ComponentMetadata','sap/ui/core/mvc/ViewType'],function(C,V){"use strict";var U=function(c,o){C.apply(this,arguments);};U.prototype=Object.create(C.prototype);U.prototype.constructor=U;
U.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
U.prototype.getRootView=function(d){return this.getManifestEntry("/sap.ui5/rootView",!d);};
U.prototype.getRoutingConfig=function(d){return this.getManifestEntry("/sap.ui5/routing/config",!d);};
U.prototype.getRoutes=function(d){return this.getManifestEntry("/sap.ui5/routing/routes",!d);};
U.prototype._convertLegacyMetadata=function(s,m){C.prototype._convertLegacyMetadata.call(this,s,m);var u=m["sap.ui5"];var r=u["rootView"]||s["rootView"];if(r){u["rootView"]=r;}var R=u["routing"]||s["routing"];if(R){u["routing"]=R;}if(u["rootView"]&&typeof u["rootView"]==="string"){u["rootView"]={viewName:u["rootView"],type:V.XML};}};
return U;},true);
sap.ui.predefine('sap/ui/core/ValueStateSupport',['./Element','./library',"sap/base/assert"],function(E,l,a){"use strict";var V=l.ValueState;var b={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[V.Error]=r.getText("VALUE_STATE_ERROR");t[V.Warning]=r.getText("VALUE_STATE_WARNING");t[V.Success]=r.getText("VALUE_STATE_SUCCESS");t[V.Information]=r.getText("VALUE_STATE_INFORMATION");}};
b.enrichTooltip=function(o,T){a(o instanceof E,"oElement must be an Element");if(!T&&o.getTooltip()){return undefined;}var s=b.getAdditionalText(o);if(s){return(T?T+" - ":"")+s;}return T;};
b.getAdditionalText=function(v){var s=null;if(v&&v.getValueState){s=v.getValueState();}else if(V[v]){s=v;}if(s&&(s!=V.None)){e();return t[s];}return null;};
b.formatValueState=function(s){switch(s){case 1:return V.Warning;case 2:return V.Success;case 3:return V.Error;case 4:return V.Information;default:return V.None;}};
return b;},true);
sap.ui.predefine('sap/ui/core/VariantLayoutData',['./LayoutData','./library'],function(L){"use strict";
var V=L.extend("sap.ui.core.VariantLayoutData",{metadata:{library:"sap.ui.core",aggregations:{multipleLayoutData:{type:"sap.ui.core.LayoutData",multiple:true,singularName:"multipleLayoutData"}}}});
return V;});
sap.ui.predefine('sap/ui/core/XMLComposite',['sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/core/Fragment','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/ui/performance/Measurement'],function(C,X,M,F,R,L,a){"use strict";var x="sap.ui.core.XMLComposite";
var b=C.extend("sap.ui.core.XMLComposite",{
metadata:{interfaces:["sap.ui.core.IDScope"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%',invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden",invalidate:true}}},
constructor:function(){this._bIsCreating=true;C.apply(this,arguments);delete this._bIsCreating;},
renderer:{apiVersion:2,render:function(r,c){L.debug("Start rendering '"+c.sId,x);a.start(c.getId()+"---renderControl","Rendering of "+c.getMetadata().getName(),["rendering","control"]);r.openStart("div",c);r.accessibilityState(c);if(!c.getDisplayBlock()&&(c.getWidth()!=="100%"||c.getHeight()!=="100%")){r.style("display","inline-block");}r.style("height",c.getHeight());r.style("width",c.getWidth());r.openEnd();var o=c._renderingContent?c._renderingContent():c._getCompositeAggregation();if(o){r.renderControl(o);}r.close("div");a.end(c.getId()+"---renderControl");L.debug("Stop rendering '"+c.sId,x);}}
},X);
b.prototype.byId=function(i){return sap.ui.getCore().byId(F.createId(this.getId(),i));};
b.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};
b.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);return s;};
b.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),p=m.getManagedProperty(n);if(!p){return this;}s=m._suppressInvalidate(p,s);return C.prototype.setProperty.apply(this,[n,v,s]);};
b.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.insertAggregation=function(n,o,i,s){return C.prototype.insertAggregation.apply(this,[n,o,i,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
b.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};
b.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};
b.prototype._destroyCompositeAggregation=function(){var c=this._getCompositeAggregation();if(c){c.destroy("KeepDom");}return this;};
b.prototype.updateBindings=function(){if(this._bIsCreating){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};
b.prototype._getCompositeAggregation=function(){var c=this.getMetadata().getCompositeAggregationName();return this.getAggregation(c);};
b.prototype._setCompositeAggregation=function(n){var c=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(Array.isArray(n)){this.setAggregation(c,null);return;}if(n){if(!n.enhanceAccessibilityState){n.enhanceAccessibilityState=function(e,A){this.enhanceAccessibilityState(e,A);}.bind(this);}n.bindObject("$"+this.alias+">/");n.setModel(this._oManagedObjectModel,"$"+this.alias);if(this.bUsesI18n){var r=this._getResourceModel();if(r){n.setModel(r,"$"+this.alias+".i18n");}}}this.setAggregation(c,n);};
b.mResourceModels={};
b.getLibraryResourceModel=function(l){var o=b.mResourceModels[l];if(!o){o=new R({bundleName:l+".messagebundle",async:true});b.mResourceModels[l]=o;}return o;};
b.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel;}if(this.messageBundle){this.resourceModel=new R({bundleName:this.messageBundle,async:true});return this.resourceModel;}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();if(this.sLibraryName){return b.getLibraryResourceModel(this.sLibraryName);}}};
b.prototype.getResourceBundle=function(){var r=this._getResourceModel();return r?r.getResourceBundle():null;};
b.prototype.destroy=function(){C.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy();}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();}};
b.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),f=m._fragment,A=m.getCompositeAggregationName();this._destroyCompositeAggregation();if(s&&A&&s[A]){var n=s[A];if(n.localName==="FragmentDefinition"){f=n;delete s[A];}}var c=f?(new XMLSerializer()).serializeToString(f):undefined;this.bUsesI18n=c?(c.indexOf("$"+this.alias+".i18n")!=-1):true;this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:f,oController:this}));this._bIsInitialized=true;};
b.prototype.enhanceAccessibilityState=function(e,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}};
b.prototype.getFocusDomRef=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getFocusDomRef();};
b.prototype.getFocusInfo=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getFocusInfo();};
b.prototype.getIdForLabel=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getIdForLabel();};
return b;});
sap.ui.predefine('sap/ui/core/XMLCompositeMetadata',['sap/ui/core/ElementMetadata','sap/ui/core/XMLTemplateProcessor',"sap/base/Log"],function(E,X,L){"use strict";var f={};var a=function(c,C){this.InvalidationMode={Render:true,None:false};if(!C.hasOwnProperty("renderer")){C.renderer="sap.ui.core.XMLCompositeRenderer";}if(!C.hasOwnProperty("alias")){C.alias="this";}E.apply(this,arguments);var b=this._bAbstract;if(!b){if(!C.fragment&&c!=="sap.ui.core.XMLComposite"){C.fragment=c;C.fragmentUnspecified=true;}if(!this._fragment&&C.fragment){try{if(!this._fragment){if(C.fragmentContent){if(typeof C.fragmentContent==="string"){var p=new DOMParser();C.fragmentContent=p.parseFromString(C.fragmentContent,"text/xml").documentElement;if(C.fragmentContent&&C.fragmentContent.getElementsByTagName("parsererror").length){var m=C.fragmentContent.getElementsByTagName("parsererror")[0].innerText;throw new Error("There was an error parsing the XML fragment for XMLComposite '"+c+"'. The following message may contain hints to find the problem: "+m);}}this._fragment=C.fragmentContent;}else{this._fragment=this._loadFragment(C.fragment,"control");}}}catch(e){if(!C.fragmentUnspecified||e.message.startsWith("There was an error parsing")){throw(e);}else{L.warning("Implicitly inferred fragment xml "+C.fragment+" not found. "+c+" is not abstract!");}}}}this._sCompositeAggregation=C.metadata?C.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings();};a.prototype=Object.create(E.prototype);a.prototype.constructor=a;a.uid=E.uid;
a.extend=function(s){for(var k in s){a[k]=s[k];}return a;};
a.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content";};
a.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true);}};
a.prototype._applyAggregationSettings=function(){var A=this.getAllAggregations();for(var n in A){if(A[n].type==="TemplateMetadataContext"){this.getAggregation(n)._doesNotRequireFactory=true;}}};
a.prototype._createPrivateAggregationAccessors=function(){var p=this.getAllPrivateAggregations(),b=this.getClass().prototype,g=function(c,d){if(!b[c]){b[c]=d;}};for(var n in p){p[n].generate(g);}};
a.prototype._suppressInvalidate=function(m,s){if(s){return true;}if(!m.appData){m.appData={};m.appData.invalidate=this.InvalidationMode.None;}if(m&&m.appData&&m.appData.invalidate===this.InvalidationMode.Render){return false;}return true;};
a.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var A=this.getAllAggregations(),m={};for(var n in A){if(A[n].type==="TemplateMetadataContext"&&A[n].appData.mandatory){m[n]=A[n];}}this._mMandatoryAggregations=m;}return this._mMandatoryAggregations;};
a.prototype._loadFragment=function(F,e){var s=e+"$"+F;if(!f[s]){f[s]=X.loadTemplate(F,e);}return f[s];};
return a;},true);
sap.ui.predefine('sap/ui/core/XMLTemplateProcessor',['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','sap/ui/core/Component','./mvc/View','./mvc/ViewType','./mvc/XMLProcessingMode','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/values','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions','sap/base/util/JSTokenizer','sap/base/util/isEmptyObject'],function(q,D,M,C,a,V,b,X,E,c,S,d,L,O,v,f,g,h,J,k){"use strict";
function l(e,i,N,j,R){var p=M.bindingParser(i,j,true,false,false,false,R);if(p&&typeof p==="object"){return p;}var H=i=typeof p==="string"?p:i;var I=D.getType(e);if(I){if(I instanceof D){H=I.parseValue(i,{context:j,locals:R});if(!I.isValid(H)){L.error("Value '"+i+"' is not valid for type '"+I.getName()+"'.");}}}else{throw new Error("Property "+N+" has unknown type "+e);}return typeof H==="string"?M.bindingParser.escape(H):H;}
function m(e){return e.localName||e.nodeName;}
var n="http://www.w3.org/1999/xhtml";var o="http://www.w3.org/2000/xmlns/";var r="http://www.w3.org/2000/svg";var s="sap.ui.core";var t="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var u="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var w="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var U="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var P="http://schemas.sap.com/sapui5/preprocessorextension/";var x=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/;
function y(e,i){function j(H,I,K,N,Q){var R,W,Y=[];for(R=H.firstChild;R;R=R.nextSibling){W=i(H,I,K,R,false,N,Q);if(W){Y.push(W.unwrap());}}return d.resolve(Y);}function p(H,I,K,N,Q){var R,W=Promise.resolve(),Y=[N];for(R=H.firstChild;R;R=R.nextSibling){W=W.then(i.bind(null,H,I,K,R,false,N,Q));Y.push(W);}return Promise.all(Y);}return e?p:j;}
var z={};
z.loadTemplate=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return h.loadResource(R).documentElement;};
z.loadTemplatePromise=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return h.loadResource(R,{async:true}).then(function(j){return j.documentElement;});};
z.parseViewAttributes=function(e,j,p){var H=j.getMetadata().getAllProperties();for(var i=0;i<e.attributes.length;i++){var I=e.attributes[i];if(I.name==='controllerName'){j._controllerName=I.value;}else if(I.name==='resourceBundleName'){j._resourceBundleName=I.value;}else if(I.name==='resourceBundleUrl'){j._resourceBundleUrl=I.value;}else if(I.name==='resourceBundleLocale'){j._resourceBundleLocale=I.value;}else if(I.name==='resourceBundleAlias'){j._resourceBundleAlias=I.value;}else if(I.name==='class'){j.addStyleClass(I.value);}else if(!p[I.name]&&H[I.name]){p[I.name]=l(H[I.name].type,I.value,I.name,j._oContainingView.oController);}}};
z.enrichTemplateIds=function(e,i){z.enrichTemplateIdsPromise(e,i,false);return e;};
z.enrichTemplateIdsPromise=function(e,i,j){return G(e,i,true,j).then(function(){return e;});};
z.parseTemplate=function(e,i){return z.parseTemplatePromise(e,i,false).unwrap();};
z.parseTemplatePromise=function(i,j,H,I){return G(i,j,false,H,I).then(function(){var p=d.resolve(arguments[0]);if(j.isA("sap.ui.core.Fragment")){return p;}var K=arguments;if(j.isA("sap.ui.core.mvc.View")&&j._epInfo&&j._epInfo.all.length>0){p=T(H,j,{"content":j._epInfo.all});}return p.then(function(){if(Array.isArray(K[0])){K[0]=K[0].filter(function(e){return e==null||!e._isExtensionPoint;});}return K[0];});});};
function A(R){var e,i=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!R||typeof R!=="object"){e="core:require in XMLView can't be parsed to a valid object";}else{Object.keys(R).some(function(K){if(!i.test(K)){e="core:require in XMLView contains invalid identifier: '"+K+"'";return true;}if(!R[K]||typeof R[K]!=="string"){e="core:require in XMLView contains invalide value '"+R[K]+"'under key '"+K+"'";return true;}});}return e;}
function B(j,p){var H=j.getAttributeNS(s,"require"),R,I,K;if(H){try{R=J.parseJS(H);}catch(e){L.error("Require attribute can't be parsed on Node: ",j.nodeName);throw e;}K=A(R);if(K){throw new Error(K+" on Node: "+j.nodeName);}if(!k(R)){I={};if(p){return new Promise(function(N,Q){var W=Object.keys(R).reduce(function(i,Y){I[Y]=sap.ui.require(R[Y]);return i&&I[Y]!==undefined;},true);if(W){N(I);return;}sap.ui.require(v(R),function(){var Y=arguments;Object.keys(R).forEach(function(Z,i){I[Z]=Y[i];});N(I);},Q);});}else{Object.keys(R).forEach(function(i){I[i]=sap.ui.requireSync(R[i]);});return d.resolve(I);}}}}
function T(e,i,j){var H=d.resolve();if(!k(j)){var I=[];var R;if(e){H=new Promise(function(p){R=p;});}Object.keys(j).forEach(function(K){var N=j[K];N.forEach(function(Q){Q.targetControl=i;var W=sap.ui.require(Q.providerClass);if(W){I.push(W.applyExtensionPoint(Q));}else{var p=new Promise(function(Y,Z){sap.ui.require([Q.providerClass],function($){Y($);},Z);}).then(function(Y){return Y.applyExtensionPoint(Q);});I.push(p);}});});if(e){Promise.all(I).then(R);}}return H;}
function F(e,i,p){var j=p;for(var H=0;H<100;H++){var R=e.lookupNamespaceURI(j);if(R==null||R===i){return j;}j=p+H;}throw new Error("Could not find an unused namespace prefix after 100 tries, giving up");}
function G(p,H,I,K,N){var R=[],Q=F(p,U,"__ui5"),W=B(p,K)||d.resolve(),Y={openStart:function(e,j){R.push(["openStart",[e,j]]);},voidStart:function(e,j){R.push(["voidStart",[e,j]]);},style:function(e,j){R.push(["style",[e,j]]);},"class":function(e){R.push(["class",[e]]);},attr:function(e,j){R.push(["attr",[e,j]]);},openEnd:function(){R.push(["openEnd"]);},voidEnd:function(){R.push(["voidEnd"]);},text:function(e){R.push(["text",[e]]);},unsafeHtml:function(e){R.push(["unsafeHtml",[e]]);},close:function(e){R.push(["close",[e]]);},renderControl:function(e){R.push(W);}};K=K&&!!H._sProcessingMode;L.debug("XML processing mode is "+(H._sProcessingMode||"default")+".","","XMLTemplateProcessor");L.debug("XML will be processed "+K?"asynchronously":"synchronously"+".","","XMLTemplateProcessor");var Z=sap.ui.getCore().getConfiguration().getDesignMode();if(Z){H._sapui_declarativeSourceInfo={xmlNode:p,xmlRootNode:H._oContainingView===H?p:H._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var $=H.sViewName||H._sFragmentName;if(!$){var _=H;var a1=0;while(++a1<1000&&_&&_!==_._oContainingView){_=_._oContainingView;}$=_.sViewName;}if(H.isSubView()){f1(p,true,false,W);}else{if(p.localName==="View"&&p.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+p.namespaceURI+"'"+($?" (View name: "+$+")":""));}p.setAttributeNS(o,"xmlns:"+Q,U);g1(p,false,false,W);}var i=0;function b1(){for(;i<R.length;i++){var e=R[i];if(e&&typeof e.then==='function'){return e.then(c1).then(b1);}}return R;}function c1(e){var j=[i,1].concat(e);Array.prototype.splice.apply(R,j);}return W.then(b1);function d1(e){return e;}function e1(e){return H._oContainingView.createId(e);}function f1(p,e,o1,p1){if(p.nodeType===1){var q1=m(p);var r1=p.namespaceURI===n;if(r1||p.namespaceURI===r){var s1=p.getAttribute("id");if(s1==null){s1=e===true?H.getId():undefined;}else{s1=m1(H,p);}if(q1==="style"){var t1=p.attributes;var u1=p.textContent;p=document.createElement(q1);p.textContent=u1;for(var j=0;j<t1.length;j++){var v1=t1[j];if(!v1.prefix){p.setAttribute(v1.name,v1.value);}}if(s1!=null){p.setAttribute("id",s1);}if(e===true){p.setAttribute("data-sap-ui-preserve",H.getId());}Y.unsafeHtml(p.outerHTML);return;}var w1=x.test(q1);if(w1){Y.voidStart(q1,s1);}else{Y.openStart(q1,s1);}for(var i=0;i<p.attributes.length;i++){var x1=p.attributes[i];if(x1.name!=="id"){Y.attr(r1?x1.name.toLowerCase():x1.name,x1.value);}}if(e===true){Y.attr("data-sap-ui-preserve",H.getId());}if(w1){Y.voidEnd();if(p.firstChild){L.error("Content of void HTML element '"+q1+"' will be ignored");}}else{Y.openEnd();var y1=p instanceof HTMLTemplateElement?p.content:p;g1(y1,false,false,p1);Y.close(q1);}}else if(q1==="FragmentDefinition"&&p.namespaceURI===s){g1(p,false,true,p1);}else{W=W.then(function(){return j1(p,p1).then(function(z1){for(var i=0;i<z1.length;i++){var A1=z1[i];if(H.getMetadata().hasAggregation("content")){H._epInfo=H._epInfo||{contentControlsCount:0,last:null,all:[]};if(A1._isExtensionPoint){A1.index=H._epInfo.contentControlsCount;A1.targetControl=H;A1.aggregationName="content";if(H._epInfo.last){H._epInfo.last._nextSibling=A1;}H._epInfo.last=A1;H._epInfo.all.push(A1);}else{H._epInfo.contentControlsCount++;H.addAggregation("content",A1);}}else if(H.getMetadata().hasAssociation(("content"))){H.addAssociation("content",A1);}}return z1;});});Y.renderControl(W);}}else if(p.nodeType===3&&!o1){Y.text(p.textContent);}}function g1(p,e,j,o1){var p1=p.childNodes;for(var i=0;i<p1.length;i++){f1(p1[i],e,j,o1);}}function h1(e,j){var o1;var p1=sap.ui.getCore().getLoadedLibraries();q.each(p1,function(t1,u1){if(e===u1.namespace||e===u1.name){o1=u1.name+"."+((u1.tagNames&&u1.tagNames[j])||j);}});o1=o1||e+"."+j;function q1(s1){if(!s1){L.error("Control '"+o1+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");s1=O.get(o1);}if(!s1){L.error("Can't find object class '"+o1+"' for XML-view","","XMLTemplateProcessor");}return s1;}var r1=o1.replace(/\./g,"/");var s1=sap.ui.require(r1);if(!s1){if(K){return new Promise(function(t1,u1){sap.ui.require([r1],function(s1){s1=q1(s1);t1(s1);},u1);});}else{s1=sap.ui.requireSync(r1);s1=q1(s1);}}return s1;}function i1(e,j,o1){if(e.namespaceURI===n||e.namespaceURI===r){var id=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(I){return z.enrichTemplateIdsPromise(e,H,K).then(function(){return[];});}else{var q1=function(p1){var s1={id:id?m1(H,e,id):undefined,xmlNode:e,containingView:H._oContainingView,processingMode:H._sProcessingMode};if(H.fnScopedRunWithOwner){return H.fnScopedRunWithOwner(function(){return new p1(s1);});}return new p1(s1);};if(K){return new Promise(function(p1,s1){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(r1){p1([q1(r1)]);},s1);});}else{var r1=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return d.resolve([q1(r1)]);}}}else{return j1(e,j,o1);}}function j1(e,j,o1){if(m(e)==="ExtensionPoint"&&e.namespaceURI===s){if(I){return d.resolve([]);}else{var p1=H instanceof V?H._oContainingView:H;var q1=c._factory.bind(null,p1,e.getAttribute("name"),function(){var s1=d.resolve();var t1=[];var u1=e.childNodes;for(var i=0;i<u1.length;i++){var v1=u1[i];if(v1.nodeType===1){s1=s1.then(i1.bind(null,v1,j,o1));t1.push(s1);}}return d.all(t1).then(function(w1){var x1=[];w1.forEach(function(y1){x1=x1.concat(y1);});return x1;});},undefined,undefined,K);return d.resolve(H.fnScopedRunWithOwner?H.fnScopedRunWithOwner(q1):q1());}}else{var r1=h1(e.namespaceURI,m(e));if(r1&&typeof r1.then==='function'){return r1.then(function(s1){return k1(e,s1,j,o1);});}else{return k1(e,r1,j,o1);}}}function k1(o1,p1,q1,r1){var ns=o1.namespaceURI,t1={},u1={},v1="",w1=[],x1=null,y1=null,z1=o1.getAttribute("stashed")==="true";if(!I){o1.removeAttribute("stashed");}if(!p1){return d.resolve([]);}var A1=p1.getMetadata();var B1=A1.getAllSettings();var C1=B(o1,K);if(C1){q1=d.all([q1,C1]).then(function(e){return Object.assign({},e[0],e[1]);});}q1=q1.then(function(j){if(k(j)){j=null;}if(!I){for(var i=0;i<o1.attributes.length;i++){var s1=o1.attributes[i],H1=s1.name,I1=s1.namespaceURI,J1=B1[H1],K1=s1.value;if(H1==="id"){t1[H1]=m1(H,o1,K1);}else if(H1==="class"){v1+=K1;}else if(H1==="viewName"){t1[H1]=K1;}else if(H1==="fragmentName"){t1[H1]=K1;t1['containingView']=H._oContainingView;}else if((H1==="binding"&&!J1)||H1==='objectBindings'){if(!z1){var L1=M.bindingParser(K1,H._oContainingView.oController);if(L1){t1.objectBindings=t1.objectBindings||{};t1.objectBindings[L1.model||undefined]=L1;}}}else if(H1==='metadataContexts'){if(!z1){var M1=null;try{M1=z._calculatedModelMapping(K1,H._oContainingView.oController,true);}catch(e){L.error(H+":"+e.message);}if(M1){t1.metadataContexts=M1;if(z._preprocessMetadataContexts){z._preprocessMetadataContexts(p1.getMetadata().getName(),t1,H._oContainingView.oController);}}}}else if(H1.indexOf(":")>-1){I1=s1.namespaceURI;if(I1===t){var N1=m(s1);w1.push(new C({key:N1,value:l("any",K1,N1,H._oContainingView.oController,j)}));}else if(I1===u){y1=K1;}else if(I1&&I1.startsWith(P)){L.debug(H+": XMLView parser ignored preprocessor attribute '"+H1+"' (value: '"+K1+"')");}else if(I1===U&&m(s1)==="invisible"){J1=B1.visible;if(J1&&J1._iKind===0&&J1.type==="boolean"){t1.visible=false;}}else if(I1===s||I1===U||H1.startsWith("xmlns:")){}else{if(!x1){x1={};}if(!x1.hasOwnProperty(s1.namespaceURI)){x1[s1.namespaceURI]={};}x1[s1.namespaceURI][m(s1)]=s1.nodeValue;L.debug(H+": XMLView parser encountered unknown attribute '"+H1+"' (value: '"+K1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(J1&&J1._iKind===0){t1[H1]=l(J1.type,K1,H1,H._oContainingView.oController,j);}else if(J1&&J1._iKind===1&&J1.altTypes){if(!z1){t1[H1]=l(J1.altTypes[0],K1,H1,H._oContainingView.oController,j);}}else if(J1&&J1._iKind===2){if(!z1){var L1=M.bindingParser(K1,H._oContainingView.oController,false,false,false,false,j);if(L1){t1[H1]=L1;}else{L.error(H+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+H1+"='"+K1+"')");}}}else if(J1&&J1._iKind===3){if(!z1){t1[H1]=e1(K1);}}else if(J1&&J1._iKind===4){if(!z1){t1[H1]=K1.split(/[\s,]+/g).filter(d1).map(e1);}}else if(J1&&J1._iKind===5){if(!z1){var O1=[];E.parse(K1).forEach(function(P1){var Q1=E.resolveEventHandler(P1,H._oContainingView.oController,j);if(Q1){O1.push(Q1);}else{L.warning(H+": event handler function \""+P1+"\" is not a function or does not exist in the controller.");}});if(O1.length){t1[H1]=O1;}}}else if(J1&&J1._iKind===-1){if(A1.isA("sap.ui.core.mvc.View")&&H1=="async"){t1[H1]=l(J1.type,K1,H1,H._oContainingView.oController,j);}else{L.warning(H+": setting '"+H1+"' for class "+A1.getName()+" (value:'"+K1+"') is not supported");}}else{f(H1==='xmlns',H+": encountered unknown setting '"+H1+"' for class "+A1.getName()+" (value:'"+K1+"')");if(z._supportInfo){z._supportInfo({context:o1,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+H1+"' for class "+A1.getName()}});}}}if(x1){w1.push(new C({key:"sap-ui-custom-settings",value:x1}));}if(w1.length>0){t1.customData=w1;}}return j;}).catch(function(e){if(!e.isEnriched){var j=H.getMetadata().isA("sap.ui.core.mvc.View")?"View":"Fragment";var s1=o1&&o1.cloneNode(false).outerHTML;e=new Error("Error found in "+j+" (id: '"+H.getId()+"').\nXML node: '"+s1+"':\n"+e);e.isEnriched=true;L.error(e);}if(K&&H._sProcessingMode!==X.SequentialLegacy){throw e;}});var D1=y(K,E1);function E1(o1,F1,G1,e,s1,q1,r1){var H1,I1;if(e.nodeType===1){if(e.namespaceURI===w){t1[m(e)]=e.querySelector("*");return;}H1=e.namespaceURI===ns&&G1&&G1[m(e)];if(H1){return D1(e,H1,false,q1,r1);}else if(F1){if(!s1&&e.getAttribute("stashed")==="true"&&!I){var J1=e;e=e.cloneNode();J1.removeAttribute("stashed");I1=function(){var j=m1(H,e);S.createStashedControl({wrapperId:j,fnCreate:function(){var L1=K;K=false;try{return E1(o1,F1,G1,J1,true,q1,r1).unwrap();}finally{K=L1;}}});};if(H.fnScopedRunWithOwner){H.fnScopedRunWithOwner(I1);}else{I1();}e.removeAttribute("visible");l1(e,"invisible");}if(t1[F1.name]&&t1[F1.name].path&&typeof t1[F1.name].path==="string"){r1={aggregation:F1.name,id:t1.id};}return i1(e,q1,r1).then(function(L1){for(var j=0;j<L1.length;j++){var M1=L1[j];var N1=F1.name;if(M1._isExtensionPoint){if(!t1[N1]){t1[N1]=[];}var O1=u1[N1];if(!O1){O1=u1[N1]=[];}M1.index=t1[N1].length;M1.aggregationName=N1;M1.closestAggregationBindingCarrier=r1&&r1.id;M1.closestAggregationBinding=r1&&r1.aggregation;var P1=O1[O1.length-1];if(P1){P1._nextSibling=M1;}O1.push(M1);}else if(F1.multiple){if(!t1[N1]){t1[N1]=[];}if(typeof t1[N1].path==="string"){f(!t1[N1].template,"list bindings support only a single template object");t1[N1].template=M1;}else{t1[N1].push(M1);}}else{f(!t1[N1],"multiple aggregates defined for aggregation with cardinality 0..1");t1[N1]=M1;}}return L1;});}else if(m(o1)!=="FragmentDefinition"||o1.namespaceURI!==s){throw new Error("Cannot add direct child without default aggregation defined for control "+A1.getElementName());}}else if(e.nodeType===3){var K1=e.textContent||e.text;if(K1&&K1.trim()){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+K1.trim());}}}var F1=A1.getDefaultAggregation();var G1=A1.getAllAggregations();return D1(o1,F1,G1,q1,r1).then(function(){var e;var j=d.resolve();var s1=d.resolve();var H1=o1.getAttribute("type");var I1=a.getOwnerComponentFor(H);var J1=I1&&I1.isA("sap.ui.core.IAsyncContentCreation");if(I&&o1.hasAttribute("id")){n1(H,o1);}else if(!I){if(p1.getMetadata().isA("sap.ui.core.mvc.View")){var K1=function(){if(!p1._sType&&!t1.viewName){t1.viewName="module:"+p1.getMetadata().getName().replace(/\./g,"/");}if(J1&&K){if(t1.async===false){throw new Error("A nested view contained in a Component implementing 'sap.ui.core.IAsyncContentCreation' is processed asynchronously by default and cannot be processed synchronously.\n"+"Affected Component '"+I1.getMetadata().getComponentName()+"' and View '"+t1.viewName+"'.");}t1.type=p1._sType||H1;s1=V.create(t1);}else{if(p1.getMetadata().isA("sap.ui.core.mvc.XMLView")&&H._sProcessingMode){t1.processingMode=H._sProcessingMode;}return V._create(t1,undefined,p1._sType||H1);}};if(H.fnScopedRunWithOwner){e=H.fnScopedRunWithOwner(K1);}else{e=K1();}}else if(p1.getMetadata().isA("sap.ui.core.Fragment")&&K){if(H1!==b.JS){t1.processingMode=H._sProcessingMode;}var L1="sap/ui/core/Fragment";var M1=sap.ui.require(L1);t1.name=t1.name||t1.fragmentName;if(M1){s1=M1.load(t1);}else{s1=new Promise(function(O1,P1){sap.ui.require([L1],function(M1){M1.load(t1).then(function(Q1){O1(Q1);});},P1);});}}else{var N1=function(){var O1;if(H.fnScopedRunWithOwner){O1=H.fnScopedRunWithOwner(function(){var O1=new p1(t1);return O1;});}else{O1=new p1(t1);}j=T(K,O1,u1);return O1;};if(N&&N.fnRunWithPreprocessor){e=N.fnRunWithPreprocessor(N1);}else{e=N1();}}}return s1.then(function(O1){return O1||e;}).then(function(O1){if(v1&&O1.addStyleClass){O1.addStyleClass(v1);}if(!O1){O1=[];}else if(!Array.isArray(O1)){O1=[O1];}if(z._supportInfo&&O1){for(var i=0,P1=O1.length;i<P1;i++){var Q1=O1[i];if(Q1&&Q1.getId()){var R1=z._supportInfo({context:o1,env:{caller:"createRegularControls",nodeid:o1.getAttribute("id"),controlid:Q1.getId()}}),S1=y1?y1+",":"";S1+=R1;z._supportInfo.addSupportInfo(Q1.getId(),S1);}}}if(Z){O1.forEach(function(Q1){if(A1.getCompositeAggregationName){var T1=o1.getElementsByTagName(Q1.getMetadata().getCompositeAggregationName());for(var i=0;i<T1.length;i++){o1.removeChild(T1[0]);}}Q1._sapui_declarativeSourceInfo={xmlNode:o1,xmlRootNode:H._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:A1.getName()==='sap.ui.core.Fragment'?t1['fragmentName']:null};});}return j.then(function(){return O1;});});});}function l1(e,j){var o1=F(e,U,Q);e.setAttributeNS(U,o1+":"+j,"true");}function m1(H,p,e){if(p.getAttributeNS(U,"id")){return p.getAttribute("id");}else{return e1(e?e:p.getAttribute("id"));}}function n1(H,p){p.setAttribute("id",e1(p.getAttribute("id")));l1(p,"id");}}
z._preprocessMetadataContexts=null;
z._calculatedModelMapping=function(e,j,p){var H,I={},K=M.bindingParser(e,j);function N(Q){if(Q.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=Q.length;i=i+2){if(typeof Q[i-1]=='string'){throw new Error("Binding expected not a string");}if(Q[i]){if((typeof Q[i]!='string')||(Q[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(K){if(!K.formatter){H=K;K={parts:[H]};}else{N(K.formatter.textFragments);}for(var i=0;i<K.parts.length;i++){H=K.parts[i];I[H.model]=I[H.model]||(p?[]:null);if(Array.isArray(I[H.model])){I[H.model].push(H);}else{I[H.model]=H;}}}return I;};
return z;},true);
sap.ui.predefine('sap/ui/core/_IconRegistry',['sap/ui/thirdparty/URI',"sap/base/i18n/ResourceBundle","sap/base/Log"],function(U,R,L){"use strict";var S='SAP-icons';var I='sap-icon';var f={undefined:{config:{fontFamily:S},metadataLoaded:true,inserted:true}};var r={'undefined':{'accidental-leave':0xe000,'account':0xe001,'wrench':0xe002,'windows-doors':0xe003,'washing-machine':0xe004,'visits':0xe005,'video':0xe006,'travel-expense':0x1e007,'temperature':0xe008,'task':0x1e009,'synchronize':0xe00a,'survey':0x1e00b,'settings':0xe00c,'search':0x1e00d,'sales-document':0x1e00e,'retail-store':0xe00f,'refresh':0xe010,'product':0xe011,'present':0xe012,'ppt-attachment':0xe013,'pool':0xe014,'pie-chart':0xe015,'picture':0xe016,'photo-voltaic':0xe017,'phone':0xe018,'pending':0xe019,'pdf-attachment':0xe01a,'past':0x1e01b,'outgoing-call':0xe01c,'opportunity':0xe01d,'opportunities':0x1e01e,'notes':0xe01f,'money-bills':0x1e020,'map':0xe021,'log':0xe022,'line-charts':0xe023,'lightbulb':0xe024,'leads':0xe025,'lead':0x1e026,'laptop':0xe027,'kpi-managing-my-area':0x1e028,'kpi-corporate-performance':0x1e029,'incoming-call':0xe02a,'inbox':0xe02b,'horizontal-bar-chart':0xe02c,'history':0xe02d,'heating-cooling':0xe02e,'gantt-bars':0xe02f,'future':0x1e030,'fridge':0xe031,'fallback':0xe032,'expense-report':0x1e033,'excel-attachment':0xe034,'energy-saving-lightbulb':0xe035,'employee':0xe036,'email':0xe037,'edit':0xe038,'duplicate':0xe039,'download':0xe03a,'doc-attachment':0xe03b,'dishwasher':0xe03c,'delete':0xe03d,'decline':0xe03e,'complete':0x1e03f,'competitor':0xe040,'collections-management':0xe041,'chalkboard':0x1e042,'cart':0xe043,'card':0xe044,'camera':0xe045,'calendar':0x1e046,'begin':0xe047,'basket':0xe048,'bar-chart':0xe049,'attachment':0xe04a,'arrow-top':0xe04b,'arrow-right':0xe04c,'arrow-left':0xe04d,'arrow-bottom':0xe04e,'approvals':0x1e04f,'appointment':0xe050,'alphabetical-order':0x1e051,'along-stacked-chart':0xe052,'alert':0xe053,'addresses':0xe054,'address-book':0x1e055,'add-filter':0xe056,'add-favorite':0xe057,'add':0xe058,'activities':0x1e059,'action':0xe05a,'accept':0x1e05b,'hint':0x1e05c,'group':0xe05d,'check-availability':0x1e05e,'weather-proofing':0xe05f,'payment-approval':0x1e060,'batch-payments':0x1e061,'bed':0xe062,'arobase':0x1e063,'family-care':0xe064,'favorite':0xe065,'navigation-right-arrow':0xe066,'navigation-left-arrow':0xe067,'e-care':0xe068,'less':0xe069,'lateness':0xe06a,'lab':0xe06b,'internet-browser':0xe06c,'instance':0xe06d,'inspection':0xe06e,'image-viewer':0xe06f,'home':0xe070,'grid':0xe071,'goalseek':0xe072,'general-leave-request':0xe073,'create-leave-request':0xe074,'flight':0xe075,'filter':0xe076,'favorite-list':0xe077,'factory':0xe078,'endoscopy':0xe079,'employee-pane':0xe07a,'employee-approvals':0x1e07b,'email-read':0xe07c,'electrocardiogram':0xe07d,'documents':0xe07e,'decision':0xe07f,'database':0xe080,'customer-history':0xe081,'customer':0xe082,'credit-card':0xe083,'create-entry-time':0xe084,'contacts':0xe085,'compare':0xe086,'clinical-order':0xe087,'chain-link':0xe088,'pull-down':0xe089,'cargo-train':0xe08a,'car-rental':0xe08b,'business-card':0xe08c,'bar-code':0xe08d,'folder-blank':0xe08e,'passenger-train':0xe08f,'question-mark':0x1e090,'world':0xe091,'iphone':0xe092,'ipad':0xe093,'warning':0xe094,'sort':0xe095,'course-book':0xe096,'course-program':0xe097,'add-coursebook':0xe098,'print':0xe099,'save':0xe09a,'play':0x1e09b,'pause':0xe09c,'record':0xe09d,'response':0xe09e,'pushpin-on':0xe09f,'pushpin-off':0xe0a0,'unfavorite':0xe0a1,'learning-assistant':0xe0a2,'timesheet':0xe0a3,'time-entry-request':0xe0a4,'list':0xe0a5,'action-settings':0xe0a6,'share':0xe0a7,'feed':0xe0a8,'role':0xe0a9,'flag':0x1e0aa,'post':0xe0ab,'inspect':0xe0ac,'inspect-down':0xe0ad,'appointment-2':0xe0ae,'target-group':0xe0af,'marketing-campaign':0xe0b0,'notification':0xe0b1,'message-error':0xe0b1,'comment':0xe0b2,'shipping-status':0xe0b3,'collaborate':0xe0b4,'shortcut':0xe0b5,'lead-outdated':0x1e0b6,'tools-opportunity':0xe0b7,'permission':0xe0b8,'supplier':0xe0b9,'table-view':0xe0ba,'table-chart':0xe0bb,'switch-views':0xe0bc,'e-learning':0xe0bd,'manager':0xe0be,'switch-classes':0xe0bf,'simple-payment':0x1e0c0,'signature':0xe0c1,'sales-order-item':0x1e0c2,'sales-order':0x1e0c3,'request':0xe0c4,'receipt':0xe0c5,'puzzle':0xe0c6,'process':0xe0c7,'private':0xe0c8,'popup-window':0xe0c9,'person-placeholder':0xe0ca,'per-diem':0x1e0cb,'paper-plane':0xe0cc,'paid-leave':0x1e0cd,'pdf-reader':0x1e0ce,'overview-chart':0xe0cf,'overlay':0xe0d0,'org-chart':0xe0d1,'number-sign':0xe0d2,'notification-2':0xe0d3,'my-sales-order':0x1e0d4,'meal':0xe0d5,'loan':0x1e0d6,'order-status':0x1e0d7,'customer-order-entry':0x1e0d8,'performance':0xe0d9,'menu':0xe0da,'employee-lookup':0xe0db,'education':0xe0dc,'customer-briefing':0xe0dd,'customer-and-contacts':0xe0de,'my-view':0xe0df,'accelerated':0xe0e0,'to-be-reviewed':0xe0e1,'warning2':0xe0e2,'feeder-arrow':0xe0e3,'quality-issue':0xe0e4,'workflow-tasks':0xe0e5,'create':0xe0e6,'home-share':0xe0e7,'globe':0x1e0e8,'tags':0xe0e9,'work-history':0xe0ea,'x-ray':0xe0eb,'wounds-doc':0xe0ec,'web-cam':0xe0ed,'waiver':0x1e0ee,'vertical-bar-chart':0xe0ef,'upstacked-chart':0xe0f0,'trip-report':0xe0f1,'microphone':0xe0f2,'unpaid-leave':0x1e0f3,'tree':0xe0f4,'toaster-up':0xe0f5,'toaster-top':0xe0f6,'toaster-down':0xe0f7,'time-account':0xe0f8,'theater':0xe0f9,'taxi':0xe0fa,'subway-train':0xe0fb,'study-leave':0xe0fc,'stethoscope':0xe0fd,'step':0xe0fe,'sonography':0xe0ff,'soccor':0xe100,'soccer':0xe100,'physical-activity':0xe101,'pharmacy':0xe102,'official-service':0xe103,'offsite-work':0xe104,'nutrition-activity':0xe105,'newspaper':0xe106,'monitor-payments':0x1e107,'map-2':0xe108,'machine':0xe109,'mri-scan':0xe10a,'end-user-experience-monitoring':0xe10b,'unwired':0xe10c,'customer-financial-fact-sheet':0x1e10d,'retail-store-manager':0xe10e,'Netweaver-business-client':0xe10f,'electronic-medical-record':0xe110,'eam-work-order':0x1e111,'customer-view':0xe112,'crm-service-manager':0xe113,'crm-sales':0x1e114,'widgets':0x1e115,'commission-check':0x1e116,'collections-insight':0x1e117,'clinical-tast-tracker':0xe118,'citizen-connect':0xe119,'cart-approval':0x1e11a,'capital-projects':0x1e11b,'bo-strategy-management':0xe11c,'business-objects-mobile':0xe11d,'business-objects-explorer':0xe11e,'business-objects-experience':0xe11f,'bbyd-dashboard':0xe120,'bbyd-active-sales':0x1e121,'business-by-design':0x1e122,'business-one':0x1e123,'sap-box':0xe124,'manager-insight':0xe125,'accounting-document-verification':0x1e126,'hr-approval':0x1e127,'idea-wall':0xe128,'Chart-Tree-Map':0xe129,'cart-5':0xe12a,'cart-4':0xe12b,'wallet':0xe12c,'vehicle-repair':0xe12d,'upload':0xe12e,'unlocked':0xe12f,'umbrella':0xe130,'travel-request':0x1e131,'travel-expense-report':0x1e132,'travel-itinerary':0xe133,'time-overtime':0x1e134,'thing-type':0xe135,'technical-object':0xe136,'tag':0xe137,'syringe':0xe138,'syntax':0xe139,'suitcase':0xe13a,'simulate':0xe13b,'shield':0xe13c,'share-2':0xe13d,'sales-quote':0x1e13e,'repost':0xe13f,'provision':0xe140,'projector':0xe141,'add-product':0xe142,'pipeline-analysis':0xe143,'add-photo':0xe144,'palette':0xe145,'nurse':0xe146,'sales-notification':0x1e147,'mileage':0xe148,'meeting-room':0xe149,'media-forward':0x1e14a,'media-play':0x1e14b,'media-pause':0xe14c,'media-reverse':0x1e14d,'media-rewind':0x1e14e,'measurement-document':0xe14f,'measuring-point':0xe150,'measure':0xe151,'map-3':0xe152,'locked':0xe153,'letter':0xe154,'journey-arrive':0xe155,'journey-change':0xe156,'journey-depart':0xe157,'it-system':0xe158,'it-instance':0xe159,'it-host':0xe15a,'iphone-2':0xe15b,'ipad-2':0xe15c,'inventory':0xe15d,'insurance-house':0xe15e,'insurance-life':0xe15f,'insurance-car':0xe160,'initiative':0xe161,'incident':0x1e162,'group-2':0xe163,'goal':0xe164,'functional-location':0xe165,'full-screen':0xe166,'form':0xe167,'fob-watch':0xe168,'blank-tag':0xe169,'family-protection':0xe16a,'folder':0xe16b,'fax-machine':0xe16c,'example':0xe16d,'eraser':0xe16e,'employee-rejections':0xe16f,'drop-down-list':0xe170,'draw-rectangle':0xe171,'document':0xe172,'doctor':0xe173,'discussion-2':0xe174,'discussion':0xe175,'dimension':0xe176,'customer-and-supplier':0xe177,'crop':0xe178,'add-contact':0xe179,'compare-2':0xe17a,'color-fill':0xe17b,'collision':0xe17c,'curriculum':0xe17d,'chart-axis':0xe17e,'full-stacked-chart':0xe17f,'full-stacked-column-chart':0xe180,'vertical-bar-chart-2':0xe181,'horizontal-bar-chart-2':0xe182,'horizontal-stacked-chart':0xe183,'vertical-stacked-chart':0xe184,'choropleth-chart':0x1e185,'geographic-bubble-chart':0x1e186,'multiple-radar-chart':0xe187,'radar-chart':0xe188,'crossed-line-chart':0xe189,'multiple-line-chart':0xe18a,'multiple-bar-chart':0xe18b,'line-chart':0xe18c,'line-chart-dual-axis':0xe18d,'bubble-chart':0xe18e,'scatter-chart':0xe18f,'multiple-pie-chart':0xe190,'column-chart-dual-axis':0xe191,'tag-cloud-chart':0xe192,'area-chart':0xe193,'cause':0xe194,'cart-3':0xe195,'cart-2':0xe196,'bus-public-transport':0xe197,'burglary':0xe198,'building':0xe199,'border':0xe19a,'bookmark':0xe19b,'badge':0xe19c,'attachment-audio':0xe19d,'attachment-video':0xe19e,'attachment-html':0xe19f,'attachment-photo':0xe1a0,'attachment-e-pub':0xe1a1,'attachment-zip-file':0xe1a2,'attachment-text-file':0xe1a3,'add-equipment':0xe1a4,'add-activity':0x1e1a5,'activity-individual':0xe1a6,'activity-2':0x1e1a7,'add-activity-2':0x1e1a8,'activity-items':0xe1a9,'activity-assigned-to-goal':0xe1aa,'status-completed':0xe1ab,'status-positive':0xe1ab,'status-error':0xe1ac,'status-negative':0xe1ac,'status-inactive':0xe1ad,'status-in-process':0xe1ae,'status-critical':0xe1ae,'blank-tag-2':0xe1af,'cart-full':0xe1b0,'locate-me':0xe1b1,'paging':0xe1b2,'company-view':0xe1b3,'document-text':0xe1b4,'explorer':0xe1b5,'personnel-view':0xe1b6,'sorting-ranking':0xe1b7,'drill-down':0xe1b8,'drill-up':0xe1b9,'vds-file':0xe1ba,'sap-logo-shape':0x1e1bb,'folder-full':0xe1bc,'system-exit':0xe1bd,'system-exit-2':0xe1be,'close-command-field':0xe1bf,'open-command-field':0xe1c0,'sys-enter-2':0x1e1c1,'sys-enter':0x1e1c2,'sys-help-2':0x1e1c3,'sys-help':0x1e1c4,'sys-back':0xe1c5,'sys-back-2':0xe1c6,'sys-cancel':0xe1c7,'sys-cancel-2':0xe1c8,'open-folder':0xe1c9,'sys-find-next':0xe1ca,'sys-find':0xe1cb,'sys-monitor':0xe1cc,'sys-prev-page':0xe1cd,'sys-first-page':0xe1ce,'sys-next-page':0xe1cf,'sys-last-page':0xe1d0,'generate-shortcut':0xe1d1,'create-session':0xe1d2,'display-more':0xe1d3,'enter-more':0xe1d4,'zoom-in':0xe1d5,'zoom-out':0xe1d6,'header':0xe1d7,'detail-view':0xe1d8,'show-edit':0xe1d8,'collapse':0xe1d9,'expand':0xe1da,'positive':0xe1db,'negative':0xe1dc,'display':0xe1dd,'menu2':0xe1de,'redo':0xe1df,'undo':0xe1e0,'navigation-up-arrow':0xe1e1,'navigation-down-arrow':0xe1e2,'down':0xe1e3,'up':0xe1e4,'shelf':0xe1e5,'background':0xe1e6,'resize':0xe1e7,'move':0xe1e8,'show':0xe1e9,'hide':0xe1ea,'nav-back':0xe1eb,'error':0xe1ec,'slim-arrow-right':0xe1ed,'slim-arrow-left':0xe1ee,'slim-arrow-down':0xe1ef,'slim-arrow-up':0xe1f0,'forward':0xe1f1,'overflow':0xe1f2,'value-help':0xe1f3,'multi-select':0x1e1f4,'exit-full-screen':0xe1f5,'sys-add':0xe1f6,'sys-minus':0xe1f7,'dropdown':0xe1f8,'expand-group':0xe1f9,'collapse-group':0xe200,'vertical-grip':0xe1fa,'horizontal-grip':0xe1fb,'sort-descending':0xe1fc,'sort-ascending':0xe1fd,'arrow-down':0xe1fe,'legend':0xe1ff,'message-warning':0xe201,'message-information':0x1e202,'message-success':0x1e203,'restart':0xe204,'stop':0xe205,'add-process':0xe206,'cancel-maintenance':0xe207,'activate':0xe208,'resize-horizontal':0xe209,'resize-vertical':0xe20a,'connected':0xe20b,'disconnected':0xe20c,'edit-outside':0xe20d,'key':0xe20e,'minimize':0xe20f,'back-to-top':0xe210,'hello-world':0xe211,'outbox':0xe212,'donut-chart':0xe213,'heatmap-chart':0xe214,'horizontal-bullet-chart':0xe215,'vertical-bullet-chart':0xe216,'call':0xe217,'download-from-cloud':0xe218,'upload-to-cloud':0xe219,'jam':0xe21a,'sap-ui5':0xe21b,'message-popup':0xe21c,'cloud':0xe21d,'horizontal-waterfall-chart':0x1e21e,'vertical-waterfall-chart':0x1e21f,'broken-link':0xe220,'headset':0xe221,'thumb-up':0x1e222,'thumb-down':0x1e223,'multiselect-all':0x1e224,'multiselect-none':0x1e225,'scissors':0xe226,'sound':0x1e227,'sound-loud':0x1e228,'sound-off':0x1e229,'date-time':0x1e22a,'user-settings':0xe22b,'key-user-settings':0xe22c,'developer-settings':0xe22d,'text-formatting':0x1e22e,'bold-text':0x1e22f,'italic-text':0x1e230,'underline-text':0x1e231,'text-align-justified':0x1e232,'text-align-left':0x1e233,'text-align-center':0x1e234,'text-align-right':0x1e235,'bullet-text':0x1e236,'numbered-text':0x1e237,'co':0xe238,'ui-notifications':0xe239,'bell':0xe23a,'cancel-share':0xe23b,'write-new-document':0xe23c,'write-new':0xe23d,'cancel':0x1e23e,'screen-split-one':0xe23f,'screen-split-two':0xe240,'screen-split-three':0xe241,'customize':0xe242,'user-edit':0xe243,'source-code':0xe244,'copy':0xe245,'paste':0xe246,'line-chart-time-axis':0x1e247,'clear-filter':0xe248,'reset':0xe249,'trend-up':0xe24a,'trend-down':0xe24b,'cursor-arrow':0xe24c,'add-document':0xe24d,'create-form':0xe24e,'resize-corner':0xe24f,'chevron-phase':0xe250,'chevron-phase-2':0xe251,'rhombus-milestone':0xe252,'rhombus-milestone-2':0xe253,'circle-task':0xe254,'circle-task-2':0xe255,'project-definition-triangle':0xe256,'project-definition-triangle-2':0xe257,'master-task-triangle':0xe258,'master-task-triangle-2':0xe259,'program-triangles':0xe25a,'program-triangles-2':0xe25b,'mirrored-task-circle':0xe25c,'mirrored-task-circle-2':0xe25d,'checklist-item':0xe25e,'checklist-item-2':0xe25f,'checklist':0xe260,'checklist-2':0xe261,'chart-table-view':0xe262,'filter-analytics':0xe263,'filter-facets':0xe264,'filter-fields':0xe265,'indent':0xe266,'outdent':0xe267,'heading1':0x1e268,'heading2':0x1e269,'heading3':0x1e26a,'decrease-line-height':0xe26b,'increase-line-height':0xe26c,'fx':0x1e26d,'add-folder':0xe26e,'away':0xe26f,'busy':0xe270,'appear-offline':0xe271,'blur':0xe272,'pixelate':0xe273,'horizontal-combination-chart':0xe274,'add-employee':0xe275,'text-color':0x1e276,'browse-folder':0xe277,'primary-key':0xe278,'two-keys':0xe279,'strikethrough':0xe27a,'text':0xe27b,'responsive':0xe27c,'desktop-mobile':0xe27d,'table-row':0xe27e,'table-column':0xe27f,'validate':0x1e280,'keyboard-and-mouse':0xe281,'touch':0xe282,'expand-all':0xe283,'collapse-all':0xe284,'combine':0xe285,'split':0xe286,'megamenu':0xe287,'feedback':0xe288,'information':0xe289,'s4hana':0x1e28a,'translate':0x1e28b,'clear-all':0xe28c,'command-line-interfaces':0xe28d,'sum':0x1e28e,'qr-code':0x1e28f,'space-navigation':0xe290,'in-progress':0x1e291,'not-editable':0xe292}};var c;
function g(){if(!c){c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");}return c;}
var _={sapIconFontFamily:S};
_.get=function(){return r;};
_.getFontRegistry=function(){return f;};
_.addIcon=function(i,a,b){if(typeof b==="string"){b={fontFamily:arguments[2],content:arguments[3],overWrite:!!arguments[4],suppressMirroring:!!arguments[5]};}if(typeof a!=="string"){a=String(a);}a=a==='undefined'?undefined:a;if(!r[a]){r[a]={};}var d=r[a],e=d[i],p,C,t,k;if(e){if(a===undefined){L.warning("Icon with name '"+i+"' in built-in collection already exists and can not be overwritten.","sap.ui.core.IconPool");return;}else if(!b.overWrite){L.warning("Icon with name '"+i+"' in collection '"+a+"' already exists. Specify 'iconInfo.overWrite' in order to overwrite.","sap.ui.core.IconPool");return;}}p={protocol:I,hostname:a||i,path:a?i:undefined};if(Array.isArray(b.content)){C=b.content.map(m).join('');}else{C=m(b.content);}if(b.resourceBundle instanceof R){k="Icon."+i;if(b.resourceBundle.hasText(k)){t=b.resourceBundle.getText(k);}}e=d[i]={name:i,collection:a,uri:U.build(p),fontFamily:b.fontFamily,content:C,text:t||'',suppressMirroring:b.suppressMirroring,skipMirroring:b.suppressMirroring};return e;};
_.getIconURI=function(i,a){var b=this.getIconInfo(i,a);return b&&b.uri;};
_.getIconInfo=function(i,a,l){var p,b,d,o,n=_.isIconURI(i);if(!i){return;}if(!l&&n){l=a;}l=l||"sync";d=(l==="async"||l==="mixed");function e(){var h=r[a];var b=h&&h[i];if(typeof b==='number'){r[a][i]=undefined;b=_.addIcon(i,a,{fontFamily:f[a].config.fontFamily,content:b&0xFFFF,suppressMirroring:!!(b&0x10000),resourceBundle:g()});}return b;}if(n){p=U.parse(i);if(p.path.length===1){a=undefined;i=p.hostname;}else{a=p.hostname;i=p.path.slice(1);}if(!i){return;}}if(typeof a!=="string"){a=String(a);}a=a==='undefined'?undefined:a;b=e();if(b===undefined&&a!==undefined){o=_._loadFontMetadata(a,d);}if(d){if(o){return o.then(function(){b=e();if(!b){L.warning("Icon info for icon '"+i+"' in collection '"+a+"' could not be fetched");}return b;});}else if(l==="async"){return Promise.resolve(b);}else{b=e();}}else{b=e();}if(!b){L.warning("Icon info for icon '"+i+"' in collection '"+a+"' could not be fetched");}return b;};
_.isIconURI=function(u){if(!u){return false;}var p=U.parse(u);return p.protocol===I&&!!p.hostname;};
_.getIconCollectionNames=function(){return Object.keys(r);};
_.getIconNames=function(a){var b=r[a];return b?Object.keys(b):[];};
_.insertFontFaceStyle=function(F,p,C){var o,f=_.getFontRegistry();function a(u){return _._convertUrl?_._convertUrl(u):u;}if(arguments.length===0||F===S){L.info("It's not needed to call IconPool.insertFontFaceStyle to insert font-face for the predefined icon font SAP-icons because the font-face is included in the library.css of sap.ui.core");return;}if(F&&p===undefined){L.error("IconPool.insertFontFaceStyle must be called with at least two parameters!");return;}if(C===undefined){C=F;}if(!f[C]){L.error("Icon font '"+C+"' has not been registered yet.");return;}if(f[C].inserted){L.info("The font face style of icon font '"+C+"' was already inserted.");return;}o=new FontFace(F,"url("+a(p+F+".woff2")+") format('woff2'),"+"local("+F+")",{weight:"normal",style:"normal"});document.fonts.add(o);o.load();f[C].inserted=true;f[C].fontFace=F;};
_._loadFontMetadata=function(a,b){var C,r=_.get(),f=_.getFontRegistry();if(f[a]){if(typeof f[a].metadataLoaded==="boolean"){return;}if(b&&f[a].metadataLoaded instanceof Promise){return f[a].metadataLoaded;}C=f[a].config;}else{if(!r[a]){L.error("The font configuration for collection '"+a+"' is not registered");}f[a]={metadataLoaded:false};}function l(F){for(var k in F){F[k]=parseInt(F[k],16);}r[a]=F;_.insertFontFaceStyle(C.fontFamily,C.fontURI,a);f[a].metadataLoaded=true;}if(C){if(C.metadataURI===undefined){C.metadataURI=C.fontURI+C.fontFamily+".json";}if(b&&!C.metadata){if(f[a].metadataLoaded instanceof Promise){return f[a].metadataLoaded;}var p=new Promise(function(d){if(r[a]===undefined){f[a].metadataLoadedResolve=d;f[a].metadataXhr=jQuery.ajax(C.metadataURI,{dataType:"json",success:function(j){l(j);delete f[a].metadataXhr;delete f[a].metadataLoadedResolve;d();},error:function(j,s){if(s!=="abort"){L.error("An error occurred loading the font metadata for collection '"+a+"'");f[a].metadataLoaded=false;d();}}});}});f[a].metadataLoaded=p;return p;}else if(C.metadataURI){if(f[a].metadataXhr){f[a].metadataXhr.abort("Replaced by sync request");f[a].metadataXhr=null;}L.warning("Synchronous loading of font meta data in IconPool, due to .getIconInfo() call"+" for '"+a+"'. Use loading mode 'async' to avoid this call.","SyncXHR",null,function(){return{type:"SyncXHR",name:"IconPool"};});jQuery.ajax(C.metadataURI,{dataType:"json",async:false,success:function(j){l(j);if(f[a].metadataLoadedResolve){f[a].metadataLoadedResolve();delete f[a].metadataLoadedResolve;}},error:function(){if(f[a].metadataLoadedResolve){f[a].metadataLoadedResolve();delete f[a].metadataLoadedResolve;}L.error("An error occurred loading the font metadata for collection '"+a+"'");f[a].metadataLoaded=false;}});}else{l(C.metadata);}}};
function m(a){return String.fromCharCode(typeof a==='number'?a:parseInt(a,16));}
return _;});
sap.ui.predefine('sap/ui/core/cache/CacheManager',['./LRUPersistentCache','./CacheManagerNOP','sap/ui/Device',"sap/base/Log","sap/ui/performance/Measurement",'sap/ui/performance/trace/Interaction'],function(L,C,D,a,M,I){"use strict";var b={_instance:null,_getInstance:function(){var p,o=d("_getInstance"),t=this;p=new Promise(function(r,e){var f;a.debug("Cache Manager: Initialization...");if(!b._instance){f=t._findImplementation();M.start(c,"CM",S);f.init().then(g,e);M.end(c,"CM");}else{g(b._instance);}function g(h){b._instance=h;o.endAsync();a.debug("Cache Manager initialized with implementation ["+b._instance.name+"], resolving _getInstance promise");r(h);}});o.endSync();return p;},_findImplementation:function(){if(i()&&this._isSupportedEnvironment()){return L;}else{a.warning("UI5 Cache Manager is switched off");return C;}},set:function(k,v){var p,o=d("set",k);a.debug("Cache Manager: Setting value of type["+typeof v+"] with key ["+k+"]");p=this._callInstanceMethod("set",arguments).then(function e(){a.debug("Cache Manager: Setting key ["+k+"] completed successfully");o.endAsync();},function(e){a.error("Cache Manager: Setting key ["+k+"] failed. Error:"+e);o.endAsync();throw e;});o.endSync();return p;},get:function(k){var p,f=I.notifyAsyncStep(),o=d("get",k);a.debug("Cache Manager: Getting key ["+k+"]");p=this._callInstanceMethod("get",arguments).then(function e(v){a.debug("Cache Manager: Getting key ["+k+"] done");o.endAsync();return v;},function(e){a.debug("Cache Manager: Getting key ["+k+"] failed. Error: "+e);o.endAsync();throw e;}).finally(f);o.endSync();return p;},has:function(k){var p,o=d("has",k);a.debug("Cache Manager: has key ["+k+"] called");p=this._callInstanceMethod("has",arguments).then(function e(r){o.endAsync();a.debug("Cache Manager: has key ["+k+"] returned "+r);return r;});o.endSync();return p;},del:function(k){var p,o=d("del",k);a.debug("Cache Manager: del called.");p=this._callInstanceMethod("del",arguments).then(function e(){a.debug("Cache Manager: del completed successfully.");o.endAsync();},function(e){a.debug("Cache Manager: del failed. Error: "+e);o.endAsync();throw e;});o.endSync();return p;},reset:function(){var p,o=d("reset");a.debug("Cache Manager: Reset called.");p=this._callInstanceMethod("reset",arguments).then(function e(){a.debug("Cache Manager: Reset completed successfully.");o.endAsync();},function(e){a.debug("Cache Manager: Reset failed. Error: "+e);o.endAsync();throw e;});o.endSync();return p;},_switchOff:function(){var t=this;return Promise.resolve().then(function(){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(false);});},_switchOn:function(){var t=this;return Promise.resolve().then(function(){var o=sap.ui.getCore().getConfiguration();if(!o.isUI5CacheOn()){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(true);}return Promise.resolve();});},_callInstanceMethod:function(e,A){var p,f="[sync ] _callInstanceMethod";M.start(f,"CM",S);if(this._instance){a.debug("Cache Manager: calling instance...");return this._instance[e].apply(this._instance,A);}a.debug("Cache Manager: getting instance...");p=this._getInstance().then(function h(g){return g[e].apply(g,A);});M.end(f);return p;},_isSupportedEnvironment:function(){var e=[];if(this._bSupportedEnvironment==undefined){e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.CHROME,browserVersion:49});e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.TABLET,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.PHONE,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.TABLET,os:D.os.OS.ANDROID,browserName:D.browser.BROWSER.CHROME,browserVersion:80});e.push({system:D.system.SYSTEMTYPE.PHONE,os:D.os.OS.ANDROID,browserName:D.browser.BROWSER.CHROME,browserVersion:80});this._bSupportedEnvironment=e.some(function(o){var f=D.system[o.system],g=o.os?o.os===D.os.name:true,h=o.browserName===D.browser.name,j=D.browser.version>=o.browserVersion;try{return f&&g&&h&&j&&window.indexedDB;}catch(k){return false;}});}return this._bSupportedEnvironment;}};var S="CacheManager",c="[sync ] _initImplementation",m=0;
function i(){return sap.ui.getCore().getConfiguration().isUI5CacheOn();}
function s(e){if(e._instance){e._instance._destroy();e._instance=null;}}
function d(o,k){m++;var e="[async]  "+o+"["+k+"]- #"+(m),f="[sync ]  "+o+"["+k+"]- #"+(m);M.start(e,"CM",[S,o]);M.start(f,"CM",[S,o]);return{sMeasureAsync:e,sMeasureSync:f,endAsync:function(){M.end(this.sMeasureAsync);},endSync:function(){M.end(this.sMeasureSync);}};}
return b;});
sap.ui.predefine('sap/ui/core/cache/CacheManagerNOP',[],function(){"use strict";var C={name:"CacheManagerNOP",set:function(){return Promise.resolve();},get:function(){return Promise.resolve(undefined);},has:function(){return Promise.resolve(false);},del:function(){return Promise.resolve();},reset:function(){return Promise.resolve();},init:function(){return Promise.resolve(this);},_db:{close:function(){}},_getCount:function(){return Promise.resolve(0);},_destroy:function(){}};return C;});
sap.ui.predefine('sap/ui/core/cache/LRUPersistentCache',["sap/base/Log","sap/ui/performance/Measurement"],function(L,M){"use strict";var a={name:"LRUPersistentCache",defaultOptions:{databaseName:"ui5-cachemanager-db",_contentStoreName:"content-store",_metadataStoreName:"metadata-store",_metadataKey:"metadataKey"},_db:{},init:function(){this._metadata={};this._mru=-1;this._lru=-1;return l(this);},_destroy:function(){if(this._db.close){this._db.close();}this._metadata=null;this._ui5version=null;},set:function(e,i){if(E(e)){L.warning("Cache Manager ignored 'set' for key ["+e+"]");return Promise.resolve();}if(e==null){return Promise.reject("Cache Manager does not accept undefined or null as key");}if(typeof i==="undefined"){return Promise.reject("Cache Manager does not accept undefined as value");}L.debug("Cache Manager LRUPersistentCache: adding item with key ["+e+"]...");var p=this,H="[sync ] fnSet: total[sync]  key ["+e+"]",J="[sync ] fnSet: txStart[sync]  key ["+e+"]",K="[sync ] fnSet: storeOpen[sync]  key ["+e+"]",N="[sync ] fnSet: putContent[sync]  key ["+e+"]",O="[sync ] fnSet: putMetadata[sync]  key ["+e+"]",P="[sync ] fnSet: serialize[sync]  key ["+e+"]";return new Promise(function Y(Q,R){M.start(H,"CM",s);var S,T,U,V,W;W=q(p._metadata);V=new n(e,i,typeof i,++p._mru,P,s).serialize();M.start(J,"CM",s);var X=p._db.transaction([p.defaultOptions._contentStoreName,p.defaultOptions._metadataStoreName],"readwrite");M.end(J);X.onerror=function(Z){var $="Cache Manager cannot complete add/put transaction for entry with key: "+V.oData.key+". Details: "+B(Z);L.error($);p._metadata=W;r(p);R($);};X.onabort=function(Z){p._metadata=W;r(p);var $=t(p);if(y(Z)&&$>0){L.warning("Cache Manager is trying to free some space to add/put new item");x(p,e,i).then(function(){L.debug("Cache Manager LRUPersistentCache: set completed after freeing space. ItemCount changed from "+$+" to "+t(p));Q();},function(a1){var b1="Cache Manager LRUPersistentCache: set unsuccessful. Cannot free space to add/put entry. Details: "+a1;L.error(b1);R(b1);});}else{var _="Cache Manager LRUPersistentCache: set failed: "+B(Z);L.error(_);R(_);}};X.oncomplete=function(){L.debug("Cache Manager LRUPersistentCache: adding item with key ["+e+"]... done");Q();};M.start(K,"CM",s);S=X.objectStore(p.defaultOptions._contentStoreName);U=X.objectStore(p.defaultOptions._metadataStoreName);M.end(K);M.start(N,"CM",s);T=S.put(V.oData,V.oData.key);M.end(N);M.end(H);T.onsuccess=function(){u(p,V);M.start(O,"CM",s);U.put(p._metadata,p.defaultOptions._metadataKey);M.end(O);};if(L.getLevel()>=L.Level.DEBUG){L.debug("Cache Manager LRUPersistentCache: measurements: "+H+": "+M.getMeasurement(H).duration+"; "+P+": "+M.getMeasurement(P).duration+"; "+J+": "+M.getMeasurement(J).duration+"; "+K+": "+M.getMeasurement(K).duration+"; "+N+": "+M.getMeasurement(N).duration+"; "+O+": "+M.getMeasurement(O).duration);}});},has:function(e){if(E(e)){L.warning("Cache Manager ignored 'has' for key ["+e+"]");return Promise.resolve(false);}return this.get(e).then(function(i){return typeof i!=="undefined";});},_getCount:function(){return Promise.resolve(t(this));},_getAll:function(e){var i=this,p,H="[sync ] _getAll: deserialize";return new Promise(function(J,K){var N=[],O=i._db.transaction([i.defaultOptions._contentStoreName],"readonly"),P=O.objectStore(i.defaultOptions._contentStoreName);O.onerror=function(Q){K(B(Q));};O.oncomplete=function(Q){J(N);};P.openCursor().onsuccess=function(Q){var R=Q.target.result;if(R&&R.value){p=new n(R.value,H,m).deserialize();N.push({key:p.oData.key,value:p.oData.value});R.continue();}};});},_loadMetaStructure:function(){var i=this;return new Promise(function(p,H){var J=i._db.transaction([i.defaultOptions._metadataStoreName],"readonly");J.onerror=function(O){if(!J.errorHandled){J.errorHandled=true;var P="Cache Manager cannot complete transaction for read metadata. Details: "+J.error;L.error(P);H(P);}};var K=J.objectStore(i.defaultOptions._metadataStoreName);try{var N=K.get(i.defaultOptions._metadataKey);N.onsuccess=function(O){i._metadata=N.result?N.result:o(i._ui5version);if(i._metadata.__ui5version!==i._ui5version){i.reset().then(p,function(e){L.error("Cannot reset the cache. Details:"+e);J.abort();});}else{p();}};N.onerror=function(O){L.error("Cache Manager cannot complete transaction for read metadata items. Details: "+O.message);H(O.message);};}catch(e){L.error("Cache Manager cannot read metadata entries behind key: "+i.defaultOptions._metadataKey+". Details: "+e.message);H(e.message);}});},get:function(e){if(E(e)){L.warning("Cache Manager ignored 'get' for key ["+e+"]");return Promise.resolve();}return g(this,e);},del:function(e){if(E(e)){L.warning("Cache Manager ignored 'del' for key ["+e+"]");return Promise.resolve();}return d(this,e);},reset:function(){var i=this;return new Promise(function(p,H){var J,K,N,O,P;P=i._db.transaction([i.defaultOptions._contentStoreName,i.defaultOptions._metadataStoreName],"readwrite");P.onerror=P.onabort=function(Q){if(!P.errorHandled){P.errorHandled=true;var R="Cache Manager LRUPersistentCache: transaction for reset() failed. Details: "+P.error;L.error(R);H(R);}};P.oncomplete=function(Q){p();};J=P.objectStore(i.defaultOptions._contentStoreName);K=P.objectStore(i.defaultOptions._metadataStoreName);try{N=J.clear();N.onerror=function(){P.abort();};N.onsuccess=function(){O=K.clear();O.onerror=function(){P.abort();};O.onsuccess=function(){i._metadata=o(sap.ui.version);r(i);};};}catch(e){P.abort();}});}};var m="LRUPersistentCache,get",s="LRUPersistentCache,set",b=0;
function c(i){var p=i._db.transaction([i.defaultOptions._contentStoreName,i.defaultOptions._metadataStoreName],"readwrite");p.onerror=p.onabort=function(H){L.warning("Cache Manager cannot persist the information about usage of an entry. This may lead to earlier removal of the entry if browser storage space is over. Details: "+p.error);};try{p.objectStore(i.defaultOptions._metadataStoreName).put(i._metadata,i.defaultOptions._metadataKey);}catch(e){L.warning("Cache Manager cannot persist the information about usage of an entry. This may lead to earlier removal of the entry if browser storage space is over. Details: "+e.message);}}
function d(e,i){return new Promise(function(p,H){var J,K;J=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");K=q(e._metadata);function N(P){e._metadata=K;r(e);var Q="Cache Manager LRUPersistentCache: cannot delete item with key: "+i+". Details: "+B(P);L.error(Q);H(Q);}J.onerror=N;J.onabort=N;J.oncomplete=function(){if(t(e)===0){e._lru=-1;e._mru=-1;e._metadata=o(e._ui5version);}L.debug("Cache Manager LRUPersistentCache: item with key "+i+" deleted");p();};L.debug("Cache Manager LRUPersistentCache: deleting item ["+i+"]");var O=J.objectStore(e.defaultOptions._contentStoreName).delete(i);O.onsuccess=function(){L.debug("Cache Manager LRUPersistentCache: request for deleting item ["+i+"] is successful, updating metadata...");z(e,i);J.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey);};});}
function g(i,H){if(i.getCounter===undefined){i.getCounter=0;}i.getCounter++;var J="[sync ] fnGet"+i.getCounter+": total[sync]  key ["+H+"]",K="[sync ] fnGet"+i.getCounter+": txStart[sync]  key ["+H+"]",N="[sync ] fnGet"+i.getCounter+": storeOpen[sync]  key ["+H+"]",O="[sync ] fnGet"+i.getCounter+": access result[sync]  key ["+H+"]",P="[sync ] fnGet"+i.getCounter+": putMetadata[sync]  key ["+H+"]",Q="[sync ] fnGet"+i.getCounter+": deserialize[sync]  key ["+H+"]",R="[sync ]  _instance.get",S="[sync ]  getRequest.onSuccess";L.debug("Cache Manager LRUPersistentCache: get for key ["+H+"]...");M.start(R,"CM",m);var p=new Promise(function Z(T,U){var V,W,X,Y;M.start(J,"CM",m);M.start(K,"CM",m);W=i._db.transaction([i.defaultOptions._contentStoreName,i.defaultOptions._metadataStoreName],"readwrite");M.end(K);W.onerror=function($){var _="Cache Manager cannot complete delete transaction for entry with key: "+H+". Details: "+W.error;L.error(_);U(_);};try{M.start(N,"CM",m);X=W.objectStore(i.defaultOptions._contentStoreName).get(H);M.end(N);X.onsuccess=function($){M.start(S,"CM",m);M.start(O,"CM",m);Y=new n(X.result,Q,m);M.end(O);G("Cache Manager LRUPersistentCache: accessing the result",H,O);if(Y.oData){M.start(P,"CM",m);if(Y.oData.lu!==i._mru){Y.oData.lu=++i._mru;u(i,Y);c(i);}M.end(P);V=Y.deserialize().oData.value;}M.end(S);L.debug("Cache Manager LRUPersistentCache: get for key ["+H+"]...done");T(V);};X.onerror=function($){L.error("Cache Manager cannot get entry with key: "+H+". Details: "+$.message);U($.message);};}catch(e){L.error("Cache Manager cannot get entry with key: "+H+". Details: "+e.message);U(e.message);return;}M.end(J);});M.end(R);return p;}
function f(e){var K=v(e);if(K==undefined){var i="Cache Manager LRUPersistentCache: deleteItemAndUpdateMetadata cannot find item to delete";L.debug(i);return Promise.reject(i);}return j(e,K).then(function(){return Promise.resolve().then(function(){z(e,K);return h(e).then(function(){return K;},function(){L.warning("Cache Manager LRUPersistentCache: Free space algorithm deleted item "+"but the metadata changes could not be persisted. This won't break the functionality.");return K;});});});}
function h(i){return new Promise(function(p,H){try{var J=i._db.transaction([i.defaultOptions._contentStoreName,i.defaultOptions._metadataStoreName],"readwrite");J.onerror=K;J.onabort=K;J.oncomplete=function(){L.debug("Cache Manager LRUPersistentCache: persistMetadata - metadata was successfully updated");p();};J.objectStore(i.defaultOptions._metadataStoreName).put(i._metadata,i.defaultOptions._metadataKey);}catch(e){K(null,e);}function K(N,O){var P="Cache Manager LRUPersistentCache: persistMetadata error - metadata was not successfully persisted. Details: "+B(N)+". Exception: "+(O?O.message:"");L.debug(P);H(P);}});}
function j(e,i){return new Promise(function(p,H){var J=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");function K(N){var O="Cache Manager LRUPersistentCache: internalDel cannot complete delete transaction for entry with key: "+i+". Details: "+B(N);L.warning(O);H(N);}J.onerror=K;J.onabort=K;J.oncomplete=function(){if(t(e)===0){e._lru=0;e._mru=0;e._metadata=o(e._ui5version);}L.debug("Cache Manager LRUPersistentCache: internalDel deleting item ["+i+"]...done");p();};L.debug("Cache Manager LRUPersistentCache: internalDel deleting item ["+i+"]...");J.objectStore(e.defaultOptions._contentStoreName).delete(i);});}
function k(e,i,p){return new Promise(function(H,J){var K,N,O,P="[sync ] internalSet: serialize[sync]  key ["+i+"]";O=q(e._metadata);var Q=new n(i,p,typeof p,++e._mru,P,s).serialize();L.debug("Cache Manager: LRUPersistentCache: internal set with parameters: key ["+Q.oData.key+"], access index ["+Q.oData.lu+"]");N=e._db.transaction([e.defaultOptions._contentStoreName,e.defaultOptions._metadataStoreName],"readwrite");N.onerror=R;N.onabort=R;function R(S){L.debug("Cache Manager: LRUPersistentCache: internal set failed. Details: "+B(S));e._metadata=O;r(e);J(S);}N.oncomplete=function(){L.debug("Cache Manager: LRUPersistentCache: Internal set transaction completed. ItemCount: "+t(e));H();};K=N.objectStore(e.defaultOptions._contentStoreName).put(Q.oData,Q.oData.key);K.onsuccess=function(){u(e,Q);N.objectStore(e.defaultOptions._metadataStoreName).put(e._metadata,e.defaultOptions._metadataKey);};});}
function u(e,i){if(e._metadata.__byKey__[i.oData.key]!=null){var p=e._metadata.__byKey__[i.oData.key];delete e._metadata.__byIndex__[p];L.debug("Cache Manager LRUPersistentCache: set/internalset - item already exists, so its indexes are updated");}e._metadata.__byIndex__[i.oData.lu]=i.oData.key;e._metadata.__byKey__[i.oData.key]=i.oData.lu;A(e);}
function l(i){i._ui5version=sap.ui.version;return new Promise(function N(p,H){var J;L.debug("Cache Manager "+"_initIndexedDB started");function K(){try{J=window.indexedDB.open(i.defaultOptions.databaseName,1);}catch(e){L.error("Could not open Cache Manager database. Details: "+e.message);H(e.message);}}K();J.onerror=function(e){L.error("Could not initialize Cache Manager database. Details: "+e.message);H(e.error);};J.onsuccess=function(e){var O=F("init_onsuccess");i._db=J.result;i._db.onversionchange=function(e){if(!e.newVersion){e.target.close();}};i._loadMetaStructure().then(function(){L.debug("Cache Manager "+" metadataLoaded. Serialization support: "+C()+", resolving initIndexDb promise");p(i);},H);O.endSync();};J.onupgradeneeded=function(O){var P=O.target.result;P.onerror=function(O){L.error("Cache Manager error. Details: "+O.message);H(P.error);};try{var Q=P.createObjectStore(i.defaultOptions._contentStoreName);P.createObjectStore(i.defaultOptions._metadataStoreName);}catch(e){L.error("Could not initialize Cache Manager object store. Details: "+e.message);throw e;}Q.createIndex("ui5version","ui5version",{unique:false});};});}
function I(e,i,p,H){this.key=e;this.sOrigType=p;this.value=i;this.lu=H;}
function n(e,i,p,H,J,K){if(arguments.length===3){this.oData=e;this.sMeasureId=i;this.sMsrCat=p;}else{this.oData=new I(e,i,p,H);}}
n.prototype.deserialize=function(){if(C()&&this.oData.sOrigType==="object"){M.start(this.sMeasureId,this.sMeasureId,this.sMsrCat);this.oData.value=JSON.parse(this.oData.value);M.end(this.sMeasureId);G("Cache Manager LRUPersistentCache: de-serialization the result",this.oData.key,this.sMeasureId);}return this;};
n.prototype.serialize=function(){if(C()&&this.oData.sOrigType==="object"){M.start(this.sMeasureId,this.sMeasureId,this.sMsrCat);this.oData.value=JSON.stringify(this.oData.value);M.end(this.sMeasureId);G("Cache Manager LRUPersistentCache: serialization of the value",this.oData.key,this.sMeasureId);}return this;};
function o(e){return{__byKey__:{},__byIndex__:{},__ui5version:e};}
function q(e){var i=o(e.__ui5version);for(var p in e.__byIndex__){i.__byIndex__[p]=e.__byIndex__[p];}for(var H in e.__byKey__){i.__byKey__[H]=e.__byKey__[H];}return i;}
function r(e){var i=w(e._metadata.__byIndex__);e._mru=i.mru;e._lru=i.lru;L.debug("Cache Manager LRUPersistentCache: LRU counters are assigned to the CM: "+JSON.stringify(i));}
function t(e){return Object.keys(e._metadata.__byKey__).length;}
function v(e){var K=e._metadata.__byIndex__[e._lru];if(K==undefined&&!A(e)){return null;}else{return e._metadata.__byIndex__[e._lru];}}
function w(e){var i=-1,p=-1,H=Number.MAX_VALUE,J=Object.keys(e),K=J.length;if(K===0){return{mru:-1,lru:-1};}else{while(++i<K){var N=parseInt(J[i]);if(p<N){p=N;}if(H>N){H=N;}}return{mru:p,lru:H};}}
function x(e,i,p){return new Promise(function(H,J){var K=0;_(e,i,p);function _(e,i,p){K++;L.debug("Cache Manager LRUPersistentCache: cleanAndStore: freeing space attempt ["+(K)+"]");f(e).then(function(N){L.debug("Cache Manager LRUPersistentCache: cleanAndStore: deleted item with key ["+N+"]. Going to put "+i);return k(e,i,p).then(H,function(O){if(y(O)){L.debug("Cache Manager LRUPersistentCache: cleanAndStore: QuotaExceedError during freeing up space...");if(t(e)>0){_(e,i,p);}else{J("Cache Manager LRUPersistentCache: cleanAndStore: even when the cache is empty, the new item with key ["+i+"] cannot be added");}}else{J("Cache Manager LRUPersistentCache: cleanAndStore: cannot free space: "+B(O));}});},J);}});}
function y(e){return(e&&e.target&&e.target.error&&e.target.error.name==="QuotaExceededError");}
function z(e,i){var p=e._metadata.__byKey__[i];delete e._metadata.__byKey__[i];delete e._metadata.__byIndex__[p];A(e);}
function A(e){while(e._lru<=e._mru&&e._metadata.__byIndex__[e._lru]==undefined){e._lru++;}return(e._lru<=e._mru);}
function B(e){if(!e){return"";}var R=e.message;if(e.target&&e.target.error&&e.target.error.name){R+=" Error name: "+e.target.error.name;}return R;}
function C(){return sap.ui.getCore().getConfiguration().isUI5CacheSerializationSupportOn();}
function D(){return sap.ui.getCore().getConfiguration().getUI5CacheExcludedKeys();}
function E(e){return D().some(function(i){return e.indexOf(i)>-1;});}
function F(O,e){b++;var i="[async]  "+O+"["+e+"]- #"+(b),p="[sync ]  "+O+"["+e+"]- #"+(b);M.start(i,"CM",["LRUPersistentCache",O]);M.start(p,"CM",["LRUPersistentCache",O]);return{sMeasureAsync:i,sMeasureSync:p,endAsync:function(){M.end(this.sMeasureAsync);},endSync:function(){M.end(this.sMeasureSync);}};}
function G(e,K,i){if(L.getLevel()>=L.Level.DEBUG){L.debug(e+" for key ["+K+"] took: "+M.getMeasurement(i).duration);}}
return a;});
sap.ui.predefine('sap/ui/core/date/Buddhist',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var B=U.extend("sap.ui.core.date.Buddhist",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=C.Buddhist;}});
B.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
B.now=function(){return Date.now();};
function t(g){var e=U.getEraStartDate(C.Buddhist,0).year,y=g.year-e+1;if(g.year<1941&&g.month<3){y-=1;}if(g.year===null){y=undefined;}return{year:y,month:g.month,day:g.day};}
function a(o){var e=U.getEraStartDate(C.Buddhist,0).year,y=o.year+e-1;if(y<1941&&o.month<3){y+=1;}if(o.year===null){y=undefined;}return{year:y,month:o.month,day:o.day};}
function b(A){var o,g;o={year:A[0],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(o);A[0]=g.year;return A;}
B.prototype._getBuddhist=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
B.prototype._setBuddhist=function(o){var g=a(o);return this.oDate.setFullYear(g.year,g.month,g.day);};
B.prototype._getUTCBuddhist=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
B.prototype._setUTCBuddhist=function(o){var g=a(o);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
B.prototype.getYear=function(){return this._getBuddhist().year;};
B.prototype.getFullYear=function(){return this._getBuddhist().year;};
B.prototype.getUTCFullYear=function(){return this._getUTCBuddhist().year;};
B.prototype.setYear=function(y){var o=this._getBuddhist();o.year=y;return this._setBuddhist(o);};
B.prototype.setFullYear=function(y,m,d){var o=this._getBuddhist();o.year=y;if(m!==undefined){o.month=m;}if(d!==undefined){o.day=d;}return this._setBuddhist(o);};
B.prototype.setUTCFullYear=function(y,m,d){var o=this._getUTCBuddhist();o.year=y;if(m!==undefined){o.month=m;}if(d!==undefined){o.day=d;}return this._setUTCBuddhist(o);};
B.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
B.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
_.set(C.Buddhist,B);return B;});
sap.ui.predefine('sap/ui/core/date/Gregorian',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var G=U.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=C.Gregorian;}});
G.UTC=function(){return Date.UTC.apply(Date,arguments);};
G.now=function(){return Date.now();};
_.set(C.Gregorian,G);return G;});
sap.ui.predefine('sap/ui/core/date/Islamic',['./UniversalDate','../CalendarType','sap/base/Log','./_Calendars'],function(U,C,L,_){"use strict";
var I=U.extend("sap.ui.core.date.Islamic",{constructor:function(){var a=arguments;if(a.length>1){a=f(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=C.Islamic;}});
I.UTC=function(){var a=f(arguments);return Date.UTC.apply(Date,a);};
I.now=function(){return Date.now();};
var B=1400,G=1721425.5,c=1948439.5,d=-42521587200000,O=86400000;var o=null;var s=["A","B"];
function t(a){var b=a.year,l=a.month,n=a.day,q,r,u,M,D,v,J;v=0;if((l+1)>2){v=j(b)?-1:-2;}J=(G-1)+(365*(b-1))+Math.floor((b-1)/4)+(-Math.floor((b-1)/100))+Math.floor((b-1)/400)+Math.floor((((367*(l+1))-362)/12)+v+n);J=Math.floor(J)+0.5;D=J-c;M=Math.floor(D/29.530588853);if(M<0){q=Math.floor(M/12)+1;r=M%12;if(r<0){r+=12;}u=D-m(q,r)+1;}else{M++;while(g(M)>D){M--;}q=Math.floor(M/12)+1;r=M%12;u=(D-g(12*(q-1)+r))+1;}return{day:u,month:r,year:q};}
function e(a){var b=a.year,l=a.month,n=a.day,M=b<1?m(b,l):g(12*(b-1)+l),J=n+M+c-1,q=Math.floor(J-0.5)+0.5,D=q-G,Q=Math.floor(D/146097),r=h(D,146097),u=Math.floor(r/36524),v=h(r,36524),w=Math.floor(v/1461),x=h(v,1461),y=Math.floor(x/365),Y=(Q*400)+(u*100)+(w*4)+y,z,A,E,F,H,K,N,P;if(!(u==4||y==4)){Y++;}E=G+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);F=q-E;H=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400)+Math.floor((739/12)+((j(Y)?-1:-2))+1);N=0;if(q<H){N=0;}else{N=j(Y)?1:2;}z=Math.floor((((F+N)*12)+373)/367);K=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);P=0;if(z>2){P=j(Y)?-1:-2;}K+=Math.floor((((367*z)-362)/12)+P+1);A=(q-K)+1;return{day:A,month:z-1,year:Y};}
function f(a){var b=Array.prototype.slice.call(a),l,n;l={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};n=e(l);b[0]=n.year;b[1]=n.month;b[2]=n.day;return b;}
function i(){var D,a;o={};D=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateFormat();D=k(D)?D:"A";a=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateCalendarCustomizing();a=a||[];if(!a.length){L.warning("No calendar customizations.");return;}a.forEach(function(E){if(E.dateFormat===D){var b=p(E.gregDate);var l=new Date(Date.UTC(b.year,b.month-1,b.day));var M=l.getTime();var n=(M-d)/O;b=p(E.islamicMonthStart);var q=(b.year-1)*12+b.month-1;o[q]=n;}});L.info("Working with date format: ["+D+"] and customization: "+JSON.stringify(a));}
function p(D){return{year:parseInt(D.substr(0,4)),month:parseInt(D.substr(4,2)),day:parseInt(D.substr(6,2))};}
function g(a){if(!o){i();}var b=o[a];if(!b){var y=Math.floor(a/12)+1;var l=a%12;b=m(y,l);}return b;}
function m(y,a){return Math.ceil(29.5*a)+(y-1)*354+Math.floor((3+11*y)/30.0);}
function h(a,b){return a-(b*Math.floor(a/b));}
function j(y){return!(y%400)||(!(y%4)&&!!(y%100));}
function k(a){return s.indexOf(a)!==-1;}
I.prototype._getIslamic=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
I.prototype._setIslamic=function(a){var b=e(a);return this.oDate.setFullYear(b.year,b.month,b.day);};
I.prototype._getUTCIslamic=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
I.prototype._setUTCIslamic=function(a){var b=e(a);return this.oDate.setUTCFullYear(b.year,b.month,b.day);};
I.prototype.getDate=function(D){return this._getIslamic().day;};
I.prototype.getMonth=function(){return this._getIslamic().month;};
I.prototype.getYear=function(){return this._getIslamic().year-B;};
I.prototype.getFullYear=function(){return this._getIslamic().year;};
I.prototype.setDate=function(D){var a=this._getIslamic();a.day=D;return this._setIslamic(a);};
I.prototype.setMonth=function(M,D){var a=this._getIslamic();a.month=M;if(D!==undefined){a.day=D;}return this._setIslamic(a);};
I.prototype.setYear=function(y){var a=this._getIslamic();a.year=y+B;return this._setIslamic(a);};
I.prototype.setFullYear=function(y,M,D){var a=this._getIslamic();a.year=y;if(M!==undefined){a.month=M;}if(D!==undefined){a.day=D;}return this._setIslamic(a);};
I.prototype.getUTCDate=function(D){return this._getUTCIslamic().day;};
I.prototype.getUTCMonth=function(){return this._getUTCIslamic().month;};
I.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year;};
I.prototype.setUTCDate=function(D){var a=this._getUTCIslamic();a.day=D;return this._setUTCIslamic(a);};
I.prototype.setUTCMonth=function(M,D){var a=this._getUTCIslamic();a.month=M;if(D!==undefined){a.day=D;}return this._setUTCIslamic(a);};
I.prototype.setUTCFullYear=function(y,M,D){var a=this._getUTCIslamic();a.year=y;if(M!==undefined){a.month=M;}if(D!==undefined){a.day=D;}return this._setUTCIslamic(a);};
_.set(C.Islamic,I);return I;});
sap.ui.predefine('sap/ui/core/date/Japanese',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var J=U.extend("sap.ui.core.date.Japanese",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=C.Japanese;}});
J.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
J.now=function(){return Date.now();};
function t(g){var e=U.getEraByDate(C.Japanese,g.year,g.month,g.day),E=U.getEraStartDate(C.Japanese,e).year;return{era:e,year:g.year-E+1,month:g.month,day:g.day};}
function a(j){var e=U.getEraStartDate(C.Japanese,j.era).year;return{year:e+j.year-1,month:j.month,day:j.day};}
function b(A){var j,g,e,y=A[0];if(typeof y=="number"){if(y>=100){return A;}else{e=U.getCurrentEra(C.Japanese);y=[e,y];}}else if(!Array.isArray(y)){y=[];}j={era:y[0],year:y[1],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(j);A[0]=g.year;return A;}
J.prototype._getJapanese=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
J.prototype._setJapanese=function(j){var g=a(j);return this.oDate.setFullYear(g.year,g.month,g.day);};
J.prototype._getUTCJapanese=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
J.prototype._setUTCJapanese=function(j){var g=a(j);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
J.prototype.getYear=function(){return this._getJapanese().year;};
J.prototype.getFullYear=function(){return this._getJapanese().year;};
J.prototype.getEra=function(){return this._getJapanese().era;};
J.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year;};
J.prototype.getUTCEra=function(){return this._getUTCJapanese().era;};
J.prototype.setYear=function(y){var j=this._getJapanese();j.year=y;return this._setJapanese(j);};
J.prototype.setFullYear=function(y,m,d){var j=this._getJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setEra=function(e,y,m,d){var E=U.getEraStartDate(C.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setUTCFullYear=function(y,m,d){var j=this._getUTCJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.setUTCEra=function(e,y,m,d){var E=U.getEraStartDate(C.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
J.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
_.set(C.Japanese,J);return J;});
sap.ui.predefine('sap/ui/core/date/Persian',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var P=U.extend("sap.ui.core.date.Persian",{constructor:function(){var a=arguments;if(a.length>1){a=e(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=C.Persian;}});
P.UTC=function(){var a=e(arguments);return Date.UTC.apply(Date,a);};
P.now=function(){return Date.now();};
var B=1300;
function t(G){var j=l(G.year,G.month+1,G.day);return h(j);}
function c(a){var j=g(a.year,a.month+1,a.day);return m(j);}
function e(a){var G=Array.prototype.slice.call(a),b,d;if(typeof a[0]!=="number"||typeof a[1]!=="number"||(a[2]!==undefined&&typeof a[2]!="number")){G[0]=NaN;G[1]=NaN;G[2]=NaN;return G;}b={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};d=c(b);G[0]=d.year;G[1]=d.month;G[2]=d.day;return G;}
function f(j){var b=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],a=b.length,d=j+621,k=-14,q=b[0],r,s,u,v,w,n,i;for(i=1;i<a;i+=1){r=b[i];s=r-q;if(j<r){break;}k=k+o(s,33)*8+o(p(s,33),4);q=r;}n=j-q;k=k+o(n,33)*8+o(p(n,33)+3,4);if(p(s,33)===4&&s-n===4){k+=1;}v=o(d,4)-o((o(d,100)+1)*3,4)-150;w=20+k-v;if(s-n<6){n=n-s+o(s+4,33)*33;}u=p(p(n+1,33)-1,4);if(u===-1){u=4;}return{leap:u,gy:d,march:w};}
function g(j,a,b){while(a<1){a+=12;j--;}while(a>12){a-=12;j++;}var r=f(j);return l(r.gy,3,r.march)+(a-1)*31-o(a,7)*(a-7)+b-1;}
function h(j){var a=m(j).year,b=a-621,r=f(b),d=l(a,3,r.march),i,n,k;k=j-d;if(k>=0){if(k<=185){n=1+o(k,31);i=p(k,31)+1;return{year:b,month:n-1,day:i};}else{k-=186;}}else{b-=1;k+=179;if(r.leap===1){k+=1;}}n=7+o(k,30);i=p(k,30)+1;return{year:b,month:n-1,day:i};}
function l(a,b,i){var d=o((a+o(b-8,6)+100100)*1461,4)+o(153*p(b+9,12)+2,5)+i-34840408;d=d-o(o(a+100100+o(b-8,6),100)*3,4)+752;return d;}
function m(a){var j,i,b,d,k;j=4*a+139361631;j=j+o(o(4*a+183187720,146097)*3,4)*4-3908;i=o(p(j,1461),4)*5+308;b=o(p(i,153),5)+1;d=p(o(i,153),12)+1;k=o(j,1461)-100100+o(8-d,6);return{year:k,month:d-1,day:b};}
function o(a,b){return~~(a/b);}
function p(a,b){return a-~~(a/b)*b;}
P.prototype._getPersian=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
P.prototype._setPersian=function(a){var G=c(a);return this.oDate.setFullYear(G.year,G.month,G.day);};
P.prototype._getUTCPersian=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
P.prototype._setUTCPersian=function(a){var G=c(a);return this.oDate.setUTCFullYear(G.year,G.month,G.day);};
P.prototype.getDate=function(d){return this._getPersian().day;};
P.prototype.getMonth=function(){return this._getPersian().month;};
P.prototype.getYear=function(){return this._getPersian().year-B;};
P.prototype.getFullYear=function(){return this._getPersian().year;};
P.prototype.setDate=function(d){var a=this._getPersian();a.day=d;return this._setPersian(a);};
P.prototype.setMonth=function(M,d){var a=this._getPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.setYear=function(y){var a=this._getPersian();a.year=y+B;return this._setPersian(a);};
P.prototype.setFullYear=function(y,M,d){var a=this._getPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.getUTCDate=function(d){return this._getUTCPersian().day;};
P.prototype.getUTCMonth=function(){return this._getUTCPersian().month;};
P.prototype.getUTCFullYear=function(){return this._getUTCPersian().year;};
P.prototype.setUTCDate=function(d){var a=this._getUTCPersian();a.day=d;return this._setUTCPersian(a);};
P.prototype.setUTCMonth=function(M,d){var a=this._getUTCPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
P.prototype.setUTCFullYear=function(y,M,d){var a=this._getUTCPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
_.set(C.Persian,P);return P;});
sap.ui.predefine('sap/ui/core/date/UniversalDate',['sap/ui/base/Object','sap/ui/core/LocaleData','./_Calendars'],function(B,L,_){"use strict";
var U=B.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var b=U.getClass();return this.createDate(b,arguments);}});
U.UTC=function(){var b=U.getClass();return b.UTC.apply(b,arguments);};
U.now=function(){return Date.now();};
U.prototype.createDate=function(b,A){switch(A.length){case 0:return new b();case 1:return new b(A[0]instanceof Date?A[0].getTime():A[0]);case 2:return new b(A[0],A[1]);case 3:return new b(A[0],A[1],A[2]);case 4:return new b(A[0],A[1],A[2],A[3]);case 5:return new b(A[0],A[1],A[2],A[3],A[4]);case 6:return new b(A[0],A[1],A[2],A[3],A[4],A[5]);case 7:return new b(A[0],A[1],A[2],A[3],A[4],A[5],A[6]);}};
U.getInstance=function(d,C){var b,i;if(d instanceof U){d=d.getJSDate();}else if(!d){d=new Date();}if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}b=U.getClass(C);i=Object.create(b.prototype);i.oDate=d;i.sCalendarType=C;return i;};
U.getClass=function(C){if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}return _.get(C);};
["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(n){U.prototype[n]=function(){return this.oDate[n].apply(this.oDate,arguments);};});
U.prototype.getJSDate=function(){return this.oDate;};
U.prototype.getCalendarType=function(){return this.sCalendarType;};
U.prototype.getEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate());};
U.prototype.setEra=function(E){};
U.prototype.getUTCEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate());};
U.prototype.setUTCEra=function(E){};
U.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate());};
U.prototype.setWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setFullYear(d.year,d.month,d.day);};
U.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
U.prototype.setUTCWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setUTCFullYear(d.year,d.month,d.day);};
U.prototype.getQuarter=function(){return Math.floor((this.getMonth()/3));};
U.prototype.getUTCQuarter=function(){return Math.floor((this.getUTCMonth()/3));};
U.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0;}else{return 1;}};
U.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0;}else{return 1;}};
U.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort();}};
U.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong();}};
var m=7*24*60*60*1000;
U.getWeekByDate=function(C,y,M,d){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),b=this.getClass(C),f=g(b,y),D=new b(b.UTC(y,M,d)),w,i,n,h,N;if(o.firstDayStartsFirstWeek()){w=c(f,D);}else{i=y-1;n=y+1;h=g(b,i);N=g(b,n);if(D>=N){y=n;w=0;}else if(D<f){y=i;w=c(h,D);}else{w=c(f,D);}}return{year:y,week:w};};
U.getFirstDateOfWeek=function(C,y,w){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),b=this.getClass(C),f=g(b,y),d=new b(f.valueOf()+w*m),i=o.firstDayStartsFirstWeek();if(i&&w===0&&f.getUTCFullYear()<y){return{year:y,month:0,day:1};}return{year:d.getUTCFullYear(),month:d.getUTCMonth(),day:d.getUTCDate()};};
function g(b,y){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),M=o.getMinimalDaysInFirstWeek(),f=o.getFirstDayOfWeek(),F=new b(b.UTC(y,0,1)),d=7;while(F.getUTCDay()!==f){F.setUTCDate(F.getUTCDate()-1);d--;}if(d<M){F.setUTCDate(F.getUTCDate()+7);}return F;}
function c(f,t){return Math.floor((t.valueOf()-f.valueOf())/m);}
var e={};
U.getEraByDate=function(C,y,M,d){var E=a(C),t=new Date(0).setUTCFullYear(y,M,d),o;for(var i=E.length-1;i>=0;i--){o=E[i];if(!o){continue;}if(o._start&&t>=o._startInfo.timestamp){return i;}if(o._end&&t<o._endInfo.timestamp){return i;}}};
U.getCurrentEra=function(C){var n=new Date();return this.getEraByDate(C,n.getFullYear(),n.getMonth(),n.getDate());};
U.getEraStartDate=function(C,E){var b=a(C),o=b[E]||b[0];if(o._start){return o._startInfo;}};
function a(C){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),E=e[C];if(!E){var E=o.getEraDates(C);if(!E[0]){E[0]={_start:"1-1-1"};}for(var i=0;i<E.length;i++){var b=E[i];if(!b){continue;}if(b._start){b._startInfo=p(b._start);}if(b._end){b._endInfo=p(b._end);}}e[C]=E;}return E;}
function p(d){var P=d.split("-"),y,M,D;if(P[0]==""){y=-parseInt(P[1]);M=parseInt(P[2])-1;D=parseInt(P[3]);}else{y=parseInt(P[0]);M=parseInt(P[1])-1;D=parseInt(P[2]);}return{timestamp:new Date(0).setUTCFullYear(y,M,D),year:y,month:M,day:D};}
return U;});
sap.ui.predefine('sap/ui/core/date/UniversalDateUtils',['sap/ui/core/date/UniversalDate','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/assert'],function(U,L,a,b){"use strict";
function c(u){b(u instanceof U,"method accepts only instances of UniversalDate");return u.createDate(u.constructor,[u.getJSDate()]);}
var d={};
d.getRange=function(D,u,B,e){if(e===undefined){e=true;}if(isNaN(D)){throw new TypeError("duration is NaN, but is "+D);}D=Math.trunc(D);var s=d.resetStartTime(B==undefined?null:B),E;if(e){switch(u){case"DAY":break;case"WEEK":s=d.getWeekStartDate(s);break;case"MONTH":s=d.getMonthStartDate(s);break;case"QUARTER":s=d.getQuarterStartDate(s);break;case"YEAR":s=d.getYearStartDate(s);break;default:throw new TypeError("invalid unit "+u);}}switch(u){case"DAY":if(D>0){s.setDate(s.getDate()+1);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+D);break;case"WEEK":if(D>0){s.setDate(s.getDate()+7);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+(D*7));break;case"MONTH":if(D>0){s.setMonth(s.getMonth()+1);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+D);break;case"QUARTER":if(D>0){s.setMonth(s.getMonth()+3);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+(D*3));break;case"YEAR":if(D>0){s.setFullYear(s.getFullYear()+1);}E=c(s);D=D==0?1:D;E.setFullYear(s.getFullYear()+D);break;default:throw new TypeError("invalid unit "+u);}if(E.getTime()<s.getTime()){E=[s,s=E][0];}E.setDate(E.getDate()-1);return[d.resetStartTime(s),d.resetEndTime(E)];};
d.getWeekStartDate=function(u,l){var o=l?new L(l):sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),e=a.getInstance(o),f=e.getFirstDayOfWeek();u=u?c(u):c(d.createNewUniversalDate());u.setDate(u.getDate()-u.getDay()+f);return d.resetStartTime(u);};
d.getMonthStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setDate(1);return d.resetStartTime(u);};
d.getQuarterStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(3*Math.floor(u.getMonth()/3));u.setDate(1);return d.resetStartTime(u);};
d.getYearStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(0);u.setDate(1);return d.resetStartTime(u);};
d.resetStartTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(0,0,0,0);return u;};
d.resetEndTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(23,59,59,999);return u;};
d.createNewUniversalDate=function(){return new U();};
d.ranges={lastDays:function(D){return d.getRange(-D,"DAY");},yesterday:function(){return d.getRange(-1,"DAY");},today:function(){return d.getRange(0,"DAY");},tomorrow:function(){return d.getRange(1,"DAY");},nextDays:function(D){return d.getRange(D,"DAY");},lastWeeks:function(w){return d.getRange(-w,"WEEK");},lastWeek:function(){return d.getRange(-1,"WEEK");},currentWeek:function(){return d.getRange(0,"WEEK");},nextWeek:function(){return d.getRange(1,"WEEK");},nextWeeks:function(w){return d.getRange(w,"WEEK");},lastMonths:function(m){return d.getRange(-m,"MONTH");},lastMonth:function(){return d.getRange(-1,"MONTH");},currentMonth:function(){return d.getRange(0,"MONTH");},nextMonth:function(){return d.getRange(1,"MONTH");},nextMonths:function(m){return d.getRange(m,"MONTH");},lastQuarters:function(q){return d.getRange(-q,"QUARTER");},lastQuarter:function(){return d.getRange(-1,"QUARTER");},currentQuarter:function(){return d.getRange(0,"QUARTER");},nextQuarter:function(){return d.getRange(1,"QUARTER");},nextQuarters:function(q){return d.getRange(q,"QUARTER");},quarter:function(q){if(q<=2){return d.getRange(q-1,"QUARTER",d.getYearStartDate());}else{var r=d.getRange(q-2,"QUARTER",d.getYearStartDate());var s=r[1];s.setMilliseconds(1000);return d.getRange(0,"QUARTER",s);}},lastYears:function(y){return d.getRange(-y,"YEAR");},lastYear:function(){return d.getRange(-1,"YEAR");},currentYear:function(){return d.getRange(0,"YEAR");},nextYear:function(){return d.getRange(1,"YEAR");},nextYears:function(y){return d.getRange(y,"YEAR");},yearToDate:function(){var t=d.createNewUniversalDate();return[d.getYearStartDate(t),d.resetEndTime(t)];}};return d;});
sap.ui.predefine('sap/ui/core/date/_Calendars',[],function(){"use strict";var r=new Map();var _={get:function(c){if(!r.has(c)){sap.ui.requireSync("sap/ui/core/date/"+c);}return r.get(c);},set:function(c,C){r.set(c,C);}};return _;});
sap.ui.predefine('sap/ui/core/delegate/ItemNavigation',['sap/ui/base/EventProvider',"sap/base/assert","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(E,a,L,c,K,q){"use strict";
var I=E.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(d,i,n){E.apply(this);this.oDomRef=null;if(d){this.setRootDomRef(d);}this.aItemDomRefs=[];if(i){this.setItemDomRefs(i);}this.iTabIndex=-1;this.iActiveTabIndex=n?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]};}});
I.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};
I.prototype.setDisabledModifiers=function(d){this.oDisabledModifiers=d;return this;};
I.prototype.getDisabledModifiers=function(d){return this.oDisabledModifiers;};
I.prototype.hasDisabledModifier=function(e){var d=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(d)){for(var i=0;i<d.length;i++){if(e[d[i]+"Key"]){return true;}}}return false;};
I.prototype.setRootDomRef=function(d){this.oDomRef=d;if(!q(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){q(this.oDomRef).attr("tabindex",this.iTabIndex);}else{q(this.oDomRef).attr("tabindex",this.iActiveTabIndex);}}q(this.oDomRef).data("sap.INRoot",this);return this;};
I.prototype.getRootDomRef=function(){return this.oDomRef;};
I.prototype.getItemDomRefs=function(){return this.aItemDomRefs;};
I.prototype.setItemDomRefs=function(b){a(typeof b==="object"&&typeof b.length==="number","aItemDomRefs must be an array of DOM elements");this.aItemDomRefs=b;if(this.iFocusedIndex>-1){var d=b.length;if(this.iFocusedIndex>d-1){this.iFocusedIndex=d-1;}var A=document.activeElement;if(A&&A!=this.aItemDomRefs[this.iFocusedIndex]){for(var i=0;i<d;i++){if(A==this.aItemDomRefs[i]){this.iFocusedIndex=i;break;}}}}for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabindex",this.iActiveTabIndex);}else if($.attr("tabindex")=="0"){$.attr("tabindex",-1);}$.data("sap.INItem",true);$.data("sap.InNavArea",true);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){$.data("sap.INRoot").setNestedItemsTabindex();}}}return this;};
I.prototype.setItemsTabindex=function(){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if($.is(":sapFocusable")){if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabindex",this.iActiveTabIndex);}else{$.attr("tabindex",-1);}}}}return this;};
I.prototype.setNestedItemsTabindex=function(){if(q(this.oDomRef).data("sap.INItem")){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]&&q(this.aItemDomRefs[i]).attr("tabindex")=="0"){q(this.aItemDomRefs[i]).attr("tabindex",-1);}}}return this;};
I.prototype.destroy=function(){if(this.oDomRef){q(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null;}if(this.aItemDomRefs){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){q(this.aItemDomRefs[i]).removeData("sap.INItem");q(this.aItemDomRefs[i]).removeData("sap.InNavArea");}}this.aItemDomRefs=null;}this._bItemTabIndex=undefined;this.iFocusedIndex=-1;};
I.prototype.setCycling=function(C){this.bCycling=C;return this;};
I.prototype.setTableMode=function(t,T){this.bTableMode=t;if(this.oConfiguration===undefined){this.oConfiguration=sap.ui.getCore().getConfiguration();}this.bTableList=t?T:false;return this;};
I.prototype.setPageSize=function(p){this.iPageSize=p;return this;};
I.prototype.setSelectedIndex=function(i){this.iSelectedIndex=i;return this;};
I.prototype.setColumns=function(C,n){this.iColumns=C;this.bNoColumnChange=n;return this;};
I.prototype.setHomeEndColumnMode=function(s,C){this._bStayInRow=s;this._bCtrlEnabled=C;return this;};
I.prototype.focusItem=function(i,e,p){L.info("FocusItem: "+i+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(i==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(I.Events.FocusAgain,{index:i,event:e});return;}if(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){if(this.bTableMode){var C=i%this.iColumns;var o=i;if(e&&e.keyCode==K.ARROW_RIGHT){if(C<this.iColumns-1){i+=this.oConfiguration.getRTL()?-1:1;}}else if(e&&e.keyCode==K.ARROW_LEFT){if(C>1){i-=this.oConfiguration.getRTL()?-1:1;}}else{if(C>1){i-=1;}}if(i!=o){this.focusItem(i,e);}}return;}this.fireEvent(I.Events.BeforeFocus,{index:i,event:e});this.setFocusedIndex(i);this.bISetFocus=true;if(e&&q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var b=q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");b._sFocusEvent=e.type;}L.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");this.aItemDomRefs[this.iFocusedIndex].focus({preventScroll:p});this.fireEvent(I.Events.AfterFocus,{index:i,event:e});};
I.prototype.setFocusedIndex=function(i){var $;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this;}if(i<0){i=0;}if(i>this.aItemDomRefs.length-1){i=this.aItemDomRefs.length-1;}q(this.oDomRef).attr("tabindex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);$=q(this.aItemDomRefs[this.iFocusedIndex]);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){q($.data("sap.INRoot").aItemDomRefs[$.data("sap.INRoot").iFocusedIndex]).attr("tabindex",-1);}}this.iFocusedIndex=i;var f=this.aItemDomRefs[this.iFocusedIndex];$=q(this.aItemDomRefs[this.iFocusedIndex]);if(!$.data("sap.INRoot")){q(f).attr("tabindex",this.iActiveTabIndex);}return this;};
I.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex];};
I.prototype.getFocusedIndex=function(){return this.iFocusedIndex;};
I.prototype.onfocusin=function(e){var s=e.target;var i=0;if(s==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true;}if(this._bMouseDownHappened){return;}var b;if(q(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!q(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":b=0;break;case"sapprevious":b=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){b=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){b=this.iFocusedIndex;}else{b=0;}break;}this._sFocusEvent=undefined;}else{if(this.iSelectedIndex!=-1){b=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){b=this.iFocusedIndex;}else{b=0;}}this.focusItem(b,e);if(this.iFocusedIndex==-1){for(i=b+1;i<this.aItemDomRefs.length;i++){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}if(this.iFocusedIndex==-1&&b>0){for(i=b-1;i>=0;i--){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}}}e.preventDefault();e.stopPropagation();}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(i=0;i<this.aItemDomRefs.length;i++){if(e.target==this.aItemDomRefs[i]){this.focusItem(i,e);break;}}}else{this.fireEvent(I.Events.AfterFocus,{index:this.iFocusedIndex,event:e});}}this.bISetFocus=false;};
I.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!c(this.oDomRef,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){var i;if(this.iSelectedIndex!=-1){i=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex;}else{i=0;}this.setFocusedIndex(i);var d;if(q(this.oDomRef).data("sap.INItem")){var p;d=q(this.oDomRef);while(!p){d=d.parent();if(d.data("sap.INRoot")){p=d.get(0);}}if(!e.relatedControlId||c(p,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);}}d=q(this.oDomRef);if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}this.fireEvent(I.Events.FocusLeave,{index:i,event:e});}};
I.prototype.onmousedown=function(e){var s=e.target;var b=function(d,o){var f=false;var C=q(d);while(!C.is(":sapFocusable")&&C.get(0)!=o){C=C.parent();}if(C.get(0)!=o){f=true;}return f;};if(c(this.oDomRef,s)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(c(o,s)){if(!this.bTableMode){this.focusItem(i,e,true);}else{if(o===s||!b(s,o)){this.focusItem(i,e,true);}}return;}}if(s==this.oDomRef){this._bMouseDownHappened=true;var t=this;window.setTimeout(function(){t._bMouseDownHappened=false;},20);}}};
I.prototype.onsapnext=function(e){if(!c(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;if(i>-1){if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,R=Math.floor(i/this.iColumns),C=i%this.iColumns;if(e.keyCode==K.ARROW_DOWN){if(R<r-1){i+=this.iColumns;}}else{if(C<this.iColumns-1){i+=1;}}}else{do{if(this.iColumns>1&&e.keyCode==K.ARROW_DOWN){if((i+this.iColumns)>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if((i%this.iColumns)<(this.iColumns-1)){i=(i%this.iColumns)+1;}else if(this.bCycling){i=0;}}else{i=this.iFocusedIndex;b=true;}}else{i=i+this.iColumns;}}else{if(i==this.aItemDomRefs.length-1){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=0;}else{i=this.iFocusedIndex;b=true;}}else{i++;}}if(i===this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapnext(e);};
I.prototype.onsapprevious=function(e){if(!c(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;var C=0;if(i>-1){if(this.bTableMode){var r=Math.floor(i/this.iColumns);C=i%this.iColumns;if(e.keyCode==K.ARROW_UP){if(r>0){i-=this.iColumns;}}else{if(C>0){i-=1;}}}else{do{if(this.iColumns>1&&e.keyCode==K.ARROW_UP){if((i-this.iColumns)<0){if(!this.bNoColumnChange){C=0;if((i%this.iColumns)>0){C=(i%this.iColumns)-1;}else if(this.bCycling){C=Math.min(this.iColumns-1,this.aItemDomRefs.length-1);}if(i===0&&C===0){i=0;}else{var R=Math.ceil(this.aItemDomRefs.length/this.iColumns);i=C+((R-1)*this.iColumns);if(i>=this.aItemDomRefs.length){i=i-this.iColumns;}}}else{i=this.iFocusedIndex;b=true;}}else{i=i-this.iColumns;}}else{if(i==0){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}else{i--;}}if(i==this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapprevious(e);};
I.prototype.onsappageup=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i-this.iPageSize;while(i>0&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;}if(i<0){if(!this.bNoColumnChange){i=0;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){i=this.iFocusedIndex%this.iColumns;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsappagedown=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i+this.iPageSize;while(i<this.aItemDomRefs.length-1&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;}if(i>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,C=this.iFocusedIndex%this.iColumns;i=(r-1)*this.iColumns+C;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsaphome=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;if(i==this.aItemDomRefs.length){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsaphome(e);};
I.prototype.onsapend=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.aItemDomRefs.length-1;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns+this.iColumns-1;}}else{if((e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=(r+1)*this.iColumns-1;if(i>=this.aItemDomRefs.length){i=this.aItemDomRefs.length-1;}}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;if(i<0){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapend(e);};
I.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0;};
I.prototype.onkeyup=function(e){if(e.keyCode==K.F2){var d=q(this.oDomRef);if(d.data("sap.InNavArea")){d.data("sap.InNavArea",false);}else if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}e.preventDefault();e.stopPropagation();}};
return I;});
sap.ui.predefine('sap/ui/core/delegate/ScrollEnablement',['sap/ui/Device','sap/ui/base/Object','sap/ui/core/Core','sap/ui/core/IntervalTrigger','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(D,B,C,I,R,q,K){"use strict";
var S=B.extend("sap.ui.core.delegate.ScrollEnablement",{
constructor:function(c,s,o){B.apply(this);this._oControl=c;this._oControl.addDelegate(this);this._sContentId=s;this._sContainerId=o.scrollContainerId;this._bHorizontal=!!o.horizontal;this._bVertical=!!o.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=0.9;this._iLastMaxScrollTop=0;i(this);if(this._init){this._init.apply(this,arguments);}},
setHorizontal:function(h){this._bHorizontal=!!h;this._setOverflow&&this._setOverflow();},
setVertical:function(v){this._bVertical=!!v;this._setOverflow&&this._setOverflow();},
getHorizontal:function(){return this._bHorizontal;},
getVertical:function(){return this._bVertical;},
setBounce:function(b){},
setPullDown:function(c){this._oPullDown=c;return this;},
setGrowingList:function(s,a,o){this._fnScrollLoadCallback=s;this._sScrollLoadDirection=a;this.onOverflowChange(o);return this;},
onOverflowChange:function(c){this._fnOverflowChangeCallback=c;if(!this._fnOverflowChangeCallback){this._deregisterOverflowMonitor();}},
setOnAfterScrollToElement:function(c){this._fnAfterScrollToElement=c;},
setIconTabBar:function(o,s,f){this._oIconTabBar=o;this._fnScrollEndCallback=q.proxy(s,o);this._fnScrollStartCallback=q.proxy(f,o);return this;},
scrollTo:function(x,y,t,s){this._scrollX=x;this._scrollY=y;this._scrollTo(x,y,t,s);return this;},
getChildPosition:function(e){var E=e instanceof q?e:q(e),o=E.position(),O=E.offsetParent(),a;while(!O.is(this._$Container)){a=O.position();o.top+=a.top;o.left+=a.left;O=O.offsetParent();}return o;},
scrollToElement:function(e,t,o){o=o||[0,0];if(!this._$Container[0].contains(e)||e.style.display==="none"||e.offsetParent.nodeName.toUpperCase()==="HTML"){return this;}var E=q(e),s=this.getChildPosition(E),l=this.getScrollLeft()+s.left+o[0],T=this.getScrollTop()+s.top+o[1];if(this._bFlipX){l=this.getScrollLeft()-(s.left-this._$Container.width())-E.width();}this._scrollTo(l,T,t,this._fnAfterScrollToElement);return this;},
destroy:function(){if(this._exit){this._exit();}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined;}},
refresh:function(){if(this._refresh){this._refresh();}},
_useDefaultScroll:function(t){return t.isContentEditable;},
onkeydown:function(e){if(this._useDefaultScroll(e.target)){return;}var c=this._$Container[0];if(e.altKey&&this.getHorizontal()){switch(e.keyCode){case K.PAGE_UP:this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);break;case K.PAGE_DOWN:this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);break;}}if(e.ctrlKey&&!e.altKey){switch(e.keyCode){case K.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-c.clientHeight*this._scrollCoef,e);}break;case K.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+c.clientHeight*this._scrollCoef,e);}break;case K.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);}break;case K.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);}break;case K.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,e);}if(this.getVertical()){this._customScrollTo(this._scrollX,0,e);}break;case K.END:var l=c.scrollWidth-c.clientWidth;var t=c.scrollHeight-c.clientHeight;if(!this.getHorizontal()){t=this._scrollY;}if(!this.getVertical()){l=C.getConfiguration().getRTL()?c.clientWidth-c.scrollWidth:this._scrollX;}this._customScrollTo(l,t,e);break;}}},
_customScrollTo:function(l,t,e){var N=e.target.nodeName;if(N!="INPUT"&&N!="TEXTAREA"){e.preventDefault();e.setMarked();this._scrollTo(l,t);}}
});
var n={getScrollTop:function(){return this._scrollY||0;},getScrollLeft:function(){return this._scrollX||0;},getScrollHeight:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight:0;},getMaxScrollTop:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight-c[0].clientHeight:-1;},getContainerDomRef:function(){return this._$Container&&this._$Container[0];},_cleanup:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._deregisterOverflowMonitor();},_setOverflow:function(){var c=this._$Container;if(!c||!c[0]){return;}if(D.os.ios){c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch");}else{c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden");}},_refresh:function(){var c=this._$Container;if(!(c&&c.length)){return;}if(this._oPullDown&&this._oPullDown._bTouchMode){var d=this._oPullDown.getDomRef();if(d){d.style.marginTop=this._oPullDown._iState==2?"":"-"+d.offsetHeight+"px";}}if(c.scrollTop()!=this._scrollY){c.scrollTop(this._scrollY);}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_onScroll:function(){var c=this._$Container,s=c.scrollTop(),v=s-this._scrollY;this._scrollX=c.scrollLeft();this._scrollY=s;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(v<0&&s<10){this._fnScrollLoadCallback();}}else if(v>=0&&c[0].scrollHeight-s-c[0].clientHeight<100){this._fnScrollLoadCallback();}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback();}},_onStart:function(e){var c=this._$Container[0];if(!c){return;}this._bDoDrag=this._bDragScroll;var p=e.touches?e.touches[0]:e;this._iX=p.pageX;this._iY=p.pageY;this._bPullDown=false;this._iDirection="";},_onTouchMove:function(e){var c=this._$Container[0];var p=e.touches?e.touches[0]:e;var d=p.pageX-this._iX;var a=p.pageY-this._iY;if(this._iDirection==""){if(d!=0||a!=0){this._iDirection=Math.abs(a)>Math.abs(d)?"v":"h";}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&c.scrollTop<=1){if(a>Math.abs(d)){this._bPullDown=true;}}}if(this._bPullDown===true){var b=this._oPullDown.getDomRef();var t=e.touches[0].pageY-this._iY-b.offsetHeight;if(t>20){t=20;}b.style.marginTop=t+"px";this._oPullDown.doPull(t);e.preventDefault();this._bDoDrag=false;}if(this._bDoDrag){var s=c.scrollLeft,f=c.scrollTop;if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=s-this._iX+p.pageX;}else{c.scrollLeft=s+this._iX-p.pageX;}}if(this._bVertical){c.scrollTop=f+this._iY-p.pageY;}if((c.scrollLeft!=s)||(c.scrollTop!=f)){e.setMarked&&e.setMarked();e.preventDefault();}this._iX=p.pageX;this._iY=p.pageY;return;}},_onEnd:function(e){if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh();}if(this._bDragScroll&&this._iDirection){e.setMarked&&e.setMarked();}},_onMouseDown:function(e){if(this._bDragScroll&&e.button==0){this._bScrolling=true;this._onStart(e);}},_onMouseMove:function(E){if(this._bScrolling){var e=E.originalEvent||E;var b=e.buttons||e.which;if(b==1||E.pressure){var c=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=c.scrollLeft-this._iX+E.pageX;}else{c.scrollLeft=c.scrollLeft+this._iX-E.pageX;}}if(this._bVertical){c.scrollTop=c.scrollTop+this._iY-E.pageY;}this._iX=E.pageX;this._iY=E.pageY;}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd();}},onBeforeRendering:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._deregisterOverflowMonitor();var c=this._$Container;if(c){if(c.height()>0){this._scrollX=c.scrollLeft();this._scrollY=c.scrollTop();}c.off();}},_checkOverflowChange:function(e){var m=this.getMaxScrollTop(),o=m>0&&this._iLastMaxScrollTop===0,u=m===0&&this._iLastMaxScrollTop>0,O=o||u;if(O){this._fnOverflowChangeCallback(o,m);}this._iLastMaxScrollTop=m;},_registerOverflowMonitor:function(){this._fnOverflowChangeCallback&&I.addListener(this._checkOverflowChange,this);},_deregisterOverflowMonitor:function(){I.removeListener(this._checkOverflowChange,this);},onAfterRendering:function(){var c=this._$Container=this._sContainerId?q(document.getElementById(this._sContainerId)):q(document.getElementById(this._sContentId)).parent();var _=q.proxy(this._refresh,this);var e=c.is(":visible");c.addClass("sapUiScrollDelegate");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY);}this._refresh();if(!e||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=R.register(c[0],_);}if(this._fnOverflowChangeCallback){this._iOverflowTimer&&window.cancelAnimationFrame(this._iOverflowTimer);this._iOverflowTimer=window.requestAnimationFrame(this._registerOverflowMonitor.bind(this));}c.on("scroll",this._onScroll.bind(this));var o=c[0];function a(E,l){E.split(" ").forEach(function(s){o&&o.addEventListener(s,l);});}function b(E){return E.pointerType=="touch"?this._onStart(E):this._onMouseDown(E);}function d(E){return E.pointerType=="touch"?this._onTouchMove(E):this._onMouseMove(E);}function f(E){return E.pointerType=="touch"?this._onEnd(E):this._onMouseUp(E);}if(D.support.pointer&&D.system.desktop){if(this._bDragScroll){a("pointerdown",b.bind(this));a("pointermove",d.bind(this));a("pointerup pointercancel pointerleave",f.bind(this));}}else if(D.support.touch){if(this._bDragScroll||this._oPullDown&&this._oPullDown._bTouchMode){c.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this));}}else if(this._bDragScroll){c.on("mouseup mouseleave",this._onMouseUp.bind(this)).on("mousedown",this._onMouseDown.bind(this)).on("mousemove",this._onMouseMove.bind(this));}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft();}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop();}},_scrollTo:function(x,y,t,s){if(this._$Container.length>0){if(t>0){this._$Container.finish().animate({scrollTop:y,scrollLeft:x},t,q.proxy(function(){this._readActualScrollPosition();s&&s();},this));}else{this._$Container.scrollTop(y);this._$Container.scrollLeft(x);this._readActualScrollPosition();s&&s();}}}};
function i(s){var d={_init:function(c,a,o){if(q.event&&q.event.special&&q.event.special.swipe&&q.event.special.swipe.scrollSupressionThreshold<120){q.event.special.swipe.scrollSupressionThreshold=120;}Object.assign(this,n);if(o.nonTouchScrolling===true){this._bDragScroll=true;}if(C.getConfiguration().getRTL()){this._scrollX=9999;}},_exit:function(){if(this._cleanup){this._cleanup();}}};Object.assign(s,d);}
return S;});
sap.ui.predefine('sap/ui/core/dnd/DragAndDrop',["sap/ui/Device","../UIArea","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,U,q){"use strict";var a={},d=null,o=null,v=null,V=[],b=[],c=null,$,g,C,t,l={},e;
function f(E,S){if(!E){return;}if(E.addStyleClass){E.addStyleClass(S);}else{E.$().addClass(S);}}
function r(E,S){if(!E){return;}if(E.removeStyleClass){E.removeStyleClass(S);}else{E.$().removeClass(S);}}
function h(E,i){var B=q(E.target).control(0,true);if(!B){return;}var N=q.Event(null,E);N.type=i;B.getUIArea()._handleEvent(N);}
function j(E){return!E.disabled&&/^(input|textarea)$/.test(E.localName);}
function s(d,E){if(!d||!d.getDragGhost){return;}var i=d.getDragGhost();if(!i){return;}if(!g){g=q('<div class="sapUiDnDGhostContainer"></div>');q(document.body).append(g);}g.append(i);window.setTimeout(function(){g.empty();},0);var O=E.originalEvent;O.dataTransfer.setDragImage(i,O.offsetX,O.offsetY);}
function k(E){var i={},I,B=E.originalEvent.dataTransfer,F=function(T,G){B.setData(T,G);};return{setData:function(K,G){G=""+G;i[K]=G;F(K,G);},getData:function(K){return i[K];},setTextData:function(G){G=""+G;i["text/plain"]=G;i["text"]=G;F("text/plain",G);F("text",G);},getTextData:function(){return i["text/plain"];},setComplexData:function(K,G){i[K]=G;},getComplexData:function(K){return i[K];},getIndicator:function(){return $&&$[0];},setIndicatorConfig:function(G){I=G;},getIndicatorConfig:function(G){return I;},getDragControl:function(){return d;},getDropControl:function(){return v;},setDropControl:function(G){v=G;},getDropInfo:function(){return b[0]||null;},getDropPosition:function(){return C;}};}
function m(E){d=o=v=c=null;C="";V=[];b=[];}
function n(){if($){return $;}$=q("<div class='sapUiDnDIndicator'></div>");q(sap.ui.getCore().getStaticAreaRef()).append($);return $;}
function p(){if($){$.removeAttr("style");$.hide();l={};}}
function u(E,i,B,F){if(!i){return;}var I=E.dragSession&&E.dragSession.getIndicatorConfig(),G=i.getBoundingClientRect(),P=window.pageYOffset,H=window.pageXOffset,J=n(),R,S={},K={top:G.top+P,bottom:G.bottom+P,left:G.left+H,right:G.right+H,width:G.width,height:G.height};if(!B||B=="On"){R="On";F="";}else if(F=="Horizontal"){var L=E.pageX-K.left;S.height=K.height;S.top=K.top;if(B=="Between"){S.width="";if(L<K.width*0.5){R="Before";S.left=K.left;}else{R="After";S.left=K.right;}}else if(B=="OnOrBetween"){if(L<K.width*0.25){R="Before";S.left=K.left;S.width="";}else if(L>K.width*0.75){R="After";S.left=K.right;S.width="";}else{R="On";}}if(R!="On"&&sap.ui.getCore().getConfiguration().getRTL()){R=(R=="After")?"Before":"After";}}else{var M=E.pageY-K.top;S.width=K.width;S.left=K.left;if(B=="Between"){S.height="";if(M<K.height*0.5){R="Before";S.top=K.top;}else{R="After";S.top=K.bottom;}}else if(B=="OnOrBetween"){if(M<K.height*0.25){R="Before";S.top=K.top;S.height="";}else if(M>K.height*0.75){R="After";S.top=K.bottom;S.height="";}else{R="On";}}}if(I&&I.display=="none"){return R;}if(R=="On"){S.top=K.top;S.left=K.left;S.width=K.width;S.height=K.height;B=R;}else{B="Between";}if(l.top!=S.top||l.left!=S.left||l.width!=S.width||l.height!=S.height){J.attr("data-drop-layout",F);J.attr("data-drop-position",B);J.css(Object.assign(S,I));J.show();l=S;}return R;}
function w(i){var P=i.getParent(),S=(i.getDragDropConfig)?i.getDragDropConfig():[],B=(P&&P.getDragDropConfig)?P.getDragDropConfig():[];return S.concat(B);}
function x(d){var i=w(d);return i.filter(function(B){return B.isDraggable(d);});}
function y(o,i,E){var B=w(o);i=i||[];return B.filter(function(F){return!F.isA("sap.ui.core.dnd.IDragInfo");}).concat(i).filter(function(F){if(!F.isDroppable(o,E)){return false;}var G=F.getGroupName();if(!G){return true;}return i.some(function(H){return H.getGroupName()==G;});});}
function z(E,i){E.preventDefault();var B=i.getDropEffect().toLowerCase();E.originalEvent.dataTransfer.dropEffect=B;}
function A(E,i,v){var T=i.getTargetAggregation();if(!T){return u(E,v.getDomRef());}var B;if(E.getMark("DragWithin")==T){B=v.getDomRefForSetting(T);}B=B||v.getDomRef();return u(E,B,i.getDropPosition(true),i.getDropLayout(true));}
a.preprocessEvent=function(E){if(c&&E.type.indexOf("dr")==0){E.dragSession=c;}var i="onbefore"+E.type;if(a[i]){a[i](E);}};
a.postprocessEvent=function(E){var i="onafter"+E.type;if(a[i]){a[i](E);}};
a.onbeforemousedown=function(E){if((D.browser.firefox)&&j(E.target)){e=q(E.target).closest("[data-sap-ui-draggable=true]").prop("draggable",false)[0];}};
a.onbeforemouseup=function(E){if(e){e.draggable=true;e=null;}};
a.onbeforedragstart=function(E){if(!E.target.draggable){return;}if(j(document.activeElement)){E.target.getAttribute("data-sap-ui-draggable")&&E.preventDefault();return;}d=q(E.target).control(0,true);if(!d){return;}V=x(d);if(!V.length){return;}if(D.browser.firefox&&E.originalEvent.dataTransfer.types.length===0){E.originalEvent.dataTransfer.setData("ui5/dummyDataForFirefox","data");}E.dragSession=c=k(E);};
a.onafterdragstart=function(E){if(!V.length||E.isDefaultPrevented()){m();return;}V=E.isMarked("NonDraggable")?[]:V.filter(function(i){return i.fireDragStart(E);});if(!V.length){E.preventDefault();m();return;}s(d,E);f(d,"sapUiDnDDragging");if(q(E.target).closest(".sapUiScrollDelegate")[0]){q("html").addClass("sapUiDnDNoScrolling");}};
a.onbeforedragenter=function(E){var B=q(E.target).control(0,true);if(B&&o===B){E.setMark("DragWithin","SameControl");}else{t=Date.now();o=B;}var F=[];v=B;for(var i=0;i<20&&v;i++,v=v.getParent()){F=y(v,V,E);if(F.length){break;}}if(E.getMark("DragWithin")!="SameControl"){b=F;if(c){c.setIndicatorConfig(null);}}if(!b.length){v=null;}else if(!c){E.dragSession=c=k(E);}};
a.onafterdragenter=function(E){if(!v||E.isMarked("NonDroppable")){b=[];}else if(E.getMark("DragWithin")!="SameControl"){b=b.filter(function(B){return B.fireDragEnter(E);});}var i=b[0];if(!i||i.getDropEffect()=="None"){p();C="";}else{z(E,i);C=A(E,i,v);}};
a.onbeforedragover=function(E){var i=Date.now();if(i-t>=1000){h(E,"longdragover");t=i;}};
a.onafterdragover=function(E){var i=b[0];if(!i||i.getDropEffect()=="None"){return;}b.forEach(function(B){B.fireDragOver(E);});z(E,i);if(i&&i.getDropPosition(true)=="On"){return;}C=A(E,i,v);};
a.onbeforedrop=function(E){if(b.length){E.preventDefault();}};
a.onafterdrop=function(E){b.forEach(function(i){i.fireDrop(E);});this.iDragEndTimer=window.requestAnimationFrame(this.onafterdragend.bind(this,E));};
a.onafterdragend=function(E){this.iDragEndTimer=window.cancelAnimationFrame(this.iDragEndTimer);V.forEach(function(i){i.fireDragEnd(E);});r(d,"sapUiDnDDragging");q("html").removeClass("sapUiDnDNoScrolling");p();m();};
U.addEventPreprocessor(a.preprocessEvent);U.addEventPostprocessor(a.postprocessEvent);return a;},true);
sap.ui.predefine('sap/ui/core/dnd/DragDropBase',['sap/base/Log','../Element','../library','./DragAndDrop'],function(L,E){"use strict";
var D=E.extend("sap.ui.core.dnd.DragDropBase",{metadata:{"abstract":true,library:"sap.ui.core",properties:{groupName:{type:"string",defaultValue:null,invalidate:false},enabled:{type:"boolean",defaultValue:true,invalidate:false}}}});
D.prototype.bIgnoreMetadataCheck=false;
D.prototype.isDraggable=function(c){return false;};
D.prototype.isDroppable=function(c,e){return false;};
D.prototype.checkMetadata=function(c,a,r){if(this.bIgnoreMetadataCheck){return true;}var m=c.getMetadata().getDragDropInfo(a);if(!m[r]){L.warning((a?a+" aggregation of ":"")+c+" is not configured to be "+r);return false;}return true;};
D.prototype.setProperty=function(p,v,s){s=(s==undefined)?(this.getMetadata().getProperty(p).appData||{}).invalidate===false:s;return E.prototype.setProperty.call(this,p,v,s);};
return D;});
sap.ui.predefine('sap/ui/core/dnd/DragDropInfo',["./DragInfo","./DropInfo","sap/ui/Device","sap/base/Log"],function(D,a,b,L){"use strict";
var c=a.extend("sap.ui.core.dnd.DragDropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo","sap.ui.core.dnd.IDropInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},associations:{targetElement:{type:"sap.ui.core.Element",multiple:false}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
D.Mixin.apply(c.prototype);
c.prototype.getDropTarget=function(){var t=this.getTargetElement();if(t){return sap.ui.getCore().byId(t);}return this.getParent();};
c.prototype.setGroupName=function(){L.error("groupName property must not be set on "+this);return this;};
return c;});
sap.ui.predefine('sap/ui/core/dnd/DragInfo',["./DragDropBase"],function(D){"use strict";
var a=D.extend("sap.ui.core.dnd.DragInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
a.Mixin=function(){this.isDraggable=function(c){if(!this.getEnabled()){return false;}var d=this.getParent();if(!d){return false;}var s=this.getSourceAggregation();if(!this.checkMetadata(d,s,"draggable")){return false;}if(d===c&&!s){return true;}if(c.getParent()===d&&s===c.sParentAggregationName){return true;}return false;};this.fireDragStart=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragStart",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()},true);};this.fireDragEnd=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnd",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()});};this.setEnabled=function(e){this.setProperty("enabled",e,false);this.invalidateDraggables();return this;};this.setParent=function(){D.prototype.setParent.apply(this,arguments);this.invalidateDraggables();return this;};this.setSourceAggregation=function(s){var o=this.getSourceAggregation();if(o==s){return this;}o&&this.invalidateDraggables();this.setProperty("sourceAggregation",s,false);this.invalidateDraggables();return this;};this.invalidateDraggables=function(){var p=this.getParent();if(p&&p.bOutput==true){var s=this.getSourceAggregation();if(s){[].concat(p.getAggregation(s)).forEach(function(A){if(A&&A.bOutput==true){A.invalidate();}});}else{p.invalidate();}}};};
a.Mixin.apply(a.prototype);return a;});
sap.ui.predefine('sap/ui/core/dnd/DropInfo',["./DragDropBase"],function(D){"use strict";
var a=D.extend("sap.ui.core.dnd.DropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{targetAggregation:{type:"string",defaultValue:null,invalidate:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move",invalidate:false},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On",invalidate:false},dropLayout:{type:"sap.ui.core.dnd.DropLayout",defaultValue:"Default",invalidate:false}},events:{dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});
a.prototype.getDropTarget=function(){return this.getParent();};
a.prototype.isDroppable=function(c,e){this.sTemporaryDropPosition="";if(!this.getEnabled()){return false;}var d=this.getDropTarget();if(!d){return false;}var t=this.getTargetAggregation();if(!this.checkMetadata(d,t,"droppable")){return false;}var t=this.getTargetAggregation();if(d===c&&!t){return true;}if(c.getParent()===d&&t===c.sParentAggregationName){return true;}if(e&&t&&d===c){var A=c.getDomRefForSetting(t);if(A&&A!=e.target&&A.contains(e.target)){e.setMark("DragWithin",t);this.sTemporaryDropPosition="On";return true;}}return false;};
a.prototype.getDropPosition=function(c){if(c&&this.sTemporaryDropPosition){return this.sTemporaryDropPosition;}return this.getProperty("dropPosition");};
a.prototype.getDropLayout=function(d){var s=this.getProperty("dropLayout");if(!d||s!="Default"){return s;}return this.getDropTarget().getMetadata().getDragDropInfo(this.getTargetAggregation()).layout;};
a.prototype.fireDragEnter=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl()},true);};
a.prototype.fireDragOver=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl(),dropPosition:d.getDropPosition()});};
a.prototype.fireDrop=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:d.getDropPosition(),draggedControl:d.getDragControl(),droppedControl:d.getDropControl()});};
return a;});
sap.ui.predefine('sap/ui/core/format/DateFormat',['sap/ui/core/CalendarType','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate',"sap/base/util/deepEqual","sap/base/strings/formatMessage","sap/base/Log","sap/base/util/extend"],function(C,L,a,U,d,f,b,e){"use strict";var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,i){return o.getDatePattern(s,i);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,i){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),i);}else{return o.getCombinedDateTimePattern(s,s,i);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,i){return o.getTimePattern(s,i);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};
D.getInstance=function(o,i){return this.getDateInstance(o,i);};
D.getDateInstance=function(o,i){return this.createInstance(o,i,this.oDateInfo);};
D.getDateTimeInstance=function(o,i){return this.createInstance(o,i,this.oDateTimeInfo);};
D.getTimeInstance=function(o,i){return this.createInstance(o,i,this.oTimeInfo);};
function g(o){var P=o.oLocaleData.getIntervalPattern("",o.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,o.oFormatOptions.pattern);}
D.createInstance=function(o,i,I){var j=Object.create(this.prototype);if(o instanceof L){i=o;o=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}j.oLocale=i;j.oLocaleData=a.getInstance(i);j.oFormatOptions=e({},I.oDefaultFormatOptions,o);if(!j.oFormatOptions.calendarType){j.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!j.oFormatOptions.pattern){if(j.oFormatOptions.format){j.oFormatOptions.pattern=j.oLocaleData.getCustomDateTimePattern(j.oFormatOptions.format,j.oFormatOptions.calendarType);}else{j.oFormatOptions.pattern=I.getPattern(j.oLocaleData,j.oFormatOptions.style,j.oFormatOptions.calendarType);}}if(j.oFormatOptions.interval){if(j.oFormatOptions.format){j.intervalPatterns=j.oLocaleData.getCustomIntervalPattern(j.oFormatOptions.format,null,j.oFormatOptions.calendarType);if(typeof j.intervalPatterns==="string"){j.intervalPatterns=[j.intervalPatterns];}j.intervalPatterns.push(j.oLocaleData.getCustomDateTimePattern(j.oFormatOptions.format,j.oFormatOptions.calendarType));}else{j.intervalPatterns=[j.oLocaleData.getCombinedIntervalPattern(j.oFormatOptions.pattern,j.oFormatOptions.calendarType),j.oFormatOptions.pattern];}var s=g(j);j.intervalPatterns.push(s);}if(!j.oFormatOptions.fallback){if(!I.oFallbackFormats){I.oFallbackFormats={};}var n=i.toString(),q=j.oFormatOptions.calendarType,K=n+"-"+q,P,t;if(j.oFormatOptions.pattern&&I.bPatternFallbackWithoutDelimiter){K=K+"-"+j.oFormatOptions.pattern;}if(j.oFormatOptions.interval){K=K+"-"+"interval";}var u=I.oFallbackFormats[K]?Object.assign({},I.oFallbackFormats[K]):undefined;if(!u){t=I.aFallbackFormatOptions;if(I.bShortFallbackFormatOptions){P=I.getPattern(j.oLocaleData,"short");t=t.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(j.oFormatOptions.pattern&&I.bPatternFallbackWithoutDelimiter){t=D._createFallbackOptionsWithoutDelimiter(j.oFormatOptions.pattern).concat(t);}u=D._createFallbackFormat(t,q,i,I,j.oFormatOptions.interval);}j.aFallbackFormats=u;}j.oRequiredParts=I.oRequiredParts;j.aRelativeScales=I.aRelativeScales;j.aRelativeParseScales=I.aRelativeParseScales;j.aIntervalCompareFields=I.aIntervalCompareFields;j.init();return j;};
D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};
D._createFallbackFormat=function(i,s,o,I,j){return i.map(function(O){var n=Object.assign({},O);if(j){n.interval=true;}n.calendarType=s;n.fallback=true;var q=D.createInstance(n,o,I);q.bIsFallback=true;return q;});};
D._createFallbackOptionsWithoutDelimiter=function(B){var i=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(i,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};
var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,i){var n=-1,M=0;for(var j=0;j<i.length;j++){if(i[j]&&i[j].length>M&&v.indexOf(i[j])===0){n=j;M=i[j].length;}}return{index:n,value:n===-1?null:i[n]};},parseTZ:function(v,i){var j=0;var t=v.charAt(0)=="+"?-1:1;var P;j++;P=this.findNumbers(v.substr(j),2);var T=parseInt(P);j+=2;if(i){j++;}P=this.findNumbers(v.substr(j),2);var n=0;if(P){j+=2;n=parseInt(P);}return{length:j,tzDiff:(n+60*T)*t};},checkValid:function(t,P,o){if(t in o.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(o,i,u,j){return o.value;},parse:function(v,P,o,i){var s;var V=true;var j=0;var n=0;var q="\u002d\u007E\u2010\u2011\u2012\u2013\u2014\ufe58\ufe63\uff0d\uFF5E";for(;n<P.value.length;n++){s=P.value.charAt(n);if(s===" "){while(v.charAt(j)===" "){j++;}}else if(q.includes(s)){if(!q.includes(v.charAt(j))){V=false;}j++;}else{if(v.charAt(j)!==s){V=false;}j++;}if(!V){break;}}if(V){return{length:j};}else{var t=false;if(i.index<i.formatArray.length-1){t=(i.formatArray[i.index+1].type in o.oRequiredParts);}return{valid:p.checkValid(P.type,t,o)};}}},"G":{name:"era",format:function(o,i,u,j){var E=u?i.getUTCEra():i.getEra();if(o.digits<=3){return j.aErasAbbrev[E];}else if(o.digits===4){return j.aErasWide[E];}else{return j.aErasNarrow[E];}},parse:function(v,P,o,j){var E=[o.aErasWide,o.aErasAbbrev,o.aErasNarrow];for(var i=0;i<E.length;i++){var V=E[i];var n=p.findEntry(v,V);if(n.index!==-1){return{era:n.index,length:n.value.length};}}return{era:o.aErasWide.length-1,valid:p.checkValid(P.type,true,o)};}},"y":{name:"year",format:function(o,i,u,j){var y=u?i.getUTCFullYear():i.getFullYear();var Y=String(y);var s=j.oFormatOptions.calendarType;if(o.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&o.digits==1&&y<100){Y=Y.padStart(4,"0");}return Y.padStart(o.digits,"0");},parse:function(v,P,o,i){var s=o.oFormatOptions.calendarType;var j;if(P.digits==1){j=p.findNumbers(v,4);}else if(P.digits==2){j=p.findNumbers(v,2);}else{j=p.findNumbers(v,P.digits);}var y=parseInt(j);if(s!=C.Japanese&&j.length<=2){var n=U.getInstance(new Date(),s),q=n.getFullYear(),t=Math.floor(q/100),Y=t*100+y-q;if(Y<-70){y+=(t+1)*100;}else if(Y<30){y+=t*100;}else{y+=(t-1)*100;}}return{length:j.length,valid:p.checkValid(P.type,j==="",o),year:y};}},"Y":{name:"weekYear",format:function(o,i,u,j){var w=u?i.getUTCWeek():i.getWeek();var W=w.year;var s=String(W);var n=j.oFormatOptions.calendarType;if(o.digits==2&&s.length>2){s=s.substr(s.length-2);}if(n!=C.Japanese&&o.digits==1&&W<100){s=s.padStart(4,"0");}return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var s=o.oFormatOptions.calendarType;var j;if(P.digits==1){j=p.findNumbers(v,4);}else if(P.digits==2){j=p.findNumbers(v,2);}else{j=p.findNumbers(v,P.digits);}var y=parseInt(j);var w;if(s!=C.Japanese&&j.length<=2){var n=U.getInstance(new Date(),s),q=n.getFullYear(),t=Math.floor(q/100),Y=t*100+w-q;if(Y<-70){w+=(t+1)*100;}else if(Y<30){w+=t*100;}else{w+=(t-1)*100;}}return{length:j.length,valid:p.checkValid(P.type,j==="",o),year:y,weekYear:w};}},"M":{name:"month",format:function(o,i,u,j){var M=u?i.getUTCMonth():i.getMonth();if(o.digits==3){return j.aMonthsAbbrev[M];}else if(o.digits==4){return j.aMonthsWide[M];}else if(o.digits>4){return j.aMonthsNarrow[M];}else{return String(M+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var M=[o.aMonthsWide,o.aMonthsWideSt,o.aMonthsAbbrev,o.aMonthsAbbrevSt,o.aMonthsNarrow,o.aMonthsNarrowSt];var V;var n;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);n=parseInt(s)-1;if(j.strict&&(n>11||n<0)){V=false;}}else{for(var i=0;i<M.length;i++){var q=M[i];var t=p.findEntry(v,q);if(t.index!==-1){return{month:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{month:n,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(o,i,u,j){var M=u?i.getUTCMonth():i.getMonth();if(o.digits==3){return j.aMonthsAbbrevSt[M];}else if(o.digits==4){return j.aMonthsWideSt[M];}else if(o.digits>4){return j.aMonthsNarrowSt[M];}else{return String(M+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var M=[o.aMonthsWide,o.aMonthsWideSt,o.aMonthsAbbrev,o.aMonthsAbbrevSt,o.aMonthsNarrow,o.aMonthsNarrowSt];var V;var n;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);n=parseInt(s)-1;if(j.strict&&(n>11||n<0)){V=false;}}else{for(var i=0;i<M.length;i++){var q=M[i];var t=p.findEntry(v,q);if(t.index!==-1){return{month:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{month:n,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(o,i,u,j){var w=u?i.getUTCWeek():i.getWeek();var W=w.week;var s=String(W+1);if(o.digits<3){s=s.padStart(o.digits,"0");}else{s=j.oLocaleData.getCalendarWeek(o.digits===3?"narrow":"wide",s.padStart(2,"0"));}return s;},parse:function(v,P,o,i){var V;var s;var w;var j=0;if(P.digits<3){s=p.findNumbers(v,2);j=s.length;w=parseInt(s)-1;V=p.checkValid(P.type,!s,o);}else{s=o.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var n=new RegExp(s),R=n.exec(v);if(R){j=R[0].length;w=parseInt(R[0])-1;}else{V=p.checkValid(P.type,true,o);}}return{length:j,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(o,i,u,j){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(o,i,u,j){},parse:function(){return{};}},"d":{name:"day",format:function(o,i,u,j){var n=u?i.getUTCDate():i.getDate();return String(n).padStart(o.digits,"0");},parse:function(v,P,o,i){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",o);var j=parseInt(s);if(i.strict&&(j>31||j<1)){V=false;}return{day:j,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(o,i,u,j){var q=u?i.getUTCQuarter():i.getQuarter();if(o.digits==3){return j.aQuartersAbbrev[q];}else if(o.digits==4){return j.aQuartersWide[q];}else if(o.digits>4){return j.aQuartersNarrow[q];}else{return String(q+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var V;var q;var s;var Q=[o.aQuartersWide,o.aQuartersWideSt,o.aQuartersAbbrev,o.aQuartersAbbrevSt,o.aQuartersNarrow,o.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);q=parseInt(s)-1;if(j.strict&&q>3){V=false;}}else{for(var i=0;i<Q.length;i++){var n=Q[i];var t=p.findEntry(v,n);if(t.index!==-1){return{quarter:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{length:s?s.length:0,quarter:q,valid:V};}},"q":{name:"quarterStandalone",format:function(o,i,u,j){var q=u?i.getUTCQuarter():i.getQuarter();if(o.digits==3){return j.aQuartersAbbrevSt[q];}else if(o.digits==4){return j.aQuartersWideSt[q];}else if(o.digits>4){return j.aQuartersNarrowSt[q];}else{return String(q+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var V;var q;var s;var Q=[o.aQuartersWide,o.aQuartersWideSt,o.aQuartersAbbrev,o.aQuartersAbbrevSt,o.aQuartersNarrow,o.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);q=parseInt(s)-1;if(j.strict&&q>3){V=false;}}else{for(var i=0;i<Q.length;i++){var n=Q[i];var t=p.findEntry(v,n);if(t.index!==-1){return{quarter:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{length:s?s.length:0,quarter:q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(o,i,u,j){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();if(o.digits<4){return j.aDaysAbbrev[n];}else if(o.digits==4){return j.aDaysWide[n];}else if(o.digits==5){return j.aDaysNarrow[n];}else{return j.aDaysShort[n];}},parse:function(v,P,o,j){var n=[o.aDaysWide,o.aDaysWideSt,o.aDaysAbbrev,o.aDaysAbbrevSt,o.aDaysShort,o.aDaysShortSt,o.aDaysNarrow,o.aDaysNarrowSt];for(var i=0;i<n.length;i++){var V=n[i];var q=p.findEntry(v,V);if(q.index!==-1){return{dayOfWeek:q.index,length:q.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();if(o.digits<4){return j.aDaysAbbrevSt[n];}else if(o.digits==4){return j.aDaysWideSt[n];}else if(o.digits==5){return j.aDaysNarrowSt[n];}else{return j.aDaysShortSt[n];}},parse:function(v,P,o,j){var n=[o.aDaysWide,o.aDaysWideSt,o.aDaysAbbrev,o.aDaysAbbrevSt,o.aDaysShort,o.aDaysShortSt,o.aDaysNarrow,o.aDaysNarrowSt];for(var i=0;i<n.length;i++){var V=n[i];var q=p.findEntry(v,V);if(q.index!==-1){return{day:q.index,length:q.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();return j._adaptDayOfWeek(n);},parse:function(v,P,o,i){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s),length:s.length};}},"a":{name:"amPmMarker",format:function(o,i,u,j){var n=u?i.getUTCDayPeriod():i.getDayPeriod();return j.aDayPeriods[n];},parse:function(v,P,o,i){var j;var n;var A=o.aDayPeriods[0],s=o.aDayPeriods[1];var q=/[aApP](?:\.)?[\x20\xA0]?[mM](?:\.)?/;var M=v.match(q);var V=(M&&M.index===0);if(V){v=M[0];A=A.replace(/[\x20\xA0]/g,"");s=s.replace(/[\x20\xA0]/g,"");v=v.replace(/[\x20\xA0]/g,"");A=A.replace(/\./g,"").toLowerCase();s=s.replace(/\./g,"").toLowerCase();v=v.replace(/\./g,"").toLowerCase();}if(v.indexOf(A)===0){j=false;n=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){j=true;n=(V?M[0].length:s.length);}return{pm:j,length:n};}},"H":{name:"hour0_23",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();return String(H).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&H>23){V=false;}return{hour:H,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s=(H===0?"24":String(H));return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(H==24){H=0;}if(i.strict&&H>23){V=false;}return{hour:H,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s=String(H>11?H-12:H);return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&H>11){V=false;}return{hour:H,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s;if(H>12){s=String(H-12);}else if(H==0){s="12";}else{s=String(H);}return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var j=i.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);var V=p.checkValid(P.type,s==="",o);if(H==12){H=0;j=(j===undefined)?true:j;}if(i.strict&&H>11){V=false;}return{hour:H,length:s.length,pm:j,valid:V};}},"m":{name:"minute",format:function(o,i,u,j){var M=u?i.getUTCMinutes():i.getMinutes();return String(M).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(o,i,u,j){var s=u?i.getUTCSeconds():i.getSeconds();return String(s).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(o,i,u,j){var M=u?i.getUTCMilliseconds():i.getMilliseconds();var s=String(M);var n=s.padStart(3,"0");n=n.substr(0,o.digits);n=n.padEnd(o.digits,"0");return n;},parse:function(v,P,o,i){var s=p.findNumbers(v,P.digits);var j=s.length;s=s.substr(0,3);s=s.padEnd(3,"0");var M=parseInt(s);return{length:j,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(o,i,u,j){if(o.digits>3&&i.getTimezoneLong&&i.getTimezoneLong()){return i.getTimezoneLong();}else if(i.getTimezoneShort&&i.getTimezoneShort()){return i.getTimezoneShort();}var t="GMT";var T=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=String(H).padStart(2,"0");t+=":";t+=String(M).padStart(2,"0");}else{t+="Z";}return t;},parse:function(v,P,o,i){var j=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){j=3;}else if(v.substring(0,2)==="UT"){j=2;}else if(v.charAt(0)==="Z"){j=1;t=0;}else{return{error:"cannot be parsed correctly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!=="Z"){var n=p.parseTZ(v.substr(j),true);j+=n.length;t=n.tzDiff;}return{length:j,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(o,i,u,j){var t=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(t/60);var M=t%60;var T="";if(!u){T+=(P?"-":"+");T+=String(H).padStart(2,"0");T+=String(M).padStart(2,"0");}return T;},parse:function(v,P,o,i){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(o,i,u,j){var t=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=String(H).padStart(2,"0");if(o.digits>1||M>0){if(o.digits===3||o.digits===5){T+=":";}T+=String(M).padStart(2,"0");}}else{T+="Z";}return T;},parse:function(v,P,o,i){if(v.charAt(0)==="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,P.digits===3||P.digits===5);}}}};
D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var R=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(R){return R;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,n,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}n=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){n=new String(n);n.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return n;};
D.prototype.format=function(j,u){var s=this.oFormatOptions.calendarType,R;if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){b.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){b.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}if(this.oFormatOptions.singleIntervalValue){if(j[0]===null){b.error("First date instance which is passed to the interval DateFormat shouldn't be null.");return"";}if(j[1]===null){R=this._format(j[0],u);}}if(R===undefined){var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){b.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}R=this._formatInterval(j,u);}}else{if(!j||isNaN(j.getTime())){b.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){b.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}R=this._format(j,u);}if(s==C.Japanese&&this.oLocale.getLanguage()==="ja"){R=R.replace(/(^|[^\d])1年/g,"$1元年");}return R;};
D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var o=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var n;var P;var S;var B=[];var q;var v=[];var w=this._getGreatestDiffField([o,t],u);if(!w){return this._format(j[0],u);}if(this.oFormatOptions.format){q=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,w,s);}else{q=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}v=this.parseCldrDatePattern(q);n=o;for(var i=0;i<v.length;i++){P=v[i];S=P.symbol||"";if(P.repeat){n=t;}B.push(this.oSymbols[S].format(P,n,u,this));}return B.join("");};
var F={Era:"Era",FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};
D.prototype._getGreatestDiffField=function(i,u){var j=false,n={};this.aIntervalCompareFields.forEach(function(s){var G="get"+(u?"UTC":""),M=G+s,o=F[s],v=i[0][M].apply(i[0]),t=i[1][M].apply(i[1]);if(!d(v,t)){j=true;n[o]=true;}});if(j){return n;}return null;};
D.prototype._parse=function(v,j,u,s){var I=0,P,S,R;var o={valid:true};var n={formatArray:j,dateValue:o,strict:s};for(var i=0;i<j.length;i++){S=v.substr(I);P=j[i];n.index=i;R=this.oSymbols[P.symbol||""].parse(S,P,this,n)||{};o=e(o,R);if(R.valid===false){break;}I+=R.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.dayNumberOfWeek===undefined&&o.dayOfWeek!==undefined){o.dayNumberOfWeek=this._adaptDayOfWeek(o.dayOfWeek);}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};
D.prototype._parseInterval=function(v,s,u,S){var j,R,o;this.intervalPatterns.some(function(P){var n=this.parseCldrDatePattern(P);R=undefined;for(var i=0;i<n.length;i++){if(n[i].repeat){R=i;break;}}if(R===undefined){o=this._parse(v,n,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}j=[o,o];return true;}else{j=[];o=this._parse(v,n.slice(0,R),u,S);if(o.valid===false){return;}j.push(o);var q=o.index;o=this._parse(v.substring(q),n.slice(R),u,S);if(o.index===0||o.index+q<v.length){o.valid=false;}if(o.valid===false){return;}j.push(o);return true;}}.bind(this));return j;};
var h=function(o,s,u,S){var i,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){i=U.getInstance(new Date(0),s);i.setUTCEra(o.era||U.getCurrentEra(s));i.setUTCFullYear(y);i.setUTCMonth(o.month||0);i.setUTCDate(o.day||1);i.setUTCHours(o.hour||0);i.setUTCMinutes(o.minute||0);i.setUTCSeconds(o.second||0);i.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==i.getUTCDate()){o.valid=false;i=undefined;}else{if(o.tzDiff){i.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined&&(o.month===undefined||o.day===undefined)){i.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){i.setUTCDate(i.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{i=U.getInstance(new Date(1970,0,1,0,0,0),s);i.setEra(o.era||U.getCurrentEra(s));i.setFullYear(y);i.setMonth(o.month||0);i.setDate(o.day||1);i.setHours(o.hour||0);i.setMinutes(o.minute||0);i.setSeconds(o.second||0);i.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==i.getDate()){o.valid=false;i=undefined;}else if(o.week!==undefined&&(o.month===undefined||o.day===undefined)){i.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){i.setDate(i.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){i=i.getJSDate();return i;}}return null;};
function m(o,i){if(o===i){return o;}var M={};Object.keys(o).forEach(function(K){M[K]=o[K];});Object.keys(i).forEach(function(K){if(!M.hasOwnProperty(K)){M[K]=i[K];}});return M;}
function k(s,E){if(s.getTime()>E.getTime()){return false;}return true;}
D.prototype.parse=function(v,u,s){v=v==null?"":String(v).trim();var o;var i=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(i==C.Japanese&&this.oLocale.getLanguage()==="ja"){v=v.replace(/元年/g,"1年");}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=h(o,i,u,s);if(j){return j;}}else{var n=this._parseInterval(v,i,u,s);var J,q;if(n&&n.length==2){var t=m(n[0],n[1]);var w=m(n[1],n[0]);J=h(t,i,u,s);q=h(w,i,u,s);if(J&&q){if(this.oFormatOptions.singleIntervalValue&&J.getTime()===q.getTime()){return[J,null];}var V=k(J,q);if(s&&!V){b.error("StrictParsing: Invalid date range. The given end date is before the start date.");return[null,null];}return[J,q];}}}if(!this.bIsFallback){var x;this.aFallbackFormats.every(function(y){x=y.parse(v,u,s);if(Array.isArray(x)){return!(x[0]&&x[1]);}else{return!x;}});return x;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};
D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var j=[],i,q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var t=P.charAt(i),N,u,v;if(q){if(t=="'"){u=P.charAt(i-1);v=P.charAt(i-2);N=P.charAt(i+1);if(u=="'"&&v!="'"){q=false;}else if(N=="'"){i+=1;}else{q=false;continue;}}if(s=="text"){o.value+=t;}else{o={type:"text",value:t};j.push(o);s="text";}}else{if(t=="'"){q=true;}else if(this.oSymbols[t]){n=this.oSymbols[t].name;if(s==n){o.digits++;}else{o={type:n,symbol:t,digits:1};j.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=t;}else{o={type:"text",value:t};j.push(o);s="text";}}}}c[P]=j;return j;};
D.prototype.parseRelative=function(v,u){var P,E,j,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){E=P[i];j=new RegExp("^\\s*"+E.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=j.exec(v);if(R){if(E.value!==undefined){return n(E.value,E.scale);}else{V=parseInt(R[1]);return n(V*E.sign,E.scale);}}}function n(o,s){var t,T=new Date(),J;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}J=new Date(t);switch(s){case"second":J.setUTCSeconds(J.getUTCSeconds()+o);break;case"minute":J.setUTCMinutes(J.getUTCMinutes()+o);break;case"hour":J.setUTCHours(J.getUTCHours()+o);break;case"day":J.setUTCDate(J.getUTCDate()+o);break;case"week":J.setUTCDate(J.getUTCDate()+o*7);break;case"month":J.setUTCMonth(J.getUTCMonth()+o);break;case"quarter":J.setUTCMonth(J.getUTCMonth()+o*3);break;case"year":J.setUTCFullYear(J.getUTCFullYear()+o);break;}if(u){return J;}else{return new Date(J.getUTCFullYear(),J.getUTCMonth(),J.getUTCDate(),J.getUTCHours(),J.getUTCMinutes(),J.getUTCSeconds(),J.getUTCMilliseconds());}}};
D.prototype.formatRelative=function(j,u,R){var t=new Date(),o,s=this.oFormatOptions.relativeScale||"day",i,P,n;n=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(n,this.aRelativeScales);}if(!R){R=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){t=new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate()));o=new Date(0);if(u){o.setUTCFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{o.setUTCFullYear(j.getFullYear(),j.getMonth(),j.getDate());}j=o;}i=this._getDifference(s,[t,j]);if(this.oFormatOptions.relativeScale!="auto"&&(i<R[0]||i>R[1])){return null;}P=this.oLocaleData.getRelativePattern(s,i,n>0,this.oFormatOptions.relativeStyle);return f(P,[Math.abs(i)]);};
D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};
D.prototype._getScale=function(j,s){var S,t;j=Math.abs(j);for(var i=0;i<s.length;i++){t=s[i];if(j>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};
function l(o,s){var j=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],M;var n=new Date(o.getTime());for(var i=s;i<j.length;i++){M="set"+j[s];n[M].apply(n,[0]);}return n;}
var r={year:function(o,t){return t.getFullYear()-o.getFullYear();},month:function(o,t){return t.getMonth()-o.getMonth()+(this.year(o,t)*12);},week:function(o,t,i){var j=i._adaptDayOfWeek(o.getDay());var T=i._adaptDayOfWeek(t.getDay());o=l(o,3);t=l(t,3);return(t.getTime()-o.getTime()-(T-j)*i._mScales.day*1000)/(i._mScales.week*1000);},day:function(o,t,i){o=l(o,3);t=l(t,3);return(t.getTime()-o.getTime())/(i._mScales.day*1000);},hour:function(o,t,i){o=l(o,4);t=l(t,4);return(t.getTime()-o.getTime())/(i._mScales.hour*1000);},minute:function(o,t,i){o=l(o,5);t=l(t,5);return(t.getTime()-o.getTime())/(i._mScales.minute*1000);},second:function(o,t,i){o=l(o,6);t=l(t,6);return(t.getTime()-o.getTime())/(i._mScales.second*1000);}};
D.prototype._adaptDayOfWeek=function(i){var j=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getFirstDayOfWeek();var n=i-(j-1);if(n<=0){n+=7;}return n;};
D.prototype._getDifference=function(s,i){var o=i[0];var t=i[1];return Math.round(r[s](o,t,this));};
D.prototype.getAllowedCharacters=function(j){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var o=false;var P;for(var i=0;i<j.length;i++){P=j[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{o=true;}break;default:o=true;break;}}if(o){A="";}return A;};
return D;},true);
sap.ui.predefine('sap/ui/core/format/FileSizeFormat',['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/format/NumberFormat'],function(B,L,a,N){"use strict";var _=[{binaryFactor:1,decimalFactor:1,decimalUnit:"Byte",binaryUnit:"Byte"},{binaryFactor:1,decimalFactor:1,decimalUnit:"Bytes",binaryUnit:"Bytes"},{binaryFactor:Math.pow(2,10),decimalFactor:1e3,decimalUnit:"Kilobyte",binaryUnit:"Kibibyte"},{binaryFactor:Math.pow(2,20),decimalFactor:1e6,decimalUnit:"Megabyte",binaryUnit:"Mebibyte"},{binaryFactor:Math.pow(2,30),decimalFactor:1e9,decimalUnit:"Gigabyte",binaryUnit:"Gibibyte"},{binaryFactor:Math.pow(2,40),decimalFactor:1e12,decimalUnit:"Terabyte",binaryUnit:"Tebibyte"},{binaryFactor:Math.pow(2,50),decimalFactor:1e15,decimalUnit:"Petabyte",binaryUnit:"Pebibyte"},{binaryFactor:Math.pow(2,60),decimalFactor:1e18,decimalUnit:"Exabyte",binaryUnit:"Exbibyte"},{binaryFactor:Math.pow(2,70),decimalFactor:1e21,decimalUnit:"Zettabyte",binaryUnit:"Zebibyte"},{binaryFactor:Math.pow(2,80),decimalFactor:1e24,decimalUnit:"Yottabyte",binaryUnit:"Yobibyte"}];
var F=B.extend("sap.ui.core.format.FileSizeFormat",{constructor:function(f){throw new Error();}});
F.getInstance=function(f,l){return this.createInstance(f,l);};
F.createInstance=function(f,l){var o=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oNumberFormat=N.getFloatInstance(f,l);o.oBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",l.toString());o.bBinary=f?!!f.binaryFilesize:false;return o;};
F.prototype.format=function(v){var V=null,o;if(typeof v=="string"){try{if(/^\s*[\+-]?0[xX]/.test(v)){V=parseInt(v,16);}else{V=parseFloat(v,10);}}catch(e){}}else if(typeof v=="number"){V=v;}if(V===null){return"NaN";}o=V;var u=c(V,this.bBinary),s=this.oNumberFormat.format(V/u.factor);if(!u.noSecondRounding){V=this.oNumberFormat.parse(s);if((this.bBinary&&Math.abs(V)>=1024)||(!this.bBinary&&Math.abs(V)>=1000)){u=c(V*u.factor,this.bBinary);s=this.oNumberFormat.format(o/u.factor);}}return this.oBundle.getText("FileSize."+u.unit,s);};
F.prototype.parse=function(v){var u,b,V,e;if(!v){return NaN;}for(var i=0;i<_.length;i++){u=_[i];b=d(this.oBundle,u.decimalUnit,v);if(b){e=false;break;}else{b=d(this.oBundle,u.binaryUnit,v);if(b){e=true;break;}}}if(!b){b=v;e=false;u=_[0];}V=this.oNumberFormat.parse(b);return V*(e?u.binaryFactor:u.decimalFactor);};
function c(f,e){var b=Math.abs(f),u,g;for(var i=_.length-1;i>=2;i--){u=_[i];g=e?u.binaryFactor:u.decimalFactor;if(b>=g){return{factor:g,unit:e?u.binaryUnit:u.decimalUnit,noSecondRounding:(i==_.length-1)};}}return{factor:1,unit:_[b>=2?1:0].decimalUnit};}
function d(b,u,v){var p=b.getText("FileSize."+u),e;if(p.startsWith("{0}")){e=p.substr(3,p.length);if((typeof e=="string"&&e!=""?v.toLowerCase().endsWith(e.toLowerCase()):false)){return v.substr(0,v.length-e.length);}}else if(p.endsWith("{0}")){e=p.substr(0,p.length-3);if((typeof e=="string"&&e!=""?v.toLowerCase().startsWith(e.toLowerCase()):false)){return v.substr(e.length,v.length);}}else{e=p.split("{0}");if(e.length==2&&((typeof e[0]=="string"&&e[0]!=""?v.toLowerCase().startsWith(e[0].toLowerCase()):false))&&((typeof e[1]=="string"&&e[1]!=""?v.toLowerCase().endsWith(e[1].toLowerCase()):false))){return v.substr(e[0].length,v.length-e[1].length);}}return null;}
return F;});
sap.ui.predefine('sap/ui/core/format/ListFormat',['sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject"],function(L,a,b,e,c){"use strict";var d=function(){throw new Error();};d.oDefaultListFormat={type:"standard",style:"wide"};
d.getInstance=function(f,l){return this.createInstance(f,l);};
d.createInstance=function(f,l){var F=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=e({},this.oDefaultListFormat,f);return F;};
d.prototype.format=function(l){if(!Array.isArray(l)){b.error("ListFormat can only format with an array given.");return"";}var o=this.oOriginalFormatOptions,m,p,v,s,M,E,V=[].concat(l),S,f;m=this.oLocaleData.getListFormat(o.type,o.style);if(c(m)){b.error("No list pattern exists for the provided format options (type, style).");return"";}function r(V,p){var R=V[0];for(var i=1;i<V.length;i++){R=p.replace("{0}",R);R=R.replace("{1}",V[i]);}return R;}if(m[V.length]){p=m[V.length];for(var i=0;i<V.length;i++){p=p.replace('{'+i+'}',V[i]);}v=p;}else if(V.length<2){v=V.toString();}else{S=V.shift();E=V.pop();f=V;s=m.start.replace("{0}",S);E=m.end.replace("{1}",E);M=r(f,m.middle);v=s.replace("{1}",E.replace("{0}",M));}return v;};
d.prototype.parse=function(v){if(typeof v!=='string'){b.error("ListFormat can only parse a String.");return[];}var r=[],s=[],m=[],E=[],f=[],o=this.oOriginalFormatOptions,l,g=/\{[01]\}/g,h,S,i,j,k;if(!o){o=d.oDefaultListFormat;}l=this.oLocaleData.getListFormat(o.type,o.style);if(c(l)){b.error("No list pattern exists for the provided format options (type, style).");return[];}i=l.start.replace(g,"");j=l.middle.replace(g,"");k=l.end.replace(g,"");s=v.split(i);r=r.concat(s.shift());E=s.join(i).split(k);h=E.pop();m=E.join(k).split(j);r=r.concat(m);r.push(h);if(s.length<1||m.length<1||E.length<1){S=l["2"].replace(g,"");f=v.split(S);if(f.length===2){return f;}if(v){return[v];}else{return[];}}return r;};
return d;});
sap.ui.predefine('sap/ui/core/format/NumberFormat',['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/base/util/extend'],function(B,L,a,b,c,e){"use strict";
var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});
var r=/0+(\.0+)?/;var d=/^0+$/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"FLOOR",CEILING:"CEILING",TOWARDS_ZERO:"TOWARDS_ZERO",AWAY_FROM_ZERO:"AWAY_FROM_ZERO",HALF_FLOOR:"HALF_FLOOR",HALF_CEILING:"HALF_CEILING",HALF_TOWARDS_ZERO:"HALF_TOWARDS_ZERO",HALF_AWAY_FROM_ZERO:"HALF_AWAY_FROM_ZERO"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",showNumber:true,customCurrencies:undefined,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",showNumber:true,customUnits:undefined,allowedUnits:undefined,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};
N.getInstance=function(F,i){return this.getFloatInstance(F,i);};
N.getFloatInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.FLOAT);w.oFormatOptions=e({},this.oDefaultFloatFormat,x,F);return w;};
N.getIntegerInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.INTEGER);w.oFormatOptions=e({},this.oDefaultIntegerFormat,x,F);return w;};
N.getCurrencyInstance=function(F,i){var w=this.createInstance(F,i);var C=F&&F.currencyContext;var S=h(F);if(S){C=C||this.oDefaultCurrencyFormat.style;C="sap-"+C;}var x=this.getLocaleFormatOptions(w.oLocaleData,n.CURRENCY,C);w.oFormatOptions=e({},this.oDefaultCurrencyFormat,x,F);w.oFormatOptions.trailingCurrencyCode=S;w._defineCustomCurrencySymbols();return w;};
N.getUnitInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.UNIT);w.oFormatOptions=e({},this.oDefaultUnitFormat,x,F);return w;};
N.getPercentInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.PERCENT);w.oFormatOptions=e({},this.oDefaultPercentFormat,x,F);return w;};
N.createInstance=function(F,i){var w=Object.create(this.prototype),P;if(F instanceof L){i=F;F=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}w.oLocale=i;w.oLocaleData=a.getInstance(i);w.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);Object.keys(P).forEach(function(x){F[x]=P[x];});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return w;};
N.getDefaultUnitPattern=function(S){return"{0} "+S;};
N.getLocaleFormatOptions=function(i,T,C){var w,x;switch(T){case n.PERCENT:x=i.getPercentPattern();break;case n.CURRENCY:x=i.getCurrencyPattern(C);break;case n.UNIT:x=i.getDecimalPattern();break;default:x=i.getDecimalPattern();}w=this.parseNumberPattern(x);w.plusSign=i.getNumberSymbol("plusSign");w.minusSign=i.getNumberSymbol("minusSign");w.decimalSeparator=i.getNumberSymbol("decimal");w.groupingSeparator=i.getNumberSymbol("group");w.percentSign=i.getNumberSymbol("percentSign");w.pattern=x;switch(T){case n.UNIT:case n.FLOAT:case n.PERCENT:w.minFractionDigits=0;w.maxFractionDigits=99;break;case n.INTEGER:w.minFractionDigits=0;w.maxFractionDigits=0;w.groupingEnabled=false;break;case n.CURRENCY:w.minFractionDigits=undefined;w.maxFractionDigits=undefined;break;}return w;};
N.parseNumberPattern=function(F){var M=0,w=0,x=0,G=false,y=0,z=0,S=F.indexOf(";"),A={Integer:0,Fraction:1},C=A.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var D=F[i];switch(D){case",":if(G){y=z;z=0;}G=true;break;case".":C=A.Fraction;break;case"0":if(C===A.Integer){M++;if(G){z++;}}else{w++;x++;}break;case"#":if(C===A.Integer){if(G){z++;}}else{x++;}break;}}if(!y){y=z;z=0;}return{minIntegerDigits:M,minFractionDigits:w,maxFractionDigits:x,groupingEnabled:G,groupingSize:y,groupingBaseSize:z};};
N.prototype._defineCustomCurrencySymbols=function(){var O=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(S,i){var U=[];var w;for(var K in S){w=S[K];if(U.indexOf(w)===-1){U.push(w);}else if(w!==undefined){i[w]=true;b.error("Symbol '"+w+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(O.customCurrencies&&typeof O.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(O.customCurrencies).forEach(function(K){if(O.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=O.customCurrencies[K].symbol;}else{var i=O.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};
function s(i,w){if(i.indexOf(".")>=0&&!k(i)&&i.endsWith("0")){var F=i.length-i.lastIndexOf(".")-1;var x=F-w;if(x>0){while(i.endsWith("0")&&(x-->0)){i=i.substring(0,i.length-1);}if(i.endsWith(".")){i=i.substring(0,i.length-1);}}}return i;}
N.prototype.format=function(V,M){if(Array.isArray(V)){M=V[1];V=V[0];}var i="",F="",G="",w="",x="",P="",y=0,z=0,A=0,C=0,D=V<0,E=-1,O=Object.assign({},this.oFormatOptions),H=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",J,S,K,Q,U,T,W=V===undefined||V===null;if(O.showNumber&&(V===O.emptyString||(isNaN(V)&&isNaN(O.emptyString)))){return"";}if(M!==undefined&&M!==null&&typeof M!=="string"&&!(M instanceof String)){return"";}if(!O.showNumber&&!M){return"";}if(W&&(!M||!O.showMeasure||O.showNumber)){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(!O.showNumber&&!O.showMeasure){return"";}if(M&&O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{T=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(T);}if(O.showMeasure){var X=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!X){return"";}}if(!U&&!O.showNumber){return this._addOriginInfo(M);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(M&&O.trailingCurrencyCode){if(!this.mKnownCurrencyCodes[M]&&!/(^[A-Z]{3}$)/.test(M)){O.trailingCurrencyCode=false;O.pattern=this.oLocaleData.getCurrencyPattern(O.currencyContext);}}if(!O.showNumber){if(!O.currencyCode){var Y;if(O.customCurrencies&&typeof O.customCurrencies==="object"){Y=this.mKnownCurrencySymbols[M];}else{Y=this.oLocaleData.getCurrencySymbol(M);}if(Y&&Y!==M){M=Y;}}return M;}if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(V)>=O.shortLimit){K=O.shortRefNumber===undefined?V:O.shortRefNumber;S=g(K,O,this.oLocaleData,I);if(S&&S.formatString!="0"){V=V/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(H.minFractionDigits===undefined&&H.maxFractionDigits===undefined&&H.decimals===undefined&&H.precision===undefined&&H.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(H.maxFractionDigits===undefined&&H.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,p(V,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){V=N._shiftDecimalPoint(V,2);}if(O.type==n.CURRENCY){var Z=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){Z=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=Z;}if(O.minFractionDigits===undefined){O.minFractionDigits=Z;}}if(typeof V==="number"&&!O.preserveDecimals){V=o(V,O.maxFractionDigits,O.roundingMode);}if(V==0){D=false;}if(O.preserveDecimals&&(typeof V==="string"||V instanceof String)){V=s(V,O.maxFractionDigits);}if(!W){x=this.convertToDecimal(V);}if(x=="NaN"){return x;}if(D){x=x.substr(1);}E=x.indexOf(".");if(E>-1){i=x.substr(0,E);F=x.substr(E+1);}else{i=x;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits&&!O.preserveDecimals){F=F.substr(0,O.maxFractionDigits);}if(O.type===n.UNIT&&!O.showNumber){if(U){Q=this.oLocaleData.getPluralCategory(i+"."+F);P=U["unitPattern-count-"+Q];if(!P){P=U["unitPattern-count-other"];}if(!P){return this._addOriginInfo(M);}if(Q!=="other"&&P.indexOf("{0}")===-1){P=U["unitPattern-count-other"];if(!P){return this._addOriginInfo(M);}}if(P.indexOf("{0}")===-1){b.warning("Cannot separate the number from the unit because unitPattern-count-other '"+P+"' does not include the number placeholder '{0}' for unit '"+M+"'");}else{return this._addOriginInfo(P.replace("{0}","").trim());}}}z=i.length;if(O.groupingEnabled){if(I){var $=[3,2,2],_,a1=0;y=i.length;while(y>0){_=$[a1%3];y-=_;if(a1>0){G=O.groupingSeparator+G;}if(y<0){_+=y;y=0;}G=i.substr(y,_)+G;a1++;}}else{A=O.groupingSize;C=O.groupingBaseSize||A;y=Math.max(z-C,0)%A||A;G=i.substr(0,y);while(z-y>=C){G+=O.groupingSeparator;G+=i.substr(y,A);y+=A;}G+=i.substr(y);}}else{G=i;}if(D){w=O.minusSign;}w+=G;if(F){w+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){Q=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,Q);w=S.formatString.replace(S.valueSubString,w);w=w.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){var b1;if(O.trailingCurrencyCode){b1="sap-short";}else{b1="short";}Q=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=j(b1,S.key,Q);}else{P=this.oLocaleData.getCurrencyFormat(b1,S.key,Q);}P=P.replace(/'.'/g,".");}J=P.split(";");if(J.length===2){P=D?J[1]:J[0];if(D){w=w.substring(O.minusSign.length);}}if(!O.currencyCode){var Y;if(O.customCurrencies&&typeof O.customCurrencies==="object"){Y=this.mKnownCurrencySymbols[M];}else{Y=this.oLocaleData.getCurrencySymbol(M);}if(Y&&Y!==M){M=Y;}}w=this._composeCurrencyResult(P,w,M,{showMeasure:O.showMeasure,negative:D,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;w=P.replace(/[0#.,]+/,w);w=w.replace(/%/,O.percentSign);}if(O.showMeasure&&M&&O.type===n.UNIT){Q=this.oLocaleData.getPluralCategory(i+"."+F);if(U){P=U["unitPattern-count-"+Q];if(!P){P=U["unitPattern-count-other"];}if(!P){P=N.getDefaultUnitPattern(M);}}else{P=N.getDefaultUnitPattern(M);}w=P.replace("{0}",w);}return this._addOriginInfo(w);};
N.prototype._addOriginInfo=function(i){if(sap.ui.getCore().getConfiguration().getOriginInfo()){i=new String(i);i.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return i;};
N.prototype._composeCurrencyResult=function(P,F,M,O){var i=O.minusSign;P=P.replace(/[0#.,]+/,F);if(O.showMeasure&&M){var w="\u00a4",x={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},y=P.indexOf(w),z=y<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(z),C=(z==="after"?M.charAt(M.length-1):M.charAt(0)),A,D=x[S.currencyMatch],E=x[S.surroundingMatch],I;P=P.replace(w,M);A=(z==="after"?P.charAt(y+M.length):P.charAt(y-1));if(D&&D.test(C)&&E&&E.test(A)){if(z==="after"){I=y+M.length;}else{I=y;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(O.negative&&z==="after"){i="\ufeff"+O.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(O.negative){P=P.replace(/-/,i);}return P;};
N.prototype.parse=function(V){var O=this.oFormatOptions,P=O.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=O.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),w=q(P+M),G=q(O.groupingSeparator),D=q(O.decimalSeparator),x="^\\s*(["+w+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",y="^\\s*(["+w+"]?[0-9"+G+"]+)\\s*$",z=new RegExp(G,"g"),A=new RegExp(D,"g"),C=this.oLocaleData.getNumberSymbol("percentSign"),I=O.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",E,F,H,J,K=0,S,Q;if(V===""){if(!O.showNumber){return null;}Q=O.emptyString;if(O.parseAsString&&(O.emptyString===0||isNaN(O.emptyString))){Q=O.emptyString+"";}if(O.type===n.CURRENCY||O.type===n.UNIT){return[Q,undefined];}else{return Q;}}if(typeof V!=="string"&&!(V instanceof String)){return null;}if(O.groupingSeparator===O.decimalSeparator){b.error("The grouping and decimal separator both have the same value '"+O.groupingSeparator+"'. "+"They must be different from each other such that values can be parsed correctly.");}J=O.type===n.PERCENT?O.pattern:this.oLocaleData.getPercentPattern();if(J.charAt(0)==="%"){x=x.slice(0,1)+"%?"+x.slice(1);}else if(J.charAt(J.length-1)==="%"){x=x.slice(0,x.length-1)+"%?"+x.slice(x.length-1);}var U;if(O.type===n.UNIT&&O.showMeasure){var T;if(O.customUnits&&typeof O.customUnits==="object"){T=O.customUnits;}else{T=this.oLocaleData.getUnitFormats();}c(T,"Unit patterns cannot be loaded");if(O.allowedUnits){var W={};for(var i=0;i<O.allowedUnits.length;i++){var X=O.allowedUnits[i];W[X]=T[X];}T=W;}var Y=t(T,V,O.showNumber);var Z=false;U=Y.cldrCode;if(U.length===1){H=U[0];if(!O.showNumber){return[undefined,H];}}else if(U.length===0){if(O.unitOptional){Y.numberValue=V;}else{return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(V)+"'");H=undefined;Z=true;}if(O.strictParsing){if(Z){return null;}}V=Y.numberValue||V;}var $;if(O.type===n.CURRENCY&&O.showMeasure){$=v({value:V,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!O.customCurrencies});if(!$){return null;}if(O.strictParsing){if(!$.currencyCode||$.duplicatedSymbolFound){return null;}}V=$.numberValue;H=$.currencyCode;if(O.customCurrencies&&H===null){return null;}if(!O.showNumber){if(V){return null;}return[undefined,H];}}V=V.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");V=V.replace(/\s/g,"");S=f(V,this.oLocaleData,I);if(S){V=S.number;}var _=k(V);if(O.isInteger&&!S&&!_){E=new RegExp(y);}else{E=new RegExp(x);}if(!E.test(V)){return O.type===n.CURRENCY||O.type===n.UNIT?null:NaN;}V=V.replace(z,"");var a1=V.length;for(var b1=0;b1<a1;b1++){var c1=V[b1];if(P.includes(c1)){V=V.replace(c1,"+");break;}else if(M.includes(c1)){V=V.replace(c1,"-");break;}}V=V.replace(/^\+/,"");if(S){V=V.replace(A,".");V=N._shiftDecimalPoint(V,Math.round(Math.log(S.factor)/Math.LN10));}if(O.isInteger){var d1;if(_){V=V.replace(A,".");d1=l(V);if(d1===undefined){return NaN;}}else{d1=parseInt(V);}K=O.parseAsString?V:d1;}else{V=V.replace(A,".");if(V.indexOf(C)!==-1){F=true;V=V.replace(C,"");}K=O.parseAsString?V:parseFloat(V);if(F){K=N._shiftDecimalPoint(K,-2);}}if(O.parseAsString){K=N._shiftDecimalPoint(V,0);}if(O.type===n.CURRENCY||O.type===n.UNIT){return[K,H];}return K;};
N.prototype.convertToDecimal=function(V){var w=""+V,x,y,D,F,E,P;if(w.indexOf("e")==-1&&w.indexOf("E")==-1){return w;}var z=w.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);x=z[1]=="-";y=z[2].replace(/\./g,"");D=z[3]?z[3].length:0;F=z[4]?z[4].length:0;E=parseInt(z[5]);if(E>0){if(E<F){P=D+E;w=y.substr(0,P)+"."+y.substr(P);}else{w=y;E-=F;for(var i=0;i<E;i++){w+="0";}}}else{if(-E<D){P=D+E;w=y.substr(0,P)+"."+y.substr(P);}else{w=y;E+=D;for(var i=0;i>E;i--){w="0"+w;}w="0."+w;}}if(x){w="-"+w;}return w;};
N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var S=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),i;if(S&&S.formatString){i=S.formatString.replace(r,"").replace(/'.'/g,".").trim();if(i){return i;}}};
N._shiftDecimalPoint=function(V,S){if(typeof S!=="number"){return NaN;}var M="";var E=V.toString().toLowerCase().split("e");if(typeof V==="number"){S=E[1]?(+E[1]+S):S;return+(E[0]+"e"+S);}else if(typeof V==="string"){if(parseFloat(V)===0&&S>=0){return d.test(V)?"0":V;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}V=E[0];var D=V.indexOf("."),A,i,w;if(D===-1){V=V+".";D=V.length-1;}if(E[1]){D+=(+E[1]);}A=D+S;if(A<=0){V=V.padStart(V.length-A+1,'0');A=1;}else if(A>=V.length-1){V=V.padEnd(A+1,'0');A=V.length-1;}V=V.replace(".","");i=V.substring(0,A);w=V.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(w?("."+w):"");}else{return null;}};
function g(V,O,w,I){var S,K,x,C,y=O.style,P=O.precision!==undefined?O.precision:2;if(y!="short"&&y!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(o(Math.abs(V)/K,P-1)<10){break;}}x=K.toString();if(O.type===n.CURRENCY){if(O.trailingCurrencyCode){y="sap-short";}if(I){C=j(y,x,"other",true);}else{C=w.getCurrencyFormat(y,x,"other");}}else{C=w.getDecimalFormat(y,x,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=x;S.formatString=C;var z=C.match(r);if(z){S.valueSubString=z[0];var A=S.valueSubString.indexOf(".");if(A==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-A-1;S.magnitude=K*Math.pow(10,1-A);}}else{return undefined;}}return S;}
function f(V,w,I){var x,F=1,K=10,P=w.getPluralCategories(),C,y={number:undefined,factor:F},G=function(A,K,S,D){if(D){C=j(S,K.toString(),A,true);}else{C=w.getDecimalFormat(S,K.toString(),A);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var E=C.match(r);if(E){var H=E[0];var U=C.replace(H,"");if(!U){return;}var J=V.indexOf(U);if(J>=0){x=V.replace(U,"");x=x.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-H.length);if(y.number===undefined||x.length<y.number.length){y.number=x;y.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,S);}K=K*10;}});if(I&&!x){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,"short",true);}K=K*10;}}if(!x){return;}return y;}
function h(F){var S=sap.ui.getCore().getConfiguration().getFormatSettings().getTrailingCurrencyCode();if(F){if(F.trailingCurrencyCode!==undefined){S=F.trailingCurrencyCode;}if(F.pattern){S=false;}if(F.currencyCode===false){S=false;}}return S;}
function j(S,K,P,D){var F,C={"short":{"1000-one":"\xa40000","1000-other":"\xa40000","10000-one":"\xa400000","10000-other":"\xa400000","100000-one":"\xa40 Lk","100000-other":"\xa40 Lk","1000000-one":"\xa400 Lk","1000000-other":"\xa400 Lk","10000000-one":"\xa40 Cr","10000000-other":"\xa40 Cr","100000000-one":"\xa400 Cr","100000000-other":"\xa400 Cr","1000000000-one":"\xa4000 Cr","1000000000-other":"\xa4000 Cr","10000000000-one":"\xa40000 Cr","10000000000-other":"\xa40000 Cr","100000000000-one":"\xa400000 Cr","100000000000-other":"\xa400000 Cr","1000000000000-one":"\xa40 Lk Cr","1000000000000-other":"\xa40 Lk Cr","10000000000000-one":"\xa400 Lk Cr","10000000000000-other":"\xa400 Lk Cr","100000000000000-one":"\xa40 Cr Cr","100000000000000-other":"\xa40 Cr Cr"},"sap-short":{"1000-one":"0000\xa0\xa4","1000-other":"0000\xa0\xa4","10000-one":"00000\xa0\xa4","10000-other":"00000\xa0\xa4","100000-one":"0 Lk\xa0\xa4","100000-other":"0 Lk\xa0\xa4","1000000-one":"00 Lk\xa0\xa4","1000000-other":"00 Lk\xa0\xa4","10000000-one":"0 Cr\xa0\xa4","10000000-other":"0 Cr\xa0\xa4","100000000-one":"00 Cr\xa0\xa4","100000000-other":"00 Cr\xa0\xa4","1000000000-one":"000 Cr\xa0\xa4","1000000000-other":"000 Cr\xa0\xa4","10000000000-one":"0000 Cr\xa0\xa4","10000000000-other":"0000 Cr\xa0\xa4","100000000000-one":"00000 Cr\xa0\xa4","100000000000-other":"00000 Cr\xa0\xa4","1000000000000-one":"0 Lk Cr\xa0\xa4","1000000000000-other":"0 Lk Cr\xa0\xa4","10000000000000-one":"00 Lk Cr\xa0\xa4","10000000000000-other":"00 Lk Cr\xa0\xa4","100000000000000-one":"0 Cr Cr\xa0\xa4","100000000000000-other":"0 Cr Cr\xa0\xa4"}},i={"short":{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};i["sap-short"]=i["short"];var T=D?i:C;var w=T[S];if(!w){w=T["short"];}if(P!=="one"){P="other";}F=w[K+"-"+P];return F;}
function k(V){return V.indexOf("e")>0||V.indexOf("E")>0;}
function l(V){var i=N._shiftDecimalPoint(V,0);if(i.indexOf(".")>0&&!d.test(i.split(".")[1])){return undefined;}var F=parseFloat(i);var w=""+F;if(k(w)){w=N._shiftDecimalPoint(w,0);}var I=parseInt(w);if(I!==F){return undefined;}return I;}
function o(V,M,i){if(typeof V!=="number"){return NaN;}i=i||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);var w=""+V;if(!k(w)){var I=w.indexOf(".");if(I<0){return V;}if(w.substring(I+1).length<=M){return V;}}if(typeof i==="function"){V=i(V,M);}else{if(i.match(/^[a-z_]+$/)){i=i.toUpperCase();}if(!M){return m[i](V);}V=N._shiftDecimalPoint(m[i](N._shiftDecimalPoint(V,M)),-M);}return V;}
function q(i){return i.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}
function p(V,P){var i=Math.floor(Math.log(Math.abs(V))/Math.LN10);return Math.max(0,P-i-1);}
function t(U,V,S){var i={numberValue:undefined,cldrCode:[]};var w=Number.POSITIVE_INFINITY;var x,K;for(x in U){for(K in U[x]){if(K.indexOf("unitPattern")===0){var y=U[x][K];var z=y.indexOf("{0}");var C=z>-1;if(C&&!S){y=y.replace("{0}","").trim();C=false;}if(C){var P=y.substring(0,z);var A=y.substring(z+"{0}".length);var M=V.startsWith(P)&&V.endsWith(A);var D=M&&V.substring(P.length,V.length-A.length);if(D){if(D.length<w){w=D.length;i.numberValue=D;i.cldrCode=[x];}else if(D.length===w&&i.cldrCode.indexOf(x)===-1){i.cldrCode.push(x);}}}else if(y===V){if(S){i.cldrCode=[x];var E;if(K.endsWith("-zero")){E="0";}else if(K.endsWith("-one")){E="1";}else if(K.endsWith("-two")){E="2";}i.numberValue=E;return i;}else if(i.cldrCode.indexOf(x)===-1){i.cldrCode.push(x);}}}}}return i;}
function u(V,C){var S="",i,w;for(var x in C){w=C[x];if(V.indexOf(w)>=0&&S.length<w.length){S=w;i=x;}}return{symbol:S,code:i};}
function v(C){var V=C.value;var M=u(V,C.currencySymbols);if(!M.code){M=u(V,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=V.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var w=M.code.length-1;var x=M.code.charAt(w);var D;var y=/[\-\s]+/;if(/\d$/.test(x)){if(V.startsWith(M.code)){D=w+1;if(!y.test(V.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(V.endsWith(M.code)){D=V.indexOf(M.code)-1;if(!y.test(V.charAt(D))){return undefined;}}}V=V.replace(M.symbol||M.code,"");}var z=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;z=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:V,currencyCode:M.code||undefined,duplicatedSymbolFound:z};}
return N;});
sap.ui.predefine('sap/ui/core/hyphenation/HyphenationTestingWords',[],function(){"use strict";var t={"bg":"непротивоконституционствувателствувайте","ca":"psiconeuroimmunoendocrinologia","hr":"prijestolonasljednikovičičinima","cs":"nejnezdevětadevadesáteronásobitelnějšími","da":"gedebukkebensoverogundergeneralkrigskommandersergenten","nl":"meervoudigepersoonlijkheidsstoornissen","en-us":"pneumonoultramicroscopicsilicovolcanoconiosis","et":"sünnipäevanädalalõpupeopärastlõunaväsimus","fi":"kolmivaihekilowattituntimittari","fr":"hippopotomonstrosesquippedaliophobie","de":"Kindercarnavalsoptochtvoorbereidingswerkzaamhedenplan","el-monoton":"ηλεκτροεγκεφαλογράφημα","hi":"किंकर्तव्यविमूढ़","hu":"megszentségteleníthetetlenségeskedéseitekért","it":"hippopotomonstrosesquippedaliofobia","lt":"nebeprisikiškiakopūstlapiaujančiuosiuose","nb-no":"supercalifragilisticexpialidocious","pl":"dziewięćdziesięciokilkuletniemu","pt":"pneumoultramicroscopicossilicovulcanoconiose","ru":"превысокомногорассмотрительствующий","sr":"семпаравиливичинаверсаламилитипиковски","sl":"dialektičnomaterialističen","es":"electroencefalografistas","sv":"realisationsvinstbeskattning","th":"ตัวอย่างข้อความที่จะใช้ในการยืนยันการถ่ายโอน","tr":"muvaffakiyetsizleştiricileştiriveremeyebileceklerimizdenmişsinizcesine","uk":"нікотинамідаденіндинуклеотидфосфат"};return t;});
sap.ui.predefine('sap/ui/core/message/MessageMixin',["sap/ui/core/library","sap/base/Log","sap/ui/core/LabelEnablement"],function(l,L,a){"use strict";var V=l.ValueState;var M=function(){this.refreshDataState=r;this.fnDestroy=this.destroy;this.destroy=d;};
function r(n,D){if(D.getChanges().messages&&this.getBinding(n)&&this.getBinding(n).isA("sap.ui.model.PropertyBinding")){var m=D.getMessages();var b=a.getReferencingLabels(this);var s=b[0];var f=false;m.forEach(function(c){if(b&&b.length>0){var e=sap.ui.getCore().byId(s);if(e.getMetadata().isInstanceOf("sap.ui.core.Label")&&e.getText&&c.getAdditionalText()!==e.getText()){c.setAdditionalText(e.getText());f=true;}else{L.warning("sap.ui.core.message.Message: Can't create labelText."+"Label with id "+s+" is no valid sap.ui.core.Label.",this);}}if(c.getControlId()!==this.getId()){c.addControlId(this.getId());f=true;}}.bind(this));var o=sap.ui.getCore().getMessageManager().getMessageModel();o.checkUpdate(f,true);if(m&&m.length>0){var c=m[0];if(V[c.type]){this.setValueState(c.type);this.setValueStateText(c.message);}}else{this.setValueState(V.None);this.setValueStateText('');}}}
function d(){var c=this.getId();function b(o){o.removeControlId(c);}for(var n in this.mBindingInfos){var B=this.mBindingInfos[n];if(B.binding){var D=B.binding.getDataState();var m=D.getMessages();m.forEach(b);}}this.fnDestroy.apply(this,arguments);}
return M;},true);
sap.ui.predefine('sap/ui/core/message/MessageParser',["sap/ui/base/Object","sap/base/Log"],function(O,L){"use strict";
var M=O.extend("sap.ui.core.message.MessageParser",{
metadata:{publicMethods:["parse","setProcessor"]},
constructor:function(){this._processor=null;}
});
M.prototype.setProcessor=function(p){this._processor=p;return this;};
M.prototype.getProcessor=function(){return this._processor;};
M.prototype.parse=function(r,R){L.error("MessageParser: parse-method must be implemented in the specific parser class. Messages "+"have been ignored.");};
return M;});
sap.ui.predefine('sap/ui/core/mvc/Controller',['sap/base/util/ObjectPath','sap/base/util/extend','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/ControllerExtension','sap/ui/core/mvc/ControllerExtensionProvider','sap/ui/core/mvc/OverrideExecution',"sap/base/Log"],function(O,e,E,M,C,a,b,c,L){"use strict";var r={};
var d=E.extend("sap.ui.core.mvc.Controller",{
metadata:{stereotype:"controller",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true},"onInit":{"public":false,"final":false,"overrideExecution":c.After},"onExit":{"public":false,"final":false,"overrideExecution":c.Before},"onBeforeRendering":{"public":false,"final":false,"overrideExecution":c.Before},"onAfterRendering":{"public":false,"final":false,"overrideExecution":c.After}}},
constructor:function(n){var t=null;if(typeof(n)=="string"){if(!r[n]){L.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!");}t=r[n];}E.apply(this,arguments);if(t){e(this,r[n]);}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller");}this["_sapui_Extensions"]={};d.extendByMember(this,false);this._sapui_isExtended=false;this._aDestroyables=[];},
_isExtended:function(){return this._sapui_isExtended;},
getInterface:function(){var i={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var F=this[s];if(typeof F==='function'){i[s]=function(){var t=F.apply(this,arguments);return(t instanceof d)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=function(){return i;};return i;}
},C);
function f(o,i,l){var n=i.getMetadata().getName();var k=o.getMetadata();var p=o["_sapui_Extensions"];var I=o.getInterface();var q=a.getMetadata().getLifecycleConfiguration();var s={namespace:n,extension:i,reloadNeeded:false};i._setController(I);if(i.getMetadata().hasOverrides()){var t,u,v,w,x=i.getMetadata().getOverrides(),S=i.getMetadata().getStaticOverrides();for(w in S){v=i.getMetadata();if(!v.isMethodFinal(w)){a.overrideMethod(w,i,S,i,v.getOverrideExecution(w));}else{L.error("Method '"+w+"' of extension '"+n+"' is flagged final and cannot be overridden by calling 'override'");}}for(w in x){if(w!=='extension'){if(w in i.base){L.debug("Overriding  member '"+w+"' of original controller.");var y=x[w];var z=o[w];if(typeof z=="object"&&typeof y=="object"){u=p[w];v=u.extension.getMetadata();for(t in y){if(!v.isMethodFinal(t)){a.overrideMethod(t,z,y,i,v.getOverrideExecution(t));}else{L.error("Method '"+t+"' of extension '"+u.namespace+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}else if(!k.isMethodFinal(w)){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{L.error("Method '"+w+"' of controller '"+o.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+n+"'");}}else if(w in q){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{L.error("Method '"+w+"' does not exist in controller "+o.getMetadata().getName()+" and cannot be overridden");}}s.reloadNeeded=true;}if(x&&x.extension){for(var A in x.extension){v=p[A].extension.getMetadata();var B=O.create(A,o.extension);var D=p[A].extension;var F=x.extension[A];for(t in F){if(!v.isMethodFinal(t)){a.overrideMethod(t,B,F,i,v.getOverrideExecution(t));a.overrideMethod(t,D,F,i,v.getOverrideExecution(t));}else{L.error("Method '"+t+"' of extension '"+A+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}}}var G=i.getInterface();if(l){p[l]=s;s.location=l;o[l]=G;I[l]=G;}else{p[n]=s;s.location="extension."+n;O.set("extension."+n,G,o);O.set("extension."+n,G,I);}}
function m(o,i,l){if(i instanceof a){f(o,i,l);}else if(i.getMetadata&&i.getMetadata().getStereotype()=="controllerextension"){var k=new i();f(o,k,l);}else{var n=a.getMetadata().getLifecycleConfiguration();for(var s in i){if(s in n){a.overrideMethod(s,o,i,o,n[s].overrideExecution);}else{a.overrideMethod(s,o,i);}}}}
function g(n,A){if(!n){throw new Error("Controller name ('sName' parameter) is required");}var s=n.replace(/\./g,"/")+".controller",i=k(sap.ui.require(s));function k(i){if(i){return i;}else if(r[n]){return d;}else{return O.get(n);}}if(A){return new Promise(function(l,o){if(!i){sap.ui.require([s],function(i){l(k(i));},o);}else{l(i);}});}else if(!i){i=sap.ui.requireSync(s);return k(i);}else{return i;}}
function h(i,n){var o;if(r[n]){o=new i(n);}else{o=new i();}if(!o){throw new Error("Controller "+n+" couldn't be instantiated");}return o;}
d.extendByMember=function(o,A){var s;for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){o[s]=new o[s]();}}for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){m(o,o[s],s);}}if(A){return Promise.resolve(o);}else{return o;}};
d.applyExtensions=function(o,n,s,v,A){function G(A,t){if(A){return g(t,true).then(function(u){u=r[t]||u;if(u!==undefined){if(u.getMetadata&&u.getMetadata().isA("sap.ui.core.mvc.Controller")){L.warning("Attempt to load Extension Controller "+t+" was not successful","Controller extension should be a plain object.",null,function(){return{type:"ControllerExtension",name:t};});}return u;}},function(u){L.error("Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?");});}else{if(!r[t]&&!sap.ui.require(t)){g(t);}if(r[t]!==undefined){return r[t];}else{L.error("Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?",null,function(){return{type:"ControllerExtension",name:t};});return{};}}}if(A){return b.getControllerExtensions(n,s,v,A).then(function(k){var t=k.customizingControllerNames.map(function(u){return G(true,u);});return Promise.all(t).then(function(p){var q=p.concat(k.providerControllers);for(var i=0,l=q.length;i<l;i++){m(o,q[i]);}return o;});},function(t){L.error("Controller Extension Provider: Error '"+t+"' thrown in "+d._sExtensionProvider+"; extension provider ignored.");return o;});}else{var k=b.getControllerExtensions(n,s,v,A);var p=k.customizingControllerNames.map(G.bind(null,false));var q=p.concat(k.providerControllers);for(var i=0,l=q.length;i<l;i++){m(o,q[i]);}}return o;};
d.create=function(o){return j(o.name,undefined,true,o._viewId);};
sap.ui.controller=function(n,o,A,v){if(A){L.info("Do not use deprecated factory function 'sap.ui.controller("+n+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:n};});}else{L.warning("Do not use synchronous controller creation for controller '"+n+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:n};});}return j.apply(this,arguments);};
function j(n,o,A,v){var i,k,s=M._sOwnerId;if(typeof o==="boolean"){o=undefined;}if(!o){if(A){return g(n,A).then(function(k){return h(k,n);}).then(function(i){return d.applyExtensions(i,n,s,v,A);}).then(function(i){i._sapui_isExtended=true;return i;});}else{k=g(n,A);i=h(k,n);i=d.applyExtensions(i,n,s,v,A);i._sapui_isExtended=true;}return i;}else{r[n]=o;L.info("For defining controllers use Controller.extend instead");}}
d.prototype.getPublicMethods=function(){var p={},o=this.getMetadata(),i=o.getAllMethods(),l=o.getLifecycleConfiguration();Object.keys(i).forEach(function(s){if(o.isMethodPublic(s)){p[s]=i[s];p[s].reloadNeeded=!!(s in l);}});delete p.extension;var k=this["_sapui_Extensions"];Object.keys(k).forEach(function(n){var q=k[n];var s=q.extension.getInterface();var A=q.extension.getMetadata().getAllMethods();Object.keys(s).forEach(function(t){delete p[q.location];var u=e({},A[t],{reloadNeeded:q.reloadNeeded});p[q.location+"."+t]=u;});});return p;};
d.prototype._getDestroyables=function(){if(!this._aDestroyables){L.error("Mandatory super constructor not called for Controller: '"+this.getMetadata().getName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"};});this._aDestroyables=[];}return this._aDestroyables;};
d.prototype.destroyFragments=function(){function D(v){v=Array.isArray(v)?v:[v];for(var i=0;i<v.length;i++){if(!v[i].isDestroyed()){v[i].destroy();}}}var k=this._getDestroyables();for(var i=0;i<k.length;i++){k[i]=k[i].then(D);}};
d.prototype.destroy=function(){if(this["_sapui_Extensions"]){Object.keys(this["_sapui_Extensions"]).forEach(function(k){var o=this["_sapui_Extensions"][k];O.set(o.location,null,this);}.bind(this));delete this["_sapui_Extensions"];}E.prototype.destroy.apply(this,arguments);};
d.prototype.getView=function(){return this.oView;};
d.prototype.byId=function(i){return this.oView?this.oView.byId(i):undefined;};
d.prototype.createId=function(i){return this.oView?this.oView.createId(i):undefined;};
d.prototype.getOwnerComponent=function(){var i=sap.ui.require("sap/ui/core/Component");if(i){return i.getOwnerComponentFor(this.getView());}else{return undefined;}};
d.prototype.connectToView=function(v){this.oView=v;if(this.onInit){v.attachAfterInit(this.onInit,this);}if(this.onExit){v.attachBeforeExit(this.onExit,this);if(v.bControllerIsViewManaged){v.attachBeforeExit(this.destroyFragments,this);}}if(this.onAfterRendering){v.attachAfterRendering(this.onAfterRendering,this);}if(this.onBeforeRendering){v.attachBeforeRendering(this.onBeforeRendering,this);}};
d.prototype.loadFragment=function(o){if(!this.getView()){throw new Error("Calling 'loadFragment' without a view attached is not supported!");}else if(!o||!o.name){throw new Error("oOptions must provide at least a fragment name!");}var i=this.getOwnerComponent();var A=o.addToDependents!==false;var k=o.autoPrefixId!==false;var F={name:o.name,type:o.type,id:o.id,controller:this};var D=this._getDestroyables();var p=new Promise(function(l,n){sap.ui.require(["sap/ui/core/Fragment"],function(q){l(q);},n);}).then(function(l){if(!o.id&&k){F.id=this.getView().getId();}else if(k){F.id=this.createId(o.id);}if(i){return i.runAsOwner(function(){return l.load(F);});}else{return l.load(F);}}.bind(this)).then(function(v){if(A){this.getView().applySettings({"dependents":v});}D.splice(D.indexOf(p),1);return v;}.bind(this));D.push(p);return p;};
d._sExtensionProvider=null;
d.registerExtensionProvider=function(s){d._sExtensionProvider=s;b.registerExtensionProvider(s);};
return d;});
sap.ui.predefine('sap/ui/core/mvc/ControllerExtension',['sap/ui/base/Object','sap/ui/base/Metadata','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/OverrideExecution','sap/base/util/uid',"sap/base/Log"],function(B,M,C,O,u,L){"use strict";
var a=B.extend("sap.ui.core.mvc.ControllerExtension",{
metadata:{stereotype:"controllerextension",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true}}},
_setController:function(c){this.base=c;},
byId:function(i){var n=this.getMetadata().getNamespace();i=n+"."+i;return this.base?this.base.byId(i):undefined;},
getView:function(){return this.base.getView();},
getInterface:function(){var m={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var f=this[s];if(typeof f==='function'){m[s]=function(){var t=f.apply(this,arguments);return(t instanceof a)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=function(){return m;};return m;}
},C);
a.override=function(e){var c=M.createClass(this,"anonymousExtension~"+u(),{},C);c.getMetadata()._staticOverride=e;c.getMetadata()._override=this.getMetadata()._override;return c;};
a.overrideMethod=function(m,o,c,b,s){var f=o[m];var d=c[m];s=s||O.Instead;function w(e){(function(d,f,b,e){o[m]=function(){if(e){d.apply(b,arguments);return f.apply(o,arguments);}else{f.apply(o,arguments);return d.apply(b,arguments);}};})(d,f,b,e);}if(typeof d==='function'&&b){d=d.bind(b);}switch(s){case O.Before:if(f&&typeof f==="function"){w(true);}else if(typeof d==="function"){o[m]=d;}else{L.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.After:if(f&&typeof f==="function"){w(false);}else if(typeof d==="function"){o[m]=d;}else{L.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.Instead:default:if(m in o){L.debug("Overriding  member '"+m+"' of extension "+this.getMetadata().getName());if(!this.getMetadata().isMethodFinal(m)){o[m]=d;}else{L.error("Error in ControllerExtension.override: Method '"+m+"' of extension '"+this.getMetadata().getName()+"' is flagged final and cannot be overridden!");}}else{o[m]=d;}break;}};
return a;});
sap.ui.predefine('sap/ui/core/mvc/ControllerExtensionProvider',["sap/base/Log","sap/ui/core/Component"],function(L,C){"use strict";var e={};var a={};a._sExtensionProvider=null;
a.registerExtensionProvider=function(E){a._sExtensionProvider=E;};
a.getControllerExtensions=function(c,s,v,A){var m={customizingControllerNames:[],providerControllers:[]};var o=C.get(s);if(o&&o.getLocalId){v=o.getLocalId(v)||v;}var M=r(c,o,v);m.customizingControllerNames=M;if(A){if(a._sExtensionProvider){return l(A).then(function(E){return E.getControllerExtensions(c,s,A,v);}).then(function(b){m.providerControllers=b||[];return m;});}else{return Promise.resolve(m);}}else{if(a._sExtensionProvider){var E=l();if(E){var b=E.getControllerExtensions(c,s,A,v);if(b&&Array.isArray(b)){m.providerControllers=b;}else{L.error("Controller Extension Provider: Error in ExtensionProvider.getControllerExtensions: "+a._sExtensionProvider+" - no valid extensions returned. Return value must be an array of ControllerExtensions.");}}}return m;}};
function r(c,o,v){var b=[];var I=C.getCustomizing(o,{type:"sap.ui.controllerExtensions",name:c+"#"+v});var d=[];if(I){d.push(I);}else{var D=C.getCustomizing(o,{type:"sap.ui.controllerExtensions",name:c});if(D){d.push(D);}}for(var i=0;i<d.length;i++){var f=d[i];if(f){var E=typeof f==="string"?f:f.controllerName;b=b.concat(f.controllerNames||[]);if(E){b.unshift(E);}}}return b;}
function l(A){var p=a._sExtensionProvider.replace(/\./g,"/"),P=e[p];if(P){return A?Promise.resolve(P):P;}if(p){if(A){return new Promise(function(b,c){sap.ui.require([p],function(d){P=new d();e[p]=P;b(P);},c);});}else{var E=sap.ui.requireSync(p);P=new E();e[p]=P;return P;}}else{return A?Promise.resolve():undefined;}}
return a;});
sap.ui.predefine('sap/ui/core/mvc/ControllerMetadata',['sap/ui/base/Metadata','sap/base/util/merge','sap/ui/core/mvc/OverrideExecution',"sap/base/Log"],function(M,a,O,L){"use strict";var C=function(c,o){M.apply(this,arguments);if(this.isA("sap.ui.core.mvc.ControllerExtension")&&this.getParent().getClass().override){this.getClass().override=this.getParent().getClass().override;}};C.prototype=Object.create(M.prototype);C.prototype.constructor=C;
C.prototype.applySettings=function(c){if(c.override){this._override=c.override;delete c.override;}M.prototype.applySettings.call(this,c);var s=c.metadata;this._defaultLifecycleMethodMetadata={"onInit":{"public":true,"final":false,"overrideExecution":O.After},"onExit":{"public":true,"final":false,"overrideExecution":O.Before},"onBeforeRendering":{"public":true,"final":false,"overrideExecution":O.Before},"onAfterRendering":{"public":true,"final":false,"overrideExecution":O.After}};var i=this.isA("sap.ui.core.mvc.ControllerExtension");var r=/^_/;var e=this._oParent.isA("sap.ui.core.mvc.Controller");var d=c.metadata&&c.metadata.methods?true:false;if(!i){if(e&&!d){r=/^_|^on|^init$|^exit$/;}if(e&&d){a(s.methods,this._defaultLifecycleMethodMetadata);}}if(i||d){this._aPublicMethods=[];}this._mMethods=s.methods||{};for(var n in c){if(n!=="metadata"&&n!=="constructor"){if(!n.match(r)){if(e&&this._oParent&&this._oParent.isMethodFinal(n)){L.error("Method: '"+n+"' of controller '"+this._oParent.getName()+"' is final and cannot be overridden by controller '"+this.getName()+"'");delete this._oClass.prototype[n];}if(!(n in this._mMethods)&&typeof c[n]==='function'){if(!(c[n].getMetadata&&c[n].getMetadata().isA("sap.ui.core.mvc.ControllerExtension"))){this._mMethods[n]={"public":true,"final":false};}}}}}for(var m in this._mMethods){if(this.isMethodPublic(m)){this._aPublicMethods.push(m);}}};
C.prototype.afterApplySettings=function(){M.prototype.afterApplySettings.call(this);var i=this.isA("sap.ui.core.mvc.ControllerExtension");if(this._oParent){var p=this._oParent._mMethods?this._oParent._mMethods:{};for(var m in p){if(this._mMethods[m]&&!i){var P=this._mMethods[m].public;this._mMethods[m]=a({},p[m]);if(P!==undefined){this._mMethods[m].public=P;}if(!this.isMethodPublic(m)&&this._mMethods[m].public!==p[m].public){this._aAllPublicMethods.splice(this._aAllPublicMethods.indexOf(m),1);}}else{this._mMethods[m]=p[m];}}}if(this._oParent&&this._oParent.isA("sap.ui.core.mvc.ControllerExtension")){this._bFinal=true;}};
C.prototype.getNamespace=function(){var i=this._sClassName.indexOf("anonymousExtension~")==0;var n=i?this._oParent._sClassName:this._sClassName;return n.substr(0,n.lastIndexOf("."));};
C.prototype.isMethodFinal=function(m){var o=this._mMethods[m];return o&&o.final;};
C.prototype.isMethodPublic=function(m){var o=this._mMethods[m];return o&&o.public;};
C.prototype.getAllMethods=function(){return this._mMethods;};
C.prototype.getOverrideExecution=function(m){var o=this._mMethods[m];var s=O.Instead;if(o){s=o.overrideExecution;}return s;};
C.prototype.getOverrides=function(){return this._override;};
C.prototype.getStaticOverrides=function(){return this._staticOverride;};
C.prototype.hasOverrides=function(){return!!this._override||!!this._staticOverride;};
C.prototype.getLifecycleConfiguration=function(){return this._defaultLifecycleMethodMetadata;};
return C;});
sap.ui.predefine('sap/ui/core/mvc/EventHandlerResolver',["sap/ui/base/BindingParser","sap/ui/core/CommandExecution","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/base/util/resolveReference","sap/base/Log"],function(B,C,a,b,J,M,c,O,r,L){"use strict";var E={resolveEventHandler:function(n,o,l){var h,s,f;n=n.trim();if(sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){h=function(){};}else{if(n.startsWith("cmd:")){var d=n.substr(4);h=function(e){var j=C.find(e.getSource(),d);if(j){j.trigger();}else{L.error("Handler '"+n+"' could not be resolved. No CommandExecution defined for command: "+d);}};h._sapui_commandName=d;}else{s=n.indexOf("(");f=n;if(s>0){f=n.substring(0,s).trim();}else if(s===0){throw new Error("Event handler name starts with a bracket, must start with a function name "+"(or with a dot followed by controller-local function name): "+n);}h=r(f,Object.assign({".":o},l),{preferDotContext:f.indexOf(".")===-1,bindContext:false});}if(h&&s>0){var i=n.lastIndexOf(")");if(i>s){if(n.substring(s).indexOf("{=")>-1){L.warning("It looks like an event handler parameter contains a binding expression ({=...}). This is not allowed and will cause an error later on "+"because the entire event handler is already considered an expression: "+n);}h=(function(f,o){return function(j){var p,S,k=n;if(n.indexOf("$parameters")>-1){p=new J(j.mParameters);}if(n.indexOf("$source")>-1){S=new M(j.getSource());}var m={"$controller":o,$event:j};if(f.indexOf(".")>0){var G=f.split(".")[0];m[G]=window[G];}else if(f.indexOf(".")===-1){if(o&&o[f]){k="$controller."+k;}else if(window[f]){m[f]=window[f];}}Object.assign(m,l);var q=B.parseExpression(k.replace(/^\./,"$controller."),0,{oContext:o},m);if(q.result){try{g(q.result,j.getSource(),o,p,S);}catch(e){e.message="Error when evaluating event handler '"+n+"': "+e.message;throw e;}}if(p){p.destroy();}if(S){S.destroy();}};})(f,o);}else{L.error("Syntax error in event handler '"+n+"': arguments must be enclosed in a pair of brackets");}}}if(typeof h==="function"){h._sapui_handlerName=n;return[h,o];}L.warning("Event handler name '"+n+"' could not be resolved to an event handler function");},parse:function e(v){v=v.trim();var t=new c();var R=[];var s="";var p=0;t.init(v,0);for(;;){var S=t.next();if(S==='"'||S==="'"){var d=t.getIndex();t.string();s+=v.slice(d,t.getIndex());S=t.getCh();}if(!S){break;}switch(S){case"(":p++;break;case")":p--;break;default:break;}if(S===";"&&p===0){R.push(s.trim());s="";}else{s+=S;}}if(s){R.push(s.trim());}return R;}};
function g(o,e,d,p,s){var t,P;o.mode=a.OneWay;if(!o.parts){o.parts=[];o.parts[0]={path:o.path,targetType:o.targetType,type:o.type,suspended:o.suspended,formatOptions:o.formatOptions,constraints:o.constraints,model:o.model,mode:o.mode};delete o.path;delete o.targetType;delete o.mode;delete o.model;}for(var i=0;i<o.parts.length;i++){P=o.parts[i];if(typeof P=="string"){P={path:P};o.parts[i]=P;}if(!P.path&&P.parts){throw new Error("Bindings in event handler parameters cannot use parts. Just use one single path.");}var S=P.path.indexOf(">");if(S>0){P.model=P.path.substr(0,S);P.path=P.path.substr(S+1);}}var T,f,h,j=[];o.parts.forEach(function(P){var m;if(P.model==="$parameters"){m=p;f=p.createBindingContext("/");}else if(P.model==="$source"){m=s;f=s.createBindingContext("/");}else{m=e.getModel(P.model);f=e.getBindingContext(P.model);}t=P.type;if(typeof t=="string"){T=O.get(t);if(typeof T!=="function"){throw new Error("Cannot find type \""+t+"\" used for binding \""+P.path+"\"!");}t=new T(P.formatOptions,P.constraints);}h=m.bindProperty(P.path,f,o.parameters);h.setType(t,P.targetType||"any");h.setFormatter(P.formatter);h.setBindingMode(a.OneTime);j.push(h);});if(j.length>1||(o.formatter&&o.formatter.textFragments)){t=o.type;if(typeof t=="string"){T=O.get(t);t=new T(o.formatOptions,o.constraints);}h=new b(j,o.useRawValues,o.useInternalValues);h.setType(t,P.targetType||"any");h.setBindingMode(a.OneTime);}else{h=j[0];}h.setFormatter(o.formatter);h.initialize();return h.getExternalValue();}
return E;});
sap.ui.predefine('sap/ui/core/mvc/HTMLView',['sap/ui/thirdparty/jquery','./View','./HTMLViewRenderer','./ViewType','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/core/DeclarativeSupport','sap/ui/model/resource/ResourceModel','sap/base/util/LoaderExtensions'],function(q,V,H,a,m,M,D,R,L){"use strict";
var b=V.extend("sap.ui.core.mvc.HTMLView",{
metadata:{library:"sap.ui.core"},
renderer:H
});
b.create=function(o){var p=m({},o);p.type=a.HTML;return V.create(p);};
sap.ui.htmlview=function(i,v){return sap.ui.view(i,v,a.HTML);};
b._sType=a.HTML;b.asyncSupport=true;b._mTemplates={};b._mAllowedSettings={"viewName":true,"controller":true,"viewContent":true,"definition":true,"controllerName":true,"resourceBundleName":true,"resourceBundleUrl":true,"resourceBundleLocale":true,"resourceBundleAlias":true};
b._getTemplate=function(t,o){var u=this._getViewUrl(t);var h=this._mTemplates[u];if(!h){h=this._loadTemplate(t,o);if(o&&o.async){var c=this;return h.then(function(_){c._mTemplates[u]=_;return Promise.resolve(_);});}else{this._mTemplates[u]=h;}}return o.async?Promise.resolve(h):h;};
b.prototype.getControllerName=function(){return this._controllerName;};
b._getViewUrl=function(t){return sap.ui.require.toUrl(t.replace(/\./g,"/"))+".view.html";};
b._loadTemplate=function(t,o){var r=t.replace(/\./g,"/")+".view.html";return L.loadResource(r,o);};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;function I(){t._oTemplate=document.createElement("div");if(typeof h==="string"){t._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}t._oTemplate.appendChild(f);}var o=t._oTemplate.getElementsByTagName("template")[0];var p=t.getMetadata().getAllProperties();if(o){q.each(o.attributes,function(d,A){var N=D.convertAttributeToSettingName(A.name,t.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(b._mAllowedSettings[N]){s[N]=v;}}});t._oTemplate=o;}if(t._oTemplate.content){var f=t._oTemplate.content;t._oTemplate=document.createElement("div");t._oTemplate.appendChild(f);}if(s.controllerName){t._controllerName=s.controllerName;}if((s.resourceBundleName||s.resourceBundleUrl)&&(!s.models||!s.models[s.resourceBundleAlias])){var c=new R({bundleName:s.resourceBundleName,bundleUrl:s.resourceBundleUrl,bundleLocale:s.resourceBundleLocale,async:s.async});var B=c.getResourceBundle();if(B instanceof Promise){return B.then(function(){t.setModel(c,s.resourceBundleAlias);});}t.setModel(c,s.resourceBundleAlias);}}var h=s.viewContent;if(!h){h=b._getTemplate(s.viewName,{async:s.async});}if(s.async){return h.then(function(_){h=_;return I();});}I();};
b.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){D.compile(t._oTemplate,t);},{settings:this._fnSettingsPreprocessor});};
b.prototype.exit=function(){this._oTemplate=null;V.prototype.exit.call(this);if(this._connectedControls){for(var i=0;i<this._connectedControls.length;i++){this._connectedControls[i].destroy();}this._connectedControls=null;}};
b.prototype.connectControl=function(c){this._connectedControls=this._connectedControls||[];this._connectedControls.push(c);};
return b;});
sap.ui.predefine('sap/ui/core/mvc/HTMLViewRenderer',['./ViewRenderer'],function(V){"use strict";var H={apiVersion:1};
H.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiHTMLView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();if(c._oTemplate){var h=c._oTemplate.innerHTML;var a=c.getContent();var d=[];var b=function(c){var t=H._getHTML(r,c,h);if(t){h=t;}else{d.push(c);}};if(a){if(Array.isArray(a)){for(var i=0;i<a.length;i++){b(a[i]);}}else if(a){b(a);}}r.unsafeHtml(h);for(var k=0;k<d.length;k++){r.renderControl(d[k]);}}r.close("div");};
H._getHTML=function(r,c,h){var i=c.getId();h=h.replace(/(<div)/gi,"\n$1");var a=new RegExp('<div.*?data-sap-ui-id="'+i+'".*?></div>',"gi");var m=a.exec(h);if(m){h=h.replace(m[0],r.getHTML(c));return h;}else{return"";}};
return H;},true);
sap.ui.predefine('sap/ui/core/mvc/JSONView',['./View','./JSONViewRenderer','./ViewType','./EventHandlerResolver','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/base/util/LoaderExtensions'],function(V,J,a,E,m,M,R,L,b){"use strict";
var c=V.extend("sap.ui.core.mvc.JSONView",{
metadata:{library:"sap.ui.core"},
renderer:J
});
c.create=function(o){var p=m({},o);for(var O in p){if(O==='preprocessors'){delete p['preprocessors'];L.warning("JSONView.create does not support the option preprocessors!");}}p.type=a.JSON;return V.create(p);};
sap.ui.jsonview=function(i,v){return sap.ui.view(i,v,a.JSON);};
c._sType=a.JSON;c.asyncSupport=true;
c.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;var i=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!s.models||!s.models[t._oJSONView.resourceBundleAlias])){var o=new R({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl,async:s.async});var B=o.getResourceBundle();if(B instanceof Promise){return B.then(function(){t.setModel(o,t._oJSONView.resourceBundleAlias);});}t.setModel(o,t._oJSONView.resourceBundleAlias);}};if(s.viewName){if(s.async){return this._loadTemplate(s.viewName,{async:true}).then(i);}else{this._loadTemplate(s.viewName);i();}}else if(s.viewContent){this.mProperties["viewContent"]=s.viewContent;if(typeof s.viewContent==="string"){this._oJSONView=JSON.parse(s.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+s.viewContent);}}else if(typeof s.viewContent==="object"){this._oJSONView=s.viewContent;}else{throw new Error("viewContent must be a JSON string or object, but is a "+(typeof s.viewContent));}if(s.async){return Promise.resolve().then(i);}else{i();}}};
c.prototype.onControllerConnected=function(C){var t=this;M.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},C);},{id:function(i){return t.createId(i);},settings:function(s){var o=this.getMetadata(),v=o.getJSONKeys(),k,d,K;for(k in s){if((K=v[k])!==undefined){d=s[k];switch(K._iKind){case 3:if(typeof d==="string"){s[k]=t.createId(d);}break;case 5:if(typeof d==="string"){s[k]=E.resolveEventHandler(d,C);}break;}}}}});};
c.prototype._loadTemplate=function(t,o){var r=t.replace(/\./g,"/")+".view.json";if(!o||!o.async){this._oJSONView=b.loadResource(r);}else{var d=this;return b.loadResource(r,o).then(function(j){d._oJSONView=j;});}};
c.prototype.getControllerName=function(){return this._oJSONView.controllerName;};
return c;});
sap.ui.predefine('sap/ui/core/mvc/JSONViewRenderer',['./ViewRenderer'],function(V){"use strict";var J={apiVersion:2};
J.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiJSONView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();c.getContent().forEach(r.renderControl,r);r.close("div");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/JSView',['./View','./JSViewRenderer','./ViewType','sap/base/util/extend','sap/base/util/merge','sap/ui/base/ManagedObject','sap/base/Log'],function(V,J,a,m,e,M,L){"use strict";
var b=V.extend("sap.ui.core.mvc.JSView",{
metadata:{library:"sap.ui.core"},
renderer:J
});
var r={};b.asyncSupport=true;b._sType=a.JS;
b.create=function(o){var p=m({},o);for(var O in p){if(O==='definition'||O==='preprocessors'){delete p[O];L.warning("JSView.create does not support the options definition or preprocessor!");}}p.type=a.JS;return V.create(p);};
sap.ui.jsview=function(i,c,A){return v.apply(this,arguments);};
function v(i,c,A){var s={},o;if(c&&typeof(c)=="string"){s.viewName=c;if(typeof arguments[2]=="boolean"){s.async=A;}else if(typeof arguments[2]=="object"){s.controller=arguments[2];s.async=!!arguments[3];}if(s.viewName.startsWith("module:")){throw Error("Legacy factory sap.ui.jsview doesn't support typed views!");}o=new b(i,s);return o;}else if(c&&typeof(c)=="object"){r[i]=c;sap.ui.loader._.declareModule(i.replace(/\./g,"/")+".view.js");L.warning("For defining views, use typed views with 'sap.ui.core.mvc.View.extend()'.");}else if(arguments.length==1&&typeof i=="string"||arguments.length==2&&typeof arguments[0]=="string"&&typeof arguments[1]=="boolean"){s.viewName=arguments[0];s.async=!!arguments[1];o=s.id?new b(s.id,s):new b(s);return o;}else{throw new Error("Wrong arguments ('"+i+"', '"+c+"')!"+" Either call sap.ui.jsview([sId,] sViewName) to instantiate a View"+" or sap.ui.jsview(sViewName, oViewImpl) to define a View type.");}}
b.prototype.initViewSettings=function(s){var p;L.warning("Do not use deprecated sap.ui.core.mvc.JSView: (View: "+(s.id||s.viewName)+"). "+"Use typed views defined by 'sap.ui.core.mvc.View.extend()' and created by 'sap.ui.core.mvc.View.create()'. "+"For further information, have a look at https://sapui5.hana.ondemand.com/#/topic/e6bb33d076dc4f23be50c082c271b9f0.","sap.ui.core.mvc.JSView",null,function(){return{type:"sap.ui.core.mvc.JSView",name:s.viewName};});if(Object.getPrototypeOf(this)===b.prototype){if(!r[s.viewName]){var c=s.viewName.replace(/\./g,"/")+".view";if(s.async){p=new Promise(function(d,f){sap.ui.require([c],d,f);});}else{sap.ui.requireSync(c);}}if(s.async){return Promise.resolve(p).then(function(){e(this,r[s.viewName]);}.bind(this));}e(this,r[s.viewName]);}else if(s.async){return Promise.resolve();}};
b.prototype.onControllerConnected=function(c){M.runWithPreprocessors(function(){this.applySettings({content:this.createContent(c)});},{id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor},this);};
return b;});
sap.ui.predefine('sap/ui/core/mvc/JSViewRenderer',['./ViewRenderer'],function(V){"use strict";var J={apiVersion:2};
J.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiJSView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();c.getContent().forEach(r.renderControl,r);r.close("div");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/OverrideExecution',function(){"use strict";var O={After:"After",Before:"Before",Instead:"Instead"};return O;},true);
sap.ui.predefine('sap/ui/core/mvc/TemplateView',["./View","./TemplateViewRenderer","./ViewType","sap/base/Log"],function(V,T,a,L){"use strict";
var b=V.extend("sap.ui.core.mvc.TemplateView",{
metadata:{library:"sap.ui.core"},
renderer:T
});
(function(){
sap.ui.templateview=function(i,v){L.warning("sap.ui.core.mvc.TemplateView is deprecated. Use XMLView or JSView instead.");return sap.ui.view(i,v,a.Template);};
b._sType=a.Template;
b.prototype.getControllerName=function(){return this._sControllerName;};
b._getViewUrl=function(t){return sap.ui.require.toUrl(t.replace(/\./g,"/"))+".view.tmpl";};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(!s.viewName){throw new Error("No view name is given.");}this._oTemplate=sap.ui.template({id:this.getId(),src:b._getViewUrl(s.viewName)});this._sControllerName=this._oTemplate._sControllerName;this._oTemplate=this._oTemplate.createControl(undefined,undefined,this);this.addContent(this._oTemplate);};
}());return b;});
sap.ui.predefine('sap/ui/core/mvc/TemplateViewRenderer',['./ViewRenderer'],function(V){"use strict";var T={apiVersion:2};
T.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiTmplView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();r.renderControl(c._oTemplate);r.close("div");};
return T;},true);
sap.ui.predefine('sap/ui/core/mvc/View',["sap/base/util/isEmptyObject","sap/ui/base/ManagedObject","sap/ui/core/Control","sap/ui/core/mvc/Controller","sap/base/util/merge","./ViewType","./ViewRenderer","./XMLProcessingMode","sap/base/assert","sap/base/Log","sap/base/util/extend","sap/ui/core/Core"],function(a,M,C,b,m,V,c,X,d,L,f){"use strict";
var g=C.extend("sap.ui.core.mvc.View",{
metadata:{interfaces:["sap.ui.core.IDScope"],"abstract":true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',definition:'any',viewContent:{type:'any',deprecated:true},viewData:'any',async:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/mvc/View.designtime"},
renderer:c
});
g._mPreprocessors={};
function h(P){P._settings={};for(var e in P){if(e.indexOf("_")!==0){P._settings[e]=P[e];}}}
function k(P,A){var e;if(typeof P.preprocessor==="string"){var i=P.preprocessor.replace(/\./g,"/");if(A){return new Promise(function(j,l){sap.ui.require([i],function(e){j(e);},l);});}else{return sap.ui.requireSync(i);}}else if(typeof P.preprocessor==="function"&&!P.preprocessor.process){e={process:P.preprocessor};}else{e=P.preprocessor;}if(A){return Promise.resolve(e);}else{return e;}}
function n(e,T){var j=this.mPreprocessors[T]||[],G=[],i,l,O,P=[];if(g._mPreprocessors[e]&&g._mPreprocessors[e][T]){G=g._mPreprocessors[e][T].map(function(x){return Object.assign({},x);});}for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{P.push(G[i]);}}for(i=0,l=j.length;i<l;i++){var I=!j[i].preprocessor;if(I&&O){P.unshift(f(j[i],O));}else if(!I){P.push(j[i]);}}return P;}
function o(e,S){var i=e.getMetadata().getClass();function j(P){P.preprocessor=k(P,S.async);}e.mPreprocessors=Object.assign({},S.preprocessors);for(var _ in i.PreprocessorType){var T=i.PreprocessorType[_];if(e.mPreprocessors[T]&&!Array.isArray(e.mPreprocessors[T])){e.mPreprocessors[T]=[e.mPreprocessors[T]];}else if(!e.mPreprocessors[T]){e.mPreprocessors[T]=[];}e.mPreprocessors[T].forEach(h);e.mPreprocessors[T]=n.call(e,i._sType,T);e.mPreprocessors[T].forEach(j);}}
function p(e){e.oAsyncState={};e.oAsyncState.promise=null;}
var q=function(T,S){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var e=S.controller,N=e&&typeof e.getMetadata==="function"&&e.getMetadata().getName(),A=S.async;if(!e&&T.getControllerName){T.bControllerIsViewManaged=true;var i=T.getControllerName();if(i){var j=sap.ui.require("sap/ui/core/Component");if(j){var l=j.getCustomizing(T,{type:"sap.ui.controllerReplacements",name:i});if(l){i=typeof l==="string"?l:l.controllerName;}}if(A){e=b.create({name:i,_viewId:T.sId});}else{e=sap.ui.controller(i,true,false,T.sId);}}}else if(e){T.bControllerIsViewManaged=false;var O=M._sOwnerId;if(!e._isExtended()){e=b.applyExtensions(e,N,O,T.sId,A);}else if(A){e=Promise.resolve(e);}}if(e){var x=function(e){T.oController=e;e.oView=T;};if(A){if(!T.oAsyncState){throw new Error("The view "+T.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return e.then(x);}else{x(e);}}}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});T.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl");}};
g.prototype._initCompositeSupport=function(S){S=S||{};d(!S.preprocessors||this.getMetadata().getName().indexOf("XMLView"),"Preprocessors only available for XMLView");this.oViewData=S.viewData;this.sViewName=S.viewName;if(this.sViewName&&this.sViewName.startsWith("module:")){this.sViewName=this.sViewName.slice("module:".length).replace(/\//g,".");}var i=this;o(this,S);if(S.async){p(this);}var j=sap.ui.require("sap/ui/core/Component");if(j){var l=j.getCustomizing(this,{type:"sap.ui.viewModifications",name:this.sViewName});if(!a(l)){this._fnSettingsPreprocessor=function(S){var I=this.getId();if(I){if(i.isPrefixedId(I)){I=I.substring((i.getId()+"--").length);}var e=Object.assign({},l[I]);if(e){for(var x in e){if(x!=="visible"){L.warning("Customizing: custom value for property '"+x+"' of control '"+I+"' in View '"+i.sViewName+"' ignored: only the 'visible' property can be customized.");delete e[x];}}L.info("Customizing: custom value for property 'visible' of control '"+I+"' in View '"+i.sViewName+"' applied: "+e.visible);S=f(S,e);}}};}}var P=function(e,x){d(typeof e==="function","fn must be a function");var O=j&&j.getOwnerComponentFor(i);if(O){if(x){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(y){return O.runAsOwner(y);};}return O.runAsOwner(e);}return e();};var A=function(e){if(e.oController&&e.oController.connectToView){return e.oController.connectToView(e);}};var F=function(S){if(i.onControllerConnected){return i.onControllerConnected(i.oController,S);}};if(S.async){this.oAsyncState.promise=this.initViewSettings(S).then(function(){return P(q.bind(null,i,S),true);}).then(function(){return P(F.bind(null,S),true);}).then(function(){return A(i);}).then(function(){return i.runPreprocessor("controls",i,false);}).then(function(){return P(i.fireAfterInit.bind(i),true);}).then(function(){return i;}).catch(function(e){this.deregister();throw e;}.bind(this));}else{this.initViewSettings(S);q(this,S);F(S);A(this);this.runPreprocessor("controls",this,true);this.fireAfterInit();}};
g.prototype.getController=function(){return this.oController;};
g.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
g.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};
g.prototype.getLocalId=function(i){var P=this.getId()+"--";return(i&&i.indexOf(P)===0)?i.slice(P.length):null;};
g.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};
g.prototype.getViewData=function(){return this.oViewData;};
function r(){this.oAsyncState=null;}
g.prototype.exit=function(){this.fireBeforeExit();if(this.oController&&this.bControllerIsViewManaged){this.oController.destroy();delete this.oController;}delete this.oPreprocessorInfo;if(this.oAsyncState){var D=r.bind(this);this.oAsyncState.promise.then(D,D);}};
g.prototype.onAfterRendering=function(){this.fireAfterRendering();};
g.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};
g.prototype.clone=function(i,l){var S={},K,e;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){S[K]=this.mProperties[K];}}e=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,x,j;for(E in e.mEventRegistry){x=e.mEventRegistry[E];for(j=x.length-1;j>=0;j--){if(x[j].oListener===this.getController()){x[j]={oListener:e.getController(),fFunction:x[j].fFunction,oData:x[j].oData};}}}e.applySettings(S);return e;};
g.prototype.getPreprocessors=function(){return this.mPreprocessors;};
g.prototype.getPreprocessorInfo=function(S){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!S};}if(g._supportInfo){this.oPreprocessorInfo._supportInfo=g._supportInfo;}return this.oPreprocessorInfo;};
g.prototype.runPreprocessor=function(T,S,e){var j=this.getPreprocessorInfo(e),P=this.mPreprocessors&&this.mPreprocessors[T]||[],x,A,y;if(!e){A=function(j,z){return function(S){return z.preprocessor.then(function(B){return B.process(S,j,z._settings);});};};y=Promise.resolve(S);}for(var i=0,l=P.length;i<l;i++){if(e&&P[i]._syncSupport===true){x=P[i].preprocessor.process;S=x(S,j,P[i]._settings);}else if(!e){y=y.then(A(j,P[i]));}else{L.debug("Async \""+T+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return e?S:y;};
function s(T,e){if(!g._mPreprocessors[e]){g._mPreprocessors[e]={};}if(!g._mPreprocessors[e][T]){g._mPreprocessors[e][T]=[];}}
function t(e,T){return g._mPreprocessors[e][T].some(function(P){return!!P._onDemand;});}
g.registerPreprocessor=function(T,P,e,S,O,i){if(typeof O!=="boolean"){i=O;O=false;}if(P){s(T,e);if(O&&t(e,T)){L.error("Registration for \""+T+"\" failed, only one on-demand-preprocessor allowed",this.getMetadata().getName());return;}g._mPreprocessors[e][T].push({preprocessor:P,_onDemand:O,_syncSupport:S,_settings:i});L.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+T+"\""+(S?" with syncSupport":""),this.getMetadata().getName());}else{L.error("Registration for \""+T+"\" failed, no preprocessor specified",this.getMetadata().getName());}};
g.prototype.hasPreprocessor=function(T){return!!this.mPreprocessors[T].length;};
g.create=function(O){var P=m({},O);P.async=true;P.viewContent=P.definition;var e=sap.ui.require("sap/ui/core/Component");var i;if(e&&M._sOwnerId){i=e.get(M._sOwnerId);}function w(){return v(P.id,P,P.type).loaded();}return new Promise(function(j,l){var x=u(P);sap.ui.require([x],function(y){j(y);},l);}).then(function(j){if(j.getMetadata().isA("sap.ui.core.mvc.XMLView")){P.processingMode=X.Sequential;}if(i){return i.runAsOwner(w);}else{return w();}});};
g._create=v;
sap.ui.view=function(i,e,T){var j=typeof i==="string"?i:e;j=typeof j==="object"?j.viewName:j;L.warning("Do not use deprecated view factory functions (View: "+j+"). "+"Use the static create function on the view module instead: [XML|HTML|JSON]View.create().","sap.ui.view",null,function(){return{type:"sap.ui.view",name:j};});return v(i,e,T);};
function v(i,e,T){var j=null,l={};if(typeof i==="object"||typeof i==="string"&&e===undefined){e=i;i=undefined;}if(e){if(typeof e==="string"){l.viewName=e;}else{l=e;}}d(!l.async||typeof l.async==="boolean","sap.ui.view factory: Special setting async has to be of the type 'boolean'!");if(i){l.id=i;}if(T){l.type=T;}if(l.type===V.XML&&l.async){l.processingMode=l.processingMode||X.SequentialLegacy;}var x=sap.ui.require("sap/ui/core/Component");if(x&&M._sOwnerId){var y=x.getCustomizing(M._sOwnerId,{type:"sap.ui.viewReplacements",name:l.viewName});if(y){delete y.async;L.info("Customizing: View replacement for view '"+l.viewName+"' found and applied: "+y.viewName+" (type: "+y.type+")");f(l,y);}else{L.debug("Customizing: no View replacement found for view '"+l.viewName+"'.");}}var z=u(l);j=w(z,l);return j;}
function u(e){var i=g._getModuleName(e);if(i){if(e.type){L.error("When using the view factory, the 'type' setting must be omitted for typed views. When embedding typed views in XML, don't use the <JSView> tag, use the <View> tag instead.");}return i;}if(!e.type){throw new Error("No view type specified.");}else if(e.type===V.JS){i='sap/ui/core/mvc/JSView';}else if(e.type===V.JSON){i='sap/ui/core/mvc/JSONView';}else if(e.type===V.XML){i='sap/ui/core/mvc/XMLView';}else if(e.type===V.HTML){i='sap/ui/core/mvc/HTMLView';}else if(e.type===V.Template){i='sap/ui/core/mvc/TemplateView';}else{throw new Error("Unknown view type "+e.type+" specified.");}return i;}
function w(e,i){var j=sap.ui.require(e);if(!j){j=sap.ui.requireSync(e);if(i.async){L.warning("sap.ui.view was called without requiring the according view class.");}}return new j(i);}
g.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise;}else{return Promise.resolve(this);}};
g._getModuleName=function(S){var e;if(S.viewName&&S.viewName.startsWith("module:")){e=S.viewName.slice("module:".length);}return e;};
g.prototype.getAutoPrefixId=function(){return false;};
g.prototype.onControllerConnected=function(e,S){if(!this.createContent&&typeof this.createContent!=='function'){return;}var P={id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor};return M.runWithPreprocessors(function(){var i=this.createContent(e);if(S.async){i=Promise.resolve(i);return i.then(function(i){this.applySettings({content:i});}.bind(this));}else if(i instanceof Promise){throw new Error("An asynchronous view (createContent) cannot be instantiated synchronously. Affected view: '"+this.getMetadata().getName()+"'.");}else{this.applySettings({content:i});}}.bind(this),P);};
g.prototype.initViewSettings=function(S){if(!this.getMetadata()._oRenderer){this.getMetadata().getRenderer=function(){return g.getMetadata().getRenderer();};this.getMetadata().getRendererName=function(){return g.getMetadata().getRendererName();};}if(S.async){return Promise.resolve();}};
return g;});
sap.ui.predefine('sap/ui/core/mvc/ViewRenderer',function(){"use strict";var V={apiVersion:2};
V.render=function(r,c){r.openStart("div",c);r.class("sapUiView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();c.getContent().forEach(r.renderControl,r);r.close("div");};
V.addDisplayClass=function(r,c){if(c.getDisplayBlock()||(c.getWidth()==="100%"&&c.getHeight()==="100%")){r.class("sapUiViewDisplayBlock");}};
return V;},true);
sap.ui.predefine('sap/ui/core/mvc/XMLProcessingMode',[],function(){"use strict";var X={Sequential:"Sequential",SequentialLegacy:"SequentialLegacy"};return X;});
sap.ui.predefine('sap/ui/core/mvc/XMLView',["sap/ui/thirdparty/jquery","./View","./XMLViewRenderer","./ViewType","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/XMLTemplateProcessor","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/cache/CacheManager","sap/ui/model/resource/ResourceModel","sap/ui/util/XMLHelper","sap/base/strings/hash","sap/base/Log","sap/base/util/LoaderExtensions","sap/ui/performance/trace/Interaction","sap/ui/core/Core"],function(q,V,X,a,m,M,b,C,R,c,d,f,h,L,g,I){"use strict";var j=R.RenderPrefixes,x="XMLViewCacheError",n={};
var k=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{
metadata:{library:"sap.ui.core"},
renderer:{apiVersion:2,render:function(o,e){o.text("");}}
});
var l=V.extend("sap.ui.core.mvc.XMLView",{
metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"},
renderer:X
});
sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,a.XML);};
l.create=function(o){var P=m({},o);P.viewContent=P.definition;P.async=true;P.type=a.XML;return V.create(P);};
l._sType=a.XML;l.asyncSupport=true;l._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&c._isSupportedEnvironment();
function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}
function p(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}
function r(o,S){o.mProperties["viewContent"]=S.viewContent;var e=f.parse(S.viewContent);v(e);return e.documentElement;}
function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new d({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale,async:S.async});var i=e.getResourceBundle();if(i instanceof Promise){return i.then(function(){o.setModel(e,o._resourceBundleAlias);});}o.setModel(e,o._resourceBundleAlias);}}
function t(o){o.oAfterRenderingNotifier=new k();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}
function u(S){var e=sap.ui.require("sap/ui/core/Component"),o;if(e){while(S){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}}return o;}
function w(o,e){var i=u(o),G=i?JSON.stringify(i.getManifest()):null,H=[];H=H.concat(A(o,i),D(),B(o),e.keys);return z(o,H).then(function(K){return{key:K+"("+h(G||"")+")",componentManifest:G,additionalData:e.additionalData};});}
function y(K){return K;}
function z(o,i){return Promise.all(i).then(function(K){K=K.filter(function(G){return G!==n;});if(K.every(y)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}
function A(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()].concat(e&&e.getActiveTerminologies()||[]);}
function B(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),G=[];function H(o){G.push(o.preprocessor.then(function(J){if(J.getCacheKey){return J.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(H);}return G;}
function D(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(o){T+=o.buildTimestamp;});}return T;}).catch(function(e){L.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");L.debug(e);return"";});}
function E(e,i){var K=e.key;delete e.key;e.xml=f.serialize(i);return c.set(K,e);}
function F(e){return c.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=f.parse(i.xml,"application/xml").documentElement;if(i.additionalData){m(e.additionalData,i.additionalData);}return i;}});}
l.prototype.initViewSettings=function(S){var e=this,_;function i(O){e._xContent=O;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:m({},e),settings:m({},S||{}),type:"xmlview"}});}if(!e.isSubView()){var P={};b.parseViewAttributes(O,e,P);if(!S.async){Object.assign(S,P);}else{e.applySettings(P);}}else{delete S.controller;}var Q=s(e,S);if(Q instanceof Promise){return Q.then(function(){t(e);});}t(e);}function o(O,P){if(e.hasPreprocessor("viewxml")){return b.enrichTemplateIdsPromise(O,e,P).then(function(){return e.runPreprocessor("viewxml",O,!P);});}return O;}function G(O){var P=I.notifyAsyncStep("VIEW PREPROCESSING");return e.runPreprocessor("xml",O).then(function(O){return o(O,true);}).finally(P);}function H(N){return g.loadResource(N,{async:true}).then(function(O){return O.documentElement;});}function J(N,O){return H(N).then(G).then(function(P){if(O){E(O,P);}return P;});}function K(N,O){return w(e,O).then(function(P){return F(P).then(function(Q){if(!Q){return J(N,P);}else{return Q.xml;}});}).catch(function(P){if(P.name===x){L.error(P.message,P.name,"sap.ui.core.mvc.XMLView");L.error("Processing the View without caching.","sap.ui.core.mvc.XMLView");return J(N);}else{return Promise.reject(P);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}p(this,S);if(S.viewName){var N=S.viewName.replace(/\./g,"/")+".view.xml";if(S.async){if(S.cache&&l._bUseCache){return K(N,S.cache).then(i);}else{return H(N).then(G).then(i);}}else{_=g.loadResource(N).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=r(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return G(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.getResult==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};
l.prototype.onBeforeRendering=function(){var o=this.getDomRef();if(o&&!R.isPreservedContent(o)){R.preserveContent(o,true);}V.prototype.onBeforeRendering.apply(this,arguments);};
l.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};
l.prototype.onControllerConnected=function(o){var e=this;function i(H){return M.runWithPreprocessors(H,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(b.parseTemplate.bind(null,this._xContent,this));}else{var G=I.notifyAsyncStep("VIEW PROCESSING");return b.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;}).finally(G);}};
l.prototype.getControllerName=function(){return this._controllerName;};
l.prototype.isSubView=function(){return this._oContainingView!=this;};
l.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var N=document.getElementById(j.Temporary+e[i].getId())||e[i].getDomRef()||document.getElementById(j.Invisible+e[i].getId());if(N){q(document.getElementById(j.Dummy+e[i].getId())).replaceWith(N);}}}q(document.getElementById(j.Temporary+this.getId())).replaceWith(this._$oldContent);}this._$oldContent=undefined;};
l.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+j.Dummy+o.getId()+'" class="sapUiHidden"></div>');return true;};
l.registerPreprocessor=function(T,P,e,S,o,i){var O=this.getMetadata().getClass()._sType;if(typeof e==="string"){if(e!==O){throw new TypeError("View types other than "+O+" are not supported by XMLView.registerPreprocessor,"+" check View.registerPreprocessor instead");}}else{i=o;o=S;S=e;}T=T.toUpperCase();if(l.PreprocessorType[T]){V.registerPreprocessor(l.PreprocessorType[T],P,O,S,o,i);}else{L.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};
l.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};l.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return l;});
sap.ui.predefine('sap/ui/core/mvc/XMLViewRenderer',['./ViewRenderer','../RenderManager',"sap/ui/thirdparty/jquery"],function(V,R,q){"use strict";var P=R.RenderPrefixes.Dummy,a=R.RenderPrefixes.Invisible,b=R.RenderPrefixes.Temporary;var X={apiVersion:2};
X.render=function(r,c){var p=c._aParsedContent;var $=c._$oldContent=R.findPreservedContent(c.getId());if($.length===0){var s=c.isSubView();if(!s){r.openStart("div",c);r.class("sapUiView");r.class("sapUiXMLView");V.addDisplayClass(r,c);if(!c.oAsyncState||!c.oAsyncState.suppressPreserve){r.attr("data-sap-ui-preserve",c.getId());}r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();}if(p){for(var i=0;i<p.length;i++){var v=p[i];if(Array.isArray(v)){r[v[0]].apply(r,v[1]);}else{r.renderControl(v);if(!v.bOutput){r.openStart("div",P+v.getId());r.class("sapUiHidden");r.openEnd();r.close("div");}}}}if(!s){r.close("div");}}else{r.renderControl(c.oAfterRenderingNotifier);r.openStart("div",b+c.getId());r.class("sapUiHidden");r.openEnd();for(var i=0;i<p.length;i++){var f=p[i];if(!Array.isArray(f)){r.renderControl(f);var F=f.getId(),d=q(document.getElementById(F));if(d.length==0){d=q(document.getElementById(a+F));}if(!R.isPreservedContent(d[0])){d.replaceWith('<div id="'+P+F+'" class="sapUiHidden"></div>');}}}r.close("div");}};
return X;},true);
sap.ui.predefine('sap/ui/core/plugin/TemplatingSupport',["sap/base/Log",'sap/ui/core/tmpl/Template','sap/ui/core/Core'],function(L){"use strict";var T=function(){};
T.prototype.startPlugin=function(c,o){L.info("Starting TemplatingSupport plugin.");this.oCore=c;sap.ui.template();};
T.prototype.stopPlugin=function(){L.info("Stopping TemplatingSupport plugin.");this.oCore=null;};
sap.ui.getCore().registerPlugin(new T());return T;},true);
sap.ui.predefine('sap/ui/core/postmessage/Bus',["sap/ui/core/EventBus","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/Log"],function(E,i,a,L){"use strict";var I;var s='______UI5______';
var P=E.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(I){return I;}I=this;E.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener('message',this._receiver);}});
P.event={CONNECT:'______CONNECT______',READY:'______READY______',ACCEPTED:'______ACCEPTED______',DECLINED:'______DECLINED______'};
P.prototype.destroy=function(){window.removeEventListener('message',this._receiver);this._aEventQueue=[];E.prototype.destroy.apply(this,arguments);I=undefined;this.bIsDestroyed=true;};
P.getInstance=function(){if(!I){I=new P();}return I;};
P.prototype.publish=function(p){var t=p.target;var o=p.origin;var c=p.channelId;var e=p.eventId;var d=p.data;if(e===P.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener;}else if(window.parent!==window){t=window.parent;}else{return;}}if(!o){o='*';}}if((typeof window==="undefined")||!(t!=null&&t===t.window)||t===window){throw TypeError("Target must be a window object and has to differ from current window");}if(typeof o!=="string"){throw TypeError("Origin must be a string");}if(typeof c!=="string"){throw TypeError("ChannelId must be a string");}if(typeof e!=="string"){throw TypeError("EventId must be a string");}if(!i([P.event.READY,P.event.ACCEPTED,P.event.DECLINED],e)&&o!=='*'&&!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}var m={origin:o,channelId:c,eventId:e,data:d};m[s]=true;t.postMessage(m,o);};
P.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
P.prototype._getText=function(k,p){return sap.ui.getCore().getLibraryResourceBundle(true).then(function(l){return l.getText(k,p);});};
P.prototype._receiver=function(e){var d=e.data;if(!a(d)||!d.hasOwnProperty(s)){return;}if(this._oPendingProcess){this._aEventQueue.push(e);}else{this._oPendingProcess=this._processEvent(e);}};
P.prototype._processEvent=function(e){return new Promise(function(r,R){var d=e.data;var o=e.origin;if(i(this._aDeclinedOrigins,o)){r();return;}switch(d.eventId){case P.event.CONNECT:{if(typeof d.data!=="string"){this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.DECLINED});r();}else if(i(this._aAcceptedOrigins,o)){this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});r();}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(c){this._getText('PostMessage.Message',[d.data,o]).then(function(t){return c(t);}).then(function(){this.addAcceptedOrigin(o);this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});}.bind(this),function(){this.addDeclinedOrigin(o);this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.DECLINED});}.bind(this)).then(r);}.bind(this),R);}break;}case P.event.ACCEPTED:case P.event.DECLINED:case P.event.READY:{e.data.data=undefined;this._emitMessage(e);r();break;}default:{if(i(this._aAcceptedOrigins,o)){this._emitMessage(e);}r();}}}.bind(this)).catch(function(v){var m;var d;if(typeof v==='string'){m=v;}else if(v instanceof Error){m=v.message;d=v.stack;}else{m='Some unexpected error happened during post message processing';}L.error(m,d,'sap.ui.core.postmessage.Bus');}).then(function(){this._oPendingProcess=(this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null);}.bind(this));};
P.prototype._emitMessage=function(e){var c=e.data.channelId;var b=e.data.eventId;E.prototype.publish.call(this,c,b,{originalEvent:e,channelId:c,eventId:b,source:e.source,origin:e.origin,data:e.data.data});};
P.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice();};
P.prototype.setAcceptedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aAcceptedOrigins=o.slice();};
P.prototype.addAcceptedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}};
P.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([]);};
P.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice();};
P.prototype.setDeclinedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aDeclinedOrigins=o.slice();};
P.prototype.addDeclinedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aDeclinedOrigins,o)){this._aDeclinedOrigins.push(o);}};
P.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([]);};
return P;});
sap.ui.predefine('sap/ui/core/postmessage/confirmationDialog',function(){"use strict";return function(m){return new Promise(function(r,R){var M=sap.ui.getCore().getLoadedLibraries().hasOwnProperty('sap.m');if(M){sap.ui.require(['sap/m/MessageBox'],function(a){a.confirm(m,{actions:[a.Action.YES,a.Action.NO],onClose:function(A){if(A===a.Action.YES){r();}else{R();}}});},R);}else{var c=window.confirm(m);if(c){r();}else{R();}}});};});
sap.ui.predefine('sap/ui/core/routing/HashChanger',["./HashChangerBase","./RouterHashChanger",'sap/ui/thirdparty/hasher',"sap/base/Log","sap/base/util/ObjectPath","sap/ui/performance/trace/Interaction"],function(H,R,h,L,O,I){"use strict";
var a=H.extend("sap.ui.core.routing.HashChanger",{constructor:function(){H.apply(this);}});
a.prototype.init=function(){if(this._initialized){L.info("this HashChanger instance has already been initialized.");return false;}this._initialized=true;h.changed.add(this.fireHashChanged,this);if(!h.isActive()){h.initialized.addOnce(this.fireHashChanged,this);h.init();}else{this.fireHashChanged(h.getHash());}return this._initialized;};
a.prototype.fireHashChanged=function(n,o){this.fireEvent("hashChanged",{newHash:n,oldHash:o});};
a.prototype.createRouterHashChanger=function(){if(!this._oRouterHashChanger){var p=this._parseHash(this.getHash());this._oRouterHashChanger=new R({parent:this,hash:p.hash,subHashMap:p.subHashMap});this._registerListenerToRelevantEvents();this._oRouterHashChanger.attachEvent("hashSet",this._onHashModified,this);this._oRouterHashChanger.attachEvent("hashReplaced",this._onHashModified,this);}this._oRouterHashChanger.attachEvent("hashChanged",function(){I.notifyNavigation();});return this._oRouterHashChanger;};
a.prototype._registerListenerToRelevantEvents=function(){if(!this._mEventListeners){this._mEventListeners={};this.getRelevantEventsInfo().forEach(function(e){var E=e.name,l=this._onHashChangedForRouterHashChanger.bind(this,e);this._mEventListeners[E]=l;this.attachEvent(E,l,this);}.bind(this));}};
a.prototype._deregisterListenerFromRelevantEvents=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(E){this.detachEvent(E,this._mEventListeners[E],this);}.bind(this));delete this._mEventListeners;}};
a.prototype._onHashChangedForRouterHashChanger=function(e,E){if(this._oRouterHashChanger){var p=e.paramMapping||{},P=p["newHash"]||"newHash",n=E.getParameter(P)||"",o=this._parseHash(n);this._oRouterHashChanger.fireHashChanged(o.hash,o.subHashMap,!!e.updateHashOnly);}};
a.prototype._onHashModified=function(e){var E=e.getId(),b=[e.getParameter("hash")],k=[e.getParameter("key")],n=e.getParameter("nestedHashInfo"),d=e.getParameter("deletePrefix")||[];if(Array.isArray(n)){n.forEach(function(o){b.push(o.hash);k.push(o.key);if(Array.isArray(o.deletePrefix)){o.deletePrefix.forEach(function(D){if(d.indexOf(D)===-1){d.push(D);}});}});}if(E==="hashSet"){this._setSubHash(k,b,d);}else{this._replaceSubHash(k,b,d);}};
a.prototype._setSubHash=function(k,s,c){var b=this._reconstructHash(k,s,c);this.setHash(b);};
a.prototype._replaceSubHash=function(k,s,c){var b=this._reconstructHash(k,s,c);this.replaceHash(b);};
a.prototype._reconstructHash=function(k,v,d){var p=this.getHash().split("&/"),t=p.shift();k.forEach(function(K,b){if(d){d=d.filter(function(D){return D!==K;});}var V=v[b];if(K===undefined){t=V+"";}else{var f=p.some(function(P,i,p){if(P.startsWith(K)){if(V){p[i]=K+"/"+V;}else{d.push(K);}return true;}});if(!f){p.push(K+"/"+V);}}});if(d&&d.length>0){p=p.filter(function(P){return!d.some(function(s){return P.startsWith(s);});});}p.unshift(t);return p.join("&/");};
a.prototype._parseHash=function(s){var p=s.split("&/");return{hash:p.shift(),subHashMap:p.reduce(function(m,P){var S=P.indexOf("/");if(S===-1){m[P]="";}else{m[P.substring(0,S)]=P.substring(S+1);}return m;},{})};};
a.prototype.setHash=function(s){H.prototype.setHash.apply(this,arguments);h.setHash(s);};
a.prototype.replaceHash=function(s){H.prototype.replaceHash.apply(this,arguments);h.replaceHash(s);};
a.prototype.getHash=function(){return h.getHash();};
a.prototype.getRelevantEventsInfo=function(){return[{name:"hashChanged",paramMapping:{fullHash:"newHash"}}];};
a.prototype.destroy=function(){if(this._oRouterHashChanger){this._deregisterListenerFromRelevantEvents();this._oRouterHashChanger.destroy();this._oRouterHashChanger=undefined;}delete this._initialized;h.changed.remove(this.fireHashChanged,this);H.prototype.destroy.apply(this,arguments);};
a.prototype.deregisterRouterHashChanger=function(){this._deregisterListenerFromRelevantEvents();delete this._oRouterHashChanger;};
(function(){var _=null;
a.getInstance=function(){if(!_){_=new a();}return _;};
function e(o){var E,b,n;for(E in _.mEventRegistry){if(_.mEventRegistry.hasOwnProperty(E)){b=_.mEventRegistry[E];n=o.mEventRegistry[E];if(n){o.mEventRegistry[E]=b.concat(n);}else{o.mEventRegistry[E]=b;}}}}
a.replaceHashChanger=function(o){if(_&&o){var g=O.get("sap.ui.core.routing.History.getInstance"),b;if(g){b=g();b._setHashChanger(o);}if(_._oRouterHashChanger){_._oRouterHashChanger.detachEvent("hashSet",_._onHashModified,_);_._oRouterHashChanger.detachEvent("hashReplaced",_._onHashModified,_);_._deregisterListenerFromRelevantEvents();o._oRouterHashChanger=_._oRouterHashChanger;o._oRouterHashChanger.parent=o;delete _._oRouterHashChanger;o._oRouterHashChanger.attachEvent("hashSet",o._onHashModified,o);o._oRouterHashChanger.attachEvent("hashReplaced",o._onHashModified,o);o._registerListenerToRelevantEvents();}e(o);_.destroy();}_=o;};
}());return a;});
sap.ui.predefine('sap/ui/core/routing/HashChangerBase',['sap/ui/base/EventProvider'],function(E){"use strict";
var H=E.extend("sap.ui.core.routing.HashChangerBase",{
metadata:{"abstract":true,publicMethods:["getHash","setHash","replaceHash"]},
constructor:function(){E.apply(this);}
});
H.M_EVENTS={"HashChanged":"hashChanged","HashSet":"hashSet","HashReplaced":"hashReplaced"};
H.prototype.setHash=function(h){this.fireEvent("hashSet",{sHash:h,hash:h});};
H.prototype.replaceHash=function(h,d){this.fireEvent("hashReplaced",{sHash:h,hash:h,direction:d});};
return H;});
sap.ui.predefine('sap/ui/core/routing/History',['sap/ui/core/library','./HashChanger',"sap/base/Log","sap/base/util/ObjectPath"],function(l,H,L,O){"use strict";var a=l.routing.HistoryDirection;var D="Direction_Unchanged";var b=function(h){var t=this;this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;function c(C){if(b._bUsePushState&&!b.getInstance()){var s=window.history.state===null?{}:window.history.state;if(typeof s==="object"){s.sap=s.sap?s.sap:{};if(s.sap.history&&Array.isArray(s.sap.history)&&s.sap.history[s.sap.history.length-1]===C){b._aStateHistory=s.sap.history;}else{b._aStateHistory.push(C);s.sap.history=b._aStateHistory;window.history.replaceState(s,window.document.title);}}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}}t._reset();}if(!h){L.error("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter");}this._setHashChanger(h);if(h._initialized){c(h.getHash());}else{h.attachEventOnce("hashChanged",function(e){c(e.getParameter("newHash"));});}};b._aStateHistory=[];b._bUsePushState=window.self===window.top;
b.prototype.getHistoryStateOffset=function(){if(!b._bUsePushState){return undefined;}var s=O.get("history.state.sap.history");if(!Array.isArray(s)){return undefined;}return s.length-b._aStateHistory.length;};
b.prototype.destroy=function(){this._unRegisterHashChanger();};
b.prototype.getDirection=function(n){if(n!==undefined&&this._bIsInitial){return undefined;}if(n===undefined){return this._sCurrentDirection;}return this._getDirection(n);};
b.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1];};
b.prototype._setHashChanger=function(h){if(this._oHashChanger){this._unRegisterHashChanger();}this._oHashChanger=h;this._mEventListeners={};h.getRelevantEventsInfo().forEach(function(e){var E=e.name,p=e.paramMapping||{},f=this._onHashChange.bind(this,p);this._mEventListeners[E]=f;this._oHashChanger.attachEvent(E,f,this);}.bind(this));this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this);};
b.prototype._unRegisterHashChanger=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(E){this._oHashChanger.detachEvent(E,this._mEventListeners[E],this);}.bind(this));delete this._mEventListeners;}this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null;};
b.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash();};
b.prototype._getDirection=function(n,h,c){if(c&&this._oNextHash&&this._oNextHash.sHash===n){return a.NewEntry;}if(h){return a.NewEntry;}if(this._bUnknown){return a.Unknown;}if(this.aHistory[this.iHistoryPosition+1]===n&&this.aHistory[this.iHistoryPosition-1]===n){return a.Unknown;}if(this.aHistory[this.iHistoryPosition-1]===n){return a.Backwards;}if(this.aHistory[this.iHistoryPosition+1]===n){return a.Forwards;}return a.Unknown;};
b.prototype._getDirectionWithState=function(h){var s=window.history.state===null?{}:window.history.state,B,d;if(typeof s==="object"){if(s.sap===undefined){b._aStateHistory.push(h);s.sap={};s.sap.history=b._aStateHistory;window.history.replaceState(s,document.title);d=a.NewEntry;}else{B=s.sap.history.every(function(u,c){return u===b._aStateHistory[c];});if(B&&s.sap.history.length===b._aStateHistory.length){d=D;}else{d=B?a.Backwards:a.Forwards;b._aStateHistory=s.sap.history;}}}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}return d;};
b.prototype._onHashChange=function(p,e){var n=p.newHash||"newHash",o=p.oldHash||"oldHash",f=p.fullHash||"fullHash";this._hashChange(e.getParameter(n),e.getParameter(o),e.getParameter(f));};
b.prototype._hashChange=function(n,o,f){var c=window.history.length,d;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===n){if(this._oNextHash.sDirection){d=this._oNextHash.sDirection;}else{this.aHistory[this.iHistoryPosition]=n;if(f!==undefined&&b._bUsePushState&&this===b.getInstance()){b._aStateHistory[b._aStateHistory.length-1]=f;window.history.replaceState({sap:{history:b._aStateHistory}},window.document.title);}this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown;}return;}}this._bIsInitial=false;if(d){this._adaptToDirection(d,{oldHash:o,newHash:n,fullHash:f});}else{if(!d&&f!==undefined&&b._bUsePushState&&this===b.getInstance()){d=this._getDirectionWithState(f);}if(d===D){return;}if(!d){d=this._getDirection(n,this._iHistoryLength<window.history.length,true);}this._bUnknown=false;switch(d){case a.Unknown:this._reset();break;case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition++;break;case a.Forwards:this.iHistoryPosition++;break;case a.Backwards:this.iHistoryPosition--;break;default:break;}}this._sCurrentDirection=d;this._iHistoryLength=c;if(this._oNextHash){this._oNextHash=null;}};
b.prototype._adaptToDirection=function(d,h){var f=h.fullHash,n=h.newHash,I,s;if(b._bUsePushState&&this===b.getInstance()&&f!==undefined){switch(d){case a.NewEntry:case a.Forwards:b._aStateHistory.push(f);break;case a.Backwards:I=b._aStateHistory.lastIndexOf(f);if(I!==-1){b._aStateHistory.splice(I+1);}else{b._aStateHistory=[f];L.debug("Can't find "+f+" in "+JSON.stringify(b._aStateHistory));}break;case a.Unknown:b._aStateHistory[b._aStateHistory.length-1]=f;break;default:break;}s={};s.sap={};s.sap.history=b._aStateHistory;window.history.replaceState(s,document.title);}switch(d){case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition+=1;break;case a.Forwards:I=this.aHistory.indexOf(n,this.iHistoryPosition+1);if(I!==-1){this.iHistoryPosition=I;}else{this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition++;}break;case a.Backwards:I=this.aHistory.lastIndexOf(n,this.iHistoryPosition-1);if(I!==-1){this.iHistoryPosition=I;}else{this.aHistory=[n];this.iHistoryPosition=0;}break;case a.Unknown:this.aHistory[this.iHistoryPosition]=n;break;default:break;}};
b.prototype._hashSet=function(e){var h=e.getParameter("hash");if(h===undefined){h=e.getParameter("sHash");}this._hashChangedByApp(h,false);};
b.prototype._hashReplaced=function(e){var h=e.getParameter("hash"),d=e.getParameter("direction");if(h===undefined){h=e.getParameter("sHash");}if(h===this._oHashChanger.getHash()&&d){this._sCurrentDirection=d;}this._hashChangedByApp(h,true,d);};
b.prototype._hashChangedByApp=function(n,w,d){this._oNextHash={sHash:n,bWasReplaced:w,sDirection:d};};
var i;
b.getInstance=function(){return i;};
i=new b(H.getInstance());return b;},true);
sap.ui.predefine('sap/ui/core/routing/Route',['sap/ui/base/EventProvider','sap/ui/core/routing/Target','sap/ui/core/routing/async/Route','sap/ui/core/routing/sync/Route','sap/ui/core/Component',"sap/base/Log","sap/base/assert","sap/base/util/deepExtend"],function(E,T,a,s,C,L,b,d){"use strict";
var R=E.extend("sap.ui.core.routing.Route",{
metadata:{publicMethods:["getURL","getPattern"]},
constructor:function(r,c,p){E.apply(this,arguments);this._validateConfig(c);this._aPattern=[];this._aRoutes=[];this._oParent=p;this._oConfig=c;this._oRouter=r;var t=this,v=c.pattern,S,e,o,f,g=r._isAsync();f=g?a:s;for(var h in f){this[h]=f[h];}if(!Array.isArray(v)){v=[v];}if(c.parent){var j=this._getParentRoute(c.parent);if(!j){L.error("No parent route with '"+c.parent+"' could be found",this);}else if(j._aPattern.length>1){L.error("Routes with multiple patterns cannot be used as parent for nested routes",this);return;}else{this._oNestingParent=j;v.forEach(function(l,i){var n=j._aPattern[0];n=n.charAt(n.length)==="/"?n:n+"/";v[i]=n+l;});}}if(Array.isArray(c.subroutes)){S=c.subroutes;c.subroutes={};S.forEach(function(i){c.subroutes[i.name]=i;});}if(!c.target){var k=this._convertToTargetOptions(c);k._async=g;this._oTarget=new T(k,r._oViews,p&&p._oTarget);this._oTarget._bUseRawViewId=true;}if(c.subroutes){for(e in c.subroutes){o=c.subroutes[e];if(o.name===undefined){o.name=e;}r.addRoute(o,t);}}if(c.pattern===undefined){return;}v.forEach(function(i,I){t._aPattern[I]=i;t._aRoutes[I]=r._oRouter.addRoute(i);t._checkRoute(t._aRoutes[I]);t._aRoutes[I].greedy=c.greedy;t._aRoutes[I].matched.add(function(){var A={};Array.from(arguments).forEach(function(l,m){A[t._aRoutes[I]._paramsIds[m]]=l;});t._routeMatched(A,true);});t._aRoutes[I].switched.add(function(){t._routeSwitched();});});},
_checkRoute:function(r){var p=r._paramsIds;if(Array.isArray(p)){var D=p.filter(function(P){return P.charAt(0)==="?";}).filter(function(P){return p.indexOf(P.substring(1))>-1;}).map(function(P){return P.substring(1);});if(D.length>0){throw Error("The config of route '"+this._oConfig.name+"' contains standard parameter and query parameter with the same name: '"+D+"'. The name of the routing parameters and query parameter have to differentiate.");}}},
_routeSwitched:function(){this._suspend();this.fireEvent("switched",{name:this._oConfig.name});},
_suspend:function(){if(this._oRouter._oTargets){this._oRouter._oTargets.suspend(this._oConfig.target);if(this._oConfig.dynamicTarget){this._oRouter._oTargets.suspend(this._oConfig.dynamicTarget);}}},
_resume:function(){if(this._oRouter._oTargets){this._oRouter._oTargets.resume(this._oConfig.target);if(this._oConfig.dynamicTarget){this._oRouter._oTargets.resume(this._oConfig.dynamicTarget);}}},
destroy:function(){E.prototype.destroy.apply(this);this._aPattern=null;this._aRoutes=null;this._oParent=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getURL:function(p){return this._aRoutes[0].interpolate(p||{});},
_alignTargetsConfig:function(t){if(!t){return[];}if(!Array.isArray(t)){return(typeof t==="string")?[{name:t}]:[t];}return t.map(function(v){if(typeof v==="string"){v={name:v};}return v;});},
_changeHashWithComponentTargets:function(c,p){var t=this._alignTargetsConfig(this._oConfig.target),o=this._oRouter._oTargets,e,l;if(t&&t.length>0&&o){e=o.getTarget(t);if(!Array.isArray(e)){e=[e];}}else{e=[];}var f=this;l=e.map(function(g,i){if(g._oOptions.type==="Component"){var h=g._load({prefix:t[i].prefix,propagateTitle:t[i].hasOwnProperty("propagateTitle")?t[i].propagateTitle:f._oRouter._oConfig.propagateTitle});return h.then(function(j){var r=j.getRouter(),H=r&&r.getHashChanger(),k=c&&c[t[i].name],m=k&&k.route,n=r&&r.getRoute(m),q;if(k){if(n){q=r._getLastMatchedRouteName()!==m;H.setHash(n.getURL(k.parameters),p||!q);return n._changeHashWithComponentTargets(k.componentTargetInfo,p||q);}else{L.error("Can not navigate to route with name '"+m+"' because the route does not exist in component with id '"+j.getId()+"'");}}});}});return Promise.all(l);},
getPattern:function(){return this._aPattern[0];},
match:function(h){return this._aRoutes.some(function(r){return r.match(h);});},
attachMatched:function(D,f,l){return this.attachEvent("matched",D,f,l);},
detachMatched:function(f,l){return this.detachEvent("matched",f,l);},
attachBeforeMatched:function(D,f,l){return this.attachEvent("beforeMatched",D,f,l);},
detachBeforeMatched:function(f,l){return this.detachEvent("beforeMatched",f,l);},
fireBeforeMatched:function(p){this.fireEvent("beforeMatched",p);return this;},
attachPatternMatched:function(D,f,l){return this.attachEvent("patternMatched",D,f,l);},
detachPatternMatched:function(f,l){return this.detachEvent("patternMatched",f,l);},
_validateConfig:function(c){if(!c.name){L.error("A name has to be specified for every route",this);}if(c.viewName){L.error("The 'viewName' option shouldn't be used in Route. please use 'view' instead",this);}},
_convertToTargetOptions:function(o){return d({},o,{rootView:o.targetParent,controlId:o.targetControl,controlAggregation:o.targetAggregation,clearControlAggregation:o.clearTarget,viewName:o.view,viewType:o.viewType,viewId:o.viewId});},
_getParentRoute:function(p){var P=p.split(":");if(P.length===1||(P.length===2&&!P[0])){return this._oRouter.getRoute(P[P.length-1]);}else{b(this._oRouter._oOwner,"No owner component for "+this._oRouter._oOwner.getId());var o=C.getOwnerComponentFor(this._oRouter._oOwner);while(o){if(o.getMetadata().getName()===P[0]){var r=o.getRouter();return r.getRoute(P[1]);}o=C.getOwnerComponentFor(o);}return null;}},
getPatternArguments:function(h){return this._aRoutes[0].extrapolate(h);}
});
R.M_EVENTS={BeforeMatched:"beforeMatched",Matched:"matched",PatternMatched:"patternMatched"};return R;});
sap.ui.predefine('sap/ui/core/routing/Router',['sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads',"sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/Log","sap/ui/thirdparty/jquery","./RouterHashChanger","sap/ui/core/Component"],function(l,E,H,R,V,T,a,c,U,d,b,L,q,e,C){"use strict";var r={};
var f=E.extend("sap.ui.core.routing.Router",{
constructor:function(o,i,O,t,j){E.apply(this);this._oConfig=i||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function k(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=k();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);this._oTargets._setRouter(this);this._oTargets.attachDisplay(function(s){var I=s.getParameter("routeRelevant");if(this.isInitialized()&&!this._bMatchingProcessStarted){var u=this.getHashChanger();if(u instanceof e&&!I){u.resetHash(this);}}},this);}var m=this,n;if(!o){o={};}if(Array.isArray(o)){n=o;o={};n.forEach(function(s){o[s.name]=s;});}q.each(o,function(s,u){if(u.name===undefined){u.name=s;}m.addRoute(u);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));if(!j){j=H.getInstance().createRouterHashChanger();}this.setHashChanger(j);var p=this._getParentRouter();if(p){this.attachTitleChanged(function(s){if(this._oOwner&&!this._oOwner._bRoutingPropagateTitle){return;}var P=s.getParameters(),N,F;if(p._fnTitleChangedFiredOnChild){p._fnTitleChangedFiredOnChild(P);}else{N=P.nestedHistory.slice();N.unshift({ownerComponentId:p._oOwner.getId(),history:p.getTitleHistory()});F={propagated:true,title:P.title,history:P.history,nestedHistory:N};p.fireTitleChanged(F);}});}},
addRoute:function(o,p){if(!o.name){L.error("A name has to be specified for every route",this);}if(this._oRoutes[o.name]){L.error("Route with name "+o.name+" already exists",this);}this._oRoutes[o.name]=this._createRoute(this,o,p);},
parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{L.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},
initialize:function(i){var t=this,s;if(this._bIsInitialized){L.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(k){t.parse(k.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!this.oHashChanger){L.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return this;}if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(this._forwardTitleChanged,this);this._aHistory=[];var j=o&&h(this._oOwner,o);if(j){this._aHistory.push(j);}}if(this.oHashChanger instanceof e){this.oHashChanger._setActiveRouter(this);}this.oHashChanger.init();s=this.oHashChanger.getHash();this.oHashChanger.attachEvent("hashChanged",this.fnHashChanged);if(i){if(this._oMatchedRoute){this._oMatchedRoute._resume();}}else if(s!==e.InvalidHash){this.parse(s);}return this;},
_forwardTitleChanged:function(o){var p=o.getParameters();var i={title:p.title};var j=this._oRoutes[this._oConfig.homeRoute];if(j&&g(p.name,j._oConfig.name)){i.isHome=true;}this.fireTitleChanged(i);},
stop:function(){if(!this._bIsInitialized){L.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}if(this._oTargets){this._oTargets.detachTitleChanged(this._forwardTitleChanged,this);this._oTargets._oLastTitleTarget={};}if(this._oMatchedRoute){this._oMatchedRoute._routeSwitched();}this._bIsInitialized=false;delete this._oPreviousTitleChangedRoute;return this;},
isStopped:function(){return this._bIsInitialized===false;},
isInitialized:function(){return this._bIsInitialized===true;},
getHashChanger:function(){return this.oHashChanger;},
setHashChanger:function(o){if(this.oHashChanger){L.warning("The Router already has a HashChanger set and this call is ignored");}else{this.oHashChanger=o;}return this;},
destroy:function(){if(this.bIsDestroyed){return this;}E.prototype.destroy.apply(this);if(this._oViews){this._oViews.destroy();this._oViews=null;}if(!this._bIsInitialized){L.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}delete this._bIsInitialized;this.bIsDestroyed=true;return this;},
getURL:function(n,p){var o=this.getRoute(n);if(o){return o.getURL(p);}else{L.warning("Route with name "+n+" does not exist",this);}},
match:function(s){return Object.keys(this._oRoutes).some(function(i){return this._oRoutes[i].match(s);}.bind(this));},
getRouteByHash:function(s){for(var i in this._oRoutes){if(this._oRoutes.hasOwnProperty(i)){var o=this.getRoute(i);if(o.match(s)){return o;}}}},
getRouteInfoByHash:function(s){var o=this.getRouteByHash(s);if(!o){return undefined;}return{name:o._oConfig.name,arguments:o.getPatternArguments(s)};},
getRoute:function(n){return this._oRoutes[n];},
getViews:function(){return this._oViews;},
_createTargets:function(o,t){return new T({views:this._oViews,config:o,targets:t});},
_createRoute:function(o,i,p){return new R(o,i,p);},
getView:function(v,s,i){L.warning("Deprecated API Router#getView called - use Router#getViews instead.",this);var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:i},true);this.fireViewCreated({view:o,viewName:v,type:s});return o;},
setView:function(v,o){this._oViews.setView(v,o);return this;},
_getParentRouter:function(){var p=this._oOwner&&C.getOwnerComponentFor(this._oOwner);return p&&p.getRouter();},
navTo:function(n,p,o,i){var t=this,j=this._getLastMatchedRouteName()!==n,k=this.getRoute(n),m,s;if(this.isStopped()){L.info("The router instance "+this._sId+" is stopped. No navigation can be performed.");return this;}if(!k){L.warning("Route with name "+n+" does not exist",this);return this;}if(typeof o==="boolean"){i=o;}if(p===undefined){p={};}if(o&&!b(o)){if(!this._oConfig._async){L.error("navTo with component target info is only supported with async router",this);return this;}m=k._changeHashWithComponentTargets(o,j);}s=k.getURL(p);if(i){t._bLastHashReplaced=true;t.oHashChanger.replaceHash(s,m,!j);}else{t.oHashChanger.setHash(s,m,!j);}return this;},
_getLastMatchedRouteName:function(){return this._oMatchedRoute&&this._oMatchedRoute._oConfig.name;},
getTargets:function(){return this._oTargets;},
getTarget:function(n){return this._oTargets.getTarget(n);},
attachRouteMatched:function(D,F,o){this.attachEvent("routeMatched",D,F,o);return this;},
detachRouteMatched:function(F,o){this.detachEvent("routeMatched",F,o);return this;},
fireRouteMatched:function(p){this.fireEvent("routeMatched",p);if(f._interceptRouteMatched){f._interceptRouteMatched(this._oConfig.controlId,this);}return this;},
attachBeforeRouteMatched:function(D,F,o){this.attachEvent("beforeRouteMatched",D,F,o);return this;},
detachBeforeRouteMatched:function(F,o){this.detachEvent("beforeRouteMatched",F,o);return this;},
fireBeforeRouteMatched:function(p){this.fireEvent("beforeRouteMatched",p);return this;},
attachViewCreated:function(D,F,o){this.attachEvent("viewCreated",D,F,o);return this;},
detachViewCreated:function(F,o){this.detachEvent("viewCreated",F,o);return this;},
fireViewCreated:function(p){this.fireEvent("viewCreated",p);return this;},
attachRoutePatternMatched:function(D,F,o){this.attachEvent("routePatternMatched",D,F,o);return this;},
detachRoutePatternMatched:function(F,o){this.detachEvent("routePatternMatched",F,o);return this;},
fireRoutePatternMatched:function(p){this.fireEvent("routePatternMatched",p);return this;},
attachBypassed:function(D,F,o){return this.attachEvent(f.M_EVENTS.BYPASSED,D,F,o);},
detachBypassed:function(F,o){return this.detachEvent(f.M_EVENTS.BYPASSED,F,o);},
fireBypassed:function(p){return this.fireEvent(f.M_EVENTS.BYPASSED,p);},
attachTitleChanged:function(D,F,o){this.attachEvent(f.M_EVENTS.TITLE_CHANGED,D,F,o);return this;},
detachTitleChanged:function(F,o){return this.detachEvent(f.M_EVENTS.TITLE_CHANGED,F,o);},
fireTitleChanged:function(p){if(this.isStopped()){return this;}var I=!this._pWaitForTitleChangedOnChild;if(!p.propagated){p.propagated=false;var D=a.getInstance().getDirection(),s=this.getHashChanger().getHash(),j=l.routing.HistoryDirection,o=this._aHistory[this._aHistory.length-1],n;if(D===j.Backwards&&o&&!o.isHome){if(o&&o.title!==p.title){this._aHistory.pop();}}else if(o&&o.hash==s){o.title=p.title;this._aHistory.some(function(k,i,m){if(i<m.length-1&&d(k,o)){return m.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:s,title:p.title};this._aHistory.some(function(k,i,m){if(d(k,n)){return m.splice(i,1);}});this._aHistory.push(n);}p.history=this._aHistory.slice(0,-1);p.nestedHistory=[{history:this.getTitleHistory(),ownerComponentId:this._oOwner&&this._oOwner.getId()}];this._bLastHashReplaced=false;this._oPreviousTitleChangedRoute=this._oMatchedRoute;this._bFireTitleChanged=false;if(this._pWaitForTitleChangedOnChild){this._pWaitForTitleChangedOnChild.then(function(i){p.title=i.title;p.propagated=true;Array.prototype.push.apply(p.nestedHistory,i.nestedHistory);this._stopWaitingTitleChangedFromChild();this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}.bind(this));}}if(I){if(this._bMatchingProcessStarted&&this._isAsync()){this.attachEventOnce("routeMatched",function(){this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);},this);}else{this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}}return this;},
getTitleHistory:function(){return this._aHistory||[];},
_waitForTitleChangedOn:function(n){if(this._bFireTitleChanged){this._pWaitForTitleChangedOnChild=new Promise(function(i){this._fnTitleChangedFiredOnChild=i;}.bind(this));}},
_stopWaitingTitleChangedFromChild:function(){delete this._pWaitForTitleChangedOnChild;delete this._fnTitleChangedFiredOnChild;},
register:function(n){r[n]=this;return this;},
_onBypassed:function(s){var F=function(){this.fireBypassed({hash:s});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:s});if(o instanceof Promise){o.then(F);return;}}F();},
_isAsync:function(){return this._oConfig._async;},
metadata:{publicMethods:["initialize","getURL","register","getRoute"]}
});
function g(s,i){return i&&i.indexOf(s)>-1;}
function h(o,i){var s=i.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{L.error("Routes with dynamic parts cannot be resolved as home route.");}}
f.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};f._interceptRouteMatched=undefined;
f.getRouter=function(n){return r[n];};
return f;});
sap.ui.predefine('sap/ui/core/routing/RouterHashChanger',['./HashChangerBase'],function(H){"use strict";
var R=H.extend("sap.ui.core.routing.RouterHashChanger",{constructor:function(s){if(!s||!s.parent){throw new Error("sap.ui.core.routing.RouterHashChanger can't be instantiated without a parent");}this.parent=s.parent;this.hash=s.hash||"";this.subHashMap=s.subHashMap;this.key=s.key||"";H.apply(this);}});
R.InvalidHash=Object.create(null);
R.prototype.init=function(){this.parent.init();};
R.prototype._generatePrefixedKey=function(k){return this.key?(this.key+"-"+k):k;};
R.prototype.createSubHashChanger=function(k){this.children=this.children||{};var p=this._generatePrefixedKey(k);if(this.children[p]){return this.children[p];}var c=new R({key:p,parent:this,subHashMap:this.subHashMap,hash:(this.subHashMap&&this.subHashMap[p])||""});c.attachEvent("hashSet",this._onChildHashChanged.bind(this,p));c.attachEvent("hashReplaced",this._onChildHashChanged.bind(this,p));this.children[p]=c;return c;};
R.prototype.fireHashChanged=function(h,s,u){var k,o=this.hash;this.hash=h;this.subHashMap=s;if(!u&&h!==o){this.fireEvent("hashChanged",{newHash:h,oldHash:o});}if(this.children){k=Object.keys(this.children);k.forEach(function(c){var C=(s[c]===undefined?"":s[c]);this.children[c].fireHashChanged(C,s,u);}.bind(this));}};
R.prototype._onChildHashChanged=function(k,e){var c=e.getParameter("key")||k,h=e.getParameter("hash"),n=e.getParameter("nestedHashInfo"),d=e.getParameter("deletePrefix");if(this._bCollectMode){this._collectHash(c,h,d);}else{this.fireEvent(e.getId(),{hash:h,key:c,nestedHashInfo:n,deletePrefix:d});}};
R.prototype._collectHash=function(k,h,d){this._aCollectedHashInfo=this._aCollectedHashInfo||[];this._aCollectedHashInfo.push({key:k,hash:h,deletePrefix:d});};
R.prototype._hasRouterAttached=function(){return this.hasListeners("hashChanged");};
R.prototype._collectActiveDescendantPrefix=function(){if(this.children){var k=Object.keys(this.children);return k.reduce(function(p,K){var c=this.children[K];if(c._hasRouterAttached()){p.push(K);Array.prototype.push.apply(p,c._collectActiveDescendantPrefix());}return p;}.bind(this),[]);}else{return[];}};
R.prototype.getHash=function(){if(this._isUnderCollectMode()){return R.InvalidHash;}else{return this.hash;}};
R.prototype._setActiveRouter=function(r){if(r.getHashChanger()===this){this._oActiveRouter=r;}return this;};
R.prototype.resetHash=function(r){if(r&&this._oActiveRouter===r){this.hash=undefined;}return this;};
R.prototype.setHash=function(h,p,s){if(!(p instanceof Promise)){s=p;p=null;}return this._modifyHash(h,p,s);};
R.prototype.replaceHash=function(h,d,p,s){if(typeof d!=="string"){s=p;p=d;d=undefined;}if(!(p instanceof Promise)){s=p;p=null;}return this._modifyHash(h,p,s,true,d);};
R.prototype._modifyHash=function(h,p,s,r,d){var e=r?"hashReplaced":"hashSet",t=this,P={hash:h};if(r&&d){P.direction=d;}if(!s){P.deletePrefix=this._collectActiveDescendantPrefix();}if(p){this._bCollectMode=true;return p.then(function(){P.nestedHashInfo=t._aCollectedHashInfo;t.fireEvent(e,P);t._aCollectedHashInfo=null;t._bCollectMode=false;});}else{this.fireEvent(e,P);}};
R.prototype._isUnderCollectMode=function(){return this.parent instanceof R&&this.parent._isInCollectMode();};
R.prototype._isInCollectMode=function(){return this._bCollectMode||(this.parent instanceof R&&this.parent._isInCollectMode());};
R.prototype.destroy=function(){this.parent.deregisterRouterHashChanger(this);if(this.children){Object.keys(this.children).forEach(function(k){var c=this.children[k];c.destroy();}.bind(this));delete this.children;}delete this.hash;delete this.subHashMap;delete this.parent;delete this.key;H.prototype.destroy.apply(this,arguments);};
R.prototype.deregisterRouterHashChanger=function(r){if(this.children){Object.keys(this.children).some(function(k){var c=this.children[k];if(c===r){delete this.children[k];return true;}}.bind(this));}};
return R;});
sap.ui.predefine('sap/ui/core/routing/Target',['sap/ui/core/Control','sap/ui/base/EventProvider','sap/ui/core/mvc/View','sap/ui/core/routing/async/Target','sap/ui/core/routing/sync/Target',"sap/base/util/UriParameters","sap/base/Log"],function(C,E,V,a,s,U,L){"use strict";
var T=C.extend("sap.ui.core.routing.Target.TitleProvider",{
metadata:{library:"sap.ui.core",properties:{title:{type:"string",group:"Data",defaultValue:null}}},
constructor:function(S){this._oTarget=S.target;delete S.target;C.prototype.constructor.call(this,S);},
setTitle:function(t){this.setProperty("title",t,true);if(this._oTarget._bIsDisplayed&&t){this._oTarget.fireTitleChanged({name:this._oTarget._oOptions._name,title:t});}}
});
var b=E.extend("sap.ui.core.routing.Target",{
constructor:function(o,c){var e;function d(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Target");return true;}return false;}if(o._async===undefined){o._async=d();}if(o.type==="Component"&&!o._async){e="sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async";L.error(e);throw new Error(e);}this._updateOptions(o);this._oCache=c;E.apply(this,arguments);if(this._oOptions.title){this._oTitleProvider=new T({target:this});}var f=this._oOptions._async?a:s;for(var g in f){this[g]=f[g];}this._bIsDisplayed=false;this._bIsLoaded=false;},
destroy:function(){this._oParent=null;this._oOptions=null;this._oCache=null;if(this._oTitleProvider){this._oTitleProvider.destroy();}this._oTitleProvider=null;E.prototype.destroy.apply(this,arguments);this.bIsDestroyed=true;return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(p){var t=this._oTitleProvider&&this._oTitleProvider.getTitle();if(t){this.fireTitleChanged({name:this._oOptions._name,title:t});}this._bIsDisplayed=true;return this.fireEvent(this.M_EVENTS.DISPLAY,p);},
attachTitleChanged:function(d,f,l){var h=this.hasListeners("titleChanged"),t=this._oTitleProvider&&this._oTitleProvider.getTitle();this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);if(!h&&t&&this._bIsDisplayed){this.fireTitleChanged({name:this._oOptions._name,title:t});}return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(p){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,p);},
_getEffectiveObjectName:function(n){var p=this._oOptions.path;if(p){n=p+"."+n;}return n;},
_updateOptions:function(o){if(o.viewName){if(o.name){o._name=o.name;}o.type="View";o.name=o.viewName;if(o.viewPath){o.path=o.viewPath;}if(o.viewId){o.id=o.viewId;}}this._oOptions=o;},
_bindTitleInTitleProvider:function(v){if(this._oTitleProvider&&v instanceof V){this._oTitleProvider.applySettings({title:this._oOptions.title},v.getController());}},
_addTitleProviderAsDependent:function(v){if(!this._oTitleProvider){return;}var o=this._oTitleProvider.getParent();if(o){o.removeDependent(this._oTitleProvider);}if(v instanceof V){v.addDependent(this._oTitleProvider);}},
_beforePlacingViewIntoContainer:function(A){},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/TargetCache',['sap/ui/base/EventProvider','sap/ui/core/routing/async/TargetCache','sap/ui/core/routing/sync/TargetCache',"sap/base/assert","sap/base/Log"],function(E,a,s,b,L){"use strict";
var T=E.extend("sap.ui.core.routing.TargetCache",{
constructor:function(o){if(!o){o={};}this._oCache={view:{},component:{}};this._oComponent=o.component;if(this._oComponent){b(this._oComponent.isA("sap.ui.core.UIComponent"),this+' - the component passed to the constructor needs to be an instance of UIComponent');}E.apply(this,arguments);this.async=o.async;if(this.async===undefined){this.async=true;}var C=this.async?a:s;for(var f in C){this[f]=C[f];}},
metadata:{publicMethods:["get","set"]},
get:function(o,t){var O;try{if(t==="Component"&&!this.async){L.error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async");throw new Error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async");}if(!o){L.error("the oOptions parameter of getObject is mandatory",this);throw new Error("the oOptions parameter of getObject is mandatory");}O=this._get(o,t);}catch(e){return Promise.reject(e);}if(O instanceof Promise){return O;}else if(O.isA("sap.ui.core.mvc.View")){return O.loaded();}else{return Promise.resolve(O);}},
fetch:function(o,t){return this._get(o,t,undefined,undefined,true);},
set:function(n,t,o){var i;this._checkName(n,t);b(t==="View"||t==="Component","sType must be either 'View' or 'Component'");i=this._oCache[t.toLowerCase()][n];if(!i){i=this._oCache[t.toLowerCase()][n]={};}i[undefined]=o;return this;},
destroy:function(){E.prototype.destroy.apply(this);if(this.bIsDestroyed){return this;}function d(o){if(o&&o.destroy&&!o._bIsBeingDestroyed){o.destroy();}}Object.keys(this._oCache).forEach(function(t){var o=this._oCache[t];Object.keys(o).forEach(function(k){var i=o[k];Object.keys(i).forEach(function(I){var O=i[I];if(O instanceof Promise){O.then(d);}else{d(O);}});});}.bind(this));this._oCache=undefined;this.bIsDestroyed=true;return this;},
attachCreated:function(d,f,l){return this.attachEvent("created",d,f,l);},
detachCreated:function(f,l){return this.detachEvent("created",f,l);},
fireCreated:function(p){return this.fireEvent("created",p);},
_get:function(o,t,g,i,n){var O;switch(t){case"View":O=this._getView(o,g,n);break;case"Component":O=this._getComponent(o,g,i,n);break;default:throw Error("The given sType: "+t+" isn't supported by TargetCache.getObject");}return O;},
_getView:function(o,g,n){if(!g){o=this._createId(o);}return this._getViewWithGlobalId(o,false,n);},
_getComponent:function(o,g,i,n){if(!g){o=this._createId(o);}return this._getComponentWithGlobalId(o,i,n);},
_createId:function(o){if(this._oComponent&&o.id){o=Object.assign({},o,{id:this._oComponent.createId(o.id)});}return o;},
_checkName:function(n,t){if(!n){var m="A name for the "+t.toLowerCase()+" has to be defined";L.error(m,this);throw Error(m);}}
});
return T;});
sap.ui.predefine('sap/ui/core/routing/Targets',['sap/ui/base/EventProvider','./Target','./async/Targets','./sync/Targets',"sap/base/util/UriParameters","sap/base/Log","sap/base/util/deepExtend"],function(E,T,a,s,U,L,d){"use strict";
var b=E.extend("sap.ui.core.routing.Targets",{
constructor:function(o){var t,c;E.apply(this);this._mTargets={};this._oLastTitleTarget={};this._oConfig=o.config;this._oCache=o.cache||o.views;if(!this._oConfig){this._oConfig={_async:false};}function e(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true;}return false;}if(this._oConfig._async===undefined){this._oConfig._async=(this._oConfig.async===undefined)?e():this._oConfig.async;}var f=this._oConfig._async?a:s;for(var g in f){this[g]=f[g];}for(t in o.targets){if(o.targets.hasOwnProperty(t)){this._createTarget(t,o.targets[t]);}}for(c in this._mTargets){if(this._mTargets.hasOwnProperty(c)){this._addParentTo(this._mTargets[c]);}}},
_setRouter:function(r){if(!this._oRouter){this._oRouter=r;}else{L.warning("The Targets is already connected with a router and this call of _setRouter is ignored");}return this;},
destroy:function(){var t;E.prototype.destroy.apply(this);for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){this._mTargets[t].destroy();}}this._mTargets=null;this._oCache=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getViews:function(){return this._oCache;},
getCache:function(){return this._oCache;},
getTarget:function(n,S){var t=this,c=this._alignTargetsInfo(n),e;e=c.reduce(function(A,C){var o=t._mTargets[C.name];if(o){A.push(o);}else if(!S){L.error("The target you tried to get \""+C.name+"\" does not exist!",t);}return A;},[]);return e.length<=1?e[0]:e;},
addTarget:function(n,t){var o=this.getTarget(n,true),c;if(o){L.error("Target with name "+n+" already exists",this);}else{c=this._createTarget(n,t);this._addParentTo(c);}return this;},
suspend:function(t){var c=this._alignTargetsInfo(t);c.forEach(function(o){var e=o.name;var f=this.getTarget(e);if(f){f.suspend();}}.bind(this));return this;},
resume:function(t){var c=this._alignTargetsInfo(t);c.forEach(function(o){var e=o.name;var f=this.getTarget(e);if(f){f.resume();}}.bind(this));return this;},
attachDisplay:function(D,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,D,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(p){return this.fireEvent(this.M_EVENTS.DISPLAY,p);},
attachTitleChanged:function(D,f,l){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,D,f,l);return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(p){if(this._oLastTitleTarget.name!==p.name||this._oLastTitleTarget.title!==p.title){this._oLastTitleTarget.name=p.name;this._oLastTitleTarget.title=p.title;this.fireEvent(this.M_EVENTS.TITLE_CHANGED,p);}return this;},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},
_alignTargetsInfo:function(t){if(t===undefined){return[];}if(!Array.isArray(t)){return(typeof t==="object")?[t]:[{name:t}];}return t.map(function(v){if(typeof v!=="object"){v={name:v};}return v;});},
_createTarget:function(n,t){var o,O,D={_name:n};if(this._vRootViewId){D.rootView=this._vRootViewId;}O=d(D,this._oConfig,t);o=this._constructTarget(O);o.attachDisplay(function(e){var p=e.getParameters();this.fireDisplay({name:n,view:p.view,object:p.object,control:p.control,config:p.config,data:p.data,routeRelevant:p.routeRelevant});},this);this._mTargets[n]=o;return o;},
_addParentTo:function(t){var p,P=t._oOptions.parent;if(!P){return;}p=this._mTargets[P];if(!p){L.error("The target '"+t._oOptions._name+" has a parent '"+P+"' defined, but it was not found in the other targets",this);return;}t._oParent=p;},
_constructTarget:function(o,p){return new T(o,this._oCache,p);},
_setRootViewId:function(i){var t,o;for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){o=this._mTargets[t]._oOptions;if(o.rootView===undefined){o.rootView=i;}}}this._vRootViewId=i;},
_getTitleTargetName:function(t,p){var o,c;if(p){t=[p];}t=this._alignTargetsInfo(t);t.some(function(e){o=this.getTarget(e);while(o&&!o._oOptions.title){o=o._oParent;}if(o){c=o._oOptions._name;return true;}}.bind(this));return c;},
_forwardTitleChanged:function(e){this.fireTitleChanged({name:e.getParameter("name"),title:e.getParameter("title")});},
_attachTitleChanged:function(t,c){var o,C;C=this._getTitleTargetName(t,c);if(C){o=this.getTarget(C);}if(this._oLastDisplayedTitleTarget){this._oLastDisplayedTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget._bIsDisplayed=false;}if(o){o.attachTitleChanged({name:o._oOptions._name},this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget=o;}else if(c){L.error("The target with the name \""+c+"\" where the titleChanged event should be fired does not exist!",this);}}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/Views',["./TargetCache","sap/base/util/UriParameters","sap/base/Log"],function(T,U,L){"use strict";
var V=T.extend("sap.ui.core.routing.Views",{
metadata:{publicMethods:["getView","setView"]},
constructor:function(o){if(!o){o={};}function c(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","TargetCache");return true;}return false;}if(o.async===undefined){o.async=c();}T.apply(this,[o]);},
getView:function(o){return this.get(o,"View");},
setView:function(v,o){return this.set(v,"View",o);},
fireCreated:function(p){if(p){p.view=p.object;p.viewOptions=p.options;}return this.fireEvent("created",p);}
});
return V;});
sap.ui.predefine('sap/ui/core/routing/async/Route',["sap/base/Log","sap/base/util/extend","sap/ui/core/Component"],function(L,e,C){"use strict";return{_routeMatched:function(a,s,n){var r=this._oRouter,t,T,c,E,v=null,o=null,i,b,d,A,R=(r._oMatchedRoute===this);r._stopWaitingTitleChangedFromChild();if(r._oMatchedRoute){delete r._oMatchedRoute._oConfig.dynamicTarget;}r._oMatchedRoute=this;r._bMatchingProcessStarted=true;c=e({},r._oConfig,this._oConfig);T=r.getTargets();var f;if(T){f=T._getTitleTargetName(c.target,c.titleTarget);if(f&&r._oPreviousTitleChangedRoute!==this){r._bFireTitleChanged=true;if((r._oOwner&&r._oOwner._bRoutingPropagateTitle)){var p=C.getOwnerComponentFor(r._oOwner);var P=p&&p.getRouter();if(P){P._waitForTitleChangedOn(r);}}}else{r._bFireTitleChanged=false;}if(this._oConfig.target){A=T._alignTargetsInfo(this._oConfig.target);A.forEach(function(t){t.propagateTitle=t.hasOwnProperty("propagateTitle")?t.propagateTitle:r._oConfig.propagateTitle;t.routeRelevant=true;t.repeatedRoute=R;});}}else{A=this._oConfig.target;}if(!s||s===true){i=true;s=Promise.resolve();}if(this._oParent){s=this._oParent._routeMatched(a,s);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,s,this);}b=Object.assign({},a);b.routeConfig=c;E={name:c.name,arguments:a,config:c};if(n){E.nestedRoute=n;}this.fireBeforeMatched(E);r.fireBeforeRouteMatched(E);if(this._oTarget){t=this._oTarget;t._updateOptions(this._convertToTargetOptions(c));s=t._place(s,{legacy:true});if(this._oRouter._oTargetHandler&&this._oRouter._oTargetHandler._chainNavigation){d=s;s=this._oRouter._oTargetHandler._chainNavigation(function(){return d;});}}else{s=r._oTargets._display(A,b,this._oConfig.titleTarget,s);}return s.then(function(g){r._bMatchingProcessStarted=false;var h,V,j;if(Array.isArray(g)){h=g;g=h[0];}g=g||{};v=g.view;o=g.control;E.view=v;E.targetControl=o;if(h){V=[];j=[];h.forEach(function(g){V.push(g.view);j.push(g.control);});E.views=V;E.targetControls=j;}if(c.callback){c.callback(this,a,c,o,v);}this.fireEvent("matched",E);r.fireRouteMatched(E);if(i){L.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",E);r.fireRoutePatternMatched(E);}return g;}.bind(this));}};});
sap.ui.predefine('sap/ui/core/routing/async/Target',["sap/base/Log","sap/ui/base/ManagedObjectMetadata","sap/ui/core/ComponentContainer","sap/ui/core/Placeholder","sap/ui/core/library"],function(L,M,C,P,c){"use strict";var a=c.ComponentLifecycle;return{display:function(d){var s=Promise.resolve();return this._display(d,s);},_display:function(d,s,t){if(this._oParent){s=this._oParent._display(d,s,Object.assign({},t));}return this._place(d,s,t);},suspend:function(){if(this._oParent){this._oParent.suspend();}if(this._isLoaded()){var o=this._get(),r;if(o.isA("sap.ui.core.UIComponent")&&(r=o.getRouter())&&o.hasNativeRouter()){r.stop();}}else{L.warning("The target with name '"+this._oOptions._name+"' can't be suspended because it's being loaded or not loaded yet");}return this;},resume:function(){if(this._oParent){this._oParent.resume();}if(this._isLoaded()){var o=this._get(),r;if(o.isA("sap.ui.core.UIComponent")&&(r=o.getRouter())&&o.hasNativeRouter()){r.initialize(true);}}return this;},_isLoaded:function(){return this._bIsLoaded;},_getCreateOptions:function(t){var n=this._getEffectiveObjectName(this._oOptions.name),o=this._oOptions,b;t=t||{};switch(o.type){case"View":b={name:n,type:o.viewType,id:o.id,async:true};break;case"Component":b={id:o.id};if(o.usage){b.usage=o.usage;}else{b.name=n;}b=Object.assign({},o.options||{},b);break;default:throw new Error("The given type "+o.type+" isn't support by sap.ui.core.routing.Target");}return b;},_get:function(t){var o=this._getCreateOptions(t);return this._oCache._get(o,this._oOptions.type,this._bUseRawViewId,t);},_load:function(t){var o=this._get(t),p;if(!(o instanceof Promise)){if(o.isA("sap.ui.core.mvc.View")){p=o.loaded();}else{p=Promise.resolve(o);}}else{p=o;}return p.then(function(o){this._bIsLoaded=true;return o;}.bind(this));},load:function(t){return this._load(t).then(function(l){return{object:l,nestedComponentReady:this.waitForComponentTarget({target:l,createInfo:t})};}.bind(this));},waitForComponentTarget:function(t){return new Promise(function(r,b){var l=t.target;var T=t.createInfo;var i=true;if(l.isA("sap.ui.core.UIComponent")){var R=l.getRouter();if(R&&l.hasNativeRouter()){var h=R.getHashChanger().getHash();var o=R.getRouteByHash(h);var I=T&&T.ignoreInitialHash;if(!R._oConfig.async){throw new Error("The router of component '"+l.getId()+"' which is loaded via the target '"+this._oOptions._name+"' is defined as synchronous which is not supported using as a nested component.");}if(R._oOwner&&T){R._oOwner._bRoutingPropagateTitle=T.propagateTitle;}if(!I&&(!R.isInitialized()||R._bMatchingProcessStarted)&&o&&o._oConfig.target){i=false;R.attachRouteMatched(r);}if(R.isStopped()){R.initialize(I);}}}if(i){r();}}.bind(this));},resolveContainerControl:function(p){return Promise.resolve().then(function(){p=p||{};var o=this._oOptions;var v=this._isValid(p);var e;if(v!==true){e=v;return this._refuseInvalidTarget(o._name,e);}var V=p.view,b=p.control,d,f;if(V&&V.isA("sap.ui.core.ComponentContainer")){V=V.getComponentInstance().getRootControl();}if(!V&&o.rootView){d=Promise.resolve(o.rootView).then(function(r){var g;if(r){g=sap.ui.getCore().byId(r);o.rootView=r;}if(!g){e="Did not find the root view with the id "+o.rootView;return this._refuseInvalidTarget(o._name,e);}else{return g;}}.bind(this));}else{d=Promise.resolve(V);}d=d.then(function(g){if(g&&g.isA("sap.ui.core.mvc.View")){return g.loaded();}else{return g;}});if(o.controlId){f=d.then(function(g){var h;if(g){h=g.byId(o.controlId);}if(!h){h=sap.ui.getCore().byId(o.controlId);}return h;});}else{f=Promise.resolve(b);}return f.then(function(g){if(!g){e="Control with ID "+o.controlId+" could not be found";return this._refuseInvalidTarget(o._name,e);}else{return g;}}.bind(this));}.bind(this));},displayPlaceholder:function(t,o){var O,b=this._oOptions,i=b.type==="Component",h=false,p=t.placeholder||b.placeholder||{},d=Promise.resolve();if(P.hasProviders()){Object.assign(p,P.getPlaceholderFromProviders({name:b.name,type:b.type}));}if(Object.keys(p).length>0){if(p.autoClose===undefined){p.autoClose=true;}h=true;}if(i){var e=this._oCache._oComponent;var s=t.componentId+"-container";O=(e&&e.byId(s))||sap.ui.getCore().byId(s);if(!O){var f=Object.assign({height:"100%",width:"100%",lifecycle:a.Application},b.containerOptions);if(e){e.runAsOwner(function(){O=new C(e.createId(s),f);});}else{O=new C(s,f);}}if(h){p.container=O;}}if(h&&o.isA("sap.ui.core.IPlaceholderSupport")){p.container=o;}if(p.container&&!t.repeatedRoute){p.aggregation=this._oOptions.controlAggregation;var g=this._getCreateOptions(t);var j=this._oCache.fetch(g,this._oOptions.type);if(j&&i){p.object=O;}else{p.object=j;}if(p.html){p.placeholder=new P({html:p.html});}if(p.placeholder&&sap.ui.getCore().getConfiguration().getPlaceholder()){d=this.showPlaceholder(p);}}return d.then(function(k){return{containerControl:o,object:O,placeholderConfig:p,placeholderShown:!!k};});},_place:function(d,s,t){var o=this._oOptions,b=this,e,i=o.type==="Component";var p,f;if(d instanceof Promise){t=s;s=d;d=undefined;}t=t||{};if(i){t.componentId=o.id||M.uid("uicomponent");}if((o.name||o.usage)&&o.type){p=this.load(t);if(this._oParent||t.legacy){f=s.then(this.resolveContainerControl.bind(this));}else{f=this.resolveContainerControl();}f=f.then(this.displayPlaceholder.bind(this,t));s=Promise.all([p,f,s]).then(function(A){var O=A[0].object,v=A[1],V,r;v.nestedComponentReady=A[0].nestedComponentReady;if(i){var g=O.destroy;O.destroy=function(){if(g){g.apply(this);}v.object.destroy();};v.object.setComponent(O);r=O.getRootControl();if(r&&r.isA("sap.ui.core.mvc.View")){V=r;}}else{v.object=O;V=O;}b._bindTitleInTitleProvider(V);b._addTitleProviderAsDependent(V);return v;}).then(function(v){var g=v.containerControl,O=v.object;b._beforePlacingViewIntoContainer({container:g,view:O,data:d});var A=g.getMetadata().getJSONKeys()[o.controlAggregation];if(!A){e="Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation;return b._refuseInvalidTarget(o._name,e);}if(o.clearControlAggregation===true){g[A._sRemoveAllMutator]();}L.info("Did place the "+o.type.toLowerCase()+" target '"+(o.name?b._getEffectiveObjectName(o.name):o.usage)+"' with the id '"+O.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+g.getId()+"'",b);g[A._sMutator](O);return{name:o._name,view:O,control:g,nestedComponentReady:v.nestedComponentReady,placeholderConfig:v.placeholderConfig,placeholderShown:v.placeholderShown};});}else{s=s.then(function(){return{name:o._name};});}return s.then(function(g){var h=g.nestedComponentReady||Promise.resolve();return h.then(function(){var j=g.control,O=g.view,k=g.placeholderConfig;if(j&&O){b.fireDisplay({view:O.isA("sap.ui.core.mvc.View")?O:undefined,object:O,control:j,config:b._oOptions,data:d,routeRelevant:t.routeRelevant});}if(k&&k.container&&k.autoClose&&b.hidePlaceholder){b.hidePlaceholder(k);}return g;});});},showPlaceholder:function(s){if(s.container&&s.container.showPlaceholder){return s.container.showPlaceholder(s);}else{return Promise.resolve();}},hidePlaceholder:function(s){if(s.container.hidePlaceholder){s.container.hidePlaceholder();}},_isValid:function(p){var o=this._oOptions,b=p&&p.control,h=(b||o.controlId),i=true,l="";if(!h){l="The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){l="The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(l){L.error(l,this);}return i||l;},_refuseInvalidTarget:function(n,m){return Promise.reject(new Error(m+" - Target: "+n));}};});
sap.ui.predefine('sap/ui/core/routing/async/TargetCache',["sap/ui/core/mvc/View","sap/ui/core/Component","sap/ui/core/routing/HashChanger"],function(V,C,H){"use strict";return{_getObjectWithGlobalId:function(o,t,T,s,n){var a=this,p,N,i,O=this._oComponent,w=[];T=T||{};function c(){switch(t){case"View":o.viewName=o.name;delete o.name;return(!o.async||s)?V._create(o):V.create(o);case"Component":o.settings=o.settings||{};o.settings._propagateTitle=T.propagateTitle;var r=a._createRouterHashChanger(T.prefix);if(r){o.settings._routerHashChanger=r;}o.id=o.id||T.componentId;if(o.usage){return O.createComponent(o);}else{return C.create(o);}default:}}function b(d){if(a._oCache){w.forEach(function(I){i[I]=d;});if(T.afterCreate){T.afterCreate(d);}a.fireCreated({object:d,type:t,options:o});}return d;}if(o.async===undefined){o.async=true;}N=o.usage||o.name;this._checkName(N,t);i=this._oCache[t.toLowerCase()][N];p=i&&i[o.id];if(n||p){return p;}if(O){p=O.runAsOwner(c);}else{p=c();}if(p instanceof Promise){p=p.then(b);}else{p.loaded().then(b);}if(!i){i=this._oCache[t.toLowerCase()][N]={};i[undefined]=p;w.push(undefined);}if(o.id!==undefined){i[o.id]=p;w.push(o.id);}return p;},_getViewWithGlobalId:function(o,s,n){if(o&&!o.name){o.name=o.viewName;}return this._getObjectWithGlobalId(o,"View",undefined,s,n);},_getComponentWithGlobalId:function(o,t,n){return this._getObjectWithGlobalId(o,"Component",t,n);},_createRouterHashChanger:function(p){var r;var R=this._oComponent&&this._oComponent.getRouter();if(R){r=R.getHashChanger();if(r&&p){r=r.createSubHashChanger(p);}}return r||H.getInstance().createRouterHashChanger();}};});
sap.ui.predefine('sap/ui/core/routing/async/Targets',["sap/base/Log"],function(L){"use strict";return{display:function(t,d,T){var s=Promise.resolve();return this._display(t,d,T,s);},_display:function(t,d,T,s){var a=this,v=[];if(!Array.isArray(t)){t=[t];}this._attachTitleChanged(t,T);return this._alignTargetsInfo(t).reduce(function(p,o){var b={prefix:o.prefix,propagateTitle:o.propagateTitle||false,ignoreInitialHash:o.ignoreInitialHash,placeholder:o.placeholder,repeatedRoute:o.repeatedRoute,routeRelevant:o.routeRelevant||false};return a._displaySingleTarget(o,d,p,b).then(function(V){V=V||{};V.targetInfo=o;v.push(V);});},s).then(function(){return v;});},_addDynamicTargetToRoute:function(t){if(this._oRouter){var r=this._oRouter._getLastMatchedRouteName();var R,s;if(r){R=this._oRouter.getRoute(r);if(R&&R._oConfig&&R._oConfig.target){s=this._alignTargetsInfo(R._oConfig.target).some(function(c){return c.name===t.name;});if(!s){R._oConfig.dynamicTarget=R._oConfig.dynamicTarget||[];R._oConfig.dynamicTarget.push(t);}}}}},_displaySingleTarget:function(t,d,s,T){var n=t.name,o=this.getTarget(n);if(o!==undefined){if(t.routeRelevant){this._addDynamicTargetToRoute(t);}return o._display(d,s,T);}else{var e="The target with the name \""+n+"\" does not exist!";L.error(e,this);return Promise.resolve({name:n,error:e});}}};});
sap.ui.predefine('sap/ui/core/routing/sync/Route',["sap/base/Log","sap/base/util/extend"],function(L,e){"use strict";return{_routeMatched:function(a,i,n){var r=this._oRouter,p,P,t,c,E,v=null,T=null,o,C,V,b,d;r._oMatchedRoute=this;r._bMatchingProcessStarted=true;if(this._oParent){p=this._oParent._routeMatched(a);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,false,this);}c=e({},r._oConfig,this._oConfig);o=Object.assign({},a);o.routeConfig=c;E={name:c.name,arguments:a,config:c};if(n){E.nestedRoute=n;}this.fireBeforeMatched(E);r.fireBeforeRouteMatched(E);if(this._oTarget){t=this._oTarget;t._updateOptions(this._convertToTargetOptions(c));if(t._isValid(p,false)){P=t._place(p);}P=P||{};v=P.oTargetParent;T=P.oTargetControl;E.view=v;E.targetControl=T;}else{V=[];b=[];C=function(f){V.push(f.getParameter("view"));b.push(f.getParameter("control"));};if(Array.isArray(this._oConfig.target)){d=this._oConfig.target;}else{d=[this._oConfig.target];}d.forEach(function(s){var t=r._oTargets.getTarget(s);if(t){t.attachEventOnce("display",C);}});r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget);E.view=V[0];E.targetControl=b[0];E.views=V;E.targetControls=b;}r._bMatchingProcessStarted=false;if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",E);r.fireRouteMatched(E);if(i){L.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",E);r.fireRoutePatternMatched(E);}return P;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Target',["sap/base/Log"],function(L){"use strict";return{display:function(d){var p;if(this._oParent){p=this._oParent.display(d);}return this._place(p,d);},suspend:function(){return this;},resume:function(){return this;},_place:function(p,d){var o=this._oOptions;p=p||{};var v,c=p.oTargetControl,V=p.oTargetParent;if(!this._isValid(p,true)){return undefined;}if(!V&&o.rootView){V=sap.ui.getCore().byId(o.rootView);if(!V){L.error("Did not find the root view with the id "+o.rootView,this);return undefined;}}if(o.controlId){if(V){c=V.byId(o.controlId);}if(!c){c=sap.ui.getCore().byId(o.controlId);}if(!c){L.error("Control with ID "+o.controlId+" could not be found",this);return undefined;}}var a=c.getMetadata().getJSONKeys()[o.controlAggregation];if(!a){L.error("Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation,this);return undefined;}var s=this._getEffectiveObjectName(o.viewName);var b={name:s,type:o.viewType,id:o.viewId};v=this._oCache._get(b,"View",this._bUseRawViewId);this._beforePlacingViewIntoContainer({container:c,view:v,data:d});this._bindTitleInTitleProvider(v);this._addTitleProviderAsDependent(v);if(o.clearControlAggregation===true){c[a._sRemoveAllMutator]();}L.info("Did place the view '"+s+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+c.getId()+"'",this);c[a._sMutator](v);this.fireDisplay({view:v,control:c,config:this._oOptions,data:d});return{oTargetParent:v,oTargetControl:c};},_isValid:function(p,l){var o=this._oOptions,c=p&&p.oTargetControl,h=(c||o.controlId),i=true,s="";if(!h){s="The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){s="The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(!o.viewName){s="The target "+o._name+" no viewName defined.";i=false;}if(l&&s){L.error(s,this);}return i;}};});
sap.ui.predefine('sap/ui/core/routing/sync/TargetCache',["sap/ui/core/mvc/View"],function(V){"use strict";return{_getObjectWithGlobalId:function(o){function c(){o.viewName=o.name;delete o.name;return V._create(o);}var v,s=o.name,i;this._checkName(s,"View");i=this._oCache.view[s];v=i&&i[o.id];if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}i=this._oCache.view[s];if(!i){i=this._oCache.view[s]={};i[undefined]=v;}if(o.id!==undefined){i[o.id]=v;}this.fireCreated({object:v,type:"View",options:o});return v;},_getViewWithGlobalId:function(o){if(o&&!o.name){o.name=o.viewName;}return this._getObjectWithGlobalId(o);}};});
sap.ui.predefine('sap/ui/core/routing/sync/Targets',["sap/base/Log"],function(L){"use strict";return{display:function(t,d,T){this._display(t,d,T);},_display:function(t,d,T){var a=this;this._attachTitleChanged(t,T);if(Array.isArray(t)){t.forEach(function(s){a._displaySingleTarget(s,d);});}else{this._displaySingleTarget(t,d);}return this;},_displaySingleTarget:function(n,d){var t=this.getTarget(n);if(t!==undefined){t.display(d);}else{L.error("The target with the name \""+n+"\" does not exist!",this);}}};});
sap.ui.predefine('sap/ui/core/search/OpenSearchProvider',['./SearchProvider',"sap/base/Log","sap/base/security/encodeURL","sap/ui/thirdparty/jquery",'sap/ui/core/library'],function(S,L,e,q){"use strict";
var O=S.extend("sap.ui.core.search.OpenSearchProvider",{metadata:{library:"sap.ui.core",properties:{suggestUrl:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},suggestType:{type:"string",group:"Misc",defaultValue:'json'}}}});
O.prototype.suggest=function(v,c){var u=this.getSuggestUrl();if(!u){return;}u=u.replace("{searchTerms}",e(v));var t=this.getSuggestType();var s;if(t&&t.toLowerCase()==="xml"){t="xml";s=function(d){var x=q(d);var i=x.find("Text");var a=[];i.each(function(){a.push(q(this).text());});c(v,a);};}else{t="json";s=function(d){c(v,d[1]);};}q.ajax({url:u,dataType:t,success:s,error:function(X,a,b){L.fatal("The following problem occurred: "+a,X.responseText+","+X.status);}});};
return O;});
sap.ui.predefine('sap/ui/core/search/SearchProvider',['sap/ui/core/Element',"sap/base/Log",'sap/ui/core/library'],function(E,L){"use strict";
var S=E.extend("sap.ui.core.search.SearchProvider",{metadata:{"abstract":true,library:"sap.ui.core",properties:{icon:{type:"string",group:"Misc",defaultValue:null}}}});
S.prototype.suggest=function(v,c){L.warning("sap.ui.core.search.SearchProvider is the abstract base class for all SearchProviders. Do not create instances of this class, but use a concrete sub class instead.");};
return S;});
sap.ui.predefine('sap/ui/core/service/Service',['sap/ui/base/Object',"sap/base/assert","sap/base/Log"],function(B,a,L){"use strict";
var S=B.extend("sap.ui.core.service.Service",{
metadata:{"abstract":true,"library":"sap.ui.core"},
constructor:function(s){B.apply(this);if(s){a(typeof s.scopeObject==="object","The service context requires a scope object!");a(typeof s.scopeType==="string","The service context requires a scope type!");}this._oServiceContext=s;if(typeof this.init==="function"){this.init();}}
});
S.create=function(s){var A=function A(o){for(var m in s){if(!m.match(/^(metadata|constructor|getContext|destroy)$/)){this[m]=s[m];}else{L.warning("The member "+m+" is not allowed for anonymous service declaration and will be ignored!");}}S.apply(this,arguments);};A.prototype=Object.create(S.prototype);return A;};
S.prototype.getInterface=function(){var p=Object.create(null);for(var m in this){if(!m.match(/^_|^metadata$|^constructor$|^getInterface$|^destroy$|^init$|^exit$|^getContext$/)&&typeof this[m]==="function"){p[m]=this[m].bind(this);}}this.getInterface=function(){return p;};return p;};
S.prototype.getContext=function(){return this._oServiceContext;};
S.prototype.destroy=function(){if(typeof this.exit==="function"){this.exit();}B.prototype.destroy.apply(this,arguments);delete this._oServiceContext;};
return S;});
sap.ui.predefine('sap/ui/core/service/ServiceFactory',['sap/ui/base/Object','sap/ui/core/service/Service',"sap/base/assert"],function(B,S,a){"use strict";
var b=B.extend("sap.ui.core.service.ServiceFactory",{
metadata:{"library":"sap.ui.core"},
constructor:function(s){B.apply(this);var f=typeof s==="object"?S.create(s):s;a(!f||f&&typeof f==="function","The service constructor either should be undefined or a constructor function!");this._fnService=f;}
});
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._fnService;};
b.prototype.createInstance=function(s){if(typeof this._fnService==="function"){return Promise.resolve(new this._fnService(s));}else{return Promise.reject(new Error("Usage of sap.ui.core.service.ServiceFactory requires a service constructor function to create a new service instance or to override the createInstance function!"));}};
return b;});
sap.ui.predefine('sap/ui/core/service/ServiceFactoryRegistry',['./ServiceFactory',"sap/base/assert"],function(S,a){"use strict";var s=Object.create(null);var b=Object.create(null);
b.register=function(c,o){a(c,"sServiceFactoryName must not be empty, null or undefined");a(o instanceof S,"oServiceFactory must be an instance of sap.ui.core.service.ServiceFactory");s[c]=o;return this;};
b.unregister=function(c){a(c,"sServiceFactoryName must not be empty, null or undefined");delete s[c];return this;};
b.get=function(c){return s[c];};
return b;},true);
sap.ui.predefine('sap/ui/core/syncStyleClass',['sap/ui/thirdparty/jquery','sap/ui/base/Object','sap/base/assert'],function(q,B,a){"use strict";var s=function(S,v,d){if(!S){return d;}if(B.isA(v,'sap.ui.core.Control')){v=v.$();}else if(typeof v==="string"){v=q(document.getElementById(v));}else if(!(v instanceof q)){a(false,'sap/ui/core/syncStyleClass(): vSource must be a jQuery object or a Control or a string');return d;}var c=!!v.closest("."+S).length;if(d instanceof q){d.toggleClass(S,c);}else if(B.isA(d,'sap.ui.core.Control')){d.toggleStyleClass(S,c);}else{a(false,'sap/ui/core/syncStyleClass(): vDestination must be a jQuery object or a Control');}return d;};return s;});
sap.ui.predefine('sap/ui/core/theming/Parameters',['sap/ui/thirdparty/URI','../Element','sap/base/util/UriParameters','sap/base/Log','sap/base/util/extend','sap/ui/core/ThemeCheck','sap/ui/thirdparty/jquery','./ThemeHelper'],function(U,E,a,L,e,T,q,b){"use strict";var c=window["sap-ui-config"]||{};var s=0;if(c['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(c['xx-nosync']===true||c['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var P={};var p=null;var t=null;var d=[];var C=[];var B=new U(sap.ui.require.toUrl(""),document.baseURI).origin();var o={};var r=/url[\s]*\('?"?([^\'")]*)'?"?\)/;var u=a.fromQuery(window.location.search).get("sap-ui-xx-no-inline-theming-parameters")!=="true";
function f(i,j){var M=r.exec(i);if(M){var D=new U(M[1]);if(D.is("relative")){var N=D.absoluteTo(j).normalize().toString();i="url('"+N+"')";}}return i;}
function m(i,N,j){for(var D in N){if(typeof i[D]==="undefined"){i[D]=f(N[D],j);}}return i;}
function g(N,i){if(typeof N["default"]!=="object"){N={"default":N,"scopes":{}};}p=p||{};p["default"]=p["default"]||{};p["scopes"]=p["scopes"]||{};m(p["default"],N["default"],i);if(typeof N["scopes"]==="object"){for(var S in N["scopes"]){p["scopes"][S]=p["scopes"][S]||{};m(p["scopes"][S],N["scopes"][S],i);}}}
function h(i){q("link[id^=sap-ui-theme-]").each(function(){i(this.getAttribute("id"));});}
function k(i){var j=n(i);var D=T.checkStyle(i);if(!D){L.warning("Parameters have been requested but theme is not applied, yet.","sap.ui.core.theming.Parameters");}if(D&&u){var $=q(document.getElementById(i));var F=$.css("background-image");var G=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)$/i.exec(F);if(G&&G.length>=2){var H=G[1];if(H.charAt(0)!=="{"&&H.charAt(H.length-1)!=="}"){try{H=decodeURIComponent(H);}catch(I){L.warning("Could not decode theme parameters URI from "+j.styleSheetUrl);}}try{var J=JSON.parse(H);g(J,j.themeBaseUrl);return true;}catch(I){L.warning("Could not parse theme parameters from "+j.styleSheetUrl+". Loading library-parameters.json as fallback solution.");}}}return false;}
function l(i){var j=n(i);if(!k(i)){var D=j.styleSheetUrl.replace(/\/(?:css_variables|library)([^\/.]*)\.(?:css|less)($|[?#])/,function($,H,I){return"/library-parameters.json"+(I?I:"");});if(s===2){L.error("[nosync] Loading library-parameters.json ignored",D,"sap.ui.core.theming.Parameters");return;}else if(s===1){L.error("[nosync] Loading library-parameters.json with sync XHR",D,"sap.ui.core.theming.Parameters");}var F=new U(j.themeBaseUrl).origin();var W=o[F];var G=[];if(W===undefined){if(D.startsWith(B)){G=[false,true];}else{G=[true,false];}}else{G=[W];}v(D,j.themeBaseUrl,G);}}
function n(i){var j=document.getElementById(i);if(!j){L.warning("Could not find stylesheet element with ID",i,"sap.ui.core.theming.Parameters");return undefined;}var S=j.href;return{themeBaseUrl:new U(S).filename("").query("").toString(),styleSheetUrl:S};}
function v(i,D,W){var F=W.shift();var H=F?{"X-Requested-With":"XMLHttpRequest"}:{};q.ajax({url:i,dataType:'json',async:false,xhrFields:{withCredentials:F},headers:H,success:function(G,I,J){var K=new U(D).origin();o[K]=F;if(Array.isArray(G)){for(var j=0;j<G.length;j++){var M=G[j];g(M,D);}}else{g(G,D);}},error:function(j,G,I){L.error("Could not load theme parameters from: "+i,I);if(W.length>0){L.warning("Initial library-parameters.json request failed ('withCredentials="+F+"'; sUrl: '"+i+"').\n"+"Retrying with 'withCredentials="+!F+"'.","sap.ui.core.theming.Parameters");v(i,D,W);}}});}
function w(i){if(!p){g({},"");h(function(I){if(i){if(T.checkStyle(I)){k(I);}else{d.push(I);}}else{l(I);}});}return p;}
function x(){var i=[];d.forEach(function(I){if(T.checkStyle(I)){k(I);}else{i.push(I);}});d=i;}
function y(){d.forEach(l);d=[];}
P._addLibraryTheme=function(i){if(p){d.push("sap-ui-theme-"+i);}};
function z(O){var i=O.async,j=w(i);if(O.scopeName){j=j["scopes"][O.scopeName];}else{j=j["default"];}var D=j[O.parameterName];if(!D){var I=O.parameterName.indexOf(":");if(I!=-1){var F=O.parameterName.substr(I+1);D=j[F];}}if(O.loadPendingParameters&&typeof D==="undefined"&&!i){y();D=z({parameterName:O.parameterName,scopeName:O.scopeName,loadPendingParameters:false});}return D;}
function A(j,D,F){var S=P.getActiveScopesFor(D,F);var G=S.flat().reduce(function(R,J){if(R.indexOf(J)===-1){R.push(J);}return R;},[]);for(var i=0;i<G.length;i++){var H=G[i];var I=z({parameterName:j,scopeName:H,async:F});if(I){return I;}}return z({parameterName:j,async:F});}
P._getScopes=function(i,j){if(i&&!p){return;}var D=w(j);var S=Object.keys(D["scopes"]);return S;};
P.getActiveScopesFor=function(i,j){var S=[];if(i instanceof E){var D=i.getDomRef();if(j){x();}else{y();}var F=this._getScopes(undefined,j);if(F.length){if(D){var N=function(I){var J=D.classList;return J&&J.contains(I);};while(D){var G=F.filter(N);if(G.length>0){S.push(G);}D=D.parentNode;}}else{var H=function(I){return typeof i.hasStyleClass==="function"&&i.hasStyleClass(I);};while(i){var G=F.filter(H);if(G.length>0){S.push(G);}i=typeof i.getParent==="function"&&i.getParent();}}}}return S;};
P.get=function(N,j){var D,F,G,H,I;var J=function(S){return S.callback===F;};if(!sap.ui.getCore().isInitialized()){L.warning("Called sap.ui.core.theming.Parameters.get() before core has been initialized. "+"Consider using the API only when required, e.g. onBeforeRendering.");}if(!t){t=sap.ui.getCore().getConfiguration().getTheme();}if(arguments.length===0){L.warning("Legacy variant usage of sap.ui.core.theming.Parameters.get API detected. Do not use the Parameters.get() API to retrieve ALL theming parameters, "+"as this will lead to unwanted synchronous requests. "+"Use the asynchronous API variant instead and retrieve a fixed set of parameters.","LegacyParametersGet","sap.ui.support",function(){return{type:"LegacyParametersGet"};});y();var K=w();return Object.assign({},K["default"]);}if(!N){return undefined;}if(N instanceof Object&&!Array.isArray(N)){if(!N.name){L.warning("sap.ui.core.theming.Parameters.get was called with an object argument without one or more parameter names.");return undefined;}j=N.scopeElement;F=N.callback;H=typeof N.name==="string"?[N.name]:N.name;G=true;}else{if(typeof N==="string"){H=[N];}else{H=N;}L.warning("Legacy variant usage of sap.ui.core.theming.Parameters.get API detected for parameter(s): '"+H.join(", ")+"'. This could lead to bad performance and additional synchronous XHRs, as parameters might not be available yet. Use asynchronous variant instead.","LegacyParametersGet","sap.ui.support",function(){return{type:"LegacyParametersGet"};});}var M,R;var O=function(S){if(j instanceof E){return A(S,j,G);}else{if(G){x();}return z({parameterName:S,loadPendingParameters:!G,async:G});}};R={};for(var i=0;i<H.length;i++){D=H[i];var Q=O(D);if(!G||Q){R[D]=Q;}}if(G&&F&&Object.keys(R).length!==H.length){if(!sap.ui.getCore().isThemeApplied()){M=function(){sap.ui.getCore().detachThemeChanged(M);var S=this.get({name:N.name,scopeElement:N.scopeElement});if(!S||(typeof S==="object"&&(Object.keys(S).length!==H.length))){L.error("One or more parameters could not be found.","sap.ui.core.theming.Parameters");}F(S);C.splice(C.findIndex(J),1);}.bind(this);I=C.findIndex(J);if(I>=0){sap.ui.getCore().detachThemeChanged(C[I].eventHandler);C[I].eventHandler=M;}else{C.push({callback:F,eventHandler:M});}sap.ui.getCore().attachThemeChanged(M);return undefined;}else{L.error("One or more parameters could not be found.","sap.ui.core.theming.Parameters");}}return H.length===1?R[H[0]]:R;};
P._setOrLoadParameters=function(i){p={"default":{},"scopes":{}};t=sap.ui.getCore().getConfiguration().getTheme();h(function(I){var j=I.substr(13);if(i[j]){e(p["default"],i[j]);}else{l(I);}});};
P.reset=function(){var O=arguments[0]===true;if(!O||sap.ui.getCore().getConfiguration().getTheme()!==t){t=sap.ui.getCore().getConfiguration().getTheme();d=[];p=null;b.reset();}};
P._getThemeImage=function(i,F){i=i||"sapUiGlobalLogo";var j=P.get(i);if(j){var D=r.exec(j);if(D){j=D[1];}else if(j==="''"||j==="none"){j=null;}}if(F&&!j){return sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');}return j;};
return P;},true);
sap.ui.predefine('sap/ui/core/tmpl/DOMAttribute',['sap/ui/core/Element','sap/ui/core/library'],function(E){"use strict";
var D=E.extend("sap.ui.core.tmpl.DOMAttribute",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
D.prototype.setValue=function(v){this.setProperty("value",v,true);var p=this.getParent(),$=p&&p.$();if($&&$.length>0){$.attr(this.getName(),this.getProperty("value"));}return this;};
return D;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElement',['sap/ui/core/Control','./DOMAttribute',"./DOMElementRenderer","sap/base/Log","sap/ui/thirdparty/jquery",'sap/ui/core/library'],function(C,D,a,L,q){"use strict";
var b=C.extend("sap.ui.core.tmpl.DOMElement",{
metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},tag:{type:"string",group:"Behavior",defaultValue:'span'}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.core.tmpl.DOMAttribute",multiple:true,singularName:"attribute"},elements:{type:"sap.ui.core.tmpl.DOMElement",multiple:true,singularName:"element"}}},
renderer:a
});
b.prototype.applySettings=function(s){var m=this.getMetadata(),j=m.getJSONKeys();if(s){if(!s["attributes"]){var A=s["attributes"]=[];q.each(s,function(k,v){if(k!=="id"&&!j[k]&&typeof v==="string"){A.push(new D({name:k,value:v}));delete s[k];}});}else{L.warning("DOMElement#"+this.getId()+": custom attributes in settings will be ignored since attributes are provided!");}}C.prototype.applySettings.apply(this,arguments);};
b.prototype.exit=b.prototype.onBeforeRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().off("change");}};
b.prototype.onAfterRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().on("change",q.proxy(this.oninputchange,this));}};
b.prototype.oninputchange=function(e){var t=this.getTag().toLowerCase();if(t==="input"){var v=this.$().val();this.getAttributes().forEach(function(A){if(A.getName().toLowerCase()==="value"){A.setValue(v);}});}else if(t==="textarea"){var T=this.$().val();this.setText(T);}else if(t==="select"){var T="";this.$().find("select option:selected").each(function(){T+=q(this).text()+" ";});this.setText(T);}};
b.prototype.attr=function(k,v){var A=this.getAttributes(),o;A.forEach(function(V){var n=V.getName();if(n.toLowerCase()===k){o=V;return false;}});if(v===undefined){return o&&o.getValue();}else{if(o){if(v===null){this.removeAttribute(o);}else{o.setValue(v);}}else{if(v!==null){this.addAttribute(new D({name:k,value:v}));}}return this;}};
b.prototype.removeAttr=function(k){this.attr(k,null);return this;};
b.prototype.setText=function(t){this.setProperty("text",t,true);var $=this.$();if($.length>0){var T=this.getTag().toLowerCase();if(T==="textarea"){$.val(this.getProperty("text"));}else{$.text(this.getProperty("text"));}}return this;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElementRenderer',["sap/base/Log","sap/base/security/encodeXML"],function(L,e){"use strict";var D={apiVersion:2};var r=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/i;
D.render=function(R,E){var s=e(E.getTag()),i=r.test(s);if(i){R.voidStart(s,E);}else{R.openStart(s,E);}E.getAttributes().forEach(function(A){var n=A.getName().toLowerCase();if(n==="class"){var c=A.getValue().split(" ");c.forEach(function(C){var C=C.trim();if(C){R.class(C);}});}else if(n==="style"){var S=A.getValue().split(";");S.forEach(function(b){var I=b.indexOf(":");if(I!=-1){var k=b.substring(0,I).trim();var v=b.substring(I+1).trim();R.style(e(k),v);}});}else if(A.getName()){R.attr(e(A.getName()),A.getValue());}else{L.error("Attributes must have a non-empty name");}});if(i){R.voidEnd();}else{R.openEnd();}var a=E.getElements(),h=!!E.getText()||a.length>0;if(h){if(i){L.error("Void element '"+s+"' is rendered with children");}if(E.getText()){R.text(E.getText());}a.forEach(function(I,c){R.renderControl(c);});}if(!i){R.close(s);}};
return D;},true);
sap.ui.predefine('sap/ui/core/tmpl/HandlebarsTemplate',['./Template','./TemplateControl','sap/ui/thirdparty/handlebars','sap/ui/base/ManagedObject','sap/base/util/ObjectPath',"sap/base/security/encodeXML","sap/base/util/isEmptyObject",'sap/ui/core/Core'],function(T,a,H,M,O,e,b){"use strict";
var c=T.extend("sap.ui.core.tmpl.HandlebarsTemplate",{
metadata:{library:"sap.ui.core"},
constructor:function(i,s){T.apply(this,arguments);}
});
T.registerType("text/x-handlebars-template","sap.ui.core.tmpl.HandlebarsTemplate");
function d(h){for(var k in h){h[k]=h[k].replace("&gt;",">").replace("&lt;","<").replace("&quot;","\"").replace("&amp;","&");}}
function f(p,P){var r=/^((\w+)>)?(.*)/,g=r.exec(p),s=g[2],h=r.exec(P),i=h[2];var g=r.exec(p);if(P&&s==i){return P+g[3];}else{return p;}}
c.RENDER_HELPERS=(function(){var E=H.helpers["each"],w=H.helpers["with"],I=H.helpers["if"],u=H.helpers["unless"],r=sap.ui.getCore().createRenderManager();r.renderControl=function(C){this.writeControlData(C);this.writeClasses(C);this.writeStyles(C);};var h={"each":function(g,o){o=o||g;if(!o.hash.path){return E.apply(this,arguments);}else{d(o.hash);var R=o.data.renderManager,i=o.data.rootControl,p=o.data.path,P=o.data.parentControl,s=f(o.hash.path,p),j=i.bindList(s),k=[],l;if(o.data){l=H.createFrame(o.data);}if(j){for(var K in j){if(l){l.renderManager=R;l.rootControl=i;l.path=s+"/"+K+"/";l.parentControl=P;}k.push(o.fn({},{data:l}));}}if(!P){return new H.SafeString(k.join(""));}}},"with":function(g,o){o=o||g;if(!o.hash.path){return w.apply(this,arguments);}},"if":function(g,o){o=o||g;if(!o.hash.path){return I.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);if(v){return o.fn(this);}else{return o.inverse(this);}}}},"unless":function(g,o){o=o||g;if(!o.hash.path){return u.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);if(!v){return o.fn(this);}else{return o.inverse(this);}}}},"text":function(g,o){o=o||g;d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);return v&&new H.SafeString(e(v));}else{throw new Error("The expression \"text\" requires the option \"path\"!");}},"element":function(g,o){o=o||g;d(o.hash);var R=o.data.renderManager,i=o.data.rootControl,j=i.createDOMElement(o.hash,o.data.path),p=o.data.parentElement;if(o.fn){o.fn({},{data:{renderManager:R,rootControl:i,parentElement:j}});}if(p){p.addElement(j);return;}return new H.SafeString(R.getHTML(j));},"control":function(g,o){o=o||g;d(o.hash);var R=o.data.renderManager,C=o.data.control;if(C){return new H.SafeString(R.getHTML(C));}var j=o.data.rootControl,p=o.data.path,P=o.data.children,t=o.hash["sap-ui-type"],k=O.get(t||""),m=k&&k.getMetadata(),D=o.hash["sap-ui-default-aggregation"]||m&&m.getDefaultAggregationName(),v=o.data.view;if(!k){throw new Error("Control of type "+t+" cannot be found.");}var n={};if(o.fn){o.fn({},{data:{rootControl:j,path:p,children:n,defaultAggregation:D,view:v}});}var s=Object.assign({},o.hash),S;for(var K in s){if(K==="sap-ui-class"&&typeof s[K]==="string"){S=s["sap-ui-class"]&&s["sap-ui-class"].split(" ");delete s[K];}else if(n[K]){delete s[K];}}var N=j.createControl(s,o.data.path,!!P,v);if(S&&S.length>0){S.forEach(N.addStyleClass.bind(N));}if(!b(n)){s=o.hash;var A=m.getAllAggregations();for(var q in n){var x=n[q];for(var i=0,l=x.length;i<l;i++){var y=x[i],z=A[q],B=z&&z.multiple;if(typeof s[q]==="string"){var F=M.bindingParser(s[q],v&&v.getController());F.template=y;N.bindAggregation(q,F);}else{if(B){N.addAggregation(q,y);}else{N.setAggregation(q,y);}}}}}if(P){var q=o.hash["sap-ui-aggregation"]||o.data.defaultAggregation;P[q]=P[q]||[];P[q].push(N);return;}return new H.SafeString(R.getHTML(N));},"property":function(g,o){o=o||g;d(o.hash);var R=o.data.rootControl,m=R.getMetadata(),p=o.hash.name,G=m.getProperty(p)._sGetter;return R[G]();},"aggregation":function(g,o){o=o||g;d(o.hash);if(o.data.children){var A=o.hash.name;if(o.fn){var D=Object.assign({},o.data,{defaultAggregation:A});o.fn({},{data:D});}}else{var R=o.data.renderManager,j=o.data.rootControl,m=j.getMetadata(),A=o.hash.name,G=m.getAggregation(A)._sGetter,k=[];var C=j[G]();if(C){for(var i=0,l=C.length;i<l;i++){if(o.fn){k.push(o.fn({},{data:{renderManager:R,rootControl:j,control:C[i]}}));}else{k.push(R.getHTML(C[i]));}}}return new H.SafeString(k.join(""));}},"event":function(g,o){o=o||g;},"controlData":function(g,o){o=o||g;var R=o.data.rootControl;return new H.SafeString(r.getHTML(R));}};return h;}());
c.prototype.createMetadata=function(){var t=this.getContent(),g=this._fnTemplate=this._fnTemplate||H.compile(t);var m={},j=a.getMetadata().getAllSettings(),p=a.getMetadata().getAllPrivateAggregations();var h={"property":function(i,o){o=o||i;d(o.hash);var n=o.hash.name;if(n&&n!=="id"&&!j[n]){m.properties=m.properties||{};m.properties[n]=Object.assign({},{type:"string"},o.hash);}else{throw new Error("The property name \""+n+"\" is reserved.");}},"aggregation":function(i,o){o=o||i;d(o.hash);var n=o.hash.name;if(n&&!j[n]&&!p[n]){o.hash.multiple=o.hash.multiple=="true";m.aggregations=m.aggregations||{};m.aggregations[n]=Object.assign({},o.hash);}else{throw new Error("The aggregation name \""+n+"\" is reserved.");}},"event":function(i,o){o=o||i;},"controlData":function(i,o){o=o||i;m._hasControlData=true;}};["each","if","unless","with"].forEach(function(v){h[v]=function(){};});g({},{helpers:h});return m;};
c.prototype.createRenderer=function(v){var t=this.getContent(),g=this._fnTemplate=this._fnTemplate||H.compile(t);var r=function(h,C){var s=g(C.getContext()||{},{data:{renderManager:h,rootControl:C,view:v},helpers:c.RENDER_HELPERS});h.write(s);};return r;};
return c;});
sap.ui.predefine('sap/ui/core/tmpl/Template',['sap/ui/base/ManagedObject','sap/ui/base/BindingParser','sap/ui/core/Control','sap/ui/core/RenderManager','sap/base/util/ObjectPath','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery','sap/ui/core/tmpl/TemplateControl','./_parsePath'],function(M,B,C,R,O,L,a,q,T,p){"use strict";
var b=M.extend("sap.ui.core.tmpl.Template",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{stereotype:"template","abstract":true,library:"sap.ui.core",properties:{"content":{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}
});
var t={};
b.prototype.register=function(){var i=this.getId(),o=t[i],m;if(o&&this!==o){m="adding template with duplicate id '"+i+"'";L.error(m);throw new Error("Error: "+m);}t[i]=this;};
b.prototype.deregister=function(){delete t[this.getId()];};
b.byId=function(i){return t[i];};
b.prototype.getInterface=function(){return this;};
b._mSupportedTypes={};
b.registerType=function(s,c){b._mSupportedTypes[s]=c;};
b.unregisterType=function(s){delete b._mSupportedTypes[s];};
b.parsePath=p;
b.prototype.init=function(s,S){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");}if(M.bindingParser===B.complexParser){b.prototype.extractBindingInfo=function(v,i,S){M.bindingParser=B.simpleParser;var r=C.prototype.extractBindingInfo.apply(this,arguments);M.bindingParser=B.complexParser;return r;};}};
b.prototype.declareControl=function(c){a(!!c,"A fully qualified name must be specified!");if(c){var m=this.createMetadata(),r=this.createRenderer(),d=this;T.extend(c,{metadata:m,init:function(){T.prototype.init.apply(this,arguments);this.setTemplate(d);},renderer:{renderTemplate:r,hasControlData:m._hasControlData}});return O.get(c||"");}};
b.prototype.createControl=function(i,c,v){var o=new T({id:i,template:this,context:c});o.setTemplateRenderer(this.createRenderer(v));return o;};
b.prototype.placeAt=function(r,c,P,i){if(typeof c==="string"||typeof c==="number"){P=c;c=undefined;}var I;if(!(r instanceof C)&&i){var $=typeof r==="string"?q(document.getElementById(r)):q(r);if($.length>0){I=$.attr("id");r=$.get(0);var s=$.attr("data-context");c=c||s&&JSON.parse(s);R.markInlineTemplate($);}}var o=this.createControl(I,c);o.placeAt(r,P);return o;};
b.prototype.createMetadata=function(){L.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");};
b.prototype.createRenderer=function(){L.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");};
sap.ui.template=function(o){var l=function(N){L.warning("The usage of Template Views is deprecated since 1.56. Please make use of the asynchronous create functions of the different view classes, e.g. XMLView.create()","Deprecation",null,function(){return{type:"sap.ui.template",name:N};});};if(!o){var c=[];q.each(b._mSupportedTypes,function(s,k){q("script[type='"+s+"'], [data-type='"+s+"']").each(function(r,E){c.push(sap.ui.template({id:E.id,domref:E,type:s,_class:k}));});});return c;}else{if(typeof o==="string"){return sap.ui.template({id:o});}else if(o&&o.tagName&&o.nodeName&&o.ownerDocument&&o.nodeType===1){return sap.ui.template({id:o.id,domref:o});}o=q.extend({type:b.DEFAULT_TEMPLATE},o);l(o.id);var i,s,d,e,f=false,g=typeof o.src==="string",I=false;if(g){q.ajax({url:o.src,dataType:"text",async:false,success:function(r){i=o.id;s=o.type;d=o.control;e=r;var u=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,v=e.match(u);if(v){s=v[1];if(v.length==3){f=v[2];}e=e.substr(v[0].length);}},error:function(){throw new Error("The template could not be loaded from "+o.src+"!");}});}else{var E=o.domref||((o.id?window.document.getElementById(o.id):null)),$=q(E);I=false;i=o.id||E&&E.id;s=$.attr("type")||o.type;d=$.attr("data-control")||o.control;if(i){var h=sap.ui.getCore().getTemplate(i);if(!h instanceof b){throw new Error("Object for id \""+i+"\" is no sap.ui.core.tmpl.Template!");}else{if(h){return h;}}}if($.length===0){throw new Error("DOM element for the Template with the id \""+i+"\" not found!");}e=$.html();var j=E.tagName.toLowerCase();if(j!=="script"){I=$.parents("body").length===1;}}var k=o._class;if(!k){k=b._mSupportedTypes[s];if(!k){throw new Error("The type \""+s+"\" is not supported.");}}var m=sap.ui.requireSync(k.replace(/\./g,"/"));m=m||O.get(k||"");var n=new m({id:i,content:e});if(d){n.declareControl(d);}if(f){n._sControllerName=f;}if(I){n.placeAt(i,o.context,undefined,true);}return n;}};
b.DEFAULT_TEMPLATE="text/x-handlebars-template";b.registerType(b.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return b;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControl',['sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/UIArea','./DOMElement',"./TemplateControlRenderer","./_parsePath","sap/base/strings/capitalize","sap/base/strings/hyphenate","sap/base/Log","sap/ui/thirdparty/jquery",'sap/ui/core/library'],function(C,D,U,a,T,p,c,h,L,q){"use strict";
var b=C.extend("sap.ui.core.tmpl.TemplateControl",{
metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}},
renderer:T
});
b.prototype.init=function(){this._aBindingInfos=[];};
b.prototype.isInline=function(){var i=false,P=this.getParent();if(P instanceof U&&q(P.getRootNode()).attr("id")===this.getId()){i=true;}return i;};
b.prototype.placeAt=function(r,P){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};
b.prototype.getTemplateRenderer=function(){return this.fnRenderer;};
b.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};
b.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(B){var o=B.binding;if(o){o.detachChange(B.changeHandler);o.destroy();}});this._aBindingInfos=[];};
b.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),d=t&&t.getDeclarativeSupport();if(d){var e=this;setTimeout(function(){D.compile(e.getDomRef());});}};
b.prototype.exit=function(){this._cleanup();};
b.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};
b.prototype.onAfterRendering=function(){this.fireAfterRendering();};
b.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o.fnRenderer=this.fnRenderer;return o;};
b.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};
b.prototype.bind=function(P,t){var o=p(P),m=this.getModel(o.model),P=o.path,M=t?"bind"+c(t):"bindProperty",B=m&&m[M](P),d={binding:B,path:o.path,model:o.model};if(B){d.changeHandler=function(){L.debug("TemplateControl#"+this.getId()+": "+t+" binding changed for path \""+P+"\"");this.invalidate();}.bind(this);B.attachChange(d.changeHandler);}this._aBindingInfos.push(d);return B;};
b.prototype.calculatePath=function(P,t){var B=this.getBindingContext(),s=B&&B.getPath();if(P&&s&&!P.startsWith("/")){if(!s.endsWith("/")){s+="/";}P=s+P;}return P;};
b.prototype.bindProp=function(P){var B=this.bind(this.calculatePath(P),"property");return B&&B.getExternalValue();};
b.prototype.bindList=function(P){var B=this.bind(this.calculatePath(P),"list"),m=B&&B.getModel(),P=B&&B.getPath();return B&&m.getProperty(P);};
b.prototype.createDOMElement=function(s,P,d){var e=new a(s);if(P){e.bindObject(P);}if(!d){this.addAggregation("controls",e);}return e;};
b.prototype.createControl=function(s,P,d,v){var H={};q.each(s,function(k,V){H["data-"+h(k)]=V;});var $=q("<div></div>",H);var o=D._createControl($.get(0),v);if(P){o.bindObject(P);}if(!d){this.addAggregation("controls",o);}return o;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControlRenderer',function(){"use strict";var T={apiVersion:1};
T.render=function(r,c){var s=c.isInline()||this.hasControlData;if(!s){r.openStart("div",c).openEnd();}var R=this.renderTemplate||c.getTemplateRenderer();if(R){R.apply(this,arguments);}if(!s){r.close("div");}};
return T;},true);
sap.ui.predefine('sap/ui/core/tmpl/_parsePath',[],function(){"use strict";return function(p){var m,s=p.indexOf(">");if(s>0){m=p.substr(0,s);p=p.substr(s+1);}return{path:p,model:m};};});
sap.ui.predefine('sap/ui/core/util/AsyncHintsHelper',[],function(){'use strict';var A={};
A.modifyUrls=function(a,u){function _(o,U){if(U===undefined){delete o.url;}}[a.components,a.libs].forEach(function(i){if(Array.isArray(i)){i.forEach(function(v){if(typeof v!=="object"){return;}if(typeof v.url==="string"){v.url=u(v.url);_(v,v.url);}else if(typeof v.url==="object"&&typeof v.url.url==="string"){v.url.url=u(v.url.url);_(v,v.url.url);}});}});return a;};
return A;});
sap.ui.predefine('sap/ui/core/util/DraftEnabledMockServer',["sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject","jquery.sap.sjax"],function(q,a){"use strict";return{_oDraftMetadata:{},_oConstants:{COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT:"com.sap.vocabularies.Common.v1.DraftRoot",COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE:"com.sap.vocabularies.Common.v1.DraftNode",COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY:"com.sap.vocabularies.Common.v1.SemanticKey",EMPTY_GUID:"00000000-0000-0000-0000-000000000000",SIBLINGENTITY_NAVIGATION:"SiblingEntity",DRAFT_ADMINISTRATIVE_DATA:"DraftAdministrativeData",DRAFT_ADMINISTRATIVE_DATA_UUID:"DraftAdministrativeDataUUID",ACTIVATION_ACTION:"ActivationAction",EDIT_ACTION:"EditAction",VALIDATE_ACTION:"ValidationFunction",PREPARE_ACTION:"PreparationAction"},handleDraft:function(A,m){var n=function(b){var N=b.getParameter("oEntity");N.IsActiveEntity=false;N.HasActiveEntity=false;N.HasDraftEntity=false;};var d=function(b){var x=b.getParameter("oXhr");var c=q.sap.sjax({url:x.url,dataType:"json"}).data.d;for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var f in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[f].to.entitySet===this._oDraftMetadata.draftNodes[i]){var r=q.sap.sjax({url:c[f].__deferred.uri,dataType:"json"});if(r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];q.sap.sjax({url:N.__metadata.uri,type:"DELETE"});}}}}}};var M=sap.ui.require("sap/ui/core/util/MockServer");if(A&&A.EntityContainer){var e=A.EntityContainer[Object.keys(A.EntityContainer)[0]];for(var E in e){var o=e[E];if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT]){this._oDraftMetadata.draftRootName=E;this._oDraftMetadata.annotations=A;this._oDraftMetadata.mockServerRootUri=m.getRootUri();if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION]){this._oDraftMetadata.draftRootActivationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION].String;}if(this._oDraftMetadata.draftRootActivationName){this._oDraftMetadata.draftRootActivationName=this._oDraftMetadata.draftRootActivationName.substring(this._oDraftMetadata.draftRootActivationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootEditName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.EDIT_ACTION];this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName?this._oDraftMetadata.draftRootEditName.String:undefined;if(this._oDraftMetadata.draftRootEditName){this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName.substring(this._oDraftMetadata.draftRootEditName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootValidationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.VALIDATE_ACTION];this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName?this._oDraftMetadata.draftRootValidationName.String:undefined;if(this._oDraftMetadata.draftRootValidationName){this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName.substring(this._oDraftMetadata.draftRootValidationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootPreparationtionName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.PREPARE_ACTION];this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName?this._oDraftMetadata.draftRootPreparationtionName.String:undefined;if(this._oDraftMetadata.draftRootPreparationtionName){this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName.substring(this._oDraftMetadata.draftRootPreparationtionName.lastIndexOf("/")+1);}q.extend(m,this);m.attachAfter(M.HTTPMETHOD.POST,n,this._oDraftMetadata.draftRootName);m.attachBefore(M.HTTPMETHOD.DELETE,d,this._oDraftMetadata.draftRootName);m.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftRootName);}}}},_calcSemanticKeys:function(e,E){var s=[];for(var b in this._oDraftMetadata.annotations){if(b.lastIndexOf(E[e].type)>-1){s=this._oDraftMetadata.annotations[b][this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY]||[];break;}}var S=[];var c;for(var i=0;i<s.length;i++){c=s[i];for(var k in c){S.push(c[k]);}}return S;},_prepareDraftMetadata:function(e){var t=this;var M=sap.ui.require("sap/ui/core/util/MockServer");this._oDraftMetadata.draftNodes=[];this._oDraftMetadata.draftRootKey=e[this._oDraftMetadata.draftRootName].keys.filter(function(x){return t._calcSemanticKeys(t._oDraftMetadata.draftRootName,e).indexOf(x)<0;})[0];var A=t._oDraftMetadata.annotations;var E=A.EntityContainer[Object.keys(A.EntityContainer)[0]];for(var s in E){var o=E[s];if(o[t._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE]){this._oDraftMetadata.draftNodes.push(s);}}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){this.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftNodes[j]);}},_fnDraftAdministrativeData:function(e){var E={};var d=e.getParameter("oFilteredData");if(!d){E=e.getParameter("oEntry");if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}else{if(d.results){d=d.results;}else{if(a(d)){d=null;return;}}for(var i=0;i<d.length;i++){E=d[i];if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}}},_handleDraftArtifacts:function(e){var t=this;var m=this._oMockdata;var d=m[this._oDraftMetadata.draftRootName];var g=function(c,C){return c.filter(function(x){return C.indexOf(x)<0;})[0];};if(d.length===100){for(var i=0;i<d.length;i++){var E=d[i];if(i<25){E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=false;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var D=[];var s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;D[i][this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][b]=this._oConstants.EMPTY_GUID;}}else if(i<50){E.IsActiveEntity=false;E.HasActiveEntity=false;E.HasDraftEntity=false;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=false;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);}}else if(i<75){var S=q.extend(true,{},E);E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=true;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=true;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][b]=this._oConstants.EMPTY_GUID;}S.IsActiveEntity=false;S.HasActiveEntity=true;S.HasDraftEntity=false;d[i+25]=S;}}}var r=this._getRootUri();q.each(e,function(c,o){q.each(m[c],function(I,f){f.__metadata=f.__metadata||{};f.__metadata.uri=r+c+"("+t._createKeysString(o,f)+")";f.__metadata.type=o.schema+"."+o.type;q.each(o.navprops,function(K){f[K]={__deferred:{uri:r+c+"("+t._createKeysString(o,f)+")/"+K}};});});});},_activate:function(e){var r;var g=function(c,C){return c.filter(function(x){return C.indexOf(x)<0;})[0];};for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var n in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[n].to.entitySet===this._oDraftMetadata.draftNodes[i]){r=q.sap.sjax({url:e[n].__deferred.uri,dataType:"json"});if(r.success&&r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];N.IsActiveEntity=true;N.HasActiveEntity=false;N.HasDraftEntity=false;N[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;var s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[i],this._mEntitySets);var d=g(this._mEntitySets[this._oDraftMetadata.draftNodes[i]].keys,s);N[d]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:N.__metadata.uri,type:"PATCH",data:JSON.stringify(N)});}}}}}e.IsActiveEntity=true;e.HasActiveEntity=false;e.HasDraftEntity=false;e[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify(e)});return e;},setRequests:function(r){var t=this;var M=sap.ui.require("sap/ui/core/util/MockServer");r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootActivationName),response:function(x){var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(e.IsActiveEntity){x.respond(400);}if(e.HasActiveEntity){var s=e.SiblingEntity.__deferred.uri;o=q.sap.sjax({url:s,dataType:"json"});if(o.success&&o.data&&o.data.d.__metadata){var S=o.data.d;o=q.sap.sjax({url:S.__metadata.uri,type:"DELETE"});}}e=t._activate(e);x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});if(t._oDraftMetadata.draftRootEditName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootEditName+"(\\?(.*))?"),response:function(x,u){var f=[];var R=JSON.parse(x.requestBody);if(R&&!a(R)){for(var p in R){f.push(p+" eq "+R[p]);}}else{var U=decodeURIComponent(u).replace("?","&").split("&");for(var b in U){var P=U[b];var c=new RegExp("(.*)=(.*)");var d;if(P){d=c.exec(P);f.push(d[1]+" eq "+d[2]);}}}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(!e.IsActiveEntity||e.HasDraftEntity){x.respond(400);}var D=q.extend(true,{},e);D.IsActiveEntity=false;D.HasActiveEntity=true;D.HasDraftEntity=false;D[t._oDraftMetadata.draftRootKey]=t._generatePropertyValue(t._oDraftMetadata.draftRootKey,"Guid");var s=t._getRootUri();var E=t._mEntitySets[t._oDraftMetadata.draftRootName];D.__metadata=D.__metadata||{};D.__metadata.uri=s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,D)+")";D.__metadata.type=E.schema+"."+E.type;q.each(E.navprops,function(k){D[k]={__deferred:{uri:s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,D)+")/"+k}};});t._oMockdata[t._oDraftMetadata.draftRootName].push(D);o=q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify({HasDraftEntity:true})});x.respondJSON(200,{},JSON.stringify({d:D}));return true;}});}if(t._oDraftMetadata.draftRootValidationName){r.push({method:"GET",path:new RegExp(t._oDraftMetadata.draftRootValidationName+"(\\?(.*))?"),response:function(x,u){var v=t._oDraftMetadata.draftRootValidationName;t.fireEvent(M.HTTPMETHOD.GET+v+":before",{oXhr:x,sUrlParams:u});t.fireEvent(M.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var R={d:{}};R.d[v]={"__metadata":{"type":"ValidationResult"},"IsValid":true};t.fireEvent(M.HTTPMETHOD.GET+v+":after",{oXhr:x,oResult:R});t.fireEvent(M.HTTPMETHOD.GET+":after",{oXhr:x,oResult:R});x.respondJSON(200,{},JSON.stringify(R));return true;}});}if(t._oDraftMetadata.draftRootPreparationtionName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootPreparationtionName),response:function(x){t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":before",{oXhr:x});t.fireEvent(M.HTTPMETHOD.POST+":before",{oXhr:x});var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":after",{oXhr:x,oEntry:e});t.fireEvent(M.HTTPMETHOD.POST+":after",{oXhr:x,oEntry:e});x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});}M.prototype.setRequests.apply(this,[r]);},_generateMockdata:function(e,b){var M=sap.ui.require("sap/ui/core/util/MockServer");M.prototype._generateMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_loadMockdata:function(e,b){var M=sap.ui.require("sap/ui/core/util/MockServer");M.prototype._loadMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_resolveNavigation:function(e,f,n,E){var M=sap.ui.require("sap/ui/core/util/MockServer");var b=M.prototype._resolveNavigation.apply(this,[e,f,n,E]);if(n===this._oConstants.SIBLINGENTITY_NAVIGATION){if(E&&E.IsActiveEntity){b.splice(0,1);}else{b.length>1?b.splice(1,1):b.splice(0,1);}}else if(n===this._oConstants.DRAFT_ADMINISTRATIVE_DATA){if(E){if(E.IsActiveEntity&&!E.HasDraftEntity){b[0]=null;}}else{b[0]=null;}}return b;},_findEntitySets:function(m){var M=sap.ui.require("sap/ui/core/util/MockServer");var e=M.prototype._findEntitySets.apply(this,[m]);this._prepareDraftMetadata(e);return e;},getEntitySetData:function(e){var M=sap.ui.require("sap/ui/core/util/MockServer");var E=M.prototype.getEntitySetData.apply(this,[e]);var g=function(){return E;};if(e===this._oDraftMetadata.draftRootName){this._fnDraftAdministrativeData({getParameter:g});return E;}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){if(e===this._oDraftMetadata.draftNodes[j]){this._fnDraftAdministrativeData({getParameter:g});return E;}}return E;}};},true);
sap.ui.predefine('sap/ui/core/util/Export',['sap/ui/core/Control','./ExportRow','./File','sap/base/Log','./ExportColumn','./ExportType'],function(C,E,F,L){'use strict';
function w(f,o){if(f){return function(){return f.apply(o,arguments);};}else{return f;}}
function p(m){L.warning("Usage of deprecated jQuery Promise method: '"+m+"'. "+"Please use the standard Promise methods 'then' / 'catch' instead!","","sap.ui.core.util.Export");}
function c(P,o){var O=new Promise(P);o=o||O;var r=false,R=false;O.then(function(v){r=true;return v;},function(e){R=true;throw e;});var m={then:O.then,"catch":O["catch"]};function b(d){d.then=function(s,e){var A=[w(s,o),w(e,o)];return b(m.then.apply(d,A),o);};d["catch"]=function(f){var A=[w(f,o)];return b(m["catch"].apply(d,A),o);};[{jq:"done",es6:"then"},{jq:"fail",es6:"catch"},{jq:"always",es6:"then"}].forEach(function(e){d[e.jq]=function(){p(e.jq);var f=null;Array.prototype.concat.apply([],arguments).forEach(function(g){var W=w(g,o);var h=function(v){W.apply(this,arguments);return v;};var A=[h];if(e.jq==="always"){A.push(h);}if(!f){f=m[e.es6].apply(d,A);}else{f=f[e.es6].apply(f,A);}});return b(f,o);};});d.pipe=function(D,f){p("pipe");return d.then(D,f);};d.state=function(){p("state");if(r){return"resolved";}else if(R){return"rejected";}else{return"pending";}};return d;}return b(O);}
var a=C.extend('sap.ui.core.util.Export',{
metadata:{publicMethods:["generate","saveFile"],library:"sap.ui.core",aggregations:{exportType:{type:'sap.ui.core.util.ExportType',multiple:false},columns:{type:'sap.ui.core.util.ExportColumn',multiple:true,bindable:'bindable'},rows:{type:'sap.ui.core.util.ExportRow',multiple:true,bindable:'bindable'},_template:{type:'sap.ui.core.util.ExportRow',multiple:false,visibility:'hidden'}}},
renderer:null
});
a.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
a.prototype.init=function(){this._oPromise=null;this._fnResolvePromise=null;this._oRowBindingArgs=null;};
a.prototype.exit=function(){delete this._oPromise;delete this._fnResolvePromise;delete this._oRowBindingArgs;};
a.prototype._createRowTemplate=function(){var t=new E(this.getId()+"-row"),b=this.getColumns();for(var i=0,l=b.length;i<l;i++){var o=b[i].getTemplate();if(o){t.addCell(o.clone("col"+i));}}return t;};
a.prototype.bindAggregation=function(n,b){if(n==='rows'){this._oRowBindingArgs=arguments;return this;}return C.prototype.bindAggregation.apply(this,arguments);};
a.prototype.updateRows=function(r){if(r==='change'&&this._fnResolvePromise){var s=this.getExportType()._generate(this);this.destroyAggregation('_template');this.unbindAggregation('rows');this._fnResolvePromise(s);this._oPromise=null;this._fnResolvePromise=null;}};
a.prototype.generate=function(){var t=this;if(!this._oPromise){this._oPromise=c(function(r,b){t._fnResolvePromise=r;if(!t.hasModel()){b("Generate is not possible beause no model was set.");}else{var T=t._createRowTemplate();t.setAggregation('_template',T,true);C.prototype.bindAggregation.apply(t,t._oRowBindingArgs);if(t.getBinding("rows")){t.getBinding("rows").getContexts(0,t.getBinding("rows").getLength());}}},this);}return this._oPromise;};
a.prototype.saveFile=function(f){return this.generate().then(function(s){var e=this.getExportType();F.save(s,f||"data",e.getFileExtension(),e.getMimeType(),e.getCharset(),e.getByteOrderMark());});};
return a;});
sap.ui.predefine('sap/ui/core/util/ExportCell',['sap/ui/core/Element'],function(E){'use strict';
var a=E.extend('sap.ui.core.util.ExportCell',{metadata:{library:"sap.ui.core",properties:{content:'string'}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportColumn',['sap/ui/base/ManagedObject','./ExportCell'],function(M){'use strict';
var E=M.extend("sap.ui.core.util.ExportColumn",{metadata:{library:"sap.ui.core",properties:{name:"string"},aggregations:{template:{type:"sap.ui.core.util.ExportCell",multiple:false}}}});
return E;});
sap.ui.predefine('sap/ui/core/util/ExportRow',['sap/ui/base/ManagedObject','./ExportCell'],function(M){'use strict';
var E=M.extend("sap.ui.core.util.ExportRow",{metadata:{library:"sap.ui.core",aggregations:{cells:{type:"sap.ui.core.util.ExportCell",multiple:true}}}});
return E;});
sap.ui.predefine('sap/ui/core/util/ExportType',['sap/ui/base/ManagedObject'],function(M){'use strict';
var E=M.extend('sap.ui.core.util.ExportType',{metadata:{library:"sap.ui.core",properties:{fileExtension:'string',mimeType:'string',charset:'string',byteOrderMark:{type:'boolean',defaultValue:undefined}}}});
E.prototype.init=function(){this._oExport=null;};
E.prototype._generate=function(e){this._oExport=e;var c=this.generate();this._oExport=null;return c;};
E.prototype.generate=function(){return'';};
E.prototype.getColumnCount=function(){if(this._oExport){return this._oExport.getColumns().length;}return 0;};
E.prototype.getRowCount=function(){if(this._oExport&&this._oExport.getBinding("rows")){return this._oExport.getBinding("rows").getLength();}return 0;};
E.prototype.columnGenerator=function(){var i=0,c=this._oExport.getColumns(),C=c.length;return{next:function(){if(i<C){var I=i;i++;return{value:{index:I,name:c[I].getName()},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.cellGenerator=function(){var i=0,r=this._oExport.getAggregation('_template'),c=r.getCells(),C=c.length;return{next:function(){if(i<C){var I=i;i++;var m={};c[I].getCustomData().forEach(function(o){m[o.getKey()]=o.getValue();});return{value:{index:I,content:c[I].getContent(),customData:m},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.rowGenerator=function(){var t=this,i=0,e=this._oExport,b=e.getBinding("rows"),B=e.getBindingInfo("rows"),c=b.getContexts(0,b.getLength()),C=c.length,r=e.getAggregation('_template');return{next:function(){if(i<C){var I=i;i++;r.setBindingContext(c[I],B.model);return{value:{index:I,cells:t.cellGenerator()},done:false};}else{return{value:undefined,done:true};}}};};
return E;});
sap.ui.predefine('sap/ui/core/util/ExportTypeCSV',['./ExportType'],function(E){'use strict';var r=/[\r\n"\t;,]/;var a=/^[=\+\-@](?![\d.,]+(?:e[\+-]?\d+)?$)/i;
var C=E.extend('sap.ui.core.util.ExportTypeCSV',{metadata:{library:"sap.ui.core",properties:{separatorChar:{type:'string',defaultValue:','}}}});
C.MAX_CELL_LENGTH=32760;
C.prototype.setSeparatorChar=function(s){var s=this.validateProperty('separatorChar',s);if(s.length>1){throw new Error("Value of property \"separatorChar\" needs to be exactly one character or empty. "+"\""+s+"\" is "+s.length+" characters long.");}return this.setProperty('separatorChar',s);};
C.prototype.init=function(){this.setProperty('fileExtension','csv',true);this.setProperty('mimeType','text/csv',true);this.setProperty('charset','utf-8',true);};
C.prototype.escapeContent=function(v){if(!v){return v;}if(v.length>C.MAX_CELL_LENGTH){v=v.slice(0,C.MAX_CELL_LENGTH);}if(a.test(v)){v="'"+v;}var c=v.indexOf(this.getSeparatorChar())>-1;if(c||r.test(v)){v=v.replace(/"/g,'""');v='"'+v+'"';}return v;};
C.prototype.generate=function(){var b=[];this.generateColumns(b);this.generateRows(b);return b.join('\r\n');};
C.prototype.generateColumns=function(b){var c=[],o=this.columnGenerator(),d;while(!(d=o.next()).done){c.push(this.escapeContent(d.value.name));}b.push(c.join(this.getSeparatorChar()));};
C.prototype.generateRows=function(b){var R=this.rowGenerator(),o;while(!(o=R.next()).done){var c=[];var d=o.value.cells,e;while(!(e=d.next()).done){c.push(this.escapeContent(e.value.content));}b.push(c.join(this.getSeparatorChar()));}};
return C;});
sap.ui.predefine('sap/ui/core/util/File',["sap/ui/thirdparty/jquery"],function(q){'use strict';var F={save:function(d,f,s,m,c,b){var a=f+'.'+s;if(typeof b==='undefined'&&c==='utf-8'&&s==='csv'){b=true;}if(b===true&&c==='utf-8'){d='\ufeff'+d;}if(window.Blob){var t='data:'+m;if(c){t+=';charset='+c;}var B=new window.Blob([d],{type:t});if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(B,a);}else{var u=window.URL||window.webkitURL;var e=u.createObjectURL(B);var l=window.document.createElement('a');if('download'in l){var $=q(document.body);var g=q(l).attr({download:a,href:e,style:'display:none'});$.append(g);g.get(0).click();g.remove();}else{d=encodeURI(d);var w=window.open(t+","+d);w.opener=null;if(!w){throw new Error("Could not download the file, please deactivate your pop-up blocker.");}}}}}};return F;},true);
sap.ui.predefine('sap/ui/core/util/LibraryInfo',['sap/ui/base/Object',"sap/base/Log","sap/base/util/Version","sap/ui/thirdparty/jquery"],function(B,L,V,q){"use strict";
var a=B.extend("sap.ui.core.util.LibraryInfo",{
constructor:function(){B.apply(this);this._oLibInfos={};},
destroy:function(){B.prototype.destroy.apply(this,arguments);this._oLibInfos={};},
getInterface:function(){return this;}
});
a.prototype._loadLibraryMetadata=function(l,c){l=l.replace(/\//g,".");if(this._oLibInfos[l]){setTimeout(c.bind(window,this._oLibInfos[l]),0);return;}var t=this,u,s,p=/themelib_(.*)/i.exec(l),r;if(!p){s=".library";u=sap.ui.require.toUrl(l.replace(/\./g,"/"))+"/";}else{s=".theme";u=sap.ui.require.toUrl("sap/ui/core/themes/"+p[1]+"/");}r=typeof t.getResourceUrl==="function"?t.getResourceUrl(u):u;q.ajax({url:r+s,dataType:"xml",error:function(x,b,e){L.error("failed to load library details from '"+u+s+": "+b+", "+e);t._oLibInfos[l]={name:l,data:null,url:u};c(t._oLibInfos[l]);},success:function(d,S,x){t._oLibInfos[l]={name:l,data:d,url:u};c(t._oLibInfos[l]);}});};
a.prototype._getLibraryInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data);r.vendor=$.find("vendor").text();r.copyright=$.find("copyright").text();r.version=$.find("version").text();r.documentation=$.find("documentation").text();r.releasenotes=$.find("releasenotes").attr("url");r.componentInfo=a.prototype._getLibraryComponentInfo($);}c(r);});};
a.prototype._getThirdPartyInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data).find("appData").find("thirdparty").children();$.each(function(i,o){if(o.nodeName==="lib"){var b=q(o);var e=b.children("license");r.libs.push({displayName:b.attr("displayName"),homepage:b.attr("homepage"),license:{url:e.attr("url"),type:e.attr("type"),file:d.url+e.attr("file")}});}});}c(r);});};
a.prototype._getDocuIndex=function(l,c){var t=this;this._loadLibraryMetadata(l,function(d){var b=d.name,f=d.url,r={"docu":{},library:b,libraryUrl:f};if(!d.data){c(r);return;}var D=q(d.data).find("appData").find("documentation");var u=D.attr("indexUrl");if(!u){c(r);return;}if(D.attr("resolve")=="lib"){u=d.url+u;}if(typeof t.getResourceUrl==="function"){u=t.getResourceUrl(u);}q.ajax({url:u,dataType:"json",error:function(x,s,e){L.error("failed to load library docu from '"+u+"': "+s+", "+e);c(r);},success:function(d,s,x){d.library=b;d.libraryUrl=f;c(d);}});});};
a.prototype._getReleaseNotes=function(l,v,c){var t=this;this._loadLibraryMetadata(l,function(d){if(!d.data){c({});return;}var i=(v.split(".").length===3)&&!(/-SNAPSHOT/.test(v));var o=V(v);var m=o.getMajor();var M=o.getMinor();var p=o.getPatch();var D=q(d.data).find("appData").find("releasenotes");var u=D.attr("url");var r=typeof t.getResourceUrl==="function";if(!u){L.warning("failed to load release notes for library "+l);c({});return;}if(o.getSuffix()==="-SNAPSHOT"){if(M%2!=0){M=(M+1);p=0;}v=m+"."+M+"."+p;}var b=r?t.getResourceUrl(""):window.location.href,f=/\/\d.\d{1,2}.\d{1,2}\//;if(D.attr("resolve")=="lib"){if(f.test(b)||i===false){u=d.url+u;}else{u="{major}.{minor}.{patch}/"+d.url+u;}}u=u.replace(/\{major\}/g,m);u=u.replace(/\{minor\}/g,M);u=u.replace(/\{patch\}/g,p);if(r){u=t.getResourceUrl(u);}q.ajax({url:u,dataType:"json",error:function(x,s,e){if(s==="parsererror"){L.error("failed to parse release notes for library '"+l+", "+e);}else{L.warning("failed to load release notes for library '"+l+", "+e);}c({});},success:function(d,s,x){c(d,v);}});});};
a.prototype._getLibraryComponentInfo=function(d){var A={};var c=[];var D="";d.find("ownership > component").each(function(b,C){if(C.childElementCount===0){D=C.textContent;}else{var v=C.getElementsByTagName("name");if(v&&v.length>0){v=v[0].textContent;var e=C.getElementsByTagName("module");if(v&&e&&e.length>0){var m=[];for(var i=0;i<e.length;i++){var M=e[i].textContent.replace(/\//g,".");if(M){m.push(M);}}if(m.length>0){c.push({"component":v,"modules":m});}}}}});A["defaultComponent"]=D;if(c&&c.length>0){A["specialCases"]=c;}return A;};
a.prototype._getActualComponent=function(c,m){function b(m,p){m=m.toLowerCase();p=p.toLowerCase();return(m===p||p.match(/\*$/)&&m.indexOf(p.slice(0,-1))===0||p.match(/\.\*$/)&&m===p.slice(0,-2));}if(m){for(var k in c){if(!c[k]){L.error("No library information deployed for "+k);continue;}var C;if(m.indexOf(k)===0){C=c[k].defaultComponent;}var s=c[k].specialCases;if(s){for(var i=0;i<s.length;i++){var S=s[i].modules;for(var j=0;j<S.length;j++){if(b(m,S[j])){C=s[i].component;}}}}if(C){return C;}}}};
a.prototype._getDefaultComponent=function(l){return l&&l.componentInfo&&l.componentInfo.defaultComponent;};
return a;});
sap.ui.predefine('sap/ui/core/util/MockServer',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/thirdparty/sinon','sap/base/Log','sap/base/util/isEmptyObject','sap/ui/core/util/MockServerAnnotationsHandler','sap/ui/core/util/DraftEnabledMockServer','jquery.sap.xml','jquery.sap.sjax'],function(q,M,d,L,f,g,D){"use strict";
var h=M.extend("sap.ui.core.util.MockServer",{
constructor:function(i,s,S){M.apply(this,arguments);h._aServers.push(this);},
metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},
_oServer:null,
_aFilter:null,
_oMockdata:null,
_oMetadata:null,
_sMetadataUrl:null,
_sMockdataBaseUrl:null,
_mEntitySets:null,
_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},
_oRandomSeed:{}
});
h.prototype._getPseudoRandomNumber=function(t){if(!this._oRandomSeed){this._oRandomSeed={};}if(!this._oRandomSeed.hasOwnProperty(t)){this._oRandomSeed[t]=0;}this._oRandomSeed[t]=(this._oRandomSeed[t]+11)*25214903917%281474976710655;return this._oRandomSeed[t]/281474976710655;};
h.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={};};
h.prototype.start=function(){this._oServer=h._getInstance();this._aFilters=[];var r=this.getRequests();var t=this;r.forEach(function(R){var a;if(t.getRecordRequests()===false&&R.response){a=function(){R.response.apply(this,arguments);t._oServer.requests=[];};}else{a=R.response;}t._addRequestHandler(R.method,R.path,a);});};
h.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null;}};
h.prototype.attachBefore=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":before",c);};
h.prototype.attachAfter=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":after",c);};
h.prototype.detachBefore=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":before",c);};
h.prototype.detachAfter=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":after",c);};
h.prototype.isStarted=function(){return!!this._oServer;};
h.prototype.getEntitySetData=function(e){var t=this;var c;if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){c=q.extend(true,[],t._oMockdata[e]);}else{L.error("Unrecognized EntitySet name: "+e);}return c;};
h.prototype.setEntitySetData=function(e,a){if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){this._oMockdata[e]=a;}else{L.error("Unrecognized EntitySet name: "+e);}};
h.prototype._applyQueryOnCollection=function(F,Q,e,u){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$top":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(0,o);break;case"$skip":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(o,F.results.length);break;case"$orderby":F.results=this._getOdataQueryOrderby(F.results,o,e);break;case"$filter":F.results=this._recursiveOdataQueryFilter(F.results,o);break;case"search-focus":break;case"search":var s="";for(var i=0;i<u.length;i++){if(u[i].indexOf("search-focus")!=-1){s=u[i].split('=')[1];break;}}F.results=this._recursiveOdataQuerySearch(F.results,o,s,e);break;case"$select":F.results=this._getOdataQuerySelect(F.results,o,e);break;case"$inlinecount":var c=this._getOdataInlineCount(F.results,o);if(c){F.__count=c;}break;case"$expand":F.results=this._getOdataQueryExpand(F.results,o,e);break;case"$format":F.results=this._getOdataQueryFormat(F.results,o);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
h.prototype._applyQueryOnEntry=function(e,Q,E){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$filter":return this._recursiveOdataQueryFilter([e],o)[0];case"$select":return this._getOdataQuerySelect([e],o,E)[0];case"$expand":return this._getOdataQueryExpand([e],o,E)[0];case"$format":return this._getOdataQueryFormat([e],o);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
h.prototype._getOdataQueryOrderby=function(c,o,e){var p=o.split(',');var t=this;q.each(p,function(i,P){p[i]=t._trim(P);});var C=function n(a,b){for(var i=0;i<p.length;i++){var s=p[i].split(' ');var S=1;if(s.length>1){switch(s[1]){case'asc':S=1;break;case'desc':S=-1;break;default:t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_SORTORDER_DETECTED,s[1]);}}var P,j;var k=s[0].indexOf("/");if(k!==-1){P=s[0].substring(k+1);j=s[0].substring(0,k);if(!a[j].hasOwnProperty(P)){var E=false;var T=[];if(j){var m=t._mEntitySets[e].navprops[j].to.entitySet;T=t._mEntityTypes[t._mEntitySets[m].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===P){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}}if(a[j][P]<b[j][P]){return-1*S;}if(a[j][P]>b[j][P]){return 1*S;}}else{P=s[0];if(!a.hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}if(a[P]<b[P]){return-1*S;}if(a[P]>b[P]){return 1*S;}}}return 0;};return c.sort(C);};
h.prototype._arrayUnique=function(b){var a=b.concat();for(var i=0;i<a.length;++i){for(var j=i+1;j<a.length;++j){if(a[i]===a[j]){a.splice(j--,1);}}}return a;};
h.prototype._getBracketIndices=function(s){var S=[];var r=0;var i,e=0;for(var c=0;c<s.length;c++){if(s[c]==='('){if(/[substringof|endswith|startswith]$/.test(s.substring(0,c))){++r;}else{S.push(s[c]);if(i===undefined){i=c;}}}else if(s[c]===')'){if(!r){S.pop();e=c;if(S.length===0){return{start:i,end:e};}}else{--r;}}}return{start:i,end:e};};
h.prototype._recursiveOdataQueryFilter=function(a,o){var I=this._getBracketIndices(o);if(I.start===0&&I.end===o.length-1){o=this._trim(o.substring(I.start+1,I.end));return this._recursiveOdataQueryFilter(a,o);}var r=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,p;var O;if(r.test(o)){var b=o.substring(I.start,I.end+1);var c=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(b))+".*)");if(I.start===0){c=new RegExp("("+this._trim(this._escapeStringForRegExp(b))+") +(or|and) +(.*)");}var e=c.exec(o);if(e===null){return this._getOdataQueryFilter(a,this._trim(o));}var E=e[1];O=e[2];var j=e[3];var S=this._recursiveOdataQueryFilter(a,E);if(O==="or"){s=this._recursiveOdataQueryFilter(a,j);return this._arrayUnique(S.concat(s));}if(O==="and"){return this._recursiveOdataQueryFilter(S,j);}}else{p=o.split(/ +and | or +/);if(p.length===1){return this._getOdataQueryFilter(a,this._trim(o));}var R=this._recursiveOdataQueryFilter(a,p[0]);var k;for(var i=1;i<p.length;i++){k=new RegExp(this._trim(this._escapeStringForRegExp(p[i-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(p[i])));O=k.exec(o)[1];if(O==="or"){s=this._recursiveOdataQueryFilter(a,p[i]);R=this._arrayUnique(R.concat(s));}if(O==="and"){R=this._recursiveOdataQueryFilter(R,p[i]);}}return R;}};
h.prototype._getOdataQueryFilter=function(a,o){if(a.length===0){return a;}var r=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var b=new RegExp("(endswith|startswith|substringof)\\((.*)");var O=null;var c=r.exec(o);if(c){O=c[2];}else{c=b.exec(o);if(c){O=c[1];}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT);}}var t=this;var G=function(v,V,p,s){var c,e,P;if(!v){c=r.exec(o);e=t._trim(c[V+1]);P=t._trim(c[p+1]);}else{var i=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");c=i.exec(o);e=t._trim(c[V+2]);P=t._trim(c[p+2]);}if(/^\(.+\)$/.test(e)){e=e.replace(/^\(|\)$/g,"");}var T=e[e.length-1];if(T==="M"||T==="m"||T==="L"||T==="f"){e=e.substring(0,e.length-1);}if(e.indexOf("datetime")===0){e=t._getJsonDate(e);}else if(e.indexOf("guid")===0){e=e.substring(5,e.length-1);}else if(e==="true"){e=true;}else if(e==="false"){e=false;}else if(t._isValidNumber(e)){e=parseFloat(e);}else if((e.charAt(0)==="'")&&(e.charAt(e.length-1)==="'")){e=e.substr(1,e.length-2);}var C=P.indexOf("/");if(C!==-1){var j=P.substring(C+1);var k=P.substring(0,C);if(a[0][k]){if(!a[0][k].hasOwnProperty(j)){var E=t._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+j+"'");L.error("MockServer: navigation property '"+k+"' was not expanded, so "+E);return a;}}else{t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e,k,j);}else{if(!a[0].hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e);}};switch(O){case"substringof":return G(true,0,1,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)!==-1);}return(typeof m[p]==="string"&&m[p].indexOf(v)!==-1);});});case"startswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===0);}return(typeof m[p]==="string"&&m[p].indexOf(v)===0);});});case"endswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===(m[C][P].length-v.length));}return(typeof m[p]==="string"&&m[p].indexOf(v)===(m[p].length-v.length));});});case"eq":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]===v);}return(m[p]===v);});});case"ne":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]!==v);}return(m[p]!==v);});});case"gt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>v);}return(m[p]>v);});});case"lt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<v);}return(m[p]<v);});});case"ge":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>=v);}return(m[p]>=v);});});case"le":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<=v);}return(m[p]<=v);});});default:this._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_FILTER_OPERATOR,O);}};
h.prototype._recursiveOdataQuerySearch=function(a,o,O,e){var F="";if(O==""||O==undefined){for(var i=0;i<this._mEntitySets[e].keys.length;i++){if(i!=0){F=F+" or ";}F=F+"startswith("+this._mEntitySets[e].keys[i]+",'"+o+"')";}}else{F="substringof('"+o+"',"+O+")";}return this._recursiveOdataQueryFilter(a,F);};
h.prototype._getOdataQuerySelect=function(a,o,e){var t=this;var p,c;var P=o.split(',');var s=[];var b;var k=a[0]?a[0][P[0].split('/')[0]]:null;if(!(k!=null&&k.results&&k.results.length>0)){var C=function(P,n,b,r){var u={};q.each(P,function(i,j){var v=j.indexOf("/");if(v!==-1){p=j.substring(v+1);c=j.substring(0,v);if(u[c]){u[c].push(p);}else{u[c]=[p];}}});q.each(Object.keys(u),function(i,j){if(!b[j]){b[j]={};}b[j]=C(u[j],n[j],b[j],j);});if(n.results){var F=[];q.each(n.results,function(i,R){var v={};q.each(P,function(j,w){v[w]=R[w];});F.push(v);});if(b){b.results=F;}}else{if(n["__metadata"]){b["__metadata"]=n["__metadata"];}q.each(P,function(i,j){var v=j.indexOf("/");if(v===-1){if(n&&!n.hasOwnProperty(j)){var E=false;var T=[];if(r){var w=t._mEntitySets[e].navprops[r].to.entitySet;T=t._mEntityTypes[t._mEntitySets[w].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===j){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,j);}}b[j]=n[j];}});}return b;};if(P.indexOf("*")!==-1){return a;}q.each(P,function(i,j){P[i]=t._trim(j);});q.each(a,function(i,j){b={};s.push(C(P,j,b));});}else{var m=function(i,j,n){var r={};n=n||'';if(typeof i!=='object'){return i;}if(typeof i.slice==='function'){return i.map(function(u,v){return m(u,j,n);});}if(i.__metadata!==undefined&&n.length===0){r.__metadata=i.__metadata;}j.filter(function(u){return(u+'/').indexOf(n)===0;}).forEach(function(u,_,v){var w=u.substr(n.length).split('/')[0];if(i[w]!==undefined){r[w]=m(i[w],v,n+w+'/');}});if(i.results!==undefined){r.results=m(i.results,j,n);}return r;};s=m(a,P);}return s;};
h.prototype._getOdataInlineCount=function(a,o){var p=o.split(',');if(p.length!==1||(p[0]!=='none'&&p[0]!=='allpages')){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}if(p[0]==='none'){return;}return a.length;};
h.prototype._getOdataQueryFormat=function(a,o){if(o!=='json'){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE);}return a;};
h.prototype._getOdataQueryExpand=function(a,o,e){var t=this;var n=o.split(',');q.each(n,function(i,p){n[i]=t._trim(p);});var E=t._mEntitySets[e].navprops;q.each(a,function(i,r){q.each(n,function(i,N){var b=N.split("/");var s=b[0];if(!r[s]){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,s);}var c=r[s].results||r[s];if(!c||c.__deferred){c=q.extend(true,[],t._resolveNavigation(e,r,s,r));}else if(!Array.isArray(c)){c=[c];}if(c&&b.length>1){var R=b.splice(1,b.length).join("/");c=t._getOdataQueryExpand(c,R,E[s].to.entitySet);}if(E[s].to.multiplicity==="*"){r[s]={results:c};}else{r[s]=c[0]?c[0]:{};}});});return a;};
h.prototype._refreshData=function(){var m=this._loadMetadata(this._sMetadataString);if(!m){return;}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata);}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/";}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl);}};
h.prototype._getRootUri=function(){var u=this.getRootUri();u=u&&/([^?#]*)([?#].*)?/.exec(u)[1];return u;};
h.prototype._loadMetadata=function(m){var m;m=m.trim();if(m.substring(0,1)!=="<"){m=q.sap.sjax({url:m,dataType:"text"}).data;if(!m){L.error("MockServer: The metadata for url \""+m+"\" could not be found!");}}this._sMetadata=m;try{this._oMetadata=q.parseXML(m);}catch(e){L.error("MockServer: Invalid metadata XML! Reason: "+e);}return this._oMetadata;};
h.prototype._findEntitySets=function(m){var e={};var p=q(m).find("Principal");var o=q(m).find("Dependent");q(m).find("EntitySet").each(function(i,E){var $=q(E);var a=/((.*)\.)?(.*)/.exec($.attr("EntityType"));e[$.attr("Name")]={"name":$.attr("Name"),"schema":a[2],"type":a[3],"keys":[],"keysType":{},"navprops":{}};});var r=function(R,a,A,F){var E=q(A).find("End[Role='"+R+"']").attr("EntitySet");var s=q(a).find("End[Role='"+R+"']").attr("Multiplicity");var P=[];var c=q(a).find("ReferentialConstraint > [Role='"+R+"']");if(c&&c.length>0){q(c[0]).children("PropertyRef").each(function(i,j){P.push(q(j).attr("Name"));});}else{var b=(F)?p:o;q(b).each(function(i,j){if(R===(q(j).attr("Role"))){q(j).children("PropertyRef").each(function(i,k){P.push(q(k).attr("Name"));});return false;}});}return{"role":R,"entitySet":E,"propRef":P,"multiplicity":s};};q.each(e,function(E,a){var $=q(m).find("EntityType[Name='"+a.type+"']");var k=q($).find("PropertyRef");q.each(k,function(i,P){var K=q(P).attr("Name");a.keys.push(K);a.keysType[K]=q($).find("Property[Name='"+K+"']").attr("Type");});var n=q(m).find("EntityType[Name='"+a.type+"'] NavigationProperty");q.each(n,function(i,N){var b=q(N);var R=b.attr("Relationship").split(".");var A=q(m).find("AssociationSet[Association = '"+R.join(".")+"']");var s=R.pop();var c=q(m).find("Association[Name = '"+s+"']");a.navprops[b.attr("Name")]={"name":b.attr("Name"),"from":r(b.attr("FromRole"),c,A,true),"to":r(b.attr("ToRole"),c,A,false)};});});return e;};
h.prototype._findEntityTypes=function(m){var e={};q(m).find("EntityType").each(function(i,E){var $=q(E);e[$.attr("Name")]={"name":$.attr("Name"),"properties":[],"keys":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");e[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});$.find("PropertyRef").each(function(i,k){var K=q(k);var p=K.attr("Name");e[$.attr("Name")].keys.push(p);});});return e;};
h.prototype._findComplexTypes=function(m){var c={};q(m).find("ComplexType").each(function(i,C){var $=q(C);c[$.attr("Name")]={"name":$.attr("Name"),"properties":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");c[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});});return c;};
h.prototype._createKeysString=function(e,E){var t=this;var k="";if(E){q.each(e.keys,function(i,K){if(k){k+=",";}var o=E[K];if(e.keysType[K]==="Edm.String"){o=encodeURIComponent("'"+o+"'");}else if(e.keysType[K]==="Edm.DateTime"){o=t._getDateTime(o);o=encodeURIComponent(o);}else if(e.keysType[K]==="Edm.Guid"){o="guid'"+o+"'";}if(e.keys.length===1){k+=o;return k;}k+=K+"="+o;});}return k;};
h.prototype._loadMockdata=function(e,b){var t=this,m={};this._oMockdata={};var a=function(u,o){var r=q.sap.sjax({url:u,dataType:"json"});if(r.success){if(r.data.d){if(r.data.d.results){m[o.name]=r.data.d.results;}else{L.error("The mock data format for entity set \""+o.name+"\" invalid");}}else{if(Array.isArray(r.data)){m[o.name]=r.data;}else{L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to wrong format!");return false;}}return true;}else{if(r.status==="parsererror"){L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to a parsing error!");}return false;}};if(b.endsWith(".json")){var r=q.sap.sjax({url:b,dataType:"json"});if(r.success){m=r.data;}else{L.warning("The mock data for all the entity types could not be found at \""+b+"\"!");}}else{var E={};if(t._aEntitySetsNames&&t._aEntitySetsNames.length>0){var s;for(var i=0;i<t._aEntitySetsNames.length;i++){s=t._aEntitySetsNames[i];if(e[s]){E[s]=e[s];}}}else{E=e;}q.each(E,function(c,o){if(!m[o.type]||!m[o.name]){var j=b+o.name+".json";if(!a(j,o)){L.warning("The mock data for entity set \""+o.name+"\" could not be found at \""+b+"\"!");var k=b+o.type+".json";if(!a(k,o)){L.warning("The mock data for entity type \""+o.type+"\" could not be found at \""+b+"\"!");if(t._bGenerateMissingMockData){var n={};n[o.name]=o;m[o.type]=t._generateODataMockdataForEntitySet(n,t._oMetadata)[o.name];}}}}});}q.each(e,function(c,o){t._oMockdata[c]=[];if(m[o.name]){q.each(m[o.name],function(I,j){t._oMockdata[c].push(q.extend(true,{},j));});}else if(m[o.type]){q.each(m[o.type],function(I,j){t._oMockdata[c].push(q.extend(true,{},j));});}});q.each(e,function(c,o){if(t._oMockdata[c].length>0){t._enhanceWithMetadata(o,t._oMockdata[c]);}});return this._oMockdata;};
h.prototype._enhanceWithMetadata=function(e,m){if(m){var t=this,r=this._getRootUri(),E=e&&e.name;q.each(m,function(i,o){o.__metadata=o.__metadata||{};o.__metadata.id=r+E+"("+t._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=r+E+"("+t._createKeysString(e,o)+")";q.each(e.navprops,function(k,n){if(o[k]&&!f(o[k])&&!o[k]["__deferred"]){t._oMockdata[n.to.entitySet]=t._oMockdata[n.to.entitySet].concat(o[k]);}o[k]={__deferred:{uri:r+E+"("+t._createKeysString(e,o)+")/"+k}};});});}};
h.prototype._isRequestedKeysValid=function(e,r){if(r.length===1){var s=r[0].split('=');if(this._trim(s[0])!==e.keys[0]){r=[e.keys[0]+"="+r[0]];}}for(var i=0;i<r.length;i++){var k=this._trim(r[i].substring(0,r[i].indexOf('=')));var R=this._trim(r[i].substring(r[i].indexOf('=')+1));var F=R.charAt(0);var a=R.charAt(R.length-1);if(e.keysType[k]==="Edm.String"){if(F!=="'"||a!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.DateTime"){if(F==="'"||a!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Guid"){if(F==="'"||a!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Binary"){if(!(new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(R))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else{if((F==="'"&&a!=="'")||(a==="'"&&F!=="'")){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}var K=e.keys.join(",");if(e.keys.indexOf(k)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,K);}}};
h.prototype._parseKeys=function(k,e){var r={};var p=k.split(",");var K,s,P;for(var i=0;i<p.length;i++){P=p[i].split("=");if(P.length===1&&e.keys.length===1){K=e.keys[0];s=P[0];}else{if(P.length===2){K=P[0];s=P[1];}}r[K]=s;switch(e.keysType[K]){case"Edm.String":r[K]=r[K].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[K]=parseFloat(r[K]);break;case"Edm.Guid":r[K]=r[K].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:}}return r;};
h.prototype._generatePropertyValue=function(k,t,C,i){var I=i;if(!I){I=Math.floor(this._getPseudoRandomNumber("String")*10000)+101;}switch(t){case"String":return k+" "+I;case"DateTime":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*10000);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1000000)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<0.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1000000000;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=this._getPseudoRandomNumber("Guid")*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16);}.bind(this));case"Binary":var n=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),m="";for(var b=0,e=n;b<32;b++,m+=String(e>>>31),e<<=1);return m;case"DateTimeOffset":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(C[t],I,C);}};
h.prototype._isFalseyValue=function(k,K,s){switch(s){case"Edm.String":return k==="";case"Edm.Boolean":return k===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return k===0||isNaN(k);default:return false;}};
h.prototype._completeKey=function(e,k,E){if(E){for(var i=0;i<e.keys.length;i++){var K=e.keys[i];if(k[K]!==undefined&&k[K]!==null){if(!E[K]){switch(e.keysType[K]){case"Edm.DateTime":E[K]=this._getJsonDate(k[K]);break;case"Edm.Guid":E[K]=k[K].replace(/^guid\'|\'$/g,"");break;default:E[K]=k[K];}}}else{if(!E[K]){E[K]=this._generatePropertyValue(K,e.keysType[K].substring(e.keysType[K].lastIndexOf('.')+1));}}}}};
h.prototype._generateDataFromEntity=function(e,I,c){var E={};if(!e){return E;}for(var i=0;i<e.properties.length;i++){var p=e.properties[i];E[p.name]=this._generatePropertyValue(p.name,p.type,c,I);}return E;};
h.prototype._generateDataFromEntitySet=function(e,E,c){var o=E[e.type];var m=[];for(var i=0;i<100;i++){m.push(this._generateDataFromEntity(o,i+1,c));}return m;};
h.prototype._generateMockdata=function(e,m){var t=this;var o={};var r=this._getRootUri();q.each(e,function(E,a){var b={};b[a.name]=a;o[E]=t._generateODataMockdataForEntitySet(b,m)[E];});q.each(e,function(E,a){for(var n in a.navprops){var N=a.navprops[n];var p=N.from.propRef.length;for(var j=0;j<p;j++){for(var i=0;i<o[E].length;i++){var b=o[E][i];o[N.to.entitySet][i][N.to.propRef[j]]=b[N.from.propRef[j]];}}}q.each(o[E],function(I,c){c.__metadata={uri:r+E+"("+t._createKeysString(a,c)+")",type:a.schema+"."+a.type};q.each(a.navprops,function(k,N){c[k]={__deferred:{uri:r+E+"("+t._createKeysString(a,c)+")/"+k}};});});});this._oMockdata=o;};
h.prototype._generateODataMockdataForEntitySet=function(e,m){var t=this,o={};var E=this._findEntityTypes(m);var c=this._findComplexTypes(m);q.each(e,function(s,a){o[s]=t._generateDataFromEntitySet(a,E,c);});return o;};
h.prototype._resolveNavigation=function(e,F,n){var E=this._mEntitySets[e];var N=E.navprops[n];if(!N){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND);}var a=[];var p=N.from.propRef.length;if(p===0){if(N.to.multiplicity==="*"){return this._oMockdata[N.to.entitySet];}else{a.push(this._oMockdata[N.to.entitySet][0]);return a;}}q.each(this._oMockdata[N.to.entitySet],function(I,t){var b=true;for(var i=0;i<p;i++){if(F[N.from.propRef[i]]!==t[N.to.propRef[i]]){b=false;break;}}if(b){a.push(t);}});return a;};
h.prototype.simulate=function(s,v){var t=this;this._sMetadataString=s;if(!v||typeof v==="string"){this._sMockdataBaseUrl=v;}else{this._sMockdataBaseUrl=v.sMockdataBaseUrl;this._bGenerateMissingMockData=v.bGenerateMissingMockData;this._aEntitySetsNames=v.aEntitySetsNames;}var o=this._loadMetadata(this._sMetadataString);if(!o){return;}if(this._sMetadata){var a=g.parse(this._oMetadata,this._sMetadata);D.handleDraft(a,this);}this._resetPseudoRandomNumberGenerator();this._refreshData();var H=function(x,m){if(x.requestHeaders["x-csrf-token"]==="Fetch"){m["X-CSRF-Token"]="42424242424242424242424242424242";}};var G=function(e,k){k=decodeURIComponent(k);var F;var E=t._mEntitySets[e];var K=E.keys;var j=k.split(',');if(j.length!==K.length){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY);}t._isRequestedKeysValid(E,j);if(j.length===1&&!j[0].split('=')[1]){j=[K[0]+"="+j[0]];}q.each(t._oMockdata[e],function(I,m){for(var i=0;i<j.length;i++){var n=j[i].split('=');var p=t._trim(n[0]);if(!K||K.indexOf(p)===-1){return true;}var N=t._trim(n[1]);var O=m[p];switch(E.keysType[p]){case"Edm.String":N=N.replace(/^\'|\'$/g,'');break;case"Edm.Time":case"Edm.DateTime":O=t._getDateTime(O);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!t._isValidNumber(N)){return false;}N=parseFloat(N);break;case"Edm.Guid":N=N.replace(/^guid\'|\'$/g,'');break;case"Edm.Boolean":if(["true","false"].indexOf(N)===-1){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_TYPE,p);}N=N==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:}if(O!==N){return true;}}F={index:I,entry:m};return false;});return F;};var r=function(e,k,u){var S=e.name;var n;if(u){n=e.navprops[u];}if(n){S=n.to.entitySet;}return S;};var b=function(u){var U=[];var S=function(V){var j=V.indexOf("'");var m=V.indexOf("\"");if(j===-1&&m===-1){return null;}else{if(j>-1&&m===-1){return"appost";}if(m>-1&&j===-1){return"doublequotes";}if(j>-1&&m>-1&&j<m){return"appost";}if(j>-1&&m>-1&&m<j){return"doublequotes";}}};var A=function(p,P,m,n){var w=p[m];var j=m+1;while(j<p.length&&p[j].indexOf(n)===-1){w=w+"&"+p[j];j++;}w=w+"&"+p[j];P.push(w);m=j;return m;};for(var i=0;i<u.length;i++){if(!S(u[i])){U.push(u[i]);}if(S(u[i])==="appost"){var e=u[i].indexOf("'");if(u[i].indexOf("'",e+1)===-1){i=A(u,U,i,"'");}else{U.push(u[i]);}}if(S(u[i])==="doublequotes"){var k=u[i].indexOf("\"");if(u[i].indexOf("\"",k+1)===-1){i=A(u,U,i,"\"");}else{U.push(u[i]);}}}return U;};var c=function(x,T,k,u){k=k?decodeURIComponent(k):k;var e=JSON.parse(x.requestBody);if(e){var K={};if(k){K=t._parseKeys(k,t._mEntitySets[T]);}t._completeKey(t._mEntitySets[T],K,e);t._enhanceWithMetadata(t._mEntitySets[T],[e]);return e;}return null;};var R=[];R.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/xml;charset=utf-8"};H(x,m);x.respond(200,m,t._sMetadata);L.debug("MockServer: response sent with: 200, "+t._sMetadata);return true;}});R.push({method:"HEAD",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);x.respond(200,m);L.debug("MockServer: response sent with: 200");return true;}});R.push({method:"GET",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);var e=[];q.each(t._mEntitySets,function(E,j){e.push(E);});var i={EntitySets:e};x.respond(200,m,JSON.stringify({d:i}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}));return true;}});R.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var e=function(b1){switch(b1.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return b1.statusCode+" "+b1.status;}};var B=function(b1,c1){var d1;if(b1.success){d1=JSON.stringify(b1.data)||"";}else{d1=b1.errorResponse;}c1=c1||"application/json";if(b1.responseHeaders){return"HTTP/1.1 "+e(b1)+"\r\n"+b1.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+d1+"\r\n";}else{return"HTTP/1.1 "+e(b1)+"\r\nContent-Type: "+c1+"\r\nContent-Length: "+d1.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+d1+"\r\n";}};var C=function(b1,V,c1,P,W){var d1;var e1=function(g1,h1,i1){d1={success:true,data:g1,status:h1,statusCode:i1&&i1.status,responseHeaders:i1&&i1.getAllResponseHeaders()};};var f1=function(g1,h1,i1){d1={success:false,data:undefined,status:h1,error:i1,statusCode:g1.status,errorResponse:g1.responseText,responseHeaders:g1&&g1.getAllResponseHeaders()};};q.ajax({type:c1,async:false,url:b1,headers:W,data:V,dataType:"json",success:e1,error:f1});if(d1.statusCode===400||d1.statusCode===404){var _=B(d1);throw new Error(_);}P.push(B(d1));};var n=function(b1,z){var c1;var d1;var e1=function(g1,h1,i1){c1={success:true,data:g1,status:h1,statusCode:i1&&i1.status,responseHeaders:i1&&i1.getAllResponseHeaders()};};var f1=function(g1,h1,i1){c1={success:false,data:undefined,status:h1,error:i1,statusCode:g1.status,errorResponse:g1.responseText,responseHeaders:g1&&g1.getAllResponseHeaders()};};q.ajax({async:false,url:b1,dataType:"json",success:e1,error:f1});var d1;if(b1.indexOf('$count')!==-1){d1=B(c1,"text/plain");}else{d1=B(c1);}z.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+d1.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+d1);};var p=function(U){var W={};U.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(b1){if(b1.indexOf(":")!==-1){var c1=b1.split(":");W[c1[0].trim()]=c1[1].trim();}});delete W["Content-Length"];return W;};var u=x.requestBody;var w=new RegExp("--batch_[a-z0-9-]*");var y=w.exec(u)[0];if(y){var z=[];var A=u.split(y);var S=x.url.split("$")[0];var E=new RegExp("PUT (.*) HTTP");var F=new RegExp("MERGE (.*) HTTP");var I=new RegExp("POST (.*) HTTP");var J=new RegExp("DELETE (.*) HTTP");var K=new RegExp("GET (.*) HTTP");for(var i=1;i<A.length-1;i++){var N=A[i];if(K.test(N)&&N.indexOf("multipart/mixed")===-1){if(E.test(N)||I.test(N)||J.test(N)){x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return true;}n(S+K.exec(N)[1],z);}else{var O=q.extend(true,{},t._oMockdata);var P=[];var Q=N.substring(N.indexOf("boundary=")+9,N.indexOf("\r\n\r\n"));var T=N.split("--"+Q);try{for(var j=1;j<T.length-1;j++){var U=T[j];var V;if(K.test(U)){t._oMockdata=O;x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return;}else{var V=U.substring(U.indexOf("{"),U.lastIndexOf("}")+1),W=p(U),X,Y;if(E.test(U)){Y="PUT";X=E.exec(U)[1];}else if(F.test(U)){Y="MERGE";X=F.exec(U)[1];}else if(I.test(U)){Y="POST";X=I.exec(U)[1];}else if(J.test(U)){Y="DELETE";V=undefined;X=J.exec(U)[1];}C(S+X,V,Y,P,W);}}var Z="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var k=0;k<P.length;k++){Z+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+P[k].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+P[k]+"--ejjeeffe1";}Z+="--\r\n";z.push(Z);}catch($){t._oMockdata=O;var _="\r\nContent-Type: application/http\r\n"+"Content-Length: "+$.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+$.message;z.push(_);}}}var a1="--ejjeeffe0";for(var m=0;m<z.length;m++){a1+=z[m]+"--ejjeeffe0";}a1+="--";var W={'Content-Type':"multipart/mixed; boundary=ejjeeffe0"};H(x,W);x.respond(202,W,a1);L.debug("MockServer: response sent with: 202, "+a1);}else{x.respond(202);}return true;}});q.each(this._mEntitySets,function(E,i){R.push({method:"GET",path:new RegExp("("+E+")/\\$count/?(.*)?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(h.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=b(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(h.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(h.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.error("MockServer: request failed due to invalid system query options value!");x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")/?(\\?(.*))?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(h.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=b(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(h.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(h.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(x,E,k,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sUrlParams:u});t.fireEvent(h.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};try{var j=q.extend(true,{},G(E,k));if(!f(j)){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=b(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){j.entry=t._applyQueryOnEntry(j.entry,Q,E);});}t.fireEvent(h.HTTPMETHOD.GET+E+":after",{oXhr:x,oEntry:j.entry});t.fireEvent(h.HTTPMETHOD.GET+":after",{oXhr:x,oEntry:j.entry});x.respond(200,m,JSON.stringify({d:j.entry}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:j.entry}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});q.each(i.navprops,function(n,N){R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/\\$count/?(.*)?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(h.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=b(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(h.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(h.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});F.results=F.results||[];x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/?(\\?(.*))?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(h.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j,p.entry);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=b(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(h.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(h.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});R.push({method:"POST",path:new RegExp("("+E+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(x,E,j,k,n){var m=false;if(x.requestHeaders["x-http-method"]==="MERGE"){m=true;}L.debug("MockServer: incoming create request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.POST+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(h.HTTPMETHOD.POST+":before",{oXhr:x,sKeys:k,sNavName:n});var p=null;var u=null;var w=405;try{if(k&&!k.split('=')[1]){k=t._mEntitySets[E].keys[0]+"="+k;}var T=r(i,decodeURIComponent(k),n);if(T){var y=c(x,T,k,n);if(y){u={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(h.HTTPMETHOD.POST+E+":after",{oXhr:x,oEntity:y});t.fireEvent(h.HTTPMETHOD.POST+":after",{oXhr:x,oEntity:y});if(m){var z=G(E,k);if(z){q.extend(t._oMockdata[E][z.index],y);}w=204;}else{var U=t._getRootUri()+T+"("+t._createKeysString(t._mEntitySets[T],y)+")";p=JSON.stringify({d:y,uri:U});t._oMockdata[T]=t._oMockdata[T].concat([y]);w=201;}}}x.respond(w,u,p);L.debug("MockServer: response sent with: "+w+", "+p);}catch(e){if(e.error){var A={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,A,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PUT",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming update request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.PUT+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(h.HTTPMETHOD.PUT+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=c(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(h.HTTPMETHOD.PUT+E+":after",{oXhr:x,oEntity:u});t.fireEvent(h.HTTPMETHOD.PUT+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){t._oMockdata[E][w.index]=u;}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"MERGE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming merge update request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.MERGE+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(h.HTTPMETHOD.MERGE+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=c(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(h.HTTPMETHOD.MERGE+E+":after",{oXhr:x,oEntity:u});t.fireEvent(h.HTTPMETHOD.MERGE+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PATCH",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming patch update request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.PATCH+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(h.HTTPMETHOD.PATCH+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=c(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(h.HTTPMETHOD.PATCH+E+":after",{oXhr:x,oEntity:u});t.fireEvent(h.HTTPMETHOD.PATCH+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"DELETE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,u){L.debug("MockServer: incoming delete request for url: "+x.url);t.fireEvent(h.HTTPMETHOD.DELETE+E+":before",{oXhr:x});t.fireEvent(h.HTTPMETHOD.DELETE+":before",{oXhr:x});var j=204;try{var m=G(E,k);if(m){t._oMockdata[E].splice(m.index,1);}else{j=400;}t.fireEvent(h.HTTPMETHOD.DELETE+E+":after",{oXhr:x});t.fireEvent(h.HTTPMETHOD.DELETE+":after",{oXhr:x});x.respond(j,null,null);L.debug("MockServer: response sent with: "+j);}catch(e){if(e.error){var n={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,n,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});this.setRequests(R);};
h.prototype._orderQueryOptions=function(u){var F,i,s,t,o,S,e,a,b,c,O=[];var j=this;q.each(u,function(I,Q){var k=u.indexOf(Q);switch(Q.split('=')[0]){case"$top":t=k;break;case"$skip":s=k;break;case"$orderby":o=k;break;case"$expand":e=k;break;case"$filter":F=k;break;case"$select":S=k;break;case"$inlinecount":i=k;break;case"$format":a=k;break;case"search-focus":c=k;break;case"search":b=k;break;default:if(Q.split('=')[0].indexOf('$')===0){j._logAndThrowMockServerCustomError(400,j._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,Q.split('=')[0]);}}});if(e>=0){O.push(u[e]);}if(F>=0){O.push(u[F]);}if(c>=0){O.push(u[c]);}if(b>=0){O.push(u[b]);}if(i>=0){O.push(u[i]);}if(o>=0){O.push(u[o]);}if(s>=0){O.push(u[s]);}if(t>=0){O.push(u[t]);}if(S>=0){O.push(u[S]);}if(a>=0){O.push(u[a]);}return O;};
h.prototype._removeAllRequestHandlers=function(){var r=this.getRequests();var a=r.length;for(var i=0;i<a;i++){h._removeResponse(r[i].response);}};
h.prototype._removeAllFilters=function(){for(var i=0;i<this._aFilters.length;i++){h._removeFilter(this._aFilters[i]);}this._aFilters=null;};
h.prototype._addRequestHandler=function(m,p,r){m=m?m.toUpperCase():m;if(typeof m!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string");}if(!(typeof p==="string"||p instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression");}if(typeof r!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function");}var u=this._getRootUri();u=u&&new RegExp(this._escapeStringForRegExp(u));if(p&&!(p instanceof RegExp)){p=new RegExp(this._createRegExpPattern(p));}var R=this._createRegExp(u?u.source+p.source:p.source);this._addFilter(this._createFilter(m,R));this._oServer.respondWith(m,R,r);L.debug("MockServer: adding "+m+" request handler for pattern "+R);};
h.prototype._createRegExp=function(p){return new RegExp("^"+p+"$");};
h.prototype._createRegExpPattern=function(p){return p.replace(/:([\w\d]+)/g,"([^\/]+)");};
h.prototype._escapeStringForRegExp=function(s){return s.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&");};
h.prototype._trim=function(s){return s&&s.replace(/^\s+|\s+$/g,"");};
h.prototype._isValidNumber=function(s){return!isNaN(parseFloat(s))&&isFinite(s);};
h.prototype._getDateTime=function(s){if(!s){return;}return"datetime'"+new Date(Number(s.replace("/Date(",'').replace(")/",''))).toJSON().substring(0,19)+"'";};
h.prototype._getJsonDate=function(S){if(!S){return;}var n=function(s){var a=q.map(s.slice(0,-5).split(/\D/),function(i){return parseInt(i)||0;});a[1]-=1;a=new Date(Date.UTC.apply(Date,a));var o=s.slice(-5);var b=parseInt(o)/100;if(o.slice(0,1)==="+"){b*=-1;}a.setHours(a.getHours()+b);return a.getTime();};if(S.indexOf("datetimeoffset")>-1){return"/Date("+n(S.substring("datetimeoffset'".length,S.length-1))+")/";}else{return"/Date("+n(S.substring("datetime'".length,S.length-1))+")/";}};
h.prototype._addFilter=function(F){this._aFilters.push(F);h._addFilter(F);};
h.prototype._createFilter=function(r,R){return function(m,u,a,U,p){return r===m&&R.test(u);};};
h.prototype._logAndThrowMockServerCustomError=function(e,E,p){if(E.indexOf('##')>-1&&p){E=E.replace("##","'"+p+"'");}L.error("MockServer: "+E);throw{error:{code:e,message:{lang:"en",value:E}}};};
h.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);this.stop();var S=h._aServers;var i=S.indexOf(this);S.splice(i,1);};
h._aFilters=[];h._oServer=null;h._aServers=[];
h._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true;}return this._oServer;};
h.config=function(c){var s=this._getInstance();s.autoRespond=c.autoRespond===false?false:true;s.autoRespondAfter=c.autoRespondAfter||0;s.fakeHTTPMethods=c.fakeHTTPMethods||false;};
h.respond=function(){this._getInstance().respond();};
h.startAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].start();}};
h.stopAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].stop();}this._getInstance().restore();this._oServer=null;};
h.destroyAll=function(){this.stopAll();while(this._aServers.length>0){this._aServers[0].destroy();}};
h.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};
h._addFilter=function(F){this._aFilters.push(F);};
h._removeFilter=function(F){this._aFilters.splice(this._aFilters.indexOf(F),1);};
h._removeResponse=function(r){var R=this._oServer.responses;var a=R.length;for(var i=0;i<a;i++){if(R[i].response===r){R.splice(i,1);return true;}}return false;};
window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(m,u,a,U,p){var F=h._aFilters;for(var i=0;i<F.length;i++){var b=F[i];if(b(m,u,a,U,p)){return false;}}return true;});var l=function(F){if(/.*\.json$/i.test(F)){return"JSON";}if(/.*\.xml$/i.test(F)){return"XML";}if(/.*metadata$/i.test(F)){return"XML";}return null;};
window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(s,H,F){var r=q.sap.sjax({url:F,dataType:"text"});if(!r.success){throw new Error("Could not load file from: "+F);}var o=r.data;var m=l(F);if(this["respond"+m]){this["respond"+m](s,H,o);}else{this.respond(s,H,o);}};
window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(s,H,j){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/json";this.respond(s,H,typeof j==="string"?j:JSON.stringify(j));};
window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(s,H,x){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/xml";this.respond(s,H,x);};
return h;});
sap.ui.predefine('sap/ui/core/util/MockServerAnnotationsHandler',['sap/ui/model/odata/ODataModel'],function(O){"use strict";return{parse:function(m,M){if(!this._index){this._index=0;}var u="/annotationhandler"+this._index++ +"/";var a=sap.ui.require("sap/ui/core/util/MockServer");var o=new a({rootUri:u,requests:[{method:"GET",path:new RegExp("\\$metadata"),response:function(x){x.respond(200,{"Content-Type":"application/xml;charset=utf-8"},M);}}]});o.start();var b={annotationURI:[u+"$metadata"],json:true};var c=new O(u,b);var A=c.getServiceAnnotations();o.destroy();return A;}};},true);
sap.ui.predefine('sap/ui/core/util/PasteHelper',["sap/ui/core/Core","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/Log"],function(C,P,V,L){"use strict";var a={};
a.getClipboardText=function(e){return(typeof e=="string")?e:e.clipboardData.getData("text");};
a.getPastedDataAs2DArray=function(e){var d,r,R=[];var b=/sapui5Placeholder4MultiLine/g;var p=b.source;var c=/""/g;var D=this.getClipboardText(e);var f=[];var m=false;var g=D.indexOf("\""),h=-1;var k,l;while(g>-1){l=D.charAt(g-1);if((g===0)||(l==='\n')||(l==='\t')||(l==='\r')){h=D.indexOf("\"",g+1);if(h>-1){k=D.charAt(h+1);while((h>-1)&&(k==='\"')){h=D.indexOf("\"",h+2);k=D.charAt(h+1);}if((k==='\n')||(k==='\t')||(k==='')||(k==='\r')){var M=D.substring(g+1,h);D=D.replace("\""+M+"\"",p);M=M.replace(c,"\"");f.push(M);g=D.indexOf("\"",g+p.length+1);m=true;}}}if(!m){g=D.indexOf("\"",g+1);}m=false;}d=D.split(/\r\n|\r|\n/);var j=0;var G=function(){return f[j++];};for(var i=0;i<d.length;i++){r=d[i];if(f.length>0){r=r.replace(b,G);}if(r.length||i<d.length-1){R.push(r.split("\t"));}}return R;};
a.parse=function(d,c){var r={parsedData:null,errors:null};if(!d){throw new Error("Parameter aData is not specified");}if(c){for(var i=0;i<c.length;i++){var o=c[i];if(o.ignore){continue;}if(o.property){if(o.type){var t=o.type;if(t.isA&&t.isA("sap.ui.model.SimpleType")){o.typeInstance=t;}else{throw new Error("Data type "+o.type+" is not an instance of any data type");}}else if(o.customParseFunction==undefined){throw new Error("Missing ColumnInfo.type or custom type parse function for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing type in the parameter aColumnInfo.");}}else{throw new Error("Missing ColumnInfo.property for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing property in the parameter aColumnInfo.");}}}else{throw new Error("Missing parameter aColumnInfo");}var e=[],R=[],b=C.getLibraryResourceBundle();var p=function(g,t){return t.parseValue(g,"string");};var v=function(g,t){return t.validateValue(g);};for(var i=0;i<d.length;i++){var f=d[i];var s=a._parseRow(f,c,i,p,v,b,e);R.push(s);}return Promise.all(R).then(function(g){if(e.length>0){r.parsedData=null;r.errors=e;}else{if(g){r.parsedData=g;}r.errors=null;}return r;});};
a._parseRow=function(r,c,R,p,v,b,e){var d=[],o={};for(var i=0;(i<c.length)&&(i<r.length);i++){var f=c[i];if(f.ignore){continue;}var s=r[i];if(!f.typeInstance){p=f.customParseFunction;v=function(){};}var S=a._parseCell(i,s,f,R,p,v,b,o,e);d.push(S);}return Promise.all(d).then(function(){return o;});};
a._parseCell=function(i,c,o,r,p,v,b,O,e){return Promise.resolve(c).then(function(d){return p(d,o.typeInstance);}).then(function(d){return Promise.all([d,v(d,o.typeInstance)]);}).then(function(R){O[o.property]=R[0];}).catch(function(E){if(E instanceof P||E instanceof V){var d={row:r+1,column:i+1,property:o.property,value:c,type:o.type,message:b.getText("PasteHelper.ErrorMessage",[c,r+1,i+1])+" "+E.message+"\n"};e.push(d);c=null;}else{L.error(E);}});};
return a;});
sap.ui.predefine('sap/ui/core/util/ResponsivePaddingsEnablement',["sap/base/Log",'sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery","sap/ui/core/library"],function(L,R,q){"use strict";var B={S:599,M:1023,L:1439};var M={S:"sapUi-Std-PaddingS",M:"sapUi-Std-PaddingM",L:"sapUi-Std-PaddingL",XL:"sapUi-Std-PaddingXL"};var a=function(s){if(!this.isA||!this.isA("sap.ui.core.Control")){L.error("Responsive Paddings enablement could be applied over controls only");return;}this._initResponsivePaddingsEnablement=function(){this.addEventDelegate({onAfterRendering:b,onBeforeRendering:o},this);};function o(){c(this);}function b(){var S=e(this,s);if(S.length){window.requestAnimationFrame(function(){_(this);}.bind(this));}}function _(C){d(C);if(!C.__iResponsivePaddingsResizeHandlerId__){C.__iResponsivePaddingsResizeHandlerId__=R.register(C,d.bind(C,C));}}function c(C){if(C.__iResponsivePaddingsResizeHandlerId__){R.deregister(C.__iResponsivePaddingsResizeHandlerId__);C.__iResponsivePaddingsResizeHandlerId__=null;}}function d(C,E){var r=e(C,s);var $=f(C,r);var w=E?E.size.width:C.$().width();g($);h($,w);}function e(C,s){var S=i(s);S=S.filter(function(j){return C.hasStyleClass(j);});if(!S.length){return[];}S=S.map(function(j){return j.split("--")[1];});S=S.map(function(A){return s[A];}).filter(function(j){return j;});return S;}function f(C,S){var $=q();S.forEach(function(j){if(j.suffix){$=$.add(C.$(j.suffix));}if(j.selector){$=$.add(C.$().find(j.selector).first());}});return $;}function g($){var C=Object.keys(M).map(function(k){return M[k];});$.each(function(j,k){var l=q(k).control(0);if(k===l.getDomRef()){C.forEach(l.removeStyleClass.bind(l));}else{q(k).removeClass(C.join(" "));}});}function h($,w){var k;switch(true){case w<=B.S:k="S";break;case w<=B.M&&w>B.S:k="M";break;case w<=B.L&&w>B.M:k="L";break;default:k="XL";break;}$.each(function(j,l){var C=q(l).control(0);if(l===C.getDomRef()){C.addStyleClass(M[k]);}else{q(l).addClass(M[k]);}});}function i(s){return Object.keys(s).map(function(k){return"sapUiResponsivePadding--"+k;});}};return a;});
sap.ui.predefine('sap/ui/core/util/ShortcutHelper',['sap/ui/Device','sap/ui/events/jquery/EventExtension'],function(D){"use strict";var k={plus:"+",space:" "};var E={OS:"Meta"};var d={"ctrl+l":"jump to address bar","ctrl+n":"new window, cannot be registered in Chrome","ctrl+shift+n":"new incognito window, cannot be registered in Chrome","ctrl+alt+shift+p":"UI5 Technical Info","ctrl+q":"quit Chrome in Mac","ctrl+alt+shift+s":"UI5 Support Popup","ctrl+t":"new tab, cannot be registered in Chrome","ctrl+shift+t":"reopen last tab, cannot be registered in Chrome","ctrl+w":"close tab, cannot be registered in Chrome","ctrl+shift+w":"close window, cannot be registered in Chrome","ctrl+0":"reset zoom","ctrl+-":"zoom out","ctrl++":"zoom in","ctrl+shift+=":"cannot be handled","tab":"TAB-based keyboard navigation","shift+tab":"TAB-based keyboard navigation","ctrl+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+shift+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+alt+delete":"nice try","ctrl+pageup":"cycling through tabs, cannot be registered in Chrome","ctrl+pagedown":"cycling through tabs, cannot be registered in Chrome","f6":"F6-based group navigation","f11":"fullscreen, cannot be registered in Chrome","f12":"browser dev tools"};var l=false;document.addEventListener('keydown',function(e){try{if(e.keyCode===18){l=(typeof e.location!=="number"||e.location===1);return;}}catch(a){}});var s={findShortcut:function(S,n){var r=S.data("sap.ui.core.Shortcut");if(!r){return;}var m=r.filter(function(o){var M=o.shortcutSpec.key===n.key&&o.shortcutSpec.ctrlKey===n.ctrlKey&&o.shortcutSpec.altKey===n.altKey&&o.shortcutSpec.shiftKey===n.shiftKey&&o.shortcutSpec.metaKey===n.metaKey;return M;});return m[0];},getNormalizedShortcutSpec:function(S){var n;if(typeof S==="string"){n=s.parseShortcut(S);}else{var a=S.key;var v=/^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.test(a);if(!v){throw new Error("Shortcut key '"+a+"' is not a valid shortcut key. It must match /^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i");}n={key:s.translateRegisteredKeyToStandard(a).toLowerCase(),ctrlKey:D.os.macintosh?false:!!S.ctrl,ctrlRequested:S.ctrl,altKey:!!S.alt,shiftKey:!!S.shift,metaKey:D.os.macintosh?!!S.ctrl:false};}return n;},parseShortcut:function(S){this.validateShortcutString(S);var p=S.toLowerCase().split("+");return{key:s.translateRegisteredKeyToStandard(p.pop()),ctrlKey:D.os.macintosh?false:p.indexOf("ctrl")>-1,ctrlRequested:p.indexOf("ctrl")>-1,altKey:p.indexOf("alt")>-1,shiftKey:p.indexOf("shift")>-1,metaKey:D.os.macintosh?p.indexOf("ctrl")>-1:false};},translateRegisteredKeyToStandard:function(K){return k.hasOwnProperty(K)?k[K]:K;},validateShortcutString:function(S){var v=/^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|Escape|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|F[1-9]|F1[0-2])$/i.test(S);if(!v){throw new Error("Shortcut '"+S+"' is not a valid shortcut string. It must be a '+'-separated list of modifier keys and the actual key, like 'Ctrl+Alt+S'. Or more generally, it must match the expression /^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.");}},validateKeyCombination:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;if(d[N]){throw new Error("Registering the shortcut '"+N+"' is not allowed ("+d[N]+").");}if([".",",","-","+","=","*","/"].indexOf(n.key)>-1&&N.indexOf("shift")>-1){throw new Error("Registering the shortcut '"+N+"' is not allowed because the 'Shift' modifier changes the meaning of the "+n.key+" key on many keyboards.");}},getNormalizedShortcutString:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;return N;},shortcutMayBeUsedHere:function(S,o){var t=o.tagName.toLowerCase();if((t==="input"||t==="textarea")&&S.key.includes("arrow")){return false;}return true;},handleKeydown:function(S,o,c,e){if(e.key==="Control"||e.key==="Shift"||e.key==="Alt"||e.key==="AltGraph"||e.key==="Meta"){return;}if(e.isMarked()){return;}if(e.altKey&&!l){return;}var a=E.hasOwnProperty(e.key)?E[e.key]:e.key;a=a.toLowerCase();if(a!==S.key||e.ctrlKey!==S.ctrlKey||e.altKey!==S.altKey||e.shiftKey!==S.shiftKey||e.metaKey!==S.metaKey){return;}if(!s.shortcutMayBeUsedHere(S,e.target||e.srcElement)){return;}e.preventDefault();e.setMarked();e.stopPropagation();var b={registeredShortcut:o,originalBrowserEvent:e.originalEvent||e};c(b);}};return s;});
sap.ui.predefine('sap/ui/core/util/XMLPreprocessor',["sap/base/Log","sap/base/util/deepExtend","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/core/Component","sap/ui/core/XMLTemplateProcessor","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/Context","sap/ui/performance/Measurement"],function(L,d,J,O,B,M,S,C,X,a,b,c,f){"use strict";var N="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1",x="sap.ui.core.util.XMLPreprocessor",p=[x],P=x+"/getResolvedBinding",s=x+"/insertFragment",g=x+".process",o=S.resolve(),h=S.resolve(true),t=Object.prototype.toString,v={},W=M.extend("sap.ui.core.util._with",{metadata:{library:"sap.ui.core",properties:{any:"any"},aggregations:{child:{multiple:false,type:"sap.ui.core.util._with"}}},updateProperty:function(){this.setAny(this.mBindingInfos.any.binding.getExternalValue());}}),R=W.extend("sap.ui.core.util._repeat",{metadata:{library:"sap.ui.core",aggregations:{list:{multiple:true,type:"n/a",_doesNotRequireFactory:true}}},updateList:function(){}});
function j(w,e,i,n){function r(y){if(!n){n=w.getBinding("any");if(n instanceof b){n=n.getBindings();if(i!==undefined){n=n[i];}}}return Array.isArray(n)?n[y]:n;}function u(y){return y instanceof c?y.getPath():y.getModel().resolve(y.getPath(),y.getContext());}return{getInterface:function(y,z){var A,D,E;if(typeof y==="string"){z=y;y=undefined;}r();if(Array.isArray(n)){if(y>=0&&y<n.length){D=n[y];}else{throw new Error("Invalid index of part: "+y);}}else if(y!==undefined){throw new Error("Not the root formatter of a composite binding");}else if(z){D=n;}else{throw new Error("Missing path");}if(z){E=D.getModel();if(z.charAt(0)!=='/'){A=D instanceof c?D:E.createBindingContext(D.getPath(),D.getContext());}D=E.createBindingContext(z,A);if(!D){throw new Error("Model could not create binding context synchronously: "+E);}}return j(null,e,undefined,D);},getModel:function(y){var z=r(y);return z&&z.getModel();},getPath:function(y){var z=r(y);return z&&u(z);},getSetting:function(y){if(y==="bindingContexts"||y==="models"){throw new Error("Illegal argument: "+y);}return e[y];}};}
function k(w,n,r,u,A){var V=false;function y(I,i){var F=I.formatter,z,D=I.model;if(I.path&&I.path.indexOf(">")>0){D=I.path.slice(0,I.path.indexOf(">"));}z=w.getModel(D);if(F&&F.requiresIContext===true){F=I.formatter=F.bind(null,j(w,r,i));}if(F&&A&&(z&&z.$$valueAsPromise||i===undefined&&V)){I.formatter=function(){var E=this;return S.all(arguments).then(function(G){return F.apply(E,G);});};I.formatter.textFragments=F.textFragments;}I.mode=a.OneTime;I.parameters=I.parameters||{};I.parameters.scope=u;if(A&&z&&z.$$valueAsPromise){V=I.parameters.$$valueAsPromise=true;}}try{if(n.parts){n.parts.forEach(y);}y(n);w.bindProperty("any",n);return w.getBinding("any")?S.resolve(w.getAny()):null;}catch(e){return S.reject(e);}finally{w.unbindProperty("any",true);}}
function l(e,n){var i=-1;function r(F){if(F){return e[i];}i+=1;if(i<e.length){return n(e[i],i,e).then(r);}}return e.length?r():o;}
function m(e){var A,r=e.attributes,T="<"+e.nodeName,i,n;for(i=0,n=r.length;i<n;i+=1){A=r.item(i);T+=" "+A.name+'="'+A.value+'"';}return T+(e.childNodes.length?">":"/>");}
function q(e,i){return i.visitNode(e);}
return{plugIn:function(V,n,e){var i=v[n];if(V!==null&&typeof V!=="function"||V===q){throw new Error("Invalid visitor: "+V);}if(!n||n===N||n==="sap.ui.core"||n.indexOf(" ")>=0){throw new Error("Invalid namespace: "+n);}L.debug("Plug-in visitor for namespace '"+n+"', local name '"+e+"'",V,x);if(e){n=n+" "+e;i=v[n]||i;}v[n]=V;return i||q;},visitNodeWrapper:q,process:function(r,V,u){var w=V.caller,D=L.isLoggable(L.Level.DEBUG,x),y=D,z=V.name,F={},A,E=0,G={},H=V._supportInfo,I=L.isLoggable(L.Level.WARNING,x);function K(i){return{find:function(n,q1){try{return S.resolve(l(n,q1));}catch(e){return S.reject(e);}},getContext:function(e){var n,q1,r1;e=e||"";if(e[0]==="{"){throw new Error("Must be a simple path, not a binding: "+e);}n=B.simpleParser("{"+e+"}");q1=i.getModel(n.model);if(!q1){throw new Error("Unknown model '"+n.model+"': "+e);}r1=q1.resolve(n.path,i.getBindingContext(n.model));if(!r1){throw new Error("Cannot resolve path: "+e);}return q1.createBindingContext(r1);},getResult:function(e,n){return _(e,n,i,true);},getSettings:function(){return u;},getViewInfo:function(){return d({},V);},insertFragment:function(e,n){return a1(e,n,i);},visitAttribute:function(e,n){return l1(e,n,i);},visitAttributes:function(e){return m1(e,i);},visitChildNodes:function(n){return n1(n,i);},visitNode:function(n){try{return o1(n,i);}catch(e){return S.reject(e);}},"with":function(e,n){var q1,r1=false,A,s1=new W();if(!n){i.setChild(s1);}for(A in e){q1=e[A];r1=true;s1.setModel(q1.getModel(),A);s1.bindObject({model:A,path:q1.getPath()});}return r1||n?K(s1):this;}};}function Q(e){if(D){L.debug(Z()+Array.prototype.slice.call(arguments,1).join(" "),e&&m(e),x);}}function T(e){if(D){L.debug(Z()+"Finished","</"+e.nodeName+">",x);}}function U(e,i){e=e+m(i);L.error(e,w,x);throw new Error(w+": "+e);}function Y(e){var q1,r1=Array.prototype.filter.call(e.childNodes,t1),i,n,s1=false;function t1(v1){return v1.nodeType===1;}function u1(v1,w1){return v1.namespaceURI===N&&v1.localName===w1;}if(!r1.length||!u1(r1[0],"then")){return null;}for(i=1,n=r1.length;i<n;i+=1){q1=r1[i];if(s1){U("Expected </"+e.prefix+":if>, but instead saw ",q1);}if(u1(q1,"else")){s1=true;}else if(!u1(q1,"elseif")){U("Expected <"+e.prefix+":elseif> or <"+e.prefix+":else>, but instead saw ",r1[i]);}}return r1;}function Z(){return(E<10?"[ ":"[")+E+"] ";}function $(A){return A&&A.charAt(0)==="."?O.get(A.slice(1),G):O.get(A||"",G)||O.get(A||"");}function _(i,n,q1,r1,s1){var t1,u1;f.average(P,"",p);try{t1=B.complexParser(i,G,r1,true,true,true)||i;}catch(e){return S.reject(e);}if(t1.functionsNotFound){if(r1){p1(n,'Function name(s)',t1.functionsNotFound.join(", "),'not found');}f.end(P);return null;}if(typeof t1==="object"){u1=k(q1,t1,u,G,!V.sync);if(r1&&!u1){p1(n,'Binding not ready');}else if(V.sync&&u1&&u1.isPending()){U("Async formatter in sync view in "+i+" of ",n);}}else{u1=S.resolve(t1);if(s1){s1();}}f.end(P);return u1;}function a1(e,i,n){var q1,r1=V.sync?X.loadTemplate:X.loadTemplatePromise,s1=z;n.$mFragmentContexts=n.$mFragmentContexts||{};if(n.$mFragmentContexts[e]){U("Cyclic reference to fragment '"+e+"' ",i);}E++;Q(i,"fragmentName =",e);n.$mFragmentContexts[e]=true;z=e;f.average(s,"",p);q1=F[e];if(!q1){F[e]=q1=S.resolve(r1(e,"fragment"));}return q1.then(function(t1){t1=i.ownerDocument.importNode(t1,true);f.end(s);return d1(t1).then(function(){if(t1.namespaceURI==="sap.ui.core"&&t1.localName==="FragmentDefinition"){return b1(t1,n,i);}i.parentNode.insertBefore(t1,i);return o1(t1,n);});}).then(function(){i.parentNode.removeChild(i);z=s1;n.$mFragmentContexts[e]=false;T(i);E-=1;});}function b1(e,i,n){return n1(e,i).then(function(){var q1;n=n||e;while((q1=e.firstChild)){n.parentNode.insertBefore(q1,n);}});}function c1(e,i){var n=p1.bind(null,e,'Constant test condition'),q1=_(e.getAttribute("test"),e,i,true,n)||S.resolve(false);return q1.catch(function(ex){p1(e,'Error in formatter:',ex);}).then(function(r1){var s1=!!r1&&r1!=="false";if(D){if(typeof r1==="string"){r1=JSON.stringify(r1);}else if(r1===undefined){r1="undefined";}else if(Array.isArray(r1)){r1="[object Array]";}Q(e,"test ==",r1,"-->",s1);}return s1;});}function d1(e){var n={},q1=e.getAttributeNodeNS(N,"require"),r1,s1;function t1(){return new S(function(i,u1){var v1=s1.map(sap.ui.require);if(v1.every(Boolean)){i(v1);}else{sap.ui.require(s1,function(){i(arguments);},u1);}}).then(function(u1){Object.keys(n).forEach(function(v1,i){G[v1]=u1[i];});});}if(q1&&q1.value){r1=q1.value;e.removeAttributeNode(q1);if(r1[0]==="{"){n=J.parseJS(r1);s1=Object.keys(n).map(function(i){return n[i];});return t1();}s1=r1.split(" ").map(function(i){return i.replace(/\./g,"/");});if(!V.sync){return t1();}s1.forEach(sap.ui.requireSync);}return o;}function e1(e,i,n){var q1=_(i.value,e,n,false);if(!q1){Q(e,'Binding not ready for attribute',i.name);return o;}return q1.then(function(r1){if(r1===undefined){Q(e,"Removed attribute",i.name);e.removeAttributeNode(i);}else if(r1!==i.value){switch(typeof r1){case"boolean":case"number":case"string":Q(e,i.name,"=",r1);i.value=r1;break;default:Q(e,"Ignoring",t.call(r1),"value for attribute",i.name);}}},function(r1){Q(e,"Error in formatter of attribute",i.name,r1);});}function f1(e,i){var A=e.getAttribute("name"),n,q1,r1=e.getAttribute("value");if(A&&A[0]==="."){A=A.slice(1);}if(!A||A.includes(".")){U("Missing proper relative name in ",e);}n=$(r1);if(!n){U("Invalid value in ",e);}q1=G[A];G[A]=n;return b1(e,i).then(function(){e.parentNode.removeChild(e);G[A]=q1;});}function g1(e,i){var n=e.getAttribute("name"),q1=_(n,e,i,true);if(!q1){return h;}return q1.then(function(A){var r1;if(A!==n){Q(e,"name =",A);}r1=C.getCustomizing(V.componentId,{extensionName:A,name:z,type:"sap.ui.viewExtensions"});if(r1&&r1.className==="sap.ui.core.Fragment"&&r1.type==="XML"){return a1(r1.fragmentName,e,i);}return true;},function(ex){p1(e,'Error in formatter:',ex);return true;});}function h1(e,i){var n=e.getAttribute("fragmentName"),q1=_(n,e,i,true);if(!q1){return o;}return q1.then(function(n){var r1=G;G=Object.create(G);return a1(n,e,i).then(function(){G=r1;});},function(ex){p1(e,'Error in formatter:',ex);});}function i1(i,e){E++;return l(Y(i)||[i],function(n){if(n.localName==="else"){return h;}if(n.localName==="then"){n=i;}return c1(n,e);}).then(function(n){return(n?b1(n,e,i):o).then(function(){i.parentNode.removeChild(i);T(i);E-=1;});});}function j1(e,n){var q1=e.getAttribute("list")||"",r1=B.complexParser(q1,G,false,true,true,true),s1,t1,u1,v1,w1,x1=e.getAttribute("var");if(x1===""){U("Missing variable name for ",e);}if(!r1){U("Missing binding for ",e);}if(r1.functionsNotFound){p1(e,'Function name(s)',r1.functionsNotFound.join(", "),'not found');}v1=new R();n.setChild(v1);r1.mode=a.OneTime;v1.bindAggregation("list",r1);t1=v1.getBinding("list");v1.unbindAggregation("list",true);u1=r1.model;if(!t1){U("Missing model '"+u1+"' in ",e);}t1.enableExtendedChangeDetection();s1=t1.getContexts(r1.startIndex,r1.length||Infinity);if(!V.sync&&s1.dataRequested){w1=new S(function(i){t1.attachEventOnce("change",i);}).then(function(){return t1.getContexts(r1.startIndex,r1.length);});}else{w1=S.resolve(s1);}x1=x1||u1;v1.setModel(t1.getModel(),x1);E++;Q(e,"Starting");return w1.then(function(s1){return l(s1,function(y1,i){var z1=(i===s1.length-1)?e:e.cloneNode(true);v1.setBindingContext(y1,x1);Q(e,x1,"=",y1.getPath());return b1(z1,v1,e);}).then(function(){T(e);E-=1;e.parentNode.removeChild(e);});});}function k1(e,i){var n,q1,r1,s1,t1=e.getAttribute("helper"),u1,v1=e.getAttribute("path"),w1,x1,y1=e.getAttribute("var");if(y1===""){U("Missing variable name for ",e);}r1=new W();i.setChild(r1);n=B.simpleParser("{"+v1+"}");y1=y1||n.model;if(t1||y1){q1=i.getModel(n.model);if(!q1){U("Missing model '"+n.model+"' in ",e);}x1=q1.resolve(n.path,i.getBindingContext(n.model));if(!x1){U("Cannot resolve path for ",e);}u1=q1.createBindingContext(x1);if(t1){s1=$(t1);if(typeof s1!=="function"){U("Cannot resolve helper for ",e);}u1=s1(u1);}w1=S.resolve(u1);if(V.sync&&w1.isPending()){U("Async helper in sync view in ",e);}w1=w1.then(function(u1){if(u1 instanceof c){q1=u1.getModel();x1=u1.getPath();}else if(u1!==undefined){if(typeof u1!=="string"||u1===""){U("Illegal helper result '"+u1+"' in ",e);}x1=u1;}r1.setModel(q1,y1);r1.bindObject({model:y1,path:x1});});}else{x1=v1;r1.bindObject(x1);w1=o;}return w1.then(function(){E++;Q(e,y1,"=",x1);if(r1.getBindingContext(y1)===i.getBindingContext(y1)){p1(e,'Set unchanged path:',x1);r1=i;}return b1(e,r1).then(function(){e.parentNode.removeChild(e);T(e);E-=1;});});}function l1(e,i,n){if(H){H({context:undefined,env:{caller:"visitAttribute",before:{name:i.name,value:i.value}}});}return e1(e,i,n).then(function(){if(H){H({context:undefined,env:{caller:"visitAttribute",after:{name:i.name,value:i.value}}});}});}function m1(e,i){function n(q1,r1){return q1.name.localeCompare(r1.name);}return l(Array.prototype.slice.apply(e.attributes).sort(n),function(q1){return l1(e,q1,i);});}function n1(n,e){return l(Array.prototype.slice.apply(n.childNodes),function(i){return o1(i,e);});}function o1(n,e){var i;function q1(){return m1(n,e).then(function(){return n1(n,e);}).then(function(){if(H){H({context:n,env:{caller:"visitNode",after:{name:n.tagName}}});}});}if(n.nodeType!==1){return o;}if(H){H({context:n,env:{caller:"visitNode",before:{name:n.tagName}}});}if(n.namespaceURI===N){switch(n.localName){case"alias":return f1(n,e);case"if":return i1(n,e);case"repeat":return j1(n,e);case"with":return k1(n,e);default:U("Unexpected tag ",n);}}else if(n.namespaceURI==="sap.ui.core"){switch(n.localName){case"ExtensionPoint":return g1(n,e).then(function(r1){if(r1){return q1();}});case"Fragment":if(n.getAttribute("type")==="XML"){return h1(n,e);}break;}}else{i=v[n.namespaceURI+" "+n.localName]||v[n.namespaceURI];if(i){E++;Q(n,"Calling visitor");return i(n,K(e)).then(function(r1){if(r1!==undefined){U("Unexpected return value from visitor for ",n);}T(n);E-=1;});}}return q1();}function p1(e){if(I){if(!y){y=true;L.warning("Warning(s) during processing of "+w,null,x);}L.warning(Z()+Array.prototype.slice.call(arguments,1).join(" "),e&&m(e),x);}}f.average(g,"",p);u=u||{};if(D){Q(undefined,"Start processing",w);if(u.bindingContexts instanceof c){Q(undefined,"undefined =",u.bindingContexts);}else{for(A in u.bindingContexts){Q(undefined,A,"=",u.bindingContexts[A]);}}}if(H){H({context:r,env:{caller:"view",viewinfo:d({},V),settings:d({},u),clone:r.cloneNode(true),type:"template"}});}return d1(r).then(function(){return o1(r,new W({models:u.models,bindingContexts:u.bindingContexts}));}).then(function(){Q(undefined,"Finished processing",w);f.end(g);return r;}).unwrap();}};},true);
sap.ui.predefine('sap/ui/core/util/reflection/BaseTreeModifier',["sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/ui/core/XMLTemplateProcessor","sap/ui/core/util/XMLPreprocessor","sap/base/util/isPlainObject","sap/base/Log"],function(M,a,O,X,b,c,d,L){"use strict";return{bySelectorExtensionPointEnabled:function(s,A,v){return Promise.resolve(this.bySelector(s,A,v));},bySelectorTypeIndependent:function(s,A,v){var C;return Promise.resolve().then(function(){if(s&&s.name){v=v||this.bySelector(s.viewSelector,A);return this.getExtensionPointInfo(s.name,v).then(function(e){return e?e.parent:undefined;});}C=this.getControlIdBySelector(s,A);return this._byId(C,v);}.bind(this));},bySelector:function(s,A,v){var C=this.getControlIdBySelector(s,A);return this._byId(C,v);},getControlIdBySelector:function(s,A){if(!s){return undefined;}if(typeof s==="string"){s={id:s};}var C=s.id;if(s.idIsLocal){if(A){C=A.createId(C);}else{throw new Error("App Component instance needed to get a control's ID from selector");}}return C;},getSelector:function(C,A,m){var s=C;if(typeof s!=="string"){s=(C)?this.getId(C):undefined;}else if(!A){throw new Error("App Component instance needed to get a selector from string ID");}if(m&&(m.id||m.idIsLocal)){throw new Error("A selector of control with the ID '"+s+"' was requested, "+"but core properties were overwritten by the additionally passed information.");}var v=this.checkControlId(s,A);if(!v){throw new Error("Generated ID attribute found - to offer flexibility a stable control ID is needed to assign the changes to, but for this control the ID was generated by SAPUI5 "+s);}var S=Object.assign({},m,{id:"",idIsLocal:false});if(this.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);S.id=l;S.idIsLocal=true;}else{S.id=s;}return S;},checkControlId:function(C,A){var s=C instanceof M?C.getId():C;var i=a.isGeneratedId(s);return!i||this.hasLocalIdSuffix(C,A);},hasLocalIdSuffix:function(C,A){var s=(C instanceof M)?C.getId():C;if(!A){L.error("Determination of a local ID suffix failed due to missing app component for "+s);return false;}return!!A.getLocalId(s);},_checkAndPrefixIdsInFragment:function(f,I){var p=X.getParseError(f);if(p.errorCode!==0){return Promise.reject(new Error(f.parseError.reason));}var C=f.documentElement;var r=[],e=[];if(C.localName==="FragmentDefinition"){r=this._getElementNodeChildren(C);}else{r=[C];}e=[].concat(r);function o(g){e.push(g);}var P=Promise.resolve();for(var i=0,n=r.length;i<n;i++){P=P.then(this._traverseXmlTree.bind(this,o,r[i]));}return P.then(function(){for(var j=0,m=e.length;j<m;j++){if(e[j].getAttribute("id")){e[j].setAttribute("id",I+"."+e[j].getAttribute("id"));}else{throw new Error("At least one control does not have a stable ID");}}return C;});},_getElementNodeChildren:function(N){var C=[];var e=N.childNodes;for(var i=0,n=e.length;i<n;i++){if(e[i].nodeType===1){C.push(e[i]);}}return C;},_getControlMetadataInXml:function(C){var s=this._getControlTypeInXml(C).replace(/\./g,"/");var o=sap.ui.require(s);if(o&&o.getMetadata){return Promise.resolve(o.getMetadata());}return new Promise(function(r,R){sap.ui.require([s],function(e){if(e.getMetadata){r(e.getMetadata());}R(new Error("getMetadata function is not available on control type"));},function(){R(new Error("Required control '"+s+"' couldn't be found"));});});},getControlMetadata:function(C){},getLibraryName:function(C){return this.getControlMetadata(C).then(function(m){return m.getLibraryName();});},_getControlTypeInXml:function(C){var s=C.namespaceURI;s=s?s+".":"";s+=C.localName;return s;},_traverseXmlTree:function(C,r){function e(p,o,i){return Promise.resolve().then(function(){if(!i){return this._getControlMetadataInXml(o,true);}return undefined;}.bind(this)).then(function(m){return m&&m.getAllAggregations();}).then(function(A){var f=this._getElementNodeChildren(o);var P=Promise.resolve();f.forEach(function(g){var I=A&&A[g.localName];P=P.then(function(){return e.call(this,o,g,I).then(function(){if(!I){C(g);}});}.bind(this));}.bind(this));return P;}.bind(this));}return e.call(this,r,r,false);},_getSerializedValue:function(p){if(this._isSerializable(p)&&typeof p!=="string"){return JSON.stringify(p);}return p;},_isSerializable:function(p){return d(p)||Array.isArray(p)||Object(p)!==p;},_escapeCurlyBracketsInString:function(p){return typeof p==="string"?p.replace(/({|})/g,"\\$&"):p;},_templateFragment:function(f,p){return Promise.resolve(c.process(b.loadTemplate(f,"fragment"),{name:f},p));},getPropertyBindingOrProperty:function(C,p){var P=this.getPropertyBinding(C,p);if(P){return Promise.resolve(P);}return this.getProperty(C,p);},setPropertyBindingOrProperty:function(C,p,B){var i=B&&(B.path||B.parts);var I=B&&typeof B==="string"&&B.substring(0,1)==="{"&&B.slice(-1)==="}";var o=i||I?"setPropertyBinding":"setProperty";this[o](C,p,B);},setVisible:function(C,v){},getVisible:function(C){},setStashed:function(C,s){},getStashed:function(C){},bindProperty:function(C,p,B){},unbindProperty:function(C,p){},bindAggregation:function(C,A,B){},unbindAggregation:function(C,A){},setProperty:function(C,p,P){},getProperty:function(C,p){},isPropertyInitial:function(C,p){},setPropertyBinding:function(C,p,P){},getPropertyBinding:function(C,p){},createAndAddCustomData:function(C,s,v,A){},createControl:function(C,A,v,s,S){},applySettings:function(C,s){},_byId:function(i,v){},getId:function(C){},getParent:function(C){},getControlType:function(C){},setAssociation:function(p,n,i){},getAssociation:function(p,n){},getAllAggregations:function(C){},getAggregation:function(p,n){},insertAggregation:function(p,A,o,i,v,s){},removeAggregation:function(p,A,o){},removeAllAggregation:function(p,A){},getBindingTemplate:function(C,A){},updateAggregation:function(p,A){},findIndexInParentAggregation:function(C){},getParentAggregationName:function(C,p){},findAggregation:function(C,A){},validateType:function(C,A,p,f,i){},instantiateFragment:function(f,n,v){},templateControlFragment:function(f,p,v){},destroy:function(C){},getChangeHandlerModulePath:function(C){return this._getFlexCustomData(C,"flexibility");},_getFlexCustomData:function(C){},getFlexDelegate:function(C){var D;var s=this._getFlexCustomData(C,"delegate");if(typeof s==="string"){try{D=JSON.parse(s);if(D.payload===undefined){D.payload={};}}catch(e){L.error("Flex Delegate for control "+this.getId(C)+" is malformed",e.message);}}return D;},attachEvent:function(C,e,f,D){},detachEvent:function(C,e,f){},getExtensionPointInfo:function(e,v){}};});
sap.ui.predefine('sap/ui/core/util/reflection/JsControlTreeModifier',["sap/ui/base/BindingParser","./BaseTreeModifier","./XmlTreeModifier","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/base/util/merge","sap/ui/core/Fragment"],function(B,a,X,O,b,m,F){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return Promise.resolve(c.getVisible());}else{return Promise.reject(new Error("Provided control instance has no getVisible method"));}},setStashed:function(c,s){s=!!s;if(c.unstash){if(c.isStashed()===true&&s===false){c=c.unstash();}if(c.setVisible){this.setVisible(c,!s);}return c;}else{throw new Error("Provided control instance has no unstash method");}},getStashed:function(c){if(c.isStashed){if(c.isStashed()){return Promise.resolve(true);}return this.getVisible(c).then(function(i){return!i;});}return Promise.reject(new Error("Provided control instance has no isStashed method"));},bindProperty:function(c,p,v){c.bindProperty(p,v);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var M=c.getMetadata().getPropertyLikeSetting(p);var o;var e;this.unbindProperty(c,p);try{o=B.complexParser(P,undefined,true);}catch(d){e=true;}if(M){if(this._isSerializable(P)){if(o&&typeof o==="object"||e){P=this._escapeCurlyBracketsInString(P);}var s=M._sMutator;c[s](P);}else{throw new TypeError("Value cannot be stringified","sap.ui.core.util.reflection.JsControlTreeModifier");}}},getProperty:function(c,p){var M=c.getMetadata().getPropertyLikeSetting(p);var P;if(M){var s=M._sGetter;P=c[s]();}return Promise.resolve(P);},isPropertyInitial:function(c,p){return c.isPropertyInitial(p);},setPropertyBinding:function(c,p,P){this.unbindProperty(c,p);var s={};s[p]=P;return c.applySettings(s);},getPropertyBinding:function(c,p){return c.getBindingInfo(p);},createAndAddCustomData:function(c,C,v,A){return this.createControl("sap.ui.core.CustomData",A).then(function(o){this.setProperty(o,"key",C);this.setProperty(o,"value",v);return this.insertAggregation(c,"customData",o,0);}.bind(this));},createControl:function(c,A,v,s,S){c=c.replace(/\./g,"/");if(this.bySelector(s,A)){var e="Can't create a control with duplicated ID "+(s.id||s);return Promise.reject(e);}var p;var C=sap.ui.require(c);if(C){p=Promise.resolve(C);}else{p=new Promise(function(r,R){sap.ui.require([c],function(C){r(C);},function(){R(new Error("Required control '"+c+"' couldn't be created asynchronously"));});});}return p.then(function(d){var i=this.getControlIdBySelector(s,A);return new d(i,S);}.bind(this));},applySettings:function(c,s){return Promise.resolve(c.applySettings(s));},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent&&c.getParent();},getControlMetadata:function(c){return Promise.resolve(c&&c.getMetadata());},getControlType:function(c){return c&&c.getMetadata().getName();},setAssociation:function(p,n,i){var M=p.getMetadata().getAssociation(n);M.set(p,i);},getAssociation:function(p,n){var M=p.getMetadata().getAssociation(n);return M.get(p);},getAllAggregations:function(p){return Promise.resolve(p.getMetadata().getAllAggregations());},getAggregation:function(p,n){return this.findAggregation(p,n).then(function(A){if(A){return p[A._sGetter]();}return undefined;});},insertAggregation:function(p,n,o,i){if(n==="customData"){return p.insertAggregation(n,o,i,true);}return this.findAggregation(p,n).then(function(A){if(A){if(A.multiple){var I=i||0;p[A._sInsertMutator](o,I);}else{p[A._sMutator](o);}}});},removeAggregation:function(c,n,o){if(n==="customData"){c.removeAggregation(n,o,true);return Promise.resolve();}return this.findAggregation(c,n).then(function(A){if(A){c[A._sRemoveMutator](o);}});},removeAllAggregation:function(c,n){if(n==="customData"){c.removeAllAggregation(n,true);return Promise.resolve();}return this.findAggregation(c,n).then(function(A){if(A){c[A._sRemoveAllMutator]();}});},getBindingTemplate:function(c,A){var o=c.getBindingInfo(A);return Promise.resolve(o&&o.template);},updateAggregation:function(c,A){return this.findAggregation(c,A).then(function(o){if(o&&c.getBinding(A)){c[o._sDestructor]();c.updateAggregation(A);}});},findIndexInParentAggregation:function(c){var p=this.getParent(c);if(!p){return Promise.resolve(-1);}return this.getParentAggregationName(c).then(function(P){return this.getAggregation(p,P);}.bind(this)).then(function(C){if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}});},getParentAggregationName:function(c){return Promise.resolve(c.sParentAggregationName);},findAggregation:function(c,A){return new Promise(function(r,d){if(c){if(c.getMetadata){var M=c.getMetadata();var o=M.getAllAggregations();if(o){r(o[A]);return;}}}r();});},validateType:function(c,A,p,f){var t=A.type;return this.getAggregation(p,A.name).then(function(o){if(A.multiple===false&&o&&o.length>0){return false;}return c.isA(t);});},instantiateFragment:function(f,n,v){var o=b.parse(f);return this._checkAndPrefixIdsInFragment(o,n).then(function(o){return F.load({definition:o,sId:v&&v.getId(),controller:v.getController()});}).then(function(N){if(N&&!Array.isArray(N)){N=[N];}return N||[];});},templateControlFragment:function(f,p,v){return a._templateFragment(f,p).then(function(o){var c=(v&&v.getController())||undefined;return F.load({definition:o,controller:c});});},destroy:function(c,s){c.destroy(s);},_getFlexCustomData:function(c,t){var C=typeof c==="object"&&typeof c.data==="function"&&c.data("sap-ui-custom-settings");return O.get(["sap.ui.fl",t],C);},attachEvent:function(o,e,f,d){return new Promise(function(r,R){var c=O.get(f);if(typeof c!=="function"){R(new Error("Can't attach event because the event handler function is not found or not a function."));}r(o.attachEvent(e,d,c));});},detachEvent:function(o,e,f){return new Promise(function(r,R){var c=O.get(f);if(typeof c!=="function"){R(new Error("Can't attach event because the event handler function is not found or not a function."));}r(o.detachEvent(e,c));});},bindAggregation:function(c,A,o){return Promise.resolve(c.bindAggregation(A,o));},unbindAggregation:function(c,A){return Promise.resolve(c.unbindAggregation(A));},getExtensionPointInfo:function(e,v){var V=(v._xContent)?v._xContent:v;return X.getExtensionPointInfo(e,V).then(function(E){if(E){E.index--;E.parent=E.parent&&this._byId(v.createId(E.parent.getAttribute("id")));E.defaultContent=E.defaultContent.map(function(n){var i=v.createId(n.getAttribute("id"));return this._byId(i);}.bind(this)).filter(function(c){return!!c;});}return E;}.bind(this));}};return m({},a,J);},true);
sap.ui.predefine('sap/ui/core/util/reflection/XmlTreeModifier',["./BaseTreeModifier","sap/ui/base/ManagedObject","sap/ui/base/DataType","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/mvc/EventHandlerResolver","sap/base/util/includes","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/core/Fragment"],function(B,M,D,m,X,E,a,O,b,F){"use strict";var C="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var c=m({},B,{targets:"xmlTree",setVisible:function(o,v){if(v){o.removeAttribute("visible");}else{o.setAttribute("visible",v);}},getVisible:function(o){return c.getProperty(o,"visible");},setStashed:function(o,s){if(!s){o.removeAttribute("stashed");}else{o.setAttribute("stashed",s);}c.setVisible(o,!s);},getStashed:function(o){return Promise.all([c.getProperty(o,"stashed"),c.getProperty(o,"visible")]).then(function(p){return!!p[0]||!p[1];});},bindProperty:function(o,p,v){o.setAttribute(p,"{"+v+"}");},unbindProperty:function(o,p){o.removeAttribute(p);},_setProperty:function(o,p,P,e){var v=c._getSerializedValue(P);if(e){v=c._escapeCurlyBracketsInString(v);}o.setAttribute(p,v);},setProperty:function(o,p,P){c._setProperty(o,p,P,true);},getProperty:function(o,p){var P;var t;var v=o.getAttribute(p);return c.getControlMetadata(o).then(function(d){P=d.getProperty(p);if(P){t=P.getType();if(p==="value"&&c.getControlType(o)==="sap.ui.core.CustomData"){return c.getProperty(o,"key").then(function(k){if(k==="sap-ui-custom-settings"){t=D.getType("object");}});}}return undefined;}).then(function(){if(P){if(v===null){v=P.getDefaultValue()||t.getDefaultValue();}else{var u=M.bindingParser(v,undefined,true);if(b(u)){if(u.path||u.parts){v=undefined;}else{v=u;}}else{v=t.parseValue(u||v);}}}return v;});},isPropertyInitial:function(o,p){var P=o.getAttribute(p);return(P==null);},setPropertyBinding:function(o,p,P){if(typeof P!=="string"){throw new Error("For XML, only strings are supported to be set as property binding.");}o.setAttribute(p,P);},getPropertyBinding:function(o,p){var P=o.getAttribute(p);if(P){var u=M.bindingParser(P,undefined,true);if(u&&(u.path||u.parts)){return u;}}return undefined;},createAndAddCustomData:function(o,s,v){o.setAttributeNS(C,"custom.data.via.modifier:"+s,c._escapeCurlyBracketsInString(v));return Promise.resolve();},createControl:function(s,A,v,S,d,e){var i,l,o;if(!c.bySelector(S,A,v)){var f=s.split('.');var n="";if(f.length>1){l=f.pop();n=f.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=c.getControlIdBySelector(S,A);if(i){N.setAttribute("id",i);}return Promise.resolve().then(function(){if(d){return c.applySettings(N,d);}return undefined;}).then(function(){return Promise.resolve(N);});}else{o=new Error("Can't create a control with duplicated ID "+i);return Promise.reject(o);}},applySettings:function(o,s){return c.getControlMetadata(o).then(function(d){var e=d.getJSONKeys();Object.keys(s).forEach(function(k){var K=e[k];var v=s[k];switch(K._iKind){case 0:c._setProperty(o,k,v,false);break;case 3:c.setAssociation(o,k,v);break;default:throw new Error("Unsupported in applySettings on XMLTreeModifier: "+k);}});});},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}return v.querySelector("[id='"+i+"']");}return undefined;},getId:function(o){return o.getAttribute("id");},getParent:function(o){var p=o.parentNode;if(!c.getId(p)&&!c._isExtensionPoint(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(o){return c._getControlTypeInXml(o);},setAssociation:function(p,n,i){if(typeof i!=="string"){i=c.getId(i);}p.setAttribute(n,i);},getAssociation:function(p,n){return p.getAttribute(n);},getAllAggregations:function(o){return c.getControlMetadata(o).then(function(d){return d.getAllAggregations();});},getAggregation:function(p,n){var d=[];var s;return c._isSingleValueAggregation(p,n).then(function(S){s=S;return c._findAggregationNode(p,n);}).then(function(A){if(A){return c._getControlsInAggregation(p,A).then(function(e){d=e;});}return c._isAltTypeAggregation(p,n).then(function(i){if(i&&s){return c.getProperty(p,n).then(function(o){d.push(o);});}return undefined;});}).then(function(){if(n==="customData"){var e;var N=Array.prototype.slice.call(p.attributes).reduce(function(f,A){var l=c._getLocalName(A);if(A.namespaceURI===C){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key",l);o.setAttribute("value",A.value);f.push(o);}else if(A.namespaceURI&&A.name.indexOf("xmlns:")!==0){if(!e){e={};}if(!e.hasOwnProperty(A.namespaceURI)){e[A.namespaceURI]={};}e[A.namespaceURI][l]=A.nodeValue;}return f;},[]);d=d.concat(N);if(e){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key","sap-ui-custom-settings");c.setProperty(o,"value",e);d.push(o);}}return s?d[0]:d;});},insertAggregation:function(p,n,o,I,v,s){return c._findAggregationNode(p,n).then(function(A){if(!A){var N=p.namespaceURI;return c.createControl(N+"."+n,undefined,v).then(function(A){p.appendChild(A);return A;});}return A;}).then(function(A){if(!s){var d=A.children;var e=0;var S=(I<d.length)?I:d.length;for(var i=0;i<S;i++){if(d[i].namespaceURI==="sap.ui.core"&&d[i].tagName.indexOf("ExtensionPoint")>-1){e=e+1-d[i].children.length;}}I=I+e;}if(I>=A.childElementCount){A.appendChild(o);}else{return c._getControlsInAggregation(p,A).then(function(r){A.insertBefore(o,r[I]);});}return undefined;});},removeAggregation:function(p,n,o){return c._findAggregationNode(p,n).then(function(A){A.removeChild(o);});},removeAllAggregation:function(o,n){return c._findAggregationNode(o,n).then(function(A){if(o===A){return c._getControlsInAggregation(o,o).then(function(d){d.forEach(function(e){o.removeChild(e);});});}return o.removeChild(A);});},_findAggregationNode:function(p,n){var A;var d=c._children(p);for(var i=0;i<d.length;i++){var N=d[i];if(N.localName===n){A=N;break;}}var P=Promise.resolve(A);if(!A){P=P.then(c._isDefaultAggregation.bind(c,p,n)).then(function(I){if(I){return p;}return A;});}return P;},_isDefaultAggregation:function(p,A){return c.getControlMetadata(p).then(function(o){var d=o.getDefaultAggregation();return d&&A===d.name;});},_isNotNamedAggregationNode:function(p,o){return c.getAllAggregations(p).then(function(A){var d=A[o.localName];return p.namespaceURI!==o.namespaceURI||!d;});},_isSingleValueAggregation:function(p,A){return c.getAllAggregations(p).then(function(d){var o=d[A];return!o.multiple;});},_isAltTypeAggregation:function(p,A){return c.getControlMetadata(p).then(function(o){return o.getAllAggregations()[A];}).then(function(o){return!!o.altTypes;});},_isExtensionPoint:function(o){return c._getControlTypeInXml(o)==="sap.ui.core.ExtensionPoint";},getControlMetadata:function(o){return c._getControlMetadataInXml(o);},_getControlsInAggregation:function(p,A){var d=Array.prototype.slice.call(c._children(A));return Promise.all(d.map(function(o){return c._isNotNamedAggregationNode(p,o).then(function(i){return i?o:undefined;});})).then(function(d){return d.filter(function(o){return!!o;});});},_children:function(p){if(p.children){return p.children;}else{var d=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){d.push(n);}}return d;}},getBindingTemplate:function(o,A){return c._findAggregationNode(o,A).then(function(d){if(d){var e=c._children(d);if(e.length===1){return e[0];}}return undefined;});},updateAggregation:function(o,A){},findIndexInParentAggregation:function(o){var p=c.getParent(o);if(!p){return Promise.resolve(-1);}return c.getParentAggregationName(o,p).then(function(A){return c.getAggregation(p,A);}).then(function(d){if(Array.isArray(d)){var P=d.map(function(o){return Promise.resolve().then(function(){if(c._isExtensionPoint(o)){return o;}return c.getProperty(o,"stashed").then(function(e){return!e?o:undefined;});});});return Promise.all(P).then(function(d){return d.filter(function(o){return!!o;}).indexOf(o);});}else{return 0;}});},getParentAggregationName:function(o,p){return Promise.resolve().then(function(){if(!p.isSameNode(o.parentNode)){return false;}else{return c._isNotNamedAggregationNode(p,o);}}).then(function(n){if(n){return c.getControlMetadata(p).then(function(d){return d.getDefaultAggregationName();});}else{return c._getLocalName(o.parentNode);}});},findAggregation:function(o,A){return c.getControlMetadata(o).then(function(d){return d.getAllAggregations();}).then(function(d){if(d){return d[A];}return undefined;});},validateType:function(o,A,p,f,i){var t=A.type;return c.getAggregation(p,A.name).then(function(d){if(A.multiple===false&&d&&d.length>0){return false;}return F.load({definition:f});}).then(function(d){if(!Array.isArray(d)){d=[d];}var r=d[i].isA(t);d.forEach(function(e){e.destroy();});return r;});},instantiateFragment:function(f,n,v){var o=X.parse(f);return c._checkAndPrefixIdsInFragment(o,n).then(function(o){var d;if(o.localName==="FragmentDefinition"){d=c._getElementNodeChildren(o);}else{d=[o];}d.forEach(function(N){if(c._byId(N.getAttribute("id"),v)){throw Error("The following ID is already in the view: "+N.getAttribute("id"));}});return d;});},templateControlFragment:function(f,p){return B._templateFragment(f,p).then(function(o){return c._children(o);});},destroy:function(o){var p=o.parentNode;if(p){p.removeChild(o);}},_getFlexCustomData:function(o,t){if(!o){return undefined;}return o.getAttributeNS("sap.ui.fl",t);},attachEvent:function(n,e,f,d){if(typeof O.get(f)!=="function"){return Promise.reject(new Error("Can't attach event because the event handler function is not found or not a function."));}return c.getProperty(n,e).then(function(v){v=v||"";var g=E.parse(v);var s=f;var p=["$event"];if(d){p.push(JSON.stringify(d));}s+="("+p.join(",")+")";if(!a(g,s)){g.push(s);}n.setAttribute(e,g.join(";"));});},detachEvent:function(n,e,f){if(typeof O.get(f)!=="function"){return Promise.reject(new Error("Can't attach event because the event handler function is not found or not a function."));}return c.getProperty(n,e).then(function(v){v=v||"";var d=E.parse(v);var i=d.findIndex(function(s){return s.includes(f);});if(i>-1){d.splice(i,1);}if(d.length){n.setAttribute(e,d.join(";"));}else{n.removeAttribute(e);}});},bindAggregation:function(n,A,v,V){return Promise.resolve().then(function(){c.bindProperty(n,A,v.path);return c.insertAggregation(n,A,v.template,0,V);});},unbindAggregation:function(n,A){return Promise.resolve().then(function(){if(n.hasAttribute(A)){n.removeAttribute(A);return c.removeAllAggregation(n,A);}return undefined;});},getExtensionPointInfo:function(e,v){return Promise.resolve().then(function(){if(v&&e){var d=Array.prototype.slice.call(v.getElementsByTagNameNS("sap.ui.core","ExtensionPoint"));var f=d.filter(function(g){return g.getAttribute("name")===e;});var o=(f.length===1)?f[0]:undefined;if(o){var p=c.getParent(o);return Promise.all([c.getParentAggregationName(o,p),c.findIndexInParentAggregation(o)]).then(function(P){var g={parent:p,aggregationName:P[0],index:P[1]+1,defaultContent:Array.prototype.slice.call(c._children(o))};return g;});}}return undefined;});}});return c;},true);
sap.ui.predefine('sap/ui/core/util/serializer/HTMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/HTML','sap/ui/thirdparty/vkbeautify'],function(E,S,H,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.HTMLViewSerializer",{constructor:function(V,w,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new H(this._fnGetControlId,this._fnGetEventHandlerName),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<template');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' data-controller-name="'+this._oView.getControllerName()+'"');}V.push(" >");V.push(r);V.push("</template>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/Serializer',['sap/ui/base/EventProvider',"sap/base/assert"],function(E,a){"use strict";
var S=E.extend("sap.ui.core.util.serializer.Serializer",{constructor:function(r,s,b,w,f,c){E.apply(this);this._oRootControl=r;this._delegate=s;this._bSkipRoot=!!b;this._oWindow=w||window;this._fnSkipAggregations=f;this._fnSkipElement=c;}});
S.prototype.serialize=function(){return this._serializeRecursive(this._oRootControl,0);};
S.prototype._serializeRecursive=function(c,l,A,b){a(typeof c!=="undefined","The control must not be undefined");var C=[];var w=(!this._bSkipRoot||l!==0);if(w){var s=this._delegate.start(c,A,b);var m=this._delegate.middle(c,A,b);C.push(s+m);}var d=c.getMetadata().getAllAggregations();if(d){for(var n in d){if(this._fnSkipAggregations&&this._fnSkipAggregations(c,n)){continue;}var e=[];var o=d[n];var v=c[o._sGetter]();if(c.getBindingPath(n)&&c.getBindingInfo(n).template){e.push(c.getBindingInfo(n).template);}else if(v&&v.length){for(var i=0;i<v.length;i++){var O=v[i];if(this._isObjectSerializable(O)){e.push(O);}}}else if(this._isObjectSerializable(v)){e.push(v);}if(e.length>0){if(w){C.push(this._delegate.startAggregation(c,n));}var f=this._isDefaultAggregation(c,n);for(var j=0;j<e.length;j++){C.push(this._serializeRecursive(e[j],l+1,n,f));}if(w){C.push(this._delegate.endAggregation(c,n));}}}}if(w){var g=this._delegate.end(c,A,b);C.push(g);}return C.join("");};
S.prototype._isObjectSerializable=function(o){return o instanceof this._oWindow.sap.ui.core.Element&&!(this._fnSkipElement&&this._fnSkipElement(o));};
S.prototype._isDefaultAggregation=function(c,A){return c.getMetadata().getDefaultAggregationName()===A;};
return S;});
sap.ui.predefine('sap/ui/core/util/serializer/ViewSerializer',['sap/ui/base/EventProvider','./HTMLViewSerializer','./XMLViewSerializer',"sap/base/assert"],function(E,H,X,a){"use strict";
var V=E.extend("sap.ui.core.util.serializer.ViewSerializer",{constructor:function(r,w,d){E.apply(this);this._oRootControl=r;this._oWindow=w||window;this._mViews={};this._sDefaultXmlNamespace=d;}});
V.prototype.serializeToXML=function(){return this.serialize("XML");};
V.prototype.serializeToHTML=function(){return this.serialize("HTML");};
V.prototype.serialize=function(c){this._mViews={};this._sConvertToViewType=c||undefined;return this._serializeRecursive(this._oRootControl);};
V.prototype._getViewType=function(v){if(!this._sConvertToViewType){if(v instanceof this._oWindow.sap.ui.core.mvc.HTMLView){return"HTML";}else if(v instanceof this._oWindow.sap.ui.core.mvc.XMLView){return"XML";}}return this._sConvertToViewType;};
V.prototype._serializeRecursive=function(c){a(typeof c!=="undefined","The control must not be undefined");if(c instanceof this._oWindow.sap.ui.core.mvc.View){var v=this._getViewSerializer(c,this._getViewType(c));if(v){var o=c.getViewName()||c.getControllerName();if(!this._mViews[o]){this._mViews[o]=v.serialize(this._getViewType(c));}}}if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.UIArea){var C=c.getContent();for(var i=0;i<C.length;i++){this._serializeRecursive(C[i]);}}else if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.ComponentContainer){this._serializeRecursive(c.getComponentInstance().getRootControl());}else{var A=c.getMetadata().getAllAggregations();if(A){for(var n in A){var b=A[n];var d=c[b._sGetter]();if(d&&d.length){for(var i=0;i<d.length;i++){var O=d[i];if(O instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(O);}}}else if(d instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(d);}}}}return this._mViews;};
V.prototype._getViewSerializer=function(v,t){var g=function(e){if(e.fFunction&&e.fFunction._sapui_handlerName){var h=e.fFunction._sapui_handlerName;var c=v.getController();if(c[h]||sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){return h;}}};var G=function(c){if(c._sapui_controlId){return c._sapui_controlId;}return c.getId().replace(v.createId(""),"");};if(t==="HTML"){return new H(v,this._oWindow,G,g);}else if(t==="XML"){return new X(v,this._oWindow,this._sDefaultXmlNamespace,G,g);}else{var t=(v)?v.constructor:"?";throw Error("View type '"+t+"' is not supported for conversion. Only HTML and XML is supported");}};
return V;});
sap.ui.predefine('sap/ui/core/util/serializer/XMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/XML','sap/ui/thirdparty/vkbeautify'],function(E,S,X,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.XMLViewSerializer",{constructor:function(V,w,d,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var p=[];var m=function(C,P){if(!P){var T=(C)?C.constructor:"?";throw Error("Controls with empty package are currently not supported by the XML serializer: "+T);}if(p.indexOf(P)===-1){p.push(P);}};var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new X(this._sDefaultNamespace,this._fnGetControlId,this._fnGetEventHandlerName,m),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<sap.ui.core.mvc:View');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' controllerName="'+this._oView.getControllerName()+'"');}if(p.indexOf('sap.ui.core.mvc')===-1){p.push('sap.ui.core.mvc');}for(var i=0;i<p.length;i++){if(this._sDefaultNamespace&&this._sDefaultNamespace===p[i]){V.push(' xmlns="'+p[i]+'"');}else{V.push(' xmlns:'+p[i]+'="'+p[i]+'"');}}V.push(" >");V.push(r);V.push("</sap.ui.core.mvc:View>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/Delegate',['sap/ui/base/EventProvider'],function(E){"use strict";
var D=E.extend("sap.ui.core.util.serializer.delegate.Delegate",{constructor:function(){E.apply(this);}});
D.prototype.start=function(c,a,i){return"";};
D.prototype.middle=function(c,a,i){return"";};
D.prototype.end=function(c,a,i){return"";};
D.prototype.startAggregation=function(c,a){return"";};
D.prototype.endAggregation=function(c,a){return"";};
return D;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/HTML',['./Delegate',"sap/base/strings/hyphenate","sap/base/util/deepEqual"],function(D,h,d){"use strict";
var H=D.extend("sap.ui.core.util.serializer.delegate.HTML",{constructor:function(g,G){D.apply(this);this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
H.prototype.startAggregation=function(c,a){return'<div data-sap-ui-aggregation="'+a+'">';};
H.prototype.endAggregation=function(c,a){return'</div>';};
H.prototype.start=function(c,a,i){return"<div";};
H.prototype.middle=function(c,a,b){var e=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){e.push(this._createAttribute("id",I));}e.push(this._createAttribute("data-sap-ui-type",c.getMetadata()._sClassName));if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var f=[];for(var i=0;i<C.length;i++){var s=C[i];if(!s.startsWith("sapM")&&!s.startsWith("sapUi")){f.push(s);}}if(f.length>0){e.push(this._createAttribute("class",f.join(" ")));}}if(this._fnGetEventHandlerName){var E=c.getMetadata().getAllEvents();for(var g in E){if(c.hasListeners(g)){var j=c.mEventRegistry[g];for(var i=0;i<j.length;i++){var k=this._fnGetEventHandlerName(j[i]);if(k){e.push(this._createAttribute("data-"+this._createHtmlAttributeName(g),k));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(e,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(e,c,p,null,function(n,v){return!d(v,o[n]);});var l=c.getMetadata().getAllAggregations();this._createAttributes(e,c,l,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});e.push('>');return e.join('');};
H.prototype.end=function(c,a,i){return"</div>";};
H.prototype._createAttributes=function(a,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){a.push(this._createAttribute("data-"+this._createHtmlAttributeName(n),V));}}else{a.push(this._createDataBindingAttribute(c,n,V));}}}};
H.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute("data-"+this._createHtmlAttributeName(n),p);};
H.prototype._createAttribute=function(a,v){return' '+a+'="'+v+'"';};
H.prototype._createHtmlAttributeName=function(n){return h(n);};
return H;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/XML',['./Delegate',"sap/base/util/deepEqual","sap/base/security/encodeXML"],function(D,d,e){"use strict";
var X=D.extend("sap.ui.core.util.serializer.delegate.XML",{constructor:function(s,g,G,m){D.apply(this);this._sDefaultNamespace=s;this._fnGetControlId=g;this._fnMemorizePackage=m;this._fnGetEventHandlerName=G;}});
X.prototype.startAggregation=function(c,a){return'<'+this._createAggregationName(c,a)+'>';};
X.prototype.endAggregation=function(c,a){return'</'+this._createAggregationName(c,a)+'>';};
X.prototype.start=function(c,a,i){return"<"+this._createTagName(c);};
X.prototype.end=function(c,a,i){return"</"+this._createTagName(c)+">";};
X.prototype.middle=function(c,a,b){var x=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){x.push(this._createAttribute("id",I));}if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var f=[];for(var i=0;i<C.length;i++){var s=C[i];if(!s.startsWith("sapM")&&!s.startsWith("sapUi")){f.push(s);}}if(f.length>0){x.push(this._createAttribute("class",f.join(" ")));}}if(this._fnGetEventHandlerName){var E=c.getMetadata().getAllEvents();for(var g in E){if(c.hasListeners(g)){var h=c.mEventRegistry[g];for(var i=0;i<h.length;i++){var H=this._fnGetEventHandlerName(h[i]);if(H){x.push(this._createAttribute(g,H));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(x,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(x,c,p,null,function(n,v){return!d(v,o[n]);});var j=c.getMetadata().getAllAggregations();this._createAttributes(x,c,j,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});x.push('>');return x.join('');};
X.prototype._createAttributes=function(x,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){x.push(this._createAttribute(n,V));}}else{x.push(this._createDataBindingAttribute(c,n,V));}}}};
X.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute(n,p);};
X.prototype._createAttribute=function(a,v){var E=(typeof v==="string"||v instanceof String)?e(v):v;return' '+a+'="'+E+'"';};
X.prototype._createTagName=function(c){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var s=(l===-1)?C:C.substring(l+1);var p=(l===-1)?C:C.substring(0,l);if(this._fnMemorizePackage){this._fnMemorizePackage(c,p);}return this._createNamespace(p,s);};
X.prototype._createAggregationName=function(c,a){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var p=(l===-1)?C:C.substring(0,l);return this._createNamespace(p,a);};
X.prototype._createNamespace=function(n,N){if(this._sDefaultNamespace&&this._sDefaultNamespace===n){return N;}else{return n+":"+N;}};
return X;});
sap.ui.predefine('sap/ui/core/ws/ReadyState',function(){"use strict";var R={CONNECTING:0,OPEN:1,CLOSING:2,CLOSED:3};return R;},true);
sap.ui.predefine('sap/ui/core/ws/SapPcpWebSocket',['./WebSocket',"sap/base/Log"],function(W,L){"use strict";
var S=W.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(u,p){W.apply(this,arguments);}});
S.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};S._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;S._SEPARATOR="\n\n";S._MESSAGE="MESSAGE";
S.prototype._onopen=function(){var s=false;if(this.getProtocol()===""){s=true;}else{for(var p in S.SUPPORTED_PROTOCOLS){if(S.SUPPORTED_PROTOCOLS.hasOwnProperty(p)){if(S.SUPPORTED_PROTOCOLS[p]===this.getProtocol()){s=true;break;}}}}if(s){this.fireOpen();}else{L.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server");}};
S.prototype._onmessage=function(m){var s=-1,e={};if(typeof m.data==="string"){s=m.data.indexOf(S._SEPARATOR);}if(s!==-1){e.pcpFields=this._extractPcpFields(m.data.substring(0,s));e.data=m.data.substr(s+S._SEPARATOR.length);}else{L.warning("Invalid PCP message received: "+m.data);e.pcpFields={};e.data=m.data;}this.fireMessage(e);};
S.prototype._extractPcpFields=function(h){var f=h.split("\n"),l=[],p={};for(var i=0;i<f.length;i++){l=f[i].match(S._deserializeRegexp);if(l&&l.length===3){p[this._unescape(l[1])]=this._unescape(l[2]);}}return p;};
S.prototype._unescape=function(e){var p=e.split("\u0008"),u="";for(var i=0;i<p.length;i++){p[i]=p[i].replace(/\\\\/g,"\u0008").replace(/\\:/g,':').replace(/\\n/g,'\n').replace(/\u0008/g,"\\");}u=p.join("\u0008");return u;};
S.prototype._serializePcpFields=function(p,m,P){var s="",f="",a="";if(m==='string'){a='text';}else if(m==='blob'||m==='arraybuffer'){a='binary';}if(p&&typeof p==='object'){for(f in p){if(p.hasOwnProperty(f)&&f.indexOf('pcp-')!==0){s+=this._escape(f)+":"+this._escape(String(p[f]))+"\n";}}}return"pcp-action:"+P+"\npcp-body-type:"+a+"\n"+s+"\n";};
S.prototype._escape=function(u){return u.replace(/\\/g,'\\\\').replace(/:/g,'\\:').replace(/\n/g,'\\n');};
S.prototype.send=function(m,p){var M=typeof m,P="";P=this._serializePcpFields(p,M,S._MESSAGE);W.prototype.send.call(this,P+m);return this;};
return S;});
sap.ui.predefine('sap/ui/core/ws/WebSocket',['sap/ui/Device','sap/ui/base/EventProvider','./ReadyState','sap/ui/thirdparty/URI',"sap/base/Log","sap/ui/thirdparty/jquery"],function(D,E,R,U,L,q){"use strict";
var W=E.extend("sap.ui.core.ws.WebSocket",{
constructor:function(u,p){E.apply(this);if(!D.support.websocket){throw new Error("Browser does not support WebSockets.");}if(typeof(u)!=="string"){throw new Error("sUrl must be a string.");}if(typeof(p)!=='undefined'&&!Array.isArray(p)&&typeof(p)!=='string'){throw new Error("aProtocols must be a string, array of strings or undefined.");}this._openConnection(u,p);},
metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}
});
W.prototype.getInterface=function(){return this;};
W.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};
W.prototype.attachOpen=function(d,f,l){this.attachEvent("open",d,f,l);return this;};
W.prototype.detachOpen=function(f,l){this.detachEvent("open",f,l);return this;};
W.prototype.fireOpen=function(p){this.fireEvent("open",p);return this;};
W.prototype.attachClose=function(d,f,l){this.attachEvent("close",d,f,l);return this;};
W.prototype.detachClose=function(f,l){this.detachEvent("close",f,l);return this;};
W.prototype.fireClose=function(p){this.fireEvent("close",p);return this;};
W.prototype.attachError=function(d,f,l){this.attachEvent("error",d,f,l);return this;};
W.prototype.detachError=function(f,l){this.detachEvent("error",f,l);return this;};
W.prototype.fireError=function(p){this.fireEvent("error",p);return this;};
W.prototype.attachMessage=function(d,f,l){this.attachEvent("message",d,f,l);return this;};
W.prototype.detachMessage=function(f,l){this.detachEvent("message",f,l);return this;};
W.prototype.fireMessage=function(p){this.fireEvent("message",p);return this;};
W.prototype._resolveFullUrl=function(u){var o=new U(u);var b=new U(document.baseURI);b.search('');b.protocol(b.protocol()==='https'?'wss':'ws');o=o.absoluteTo(b);return o.toString();};
W.prototype._openConnection=function(u,p){var u=this._resolveFullUrl(u);this._oWs=(typeof(p)==='undefined')?new window.WebSocket(u):new window.WebSocket(u,p);this._oWs.onopen=q.proxy(this._onopen,this);this._oWs.onclose=q.proxy(this._onclose,this);this._oWs.onmessage=q.proxy(this._onmessage,this);this._oWs.onerror=q.proxy(this._onerror,this);};
W.prototype._onopen=function(){this.fireOpen();};
W.prototype._onclose=function(c){this.fireClose({code:c.code,reason:c.reason,wasClean:c.wasClean});};
W.prototype._onerror=function(e){this.fireError();};
W.prototype._onmessage=function(m){this.fireMessage({data:m.data});};
W.prototype.send=function(m){if(this.getReadyState()===R.OPEN){this._oWs.send(m);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(m);});}else{L.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+m);}return this;};
W.prototype.close=function(c,r){if(typeof(c)==='string'){r=c;c=undefined;}c=(typeof(c)==='undefined')?1000:c;r=(typeof(r)==='undefined')?"":r;if(this.getReadyState()===R.OPEN){this._oWs.close(c,r);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.close(c,r);});}else{var t='';switch(this.getReadyState()){case R.CLOSED:t="Connection is already closed.";break;case R.CLOSING:t="Connection is already closing.";break;}L.warning("Unable to close WebSocket connection. "+t);}return this;};
W.prototype.getReadyState=function(){return this._oWs.readyState;};
W.prototype.getProtocol=function(){return this._oWs.protocol;};
return W;});
sap.ui.predefine('sap/ui/dom/denormalizeScrollBeginRTL',["sap/ui/util/_FeatureDetection"],function(_){"use strict";var d;if(_.initialScrollPositionIsZero()){d=function(n,o){return-n;};}else{d=function(n,o){return o.scrollWidth-o.clientWidth-n;};}var D=function(n,o){if(o){return d(n,o);}};return D;});
sap.ui.predefine('sap/ui/dom/denormalizeScrollLeftRTL',["sap/ui/util/_FeatureDetection"],function(_){"use strict";var d;if(_.initialScrollPositionIsZero()){d=function(n,o){return o.clientWidth+n-o.scrollWidth;};}else{d=function(n,o){return n;};}var D=function(n,o){if(o){return d(n,o);}};return D;});
sap.ui.predefine('sap/ui/dom/getFirstEditableInput',["sap/ui/thirdparty/jquery","sap/ui/dom/isHidden"],function(q,i){"use strict";
function f(c){return q(c).find('input, textarea').not('input[readonly],textarea[readonly],input[type=hidden],input[type=button],input[type=submit],input[type=reset],input[type=image],button').filter(':enabled:visible:first')[0];}
function g(c){if(!c||i(c)){return null;}return f(c);}
return g;});
sap.ui.predefine('sap/ui/dom/getOwnerWindow',[],function(){"use strict";var g=function o(d){if(d.ownerDocument.parentWindow){return d.ownerDocument.parentWindow;}return d.ownerDocument.defaultView;};return g;});
sap.ui.predefine('sap/ui/dom/isHidden',["sap/ui/thirdparty/jquery"],function(q){"use strict";
function i(e){return(e.offsetWidth<=0&&e.offsetHeight<=0)||q.css(e,'visibility')==='hidden';}
return i;});
sap.ui.predefine('sap/ui/dom/jquery/Aria',['sap/ui/thirdparty/jquery'],function(q){"use strict";
function a(A,v,p){var s=this.attr(A);if(!s){return this.attr(A,v);}var b=s.split(" ");if(b.indexOf(v)==-1){p?b.unshift(v):b.push(v);this.attr(A,b.join(" "));}return this;}
function r(A,v){var s=this.attr(A)||"",b=s.split(" "),i=b.indexOf(v);if(i==-1){return this;}b.splice(i,1);if(b.length){this.attr(A,b.join(" "));}else{this.removeAttr(A);}return this;}
q.fn.addAriaLabelledBy=function(i,p){return a.call(this,"aria-labelledby",i,p);};
q.fn.removeAriaLabelledBy=function(i){return r.call(this,"aria-labelledby",i);};
q.fn.addAriaDescribedBy=function(i,p){return a.call(this,"aria-describedby",i,p);};
q.fn.removeAriaDescribedBy=function(i){return r.call(this,"aria-describedby",i);};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/Focusable',["sap/ui/thirdparty/jquery","sap/ui/dom/isHidden","./hasTabIndex"],function(q,i){"use strict";
function f(c,F){var C=F?c.firstChild:c.lastChild,o;while(C){if(C.nodeType==1&&!i(C)){if(q(C).hasTabIndex()){return C;}o=f(C,F);if(o){return o;}}C=F?C.nextSibling:C.previousSibling;}return null;}
q.fn.firstFocusableDomRef=function(){var c=this.get(0);if(!c||i(c)){return null;}return f(c,true);};
q.fn.lastFocusableDomRef=function(){var c=this.get(0);if(!c||i(c)){return null;}return f(c,false);};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/Selection',["sap/ui/thirdparty/jquery"],function(q){"use strict";
q.fn.disableSelection=function(){return this.on(("onselectstart"in document.createElement("div")?"selectstart":"mousedown")+".ui-disableSelection",function(e){e.preventDefault();});};
q.fn.enableSelection=function(){return this.off(".ui-disableSelection");};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/cursorPos',['sap/ui/thirdparty/jquery'],function(q){"use strict";var c=function a(p){var l=arguments.length,t,T;t=this.prop("tagName");T=this.prop("type");if(this.length===1&&((t=="INPUT"&&(T=="text"||T=="password"||T=="search"))||t=="TEXTAREA")){var d=this.get(0);if(l>0){if(typeof(d.selectionStart)=="number"){d.focus();d.selectionStart=p;d.selectionEnd=p;}return this;}else{if(typeof(d.selectionStart)=="number"){return d.selectionStart;}return-1;}}else{return this;}};q.fn.cursorPos=c;return q;});
sap.ui.predefine('sap/ui/dom/jquery/getSelectedText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var g=function(){var d=this.get(0);try{if(typeof d.selectionStart==="number"){return d.value.substring(d.selectionStart,d.selectionEnd);}}catch(e){}return"";};q.fn.getSelectedText=g;return q;});
sap.ui.predefine('sap/ui/dom/jquery/hasTabIndex',["sap/ui/thirdparty/jquery"],function(q){"use strict";var h=function(e){var t=q.prop(e,"tabIndex");return t!=null&&t>=0&&(!q.attr(e,"disabled")||q.attr(e,"tabindex"));};
q.fn.hasTabIndex=function(){return h(this.get(0));};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/parentByAttribute',['sap/ui/thirdparty/jquery'],function(q){"use strict";var p=function b(a,v){if(this.length>0){if(v){return this.first().parents("["+a+"='"+v+"']").get(0);}else{return this.first().parents("["+a+"]").get(0);}}};q.fn.parentByAttribute=p;return q;});
sap.ui.predefine('sap/ui/dom/jquery/rect',["sap/ui/thirdparty/jquery","sap/ui/dom/getOwnerWindow"],function(q,d){"use strict";var r=function a(){var D=this.get(0);if(D){if(D.getBoundingClientRect){var c=D.getBoundingClientRect();var R={top:c.top,left:c.left,width:c.right-c.left,height:c.bottom-c.top};var w=d(D);R.left+=q(w).scrollLeft();R.top+=q(w).scrollTop();return R;}else{return{top:10,left:10,width:D.offsetWidth,height:D.offsetHeight};}}return null;};q.fn.rect=r;return q;});
sap.ui.predefine('sap/ui/dom/jquery/rectContains',["sap/ui/thirdparty/jquery","sap/base/assert","sap/ui/dom/jquery/rect"],function(q,a){"use strict";var r=function b(p,P){a(!isNaN(p),"iPosX must be a number");a(!isNaN(P),"iPosY must be a number");var R=this.rect();if(R){return p>=R.left&&p<=R.left+R.width&&P>=R.top&&P<=R.top+R.height;}return false;};q.fn.rectContains=r;return q;});
sap.ui.predefine('sap/ui/dom/jquery/scrollLeftRTL',["sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(d,_,q){"use strict";var s;if(_.initialScrollPositionIsZero()){s=function(D){return D.scrollWidth+D.scrollLeft-D.clientWidth;};}else{s=function(D){return D.scrollLeft;};}var S=function(p){var D=this.get(0);if(D){if(p===undefined){return s(D);}else{D.scrollLeft=d(p,D);return this;}}};q.fn.scrollLeftRTL=S;return q;});
sap.ui.predefine('sap/ui/dom/jquery/scrollRightRTL',["sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(_,q){"use strict";var s;if(_.initialScrollPositionIsZero()){s=function(d){return(-d.scrollLeft);};}else{s=function(d){return d.scrollWidth-d.scrollLeft-d.clientWidth;};}var S=function(){var d=this.get(0);if(d){return s(d);}};q.fn.scrollRightRTL=S;return q;});
sap.ui.predefine('sap/ui/dom/jquery/selectText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var s=function a(S,E){var d=this.get(0);try{if(typeof(d.selectionStart)==="number"){d.setSelectionRange(S>0?S:0,E);}}catch(e){}return this;};q.fn.selectText=s;return q;});
sap.ui.predefine('sap/ui/dom/units/Rem',['sap/base/assert'],function(a){"use strict";
function g(){var r=document.documentElement;if(!r){return 16;}return parseFloat(window.getComputedStyle(r).getPropertyValue("font-size"));}
var R={fromPx:function(p){a(((typeof p==="string")&&(p!=="")&&!isNaN(parseFloat(p))&&(typeof parseFloat(p)==="number"))||((typeof p==="number")&&!isNaN(p)),'Rem.fromPx: either the "vPx" parameter must be an integer, or a string e.g.: "16px"');return parseFloat(p)/g();},toPx:function(r){a(((typeof r==="string")&&(r!=="")&&!isNaN(parseFloat(r))&&(typeof parseFloat(r)==="number"))||((typeof r==="number")&&!isNaN(r)),'Rem.toPx: either the "vRem" parameter must be an integer, or a string e.g.: "1rem"');return parseFloat(r)*g();}};return R;});
sap.ui.predefine('sap/ui/events/isMouseEventDelayed',["sap/ui/Device"],function(D){"use strict";var i=function(n){n=n||navigator;return!!(D.browser.mobile&&!((D.os.ios&&D.os.version>=8&&D.browser.safari&&!D.browser.webview)||(D.browser.chrome&&!/SAMSUNG/.test(n.userAgent)&&D.browser.version>=32)));};return i;});
sap.ui.predefine('sap/ui/events/isSpecialKey',function(){"use strict";var i=function(e){function a(e){var k=e.key;return(k==='Shift')||(k==='Control')||(k==='Alt')||(k==='AltGraph')||(k==='CapsLock')||(k==='NumLock');}function b(e){var k=e.key;return(k==='ArrowLeft')||(k==='ArrowUp')||(k==='ArrowRight')||(k==='ArrowDown');}var k=e.key,s=a(e)||b(e)||k==='PageUp'||k==='PageDown'||k==='End'||k==='Home'||k==='PrintScreen'||k==='Insert'||k==='Delete'||k==='F1'||k==='F2'||k==='F3'||k==='F4'||k==='F5'||k==='F6'||k==='F7'||k==='F8'||k==='F9'||k==='F10'||k==='F11'||k==='F12'||k==='Pause'||k==='Backspace'||k==='Tab'||k==='Enter'||k==='Escape'||k==='ScrollLock';switch(e.type){case"keydown":case"keyup":case"keypress":return s;default:return false;}};return i;});
sap.ui.predefine('sap/ui/events/jquery/EventTriggerHook',['sap/base/Log','sap/ui/dom/containsOrEquals','sap/ui/thirdparty/jquery','sap/base/util/uid'],function(L,c,q,u){"use strict";var t={};
function T(e){var i=L.isLoggable(L.Level.DEBUG),E=t[e.type],o=E.originalTriggerHook,a=window.performance.now(),b,I,d;if(!e.isPropagationStopped()&&!e.isSimulated){for(I in E.domRefs){d=E.domRefs[I];if(d.excludedDomRefs.indexOf(e.target)===-1&&c(d.domRef,e.target)){e.preventDefault();e.stopImmediatePropagation();if(i){b=window.performance.now();L.debug("Perf: jQuery trigger suppression event handler "+e.type+" took "+(b-a)+" milliseconds.");}return false;}}}if(o){return o.call(this,e);}}
function _(e){if(!q.event.special[e]){q.event.special[e]={};}var S=q.event.special[e],o=S.trigger;S.trigger=T;return o;}
function s(e,d,E){var m=t[e];var i=u();if(!m){m=t[e]={domRefs:{},originalTriggerHook:_(e)};}m.domRefs[i]={domRef:d,excludedDomRefs:[].concat(E)};return{id:i,type:e};}
function r(h){if(!h){L.error("Release trigger events must not be called without passing a valid handler!");return;}var e=t[h.type];if(!e){return;}else if(!e.domRefs[h.id]||!e.domRefs[h.id].domRef){L.warning("Release trigger event for event type "+h.type+"on Control "+h.id+": DomRef does not exists");return;}delete e.domRefs[h.id];}
return{suppress:s,release:r};});
sap.ui.predefine('sap/ui/model/ClientTreeBindingAdapter',['sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','./TreeBindingAdapter','sap/ui/model/ChangeReason',"sap/base/assert","sap/base/Log"],function(T,C,a,b,c,L){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this._invalidTree=true;this.setNumberOfExpandedLevels(this.mParameters.numberOfExpandedLevels||0);};
d.prototype.setNumberOfExpandedLevels=function(n){this._iNumberOfExpandedLevels=parseInt(n);};
d.prototype.getNumberOfExpandedLevels=function(){return this._iNumberOfExpandedLevels;};
d.prototype.nodeHasChildren=function(n){c(n,"TreeBindingAdapter.nodeHasChildren: No node given!");if(!n){return false;}else if(n.isArtificial){return true;}else{return C.prototype.hasChildren.call(this,n.context);}};
d.prototype.resetData=function(o,p){var r=C.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==b.Sort){this.clearSelection();this._createTreeState(true);}return r;};
d.prototype._calculateGroupID=function(n){var B=this.getPath();var g;if(n.context){var s=n.context.getPath();if(B!="/"){var m=s.match(B+"(.*)");if(m!=null&&m[1]){g=m[1];}else{L.warning("CTBA: BindingPath/ContextPath matching problem!");}}if(!g){g=s;}if(g.startsWith("/")){g=g.substring(1,g.length);}var p;if(!n.parent){p=this._calculateGroupID({context:n.context._parentContext||null});}else{p=n.parent.groupID;}g=p+g.replace(/\//g,"_")+"/";}else if(n.context===null){g="/";}return g;};
d.prototype.expand=function(){this._buildTree();a.prototype.expand.apply(this,arguments);};
d.prototype.collapse=function(){this._buildTree();a.prototype.collapse.apply(this,arguments);};
d.prototype._buildTree=function(s,l){if(this._invalidTree){s=s||0;l=l||this.getRootContexts().length;this._invalidTree=false;this._aRowIndexMap=[];a.prototype._buildTree.call(this,s,l);}};
d.prototype.findNode=function(p){this._buildTree();return a.prototype.findNode.apply(this,arguments);};
d.prototype.setSelectedIndex=function(r){this._buildTree();a.prototype.setSelectedIndex.apply(this,arguments);};
d.prototype.setSelectionInterval=function(f,t){this._buildTree();a.prototype.setSelectionInterval.apply(this,arguments);};
d.prototype.addSelectionInterval=function(){this._buildTree();a.prototype.addSelectionInterval.apply(this,arguments);};
d.prototype.removeSelectionInterval=function(){this._buildTree();a.prototype.removeSelectionInterval.apply(this,arguments);};
d.prototype.clearSelection=function(){this._buildTree();a.prototype.clearSelection.apply(this,arguments);};
d.prototype.selectAll=function(){this._buildTree();a.prototype.selectAll.apply(this,arguments);};
d.prototype._calculateRequestLength=function(m,s){return m;};
d.prototype.getLength=function(){this._buildTree();return a.prototype.getLength.apply(this,arguments);};
d.prototype._fireChange=function(){this._invalidTree=true;this.constructor.prototype._fireChange.apply(this,arguments);};
return d;},true);
sap.ui.predefine('sap/ui/model/MetaModel',['./Model'],function(M){"use strict";
var a=M.extend("sap.ui.model.MetaModel",{constructor:function(){M.apply(this,arguments);}});
a.prototype.createBindingContext=function(p,c,P,C){if(typeof c=="function"){C=c;c=null;}if(typeof P=="function"){C=P;P=null;}var s=this.resolve(p,c),n=(s==undefined)?undefined:this.getContext(s?s:"/");if(!n){n=null;}if(C){C(n);}return n;};
a.prototype.destroyBindingContext=function(){};
return a;});
sap.ui.predefine('sap/ui/model/SelectionModel',['sap/ui/base/EventProvider',"sap/base/assert"],function(E,c){"use strict";
var S=E.extend("sap.ui.model.SelectionModel",{constructor:function(s){E.apply(this);this.iSelectionMode=s||S.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(a,b){return a-b;};this.fnSortReverse=function(a,b){return b-a;};}});
S.SINGLE_SELECTION=0;S.MULTI_SELECTION=1;
S.prototype.getSelectionMode=function(){return this.iSelectionMode;};
S.prototype.setSelectionMode=function(s){this.iSelectionMode=s||S.SINGLE_SELECTION;};
S.prototype.isSelectedIndex=function(i){return this.aSelectedIndices.indexOf(i)!==-1;};
S.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex;};
S.prototype.setLeadSelectedIndex=function(l){c(typeof l==="number","iLeadIndex must be an integer");this.setSelectionInterval(l,l);return this;};
S.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSort);return i[0];}else{return-1;}};
S.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSortReverse);return i[0];}else{return-1;}};
S.prototype.getSelectedIndices=function(){var i=this.aSelectedIndices.sort(this.fnSort);return i;};
S.prototype.setSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var o=this.aSelectedIndices.slice();var l={};var C=[];for(var i=0;i<o.length;i++){l[o[i]]=true;if(o[i]<f||o[i]>t){C.push(o[i]);}}var s=[];for(var I=F;I<=T;I++){s.push(I);if(!l[I]){C.push(I);}}this._update(s,t,C);return this;};
S.prototype.addSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){return this.setSelectionInterval(f,t);}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;for(var i=F;i<=T;i++){if(s.indexOf(i)===-1){s.push(i);C.push(i);}}this._update(s,T,C);return this;};
S.prototype.moveSelectionInterval=function(s,m){c(typeof s==="number","iFromIndex must be an integer");c(typeof m==="number","iToIndex must be an integer");var C=[];var a=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=0;i<a.length;i++){var I=a[i];if(I>=s){C.push(a[i]);a[i]+=m;C.push(a[i]);if(I===this.iLeadIndex){l+=m;}}}this._update(a,l,C);return this;};
S.prototype.removeSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=F;i<=T;i++){var I=s.indexOf(i);if(I>-1){s.splice(I,1);C.push(i);}if(i===this.iLeadIndex){l=-1;}}this._update(s,l,C);return this;};
S.prototype.sliceSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var r=[];var o=this.aSelectedIndices.slice(0);var s=this.aSelectedIndices;var l=this.iLeadIndex;var R=T-F+1;for(var I=T;I>=F;I--){var a=s.indexOf(I);if(a>-1){s.splice(a,1);r.push(I);}if(I===this.iLeadIndex){l=-1;}}for(var I=0;I<s.length;I++){var O=s[I];if(O>=F){var n=s[I]-R;if(O===l){l=n;}s[I]=n;if(o.indexOf(n)===-1){C.push(n);}}}for(var i=0;i<r.length;i++){var I=o[o.length-1-i];if(C.indexOf(I)===-1){C.push(I);}}for(var i=0;i<r.length;i++){if(s.indexOf(r[i])===-1&&C.indexOf(r[i])===-1){C.push(r[i]);}}this._update(s,l,C);return this;};
S.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice());}return this;};
S.prototype.attachSelectionChanged=function(d,f,l){this.attachEvent("selectionChanged",d,f,l);return this;};
S.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
S.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};
S.prototype._update=function(s,l,C,b){var p={rowIndices:C&&C.sort(this.fnSort),selectAll:b};this.aSelectedIndices=s;p.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==l){this.iLeadIndex=l;p.leadIndex=this.iLeadIndex;}if(C.length>0||typeof p.leadIndex!=="undefined"){this.fireSelectionChanged(p);}};
S.prototype.selectAll=function(t){c(typeof t==="number","iToIndex must be an integer");var o=this.aSelectedIndices.slice();var l={};var C=[];var s=[];var i=0;for(i=0;i<o.length;i++){l[o[i]]=true;if(o[i]>t){C.push(o[i]);}}for(i=0;i<=t;i++){s.push(i);if(!l[i]){C.push(i);}}this._update(s,0,C,true);return this;};
return S;});
sap.ui.predefine('sap/ui/model/TreeAutoExpandMode',[],function(){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingAdapter',['sap/ui/model/TreeBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils',"sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(T,c,C,d,e,L,f,g){"use strict";var h=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var a in h.prototype){if(h.prototype.hasOwnProperty(a)){this[a]=h.prototype[a];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||c.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();this._bIsAdapted=true;};
h.prototype.getCurrentTreeState=function(){var D=";",G;var E={};for(G in this._mTreeState.expanded){E[G]=true;}var m={};for(G in this._mTreeState.collapsed){m[G]=true;}var s={};for(G in this._mTreeState.selected){s[G]=true;}return{_getExpandedList:function(){return Object.keys(E).join(D);},_getCollapsedList:function(){return Object.keys(m).join(D);},_getSelectedList:function(){return Object.keys(s).join(D);},_isExpanded:function(G){return!!E[G];},_isCollapsed:function(G){return!!m[G];},_remove:function(G){delete E[G];delete m[G];delete s[G];}};};
h.prototype.setTreeState=function(t){this._oInitialTreeState=t;};
h.prototype.setAutoExpandMode=function(a){this._autoExpandMode=a;};
h.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};
h.prototype.getContextByIndex=function(i){if(this.isInitial()){return undefined;}var n=this.findNode(i);return n?n.context:undefined;};
h.prototype.getNodeByIndex=function(i){if(this.isInitial()){return undefined;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
h.prototype.findNode=function(r){if(this.isInitial()){return undefined;}var p=typeof r;var F;var s=[];if(p==="number"){F=this._aRowIndexMap[r];if(!F){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===r){return true;}i+=1;return false;});F=s[0];}}return F;};
h.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};
h.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};
h.prototype._createNodeState=function(p){if(!p.groupID){e(false,"To create a node state a group ID is mandatory!");return undefined;}var i;var I;if(this._oInitialTreeState){i=this._oInitialTreeState._isExpanded(p.groupID);I=this._oInitialTreeState._isCollapsed(p.groupID);this._oInitialTreeState._remove(p.groupID);}var b=p.expanded||i||false;var a=p.selected||false;var n={groupID:p.groupID,expanded:b,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:a};if(i||I){this._updateTreeState({groupID:p.groupID,fallbackNodeState:n,expanded:i,collapsed:I});}return n;};
h.prototype._getNodeState=function(G){var E=this._mTreeState.expanded[G];var o=this._mTreeState.collapsed[G];var s=this._mTreeState.selected[G];var D=this._mTreeState.deselected[G];return E||o||s||D;};
h.prototype._updateNodeSections=function(G,n){var N=this._getNodeState(G);if(!N){e(false,"No Node State for Group ID '"+G+"' found!");return undefined;}else if(!n){e(false,"No Section given!");return undefined;}else if(n.length<=0){e(false,"The length of the given section must be positive greater than 0.");return undefined;}else if(n.startIndex<0){e(false,"The sections start index must be greater/equal to 0.");return undefined;}N.sections=d.mergeSections(N.sections,n);return N.sections;};
h.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=this._getMaxGroupSize(n);var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var o=N.sections[i];o.length=Math.max(o.length,this._iPageSize);a=d.mergeSections(a,o);}N.sections=a;}};this._map(this._oRootNode,I);};
h.prototype._getMaxGroupSize=function(n){var m=0;if(n.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}return m;};
h.prototype.getContexts=function(s,l,t){return this._getContextsOrNodes(false,s,l,t);};
h.prototype._getContextsOrNodes=function(r,s,l,t){var m,n,a=[],N=[];if(!this.isResolved()||this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);if(this._oRootNode){N=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(N,s);for(var i=0;i<N.length;i++){n=N[i];if(!n.context){m=m||{};var p=n.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:n.positionInParent,length:1});}a.push(n.context);}if(m){var b=this;f(m,function(G,n){n.magnitude=0;n.numberOfTotals=0;b._loadChildContexts(n);});a=[];for(var j=0;j<N.length;j++){n=N[j];a.push(n.context);}}if(r){return N;}else{return a;}};
h.prototype.getNodes=function(s,l,t){return this._getContextsOrNodes(true,s,l,t);};
h.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};
h.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}return false;});return a;};
h.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};
h.prototype._calculateRequestLength=function(m,s){var r;if(!m){r=s.length;}else{r=Math.max(Math.min(s.length,m-s.startIndex),0);}return r;};
h.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=this._getMaxGroupSize(n);if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}N.leafCount=m;}if(this.bClientOperation){N.sections=[{startIndex:0,length:m}];}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];var r=this._calculateRequestLength(m,o);if(n.autoExpand>=0&&this._autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(o.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,o.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var b=a[j];if(!b){continue;}var k=j+o.startIndex;var l=n.children[k];var u={context:a[j],parent:n,level:n.level+1,positionInParent:k,autoExpand:Math.max(n.autoExpand-1,-1)};if(l){l.context=u.context;l.parent=u.parent;l.level=u.level;l.positionInParent=u.positionInParent;l.magnitude=0;l.numberOfTotals=0;l.autoExpand=u.autoExpand;var G;if(b){G=this._calculateGroupID(l);}l.groupID=G;}else{l=this._createNode(u);}l.nodeState=this._getNodeState(l.groupID);if(!l.nodeState){l.nodeState=this._createNodeState({groupID:l.groupID,expanded:false});}l.nodeState.parentGroupID=n.groupID;l.isLeaf=!this.nodeHasChildren(l);n.children[k]=l;if(l.isLeaf){n.numberOfLeafs+=1;}if(l.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[l.groupID]){this.setNodeSelection(l.nodeState,true);}if((l.autoExpand>0||l.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[l.groupID]&&!l.isLeaf){this._updateTreeState({groupID:l.nodeState.groupID,fallbackNodeState:l.nodeState,expanded:true});this._loadChildContexts(l);}n.magnitude+=Math.max(l.magnitude||0,0);n.numberOfLeafs+=l.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};
h.prototype.isGrouped=function(){return true;};
h.prototype._calculateGroupID=function(n){L.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.");};
h.prototype._createNode=function(p){p=p||{};var o=p.context;var l=p.level||0;var n={context:o,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0,absoluteNodeIndex:p.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(o!==undefined){n.groupID=this._calculateGroupID(n);}return n;};
h.prototype.expand=function(i,s){var n=this.findNode(i);if(!n){e(false,"No node found for index "+i);return;}this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});if(!s){this._fireChange({reason:C.Expand});}};
h.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange({reason:C.Expand});};
h.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};
h.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);if(!N){e(false,"No node found for index "+p);return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var G=n.groupID;f(this._mTreeState.expanded,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)){t._updateTreeState({groupID:b,expanded:false});}});var D=[];f(this._mTreeState.selected,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)&&b!==G){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(b);}});if(D.length){var a={rowIndices:[]};var i=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){a.oldIndex=i;a.leadIndex=-1;}a.rowIndices.push(i);}});this._publishSelectionChanges(a);}}if(!s){this._fireChange({reason:C.Collapse});}};
h.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;f(this._mTreeState.expanded,function(G,n){var N=t._getGroupIdLevel(G)-1;if(N===l){t.collapse(n,true);}});if(this.bCollapseRecursive){this.setNumberOfExpandedLevels(l);}this._fireChange({reason:C.Collapse});};
h.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var o=n.children[i];this._map(o,m);}if(this._afterMapHook){this._afterMapHook(n,m);}};
h.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var o=n.children[i];var b=this._match(o,r,m,M,i,n);if(b){return true;}}return this._afterMatchHook?this._afterMatchHook(n,r,m,M,p,P):false;};
h.prototype.toggleIndex=function(i){var n=this.findNode(i);if(!n){e(false,"There is no node at index "+i+".");return;}if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};
h.prototype._getGroupIdLevel=function(G){if(G==null){L.warning("assertion failed: no need to determine level of group ID = null");return-1;}return G.split("/").length-2;};
h.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};
h.prototype.setNodeSelection=function(n,i){if(!n.groupID){e(false,"NodeState must have a group ID!");return;}n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};
h.prototype.isIndexSelected=function(r){var n=this.getNodeByIndex(r);return n&&n.nodeState?n.nodeState.selected:false;};
h.prototype.isIndexSelectable=function(r){var n=this.getNodeByIndex(r);return this._isNodeSelectable(n);};
h.prototype._isNodeSelectable=function(n){return!!n&&!n.isArtificial;};
h.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n&&this._isNodeSelectable(n)){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadGroupID=n.groupID;o.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(o);}else{L.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.");}};
h.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||g(this._mTreeState.selected)){return-1;}var n=-1;var a=false;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){a=true;return true;}}return false;};this._match(this._oRootNode,[],1,m);if(a){return n;}return-1;};
h.prototype.getSelectedIndices=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(N);t._aRowIndexMap[N]=o;return true;}}return false;};this._match(this._oRootNode,[],n,m);return r;};
h.prototype.getSelectedNodesCount=function(){var s;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var G,v,p,o;var a,V=[];if(this.filterInfo&&this.oCombinedFilter){for(var i=this.filterInfo.aFilteredContexts.length-1;i>=0;i--){a=this.filterInfo.aFilteredContexts[i];V.push(this._calculateGroupID({context:a}));}}v=0;for(G in this._mTreeState.expanded){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.expanded[G];if(!o.selectAllMode&&o.leafCount!==undefined){v+=o.leafCount;}}}for(G in this._mTreeState.selected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.selected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&!p.selectAllMode){v--;}}}for(G in this._mTreeState.deselected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.deselected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&p.selectAllMode){v++;}}}s=this._getSelectableNodesCount(this._oRootNode)-v;}else{s=Object.keys(this._mTreeState.selected).length;}return s;};
h.prototype._getSelectableNodesCount=function(n){if(n){return n.magnitude;}else{return 0;}};
h.prototype.getSelectedContexts=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(o.context);t._aRowIndexMap[N]=o;return true;}}return false;};this._match(this._oRootNode,[],n,m);return r;};
h.prototype.setSelectionInterval=function(F,t){var i,I,m=this._clearSelection(),a={},r=[],s=this._setSelectionInterval(F,t,true);for(i=0;i<m.rowIndices.length;i++){I=m.rowIndices[i];a[I]=true;}for(i=0;i<s.rowIndices.length;i++){I=s.rowIndices[i];if(a[I]){delete a[I];}else{a[I]=true;}}for(I in a){if(a[I]){r.push(parseInt(I));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};
h.prototype._setSelectionInterval=function(F,t,s){var n=Math.min(F,t);var N=Math.max(F,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var j=-1;var m=function(k){if(!k||!k.isArtificial){j++;}if(k){if(j>=n&&j<=N){if(this._isNodeSelectable(k)){if(k.nodeState.selected!==!!s){b.push(j);}if(k.groupID===this._sLeadSelectionGroupID){o=j;}this.setNodeSelection(k.nodeState,!!s);}return true;}}return false;};this._match(this._oRootNode,a,i,m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};
h.prototype.addSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,true);this._publishSelectionChanges(p);};
h.prototype.removeSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,false);this._publishSelectionChanges(p);};
h.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(this._isNodeSelectable(N)){if(N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);p.leadGroupID=N.groupID;p.leadIndex=n;}if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};
h.prototype._clearSelection=function(){var n=-1;var o=-1;var m;var a=[];if(this._oRootNode&&!this._oRootNode.nodeState.selectAllMode){m=0;for(var G in this._mTreeState.selected){if(G){m++;}}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){N.nodeState.selectAllMode=false;if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){a.push(n);}this.setNodeSelection(N.nodeState,false);if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}return false;};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
h.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
h.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
h.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
h.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive;};
h.prototype.attachSelectionChanged=function(D,F,l){this.attachEvent("selectionChanged",D,F,l);return this;};
h.prototype.detachSelectionChanged=function(F,l){this.detachEvent("selectionChanged",F,l);return this;};
h.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};
return h;},true);
sap.ui.predefine('sap/ui/model/TreeBindingCompatibilityAdapter',["sap/base/util/each"],function(e){"use strict";var T=function(b,c){Object.assign(b,{_init:function(E){this._bExpandFirstLevel=E;this.mContextInfo={};this._initContexts();if(E&&!this._bFirstLevelExpanded){this._expandFirstLevel();}},_initContexts:function(s){this.aContexts=this.getRootContexts(0,Number.MAX_VALUE);for(var i=0,l=this.aContexts.length;i<l;i++){var o=this._getContextInfo(this.aContexts[i]);this._setContextInfo({oContext:this.aContexts[i],iLevel:0,bExpanded:o?o.bExpanded:false});}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(s);}},_expandFirstLevel:function(s){var t=this;if(this.aContexts&&this.aContexts.length>0){e(this.aContexts.slice(),function(i,C){if(!s){t._loadChildContexts(C);}t._getContextInfo(C).bExpanded=true;});this._bFirstLevelExpanded=true;}},_fnFireFilter:b._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_fnFireChange:b._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_restoreContexts:function(C){var t=this;var n=[];e(C.slice(),function(i,o){var a=t._getContextInfo(o);if(a&&a.bExpanded){n.push.apply(n,t._loadChildContexts(o));}});if(n.length>0){this._restoreContexts(n);}},_loadChildContexts:function(C){var o=this._getContextInfo(C);var I=(this.aContexts?this.aContexts.indexOf(C):-1);var n=this.getNodeContexts(C,0,Number.MAX_VALUE);for(var i=0,l=n.length;i<l;i++){this.aContexts.splice(I+i+1,0,n[i]);var a=this._getContextInfo(n[i]);this._setContextInfo({oParentContext:C,oContext:n[i],iLevel:o.iLevel+1,bExpanded:a?a.bExpanded:false});}return n;},_getContextInfo:function(C){return C?this.mContextInfo[C.getPath()]:undefined;},_setContextInfo:function(d){if(d&&d.oContext){this.mContextInfo[d.oContext.getPath()]=d;}},getLength:function(){return this.aContexts?this.aContexts.length:0;},getContexts:function(s,l){return this.aContexts.slice(s,s+l);},getNodes:function(s,l){var C=this.getContexts(s,s+l);var n=[];for(var i=0;i<C.length;i++){var o=this._getContextInfo(C[i])||{};var a=C[i];n.push({context:a,level:o.iLevel,parent:o.oParentContext,nodeState:{expanded:o.bExpanded,collapsed:!o.bExpanded,selected:false}});}return n;},hasChildren:function(){return true;},nodeHasChildren:function(){return true;},getContextByIndex:function(r){return this.aContexts[r];},getLevel:function(C){var o=this._getContextInfo(C);return o?o.iLevel:-1;},isExpanded:function(r){var C=this.getContextByIndex(r);var o=this._getContextInfo(C);return o?o.bExpanded:false;},expandContext:function(C){var o=this._getContextInfo(C);if(o&&!o.bExpanded){this.storeSelection();this._loadChildContexts(C);o.bExpanded=true;this._fireChange();this.restoreSelection();}},expand:function(r){this.expandContext(this.getContextByIndex(r));},collapseContext:function(C,s){var o=this._getContextInfo(C);if(o&&o.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===C){this.aContexts.splice(i,1);}}o.bExpanded=false;if(!s){this._fireChange();}this.restoreSelection();}},collapse:function(r){this.collapseContext(this.getContextByIndex(r));},collapseToLevel:function(l){if(!l||l<0){l=0;}var C=this.aContexts.slice();for(var i=C.length-1;i>=0;i--){var a=this.getLevel(C[i]);if(a!=-1&&a>=l){this.collapseContext(C[i],true);}}this._fireChange();},toggleContext:function(C){var o=this._getContextInfo(C);if(o){if(o.bExpanded){this.collapseContext(C);}else{this.expandContext(C);}}},toggleIndex:function(r){this.toggleContext(this.getContextByIndex(r));},storeSelection:function(){var s=c.getSelectedIndices();var S=[];e(s,function(i,v){S.push(c.getContextByIndex(v));});this._aSelectedContexts=S;},restoreSelection:function(){c.clearSelection();var _=this._aSelectedContexts;e(this.aContexts,function(i,C){if(((_?_.indexOf(C):-1))>=0){c.addSelectionInterval(i,i);}});this._aSelectedContexts=undefined;},attachSelectionChanged:function(){return undefined;},detachSelectionChanged:function(){},clearSelection:function(){c._oSelection.clearSelection();},attachSort:function(){},detachSort:function(){}});b._init(c.getExpandFirstLevel());};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingUtils',function(){"use strict";var T=function(){};
T.mergeSections=function(s,n){var N=[];for(var i=0;i<s.length;i++){var c=s[i];var C=c.startIndex+c.length;var a=n.startIndex+n.length;if(n.startIndex<=C&&a>=C&&n.startIndex>=c.startIndex){n.startIndex=c.startIndex;n.length=a-c.startIndex;}else if(n.startIndex<=c.startIndex&&a>=c.startIndex&&a<=C){n.length=C-n.startIndex;}else if(n.startIndex>=c.startIndex&&a<=C){n.startIndex=c.startIndex;n.length=c.length;}else if(a<c.startIndex||n.startIndex>C){N.push(c);}}N.push(n);return N;};
T._determineRequestDelta=function(n,p){var N=n.iSkip+n.iTop;var P=p.iSkip+p.iTop;if(n.iSkip===p.iSkip&&n.iTop===p.iTop){return false;}else if(n.iSkip<p.iSkip&&N>p.iSkip&&N<=P){n.iTop=p.iSkip-n.iSkip;if(n.iThreshold){n.iTop=n.iTop+n.iThreshold;n.iSkip=Math.max(0,n.iSkip-n.iThreshold);n.iThreshold=0;}}else if(n.iSkip<P&&N>P&&n.iSkip>=p.iSkip){n.iSkip=P;n.iTop=N-n.iSkip;if(n.iThreshold){n.iTop+=n.iThreshold;n.iThreshold=0;}}else if(n.iSkip>=p.iSkip&&N<=P){return false;}else if(n.iSkip<=p.iSkip&&N>=P){p.oRequestHandle.abort();}else if(N<=p.iSkip||n.iSkip>=P){}};
return T;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalBinding',["./AnalyticalVersionInfo","./BatchResponseCollector","./odata4analytics","sap/base/Log","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/odata/CountMode","sap/ui/model/odata/ODataUtils"],function(A,B,a,L,d,b,c,f,u,C,F,t,v,w,S,T,x,y,O){"use strict";var D="sap.ui.model.analytics.AnalyticalBinding",I=0,E=L.getLogger(D);
function G(o){var e,g,s,h,i,j,m,n,p,k=new a.QueryResultRequest(o.oAnalyticalQueryResult),l=o.mParameters.select.split(","),q=J(l,o.sPath);k.setAggregationLevel(o.aMaxAggregationLevel);k.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(r){h=o.oDimensionDetailsSet[r];k.includeDimensionKeyTextAttributes(r,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(r){m=o.oMeasureDetailsSet[r];k.includeMeasureRawFormattedValueUnit(r,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=k.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=l.indexOf(p);if(j<0){e=o.mAnalyticalInfoByProperty[p];if(!e||(!e.visible&&!e.inResult)){continue;}E.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);q=true;}else{l.splice(j,1);}}}for(i=0,n=l.length;i<n;i++){p=l[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){H(o.sPath,p,h);q=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){H(o.sPath,p,m);q=true;}}return q?[]:l;}
function H(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){E.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{E.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}
function J(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){E.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}
var K=x.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){x.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;I+=1;this._iId=I;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==y.None){E.fatal("requested count mode is ignored; OData requests will include"+" $inlinecount options");}else if(P&&(P.countMode==y.Request||P.countMode==y.Both)){E.warning("default count mode is ignored; OData requests will include"+" $inlinecount options");}else if(this.oModel.sDefaultCountMode==y.Request){E.warning("default count mode is ignored; OData requests will include"+" $inlinecount options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){E.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});
function M(o,e){return function(){if(!o.__supportUID){o.__supportUID=u();}return{type:D,analyticalError:e,analyticalBindingId:o.__supportUID};};}
K.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.getResolvedPath();if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};
K.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};
K.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};
K.prototype.getRootContexts=function(p,l,n,i){if(typeof p!=="object"){p={length:l,numberOfExpandedLevels:n,startIndex:p,threshold:i};}if(this.isInitial()){return[];}var e=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(K._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(e<=1){if(e==1){this._considerRequestGrouping([R,this._getRequestId(K._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var g=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);g.push(R);this._considerRequestGrouping(g);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){E.fatal("assertion failed: grand total represented by a single entry");}return r;};
K.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};
K.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};
K.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return K.prototype.ContextsAvailabilityStatus.ALL;}else{return K.prototype.ContextsAvailabilityStatus.SOME;}}else{return K.prototype.ContextsAvailabilityStatus.NONE;}};
K.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};
K.prototype.getCount=function(){return this.iTotalSize>=0?this.iTotalSize:undefined;};
K.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){E.fatal("total size of result explicitly turned off, but getter invoked");}return this.iTotalSize;};
K.prototype.hasChildren=function(o,p){p=p||{level:1};if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};
K.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};
K.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};
K.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};
K.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};
K.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};
K.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};
K.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};
K.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};
K.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};
K.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};
K.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};
K.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==w.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};
K.prototype.getFilterInfo=function(i){var o=v.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};
K.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};
K.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};
K.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,l,m=this;function n(W){var X=W.level,Y=W.name;l=l||k.getAllHierarchyPropertyNames();l.forEach(function(Z){var $=m.oAnalyticalQueryResult.findDimensionByPropertyName(Z).getHierarchy(),_=null,a1=$.getNodeIDProperty().name,b1;if(a1===Y){_=p($);}else{b1=$.getNodeExternalKeyProperty();if(b1&&b1.name===Y){_=p($);_.nodeExternalKeyName=Y;}else{b1=k.getTextPropertyOfProperty(a1);if(b1&&b1.name===Y){_=p($);_.nodeTextName=Y;}}}if(_&&"level"in W){if(typeof X==="number"){if("level"in _&&_.level!==X){throw new Error("Multiple different level filter for hierarchy '"+a1+"' defined");}_.level=X;_.grouped=!!W.grouped;}else{throw new Error("The level of '"+a1+"' has to be an integer value");}}});}function p(W){var X=W.getNodeIDProperty().name,Y,Z=m.mHierarchyDetailsByName[X];if(!Z){Y=W.getNodeLevelProperty();Z={dimensionName:W.getNodeValueProperty().name,nodeIDName:X,nodeLevelName:Y&&Y.name};m.mHierarchyDetailsByName[X]=Z;}return Z;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=a.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(W){m.mAnalyticalInfoByProperty[W.name].formatter=W.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=c({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var P=this.oDimensionDetailsSet||{},q=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var r=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(r&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=r.getName();o=this.oDimensionDetailsSet[r.getName()];if(!o){o={};o.name=r.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[r.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(r.getName())==-1){E.fatal("property "+r.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(r.getName()==e[i].name){o.keyPropertyName=e[i].name;}var s=r.getTextProperty();if(s&&s.name==e[i].name){o.textPropertyName=e[i].name;}if(r.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var z=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(z&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=z.getName();var N=this.oMeasureDetailsSet[z.getName()];if(!N){N={};N.name=z.getName();this.oMeasureDetailsSet[z.getName()]=N;this.aMeasureName.push(N.name);}if(z.getRawValueProperty().name==e[i].name){N.rawValuePropertyName=e[i].name;}var Q=z.getFormattedValueProperty();if(Q&&Q.name==e[i].name){N.formattedValuePropertyName=e[i].name;}N.analyticalInfo=e[i];}if(!r&&!z){n(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(W){var X=m.mHierarchyDetailsByName[W];if(!("level"in X)){delete m.mHierarchyDetailsByName[W];if(E.isLoggable(L.Level.INFO)){E.info("No level specified for hierarchy node '"+W+"'; ignoring hierarchy","");}}else if(!m.oDimensionDetailsSet[W]){m.oDimensionDetailsSet[W]={aAttributeName:[],grouped:X.grouped,isHierarchyDimension:true,name:W};m.aMaxAggregationLevel.push(W);if(X.grouped){m.aAggregationLevel.push(W);}}});for(var R in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(R).getUnitProperty();if(U){this.oMeasureDetailsSet[R].unitPropertyName=U.name;}}var V=Object.keys(P).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(V){this.iTotalSize=-1;}if(V||Object.keys(q).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=G(this);}if(g){this._fireChange({reason:C.Change});}};
K.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};
K.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(K._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};
K.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};
K._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};K._artificialRootContextGroupId="artificialRootContext";
K._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,t.EQ,g.level);});};
K.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+K._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};
K.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){E.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){E.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){E.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var N=this._getGroupIdLevel(p);var P=N+n;var Q=true;if(!g){m=this._calculateRequiredGroupExpansion(p,P,s,l+e);Q=m.groupId_Missing==null;Q=Q||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(Q){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!Q;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var R=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||R;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));}var U=false;if(this.oModel.getServiceMetadata()){if(k){var V=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(K._requestType.totalSizeQuery));U=true;var W;if(this.bUseBatchRequests){if(z){W=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,X;(X=W[++i])!==undefined;){if(this._isRequestPending(X)){U=false;break;}}if(U){this.aBatchRequestQueue.push([K._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{U=o.length&&!this._isRequestPending(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));if(U){this.aBatchRequestQueue.push([K._requestType.groupMembersQuery,p,o.startIndex,o.length]);W=[this._getRequestId(K._requestType.groupMembersQuery,{groupId:p})];}}if(U&&V){W.push(this._getRequestId(K._requestType.totalSizeQuery));this._considerRequestGrouping(W);this.aBatchRequestQueue.push([K._requestType.totalSizeQuery]);}if(U){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(K.prototype._processRequestQueue.bind(this));}}else{var Y;if(z){W=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,Z;(Z=W[++j])!==undefined;){if(this._isRequestPending(Z)){U=false;break;}}if(U){Y=this._prepareGroupMembersAutoExpansionQueryRequest(K._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{U=o.length&&!this._isRequestPending(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));if(U){Y=this._prepareGroupMembersQueryRequest(K._requestType.groupMembersQuery,p,o.startIndex,o.length);W=[Y.sRequestId];}}if(U){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(Y);if(V&&!Y.bIsFlatListRequest){W.push(this._getRequestId(K._requestType.totalSizeQuery));this._considerRequestGrouping(W);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(K._requestType.totalSizeQuery));}}}}}return h;};
K.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,e=[],i=this;if(g===null){return e;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){E.error("Hierarchy cannot be requested for members of a group",g);return e;}h.forEach(function(s){var j=i.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(j.dimensionName,!!j.nodeExternalKeyName,!!j.nodeTextName);e.push({propertyName:j.nodeLevelName,level:j.level});});return e;};
K.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};
K.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==K._requestType.groupMembersQuery){o=K.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case K._requestType.groupMembersQuery:continue;case K._requestType.totalSizeQuery:if(!e){o=K.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case K._requestType.groupMembersAutoExpansionQuery:o=K.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case K._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:E.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};
K.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],o;var p=new a.QueryResultRequest(this.oAnalyticalQueryResult);p.setResourcePath(this._getResourcePath());p.getSortExpression().clear();var q=0,z=-1;if(g){h=this._getGroupIdComponents(g);q=z=h.length;var U=0;for(var j=0,N=0;j<q;N++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[N]].grouped==false){++U;}else{++j;}}q=z=q+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){if(++z==this.aMaxAggregationLevel.length){break;}}}}var P=z>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(p,g);var Q=this.aMaxAggregationLevel.slice(0,z+1);var R=this._getNonHierarchyDimensions(Q);p.setAggregationLevel(R);for(var i=0;i<R.length;i++){var V=this.oDimensionDetailsSet[R[i]];var W=(V.textPropertyName!=undefined);p.includeDimensionKeyTextAttributes(V.name,true,W,V.aAttributeName);if(V.grouped){m.push({sPath:R[i],bDescending:false});}}var X=p.getFilterExpression();X.clear();if(this.aApplicationFilter){X.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){X.addUI5FilterConditions(this.aControlFilter);}if(q>=1){for(var k=0,l=h.length;k<l;k++){X.removeConditions(this.aAggregationLevel[k]);X.addCondition(this.aAggregationLevel[k],t.EQ,h[k]);}}K._addHierarchyLevelFilters(o,X);var Y;var Z;var $;var _;var a1=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){p.setMeasures(this.aMeasureName);for(var b1 in this.oMeasureDetailsSet){_=this.oMeasureDetailsSet[b1];if(!P&&this._isSkippingTotalForMeasure(b1)){Y=false;Z=false;$=false;}else{Y=(_.rawValuePropertyName!=undefined);Z=(_.formattedValuePropertyName!=undefined);$=(_.unitPropertyName!=undefined);if($){if(a1.indexOf(_.unitPropertyName)==-1){a1.push(_.unitPropertyName);}}}p.includeMeasureRawFormattedValueUnit(_.name,Y,Z,$);}for(var n in R){var c1;if((c1=a1.indexOf(R[n]))!=-1){a1.splice(c1,1);}}}if(g){this._addSorters(p.getSortExpression(),m);}if(e==0){E.fatal("unhandled case: load 0 entities of sub group");}var d1=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){p.setResultPageBoundaries(d1.iServiceKeyIndex+1,d1.iServiceKeyIndex+e);}p.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:p,sGroupId:g,aSelectedUnitPropertyName:a1,aAggregationLevel:Q,bIsFlatListRequest:P&&q==0,bIsLeafGroupsRequest:P,iStartIndex:s,iLength:e,oKeyIndexMapping:d1};};
K.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}K._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};
K.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var P=[];if(o.groupId_Missing==null){E.fatal("missing group Id not present");return P;}var z=h._getGroupIdComponents(o.groupId_Missing);var N=z.length;if(N>s){E.fatal("the given group ID is too deep for requested level for auto expansion");return P;}var k=[];for(var i=0;i<N;i++){var l=h.aAggregationLevel[i];var b1=z[i];var c1=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,c1,b1);}var d1=null;if(o.startIndex_Missing>0){var e1=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var f1=h.oModel.getObject("/"+e1);var g1=h.aAggregationLevel[N];var h1=f1[g1];d1=new F(g1,h._getFilterOperatorMatchingPropertySortOrder(g1,false),h1);}for(var U=0;U<s;U++){var i1=[];var j1=Math.min(N,U+1);for(var k1=0;k1<j1;k1++){var l1=[];var m1=Math.min(N,k1+1);var n1=o.startIndex_Missing>0;for(var o1=0;o1<m1;o1++){var p1=new F("x",t.EQ,"x");p1=d(p1,k[o1]);if(m1>1&&o1<m1-1){p1.sOperator=t.EQ;}if(o1==N-1&&U>N-1&&!n1){if(p1.sOperator==t.GT){p1.sOperator=t.GE;}else{p1.sOperator=t.LE;}}l1.push(p1);}if(l1.length>0){i1.push(new F(l1,true));if(U>N-1&&k1==N-1&&n1){var q1=[];for(var j=0;j<l1.length;j++){var r1=new F("x",t.EQ,"x");r1=d(r1,l1[j]);q1.push(r1);}q1[N-1].sOperator=t.EQ;q1.push(d1);i1.push(new F(q1,true));break;}}}if(i1.length>0){P[U]=new F(i1,false);}else{P[U]=null;}}return P;};var m=function(r,g,U,b1,V,e,c1,d1){var e1;var f1=new a.QueryResultRequest(h.oAnalyticalQueryResult);f1.setResourcePath(h._getResourcePath());f1.getSortExpression().clear();var g1=0,h1=-1;g1=h1=U-1;var i1=0;for(var i=0,j1=0;i<g1;j1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[j1]].grouped==false){++i1;}else{++i;}}g1=h1=g1+i1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[h1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[h1]].grouped==false){if(++h1==h.aMaxAggregationLevel.length){break;}}}var k1=h1>=h.aMaxAggregationLevel.length-1;e1=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(f1,g);var l1=h.aMaxAggregationLevel.slice(0,h1+1);f1.setAggregationLevel(l1);for(var l=0;l<l1.length;l++){var m1=h.oDimensionDetailsSet[l1[l]];var n1=(m1.textPropertyName!=undefined);f1.includeDimensionKeyTextAttributes(m1.name,true,n1,m1.aAttributeName);if(m1.grouped){f1.getSortExpression().addSorter(l1[l],a.SortOrder.Ascending);}}var o1=f1.getFilterExpression();o1.clear();if(h.aApplicationFilter){o1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){o1.addUI5FilterConditions(h.aControlFilter);}if(b1){o1.addUI5FilterConditions([b1]);}K._addHierarchyLevelFilters(e1,o1);var p1;var q1;var r1;var s1;var t1=[];f1.setMeasures(h.aMeasureName);for(var u1 in h.oMeasureDetailsSet){s1=h.oMeasureDetailsSet[u1];if(!k1&&h._isSkippingTotalForMeasure(u1)){p1=false;q1=false;r1=false;}else{p1=(s1.rawValuePropertyName!=undefined);q1=(s1.formattedValuePropertyName!=undefined);r1=(s1.unitPropertyName!=undefined);if(r1){if(t1.indexOf(s1.unitPropertyName)==-1){t1.push(s1.unitPropertyName);}}}f1.includeMeasureRawFormattedValueUnit(s1.name,p1,q1,r1);}for(var j in l1){var v1;if((v1=t1.indexOf(l1[j]))!=-1){t1.splice(v1,1);}}var w1=f1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){w1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}if(e==0){E.fatal("unhandled case: load 0 entities of sub group");}var x1=V;if(!d1){x1=0;}else{var y1=0;for(var z1 in h.mServiceKey){if(z1.split("/").length===U+1){y1+=h.mServiceKey[z1].length;}}x1=Math.max(x1,y1);}if(!h.bNoPaging){f1.setResultPageBoundaries(x1+1,x1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:f1,iLevel:U,aSelectedUnitPropertyName:t1,aAggregationLevel:l1,bIsFlatListRequest:k1,bIsLeafGroupsRequest:k1,iStartIndex:V,iLength:e,bAvoidLengthUpdate:c1};};var q=[];var R=[];if(!o){E.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var N=z.length;var P=p(o,s);var Q;for(var U=1;U<=s;U++){var V;if(U>=N+2){V=0;Q=undefined;}else if(U==N+1){V=o.startIndex_Missing;Q=o.groupId_Missing;}else if(N>0){if(U==N){Q=o.groupId_Missing;}else{Q=this._getGroupIdAncestors(o.groupId_Missing,-(N-U))[0];}var W=this._getGroupIdAncestors(o.groupId_Missing,-(N-U+1))[0];if(!W){E.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+U);}V=this._findKeyIndex(W,this.mEntityKey[Q]);if(V==-1){E.fatal("failed to determine position of value "+Q+" in group "+W);}Q=W;V++;}var X=e>U?Math.ceil((e-U)/(s-U+1)):e;var Y=P[U-1];if(this.bUseAcceleratedAutoExpand){var Z=m(K._requestType.levelMembersQuery,g,U,Y,V,X,false,Y==null?true:false);Z.sGroupId_Missing_AtLevel=Q;Z.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U});q.push(Z);R.push(Z.sRequestId);}else if(Y&&Y.aFilters.length>0){if(!Y._bMultiFilter||Y.bAnd){E.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<Y.aFilters.length;i++){var $=Y.aFilters[i];var _=m(K._requestType.levelMembersQuery,g,U,$,V,X,false,Y==null?true:false);_.sGroupId_Missing_AtLevel=Q;_.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U,tupleIndex:i});q.push(_);R.push(_.sRequestId);}}else{var a1=m(K._requestType.levelMembersQuery,g,U,null,V,X,false,Y==null?true:false);a1.sGroupId_Missing_AtLevel=Q;a1.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U});q.push(a1);R.push(a1.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};
K.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var h=g.bIsLeafGroupsRequest;var k=o.getFilterExpression();k.clear();if(this.aApplicationFilter){k.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){k.addUI5FilterConditions(this.aControlFilter);}var l=[];for(var i=0;i<e.length;i++){var n=new F(e[i],t.EQ,m.oEntry[e[i]]);l.push(n);}k.addUI5FilterConditions(l);var p;var q;var s;var z;var N=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var P in this.oMeasureDetailsSet){z=this.oMeasureDetailsSet[P];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(z.name)==-1){continue;}if(!h&&this._isSkippingTotalForMeasure(P)){p=false;q=false;s=false;}else{p=(z.rawValuePropertyName!=undefined);q=(z.formattedValuePropertyName!=undefined);s=(z.unitPropertyName!=undefined);if(s){if(N.indexOf(z.unitPropertyName)==-1){N.push(z.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(z.name,p,q,s);}for(var j in e){var Q;if((Q=N.indexOf(e[j]))!=-1){N.splice(Q,1);}}return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:N,aAggregationLevel:e,oMultiUnitRepresentative:m};};
K.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};
K.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){E.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var j=o.getURIQueryOptionValue("$orderby");var k=o.getURIQueryOptionValue("$skip");var l=o.getURIQueryOptionValue("$top");var m=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(j!==null){P.push("$orderby="+j);}if(k!==null){P.push("$skip="+k);}if(l!==null){P.push("$top="+l);}if(m!==null){P.push("$inlinecount="+m);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};
K.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var N=z.oAnalyticalQueryRequest,P=z.sGroupId;if(N.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});P=null;this.mServiceLength[P]=this.mLength[P]=1;this.mServiceFinalLength[P]=true;this._setServiceKey(this._getKeyIndexMapping(P,0),K._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var Q=N.getURIToQueryResultEntries();if(!this.oContext&&Q[0]!=="/"){Q="/"+Q;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(Q.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(N,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var V=this.oModel.read(Q.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(V);}l.push(z);}}if(h.length>0){E.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var W;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);W=this.oModel.submitBatch(X,Y,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{W={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:X,error:Y});}this._registerNewRequestHandle(R,W);}function X(Z,$){g._deregisterHandleOfCompletedRequest(R);if(l.length!=Z.__batchResponses.length){E.fatal("assertion failed: received "+Z.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var _=l[j].sRequestId;if(_!==undefined){g._deregisterCompletedRequest(_);g._cleanupGroupingForCompletedRequest(_);}}g.fireDataReceived({data:[]});return;}var a1=0;for(var k=0;k<Z.__batchResponses.length;k++){if(Z.__batchResponses[k].data!=undefined){if(Z.__batchResponses[k].data.results.length==0){a1++;}switch(l[k].iRequestType){case K._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],Z.__batchResponses[k].data);break;default:E.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(a1==Z.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var b1=true;var c1;g.fireDataReceived({data:Z});var d1={};if(g.iModelVersion===A.V1){c1=g.oModel._getBatchErrors(Z);if(c1.length>0){b1=false;d1=g.oModel._handleError(c1[0]);}g.oModel.fireRequestCompleted({url:$.requestUri,type:"POST",async:true,info:"",infoObject:{},success:b1,errorobject:b1?{}:d1});if(b1){g.oModel.checkUpdate();}}}function Y(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,Z;(Z=l[++j])!==undefined;){g._deregisterCompletedRequest(Z.sRequestId);g._cleanupGroupingForCompletedRequest(Z.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var $=k;if(g.iModelVersion===A.V1){$=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:$});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed($);}g.fireDataReceived();}};
K.prototype._executeQueryRequest=function(r){if(r.iRequestType==K._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),K._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}E.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case K._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case K._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case K._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case K._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:E.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};
K.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};
K.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,z=this.aSorter.length>0,N=R.aSelectedUnitPropertyName,P=R.aAggregationLevel,Q=R.oKeyIndexMapping.iIndex,U=R.oKeyIndexMapping.iServiceKeyIndex,V=R.iLength,W=R.oKeyIndexMapping,X=n==null?0:this._getGroupIdLevel(n)+1,Y=(N.length>0),Z,$,_,a1=0,b1,c1,d1=[];var e1=e.results.length;if(n===null&&e1>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(z?"binding is refreshed":undefined);if(z){setTimeout(this.refresh.bind(this),0);return;}}var f1=this._getServiceKeys(n,W.iIndex-1);Z=undefined;if(f1&&f1.length>0){for(var i=0,g1=f1.length;i<g1;i++){e.results[i-g1]=this.oModel.getObject("/"+f1[i]);}var h1=e.results[-f1.length];Z="";for(var j=0;j<P.length;j++){Z+=h1[P[j]]+"|";}}b1=f1&&f1.length==1;for(var h=0;h<e1;h++){var i1=e.results[h];if(Y){$="";for(var g=0;g<P.length;g++){$+=i1[P[g]]+"|";}if(Z==$){this._warnNoSortingOfGroups();if(_===undefined){if(h==0){_=-f1.length;W.iServiceKeyIndex-=f1.length-1;}else{_=h-1;}}var j1=-1,k1=e.results[h-1];for(var k=0;k<N.length;k++){if(k1[N[k]]!=i1[N[k]]){j1=k;break;}}if(j1==-1){E.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,M(this,"NO_DEVIATING_UNITS"));}}if((Z!=$||h==e1-1)&&_!==undefined){var l1=[];for(var l=_;l<h;l++){l1.push(e.results[l]);}if(Z==$){l1.push(e.results[h]);}var m1=[];for(var m=0;m<N.length;m++){var n1=N[m];for(var o=1;o<l1.length;o++){if(l1[o-1][n1]!=l1[o][n1]){m1.push(n1);break;}}}var o1=this._createMultiUnitRepresentativeEntry(n,e.results[_],N,m1,R.bIsFlatListRequest);if(o1.aReloadMeasurePropertyName.length>0){c1=this._prepareReloadMeasurePropertiesQueryRequest(K._requestType.reloadMeasuresQuery,R,o1);if(c1.oAnalyticalQueryRequest&&c1.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){d1.push(c1);}}var p1=this._setAdjacentMultiUnitKeys(W,o1,l1);var q1;if(o1.bIsNewEntry){q1=l1.length-1;}else{q1=p1;}if(b1){b1=false;}if(q1<0){E.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}a1+=q1;var r1=this.oModel._getKey(o1.oEntry);var s1=this.oModel.getContext('/'+r1);this._getGroupIdFromContext(s1,X);this.mEntityKey[s]=r1;_=undefined;if(Z!=$){b1=this._setServiceKey(W,this.oModel._getKey(i1));}}else if(Z!=$){b1=this._setServiceKey(W,this.oModel._getKey(i1));}Z=$;}else{this._setServiceKey(W,this.oModel._getKey(i1));}if(!R.bIsLeafGroupsRequest){var t1=this._getKey(n,W.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+t1),X);this.mEntityKey[s]=t1;}}var u1=[];if(this.bReloadSingleUnitMeasures&&d1.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([K._requestType.reloadMeasuresQuery,d1]);Promise.resolve().then(K.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<d1.length;q++){var v1=d1[q];this._executeQueryRequest(v1);}}for(var p=0;p<d1.length;p++){var w1=d1[p];u1.push(w1.sRequestId);}this._considerRequestGrouping(u1);}if(f1&&f1.length>0){for(var r=0,x1=f1.length;r<x1;r++){delete e.results[r-x1];}}if(Y){a1+=this._mergeLoadedKeyIndexWithSubsequentIndexes(W,P,N,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var y1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-a1;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=this.mServiceLength[n];}y1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<U+e1){this.mServiceLength[n]=U+e1;this.mLength[n]=Q+e1-a1;this.mFinalLength[n]=false;}if(e1<V||V===undefined){this.mServiceLength[n]=U+e1;this.mLength[n]=Q+W.iIndex-Q;this.mFinalLength[n]=true;y1=true;}if(e1==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;y1=true;}if(!y1&&this.mLength[n]!==undefined&&a1>0){this.mLength[n]-=a1;}}this.bNeedsUpdate=true;if(a1>0){if(e.results.length-a1>0){this.aMultiUnitLoadFactor[P.length]=e.results.length/(e.results.length-a1);}if(this.aMultiUnitLoadFactor[P.length]<1.5){this.aMultiUnitLoadFactor[P.length]=2;}}E.info("MultiUnit Situation in Group ("+n+"), discarded: "+a1+", load-factor is now: "+this.aMultiUnitLoadFactor[P.length]);};
K.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){E.fatal("missing entity count in query result");return;}this.iTotalSize=parseInt(o.__count);};
K.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,l){var m={iRequestType:K._requestType.groupMembersQuery,sRequestId:e._getRequestId(K._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=m.sGroupId||e._getKeys(m.sGroupId)===undefined)){var s=e._getParentGroupId(m.sGroupId);var n=e._findKeyIndex(s,e.mEntityKey[m.sGroupId]);if(n<0){E.fatal("assertion failed: failed to determine position of "+m.sGroupId+" in group "+s);}else if(!n){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,n-1)!==undefined){var q=e._getKey(s,n-1);var z=e._getGroupIdFromContext(e.oModel.getContext('/'+q),e._getGroupIdLevel(m.sGroupId));e.mFinalLength[z]=true;m.iStartIndex=0;}}if(l){m.iLength=P.length;}m.oKeyIndexMapping=e._getKeyIndexMapping(m.sGroupId,m.iStartIndex);var N=d({},o);N.results=P;e._processGroupMembersQueryResponse(m,N);};if(o.results.length==0){this.bNeedsUpdate=true;return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};
K.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var s=this.oModel.getKey(m.oEntry);if(o.results.length!=1){E.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+s);return;}var R=o.results[0];var e=this.oModel.getObject("/"+s);if(!e){E.fatal("assertion failed: no entity found with key "+s);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};
K.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),j;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;j=k(i);while(j){o=this.oModel.getContext('/'+j);h.push(o);i++;j=k(i);}return h;}for(i=s;i<s+l;i++){j=k(i);if(!j){break;}o=this.oModel.getContext('/'+j);h.push(o);}return h;};
K.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this.mKeyIndex[g]||[],h=this.mFinalLength[g]?this.mLength[g]:undefined,j=O._getReadIntervals(e,s,l,i,h),o=O._mergeIntervals(j);if(o){return{startIndex:o.start,length:o.end-o.start};}return{startIndex:0,length:Math.min(0,l)};};
K.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var N=h._getLoadedContextsForGroup(g,s,l);var Q=s+N.length-1;if(N.length>=l){return n;}else if(h.mFinalLength[g]){if(N.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-N.length};}else{return{groupId_Missing:g,startIndex_Missing:Q+1,length_Missing:l-N.length};}}else{return{groupId_Missing:g,startIndex_Missing:Q+1,length_Missing:l-N.length};}}var R=h._getLoadedContextsForGroup(g,s,l);var m=l,U=s+R.length-1;for(var i=-1,V;(V=R[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(V,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:U+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};
K.prototype._getResourcePath=function(){return this.isRelative()?this.getResolvedPath():this.sPath;};
K.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};
K.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending;}}return null;};
K.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case a.SortOrder.Ascending:if(W){s=t.GE;}else{s=t.GT;}break;case a.SortOrder.Descending:if(W){s=t.LE;}else{s=t.LT;}break;default:s=t.GT;}return s;};
K.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var g=sap.ui.require("sap/ui/model/odata/Filter");if(typeof g==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof g){e[i]=e[i].convert();}}}return e;};
K.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){E.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};
K.prototype._getGroupIdLevel=function(g){if(g==null){E.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
K.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};
K.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){E.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{E.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){E.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){E.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};
K.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};
K.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};
K.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};
K.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){E.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};
K.prototype._deregisterHandleOfCompletedRequest=function(r){if(f(this.oPendingRequestHandle)){E.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){E.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};
K.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};
K.prototype._getRequestId=function(r,p){switch(r){case K._requestType.groupMembersQuery:if(p.groupId===undefined){E.fatal("missing group ID");}return K._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case K._requestType.levelMembersQuery:if(p.level===undefined){E.fatal("missing level");}if(p.groupId===undefined){E.fatal("missing groupId");}return""+K._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case K._requestType.totalSizeQuery:return K._requestType.totalSizeQuery;case K._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){E.fatal("missing multi unit entry key");}return K._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:E.fatal("invalid request type "+r);return-1;}};
K.prototype._registerNewRequest=function(r){if(r==undefined||r==""){E.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};
K.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};
K.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};
K.prototype._deregisterCompletedRequest=function(r){if(f(this.oPendingRequests)){E.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){E.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};
K.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var s in R){if(s!=r){this._cleanupGroupingForCompletedRequest(s);}}}return g;};
K.prototype._getKeyIndexMapping=function(g,s){var i,l,e,k=this.mKeyIndex[g],o={sGroupId:g,iIndex:s,iServiceKeyIndex:s},h=this.mServiceKey[g];if(k!==undefined){if(k[s]!==undefined){o.iServiceKeyIndex=k[s]==="ZERO"?0:Math.abs(k[s]);return o;}l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}if(l==0){e=0;}else{if(k[l]>=0){e=k[l];}else if(k[l+1]===undefined){e=-k[l];while(h[e+1]!==undefined){++e;}}else{e=Math.abs(k[l+1])-1;}if(h[e]===undefined){E.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+e);}}i=s-l;o.iServiceKeyIndex=e+i;}return o;};
K.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};
K.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){E.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){E.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};
K.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};
K.prototype._getServiceKeys=function(g,e){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],h=k[e];if(h===undefined){return undefined;}if(h>=0){return[s[h]];}var j=[];if(k[e+1]===undefined){h=k[e]=="ZERO"?0:-k[e];while(s[h]!==undefined){j.push(s[h++]);}}else{h=k[e]=="ZERO"?0:-k[e];for(var i=h,n=Math.abs(k[e+1]);i<n;i++){j.push(s[i]);}}return j;};
K.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};
K.prototype._findKeyIndex=function(g,k){var e=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(e[i]<0||e[i]==="ZERO"){if(m[i]==k){return i;}}else if(s[e[i]]==k){return i;}}return-1;};
K.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};
K.prototype._setAdjacentMultiUnitKeys=function(k,m,e){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<e.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(e[i]);}return n;};
K.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,g){var h=this.mKeyIndex[k.sGroupId],j=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],l=0,n=k.iServiceKeyIndex,o=k.iIndex;var p,q;if(h===undefined){return l;}var N=false;var P=j[n-1],r=j[n];if(r===undefined){return l;}if(P===undefined){E.fatal("assertion failed: missing expected entry before given key index");return l;}var z=this.oModel.getObject("/"+P);var Q=this.oModel.getObject("/"+r);var R="",U="";for(var i=0;i<e.length;i++){R+=z[e[i]]+"|";U+=Q[e[i]]+"|";}N=R==U;var V=o;if(V>=this.mLength[k.sGroupId]){E.fatal("assertion failed: service key exists,but no corresponding key index found");return l;}while(h[V]===undefined||Math.abs(h[V])<n){++V;}if(N){if(Math.abs(h[V])==n&&h[V]<0){if(V>o){if(h[o-1]<0){m[V]=undefined;h.splice(o,V-o+1);m.splice(o,V-o+1);}else{h[o-1]=-h[o-1];m[o-1]=m[V];m[V]=undefined;h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}}}else if(Math.abs(h[V])>n){var W=V-1;if(h[W]>0){p=this._createMultiUnitRepresentativeEntry(k.sGroupId,z,s,undefined,g);q=this.oModel._getKey(p.oEntry);h[W]=-h[W];m[W]=q;if(W>o){h.splice(o,W-o);m.splice(o,W-o);}if(p.bIsNewEntry){l=1;}else{l=0;}}else if(h[o-1]<0){if(V>o){m[W]=undefined;h.splice(o,W-o+1);m.splice(o,W-o+1);}}else{h[o-1]=-h[o-1];m[o-1]=m[W];m[W]=undefined;h.splice(o,W-o+1);m.splice(o,W-o+1);}}else if(h[V]==n){if(V>o){if(h[o-1]<0){h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}else{p=this._createMultiUnitRepresentativeEntry(k.sGroupId,z,s,undefined,g);q=this.oModel._getKey(p.oEntry);if(!p.bIsNewEntry){E.fatal("assertion failed: multi-unit entry already existed before");}h[o-1]=-h[o-1];m[o-1]=q;h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}}}else{E.fatal("assertion failed: uncovered case detected");return l;}}else if(h[V]>n){E.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(V-o>0){h.splice(o,V-o);m.splice(o,V-o);}return l;};
K.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=d({},r);var R=[];for(var h in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[h];if(!i&&this._isSkippingTotalForMeasure(h)){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName||o.name);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var j="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var n=m[this.aAllDimensionSortedByName[l]];var p=n===""?'""':n;p=p===undefined?"":p;j+=(encodeURIComponent(p)+",");}j+="-multiple-units-not-dereferencable|"+this._iId;var q;if(this.mMultiUnitKey[g]&&(q=this.mMultiUnitKey[g].indexOf(j))!=-1){return{oEntry:this.oModel.getObject("/"+j),bIsNewEntry:false,iIndex:q,aReloadMeasurePropertyName:R};}m.__metadata.uri=j;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var z=this.oModel._getKey(m);this.oModel.getContext('/'+z)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};
K.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};
K.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};
K.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};
K.prototype.refresh=function(e){K.prototype._refresh.apply(this,arguments);};
K.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.getResolvedPath();var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){b(this.mServiceKey,function(i,n){b(n,function(i,k){if(k in m){h=true;return false;}});if(h){return false;}});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};
K.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{b(this.mServiceKey,function(i,n){b(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};
K.prototype.getDownloadUrl=function(s){var e,p,z;var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var N=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,N,r.aAttributeName);}for(var P in this.oMeasureDetailsSet){h.push(P);}o.setMeasures(h);for(var Q in this.oMeasureDetailsSet){var R=this.oMeasureDetailsSet[Q];var U=(R.rawValuePropertyName!=undefined);var V=(R.formattedValuePropertyName!=undefined);var W=(R.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(R.name,U,V,W);}var X=o.getSortExpression();X.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){X.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}var Y=o.getFilterExpression();Y.clear();if(this.aApplicationFilter){Y.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){Y.addUI5FilterConditions(this.aControlFilter);}var Z=o.getURIToQueryResultEntitySet();var $=this._getQueryODataRequestOptions(o,true);if(!$){return undefined;}var _=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var a1=this.aAnalyticalInfo[k];if((a1.visible||a1.inResult)&&a1.name!==""&&a1.name!==_[_.length-1]){_.push(a1.name);if(this.oMeasureDetailsSet[a1.name]!=undefined&&this.oMeasureDetailsSet[a1.name].unitPropertyName!=undefined){_.push(this.oMeasureDetailsSet[a1.name].unitPropertyName);}}}for(var j=0,l=$.length;j<l;j++){if(/^\$select/i.test($[j])){if(this.mParameters.select){e=$[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(_.indexOf(p)===-1){_.push(p);}}}$[j]="$select="+_.join(",");break;}}if(s){$.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){$.push(this.sCustomParams);}if(Z){return this.oModel._createRequestUrl(Z,null,$).replace(/ /g,"%20");}};
K.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);});};
K.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==T.Sequential){E.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===T.Sequential;}return false;};
K.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}E.warning(m,this.sPath);}this.bApplySortersToGroups=false;};
K.prototype._isSkippingTotalForMeasure=function(m){var o=this.mAnalyticalInfoByProperty[m];return!!o&&o.total==false;};
K.Logger=E;return K;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalTreeBindingAdapter',["./AnalyticalBinding","sap/base/assert","sap/base/Log","sap/base/util/each","sap/ui/model/ChangeReason","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/TreeBindingAdapter","sap/ui/model/odata/ODataTreeBindingAdapter"],function(A,a,L,e,C,T,b,c,O){"use strict";var d=function(){if(!(this instanceof b)||this._bIsAdapted){return;}O.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.setAutoExpandMode(this.mParameters.autoExpandMode||T.Bundled);},s="sap.ui.model.analytics.AnalyticalTreeBindingAdapter";
d.prototype.getGrandTotalContext=function(){if(this._oRootNode){return this._oRootNode.context;}};
d.prototype.getGrandTotalNode=function(){if(this._oRootNode){return this._oRootNode;}};
d.prototype.getGrandTotalContextInfo=function(){return this._oRootNode;};
d.prototype.getLength=function(){if(!this._oRootNode){return 0;}if(this._oRootNode&&this._oWatermark&&this._isRunningInAutoExpand(T.Bundled)){if(this._oWatermark.groupID===this._oRootNode.groupID){return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;}return this._oWatermark.absoluteNodeIndex+this._oRootNode.numberOfTotals+1;}return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;};
d.prototype.getContextByIndex=function(i){if(this._oRootNode&&i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode.context;}var n=this.findNode(i);if(!n||!n.context){n={context:this.getContexts(i,1,0)[0]};}return n?n.context:undefined;};
d.prototype.getNodeByIndex=function(i){if(i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
d.prototype._isNodeSelectable=function(n){if(!n){return false;}return n.isLeaf&&!n.isArtificial;};
d.prototype._getContextsOrNodes=function(r,S,l,t){if(!this.isResolved()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}this._iPageSize=l;this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(S,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,S,l);}this._updateRowIndexMap(n,S);var f=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(this._isRunningInAutoExpand(T.Bundled)&&this._oWatermark){if(N.groupID===this._oWatermark.groupID||(this._oWatermark.groupID===this._oRootNode.groupID&&(S+i+1)==this.getLength()-1)){this._autoExpandPaging();}}if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}f.push(N.context);}if(m){var g=this;e(m,function(G,N){N.magnitude=0;N.numberOfTotals=0;g._loadChildContexts(N,{absoluteNodeIndex:N.absoluteNodeIndex});});f=[];for(var j=0;j<n.length;j++){var N=n[j];f.push(N.context);}}if(r){return n;}else{return f;}};
d.prototype._autoExpandPaging=function(){a(this._oWatermark,"No watermark was set!");a(this._isRunningInAutoExpand(T.Bundled),"Optimised AutoExpand Paging can only be used with TreeAutoExpandMode.Bundled!");var f=this.getNodeContexts(this._oWatermark.context,{startIndex:this._oWatermark.startIndex,length:this._iPageSize,threshold:this._iThreshold,level:this._oWatermark.level,numberOfExpandedLevels:this._oWatermark.autoExpand});return f;};
d.prototype._afterMatchHook=function(n,r,m,M,p,P){if(n.sumNode&&n!==this._oRootNode){if(r.length===m){return true;}var N=M.call(this,n.sumNode,n.sumNode.positionInParent,P);if(N){r.push(n.sumNode);}}};
d.prototype._afterMapHook=function(n,m){if(n.sumNode&&n!==this._oRootNode){m.call(this,n.sumNode);}};
d.prototype._createSumNode=function(n){var f;if(this.bProvideGrandTotals&&!this.mParameters.sumOnTop&&this.hasTotaledMeasures()&&n.children.length>1){f=this._createNode({parent:n.parent,positionInParent:n.children.length,context:n.context,level:n.level});f.nodeState=this._createNodeState({groupID:f.groupID,sum:true,expanded:false});}return f;};
d.prototype._buildTree=function(S,l){this._oRootNode=undefined;this._oWatermark=undefined;var n=this.mParameters&&this.getNumberOfExpandedLevels();var r=this.getRootContexts({startIndex:0,length:this._iPageSize,threshold:this._iThreshold,numberOfExpandedLevels:this._autoExpandMode===T.Bundled?n:undefined});var R;if(r==null){L.warning("AnalyticalTreeBindingAdapter: No Dimensions given. An artificial rootContext has be created. Please check your Table/Service definition for dimension columns!");}else{R=r[0];}if(!R){return;}var o=this._getNodeState("/");if(!o){o=this._updateTreeState({groupID:"/",expanded:true,sum:true});this._updateNodeSections("/",{startIndex:0,length:l});}this._oRootNode=this._createNode({context:R,parent:null,level:0,nodeState:o,isLeaf:false,autoExpand:n,absoluteNodeIndex:-1});this._oRootNode.isArtificial=true;this._loadChildContexts(this._oRootNode,{absoluteNodeIndex:-1});};
d.prototype._loadChildContexts=function(n,r){var N=n.nodeState;var m=this.getGroupSize(n.context,n.level);if(m>=0){if(!n.children[m-1]){n.children[m-1]=undefined;}if(n.level===this.aAggregationLevel.length){N.leafCount=m;}n.sumNode=this._createSumNode(n);}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];if(o.startIndex>n.children.length){continue;}var R;if(m===-1){R=o.length;}else{R=Math.min(o.length,m-o.startIndex);}var S=false;if(n.autoExpand>=0&&this._isRunningInAutoExpand(T.Bundled)){S=true;R=Math.max(0,m);}var f=this.getNodeContexts(n.context,{startIndex:o.startIndex,length:R,threshold:S?0:this._iThreshold,level:n.level,supressRequest:S});for(var j=0;j<f.length;j++){var g=f[j];var h=j+o.startIndex;var k=n.children[h];var u={context:f[j],parent:n,level:n.level+1,positionInParent:h,autoExpand:Math.max(n.autoExpand-1,-1),absoluteNodeIndex:(++r.absoluteNodeIndex)};if(k){k.context=u.context;k.parent=u.parent;k.level=u.level;k.positionInParent=u.positionInParent;k.magnitude=0;k.numberOfTotals=0;k.totalNumberOfLeafs=0;k.autoExpand=u.autoExpand;k.absoluteNodeIndex=u.absoluteNodeIndex;var G;if(g){G=this._calculateGroupID(k);}k.groupID=G;}else{k=this._createNode(u);}k.nodeState=this._getNodeState(k.groupID);if(!k.nodeState){k.nodeState=this._createNodeState({groupID:k.groupID,expanded:false});}k.nodeState.parentGroupID=n.groupID;k.isLeaf=!this.nodeHasChildren(k);n.children[h]=k;if(k.isLeaf){n.numberOfLeafs+=1;}if(k.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[k.groupID]&&k.isLeaf){this.setNodeSelection(k.nodeState,true);}if((k.autoExpand>=0||k.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[k.groupID]){if(k.autoExpand>=0&&k.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[k.groupID]){if(k.nodeState.selectAllMode===undefined){k.nodeState.selectAllMode=true;}}this._updateTreeState({groupID:k.nodeState.groupID,fallbackNodeState:k.nodeState,expanded:true});this._loadChildContexts(k,r);}n.magnitude+=k.magnitude;n.numberOfTotals+=k.numberOfTotals;n.numberOfLeafs+=k.numberOfLeafs;}if(k&&k.isLeaf){n.totalNumberOfLeafs=m;}else{n.totalNumberOfLeafs+=k.totalNumberOfLeafs;}}}m=this._isRunningInAutoExpand(T.Bundled)?n.children.length:m;n.magnitude+=Math.max(m||0,0);if(!m&&!this._isRunningInAutoExpand(T.Bundled)){L.warning("AnalyticalTreeBindingAdapter: iMaxGroupSize("+m+") is undefined for node '"+n.groupID+"'!");}if(n.sumNode||(n===this._oRootNode&&this.providesGrandTotal()&&this.hasTotaledMeasures())){n.numberOfTotals+=1;}if(this._isRunningInAutoExpand(T.Bundled)&&n.autoExpand!=-1){if(!this._oWatermark&&!n.isLeaf&&!this.mFinalLength[n.groupID]){this._oWatermark={groupID:n.groupID,context:n.context,absoluteNodeIndex:n.absoluteNodeIndex,startIndex:n.children.length,level:n.level,autoExpand:n.autoExpand};}}};
d.prototype._calculateGroupID=function(n){var g;var m=this.aAggregationLevel.length;if(!this.isGrouped()&&n&&n.positionInParent){g="/"+n.positionInParent+"/";}else{if(n.level>m){g=this._getGroupIdFromContext(n.context,m);a(n.positionInParent!=undefined,"If the node level is greater than the number of grouped columns, the position of the node to its parent must be defined!");g+=n.positionInParent+"/";}else{g=this._getGroupIdFromContext(n.context,n.level);}}return g;};
d.prototype.collapse=function(p){var n,N;if(typeof p==="object"){n=p;}else if(typeof p==="number"){N=this.findNode(p);a(N&&N.nodeState,"AnalyticalTreeBindingAdapter.collapse("+p+"): No node found!");if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,expanded:false});n.selectAllMode=false;var f=false;if(this.bCollapseRecursive||this._isRunningInAutoExpand(T.Bundled)){var g=n.groupID;if(this._isRunningInAutoExpand(T.Bundled)&&this._oWatermark&&(typeof g=="string"&&g.length>0&&this._oWatermark.groupID.startsWith(g))){if(N&&N.parent){this._oWatermark={groupID:N.parent.groupID,context:N.parent.context,absoluteNodeIndex:N.parent.absoluteNodeIndex,startIndex:N.positionInParent+1,level:N.parent.level,autoExpand:N.parent.autoExpand};}this._autoExpandPaging();f=true;}var t=this;e(this._mTreeState.expanded,function(G,o){if(typeof g=="string"&&g.length>0&&G.startsWith(g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];e(this._mTreeState.selected,function(G,o){if(typeof g=="string"&&g.length>0&&G.startsWith(g)){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var h={rowIndices:[]};var i=0;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){h.oldIndex=i;h.leadIndex=-1;}h.rowIndices.push(i);}});this._publishSelectionChanges(h);}}if(!f){this._fireChange({reason:C.Collapse});}};
d.prototype.collapseToLevel=function(l){this.setNumberOfExpandedLevels(l,true);c.prototype.collapseToLevel.call(this,l);};
d.prototype.nodeHasChildren=function(n){a(n,"AnalyticalTreeBindingAdapter.nodeHasChildren: No node given!");if(!n||!n.parent||n.nodeState.sum){return false;}else if(n.isArtificial){return true;}else{return A.prototype.hasChildren.call(this,n.context,{level:n.level});}};
d.prototype.resetData=function(o,p){var r=A.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._oWatermark=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
d.prototype.hasTotaledMeasures=function(){var h=false;e(this.getMeasureDetails()||[],function(i,m){if(m.analyticalInfo.total){h=true;return false;}});return h;};
d.prototype.isGrouped=function(){return(this.aAggregationLevel.length>0);};
d.prototype._isRunningInAutoExpand=function(f){if(this.getNumberOfExpandedLevels()>0&&this._autoExpandMode===f){return true;}else{return false;}};
d.prototype.setNumberOfExpandedLevels=function(l,S){var n;l=l||0;if(l<0){L.warning("Number of expanded levels was set to 0. Negative values are prohibited",this,s);l=0;}n=this.aAggregationLevel.length;if(l>n){L.warning("Number of expanded levels was reduced from "+l+" to "+n+" which is the number of grouped dimensions",this,s);l=n;}if(!S){this.resetData();}this.mParameters.numberOfExpandedLevels=l;};
d.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels;};
d.prototype._getSelectableNodesCount=function(n){if(n){return n.totalNumberOfLeafs;}else{return 0;}};
return d;},true);
sap.ui.predefine('sap/ui/model/analytics/AnalyticalVersionInfo',["sap/base/Log"],function(L){"use strict";var A={NONE:null,V1:1,V2:2,getVersion:function(o){var v;var O;if(o&&o.getMetadata){O=o.getMetadata().getName();}switch(O){case"sap.ui.model.odata.ODataModel":v=this.V1;break;case"sap.ui.model.odata.v2.ODataModel":v=this.V2;break;default:v=this.NONE;L.info("AnalyticalVersionInfo.getVersion(...) - The given object is no instance of ODataModel V1 or V2!");break;}return v;}};return A;},true);
sap.ui.predefine('sap/ui/model/analytics/BatchResponseCollector',function(){"use strict";
function B(p){if(p){this.setup(p);}}
B.TYPE_SUCCESS="success";B.TYPE_ERROR="error";
B.prototype.setup=function(p){this.iRequestCollectionCount=0;this.aCollectedSuccesses=[];this.aCollectedErrors=[];this.aExecutedRequestDetails=p.executedRequests;this.oAnalyticalBinding=p.binding;this.fnSuccessHandler=p.success;this.fnErrorHandler=p.error;};
B.prototype.success=function(r){this.collect(r,B.TYPE_SUCCESS);};
B.prototype.error=function(r){this.collect(r,B.TYPE_ERROR);};
B.prototype.collect=function(r,R){this.iRequestCollectionCount++;if(R===B.TYPE_SUCCESS){this.aCollectedSuccesses.push(r);}else{this.aCollectedErrors.push(r);}var o=(this.aCollectedSuccesses.length+this.aCollectedErrors.length);if(o===this.aExecutedRequestDetails.length){if((this.aCollectedSuccesses.length===o)&&this.aCollectedErrors.length===0){this.fnSuccessHandler.call(window,{__batchResponses:this.aCollectedSuccesses},{requestUri:this.oAnalyticalBinding.oModel.sServiceUrl+"/$batch"});}else{this.fnErrorHandler.call(window,this.aCollectedErrors[0]||{});}}};
return B;},true);
sap.ui.predefine('sap/ui/model/analytics/ODataModelAdapter',['./AnalyticalBinding',"./AnalyticalTreeBindingAdapter",'./odata4analytics','./AnalyticalVersionInfo',"sap/base/Log"],function(A,a,o,b,L){"use strict";var O=function(){var m=b.getVersion(this);if(m===b.NONE||this.getAnalyticalExtensions){return;}this._mPreadapterFunctions={bindList:this.bindList,bindTree:this.bindTree};for(var f in O.prototype){if(O.prototype.hasOwnProperty(f)){this[f]=O.prototype[f];}}if(m===b.V1&&this.isCountSupported()){L.info("ODataModelAdapter: switched ODataModel to use inlinecount (mandatory for the AnalyticalBinding)");this.setCountSupported(false);}};
O.prototype.bindList=function(p,c,s,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,s,f,P);a.apply(B);return B;}else{return this._mPreadapterFunctions.bindList.apply(this,arguments);}};
O.prototype.bindTree=function(p,c,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,[],f,P);return B;}else{return this._mPreadapterFunctions.bindTree.apply(this,arguments);}};
O.prototype.getAnalyticalExtensions=function(){if(this.oOData4SAPAnalyticsModel!=undefined&&this.oOData4SAPAnalyticsModel!=null){return this.oOData4SAPAnalyticsModel;}var m=b.getVersion(this);if(m===b.V2&&!(this.oMetadata&&this.oMetadata.isLoaded())){throw"Failed to get the analytical extensions. The metadata have not been loaded by the model yet."+"Register for the 'metadataLoaded' event of the ODataModel(v2) to know when the analytical extensions can be retrieved.";}var s=null;if(arguments.length==1){var c=arguments[0];var r=jQuery.sap.syncGetText(c);if(r.success){s=r.data;}}try{this.oOData4SAPAnalyticsModel=new o.Model(new o.Model.ReferenceByModel(this),{sAnnotationJSONDoc:s});}catch(e){throw"Failed to instantiate analytical extensions for given OData model: "+e.message;}return this.oOData4SAPAnalyticsModel;};
O.prototype.setAnalyticalExtensions=function(c){this.oOData4SAPAnalyticsModel=c;};
return O;},true);
sap.ui.predefine('sap/ui/model/analytics/odata4analytics',['sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/Sorter','./AnalyticalVersionInfo',"sap/base/security/encodeURL"],function(F,c,S,A,e){"use strict";var o=o||{},d=/^\d+$/;o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={deepEqual:function(O,N,f){var a,b,r=0,i,n;if(!O||O.length!==N.length){return 2;}if(O!==N){for(i=0,n=O.length;i<n;i+=1){b=O[i];a=N[i];if(b.grouped!==a.grouped||b.inResult!==a.inResult||b.level!==a.level||b.name!==a.name||b.total!==a.total||b.visible!==a.visible){return 2;}if(b.formatter!==a.formatter){r=1;if(f){f(a);}}}}return r;},tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l;}};
o.Model=function(m,p){this._init(m,p);};
o.Model.ReferenceByURI=function(u){return{sServiceURI:u};};
o.Model.ReferenceByModel=function(m){return{oModel:m};};
o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w};};
o.Model.prototype={_init:function(m,p){var O,t=this;if(typeof p=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead";}this._mParameter=p;this._oActivatedWorkarounds={};if(m&&m.aWorkaroundID){for(var i=-1,I;(I=m.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true;}m=m.oModelReference;}if(!m||(!m.sServiceURI&&!m.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel";}if(m.oModel){this._oModel=m.oModel;this._iVersion=A.getVersion(this._oModel);a();}else if(p&&p.modelVersion===A.V2){O=sap.ui.require("sap/ui/model/odata/v2/ODataModel")||sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V2;a();}else{O=sap.ui.require("sap/ui/model/odata/ODataModel")||sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V1;a();}if(this._oModel.getServiceMetadata()&&this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded";}function a(){if(!t._oModel.getServiceMetadata()){t._oModel.attachMetadataLoaded(b);}else{b();}}function b(){if(t.bIsInitialized){return;}t.bIsInitialized=true;if(p&&p.sAnnotationJSONDoc){t.mergeV2Annotations(p.sAnnotationJSONDoc);}t._interpreteMetadata(t._oModel.getServiceMetadata().dataServices);}},_interpreteMetadata:function(M){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var a=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,C;(C=a.entityContainer[++j])!==undefined;){if(C.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=C;break;}}var E=a.entityType;var q=[],P=[],u=[];for(var k=-1,T;(T=E[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,f;(f=T.extensions[++l])!==undefined;){if(f.namespace==o.constants.SAP_NAMESPACE&&f.name=="semantics"){b=true;switch(f.value){case"aggregate":q.push(T);break;case"parameters":P.push(T);break;default:u.push(T);}}if(b){continue;}}if(!b){u.push(T);}}else{u.push(T);}}for(var m=-1,g;(g=u[++m])!==undefined;){var h=new o.EntityType(this._oModel.getServiceMetadata(),a,g);this._oEntityTypeSet[h.getQName()]=h;var i=this._getEntitySetsOfType(a,h.getQName());if(i.length==0){throw"Invalid consumption model: No entity set for entity type "+h.getQName()+" found";}if(i.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+h.getQName()+" found";}var v=new o.EntitySet(this._oModel.getServiceMetadata(),a,i[0][0],i[0][1],h);this._oEntitySetSet[v.getQName()]=v;this._oEntityTypeNameToEntitySetMap[h.getQName()]=v;}var w={};for(var n=-1,x;(x=P[++n])!==undefined;){var y=new o.EntityType(this._oModel.getServiceMetadata(),a,x);this._oEntityTypeSet[y.getQName()]=y;var z=this._getEntitySetsOfType(a,y.getQName());if(z.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+y.getQName()+" found";}if(z.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+y.getQName()+" found";}var B=new o.EntitySet(this._oModel.getServiceMetadata(),a,z[0][0],z[0][1],y);this._oEntitySetSet[B.getQName()]=B;this._oEntityTypeNameToEntitySetMap[y.getQName()]=B;var D=new o.Parameterization(y,B);this._oParameterizationSet[D.getName()]=D;w[y.getQName()]=D;var G=y.getQName();if(a.association!=undefined){for(var p=-1,H;(H=a.association[++p])!==undefined;){if(H.referentialConstraint==undefined){continue;}var I=null;if(H.end[0].type==G&&H.end[0].multiplicity=="*"&&H.end[1].multiplicity=="1"){I=H.end[1].type;}else if(H.end[1].type==G&&H.end[1].multiplicity=="*"&&H.end[0].multiplicity=="1"){I=H.end[0].type;}if(!I){continue;}if(H.referentialConstraint.dependent.propertyRef.length!=1){continue;}var J=D.findParameterByName(H.referentialConstraint.dependent.propertyRef[0].name);if(J==null){continue;}var V=this._oEntityTypeSet[I];var K=this._oEntityTypeNameToEntitySetMap[I];J.setValueSetEntity(V,K);}}}for(var r=-1,L;(L=q[++r])!==undefined;){var N=new o.EntityType(this._oModel.getServiceMetadata(),a,L);this._oEntityTypeSet[N.getQName()]=N;var Q=N.getQName();var O=null;var R=null;if(a.association!=undefined){for(var s=-1,U;(U=a.association[++s])!==undefined;){var W=null;if(U.end[0].type==Q){W=U.end[1].type;}else if(U.end[1].type==Q){W=U.end[0].type;}else{continue;}var X=null;X=w[W];if(X!=null){if(O!=null){throw"Unable to handle multiple parameter entity types of query entity "+N.name;}else{O=X;R=U;}}}}var Y=this._getEntitySetsOfType(a,N.getQName());if(Y.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics";}var Z=new o.EntitySet(this._oModel.getServiceMetadata(),a,Y[0][0],Y[0][1],N);this._oEntitySetSet[Z.getQName()]=Z;this._oEntityTypeNameToEntitySetMap[N.getQName()]=Z;var $=new o.QueryResult(this,N,Z,O);this._oQueryResultSet[$.getName()]=$;if(O){O.setTargetQueryResult($,R);}if(a.association!=undefined){for(var t=-1,_;(_=a.association[++t])!==undefined;){if(_.referentialConstraint==undefined){continue;}var a1=null;if(_.end[0].type==Q&&_.end[0].multiplicity=="*"&&_.end[1].multiplicity=="1"){a1=_.end[1].type;}else if(_.end[1].type==Q&&_.end[1].multiplicity=="*"&&_.end[0].multiplicity=="1"){a1=_.end[0].type;}if(!a1){continue;}if(_.referentialConstraint.dependent.propertyRef.length!=1){continue;}var b1=$.findDimensionByName(_.referentialConstraint.dependent.propertyRef[0].name);if(b1==null){continue;}var c1=this._oEntityTypeNameToEntitySetMap[a1];b1.setMembersEntitySet(c1);}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var b=null;try{b=JSON.parse(a);}catch(f){return;}var m;try{m=this._oModel.getServiceMetadata().dataServices;}catch(f){return;}for(var p in b){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue;}if(!(b[p]instanceof Array)){continue;}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],b[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break;}return;},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,b;(b=a[++i])!==undefined;){for(var j=-1,f;(f=M[++j])!==undefined;){if(!(b[u.keyPropName]==f[u.keyPropName])){continue;}if(b["extensions"]!=undefined){if(f["extensions"]==undefined){f["extensions"]=[];}for(var l=-1,g;(g=b["extensions"][++l])!==undefined;){var h=false;for(var m=-1,n;(n=f["extensions"][++m])!==undefined;){if(g.name==n.name&&g.namespace==n.namespace){n.value=g.value;h=true;break;}}if(!h){f["extensions"].push(g);}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in b){if(!(U.objectName==p)){continue;}if(!(b[U.objectName]instanceof Array)){continue;}if((f[U.objectName]==undefined)||(!(f[U.objectName]instanceof Array))){continue;}this.mergeV2AnnotationLevel(f[U.objectName],b[U.objectName],U);break;}}}}return;},findQueryResultByName:function(n){var q=this._oQueryResultSet[n];if(!q&&this._oDefaultEntityContainer){var Q=this._oDefaultEntityContainer.name+"."+n;q=this._oQueryResultSet[Q];}return q;},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames;}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName());}return this._aQueryResultNames;},getAllQueryResults:function(){return this._oQueryResultSet;},getODataModel:function(){return this._oModel;},_getEntitySetsOfType:function(s,q){var E=[];for(var i=-1,a;(a=s.entityContainer[++i])!==undefined;){for(var j=-1,b;(b=a.entitySet[++j])!==undefined;){if(b.entityType==q){E.push([a,b]);}}}return E;},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};
o.QueryResult=function(m,E,a,p){this._init(m,E,a,p);};
o.QueryResult.prototype={_init:function(m,E,a,p,b){this._oModel=m;this._oEntityType=E;this._oEntitySet=a;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=E.getTypeDescription().property;var f={};for(var i=-1,g;(g=P[++i])!==undefined;){if(g.extensions==undefined){continue;}for(var j=-1,h;(h=g.extensions[++j])!==undefined;){if(!h.namespace==o.constants.SAP_NAMESPACE){continue;}switch(h.name){case"aggregation-role":switch(h.value){case"dimension":{var D=new o.Dimension(this,g);this._oDimensionSet[D.getName()]=D;break;}case"measure":{var M=new o.Measure(this,g);this._oMeasureSet[M.getName()]=M;break;}case"totaled-properties-list":this._oTotaledPropertyListProperty=g;break;default:}break;case"attribute-for":{var k=new o.DimensionAttribute(this,g);var K=k.getKeyProperty();f[K.name]=k;break;}default:}}}for(var s in f){var l=f[s];l.getDimension().addAttribute(l);}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var n=[];for(var q in this._oDimensionSet){var r=this._oDimensionSet[q];if(!r.getTextProperty()){var T=null;T=E.findPropertyByName(q+"Name");if(!T){T=E.findPropertyByName(q+"Text");}if(!T){T=E.findPropertyByName(q+"Desc");}if(!T){T=E.findPropertyByName(q+"Description");}if(T){r.setTextProperty(T);n.push(T.name);}}}for(var t=-1,u;(u=n[++t])!==undefined;){delete this._oDimensionSet[u];}}},getName:function(){return this.getEntitySet().getQName();},getParameterization:function(){return this._oParameterization;},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames;}this._aDimensionNames=[];for(var n in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[n].getName());}return this._aDimensionNames;},getAllDimensions:function(){return this._oDimensionSet;},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames;}this._aMeasureNames=[];for(var n in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[n].getName());}return this._aMeasureNames;},getAllMeasures:function(){return this._oMeasureSet;},findDimensionByName:function(n){return this._oDimensionSet[n];},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n];}for(var D in this._oDimensionSet){var a=this._oDimensionSet[D];var t=a.getTextProperty();if(t&&t.name==n){return a;}if(a.findAttributeByName(n)){return a;}}return null;},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty;},findMeasureByName:function(n){return this._oMeasureSet[n];},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n];}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M;}}return null;},getModel:function(){return this._oModel;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};
o.Parameterization=function(E,a){this._init(E,a);};
o.Parameterization.prototype={_init:function(E,a){this._oEntityType=E;this._oEntitySet=a;this._oParameterSet={};var p=E.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue;}for(var j=-1,b;(b=P.extensions[++j])!==undefined;){if(!b.namespace==o.constants.SAP_NAMESPACE){continue;}switch(b.name){case"parameter":{var f=new o.Parameter(this,P);this._oParameterSet[f.getName()]=f;break;}default:}}}},setTargetQueryResult:function(q,a){this._oQueryResult=q;var Q=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==Q){this._oNavPropToQueryResult=N.name;}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set";}return this._oQueryResult;},getName:function(){return this.getEntitySet().getQName();},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames;}this._aParameterNames=[];for(var n in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[n].getName());}return this._aParameterNames;},getAllParameters:function(){return this._oParameterSet;},findParameterByName:function(n){return this._oParameterSet[n];},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};
o.Parameter=function(p,P){this._init(p,P);};
o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var E=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,a;(a=P.extensions[++i])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"parameter":switch(a.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property";}break;case"label":this._sLabelText=a.value;break;case"text":this._oTextProperty=E.findPropertyByName(a.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},setValueSetEntity:function(E,a){this._oValueSetEntityType=E;this._oValueSetEntitySet=a;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isOptional:function(){return(!this._bRequired);},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter;},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false);},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name;}else{p=this._oUpperIntervalBoundaryParameterProperty.name;}if(!p){throw"Parameter is not an interval boundary";}return this._oParameterization.findParameterByName(p);},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false);},getName:function(){return this._oProperty.name;},getProperty:function(){return this._oProperty;},getContainingParameterization:function(){return this._oParameterization;},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u;},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};
o.Dimension=function(q,p){this._init(q,p);};
o.Dimension.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;this._oAttributeSet={};},setMembersEntitySet:function(E){this._oMembersEntitySet=E;},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName());}return this._oTextProperty;},setTextProperty:function(t){this._oTextProperty=t;},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName());}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return(this._sLabelText==null?"":this._sLabelText);},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName());if(s){this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s.name);}}return this._sSuperOrdinateDimension;},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name);}return this._oHierarchy;},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames;}this._aAttributeNames=[];for(var n in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[n].getName());}return this._aAttributeNames;},getAllAttributes:function(){return this._oAttributeSet;},findAttributeByName:function(n){return this._oAttributeSet[n];},addAttribute:function(D){this._oAttributeSet[D.getName()]=D;},getContainingQueryResult:function(){return this._oQueryResult;},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false;},getMasterDataEntitySet:function(){return this._oMembersEntitySet;},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};
o.DimensionAttribute=function(q,p){this._init(q,p);};
o.DimensionAttribute.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"attribute-for":this._sDimensionName=E.value;break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};
o.Measure=function(q,p){this._init(q,p);};
o.Measure.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;case"unit":this._oUnitProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},getName:function(){return this._oProperty.name;},getRawValueProperty:function(){return this._oProperty;},getFormattedValueProperty:function(){return this._oTextProperty;},getUnitProperty:function(){return this._oUnitProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable;}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};
o.EntitySet=function(m,s,C,E,a){this._init(m,s,C,E,a);};
o.EntitySet.prototype={_init:function(m,s,C,E,a){this._oEntityType=a;this._oEntitySet=E;this._oContainer=C;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=C.name+"."+E.name;}else{this._sQName=E.name;}},getQName:function(){return this._sQName;},getSetDescription:function(){return this._oEntitySet;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames;}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,E;(E=this._oEntitySet.extensions[++j])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="updatable"){if(E.value=="false"){s=false;break;}}}}if(!s){return this._oUpdatablePropertyNames;}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue;}for(var k=-1,a;(a=P.extensions[++k])!==undefined;){if(a.namespace!=o.constants.SAP_NAMESPACE){continue;}if(a.name=="updatable"){if(a.value=="false"){b=false;break;}}}if(b){this._oUpdatablePropertyNames[P.name]=true;}}return this._oUpdatablePropertyNames;},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};
o.EntityType=function(m,s,E){this._init(m,s,E);};
o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+E.name;var r={};function g(K){var R=r[K];if(!R){R=r[K]={};}return R;}for(var i=-1,p;(p=E.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name);}for(var k=-1,P;(P=E.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue;}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(a.namespace!==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"filterable":if(a.value=="false"){this._aFilterablePropertyNames.pop(P.name);}break;case"sortable":if(a.value=="false"){this._aSortablePropertyNames.pop(P.name);}break;case"required-in-filter":if(a.value=="true"){this._aRequiredFilterPropertyNames.push(P.name);}break;case"filter-restriction":if(a.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||a.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||a.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=a.value;}break;case"hierarchy-node-external-key-for":g(a.value).externalKeyProperty=P;break;case"hierarchy-node-for":g(P.name).dimensionName=a.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":g(a.value).parentNodeIDProperty=P;break;case"hierarchy-level-for":g(a.value).levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":g(a.value).drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var b=this._oPropertySet[h];var D=this._oPropertySet[H.dimensionName];if(D==null){D=b;}this._oRecursiveHierarchySet[D.name]=new o.RecursiveHierarchy(E,b,H.parentNodeIDProperty,H.levelProperty,D,H.externalKeyProperty);}},getProperties:function(){return this._oPropertySet;},findPropertyByName:function(p){return this._oPropertySet[p];},getKeyProperties:function(){return this._aKeyProperties;},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="label"){return E.value;}}}return null;},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="heading"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="quickinfo"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="text"){return this.findPropertyByName(E.value);}}}return null;},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="super-ordinate"){return this.findPropertyByName(E.value);}}}return null;},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames;},getSortablePropertyNames:function(){return this._aSortablePropertyNames;},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames;},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet;},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames;}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);}return this._aHierarchyPropertyNames;},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null;}return this._oRecursiveHierarchySet[n];},getQName:function(){return this._sQName;},getTypeDescription:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};
o.RecursiveHierarchy=function(E,n,p,N,a,b){this._init(E,n,p,N,a,b);};
o.RecursiveHierarchy.prototype={_init:function(E,n,p,N,a,b){this._oEntityType=E;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a;this._oNodeExternalKeyProperty=b;},isRecursiveHierarchy:function(){return true;},isLeveledHierarchy:function(){return false;},getNodeExternalKeyProperty:function(){return this._oNodeExternalKeyProperty;},getNodeIDProperty:function(){return this._oNodeIDProperty;},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty;},getNodeLevelProperty:function(){return this._oNodeLevelProperty;},getNodeValueProperty:function(){return this._oNodeValueProperty;},_oEntityType:null,_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null,_oNodeExternalKeyProperty:null};
o.FilterExpression=function(m,s,E){this._init(m,s,E);};
o.FilterExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_renderPropertyFilterValue:function(f,p){if(p==="Edm.Time"&&d.test(f)){f={ms:parseInt(f),__edmType:"Edm.Time"};}return e(this._oModel.getODataModel().formatValue(f,p));},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return;}}this._aConditionUI5Filter.push(new F(p,O,v,V));},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u);},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}this._addCondition(p,O,v,V);return this;},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p;}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1);}}return this;},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,c.EQ,V);}return this;},addUI5FilterConditions:function(u){if(!Array.isArray(u)){throw"Argument is not an array";}if(u.length==0){return this;}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break;}}if(h){this._addUI5FilterArray(u);}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2);}}return this;},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,a;(a=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,b;(b=a[++j])!==undefined;){f.push(b);}}return f;},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r);}else{if(r[U.sPath]==undefined){r[U.sPath]=[];}r[U.sPath].push(U);}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[];}r[u.sPath].push(u);}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r);}return r;},renderUI5Filter:function(u){var f=null,p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath;}switch(u.sOperator){case c.BT:f="("+u.sPath+" ge "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" le "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.NB:f="("+u.sPath+" lt "+this._renderPropertyFilterValue(u.oValue1,p.type)+" or "+u.sPath+" gt "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.Contains:case c.NotContains:f=(u.sOperator[0]==="N"?"not ":"")+"substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case c.StartsWith:case c.EndsWith:case c.NotStartsWith:case c.NotEndsWith:f=u.sOperator.toLowerCase().replace("not","not ")+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type);}return f;},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue;}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")";}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")";}}return O;},renderUI5FilterArray:function(u){if(u.length==0){return"";}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0;}if(a.sPath>b.sPath){return 1;}else{return-1;}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,f;(f=u[++i])!==undefined;){if(f.aFilters!=undefined){U.push(f);continue;}if(p!=f.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N);}O+=(O==""?"":" and ")+"("+s+")";s="";}p=f.sPath;n=[];}if(f.sOperator==c.NE){n.push(f);continue;}s+=(s==""?"":" or ")+this.renderUI5Filter(f);}if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}if(n.length>0){s="";for(var k=-1,g;(g=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(g);}O+=(O==""?"":" and ")+"("+s+")";}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")";}}return O;},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")";}return O;},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P;}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1){var t=p[s][0].oValue1;for(var j=0;j<p[s].length;j++){if(p[s][j].oValue1!=t||p[s][j].sOperator!=c.EQ){throw"filter expression may use "+s+" only with a single EQ condition";}}}}}}return true;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};
o.SortExpression=function(m,s,E){this._init(m,s,E);};
o.SortExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aSortCondition=[];},_containsSorter:function(p){var r=null;for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(C.property.name===p){r={sorter:C,index:i};break;}}return r;},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r);},clear:function(){this._aSortCondition=[];},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p;}var E=this._containsSorter(p);if(E!=null){E.sorter.order=s;return this;}var a=this._oEntityType.getSortablePropertyNames();if(((a?Array.prototype.indexOf.call(a,p):-1))===-1){throw"Cannot add sort condition for not sortable property name "+p;}this._aSortCondition.push({property:P,order:s});return this;},removeSorter:function(p){if(!p){return;}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index);}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){s.push(new S(C.property.name,C.order==o.SortOrder.Descending));}return s;},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null;}else{return s[0];}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return"";}var O="";for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(!s[C.property.name]){continue;}O+=(O==""?"":",")+C.property.name+" "+C.order;}return O;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};
o.ParameterizationRequest=function(p){this._init(p);};
o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given";}this._oParameterization=p;this._oParameterValueAssignment=[];},_renderParameterKeyValue:function(k,p){return e(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p));},getParameterization:function(){return this._oParameterization;},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p;}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values";}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary";}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p];}else{this._oParameterValueAssignment[p]=v;}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary";}if(v==null){delete this._oParameterValueAssignment[p];t=null;}else{this._oParameterValueAssignment[p]=v;}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v;}if(v==null){delete this._oParameterValueAssignment[u.getName()];}else{this._oParameterValueAssignment[u.getName()]=t;}}return;},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName();},getURIToParameterizationEntry:function(s){var D=this._oParameterization.getAllParameters();for(var a in D){if(this._oParameterValueAssignment[a]==undefined){throw"Parameter "+a+" has no value assigned";}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],D[p].getProperty().type);f=false;}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")";},_oParameterization:null,_oParameterValueAssignment:null};
o.QueryResultRequest=function(q,p){this._init(q,p);};
o.QueryResultRequest.prototype={_init:function(q,p){this._oQueryResult=q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oDimensionHierarchies={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null;},addRecursiveHierarchy:function(h,i,I){var D;if(!h){return;}D=this._oQueryResult.findDimensionByName(h);if(!D){throw new Error("'"+h+"' is not a dimension property");}if(!D.getHierarchy()){throw new Error("Dimension '"+h+"' does not have a hierarchy");}this._oSelectedPropertyNames=null;this._oDimensionHierarchies[h]={externalKey:i,id:true,text:I};},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path";}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path";}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path";}}},getParameterizationRequest:function(){return this._oParameterizationRequest;},getQueryResult:function(){return this._oQueryResult;},setAggregationLevel:function(D){this._oAggregationLevel={};if(!D){D=this._oQueryResult.getAllDimensionNames();}this.addToAggregationLevel(D);this._oSelectedPropertyNames=null;},addToAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}this._oAggregationLevel[s]={key:true,text:false,attributes:null};}},removeFromAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}if(this._oAggregationLevel[s]!=undefined){delete this._oAggregationLevel[s];this.getSortExpression().removeSorter(s);}}},getAggregationLevel:function(){var D=[];for(var s in this._oAggregationLevel){D.push(s);}return D;},getAggregationLevelDetails:function(D){if(this._oAggregationLevel[D]==undefined){throw"Aggregation level does not include dimension "+D;}return this._oAggregationLevel[D];},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames();}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name";}this._oMeasures[M]={value:true,text:false,unit:false};}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M);}return m;},includeDimensionKeyTextAttributes:function(D,I,b,a){this._oSelectedPropertyNames=null;var f=[];if(D){if(this._oAggregationLevel[D]==undefined){throw D+" is not included in the aggregation level";}f.push(D);}else{for(var n in this._oAggregationLevel){f.push(n);}a=null;}for(var i=-1,s;(s=f[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I;}if(b!=null){this._oAggregationLevel[s].text=b;}if(a!=null){this._oAggregationLevel[s].attributes=a;}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result";}M.push(m);}else{for(var n in this._oMeasures){M.push(n);}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I;}if(b!=null){this._oMeasures[s].text=b;}if(a!=null){this._oMeasures[s].unit=a;}}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i,I,r){if(i!=null){this._bIncludeEntityKey=i;}if(I!=null){this._bIncludeCount=I;}if(r!=null){this._bReturnNoEntities=r;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath;}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request";}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult();}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName();}return u;},getURIOrderByOptionValue:function(){var a,C,O=null,s=this._oSortExpression?this._oSortExpression._aSortCondition:[],i,n=s.length;if(n){a=this._oQueryResult.getAllMeasureNames();for(i=0;i<n;i+=1){C=s[i];if(!this._oSelectedPropertyNames[C.property.name]&&a.indexOf(C.property.name)<0){continue;}O=(O?O+",":"")+C.property.name+" "+C.order;}}return O;},getURIQueryOptionValue:function(q){var n,Q=null,s,t=this;function a(p){var P;if(!p){return;}P=typeof p==="string"?p:p.name;if(!t._oSelectedPropertyNames[P]){s+=(s==""?"":",")+P;t._oSelectedPropertyNames[P]=true;}}switch(q){case"$select":{s="";this._oSelectedPropertyNames={};for(n in this._oAggregationLevel){var D=this._oQueryResult.findDimensionByName(n);var b=this._oAggregationLevel[n];if(b.key==true){a(D.getKeyProperty());}if(b.text==true){a(D.getTextProperty());}if(b.attributes){for(var i=-1,f;(f=b.attributes[++i])!==undefined;){a(D.findAttributeByName(f).getName());}}}for(n in this._oMeasures){var m=this._oQueryResult.findMeasureByName(n);var M=this._oMeasures[n];if(M.value==true){a(m.getRawValueProperty());}if(M.text==true){a(m.getFormattedValueProperty());}if(M.unit==true){a(m.getUnitProperty());}}for(n in this._oDimensionHierarchies){var h=this._oQueryResult.findDimensionByName(n).getHierarchy();var H=this._oDimensionHierarchies[n];if(H.id){a(h.getNodeIDProperty());}if(H.externalKey){a(h.getNodeExternalKeyProperty());}if(H.text){a(this._oQueryResult.getEntityType().getTextPropertyOfProperty(h.getNodeIDProperty().name));}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){s+=(s==""?"":",")+K.name;}}Q=(s?s:null);break;}case"$filter":{var g=null;if(this._oFilterExpression){g=this._oFilterExpression.getURIFilterOptionValue();}Q=(g?g:null);break;}case"$orderby":{Q=this.getURIOrderByOptionValue();break;}case"$top":{Q=null;if(this._bReturnNoEntities){Q=0;}else if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=null;if(!this._bReturnNoEntities){Q=this._iSkipRequestOption;}break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s);}this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a!==null){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if((this._iTopRequestOption||this._bReturnNoEntities)&&t!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oDimensionHierarchies:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};
o.ParameterValueSetRequest=function(p){this._init(p);};
o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";s+=(s==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){s+=(s==""?"":",")+this._oParameter.getTextProperty().name;}Q=(s?s:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}Q=(f?f:null);break;}case"$orderby":{var a=null;if(this._oSortExpression){a=this._oSortExpression.getURIOrderByOptionValue();}Q=(a?a:null);break;}default:break;}return Q;},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}return u;},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};
o.DimensionMemberSetRequest=function(D,p,u){this._init(D,p,u);};
o.DimensionMemberSetRequest.prototype={_init:function(D,p,u){this._oDimension=D;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"Parameterized master data entity sets are not yet implemented";}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet();}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request";}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true;}if(I==true){this._oValueSetResult.attributes=true;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";var E=this._oEntitySet.getEntityType();var K=E.getKeyProperties();var a=[];if(this._bUseMasterData){for(var i=-1,b;(b=K[++i])!==undefined;){s+=(s==""?"":",")+b;var f=E.getTextPropertyOfProperty(b);if(f){if(this._oValueSetResult.text==true){s+=","+f.name;}a.push(f.name);}}}else{s+=(s==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){s+=(s==""?"":",")+this._oDimension.getTextProperty().name;}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var g=E.getProperties();for(var p in g){var I=false;for(var j=-1,h;(h=K[++j])!==undefined;){if(p==h){I=true;break;}}if(I){continue;}for(var k=-1,m;(m=a[++k])!==undefined;){if(p==m){I=true;break;}}if(!I){s+=","+p;}}}else{var n=this._oDimension.getAllAttributeNames();for(var l=-1,r;(r=n[++l])!==undefined;){s+=(s==""?"":",")+this._oDimension.findAttributeByName(r).getName();}}}Q=(s?s:null);break;}case"$filter":{var t=null;if(this._oFilterExpression){t=this._oFilterExpression.getURIFilterOptionValue();}Q=(t?t:null);break;}case"$orderby":{var u=null;if(this._oSortExpression){u=this._oSortExpression.getURIOrderByOptionValue();}Q=(u?u:null);break;}case"$top":{if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=this._iSkipRequestOption;break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult();}else{r=(s?s:"")+"/"+this._oEntitySet.getQName();}return r;},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if(this._iTopRequestOption&&t){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o;},true);
sap.ui.predefine('sap/ui/model/json/JSONListBinding',["sap/base/Log","sap/base/util/deepEqual","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding"],function(L,d,a,e,b,C,c){"use strict";
var J=c.extend("sap.ui.model.json.JSONListBinding");
J.prototype.getContexts=function(s,l){this.iLastStartIndex=s;this.iLastLength=l;if(!s){s=0;}if(!l){l=Math.min(this.iLength,this.oModel.iSizeLimit);}var f=this._getContexts(s,l),g=[];if(this.bUseExtendedChangeDetection){try{for(var i=0;i<f.length;i++){g.push(this.getContextData(f[i]));}if(this.aLastContextData&&s<this.iLastEndIndex){f.diff=this.diffData(this.aLastContextData,g);}this.iLastEndIndex=s+l;this.aLastContexts=f.slice(0);this.aLastContextData=g.slice(0);}catch(E){this.bUseExtendedChangeDetection=false;L.warning("JSONListBinding: Extended change detection has been disabled as JSON data could not be serialized.");}}return f;};
J.prototype.getCurrentContexts=function(){if(this.bUseExtendedChangeDetection){return this.aLastContexts||[];}else{return this.getContexts(this.iLastStartIndex,this.iLastLength);}};
J.prototype.updateIndices=function(){var i;this.aIndices=[];if(Array.isArray(this.oList)){for(i=0;i<this.oList.length;i++){this.aIndices.push(i);}}else{for(i in this.oList){this.aIndices.push(i);}}};
J.prototype.update=function(){var l=this.oModel._getObject(this.sPath,this.oContext);if(l){if(Array.isArray(l)){if(this.bUseExtendedChangeDetection){this.oList=a([],l);}else{this.oList=l.slice(0);}}else{this.oList=this.bUseExtendedChangeDetection?a({},l):b({},l);}this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();}else{this.oList=[];this.aIndices=[];this.iLength=0;}};
J.prototype.checkUpdate=function(f){var l;if(this.bSuspended&&!this.bIgnoreSuspend&&!f){return;}if(!this.bUseExtendedChangeDetection){l=this.oModel._getObject(this.sPath,this.oContext)||[];if(!d(this.oList,l)||f){this.update();this._fireChange({reason:C.Change});}}else{var g=false;var t=this;l=this.oModel._getObject(this.sPath,this.oContext)||[];if(this.oList.length!=l.length){g=true;}if(!d(this.oList,l)){this.update();}var h=this._getContexts(this.iLastStartIndex,this.iLastLength);if(this.aLastContexts){if(this.aLastContexts.length!=h.length){g=true;}else{e(this.aLastContextData,function(i,o){var j=t.getContextData(h[i]);if(j!==o){g=true;return false;}return true;});}}else{g=true;}if(g||f){this._fireChange({reason:C.Change});}}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONModel',["./JSONListBinding","./JSONPropertyBinding","./JSONTreeBinding","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isPlainObject","sap/ui/model/ClientModel","sap/ui/model/Context"],function(J,a,b,L,d,c,C,f){"use strict";
var g=C.extend("sap.ui.model.json.JSONModel",{
constructor:function(D,o){this.pSequentialImportCompleted=Promise.resolve();C.apply(this,arguments);this.bObserve=o;if(D&&typeof D=="object"){this.setData(D);}},
metadata:{publicMethods:["setJSON","getJSON"]}
});
g.prototype.setData=function(D,m){if(m){this.oData=d(Array.isArray(this.oData)?[]:{},this.oData,D);}else{this.oData=D;}if(this.bObserve){this.observeData();}this.checkUpdate();};
g.prototype.observeData=function(){var t=this;function e(v){return function(){return v;};}function h(O,n){return function(v){o(v,O,n);t.checkUpdate();};}function j(O,n,v){if(typeof v=="function"){O[n]=v;}else{Object.defineProperty(O,n,{get:e(v),set:h(O,n)});}}function o(O,p,n){var i;if(Array.isArray(O)){for(i=0;i<O.length;i++){o(O[i],O,i);}}else if(c(O)){for(i in O){o(O[i],O,i);}}if(p){j(p,n,O);}}o(this.oData);};
g.prototype.setJSON=function(j,m){var o;try{o=JSON.parse(j+"");this.setData(o,m);}catch(e){L.fatal("The following problem occurred: JSON parse Error: "+e);this.fireParseError({url:"",errorCode:-1,reason:"",srcText:e,line:-1,linepos:-1,filepos:-1});}};
g.prototype.getJSON=function(){return JSON.stringify(this.oData);};
g.prototype.loadData=function(u,p,A,t,m,e,h){var i;A=(A!==false);t=t||"GET";e=e===undefined?this.bCache:e;this.fireRequestSent({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m}});var s=function(D){if(!D){L.fatal("The following problem occurred: No data was retrieved by service: "+u);}this.setData(D,m);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:true});}.bind(this);var E=function(P,T){var M=T||P.textStatus;var p=A?P.request:P;var S=p.status;var k=p.statusText;var r=p.responseText;var o={message:M,statusCode:S,statusText:k,responseText:r};L.fatal("The following problem occurred: "+M,r+","+S+","+k);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:false,errorobject:o});this.fireRequestFailed(o);if(A){return Promise.reject(o);}return undefined;}.bind(this);var _=function(s,E){this._ajax({url:u,async:A,dataType:'json',cache:e,data:p,headers:h,type:t,success:s,error:E});}.bind(this);if(A){i=new Promise(function(r,k){var R=function(x,T,o){k({request:x,textStatus:T,error:o});};_(r,R);});var j=this.pSequentialImportCompleted.then(function(){return i.then(s,E);});this.pSequentialImportCompleted=j.catch(function(o){L.error("Loading of data failed: "+o.stack);});return j;}else{_(s,E);return undefined;}};
g.prototype.dataLoaded=function(){return this.pSequentialImportCompleted;};
g.prototype.bindProperty=function(p,o,P){var B=new a(this,p,o,P);return B;};
g.prototype.bindList=function(p,o,s,F,P){var B=new J(this,p,o,s,F,P);return B;};
g.prototype.bindTree=function(p,o,F,P,s){var B=new b(this,p,o,F,P,s);return B;};
g.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r=="/"){this.setData(v);return true;}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var e=this._getObject(O);if(e){e[P]=v;this.checkUpdate(false,A);return true;}return false;};
g.prototype.getProperty=function(p,o){return this._getObject(p,o);};
g.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null;if(o instanceof f){n=this._getObject(o.getPath());}else if(o!=null){n=o;}if(!p){return n;}var P=p.split("/"),i=0;if(!P[0]){n=this.oData;i++;}while(n&&P[i]){n=n[P[i]];i++;}return n;};
g.prototype.isList=function(p,o){var A=this.resolve(p,o);return Array.isArray(this._getObject(A));};
g.prototype._setMetaModel=function(m){this._oMetaModel=m;};
g.prototype.getMetaModel=function(){return this._oMetaModel;};
return g;});
sap.ui.predefine('sap/ui/model/json/JSONPropertyBinding',['sap/ui/model/ChangeReason','sap/ui/model/ClientPropertyBinding',"sap/base/util/deepEqual"],function(C,a,d){"use strict";
var J=a.extend("sap.ui.model.json.JSONPropertyBinding");
J.prototype.setValue=function(v){if(this.bSuspended){return;}if(!d(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this.sPath,context:this.oContext,value:v});}}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!d(v,this.oValue)||f){this.oValue=v;this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONTreeBinding',['sap/ui/model/ClientTreeBinding'],function(C){"use strict";
var J=C.extend("sap.ui.model.json.JSONTreeBinding");
J.prototype._saveSubContext=function(n,c,s,N){if(n&&typeof n=="object"){var o=this.oModel.getContext(s+N);if(this.oCombinedFilter&&!this.bIsFiltering){if(this.filterInfo.aFilteredContexts&&this.filterInfo.aFilteredContexts.indexOf(o)!=-1){c.push(o);}}else{c.push(o);}}};
return J;});
sap.ui.predefine('sap/ui/model/odata/AnnotationHelper',["./_AnnotationHelperBasics","./_AnnotationHelperExpression","sap/base/Log","sap/ui/base/BindingParser"],function(B,E,L,a){'use strict';
function c(f,b){return function(){return f.call(this,b.apply(this,arguments));};}
var A={createPropertySetting:function(p,r){var m=false,P;p=p.slice();p.forEach(function(v,i){switch(typeof v){case"boolean":case"number":case"undefined":m=true;break;case"string":P=a.complexParser(v,null,true,true);if(P!==undefined){if(P.functionsNotFound){throw new Error("Function name(s) "+P.functionsNotFound.join(", ")+" not found");}p[i]=v=P;}case"object":if(!v||typeof v!=="object"||!("path"in v)){m=true;}break;default:throw new Error("Unsupported part: "+v);}});P={formatter:r,parts:p};if(m){a.mergeParts(P);}r=P.formatter;if(P.parts.length===0){P=r&&r();if(typeof P==="string"){P=a.complexParser.escape(P);}}else if(P.parts.length===1){if(r&&!r.textFragments&&P.parts[0].formatter){P.formatter=c(r,P.parts[0].formatter);P.parts[0]=Object.assign({},P.parts[0]);delete P.parts[0].formatter;}}return P;},format:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,true);},getNavigationPath:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=B.followPath(i,r);return R?"{"+R.navigationProperties.join("/")+"}":"";},gotoEntitySet:function(C){var e,s,r=C.getObject(),R;if(typeof r==="string"){e=r;}else{R=B.followPath(C,r);e=R&&R.associationSetEnd&&R.associationSetEnd.entitySet;}if(e){s=C.getModel().getODataEntitySet(e,true);}if(!s){L.warning(C.getPath()+": found '"+e+"' which is not a name of an entity set",undefined,"sap.ui.model.odata.AnnotationHelper");}return s;},gotoEntityType:function(C){var e=C.getProperty(""),r=C.getModel().getODataEntityType(e,true);if(!r){L.warning(C.getPath()+": found '"+e+"' which is not a name of an entity type",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},gotoFunctionImport:function(C){var f=C.getProperty("String"),r=C.getModel().getODataFunctionImport(f,true);if(!r){L.warning(C.getPath()+": found '"+f+"' which is not a name of a function import",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},isMultiple:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=B.followPath(i,r);if(R){if(R.navigationAfterMultiple){throw new Error('Association end with multiplicity "*" is not the last one: '+r.AnnotationPath);}return String(R.isMultiple);}return"";},resolvePath:function(C){var r=B.followPath(C,C.getObject());if(!r){L.warning(C.getPath()+": Path could not be resolved ",undefined,"sap.ui.model.odata.AnnotationHelper");}return r?r.resolvedPath:undefined;},simplePath:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,false);}};A.format.requiresIContext=true;A.getNavigationPath.requiresIContext=true;A.isMultiple.requiresIContext=true;A.simplePath.requiresIContext=true;return A;},true);
sap.ui.predefine('sap/ui/model/odata/AnnotationParser',["sap/base/assert","sap/base/Log","sap/base/util/isEmptyObject"],function(a,L,b){"use strict";var A={EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var t={Binary:true,Bool:true,Date:true,DateTimeOffset:true,Decimal:true,Duration:true,Float:true,Guid:true,Int:true,String:true,TimeOfDay:true,LabelElementReference:true,EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var M={And:true,Or:true,Eq:true,Ne:true,Gt:true,Ge:true,Lt:true,Le:true,If:true,Collection:true};
function g(o){return o.getAttribute("Qualifier")||o.parentNode.nodeName==="Annotations"&&o.parentNode.getAttribute("Qualifier");}
var c={merge:function(T,s){var d,e;var S=["annotationsAtArrays","propertyAnnotations","EntityContainer","annotationReferences"];for(d in s){if(S.indexOf(d)!==-1){continue;}c._mergeAnnotation(d,s,T);}for(var i=1;i<S.length;++i){var f=S[i];T[f]=T[f]||{};for(d in s[f]){for(e in s[f][d]){T[f][d]=T[f][d]||{};c._mergeAnnotation(e,s[f][d],T[f][d]);}}}if(s.annotationsAtArrays){T.annotationsAtArrays=(T.annotationsAtArrays||[]).concat(s.annotationsAtArrays);}},_mergeAnnotation:function(n,m,T){if(Array.isArray(m[n])){T[n]=m[n].slice(0);}else{T[n]=T[n]||{};for(var k in m[n]){T[n][k]=m[n][k];}}},parse:function(m,x,s){try{c._parserData={};c._oXPath=c.getXPath();return c._parse(m,x,s);}finally{delete c._parserData;delete c._oXPath;}},_parse:function(m,x,s){var d={},e,f,h,T,l,n,p,q,r,u,v,w,y,z,B,C,D,E,F,G,H,i,I,J=[];c._parserData.metadataInstance=m;c._parserData.serviceMetadata=m.getServiceMetadata();c._parserData.xmlDocument=c._oXPath.setNameSpace(x);c._parserData.schema={};c._parserData.aliases={};c._parserData.url=s?s:"metadata document";c._parserData.annotationsAtArrays=J;e=c._oXPath.selectNodes("//d:Schema",c._parserData.xmlDocument);for(i=0;i<e.length;i+=1){f=c._oXPath.nextNode(e,i);c._parserData.schema.Alias=f.getAttribute("Alias");c._parserData.schema.Namespace=f.getAttribute("Namespace");}var K={};var N=c._parseReferences(K);if(N){d.annotationReferences=K;d.aliasDefinitions=c._parserData.aliases;}h=c._oXPath.selectNodes("//d:Term",c._parserData.xmlDocument);if(h.length>0){T={};for(I=0;I<h.length;I+=1){l=c._oXPath.nextNode(h,I);n=c.replaceWithAlias(l.getAttribute("Type"));T["@"+c._parserData.schema.Alias+"."+l.getAttribute("Name")]=n;}d.termDefinitions=T;}c._parserData.metadataProperties=c.getAllPropertiesMetadata(c._parserData.serviceMetadata);if(c._parserData.metadataProperties.extensions){d.propertyExtensions=c._parserData.metadataProperties.extensions;}p=c._oXPath.selectNodes("//d:Annotations ",c._parserData.xmlDocument);for(I=0;I<p.length;I+=1){q=c._oXPath.nextNode(p,I);if(q.hasChildNodes()===false){continue;}r=q.getAttribute("Target");u=r.split(".")[0];if(u&&c._parserData.aliases[u]){r=r.replace(new RegExp(u,""),c._parserData.aliases[u]);}v=r;w=null;var O=null;if(r.indexOf("/")>0){v=r.split("/")[0];var S=c._parserData.serviceMetadata.dataServices&&c._parserData.serviceMetadata.dataServices.schema&&c._parserData.serviceMetadata.dataServices.schema.length;if(S){for(var j=c._parserData.serviceMetadata.dataServices.schema.length-1;j>=0;j--){var P=c._parserData.serviceMetadata.dataServices.schema[j];if(P.entityContainer){var Q=v.split('.');for(var k=P.entityContainer.length-1;k>=0;k--){if(P.entityContainer[k].name===Q[Q.length-1]){O=r.replace(v+"/","");break;}}}}}if(!O){w=r.replace(v+"/","");}}if(w){if(!d.propertyAnnotations){d.propertyAnnotations={};}if(!d.propertyAnnotations[v]){d.propertyAnnotations[v]={};}if(!d.propertyAnnotations[v][w]){d.propertyAnnotations[v][w]={};}y=c._oXPath.selectNodes("./d:Annotation",q);for(var R=0;R<y.length;R+=1){z=c._oXPath.nextNode(y,R);B=c.replaceWithAlias(z.getAttribute("Term"));var U=g(z);if(U){B+="#"+U;}if(z.hasChildNodes()===false){var o={};c.enrichFromPropertyValueAttributes(o,z);if(b(o)){o.Bool="true";}d.propertyAnnotations[v][w][B]=o;}else{d.propertyAnnotations[v][w][B]=c.getPropertyValue(z);}}}else{var V;if(O){if(!d["EntityContainer"]){d["EntityContainer"]={};}if(!d["EntityContainer"][v]){d["EntityContainer"][v]={};}V=d["EntityContainer"][v];}else{if(!d[v]){d[v]={};}V=d[v];}C=v.replace(c._parserData.aliases[u],u);y=c._oXPath.selectNodes("./d:Annotation",q);for(var W=0;W<y.length;W+=1){z=c._oXPath.nextNode(y,W);var X=V;if(O){if(!V[O]){V[O]={};}X=V[O];}c._parseAnnotation(v,z,X);}D=c._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+C+"')]//d:PropertyValue[contains(@Path, '/')]//@Path",c._parserData.xmlDocument);for(i=0;i<D.length;i+=1){E=c._oXPath.nextNode(D,i);F=E.value;if(d.propertyAnnotations){if(d.propertyAnnotations[v]){if(d.propertyAnnotations[v][F]){continue;}}}G=F.split('/');if(c.findNavProperty(v,G[0])){if(!d.expand){d.expand={};}if(!d.expand[v]){d.expand[v]={};}d.expand[v][G[0]]=G[0];}}H=c._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+C+"')]//d:Path[contains(., '/')]",c._parserData.xmlDocument);for(i=0;i<H.length;i+=1){E=c._oXPath.nextNode(H,i);F=c._oXPath.getNodeText(E);if(d.propertyAnnotations&&d.propertyAnnotations[v]&&d.propertyAnnotations[v][F]){continue;}if(!d.expand){d.expand={};}if(!d.expand[v]){d.expand[v]={};}G=F.split('/');if(c.findNavProperty(v,G[0])){if(!d.expand){d.expand={};}if(!d.expand[v]){d.expand[v]={};}d.expand[v][G[0]]=G[0];}}}}if(J.length){d.annotationsAtArrays=J.map(function(Y){return c.backupAnnotationAtArray(Y,d);});}return d;},backupAnnotationAtArray:function(e,m){var q,s=[];function i(){return Array.prototype.filter.call(e.parentNode.childNodes,function(n){return n.nodeType===1;}).indexOf(e);}while(e.nodeName!=="Annotations"){switch(e.nodeName){case"Annotation":q=g(e);s.unshift(e.getAttribute("Term")+(q?"#"+q:""));break;case"Collection":break;case"PropertyValue":s.unshift(e.getAttribute("Property"));break;case"Record":if(e.parentNode.nodeName==="Collection"){s.unshift(i());}break;default:if(e.parentNode.nodeName==="Apply"){s.unshift("Value");s.unshift(i());s.unshift("Parameters");}else{s.unshift(e.nodeName);}break;}e=e.parentNode;}s.unshift(e.getAttribute("Target"));s=s.map(function(S){return typeof S==="string"?c.replaceWithAlias(S):S;});c.syncAnnotationsAtArrays(m,s,true);return s;},restoreAnnotationsAtArrays:function(m){if(m.annotationsAtArrays){m.annotationsAtArrays.forEach(function(s){c.syncAnnotationsAtArrays(m,s);});}},syncAnnotationsAtArrays:function(m,s,w){var i,n=s.length-2,d=s[n+1],p=m,P=s[n],S=P+"@"+d;for(i=0;i<n;i+=1){p=p&&p[s[i]];}if(p&&Array.isArray(p[P])){if(!(S in p)){p[S]=p[P][d];}if(!(d in p[P])){p[P][d]=p[S];}}else if(w){L.warning("Wrong path to annotation at array",s,"sap.ui.model.odata.AnnotationParser");}},_parseAnnotation:function(s,o,d){var q=g(o);var T=c.replaceWithAlias(o.getAttribute("Term"));if(q){T+="#"+q;}var v=c.getPropertyValue(o,s);v=c.setEdmTypes(v,c._parserData.metadataProperties.types,s,c._parserData.schema);d[T]=v;if(Array.isArray(d)){c._parserData.annotationsAtArrays.push(o);}},_parseReferences:function(m){var f=false;var n,i;var x=c._oXPath;var s="//edmx:Reference/edmx:Include[@Namespace and @Alias]";var o=x.selectNodes(s,c._parserData.xmlDocument);for(i=0;i<o.length;++i){f=true;n=x.nextNode(o,i);c._parserData.aliases[n.getAttribute("Alias")]=n.getAttribute("Namespace");}c._parserData.aliasesByLength=Object.keys(c._parserData.aliases).sort(function(h,j){return j.length-h.length;});var r="//edmx:Reference[@Uri]/edmx:IncludeAnnotations[@TermNamespace]";var R=x.selectNodes(r,c._parserData.xmlDocument);for(i=0;i<R.length;++i){f=true;n=x.nextNode(R,i);var T=n.getAttribute("TermNamespace");var d=n.getAttribute("TargetNamespace");var e=n.parentNode.getAttribute("Uri");if(d){if(!m[d]){m[d]={};}m[d][T]=e;}else{m[T]=e;}}return f;},getAllPropertiesMetadata:function(o){var d={},P={},e={},f=false,n,E,C,h={},q={},r={},s=false,u,v,w,T,x,R={types:P};if(!o.dataServices.schema){return R;}for(var i=o.dataServices.schema.length-1;i>=0;i-=1){d=o.dataServices.schema[i];if(d.entityType){n=d.namespace;E=d.entityType;C=d.complexType;for(var j=0;j<E.length;j+=1){h=E[j];r={};q={};if(h.property){for(var k=0;k<h.property.length;k+=1){u=h.property[k];if(u.type.substring(0,n.length)===n){if(C){for(var l=0;l<C.length;l+=1){if(C[l].name===u.type.substring(n.length+1)){if(C[l].property){for(var m=0;m<C[l].property.length;m+=1){v=C[l].property[m];q[C[l].name+"/"+v.name]=v.type;}}}}}}else{w=u.name;T=u.type;if(u.extensions){for(var p=0;p<u.extensions.length;p+=1){x=u.extensions[p];if((x.name==="display-format")&&(x.value==="Date")){T="Edm.Date";}else{s=true;if(!r[w]){r[w]={};}if(x.namespace&&!r[w][x.namespace]){r[w][x.namespace]={};}r[w][x.namespace][x.name]=x.value;}}}q[w]=T;}}}if(!P[n+"."+h.name]){P[n+"."+h.name]={};}P[n+"."+h.name]=q;if(s){if(!e[n+"."+h.name]){f=true;}e[n+"."+h.name]={};e[n+"."+h.name]=r;}}}}if(f){R={types:P,extensions:e};}return R;},setEdmTypes:function(p,P,T,s){function d(e){var o,E='';if(p[e]){o=p[e];if(o.Value&&o.Value.Path){E=c.getEdmType(o.Value.Path,P,T,s);if(E){p[e].EdmType=E;}}else if(o.Path){E=c.getEdmType(o.Path,P,T,s);if(E){p[e].EdmType=E;}}else if(o.Facets){p[e].Facets=c.setEdmTypes(o.Facets,P,T,s);}else if(o.Data){p[e].Data=c.setEdmTypes(o.Data,P,T,s);}else if(e==="Data"){p.Data=c.setEdmTypes(o,P,T,s);}else if(o.Value&&o.Value.Apply){p[e].Value.Apply.Parameters=c.setEdmTypes(o.Value.Apply.Parameters,P,T,s);}else if(o.Value&&o.Type&&(o.Type==="Path")){E=c.getEdmType(o.Value,P,T,s);if(E){p[e].EdmType=E;}}}}if(Array.isArray(p)){for(var v=0;v<p.length;v+=1){d(v);}}else{for(var V in p){d(V);}}return p;},getEdmType:function(p,P,T,s){var i=p.indexOf("/");if(i>-1){var d=p.substr(0,i);var n=c.findNavProperty(T,d);if(n){var m=c._parserData.metadataInstance._getEntityTypeByNavPropertyObject(n);if(m){T=m.entityType;p=p.substr(i+1);}}}if((p.charAt(0)==="@")&&(p.indexOf(s.Alias)===1)){p=p.slice(s.Alias.length+2);}if(p.indexOf("/")>=0){if(P[p.slice(0,p.indexOf("/"))]){T=p.slice(0,p.indexOf("/"));p=p.slice(p.indexOf("/")+1);}}return P[T]&&P[T][p];},enrichFromPropertyValueAttributes:function(m,n){var I={"Property":true,"Qualifier":true,"Term":true,"xmlns":true};for(var i=0;i<n.attributes.length;i+=1){var N=n.attributes[i].name;if(!I[N]&&(N.indexOf("xmlns:")!==0)){var v=n.attributes[i].value;if(N==="EnumMember"&&v.indexOf(" ")>-1){var V=v.split(" ");m[N]=V.map(c.replaceWithAlias).join(" ");}else{m[N]=c.replaceWithAlias(v);}}}return m;},_getRecordValues:function(n){var N=[];var x=c._oXPath;for(var i=0;i<n.length;++i){var o=x.nextNode(n,i);var v=c.getPropertyValues(o);var T=o.getAttribute("Type");if(T){v["RecordType"]=c.replaceWithAlias(T);}N.push(v);}return N;},_getTextValues:function(n){var N=[];var x=c._oXPath;for(var i=0;i<n.length;i+=1){var o=x.nextNode(n,i);var v={};var T=x.getNodeText(o);v[o.nodeName]=c._parserData.aliases?c.replaceWithAlias(T):T;N.push(v);}return N;},_getTextValue:function(n){var x=c._oXPath;var v="";if(n.nodeName in A){v=c.replaceWithAlias(x.getNodeText(n));}else{v=x.getNodeText(n);}if(n.nodeName!=="String"){v=v.trim();}return v;},getPropertyValue:function(d,s){var i;var x=c._oXPath;var p=d.nodeName==="Collection"?[]:{};if(d.hasChildNodes()){var r=x.selectNodes("./d:Record",d);var R=c._getRecordValues(r);var C=x.selectNodes("./d:Collection/d:Record | ./d:Collection/d:If/d:Record",d);var e=c._getRecordValues(C);var P=R.concat(e);if(P.length>0){if(C.length===0&&r.length>0){p=P[0];}else{p=P;}}else{var o=x.selectNodes("./d:Collection/d:AnnotationPath | ./d:Collection/d:NavigationPropertyPath | ./d:Collection/d:PropertyPath",d);if(o.length>0){p=c._getTextValues(o);}else{var f=x.selectNodes("./d:*[not(local-name() = \"Annotation\")]",d);if(f.length>0){for(i=0;i<f.length;i++){var h=x.nextNode(f,i);var v;var n=h.nodeName;var j=h.parentNode.nodeName;if(n==="Apply"){v=c.getApplyFunctions(h);}else{v=c.getPropertyValue(h);}if(M[j]){if(!Array.isArray(p)){p=[];}var V={};V[n]=v;p.push(V);}else if(n==="Collection"){p=v;}else{if(p[n]){L.warning("Annotation contained multiple "+n+" values. Only the last "+"one will be stored: "+x.getPath(h));}p[n]=v;}}c.enrichFromPropertyValueAttributes(p,d);}else if(d.nodeName in t){p=c._getTextValue(d);}else{c.enrichFromPropertyValueAttributes(p,d);}}}var N=x.selectNodes("./d:Annotation",d);if(N.length>0){for(i=0;i<N.length;i++){var k=x.nextNode(N,i);c._parseAnnotation(s,k,p);}}}else if(d.nodeName in t){p=c._getTextValue(d);}else if(d.nodeName.toLowerCase()==="null"){p=null;}else{c.enrichFromPropertyValueAttributes(p,d);}return p;},getPropertyValues:function(p){var P={},i;var x=c._oXPath;var o=x.selectNodes("./d:Annotation",p);var d=x.selectNodes("./d:PropertyValue",p);function e(p,w,N){var l,m=p;while(m.nodeName!=="Annotation"){m=m.parentNode;}l=m.parentNode;return(w+" '"+N+"' is defined twice; "+"Source = "+c._parserData.url+", Annotation Target = "+l.getAttribute("Target")+", Term = "+m.getAttribute("Term"));}if(o.length===0&&d.length===0){P=c.getPropertyValue(p);}else{for(i=0;i<o.length;i++){var f=x.nextNode(o,i);var T=c.replaceWithAlias(f.getAttribute("Term"));a(!P[T],function(){return e(p,"Annotation",T);});P[T]=c.getPropertyValue(f);}for(i=0;i<d.length;i++){var h=x.nextNode(d,i);var s=h.getAttribute("Property");a(!P[s],function(){return e(p,"Property",s);});P[s]=c.getPropertyValue(h);var j=x.selectNodes("./d:Apply",h);for(var n=0;n<j.length;n+=1){var k=x.nextNode(j,n);P[s]={};P[s]['Apply']=c.getApplyFunctions(k);}}}return P;},getApplyFunctions:function(d){var x=c._oXPath;var m={Name:d.getAttribute('Function'),Parameters:[]};var p=x.selectNodes("./d:*",d);for(var i=0;i<p.length;i+=1){var P=x.nextNode(p,i);var e={Type:P.nodeName};if(P.nodeName==="Apply"){e.Value=c.getApplyFunctions(P);}else if(P.nodeName==="LabeledElement"){e.Value=c.getPropertyValue(P);e.Name=e.Value.Name;delete e.Value.Name;}else if(M[P.nodeName]){e.Value=c.getPropertyValue(P);}else{e.Value=x.getNodeText(P);}m.Parameters.push(e);}return m;},findNavProperty:function(e,p){var m=c._parserData.serviceMetadata;for(var i=m.dataServices.schema.length-1;i>=0;i-=1){var o=m.dataServices.schema[i];if(o.entityType){var n=o.namespace+".";var E=o.entityType;for(var k=E.length-1;k>=0;k-=1){if(n+E[k].name===e&&E[k].navigationProperty){for(var j=0;j<E[k].navigationProperty.length;j+=1){if(E[k].navigationProperty[j].name===p){return E[k].navigationProperty[j];}}}}}}return null;},replaceWithAlias:function(v){c._parserData.aliasesByLength.some(function(s){if(v.includes(s+".")&&!v.includes("."+s+".")){v=v.replace(s+".",c._parserData.aliases[s]+".");return true;}return false;});return v;},getXPath:function(){var x={};var p=c._parserData;x={setNameSpace:function(o){return o;},nsResolver:function(d){var n={"edmx":"http://docs.oasis-open.org/odata/ns/edmx","d":"http://docs.oasis-open.org/odata/ns/edm"};return n[d]||null;},selectNodes:function(P,i){var d=p.xmlDocument.evaluate(P,i,this.nsResolver,7,null);d.length=d.snapshotLength;return d;},nextNode:function(n,i){return n.snapshotItem(i);},getNodeText:function(n){return n.textContent;}};x.getPath=function(n){var P="";var I="getAttribute"in n?n.getAttribute("id"):"";var T=n.tagName?n.tagName:"";if(I){P='id("'+I+'")';}else if(n instanceof Document){P="/";}else if(T.toLowerCase()==="body"){P=T;}else if(n.parentNode){var d=1;for(var i=0;i<n.parentNode.childNodes.length;++i){if(n.parentNode.childNodes[i]===n){P=x.getPath(n.parentNode)+"/"+T+"["+d+"]";break;}else if(n.parentNode.childNodes[i].nodeType===1&&n.parentNode.childNodes[i].tagName===T){++d;}}}else{L.error("Wrong Input node - cannot find XPath to it: "+T);}return P;};return x;}};return c;});
sap.ui.predefine('sap/ui/model/odata/CountMode',function(){"use strict";var C={Request:"Request",Inline:"Inline",InlineRepeat:"InlineRepeat",Both:"Both",None:"None"};return C;},true);
sap.ui.predefine('sap/ui/model/odata/Filter',['sap/ui/base/Object','sap/ui/model/Filter'],function(B,F){"use strict";
var O=B.extend("sap.ui.model.odata.Filter",{
constructor:function(p,v,a){if(typeof p==="object"){var f=p;p=f.path;v=f.values;a=f.and;}this.sPath=p;this.aValues=v;this.bAND=a==undefined?true:a;},
convert:function(){var f=[];for(var i=0,l=this.aValues&&this.aValues.length||0;i<l;i++){f.push(new F({path:this.sPath,operator:this.aValues[i].operator,value1:this.aValues[i].value1,value2:this.aValues[i].value2}));}if(f.length>1){var o=new F({filters:f,and:this.bAND});return o;}else{return f[0];}}
});
return O;});
sap.ui.predefine('sap/ui/model/odata/MessageScope',function(){"use strict";var M={RequestedObjects:"RequestedObjects",BusinessObject:"BusinessObject"};return M;},true);
sap.ui.predefine('sap/ui/model/odata/ODataAnnotations',["./AnnotationParser","sap/base/assert","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/base/EventProvider","sap/ui/thirdparty/jquery"],function(A,a,L,e,b,E,q){"use strict";
var O=E.extend("sap.ui.model.odata.ODataAnnotations",{
constructor:function(o){E.apply(this,arguments);if(arguments.length!==1){if(typeof arguments[2]==="object"){o=arguments[2];}o.urls=arguments[0];o.metadata=arguments[1];}this.oMetadata=o.metadata;this.oAnnotations=o.annotationData?o.annotationData:{};this.bLoaded=false;this.bAsync=o&&o.async;this.xPath=null;this.oError=null;this.bValidXML=true;this.oRequestHandles=[];this.oLoadEvent=null;this.oFailedEvent=null;this.mCustomHeaders=o.headers?e({},o.headers):{};if(o.urls){this.addUrl(o.urls);if(!this.bAsync){a(!b(this.oMetadata),"Metadata must be available for synchronous annotation loading");if(this.oError){L.error("OData annotations could not be loaded: "+this.oError.message);}}}},
metadata:{publicMethods:["parse","getAnnotationsData","attachFailed","detachFailed","attachLoaded","detachLoaded"]}
});
O.prototype.getAnnotationsData=function(){return this.oAnnotations;};
O.prototype.isLoaded=function(){return this.bLoaded;};
O.prototype.isFailed=function(){return this.oError!==null;};
O.prototype.fireLoaded=function(p){this.fireEvent("loaded",p);return this;};
O.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
O.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
O.prototype.fireFailed=function(p){this.fireEvent("failed",p);return this;};
O.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
O.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
O.prototype.setHeaders=function(h){this.mCustomHeaders=e({},h);};
O.prototype._createXMLDocument=function(x,X){var o=null;if(typeof x==="string"){X=x;x=null;}if(x){o=x;}else{o=new DOMParser().parseFromString(X,'application/xml');}return o;};
O.prototype._documentHasErrors=function(x){return x.getElementsByTagName("parsererror").length>0;};
O.prototype._mergeAnnotationData=function(m,s){if(!this.oAnnotations){this.oAnnotations={};}A.merge(this.oAnnotations,m);this.bLoaded=true;if(!s){this.fireLoaded({annotations:m});}};
O.prototype.setXML=function(x,X,o){var d={success:function(){},error:function(){},fireEvents:false};o=e({},d,o);var c=this._createXMLDocument(x,X);var p=function(c){var r={xmlDoc:c};var f=A.parse(this.oMetadata,c);if(f){r.annotations=f;o.success(r);this._mergeAnnotationData(f,!o.fireEvents);}else{o.error(r);if(o.fireEvents){this.fireFailed(r);}}}.bind(this,c);if(this._documentHasErrors(c)){o.error({xmlDoc:c});return false;}else{var m=this.oMetadata.getServiceMetadata();if(!m||b(m)){this.oMetadata.attachLoaded(p);}else{p();}return true;}};
O.prototype.addUrl=function(u){var t=this;var U=