/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./View","./XMLViewRenderer","./ViewType","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/XMLTemplateProcessor","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/cache/CacheManager","sap/ui/model/resource/ResourceModel","sap/ui/util/XMLHelper","sap/base/strings/hash","sap/base/Log","sap/base/util/LoaderExtensions","sap/ui/performance/trace/Interaction","sap/ui/core/Core"],function(q,V,X,a,m,M,b,C,R,c,d,f,h,L,g,I){"use strict";var j=R.RenderPrefixes,x="XMLViewCacheError",n={};var k=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:{apiVersion:2,render:function(o,e){o.text("");}}});var l=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"},renderer:X});sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,a.XML);};l.create=function(o){var P=m({},o);P.viewContent=P.definition;P.async=true;P.type=a.XML;return V.create(P);};l._sType=a.XML;l.asyncSupport=true;l._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&c._isSupportedEnvironment();function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}function p(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}function r(o,S){o.mProperties["viewContent"]=S.viewContent;var e=f.parse(S.viewContent);v(e);return e.documentElement;}function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new d({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale,async:S.async});var i=e.getResourceBundle();if(i instanceof Promise){return i.then(function(){o.setModel(e,o._resourceBundleAlias);});}o.setModel(e,o._resourceBundleAlias);}}function t(o){o.oAfterRenderingNotifier=new k();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}function u(S){var e=sap.ui.require("sap/ui/core/Component"),o;if(e){while(S){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}}return o;}function w(o,e){var i=u(o),G=i?JSON.stringify(i.getManifest()):null,H=[];H=H.concat(A(o,i),D(),B(o),e.keys);return z(o,H).then(function(K){return{key:K+"("+h(G||"")+")",componentManifest:G,additionalData:e.additionalData};});}function y(K){return K;}function z(o,i){return Promise.all(i).then(function(K){K=K.filter(function(G){return G!==n;});if(K.every(y)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}function A(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()].concat(e&&e.getActiveTerminologies()||[]);}function B(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),G=[];function H(o){G.push(o.preprocessor.then(function(J){if(J.getCacheKey){return J.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(H);}return G;}function D(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(o){T+=o.buildTimestamp;});}return T;}).catch(function(e){L.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");L.debug(e);return"";});}function E(e,i){var K=e.key;delete e.key;e.xml=f.serialize(i);return c.set(K,e);}function F(e){return c.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=f.parse(i.xml,"application/xml").documentElement;if(i.additionalData){m(e.additionalData,i.additionalData);}return i;}});}l.prototype.initViewSettings=function(S){var e=this,_;function i(O){e._xContent=O;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:m({},e),settings:m({},S||{}),type:"xmlview"}});}if(!e.isSubView()){var P={};b.parseViewAttributes(O,e,P);if(!S.async){Object.assign(S,P);}else{e.applySettings(P);}}else{delete S.controller;}var Q=s(e,S);if(Q instanceof Promise){return Q.then(function(){t(e);});}t(e);}function o(O,P){if(e.hasPreprocessor("viewxml")){return b.enrichTemplateIdsPromise(O,e,P).then(function(){return e.runPreprocessor("viewxml",O,!P);});}return O;}function G(O){var P=I.notifyAsyncStep("VIEW PREPROCESSING");return e.runPreprocessor("xml",O).then(function(O){return o(O,true);}).finally(P);}function H(N){return g.loadResource(N,{async:true}).then(function(O){return O.documentElement;});}function J(N,O){return H(N).then(G).then(function(P){if(O){E(O,P);}return P;});}function K(N,O){return w(e,O).then(function(P){return F(P).then(function(Q){if(!Q){return J(N,P);}else{return Q.xml;}});}).catch(function(P){if(P.name===x){L.error(P.message,P.name,"sap.ui.core.mvc.XMLView");L.error("Processing the View without caching.","sap.ui.core.mvc.XMLView");return J(N);}else{return Promise.reject(P);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}p(this,S);if(S.viewName){var N=S.viewName.replace(/\./g,"/")+".view.xml";if(S.async){if(S.cache&&l._bUseCache){return K(N,S.cache).then(i);}else{return H(N).then(G).then(i);}}else{_=g.loadResource(N).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=r(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return G(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.getResult==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};l.prototype.onBeforeRendering=function(){var o=this.getDomRef();if(o&&!R.isPreservedContent(o)){R.preserveContent(o,true);}V.prototype.onBeforeRendering.apply(this,arguments);};l.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};l.prototype.onControllerConnected=function(o){var e=this;function i(H){return M.runWithPreprocessors(H,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(b.parseTemplate.bind(null,this._xContent,this));}else{var G=I.notifyAsyncStep("VIEW PROCESSING");return b.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;}).finally(G);}};l.prototype.getControllerName=function(){return this._controllerName;};l.prototype.isSubView=function(){return this._oContainingView!=this;};l.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var N=document.getElementById(j.Temporary+e[i].getId())||e[i].getDomRef()||document.getElementById(j.Invisible+e[i].getId());if(N){q(document.getElementById(j.Dummy+e[i].getId())).replaceWith(N);}}}q(document.getElementById(j.Temporary+this.getId())).replaceWith(this._$oldContent);}this._$oldContent=undefined;};l.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+j.Dummy+o.getId()+'" class="sapUiHidden"></div>');return true;};l.registerPreprocessor=function(T,P,e,S,o,i){var O=this.getMetadata().getClass()._sType;if(typeof e==="string"){if(e!==O){throw new TypeError("View types other than "+O+" are not supported by XMLView.registerPreprocessor,"+" check View.registerPreprocessor instead");}}else{i=o;o=S;S=e;}T=T.toUpperCase();if(l.PreprocessorType[T]){V.registerPreprocessor(l.PreprocessorType[T],P,O,S,o,i);}else{L.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};l.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};l.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return l;});
