/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads',"sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/Log","sap/ui/thirdparty/jquery","./RouterHashChanger","sap/ui/core/Component"],function(l,E,H,R,V,T,a,c,U,d,b,L,q,e,C){"use strict";var r={};var f=E.extend("sap.ui.core.routing.Router",{constructor:function(o,i,O,t,j){E.apply(this);this._oConfig=i||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function k(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=k();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);this._oTargets._setRouter(this);this._oTargets.attachDisplay(function(s){var I=s.getParameter("routeRelevant");if(this.isInitialized()&&!this._bMatchingProcessStarted){var u=this.getHashChanger();if(u instanceof e&&!I){u.resetHash(this);}}},this);}var m=this,n;if(!o){o={};}if(Array.isArray(o)){n=o;o={};n.forEach(function(s){o[s.name]=s;});}q.each(o,function(s,u){if(u.name===undefined){u.name=s;}m.addRoute(u);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));if(!j){j=H.getInstance().createRouterHashChanger();}this.setHashChanger(j);var p=this._getParentRouter();if(p){this.attachTitleChanged(function(s){if(this._oOwner&&!this._oOwner._bRoutingPropagateTitle){return;}var P=s.getParameters(),N,F;if(p._fnTitleChangedFiredOnChild){p._fnTitleChangedFiredOnChild(P);}else{N=P.nestedHistory.slice();N.unshift({ownerComponentId:p._oOwner.getId(),history:p.getTitleHistory()});F={propagated:true,title:P.title,history:P.history,nestedHistory:N};p.fireTitleChanged(F);}});}},addRoute:function(o,p){if(!o.name){L.error("A name has to be specified for every route",this);}if(this._oRoutes[o.name]){L.error("Route with name "+o.name+" already exists",this);}this._oRoutes[o.name]=this._createRoute(this,o,p);},parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{L.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},initialize:function(i){var t=this,s;if(this._bIsInitialized){L.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(k){t.parse(k.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!this.oHashChanger){L.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return this;}if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(this._forwardTitleChanged,this);this._aHistory=[];var j=o&&h(this._oOwner,o);if(j){this._aHistory.push(j);}}if(this.oHashChanger instanceof e){this.oHashChanger._setActiveRouter(this);}this.oHashChanger.init();s=this.oHashChanger.getHash();this.oHashChanger.attachEvent("hashChanged",this.fnHashChanged);if(i){if(this._oMatchedRoute){this._oMatchedRoute._resume();}}else if(s!==e.InvalidHash){this.parse(s);}return this;},_forwardTitleChanged:function(o){var p=o.getParameters();var i={title:p.title};var j=this._oRoutes[this._oConfig.homeRoute];if(j&&g(p.name,j._oConfig.name)){i.isHome=true;}this.fireTitleChanged(i);},stop:function(){if(!this._bIsInitialized){L.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}if(this._oTargets){this._oTargets.detachTitleChanged(this._forwardTitleChanged,this);this._oTargets._oLastTitleTarget={};}if(this._oMatchedRoute){this._oMatchedRoute._routeSwitched();}this._bIsInitialized=false;delete this._oPreviousTitleChangedRoute;return this;},isStopped:function(){return this._bIsInitialized===false;},isInitialized:function(){return this._bIsInitialized===true;},getHashChanger:function(){return this.oHashChanger;},setHashChanger:function(o){if(this.oHashChanger){L.warning("The Router already has a HashChanger set and this call is ignored");}else{this.oHashChanger=o;}return this;},destroy:function(){if(this.bIsDestroyed){return this;}E.prototype.destroy.apply(this);if(this._oViews){this._oViews.destroy();this._oViews=null;}if(!this._bIsInitialized){L.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}delete this._bIsInitialized;this.bIsDestroyed=true;return this;},getURL:function(n,p){var o=this.getRoute(n);if(o){return o.getURL(p);}else{L.warning("Route with name "+n+" does not exist",this);}},match:function(s){return Object.keys(this._oRoutes).some(function(i){return this._oRoutes[i].match(s);}.bind(this));},getRouteByHash:function(s){for(var i in this._oRoutes){if(this._oRoutes.hasOwnProperty(i)){var o=this.getRoute(i);if(o.match(s)){return o;}}}},getRouteInfoByHash:function(s){var o=this.getRouteByHash(s);if(!o){return undefined;}return{name:o._oConfig.name,arguments:o.getPatternArguments(s)};},getRoute:function(n){return this._oRoutes[n];},getViews:function(){return this._oViews;},_createTargets:function(o,t){return new T({views:this._oViews,config:o,targets:t});},_createRoute:function(o,i,p){return new R(o,i,p);},getView:function(v,s,i){L.warning("Deprecated API Router#getView called - use Router#getViews instead.",this);var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:i},true);this.fireViewCreated({view:o,viewName:v,type:s});return o;},setView:function(v,o){this._oViews.setView(v,o);return this;},_getParentRouter:function(){var p=this._oOwner&&C.getOwnerComponentFor(this._oOwner);return p&&p.getRouter();},navTo:function(n,p,o,i){var t=this,j=this._getLastMatchedRouteName()!==n,k=this.getRoute(n),m,s;if(this.isStopped()){L.info("The router instance "+this._sId+" is stopped. No navigation can be performed.");return this;}if(!k){L.warning("Route with name "+n+" does not exist",this);return this;}if(typeof o==="boolean"){i=o;}if(p===undefined){p={};}if(o&&!b(o)){if(!this._oConfig._async){L.error("navTo with component target info is only supported with async router",this);return this;}m=k._changeHashWithComponentTargets(o,j);}s=k.getURL(p);if(i){t._bLastHashReplaced=true;t.oHashChanger.replaceHash(s,m,!j);}else{t.oHashChanger.setHash(s,m,!j);}return this;},_getLastMatchedRouteName:function(){return this._oMatchedRoute&&this._oMatchedRoute._oConfig.name;},getTargets:function(){return this._oTargets;},getTarget:function(n){return this._oTargets.getTarget(n);},attachRouteMatched:function(D,F,o){this.attachEvent("routeMatched",D,F,o);return this;},detachRouteMatched:function(F,o){this.detachEvent("routeMatched",F,o);return this;},fireRouteMatched:function(p){this.fireEvent("routeMatched",p);if(f._interceptRouteMatched){f._interceptRouteMatched(this._oConfig.controlId,this);}return this;},attachBeforeRouteMatched:function(D,F,o){this.attachEvent("beforeRouteMatched",D,F,o);return this;},detachBeforeRouteMatched:function(F,o){this.detachEvent("beforeRouteMatched",F,o);return this;},fireBeforeRouteMatched:function(p){this.fireEvent("beforeRouteMatched",p);return this;},attachViewCreated:function(D,F,o){this.attachEvent("viewCreated",D,F,o);return this;},detachViewCreated:function(F,o){this.detachEvent("viewCreated",F,o);return this;},fireViewCreated:function(p){this.fireEvent("viewCreated",p);return this;},attachRoutePatternMatched:function(D,F,o){this.attachEvent("routePatternMatched",D,F,o);return this;},detachRoutePatternMatched:function(F,o){this.detachEvent("routePatternMatched",F,o);return this;},fireRoutePatternMatched:function(p){this.fireEvent("routePatternMatched",p);return this;},attachBypassed:function(D,F,o){return this.attachEvent(f.M_EVENTS.BYPASSED,D,F,o);},detachBypassed:function(F,o){return this.detachEvent(f.M_EVENTS.BYPASSED,F,o);},fireBypassed:function(p){return this.fireEvent(f.M_EVENTS.BYPASSED,p);},attachTitleChanged:function(D,F,o){this.attachEvent(f.M_EVENTS.TITLE_CHANGED,D,F,o);return this;},detachTitleChanged:function(F,o){return this.detachEvent(f.M_EVENTS.TITLE_CHANGED,F,o);},fireTitleChanged:function(p){if(this.isStopped()){return this;}var I=!this._pWaitForTitleChangedOnChild;if(!p.propagated){p.propagated=false;var D=a.getInstance().getDirection(),s=this.getHashChanger().getHash(),j=l.routing.HistoryDirection,o=this._aHistory[this._aHistory.length-1],n;if(D===j.Backwards&&o&&!o.isHome){if(o&&o.title!==p.title){this._aHistory.pop();}}else if(o&&o.hash==s){o.title=p.title;this._aHistory.some(function(k,i,m){if(i<m.length-1&&d(k,o)){return m.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:s,title:p.title};this._aHistory.some(function(k,i,m){if(d(k,n)){return m.splice(i,1);}});this._aHistory.push(n);}p.history=this._aHistory.slice(0,-1);p.nestedHistory=[{history:this.getTitleHistory(),ownerComponentId:this._oOwner&&this._oOwner.getId()}];this._bLastHashReplaced=false;this._oPreviousTitleChangedRoute=this._oMatchedRoute;this._bFireTitleChanged=false;if(this._pWaitForTitleChangedOnChild){this._pWaitForTitleChangedOnChild.then(function(i){p.title=i.title;p.propagated=true;Array.prototype.push.apply(p.nestedHistory,i.nestedHistory);this._stopWaitingTitleChangedFromChild();this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}.bind(this));}}if(I){if(this._bMatchingProcessStarted&&this._isAsync()){this.attachEventOnce("routeMatched",function(){this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);},this);}else{this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}}return this;},getTitleHistory:function(){return this._aHistory||[];},_waitForTitleChangedOn:function(n){if(this._bFireTitleChanged){this._pWaitForTitleChangedOnChild=new Promise(function(i){this._fnTitleChangedFiredOnChild=i;}.bind(this));}},_stopWaitingTitleChangedFromChild:function(){delete this._pWaitForTitleChangedOnChild;delete this._fnTitleChangedFiredOnChild;},register:function(n){r[n]=this;return this;},_onBypassed:function(s){var F=function(){this.fireBypassed({hash:s});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:s});if(o instanceof Promise){o.then(F);return;}}F();},_isAsync:function(){return this._oConfig._async;},metadata:{publicMethods:["initialize","getURL","register","getRoute"]}});function g(s,i){return i&&i.indexOf(s)>-1;}function h(o,i){var s=i.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{L.error("Routes with dynamic parts cannot be resolved as home route.");}}f.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};f._interceptRouteMatched=undefined;f.getRouter=function(n){return r[n];};return f;});
