/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/events/jquery/EventExtension'],function(D){"use strict";var k={plus:"+",space:" "};var E={OS:"Meta"};var d={"ctrl+l":"jump to address bar","ctrl+n":"new window, cannot be registered in Chrome","ctrl+shift+n":"new incognito window, cannot be registered in Chrome","ctrl+alt+shift+p":"UI5 Technical Info","ctrl+q":"quit Chrome in Mac","ctrl+alt+shift+s":"UI5 Support Popup","ctrl+t":"new tab, cannot be registered in Chrome","ctrl+shift+t":"reopen last tab, cannot be registered in Chrome","ctrl+w":"close tab, cannot be registered in Chrome","ctrl+shift+w":"close window, cannot be registered in Chrome","ctrl+0":"reset zoom","ctrl+-":"zoom out","ctrl++":"zoom in","ctrl+shift+=":"cannot be handled","tab":"TAB-based keyboard navigation","shift+tab":"TAB-based keyboard navigation","ctrl+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+shift+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+alt+delete":"nice try","ctrl+pageup":"cycling through tabs, cannot be registered in Chrome","ctrl+pagedown":"cycling through tabs, cannot be registered in Chrome","f6":"F6-based group navigation","f11":"fullscreen, cannot be registered in Chrome","f12":"browser dev tools"};var l=false;document.addEventListener('keydown',function(e){try{if(e.keyCode===18){l=(typeof e.location!=="number"||e.location===1);return;}}catch(a){}});var s={findShortcut:function(S,n){var r=S.data("sap.ui.core.Shortcut");if(!r){return;}var m=r.filter(function(o){var M=o.shortcutSpec.key===n.key&&o.shortcutSpec.ctrlKey===n.ctrlKey&&o.shortcutSpec.altKey===n.altKey&&o.shortcutSpec.shiftKey===n.shiftKey&&o.shortcutSpec.metaKey===n.metaKey;return M;});return m[0];},getNormalizedShortcutSpec:function(S){var n;if(typeof S==="string"){n=s.parseShortcut(S);}else{var a=S.key;var v=/^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.test(a);if(!v){throw new Error("Shortcut key '"+a+"' is not a valid shortcut key. It must match /^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i");}n={key:s.translateRegisteredKeyToStandard(a).toLowerCase(),ctrlKey:D.os.macintosh?false:!!S.ctrl,ctrlRequested:S.ctrl,altKey:!!S.alt,shiftKey:!!S.shift,metaKey:D.os.macintosh?!!S.ctrl:false};}return n;},parseShortcut:function(S){this.validateShortcutString(S);var p=S.toLowerCase().split("+");return{key:s.translateRegisteredKeyToStandard(p.pop()),ctrlKey:D.os.macintosh?false:p.indexOf("ctrl")>-1,ctrlRequested:p.indexOf("ctrl")>-1,altKey:p.indexOf("alt")>-1,shiftKey:p.indexOf("shift")>-1,metaKey:D.os.macintosh?p.indexOf("ctrl")>-1:false};},translateRegisteredKeyToStandard:function(K){return k.hasOwnProperty(K)?k[K]:K;},validateShortcutString:function(S){var v=/^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|Escape|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|F[1-9]|F1[0-2])$/i.test(S);if(!v){throw new Error("Shortcut '"+S+"' is not a valid shortcut string. It must be a '+'-separated list of modifier keys and the actual key, like 'Ctrl+Alt+S'. Or more generally, it must match the expression /^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.");}},validateKeyCombination:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;if(d[N]){throw new Error("Registering the shortcut '"+N+"' is not allowed ("+d[N]+").");}if([".",",","-","+","=","*","/"].indexOf(n.key)>-1&&N.indexOf("shift")>-1){throw new Error("Registering the shortcut '"+N+"' is not allowed because the 'Shift' modifier changes the meaning of the "+n.key+" key on many keyboards.");}},getNormalizedShortcutString:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;return N;},shortcutMayBeUsedHere:function(S,o){var t=o.tagName.toLowerCase();if((t==="input"||t==="textarea")&&S.key.includes("arrow")){return false;}return true;},handleKeydown:function(S,o,c,e){if(e.key==="Control"||e.key==="Shift"||e.key==="Alt"||e.key==="AltGraph"||e.key==="Meta"){return;}if(e.isMarked()){return;}if(e.altKey&&!l){return;}var a=E.hasOwnProperty(e.key)?E[e.key]:e.key;a=a.toLowerCase();if(a!==S.key||e.ctrlKey!==S.ctrlKey||e.altKey!==S.altKey||e.shiftKey!==S.shiftKey||e.metaKey!==S.metaKey){return;}if(!s.shortcutMayBeUsedHere(S,e.target||e.srcElement)){return;}e.preventDefault();e.setMarked();e.stopPropagation();var b={registeredShortcut:o,originalBrowserEvent:e.originalEvent||e};c(b);}};return s;});
