/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/m/Image","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute","sap/m/ObjectStatus","sap/m/Popover","sap/m/library","sap/ui/core/library","sap/m/CustomListItem","sap/m/List"],function(q,B,J,C,T,A,f,I,L,a,b,H,O,c,P,l,d,e,g){"use strict";var F=l.FlexWrap;var h=d.ValueState;return B.extend("sap.ui.documentation.sdk.controller.SubApiDetail",{NOT_AVAILABLE:'N/A',PUBLIC_GITHUB_FRAMEWORK_DOMAIN:'https://github.com/SAP/openui5/blob/master/src/',SECTION_MAP:{"properties":"controlProperties","fields":"properties","special settings":"specialsettings"},formatter:f,onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");if(!window.hljs){q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"});}},initiate:function(r){var i,j,k,o=function(p){return!p.borrowedFrom;};this._sTopicId=r.sTopicId;this._oModel=r.oModel;this._oControlData=this._oModel.getData();this._aApiIndex=r.aApiIndex;this._aAllowedMembers=r.aAllowedMembers;this._sEntityType=r.sEntityType;this._sEntityId=r.sEntityId!=="undefined"?r.sEntityId:undefined;this._oEntityData=r.oEntityData;this._oContainerController=r.oContainerController;this._oContainerView=r.oContainerView;this._oToggleFullScreenBtn=this.byId("toggleFullScreenBtn");this.getOwnerComponent=function(){return r.oOwnerComponent;};this._oRouter=this.getRouter();this._allProperties=this._oModel.getProperty("/ui5-metadata/properties");this._allAggregations=this._oModel.getProperty("/ui5-metadata/aggregations");this._allAssociations=this._oModel.getProperty("/ui5-metadata/associations");if(this._allProperties){this._selfProperties=this._allProperties.filter(o);i=this._selfProperties.length>0;this._oModel.setProperty("/bShowBorrowedProps",!i);this._oModel.setProperty("/bHasSelfProps",i);this._oModel.setProperty("/bHasBorrowedProps",this._allProperties.length>this._selfProperties.length);this._oModel.setProperty("/ui5-metadata/properties",i?this._selfProperties:this._allProperties);}if(this._allAggregations){this._selfAggregations=this._allAggregations.filter(o);j=this._selfAggregations.length>0;this._oModel.setProperty("/bShowBorrowedAggr",!j);this._oModel.setProperty("/bHasSelfAggr",j);this._oModel.setProperty("/bHasBorrowedAggr",this._allAggregations.length>this._selfAggregations.length);this._oModel.setProperty("/ui5-metadata/aggregations",j?this._selfAggregations:this._allAggregations);}if(this._allAssociations){this._selfAssociations=this._allAssociations.filter(o);k=this._selfAssociations.length>0;this._oModel.setProperty("/bShowBorrowedAssoc",!k);this._oModel.setProperty("/bHasSelfAssoc",k);this._oModel.setProperty("/bHasBorrowedAssoc",this._allAssociations.length>this._selfAssociations.length);this._oModel.setProperty("/ui5-metadata/associations",k?this._selfAssociations:this._allAssociations);}if(this._oModel.getProperty("/hasFAQ")){var s=this._oEntityData.lib,m=s.replace(/\./g,'/'),n=this._oEntityData.name.replace(s,"").replace(/^[.]/,"").replace(/\./g,'/')+".html";q.ajax({type:"GET",url:'./docs/api/'+m+'/demokit/faq/'+n,success:function(p){this._oModel.setProperty("/faqContent",p);}.bind(this)});}this.setModel(this._oModel);this._oEntityData.appComponent=this._oControlData.component||this.NOT_AVAILABLE;this._oEntityData.hasSample=this._oControlData.hasSample;this._oEntityData.sample=this._oControlData.hasSample?this._sTopicId:this.NOT_AVAILABLE;this._buildHeaderLayout(this._oControlData,this._oEntityData);setTimeout(function(){this._hljs();this._objectPage.attachEvent("subSectionEnteredViewPort",function(){if(this._sHljsDelayedCallID){clearTimeout(this._sHljsDelayedCallID);}this._sHljsDelayedCallID=setTimeout(function(){var $=this._objectPage.$().find("pre:not(.hljs)");if($.length>0&&window.hljs){$.addClass('hljs');document.querySelectorAll('pre').forEach(function(p){window.hljs.highlightBlock(p);});}}.bind(this),200);},this);setTimeout(function(){if(this._sEntityType){this.scrollToEntity(this._sEntityType,this._sEntityId);}setTimeout(function(){this._objectPage.attachEvent("_sectionChange",function(E){var S=E.getParameter("section"),p=E.getParameter("subSection");if(this._oNavigatingTo){if(this._oNavigatingTo===p){this._oNavigatingTo=null;}return;}this._modifyURL(S,p,false);},this);this._objectPage.attachEvent("navigate",function(E){var S=E.getParameter("section"),p=E.getParameter("subSection");this._oNavigatingTo=p;this._modifyURL(S,p,true);},this);}.bind(this),500);}.bind(this),1000);}.bind(this),0);this.searchResultsButtonVisibilitySwitch(this.byId("apiDetailBackToSearch"));this.appendPageTitle(this._oModel.getProperty("/displayName"));},onAfterRendering:function(){this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);T.updateControl(this._oToggleFullScreenBtn,this._oContainerView,this._oContainerController);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onToggleFullScreen:function(E){T.updateMode(E,this._oContainerView,this._oContainerController);},onBorrowedPropCheckboxClick:function(E){var i=E.getParameter("selected");this._oModel.setProperty("/bShowBorrowedProps",i);this._oModel.setProperty("/ui5-metadata/properties",i?this._allProperties:this._selfProperties);},onBorrowedAggrCheckboxClick:function(E){var i=E.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAggr",i);this._oModel.setProperty("/ui5-metadata/aggregations",i?this._allAggregations:this._selfAggregations);},onBorrowedAssocCheckboxClick:function(E){var i=E.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAssoc",i);this._oModel.setProperty("/ui5-metadata/associations",i?this._allAssociations:this._selfAssociations);},onJSDocLinkClick:function(E){var o=E.target.classList,i=o.contains("sapUISDKExternalLink");if(i){this.onDisclaimerLinkPress(E);return;}},_modifyURL:function(s,S,i){var j=s.getTitle().toLowerCase(),k=(S&&S.getTitle()!=='Overview')?S.getTitle():'';if(Object.keys(this.SECTION_MAP).indexOf(j)>=0){j=this.SECTION_MAP[j];}this._oRouter.navToChangeUrlOnly({id:this._sTopicId,entityType:j,entityId:k},i);},_hljs:function(){if(window.hljs){document.querySelectorAll('pre').forEach(function(i){window.hljs.highlightBlock(i);});}},scrollToEntity:function(s,S){var i,j,o;if(!s){return;}s=s.toLowerCase();o=this.byId(s);if(!o){return;}if(S){S=S.toLowerCase();j=o.getSubSections();i=j.filter(function(k){return k.getTitle().toLowerCase()===S;});if(i.length){this._objectPage.scrollToSection(i[0].getId(),250);}}else{this._objectPage.scrollToSection(o.getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s,o){var p=new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");if(o){p.setCustomContent(o);}return p;},i=function(t,o){return new c({title:"Visibility",text:f.formatVisibility(t,o),state:h.Warning}).addStyleClass("sapUiTinyMarginBottom");},j=function(o){return new a(o||{});},k=function(o){return new b(o||{});},m=function(o){return new L(o||{});},n=function(o,p){var r=new H(o||{});if(p){r.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return r;};this._oHeaderLayoutUtil={_getControlSampleBlock:function(o,E){return n({items:[m({design:"Bold",text:"Control Sample:"}),j({emphasized:true,text:E.sample,visible:!!E.hasSample,href:"entity/"+o.name}),k({text:E.sample,visible:!E.hasSample})]},true);},_getControlGithub:function(o,E){return n({items:[m({design:"Bold",text:"GitHub:"}),j({emphasized:true,text:o.resource,visible:true,href:this.PUBLIC_GITHUB_FRAMEWORK_DOMAIN+E.lib+'/src/'+o.resource})]},true);},_getDocumentationBlock:function(o,E){return n({items:[m({design:"Bold",text:"Documentation:"}),j({emphasized:true,text:o.docuLinkText,href:"topic/"+o.docuLink})]},true);},_getUXGuidelinesBlock:function(o){return n({items:[m({design:"Bold",text:"UX Guidelines:"}),j({emphasized:true,text:o.uxGuidelinesLinkText,href:o.uxGuidelinesLink,target:"_blank"}),new I({src:"./resources/sap/ui/documentation/sdk/images/link-sap.png",tooltip:"Information published on SAP site",press:this.onDisclaimerLinkPress})]},true);},_getExtendsBlock:function(o,E){return n({items:[m({text:"Extends:"}),j({text:o.extendsText,href:"api/"+o.extendsText,visible:o.isDerived}),k({text:o.extendsText,visible:!o.isDerived})]},true);},_getSubclassesBlock:function(o,E){var s=E.extendedBy||E.implementedBy,S;this._aSubClasses=s;if(s.length===1){S=j({text:s[0],href:"api/"+s[0]});}else{S=j({text:o.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});}return n({items:[m({text:o.isClass?"Known direct subclasses:":"Known direct implementations:"}),S]},true);},_getImplementsBlock:function(o,E){var p=[m({text:"Implements:"})];o.implementsParsed.forEach(function(r){p.push(j({text:r.name,href:"api/"+r.href}));});return n({items:p,wrap:F.Wrap},true).addStyleClass("sapUiDocumentationCommaList");},_getModuleBlock:function(o,E){return _("Module",o.module);},_getLibraryBlock:function(o,E){return _("Library",E.lib);},_getVisibilityBlock:function(o,E){var v=o.visibility,p=E.allowedFor;if(v==="restricted"&&p){return p.length>1?_("Visibility",v,j({text:"restricted to",press:this._openVisibilityPopover.bind(this,p)})):i(v,p);}else{return _("Visibility",v);}},_getAvailableSinceBlock:function(o,E){return _("Available since",o.sinceText);},_getApplicationComponentBlock:function(o,E){return _("Application Component",E.appComponent);}};}return this._oHeaderLayoutUtil;},_openSubclassesImplementationsPopover:function(E){var p=this._aSubClasses.map(function(i){return new e({content:[new a({text:i,href:"api/"+i}).addStyleClass("sapUiTinyMargin")]});}),o=this._addPopoverContent(p);o.openBy(E.getSource());},_openVisibilityPopover:function(i,E){var p=i.map(function(s){return new e({content:[new b({text:s}).addStyleClass("sapUiTinyMargin")]});}),o=this._addPopoverContent(p);o.openBy(E.getSource());},_addPopoverContent:function(i){var p=this._getPopover();if(p.getContent().length>0){p.destroyContent();}if(i&&i.length>0){var o=new g({items:i||[]});p.addContent(o);}return p;},_getPopover:function(){if(!this._oPopover){this._oPopover=new P({placement:"Bottom",showHeader:false});}return this._oPopover;},_buildHeaderLayout:function(o,E){var i=0,S=1,j=2,k=3,m=[[],[],[]],n=this._getHeaderLayoutUtil(),s=E.extendedBy||E.implementedBy||[],p=this.getModel("versionData").getProperty("/isOpenUI5"),r=[{creator:"_getControlSampleBlock",exists:o.isClass||o.isNamespace},{creator:"_getDocumentationBlock",exists:o.docuLink!==undefined},{creator:"_getControlGithub",exists:p&&o.resource&&E.lib},{creator:"_getUXGuidelinesBlock",exists:o.uxGuidelinesLink!==undefined},{creator:"_getExtendsBlock",exists:o.isClass},{creator:"_getSubclassesBlock",exists:s.length>0},{creator:"_getImplementsBlock",exists:o.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:o.kind==="namespace"&&E.lib},{creator:"_getVisibilityBlock",exists:o.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],t=function(){var u=0,v,G=function(u){if(u<=k){return i;}else if(u<=k*2){return S;}return j;};r.forEach(function(w){var x;if(w.exists){x=n[w.creator].call(this,o,E);v=G(++u);m[v].push(x);}},this);}.bind(this);t();m.forEach(function(u,v){var V=this.byId("headerColumn"+v);V.removeAllContent();if(u.length>0){V.setVisible(true);u.forEach(V.addContent,V);}},this);},onAnnotationsLinkPress:function(){this.scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();}});});
