/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap","sap/ui/documentation/sdk/controller/util/SidyBySideImageMap","sap/ui/core/HTML","sap/base/Log","sap/m/LightBox","sap/m/LightBoxItem","./util/DataTableHelper","./util/DataTable","sap/m/Button","sap/m/MessageToast"],function(q,R,B,J,X,D,T,a,b,S,H,L,c,d,e,f,g,M){"use strict";var G="https://sap.github.io/openui5-docs/#/",h={SPECIAL_CHARS:/[\\\/:*\?"<>|]/g,SPACES:/\s+/g};return B.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){var i,C;this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass('docuPage');this.oHtml=this.byId("staticContent");this.aWaitingDatatables=[];this.aResponsiveImageMaps=[];this.oLayout=this.byId("staticContentLayout");this.oHtml.attachEvent("afterRendering",this._onHtmlRendered.bind(this));this._oConfig=C=this.getConfig();this.oMatchedTopicDataTablesConfig={};if(!window.hljs){q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"});}q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/css/dataTables.jqueryui.css");q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/css/buttons.jqueryui.css");q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/jquery.dataTables.js"}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/dataTables.jqueryui.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/dataTables.buttons.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.jqueryui.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.html5.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.colVis.js"});}).then(function(){i=a.getResourceOriginPath(C.docuPath+'dataTablesConfig.json');return q.ajax({url:i});}).then(function(j){this.oDataTablesConfig=j;this.bDataTablesPluginLoaded=true;this._getDataTableHelper().addMiddlewares();if(this.aWaitingDatatables.length>0){this.aWaitingDatatables.forEach(function(t){this._enableDataTable(t);},this);this.aWaitingDatatables=[];}}.bind(this));this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this.jsonDefModel=new J();this.getView().setModel(this.jsonDefModel);},onBeforeRendering:function(){var v=this.getView().getDomRef();if(v&&this.fnOnPageClickListener){v.removeEventListener('click',this.fnOnPageClickListener);}R.deregister(this._onResize.bind(this));D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){var v=this.getView().getDomRef();this.fnOnPageClickListener=this._onPageClick.bind(this);if(v){v.addEventListener('click',this.fnOnPageClickListener);}R.register(this.getView().getDomRef(),this._onResize.bind(this));D.orientation.attachHandler(this._onOrientationChange,this);},_getCopyButtons:function(E){var m="Copied to clipboard.";this.aButtonElements=E.querySelectorAll(".copyButton");this.aButtonElements.forEach(function(o){var i=new g({icon:"sap-icon://copy"});i.placeAt(o);o.addEventListener('click',function(){var t=document.createElement("textarea");t.value=o.parentNode.innerText;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);M.show(m);});});},onExit:function(){this.aResponsiveImageMaps.forEach(function(r){r.removeEventListeners();});R.deregister(this._onResize.bind(this));D.orientation.detachHandler(this._onOrientationChange,this);},_onResize:function(){this.aResponsiveImageMaps.forEach(function(i){i.resize();});},_onPageClick:function(E){var t=E.target,C=t.classList,i=C.contains('collapsible-icon'),j=C.contains('lightbox-img'),s;if(j){this._onThumbnailClicked(t);}if(i){s=t.parentNode;s.classList.toggle("expanded");}},_onThumbnailClicked:function(t){var l=this._getLightBox(),o=l.getImageContent()[0],s=t.getAttribute('src'),i=t.getAttribute('title'),A=t.getAttribute('alt');o.setImageSrc(s);o.setTitle(i);o.setAlt(A);l.open();},_getLightBox:function(){if(!this._oLightBox){this._oLightBox=new c({imageContent:new d()});}return this._oLightBox;},_getDataTableHelper:function(){return e.getInstance();},_onHtmlResourceLoaded:function(i){var j;if(!i){setTimeout(function(){this.onRouteNotFound();}.bind(this),0);return;}j=X.XML2JSON(i,this._oConfig);j.bIsPhone=D.system.phone;j.topicURL=this.sTopicURL;if(j.shortdesc){j.shortdesc=j.shortdesc.trim().replace(/(\r\n|\n|\r)/gm,' ');}this.jsonDefModel.setData(j);this.oHtml.setContent(j.html);this.oLayout.invalidate();this._scrollContentToTop();this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));this.appendPageTitle(this.getModel().getProperty("/topictitle1"));},_onTopicMatched:function(i){var I=decodeURIComponent(i.getParameter("arguments").id),u=I.split("#"),t=u[0],s=u[1];this.sTopicId=t.replace(".html","");this.sSubTopicId=s;this.sTopicURL=a.getResourceOriginPath(this._oConfig.docuPath+t+(t.match(/\.html/)?"":".html"));this.sSubTopicId=i.getParameter("arguments").subId||s;q.ajax(this.sTopicURL).done(this._onHtmlResourceLoaded.bind(this)).fail(this.onRouteNotFound.bind(this));},_onHtmlRendered:function(){this._getDataTableHelper().destroyDatatables();var s,i=this.oPage.$().find('#d4h5-main-container :not(.imagemap_sidebyside)>.imagemap'),j=this.oPage.$().find('#d4h5-main-container .imagemap_sidebyside'),k=this.oPage.$().find('#d4h5-main-container table.datatable'),I=this.oPage.$().find('#d4h5-main-container img'),o=this.oLayout.getDomRef();this._fixExternalLinks(o);this._getCopyButtons(o);this._computeColumnGroupValues(o);if(this.sSubTopicId){s=document.getElementById(this.sSubTopicId);if(s){s.scrollIntoView(true);}}this.aResponsiveImageMaps.forEach(function(r){r.removeEventListeners();});this.aResponsiveImageMaps=[];if(k.length){k.each(function(l,t){if(this.bDataTablesPluginLoaded){this._enableDataTable(t);}else{this.aWaitingDatatables.push(t);}}.bind(this));}i.each(function(l,m){this._enableImageMap(m);}.bind(this));j.each(function(l,m){this._enableImageMap(m,true);}.bind(this));I.each(function(l,m){var n=m.getAttribute("src");m.setAttribute("src",a.getResourceOriginPath(n));});if(window.hljs){document.querySelectorAll('pre').forEach(function(l){window.hljs.highlightBlock(l);});}},_enableImageMap:function(i,I){var o=i.querySelector('img'),n,s,r=/<img[^>]+src="([^">]+)/g,t=this;if(o.complete){this._addResponsiveImageMap(i,I);}else{n=new Image();n.onload=function(){t._addResponsiveImageMap(i,I);};s=r.exec(o.outerHTML);if(s){n.src=s&&s[1];}}},_enableDataTable:function(t){var s=t.id,C=this._getDataTableConfig(s),o;if(C){o=new f().init(s,t,C);this._getDataTableHelper().addDatatable(o);}},_getDataTableConfig:function(t){var o=this.oDataTablesConfig[this.sSubTopicId]||this.oDataTablesConfig[this.sTopicId]||{};return o[t];},_addResponsiveImageMap:function(i,I){var C=I?S:b;this.aResponsiveImageMaps.push(new C(i));},_fixExternalLinks:function(E){var l=E.querySelectorAll("a.external-link"),i,o,s,j="http://help.sap.com/disclaimer?site=";for(i=0;i<l.length;i++){o=l[i];s=o.getAttribute("href");o.setAttribute("href",j+s);this._addIconToExternalUrl(o,s);}},_computeColumnGroupValues:function(E){var s,w,i,p,C,o=E.querySelectorAll("colgroup");o=[].slice.call(o);o.forEach(function(j){s=0;i=[];C=[].slice.call(j.children);C.forEach(function(k,l){w=parseInt(k.getAttribute('width'));i[l]=w;s+=w;});C.forEach(function(k,l){p=(i[l]/s)*100;k.setAttribute('width',p+"%");});});},_addIconToExternalUrl:function(i,s){var j=this._isSAPHostedUrl(s),t='Information published on '+(j?'':'non ')+'SAP site',n=new Image(),I=j?'link-sap':'link-external';n.onload=function(){i.appendChild(n);};n.src='./resources/sap/ui/documentation/sdk/images/'+I+'.png';n.setAttribute("title",t);n.className="sapUISDKExternalLink";},_isSAPHostedUrl:function(s){return/^https?:\/\/([\w.]*\.)?(?:sap|hana\.ondemand|sapfioritrial)\.com/.test(s);},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1);}},_formatHTML:function(i){return'<div>'+i+'</div>';},backToSearch:function(t){this.onNavBack();},onToggleFullScreen:function(E){T.updateMode(E,this.getView(),this);},onEditGitHubPress:function(E){var u=this.jsonDefModel.getProperty("/topicURL"),t=this.jsonDefModel.getProperty("/topictitle1"),s=this._formatToGitHubUrl(u,t);window.open(s,"_blank");},_formatToGitHubUrl:function(u,t){var s=t.trim().replace(h.SPECIAL_CHARS,"").replace(h.SPACES,"_");s+="_";s+=u.split("/").pop().substring(0,7);s+=".md";return G+s;}});});
