/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

(function (root, factory) {
	"use strict";
	if (self.sap && self.sap.ui && typeof self.sap.ui.define  === 'function') {
		sap.ui.define(['sap/ui/thirdparty/URI'], factory);
	} else if (typeof self.exports === 'object' && typeof self.exports.nodeName !== 'string') {
		self.exports["ResourcesUtil"] = factory();
	} else {
		root["ResourcesUtil"] = factory();
	}
}(self, function (URI, b) {

	"use strict";

	var ResourcesUtil = {
		/**
		 *
		 * @param {string} sPath Relative path to resources
		 */

		getResourceOriginPath: function (sPath) {
			var sOrigin,
				oUri = URI(sPath),
				sVersionPrefixPath = this.getResourcesVersion();
			if (oUri && oUri.is("absolute")) {
				return sPath;
			}
			sOrigin = this.getConfig() || '.';

			return sOrigin + sVersionPrefixPath + this._formatPath(sPath);
		},
		getHasProxy: function () {
			return new window.URLSearchParams(window.location.search).get('sap-ui-xx-unifiedResources') != null ||
				window["sap-ui-unified-resources"];
		},
		getResourcesVersion: function() {
			return this.getHasProxy() && window.sessionStorage.getItem("versionPrefixPath") || "";
		},
		getConfig: function() {
			return self['sap-ui-documentation-config'] && self['sap-ui-documentation-config'].demoKitResourceOrigin;
		},
		_formatPath: function(sPath) {
			sPath = sPath.replace(/^\.\//, '/');

			if (!sPath.match(/^\//)) {
				sPath = "/" + sPath;
			}
			return sPath;
		}
	};

	return ResourcesUtil;
}));

