/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/fl/Utils"],function(L,F){"use strict";var M={};M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";function c(o,m,v,a){if(!o){return Promise.reject(new Error("No change instance"));}var b=o.getContent();if(!b||!b.movedElements||b.movedElements.length===0){return Promise.reject(new Error("Change format invalid"));}if(!b.source||!b.source.selector){return Promise.reject(new Error("No source supplied for move"));}if(!b.target||!b.target.selector){return Promise.reject(new Error("No target supplied for move"));}if(!m.bySelector(b.source.selector,a,v)){return Promise.reject(new Error("Move source parent not found"));}if(!m.bySelector(b.target.selector,a,v)){return Promise.reject(new Error("Move target parent not found"));}if(!b.source.selector.aggregation){return Promise.reject(new Error("No source aggregation supplied for move"));}if(!b.target.selector.aggregation){return Promise.reject(new Error("No target aggregation supplied for move"));}return Promise.resolve();}function g(m,o,a,v){if(!m.selector&&!m.id){return Promise.reject(new Error("Change format invalid - moveElements element has no id attribute"));}if(typeof m.targetIndex!=="number"){return Promise.reject(new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied"));}return Promise.resolve().then(o.bySelector.bind(o,m.selector||m.id,a,v)).then(function(b){if(!b){return Promise.reject(new Error("Control to move was not found. Id: '"+m.selector.id+"'"));}return b;});}function C(s){if(!s.movedElements){return Promise.reject(new Error("mSpecificChangeInfo.movedElements attribute required"));}if(s.movedElements.length===0){return Promise.reject(new Error("MovedElements array is empty"));}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});return Promise.resolve();}function G(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S;var t;return Promise.resolve().then(function(){return s.source.parent||m.bySelector(s.source.id,a);}).then(function(r){S=r;return s.target.parent||m.bySelector(s.target.id,a);}).then(function(r){t=r;var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var d={aggregation:s.target.aggregation,type:m.getControlType(t)};var e={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:d.type,selector:m.getSelector(s.target.id,a,d)},movedElements:s.movedElements};return e;});}M.applyChange=function(o,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var b;var s;var t;var S;var T;var i;var I;var d=false;var e=o.getContent();var R=[];var P=[];return c(o,m,v,a).then(function(){e.movedElements.forEach(function(f){var h=function(){return Promise.resolve().then(g.bind(null,f,m,a,v)).then(function(j){b=j;s=m.getParent(b);return p.sourceAggregation||m.getParentAggregationName(b,s);}).then(function(j){S=j;return m.bySelector(e.target.selector,a,v);}).then(function(j){t=j;T=p.targetAggregation||e.target.selector.aggregation;return m.findIndexInParentAggregation(b);}).then(function(j){i=j;I=f.targetIndex;if(i>-1){if(i===I&&S===T&&m.getParent(b)===t){i=f.sourceIndex;S=p.sourceAggregation||e.source.selector.aggregation;d=true;return m.bySelector(e.source.selector,a,v);}}return Promise.resolve();}).then(function(j){if(j){s=j;}if(i>-1){R.unshift({index:i,aggregation:S,sourceParent:m.getSelector(s,a)});}if(!d){return Promise.resolve().then(m.removeAggregation.bind(m,s,S,b)).then(m.insertAggregation.bind(m,t,T,b,I,v));}return Promise.resolve();});};P.push(h);},this);return F.execPromiseQueueSequentially(P,true,true);}.bind(this)).then(function(){o.setRevertData(R);});};M.revertChange=function(o,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var b=o.getContent();var s;var t;var S;var T;var d;var i;return c(o,m,v,a).then(m.bySelector.bind(m,b.source.selector,a,v)).then(function(R){s=R;S=b.source.selector.aggregation;T=b.target.selector.aggregation;return m.bySelector(b.target.selector,a,v);}).then(function(R){t=R;var e=o.getRevertData();o.getContent().movedElements.reverse();var P=[];b.movedElements.forEach(function(f,E){var h=function(){return Promise.resolve().then(g.bind(this,f,m,a,v)).then(function(j){d=j;if(!d){L.warning("Element to move not found");return Promise.reject();}i=f.sourceIndex;if(e){var k=e[E];S=k.aggregation;i=k.index;return m.bySelector(k.sourceParent,a,v);}return Promise.resolve();}).then(function(j){if(j){s=j;}return m.removeAggregation(t,T,d);}).then(function(){return m.insertAggregation(s,S,d,i,v);});}.bind(this);P.push(h);},this);return F.execPromiseQueueSequentially(P,true,true);}.bind(this)).then(function(){o.resetRevertData();});};M.completeChangeContent=function(o,s,p){var m=p.modifier;var a=p.appComponent;var b=o.getDefinition();return C(s).then(G.bind(this,m,s,a)).then(function(s){b.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};var P=[];s.movedElements.forEach(function(e){var d=Promise.resolve().then(function(){return e.element||m.bySelector(e.id,a);}).then(function(E){b.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});o.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);o.addDependentControl(s.target.id,M.TARGET_ALIAS,p);o.addDependentControl(s.movedElements.map(function(f){return f.id;}),M.MOVED_ELEMENTS_ALIAS,p);});P.push(d);});return Promise.all(P);});};M.getCondenserInfo=function(o){var a=o.getContent();var r=o.getRevertData()[0];return{affectedControl:a.movedElements[0].selector,classification:sap.ui.fl.condenser.Classification.Move,sourceContainer:r.sourceParent,targetContainer:a.target.selector,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:a.target.selector.aggregation,setTargetIndex:function(o,n){o.getContent().movedElements[0].targetIndex=n;},getTargetIndex:function(o){return o.getContent().movedElements[0].targetIndex;}};};M.getChangeVisualizationInfo=function(o){var a=o.getContent();return{affectedControls:[a.movedElements[0].selector],dependentControls:[a.source.selector]};};return M;},true);
