/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/base/Log","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider"],function(C,a,L,I,H,T,O,b){"use strict";var B=C.extend("sap.ui.integration.cards.filters.BaseFilter",{metadata:{"abstract":true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(r,f){var l=f.isLoading();r.openStart("div",f).class("sapFCardFilter");if(l){r.class("sapFCardFilterLoading");}r.openEnd();if(f._hasError()){r.renderControl(f._getErrorMessage());}else{r.renderControl(f.getField());}r.close("div");}}});B.prototype.init=function(){this.setAggregation("_loadingProvider",new b());this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready");});};B.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}};B.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider");return!l.isDataProviderJson()&&l.getLoading();};B.prototype.getField=function(){return null;};B.prototype.showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};B.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false);};B.prototype.onDataChanged=function(){};B.prototype.getValueForModel=function(){};B.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};B.prototype.getCardInstance=function(){return a.byId(this.getCard());};B.prototype._hasError=function(){return!!this._bError;};B.prototype._getErrorMessage=function(){var m="Unable to load the filter.";return new H({justifyContent:"Center",alignItems:"Center",items:[new I({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:m})]});};B.prototype._handleError=function(l){L.error(l);this._bError=true;this.invalidate();};B.prototype._onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders();};B.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),m;if(!d){this.fireEvent("_dataReady");return;}if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=c.getDataProviderFactory().create(d,null,true);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new O();this.setModel(m);}m.attachEvent("change",function(){this.onDataChanged();}.bind(this));this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();};return B;});
