/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone"],function(C,f,c,e,P,_,a,d,b){"use strict";var g="config";var h="propertyName";var i=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},_bEditorAutoDetect:false,_sCreatedBy:null,constructor:function(){C.prototype.constructor.apply(this,e(arguments,function(v,p){return(p==="config"&&P.hasType(v.type));}));if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(E){if(this._sCreatedBy){this._removePropertyEditor(E.getParameter("previousEditor"));}this._initPropertyEditor();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var o=E.getParameter("config");var n=this.getAggregation("propertyEditor");if(this._fnCancelInit||!n||!p||!o||p.type!==o.type||p.path!==o.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor();}else{n.setConfig(o);if(o.visible!==false&&p.visible===false){n.setValue(this.getValue());}}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===h){this._removePropertyEditor(this.getEditor());}if(this._sCreatedBy!==g){this._initPropertyEditor();}});this._initPropertyEditor();},renderer:function(r,o){r.openStart("div",o);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();r.renderControl(o.getAggregation("propertyEditor"));r.close("div");}});i.prototype.init=function(){Promise.resolve().then(function(){this.fireInit();}.bind(this));};i.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};i.prototype._prepareConfig=function(o){var B=this.getEditor();var E=(o.type&&B)?(B.getConfig().propertyEditorConfigs||{})[o.type]:{};return _({},E,o);};i.prototype.setConfig=function(m){var p=this.getConfig();var n=m&&_({},{designtime:undefined},this._prepareConfig(m));if(!d(p,n)){this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};i.prototype.setPropertyName=function(p){var s=this.getPropertyName();if(s!==p){this.setProperty("propertyName",p);this.firePropertyNameChange({previousPropertyName:s,propertyName:p});}};i.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});this.setConfig(this.getConfig());}};i.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());C.prototype.destroy.apply(this,arguments);};i.prototype._cleanupCancelledInit=function(p){p.destroy();};i.prototype._removePropertyEditor=function(E){var p=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}if(p){this.setAggregation("propertyEditor",null);p.detachReady(this._onPropertyEditorReady,this);p.detachValidationErrorChange(this._onPropertyEditorError,this);p.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null});}if(E&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){E.deregisterPropertyEditor(this,this._mConfig.__propertyName);}};i.prototype.isReady=function(){var n=this.getAggregation("propertyEditor");return n&&n.isReady()||false;};i.prototype.hasError=function(){var n=this.getAggregation("propertyEditor");return n&&n.hasError();};i.prototype.ready=function(){return new Promise(function(r){var j=function(n){n.ready().then(r);};var n=this.getAggregation("propertyEditor");if(n){j(n);}else{var w=function(E){var n=E.getParameter("propertyEditor");if(n){this.detachPropertyEditorChange(w,this);j(n);}};this.attachPropertyEditorChange(w,this);}}.bind(this));};i.prototype._onPropertyEditorReady=function(){this.fireReady();};i.prototype._onPropertyEditorError=function(E){this.fireValidationErrorChange({hasError:E.getParameter("hasError")});};i.prototype._initPropertyEditor=function(){if(!this.getEditor()){return;}if(this.getConfig()||(!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor())){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var s=this.getConfig()?g:h;var p=c(function(r,R){P.create(this._mConfig.type).then(r).catch(R);}.bind(this));this._fnCancelInit=p.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName);}p.promise.then(function(o){o.setModel(this.getEditor().getModel("i18n"),"i18n");o.setConfig(a(_({},this._mConfig),"__propertyName"));o.attachBeforeValueChange(function(E){this.fireBeforeValueChange(a(E.getParameters(),"id"));},this);o.attachValueChange(function(E){this.setValue(E.getParameter("value"));this.fireValueChange(a(E.getParameters(),"id"));},this);o.attachDesigntimeMetadataChange(function(E){this.fireDesigntimeMetadataChange(a(E.getParameters(),"id"));},this);o.setValue(this.getValue(),true);this._sCreatedBy=s;this.setAggregation("propertyEditor",o);var r=this.getRenderLabel();if(r!==undefined){o.setRenderLabel(r);}o.attachReady(this._onPropertyEditorReady,this);if(o.isReady()){this.fireReady();}o.attachValidationErrorChange(this._onPropertyEditorError,this);if(o.hasError()){this.fireValidationErrorChange({hasError:true});}this.firePropertyEditorChange({propertyEditor:o});delete this._fnCancelInit;}.bind(this));}};i.prototype._isAbsolutePath=function(p){return p&&p.startsWith("/");};i.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};i.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};i.prototype.setRenderLabel=function(r){this.setProperty("renderLabel",r);var n=this.getAggregation("propertyEditor");if(n){n.setRenderLabel(r);}};i.prototype.getContent=function(){var n=this.getAggregation("propertyEditor");return n&&n.getContent();};i.prototype.setValue=function(v){this.setProperty("value",v);var n=this.getAggregation("propertyEditor");if(n){n.setValue(v,true);}};i.prototype.getRuntimeConfig=function(){return this._mConfig;};i.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}};i.prototype.getFocusDomRef=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getFocusDomRef();}};i.prototype.getIdForLabel=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getIdForLabel();}};return i;});
