//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/ActionDefinition',["sap/m/library","sap/ui/core/Element"],function(l,E){"use strict";var B=l.ButtonType;
var A=E.extend("sap.ui.integration.ActionDefinition",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardActionType"},text:{type:"string",defaultValue:""},icon:{type:"sap.ui.core.URI"},buttonType:{type:"sap.m.ButtonType",defaultValue:B.Transparent},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true},parameters:{type:"object"}},events:{press:{}},associations:{_menuButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});
return A;});
sap.ui.predefine('sap/ui/integration/Designtime',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.Designtime",{
metadata:{library:"sap.ui.integration"},
constructor:function(s){M.apply(this);this.settings=s||(this.create&&this.create())||{};}
});
D.prototype.init=function(){this._oCard=null;};
D.prototype.exit=function(){this._oCard=null;};
D.prototype.onCardReady=function(c,i){this._oCard=c;this._oInternalCardInstance=i;};
D.prototype._readyPromise=function(c,i){this.onCardReady(c,i);return Promise.resolve();};
D.prototype.getCard=function(){return this._oCard;};
D.prototype.getSettings=function(){return this.settings;};
return D;});
sap.ui.predefine('sap/ui/integration/Extension',["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject"],function(l,L,M){"use strict";
var E=M.extend("sap.ui.integration.Extension",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]",deprecated:true},formatters:{type:"object"}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});
E.prototype.init=function(){this._oCardInterface=null;this._oCard=null;};
E.prototype.exit=function(){this._oCardInterface=null;this._oCard=null;};
E.prototype.setActions=function(a){this.setProperty("actions",a);if(this._oCard){this._oCard._refreshActionsMenu();}};
E.prototype.setFormatters=function(f){this.setProperty("formatters",f);if(!this._oCard){return;}if(!this._oCard._bApplyManifest||this._oCard.getAggregation("_extension")!==this){L.error("Extension formatters must be set before the initialization of the card. Do this inside Extension#init().");}};
E.prototype.onCardReady=function(){};
E.prototype.getCard=function(){return this._oCardInterface;};
E.prototype._setCard=function(c,C){this._oCard=c;this._oCardInterface=C;};
return E;});
sap.ui.predefine('sap/ui/integration/Host',["sap/ui/integration/library",'sap/ui/core/Element'],function(l,E){"use strict";
var H=E.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},cardConfigurationChange:{parameters:{card:{type:"sap.ui.core.Control"},changes:{type:"object"}}},message:{parameters:{data:{type:'object'}}}}}});
H.prototype.init=function(){this._handlePostMessageBound=this._handlePostMessage.bind(this);};
H.prototype.getDestination=function(d){var r=this.getResolveDestination(),R;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+d+"'. There is no 'resolveDestination' callback function configured in the host.");}R=r(d);if(!R){return Promise.reject("Destination '"+d+"' could not be resolved by the host.");}if(R instanceof Promise){return R;}return Promise.resolve(R);};
H.prototype.getContextValue=function(p){if(!p){return Promise.resolve(null);}return Promise.resolve(null);};
H.prototype.getDestinations=function(){return Promise.resolve([]);};
H.prototype.getContexts=function(){return Promise.resolve({});};
H.prototype.useExperimentalCaching=function(){this.bUseExperimentalCaching=true;this.subscribeForMessages();};
H.prototype.stopUsingExperimentalCaching=function(){this.bUseExperimentalCaching=false;this.unsubscribeForMessages();};
H.prototype.modifyRequestHeaders=function(h,s,c){var C=s.request.cache,a=[];if(C.enabled===false){a.push("max-age=0");a.push("no-store");}else{a.push("max-age="+parseInt(C.maxAge||0));if(C.staleWhileRevalidate){a.push("x-stale-while-revalidate");}}if(a.length){h["Cache-Control"]=a.join(", ");}h["x-sap-card"]="true";h["x-use-cryptocache"]="true";return h;};
H.prototype.subscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return;}navigator.serviceWorker.addEventListener("message",this._handlePostMessageBound);};
H.prototype.unsubscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return;}navigator.serviceWorker.removeEventListener("message",this._handlePostMessageBound);};
H.prototype._handlePostMessage=function(e){this.fireMessage({data:e.data});};
return H;});
sap.ui.predefine('sap/ui/integration/bindingFeatures/DateRange',["sap/ui/core/date/UniversalDateUtils","sap/base/Log"],function(U,L){"use strict";var D={start:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[0];},end:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[1];},_getRange:function(t,v){var g=U.ranges[t];if(!g){L.error("The requested date range type '"+t+"' is not found","sap.ui.integration.widgets.Card");return null;}return g(v);}};return D;});
sap.ui.predefine('sap/ui/integration/cards/AdaptiveContent',["sap/ui/integration/library","sap/ui/core/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/m/MessageStrip","sap/ui/core/HTML","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/Log"],function(l,c,i,B,h,V,M,H,C,J,L){"use strict";var A,a,b,U,d,e,f,g,j,k;var m=c.MessageType;
var n=B.extend("sap.ui.integration.cards.AdaptiveContent",{
metadata:{library:"sap.ui.integration"},
renderer:{apiVersion:2,render:function(r,o){var p=B.getMetadata().getRenderer();return p.render.apply(this,arguments);}}
});
n.prototype.init=function(){B.prototype.init.apply(this,arguments);this.setComponentsReady(false);this._bAdaptiveCardElementsReady=false;this._setupCardContent();C.attachThemeChanged(function(){this._adjustHostConfig();this.invalidate();}.bind(this));};
n.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this._oCardConfig);};
n.prototype.loadDependencies=function(o){this._loadWebcomponents();var p=[];p.push(new Promise(function(r,q){sap.ui.require(["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender"],function(_,s,t,u,v,w,x,y,z){A=_;a=s;U=t;d=u;e=v;f=w;g=x;j=y;k=z;this._setupAdaptiveCardDependency();r();}.bind(this),q);}.bind(this)));if(o.get("/sap.card/configuration/enableMarkdown")){p.push(new Promise(function(r,q){sap.ui.require(["sap/ui/integration/thirdparty/markdown-it"],function(_){b=_;r();},q);}));}return Promise.all(p);};
n.prototype._setupCardContent=function(){var o=new M(this.getId()+"-message",{showCloseButton:true,visible:false}),p=new H(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});o.addStyleClass("sapUiTinyMargin");this.setAggregation("_content",new V({items:[o,p]}));};
n.prototype.setConfiguration=function(o){this._oCardConfig=o;if(o&&o.request&&o.request.url){this._loadManifestFromUrl(o.request.url);return;}this._handleMarkDown();this._setupMSCardContent();};
n.prototype.getConfiguration=function(){return this._oCardConfig;};
n.prototype._handleMarkDown=function(){var t=this;A.AdaptiveCard.onProcessMarkdown=function(T,r){var o=t.getParent(),E=o&&o.getManifestEntry("/sap.card/configuration/enableMarkdown");if(E){r.outputHtml=new b().render(T);r.didProcess=true;return r;}};};
n.prototype._loadManifestFromUrl=function(u){var D=new J(),t=this;D.loadData(u).then(function(){t._oCardConfig=Object.assign(t._oCardConfig,D.getData());}).then(function(){t._handleMarkDown();t._setupMSCardContent();}).then(function(){D.destroy();D=null;}).catch(function(){L.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.");});};
n.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new A.AdaptiveCard();this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl();};
n.prototype._doMSCardsOverwrites=function(){A.Action.prototype.render=k;};
n.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new A.HostConfig(h());};
n.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return C.getConfiguration().getRTL();};};
n.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(o){var t,p,q;if(o instanceof A.OpenUrlAction){p={url:o.url};t=l.CardActionType.Navigation;}else if(o instanceof A.SubmitAction){p={data:o.data};t=l.CardActionType.Submit;}else{return;}q=this.getActions();if(q){q.fireAction(this,t,p);}}.bind(this);};
n.prototype.onActionSubmitStart=function(F){this.getParent().setBusy(true);};
n.prototype.onActionSubmitEnd=function(r,E){var R=C.getLibraryResourceBundle("sap.ui.integration"),s=E?R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),o=E?m.Error:m.Success;this.showMessage(s,o);this.getParent().setBusy(false);};
n.prototype.showMessage=function(s,t){var o=this.getAggregation("_content").getItems()[0];o.applySettings({"type":t,"text":s,"visible":true});};
n.prototype._replaceElements=function(){A.GlobalRegistry.elements.unregister("Input.Text");A.GlobalRegistry.elements.register("Input.Text",U);A.GlobalRegistry.elements.unregister("Input.Number");A.GlobalRegistry.elements.register("Input.Number",d);A.GlobalRegistry.elements.unregister("Input.ChoiceSet");A.GlobalRegistry.elements.register("Input.ChoiceSet",e);A.GlobalRegistry.elements.unregister("Input.Time");A.GlobalRegistry.elements.register("Input.Time",f);A.GlobalRegistry.elements.unregister("Input.Date");A.GlobalRegistry.elements.register("Input.Date",g);A.GlobalRegistry.elements.unregister("Input.Toggle");A.GlobalRegistry.elements.register("Input.Toggle",j);};
n.prototype.setCardDataProvider=function(D){this._oCardDataProvider=D;};
n.prototype._setupMSCardContent=function(){var o=this._oCardConfig,p,q=this._oCardDataProvider;if(!this.adaptiveCardInstance||!o){return;}p=o.$data||o.data;if(!p&&!q){this._oCardTemplate=null;this._renderMSCardContent(o);return;}if(o.$data){p={"json":p};}this._setDataConfiguration(p);};
n.prototype.onDataChanged=function(){var p=this.getBindingContext().getPath(),D=this.getModel().getProperty(p);this._oCardTemplate=this._setTemplating(this._oCardConfig,D);this.getAggregation("_loadingProvider").setLoading(false);this.invalidate();};
n.prototype._renderMSCardContent=function(o){var D=this.getAggregation("_content").getItems()[1].$(),I=!!this.isLoading();this.setBusy(I);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",I);if(this.adaptiveCardInstance&&o&&D.length){this.adaptiveCardInstance.parse(o);D.html(this.adaptiveCardInstance.render());this._bAdaptiveCardElementsReady=true;this._fireCardReadyEvent();if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1;}}};
n.prototype._fireCardReadyEvent=function(){if(this._bAdaptiveCardElementsReady&&this.getComponentsReady()){this._bReady=true;this.fireReady();}};
n.prototype._setTemplating=function(t,D){var o=new a.Template(t),p=new a.EvaluationContext();p.$root=D;return o.expand(p);};
n.prototype._loadWebcomponents=function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");this._fireCardReadyEvent();return;}if(window.customElements){window.customElements.whenDefined("ui5-button").then(function(){if(!this.getComponentsReady()){this.setComponentsReady(true);this._fireCardReadyEvent();}}.bind(this));}setTimeout(function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-loader",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/webcomponentsjs/webcomponents-loader.js")});}.bind(this));document.addEventListener("WebComponentsReady",function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")});this.setComponentsReady(true);this._fireCardReadyEvent();}.bind(this));};
n.prototype.setComponentsReady=function(v){this._bComponentsReady=v;return this;};
n.prototype.getComponentsReady=function(){return!!this._bComponentsReady;};
return n;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContent',["./AnalyticalContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/base/util/merge","sap/ui/core/Core"],function(A,B,l,a,L,m,C){"use strict";var b=l.CardActionArea;var V,F,c,P;var d={"Top":"top","Bottom":"bottom","Left":"left","Right":"right"};var e={"TopLeft":"topLeft","Center":"center"};var T={"Left":"left","Center":"center","Right":"right"};var f={"Line":"line","StackedColumn":"stacked_column","StackedBar":"stacked_bar","Donut":"donut"};var g={"Chart":"Chart","Full":"Full"};
var h=B.extend("sap.ui.integration.cards.AnalyticalContent",{
metadata:{library:"sap.ui.integration"},
renderer:A
});
h.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oPopover){this._oPopover.destroy();}};
h.prototype.loadDependencies=function(o){return new Promise(function(r,i){C.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/controls/Popover","sap/viz/ui5/data/FlattenedDataset"],function(_,j,k,n){V=_;F=j;P=k;c=n;r();},function(E){i(E);});}).catch(function(){i("Analytical content type is not available with this distribution.");});});};
h.prototype.onDataChanged=function(){this._createChart();};
h.prototype._createChart=function(){var o=this.getConfiguration();if(!o.chartType){L.error("\"sap.card\".content.chartType is mandatory property.",null,"sap.ui.integration.widgets.Card");return;}var r=a.resolveValue(o,this,"/");var i=new V({uiConfig:{applicationSet:"fiori"},height:"100%",width:"100%",vizType:f[r.chartType]||r.chartType,vizProperties:this._getVizProperties(r),dataset:this._getDataset(r),feeds:this._getFeeds(r)});this.setAggregation("_content",i);this._attachActions();if(r.popover&&r.popover.active){this._attachPopover();}};
h.prototype._attachActions=function(){var o=this.getConfiguration();var i={area:b.Content,actions:o.actions,control:this};if(o.actionableArea===g.Chart){i.eventName="selectData";i.actionControl=this.getAggregation("_content");this._oActions.setBindingPathResolver(function(E){var I=E.getParameter("data")[0].data._context_row_number;return this.getBindingContext().getPath()+"/"+I;}.bind(this));}else{i.eventName="press";}this._oActions.attach(i);};
h.prototype._attachPopover=function(){if(this._oPopover){this._oPopover.destroy();}this._oPopover=new P();this._oPopover.connect(this.getAggregation("_content").getVizUid());};
h.prototype._getVizProperties=function(r){if(!r){return null;}var t=r.title,o=r.legend,p=r.plotArea;var v={title:{style:{fontWeight:"normal"},layout:{respectPlotPosition:false}},legend:{},legendGroup:{layout:{}},plotArea:{window:{start:"firstDataPoint",end:"lastDataPoint"}},categoryAxis:{title:{}},valueAxis:{title:{}},interaction:{noninteractiveMode:true}};if(r.actions||r.popover){var i=r.actionableArea===g.Chart||r.popover&&r.popover.active;v.interaction.noninteractiveMode=!i;}if(t){v.title.text=t.text;v.title.visible=t.visible;v.title.alignment=T[t.alignment];L.warning("\"sap.card\".content.title is deprecated. Use \"sap.card\".content.chartProperties instead",null,"sap.ui.integration.widgets.Card");}if(o){v.legend.visible=o.visible;v.legendGroup.layout.position=d[o.position];v.legendGroup.layout.alignment=e[o.alignment];L.warning("\"sap.card\".content.legend is deprecated. Use \"sap.card\".content.chartProperties instead",null,"sap.ui.integration.widgets.Card");}if(p){if(p.dataLabel){v.plotArea.dataLabel=p.dataLabel;}if(p.categoryAxisText){v.categoryAxis.title.visible=p.categoryAxisText.visible;}if(p.valueAxisText){v.valueAxis.title.visible=p.valueAxisText.visible;}L.warning("\"sap.card\".content.plotArea is deprecated. Use \"sap.card\".content.chartProperties instead",null,"sap.ui.integration.widgets.Card");}m(v,r.chartProperties);return v;};
h.prototype._getDataset=function(r){var o=this.getConfiguration();var M,D;if(o.dimensions){D=o.dimensions.map(function(j,i){return{name:r.dimensions[i].name||r.dimensions[i].label,value:j.value};});}if(o.measures){M=o.measures.map(function(j,i){return{name:r.measures[i].name||r.measures[i].label,value:j.value};});}return new c({measures:M,dimensions:D,data:{path:this.getBindingContext().getPath()}});};
h.prototype._getFeeds=function(r){var i=r.feeds;if(r.measureAxis||r.dimensionAxis){L.warning("\"sap.card\".content.measureAxis and \"sap.card\".content.dimensionAxis are deprecated. Use \"sap.card\".content.feeds instead",null,"sap.ui.integration.widgets.Card");i=[{uid:r.measureAxis,type:"Measure",values:r.measures.map(function(M){return M.label;})},{uid:r.dimensionAxis,type:"Dimension",values:r.dimensions.map(function(D){return D.label;})}];}return i.map(function(o){return new F(o);});};
return h;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticalContentRenderer",{
apiVersion:2,
MIN_ANALYTICAL_CONTENT_HEIGHT:"14rem"
});
A.getMinHeight=function(c,C){if(c.minHeight){return c.minHeight;}return A.MIN_ANALYTICAL_CONTENT_HEIGHT;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContent',["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/base/Log"],function(A,B,l,H,a,L){"use strict";var b=l.CardActionArea;
var c=B.extend("sap.ui.integration.cards.AnalyticsCloudContent",{
metadata:{library:"sap.ui.integration"},
renderer:A
});
c.prototype.init=function(){B.prototype.init.apply(this,arguments);var i=this.getId()+"-highchartContainer";this._oHighchartContainer=new H(i,{content:"<div id="+i+" class='sapFCardAnalyticsCloudContentHCC'></div>"});this.setAggregation("_content",this._oHighchartContainer);};
c.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oHighchart){this._oHighchart.destroy();this._oHighchart=null;}if(this._oHighchartContainer){this._oHighchartContainer.destroy();this._oHighchartContainer=null;}};
c.prototype.loadDependencies=function(C){return this._loadHighcharts();};
c.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);this.fireEvent("_actionContentReady");this._oActions.attach({area:b.Content,actions:C.actions,control:this});};
c.prototype.onAfterRendering=function(){this._createHighchart();};
c.prototype._loadHighcharts=function(){var C=this.getCardInstance(),d=c.SAC_DESTINATION_KEY,p=C.resolveDestination(d);return p.then(function(u){return c.loadHighcharts(u);},function(r){return Promise.reject("Destination with key '"+d+"' is required for AnalyticsCloud card. It could not be resolved. Reason: '"+r+"'");});};
c.prototype._createHighchart=function(){if(this._bIsBeingDestroyed){return;}var C=this.getCardInstance(),o=this.getConfiguration(),d=this.getBindingContext(),p,e;if(!C.isReady()){C.attachEventOnce("_ready",this._createHighchart,this);return;}if(!window.Highcharts){this.handleError("There was a problem with loading Highcharts library. Could not initialize AnalyticsCloud card content.");return;}if(!this._oHighchartContainer){L.error("Highcharts container is not created or destroyed.");return;}if(d){p=d.getPath();}e=a.resolveValue(o.options,this,p);this._oHighchart=new window.Highcharts.Chart(this._oHighchartContainer.getId(),e);};
c.SAC_DESTINATION_KEY="sac";c.HIGHCHART_MODULES={"highcharts/highstock":{amd:true,exports:'Highcharts'},"highcharts/highcharts-more":{deps:["highcharts/highstock"]},"highcharts/solid-gauge":{deps:["highcharts/highstock"]},"highcharts/histogram-bellcurve":{deps:["highcharts/highstock"]},"highcharts/no-data-to-display":{deps:["highcharts/highstock"]},"highcharts/wordcloud":{deps:["highcharts/highstock"]},"highcharts/variable-pie":{deps:["highcharts/highstock"]},"highcharts/heatmap":{deps:["highcharts/highstock"]},"highcharts/treemap":{deps:["highcharts/highstock"]},"highcharts/variwide":{deps:["highcharts/highstock"]},"highcharts/pattern-fill":{deps:["highcharts/highstock"]},"highcharts/highcharts-3d":{deps:["highcharts/highstock"]},"highcharts/grouped-categories":{deps:["highcharts/highstock"]}};
c.loadHighcharts=function(s){var S=s.trim().replace(/\/$/,""),f=S,i=this._isHighchartsIncluded(f),I=this._isHighchartsIncludedByThirdParty();if(i){return this._pLoadModules;}if(I){return Promise.resolve();}this._sIncludedFrom=f;this._pLoadModules=this._loadModules(f);return this._pLoadModules;};
c._isHighchartsIncluded=function(s){var i=this._sIncludedFrom;if(i&&i===s){return true;}if(i&&i!==s){L.warning("Highcharts library is already included from '"+i+"'. The included version will be used and will not load from '"+s+"'","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._isHighchartsIncludedByThirdParty=function(){if(window.Highcharts){L.warning("Highcharts library is already included on the page. The included version will be used and will not load another one.","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._loadModules=function(s){var S=this.HIGHCHART_MODULES,m=Object.getOwnPropertyNames(S);sap.ui.loader.config({paths:{"highcharts":s+"/highcharts"},async:true,shim:S});return this._require(m).catch(function(){return Promise.reject("There was a problem with loading of the Highcharts library files.");});};
c._require=function(m){return new Promise(function(r,R){sap.ui.require(m,function(){r(arguments);},function(e){R(e);});});};
return c;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticsCloudContentRenderer",{
apiVersion:2,
MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT:"14rem"
});
A.getMinHeight=function(c,C){if(c.minHeight){return c.minHeight;}return A.MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/BaseContent',["./BaseContentRenderer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider"],function(B,C,a,O,M,L){"use strict";
var b=a.extend("sap.ui.integration.cards.BaseContent",{
metadata:{library:"sap.ui.integration",aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{},ready:{}}},
renderer:B
});
b.prototype.init=function(){this._oAwaitedEvents=new Set();this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new L());};
b.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};
b.prototype.exit=function(){this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}this._sContentBindingPath=null;};
b.prototype.loadDependencies=function(c){return Promise.resolve();};
b.prototype.getActions=function(){return this._oActions;};
b.prototype.setActions=function(A){this._oActions=A;};
b.prototype.awaitEvent=function(e){if(this._oAwaitedEvents.has(e)){return;}this._bReady=false;this._oAwaitedEvents.add(e);this.showLoadingPlaceholders();this.attachEventOnce(e,function(){this._oAwaitedEvents.delete(e);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady();}}.bind(this));};
b.prototype.setConfiguration=function(c,t){this._oConfiguration=c;this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady");if(!c){return this;}this._oLoadingPlaceholder=this.getAggregation("_loadingProvider").createContentPlaceholder(c,t,this.getCardInstance());this._setDataConfiguration(c.data);return this;};
b.prototype.getConfiguration=function(){return this._oConfiguration;};
b.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),m;if(!d){this._sContentBindingPath=null;this.fireEvent("_dataReady");return;}this._sContentBindingPath=d.path||"/";this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new O();this.setModel(m);}if(!m){this.fireEvent("_dataReady");return;}m.attachEvent("change",function(){this.onDataChanged();this.onDataRequestComplete();}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));});this._oDataProvider.attachError(function(e){this.handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype.onDataRequested=function(){this.awaitEvent("_dataReady");};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");};
b.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};
b.prototype.showLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(true);}};
b.prototype.hideLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(false);}};
b.prototype.onDataChanged=function(){};
b.prototype._bindAggregationToControl=function(A,c,o){var d;if(!o){return;}if(!o.path){o.path=this._sContentBindingPath;}if(!o.path){d=this.getCardInstance().getBindingContext();o.path=d&&d.getPath();}if(!o.path){return;}c.bindAggregation(A,o);this._observeAggregation(A,c);};
b.prototype._observeAggregation=function(A,c){var p=this.getCardInstance().getModel("parameters"),o;if(this._mObservers[A]){return;}o=new M(function(d){var e;if(d.name!==A){return;}if(!(d.mutation==="insert"||d.mutation==="remove")){return;}e=c.getMetadata().getAggregation(A).get(c);p.setProperty("/visibleItems",e.length);});o.observe(c,{aggregations:[A]});this._mObservers[A]=o;};
b.prototype.isReady=function(){return this._bReady;};
b.prototype.handleError=function(l,d){this.fireEvent("_error",{logMessage:l,displayMessage:d});};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype.setIconFormatter=function(i){this._oIconFormatter=i;return this;};
b.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider"),c=this.getCardInstance();return!l.isDataProviderJson()&&(l.getLoading()||(c&&c.isLoading()));};
b.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.attachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.detachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.onActionSubmitStart=function(f){};
b.prototype.onActionSubmitEnd=function(r,e){};
b.prototype.getCardInstance=function(){return C.byId(this.getCard());};
return b;});
sap.ui.predefine('sap/ui/integration/cards/BaseContentRenderer',["sap/ui/core/Renderer"],function(R){"use strict";
var B=R.extend("sap.ui.integration.cards.BaseContentRenderer",{apiVersion:2});
B.DEFAULT_MIN_HEIGHT="5rem";
B.render=function(r,c){var C="sapFCard",n=c.getMetadata().getName(),t=n.slice(n.lastIndexOf(".")+1),o=c.getParent(),i=o&&o.isA("sap.f.ICard"),l=t!=="AdaptiveContent"&&i&&c.isLoading();C+=t;r.openStart("div",c).class(C).class("sapFCardBaseContent");if(c.hasListeners("press")){r.class("sapFCardClickable");}if(i&&o.getHeight()==="auto"){var h=this.getMinHeight(c.getConfiguration(),c);r.style("min-height",h);}if(l){r.class("sapFCardContentLoading");}r.openEnd();if(l){r.renderControl(c._oLoadingPlaceholder);}this.renderContent(r,c);r.close("div");};
B.renderContent=function(r,c){r.renderControl(c.getAggregation("_content"));};
B.getMinHeight=function(c,C){return this.DEFAULT_MIN_HEIGHT;};
B.isCompact=function(c){var r=c,p=c.getParent();if(!c.getDomRef()&&p&&p.isA("sap.f.ICard")){r=p;}return r.$().closest(".sapUiSizeCompact").hasClass("sapUiSizeCompact");};
return B;});
sap.ui.predefine('sap/ui/integration/cards/BaseListContent',["sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingResolver","sap/ui/integration/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log","sap/ui/model/Sorter"],function(B,a,l,F,b,L,S){"use strict";
var c=B.extend("sap.ui.integration.cards.BaseListContent",{
metadata:{library:"sap.ui.integration"},
renderer:{apiVersion:2}
});
c.prototype.init=function(){B.prototype.init.apply(this,arguments);this._oAwaitingPromise=null;};
c.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._oAwaitingPromise=null;};
c.prototype.setConfiguration=function(C,t){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}var o=this.getInnerList(),m=C.maxItems;if(o&&m){o.setGrowing(true);o.setGrowingThreshold(parseInt(m));o.addStyleClass("sapFCardMaxItems");}return this;};
c.prototype.getInnerList=function(){return null;};
c.prototype._filterHiddenNavigationItems=function(i,o){if(!i.actions){return;}var A=i.actions[0];if(!(A&&A.service&&A.type==="Navigation")){return;}var f=new F("_card_item_hidden",b.EQ,false);this.awaitEvent("_filterNavItemsReady");o.filters=[f];};
c.prototype._checkHiddenNavigationItems=function(i){if(!i.actions){return;}if(!this.getInnerList()){return;}var o=this.getInnerList().getBinding("items"),m=o.getModel(),p=o.getPath(),I=m.getProperty(p),P=[],A=i.actions[0],s=p.trim().replace(/\/$/,""),d;if(!(A&&A.service&&A.type==="Navigation")){return;}if(A.service==="object"){d=A.service.name;}else{d=A.service;}I.forEach(function(e,f){var g=a.resolveValue(A.parameters,this,s+"/"+f);if(e._card_item_hidden===undefined){e._card_item_hidden=false;}P.push(this._oServiceManager.getService(d).then(function(n){if(!n.hidden){return false;}return n.hidden({parameters:g});}).then(function(h){e._card_item_hidden=!!h;m.checkUpdate(true);}).catch(function(M){L.error(M);}));}.bind(this));m.checkUpdate(true);this._awaitPromises(P);};
c.prototype._awaitPromises=function(p){var d=this._oAwaitingPromise=Promise.all(p);d.then(function(){if(this._oAwaitingPromise===d){this.fireEvent("_filterNavItemsReady");}}.bind(this));};
c.prototype._getGroupSorter=function(g){var d=false;if(g.order.dir&&g.order.dir==="DESC"){d=true;}var s=new S(g.order.path,d,function(C){return a.resolveValue(g.title,C.getModel(),C.getPath());});return s;};
return c;});
sap.ui.predefine('sap/ui/integration/cards/CalendarContent',["./CalendarContentRenderer","sap/ui/core/ResizeHandler","sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/CalendarAppointmentInCard","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem"],function(C,R,l,B,a,b,c,d,P,L,e,F,D,f,g,h,j,k,U,m){"use strict";var A=l.CardActionArea;
var n=B.extend("sap.ui.integration.cards.CalendarContent",{
renderer:C,
metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{appointments:{type:"sap.f.CalendarAppointmentInCard",multiple:true,singularName:"appointment"}}}
});
n.prototype._createCardContent=function(){this._oCalendar=new d(this.getId()+"-navigation",{startDateChange:function(E){var i=E.getSource()._getFocusedDate().toLocalJSDate();this._handleStartDateChange(i);}.bind(this),select:function(E){var s=E.getSource().getSelectedDates()[0].getStartDate();this._setParameters(E,E.getParameter("startDate"));this._refreshVisibleAppointments(s);this.invalidate();this._handleSelect(s);}.bind(this)});this._oLegend=new P(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oCalendar.setLegend(this._oLegend);this._oContent=new F(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+_.call(this).getTimePattern("medium")});};
n.prototype.init=function(){this._aVisibleAppointments=[];B.prototype.init.apply(this,arguments);this._createCardContent();};
n.prototype.exit=function(){if(this._sTwoColumnsResizeListener){R.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined;}B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._bDataInitiallyLoaded){this._bDataInitiallyLoaded=null;}};
n.prototype.onDataChanged=function(){var s=this._oCalendar.getSelectedDates()[0].getStartDate();if(!this._bDataInitiallyLoaded){this._handleSelect(s);this._handleStartDateChange(s);this._bDataInitiallyLoaded=true;}this._setParameters();this._refreshVisibleAppointments(s);this.invalidate();};
n.prototype.onBeforeRendering=function(){var i=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._setParameters();this._refreshVisibleAppointments(i);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};
n.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=R.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()});}};
n.prototype.resizeHandler=function(E){E.control.toggleStyleClass("sapMPCInCardTwoColumns",E.target.getBoundingClientRect().width>576);};
n.prototype.setConfiguration=function(i){B.prototype.setConfiguration.apply(this,arguments);this.fireEvent("_actionContentReady");if(!i){return this;}if(i.item){this._addItem(i.item);}if(i.specialDate){this._addSpecialDate(i.specialDate);}if(i.legendItem){this._addLegendItem(i.legendItem);}if(i.date){this._addDate(i.date);}if(i.maxItems){this._addMaxItems(i.maxItems);}if(i.maxLegendItems){this._addMaxLegendItems(i.maxLegendItems);}if(i.noItemsText){this._addNoItemsText(i.noItemsText);}if(i.moreItems&&i.moreItems.actions){this._oActions.attach({area:A.Content,actions:i.moreItems.actions,control:this._getMoreButton()});}return this;};
n.prototype._setParameters=function(E,i){var p,s,q,r,t;if(i){p=i;}else if(this._oCalendar.getSelectedDates().length){p=this._oCalendar.getSelectedDates()[0].getStartDate();}else{p=this._oCalendar.getStartDate();}s=new Date(p.getFullYear(),p.getMonth(),p.getDate());q=new Date(p.getFullYear(),p.getMonth(),p.getDate());q.setDate(q.getDate()+1);r=this.getAppointments();if(r){t=r.filter(function(u){var S=u.getStartDate().getTime(),v=u.getEndDate().getTime();if((S>=s.getTime()&&S<q.getTime())||(v>=s.getTime()&&v<q.getTime())||(S<=s.getTime()&&v>q.getTime())){return u;}});}else{t=[];}this._iAllItems=t.length;this._iMaxItems=this.getVisibleAppointmentsCount();this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};
n.prototype._refreshVisibleAppointments=function(s){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),s);};
n.prototype._calculateVisibleAppointments=function(i,s){var I=this._isAppointmentInSelectedDate(s);var t=function(p,q){var E=p.getEndDate(),N=new Date();if(s.getDate()===N.getDate()&&s.getMonth()===N.getMonth()&&s.getFullYear()===N.getFullYear()){return this._iAllItems-q<this._iVisibleItems||E.getTime()>N.getTime();}return true;};var r=i.filter(I,this).sort(this._sortByStartHourCB).filter(t,this).slice(0,this._iVisibleItems);return r;};
n.prototype._sortByStartHourCB=function(i,p){return i.getStartDate().getTime()-p.getStartDate().getTime()||p.getEndDate().getTime()-i.getEndDate().getTime();};
n.prototype._isAppointmentInSelectedDate=function(s){return function(i){var p=i.getStartDate().getTime(),q=i.getEndDate().getTime(),S=s.getTime(),r=U.getInstance(new Date(s.getTime())),t,u,v,E;r.setDate(r.getDate()+1);t=r.getTime();u=p<S&&q>t;v=p>=S&&p<t;E=q>S&&q<=t;return u||v||E;};};
n.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
n.prototype.formatDate=function(t){var i=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!i){i=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return i;};
n.prototype._addItem=function(i){var p={title:i.template.title,text:i.template.text,type:i.template.type},q;if(i.template.startDate){p.startDate=a.formattedProperty(i.template.startDate,this.formatDate);}if(i.template.endDate){p.endDate=a.formattedProperty(i.template.endDate,this.formatDate);}if(i.template.icon&&i.template.icon.src){p.icon=a.formattedProperty(i.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));}this._oAppointmentTemplate=new c(p);var r=this.getActions();r.attach({area:A.ContentItem,actions:i.template.actions,control:this,actionControl:this._oAppointmentTemplate,enabledPropertyName:"clickable",enabledPropertyValue:true,disabledPropertyValue:false});q={path:i.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,q);};
n.prototype._addSpecialDate=function(s){var S=s.template,i;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new k(S);i={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,i);};
n.prototype._addLegendItem=function(i){var p={text:i.template.text,type:i.template.type},q={text:i.template.text,type:i.template.type},r,s;this._oCalendarLegendItemTemplate=new m(p);r={path:i.path,template:this._oCalendarLegendItemTemplate,filters:new f({path:"category",operator:g.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,r);this._oAppointmentLegendItemTemplate=new m(q);s={path:i.path,template:this._oAppointmentLegendItemTemplate,filters:new f({path:"category",operator:g.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,s);};
n.prototype._addDate=function(t){if(b.isBindingInfo(t)){if(!t){return;}var i=new k();i.bindProperty("startDate",a.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(i);}else{this._oCalendar.addSelectedDate(new k({startDate:this.formatDate(t)}));var p=this.formatDate(t);this._handleSelect(p);this._handleStartDateChange(p);this._bDataInitiallyLoaded=true;}};
n.prototype._addMaxItems=function(M){if(b.isBindingInfo(M)){M&&this.bindProperty("visibleAppointmentsCount",M);}else{this.setVisibleAppointmentsCount(M);}};
n.prototype._addMaxLegendItems=function(M){if(b.isBindingInfo(M)){M&&this._oLegend.bindProperty("visibleLegendItemsCount",M);}else{this._oLegend.setVisibleLegendItemsCount(M);}};
n.prototype._addNoItemsText=function(N){if(b.isBindingInfo(N)){N&&this.bindProperty("noAppointmentsText",N);}else{this.setNoAppointmentsText(N);}};
n.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new e({text:"More"});}return this._oMoreAppsButton;};
n.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount();};
n.prototype._getCurrentAppointment=function(){var p=this._getVisibleAppointments(),N=new Date(),q,s,E,i,S=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(S.getDate()===N.getDate()&&S.getMonth()===N.getMonth()&&S.getFullYear()===N.getFullYear()){for(i=p.length-1;i>=0;i--){q=p[i];s=q.getStartDate().getTime();E=q.getEndDate().getTime();if(N.getTime()>s&&N.getTime()<E){return q;}}}};
n.prototype._handleStartDateChange=function(i){var p=this.getActions(),q=h.fromLocalJSDate(i),r=j._getFirstDateOfWeek(j._getFirstDateOfMonth(q)),s=new h(i.getFullYear(),i.getMonth()+1,1),t;s.setDate(s.getDate()-1);t=j._getFirstDateOfWeek(s);t.setDate(t.getDate()+6);p.fireAction(this,"MonthChange",{"firstDate":r.toLocalJSDate(),"lastDate":t.toLocalJSDate()});};
n.prototype._handleSelect=function(s){var i=this.getActions();i.fireAction(this,"DateChange",{"selectedDate":s});};
function _(){if(!this._oLocaleData){var s=o.call(this);var i=new sap.ui.core.Locale(s);this._oLocaleData=sap.ui.core.LocaleData.getInstance(i);}return this._oLocaleData;}
function o(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
return n;});
sap.ui.predefine('sap/ui/integration/cards/CalendarContentRenderer',["./BaseContentRenderer","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/unified/library","sap/ui/unified/CalendarLegendRenderer"],function(B,I,a,u,C){"use strict";var b=u.CalendarDayType;
var c=B.extend("sap.ui.integration.cards.CalendarContentRenderer",{apiVersion:2});
c.renderContent=function(r,o){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration"),i=o.getId();r.openStart("div",i+"card-group");r.attr("role","group");r.attr("aria-label",R.getText("CARDS_CALENDAR"));r.class("sapFCalCard");r.openEnd();r.openStart("div",i+"card-layout");r.class("sapFCalCardLayout");r.openEnd();r.openStart("div",i+"left-side");r.class("sapFCalCardLeftSide");r.openEnd();r.renderControl(o._oCalendar);r.openStart("div",i+"card-legend");r.attr("aria-label",R.getText("CARDS_CALENDAR_LEGEND"));r.openEnd();r.renderControl(o._oLegend);r.close("div");r.openStart("div","card-line-separator");r.class("sapFCalCardLineSeparator");r.openEnd();r.close("div");r.close("div");r.openStart("div",i+"right-side");r.class("sapFCalCardRightSide");r.openEnd();c.renderAppointments(r,o);if(o._bNeedForMoreButton()){r.renderControl(o._getMoreButton());}r.close("div");r.close("div");r.close("div");};
c.renderAppointments=function(r,o){var v=o._getVisibleAppointments(),d=o._getCurrentAppointment(),R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.integration");r.openStart("div",o.getId()+"appointments-list");r.attr("role","list");r.attr("aria-label",R.getText("CARDS_CALENDAR_APPOINTMENTS"));r.class("sapFCalCardAppList");r.openEnd();if(!v.length){r.openStart("div");r.class("sapFCalCardNoItemsText");r.openEnd();r.text(o.getNoAppointmentsText());r.close("div");}v.forEach(function(A){c.renderAppointment(r,o,A,d==A);});r.close("div");};
c.renderAppointment=function(r,o,A,i){var s=o._oCalendar.getSelectedDates()[0].getStartDate();r.openStart("div");r.attr("role","listitem");r.class("sapUiCalendarAppContainer");if(i){r.class("sapUiCalendarAppCurrent");}r.openEnd();r.openStart("div");r.class("sapUiCalendarAppContainerLeft");r.openEnd();r.openStart("div");r.class("sapUiCalendarAppStart");r.openEnd();r.text(A._getDateRangeIntersectionText(s).start);r.close("div");r.openStart("div");r.class("sapUiCalendarAppEnd");r.openEnd();r.text(A._getDateRangeIntersectionText(s).end);r.close("div");r.close("div");r.openStart("div");r.class("sapUiCalendarAppContainerRight");r.openEnd();this._renderAppointment(r,o,A,s);r.close("div");c.renderAdditionalAriaLabel(r,o,A);r.close("div");};
c._renderAppointment=function(r,o,A,s){var i=A.getId();var t=A.getTitle();var T=A.getText();var d=A.getType();var e=A.getIcon();var S=!t||!T;r.openStart("div",A);r.class("sapUiCalendarApp");if(A.getClickable()){r.attr("tabindex","0");}else{r.class("sapUiCalendarAppDisabled");}r.accessibilityState(A,c.getAccProps(A));if(d&&d!=b.None){r.class("sapUiCalendarApp"+d);}if(S){r.class("sapUiCalendarAppOneLine");}r.openEnd();r.openStart("div");r.class("sapUiCalendarAppCont");r.openEnd();if(e){var f=["sapUiCalendarAppIcon"];var m={};m["id"]=i+"-Icon";m["title"]=null;r.icon(e,f,m);}r.openStart("div");r.class("sapUiCalendarAppTitleWrapper");r.openEnd();if(t){r.openStart("span",i+"-Title");r.class("sapUiCalendarAppTitle");r.openEnd();r.text(t);r.close("span");}if(T){r.openStart("span",i+"-Text");r.class("sapUiCalendarAppText");r.openEnd();r.text(T);r.close("span");}r.close("div");r.close("div");r.close("div");};
c.renderAdditionalAriaLabel=function(r,o,A){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),f=o._oFormatAria,t=A.getType(),l=o._oLegend?o._oLegend.getAppointmentItems():[];var s=R.getText("CALENDAR_START_TIME")+": "+f.format(A.getStartDate());s=s+"; "+R.getText("CALENDAR_END_TIME")+": "+f.format(A.getEndDate());if(t&&t!=b.None){s=s+"; "+this.getAriaTextForType(t,l);}r.openStart("span",A.getId()+"-Descr");r.class("sapUiInvisibleText");r.openEnd();r.text(s);r.close("span");};
c.getAriaTextForType=function(t,l){var T,s,o,i;if(l&&l.length){for(var i=0;i<l.length;i++){o=l[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=C.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
c.getAccProps=function(A){var i=A.getId();var m={labelledby:{value:a.getStaticId("sap.ui.unified","APPOINTMENT")+" "+i+"-Descr",append:true},selected:null};if(A.getTitle()){m["labelledby"].value=m["labelledby"].value+" "+i+"-Title";}if(A.getText()){m["labelledby"].value=m["labelledby"].value+" "+i+"-Text";}if(A.getSelected()){m["labelledby"].value=m["labelledby"].value+" "+a.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");}return m;};
return c;});
sap.ui.predefine('sap/ui/integration/cards/ComponentContent',["sap/ui/integration/cards/BaseContent","./ComponentContentRenderer","sap/ui/core/ComponentContainer","sap/ui/core/Component"],function(B,C,a,b){"use strict";
var c=B.extend("sap.ui.integration.cards.ComponentContent",{
metadata:{library:"sap.ui.integration"},
renderer:C
});
b._fnOnInstanceCreated=function(i){var o=i.getComponentData();if(o&&o["__sapUiIntegration_card"]&&i.onCardReady){i.onCardReady(o["__sapUiIntegration_card"]);}};
c.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return;}var d=new a({manifest:o.componentManifest,async:true,settings:{componentData:{"__sapUiIntegration_card":this.getCardInstance()}},componentCreated:function(){this.fireEvent("_actionContentReady");this.fireEvent("_updated");}.bind(this),componentFailed:function(){this.fireEvent("_actionContentReady");this.handleError("Card content failed to create component");}.bind(this)});this.setAggregation("_content",d);};
return c;});
sap.ui.predefine('sap/ui/integration/cards/ComponentContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var C=B.extend("sap.ui.integration.cards.ComponentContentRenderer",{apiVersion:2});
C.getMinHeight=function(c,o){if(c.minHeight){return c.minHeight;}return B.getMinHeight.apply(this,arguments);};
return C;});
sap.ui.predefine('sap/ui/integration/cards/Footer',["sap/ui/core/Control","sap/ui/core/Core","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver"],function(C,a,A,B,b){"use strict";
var F=C.extend("sap.ui.integration.cards.Footer",{
metadata:{properties:{configuration:{type:"object"}},aggregations:{actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:{apiVersion:2,render:function(r,f){r.openStart("div",f).class("sapFCardFooter");if(f.getCardInstance().isLoading()&&f._hasBinding()){r.class("sapFCardFooterLoading");}r.openEnd();r.renderControl(f.getActionsStrip());r.close("div");}}
});
F.prototype._hasBinding=function(){var c=B.createBindingInfos(this.getConfiguration(),this.getCardInstance().getBindingNamespaces());return c.actionsStrip.some(function(o){for(var k in o){if(b.isBindingInfo(o[k])){return true;}}return false;});};
F.prototype.getCardInstance=function(){return a.byId(this.getCard());};
F.create=function(c,o){if(!o.actionsStrip){return null;}return new F({configuration:o,card:c,actionsStrip:A.create(c,o.actionsStrip)});};
return F;});
sap.ui.predefine('sap/ui/integration/cards/Header',["sap/ui/core/Core","sap/base/util/isEmptyObject","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/LoadingProvider"],function(C,i,F,a,l,B,J,L){"use strict";var A=l.AvatarColor;
var H=F.extend("sap.ui.integration.cards.Header",{
constructor:function(c,o,I){c=c||{};this._bIsEmpty=i(c);var s={title:c.title,subtitle:c.subTitle,dataTimestamp:c.dataTimestamp};if(c.status&&c.status.text&&!c.status.text.format){s.statusText=c.status.text;}if(c.icon){s.iconSrc=c.icon.src;s.iconDisplayShape=c.icon.shape;s.iconInitials=c.icon.text;s.iconAlt=c.icon.alt;s.iconBackgroundColor=c.icon.backgroundColor||(c.icon.text?A.Accent6:A.Transparent);}if(s.iconSrc){s.iconSrc=B.formattedProperty(s.iconSrc,function(v){return I.formatSrc(v);});}s.toolbar=o;F.call(this,s);if(o){o.attachVisibilityChange(this._handleToolbarVisibilityChange.bind(this));}},
metadata:{library:"sap.ui.integration",aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:a
});
H.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new L());this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
H.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
H.prototype.isReady=function(){return this._bReady;};
H.prototype.isLoading=function(){var o=this.getAggregation("_loadingProvider"),c=this.getCardInstance(),b=c&&c.isA("sap.ui.integration.widgets.Card")?c.isLoading():false;return!o.isDataProviderJson()&&(o.getLoading()||b);};
H.prototype._handleError=function(s){this.fireEvent("_error",{logMessage:s});};
H.prototype._handleToolbarVisibilityChange=function(e){var t=e.getParameter("visible");if(this._bIsEmpty&&this.getVisible()!==t){this.setVisible(t);}};
H.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};
H.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
H.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
H.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),p="/",m;if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=c.getDataProviderFactory().create(d,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d&&d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new J();this.setModel(m);}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
H.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};
H.prototype.showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};
H.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false);};
H.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders();};
H.prototype.getCardInstance=function(){return C.byId(this.getCard());};
return H;});
sap.ui.predefine('sap/ui/integration/cards/ListContent',["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/m/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip"],function(B,L,o,l,a,O,b,c,M,d,e,A){"use strict";var f=l.AvatarSize;var g=l.AvatarColor;var h=l.ListType;var j=l.ListSeparators;var k=b.CardActionArea;var E=l.EmptyIndicatorMode;var m="_legendColorsLoad";
var n=B.extend("sap.ui.integration.cards.ListContent",{
metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},
renderer:L
});
n.prototype.init=function(){B.prototype.init.apply(this,arguments);var p=this._getList();var t=this;this.setAggregation("_content",p);p.attachUpdateFinished(function(){if(t._iVisibleItems){var I=p.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});};
n.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
n.prototype.loadDependencies=function(C){if(C.get("/sap.card/content/item/chart")){return M.loadDependencies();}return Promise.resolve();};
n.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};
n.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
n.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false});}return this._oList;};
n.prototype._setItem=function(i){var p=this._getList(),s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=f.S;}else{s.iconSize=f.XS;}s.iconSize=i.icon.size||s.iconSize;s.iconBackgroundColor=i.icon.backgroundColor||(i.icon.text?undefined:g.Transparent);}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType;}if(i.attributes){i.attributes.forEach(function(r){s.attributes.push(new O({text:r.value,state:r.state,emptyIndicatorMode:E.On}));});}if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}if(i.actionsStrip){s.actionsStrip=A.create(this.getCardInstance(),i.actionsStrip);p.setShowSeparators(j.All);}else{p.setShowSeparators(j.None);}this._oItemTemplate=new e(s);this._oActions.attach({area:k.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:h.Navigation,disabledPropertyValue:h.Inactive});var G=this.getConfiguration().group;if(G){this._oSorter=this._getGroupSorter(G);}var q={template:this._oItemTemplate,sorter:this._oSorter};this._filterHiddenNavigationItems(i,q);this._bindAggregationToControl("items",p,q);};
n.prototype._createChartAndAddLegend=function(C){var i=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var p=new d({chart:i.getChart(),colorsLoad:function(){this.fireEvent(m);}.bind(this)});p.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",p);this.awaitEvent(m);}return i;};
n.prototype._setStaticItems=function(i){var p=this._getList();i.forEach(function(I){var q=new e({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){q.setType("Navigation");if(I.action.url){q.attachPress(function(){o(I.action.url,I.target||"_blank");});}}p.addItem(q);});this.fireEvent("_actionContentReady");};
n.prototype.getInnerList=function(){return this._getList();};
return n;});
sap.ui.predefine('sap/ui/integration/cards/ListContentRenderer',["./BaseContentRenderer","../library"],function(B,l){"use strict";var A=l.AttributesLayoutType;
var L=B.extend("sap.ui.integration.cards.ListContentRenderer",{apiVersion:2});
L.renderContent=function(r,o){r.renderControl(o.getAggregation("_content"));if(o.getAggregation("_legend")){r.renderControl(o.getAggregation("_legend"));}};
L.getMinHeight=function(c,C){if(!c||!c.maxItems||!c.item){return this.DEFAULT_MIN_HEIGHT;}var i=this.getItemMinHeight(c,C),a=parseInt(c.maxItems)||0;return(a*i)+"rem";};
L.getItemMinHeight=function(c,C){if(!c||!c.item){return 0;}var i=this.isCompact(C),t=c.item,I=i?1:1.125,v=i?1:1.625,a;if(t.icon&&!t.description){v=i?0:0.75;I=2;}if(t.description){v=2;I+=i?2:1.875;}if(t.attributes){v=2.25;a=t.attributes.length/2;if(t.attributesLayoutType===A.OneColumn){a=t.attributes.length;}a=Math.ceil(a);I+=a*1.5;}if(t.chart){I+=1;}if(t.actionsStrip){v=1;I+=i?3:3.75;}I+=v;return I;};
return L;});
sap.ui.predefine('sap/ui/integration/cards/NumericHeader',["sap/ui/core/Core","sap/base/util/extend","sap/base/util/isEmptyObject","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/f/cards/NumericSideIndicator","sap/ui/model/json/JSONModel","sap/ui/integration/util/LoadingProvider"],function(C,e,i,F,a,N,J,L){"use strict";
var b=F.extend("sap.ui.integration.cards.NumericHeader",{
constructor:function(c,A){c=c||{};this._bIsEmpty=i(c);var s={title:c.title,subtitle:c.subTitle,dataTimestamp:c.dataTimestamp};if(c.status&&c.status.text&&!c.status.text.format){s.statusText=c.status.text;}e(s,{unitOfMeasurement:c.unitOfMeasurement,details:c.details,sideIndicatorsAlignment:c.sideIndicatorsAlignment});if(c.mainIndicator){s.number=c.mainIndicator.number;s.scale=c.mainIndicator.unit;s.trend=c.mainIndicator.trend;s.state=c.mainIndicator.state;}if(c.sideIndicators){s.sideIndicators=c.sideIndicators.map(function(I){return new N(I);});}s.toolbar=A;F.call(this,s);if(A){A.attachVisibilityChange(this._handleToolbarVisibilityChange.bind(this));}},
metadata:{library:"sap.ui.integration",aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:a
});
b.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new L());this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
b.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
b.prototype.isReady=function(){return this._bReady;};
b.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider"),c=this.getCardInstance(),d=c&&c.isA("sap.ui.integration.widgets.Card")?c.isLoading():false;return!l.isDataProviderJson()&&(l.getLoading()||d);};
b.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),p="/",m;if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=c.getDataProviderFactory().create(d,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d&&d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new J();this.setModel(m);}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(E){m.setData(E.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError(E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
b.prototype._handleToolbarVisibilityChange=function(E){var t=E.getParameter("visible");if(this._bIsEmpty&&this.getVisible()!==t){this.setVisible(t);}};
b.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};
b.prototype.showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};
b.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false);};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders();};
b.prototype.getCardInstance=function(){return C.byId(this.getCard());};
return b;});
sap.ui.predefine('sap/ui/integration/cards/ObjectContent',["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/base/Log","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/Utils"],function(l,B,L,H,V,T,a,A,b,c,d,R,e,f,g,U){"use strict";var h=L.AvatarSize;var i=L.AvatarColor;var F=L.FlexRendertype;var j=l.CardActionArea;
var O=B.extend("sap.ui.integration.cards.ObjectContent",{
metadata:{library:"sap.ui.integration"},
renderer:{apiVersion:2}
});
O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new e();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};
O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=f.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var k=Math.floor(E.size.width/M);if(k>n){k=n;}if(this._iColsOld===k){return;}this._iColsOld=k;var o=k-1,r=Math.ceil(n/k);C.getContent().forEach(function(I,p){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(o===p&&o<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");o+=k;}if(p+1>(r-1)*k){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};
O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};
O.prototype._addGroups=function(C){var o=this._getRootContainer(),G=C.groups||[];G.forEach(function(k){var v;if(typeof k.visible=="string"){v=!U.hasFalsyValueAsString(k.visible);}else{v=k.visible;}var m=new V({visible:v,renderType:F.Bare}).addStyleClass("sapFCardObjectGroup");if(k.title){m.addItem(new a({text:k.title}).addStyleClass("sapFCardObjectItemTitle"));m.addStyleClass("sapFCardObjectGroupWithTitle");}k.items.forEach(function(I){var n=I.label,p=I.value,q,v,r,s,t=[];if(typeof I.visible=="string"){v=!U.hasFalsyValueAsString(I.visible);}else{v=I.visible;}if(n){n=g.formattedProperty(n,function(y){return y&&y[y.length-1]===":"?y:y+":";});q=new c({text:n,visible:v}).addStyleClass("sapFCardObjectItemLabel");}if(p&&I.actions){r=new b({text:p,visible:g.reuse(v)});this._oActions.attach({area:j.ContentItemDetail,actions:I.actions,control:this,actionControl:r,enabledPropertyName:"enabled"});}if(p&&!I.actions&&I.type){d.warning("Usage of Object Group Item property 'type' is deprecated. Use Card Actions for navigation.",null,"sap.ui.integration.widgets.Card");switch(I.type){case'link':r=new b({href:I.url||p,text:p,target:I.target||'_blank',visible:g.reuse(v)});break;case'email':if(I.value){t.push(I.value);}if(I.emailSubject){t.push(I.emailSubject);}s=g.formattedProperty(t,function(y,E){if(E){return"mailto:"+y+"?subject="+E;}else{return"mailto:"+y;}});r=new b({href:s,text:p,visible:g.reuse(v)});break;case'phone':s=g.formattedProperty(p,function(y){return"tel:"+y;});r=new b({href:s,text:p,visible:g.reuse(v)});break;default:}}if(p&&!r){r=new T({text:p,visible:g.reuse(v)});}if(r){r.addStyleClass("sapFCardObjectItemText");}if(I.icon){var S=g.formattedProperty(I.icon.src,function(y){return this._oIconFormatter.formatSrc(y);}.bind(this));var u=new A({displaySize:I.icon.size||h.XS,src:S,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt,backgroundColor:I.icon.backgroundColor||(I.icon.text?undefined:i.Transparent)}).addStyleClass("sapFCardObjectItemAvatar sapFCardIcon");var w=new V({renderType:F.Bare,items:[q,r]});var x=new H({visible:v,renderType:F.Bare,items:[u,w]}).addStyleClass("sapFCardObjectItemLabel");m.addItem(x);}else{m.addItem(q);m.addItem(r);}},this);o.addContent(m);},this);this._oActions.attach({area:j.Content,actions:C.actions,control:this});};
return O;});
sap.ui.predefine('sap/ui/integration/cards/TableContent',["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/base/Log"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f,g){"use strict";var h=m.AvatarSize;var i=m.AvatarColor;var V=d.VerticalAlign;var k=m.ListSeparators;var n=m.ListType;var o=l.CardActionArea;
var p=B.extend("sap.ui.integration.cards.TableContent",{
metadata:{library:"sap.ui.integration"},
renderer:T
});
p.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
p.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:k.None});this.setAggregation("_content",t);}return t;};
p.prototype.setConfiguration=function(j){B.prototype.setConfiguration.apply(this,arguments);if(!j){return this;}if(j.rows&&j.columns){this._setStaticColumns(j.rows,j.columns);return this;}if(j.row&&j.row.columns){this._setColumns(j.row);}return this;};
p.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};
p.prototype._setColumns=function(r){var j=[],t=this._getTable(),q=r.columns;q.forEach(function(u){t.addColumn(new C({header:new b({text:u.title}),width:u.width,hAlign:u.hAlign,visible:u.visible}));j.push(this._createCell(u));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.attach({area:o.ContentItem,actions:r.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:n.Navigation,disabledPropertyValue:n.Inactive});var G=this.getConfiguration().group;if(G){this._oSorter=this._getGroupSorter(G);}var s={template:this._oItemTemplate,sorter:this._oSorter};this._filterHiddenNavigationItems(r,s);this._bindAggregationToControl("items",t,s);};
p.prototype._setStaticColumns=function(r,q){var t=this._getTable();q.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(s){var I=new a({vAlign:V.Middle});if(s.cells&&Array.isArray(s.cells)){for(var j=0;j<s.cells.length;j++){I.addCell(this._createCell(s.cells[j]));}}if(s.actions&&Array.isArray(s.actions)){this._oActions.attach({area:o.ContentItem,actions:s.actions,control:this,actionControl:I,enabledPropertyName:"type",enabledPropertyValue:n.Navigation,disabledPropertyValue:n.Inactive});}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};
p.prototype._createCell=function(j){var q;if(j.identifier){if(typeof j.identifier=="object"){if(!e.isBindingInfo(j.identifier)){g.warning("Usage of object type for column property 'identifier' is deprecated.",null,"sap.ui.integration.widgets.Card");}if(j.identifier.url){j.actions=[{type:"Navigation",parameters:{url:j.identifier.url,target:j.identifier.target}}];}}q=new O({title:j.value});if(j.actions){q.setTitleActive(true);this._oActions.attach({area:o.ContentItemDetail,actions:j.actions,control:this,actionControl:q,enabledPropertyName:"titleActive",eventName:"titlePress"});}return q;}if(j.url){g.warning("Usage of column property 'url' is deprecated. Use card actions for navigation.",null,"sap.ui.integration.widgets.Card");j.actions=[{type:"Navigation",parameters:{url:j.url,target:j.target}}];}if(j.actions){q=new L({text:j.value});this._oActions.attach({area:o.ContentItemDetail,actions:j.actions,control:this,actionControl:q,enabledPropertyName:"enabled"});return q;}if(j.state){return new c({text:j.value,state:j.state});}if(j.value){return new b({text:j.value});}if(j.icon){var s=f.formattedProperty(j.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));return new A({src:s,displayShape:j.icon.shape,displaySize:j.icon.size||h.XS,tooltip:j.icon.alt,initials:j.icon.text,backgroundColor:j.icon.backgroundColor||(j.icon.text?undefined:i.Transparent)}).addStyleClass("sapFCardIcon");}if(j.progressIndicator){return new P({percentValue:j.progressIndicator.percent,displayValue:j.progressIndicator.text,state:j.progressIndicator.state});}};
p.prototype.getInnerList=function(){return this._getTable();};
return p;});
sap.ui.predefine('sap/ui/integration/cards/TableContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TableContentRenderer",{apiVersion:2});
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems)||0,r=i?2:2.75,t=i?2:2.75;return(a*r+t)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContent',["./BaseListContent","./TimelineContentRenderer","sap/ui/integration/library","sap/m/library","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(B,T,l,L,C,a){"use strict";var A=l.CardActionArea;var b,c;
var d=B.extend("sap.ui.integration.cards.TimelineContent",{
metadata:{library:"sap.ui.integration"},
renderer:T
});
d.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null;}};
d.prototype.loadDependencies=function(o){return new Promise(function(r,e){C.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(_,f){b=_;c=f;r();},function(E){e(E);});}).catch(function(){e("Timeline content type is not available with this distribution.");});});};
d.prototype._getTimeline=function(){var t=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null;}if(!t){t=new b({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false});this.setAggregation("_content",t);}return t;};
d.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.items){this._setStaticItems(o.items);return this;}if(o.item){this._setItem(o.item);}return this;};
d.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
d.prototype._setItem=function(i){var s={userNameClickable:false,title:i.title&&i.title.value,text:i.description&&i.description.value,dateTime:i.dateTime&&i.dateTime.value,userName:i.owner&&i.owner.value,icon:i.icon&&i.icon.src};if(i.ownerImage&&i.ownerImage.value){s.userPicture=a.formattedProperty(i.ownerImage.value,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));}this._oTimeLineItemTemplate=new c(s);this._oActions.attach({area:A.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate});var o={template:this._oTimeLineItemTemplate};this._filterHiddenNavigationItems(i,o);this._bindAggregationToControl("content",this._getTimeline(),o);return this;};
d.prototype._setStaticItems=function(i){var t=this._getTimeline(),o;i.forEach(function(I){o=new c({title:I.title,text:I.description,userPicture:I.ownerImage,dateTime:I.dateTime,userName:I.owner,icon:I.icon});t.addContent(o);});};
d.prototype.getInnerList=function(){return this._getTimeline();};
return d;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TimelineContentRenderer",{apiVersion:2});
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}if(!c.maxItems){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems),I=i?4:5;return(a*I)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/WebPageContent',["./BaseContent","./WebPageContentRenderer","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(B,W,C,a){"use strict";var F="_frameLoaded";var L=15*1000;var r=C.getLibraryResourceBundle("sap.ui.integration");
var b=B.extend("sap.ui.integration.cards.WebPageContent",{
metadata:{properties:{minHeight:{type:"sap.ui.core.CSSSize",defaultValue:W.MIN_WEB_PAGE_CONTENT_HEIGHT,bindable:true},src:{type:"sap.ui.core.URI",defaultValue:"",bindable:true},sandbox:{type:"string",defaultValue:"",bindable:true}},library:"sap.ui.integration"},
renderer:W
});
b.prototype.init=function(){B.prototype.init.apply(this,arguments);this._onFrameLoadedBound=this._onFrameLoaded.bind(this);this._sPrevSrc=this.getSrc();};
b.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout);}};
b.prototype.onBeforeRendering=function(){B.prototype.onBeforeRendering.apply(this,arguments);if(this.getDomRef()){this.getDomRef("frame").removeEventListener("load",this._onFrameLoadedBound);}};
b.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.apply(this,arguments);this.getDomRef("frame").addEventListener("load",this._onFrameLoadedBound);this._checkSrc();};
b.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);this.fireEvent("_actionContentReady");if(!c){return this;}var s=a.formattedProperty(c.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));if(s){this.bindSrc(s);}if(typeof c.sandbox==="object"){this.bindSandbox(a.reuse(c.sandbox));}else{this.setSandbox(c.sandbox);}if(typeof c.minHeight==="object"){this.bindMinHeight(a.reuse(c.minHeight));}else{this.setMinHeight(c.minHeight);}return this;};
b.prototype._checkSrc=function(){var c=this.getSrc();if(c===""){this.handleError("Src of WebPage content is empty",r.getText("CARD_WEB_PAGE_EMPTY_URL_ERROR"));return;}if(!c.startsWith("https://")){this.handleError("Please use a secure URL (https://)",r.getText("CARD_WEB_PAGE_HTTPS_URL_ERROR"));return;}if(this._sPrevSrc!==c){this._raceFrameLoad();this._sPrevSrc=c;}};
b.prototype._raceFrameLoad=function(){this.awaitEvent(F);this._iLoadTimeout=setTimeout(function(){var s=L/1000;this.handleError("Failed to load '"+this.getSrc()+"' after "+s+" seconds.",r.getText("CARD_WEB_PAGE_TIMEOUT_ERROR",[s]));}.bind(this),L);};
b.prototype._onFrameLoaded=function(){this.fireEvent(F);clearTimeout(this._iLoadTimeout);};
return b;});
sap.ui.predefine('sap/ui/integration/cards/WebPageContentRenderer',["./BaseContentRenderer","sap/ui/integration/util/BindingResolver"],function(B,a){"use strict";var P="2px";
var W=B.extend("sap.ui.integration.cards.WebPageContentRenderer",{
apiVersion:2,
MIN_WEB_PAGE_CONTENT_HEIGHT:"150px"
});
W.renderContent=function(r,w){r.openStart("iframe",w.getId()+"-frame").class("sapUiIntWPCFrame");r.style("height","calc("+w.getMinHeight()+" - "+P+")").attr("src",w.getSrc()).attr("tabindex","0").attr("sandbox",w.getSandbox()).openEnd().close("iframe");};
W.getMinHeight=function(c,C){if(c.minHeight){return a.resolveValue(c.minHeight,C);}return W.MIN_WEB_PAGE_CONTENT_HEIGHT;};
return W;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ChoiceSetInput.apply(this,arguments);}
U.prototype=Object.create(A.ChoiceSetInput.prototype);
U.prototype.internalRender=function(){if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("ui5-select");this._selectElement.id=this.id;this._selectElement.addEventListener("change",function(){this.valueChanged();}.bind(this));for(var i=0;i<this.choices.length;i++){var o=document.createElement("ui5-option");o.value=this.choices[i].value;o.innerHTML=this.choices[i].title;if(this.choices[i].value===this.defaultValue){o.selected=true;}this._selectElement.appendChild(o);}return this._selectElement;}var r=document.createElement("div");r.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");r.id=this.id;r.addEventListener("select",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var j=0;j<this.choices.length;j++){var R=document.createElement("ui5-radiobutton");R.value=this.choices[j].value;R.text=this.choices[j].title;R.name=this.id;R.wrap=this.wrap;if(this.choices[j].value===this.defaultValue){R.selected=true;}this._toggleInputs.push(R);r.appendChild(R);}return r;}var d=this.defaultValue?this.defaultValue.split(","):null;var c=document.createElement("div");c.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");c.id=this.id;c.addEventListener("change",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var k=0;k<this.choices.length;k++){var C=document.createElement("ui5-checkbox");C.value=this.choices[k].value;C.text=this.choices[k].title;C.name=this.id;C.wrap=this.wrap;if(d&&d.indexOf(this.choices[k].value)>=0){C.checked=true;}this._toggleInputs.push(C);c.appendChild(C);}return c;};
Object.defineProperty(U.prototype,"value",{get:function v(){var i;if(!this.isMultiSelect){if(this.isCompact){return this._selectElement.selectedOption?this._selectElement.selectedOption.value:null;}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].selected){return this._toggleInputs[i].value;}}return null;}}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}var r="";for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].checked){if(r!==""){r+=this.hostConfig.choiceSetInputValueSeparator;}r+=this._toggleInputs[i].value;}}return r===""?null:r;}}});return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputDate',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.DateInput.apply(this,arguments);}
U.prototype=Object.create(A.DateInput.prototype);
U.prototype.internalRender=function(){this._dateInputElement=document.createElement("ui5-datepicker");this._dateInputElement.id=this.id;this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.formatPattern="yyyy-MM-dd";this._dateInputElement.value=this.defaultValue||"";this._dateInputElement.minDate=this.min||"";this._dateInputElement.maxDate=this.max||"";this._dateInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._dateInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.NumberInput.apply(this,arguments);}
U.prototype=Object.create(A.NumberInput.prototype);
U.prototype.internalRender=function(){this._numberInputElement=document.createElement("ui5-input");this._numberInputElement.type="Number";this._numberInputElement.id=this.id;this._numberInputElement.placeholder=this.placeholder||"";this._numberInputElement.value=this.defaultValue||"";this._numberInputElement.addEventListener("change",function(e){if(e.target.value>this.max){e.target.value=this.max;}if(e.target.value<this.min){e.target.value=this.min;}this.valueChanged();}.bind(this));return this._numberInputElement;};
Object.defineProperty(U.prototype,"value",{get:function(){return this._numberInputElement?this._numberInputElement.value:undefined;}});return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputText',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.TextInput.apply(this,arguments);}
U.prototype=Object.create(A.TextInput.prototype);
U.prototype.internalRender=function(){if(this.isMultiline){var t=document.createElement("ui5-textarea");t.id=this.id;t.placeholder=this.placeholder||"";t.value=this.defaultValue||"";t.maxlength=this.maxLength||null;t.addEventListener("change",function(){this.valueChanged();}.bind(this));return t;}var i=document.createElement("ui5-input");switch(this.style){case 1:i.type="Tel";break;case 2:i.type="URL";break;case 3:i.type="Email";break;default:i.type="Text";}i.id=this.id;i.placeholder=this.placeholder||"";i.value=this.defaultValue||"";i.maxlength=this.maxLength||null;i.addEventListener("change",function(){this.valueChanged();}.bind(this));return i;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputTime',["sap/ui/integration/thirdparty/adaptivecards","sap/ui/core/format/DateFormat"],function(A,D){"use strict";
function U(){A.TimeInput.apply(this,arguments);}
var V={None:"None",Error:"Error"};var t="HH:mm";U.prototype=Object.create(A.TimeInput.prototype);
U.prototype.internalRender=function(){var w="ui5-timepicker";this._timeInputElement=document.createElement(w);this._timeInputElement.id=this.id;this._timeInputElement.value=this.defaultValue||"";this._timeInputElement.formatPattern=t;this._handleMinMaxProps();this._validateInput(this.value);this._timeInputElement.addEventListener("change",function(e){this._validateInput(e.target.value);this.valueChanged();}.bind(this));return this._timeInputElement;};
U.prototype._validateInputRange=function(v){var a,i,b;if(!this._isMinValid&&!this._isMaxValid){this._setValueState(V.None);return;}a=v.split(":");i=a[0];b=a[1];if(this._isMinValid&&i<this._iMinHour||(i===this._iMinHour&&b<this._iMinMinute)){this._setValueState(V.Error);return;}if(this._isMaxValid&&i>this._iMaxHour||(i===this._iMaxHour&&b>this._iMaxMinute)){this._setValueState(V.Error);return;}this._setValueState(V.None);};
U.prototype._validateInput=function(v){if(v===""){this._setValueState(V.None);return;}this._isValidTime(v)?this._validateInputRange(v):this._setValueState(V.Error);};
U.prototype._handleMinMaxProps=function(){this._isMinValid=this.min&&this._isValidTime(this.min);this._isMaxValid=this.max&&this._isValidTime(this.max);if(this._isMinValid){this._aMinValue=this.min.split(":");this._iMinHour=Number(this._aMinValue[0]);this._iMinMinute=Number(this._aMinValue[1]);}if(this._isMaxValid){this._aMaxValue=this.max.split(":");this._iMaxHour=Number(this._aMaxValue[0]);this._iMaxMinute=Number(this._aMaxValue[1]);}if(!this._isMinValid||!this._isMaxValid){return;}if(this._iMinHour>this._iMaxHour||(this._iMinHour===this._iMaxHour&&this._iMinMinute>this._iMaxMinute||this._iMinMinute===this._iMaxMinute)){this._setValueState(V.Error);}else{this._setValueState(V.None);}};
U.prototype._setValueState=function(T){this._timeInputElement.valueState=T;};
U.prototype._setValueStateMessage=function(m){this._timeInputElement.valueStateMessage=m;};
U.prototype._isValidTime=function(v){var T=D.getTimeInstance({pattern:t});return v&&T.parse(v);};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ToggleInput.apply(this,arguments);}
U.prototype=Object.create(A.ToggleInput.prototype);
U.prototype.internalRender=function(){this._checkboxInputElement=document.createElement("ui5-checkbox");this._checkboxInputElement.id=this.id;this._checkboxInputElement.text=this.title||"";this._checkboxInputElement.wrap=this.wrap;this._checkboxInputElement.checked=false;if(this.defaultValue===this.valueOn){this._checkboxInputElement.checked=true;}this._checkboxInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._checkboxInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/hostConfig',["sap/ui/core/theming/Parameters"],function(P){"use strict";return function(){return{"spacing":{"small":8,"default":16,"medium":32,"large":48,"extraLarge":48,"padding":16},"separator":{"lineThickness":1,"lineColor":P.get("sapUiToolbarSeparatorColor")},"supportsInteractivity":true,"fontTypes":{"default":{"fontFamily":P.get("sapUiFontFamily"),"fontSizes":{"small":12,"default":14,"medium":14,"large":16,"extraLarge":20}},"monospace":{}},"containerStyles":{"default":{"backgroundColor":"transparent","foregroundColors":{"default":{"default":P.get("sapUiBaseText"),"subtle":P.get("sapUiContentLabelColor")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"emphasis":{"backgroundColor":P.get("sapUiNeutralBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"accent":{"backgroundColor":P.get("sapUiInformationBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"good":{"backgroundColor":P.get("sapUiSuccessBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"attention":{"backgroundColor":P.get("sapUiErrorBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"warning":{"backgroundColor":P.get("sapUiWarningBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}}}};};});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/overwrites/ActionRender',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";return function(b){if(b===0){b="ac-pushButton";}var h=this.parent.hostConfig;var a=document.createElement("ui5-button");this.addCssClasses(a);a.setAttribute("aria-label",this.title);a.type="button";a.style.display="flex";a.style.alignItems="center";a.style.justifyContent="center";var c=this.title;var t=document.createElement("div");t.style.overflow="hidden";t.style.textOverflow="ellipsis";if(!(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle||h.actions.allowTitleToWrap)){t.style.whiteSpace="nowrap";}if(c){t.innerText=this.title;}if(!this.iconUrl){a.classList.add("noIcon");a.appendChild(t);}else{var i=document.createElement("img");i.src=this.iconUrl;i.style.width=h.actions.iconSize+"px";i.style.height=h.actions.iconSize+"px";i.style.flex="0 0 auto";if(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle){a.classList.add("iconAbove");a.style.flexDirection="column";if(c){i.style.marginBottom="4px";}}else{a.classList.add("iconLeft");if(c){i.style.marginRight="4px";}}a.appendChild(i);a.appendChild(t);}this._renderedElement=a;};});
sap.ui.predefine('sap/ui/integration/cards/filters/BaseFilter',["sap/ui/core/Control","sap/ui/core/Core","sap/base/Log","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider"],function(C,a,L,I,H,T,O,b){"use strict";
var B=C.extend("sap.ui.integration.cards.filters.BaseFilter",{
metadata:{"abstract":true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:{apiVersion:2,render:function(r,f){var l=f.isLoading();r.openStart("div",f).class("sapFCardFilter");if(l){r.class("sapFCardFilterLoading");}r.openEnd();if(f._hasError()){r.renderControl(f._getErrorMessage());}else{r.renderControl(f.getField());}r.close("div");}}
});
B.prototype.init=function(){this.setAggregation("_loadingProvider",new b());this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready");});};
B.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}};
B.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider");return!l.isDataProviderJson()&&l.getLoading();};
B.prototype.getField=function(){return null;};
B.prototype.showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};
B.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false);};
B.prototype.onDataChanged=function(){};
B.prototype.getValueForModel=function(){};
B.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};
B.prototype.getCardInstance=function(){return a.byId(this.getCard());};
B.prototype._hasError=function(){return!!this._bError;};
B.prototype._getErrorMessage=function(){var m="Unable to load the filter.";return new H({justifyContent:"Center",alignItems:"Center",items:[new I({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:m})]});};
B.prototype._handleError=function(l){L.error(l);this._bError=true;this.invalidate();};
B.prototype._onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders();};
B.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),m;if(!d){this.fireEvent("_dataReady");return;}if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=c.getDataProviderFactory().create(d,null,true);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new O();this.setModel(m);}m.attachEvent("change",function(){this.onDataChanged();}.bind(this));this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this._onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();};
return B;});
sap.ui.predefine('sap/ui/integration/cards/filters/DateRangeFilter',["./BaseFilter","sap/ui/core/library","sap/m/DynamicDateRange","sap/m/DynamicDateUtil"],function(B,c,D,a){"use strict";var V=c.ValueState;var M=new Date(-8640000000000000);var b=new Date("1753-01-01");var d=new Date(8640000000000000);var e=new Date("9999-12-31");
function o(O){var m={"DATE":"date","TODAY":"today","YESTERDAY":"yesterday","TOMORROW":"tomorrow","DATERANGE":"dateRange","FROM":"from","TO":"to","YEARTODATE":"yearToDate","LASTDAYS":"lastDays","LASTWEEKS":"lastWeeks","LASTMONTHS":"lastMonths","LASTQUARTERS":"lastQuarters","LASTYEARS":"lastYears","NEXTDAYS":"nextDays","NEXTWEEKS":"nextWeeks","NEXTMONTHS":"nextMonths","NEXTQUARTERS":"nextQuarters","NEXTYEARS":"nextYears","TODAYFROMTO":"todayFromTo","THISWEEK":"thisWeek","LASTWEEK":"lastWeek","NEXTWEEK":"nextWeek","SPECIFICMONTH":"specificMonth","THISMONTH":"thisMonth","LASTMONTH":"lastMonth","NEXTMONTH":"nextMonth","THISQUARTER":"thisQuarter","LASTQUARTER":"lastQuarter","NEXTQUARTER":"nextQuarter","QUARTER1":"quarter1","QUARTER2":"quarter2","QUARTER3":"quarter3","QUARTER4":"quarter4","THISYEAR":"thisYear","LASTYEAR":"lastYear","NEXTYEAR":"nextYear"};return m[O];}
var f=B.extend("sap.ui.integration.cards.filters.DateRangeFilter",{
metadata:{library:"sap.ui.integration",aggregations:{_ddr:{type:"sap.m.DynamicDateRange",multiple:false,visibility:"hidden"}}},
renderer:{apiVersion:2}
});
f.prototype.getField=function(){return this._getDdr();};
f.prototype.getValueForModel=function(){var g=this._getDdr().getValue();var v;var r;var R;if(g){v=Object.assign({},g);var h=a.toDates(v),s=h[0].getJSDate?h[0].getJSDate():h[0],E=h[1].getJSDate?h[1].getJSDate():h[1];r={start:s.toISOString(),end:E.toISOString()};R={start:s.toISOString(),end:E.toISOString()};if(v.operator==="TO"){r.start=M.toISOString();R.start=b.toISOString();}if(v.operator==="FROM"){r.end=d.toISOString();R.end=e.toISOString();}v.operator=o(v.operator);}return{value:v,range:r,rangeOData:R};};
f.prototype._getDdr=function(){var C=this.getAggregation("_ddr");if(!C){C=this._createDdr();this.setAggregation("_ddr",C);}return C;};
f.prototype._createDdr=function(){var C=Object.assign({},this.getConfig());var v;if(C.value){var O=C.value.operator.toUpperCase();var t=a.getOption(O).getValueTypes();v={operator:O,values:C.value.values.map(function(h,i){if(t[i]==="date"){return new Date(h);}return h;})};}C.options=C.options||this._getDefaultOptions();C.options=C.options.map(function(O){return O.toUpperCase();});var g=new D({value:v,options:C.options});g.attachChange(function(E){if(E.getParameter("valid")){g.setValueState(V.None);this.setValue(this.getValueForModel());}else{g.setValueState(V.Error);}}.bind(this));return g;};
f.prototype._getDefaultOptions=function(){return["date","today","dateRange","from","to","lastDays","nextDays","lastWeeks","nextWeeks"];};
return f;});
sap.ui.predefine('sap/ui/integration/cards/filters/FilterBarFactory',["./SelectFilter","./DateRangeFilter","sap/ui/base/Object","sap/m/library","sap/m/HBox"],function(S,D,B,l,H){"use strict";var F=l.FlexWrap;var R=l.FlexRendertype;
var a=B.extend("sap.ui.integration.util.FilterBarFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(c){B.call(this);this._oCard=c;}
});
a.prototype.create=function(f,m){var b=[],r=[],c,k,o,d,e=null;for(k in f){c=f[k];e=this._getClass(c.type);o=new e({card:this._oCard,key:k,config:c,value:{model:"filters",path:"/"+k}});m.setProperty("/"+k,o.getValueForModel());this._awaitEvent(r,o,"_ready");o._setDataConfiguration(c.data);b.push(o);}if(!b.length){return null;}for(var i=0;i<b.length-1;i++){b[i].addStyleClass("sapUiTinyMarginEnd");}d=new H({wrap:F.Wrap,renderType:R.Bare,items:b});Promise.all(r).then(function(){d.fireEvent("_filterBarDataReady");});return d;};
a.prototype._awaitEvent=function(p,f,e){p.push(new Promise(function(r){f.attachEventOnce(e,function(){r();});}));};
a.prototype._getClass=function(t){t=t||"select";switch(t.toLowerCase()){case"string":case"integer":case"select":return S;case"daterange":return D;default:return undefined;}};
return a;});
sap.ui.predefine('sap/ui/integration/cards/filters/SelectFilter',["./BaseFilter","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel"],function(B,S,L,J){"use strict";
var a=B.extend("sap.ui.integration.cards.filters.SelectFilter",{
metadata:{library:"sap.ui.integration",aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},
renderer:{apiVersion:2}
});
a.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();}};
a.prototype.getField=function(){return this._getSelect();};
a.prototype.onDataChanged=function(){var s=this._getSelect();s.setSelectedKey(this.getValue().value);};
a.prototype.getValueForModel=function(){var s=this._getSelect().getSelectedItem();if(s){return{value:s.getKey(),selectedItem:{title:s.getText(),key:s.getKey()}};}return{value:this.getConfig().value};};
a.prototype._getSelect=function(){var c=this.getAggregation("_select");if(!c){c=this._createSelect();this.setAggregation("_select",c);}return c;};
a.prototype._createSelect=function(){var s=new S(),i,I,b="/",c=this.getConfig();s.attachChange(function(e){this.setValue(this.getValueForModel());var m="/sap.card/configuration/filters/"+this.getKey()+"/value",p={};p[m]=e.getParameter("selectedItem").getKey();this.getCardInstance()._fireConfigurationChange(p);}.bind(this));if(c&&c.item){b=c.item.path||b;}if(c&&c.item&&c.item.template){i=c.item.template.key;I=c.item.template.title;}if(c&&c.items){i="{key}";I="{title}";this.setModel(new J(c.items));}this._oItemTemplate=new L({key:i,text:I});s.bindItems({path:b,template:this._oItemTemplate});s.setSelectedKey(c.value);return s;};
return a;});
sap.ui.predefine('sap/ui/integration/controls/ActionsStrip',["../library","sap/m/library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/CardActions","sap/ui/integration/util/BindingHelper","sap/m/Button","sap/m/OverflowToolbarButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer"],function(l,L,C,a,b,B,c,O,d,e,T){"use strict";var f=L.ToolbarStyle;var A=l.CardActionArea;
var g=a.extend("sap.ui.integration.controls.ActionsStrip",{
metadata:{library:"sap.ui.integration",properties:{},aggregations:{_toolbar:{type:"sap.m.OverflowToolbar",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o).class("sapUiIntActionsStrip").openEnd();r.renderControl(o._getToolbar());r.close("div");}}
});
g.prototype._getToolbar=function(){var t=this.getAggregation("_toolbar");if(!t){t=new d({style:f.Clear});this.setAggregation("_toolbar",t);}return t;};
g.prototype._initButtons=function(h){if(!h||!h.length){return null;}var t=this._getToolbar(),o=C.byId(this.getCard()),i=new b({card:o}),H=false;h=B.createBindingInfos(h,o.getBindingNamespaces());h.forEach(function(m){if(m.type==="ToolbarSpacer"){H=true;t.addContent(new T());return;}var j=m.actions,k=new e({group:m.overflowGroup,priority:m.overflowPriority}),n;if(m.icon){n=new O({icon:m.icon,text:m.text||m.tooltip,tooltip:m.tooltip||m.text,type:m.buttonType,ariaHasPopup:m.ariaHasPopup,visible:m.visible});}else{n=new c({text:m.text,tooltip:m.tooltip,type:m.buttonType,ariaHasPopup:m.ariaHasPopup,visible:m.visible});}n.setLayoutData(k);i.attach({area:A.ActionsStrip,control:n,actions:j,enabledPropertyName:"enabled"});t.addContent(n);});if(!H){t.insertContent(new T(),0);}};
g.create=function(o,h){var i=new g({card:o});i._initButtons(h);return i;};
return g;});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbar',["./ActionsToolbarRenderer","sap/base/strings/capitalize","sap/ui/core/Control","sap/m/library","sap/ui/core/library","sap/m/Button","sap/m/ActionSheet","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/ui/integration/util/CardActions"],function(A,c,C,l,a,B,b,M,d,e){"use strict";var f=l.ButtonType;var H=a.aria.HasPopup;
function s(o,p,v,h){return new Promise(function(r){var R;if(typeof v==="function"){R=v(h);if(R instanceof Promise){R.then(function(i){o.setProperty(p,i);r();});return;}}else{R=v;}o.setProperty(p,R);r();});}
var g=C.extend("sap.ui.integration.controls.ActionsToolbar",{
metadata:{library:"sap.ui.integration",properties:{},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true},_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"}},events:{visibilityChange:{parameters:{visible:{type:"boolean"}}}}},
renderer:A
});
g.prototype.init=function(){this.setAggregation("_actionSheet",new b());this._aActions=[];this._mActionObservers=new Map();this._oObserver=new M(this._observeActionsAggregation.bind(this));this._oObserver.observe(this,{aggregations:["actionDefinitions"]});};
g.prototype.exit=function(){this._oCard=null;this._aActions=null;this._oObserver.disconnect();this._oObserver=null;this._mActionObservers.clear();this._mActionObservers=null;};
g.prototype.onBeforeRendering=function(){this._updateVisibility();};
g.prototype.initializeContent=function(o){var t=this,h,i=[],j=[],k=this.getAggregation("_actionSheet"),m=o.getHostInstance(),E=o.getAggregation("_extension");if(m){j=j.concat(m.getActions()||[]);}if(E){j=j.concat(E.getActions()||[]);}this._aActions=j;j.forEach(function(n){h=t._createActionButton(n,false);i.push(h);});if(this._aButtons){this._aButtons.forEach(function(n){n.destroy();});}i.forEach(k.addButton,k);this._aButtons=i;this._refreshButtons().then(this._updateVisibility.bind(this));};
g.prototype.setCard=function(o){this._oCard=o;};
g.prototype._open=function(){this._refreshButtons().then(function(){this.getAggregation("_actionSheet").openBy(this._getToolbar());}.bind(this));};
g.prototype._getToolbar=function(){var t=this.getAggregation('_toolbar');if(!t){t=new B({id:this.getId()+"-overflowButton",icon:'sap-icon://overflow',type:f.Transparent,ariaHasPopup:H.Menu,press:function(E){this._open();}.bind(this)});this.setAggregation('_toolbar',t);}return t;};
g.prototype._refreshButtons=function(){var h=this._aActions,o=this._oCard,j=this._aButtons,m,k,i,p=[];for(i=0;i<h.length;i++){m=h[i];k=j[i];p.push(s(k,'enabled',m.enabled,o));p.push(s(k,'visible',m.visible,o));}return Promise.all(p);};
g.prototype._createActionButton=function(v,i){var S=i?this._getActionConfig(v):v;var o=new B({icon:S.icon,text:S.text,tooltip:S.tooltip,type:S.buttonType,visible:i?S.visible:false,press:function(E){var m=i?this._getActionConfig(v):v;e.fireAction({card:this._oCard,host:this._oCard.getHostInstance(),action:m,parameters:m.parameters,source:E.getSource(),url:m.url});}.bind(this)});if(i){o.setEnabled(S.enabled);}return o;};
g.prototype._updateVisibility=function(){var v=this.getAggregation("_actionSheet").getButtons().some(function(o){return o.getVisible();});this.fireVisibilityChange({visible:v});this.setVisible(v);};
g.prototype._getActionConfig=function(o){var S=["visible","enabled","icon","text","tooltip","parameters","buttonType","type"].reduce(function(m,k){m[k]=o["get"+c(k)]();return m;},{});S.action=function(){o.firePress();};return S;};
g.prototype._observeActionsAggregation=function(o){var h=o.child;if(o.mutation==="insert"){var i=this._createActionButton(h,true);this.getAggregation("_actionSheet").addButton(i);h.setAssociation("_menuButton",i);var j=new M(this._observeSingleAction.bind(this));j.observe(h,{properties:true,aggregations:["tooltip"]});this._mActionObservers.set(h.getId(),j);this._updateVisibility();}else if(o.mutation==="remove"){d.byId(h.getAssociation("_menuButton")).destroy();this._mActionObservers.get(h.getId()).disconnect();this._mActionObservers.delete(h.getId());}};
g.prototype._observeSingleAction=function(o){var h=o.object,n=o.name,i=d.byId(h.getAssociation("_menuButton")),v=o.current;if(["type","parameters"].indexOf(n)!==-1){return;}if(o.type==="aggregation"){v=o.child;}if(n==="buttonType"){n="type";}i["set"+c(n)](v);this._updateVisibility();};
return g;});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbarRenderer',[],function(){"use strict";var A={apiVersion:2};
A.render=function(r,a){r.openStart("div",a).class("sapUiIntActionsToolbar").openEnd();r.renderControl(a._getToolbar());r.close("div");};
return A;},true);
sap.ui.predefine('sap/ui/integration/controls/ListContentItem',["sap/ui/integration/library","./ListContentItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/StandardListItem"],function(l,L,A,a,b,S){"use strict";var c=l.AttributesLayoutType;
var d=S.extend("sap.ui.integration.controls.ListContentItem",{
metadata:{library:"sap.ui.integration",properties:{iconAlt:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:a.Square},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:b.XS},iconBackgroundColor:{type:"sap.m.AvatarColor"},attributesLayoutType:{type:"sap.ui.integration.AttributesLayoutType",defaultValue:c.TwoColumns}},aggregations:{microchart:{type:"sap.ui.integration.controls.Microchart",multiple:false},actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},attributes:{type:"sap.m.ObjectStatus",multiple:true},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}},
renderer:L
});
d.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}o.setSrc(this.getIcon()).setDisplayShape(this.getIconDisplayShape()).setTooltip(this.getIconAlt()).setInitials(this.getIconInitials()).setDisplaySize(this.getIconSize()).setBackgroundColor(this.getIconBackgroundColor());return o;};
return d;});
sap.ui.predefine('sap/ui/integration/controls/ListContentItemRenderer',["sap/ui/integration/library","sap/ui/core/Renderer","sap/ui/core/Core","sap/ui/Device","sap/m/StandardListItemRenderer"],function(l,R,C,D,S){"use strict";var L=R.extend(S);L.apiVersion=2;var A=l.AttributesLayoutType;
L.renderLIAttributes=function(r,o){S.renderLIAttributes.apply(this,arguments);r.class("sapUiIntLCI");if(o.getIcon()){r.class("sapUiIntLCIIconSize"+o.getIconSize());}if(o.getMicrochart()){r.class("sapUiIntLCIWithChart");}if(o.getActionsStrip()){r.class("sapUiIntLCIWithActionsStrip");}if(o.getAttributes().length){r.class("sapUiIntLCIWithAttributes");}};
L.renderLIContent=function(r,o){var i=o.getInfo(),t=o.getTitle(),d=o.getDescription(),a=o.getAdaptTitleSize(),s=!t&&i;if(o.getIcon()||o.getIconInitials()){r.renderControl(o._getAvatar());}r.openStart("div").class("sapMSLIDiv");if((!d&&a&&i)||s){r.class("sapMSLIInfoMiddle");}r.openEnd();this.renderTitleWrapper(r,o);if(t&&d){this.renderDescription(r,o);}if(s&&!o.getWrapping()){this.renderInfo(r,o);}r.close("div");};
L.render=function(r,o){if(!o.getVisible()){this.renderInvisible(r,o);return;}this.openItemTag(r,o);r.class("sapMLIB");r.class("sapMLIB-CTX");r.class("sapMLIBShowSeparator");r.class("sapMLIBType"+o.getType());r.class("sapMLIB");if(D.system.desktop&&o.isActionable()){r.class("sapMLIBActionable");r.class("sapMLIBHoverable");}if(o.getSelected()){r.class("sapMLIBSelected");}if(o.getListProperty("showUnread")&&o.getUnread()){r.class("sapMLIBUnread");}this.addFocusableClasses(r,o);this.renderTooltip(r,o);this.renderTabIndex(r,o);if(C.getConfiguration().getAccessibility()){r.accessibilityState(o,this.getAccessibilityState(o));}this.renderLIAttributes(r,o);r.openEnd();this.renderContentFormer(r,o);this.renderLIContentWrapper(r,o);this.renderContentLatter(r,o);this.renderItemAttributes(r,o);this.renderFooter(r,o);this.closeItemTag(r,o);};
L.renderItemAttributes=function(r,o){var a=o.getAttributes(),s=o.getAttributesLayoutType(),b=a.length,i;if(!b){return;}r.openStart("div").class("sapUiIntLCIAttrs").openEnd();for(i=0;i<b;i++){r.openStart("div").class("sapUiIntLCIAttrRow").openEnd();r.openStart("span").class("sapUiIntLCIAttrCell").openEnd();r.renderControl(a[i]);r.close("span");if(s===A.TwoColumns){i++;if(a[i]){r.openStart("span").class("sapUiIntLCIAttrCell").class("sapUiIntLCIAttrSecondCell").openEnd();r.renderControl(a[i]);r.close("span");}}r.close("div");}r.close("div");};
L.renderFooter=function(r,o){var m=o.getMicrochart(),a=o.getActionsStrip();if(!m&&!a){return;}r.openStart("div").class("sapUiIntLCIFooter").openEnd();if(m){r.renderControl(m);}if(a){r.renderControl(a);}r.close("div");};
return L;},true);
sap.ui.predefine('sap/ui/integration/controls/Microchart',["sap/m/library","sap/ui/core/Control","sap/ui/core/Core"],function(l,C,a){"use strict";var B,b,S,c;var V=l.ValueColor;
var M=C.extend("sap.ui.integration.controls.Microchart",{
metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:V.Neutral}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(r,m){var v="sapUiIntMicrochartValue"+m.getValueColor();r.openStart("div",m).class("sapUiIntMicrochartChartWrapper").openEnd();r.openStart("div").class("sapUiIntMicrochartChart").openEnd().renderControl(m.getChart()).close("div");r.openStart("div").class("sapMSLIInfo").class(v).openEnd().text(m.getDisplayValue()).close("div");r.close("div");}}
});
M.loadDependencies=function(){return new Promise(function(r,d){a.loadLibrary("sap.suite.ui.microchart",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar"],function(_,e,f,g){B=_;b=e;S=f;c=g;r();},function(e){d(e);});}).catch(function(){d("The usage of Microcharts is not available with this distribution.");});});};
M.create=function(o){var m,d;if(o.type==="Bullet"){var t=[];if(o.thresholds){t=o.thresholds.map(function(T){return new b({value:T.value,color:T.color});});}d=new B({size:"Responsive",minValue:o.minValue,maxValue:o.maxValue,targetValue:o.target,showTargetValue:!!o.target,scaleColor:"Light",scale:o.scale,actual:new b({value:o.value,color:o.color}),thresholds:t});m=new M({valueColor:o.color,displayValue:o.displayValue,chart:d});}if(o.type==="StackedBar"){var e=o.bars.map(function(f){return new c({value:f.value,displayValue:f.displayValue,valueColor:f.color});});d=new S({size:"Responsive",bars:e,maxValue:o.maxValue});m=new M({displayValue:o.displayValue,chart:d});}return m;};
return M;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegend',["./MicrochartLegendRenderer","sap/m/Text","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/theming/Parameters","sap/ui/integration/util/BindingHelper"],function(M,T,C,a,P,B){"use strict";
var b=C.extend("sap.ui.integration.controls.MicrochartLegend",{
metadata:{library:"sap.ui.integration",aggregations:{_titles:{type:"sap.m.Text",multiple:true,visibility:"hidden"}},associations:{chart:{type:"sap.ui.core.Control",multiple:false}},events:{colorsLoad:{}}},
renderer:M
});
b.prototype.onBeforeRendering=function(){this._mLegendColors={};this._loadLegendColors();};
b.prototype.onAfterRendering=function(){this._equalizeWidths();};
b.prototype._equalizeWidths=function(){var $=this.$().children(".sapUiIntMicrochartLegendItem"),m=0;$.css("width","");$.each(function(){var c=this.getBoundingClientRect().width;if(c>m){m=c;}});$.css("min-width",m+"px");};
b.prototype.initItemsTitles=function(c,p){this.destroyAggregation("_titles");c.forEach(function(o,i){var d=B.prependRelativePaths(o.legendTitle,p+"/"+i);var t=new T({text:d});t.addEventDelegate({onAfterRendering:this._equalizeWidths},this);this.addAggregation("_titles",t);}.bind(this));};
b.prototype._loadLegendColors=function(){var c=a.byId(this.getChart()),n=[],p;if(c){n=c._calculateChartData().map(function(d){return d.color;}).filter(function(s){return s.startsWith("sapUi");});}if(n.length>0){p=P.get({name:n,callback:function(_){this._handleColorsLoad(n,_);}.bind(this)});}if(this._mLegendColors!==undefined){this._handleColorsLoad(n,p);}};
b.prototype._handleColorsLoad=function(n,p){if(typeof p==="string"){this._mLegendColors={};this._mLegendColors[n[0]]=p;}else if(p){this._mLegendColors=p;}this.fireColorsLoad();};
return b;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegendRenderer',["sap/m/library","sap/ui/core/Core"],function(l,C){"use strict";var V=l.ValueColor;var M={apiVersion:2};
M.render=function(r,m){var c=C.byId(m.getChart()),L=[],t=m.getAggregation("_titles");if(c){L=c._calculateChartData().map(function(d){return d.color;});}r.openStart("div",m).class("sapUiIntMicrochartLegend").openEnd();L.forEach(function(s,i){r.openStart("div").class("sapUiIntMicrochartLegendItem").openEnd();r.openStart("div");M.addColor(r,m,s);r.openEnd().close("div");r.renderControl(t[i]);r.close("div");});r.close("div");};
M.addColor=function(r,m,c){if(V[c]){r.class("sapUiIntMicrochartLegendItem"+c);}else{var s=m._mLegendColors[c]||c;r.style("background",s);}};
return M;},true);
sap.ui.predefine('sap/ui/integration/customElements/CustomElementBase',["sap/base/Log","sap/ui/integration/util/Utils","sap/base/strings/hyphenate","sap/base/strings/camelize"],function(L,U,h,c){"use strict";
function C(){if(this.constructor===C){throw new TypeError('Abstract class "CustomElementBase" cannot be instantiated directly.');}return Reflect.construct(HTMLElement,[],this.constructor);}
C.prototype=Object.create(HTMLElement.prototype);C.prototype.constructor=C;
C.prototype.connectedCallback=function(){this._init();this._upgradeAllProperties();this._oControlInstance.placeAt(this.firstElementChild);this._attachEventListeners();};
C.prototype.disconnectedCallback=function(){if(this._oControlInstance){this._oControlInstance.destroy();delete this._oControlInstance;}if(this.firstElementChild){this.removeChild(this.firstElementChild);}};
C.prototype.attributeChangedCallback=function(a,o,n){this._init();var s=c(a);if(U.isJson(n)){n=JSON.parse(n);}if(this._mAllProperties[s]){this._mAllProperties[s].set(this._oControlInstance,n);}else if(this._mAllAssociations[s]){var e=document.getElementById(n);if(e instanceof C){n=document.getElementById(n)._getControl();}this._mAllAssociations[s].set(this._oControlInstance,n);}};
C.prototype._init=function(){if(!this._oControlInstance){this._oControlInstance=new this._ControlClass();}if(!this.firstElementChild){var u=document.createElement("div");this.appendChild(u);}};
C.prototype._getControl=function(){this._init();return this._oControlInstance;};
C.prototype._attachEventListeners=function(){Object.keys(this._oMetadata.getEvents()).map(function(e){this._oControlInstance.attachEvent(e,function(E){this.dispatchEvent(new CustomEvent(e,{detail:E,bubbles:true}));},this);}.bind(this));};
C.prototype._upgradeAllProperties=function(){this._aAllProperties.forEach(this._upgradeProperty.bind(this));};
C.prototype._upgradeProperty=function(p){if(this[p]){var v=this[p];delete this[p];this[p]=v;}};
C.generateAccessors=function(p,P){P.forEach(function(s){Object.defineProperty(p,s,{get:function(){return this.getAttribute(h(s));},set:function(v){if(typeof v==="object"){v=JSON.stringify(v);}this.setAttribute(h(s),v);}});});};
C.define=function(s,a,d){d=d||[];C.awaitDependencies(d).then(function(){window.customElements.define(s,a);});};
C.awaitDependencies=function(d){var p=d.map(function(s){return window.customElements.whenDefined(s);});return Promise.all(p);};
C.extend=function(a,s){function b(){return C.apply(this,arguments);}b.prototype=Object.create(C.prototype);b.prototype.constructor=b;var p=b.prototype,k="";p._ControlClass=a;p._oMetadata=a.getMetadata();p._mAllAssociations=p._oMetadata.getAllAssociations();p._mAllProperties=p._oMetadata.getAllProperties();p._aAllProperties=[];if(s&&s.customProperties){p._mAllProperties=Object.assign(p._mAllProperties,s.customProperties);}for(k in p._mAllProperties){if(s&&s.privateProperties&&s.privateProperties.indexOf(k)!==-1){continue;}p._aAllProperties.push(k);}for(k in p._mAllAssociations){p._aAllProperties.push(k);}Object.defineProperty(b,"observedAttributes",{get:function(){var A=p._aAllProperties.map(h);return A;}});C.generateAccessors(p,p._aAllProperties);return b;};
return C;});
sap.ui.predefine('sap/ui/integration/editor/Editor',["ui5loader","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/Title","sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/thirdparty/URI","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/base/util/includes","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(u,C,c,M,d,f,g,I,D,J,U,h,p,L,T,P,H,V,q,R,r,t,v,w,x,y,A,B,E,O,F,G,S,K,N,Q,W,X,Y,Z,$){"use strict";var _=r.prototype.init;
r.prototype.init=function(){_.apply(this,arguments);var a=this.oPopup._applyPosition,b=this;this.oPopup._applyPosition=function(){var e=b.close;b.close=function(){};a.apply(this,arguments);b.close=e;};};
function a1(s){if(s&&s.nodeType!==1){return 0;}var z=parseInt(window.getComputedStyle(s).getPropertyValue('z-index'));if(isNaN(z)){return a1(s.parentNode);}return z+1;}
var b1=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,c1=/\{\{parameters\.([^\}\}]+)/g,d1=5000,e1=c.getLibraryResourceBundle("sap.ui.integration"),f1="__strip0";
var g1=C.extend("sap.ui.integration.editor.Editor",{
metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{ready:{},manifestReady:{}}},
renderer:function(o,a){var b=a.getAggregation("_preview");var s=a.getMode()!=="translation"&&a.hasPreview();var e=a.getPreviewPosition();if(s&&(e==="top"||e==="bottom")){o.openStart("div");o.writeElementData(a);o.openEnd();if(a.isReady()&&e==="top"){o.renderControl(b);o.close("div");}}o.openStart("div");o.addClass("sapUiIntegrationEditor");if(s&&e==="left"){o.writeElementData(a);o.openEnd();if(a.isReady()){o.renderControl(b);o.close("div");}}else if(s&&(e==="bottom"||e==="top")){o.openEnd();}else{o.writeElementData(a);o.openEnd();}if(a.isReady()){o.openStart("div");o.addClass("sapUiIntegrationEditorForm");if(a.getMode()!=="translation"){o.addClass("settingsButtonSpace");}o.writeClasses();o.openEnd();if(a.getMode()!=="translation"){o.renderControl(a.getAggregation("_messageStrip"));}var j=a.getAggregation("_formContent");if(j){var k;var l;var m;var z=[];var h1;var i1=function(){if(z.length>0){var C1=2-z.length;for(var n=0;n<C1;n++){z.push(new V());}k.addContent(new Z({alignItems:"Start",justifyContent:"SpaceBetween",items:z}));z=[];}};for(var i=0;i<j.length;i++){var j1=j[i];if(a.getMode()!=="translation"){if(j1.isA("sap.m.Panel")){if(k){i1();if(k.getContent().length>0){o.renderControl(k);}}k=j1;k.addStyleClass("sapUiIntegrationEditorItem");if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}continue;}if(j1.isA("sap.m.FormattedText")){k.addContent(j1.addStyleClass("sapUiIntegrationEditorHint"));if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}continue;}var k1=j1._layout;if(j1.isA("sap.m.Label")){j1.addStyleClass("sapUiIntegrationEditorItemLabel");if(k1&&!f(k1,{})){if(k1.alignment&&k1.alignment.label==="end"){j1.setTextAlign("End");}m=j1;}else{if(j1._cols===2||(j1._cols===1&&z.length===2)){i1();}k.addContent(j1);}}else if(j1.isA("sap.m.ToolbarSpacer")){i1();if(j1._hasLine){j1.addStyleClass("sapUiIntegrationEditorSpacerWithLine");}else{j1.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine");}k.addContent(j1);}else{var l1=j1.getConfiguration(),m1=new H(),n1=0.1,o1=0,p1;if(j1._descriptionIcon){m1.addItem(j1._descriptionIcon);n1+=0.9;}var q1=c.byId(j1.getAssociation("_messageIcon"));if(j1.getAssociation("_messageIcon")&&q1){m1.addItem(q1);n1+=1.2;}if(j1._settingsButton){j1._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");o1=2;}var r1=new Y({growFactor:10,maxWidth:"calc(100% - "+o1+"rem)"});var s1=new Y({maxWidth:"calc(100% - "+n1+"rem)"});if(m){var t1,u1,v1="50%";if(k1&&k1["label-width"]){v1=k1["label-width"];}var w1=parseInt(v1);var x1=100-w1;if(j1._cols===2){w1=w1-0.5;x1=x1-0.5;}if(k1.alignment&&k1.alignment.field==="end"){j1.addStyleClass("sapUiIntegrationEditorFieldAlignEnd");}if(k1.alignment&&k1.alignment.label==="end"){m.setLayoutData(new Y({maxWidth:"calc(100% - "+n1+"rem)",minWidth:"calc(100% - "+n1+"rem)"}));}else{m.setLayoutData(s1);}if(m1.getItems().length>0){m.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");p1=new H({items:[m,m1]});}else{p1=m;}if(k1&&k1.position&&k1.position==="field-label"){p1.setLayoutData(r1);u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,j1._settingsButton]});u1.setLayoutData(new Y({growFactor:w1,maxWidth:w1+"%"}));j1.setLayoutData(new Y({growFactor:x1,maxWidth:x1+"%"}));t1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[j1,u1]});}else{j1.setLayoutData(r1);u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[j1,j1._settingsButton]});p1.setLayoutData(new Y({growFactor:w1,maxWidth:w1+"%"}));u1.setLayoutData(new Y({growFactor:x1,maxWidth:x1+"%"}));t1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,u1]});}if(j1._cols===1){if(z.length===2){i1();}if(l1.hint){var y1=a._createHint(l1.hint);var z1=new V({items:[t1,y1.addStyleClass("sapUiIntegrationEditorHint")]});z1.addStyleClass("col1");z.push(z1);}else{t1.addStyleClass("col1");z.push(t1);}}else{i1();k.addContent(t1);}m=null;}else{var A1=k.getContent().pop();A1.setLayoutData(s1);if(m1.getItems().length>0){A1.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");p1=new H({items:[A1,m1]});}else{p1=A1;}p1.setLayoutData(r1);var B1=new Z({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,j1._settingsButton]});if(j1._cols===1){var z1=new V({items:[B1,j1]});if(l1.hint){var y1=a._createHint(l1.hint);z1.addItem(y1.addStyleClass("sapUiIntegrationEditorHint"));}z1.addStyleClass("col1");z.push(z1);}else{k.addContent(B1);k.addContent(j1);}}}if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}}else{if(i===0){l=j1;o.renderControl(l);l.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue;}if(j1.isA("sap.m.Panel")){if(k&&k.getContent().length>0){l.addContent(k);}k=j1;k.addStyleClass("sapUiIntegrationEditorTranslationSubPanel");continue;}if(j1.isA("sap.m.ToolbarSpacer")){continue;}if(j1.isA("sap.m.FormattedText")){continue;}if(j1.isA("sap.m.Label")){k.addContent(j1);continue;}if(j1.isOrigLangField){h1=j1;continue;}h1.addStyleClass("sapUiIntegrationFieldTranslationText");var t1=new H({items:[h1,j1]}).addStyleClass("notWrappingRow");k.addContent(t1);if(i===j.length-1){l.addContent(k);}}}}o.close("div");if(s&&e==="right"){o.renderControl(b);}}o.close("div");if(a.isReady()&&s&&e==="bottom"){o.renderControl(b);o.close("div");}}
});
g1.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};this.setAggregation("_messageStrip",new G({showIcon:false}));this._oLimitedInterface=new I(this,["getParameters","resolveDestination","request","getModel"]);};
g1.prototype.getParameters=function(){if(!this._isManifestReady){v.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}var o=this._oEditorManifest.getProcessedParameters(),a={},k;for(k in o){a[k]=o[k].value;}return a;};
g1.prototype.resolveDestination=function(k){return this._oDestinations.getUrl(k);};
g1.prototype.isReady=function(){return this._ready;};
g1.prototype.hasPreview=function(){var o=this.getAggregation("_preview");if(o&&o.visible!==false){return true;}return false;};
g1.prototype.flattenData=function(o,s,a,b){b=b||"";a=a||[];if(typeof o==="object"){if(!o[s]){for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}else{if(o.type){a.push({path:o.pathvalue||b.substring(1),value:o.pathvalue||"{context>"+b.substring(1)+"/value}",object:o});}else{a.push({path:b.substring(1),object:o});for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}}}return a;};
g1.prototype.setJson=function(i,s){this._ready=false;if(f(i,this._preIdOrSettings)){return this;}this._preIdOrSettings=d(i,500);if(typeof i==="string"){try{i=JSON.parse(i);}catch(e){}}if(typeof i==="object"){if(i.manifestChanges){this._filterManifestChangesByLayer(i);}if(this._manifestModel){return;}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}if(i.host){this.setProperty("host",i.host);}if(i.baseUrl){this.setProperty("baseUrl",i.baseUrl);}this._appliedLayerManifestChanges=i.manifestChanges;this.createManifest(i,s);}};
g1.prototype.createManifest=function(i,s){var b=this.getBaseUrl();var o={},m=i.manifest;this._isManifestReady=false;if(typeof m==="string"){o.manifestUrl=m;m=null;}if(this._oEditorManifest){this._oEditorManifest.destroy();}this.destroyAggregation("_extension");var a=W.layers[this.getMode()];this._oEditorManifest=new Q(this.getSection(),m,b,i.manifestChanges);this._oEditorManifest.load(o).then(function(){this._registerManifestModulePath();this._oInitialManifestModel=new J(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,s);var e=this._oEditorManifest._oManifest.getRawJson();var j=g({},e);this._beforeManifestModel=new J(j);if(a<W.layers["translation"]&&this._currentLayerManifestChanges){e=W.mergeDelta(e,[this._currentLayerManifestChanges]);}this._manifestModel=new J(e);this._isManifestReady=true;this.fireManifestReady();this._loadDefaultTranslations();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle());}return this._loadExtension().then(function(){this._initInternal();}.bind(this));}.bind(this));};
g1.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return;}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){B.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/");}else{v.error("sap.app/id entry in the manifest is mandatory");}};
g1.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var e1=c.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e1);this._defaultTranslationsLoaded=true;};
g1.prototype._enhanceI18nModel=function(e1){var o=this.getModel("i18n");if(o){if(o.getResourceBundle().oUrlInfo.url!==e1.oUrlInfo.url){o.enhance(e1);this._oResourceBundle=o.getResourceBundle();}return;}o=new N({bundle:e1});this.setModel(o,"i18n");this._oResourceBundle=e1;};
g1.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension");if(!e){v.info("Extension is not defined in manifest, do not load it.");return new Promise(function(a,b){a();});}var s=this._sAppId.replace(/\./g,"/")+"/"+e;return new Promise(function(a,b){sap.ui.require([s],function(i){var o=new i();o._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",o);a();}.bind(this),function(i){v.error("Failed to load "+e+". Check if the path is correct. Reason: "+i);b(i);});}.bind(this));};
g1.prototype.request=function(o){return this._oDataProviderFactory.create({request:o}).setAllowCustomDataType(true).getData();};
g1.prototype.initDestinations=function(a){var o=this.getHostInstance();if(a&&!o){v.error("Host with id '"+a+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor");}if(this._oDestinations){this._oDestinations.setHost(o);}else{var s=this.getConfigurationPath();this._oDestinations=new h(o,this._manifestModel.getProperty(s+"/destinations"));}};
g1.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}var e=this.getAggregation("_extension");this._oDataProviderFactory=new p(this._oDestinations,e,undefined,this);};
g1.prototype.getRuntimeUrl=function(s){var a=this._sAppId,b,e=s&&s.trim().replace(/^\//,"");if(a===null){v.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}if(!a||s.startsWith("http://")||s.startsWith("https://")||s.startsWith("//")){return s;}b=a.replace(/\./g,"/");return sap.ui.require.toUrl(b)+"/"+e;};
g1.prototype.getBindingNamespaces=function(){var n={},e=this.getAggregation("_extension");if(e){n.extension={formatters:e.getFormatters()};}return n;};
g1.prototype.getHostInstance=function(){var s=this.getHost();if(!s){return null;}return c.byId(s);};
g1.prototype.setLanguage=function(s,b){if(!s||typeof s!=="string"){return this;}this._language=s.replaceAll('_','-');if(this.getLanguage()!=s){var e1=c.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e1);}this.setProperty("language",s,b);if(!g1._languages[this._language]){this._language=this._language.split("-")[0];}if(!g1._languages[this._language]){v.warning("The language: "+s+" is currently unknown, some UI controls might show "+s+" instead of the language name.");}return this;};
g1.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=a1(this.getDomRef());w.setInitialZIndex(this._iZIndex);}};
g1.prototype._filterManifestChangesByLayer=function(m){var a=[],o={":layer":W.layers[this.getMode()]},i=W.layers[this.getMode()];m.manifestChanges.forEach(function(b){var l=b.hasOwnProperty(":layer")?b[":layer"]:1000;if(l<i){a.push(b);}else if(l===i){o=b;}});m.manifestChanges=a;this._currentLayerManifestChanges=o;};
g1.prototype._initInternal=function(){var a=this;var s=a.getConfigurationPath();var b=a._oEditorManifest.get(s+"/editor");if(!b){b=a._oEditorManifest.get("/"+a.getSection()+"/designtime");}var o=a._manifestModel.getProperty(s),e,i=a.getDesigntime();if(i){if(typeof i==="function"){e=new Promise(function(j,k){var l=new i();a._applyDesigntimeDefaults(l.getSettings());j(l);});}else if(typeof i==="object"){e=new Promise(function(j,k){sap.ui.require(["sap/ui/integration/Designtime"],function(D){var l=D.extend("test.Designtime");l.prototype.create=function(){return i;};var m=new l();a._applyDesigntimeDefaults(m.getSettings());j(m);});});}}else if(b){e=a.loadDesigntime().then(function(j){a._applyDesigntimeDefaults(j.getSettings());return j;});}else{e=Promise.resolve(a._createParameterDesigntime(o));}e.then(function(j){a._oDesigntimeInstance=j;a.initDestinations();a.initDataProviderFactory();if(a.getMode()==="admin"||a.getMode()==="all"){a._addDestinationSettings(o,a._oDesigntimeInstance);}a._settingsModel=new J(a._oDesigntimeInstance.getSettings());a.setModel(a._settingsModel,"currentSettings");a.setModel(a._settingsModel,"items");return a._loadValueContextInDesigntime();}).then(function(){a._applyDesigntimeLayers();return a._requestExtensionData();}).then(function(){a._requireFields().then(function(){a._startEditor();});});};
g1.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oEditorManifest){return new Promise(function(a,b){this.attachManifestReady(function(){this.loadDesigntime().then(a,b);}.bind(this));}.bind(this));}if(!this._sAppId){return Promise.reject("App id not maintained");}return new Promise(function(a,b){var s=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!s){s=this._oEditorManifest.get("/"+this.getSection()+"/designtime");}var e=this._sAppId.replace(/\./g,"/")+"/"+s;if(e){sap.ui.require([e],function(o){o=new o();o._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=o;a(o);}.bind(this));}.bind(this),function(){b({error:e+" not found"});});}else{b();}}.bind(this));};
g1.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration";};
g1.prototype.getCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={},a;if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable&&i.visible){var b="";if(i.manifestpath){b=i.manifestpath.substring(0,i.manifestpath.lastIndexOf("/"))+"/valueTranslations";}if(this.getMode()!=="translation"){if(i.translatable&&!i._changed&&i._translatedPlaceholder&&!this._currentLayerManifestChanges[i.manifestpath]&&!this._currentLayerManifestChanges[b]){continue;}else{m[i.manifestpath]=i.value;if(i.valueItems){m[i.manifestpath.substring(0,i.manifestpath.lastIndexOf("/"))+"/valueItems"]=i.valueItems;}}}else if(i.translatable&&i.value){m[i.manifestpath]=i.value;}if(i._next&&(this.getAllowSettings())){var e=typeof(i.visibleToUser)==="undefined"?true:i.visibleToUser;var j=typeof(i.editableToUser)==="undefined"?true:i.editableToUser;if(i._next.visible===!e){a=a||{};a[i._settingspath+"/visible"]=i._next.visible;}if(i._next.editable===!j){a=a||{};a[i._settingspath+"/editable"]=i._next.editable;}if(i._next.pageAdminValues){a=a||{};a[i._settingspath+"/pageAdminValues"]=i._next.pageAdminValues;}if(typeof i._next.allowDynamicValues==="boolean"&&this.getAllowDynamicValues()){a=a||{};a[i._settingspath+"/allowDynamicValues"]=i._next.allowDynamicValues;}}}}}if(this.getMode()!=="translation"){m[":multipleLanguage"]=true;}m[":layer"]=W.layers[this.getMode()];m[":errors"]=this.checkCurrentSettings()[":errors"];if(a){m[":designtime"]=a;}return m;};
g1.prototype.checkCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={};if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable){if((i.isValid||i.required)&&!(this.getMode()==="translation"&&i.translatable)){if(i.isValid){m[i.manifestpath]=i.isValid(i);}m[i.manifestpath]=true;var a=i.value;var b=i.type;if(b==="string"&&a===""){m[i.manifestpath]=a;}if((b==="date"||b==="datetime")&&isNaN(Date.parse(a))){m[i.manifestpath]=a;}if(b==="integer"){if(isNaN(parseInt(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}if(b==="number"){if(isNaN(parseFloat(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}}}}m[":layer"]=W.layers[this.getMode()];}m[":errors"]=Object.values(m).indexOf(false)>-1;return m;};
g1.prototype._createContextModel=function(){var b=this.getHostInstance(),e=new J({}),i=new J([]);this.setModel(e,"context");this.setModel(i,"contextflat");e._aPendingPromises=[];i._getPathObject=function(s){var a=this.getData().filter(function(o){if(o.path===s){return true;}});return a.length?a[0]:null;};i._getValueObject=function(s){var a=this.getData()||[];a=a.filter(function(o){if(o.value===s||o.object.value===s){return true;}});return a.length?a[0]:null;};var j=new Promise(function(a,k){if(b&&b.getContext){var l=false;setTimeout(function(){if(l){return;}v.error("Editor context could not be determined with "+d1+".");l=true;a({});},d1);b.getContext().then(function(o){if(l){v.error("Editor context returned after more than "+d1+". Context is ignored.");}l=true;a(o||{});});}else{a({});}});j.then(function(o){var a=this._mergeContextData(o);e.setData(a);i.setData(this.flattenData(a,"label"));}.bind(this));e.getProperty=function(s,o){if(s&&!s.startsWith("/")&&!o){s="/"+s;}var a=this.resolve(s,o),k;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a];}this._mValues[a]=undefined;k=U.timeoutPromise(b.getContextValue(a.substring(1)));k=k.then(function(l){this._mValues[a]=l;this.checkUpdate();}.bind(this)).catch(function(l){this._mValues[a]=null;this.checkUpdate();v.error("Path "+a+" could not be resolved. Reason: "+l);}.bind(this));this._aPendingPromises.push(k);return undefined;}else{return J.prototype.getProperty.apply(this,arguments);}};};
g1.prototype._mergeContextData=function(o){var a={};a["empty"]=g1._contextEntries.empty;for(var n in o){a[n]=o[n];}a["editor.internal"]=g1._contextEntries["editor.internal"];return a;};
g1.prototype._loadValueContextInDesigntime=function(){var o=this.getModel("context");var s=this._oDesigntimeInstance.getSettings();var i;if(s&&s.form&&s.form.items){i=JSON.stringify(s.form.items);}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var b=i.match(a);var e;if(b&&b.length>0){b=b.filter(function(j){return j.endsWith("value}");});e=b.map(function(j){return j.substring("{context>".length,j.length-1);});e.forEach(function(j){o.getProperty(j);});return Promise.all(o._aPendingPromises).then(function(){o._aPendingPromises=[];});}}return Promise.resolve();};
g1.fieldMap={"string":"sap/ui/integration/editor/fields/StringField","integer":"sap/ui/integration/editor/fields/IntegerField","number":"sap/ui/integration/editor/fields/NumberField","boolean":"sap/ui/integration/editor/fields/BooleanField","date":"sap/ui/integration/editor/fields/DateField","datetime":"sap/ui/integration/editor/fields/DateTimeField","string[]":"sap/ui/integration/editor/fields/ListField","destination":"sap/ui/integration/editor/fields/DestinationField"};g1.Fields=null;
g1.prototype._requireFields=function(){if(g1.Fields){return Promise.resolve();}return new Promise(function(a){sap.ui.require(Object.values(g1.fieldMap),function(){g1.Fields={};for(var n in g1.fieldMap){g1.Fields[n]=arguments[Object.keys(g1.fieldMap).indexOf(n)];}a();});});};
g1.prototype._createDescription=function(o){var a=new q({src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.addStyleClass("sapUiIntegrationEditorDescriptionIcon");a.onmouseover=function(a){this._getPopover().getContent()[0].applySettings({text:o.description});this._getPopover().openBy(a);a.addDependent(this._getPopover());}.bind(this,a);a.onmouseout=function(a){this._getPopover().close();a.removeDependent(this._getPopover());}.bind(this,a);return a;};
g1.prototype._createMessageIcon=function(o){var a=o.getConfiguration();var m=new q({src:"sap-icon://message-information",size:"12px",visible:a.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});m.onmouseover=function(o){o._showMessage();}.bind(this,o);m.onmouseout=function(o){o._hideMessage();}.bind(this,o);m.addStyleClass("sapUiIntegrationEditorMessageIcon");return m;};
g1.prototype._createLabel=function(o){var l=new L({text:o.label,tooltip:o.tooltip||o.label,required:o.required&&o.editable||false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});l._cols=o.cols||2;if(o.layout){l._layout=o.layout;}l._sOriginalType=o.type;return l;};
g1.prototype._createSettingsButton=function(o){var a=o.getConfiguration();var s=new $({icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(e){this._openSettingsDialog(200,e.oSource,o);}.bind(this),visible:a.visible,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return s;};
g1.prototype._getSettingsPanel=function(o){if(!o._oSettingsPanel){o._oSettingsPanel=new X();}return o._oSettingsPanel;};
g1.prototype._openSettingsDialog=function(i,s,o){var a=this._getSettingsPanel(o);window.setTimeout(function(){a.setConfiguration(o.getConfiguration());var b=this.getAggregation("_preview");a.open(s,s,b,o.getHost(),o,o._applySettings.bind(o),o._cancelSettings.bind(o));}.bind(this),i||600);};
g1.prototype._getPopover=function(){if(this._oPopover){return this._oPopover;}var o=new t({text:""});o.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new R({showHeader:false,content:[o]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover;};
g1.prototype._createField=function(o){var a=new g1.Fields[o.type]({configuration:o,mode:this.getMode(),host:this.getHostInstance(),objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},visible:o.visible});this._aFieldReadyPromise.push(a._readyPromise.then(function(){if(o.require||o.validation||(o.validations&&o.validations.length>0)||(o.values&&o.values.data&&!o.values.data.json)){var m=this._createMessageIcon(a);a.setAssociation("_messageIcon",m);}if(o.description&&this.getMode()!=="translation"){a._descriptionIcon=this._createDescription(o);}if(o._changeDynamicValues){a._settingsButton=this._createSettingsButton(a);a._applyButtonStyles();}}.bind(this)));var b=this._settingsModel.bindProperty(o._settingspath+"/value");b.attachChange(function(){if(!this._bIgnoreUpdates){o._changed=true;if(o._dependentFields&&o._dependentFields.length>0){this._updateEditor(o._dependentFields);}this._updatePreview();}}.bind(this));if(a.isFilterBackend()){var s=this._settingsModel.bindProperty(o._settingspath+"/suggestValue");s.attachChange(function(){var e=g({},o);e._cancel=false;this._addValueListModel(e,a,true);}.bind(this));}this._addValueListModel(o,a);a._cols=o.cols||2;if(o.layout){a._layout=o.layout;}a._oDataProviderFactory=this._oDataProviderFactory;a.setAssociation("_messageStrip",this.getAggregation("_messageStrip"));return a;};
g1.prototype._updateEditor=function(a){if(this._ready){if(a.length===0){return;}for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=true;}if(!this._oDataProviderFactory){return;}this._bIgnoreUpdates=true;for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=false;this._addValueListModel(o.config,o.field,true,500*i);}this._bIgnoreUpdates=false;}};
g1.prototype._updatePreview=function(){var o=this.getAggregation("_preview");if(o&&o.update){o.update();}};
g1.prototype._requestData=function(o,a){var b=this._oDataProviderFactory.create(o.values.data);b.bindObject({path:"items>/form/items"});b.bindObject({path:"currentSettings>"+o._settingspath});b.bindObject({path:"context>/"});var e=b.getData();e.then(function(m){if(o._cancel){o._values=[];this._settingsModel.setProperty(o._settingspath+"/_loading",false);return;}var s=o.values.data.path,z,h1=[];if(s&&s!=="/"){if(s.startsWith("/")){s=s.substring(1);}if(s.endsWith("/")){s=s.substring(0,s.length-1);}z=s.split("/");h1=O.get(z,m);}else{h1=m;}if(this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){var i1=o.pageAdminValues,j1=o.value,k1=o.valueItems,l1=[],m1=[],n1=[];this.prepareFieldsInKey(o);if(i1.length>0){for(var i=0;i<i1.length;i++){for(var j=0;j<h1.length;j++){var o1=this.getKeyFromItem(h1[j]);if(i1[i]===o1){l1.push(h1[j]);}}if(Array.isArray(j1)){for(var k=0;k<j1.length;k++){if(i1[i]===j1[k]){m1.push(j1[k]);}}for(var l=0;l<k1.length;l++){var p1=this.getKeyFromItem(k1[l]);if(i1[i]===p1){n1.push(k1[l]);}}}}if(m1.length>0){o.value=[];o.value=m1;}if(n1.length>0){o.valueItems=[];o.valueItems=n1;}}if(o.values.data.path&&o.values.data.path!=="/"){delete m[z];O.set(z,l1,m);}else{m=[];m=l1;}}var q1=a.getConfiguration();if(o.type==="string[]"){var r1=o.values.data.path;if(r1&&r1!=="/"){if(r1.startsWith("/")){r1=r1.substring(1);}if(r1.endsWith("/")){r1=r1.substring(0,r1.length-1);}var z=r1.split("/");var s1=O.get(z,m);if(Array.isArray(s1)){for(var n in s1){var t1=a.getKeyFromItem(s1[n]);if(Array.isArray(q1.value)&&q1.value.length>0&&K(q1.value,t1)){s1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{s1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}O.set(z,s1,m);}}else if(Array.isArray(m)){for(var n in m){var t1=a.getKeyFromItem(m[n]);if(Array.isArray(q1.value)&&q1.value.length>0&&K(q1.value,t1)){m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}}}o._values=m;var u1=a.getModel();u1.setData(m);u1.checkUpdate(true);u1.firePropertyChange();this._settingsModel.setProperty(o._settingspath+"/_loading",false);a._hideValueState(true,true);}.bind(this)).catch(function(i){this._settingsModel.setProperty(o._settingspath+"/_loading",false);var s=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){s=i[0];var j=i[1];if(j){var k;if(j.responseJSON){k=j.responseJSON.error;}else if(j.responseText){if(U.isJson(j.responseText)){k=JSON.parse(j.responseText).error;}else{s=j.responseText;}}if(k){s=(k.code||k.errorCode||j.status)+": "+k.message;}}}else if(typeof(i)==="string"){s=i;}var l=a.getModel();l.firePropertyChange();a._showValueState("error",s,true);}.bind(this));};
g1.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){v.info("Extension is not defined or created, do not load data of it.");return new Promise(function(k,l){k();});}var b=false;var o={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var s;if(a){b=true;s=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");o={"extension":a};if(s){o.path=s;}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){b=true;s=this._oEditorManifest.get("/"+this.getSection()+"/data/path");o={"extension":a};if(s){o.path=s;}}}if(!b){v.info("Extension data is not defined in manifest, do not load data of it.");return new Promise(function(k,l){k();});}var i=this._oDataProviderFactory.create(o);var j=i.getData();return j.then(function(k){var l=e.getModel();if(!l){l=new J(k||{});e.setModel(l,undefined);}else{l.setData(k);}l.checkUpdate(true);}).catch(function(k){var l=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(k)&&k.length>0){l=k[0];var m=k[1];if(m){var n;if(m.responseJSON){n=m.responseJSON.error;}else if(m.responseText){if(U.isJson(m.responseText)){n=JSON.parse(m.responseText).error;}else{l=m.responseText;}}if(n){l=(n.code||n.errorCode||m.status)+": "+n.message;}}}else if(typeof(k)==="string"){l=k;}v.error("Request extension data failed, "+l);}.bind(this));};
g1.prototype._addValueListModel=function(o,a,b,n){if(o.values){var e;if(o.values.data){if(this._oDataProviderFactory){e=a.getModel();if(!e){e=new J({});a.setModel(e,undefined);}this._settingsModel.setProperty(o._settingspath+"/_loading",true);if(!n){this._requestData(o,a);}else{setTimeout(function(){this._requestData(o,a);}.bind(this),n);}}a.bindObject({path:o.values.data.path||"/"});}else if(this.getAggregation("_extension")){e=this.getAggregation("_extension").getModel();if(e&&this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){this.prepareFieldsInKey(o);var k=o.values.path;if(k.length>1){k=k.substring(1);}var l=O.get([k],e.getData()),s=o.pageAdminValues,z=[];for(var m=0;m<s.length;m++){for(var j=0;j<l.length;j++){var h1=this.getKeyFromItem(l[j]);if(s[m]===h1){z.push(l[j]);}}}delete l[k];O.set(k,z,l);e.setData(l);}a.bindObject({path:o.values.path||"/"});a.setModel(e,undefined);}if(!b){var i1=JSON.stringify(o.values.data);if(i1){var j1=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,k1=i1.match(j1);if(k1){for(var i=0;i<k1.length;i++){var l1="/value";var m1=this.getConfigurationPath();if(k1[i].indexOf("destinations.")===0||k1[i].indexOf("parameters.")===0){if(k1[i].indexOf("destinations.")===0){l1="/name";}m1=m1+k1[i].replace(".","/")+"/"+l1;}else if(k1[i].indexOf("{items>")===0){m1=m1+"/parameters/"+k1[i].slice(7,-1);}var n1=this._mItemsByPaths[m1];if(n1){if(n1._settingspath===o._settingspath){o=g({},o);}n1._dependentFields=n1._dependentFields||[];n1._dependentFields.push({field:a,config:o});}}}}}}};
g1.prototype._addItem=function(o){var m=this.getMode();if(this.getAllowDynamicValues()===false||!o.allowDynamicValues){o.allowDynamicValues=false;}if(this.getAllowSettings()===false){o.allowSettings=false;}o.__cols=o.cols||2;if(o.visible===false||(!o.translatable&&m==="translation"&&o.type!=="group")){return;}if(o.type==="group"){var a=new P({headerText:o.label,visible:o.visible,expandable:o.expandable!==false,expanded:o.expanded!==false,width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(i){var j=i.getSource();if(!i.mParameters.expand&&j.getParent().getAggregation("_messageStrip")!==null){f1=j.getParent().getAggregation("_messageStrip").getId();}if(i.mParameters.expand){var k=c.byId(f1);j.addContent(k);j.focus();}}});this.addAggregation("_formContent",a);a._cols=o.cols||2;if(o.hint){this._addHint(o.hint);}return;}if(o.type==="separator"){var s=new S();this.addAggregation("_formContent",s);return;}var n=null;if(m==="translation"){if((typeof o.value==="string"&&o.value.indexOf("{")===0)||typeof o.values!=="undefined"){return;}o._language={value:o.value};o.cols=1;delete o.values;var b=d(o,500);b._settingspath+="/_language";b.editable=false;b.required=false;if(!b.value){b.value="-";}var l=this._createLabel(b);this.addAggregation("_formContent",l);var e=this._createField(b);e.isOrigLangField=true;this.addAggregation("_formContent",e);o.value=o._translatedValue||"";o.editable=o.visible=o.translatable;if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}o.label=o._translatedLabel||"";o.required=false;var e=this._createField(o);this.addAggregation("_formContent",e);}else{n=this._createLabel(o);this.addAggregation("_formContent",n);if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}var e=this._createField(o);this.addAggregation("_formContent",e);}if(o.hint&&(!o.cols||o.cols===2)){this._addHint(o.hint);}o.cols=o.__cols;delete o.__cols;};
g1.prototype._createHint=function(s){s=s.replace(/<a href/g,"<a target='blank' href");var o=new F({htmlText:s});return o;};
g1.prototype._addHint=function(s){var o=this._createHint(s);this.addAggregation("_formContent",o);};
g1.prototype._getCurrentLanguageSpecificText=function(k){var l=this._language;if(this._oTranslationBundle){var s=this._oTranslationBundle.getText(k,[],true);if(s===undefined){return"";}return s;}if(!l){return"";}var i=this._oEditorManifest.get("/sap.app/i18n");if(!i){return"";}if(typeof i==="string"){var a=[l];if(l.indexOf("-")>-1){a.push(l.substring(0,l.indexOf("-")));}if(!K(a,"en")){a.push("en");}this._oTranslationBundle=x.create({url:this.getBaseUrl()+i,async:false,locale:l,supportedLocales:a,fallbackLocale:"en"});return this._getCurrentLanguageSpecificText(k);}};
g1.prototype._startEditor=function(){var o=this.getAggregation("_formContent");if(o&&o.length>0){this.destroyAggregation("_formContent");}var s=this._settingsModel.getProperty("/");var i;if(s.form&&s.form.items){i=s.form.items;var l=this._language||this.getLanguage()||c.getConfiguration().getLanguage().replaceAll('_','-');if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+g1._languages[l]});}var a=false;for(var m in i){var b=i[m];if(b.type==="group"){break;}else if(b.visible){a=true;break;}}if(a){this._addItem({type:"group",translatable:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS")});}this._mItemsByPaths={};for(var n in i){var b=i[n];if(b){b.label=b.label||n;var e;if(b.manifestpath){this._mItemsByPaths[b.manifestpath]=b;e=this._currentLayerManifestChanges[b.manifestpath];}b._changed=e!==undefined&&this.getMode()!=="translation";if(b.values){b.translatable=false;}b._beforeValue=this._getManifestBeforelValue(b.manifestpath);if(b.type==="string"){b._translatedDefaultPlaceholder=this._getManifestDefaultValue(b.manifestpath);var j=null,k=b._translatedDefaultPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}if(j){b.translatable=true;}}b._translatedPlaceholder=b._beforeValue;j=null;k=b._translatedPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}if(j){b._translatedValue=this.getModel("i18n").getResourceBundle().getText(j);if(b._changed){b.value=e;}else{b.value=b._translatedValue;}if(b.valueTranslations&&b.valueTranslations[l]){b.value=b.valueTranslations[l];}if(this.getMode()==="translation"){b._translatedValue=this._getCurrentLanguageSpecificText(j);}}else if(b.translatable&&this.getMode()==="translation"){b._translatedValue=b._translatedPlaceholder;b.value=b._beforeValue;}}if(this.getMode()==="translation"){if(b.valueTranslations&&b.valueTranslations[l]){b._translatedValue=b.valueTranslations[l];}if(this._isValueWithHandlebarsTranslation(b.label)){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(2,b.label.length-2),true);}else if(b.label&&b.label.startsWith("{i18n>")){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(6,b.label.length-1),true);}}}else if(b.type==="string[]"){var z=b.manifestpath.substring(0,b.manifestpath.lastIndexOf("/"))+"/valueItems";var h1=this._manifestModel.getProperty(z);if(h1){b.valueItems=h1;}}if(b.label&&this._isValueWithHandlebarsTranslation(b.label)){var i1=b.label.substring(2,b.label.length-2);if(i1){b.label=this.getModel("i18n").getResourceBundle().getText(i1);}}}}}for(var n in i){var b=i[n];this._addItem(b);}if(this.getMode()!=="translation"){Promise.resolve(this._initPreview()).then(function(){Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}.bind(this));}else{Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}};
g1.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}var o=this.getAggregation("_preview");if(o&&o.destroy){o.destroy();}var m=c.byId(f1);if(m){m.destroy();}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;C.prototype.destroy.apply(this,arguments);};
g1.prototype._initPreview=function(){return new Promise(function(a,b){a();});};
g1.prototype._applyDesigntimeDefaults=function(s){s=s||{};s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items||s.form.items;for(var n in i){var o=i[n];if(o.manifestpath){o.value=this._manifestModel.getProperty(o.manifestpath);}if(o.visible===undefined||o.visible===null){o.visible=true;}if(o.editable===undefined||o.editable===null){o.editable=true;}if(this.getMode()!=="admin"){if(o.visibleToUser!==undefined){o.visible=o.visibleToUser;}if(o.editableToUser!==undefined){o.editable=o.editableToUser;}}if(typeof o.translatable!=="boolean"){o.translatable=false;}if(!o.label){o.label=n;}if(!o.type||o.type==="enum"){o.type="string";}if(o.value===undefined||o.value===null){switch(o.type){case"boolean":o.value=false;break;case"integer":case"number":o.value=0;break;case"string[]":o.value=[];break;default:o.value="";}}if(o.type==="group"){if(o.visible===undefined||o.value===null){o.visible=true;}}o._settingspath="/form/items/"+n;}};
g1.prototype._applyDesigntimeLayers=function(s){if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var i=0;i<this._appliedLayerManifestChanges.length;i++){var o=this._appliedLayerManifestChanges[i][":designtime"];if(o){var k=Object.keys(o);for(var j=0;j<k.length;j++){this._settingsModel.setProperty(k[j],o[k[j]]);}}}}if(this._currentLayerManifestChanges){var o=this._currentLayerManifestChanges[":designtime"];if(o){var k=Object.keys(o);for(var j=0;j<k.length;j++){var a=k[j],n=a.substring(0,a.lastIndexOf("/")+1)+"_next";if(!this._settingsModel.getProperty(n)){this._settingsModel.setProperty(n,{});}var n=a.substring(0,a.lastIndexOf("/")+1)+"_next",b=a.substring(a.lastIndexOf("/")+1);this._settingsModel.setProperty(n+"/"+b,o[k[j]]);}}}};
g1.prototype._createParameterDesigntime=function(o){var s={},b=this.getConfigurationPath()+"/parameters",m=this.getMode();if(o&&o.parameters){s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items;Object.keys(o.parameters).forEach(function(n){i[n]=g({manifestpath:b+"/"+n+"/value",editable:(m!=="translation"),_settingspath:"/form/items/"+n},o.parameters[n]);var a=i[n];if(!a.type){a.type="string";}if(!a.hasOwnProperty("visible")){a.visible=true;}});}return new D(s);};
g1.prototype._addDestinationSettings=function(o){var s=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";s.form=s.form||{};s.form.items=s.form.items||{};if(s&&o&&o.destinations){if(!s.form.items["destination.group"]){s.form.items["destination.group"]={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",visible:true};}var j=s.form.items,k=this.getHostInstance();Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]=g({manifestpath:i+"/"+n+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:o.destinations[n].name,defaultValue:o.destinations[n].defaultUrl,_settingspath:"/form/items/"+[n+".destinaton"],_values:[],_destinationName:n},o.destinations[n]);if(typeof j[n+".destinaton"].label==="undefined"){j[n+".destinaton"].label=n;}if(k){j[n+".destinaton"]._loading=true;}});var l=false;if(k){this.getHostInstance().getDestinations().then(function(a){l=true;Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=a;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(){return this.getHostInstance().getDestinations();}.bind(this)).then(function(b){if(l){return;}Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=b;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(e){Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));v.error("Can not get destinations list from '"+k.getId()+"'.");}.bind(this));}}};
g1.prototype._getManifestDefaultValue=function(s){return this._oInitialManifestModel.getProperty(s);};
g1.prototype._getManifestBeforelValue=function(s){return this._beforeManifestModel.getProperty(s);};
g1.prototype._isValueWithHandlebarsTranslation=function(a){if(typeof a==="string"){return!!a.match(b1);}return false;};
g1.prototype._isValueWithParameterSyntax=function(a){if(typeof a==="string"){return!!a.match(c1);}return false;};
g1._contextEntries={empty:{label:e1.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:e1.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:e1.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};g1._languages={};
g1._appendThemeVars=function(){var a=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var m=E.get({name:a,callback:function(b){}});if(m){for(var n in m){document.body.style.setProperty("--"+n,m[n]);}}};
g1.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#";}var k=o.values.item.key;this._aFields=k.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};
g1.prototype.getKeyFromItem=function(i){var s="";this._aFields.forEach(function(a){s+=i[a].toString()+this._sKeySeparator;}.bind(this));if(s.endsWith(this._sKeySeparator)){s=s.substring(0,s.length-this._sKeySeparator.length);}return s;};
g1.init=function(){this.init=function(){};g1._appendThemeVars();c.attachThemeChanged(function(){g1._appendThemeVars();});var s=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");A(s);B.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(o){g1._languages=o;});};
g1.init();return g1;});
sap.ui.predefine('sap/ui/integration/editor/EditorResourceBundles',["sap/base/util/LoaderExtensions","sap/base/i18n/ResourceBundle","sap/base/util/includes"],function(L,R,i){"use strict";var E=(function(){var e;function a(r){e=[];var l=L.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:false});for(var p in l){var f=[p];if(p.indexOf("-")>-1){f.push(p.substring(0,p.indexOf("-")));}if(!i(f,"en")){f.push("en");}var o=R.create({url:r,async:false,locale:p,supportedLocales:f,fallbackLocale:"en"});e[p]={"language":l[p],"resourceBundle":o};}return e;}return{getInstance:function(r){if(!e){e=a(r);}return e;}};})();return E;});
sap.ui.predefine('sap/ui/integration/editor/Extension',["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject"],function(l,L,M){"use strict";
var E=M.extend("sap.ui.integration.editor.Extension",{metadata:{library:"sap.ui.integration",properties:{formatters:{type:"object"}}}});
E.prototype.init=function(){this._oEditorInterface=null;this._oEditor=null;};
E.prototype.exit=function(){this._oEditorInterface=null;this._oEditor=null;};
E.prototype.setFormatters=function(f){this.setProperty("formatters",f);if(!this._oEditor){return;}if(this._oEditor.getAggregation("_extension")!==this){L.error("Extension formatters must be set before the initialization of the editor. Do this inside Extension#init().");}};
E.prototype.onEditorReady=function(){};
E.prototype.getEditor=function(){return this._oEditorInterface;};
E.prototype._setEditor=function(e,o){this._oEditor=e;this._oEditorInterface=o;};
return E;});
sap.ui.predefine('sap/ui/integration/editor/Manifest',["sap/ui/integration/util/Manifest","./Merger"],function(B,M){"use strict";
var a=B.extend("sap.ui.integration.editor.Manifest");
a.prototype.mergeDeltaChanges=function(m){return M.mergeDelta(m,this._aChanges,this._sSection);};
return a;},true);
sap.ui.predefine('sap/ui/integration/editor/Merger',["sap/base/util/merge","sap/ui/model/json/JSONModel","sap/ui/core/Core","sap/base/util/deepClone"],function(m,J,C,d){"use strict";var M={layers:{"admin":0,"content":5,"translation":10,"all":20},mergeManifestPathChanges:function(o,c){Object.keys(c).forEach(function(s){if(s.charAt(0)==="/"){var v=c[s];o.setProperty(s,v);}});},mergeDelta:function(o,c,s){var i=m({},o);if(typeof s==="undefined"){s="sap.card";}if(Array.isArray(c)&&c.length>0){var a;c.forEach(function(b){if(b.content){m(i[s],b.content);}else{a=a||new J(i);M.mergeManifestPathChanges(a,b);}});}return i;},mergeDesigntimeMetadata:function(D,c){var i=m({},D);c.forEach(function(o){var I=o.content.entityPropertyChange||[];I.forEach(function(a){var p=a.propertyPath;switch(a.operation){case"UPDATE":if(i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;case"DELETE":delete i[p];break;case"INSERT":if(!i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;default:break;}});});return i;}};return M;});
sap.ui.predefine('sap/ui/integration/editor/Settings',["sap/ui/core/Control","sap/m/ResponsivePopover","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/ui/core/Core","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ScrollContainer","sap/base/util/ObjectPath","sap/ui/integration/util/BindingHelper"],function(C,P,J,B,S,b,V,H,c,L,d,T,e,f,M,g,I,h,m,k,l,p,q,r,O,s){"use strict";
var t=C.extend("sap.ui.integration.editor.Settings",{
metadata:{library:"sap.ui.integration"},
renderer:null
});
var R=k.getLibraryResourceBundle("sap.ui.integration"),u,w,x=null,D,y,z,A,E,F,G,K,N,Q,U,W;
t.prototype.setConfiguration=function(o){this._originalConfig=o;o=m({},o);var a=new J(o);this.setModel(a,"currentSettings");this.bindElement({path:"currentSettings>/"});};
t.prototype.open=function(o,a,i,j,n,v,o1){var p1=this.getModel("currentSettings").getData();if(p1.values){this.prepareFieldsInKey(p1);}x=this;W=X(p1,n);this.addDependent(W);this.oHost=j;this.fnApply=v;this.fnCancel=o1;this._oOpener=n;w=true;o.addDependent(this);if(!p1.allowDynamicValues&&p1.values){k.byId("settings_scroll_container").setHeight("155px");}this.getModel("currentSettings").checkUpdate(true,true);l1(R.getText("EDITOR_SELECT_FROM_LIST"),[]);if(a){var q1=(!i||i.getDomRef()===null||i.getDomRef().offsetWidth===0)?270:i.getDomRef().offsetWidth;var r1=(!i||i.getDomRef()===null||i.getDomRef().offsetHeight===0)?350:i.getDomRef().offsetHeight;W.setContentWidth(q1+"px");W.setContentHeight((r1-50)+"px");if(i&&i.getSettings().preview.position==="right"){W.setPlacement("Right");}else{W.setPlacement("Left");}A.setValue(o._label);W.openBy(o);}else{W.open();}u=this.getModel("currentSettings");if(u.getProperty("/_hasDynamicValue")){b1();}else if(u.getProperty("/_hasSettings")){a1();}else if(u.getProperty("/allowDynamicValues")){b1();}else if(u.getProperty("/allowSettings")){a1();}};
t.prototype._applyCurrentSettings=function(){this.fnApply(u.getData());};
t.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig);};
t.prototype.destroy=function(){this.removeDependent(W);return C.prototype.destroy.apply(this,arguments);};
function X(o,a){var n=$(),U=_(o),D=f1(),v=g1(),y=h1(o,a),W=new P({id:"settings_popover",showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,verticalScrolling:false,modal:false,endButton:new B({text:R.getText("EDITOR_MORE_CANCEL"),press:function(){W.close();}}),beginButton:new B({text:R.getText("EDITOR_MORE_OK"),type:"Emphasized",press:function(){if(o.values){var j=k.byId("settings_pav_table"),o1=j.getSelectedContexts(),p1=[];if(u.getProperty("/selectedValues")==="Partion"){for(var i=0;i<o1.length;i++){var q1=x.getKeyFromItem(o1[i].getObject());p1.push(q1);}c1("pageAdminValues",p1);}else{c1("pageAdminValues",[]);}}x._applyCurrentSettings();w=false;W.close();}}),afterClose:function(){if(w){x._cancelCurrentSettings();}w=true;W.destroy();},afterOpen:function(){var o1=this.getDomRef().querySelector("footer");var p1=U.getDomRef(),q1=o1.querySelector("button").parentNode;if(p1){q1.insertBefore(p1,q1.firstChild);}window.requestAnimationFrame(function(){W.getDomRef()&&(W.getDomRef().style.opacity="1");});if(o.values){var r1=k.byId("settings_pav_table"),s1=u.getProperty("/_next/pageAdminValues");if(s1!==undefined&&s1.length>0){r1.removeSelections();u.setProperty("/selectedValues","None");var t1=u.getProperty("/_next/pageAdminValues"),u1=r1.getItems();for(var i=0;i<t1.length;i++){for(var j=0;j<u1.length;j++){var v1=x.getKeyFromItem(u1[j].getBindingContext().getObject());if(t1[i]===v1){r1.setSelectedItem(u1[j]);}}}u.setProperty("/selectedValues","Partion");}else{r1.selectAll();u.setProperty("/selectedValues","All");}}}});W.setCustomHeader(n);W.addContent(U);W.addContent(D);W.addContent(v);W.addContent(y);W.addStyleClass("sapUiIntegrationFieldSettings");return W;}
function Y(){N=new b({text:R.getText("EDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:a1}).addStyleClass("setbtn");return N;}
function Z(){N=Y();Q=new S("settings_Segment_btn",{width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}",items:[new b({text:R.getText("EDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:b1}).addStyleClass("dynbtn sel"),N]});return Q;}
function $(){Q=Z();var o=new T({text:R.getText("EDITOR_MORE_DYNAMICVALUES"),visible:"{= ${currentSettings>allowDynamicValues} && !${currentSettings>allowSettings}}"}).addStyleClass("sapUiTinyMagin");var a=new T({text:R.getText("EDITOR_MORE_SETTINGS"),visible:"{= !${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}"}).addStyleClass("sapUiTinyMagin");var i=new H({width:"100%",items:[Q,o,a]}).addStyleClass("headertitle");return i;}
function _(o){U=new B("settings_reset_to_default_btn",{type:"Transparent",text:R.getText("EDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === (typeof(${currentSettings>visibleToUser}) === 'undefined' ? false : !${currentSettings>visibleToUser}) || ${currentSettings>_next/editable} === (typeof(${currentSettings>editableToUser}) === 'undefined' ? false : !${currentSettings>editableToUser}) || ${currentSettings>_next/allowDynamicValues} === (typeof(${currentSettings>allowDynamicValues}) === 'undefined' ? false : !${currentSettings>allowDynamicValues}) || ${currentSettings>_beforeValue} !== ${currentSettings>value}}",tooltip:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){var v=typeof(u.getProperty("/visibleToUser"))==='undefined'?true:u.getProperty("/visibleToUser");var a=typeof(u.getProperty("/editableToUser"))==='undefined'?true:u.getProperty("/editableToUser");var n=typeof(u.getProperty("/allowDynamicValues"))==='undefined'?true:u.getProperty("/allowDynamicValues");var W=k.byId("settings_popover");c1("visible",v);c1("editable",a);c1("allowDynamicValues",n);if(u.getProperty("/translatable")){if(u.getProperty("/_translatedDefaultValue")&&u.getProperty("/_translatedDefaultValue")!==""){u.setProperty("/value",u.getProperty("/_translatedDefaultValue"));}else if(u.getProperty("/_translatedDefaultPlaceholder")&&u.getProperty("/_translatedDefaultPlaceholder")!==""){u.setProperty("/value",u.getProperty("/_translatedDefaultPlaceholder"));}u.setProperty("/_changed",false);}else{u.setProperty("/value",u.getProperty("/_beforeValue"));}if(o.values){var o1=k.byId("settings_pav_table"),p1=u.getProperty("/_next/pageAdminValues"),q1=o1.getItems();if(p1!==undefined&&p1.length>0&&p1.length<q1.length){o1.removeSelections();for(var i=0;i<p1.length;i++){for(var j=0;j<q1.length;j++){var r1=x.getKeyFromItem(q1[j].getBindingContext().getObject());if(p1[i]===r1){o1.setSelectedItem(q1[j]);}}}u.setProperty("/selectedValues","Partion");}else{o1.selectAll();u.setProperty("/selectedValues","All");}}W.getBeginButton().firePress();}}).addStyleClass("resetbutton");return U;}
function a1(){y.setVisible(true);D.setVisible(false);k.byId("settings_Segment_btn").setSelectedKey("settings");var o=k.byId("settings_current_value");o.setVisible(false);}
function b1(){y.setVisible(false);D.setVisible(true);k.byId("settings_Segment_btn").setSelectedKey("dynamic");var a=x.getModel("contextflat"),o=a._getValueObject(u.getProperty("/value"));if(o&&o.object.label){A.setValue(o.object.label);l1(o.object.description,o.object.tags);if(o.path==="empty"){A.setValue(o.object.label);}n1(o);}var i=k.byId("settings_current_value");i.setVisible(true);}
function c1(a,v){if(!u.getProperty("/_next")){u.setProperty("/_next",{});}u.setProperty("/_next/"+a,v);}
function d1(o,j){var a=[];for(var n in o){if(o[n]&&o[n].label){var v=new g({text:o[n].label});v.__data=o[n];o[n].pathvalue=(j+"/"+n).substring(1);a.push(v);var o1=d1(o[n],j+"/"+n);for(var i=0;i<o1.length;i++){v.addItem(o1[i]);}}}return a;}
var e1=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];
function f1(){D=new V({visible:true});D.addStyleClass("sapUiSmallMargin");A=new I({width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(E){E.destroy();}E=new M({});F=d1(D.getModel("context").getData(),"");for(var i=0;i<F.length;i++){E.addItem(F[i]);}E.attachItemSelected(function(o){var a=o.getParameter("item").__data;l1(a.description||"",a.tags||[]);A.setValue(a.placeholder||a.label);var j=x.getModel("contextflat");n1(j._getPathObject(a.pathvalue));});A.addDependent(E);E.addStyleClass("sapUiIntegrationFieldSettingsMenu");E.openBy(A,false,null,null,"1 0");}});A.addStyleClass("selectvariable");var v=new V({items:[new d({text:"Select a dynamic value"}),A]});D.addItem(v);z=new T({text:"",maxLines:6,renderWhitespace:true});v=new V({width:"100%",items:[z]});z.addStyleClass("description");D.addItem(v);if(e1.length===-1){G=new c({width:"100%",enabled:true,change:function(){K.setText(G.getSelectedItem()._data.description);}});v=new V({visible:false,items:[new d({text:"Customize the value..."}),G]});D.addItem(v);K=new T({text:"",maxLines:4,renderWhitespace:true});K.addStyleClass("description");v=new V({width:"100%",items:[K]});D.addItem(v);D.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop");}D.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");return D;}
function g1(){var o=new V("settings_current_value",{width:"100%",items:[new T({text:R.getText("EDITOR_ACTUAL_VALUE")}),new I({value:{path:"currentSettings>_currentContextValue"},editable:false})]});o.addStyleClass("currentval");return o;}
function h1(o,a){y=new V({visible:false});var j=new V().addStyleClass("commonSettings");y.addItem(j);j.addItem(new e({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN")}).addStyleClass("stitle"));j.addItem(new H({items:[new d({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE")}),new f({selected:"{= ${currentSettings>_next/visible} !== false}",select:function(v1){c1("visible",v1.getParameter("selected"));}})]}).addStyleClass("cbrow"));j.addItem(new H({items:[new d({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_EDIT")}),new f({selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(v1){c1("editable",v1.getParameter("selected"));}})]}).addStyleClass("cbrow"));j.addItem(new H({visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[new d({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DYN")}),new f({selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(v1){c1("allowDynamicValues",v1.getParameter("selected"));}})]}).addStyleClass("cbrow"));if(o.values){var v;if(o.values.data){var n=o.values.data.path,o1;if(n&&n!=="/"){if(n.startsWith("/")){n=n.substring(1);}if(n.endsWith("/")){n=n.substring(0,n.length-1);}o1=n.split("/");v=O.get(["_values",o1],o);}else{v=O.get(["_values"],o);}}else if(a.getParent().getParent().getAggregation("_extension")){var p1=o.values.path;if(p1.length>1){p1=p1.substring(1);}v=O.get([p1],a.getModel().getData());}j.addItem(new H({visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",items:[new d({text:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST"),tooltip:R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST_TOOLTIPS"),wrapping:false}),new B({type:"Transparent",enabled:v!==undefined,icon:{path:"currentSettings>selectedValues",formatter:function(v1){if(v1==="All"){return"sap-icon://multiselect-all";}else if(v1==="Partion"){return"sap-icon://multi-select";}else if(v1==="None"){return"sap-icon://multiselect-none";}}},tooltip:{path:"currentSettings>selectedValues",formatter:function(v1){if(v1==="All"){return R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DESELECT_ALL");}else{return R.getText("EDITOR_MORE_SETTINGS_P_ADMIN_SELECT_ALL");}}},press:i1})]}).addStyleClass("cbrow"));var q1=new l({id:"settings_pav_table",mode:"MultiSelect",width:"84%",select:j1,columns:[new p()]}).addStyleClass("tableHdr");var r1=o.values.item.text,s1=new J(v);q1.setModel(s1);var t1=new q().addStyleClass("pavlistItem");if(v){for(var i=0;i<v.length;i++){t1.addCell(new H({items:[new T({text:s.createBindingInfos(r1)}).addStyleClass("pavTblCellText")]})).addStyleClass("pavlistItem");}}q1.bindItems("/",t1);var u1=new r({id:"settings_scroll_container",height:"125px",width:"94%",vertical:true,horizontal:false,visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",content:[q1]}).addStyleClass("SettingsPAVTable");y.addItem(u1);}return y;}
function i1(){var o=k.byId("settings_pav_table"),a=k.byId("settings_reset_to_default_btn"),i=u.getProperty("/selectedValues");if(i==="All"){o.removeSelections();u.setProperty("/selectedValues","None");}else{o.selectAll();u.setProperty("/selectedValues","All");}if(!a.getEnabled()){a.setEnabled(true);}}
function j1(o){var a=o.getSource(),i=a.getSelectedItems(),j=a.getItems(),n=k.byId("settings_reset_to_default_btn");if(i.length===j.length){u.setProperty("/selectedValues","All");}else if(i.length<j.length&&i.length>0){u.setProperty("/selectedValues","Partion");}else{u.setProperty("/selectedValues","None");}if(!n.getEnabled()){n.setEnabled(true);}}
function k1(a,j){a=a||[];G.removeAllItems();var n=[];G.addItem(new L({text:"No customizing needed",key:""}));for(var i=0;i<e1.length;i++){var o=e1[i],v=new L({text:o.label,key:"key"+i});v._data=o;if(o.sourceTypes.indexOf(j)>-1||a.indexOf(o.formatMethod)>-1){G.addItem(v);}else{n.push(v);}}for(var i=0;i<n.length;i++){G.addItem(n[i]);}}
function l1(a,i){i=i||[];if(i.indexOf("technical")>-1){a=a+"\n"+R.getText("EDITOR_MORE_DYNAMICVALUES_TECHHINT");}z.setText(a);}
function m1(o){if(e1.length===-1){if(!o){G.removeAllItems();G.addItem(new L({text:"No customizing available for this value"}));K.setText("");G.setEnabled(false);}else{k1(o.customize,o.type);G.setEnabled(true);}}}
function n1(o){if(o){u.setProperty("/_hasDynamicValue",true);var a=o.value;u.setProperty("/value",a);u.setProperty("/_contextpath",o.path);if(o.object&&o.object.value&&o.object.value.indexOf("{{")===0){u.setProperty("/_currentContextValue",h.processPredefinedParameter(o.object.value));m1(o.object);}else{if(o.path==="empty"){u.setProperty("/value","");u.setProperty("/_currentContextValue","");u.setProperty("/_hasDynamicValue",false);m1();}else{m1(o.object);if(o.object&&o.object.hasOwnProperty("value")){u.setProperty("/_currentContextValue",o.object.value);}else{x.oHost.getContextValue(o.path+"/value").then(function(v){if(v===null){u.setProperty("/_currentContextValue","(not available)");}else{u.setProperty("/_currentContextValue",v);}o.object&&(o.object.value=v);});}}}}}
t._private=function(){return{oPopover:W,oSegmentedButton:Q,oSettingsButton:N,oDynamicPanel:D,oSettingsPanel:y,oCurrentModel:u,updateCurrentValue:n1,oCurrentInstance:x,oDynamicValueField:A,oResetToDefaultButton:U,getMenuItems:function(){return F;},getMenu:function(){return E;}};};
t.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#";}var a=o.values.item.key;this._aFields=a.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};
t.prototype.getKeyFromItem=function(i){var a="";this._aFields.forEach(function(j){a+=i[j].toString()+this._sKeySeparator;}.bind(this));if(a.endsWith(this._sKeySeparator)){a=a.substring(0,a.length-this._sKeySeparator.length);}return a;};
return t;});
sap.ui.predefine('sap/ui/integration/editor/fields/BaseField',["sap/ui/core/Control","sap/m/Button","sap/m/FormattedText","sap/m/MultiInput","sap/m/Token","sap/ui/core/Core","sap/ui/integration/util/BindingHelper","sap/ui/core/ListItem","sap/base/util/ObjectPath","sap/ui/integration/util/Utils","sap/base/util/deepEqual","sap/m/MessageToast"],function(C,B,F,M,T,a,c,L,O,U,d,e){"use strict";var r=a.getLibraryResourceBundle("sap.ui.integration"),s="sap/ui/integration/editor/fields/viz";
var g=C.extend("sap.ui.integration.editor.fields.BaseField",{
metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{_messageIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"}},events:{afterInit:{}}},
renderer:function(R,o){var f=o.getAggregation("_field"),D=o._getDynamicField();R.openStart("div");R.addClass("sapUiIntegrationEditorItemField");if(f&&f.getWidth){}if(!o.getVisible()){R.addStyle("display","none");}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();if(o.getVisible()){R.openStart("span");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationEditorEditor");if(o._hasDynamicValue()){R.addStyle("width","1px");R.addStyle("opacity","0");}else{R.addStyle("width","100%");}R.writeStyles();R.writeClasses();R.openEnd();R.renderControl(f);R.close("span");R.close("span");if(o._hasDynamicValue()){R.openStart("span");R.addClass("sapUiIntegrationEditorSettings");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationEditorSettingsField");R.addStyle("width","100%");R.addStyle("opacity","1");R.writeClasses();R.writeStyles();R.openEnd();R.renderControl(D);R.close("span");}R.openStart("div");R.writeAttribute("id",o.getId()+"-ms");R.addStyle("height","0");R.writeStyles();R.openEnd();R.close("div");}R.close("div");}
});
g.prototype.init=function(){this._readyPromise=new Promise(function(b){this._fieldResolver=b;}.bind(this));};
g.prototype.getMessagestrip=function(){var m=this.getAssociation("_messageStrip");return a.byId(m);};
g.prototype.getMessageIcon=function(){var m=this.getAssociation("_messageIcon");return a.byId(m);};
g.prototype._removeValidationMessage=function(){var f=this.control,m=f.getParent().getMessageIcon();if(m){m.setVisible(false);}if(f.getEnabled()){f.setEnabled(false);}};
g.prototype.setConfiguration=function(o,S){if(r&&r.sLocale!==a.getConfiguration().getLanguage()){r=a.getLibraryResourceBundle("sap.ui.integration");}if(o!==this.getConfiguration()){this._sanitizeValidationSettings(o);this.setProperty("configuration",o,S);if(o){Promise.resolve().then(function(){this.initEditor(o);}.bind(this));}}return this;};
g.prototype._sanitizeValidationSettings=function(o){o.validations=o.validations||[];if(o.validation&&o.validations&&Array.isArray(o.validations)){o.validations.push(o.validation);delete o.validation;}if(o.validation&&!o.validations){o.validations=[o.validation];delete o.validation;}if(o.required){o.validations.unshift({"required":true,"type":"error"});}};
g.prototype._triggerValidation=function(v){if(d(v,this._preChangedValue)&&this._messageFrom==="validation"){return;}this._preChangedValue=v;var o=this.getConfiguration();var b=false;if(o.required){b=true;}else if(o.type==="string"&&v){b=true;}else if((o.type==="integer"||o.type==="number")&&!isNaN(v)){if(v!==""){b=true;}}else if(o.type==="boolean"){b=true;}else if(o.type==="string[]"&&Array.isArray(v)){b=true;}if(o.validations&&Array.isArray(o.validations)&&b){for(var i=0;i<o.validations.length;i++){if(!this._handleValidation(o.validations[i],v)){return false;}}this._hideValueState();}return true;};
g.validations={string:{maxLength:function(v,m){return v.length<=m;},maxLengthTxt:"EDITOR_VAL_MAXLENGTH",minLength:function(v,m){return v.length>=m;},minLengthTxt:"EDITOR_VAL_MINLENGTH",pattern:function(v,b){var p=new RegExp(b);return p.test(v);},patternTxt:"EDITOR_VAL_NOMATCH",required:function(v,b){return b&&!!v;},requiredTxt:"EDITOR_VAL_TEXTREQ",validateTxt:"EDITOR_VAL_NOMATCH"},"string[]":{maxLength:function(v,m){return Array.isArray(v)&&v.length<=m;},maxLengthTxt:"EDITOR_VAL_LISTMAXLENGTH",minLength:function(v,m){return Array.isArray(v)&&v.length>=m;},minLengthTxt:"EDITOR_VAL_LISTMINLENGTH",required:function(v,b){return Array.isArray(v)&&v.length>0;},requiredTxt:"EDITOR_VAL_LISTREQ"},integer:{maximum:function(v,b,f){if(f.exclusiveMaximum){f._txt="maximumExclusiveTxt";return v<b;}return v<=b;},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(v,b,f){if(f.exclusiveMinimum){f._txt="minimumExclusiveTxt";return v>b;}return v>=b;},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MIN_E",multipleOf:function(v,b){return(v%b)===0;},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(v,b){return!isNaN(v)&&v!=="";},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},number:{maximum:function(v,b,f){if(f.exclusiveMaximum){f._txt="maximumExclusiveTxt";return v<b;}return v<=b;},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(v,b,f){if(f.exclusiveMinimum){f._txt="minimumExclusiveTxt";return v>b;}return v>=b;},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MAX_E",multipleOf:function(v,b){return(v%b)===0;},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(v,b){return!isNaN(v)&&v!=="";},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"}};
g.prototype._requestData=function(R){var f=this.control.getParent();var o=f.getConfiguration();var D=f._oDataProviderFactory.create(R.data);f.getModel("currentSettings").setProperty(o._settingspath+"/_loading",true);var p=D.getData();return p.then(function(b){f.getModel("currentSettings").setProperty(o._settingspath+"/_loading",false);var P=R.data.path||"/";if(P.startsWith("/")){P=P.substring(1);}if(P.endsWith("/")){P=P.substring(0,P.length-1);}var h=P.split("/");var i=O.get(h,b);return i;});};
g.prototype._handleValidation=function(S,v){var o=this.getConfiguration(),V=g.validations[o.type];var f=function(n,D){var E;if(typeof S.message==="function"){E=S.message(v,o,D);}else{E=S.message;}if(!E){if(S._txt){E=r.getText(V[S._txt],[S[n]]);}else{E=r.getText(V[n+"Txt"],[S[n]]);}}this._showValueState(S.type||"error",E);}.bind(this);if(S["validate"]){var b={control:this.getAggregation("_field"),requestData:this._requestData,removeValidationMessage:this._removeValidationMessage};var h=S["validate"];Promise.resolve(h(v,o,b)).then(function(j){var I=j.isValid;if(typeof I==="undefined"){I=j;}var D=j.data?j.data:undefined;if(!I){f("validate",D);return false;}else{this._hideValueState(true,false);return true;}}.bind(this));}else{for(var n in S){if(V){var i=V[n];S._txt="";if(i){if(!i(v,S[n],S)){f(n);return false;}}}}}return true;};
g.prototype.onAfterRendering=function(){this._applyMessage();var m=this.getMessagestrip();if(m&&m.getDomRef()){m.getDomRef().style.opacity="0";}};
g.prototype._applyMessage=function(){var i=a.byId(this.getAssociation("_messageIcon"));if(this.getAssociation("_messageIcon")&&i){var I=i.getDomRef();if(I){I.classList.remove("error");I.classList.remove("warning");I.classList.remove("success");if(this._message){I.classList.add(this._message.type);}}}};
g.prototype._showValueState=function(t,m,f){var o=this.getAggregation("_field"),E=t.substring(0,1).toUpperCase()+t.substring(1);this._message={"enum":E,"type":t,"message":m,"atControl":false};this._messageFrom="validation";if(f){this._messageFrom="request";}var b=this.getMessagestrip();if(o&&o.setValueState){this._message.atControl=true;if(o.setShowValueStateMessage){o.setShowValueStateMessage(false);}o.setValueState(E);o.setValueStateText(m);}else if(b&&b.getVisible()&&o.getMetadata().getName()!=="sap.m.Switch"){this._showMessage();}this._applyMessage();};
g.prototype._hideValueState=function(f,t){if(!this.getParent()){return;}var m=this.getMessagestrip();if(this._message){if((f&&this._messageFrom==="request")||(!f&&this._messageFrom==="validation")){var o=this.getAggregation("_field");this._message={"enum":"Success","type":"success","message":"Corrected","atControl":this._message.atControl};this._messageFrom="validation";if(f){this._messageFrom="request";}if(this._messageto){clearTimeout(this._messageto);}this._messageto=setTimeout(function(){this._messageto=null;this._applyMessage();if(!this._message&&o.setValueState){o.setValueState("None");}}.bind(this),1500);this._applyMessage();if(m){if(m.getDomRef()){m.getDomRef().style.opacity="0";}m.onAfterRendering=null;}if(o.setValueState){o.setValueState("Success");}if(o.setValueStateText){o.setValueStateText("");}this._message=null;}if(!this._message&&f&&t){this._triggerValidation(this.getConfiguration().value);}}};
g.prototype.onfocusin=function(E){if(E&&E.target.classList.contains("sapMBtn")){return;}this._showMessage();};
g.prototype.onfocusout=function(E){this._hideMessage();};
g.prototype._showMessage=function(){if(!this.getParent()){return;}var m=this.getMessagestrip();if(this._message&&m){m.applySettings({type:this._message.enum,text:this._message.message});var t=this;m.onAfterRendering=function(){m.getDomRef().style.zIndex="1";m.getDomRef().style.opacity="1";t.getDomRef("ms")&&t.getDomRef("ms").appendChild(m.getDomRef());var f=t.getAggregation("_field");if(t._message&&!t._message.atControl){m.getDomRef().style.marginTop="0";m.getDomRef().style.marginLeft="0";}var w=f.getDomRef().offsetWidth-5;if(w<100){w=f.getParent().getDomRef().offsetWidth-35;}m.getDomRef().style.width=w+"px";};m.rerender();}};
g.prototype._hideMessage=function(){var m=this.getMessagestrip();var f=this.getAggregation("_field"),b=f.getDomRef()&&f.getDomRef().contains(window.document.activeElement);if(m){if(!b&&m.getDomRef()){m.getDomRef().style.opacity="0";m.getDomRef().style.zIndex="-1";}m.onAfterRendering=null;}};
g.prototype.initEditor=function(o){var b;this.initVisualization&&this.initVisualization(o);if(this._visualization.editor){b=this._visualization.editor;}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=s+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:o.editable};}sap.ui.require([this._visualization.type],function(f){this._visualization.type=f;this.initEditor(o);}.bind(this));return;}b=new this._visualization.type(this._visualization.settings||{});}if(b instanceof C){this.setAggregation("_field",b);if(b.attachChange){b.attachChange(function(E){if(E.mParameters.value===""){this._triggerValidation(E.getParameter("value"));}}.bind(this));}var h=this.getModel("currentSettings").bindProperty("value",this.getBindingContext("currentSettings"));h.attachChange(function(){this._triggerValidation(o.value);}.bind(this));this._triggerValidation(o.value);}var m=this.getMode();o.allowSettings=o.allowSettings||o.allowSettings!==false&&m==="admin";o.allowDynamicValues=o.allowDynamicValues||o.allowDynamicValues!==false;o._changeDynamicValues=o.visible&&o.editable&&(o.allowDynamicValues||o.allowSettings)&&m!=="translation";if(o._changeDynamicValues){this._getDynamicField();}this._applySettings(o);this.fireAfterInit();};
g.prototype.initVisualization=function(){};
g.prototype._hasDynamicValue=function(){var v=this._getCurrentProperty("value");var D=typeof v==="string"&&(v.indexOf("{context>")===0||v.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",D);return D;};
g.prototype._hasSettings=function(){var o=this.getConfiguration();if(o._next){var v=o.hasOwnProperty("visibleToUser")?o.visibleToUser:true;var E=o.hasOwnProperty("editableToUser")?o.editableToUser:true;var b=o._next.visible===false?false:o._next.editable;var A=o.hasOwnProperty("allowDynamicValues")?o.allowDynamicValues:true;o._hasSettings=(o._next.visible===!v||b===!E||o._next.allowDynamicValues===!A);}else{o._hasSettings=false;if(o.hasOwnProperty("editableToUser")||o.hasOwnProperty("visibleToUser")){o._next={};}if(o.hasOwnProperty("editableToUser")){o._next.editable=o.editableToUser;}if(o.hasOwnProperty("visibleToUser")){o._next.visible=o.visibleToUser;}}return o._hasSettings;};
g.prototype._getDynamicField=function(){var f=this.getAggregation("_dynamicField");if(!f){var f=new M({showValueHelp:false});this.setAggregation("_dynamicField",f);}return f;};
g.prototype._hideDynamicField=function(){var D=this._getDynamicField(),f=this.getAggregation("_field");if(D.getDomRef()){var S=D.getDomRef().parentNode.style;S.width="1px";S.opacity=0;S=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="visible";S.width="100%";S.opacity=1;}};
g.prototype._showDynamicField=function(){var D=this._getDynamicField(),f=this.getAggregation("_field");if(D.getDomRef()){var S=D.getDomRef().parentNode.style;S.width="100%";S.opacity=1;S=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="hidden";S.width="1px";S.opacity=0;}};
g.prototype._setCurrentProperty=function(p,v){if(this._getCurrentProperty(p)!==v){this.getModel("currentSettings").setProperty(p,v,this.getBindingContext("currentSettings"));}};
g.prototype._getCurrentProperty=function(p){return this.getModel("currentSettings").getProperty(p,this.getBindingContext("currentSettings"));};
g.prototype._applySettings=function(D){var b=this._getDynamicField(),o=this.getModel("contextflat")._getValueObject(D.value);b.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){b.setEnabled(false);}if(o&&o.path!=="empty"){if(o.object.value&&o.object.value.indexOf("{{")==0){this._setCurrentProperty("value",o.object.value);}else{this._setCurrentProperty("value",o.value);}b.addToken(new T({text:o.object.label,"delete":function(){this._setCurrentProperty("value","");if(!this._hasDynamicValue()){this._hideDynamicField();}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus();}.bind(this),100);}.bind(this)}));}else{this._setCurrentProperty("value",D.value);this._setCurrentProperty("_changed",D._changed);this._hideDynamicField();}this._setCurrentProperty("_next",D._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}else{this._showDynamicField();}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null;};
g.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}};
g.prototype._applyButtonStyles=function(){if(!this._settingsButton){return;}if(!this._hasDynamicValue()){this._settingsButton.removeStyleClass("dynamicvalue");}else{this._settingsButton.addStyleClass("dynamicvalue");}if(!this._hasSettings()){this._settingsButton.removeStyleClass("settings");}else{this._settingsButton.addStyleClass("settings");}};
g.prototype.isFilterBackend=function(){var o=this.getConfiguration();var i=false;if(o&&o.values&&o.values.data){if(o.values.data.request&&o.values.data.request.parameters&&o.values.data.request.parameters.$filter&&o.values.data.request.parameters.$filter.indexOf("{currentSettings>suggestValue}")>-1){i=true;}else if(o.values.data.request&&o.values.data.request.url&&o.values.data.request.url.indexOf("{currentSettings>suggestValue}")>-1){i=true;}}return i;};
g.prototype.formatListItem=function(i){var I=new L();for(var k in i){I.bindProperty(k,c.createBindingInfos(i[k]));}return I;};
return g;});
sap.ui.predefine('sap/ui/integration/editor/fields/BooleanField',["sap/ui/integration/editor/fields/BaseField","sap/m/CheckBox"],function(B,C){"use strict";
var a=B.extend("sap.ui.integration.editor.fields.BooleanField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
a.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:C,settings:{selected:{path:'currentSettings>value'},editable:c.editable}};c.withLabel=true;}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/editor/fields/DateField',["sap/ui/integration/editor/fields/BaseField","sap/m/DatePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.editor.fields.DateField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
a.prototype.initVisualization=function(c){var v=c.visualization;var o=c.formatter;if(c.value!==""){c.value=new Date(c.value);}if(!v){v={type:D,settings:{value:{path:"currentSettings>value",type:'sap.ui.model.type.Date',formatOptions:o},editable:c.editable,width:"100%",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("value").setValue(s.getDateValue());s.getBinding("value").checkUpdate();}else{var s=e.getSource();s.getBinding("value").setValue("");}}}};}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/editor/fields/DateTimeField',["sap/ui/integration/editor/fields/BaseField","sap/m/DateTimePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.editor.fields.DateTimeField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
a.prototype.initVisualization=function(c){var v=c.visualization;var o=c.formatter;if(c.value!==""){c.value=new Date(c.value);}if(!v){v={type:D,settings:{value:{path:"currentSettings>value",type:'sap.ui.model.type.DateTime',formatOptions:o},editable:c.editable,width:"100%",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("value").setValue(s.getDateValue().toISOString());s.getBinding("value").checkUpdate();}else{var s=e.getSource();s.getBinding("value").setValue("");s.getBinding("value").checkUpdate(true);}}}};}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/editor/fields/DestinationField',["sap/ui/integration/editor/fields/BaseField","sap/m/Select","sap/ui/core/ListItem"],function(B,S,L){"use strict";
var D=B.extend("sap.ui.integration.editor.fields.DestinationField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
D.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:S,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},forceSelection:false,width:"100%",items:{path:"currentSettings>_values",template:new L({text:"{currentSettings>name}",key:"{currentSettings>name}"})}}};}this._visualization=v;};
return D;});
sap.ui.predefine('sap/ui/integration/editor/fields/IntegerField',["sap/ui/integration/editor/fields/BaseField","sap/m/Input"],function(B,I){"use strict";
var a=B.extend("sap.ui.integration.editor.fields.IntegerField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
a.prototype.initVisualization=function(c){var v=c.visualization;var f=c.formatter;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:'sap.ui.model.type.Integer',formatOptions:f},editable:c.editable,type:"Number"}};}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/editor/fields/ListField',["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/MultiComboBox","sap/ui/core/ListItem","sap/base/util/each","sap/base/util/restricted/_debounce","sap/base/util/restricted/_isEqual","sap/base/util/ObjectPath","sap/base/util/includes","sap/ui/core/SeparatorItem","sap/ui/core/Core","sap/ui/model/Sorter","sap/base/util/deepClone"],function(B,I,T,M,L,e,_,b,O,i,S,C,c,d){"use strict";var D="#";var r=C.getLibraryResourceBundle("sap.ui.integration");
var f=B.extend("sap.ui.integration.editor.fields.ListField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
f.prototype.initVisualization=function(o){if(r&&r.sLocale!==C.getConfiguration().getLanguage()){r=C.getLibraryResourceBundle("sap.ui.integration");}var t=this;var v=o.visualization;if(!v){if(o.values){var g=this.formatListItem(o.values.item);v={type:M,settings:{selectedKeys:{path:'currentSettings>value'},busy:{path:'currentSettings>_loading'},editable:o.editable,visible:o.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:g,sorter:[new c({path:'Selected',descending:false,group:true})],groupHeaderFactory:t.getGroupHeader}}};if(this.isFilterBackend()){v.settings.selectedKeys={parts:['currentSettings>value','currentSettings>suggestValue'],formatter:function(V,s){if(s){t.setSuggestValue();}return V;}};}}else{v={type:I,settings:{value:{path:'currentSettings>value',formatter:function(a){a=a||[];return a.join(",");}},change:function(E){var s=E.getSource();s.getBinding("value").setRawValue(s.getValue().split(","));},editable:o.editable,visible:o.visible,placeholder:o.placeholder}};}}this._visualization=v;this.attachAfterInit(this._afterInit);};
f.prototype._afterInit=function(){var o=this.getAggregation("_field");if(o instanceof M){var a=this.getConfiguration();var m=this.getModel();this.prepareFieldsInKey(a);if(this.isFilterBackend()){this.onInput=_(this.onInput,500);o.oninput=this.onInput;o.attachSelectionChange(this.onSelectionChangeForFilterBackend);o.attachSelectionFinish(this.onSelectionFinishForFilterBackend);m.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);}else{o.attachSelectionChange(this.onSelectionChange);m.attachPropertyChange(this.onPropertyChange,this);}}};
f.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator=D;}var k=o.values.item.key;this._aFields=k.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};
f.prototype.getKeyFromItem=function(o){var s="";this._aFields.forEach(function(a){s+=o[a].toString()+this._sKeySeparator;}.bind(this));if(s.endsWith(this._sKeySeparator)){s=s.substring(0,s.length-this._sKeySeparator.length);}return s;};
f.prototype.onPropertyChangeForFilterBackend=function(E){var o=this.getConfiguration();if(!o.valueItems){o.valueItems=[];}var p=o.values.data.path||"/";var v=this.getModel();var a=v.getData();if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");var R=O.get(P,a);R=this.mergeSelectedItems(o,R);O.set(P,R,a);}else{a=this.mergeSelectedItems(o,a);}v.setData(a);this.setSuggestValue();};
f.prototype.onPropertyChange=function(E){var o=this.getAggregation("_field");var s=o.getSelectedItems().map(function(h){return h.getKey();});var a=this.getBindingContext("currentSettings").sPath;var g=this.getModel("currentSettings");g.setProperty(a+"/value",s);};
f.prototype.mergeSelectedItems=function(o,a){if(Array.isArray(a)){var s=o.valueItems.map(function(l){return this.getKeyFromItem(l);}.bind(this));var g=a.filter(function(l){var m=this.getKeyFromItem(l);return!i(s,m);}.bind(this));var h=g.filter(function(l){return l.Selected===r.getText("EDITOR_ITEM_SELECTED");});o.valueItems=o.valueItems.concat(h);var n=g.filter(function(l){return l.Selected!==r.getText("EDITOR_ITEM_SELECTED");});a=o.valueItems.concat(n);var j=this.getAggregation("_field");if(j.isOpen()){s=o.valueItems.map(function(l){return this.getKeyFromItem(l);}.bind(this));var k=j.getSelectedKeys();if(!b(s,k)){j.setSelectedKeys(s);}}}else{a=o.valueItems;}return a;};
f.prototype.setSuggestValue=function(){var o=this.getAggregation("_field");var s=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");var g=a.getProperty(s+"/suggestValue");if(g&&g!==""){o.setValue(g.replaceAll("\'\'","'"));}};
f.prototype.getSuggestValue=function(){var s=this.getBindingContext("currentSettings").sPath;var o=this.getModel("currentSettings");return o.getProperty(s+"/suggestValue");};
f.prototype.getGroupHeader=function(g){return new S({text:g.key});};
f.prototype.onSelectionChangeForFilterBackend=function(E){var F=E.oSource.getParent();var o=F.getConfiguration();var l=E.getParameter("changedItem");var s=l.getKey();var a=E.getParameter("selected");var g=this.getModel().getData();var p=o.values.data.path||"/";var P,h;if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}P=p.split("/");h=O.get(P,g);}else{h=g;}if(h){if(!o.valueItems){o.valueItems=[];}var n=[];h.forEach(function(j){var N=d(j,500);var k=F.getKeyFromItem(N);if(k===s){if(a){N.Selected=r.getText("EDITOR_ITEM_SELECTED");o.valueItems=o.valueItems.concat([N]);}else{N.Selected=r.getText("EDITOR_ITEM_UNSELECTED");o.valueItems=o.valueItems.filter(function(m){var k=F.getKeyFromItem(m);return k!==s;});}}n.push(N);});if(P!==undefined){O.set(P,n,g);this.getModel().checkUpdate(true);}else{this.getModel().setData(n);}}};
f.prototype.onSelectionChange=function(E){var F=E.oSource.getParent();var o=F.getConfiguration();var l=E.getParameter("changedItem");var s=l.getKey();var a=E.getParameter("selected");var g=this.getModel().getData();var p=o.values.data.path||"/";if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");var R=O.get(P,g);if(Array.isArray(R)){for(var n in R){var h=F.getKeyFromItem(R[n]);if(h===s){if(a){R[n].Selected=r.getText("EDITOR_ITEM_SELECTED");}else{R[n].Selected=r.getText("EDITOR_ITEM_UNSELECTED");}}}O.set(P,R,g);}}else if(Array.isArray(g)){for(var n in g){var h=F.getKeyFromItem(g[n]);if(h===s){if(a){g[n].Selected=r.getText("EDITOR_ITEM_SELECTED");}else{g[n].Selected=r.getText("EDITOR_ITEM_UNSELECTED");}}}}this.getModel().setData(g);this.getModel().checkUpdate(true);};
f.prototype.onSelectionFinishForFilterBackend=function(E){var F=this.getParent();var o=F.getConfiguration();var s=E.getParameter("selectedItems").map(function(k){return k.getKey();});var a=this.getModel().getData();var p=o.values.data.path||"/";if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");a=O.get(P,a);}if(a){o.valueItems=a.filter(function(k){var l=F.getKeyFromItem(k);return i(s,l);});}var g=this.getBindingContext("currentSettings").sPath;var h=this.getModel("currentSettings");h.setProperty(g+"/value",s);var j=F.getSuggestValue();if(j&&j!==""){h.setProperty(g+"/suggestValue","");}};
f.prototype.onInput=function(E){var t=E.target.value;var s=this.getBindingContext("currentSettings").sPath;var o=this.getModel("currentSettings");o.setProperty(s+"/suggestValue",t.replaceAll("'","\'\'"));o.setProperty(s+"/_loading",true);E.srcControl.open();E.srcControl._getSuggestionsPopover()._sTypedInValue=t;};
return f;});
sap.ui.predefine('sap/ui/integration/editor/fields/NumberField',["sap/ui/integration/editor/fields/BaseField","sap/m/Input"],function(B,I){"use strict";
var N=B.extend("sap.ui.integration.editor.fields.NumberField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
N.prototype.initVisualization=function(c){var v=c.visualization;var f=c.formatter;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:'sap.ui.model.type.Float',formatOptions:f},editable:c.editable,type:"Number"}};}this._visualization=v;};
return N;});
sap.ui.predefine('sap/ui/integration/editor/fields/StringField',["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/List","sap/m/CustomListItem","sap/m/VBox","./viz/IconSelect","sap/base/util/each","sap/base/util/restricted/_debounce","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/ui/integration/editor/EditorResourceBundles","sap/base/util/deepClone","sap/ui/model/Sorter","sap/ui/core/SeparatorItem","sap/base/util/includes","sap/base/util/merge","sap/ui/core/CustomData"],function(B,I,T,a,S,C,P,b,O,c,L,d,e,V,f,g,_,h,J,E,j,k,l,m,n,o){"use strict";var R=/parameters\.([^\}\}]+)/g;var s=["TODAY_ISO","NOW_ISO","LOCALE"];
var q=B.extend("sap.ui.integration.editor.fields.StringField",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer()
});
q.prototype.initVisualization=function(p){var v=p.visualization;if(!v){var r=p.value?p.value.match(R):undefined;var t,u,w;if(r&&r.length>0){r=r.filter(function(i){var y=i.substring(11);return!m(s,y);});}if(r&&r.length>0){t=r.map(function(i){if(this.isOrigLangField){return"items>"+i.substring(11)+"/_language/value";}return"items>"+i.substring(11)+"/value";}.bind(this));t.unshift("currentSettings>value");u={parts:t,formatter:function(y){var A=Array.prototype.slice.call(arguments,1);for(var i=0;i<A.length;i++){if(A[i]){y=y.replaceAll("{{"+r[i]+"}}",A[i]);}}return y;}};w=function(i){var y=i.getSource().getValue();var z=this.getBindingContext("currentSettings").sPath;var A=this.getModel("currentSettings");A.setProperty(z+"/value",y);var D=A.getBindings();var F=z.substring(z.lastIndexOf("/")+1);g(D,function(G,H){if(H.sPath==="/form/items/"+F+"/value"){H.checkUpdate(true);}});}.bind(this);}if(this.getMode()==="translation"){if(p.editable){v={type:I,settings:{value:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},editable:p.editable,visible:p.visible,placeholder:p.placeholder}};}else{v={type:T,settings:{text:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},visible:p.visible,wrapping:false}};}}else if(p.enum){var x=new L({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});v={type:S,settings:{selectedKey:{path:'currentSettings>value'},forceSelection:false,editable:p.editable,visible:p.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:x}}};}else if(p.values){var x=this.formatListItem(p.values.item);if(!p.values.item.key){p.values.item.key=p.values.item.text;}v={type:C,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},editable:p.editable,visible:p.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:x}}};if(this.isFilterBackend()){v.settings.selectedKey={parts:['currentSettings>value','currentSettings>suggestValue'],formatter:function(i,y){if((!i||i==="")&&y){return y.replaceAll('\'\'',"'");}else{return i;}}};}}else{v={type:I,settings:{value:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},editable:p.editable,visible:p.visible,placeholder:p.placeholder}};if(t){delete v.settings.tooltip;v.settings.value=u;v.settings.change=w;}}}this._visualization=v;this.attachAfterInit(this._afterInit);};
q.prototype._afterInit=function(){var i=this.getAggregation("_field");if(i instanceof C){if(this.isFilterBackend()){this.onInput=_(this.onInput,500);i.oninput=this.onInput;i.attachSelectionChange(this.onSelectionChange);}}};
q.prototype.onSelectionChange=function(i){var p=i.getParameter("selectedItem")||{};var K=p.getKey();var r=this.getBindingContext("currentSettings").sPath;var t=this.getModel("currentSettings");t.setProperty(r+"/value",K);};
q.prototype.onInput=function(i){var t=i.target.value;var p=this.getBindingContext("currentSettings").sPath;var r=this.getModel("currentSettings");r.setProperty(p+"/suggestValue",t.replaceAll("'","\'\'"));r.setProperty(p+"/_loading",true);r.setProperty(p+"/value","");var u=r.getBindings();var v=p.substring(p.lastIndexOf("/")+1);g(u,function(x,y){if(y.sPath==="/form/items/"+v+"/value"){y.checkUpdate(true);}});var w=i.srcControl;w.open();w.setValue(t);w.setSelection(null);};
q.prototype.getOriginTranslatedValues=function(i){var r=[];var t=E.getInstance(i._resourceBundleURL);for(var p in t){var u=t[p];var K;if(i._translatedDefaultPlaceholder.startsWith("{i18n>")&&i._translatedDefaultPlaceholder.endsWith("}")){K=i._translatedDefaultPlaceholder.substring(6,i._translatedDefaultPlaceholder.length-1);}else if(i._translatedDefaultPlaceholder.startsWith("{{")&&i._translatedDefaultPlaceholder.endsWith("}}")){K=i._translatedDefaultPlaceholder.substring(2,i._translatedDefaultPlaceholder.length-2);}var v="";var w="";if(K&&u){var x=u.resourceBundle.getText(K,[],true);if(x!==undefined){v=x;w=x;}}else{v=i._translatedDefaultPlaceholder;w=i._translatedDefaultPlaceholder;}var y={"key":p,"desription":u.language,"value":v,"originValue":w,"editable":true};r.push(y);}return r;};
q.prototype.openTranslationListPopup=function(i){var t=this;var p=i.getSource();var F=p.getParent();var r=F.getConfiguration();if(!t._aOriginTranslatedValues){t._aOriginTranslatedValues=F.getOriginTranslatedValues(r);}var u=j(t._aOriginTranslatedValues,500);var v=h.getLibraryResourceBundle("sap.ui.integration");u.forEach(function(y){if(r.valueTranslations&&r.valueTranslations[y.key]){y.value=r.valueTranslations[y.key];if(!m(t._aUpdatedLanguages,y.key)){y.originValue=y.value;}}y.status=v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");if(y.key===v.sLocale){y.editable=false;}});var w={"currentLanguage":{},"isUpdated":false,"translatedLanguages":[]};var M;if(u){u.forEach(function(y){if(m(t._aUpdatedLanguages,y.key)){y.value=r.valueTranslations[y.key];y.status=v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED");}if(y.key===v.sLocale){y.value=p.getValue();w.currentLanguage=y;}else{w.translatedLanguages.push(y);}});}if(!t._oTranslationPopover){var x=new d({items:{path:"languages>/translatedLanguages",template:new e({content:[new V({items:[new T({text:"{languages>desription}"}),new I({value:"{languages>value}",editable:"{languages>editable}"})]})],customData:[new o({key:"{languages>key}",value:"{languages>desription}"})]}),sorter:[new k({path:'status',descending:true,group:true})],groupHeaderFactory:t.getGroupHeader}});t._oTranslationPopover=new P({placement:"Right",contentWidth:"300px",contentHeight:"345px",customHeader:new V({items:[new a({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new a({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new V({items:[new T({text:"{languages>/currentLanguage/desription}"}),new I({value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new a({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:x,footer:new O({content:[new c(),new b({type:"Emphasized",text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var y=t._oTranslationPopover.getModel("languages").getData();var z=j(r.valueTranslations,500);var A={};var U=[];y.translatedLanguages.forEach(function(D){if(D.value!==D.originValue){A[D.key]=D.value;U.push(D.key);}});if(y.currentLanguage.value!=y.currentLanguage.originValue){A[y.currentLanguage.key]=y.currentLanguage.value;U.push(y.currentLanguage.key);}if(A!=={}){r.valueTranslations=n(z,A);r._changed=true;}if(U.length>0){t._aUpdatedLanguages=U;}t._oTranslationPopover.close();}}),new b({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){t._oTranslationPopover.close();}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");M=new J(w);M.attachPropertyChange(function(i){var D=M.getData();var U=v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED");var N=v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");var y=false;D.translatedLanguages.forEach(function(z){if(z.value!==z.originValue){z.status=U;y=true;}else{z.status=N;}});D.isUpdated=y;M.setData(D);M.checkUpdate(true);});t._oTranslationPopover.setModel(M,"languages");}else{M=t._oTranslationPopover.getModel("languages");M.setData(w);M.checkUpdate(true);}t._oTranslationPopover.openBy(p);};
q.prototype.getGroupHeader=function(G){return new l({text:G.key});};
return q;});
sap.ui.predefine('sap/ui/integration/editor/fields/viz/ColorSelect',["sap/ui/core/Control","sap/m/ColorPalettePopover","sap/m/Button","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,a,B,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.editor.fields.viz.ColorSelect",{
metadata:{library:"sap.ui.integration",properties:{enumValue:{type:"string",defaultValue:""},colorValue:{type:"string",defaultValue:""},editable:{type:"boolean",defaultValue:true},colorEnum:{type:"string",defaultValue:"sap.m.AvatarColor"},background:{type:"boolean",defaultValue:true},allowCustomColors:{type:"boolean",defaultValue:false}},aggregations:{_colorpalette:{type:"sap.m.ColorPalettePopover",multiple:false,visibility:"hidden"},_button:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},
renderer:function(r,f){var g=f.getAggregation("_button");r.openStart("div");r.addClass("sapUiIntegrationColorSelect");r.writeClasses();r.writeStyles();r.writeElementData(f);r.openEnd();r.renderControl(g);r.close("div");}
});
var e={};
function s(){var v=["sapUiAccent1","sapUiAccent2","sapUiAccent3","sapUiAccent4","sapUiAccent5","sapUiAccent6","sapUiAccent7","sapUiAccent8","sapUiAccent9","sapUiAccent10","sapUiTileIconColor","sapUiContentImagePlaceholderBackground"];var p=P.get({name:v,callback:function(_){}});if(p){e={"sap.m.AvatarColor":{"Accent1":p["sapUiAccent1"],"Accent2":p["sapUiAccent2"],"Accent3":p["sapUiAccent3"],"Accent4":p["sapUiAccent4"],"Accent5":p["sapUiAccent5"],"Accent6":p["sapUiAccent6"],"Accent7":p["sapUiAccent7"],"Accent8":p["sapUiAccent8"],"Accent9":p["sapUiAccent9"],"Accent10":p["sapUiAccent10"],"TileIcon":p["sapUiTileIconColor"],"Transparent":"transparent","Placeholder":p["sapUiContentImagePlaceholderBackground"]}};}}
s();b.attachThemeChanged(s);var o,d=new a("oColorPalettePopoverFull",{colorSelect:function(E){var f=E.getParameter("value"),g=e[o.getColorEnum()],i=Object.values(g).indexOf(f);o.setEnumValue(Object.keys(g)[i]);o.setColorValue(f);o._colorValue=f;}});
c.prototype.init=function(){this._oButton=new B({icon:"sap-icon://color-fill",press:function(){this._openPalette();}.bind(this)});this._colorValue="transparent";this.setAggregation("_button",this._oButton);};
c.prototype.onBeforeRendering=function(){if(!this._oStyle){this._oStyle=document.createElement("style");this._oStyle.innerHTML="#"+this.getId()+" .sapUiIcon::before { color: "+this._colorValue+" !important}";document.body.appendChild(this._oStyle);}var r=this._oStyle.sheet.rules[0];if(!this._colorValue||this._colorValue==="transparent"){r.style.opacity="0.5";r.style.color="transparent";r.style.backgroundSize="10px 10px";r.style.backgroundPosition="0px 0px, 0px 10px, 10px -10px, -10px 10px";r.style.border="1px dashed #808080";r.style.padding="0px 0px";r.style.backgroundImage="linear-gradient(45deg, #ddd 25%, transparent 25%), linear-gradient(-45deg, #ddd 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #ddd 75%), linear-gradient(-45deg, transparent 75%, #ddd 75%)";}else{r.style.textShadow="unset";r.style.opacity="unset";r.style.backgroundSize="unset";r.style.backgroundPosition="unset";r.style.border="unset";r.style.padding="unset";r.style.backgroundImage="unset";r.style.color=this._colorValue;}};
c.prototype._openPalette=function(){o=this;d.setShowDefaultColorButton(true);d.setShowMoreColorsButton(false);d.setDefaultColor("");var E=e[this.getColorEnum()];if(E){var f=[];for(var n in E){f.push(E[n]);}d.setColors(f);}d.openBy(this._oButton);};
c.prototype.setEnumValue=function(v){this.setProperty("enumValue",v,true);this._colorValue=e[this.getColorEnum()][v];this.rerender();};
c.prototype.bindProperty=function(p,f){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var g=m({},f);this._oButton.bindProperty("enabled",g);}return this;};
return c;});
sap.ui.predefine('sap/ui/integration/editor/fields/viz/IconSelect',["sap/ui/core/Control","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone"],function(C,S,L,J,I,m,c,d){"use strict";var r=c.getLibraryResourceBundle("sap.ui.integration"),D;
var e=C.extend("sap.ui.integration.editor.fields.viz.IconSelect",{
metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"sap-icon://accept"},editable:{type:"boolean",defaultValue:true},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true}},aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},
renderer:function(R,o){var s=o.getAggregation("_select");R.openStart("div");R.addClass("sapUiIntegrationIconSelect");if(s&&o.getWidth){R.addStyle("width",s.getWidth());}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();R.renderControl(s);R.close("div");}
});
e.prototype._initIconModel=function(){var i=I.getIconNames();i=i.sort(function(a,b){return a.toLowerCase().localeCompare(b.toLowerCase());});var f=[];if(!D){i.filter(function(s){var t=I.getIconInfo(s).text||("-"+s).replace(/-(.)/ig,function(M,a){return" "+a.toUpperCase();}).substring(1);f.push({icon:"sap-icon://"+s,key:"sap-icon://"+s,text:t,tooltip:t,enabled:true});});D=d(f,500);}else{f=d(D,500);}f=[{icon:"",text:r.getText("EDITOR_ICON_NONE"),tooltip:"",key:"empty",enabled:true},{icon:"sap-icon://upload",text:r.getText("EDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true},{icon:"sap-icon://download",text:r.getText("EDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false}].concat(f);this._oIconModel=new J(f);this._oIconModel.setSizeLimit(f.length);};
e.prototype.init=function(){if(r&&r.sLocale!==c.getConfiguration().getLanguage()){r=c.getLibraryResourceBundle("sap.ui.integration");}if(!this._oIconModel){this._initIconModel();}var i=new L({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",enabled:"{iconlist>enabled}"});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oSelect=new S({width:"100%",items:{path:"iconlist>/",template:i},change:function(E){var s=E.getSource(),a=E.getSource().getSelectedKey();if(a==="file"){s._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);s.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack);}else{this.setValue(a);}}.bind(this)});this._oSelect.setModel(this._oIconModel,"iconlist");var o=this._oSelect.open;this._oSelect.open=function(){o&&o.apply(this,arguments);this.getPicker().addStyleClass("sapUiIntegrationIconSelectList");this.getPicker().setContentHeight("400px");};this._oSelect.addDelegate({onAfterRendering:function(){var a=this._oSelect.getDomRef("labelIcon");if(a){var s=this._oSelect._customImage;if(s){a.style.backgroundImage="url('"+s+"')";a.classList.add("sapMSelectListItemIconCustom");}else{a.style.backgroundImage="unset";a.classList.remove("sapMSelectListItemIconCustom");}}}.bind(this)});this._oSelect.addDelegate({onsappageup:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();this._oSelect.setSelectedIndex(s-50);}}.bind(this),onsappagedown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s<3){this._oSelect.setSelectedIndex(29);}else{this._oSelect.setSelectedIndex(s+50);}}}.bind(this),onsapup:function(){if(this._oSelect.isOpen()){var a=this.getAllowFile();var A=this.getAllowNone();var f=this._oIconModel.getProperty("/2/enabled");var s=this._oSelect.getSelectedIndex();if(s>11+2){this._oSelect.setSelectedIndex(s-11);}else if(s>=3){if(A&&!a){this._oSelect.setSelectedIndex(0);}else if(f){this._oSelect.setSelectedIndex(2);}else{this._oSelect.setSelectedIndex(3);}}}}.bind(this),onsapdown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s>1){this._oSelect.setSelectedIndex(s+11);}}}.bind(this),onsapleft:function(){if(this._oSelect.isOpen()){this._oSelect.onsapup.apply(this._oSelect,arguments);}}.bind(this),onsapright:function(){if(this._oSelect.isOpen()){this._oSelect.onsapdown.apply(this._oSelect,arguments);}}.bind(this)},true);this.setAggregation("_select",this._oSelect);};
e.prototype._fileUploadChange=function(){var f=new window.FileReader();f.onload=function(){this.setValue(f.result);this._oSelect.invalidate();}.bind(this);if(this._oFileUpload.files.length===1){f.readAsDataURL(this._oFileUpload.files[0]);}};
e.prototype._focusBack=function(){this._oSelect.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue());}.bind(this),150);};
e.prototype.bindProperty=function(p,b){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},b);this._oSelect.bindProperty("editable",s);}return this;};
e.prototype.setValue=function(v){this.setProperty("value",v,true);if(v&&v.indexOf("data:image/")===0){this._oSelect._customImage=v;this._oIconModel.setProperty("/2/enabled",true);this._oSelect.setSelectedKey("selected");}else{this._oSelect._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oSelect.setSelectedKey(v);}this._oSelect.invalidate();return this;};
e.prototype.setAllowFile=function(v){this.setProperty("allowFile",v,true);v=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",v);return this;};
e.prototype.setAllowNone=function(v){this.setProperty("allowNone",v,true);v=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",v);return this;};
return e;});
sap.ui.predefine('sap/ui/integration/editor/fields/viz/ShapeSelect',["sap/ui/core/Control","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,S,a,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.editor.fields.viz.ShapeSelect",{
metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"Circle"},editable:{type:"boolean",defaultValue:true}},aggregations:{_segmentedbutton:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){var s=o.getAggregation("_segmentedbutton");r.openStart("div");r.addClass("sapUiIntegrationShapeSelect");r.writeClasses();r.writeStyles();r.writeElementData(o);r.openEnd();r.renderControl(s);r.close("div");}
});
c.prototype.init=function(){this._oSegmentedButton=new S({items:[new a({icon:"sap-icon://circle-task",key:"Circle"}),new a({icon:"sap-icon://border",key:"Square"})]});this.setAggregation("_segmentedbutton",this._oSegmentedButton);};
c.prototype.bindProperty=function(p,B){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},B);this._oSegmentedButton.bindProperty("enabled",s);}if(p==="value"){var s=m({},B);this._oSegmentedButton.bindProperty("selectedKey",s);}return this;};
return c;});
sap.ui.predefine('sap/ui/integration/formatters/DateTimeFormatter',["sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/integration/util/Utils"],function(D,U,a){"use strict";var d={dateTime:function(v,f,l){var A=a.processFormatArguments(f,l),o=D.getDateTimeInstance(A.formatOptions,A.locale),p=a.parseJsonDateTime(v);var u=new U(p);var F=o.format(u);return F;},date:function(v,f,l){return d.dateTime.apply(this,arguments);}};return d;});
sap.ui.predefine('sap/ui/integration/formatters/IconFormatter',["sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/core/IconPool"],function(M,C,I){"use strict";
var a=M.extend("sap.ui.integration.formatters.IconFormatter",{metadata:{library:"sap.ui.integration",properties:{destinations:{type:"object"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});
a.prototype.formatSrc=function(u){if(!u){return u;}if(u.startsWith("data:")||I.isIconURI(u)){return u;}if(this.getDestinations().hasDestination(u)){return this.getDestinations().processString(u).then(function(r){return this._format(r);}.bind(this));}return this._format(u);};
a.prototype._format=function(u){return this._getCardInstance().getRuntimeUrl(u);};
a.prototype._getCardInstance=function(){return C.byId(this.getCard());};
return a;});
sap.ui.predefine('sap/ui/integration/formatters/NumberFormatter',["sap/ui/core/format/NumberFormat","sap/ui/integration/util/Utils"],function(N,U){"use strict";var n={currency:function(c,C,f,l){var s=U.processFormatArguments(f,l),o=N.getCurrencyInstance(s.formatOptions,s.locale);return o.format(c,C);},"float":function(f,F,l){var s=U.processFormatArguments(F,l),o=N.getFloatInstance(s.formatOptions,s.locale);return o.format(f);},integer:function(i,f,l){var s=U.processFormatArguments(f,l),I=N.getIntegerInstance(s.formatOptions,s.locale);return I.format(i);},percent:function(p,f,l){var s=U.processFormatArguments(f,l),P=N.getPercentInstance(s.formatOptions,s.locale);return P.format(p);},unit:function(u,s,f,l){var S=U.processFormatArguments(f,l),o=N.getUnitInstance(S.formatOptions,S.locale);return o.format(u,s);}};return n;});
sap.ui.predefine('sap/ui/integration/formatters/TextFormatter',["sap/base/strings/formatMessage"],function(f){"use strict";var t={text:function(p,v){return f(p,v);}};return t;});
sap.ui.predefine('sap/ui/integration/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/m/library","sap/f/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.integration",version:"1.96.3",dependencies:["sap.ui.core","sap.f","sap.m"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem"],elements:["sap.ui.integration.ActionDefinition","sap.ui.integration.Host"],customElements:{"card":"sap/ui/integration/customElements/CustomElementCard"}});var t=sap.ui.integration;t.CardActionType={Navigation:"Navigation",Submit:"Submit",Custom:'Custom'};t.CardDataMode={Active:"Active",Inactive:"Inactive",Auto:"Auto"};t.CardActionArea={None:"None",Content:"Content",ContentItem:"ContentItem",ActionsStrip:"ActionsStrip",ContentItemDetail:"ContentItemDetail",Header:"Header"};t.CardArea={Header:"Header",Filters:"Filters",Content:"Content"};t.AttributesLayoutType={OneColumn:"OneColumn",TwoColumns:"TwoColumns"};t.CardMenuAction=D.createType("sap.ui.integration.CardMenuAction",{isValid:function(v){var p=["type","text","icon","tooltip","buttonType","enabled","visible","action","parameters","target","url"];return Object.keys(v).every(function(k){return p.indexOf(k)!==-1;});}},"object");return t;});
sap.ui.predefine('sap/ui/integration/model/ContextModel',["sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/Utils"],function(J,L,U){"use strict";
var C=J.extend("sap.ui.integration.model.ContextModel",{constructor:function(d,o){J.apply(this,arguments);this._aPendingPromises=[];}});
C.prototype.setHost=function(h){this._oHost=h;this.resetHostProperties();};
C.prototype.getProperty=function(p,c){if(p&&!p.startsWith("/")&&!c){p="/"+p;}var h=this._oHost,a=this.resolve(p,c),b,H=h&&h.getContextValue;if(H){this._mValues=this._mValues||{};if(this._mValues[a]!==undefined){return this._mValues[a];}b=U.timeoutPromise(h.getContextValue(a.substring(1)));b=b.then(function(v){this._mValues[a]=v;this.checkUpdate();}.bind(this)).catch(function(r){this._mValues[a]=null;this.checkUpdate();L.error("Path "+a+" could not be resolved. Reason: "+r);}.bind(this));this._aPendingPromises.push(b);return null;}else{return J.prototype.getProperty.apply(this,arguments);}};
C.prototype.resetHostProperties=function(){this._mValues={};};
C.prototype.waitForPendingProperties=function(){var p=Promise.all(this._aPendingPromises);this._aPendingPromises=[];return p;};
return C;},true);
sap.ui.predefine('sap/ui/integration/model/ObservableModel',["sap/ui/model/json/JSONModel","sap/ui/model/ClientPropertyBinding","sap/base/util/deepEqual","sap/base/util/deepClone"],function(J,C,d,a){"use strict";
var O=J.extend("sap.ui.integration.model.ObservableModel",{constructor:function(D,o){J.apply(this,arguments);this._observedBinding=new C(this,"/",this.getContext("/"));this._observedBinding.attachChange(this._handleChange.bind(this));this._fireChangeBound=this._fireChange.bind(this);}});
O.prototype.destroy=function(){this._observedBinding.destroy();this._observedBinding=null;clearTimeout(this._iFireChangeCallId);};
O.prototype._handleChange=function(){this._scheduleFireChange();};
O.prototype._scheduleFireChange=function(){if(this._iFireChangeCallId){clearTimeout(this._iFireChangeCallId);}this._iFireChangeCallId=setTimeout(this._fireChangeBound,0);};
O.prototype._fireChange=function(){this.fireEvent("change");};
return O;});
sap.ui.predefine('sap/ui/integration/services/Data',['./Service'],function(S){"use strict";var D=S.extend();
D.prototype.attachDataChanged=function(d,p){};
D.prototype.detachDataChanged=function(d){};
D.prototype.getData=function(i){return Promise.resolve(false);};
return D;});
sap.ui.predefine('sap/ui/integration/services/Navigation',['./Service'],function(S){"use strict";var N=S.extend();
N.prototype.navigate=function(c){};
N.prototype.enabled=function(c){return Promise.resolve(false);};
N.prototype.hidden=function(c){return Promise.resolve(false);};
return N;});
sap.ui.predefine('sap/ui/integration/services/Service',[],function(){"use strict";var S=function(){};
S.extend=function(C){if(!C){var t=this;C=function(){t.apply(this,arguments);};}C.prototype=Object.create(this.prototype);C.prototype.constructor=C;C.extend=this.extend.bind(C);return C;};
S.prototype.getInterface=function(){return this;};
return S;});
sap.ui.predefine('sap/ui/integration/util/BaseFactory',["./BindingHelper","sap/base/util/merge","sap/ui/base/Object"],function(B,m,a){"use strict";
var b=a.extend("sap.ui.integration.util.BaseFactory",{constructor:function(c){a.call(this);this._oCard=c;}});
b.prototype.createBindingInfos=function(M){var r=m({},M),d=r.data;delete r.data;r=B.createBindingInfos(r,this._oCard.getBindingNamespaces());if(d){r.data=d;}return r;};
return b;});
sap.ui.predefine('sap/ui/integration/util/BindingHelper',["sap/ui/base/BindingParser","sap/base/util/extend","sap/ui/integration/formatters/DateTimeFormatter","sap/ui/integration/formatters/NumberFormatter","sap/ui/integration/formatters/TextFormatter","sap/ui/integration/bindingFeatures/DateRange"],function(B,e,D,N,T,a){"use strict";var r=/\{\{([^}]+)\}\}/g,b=/\{\{(parameters\.[^}]+)\}\}/g,c=/\{\{(dataSources\.[^}]+)\}\}/g;var d={};var f={date:D.date,dateTime:D.dateTime,currency:N.currency,"float":N.float,integer:N.integer,percent:N.percent,text:T.text,unit:N.unit};d.mLocals={"format":f,"dateRange":a};
d.extractBindingInfo=function(v,l){v=d.escapeCardPlaceholders(v);return B.complexParser(v,undefined,true,undefined,undefined,undefined,e({},d.mLocals,l));};
d.createBindingInfos=function(i,l){if(!i){return i;}if(Array.isArray(i)){return i.map(function(i){return d.createBindingInfos(i,l);});}if(typeof i==="object"){var I={};for(var k in i){I[k]=d.createBindingInfos(i[k],l);}return I;}var o=d.extractBindingInfo(i,l);return d.escapeParametersAndDataSources(o||i);};
d.formattedProperty=function(v,F){if(v===undefined){return v;}var o={};if(Array.isArray(v)){o.parts=v.map(function(I){return typeof I==="object"?e({},I):{value:I};});o.formatter=F;}else if(typeof v==="object"){o=e({},v);if(v.formatter){var i=o.formatter;o.formatter=function(){var I=i.apply(this,arguments);return F(I);};}else{o.formatter=F;}}else{o={value:v,formatter:F};}return o;};
d.escapeCardPlaceholders=function(v){if(typeof v!=="string"){return v;}return v.replace(r,"\\{\\{$1\\}\\}");};
d.escapeParametersAndDataSources=function(v){if(typeof v!=="string"){return v;}return v.replace(b,"\\{\\{$1\\}\\}").replace(c,"\\{\\{$1\\}\\}");};
d.isAbsolutePath=function(p){return p.startsWith("/");};
d.prependRelativePaths=function(v,p){if(typeof v!=="object"){return v;}var o=e({},v);if(o.path&&!this.isAbsolutePath(o.path)){o.path=p+"/"+o.path;}if(o.parts){o.parts=o.parts.map(function(g){return d.prependRelativePaths(g,p);});}return o;};
d.propagateModels=function(s,t){var S=e({},s.oPropagatedProperties.oModels,s.oModels),m=Object.keys(S),o=s.getModel();if(o){t.setModel(o);}m.forEach(function(M){if(M==="undefined"){return;}var g=s.getModel(M);if(g){t.setModel(g,M);}});};
d.reuse=function(v){if(typeof v==="object"){return e({},v);}return v;};
return d;});
sap.ui.predefine('sap/ui/integration/util/BindingResolver',["sap/ui/base/ManagedObject","sap/base/Log","sap/ui/model/Model","sap/ui/integration/util/BindingHelper","sap/base/util/extend"],function(M,L,a,B,e){"use strict";
var S=M.extend("sap.ui.integration.util.SimpleControl",{metadata:{library:"sap.ui.integration",properties:{resolved:{type:"any"}}}});
var s=new S();var b={};
function p(v,m,P,c,i){if(c===i){L.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");return v;}if(Array.isArray(v)){return v.map(function(I){return p(I,m,P,c+1,i);});}if(v&&typeof v==="object"&&!b.isBindingInfo(v)){var n={};for(var d in v){n[d]=p(v[d],m,P,c+1,i);}return n;}if(typeof v==="string"||(typeof v==="object"&&b.isBindingInfo(v))){return r(v,m,P);}return v;}
function r(v,m,P){if(!v){return v;}var o=typeof v==="string"?M.bindingParser(v):e({},v);if(!o){return v;}if(!P){P="/";}if(m instanceof a){s.setModel(m);}else{B.propagateModels(m,s);}s.bindObject(P);s.bindProperty("resolved",o);var V=s.getResolved();s.unbindProperty("resolved");s.unbindObject();s.setModel(null);return V;}
b.resolveValue=function(v,m,P){var c=0,i=30;if(m){return p(v,m,P,c,i);}else{return v;}};
b.isBindingInfo=function(o){if(!o){return false;}return o.hasOwnProperty("path")||(o.hasOwnProperty("parts")&&(o.hasOwnProperty("formatter")||o.hasOwnProperty("binding")));};
return b;});
sap.ui.predefine('sap/ui/integration/util/CacheAndRequestDataProvider',["sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/ui/core/Core","sap/base/util/merge"],function(R,L,C,m){"use strict";var S=31536000;
function g(r){var u=r.url,d=r.data,U,p;if(r.method!=="GET"){return r.url;}U=new URL(u,window.location.href);for(p in d){U.searchParams.set(p,d[p]);}return U.href;}
var a=R.extend("sap.ui.integration.util.CacheAndRequestDataProvider",{metadata:{associations:{host:{type:"sap.ui.integration.Host",multiple:false},card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});
a.prototype.init=function(){this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this);};
a.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();R.prototype.destroy.apply(this,arguments);};
a.prototype.getHostInstance=function(){return C.byId(this.getHost());};
a.prototype.getCardInstance=function(){return C.byId(this.getCard());};
a.prototype.getCardInstanceHeader=function(){var c=this.getCardInstance();if(!c){return null;}return c.getCardHeader();};
a.prototype.onDataRequestComplete=function(){var i;if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null;}if(!this._oSettings||!this._oSettings.updateInterval){return;}i=parseInt(this._oSettings.updateInterval);if(isNaN(i)){return;}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache();}.bind(this),i*1000);};
a.prototype._request=function(r){var p,c=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=g(r);this._subscribeToHostMessages();p=R.prototype._request.apply(this,arguments);p.then(function(v){var j=v[1],d=j.getResponseHeader("Date");if(d&&c){this._attachTimestampPress();c.setDataTimestamp((new Date(d)).toISOString());}}.bind(this));return p;};
a.prototype.refreshWithoutCache=function(){var c=this.getCardInstanceHeader();if(c){c.setDataTimestampUpdating(true);}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate();}.bind(this),200);};
a.prototype.refreshFromCache=function(){var c=this.getCardInstanceHeader();if(c){c.setDataTimestampUpdating(true);}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate();}.bind(this),200);};
a.prototype._prepareHeaders=function(h,s){var c=this.getCardInstance(),H=this.getHostInstance(),d={enabled:true,maxAge:0,staleWhileRevalidate:true},n=m({request:{cache:d}},s),o=n.request.cache;if(o.noStore){o.enabled=false;}if(o.enabled){if(this._bCacheOnly){o.maxAge=S;o.staleWhileRevalidate=false;}else if(this._bNoCache){o.maxAge=0;o.staleWhileRevalidate=false;}}n.request.cache=o;if(H&&H.modifyRequestHeaders){return H.modifyRequestHeaders(Object.assign({},h),n,c);}return h;};
a.prototype._subscribeToHostMessages=function(){var h=this.getHostInstance();if(this._bIsSubscribed){return;}if(!h){return;}h.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true;};
a.prototype._unsubscribeFromHostMessages=function(){var h=this.getHostInstance();if(!h){return;}h.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false;};
a.prototype._handleHostMessage=function(e){var d=e.getParameter("data");if(d.type!=="ui-integration-card-update"){return;}if(d.url!==this._sCurrentRequestFullUrl){return;}L.info("[CARDS CACHE] message ui-integration-card-update received for "+d.url);this.refreshFromCache();};
a.prototype._attachTimestampPress=function(e){var c=this.getCardInstance(),h=this.getCardInstanceHeader();if(this._oHeaderDelegate){return;}if(!h){return;}this._oHeaderDelegate={onBeforeRendering:function(){var $=c.$().find(".sapFCardDataTimestamp");$.off("click",this._oRefreshWithoutCacheBound);}.bind(this),onAfterRendering:function(){var $=c.$().find(".sapFCardDataTimestamp");$.on("click",this._oRefreshWithoutCacheBound);}.bind(this)};h.addEventDelegate(this._oHeaderDelegate);};
a.prototype._detachTimestampPress=function(e){var c=this.getCardInstance(),h=this.getCardInstanceHeader(),$=c&&c.$().find(".sapFCardDataTimestamp");if(!h){return;}$.off("click",this._oRefreshWithoutCacheBound);h.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null;};
return a;});
sap.ui.predefine('sap/ui/integration/util/CardActions',["./BindingResolver","../library","sap/base/Log","sap/ui/util/openWindow","sap/ui/base/ManagedObject","sap/base/strings/capitalize"],function(B,l,L,o,M,c){"use strict";
function _(s){if(s&&typeof s==="object"){return s.name;}return s;}
var A=l.CardActionArea,C=l.CardActionType;
var a=M.extend("sap.ui.integration.util.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});
a.prototype.attach=function(b){var d=b.control,s=b.area;b.actionControl=b.actionControl||b.control;b.enabledPropertyValue=b.enabledPropertyValue||true;b.disabledPropertyValue=b.disabledPropertyValue||false;b.eventName=b.eventName||"press";if(!b.actions){this._fireActionReady(d,s);return;}var e=b.actions[0];if(e&&e.type){b.action=e;this._attachAction(b);}else{this._fireActionReady(d,s);}};
a.prototype._attachAction=function(b){var d=b.action,s=b.area,e=b.control,f=b.actionControl,E=b.enabledPropertyName,v=b.enabledPropertyValue,D=b.disabledPropertyValue,g=true,S=this._isSingleAction(s),h=true;if(E){g=false;if(d.service&&!S){this._setControlEnabledStateUsingService(d,e,f,E,v,D);}else{this._setControlEnabledState(d,f,E,v,D);}}if(d.service&&S){this._getSingleActionEnabledState(d,e).then(function(i){if(i){this._attachEventListener(b);}this._fireActionReady(e,s);}.bind(this));return;}if(g){h=d.enabled!==false&&d.enabled!=="false";}if(h){this._attachEventListener(b);}this._fireActionReady(e,s);};
a.prototype._setControlEnabledStateUsingService=function(b,d,e,p,E,D){var f=M.bindingParser("{path:''}");f.formatter=function(v){var g=this.getBindingContext(),P,m;if(g){P=g.getPath();}m=B.resolveValue(b.parameters,d,P);if(v.__resolved){if(!v.__enabled||v.__enabled==="false"){return D;}return E;}if(!v.__promise){v.__promise=true;d._oServiceManager.getService(_(b.service)).then(function(n){if(n){n.enabled({parameters:m}).then(function(h){v.__resolved=true;v.__enabled=h;d.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return D;};e.bindProperty(p,f);};
a.prototype._setControlEnabledState=function(b,d,p,e,D){var f,v;if(typeof b.enabled==="object"){f=b.enabled;f.formatter=function(V){if(!V||V==="false"){return D;}return e;};}if(f){d.bindProperty(p,f);}else{v=(b.enabled===false||b.enabled==="false")?D:e;d.setProperty(p,v);}};
a.prototype._getSingleActionEnabledState=function(b,d){var e=d.getBindingContext(),p,P;if(e){P=e.getPath();}p=B.resolveValue(b.parameters,d,P);return new Promise(function(r){d._oServiceManager.getService(_(b.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};
a.prototype._fireActionReady=function(b,s){var h=s===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";b.fireEvent(e);};
a.prototype._resolveBindingPath=function(e){var b=e.getSource().getBindingContext(),p;if(this.getBindingPathResolver()){p=this.getBindingPathResolver()(e);}else if(b){p=b.getPath();}return p;};
a.prototype._handleServiceAction=function(E,b,d){var s=E.getSource();var p=this._resolveBindingPath(E);d._oServiceManager.getService(_(b.service)).then(function(S){if(S){S.navigate({parameters:B.resolveValue(b.parameters,s,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,b,p);}.bind(this));};
a.prototype._attachEventListener=function(b){var d=b.action;b.actionControl["attach"+c(b.eventName)](function(e){var s=e.getSource();if(d.service){this._handleServiceAction(e,d,b.control);}else{this._processAction(s,d,this._resolveBindingPath(e));}}.bind(this));};
a.prototype._processAction=function(s,b,p){var h=this._getHostInstance(),d=this.getCard(),u=b.url;if(u){u=B.resolveValue(u,s,p);}a.fireAction({card:d,host:h,action:b,parameters:B.resolveValue(b.parameters,s,p),source:s,url:u});};
a.prototype._getHostInstance=function(){var b=this.getCard();if(b){return b.getHostInstance();}return null;};
a.prototype.fireAction=function(s,t,p){var h=this._getHostInstance(),b=this.getCard(),d=this._extractActionConfigurations(b,p),e={card:b,host:h,action:{type:t},parameters:d,source:s};a.fireAction(e);};
a.fireAction=function(m){var h=m.host,b=m.card,e=b.getAggregation("_extension"),d=m.action,p=m.parameters||{},f={type:d.type,card:b,actionSource:m.source,parameters:p},g=Object.assign({},f,{manifestParameters:p}),i=b.fireAction(g);if(!i){return false;}if(h){i=h.fireAction(f);}if(!i){return false;}if(e){i=e.fireAction(f);}if(i){a._doPredefinedAction(m);}return i;};
a._doPredefinedAction=function(m){var b=m.action,p=m.parameters,t=b.type,u,T,P,s;if(p){P=p.url;s=p.target;}switch(t){case C.Navigation:if(b.service){break;}u=m.url||P;T=b.target||s||"_blank";if(u){a.openUrl(u,T);}break;case C.Custom:if(typeof b.action==="function"){b.action(m.card,m.source);}break;case C.Submit:if(m.source&&m.source.isA("sap.ui.integration.cards.BaseContent")){a.handleSubmitAction(m);}break;default:break;}};
a.openUrl=function(u,t){o(u,t);};
a.handleSubmitAction=function(m){var d,b=m.card,D=b._oDataProviderFactory,e=m.source,f=m.parameters;if(!f.configuration){return;}e.onActionSubmitStart(f);d=D.create({request:f.configuration});d.getData().then(function(r){e.onActionSubmitEnd(r,null);},function(E){L.error(E);e.onActionSubmitEnd(null,{error:E});}).finally(function(){D.remove(d);});};
a.prototype._extractActionConfigurations=function(b,p){var r=b&&b.getManifestEntry("/sap.card/configuration/actionHandlers/submit"),d=p.data||{};if(!r){return p;}return{data:d,configuration:{"mode":r.mode||"cors","url":r.url,"method":r.method||"POST","parameters":Object.assign({},d,r.parameters),"headers":r.headers,"xhrFields":{"withCredentials":!!r.withCredentials}}};};
a.prototype._isSingleAction=function(s){return[A.Header,A.Content,A.ContentItemDetail,A.ActionsStrip].indexOf(s)>-1;};
return a;});
sap.ui.predefine('sap/ui/integration/util/CardMerger',["sap/base/util/merge","sap/ui/model/json/JSONModel","sap/ui/core/Core","sap/base/util/deepClone"],function(m,J,C,d){"use strict";var a={layers:{"admin":0,"content":5,"translation":10,"all":20},mergeManifestPathChanges:function(M,c){Object.keys(c).forEach(function(s){if(s.charAt(0)==="/"){var v=c[s];M.setProperty(s,v);}});},mergeCardDelta:function(M,c,s){var i=m({},M);if(typeof s==="undefined"){s="sap.card";}if(Array.isArray(c)&&c.length>0){var o;c.forEach(function(b){if(b.content){m(i[s],b.content);}else{o=o||new J(i);a.mergeManifestPathChanges(o,b);}});}return i;},mergeCardDesigntimeMetadata:function(D,c){var i=m({},D);c.forEach(function(o){var I=o.content.entityPropertyChange||[];I.forEach(function(b){var p=b.propertyPath;switch(b.operation){case"UPDATE":if(i.hasOwnProperty(p)){i[p]=b.propertyValue;}break;case"DELETE":delete i[p];break;case"INSERT":if(!i.hasOwnProperty(p)){i[p]=b.propertyValue;}break;default:break;}});});return i;}};return a;});
sap.ui.predefine('sap/ui/integration/util/CardObserver',["sap/ui/integration/library","sap/ui/base/Object"],function(l,B){"use strict";var C=l.CardDataMode;
var a=B.extend("sap.ui.integration.util.CardObserver",{constructor:function(c){B.call(this);this._oCard=c;}});
a.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);this._oCard=null;if(this.oObserver){this.oObserver.disconnect();this.oObserver=null;}};
a.prototype.createObserver=function(){if(!this.oObserver){this.oObserver=new window.IntersectionObserver(function(e){e.forEach(function(E){if(E.isIntersecting){this.loadManifest();}}.bind(this),{threshold:[0.1]});}.bind(this));}};
a.prototype.loadManifest=function(){var c=this._oCard.getDomRef();this._oCard.setDataMode(C.Active);this.oObserver.unobserve(c);};
return a;});
sap.ui.predefine('sap/ui/integration/util/ContentFactory',["./BaseFactory","./CardActions","sap/ui/integration/cards/AdaptiveContent","sap/ui/integration/cards/AnalyticalContent","sap/ui/integration/cards/AnalyticsCloudContent","sap/ui/integration/cards/CalendarContent","sap/ui/integration/cards/ComponentContent","sap/ui/integration/cards/ListContent","sap/ui/integration/cards/ObjectContent","sap/ui/integration/cards/TableContent","sap/ui/integration/cards/TimelineContent","sap/ui/integration/cards/WebPageContent"],function(B,C,A,a,b,c,d,L,O,T,e,W){"use strict";
var f=B.extend("sap.ui.integration.util.ContentFactory");
f.prototype.create=function(m){var o=this._oCard,t=m.cardType;return new Promise(function(r,g){var h=this.getClass(t);if(!h){g(t.toUpperCase()+" content type is not supported.");return;}var i=new h();i.setCard(o);if(i instanceof A){i.setCardDataProvider(o._oDataProvider);}i.loadDependencies(m.cardManifest).then(function(){if((m.cardManifest&&m.cardManifest.isDestroyed())||(m.dataProviderFactory&&m.dataProviderFactory.isDestroyed())){g();return;}var j=new C({card:o});i._sAppId=m.appId;i.setServiceManager(m.serviceManager);i.setDataProviderFactory(m.dataProviderFactory);i.setIconFormatter(m.iconFormatter);i.setActions(j);if(t.toLowerCase()!=="adaptivecard"){i.setConfiguration(this.createBindingInfos(m.contentManifest),t);}else{i.setConfiguration(m.contentManifest);}r(i);}.bind(this)).catch(function(E){g(E);});}.bind(this));};
f.prototype.getClass=function(t){switch(t.toLowerCase()){case"adaptivecard":return A;case"analytical":return a;case"analyticscloud":return b;case"calendar":return c;case"component":return d;case"list":return L;case"object":return O;case"table":return T;case"timeline":return e;case"webpage":return W;default:return null;}};
return f;});
sap.ui.predefine('sap/ui/integration/util/DataProvider',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{settingsJson:{type:"string"},baseRuntimeUrl:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}}}});
D.prototype.setDestinations=function(d){this._oDestinations=d;};
D.prototype.setDependencies=function(d){this._aDependencies=d;};
D.prototype.setSettingsJson=function(s){this.setProperty("settingsJson",s);this.setSettings(JSON.parse(s));if(this._bActive){this._scheduleDataUpdate();}};
D.prototype._getRuntimeUrl=function(u){if(u.startsWith("http://")||u.startsWith("https://")||u.startsWith("//")){return u;}var s=u&&u.trim().replace(/^\//,"");return this.getBaseRuntimeUrl()+s;};
D.prototype.setSettings=function(s){this._oSettings=s;};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.triggerDataUpdate=function(){var p,a;this.fireDataRequested();p=this._waitDependencies();a=p.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=a;}return a;};
D.prototype._triggerDataUpdate=function(){this._bActive=true;return this.getData().then(function(d){this.fireDataChanged({data:d});this.onDataRequestComplete();}.bind(this)).catch(function(r){if(Array.isArray(r)&&r.length>0){this.fireError({message:r[0],jqXHR:r[1]});}else{this.fireError({message:r});}this.onDataRequestComplete();}.bind(this));};
D.prototype.getData=function(){var d=this.getSettings();return new Promise(function(r,a){if(d.json){r(d.json);}else{a("Could not get card data.");}});};
D.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null;}if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);this._iDataUpdateCallId=null;}this._oSettings=null;M.prototype.destroy.apply(this,arguments);};
D.prototype.getInitialRequestPromise=function(){return this._pInitialRequestPromise;};
D.prototype.onDataRequestComplete=function(){var i;if(!this._oSettings||!this._oSettings.updateInterval){return;}i=parseInt(this._oSettings.updateInterval);if(isNaN(i)){return;}setTimeout(function(){this.triggerDataUpdate();}.bind(this),i*1000);};
D.prototype._scheduleDataUpdate=function(){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),0);};
D.prototype._waitDependencies=function(){var d=this._aDependencies||[],p=[];d.forEach(function(o){p.push(o.getInitialRequestPromise());});return Promise.all(p);};
return D;});
sap.ui.predefine('sap/ui/integration/util/DataProviderFactory',["sap/ui/base/Object","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/CacheAndRequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper"],function(B,S,R,C,D,E,J,a){"use strict";
var b=B.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(d,e,c,o,h){B.call(this);this._oDestinations=d;this._oExtension=e;this._oCard=c;this._oEditor=o;this._oHost=h;this._aDataProviders=[];this._aFiltersProviders=[];}});
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(d){if(!d.bIsDestroyed){d.destroy();}});this._aDataProviders=null;this._aFiltersProviders=null;}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true;};
b.prototype.isDestroyed=function(){return this._bIsDestroyed;};
b.prototype.create=function(d,s,i){var c=this._oCard,e=this._oEditor,h=this._oHost||(c&&c.getHostInstance())||(e&&e.getHostInstance()),u=h&&h.bUseExperimentalCaching,o,f;if(!d){return null;}if(c){o={"baseRuntimeUrl":c.getRuntimeUrl("/"),"settingsJson":J.createJsonWithBindingInfos(d,c.getBindingNamespaces())};}else if(e){o={"baseRuntimeUrl":e.getRuntimeUrl("/"),"settingsJson":J.createJsonWithBindingInfos(d,e.getBindingNamespaces())};}else{o={"settingsJson":J.createJsonWithBindingInfos(d,{})};}if(d.request&&u){f=new C(o);f.setCard(c);f.setHost(h);}else if(d.request){f=new R(o);}else if(d.service){f=new S(o);}else if(d.json){f=new D(o);}else if(d.extension){f=new E(o,this._oExtension);}else{return null;}if(c){a.propagateModels(c,f);}else if(e){a.propagateModels(e,f);}f.bindObject("/");f.setDestinations(this._oDestinations);if(f.isA("sap.ui.integration.util.IServiceDataProvider")){f.createServiceInstances(s);}this._aDataProviders.push(f);if(i){this._aFiltersProviders.push(f);}else{f.setDependencies(this._aFiltersProviders);}return f;};
b.prototype.remove=function(d){var p=this._aDataProviders.indexOf(d);if(p>-1){this._aDataProviders.splice(p,1);}if(d&&!d.bDestroyed&&d._bIsDestroyed){d.destroy();}};
return b;});
sap.ui.predefine('sap/ui/integration/util/Destinations',["sap/ui/base/Object","sap/base/Log","sap/ui/integration/util/Utils"],function(B,L,U){"use strict";var r=/\{\{destinations.([^\}]+)/;
var D=B.extend("sap.ui.integration.util.Destinations",{
metadata:{library:"sap.ui.integration"},
constructor:function(h,c){B.call(this);this._oHost=h;this._oConfiguration=c;this._mResolved=new Map();}
});
D.prototype.setHost=function(h){this._oHost=h;this._mResolved.clear();};
D.prototype.process=function(c){var u=c.url,C;if(!u||typeof u!=="string"){return Promise.resolve(c);}if(!this.hasDestination(u)){return Promise.resolve(c);}C=jQuery.extend(true,{},c);return this.processString(u).then(function(p){C.url=p;return C;});};
D.prototype.getUrl=function(k){var R;if(this._mResolved.has(k)){return this._mResolved.get(k);}R=this._resolveUrl(k);this._mResolved.set(k,R);return R;};
D.prototype._resolveUrl=function(k){var c=this._oConfiguration?this._oConfiguration[k]:null,n,d,p;if(!c){return Promise.reject("Configuration for destination '"+k+"' was not found in the manifest.");}n=c.name;d=c.defaultUrl;if(!n&&!d){return Promise.reject("Can not resolve destination '"+k+"'. Neither 'name' nor 'defaultUrl' is configured.");}if(!n&&d){return Promise.resolve(d);}if(!this._oHost&&!d){return Promise.reject("Can not resolve destination '"+k+"'. There is no 'host' and no defaultUrl specified.");}if(!this._oHost&&d){return Promise.resolve(d);}p=U.timeoutPromise(this._oHost.getDestination(n));if(d){return p.catch(function(m){L.error(m+" Fallback to default url.");return d;});}return p;};
D.prototype.hasDestination=function(s){return!!s.match(r);};
D.prototype.processString=function(s){var m=s.match(r),k;if(!m){return Promise.resolve(s);}k=m[1];return this.getUrl(k).then(function(u){return this._replaceUrl(s,k,u);}.bind(this));};
D.prototype._replaceUrl=function(s,k,u){var S=u.trim().replace(/\/$/,"");return s.replace("{{destinations."+k+"}}",S);};
return D;});
sap.ui.predefine('sap/ui/integration/util/ExtensionDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var E=D.extend("sap.ui.integration.util.ExtensionDataProvider",{
metadata:{library:"sap.ui.integration"},
constructor:function(c,e){D.call(this,c);this._oExtension=e;}
});
E.prototype.destroy=function(){D.prototype.destroy.apply(this,arguments);this._oExtension=null;};
E.prototype.getData=function(){var e=this.getSettings().extension;if(!this._oExtension){return Promise.reject("The extension module is not loaded properly or doesn't export a correct value.");}if(!this._oExtension[e.method]){return Promise.reject("Extension doesn't implement "+e.method+" method.");}return this._oExtension[e.method].apply(this._oExtension,e.args);};
return E;});
sap.ui.predefine('sap/ui/integration/util/HeaderFactory',["./BaseFactory","./CardActions","sap/ui/integration/library","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/base/strings/formatMessage"],function(B,C,l,N,H,f){"use strict";var A=l.CardActionArea;
function b(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var o={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var c=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){c=P.length;}var i=parseFloat(s)||0;var d=parseFloat(c)||0;return f(t,[i,d]);}};h.bindProperty("statusText",o);}}
var a=B.extend("sap.ui.integration.util.HeaderFactory");
a.prototype.create=function(c,t){var o=this._oCard,h;c=this.createBindingInfos(c,o.getBindingNamespaces());switch(c.type){case"Numeric":h=new N(c,t);break;default:h=new H(c,t,o._oIconFormatter);break;}h.setCard(o);if(c.status&&c.status.text&&c.status.text.format){if(c.status.text.format.translationKey){o._loadDefaultTranslations();}b(c.status.text.format,h);}h.setServiceManager(o._oServiceManager);h.setDataProviderFactory(o._oDataProviderFactory);h._setDataConfiguration(c.data);var d=new C({card:o});d.attach({area:A.Header,actions:c.actions,control:h});h._oActions=d;if(h._bIsEmpty){h.setVisible(t.getVisible());}return h;};
return a;});
sap.ui.predefine('sap/ui/integration/util/JSONBindingHelper',["sap/ui/base/BindingParser","sap/ui/integration/util/BindingHelper"],function(B,a){"use strict";var b=[["ESCAPED_BINDING_START",/\\{/g,"\\{"],["ESCAPED_BINDING_END",/\\}/g,"\\}"],["BINDING_START",/{/g,"{"],["BINDING_END",/}/g,"}"]];var J={};
J.createJsonWithBindingInfos=function(v,l){if(!v){return v;}var j=this._createBindableJson(v),c=a.createBindingInfos(j,l);if(typeof c==="string"){c=this._escape(c);}return c;};
J._createBindableJson=function(v){var r;r=JSON.stringify(v,function(k,V){if(typeof V==="string"){return this._encodeBindingString(V);}return V;}.bind(this));r=this._escape(r);r=this._decodeBindingString(r);return r;};
J._escape=function(v){return B.complexParser.escape(v);};
J._encodeBindingString=function(v){b.forEach(function(c){var C=c[0],r=c[1];v=v.replace(r,C);});return v;};
J._decodeBindingString=function(v){b.forEach(function(c){var C=c[0],s=c[2];v=v.replace(new RegExp(C,"g"),s);});return v;};
return J;});
sap.ui.predefine('sap/ui/integration/util/LoadingProvider',["../cards/ListContentRenderer","sap/ui/integration/library","sap/ui/core/Element","sap/f/cards/loading/GenericPlaceholder","sap/f/cards/loading/ListPlaceholder"],function(L,l,E,G,a){"use strict";
var b=E.extend("sap.ui.integration.util.LoadingProvider",{metadata:{library:"sap.ui.integration",properties:{loading:{type:"boolean",defaultValue:false}}}});
b.prototype.setLoading=function(c){if(this.isDataProviderJson()){return;}this.setProperty("loading",c);};
b.prototype.isDataProviderJson=function(){return!!(this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]);};
b.prototype.setDataProvider=function(d){this._oDataProvider=d;};
b.prototype.destroy=function(){if(this._oContentPlaceholder){this._oContentPlaceholder.destroy();this._oContentPlaceholder=null;}this._oDataProvider=null;E.prototype.destroy.apply(this,arguments);};
b.prototype.createContentPlaceholder=function(c,t,C){switch(t){case"List":this._oContentPlaceholder=new a({maxItems:c.maxItems?parseInt(c.maxItems):2,item:c.item,itemHeight:L.getItemMinHeight(c,C||this)+"rem"});break;default:this._oContentPlaceholder=new G();}return this._oContentPlaceholder;};
return b;});
sap.ui.predefine('sap/ui/integration/util/Manifest',["sap/ui/base/Object","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/Log","./ParameterMap","sap/ui/integration/util/CardMerger"],function(B,C,d,a,b,L,P,c){"use strict";var M="/{SECTION}/configuration/parameters",e="/{SECTION}/configuration/filters",f="/{SECTION}",A="/sap.app/dataSources",R=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}|\{i18n>([^\}]+)\}/g;
var g=B.extend("sap.ui.integration.util.Manifest",{constructor:function(s,o,i,j){B.call(this);this._aChanges=j;this._sSection=s;this.PARAMETERS=M.replace("{SECTION}",s);this.FILTERS=e.replace("{SECTION}",s);this.CONFIGURATION=f.replace("{SECTION}",s);if(o){var O={},l;O.process=false;this._oInitialJson=d(o,500);if(i){O.baseUrl=i;this._sBaseUrl=i;}else{L.warning("If no base URL is provided when the manifest is an object static resources cannot be loaded.");}if(this._aChanges){l=this.mergeDeltaChanges(o);}else{l=o;}this._oManifest=new C(l,O);this.oJson=this._oManifest.getRawJson();}}});
g.prototype.mergeDeltaChanges=function(o){return c.mergeCardDelta(o,this._aChanges,this._sSection);};
g.prototype.getJson=function(){return this._unfreeze(this.oJson);};
g.prototype.getInitialJson=function(){return this._oInitialJson;};
g.prototype.get=function(s){return this._unfreeze(n(this.oJson,s));};
g.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest");};
g.prototype.getResourceBundle=function(){return this.oResourceBundle;};
g.prototype._unfreeze=function(v){if(typeof v==="object"){return JSON.parse(JSON.stringify(v));}return v;};
g.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy();}this._bIsDestroyed=true;};
g.prototype.isDestroyed=function(){return this._bIsDestroyed;};
g.prototype.load=function(s){if(!s||!s.manifestUrl){if(this._sBaseUrl&&this._oManifest){return this.loadI18n().then(function(){this.processManifest();}.bind(this));}else{if(this._oManifest){this.processManifest();}return new Promise(function(i){i();});}}return C.load({manifestUrl:s.manifestUrl,async:true,processJson:function(o){this._oInitialJson=d(o,500);if(this._aChanges){return this.mergeDeltaChanges(o);}return o;}.bind(this)}).then(function(o){this._oManifest=o;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest();}.bind(this));}.bind(this));};
g.prototype.loadI18n=function(){var H=false;C.processObject(this._oManifest.getJson(),function(o,K,v){if(!H&&v.match(R)){H=true;}});if(this.get("/sap.app/i18n")){H=true;}if(!H){return Promise.resolve();}return this._oManifest._loadI18n(true).then(function(o){this.oResourceBundle=o;}.bind(this));};
g.prototype.processManifest=function(){var i=0,j=15,u=jQuery.extend(true,{},this._oManifest.getRawJson()),D=this.get(A);p(u,this.oResourceBundle,i,j,this._oCombinedParams,D,this._oCombinedFilters);h(u);this.oJson=u;};
function h(o){if(o&&typeof o==='object'&&!Object.isFrozen(o)){Object.freeze(o);for(var K in o){if(o.hasOwnProperty(K)){h(o[K]);}}}}
function k(v){return(typeof v==="string")&&v.indexOf("{{")===0&&v.indexOf("}}")===v.length-2;}
function m(v){return(typeof v==="string")&&(v.indexOf("{{parameters.")>-1||v.indexOf("{{dataSources")>-1||v.indexOf("{{filters.")>-1);}
g._processPlaceholder=function(s,o,D,F){var i=P.processPredefinedParameter(s),v,j;if(!b(o)){for(var l in o){v=o[l].value;j="{{parameters."+l;i=r(i,v,j);}}if(D){i=r(i,D,"{{dataSources");}if(F){i=r(i,F,"{{filters");}return i;};
function r(s,v,i){if(a(v)||Array.isArray(v)){for(var j in v){s=r(s,v[j],i+"."+j);}}else if(s.includes(i+"}}")){s=s.replace(new RegExp(i+"}}",'g'),v);}return s;}
function p(o,i,j,l,q,D,F){if(j===l){return;}if(Array.isArray(o)){o.forEach(function(I,t,u){if(typeof I==="object"){p(I,i,j+1,l,q,D,F);}else if(m(I)){u[t]=g._processPlaceholder(I,q,D,F);}else if(k(I)&&i){u[t]=i.getText(I.substring(2,I.length-2));}},this);}else{for(var s in o){if(typeof o[s]==="object"){p(o[s],i,j+1,l,q,D,F);}else if(m(o[s])){o[s]=g._processPlaceholder(o[s],q,D,F);}else if(k(o[s])&&i){o[s]=i.getText(o[s].substring(2,o[s].length-2));}}}}
function n(o,s){if(s==="/"){return o;}if(o&&s&&typeof s==="string"&&s[0]==="/"){var j=s.substring(1).split("/"),q;for(var i=0,l=j.length;i<l;i++){q=j[i];o=o.hasOwnProperty(q)?o[q]:undefined;if(o===null||typeof o!=="object"){if(i+1<l&&o!==undefined){o=undefined;}break;}}return o;}return o&&o[s];}
g.prototype.processFilters=function(i){if(!this._oManifest){return;}var o=this.get(this.FILTERS),j={};if(i.size&&!o){L.error("If runtime filters are set, they have to be defined in the manifest configuration as well.");return;}jQuery.each(o,function(K,l){var v=i.get(K)||l.value;j[K]=v;});this._oCombinedFilters=j;this.processManifest();};
g.prototype.processParameters=function(o){if(!this._oManifest){return;}var i=this.get(this.PARAMETERS);if(!b(o)&&!i){L.error("If parameters property is set, parameters should be described in the manifest");return;}this._oCombinedParams=this._syncParameters(o,i);this.processManifest();};
g.prototype.getProcessedParameters=function(o){var i=this.get(this.PARAMETERS),j=this._syncParameters(o,i);p(j,this.oResourceBundle,0,15,o);return j;};
g.prototype._syncParameters=function(o,l){if(b(o)){return l;}var q=d(l||{},500),s=Object.getOwnPropertyNames(o),t=Object.getOwnPropertyNames(q);for(var i=0;i<t.length;i++){for(var j=0;j<s.length;j++){if(t[i]===s[j]){q[t[i]].value=o[s[j]];}}}return q;};
g.prototype.findDataSections=function(s){var i=[],K;if(!s){s=this.get(this.CONFIGURATION);}if(!a(s)){return[];}if(s.data){i.push(s.data);}for(K in s){if(s[K]){i=i.concat(this.findDataSections(s[K]));}}return i;};
return g;},true);
sap.ui.predefine('sap/ui/integration/util/ParameterMap',['sap/ui/core/Core'],function(C){"use strict";var P={};var p={"{{parameters.NOW_ISO}}":g,"{{parameters.TODAY_ISO}}":a,"{{parameters.LOCALE}}":b};
function g(){return new Date().toISOString();}
function a(){return new Date().toISOString().slice(0,10);}
function b(){return C.getConfiguration().getLocale().toString();}
P.processPredefinedParameter=function(s){var r;Object.keys(p).forEach(function(e){r=new RegExp(e,'g');if(s.indexOf(e)>-1){s=s.replace(r,p[e]());}});return s;};
return P;});
sap.ui.predefine('sap/ui/integration/util/RequestDataProvider',["sap/ui/integration/util/DataProvider","jquery.sap.global","sap/base/Log","sap/ui/model/odata/v4/ODataUtils"],function(D,q,L,O){"use strict";var R=[429,503];var m=["no-cors","same-origin","cors"];var M=["GET","POST"];
var a=D.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{properties:{allowCustomDataType:{type:"boolean",defaultValue:false}}}});
a.prototype.destroy=function(){if(this._iRetryAfterTimeout){clearTimeout(this._iRetryAfterTimeout);}D.prototype.destroy.apply(this,arguments);};
a.prototype.getData=function(){var r=this.getSettings().request;if(this._oDestinations){return this._oDestinations.process(r).then(this._fetch.bind(this));}return this._fetch(r);};
a.prototype._isValidRequest=function(r){if(!r){return false;}if(m.indexOf(r.mode)===-1){return false;}if(M.indexOf(r.method)===-1){return false;}if(typeof r.url!=="string"){return false;}return true;};
a.prototype._fetch=function(r){var s="Invalid request",S=this._oSettings;if(!r||!r.url){L.error(s);return Promise.reject(s);}if(!this.getAllowCustomDataType()&&r.dataType){L.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.");}var d=r.parameters,u=r.url,b=(this.getAllowCustomDataType()&&r.dataType)||"json",h=r.headers||{},B=r.batch,o,c;if(!u.startsWith("/")){u=this._getRuntimeUrl(r.url);}if(this._hasHeader(r,"Content-Type","application/json")){d=JSON.stringify(r.parameters);}if(B){o=O.serializeBatchRequest(Object.values(B));b="text";d=o.body;h=Object.assign({},h,o.headers);}h=this._prepareHeaders(h,S);c={"mode":r.mode||"cors","url":u,"method":(r.method&&r.method.toUpperCase())||"GET","dataType":b,"data":d,"headers":h,"timeout":15000,"xhrFields":{"withCredentials":!!r.withCredentials}};if(!this._isValidRequest(c)){L.error(s);return Promise.reject(s);}return this._request(c).then(function(v){var d=v[0],j=v[1];if(B){return this._deserializeBatchResponse(B,d,j);}return d;}.bind(this));};
a.prototype._request=function(r,n){return new Promise(function(b,c){q.ajax(r).done(function(d,t,j){if(this.bIsDestroyed){c("RequestDataProvider is already destroyed before the response is received.");return;}b([d,j]);}).fail(function(j,t,e){var E=[e,j];if(this.bIsDestroyed){c("RequestDataProvider is already destroyed while error in the response occurred.");return;}if(n){c(E);return;}this._retryRequest(E,r).then(b,c);}.bind(this));}.bind(this));};
a.prototype._retryRequest=function(e,r){var j=e[1],i=this._getRetryAfter(j);if(!R.includes(j.status)){return Promise.reject(e);}if(!i){L.warning("Request could be retried, but Retry-After header or configuration parameter retryAfter are missing.");return Promise.reject(e);}if(this._iRetryAfterTimeout){return Promise.reject("The retry was already scheduled.");}return new Promise(function(b,c){this._iRetryAfterTimeout=setTimeout(function(){this._request(r,true).then(b,c);this._iRetryAfterTimeout=null;}.bind(this),i*1000);}.bind(this));};
a.prototype._getRetryAfter=function(j){var r=this.getSettings().request,v=j.getResponseHeader("Retry-After")||r.retryAfter;if(!v){return 0;}if(Number.isInteger(v)){return v;}if(!v.match(/^\d+$/)){L.error("Only number of seconds is supported as value of retry-after. Given '"+v+"'.");return 0;}return parseInt(v);};
a.prototype._hasHeader=function(r,h,v){if(!r.headers){return false;}for(var k in r.headers){if(k.toLowerCase()===h.toLowerCase()&&r.headers[k]===v){return true;}}return false;};
a.prototype._deserializeBatchResponse=function(b,r,j){return new Promise(function(c,d){var C=j.getResponseHeader("Content-Type"),B=O.deserializeBatchResponse(C,r,false),k=Object.keys(b),e={};k.forEach(function(K,i){var f=B[i],o;if(!f){d("Batch responses do not match the batch requests.");return;}o=new Response(f.responseText,f);if(!o.ok){d("One of batch requests fails with '"+o.status+" "+o.statusText+"'");return;}e[K]=f.responseText?JSON.parse(f.responseText):{};});c(e);});};
a.prototype._prepareHeaders=function(h,s){return h;};
return a;});
sap.ui.predefine('sap/ui/integration/util/ServiceDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var S=D.extend("sap.ui.integration.util.ServiceDataProvider",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.integration.util.IServiceDataProvider"]}});
S.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null;}D.prototype.destroy.apply(this,arguments);};
S.prototype.createServiceInstances=function(s){this._oServiceManager=s;if(!this._oSettings||!this._oSettings.service){return;}var v=this._oSettings.service;if(v&&typeof v==="object"){v=v.name;}this._createServiceInstance(v);};
S.prototype._createServiceInstance=function(s){var d=this._oSettings;this._oDataServicePromise=this._oServiceManager.getService(s).then(function(o){o.attachDataChanged(function(e){this.fireDataChanged({data:e.data});}.bind(this),d.service.parameters);return o;}.bind(this));};
S.prototype.getData=function(){var d=this.getSettings();var s=d.service;return new Promise(function(r,a){if(s&&this._oDataServicePromise){this._oDataServicePromise.then(function(o){o.getData().then(function(b){r(b);}).catch(function(){a("Card data service failed to get data.");});}).catch(function(){a("Card data service unavailable.");});}else{a("Could not get card data.");}}.bind(this));};
return S;});
sap.ui.predefine('sap/ui/integration/util/ServiceManager',["sap/ui/base/EventProvider","sap/base/Log"],function(E,L){"use strict";
var S=E.extend("sap.ui.integration.util.ServiceManager",{constructor:function(s,o){if(!s){throw new Error("Missing manifest services reference!");}if(!o){throw new Error("Missing context object");}E.call(this);this._mServiceFactoryReferences=s;this._mServices={};this._oServiceContext=o;this._initAllServices();}});
S.prototype._initAllServices=function(){for(var s in this._mServiceFactoryReferences){this._initService(s);}};
S.prototype._initService=function(n){var s=this._mServices[n]||{};s.promise=S._getService(this._oServiceContext,n,this._mServiceFactoryReferences).then(function(o){s.instance=o;}).catch(function(e){L.error(e.message);});this._mServices[n]=s;};
S.prototype.getService=function(s){var e="Invalid service";return new Promise(function(r,R){if(!s||!this._mServices[s]||!Object.keys(this._mServices[s])){R(e);return;}this._mServices[s].promise.then(function(){if(this._mServices[s].instance){r(this._mServices[s].instance);}else{R(e);}}.bind(this)).catch(R);}.bind(this));};
S.prototype.destroy=function(){this._mServices=null;};
S._getService=function(i,n,s){return new Promise(function(r,R){var o,f;if(i.bIsDestroyed){R(new Error("Service "+n+" could not be loaded as the requestor "+i.getMetadata().getName()+" was destroyed."));return;}if(!s){R(new Error("No Services declared"));return;}else{o=s[n];}if(!o||!o.factoryName){R(new Error("No Service '"+n+"' declared or factoryName missing"));return;}else{f=o.factoryName;}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(a){var b=a.get(f);if(b){b.createInstance({scopeObject:i,scopeType:"component",settings:o.settings||{}}).then(function(c){if(c.getInterface){r(c.getInterface());}else{r(c);}}).catch(R);}else{var e=new Error("ServiceFactory '"+f+"' for Service '"+n+"' not found in ServiceFactoryRegistry");e._optional=o.optional;R(e);}});});};
return S;});
sap.ui.predefine('sap/ui/integration/util/Utils',["sap/ui/core/Locale",'sap/base/util/isPlainObject',"sap/base/Log"],function(L,i,a){"use strict";var U={};
U.isJson=function(t){if(typeof t!=="string"){return false;}try{JSON.parse(t);return true;}catch(e){return false;}};
U.processFormatArguments=function(f,l){var F=i(f)?f:{},o=typeof f==="string"?new L(f):(l&&new L(l));return{formatOptions:F,locale:o};};
var J=1,b=2,c=3;
U.parseJsonDateTime=function(d){var r=/^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/,j;if(typeof d==="string"){j=r.exec(d);}if(j){var R=new Date(parseInt(j[J]));if(j[b]){var m=parseInt(j[c]);if(j[b]==="-"){m=-m;}var C=R.getUTCMinutes();R.setUTCMinutes(C-m);}if(isNaN(R.valueOf())){a.error("Invalid JSON Date format - "+d);}else{d=R;}}return d;};
U.DEFAULT_PROMISE_TIMEOUT=5000;
U.timeoutPromise=function(p,t){var d;if(t===undefined){t=U.DEFAULT_PROMISE_TIMEOUT;}d=new Promise(function(r,e){setTimeout(function(){e("The promise was not resolved after "+t+" ms so it timed out.");},t);});return Promise.race([p,d]);};
U.hasFalsyValueAsString=function(s){return typeof s=="string"&&["null","false","undefined",""].indexOf(s.trim())>-1;};
return U;});
sap.ui.predefine('sap/ui/integration/util/loadCardEditor',function(){"use strict";
function l(){return new Promise(function(r,R){sap.ui.require(["sap/ui/integration/designtime/cardEditor/BASEditor"],r,R);});}
return function(){return sap.ui.loader._.loadJSResourceAsync("sap-ui-integration-cardEditor.js").then(l).catch(l);};});
sap.ui.predefine('sap/ui/integration/widgets/Card',["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/integration/util/DataProviderFactory","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/base/util/LoaderExtensions","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/util/CardActions","sap/ui/integration/util/CardObserver"],function(C,F,A,I,q,a,b,S,L,m,d,D,H,c,T,J,O,R,f,g,h,l,i,j,k,n,o,B,p,r,s,t){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",FILTERS:"/sap.card/configuration/filters"};var u=["parameters","filters","context","i18n"];var v=["visibleItems","allItems"];var w=l.cards.HeaderPosition;var x=i.CardDataMode;var y="Card is destroyed!";var z=i.CardArea;
var E=h.extend("sap.ui.integration.widgets.Card",{
metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:x.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{}},associations:{host:{}}},
renderer:C
});
E.prototype.init=function(){h.prototype.init.call(this);this.setAggregation("_loadingProvider",new k());this.setModel(new J());this.setModel(new J(),"parameters");this.setModel(new J(),"filters");this.setModel(new f(),"context");this._oContentFactory=new o(this);this._oCardObserver=new t(this);this._bFirstRendering=true;if(this.getProperty("dataMode")===x.Auto){this._oCardObserver.createObserver(this);}this._oLimitedInterface=new I(this,["getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders"]);};
E.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
E.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};
E.prototype.onBeforeRendering=function(){if(this.getDataMode()!==x.Active){return;}this.startManifestProcessing();};
E.prototype.onAfterRendering=function(){var e=this.getDomRef();if(this.getDataMode()===x.Auto&&this._bFirstRendering){this._oCardObserver.oObserver.observe(e);}this._bFirstRendering=false;};
E.prototype.startManifestProcessing=function(){if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var e=this.getManifest();if(!e){this.destroyManifest();}else{this.createManifest(e,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu();};
E.prototype.setManifest=function(V){this.setProperty("manifest",V);this.destroyActionDefinitions();this._bApplyManifest=true;return this;};
E.prototype.setManifestChanges=function(V){this.setProperty("manifestChanges",V);this._bApplyManifest=true;return this;};
E.prototype.setParameters=function(V){this.setProperty("parameters",V);this._bApplyParameters=true;return this;};
E.prototype.setParameter=function(K,V){var P=this.getParameters()||{};P[K]=V;this.setParameters(P);return this;};
E.prototype.setHost=function(e){this.setAssociation("host",e);var G=this.getHostInstance();if(e&&!G){L.error("Host with id '"+e+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this;}this.getModel("context").setHost(G);if(this._oDestinations){this._oDestinations.setHost(G);}if(G&&G.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching");}else{this.removeStyleClass("sapFCardExperimentalCaching");}return this;};
E.prototype.createManifest=function(G,K){var N={};this._isManifestReady=false;if(typeof G==="string"){N.manifestUrl=G;G=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this.destroyAggregation("_extension");this._oCardManifest=new b("sap.card",G,K,this.getManifestChanges());this._oCardManifest.load(N).then(function(){if(this.bIsDestroyed){throw new Error(y);}this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(this._applyManifest.bind(this)).catch(function(e){if(e.message!==y){this._applyManifest();}}.bind(this));};
E.prototype._loadExtension=function(){var e=this._oCardManifest.get("/sap.card/extension");if(!e){return null;}var G=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+e;return new Promise(function(K,N){sap.ui.require([G],function(P){var Q=new P();Q._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",Q);K();}.bind(this),function(P){L.error("Failed to load "+e+". Check if the path is correct. Reason: "+P);N(P);});}.bind(this));};
E.prototype._applyManifest=function(){var e=this._oCardManifest;if(e&&e.getResourceBundle()){this._enhanceI18nModel(e.getResourceBundle());}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._resolveContextParams().then(function(G){this._oContextParameters=G;this._applyManifestWithParams();}.bind(this));return;}this._applyManifestWithParams();};
E.prototype._applyManifestWithParams=function(){var e=this._oCardManifest,P=this._getContextAndRuntimeParams();e.processParameters(P);this._prepareToApplyManifestSettings();this._applyManifestSettings();};
E.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var e=a.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e);this._defaultTranslationsLoaded=true;this._oIntegrationRb=e;};
E.prototype._enhanceI18nModel=function(e){var G=this.getModel("i18n");if(G){if(G.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){G.enhance(e);}return;}G=new R({bundle:e});this.setModel(G,"i18n");};
E.prototype._hasContextParams=function(){var e=this._oCardManifest.get(M.PARAMS),K,V;for(K in e){V=e[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){return true;}}return false;};
E.prototype._resolveContextParams=function(){var e=this.getModel("context"),G=this._oCardManifest.get(M.PARAMS),K={},N,V;for(N in G){V=G[N].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){K[N]=V;}}B.resolveValue(K,this,"/");return e.waitForPendingProperties().then(function(){return B.resolveValue(K,this,"/");}.bind(this));};
E.prototype._getContextAndRuntimeParams=function(){var e=this._oContextParameters||{},G=this.getParameters()||{};return m(e,G);};
E.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(G){this.attachEventOnce(e,function(){G();});}.bind(this)));};
E.prototype.isReady=function(){return this._bReady;};
E.prototype.refresh=function(){if(this.getDataMode()===x.Active){this._bApplyManifest=true;this.invalidate();}};
E.prototype.refreshData=function(){var e=this.getCardHeader(),G=this.getCardContent(),K=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}if(e){e.refreshData();}if(G){G.refreshData();}if(K){K.getItems().forEach(function(N){N.refreshData();});}};
E.prototype._refreshActionsMenu=function(){var e=this.getCardHeader(),G=this.getHostInstance(),K=this.getAggregation("_extension"),N=[];if(!e){return;}if(G){N=N.concat(G.getActions()||[]);}if(K){N=N.concat(K.getActions()||[]);}if(d(N,this._getActionsToolbar()._aActions)){return;}this._getActionsToolbar().initializeContent(this);};
E.prototype.exit=function(){h.prototype.exit.call(this);this.destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oContentFactory=null;this._bFirstRendering=null;if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null;}};
E.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this.destroyAggregation("_footer");this._aReadyPromises=null;this.getModel("filters").setData({});this.getModel("parameters").setData({});this._oContextParameters=null;this._deregisterCustomModels();};
E.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){g.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl()||"/");}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};
E.prototype.getManifest=function(){var V=this.getProperty("manifest");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};
E.prototype.getParameters=function(){var V=this.getProperty("parameters");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};
E.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},K;for(K in P){e[K]=P[K].value;}return e;};
E.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};
E.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return this._oCardManifest.getInitialJson();};
E.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};
E.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};
E.prototype.showMessage=function(e,G){var K=this.getCardContent();if(!K||!K.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}K.showMessage(e,G);};
E.prototype.getTranslatedText=function(K,e,G){var N=this.getModel("i18n"),P;if(!N){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}P=N.getResourceBundle();return P.getText(K,e,G);};
E.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){L.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null;}return this._oDataProviderFactory;};
E.prototype.getRuntimeUrl=function(U){var e=this._sAppId,G,K=U&&U.trim().replace(/^\//,"");if(e===null){L.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}if(!e||U.startsWith("http://")||U.startsWith("https://")||U.startsWith("//")){return U;}G=e.replace(/\./g,"/");return sap.ui.require.toUrl(G)+"/"+K;};
E.prototype._prepareToApplyManifestSettings=function(){var e=this._oCardManifest.get(M.APP_TYPE),G=this.getAggregation("_extension");if(e&&e!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new j(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new p({destinations:this._oDestinations,card:this});this._oDataProviderFactory=new D(this._oDestinations,G,this);this._registerCustomModels();if(G){G.onCardReady();}};
E.prototype._applyManifestSettings=function(){this._setParametersModelData();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();this._applyFooterManifestSettings();this.fireManifestApplied();};
E.prototype._setParametersModelData=function(){var e={},G=this.getCombinedParameters(),K;for(K in G){if(v.indexOf(K)>=0){L.warning("The parameter name '"+K+"' is reserved for cards. Can not be used for creating custom parameter.");}else{e[K]={value:G[K]};}}this.getModel("parameters").setData(e);};
E.prototype._applyDataManifestSettings=function(){var e=this._oCardManifest.get(M.DATA),G;if(!e){this.fireEvent("_cardReady");return;}this.bindObject(e.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(e,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(e.name){G=this.getModel(e.name);}else if(this._oDataProvider){G=new O();this.setModel(G);}if(!G){this.fireEvent("_cardReady");return;}G.attachEvent("change",function(){if(this._createContentPromise){this._createContentPromise.then(function(K){K.onDataChanged();this.onDataRequestComplete();}.bind(this));}else{this.onDataRequestComplete();}}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(K){G.setData(K.getParameter("data"));});this._oDataProvider.attachError(function(K){this._handleError("Data service unavailable. "+K.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_cardReady");}};
E.prototype._applyServiceManifestSettings=function(){var e=this._oCardManifest.get(M.SERVICES);if(!e){return;}if(!this._oServiceManager){this._oServiceManager=new S(e,this);}};
E.prototype.getCardHeader=function(){return this.getAggregation("_header");};
E.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||w.Top;};
E.prototype.getCardContent=function(){return this.getAggregation("_content");};
E.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new A();this._oActionsToolbar.setCard(this);}return this._oActionsToolbar;};
E.prototype._applyHeaderManifestSettings=function(){var e=this.createHeader();this.destroyAggregation("_header");if(!e){this.fireEvent("_headerReady");return;}e.attachEvent("_error",function(G){this._handleError(G.getParameter("message"));}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady");}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};
E.prototype._applyFilterBarManifestSettings=function(){var e=this.createFilterBar();this.destroyAggregation("_filterBar");if(!e){this.fireEvent("_filterBarReady");return;}e.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady");}.bind(this));this.setAggregation("_filterBar",e);};
E.prototype._applyFooterManifestSettings=function(){var e=this.createFooter();this.destroyAggregation("_footer");if(e){this.setAggregation("_footer",e);}};
E.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null;}return a.byId(e);};
E.prototype._applyContentManifestSettings=function(){var e=this._oCardManifest.get(M.TYPE),G=this.getContentManifest(),K=e+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(K);if(!G){this.fireEvent("_contentReady");return;}this._setTemporaryContent(e,G);if(this._bIsPreviewMode){this.fireEvent("_contentReady");return;}this._createContentPromise=this.createContent({cardType:e,contentManifest:G,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(N){this._setCardContent(N);return N;}.bind(this));this._createContentPromise.catch(function(N){if(N){this._handleError(N);}}.bind(this));};
E.prototype.createHeader=function(){var e=this._oCardManifest.get(M.HEADER),G=new n(this);return G.create(e,this._getActionsToolbar());};
E.prototype.createFilterBar=function(){var e=this._oCardManifest.get(M.FILTERS),G=new r(this);return G.create(e,this.getModel("filters"));};
E.prototype.createFooter=function(){var e=this._oCardManifest.get(M.FOOTER);if(!e){return null;}return F.create(this,e);};
E.prototype.getContentManifest=function(){var e=this._oCardManifest.get(M.TYPE),G=e&&e.toLowerCase()==="component",K=this._oCardManifest.get(M.CONTENT),N=!!K;if(N&&!e){L.error("Card type property is mandatory!");return null;}if(!N&&!G){return null;}if(G){K=m(K,{componentManifest:this._oCardManifest.getJson()});}return K;};
E.prototype.createContent=function(e){e.cardManifest=this._oCardManifest;return this._oContentFactory.create(e);};
E.prototype._setCardContent=function(e){if(this._bShowContentLoadingPlaceholders){e.showLoadingPlaceholders();this._bShowContentLoadingPlaceholders=false;}e.attachEvent("_error",function(G){this._handleError(G.getParameter("logMessage"),G.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",e);if(e.isReady()){this.fireEvent("_contentReady");}else{e.attachReady(function(){this.fireEvent("_contentReady");}.bind(this));}};
E.prototype._setTemporaryContent=function(e,G){var K=this._getTemporaryContent(e,G),P=this.getAggregation("_content");if(P&&P!==K){P.destroy();}this.setAggregation("_content",K);};
E.prototype._preserveMinHeightInContent=function(e){e.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var G=this._oCardManifest.get(M.TYPE),K=this._oCardManifest.get(M.CONTENT),N=this._oContentFactory.getClass(G),P;if(!N){return;}P=N.getMetadata().getRenderer().getMinHeight(K,e);if(this.getHeight()==="auto"){e.$().css({"min-height":P});}}},this);};
E.prototype._destroyPreviousContent=function(e){if(e&&!e.hasStyleClass("sapFCardErrorContent")){e.destroy();if(e===this._oTemporaryContent){this._oTemporaryContent=null;}}};
E.prototype._createError=function(e){return new H({justifyContent:"Center",alignItems:"Center",items:[new c({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:e})]}).addStyleClass("sapFCardErrorContent");};
E.prototype._handleError=function(e,G){this._loadDefaultTranslations();L.error(e,null,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:e});var K=G||this._oIntegrationRb.getText("CARD_DATA_LOAD_ERROR"),N=this._createError(K),P=this._oCardManifest.get(M.CONTENT);if(P){this._destroyPreviousContent(this.getCardContent());this._preserveMinHeightInContent(N);this.setAggregation("_content",N);this.fireEvent("_contentReady");}else{this.getCardHeader().setAggregation("_error",N);}};
E.prototype._getTemporaryContent=function(e,G){var K=this.getAggregation("_loadingProvider");if(!this._oTemporaryContent&&K){this._oTemporaryContent=K.createContentPlaceholder(G,e);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var N=this._oContentFactory.getClass(e).getMetadata().getRenderer().getMinHeight(G,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":N});}}},this);}return this._oTemporaryContent;};
E.prototype.setDataMode=function(e){if(this._oDataProviderFactory&&e===x.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",e,true);if(this.getProperty("dataMode")===x.Active){this.refresh();}if(this.getProperty("dataMode")===x.Auto){this._oCardObserver.createObserver(this);if(!this._bFirstRendering){this._oCardObserver.oObserver.observe(this.getDomRef());}}return this;};
E.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(G,K){this.attachManifestReady(function(){this.loadDesigntime().then(G,K);}.bind(this));}.bind(this));}var e=this._oCardManifest.get("/sap.app/id");if(!e){return Promise.reject("App id not maintained");}return new Promise(function(G,K){var N=this._oCardManifest.get("/sap.card/configuration/editor");if(N===undefined){N=this._oCardManifest.get("/sap.card/designtime");}var P=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+N;if(P){sap.ui.require([P],function(Q){Q=new Q();Q._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=Q;G(Q);}.bind(this));}.bind(this),function(){K({error:P+" not found"});});}else{K();}}.bind(this));};
E.prototype.showLoadingPlaceholders=function(e){var G;switch(e){case z.Header:G=this.getCardHeader();if(G){G.showLoadingPlaceholders();}break;case z.Filters:G=this.getAggregation("_filterBar");if(G){G.getItems().forEach(function(K){K.showLoadingPlaceholders();});}break;case z.Content:if(this._createContentPromise){this._createContentPromise.then(function(K){K.showLoadingPlaceholders();});}else{this._bShowContentLoadingPlaceholders=true;}break;default:this.showLoadingPlaceholders(z.Header);this.showLoadingPlaceholders(z.Filters);this.showLoadingPlaceholders(z.Content);this.getAggregation("_loadingProvider").setLoading(true);}return this;};
E.prototype.hideLoadingPlaceholders=function(e){var G;switch(e){case z.Header:G=this.getCardHeader();if(G){G.hideLoadingPlaceholders();}break;case z.Filters:G=this.getAggregation("_filterBar");if(G){G.getItems().forEach(function(K){K.hideLoadingPlaceholders();});}break;case z.Content:if(this._createContentPromise){this._createContentPromise.then(function(K){K.hideLoadingPlaceholders();});}else{this._bShowContentLoadingPlaceholders=false;}break;default:this.hideLoadingPlaceholders(z.Header);this.hideLoadingPlaceholders(z.Filters);this.hideLoadingPlaceholders(z.Content);this.getAggregation("_loadingProvider").setLoading(false);}return this;};
E.prototype.isLoading=function(){var e=this.getAggregation("_loadingProvider");return e?e.getLoading():false;};
E.prototype.getFocusDomRef=function(){var e=this.getCardHeader();if(e&&e.getDomRef()){return e.getDomRef();}return this.getDomRef();};
E.prototype._showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};
E.prototype.onDataRequestComplete=function(){var e=this.getCardContent();this.fireEvent("_cardReady");this.hideLoadingPlaceholders(z.Header);this.hideLoadingPlaceholders(z.Filters);if(e&&e.isA("sap.ui.integration.cards.BaseContent")&&e.isReady()){this.hideLoadingPlaceholders(z.Content);}this.getAggregation("_loadingProvider").setLoading(false);};
E.prototype.request=function(e){return this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true).getData();};
E.prototype.triggerAction=function(e){s.fireAction({card:this,host:this.getHostInstance(),action:e,parameters:e.parameters,source:this});};
E.prototype._setPreviewMode=function(e){this._bIsPreviewMode=e;if(e){this.addStyleClass("sapFCardPreview");}else{this.removeStyleClass("sapFCardPreview");}this._bApplyManifest=true;this.invalidate();};
E.prototype.getBindingNamespaces=function(){var N={},e=this.getAggregation("_extension");if(e){N.extension={formatters:e.getFormatters()};}return N;};
E.prototype._registerCustomModels=function(){var e=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[];}this._deregisterCustomModels();e.forEach(function(G){var K=G&&G.name;if(!K){return;}if(u.indexOf(K)>-1){L.error("The model name (data section name) '"+K+"' is reserved for cards. Can not be used for creating a custom model.");return;}if(this._aCustomModels.indexOf(K)>-1){L.error("The model name (data section name) '"+K+"' is already used.");return;}this.setModel(new O(),K);this._aCustomModels.push(K);}.bind(this));};
E.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return;}this._aCustomModels.forEach(function(e){this.getModel(e).destroy();this.setModel(null,e);}.bind(this));this._aCustomModels=[];};
E.prototype._fireConfigurationChange=function(e){var G=this.getHostInstance();if(!this._bReady){return;}this.fireConfigurationChange({changes:e});if(G){G.fireCardConfigurationChange({card:this,changes:e});}};
return E;});
sap.ui.predefine('sap/ui/integration/widgets/CardRenderer',["sap/f/CardRenderer"],function(F){"use strict";var M={TYPE:"/sap.card/type"};return F.extend("sap.ui.integration.widgets.CardRenderer",{apiVersion:2,renderContainerAttributes:function(r,c){F.renderContainerAttributes.apply(this,arguments);r.class("sapUiIntCard");var C=c._oCardManifest;if(C&&C.get(M.TYPE)&&C.get(M.TYPE).toLowerCase()==="analytical"){r.class("sapUiIntCardAnalytical");}if(c.getAggregation("_footer")){r.class("sapUiIntCardWithFooter");}},renderContentSection:function(r,c){var f=c.getAggregation("_filterBar");if(f){r.openStart("div").class("sapFCardFilterBar").openEnd();r.renderControl(f);r.close("div");}F.renderContentSection.apply(this,arguments);},renderFooterSection:function(r,c){var f=c.getAggregation("_footer");if(f){r.renderControl(f);}}});});
sap.ui.require.preload({
	"sap/ui/integration/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.96.3"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"ui5-web-components","packagedWithMySelf":true,"version":"1.0.0-rc.8"},{"name":"webcomponentsjs","packagedWithMySelf":true,"version":"1.0.2"},{"name":"cldr","packagedWithMySelf":true,"version":"unknown"},{"name":"adaptive-cards","packagedWithMySelf":true,"version":"2.9.0"},{"name":"adaptive-cards-templating","packagedWithMySelf":true,"version":"0.1.1-alpha.0"},{"name":"markdown-it","packagedWithMySelf":true,"version":"10.0.0"},{"name":"ajv","packagedWithMySelf":true,"version":"6.12.3"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.96","libs":{"sap.ui.core":{"minVersion":"1.96.3"},"sap.f":{"minVersion":"1.96.3"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem"],"elements":["sap.ui.integration.ActionDefinition","sap.ui.integration.Host"],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"]}}}}',
	"sap/ui/integration/customElements/CustomElementCard.js":function(){sap.ui.require(["sap/ui/integration/widgets/Card","sap/ui/integration/customElements/CustomElementBase","sap/m/BadgeCustomData"],function(C,a,B){"use strict";var b=a.extend(C,{privateProperties:["width","height"],customProperties:{"badge":{set:function(c,v){c.addCustomData(new B({value:v}));}}}});b.prototype.refresh=function(){this._getControl().refresh();};b.prototype.loadDesigntime=function(){return this._getControl().loadDesigntime();};a.define("ui-integration-card",b);});
},
	"sap/ui/integration/customElements/CustomElementCardEditor.js":function(){sap.ui.require(["sap/ui/integration/designtime/editor/CardEditor","sap/ui/integration/customElements/CustomElementBase"],function(C,a){"use strict";var b=a.extend(C,{});b.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings();};var d=["ui-integration-card"];a.define("ui-integration-card-editor",b,d);});
},
	"sap/ui/integration/customElements/CustomElementEditor.js":function(){sap.ui.require(["sap/ui/integration/editor/Editor","sap/ui/integration/customElements/CustomElementBase"],function(E,C){"use strict";var a=C.extend(E,{});a.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings();};C.define("ui-integration-editor",a);});
},
	"sap/ui/integration/library-bootstrap.js":function(){(function(w){"use strict";var c;var s=document.currentScript||document.querySelector("script[src*='/sap-ui-integration.js']");
function b(){if(w.sap&&w.sap.ui&&w.sap.ui.getCore){c=w.sap.ui.getCore();return a();}w.sap.ui.require(['sap/ui/core/Core'],function(C){C.boot();c=C;C.attachInit(function(){a();});});}
function r(l){var L=c.getLoadedLibraries()[l];var t=Object.keys(L.customElements),T=s.getAttribute("tags");if(T){t=T.split(",");}w.sap.ui.require(t.map(function(o,i){return L.customElements[t[i]];}));}
function a(){c.loadLibraries(["sap/ui/integration"],{async:true}).then(function(){r("sap.ui.integration");});}
b();})(window);
},
	"sap/ui/integration/sap-ui-integration-config.js":function(){window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){(function(){"use strict";sap["ui"].define("sap/ui/thirdparty/jquery",function(){return jQuery;});sap["ui"].define("sap/ui/thirdparty/jqueryui/jquery-ui-position",function(){return jQuery;});})();
}
},"sap/ui/integration/library-preload"
);
//# sourceMappingURL=library-preload.js.map