/**
 * MIT License
 *
 * Copyright (c) 2017 Microsoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function w(r,f){if(typeof exports==='object'&&typeof module==='object')module.exports=f();else if(typeof sap.ui.define==='function')sap.ui.define([],f);else if(typeof exports==='object')exports["AdaptiveCards"]=f();else r["AdaptiveCards"]=f();})(window,function(){return(function(m){var i={};function _(a){if(i[a]){return i[a].exports;}var b=i[a]={i:a,l:false,exports:{}};m[a].call(b.exports,b,b.exports,_);b.l=true;return b.exports;}_.m=m;_.c=i;_.d=function(e,n,g){if(!_.o(e,n)){Object.defineProperty(e,n,{enumerable:true,get:g});}};_.r=function(e){if(typeof Symbol!=='undefined'&&Symbol.toStringTag){Object.defineProperty(e,Symbol.toStringTag,{value:'Module'});}Object.defineProperty(e,'__esModule',{value:true});};_.t=function(v,a){if(a&1)v=_(v);if(a&8)return v;if((a&4)&&typeof v==='object'&&v&&v.__esModule)return v;var n=Object.create(null);_.r(n);Object.defineProperty(n,'default',{enumerable:true,value:v});if(a&2&&typeof v!='string')for(var k in v)_.d(n,k,function(k){return v[k];}.bind(null,k));return n;};_.n=function(a){var g=a&&a.__esModule?function b(){return a['default'];}:function b(){return a;};_.d(g,'a',g);return g;};_.o=function(o,p){return Object.prototype.hasOwnProperty.call(o,p);};_.p="";return _(_.s="./src/adaptivecards.ts");})({"./src/activity-request.ts":(function(m,a,_){"use strict";var c=(this&&this.__extends)||(function(){var e=function(d,b){e=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return e(d,b);};return function(d,b){e(d,b);function h(){this.constructor=d;}d.prototype=b===null?Object.create(b):(h.prototype=b.prototype,new h());};})();Object.defineProperty(a,"__esModule",{value:true});a.LoginRequestResponse=a.ErrorResponse=a.SuccessResponse=a.ActivityResponse=a.ActivityRequestError=a.ActivityRequestTrigger=void 0;var A;(function(A){A["Automatic"]="automatic";A["Manual"]="manual";})(A=a.ActivityRequestTrigger||(a.ActivityRequestTrigger={}));var f=(function(){function f(b,d){this.code=b;this.message=d;}return f;}());a.ActivityRequestError=f;var g=(function(){function g(r){this.request=r;}return g;}());a.ActivityResponse=g;var S=(function(b){c(S,b);function S(r,d){var e=b.call(this,r)||this;e.request=r;e.rawContent=d;return e;}return S;}(g));a.SuccessResponse=S;var E=(function(b){c(E,b);function E(r,e){var d=b.call(this,r)||this;d.request=r;d.error=e;return d;}return E;}(g));a.ErrorResponse=E;var L=(function(b){c(L,b);function L(r,d){var h=b.call(this,r)||this;h.request=r;h._auth=d;for(var i=0,j=h._auth.buttons;i<j.length;i++){var k=j[i];if(k.type==="signin"&&k.value!==undefined){try{new URL(k.value);h.signinButton=k;break;}catch(e){}}}return h;}Object.defineProperty(L.prototype,"tokenExchangeResource",{get:function(){return this._auth.tokenExchangeResource;},enumerable:false,configurable:true});return L;}(g));a.LoginRequestResponse=L;}),"./src/adaptive-applet.ts":(function(m,a,b){"use strict";var c=(this&&this.__awaiter)||function(t,_,P,g){function f(v){return v instanceof P?v:new P(function(r){r(v);});}return new(P||(P=Promise))(function(r,n){function p(v){try{u(g.next(v));}catch(e){n(e);}}function q(v){try{u(g["throw"](v));}catch(e){n(e);}}function u(e){e.done?r(e.value):f(e.value).then(p,q);}u((g=g.apply(t,_||[])).next());});};var d=(this&&this.__generator)||function(p,q){var _={label:0,sent:function(){if(t[0]&1)throw t[1];return t[1];},trys:[],ops:[]},f,y,t,g;return g={next:r(0),"throw":r(1),"return":r(2)},typeof Symbol==="function"&&(g[Symbol.iterator]=function(){return this;}),g;function r(n){return function(v){return u([n,v]);};}function u(n){if(f)throw new TypeError("Generator is already executing.");while(_)try{if(f=1,y&&(t=n[0]&2?y["return"]:n[0]?y["throw"]||((t=y["return"])&&t.call(y),0):y.next)&&!(t=t.call(y,n[1])).done)return t;if(y=0,t)n=[n[0]&2,t.value];switch(n[0]){case 0:case 1:t=n;break;case 4:_.label++;return{value:n[1],done:false};case 5:_.label++;y=n[1];n=[0];continue;case 7:n=_.ops.pop();_.trys.pop();continue;default:if(!(t=_.trys,t=t.length>0&&t[t.length-1])&&(n[0]===6||n[0]===2)){_=0;continue;}if(n[0]===3&&(!t||(n[1]>t[0]&&n[1]<t[3]))){_.label=n[1];break;}if(n[0]===6&&_.label<t[1]){_.label=t[1];t=n;break;}if(t&&_.label<t[2]){_.label=t[2];_.ops.push(n);break;}if(t[2])_.ops.pop();_.trys.pop();continue;}n=q.call(p,_);}catch(e){n=[6,e];y=0;}finally{f=t=0;}if(n[0]&5)throw n[1];return{value:n[0]?n[1]:void 0,done:true};}};Object.defineProperty(a,"__esModule",{value:true});a.AdaptiveApplet=void 0;var E=b("./src/enums.ts");var U=b("./src/utils.ts");var s=b("./src/shared.ts");var h=b("./src/activity-request.ts");var i=b("./src/strings.ts");var j=b("./src/card-elements.ts");var k=b("./src/serialization.ts");function l(e,f){var g=[];for(var _=2;_<arguments.length;_++){g[_-2]=arguments[_];}if(s.GlobalSettings.applets.logEnabled){if(s.GlobalSettings.applets.onLogEvent){s.GlobalSettings.applets.onLogEvent(e,f,g);}else{switch(e){case E.LogLevel.Warning:console.warn(f,g);break;case E.LogLevel.Error:console.error(f,g);break;default:console.log(f,g);break;}}}}var A=(function(){function A(e,t,f){this.action=e;this.trigger=t;this.consecutiveRefreshes=f;this.attemptNumber=0;}A.prototype.retryAsync=function(){return c(this,void 0,void 0,function(){return d(this,function(_){if(this.onSend){this.onSend(this);}return[2];});});};return A;}());var o=(function(){function o(){this._allowAutomaticCardUpdate=false;this.renderedElement=document.createElement("div");this.renderedElement.className="aaf-cardHost";this.renderedElement.style.position="relative";this.renderedElement.style.display="flex";this.renderedElement.style.flexDirection="column";this._cardHostElement=document.createElement("div");this._refreshButtonHostElement=document.createElement("div");this._refreshButtonHostElement.className="aaf-refreshButtonHost";this._refreshButtonHostElement.style.display="none";this.renderedElement.appendChild(this._cardHostElement);this.renderedElement.appendChild(this._refreshButtonHostElement);}o.prototype.displayCard=function(e){if(e.renderedElement){U.clearElementChildren(this._cardHostElement);this._refreshButtonHostElement.style.display="none";this._cardHostElement.appendChild(e.renderedElement);}else{throw new Error("displayCard: undefined card.");}};o.prototype.showManualRefreshButton=function(r){var _=this;var e=this.onShowManualRefreshButton?this.onShowManualRefreshButton(this):true;if(e){this._refreshButtonHostElement.style.display="none";var f=undefined;if(this.onRenderManualRefreshButton){f=this.onRenderManualRefreshButton(this);}else{var g=i.Strings.runtime.refreshThisCard();if(s.GlobalSettings.applets.refresh.mode===E.RefreshMode.Automatic){var n=i.Strings.runtime.automaticRefreshPaused();if(n[n.length-1]!==" "){n+=" ";}g=i.Strings.runtime.clckToRestartAutomaticRefresh();}var p={type:"AdaptiveCard",version:"1.2",body:[{type:"RichTextBlock",horizontalAlignment:"right",inlines:[{type:"TextRun",text:g,selectAction:{type:"Action.Submit",id:"refreshCard"}}]}]};var q=new j.AdaptiveCard();q.parse(p,new j.SerializationContext(k.Versions.v1_2));q.onExecuteAction=function(t){if(t.id==="refreshCard"){U.clearElementChildren(_._refreshButtonHostElement);_.internalExecuteAction(r,h.ActivityRequestTrigger.Automatic,0);}};f=q.render();}if(f){U.clearElementChildren(this._refreshButtonHostElement);this._refreshButtonHostElement.appendChild(f);this._refreshButtonHostElement.style.removeProperty("display");}}};o.prototype.createActivityRequest=function(e,t,f){var _=this;if(this.card){var r=new A(e,t,f);r.onSend=function(n){n.attemptNumber++;_.internalSendActivityRequestAsync(r);};var g=this.onPrepareActivityRequest?!this.onPrepareActivityRequest(this,r,e):false;return g?undefined:r;}else{throw new Error("createActivityRequest: no card has been set.");}};o.prototype.createMagicCodeInputCard=function(e){var p={type:"AdaptiveCard",version:"1.0",body:[{type:"TextBlock",color:"attention",text:e===1?undefined:"That didn't work... let's try again.",wrap:true,horizontalAlignment:"center"},{type:"TextBlock",text:"Please login in the popup. You will obtain a magic code. Paste that code below and select \"Submit\"",wrap:true,horizontalAlignment:"center"},{type:"Input.Text",id:"magicCode",placeholder:"Enter magic code"},{type:"ActionSet",horizontalAlignment:"center",actions:[{type:"Action.Submit",id:o.submitMagicCodeActionId,title:"Submit"},{type:"Action.Submit",id:o.cancelMagicCodeAuthActionId,title:"Cancel"}]}]};var f=new j.AdaptiveCard();f.parse(p);return f;};o.prototype.cancelAutomaticRefresh=function(){if(this._allowAutomaticCardUpdate){l(E.LogLevel.Warning,"Automatic card refresh has been cancelled as a result of the user interacting with the card.");}this._allowAutomaticCardUpdate=false;};o.prototype.createSerializationContext=function(){return this.onCreateSerializationContext?this.onCreateSerializationContext(this):new j.SerializationContext();};o.prototype.internalSetCard=function(p,e){var _=this;if(typeof p==="object"&&p["type"]==="AdaptiveCard"){this._cardPayload=p;}if(this._cardPayload){try{var f=new j.AdaptiveCard();if(this.hostConfig){f.hostConfig=this.hostConfig;}var g=this.createSerializationContext();f.parse(this._cardPayload,g);var n=this.onCardChanging?this.onCardChanging(this,this._cardPayload):true;if(n){this._card=f;if(this._card.authentication&&this._card.authentication.tokenExchangeResource&&this.onPrefetchSSOToken){this.onPrefetchSSOToken(this,this._card.authentication.tokenExchangeResource);}this._card.onExecuteAction=function(t){_.cancelAutomaticRefresh();_.internalExecuteAction(t,h.ActivityRequestTrigger.Manual,0);};this._card.onInputValueChanged=function(t){_.cancelAutomaticRefresh();};this._card.render();if(this._card.renderedElement){this.displayCard(this._card);if(this.onCardChanged){this.onCardChanged(this);}if(this._card.refresh){if(s.GlobalSettings.applets.refresh.mode===E.RefreshMode.Automatic&&e<s.GlobalSettings.applets.refresh.maximumConsecutiveAutomaticRefreshes){if(s.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes<=0){l(E.LogLevel.Info,"Triggering automatic card refresh number "+(e+1));this.internalExecuteAction(this._card.refresh.action,h.ActivityRequestTrigger.Automatic,e+1);}else{l(E.LogLevel.Info,"Scheduling automatic card refresh number "+(e+1)+" in "+s.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes+"ms");var q=this._card.refresh.action;this._allowAutomaticCardUpdate=true;window.setTimeout(function(){if(_._allowAutomaticCardUpdate){_.internalExecuteAction(q,h.ActivityRequestTrigger.Automatic,e+1);}},s.GlobalSettings.applets.refresh.timeBetweenAutomaticRefreshes);}}else if(s.GlobalSettings.applets.refresh.mode!==E.RefreshMode.Disabled){if(e>0){l(E.LogLevel.Warning,"Stopping automatic refreshes after "+e+" consecutive refreshes.");}else{l(E.LogLevel.Warning,"The card has a refresh section, but automatic refreshes are disabled.");}if(s.GlobalSettings.applets.refresh.allowManualRefreshesAfterAutomaticRefreshes||s.GlobalSettings.applets.refresh.mode===E.RefreshMode.Manual){l(E.LogLevel.Info,"Showing manual refresh button.");this.showManualRefreshButton(this._card.refresh.action);}}}}}}catch(r){l(E.LogLevel.Error,"setCard: "+r);}}};o.prototype.internalExecuteAction=function(e,t,f){if(e instanceof j.ExecuteAction){if(this.channelAdapter){var r=this.createActivityRequest(e,t,f);if(r){r.retryAsync();}}else{throw new Error("internalExecuteAction: No channel adapter set.");}}if(this.onAction){this.onAction(this,e);}};o.prototype.createProgressOverlay=function(r){if(!this._progressOverlay){if(this.onCreateProgressOverlay){this._progressOverlay=this.onCreateProgressOverlay(this,r);}else{this._progressOverlay=document.createElement("div");this._progressOverlay.className="aaf-progress-overlay";var e=document.createElement("div");e.className="aaf-spinner";e.style.width="28px";e.style.height="28px";this._progressOverlay.appendChild(e);}}return this._progressOverlay;};o.prototype.removeProgressOverlay=function(r){if(this.onRemoveProgressOverlay){this.onRemoveProgressOverlay(this,r);}if(this._progressOverlay!==undefined){this.renderedElement.removeChild(this._progressOverlay);this._progressOverlay=undefined;}};o.prototype.activityRequestSucceeded=function(r,p){if(this.onActivityRequestSucceeded){this.onActivityRequestSucceeded(this,r,p);}};o.prototype.activityRequestFailed=function(r){return this.onActivityRequestFailed?this.onActivityRequestFailed(this,r):s.GlobalSettings.applets.defaultTimeBetweenRetryAttempts;};o.prototype.showAuthCodeInputDialog=function(r){var _=this;var e=this.onShowAuthCodeInputDialog?this.onShowAuthCodeInputDialog(this,r):true;if(e){var f=this.createMagicCodeInputCard(r.attemptNumber);f.render();f.onExecuteAction=function(g){if(_.card&&g instanceof j.SubmitAction){switch(g.id){case o.submitMagicCodeActionId:var n=undefined;if(g.data&&typeof g.data["magicCode"]==="string"){n=g.data["magicCode"];}if(n){_.displayCard(_.card);r.authCode=n;r.retryAsync();}else{alert("Please enter the magic code you received.");}break;case o.cancelMagicCodeAuthActionId:l(E.LogLevel.Warning,"Authentication cancelled by user.");_.displayCard(_.card);break;default:l(E.LogLevel.Error,"Unespected action taken from magic code input card (id = "+g.id+")");alert(i.Strings.magicCodeInputCard.somethingWentWrong());break;}}};this.displayCard(f);}};o.prototype.internalSendActivityRequestAsync=function(r){return c(this,void 0,void 0,function(){var e,f,_,t,g;return d(this,function(n){switch(n.label){case 0:if(!this.channelAdapter){throw new Error("internalSendActivityRequestAsync: channelAdapter is not set.");}e=this.createProgressOverlay(r);if(e!==undefined){this.renderedElement.appendChild(e);}f=false;_=function(){var p,q,u,v,w,x,y;return d(this,function(n){switch(n.label){case 0:p=undefined;if(r.attemptNumber===1){l(E.LogLevel.Info,"Sending activity request to channel (attempt "+r.attemptNumber+")");}else{l(E.LogLevel.Info,"Re-sending activity request to channel (attempt "+r.attemptNumber+")");}n.label=1;case 1:n.trys.push([1,3,,4]);return[4,t.channelAdapter.sendRequestAsync(r)];case 2:p=n.sent();return[3,4];case 3:q=n.sent();l(E.LogLevel.Error,"Activity request failed: "+q);t.removeProgressOverlay(r);f=true;return[3,4];case 4:if(!p)return[3,10];if(!(p instanceof h.SuccessResponse))return[3,5];t.removeProgressOverlay(r);if(p.rawContent===undefined){throw new Error("internalSendActivityRequestAsync: Action.Execute result is undefined");}u=p.rawContent;try{u=JSON.parse(p.rawContent);}catch(z){}if(typeof u==="string"){l(E.LogLevel.Info,"The activity request returned a string after "+r.attemptNumber+" attempt(s).");t.activityRequestSucceeded(p,u);}else if(typeof u==="object"&&u["type"]==="AdaptiveCard"){l(E.LogLevel.Info,"The activity request returned an Adaptive Card after "+r.attemptNumber+" attempt(s).");t.internalSetCard(u,r.consecutiveRefreshes);t.activityRequestSucceeded(p,t.card);}else{throw new Error("internalSendActivityRequestAsync: Action.Execute result is of unsupported type ("+typeof p.rawContent+")");}f=true;return[3,10];case 5:if(!(p instanceof h.ErrorResponse))return[3,9];v=t.activityRequestFailed(p);if(!(v>=0&&r.attemptNumber<s.GlobalSettings.applets.maximumRetryAttempts))return[3,7];l(E.LogLevel.Warning,"Activity request failed: "+p.error.message+". Retrying in "+v+"ms");r.attemptNumber++;return[4,new Promise(function(B,C){window.setTimeout(function(){B();},v);})];case 6:n.sent();return[3,8];case 7:l(E.LogLevel.Error,"Activity request failed: "+p.error.message+". Giving up after "+r.attemptNumber+" attempt(s)");t.removeProgressOverlay(r);f=true;n.label=8;case 8:return[3,10];case 9:if(p instanceof h.LoginRequestResponse){l(E.LogLevel.Info,"The activity request returned a LoginRequestResponse after "+r.attemptNumber+" attempt(s).");if(r.attemptNumber<=s.GlobalSettings.applets.maximumRetryAttempts){w=true;if(p.tokenExchangeResource&&t.onSSOTokenNeeded){w=!t.onSSOTokenNeeded(t,r,p.tokenExchangeResource);}if(w){t.removeProgressOverlay(r);if(p.signinButton===undefined){throw new Error("internalSendActivityRequestAsync: the login request doesn't contain a valid signin URL.");}l(E.LogLevel.Info,"Login required at "+p.signinButton.value);if(t.onShowSigninPrompt){t.onShowSigninPrompt(t,r,p.signinButton);}else{t.showAuthCodeInputDialog(r);x=window.screenX+(window.outerWidth-s.GlobalSettings.applets.authPromptWidth)/2;y=window.screenY+(window.outerHeight-s.GlobalSettings.applets.authPromptHeight)/2;window.open(p.signinButton.value,p.signinButton.title?p.signinButton.title:"Sign in","width="+s.GlobalSettings.applets.authPromptWidth+",height="+s.GlobalSettings.applets.authPromptHeight+",left="+x+",top="+y);}}}else{l(E.LogLevel.Error,"Authentication failed. Giving up after "+r.attemptNumber+" attempt(s)");alert(i.Strings.magicCodeInputCard.authenticationFailed());}return[2,"break"];}else{throw new Error("Unhandled response type: "+p.toString());}n.label=10;case 10:return[2];}});};t=this;n.label=1;case 1:if(!!f)return[3,3];return[5,_()];case 2:g=n.sent();if(g==="break")return[3,3];return[3,1];case 3:return[2];}});});};o.prototype.refreshCard=function(){if(this._card&&this._card.refresh){this.internalExecuteAction(this._card.refresh.action,h.ActivityRequestTrigger.Manual,0);}};o.prototype.setCard=function(p){this.internalSetCard(p,0);};Object.defineProperty(o.prototype,"card",{get:function(){return this._card;},enumerable:false,configurable:true});o.submitMagicCodeActionId="submitMagicCode";o.cancelMagicCodeAuthActionId="cancelMagicCodeAuth";return o;}());a.AdaptiveApplet=o;}),"./src/adaptivecards.ts":(function(a,e,_){"use strict";var b=(this&&this.__createBinding)||(Object.create?(function(o,m,k,d){if(d===undefined)d=k;Object.defineProperty(o,d,{enumerable:true,get:function(){return m[k];}});}):(function(o,m,k,d){if(d===undefined)d=k;o[d]=m[k];}));var c=(this&&this.__exportStar)||function(m,e){for(var p in m)if(p!=="default"&&!e.hasOwnProperty(p))b(e,m,p);};Object.defineProperty(e,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
c(_("./src/serialization.ts"),e);c(_("./src/registry.ts"),e);c(_("./src/card-object.ts"),e);c(_("./src/card-elements.ts"),e);c(_("./src/enums.ts"),e);c(_("./src/host-config.ts"),e);c(_("./src/shared.ts"),e);c(_("./src/utils.ts"),e);c(_("./src/strings.ts"),e);c(_("./src/channel-adapter.ts"),e);c(_("./src/activity-request.ts"),e);c(_("./src/adaptive-applet.ts"),e);}),"./src/card-elements.ts":(function(m,a,_){"use strict";var f=(this&&this.__extends)||(function(){var e=function(d,b){e=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return e(d,b);};return function(d,b){e(d,b);function c(){this.constructor=d;}d.prototype=b===null?Object.create(b):(c.prototype=b.prototype,new c());};})();var g=(this&&this.__decorate)||function(b,e,o,p){var c=arguments.length,r=c<3?e:p===null?p=Object.getOwnPropertyDescriptor(e,o):p,d;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")r=Reflect.decorate(b,e,o,p);else for(var i=b.length-1;i>=0;i--)if(d=b[i])r=(c<3?d(r):c>3?d(e,o,r):d(e,o))||r;return c>3&&r&&Object.defineProperty(e,o,r),r;};Object.defineProperty(a,"__esModule",{value:true});a.SerializationContext=a.GlobalRegistry=a.AdaptiveCard=a.Authentication=a.TokenExchangeResource=a.AuthCardButton=a.RefreshDefinition=a.RefreshActionProperty=a.ContainerWithActions=a.ColumnSet=a.Column=a.Container=a.BackgroundImage=a.StylableCardElementContainer=a.ActionSet=a.ShowCardAction=a.HttpAction=a.HttpHeader=a.ToggleVisibilityAction=a.OpenUrlAction=a.ExecuteAction=a.SubmitAction=a.SubmitActionBase=a.Action=a.TimeInput=a.TimeProperty=a.DateInput=a.NumberInput=a.ChoiceSetInput=a.Choice=a.ToggleInput=a.TextInput=a.Input=a.Media=a.MediaSource=a.ImageSet=a.CardElementContainer=a.Image=a.FactSet=a.Fact=a.RichTextBlock=a.TextRun=a.TextBlock=a.BaseTextBlock=a.ActionProperty=a.CardElement=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var s=_("./src/shared.ts");var U=_("./src/utils.ts");var h=_("./src/host-config.ts");var T=_("./src/text-formatters.ts");var j=_("./src/card-object.ts");var k=_("./src/serialization.ts");var l=_("./src/registry.ts");var n=_("./src/strings.ts");var C=(function(b){f(C,b);function C(){var c=b!==null&&b.apply(this,arguments)||this;c._truncatedDueToOverflow=false;return c;}Object.defineProperty(C.prototype,"lang",{get:function(){var c=this.getValue(C.langProperty);if(c){return c;}else{if(this.parent){return this.parent.lang;}else{return undefined;}}},set:function(c){this.setValue(C.langProperty,c);},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"isVisible",{get:function(){return this.getValue(C.isVisibleProperty);},set:function(c){if(s.GlobalSettings.useAdvancedCardBottomTruncation&&!c){this.undoOverflowTruncation();}if(this.isVisible!==c){this.setValue(C.isVisibleProperty,c);this.updateRenderedElementVisibility();if(this._renderedElement){o1(this);}}if(this._renderedElement){this._renderedElement.setAttribute("aria-expanded",c.toString());}},enumerable:false,configurable:true});C.prototype.internalRenderSeparator=function(){var r=U.renderSeparation(this.hostConfig,{spacing:this.hostConfig.getEffectiveSpacing(this.spacing),lineThickness:this.separator?this.hostConfig.separator.lineThickness:undefined,lineColor:this.separator?this.hostConfig.separator.lineColor:undefined},this.separatorOrientation);if(s.GlobalSettings.alwaysBleedSeparators&&r&&this.separatorOrientation==E.Orientation.Horizontal){var p=this.getParentContainer();if(p&&p.getEffectivePadding()){var c=this.hostConfig.paddingDefinitionToSpacingDefinition(p.getEffectivePadding());r.style.marginLeft="-"+c.left+"px";r.style.marginRight="-"+c.right+"px";}}return r;};C.prototype.updateRenderedElementVisibility=function(){var d=this.isDesignMode()||this.isVisible?this._defaultRenderedElementDisplayMode:"none";if(this._renderedElement){if(d){this._renderedElement.style.display=d;}else{this._renderedElement.style.removeProperty("display");}}if(this._separatorElement){if(this.parent&&this.parent.isFirstElement(this)){this._separatorElement.style.display="none";}else{if(d){this._separatorElement.style.display=d;}else{this._separatorElement.style.removeProperty("display");}}}};C.prototype.hideElementDueToOverflow=function(){if(this._renderedElement&&this.isVisible){this._renderedElement.style.visibility="hidden";this.isVisible=false;o1(this,false);}};C.prototype.showElementHiddenDueToOverflow=function(){if(this._renderedElement&&!this.isVisible){this._renderedElement.style.removeProperty("visibility");this.isVisible=true;o1(this,false);}};C.prototype.handleOverflow=function(c){if(this.isVisible||this.isHiddenDueToOverflow()){var d=this.truncateOverflow(c);this._truncatedDueToOverflow=d||this._truncatedDueToOverflow;if(!d){this.hideElementDueToOverflow();}else if(d&&!this.isVisible){this.showElementHiddenDueToOverflow();}}};C.prototype.resetOverflow=function(){var c=false;if(this._truncatedDueToOverflow){this.undoOverflowTruncation();this._truncatedDueToOverflow=false;c=true;}if(this.isHiddenDueToOverflow()){this.showElementHiddenDueToOverflow();}return c;};C.prototype.getDefaultSerializationContext=function(){return new y1();};C.prototype.createPlaceholderElement=function(){var c=this.getEffectiveStyleDefinition();var d=U.stringToCssColor(c.foregroundColors.default.subtle);var e=document.createElement("div");e.style.border="1px dashed "+d;e.style.padding="4px";e.style.minHeight="32px";e.style.fontSize="10px";e.style.color=d;e.innerText="Empty "+this.getJsonTypeName();return e;};C.prototype.adjustRenderedElementSize=function(r){if(this.height==="auto"){r.style.flex="0 0 auto";}else{r.style.flex="1 1 auto";}};C.prototype.isDisplayed=function(){return this._renderedElement!==undefined&&this.isVisible&&this._renderedElement.offsetHeight>0;};C.prototype.overrideInternalRender=function(){return this.internalRender();};C.prototype.applyPadding=function(){if(this.separatorElement&&this.separatorOrientation===E.Orientation.Horizontal){if(s.GlobalSettings.alwaysBleedSeparators&&!this.isBleeding()){var p=new s.PaddingDefinition();this.getImmediateSurroundingPadding(p);var c=this.hostConfig.paddingDefinitionToSpacingDefinition(p);this.separatorElement.style.marginLeft="-"+c.left+"px";this.separatorElement.style.marginRight="-"+c.right+"px";}else{this.separatorElement.style.marginRight="0";this.separatorElement.style.marginLeft="0";}}};C.prototype.truncateOverflow=function(c){return false;};C.prototype.undoOverflowTruncation=function(){};C.prototype.getDefaultPadding=function(){return new s.PaddingDefinition();};C.prototype.getHasBackground=function(){return false;};C.prototype.getPadding=function(){return this._padding;};C.prototype.setPadding=function(c){this._padding=c;};C.prototype.shouldSerialize=function(c){return c.elementRegistry.findByName(this.getJsonTypeName())!==undefined;};Object.defineProperty(C.prototype,"useDefaultSizing",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"allowCustomPadding",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"separatorOrientation",{get:function(){return E.Orientation.Horizontal;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"defaultStyle",{get:function(){return E.ContainerStyle.Default;},enumerable:false,configurable:true});C.prototype.parse=function(c,d){b.prototype.parse.call(this,c,d?d:new y1());};C.prototype.asString=function(){return"";};C.prototype.isBleeding=function(){return false;};C.prototype.getEffectiveStyle=function(){if(this.parent){return this.parent.getEffectiveStyle();}return this.defaultStyle;};C.prototype.getEffectiveStyleDefinition=function(){return this.hostConfig.containerStyles.getStyleByName(this.getEffectiveStyle());};C.prototype.getForbiddenActionTypes=function(){return[];};C.prototype.getImmediateSurroundingPadding=function(r,p,c,d,e){if(p===void 0){p=true;}if(c===void 0){c=true;}if(d===void 0){d=true;}if(e===void 0){e=true;}if(this.parent){var i=p&&this.parent.isTopElement(this);var o=c&&this.parent.isRightMostElement(this);var z1=d&&this.parent.isBottomElement(this);var A1=e&&this.parent.isLeftMostElement(this);var B1=this.parent.getEffectivePadding();if(B1){if(i&&B1.top!=E.Spacing.None){r.top=B1.top;i=false;}if(o&&B1.right!=E.Spacing.None){r.right=B1.right;o=false;}if(z1&&B1.bottom!=E.Spacing.None){r.bottom=B1.bottom;z1=false;}if(A1&&B1.left!=E.Spacing.None){r.left=B1.left;A1=false;}}if(i||o||z1||A1){this.parent.getImmediateSurroundingPadding(r,i,o,z1,A1);}}};C.prototype.getActionCount=function(){return 0;};C.prototype.getActionAt=function(i){throw new Error(n.Strings.errors.indexOutOfRange(i));};C.prototype.remove=function(){if(this.parent&&this.parent instanceof w){return this.parent.removeItem(this);}return false;};C.prototype.render=function(){this._renderedElement=this.overrideInternalRender();this._separatorElement=this.internalRenderSeparator();if(this._renderedElement){if(this.id){this._renderedElement.id=this.id;}if(this.customCssSelector){this._renderedElement.classList.add(this.customCssSelector);}this._renderedElement.style.boxSizing="border-box";this._defaultRenderedElementDisplayMode=this._renderedElement.style.display?this._renderedElement.style.display:undefined;this.adjustRenderedElementSize(this._renderedElement);this.updateLayout(false);}else if(this.isDesignMode()){this._renderedElement=this.createPlaceholderElement();}return this._renderedElement;};C.prototype.updateLayout=function(p){if(p===void 0){p=true;}this.updateRenderedElementVisibility();this.applyPadding();};C.prototype.indexOf=function(c){return-1;};C.prototype.isDesignMode=function(){var r=this.getRootElement();return r instanceof v1&&r.designMode;};C.prototype.isFirstElement=function(e){return true;};C.prototype.isLastElement=function(e){return true;};C.prototype.isAtTheVeryLeft=function(){return this.parent?this.parent.isLeftMostElement(this)&&this.parent.isAtTheVeryLeft():true;};C.prototype.isAtTheVeryRight=function(){return this.parent?this.parent.isRightMostElement(this)&&this.parent.isAtTheVeryRight():true;};C.prototype.isAtTheVeryTop=function(){return this.parent?this.parent.isFirstElement(this)&&this.parent.isAtTheVeryTop():true;};C.prototype.isAtTheVeryBottom=function(){return this.parent?this.parent.isLastElement(this)&&this.parent.isAtTheVeryBottom():true;};C.prototype.isBleedingAtTop=function(){return false;};C.prototype.isBleedingAtBottom=function(){return false;};C.prototype.isLeftMostElement=function(e){return true;};C.prototype.isRightMostElement=function(e){return true;};C.prototype.isTopElement=function(e){return this.isFirstElement(e);};C.prototype.isBottomElement=function(e){return this.isLastElement(e);};C.prototype.isHiddenDueToOverflow=function(){return this._renderedElement!==undefined&&this._renderedElement.style.visibility=='hidden';};C.prototype.getRootElement=function(){return this.getRootObject();};C.prototype.getParentContainer=function(){var c=this.parent;while(c){if(c instanceof g1){return c;}c=c.parent;}return undefined;};C.prototype.getAllInputs=function(p){if(p===void 0){p=true;}return[];};C.prototype.getResourceInformation=function(){return[];};C.prototype.getElementById=function(i){return this.id===i?this:undefined;};C.prototype.getActionById=function(i){return undefined;};C.prototype.getEffectivePadding=function(){var p=this.getPadding();return(p&&this.allowCustomPadding)?p:this.getDefaultPadding();};Object.defineProperty(C.prototype,"hostConfig",{get:function(){if(this._hostConfig){return this._hostConfig;}else{if(this.parent){return this.parent.hostConfig;}else{return h.defaultHostConfig;}}},set:function(c){this._hostConfig=c;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"index",{get:function(){if(this.parent){return this.parent.indexOf(this);}else{return 0;}},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"isInteractive",{get:function(){return false;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"isStandalone",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"isInline",{get:function(){return false;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"hasVisibleSeparator",{get:function(){if(this.parent&&this.separatorElement){return!this.parent.isFirstElement(this)&&(this.isVisible||this.isDesignMode());}else{return false;}},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"separatorElement",{get:function(){return this._separatorElement;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"parent",{get:function(){return this._parent;},enumerable:false,configurable:true});C.langProperty=new k.StringProperty(k.Versions.v1_1,"lang",true,/^[a-z]{2,3}$/ig);C.isVisibleProperty=new k.BoolProperty(k.Versions.v1_2,"isVisible",true);C.separatorProperty=new k.BoolProperty(k.Versions.v1_0,"separator",false);C.heightProperty=new k.ValueSetProperty(k.Versions.v1_1,"height",[{value:"auto"},{value:"stretch"}],"auto");C.horizontalAlignmentProperty=new k.EnumProperty(k.Versions.v1_0,"horizontalAlignment",E.HorizontalAlignment,E.HorizontalAlignment.Left);C.spacingProperty=new k.EnumProperty(k.Versions.v1_0,"spacing",E.Spacing,E.Spacing.Default);g([k.property(C.horizontalAlignmentProperty)],C.prototype,"horizontalAlignment",void 0);g([k.property(C.spacingProperty)],C.prototype,"spacing",void 0);g([k.property(C.separatorProperty)],C.prototype,"separator",void 0);g([k.property(C.heightProperty)],C.prototype,"height",void 0);g([k.property(C.langProperty)],C.prototype,"lang",null);g([k.property(C.isVisibleProperty)],C.prototype,"isVisible",null);return C;}(j.CardObject));a.CardElement=C;var A=(function(b){f(A,b);function A(c,d,e){if(e===void 0){e=[];}var i=b.call(this,c,d,undefined)||this;i.targetVersion=c;i.name=d;i.forbiddenActionTypes=e;return i;}A.prototype.parse=function(c,d,e){var p=c;return e.parseAction(p,d[this.name],this.forbiddenActionTypes,p.isDesignMode());};A.prototype.toJSON=function(c,d,e,i){i.serializeValue(d,this.name,e?e.toJSON(i):undefined,undefined,true);};return A;}(k.PropertyDefinition));a.ActionProperty=A;var B=(function(b){f(B,b);function B(c){var d=b.call(this)||this;d.size=E.TextSize.Default;d.weight=E.TextWeight.Default;d.color=E.TextColor.Default;d.isSubtle=false;d.ariaHidden=false;if(c){d.text=c;}return d;}B.prototype.populateSchema=function(c){b.prototype.populateSchema.call(this,c);c.remove(B.selectActionProperty);};Object.defineProperty(B.prototype,"text",{get:function(){return this.getValue(B.textProperty);},set:function(c){this.setText(c);},enumerable:false,configurable:true});B.prototype.getFontSize=function(c){switch(this.size){case E.TextSize.Small:return c.fontSizes.small;case E.TextSize.Medium:return c.fontSizes.medium;case E.TextSize.Large:return c.fontSizes.large;case E.TextSize.ExtraLarge:return c.fontSizes.extraLarge;default:return c.fontSizes.default;}};B.prototype.getColorDefinition=function(c,d){switch(d){case E.TextColor.Accent:return c.accent;case E.TextColor.Dark:return c.dark;case E.TextColor.Light:return c.light;case E.TextColor.Good:return c.good;case E.TextColor.Warning:return c.warning;case E.TextColor.Attention:return c.attention;default:return c.default;}};B.prototype.setText=function(c){this.setValue(B.textProperty,c);};B.prototype.init=function(c){this.size=c.size;this.weight=c.weight;this.color=c.color;this.isSubtle=c.isSubtle;};B.prototype.asString=function(){return this.text;};B.prototype.applyStylesTo=function(c){var d=this.hostConfig.getFontTypeDefinition(this.fontType);if(d.fontFamily){c.style.fontFamily=d.fontFamily;}var e;switch(this.size){case E.TextSize.Small:e=d.fontSizes.small;break;case E.TextSize.Medium:e=d.fontSizes.medium;break;case E.TextSize.Large:e=d.fontSizes.large;break;case E.TextSize.ExtraLarge:e=d.fontSizes.extraLarge;break;default:e=d.fontSizes.default;break;}c.style.fontSize=e+"px";var i=this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors,this.effectiveColor);c.style.color=U.stringToCssColor(this.isSubtle?i.subtle:i.default);var o;switch(this.weight){case E.TextWeight.Lighter:o=d.fontWeights.lighter;break;case E.TextWeight.Bolder:o=d.fontWeights.bolder;break;default:o=d.fontWeights.default;break;}c.style.fontWeight=o.toString();if(this.ariaHidden){c.setAttribute("aria-hidden","true");}};Object.defineProperty(B.prototype,"effectiveColor",{get:function(){return this.color?this.color:E.TextColor.Default;},enumerable:false,configurable:true});B.textProperty=new k.StringProperty(k.Versions.v1_0,"text",true);B.sizeProperty=new k.EnumProperty(k.Versions.v1_0,"size",E.TextSize,E.TextSize.Default);B.weightProperty=new k.EnumProperty(k.Versions.v1_0,"weight",E.TextWeight,E.TextWeight.Default);B.colorProperty=new k.EnumProperty(k.Versions.v1_0,"color",E.TextColor,E.TextColor.Default);B.isSubtleProperty=new k.BoolProperty(k.Versions.v1_0,"isSubtle",false);B.fontTypeProperty=new k.EnumProperty(k.Versions.v1_2,"fontType",E.FontType);B.selectActionProperty=new A(k.Versions.v1_1,"selectAction",["Action.ShowCard"]);g([k.property(B.sizeProperty)],B.prototype,"size",void 0);g([k.property(B.weightProperty)],B.prototype,"weight",void 0);g([k.property(B.colorProperty)],B.prototype,"color",void 0);g([k.property(B.fontTypeProperty)],B.prototype,"fontType",void 0);g([k.property(B.isSubtleProperty)],B.prototype,"isSubtle",void 0);g([k.property(B.textProperty)],B.prototype,"text",null);g([k.property(B.selectActionProperty)],B.prototype,"selectAction",void 0);return B;}(C));a.BaseTextBlock=B;var q=(function(b){f(q,b);function q(){var c=b!==null&&b.apply(this,arguments)||this;c.wrap=false;c._treatAsPlainText=true;c.useMarkdown=true;return c;}q.prototype.restoreOriginalContent=function(){if(this.renderedElement!==undefined){if(this.maxLines&&this.maxLines>0){this.renderedElement.style.maxHeight=this._computedLineHeight*this.maxLines+"px";}this.renderedElement.innerHTML=this._originalInnerHtml;}};q.prototype.truncateIfSupported=function(c){if(this.renderedElement!==undefined){var d=this.renderedElement.children;var i=!d.length;var e=i||d.length==1&&d[0].tagName.toLowerCase()=='p';if(e){var o=i?this.renderedElement:d[0];U.truncate(o,c,this._computedLineHeight);return true;}}return false;};q.prototype.setText=function(c){b.prototype.setText.call(this,c);this._processedText=undefined;};q.prototype.internalRender=function(){var c=this;this._processedText=undefined;if(this.text){var p=this.preProcessPropertyValue(B.textProperty);var d=this.hostConfig;var o=void 0;if(this.forElementId){var r=document.createElement("label");r.htmlFor=this.forElementId;o=r;}else{o=document.createElement("div");}o.classList.add(d.makeCssClassName("ac-textBlock"));o.style.overflow="hidden";this.applyStylesTo(o);if(this.selectAction){o.onclick=function(e){e.preventDefault();e.cancelBubble=true;if(c.selectAction){c.selectAction.execute();}};if(d.supportsInteractivity){o.tabIndex=0;o.setAttribute("role",this.selectAction.getAriaRole());if(this.selectAction.title){o.setAttribute("aria-label",this.selectAction.title);o.title=this.selectAction.title;}o.classList.add(d.makeCssClassName("ac-selectable"));}}if(!this._processedText){this._treatAsPlainText=true;var z1=T.formatText(this.lang,p);if(this.useMarkdown&&z1){if(s.GlobalSettings.allowMarkForTextHighlighting){z1=z1.replace(/<mark>/g,"===").replace(/<\/mark>/g,"/==/");}var A1=v1.applyMarkdown(z1);if(A1.didProcess&&A1.outputHtml){this._processedText=A1.outputHtml;this._treatAsPlainText=false;if(s.GlobalSettings.allowMarkForTextHighlighting&&this._processedText){var B1="";var C1=this.getEffectiveStyleDefinition();if(C1.highlightBackgroundColor){B1+="background-color: "+C1.highlightBackgroundColor+";";}if(C1.highlightForegroundColor){B1+="color: "+C1.highlightForegroundColor+";";}if(B1){B1='style="'+B1+'"';}this._processedText=this._processedText.replace(/===/g,"<mark "+B1+">").replace(/\/==\//g,"</mark>");}}else{this._processedText=z1;this._treatAsPlainText=true;}}else{this._processedText=z1;this._treatAsPlainText=true;}}if(!this._processedText){this._processedText="";}if(this._treatAsPlainText){o.innerText=this._processedText;}else{o.innerHTML=this._processedText;}if(o.firstElementChild instanceof HTMLElement){var D1=o.firstElementChild;D1.style.marginTop="0px";D1.style.width="100%";if(!this.wrap){D1.style.overflow="hidden";D1.style.textOverflow="ellipsis";}}if(o.lastElementChild instanceof HTMLElement){o.lastElementChild.style.marginBottom="0px";}var E1=o.getElementsByTagName("a");for(var i=0;i<E1.length;i++){var F1=E1[i];F1.classList.add(d.makeCssClassName("ac-anchor"));F1.target="_blank";F1.onclick=function(e){if(k1(c,e.target,e)){e.preventDefault();e.cancelBubble=true;}};F1.oncontextmenu=function(e){if(k1(c,e.target,e)){e.preventDefault();e.cancelBubble=true;return false;}return true;};}if(this.wrap){o.style.wordWrap="break-word";if(this.maxLines&&this.maxLines>0){o.style.overflow="hidden";if(U.isInternetExplorer()||!s.GlobalSettings.useWebkitLineClamp){o.style.maxHeight=(this._computedLineHeight*this.maxLines)+"px";}else{o.style.removeProperty("line-height");o.style.display="-webkit-box";o.style.webkitBoxOrient="vertical";o.style.webkitLineClamp=this.maxLines.toString();}}}else{o.style.whiteSpace="nowrap";o.style.textOverflow="ellipsis";}if(s.GlobalSettings.useAdvancedTextBlockTruncation||s.GlobalSettings.useAdvancedCardBottomTruncation){this._originalInnerHtml=o.innerHTML;}return o;}else{return undefined;}};q.prototype.truncateOverflow=function(c){if(c>=this._computedLineHeight){return this.truncateIfSupported(c);}return false;};q.prototype.undoOverflowTruncation=function(){this.restoreOriginalContent();if(s.GlobalSettings.useAdvancedTextBlockTruncation&&this.maxLines){var c=this._computedLineHeight*this.maxLines;this.truncateIfSupported(c);}};q.prototype.applyStylesTo=function(c){b.prototype.applyStylesTo.call(this,c);var p=this.getParentContainer();var i=p?p.isRtl():false;switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:c.style.textAlign="center";break;case E.HorizontalAlignment.Right:c.style.textAlign=i?"left":"right";break;default:c.style.textAlign=i?"right":"left";break;}var d=this.hostConfig.lineHeights;if(d){switch(this.size){case E.TextSize.Small:this._computedLineHeight=d.small;break;case E.TextSize.Medium:this._computedLineHeight=d.medium;break;case E.TextSize.Large:this._computedLineHeight=d.large;break;case E.TextSize.ExtraLarge:this._computedLineHeight=d.extraLarge;break;default:this._computedLineHeight=d.default;break;}}else{this._computedLineHeight=this.getFontSize(this.hostConfig.getFontTypeDefinition(this.fontType))*1.33;}c.style.lineHeight=this._computedLineHeight+"px";};q.prototype.getJsonTypeName=function(){return"TextBlock";};q.prototype.updateLayout=function(p){if(p===void 0){p=false;}b.prototype.updateLayout.call(this,p);if(s.GlobalSettings.useAdvancedTextBlockTruncation&&this.maxLines&&this.isDisplayed()){this.restoreOriginalContent();this.truncateIfSupported(this._computedLineHeight*this.maxLines);}};q.wrapProperty=new k.BoolProperty(k.Versions.v1_0,"wrap",false);q.maxLinesProperty=new k.NumProperty(k.Versions.v1_0,"maxLines");g([k.property(q.wrapProperty)],q.prototype,"wrap",void 0);g([k.property(q.maxLinesProperty)],q.prototype,"maxLines",void 0);return q;}(B));a.TextBlock=q;var t=(function(b){f(t,b);function t(){var c=b!==null&&b.apply(this,arguments)||this;c.italic=false;c.strikethrough=false;c.highlight=false;c.underline=false;return c;}t.prototype.populateSchema=function(c){b.prototype.populateSchema.call(this,c);c.add(B.selectActionProperty);};t.prototype.internalRender=function(){var c=this;if(this.text){var p=this.preProcessPropertyValue(B.textProperty);var d=this.hostConfig;var i=T.formatText(this.lang,p);if(!i){i="";}var o=document.createElement("span");o.classList.add(d.makeCssClassName("ac-textRun"));this.applyStylesTo(o);if(this.selectAction&&d.supportsInteractivity){var r=document.createElement("a");r.classList.add(d.makeCssClassName("ac-anchor"));var z1=this.selectAction.getHref();r.href=z1?z1:"";r.target="_blank";r.onclick=function(e){e.preventDefault();e.cancelBubble=true;if(c.selectAction){c.selectAction.execute();}};if(this.selectAction.title){r.setAttribute("aria-label",this.selectAction.title);r.title=this.selectAction.title;}r.innerText=i;o.appendChild(r);}else{o.innerText=i;}return o;}else{return undefined;}};t.prototype.applyStylesTo=function(c){b.prototype.applyStylesTo.call(this,c);if(this.italic){c.style.fontStyle="italic";}if(this.strikethrough){c.style.textDecoration="line-through";}if(this.highlight){var d=this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors,this.effectiveColor);c.style.backgroundColor=U.stringToCssColor(this.isSubtle?d.highlightColors.subtle:d.highlightColors.default);}if(this.underline){c.style.textDecoration="underline";}};t.prototype.getJsonTypeName=function(){return"TextRun";};Object.defineProperty(t.prototype,"isStandalone",{get:function(){return false;},enumerable:false,configurable:true});Object.defineProperty(t.prototype,"isInline",{get:function(){return true;},enumerable:false,configurable:true});t.italicProperty=new k.BoolProperty(k.Versions.v1_2,"italic",false);t.strikethroughProperty=new k.BoolProperty(k.Versions.v1_2,"strikethrough",false);t.highlightProperty=new k.BoolProperty(k.Versions.v1_2,"highlight",false);t.underlineProperty=new k.BoolProperty(k.Versions.v1_3,"underline",false);g([k.property(t.italicProperty)],t.prototype,"italic",void 0);g([k.property(t.strikethroughProperty)],t.prototype,"strikethrough",void 0);g([k.property(t.highlightProperty)],t.prototype,"highlight",void 0);g([k.property(t.underlineProperty)],t.prototype,"underline",void 0);return t;}(B));a.TextRun=t;var R=(function(b){f(R,b);function R(){var c=b!==null&&b.apply(this,arguments)||this;c._inlines=[];return c;}R.prototype.internalAddInline=function(i,c){if(c===void 0){c=false;}if(!i.isInline){throw new Error(n.Strings.errors.elementCannotBeUsedAsInline());}var d=i.parent===undefined||c;if(!d&&i.parent!=this){throw new Error(n.Strings.errors.inlineAlreadyParented());}else{i.setParent(this);this._inlines.push(i);}};R.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);this._inlines=[];if(Array.isArray(c["inlines"])){for(var e=0,i=c["inlines"];e<i.length;e++){var o=i[e];var p=void 0;if(typeof o==="string"){var r=new t();r.text=o;p=r;}else{p=d.parseElement(this,o,false);}if(p){this.internalAddInline(p,true);}}}};R.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);if(this._inlines.length>0){var e=[];for(var i=0,o=this._inlines;i<o.length;i++){var p=o[i];e.push(p.toJSON(d));}d.serializeValue(c,"inlines",e);}};R.prototype.internalRender=function(){if(this._inlines.length>0){var e=void 0;if(this.forElementId){var c=document.createElement("label");c.htmlFor=this.forElementId;e=c;}else{e=document.createElement("div");}e.className=this.hostConfig.makeCssClassName("ac-richTextBlock");var p=this.getParentContainer();var i=p?p.isRtl():false;switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.style.textAlign="center";break;case E.HorizontalAlignment.Right:e.style.textAlign=i?"left":"right";break;default:e.style.textAlign=i?"right":"left";break;}var r=0;for(var d=0,o=this._inlines;d<o.length;d++){var z1=o[d];var A1=z1.render();if(A1){e.appendChild(A1);r++;}}if(r>0){return e;}}return undefined;};R.prototype.asString=function(){var r="";for(var c=0,d=this._inlines;c<d.length;c++){var i=d[c];r+=i.asString();}return r;};R.prototype.getJsonTypeName=function(){return"RichTextBlock";};R.prototype.getInlineCount=function(){return this._inlines.length;};R.prototype.getInlineAt=function(i){if(i>=0&&i<this._inlines.length){return this._inlines[i];}else{throw new Error(n.Strings.errors.indexOutOfRange(i));}};R.prototype.addInline=function(i){if(typeof i==="string"){this.internalAddInline(new t(i));}else{this.internalAddInline(i);}};R.prototype.removeInline=function(i){var c=this._inlines.indexOf(i);if(c>=0){this._inlines[c].setParent(undefined);this._inlines.splice(c,1);return true;}return false;};return R;}(C));a.RichTextBlock=R;var F=(function(b){f(F,b);function F(c,d){var e=b.call(this)||this;e.name=c;e.value=d;return e;}F.prototype.getSchemaKey=function(){return"Fact";};F.titleProperty=new k.StringProperty(k.Versions.v1_0,"title");F.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");g([k.property(F.titleProperty)],F.prototype,"name",void 0);g([k.property(F.valueProperty)],F.prototype,"value",void 0);return F;}(k.SerializableObject));a.Fact=F;var u=(function(b){f(u,b);function u(){return b!==null&&b.apply(this,arguments)||this;}Object.defineProperty(u.prototype,"useDefaultSizing",{get:function(){return false;},enumerable:false,configurable:true});u.prototype.internalRender=function(){var e=undefined;var c=this.hostConfig;if(this.facts.length>0){e=document.createElement("table");e.style.borderWidth="0px";e.style.borderSpacing="0px";e.style.borderStyle="none";e.style.borderCollapse="collapse";e.style.display="block";e.style.overflow="hidden";e.classList.add(c.makeCssClassName("ac-factset"));e.setAttribute("role","presentation");for(var i=0;i<this.facts.length;i++){var d=document.createElement("tr");if(i>0){d.style.marginTop=c.factSet.spacing+"px";}var o=document.createElement("td");o.style.padding="0";o.classList.add(c.makeCssClassName("ac-fact-title"));if(c.factSet.title.maxWidth){o.style.maxWidth=c.factSet.title.maxWidth+"px";}o.style.verticalAlign="top";var p=new q();p.setParent(this);p.text=(!this.facts[i].name&&this.isDesignMode())?"Title":this.facts[i].name;p.size=c.factSet.title.size;p.color=c.factSet.title.color;p.isSubtle=c.factSet.title.isSubtle;p.weight=c.factSet.title.weight;p.wrap=c.factSet.title.wrap;p.spacing=E.Spacing.None;U.appendChild(o,p.render());U.appendChild(d,o);o=document.createElement("td");o.style.width="10px";U.appendChild(d,o);o=document.createElement("td");o.style.padding="0";o.style.verticalAlign="top";o.classList.add(c.makeCssClassName("ac-fact-value"));p=new q();p.setParent(this);p.text=this.facts[i].value;p.size=c.factSet.value.size;p.color=c.factSet.value.color;p.isSubtle=c.factSet.value.isSubtle;p.weight=c.factSet.value.weight;p.wrap=c.factSet.value.wrap;p.spacing=E.Spacing.None;U.appendChild(o,p.render());U.appendChild(d,o);U.appendChild(e,d);}}return e;};u.prototype.getJsonTypeName=function(){return"FactSet";};u.factsProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_0,"facts",F);g([k.property(u.factsProperty)],u.prototype,"facts",void 0);return u;}(C));a.FactSet=u;var I=(function(b){f(I,b);function I(c,d,i,e){var o=b.call(this,c,d)||this;o.targetVersion=c;o.name=d;o.internalName=i;o.fallbackProperty=e;return o;}I.prototype.getInternalName=function(){return this.internalName;};I.prototype.parse=function(c,d,e){var r=undefined;var i=d[this.name];if(i===undefined){return this.defaultValue;}var o=false;if(typeof i==="string"){try{var p=s.SizeAndUnit.parse(i,true);if(p.unit==E.SizeUnit.Pixel){r=p.physicalSize;o=true;}}catch(_a){}if(!o&&this.fallbackProperty){o=this.fallbackProperty.isValidValue(i,e);}}if(!o){e.logParseEvent(c,E.ValidationEvent.InvalidPropertyValue,n.Strings.errors.invalidPropertyValue(i,this.name));}return r;};I.prototype.toJSON=function(c,d,e,i){i.serializeValue(d,this.name,typeof e==="number"&&!isNaN(e)?e+"px":undefined);};return I;}(k.PropertyDefinition));var v=(function(b){f(v,b);function v(){var c=b!==null&&b.apply(this,arguments)||this;c.size=E.Size.Auto;c.style=E.ImageStyle.Default;return c;}v.prototype.populateSchema=function(c){b.prototype.populateSchema.call(this,c);c.remove(C.heightProperty);};v.prototype.applySize=function(e){if(this.pixelWidth||this.pixelHeight){if(this.pixelWidth){e.style.width=this.pixelWidth+"px";}if(this.pixelHeight){e.style.height=this.pixelHeight+"px";}}else{if(this.maxHeight){switch(this.size){case E.Size.Small:e.style.height=this.hostConfig.imageSizes.small+"px";break;case E.Size.Large:e.style.height=this.hostConfig.imageSizes.large+"px";break;default:e.style.height=this.hostConfig.imageSizes.medium+"px";break;}e.style.maxHeight=this.maxHeight+"px";}else{switch(this.size){case E.Size.Stretch:e.style.width="100%";break;case E.Size.Auto:e.style.maxWidth="100%";break;case E.Size.Small:e.style.width=this.hostConfig.imageSizes.small+"px";break;case E.Size.Large:e.style.width=this.hostConfig.imageSizes.large+"px";break;case E.Size.Medium:e.style.width=this.hostConfig.imageSizes.medium+"px";break;}e.style.maxHeight="100%";}}};Object.defineProperty(v.prototype,"useDefaultSizing",{get:function(){return false;},enumerable:false,configurable:true});v.prototype.internalRender=function(){var c=this;var d=undefined;if(this.url){d=document.createElement("div");d.style.display="flex";d.style.alignItems="flex-start";d.onkeypress=function(e){if(c.selectAction&&(e.keyCode==13||e.keyCode==32)){e.preventDefault();e.cancelBubble=true;c.selectAction.execute();}};d.onclick=function(e){if(c.selectAction){e.preventDefault();e.cancelBubble=true;c.selectAction.execute();}};switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:d.style.justifyContent="center";break;case E.HorizontalAlignment.Right:d.style.justifyContent="flex-end";break;default:d.style.justifyContent="flex-start";break;}var i=this.hostConfig;var o=document.createElement("img");o.onload=function(e){j1(c);};o.onerror=function(e){if(c.renderedElement){var r=c.getRootElement();c.renderedElement.innerHTML="";if(r&&r.designMode){var z1=document.createElement("div");z1.style.display="flex";z1.style.alignItems="center";z1.style.justifyContent="center";z1.style.backgroundColor="#EEEEEE";z1.style.color="black";z1.innerText=":-(";z1.style.padding="10px";c.applySize(z1);c.renderedElement.appendChild(z1);}}j1(c);};o.style.minWidth="0";o.classList.add(i.makeCssClassName("ac-image"));if(this.selectAction!==undefined&&i.supportsInteractivity){o.tabIndex=0;o.setAttribute("role",this.selectAction.getAriaRole());if(this.selectAction.title){o.setAttribute("aria-label",this.selectAction.title);o.title=this.selectAction.title;}o.classList.add(i.makeCssClassName("ac-selectable"));}this.applySize(o);if(this.style===E.ImageStyle.Person){o.style.borderRadius="50%";o.style.backgroundPosition="50% 50%";o.style.backgroundRepeat="no-repeat";}o.style.backgroundColor=U.stringToCssColor(this.backgroundColor);o.src=this.preProcessPropertyValue(v.urlProperty);var p=this.preProcessPropertyValue(v.altTextProperty);if(p){o.alt=p;}d.appendChild(o);}return d;};v.prototype.getJsonTypeName=function(){return"Image";};v.prototype.getActionById=function(i){var r=b.prototype.getActionById.call(this,i);if(!r&&this.selectAction){r=this.selectAction.getActionById(i);}return r;};v.prototype.getResourceInformation=function(){return this.url?[{url:this.url,mimeType:"image"}]:[];};v.urlProperty=new k.StringProperty(k.Versions.v1_0,"url");v.altTextProperty=new k.StringProperty(k.Versions.v1_0,"altText");v.backgroundColorProperty=new k.StringProperty(k.Versions.v1_1,"backgroundColor");v.styleProperty=new k.EnumProperty(k.Versions.v1_0,"style",E.ImageStyle,E.ImageStyle.Default);v.sizeProperty=new k.EnumProperty(k.Versions.v1_0,"size",E.Size,E.Size.Auto);v.pixelWidthProperty=new I(k.Versions.v1_1,"width","pixelWidth");v.pixelHeightProperty=new I(k.Versions.v1_1,"height","pixelHeight",C.heightProperty);v.selectActionProperty=new A(k.Versions.v1_1,"selectAction",["Action.ShowCard"]);g([k.property(v.urlProperty)],v.prototype,"url",void 0);g([k.property(v.altTextProperty)],v.prototype,"altText",void 0);g([k.property(v.backgroundColorProperty)],v.prototype,"backgroundColor",void 0);g([k.property(v.sizeProperty)],v.prototype,"size",void 0);g([k.property(v.styleProperty)],v.prototype,"style",void 0);g([k.property(v.pixelWidthProperty)],v.prototype,"pixelWidth",void 0);g([k.property(v.pixelHeightProperty)],v.prototype,"pixelHeight",void 0);g([k.property(v.selectActionProperty)],v.prototype,"selectAction",void 0);return v;}(C));a.Image=v;var w=(function(b){f(w,b);function w(){var c=b!==null&&b.apply(this,arguments)||this;c.allowVerticalOverflow=false;return c;}w.prototype.populateSchema=function(c){b.prototype.populateSchema.call(this,c);if(!this.isSelectable){c.remove(w.selectActionProperty);}};w.prototype.isElementAllowed=function(e){return this.hostConfig.supportsInteractivity||!e.isInteractive;};w.prototype.applyPadding=function(){b.prototype.applyPadding.call(this);if(!this.renderedElement){return;}var p=new s.SpacingDefinition();if(this.getEffectivePadding()){p=this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());}this.renderedElement.style.paddingTop=p.top+"px";this.renderedElement.style.paddingRight=p.right+"px";this.renderedElement.style.paddingBottom=p.bottom+"px";this.renderedElement.style.paddingLeft=p.left+"px";this.renderedElement.style.marginRight="0";this.renderedElement.style.marginLeft="0";};Object.defineProperty(w.prototype,"isSelectable",{get:function(){return false;},enumerable:false,configurable:true});w.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);for(var i=0;i<this.getItemCount();i++){var d=this.getItemAt(i);if(!this.hostConfig.supportsInteractivity&&d.isInteractive){c.addFailure(this,E.ValidationEvent.InteractivityNotAllowed,n.Strings.errors.interactivityNotAllowed());}if(!this.isElementAllowed(d)){c.addFailure(this,E.ValidationEvent.InteractivityNotAllowed,n.Strings.errors.elementTypeNotAllowed(d.getJsonTypeName()));}d.internalValidateProperties(c);}if(this._selectAction){this._selectAction.internalValidateProperties(c);}};w.prototype.render=function(){var c=this;var d=b.prototype.render.call(this);if(d){var i=this.hostConfig;if(this.allowVerticalOverflow){d.style.overflowX="hidden";d.style.overflowY="auto";}if(d&&this.isSelectable&&this._selectAction&&i.supportsInteractivity){d.classList.add(i.makeCssClassName("ac-selectable"));d.tabIndex=0;d.setAttribute("role",this._selectAction.getAriaRole());if(this._selectAction.title){d.setAttribute("aria-label",this._selectAction.title);d.title=this._selectAction.title;}d.onclick=function(e){if(c._selectAction!==undefined){e.preventDefault();e.cancelBubble=true;c._selectAction.execute();}};d.onkeypress=function(e){if(c._selectAction!==undefined&&(e.keyCode==13||e.keyCode==32)){e.preventDefault();e.cancelBubble=true;c._selectAction.execute();}};}}return d;};w.prototype.updateLayout=function(p){if(p===void 0){p=true;}b.prototype.updateLayout.call(this,p);if(p){for(var i=0;i<this.getItemCount();i++){this.getItemAt(i).updateLayout();}}};w.prototype.getAllInputs=function(p){if(p===void 0){p=true;}var r=[];for(var i=0;i<this.getItemCount();i++){r=r.concat(this.getItemAt(i).getAllInputs(p));}return r;};w.prototype.getResourceInformation=function(){var r=[];for(var i=0;i<this.getItemCount();i++){r=r.concat(this.getItemAt(i).getResourceInformation());}return r;};w.prototype.getElementById=function(c){var r=b.prototype.getElementById.call(this,c);if(!r){for(var i=0;i<this.getItemCount();i++){r=this.getItemAt(i).getElementById(c);if(r){break;}}}return r;};w.prototype.findDOMNodeOwner=function(c){var d=undefined;for(var i=0;i<this.getItemCount();i++){d=this.getItemAt(i).findDOMNodeOwner(c);if(d){return d;}}return b.prototype.findDOMNodeOwner.call(this,c);};w.selectActionProperty=new A(k.Versions.v1_1,"selectAction",["Action.ShowCard"]);g([k.property(w.selectActionProperty)],w.prototype,"_selectAction",void 0);return w;}(C));a.CardElementContainer=w;var x=(function(b){f(x,b);function x(){var c=b!==null&&b.apply(this,arguments)||this;c._images=[];c.imageSize=E.ImageSize.Medium;return c;}x.prototype.internalRender=function(){var e=undefined;if(this._images.length>0){e=document.createElement("div");e.style.display="flex";e.style.flexWrap="wrap";for(var c=0,d=this._images;c<d.length;c++){var i=d[c];switch(this.imageSize){case E.ImageSize.Small:i.size=E.Size.Small;break;case E.ImageSize.Large:i.size=E.Size.Large;break;default:i.size=E.Size.Medium;break;}i.maxHeight=this.hostConfig.imageSet.maxImageHeight;var r=i.render();if(r){r.style.display="inline-flex";r.style.margin="0px";r.style.marginRight="10px";U.appendChild(e,r);}}}return e;};x.prototype.getItemCount=function(){return this._images.length;};x.prototype.getItemAt=function(i){return this._images[i];};x.prototype.getFirstVisibleRenderedItem=function(){return this._images&&this._images.length>0?this._images[0]:undefined;};x.prototype.getLastVisibleRenderedItem=function(){return this._images&&this._images.length>0?this._images[this._images.length-1]:undefined;};x.prototype.removeItem=function(i){if(i instanceof v){var c=this._images.indexOf(i);if(c>=0){this._images.splice(c,1);i.setParent(undefined);this.updateLayout();return true;}}return false;};x.prototype.getJsonTypeName=function(){return"ImageSet";};x.prototype.addImage=function(i){if(!i.parent){this._images.push(i);i.setParent(this);}else{throw new Error("This image already belongs to another ImageSet");}};x.prototype.indexOf=function(c){return c instanceof v?this._images.indexOf(c):-1;};x.imagesProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_0,"images",v,function(c,i){i.setParent(c);});x.imageSizeProperty=new k.EnumProperty(k.Versions.v1_0,"imageSize",E.ImageSize,E.ImageSize.Medium);g([k.property(x.imagesProperty)],x.prototype,"_images",void 0);g([k.property(x.imageSizeProperty)],x.prototype,"imageSize",void 0);return x;}(w));a.ImageSet=x;var M=(function(b){f(M,b);function M(c,d){var e=b.call(this)||this;e.url=c;e.mimeType=d;return e;}M.prototype.getSchemaKey=function(){return"MediaSource";};M.prototype.isValid=function(){return this.mimeType&&this.url?true:false;};M.prototype.render=function(){var r=undefined;if(this.isValid()){r=document.createElement("source");r.src=this.url;r.type=this.mimeType;}return r;};M.mimeTypeProperty=new k.StringProperty(k.Versions.v1_1,"mimeType");M.urlProperty=new k.StringProperty(k.Versions.v1_1,"url");g([k.property(M.mimeTypeProperty)],M.prototype,"mimeType",void 0);g([k.property(M.urlProperty)],M.prototype,"url",void 0);return M;}(k.SerializableObject));a.MediaSource=M;var y=(function(b){f(y,b);function y(){var c=b!==null&&b.apply(this,arguments)||this;c.sources=[];return c;}y.prototype.getPosterUrl=function(){return this.poster?this.poster:this.hostConfig.media.defaultPoster;};y.prototype.processSources=function(){this._selectedSources=[];this._selectedMediaType=undefined;for(var c=0,d=this.sources;c<d.length;c++){var e=d[c];var i=e.mimeType?e.mimeType.split('/'):[];if(i.length==2){if(!this._selectedMediaType){var o=y.supportedMediaTypes.indexOf(i[0]);if(o>=0){this._selectedMediaType=y.supportedMediaTypes[o];}}if(i[0]==this._selectedMediaType){this._selectedSources.push(e);}}}};y.prototype.handlePlayButtonInvoke=function(e){if(this.hostConfig.media.allowInlinePlayback){e.preventDefault();e.cancelBubble=true;if(this.renderedElement){var c=this.renderMediaPlayer();this.renderedElement.innerHTML="";this.renderedElement.appendChild(c);c.play();c.focus();}}else{if(y.onPlay){e.preventDefault();e.cancelBubble=true;y.onPlay(this);}}};y.prototype.renderPoster=function(){var c=this;var p=12;var d=15;var i=document.createElement("div");i.className=this.hostConfig.makeCssClassName("ac-media-poster");i.setAttribute("role","contentinfo");i.setAttribute("aria-label",this.altText?this.altText:n.Strings.defaults.mediaPlayerAriaLabel());i.style.position="relative";i.style.display="flex";var o=this.getPosterUrl();if(o){var r=document.createElement("img");r.style.width="100%";r.style.height="100%";r.setAttribute("role","presentation");r.onerror=function(e){if(r.parentNode){r.parentNode.removeChild(r);}i.classList.add("empty");i.style.minHeight="150px";};r.src=o;i.appendChild(r);}else{i.classList.add("empty");i.style.minHeight="150px";}if(this.hostConfig.supportsInteractivity&&this._selectedSources.length>0){var z1=document.createElement("div");z1.tabIndex=0;z1.setAttribute("role","button");z1.setAttribute("aria-label",n.Strings.defaults.mediaPlayerPlayMedia());z1.className=this.hostConfig.makeCssClassName("ac-media-playButton");z1.style.display="flex";z1.style.alignItems="center";z1.style.justifyContent="center";z1.onclick=function(e){c.handlePlayButtonInvoke(e);};z1.onkeypress=function(e){if(e.keyCode==13||e.keyCode==32){c.handlePlayButtonInvoke(e);}};var A1=document.createElement("div");A1.className=this.hostConfig.makeCssClassName("ac-media-playButton-arrow");A1.style.width=p+"px";A1.style.height=d+"px";A1.style.borderTopWidth=(d/2)+"px";A1.style.borderBottomWidth=(d/2)+"px";A1.style.borderLeftWidth=p+"px";A1.style.borderRightWidth="0";A1.style.borderStyle="solid";A1.style.borderTopColor="transparent";A1.style.borderRightColor="transparent";A1.style.borderBottomColor="transparent";A1.style.transform="translate("+(p/10)+"px,0px)";z1.appendChild(A1);var B1=document.createElement("div");B1.style.position="absolute";B1.style.left="0";B1.style.top="0";B1.style.width="100%";B1.style.height="100%";B1.style.display="flex";B1.style.justifyContent="center";B1.style.alignItems="center";B1.appendChild(z1);i.appendChild(B1);}return i;};y.prototype.renderMediaPlayer=function(){var c;if(this._selectedMediaType=="video"){var d=document.createElement("video");var p=this.getPosterUrl();if(p){d.poster=p;}c=d;}else{c=document.createElement("audio");}c.setAttribute("aria-label",this.altText?this.altText:n.Strings.defaults.mediaPlayerAriaLabel());c.setAttribute("webkit-playsinline","");c.setAttribute("playsinline","");c.autoplay=true;c.controls=true;if(U.isMobileOS()){c.muted=true;}c.preload="none";c.style.width="100%";for(var e=0,i=this.sources;e<i.length;e++){var o=i[e];var r=o.render();U.appendChild(c,r);}return c;};y.prototype.internalRender=function(){var e=document.createElement("div");e.className=this.hostConfig.makeCssClassName("ac-media");this.processSources();e.appendChild(this.renderPoster());return e;};y.prototype.getJsonTypeName=function(){return"Media";};y.prototype.getResourceInformation=function(){var r=[];var p=this.getPosterUrl();if(p){r.push({url:p,mimeType:"image"});}for(var c=0,d=this.sources;c<d.length;c++){var e=d[c];if(e.isValid()){r.push({url:e.url,mimeType:e.mimeType});}}return r;};Object.defineProperty(y.prototype,"selectedMediaType",{get:function(){return this._selectedMediaType;},enumerable:false,configurable:true});y.sourcesProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_1,"sources",M);y.posterProperty=new k.StringProperty(k.Versions.v1_1,"poster");y.altTextProperty=new k.StringProperty(k.Versions.v1_1,"altText");y.supportedMediaTypes=["audio","video"];g([k.property(y.sourcesProperty)],y.prototype,"sources",void 0);g([k.property(y.posterProperty)],y.prototype,"poster",void 0);g([k.property(y.altTextProperty)],y.prototype,"altText",void 0);return y;}(C));a.Media=y;var z=(function(b){f(z,b);function z(){return b!==null&&b.apply(this,arguments)||this;}z.prototype.getAllLabelIds=function(){var c=[];if(this._renderedLabelElement){c.push(this._renderedLabelElement.id);}if(this._renderedErrorMessageElement){c.push(this._renderedErrorMessageElement.id);}return c;};z.prototype.updateInputControlAriaLabelledBy=function(){if(this._renderedInputControlElement){var c=this.getAllLabelIds();if(this.labelledBy){c.push(this.labelledBy);}if(this._renderedLabelElement){c.push(this._renderedLabelElement.id);}if(this._renderedErrorMessageElement){c.push(this._renderedErrorMessageElement.id);}if(c.length>0){this._renderedInputControlElement.setAttribute("aria-labelledby",c.join(" "));}else{this._renderedInputControlElement.removeAttribute("aria-labelledby");}}};Object.defineProperty(z.prototype,"isNullable",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(z.prototype,"renderedInputControlElement",{get:function(){return this._renderedInputControlElement;},enumerable:false,configurable:true});Object.defineProperty(z.prototype,"inputControlContainerElement",{get:function(){return this._inputControlContainerElement;},enumerable:false,configurable:true});z.prototype.overrideInternalRender=function(){var c=this.hostConfig;this._outerContainerElement=document.createElement("div");this._outerContainerElement.style.display="flex";this._outerContainerElement.style.flexDirection="column";var r=U.generateUniqueId();if(this.label){var d=new R();d.setParent(this);d.forElementId=r;var e=new t(this.label);d.addInline(e);if(this.isRequired){e.init(c.inputs.label.requiredInputs);var i=new t(c.inputs.label.requiredInputs.suffix);i.color=c.inputs.label.requiredInputs.suffixColor;i.ariaHidden=true;d.addInline(i);}else{e.init(c.inputs.label.optionalInputs);}this._renderedLabelElement=d.render();if(this._renderedLabelElement){this._renderedLabelElement.id=U.generateUniqueId();this._renderedLabelElement.style.marginBottom=c.getEffectiveSpacing(c.inputs.label.inputSpacing)+"px";this._outerContainerElement.appendChild(this._renderedLabelElement);}}this._inputControlContainerElement=document.createElement("div");this._inputControlContainerElement.className=c.makeCssClassName("ac-input-container");this._inputControlContainerElement.style.display="flex";if(this.height==="stretch"){this._inputControlContainerElement.style.alignItems="stretch";this._inputControlContainerElement.style.flex="1 1 auto";}this._renderedInputControlElement=this.internalRender();if(this._renderedInputControlElement){this._renderedInputControlElement.id=r;this._renderedInputControlElement.style.minWidth="0px";if(this.isNullable&&this.isRequired){this._renderedInputControlElement.setAttribute("aria-required","true");this._renderedInputControlElement.classList.add(c.makeCssClassName("ac-input-required"));}this._inputControlContainerElement.appendChild(this._renderedInputControlElement);this._outerContainerElement.appendChild(this._inputControlContainerElement);this.updateInputControlAriaLabelledBy();return this._outerContainerElement;}return undefined;};z.prototype.valueChanged=function(){if(this.isValid()){this.resetValidationFailureCue();}if(this.onValueChanged){this.onValueChanged(this);}n1(this);};z.prototype.resetValidationFailureCue=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.classList.remove(this.hostConfig.makeCssClassName("ac-input-validation-failed"));this.updateInputControlAriaLabelledBy();if(this._renderedErrorMessageElement){this._outerContainerElement.removeChild(this._renderedErrorMessageElement);this._renderedErrorMessageElement=undefined;}}};z.prototype.showValidationErrorMessage=function(){if(this.renderedElement&&this.errorMessage&&s.GlobalSettings.displayInputValidationErrors){var e=new q();e.setParent(this);e.text=this.errorMessage;e.wrap=true;e.init(this.hostConfig.inputs.errorMessage);this._renderedErrorMessageElement=e.render();if(this._renderedErrorMessageElement){this._renderedErrorMessageElement.id=U.generateUniqueId();this._outerContainerElement.appendChild(this._renderedErrorMessageElement);this.updateInputControlAriaLabelledBy();}}};z.prototype.focus=function(){if(this._renderedInputControlElement){this._renderedInputControlElement.focus();}};z.prototype.isValid=function(){return true;};z.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(!this.id){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.inputsMustHaveUniqueId());}if(this.isRequired){if(!this.label){c.addFailure(this,E.ValidationEvent.RequiredInputsShouldHaveLabel,"Required inputs should have a label");}if(!this.errorMessage){c.addFailure(this,E.ValidationEvent.RequiredInputsShouldHaveErrorMessage,"Required inputs should have an error message");}}};z.prototype.validateValue=function(){this.resetValidationFailureCue();var r=this.isRequired?this.isSet()&&this.isValid():this.isValid();if(!r&&this.renderedInputControlElement){this.renderedInputControlElement.classList.add(this.hostConfig.makeCssClassName("ac-input-validation-failed"));this.showValidationErrorMessage();}return r;};z.prototype.getAllInputs=function(p){if(p===void 0){p=true;}return[this];};Object.defineProperty(z.prototype,"isInteractive",{get:function(){return true;},enumerable:false,configurable:true});z.labelProperty=new k.StringProperty(k.Versions.v1_3,"label",true);z.isRequiredProperty=new k.BoolProperty(k.Versions.v1_3,"isRequired",false);z.errorMessageProperty=new k.StringProperty(k.Versions.v1_3,"errorMessage",true);g([k.property(z.labelProperty)],z.prototype,"label",void 0);g([k.property(z.isRequiredProperty)],z.prototype,"isRequired",void 0);g([k.property(z.errorMessageProperty)],z.prototype,"errorMessage",void 0);return z;}(C));a.Input=z;var D=(function(b){f(D,b);function D(){var c=b!==null&&b.apply(this,arguments)||this;c.isMultiline=false;c.style=E.InputTextStyle.Text;return c;}D.prototype.setupInput=function(i){var c=this;i.style.flex="1 1 auto";i.tabIndex=0;if(this.placeholder){i.placeholder=this.placeholder;i.setAttribute("aria-label",this.placeholder);}if(this.defaultValue){i.value=this.defaultValue;}if(this.maxLength&&this.maxLength>0){i.maxLength=this.maxLength;}i.oninput=function(){c.valueChanged();};i.onkeypress=function(e){if(e.ctrlKey&&e.code==="Enter"&&c.inlineAction){c.inlineAction.execute();}};};D.prototype.internalRender=function(){var r;if(this.isMultiline){r=document.createElement("textarea");r.className=this.hostConfig.makeCssClassName("ac-input","ac-textInput","ac-multiline");if(this.height==="stretch"){r.style.height="initial";}}else{r=document.createElement("input");r.className=this.hostConfig.makeCssClassName("ac-input","ac-textInput");r.type=E.InputTextStyle[this.style].toLowerCase();}this.setupInput(r);return r;};D.prototype.overrideInternalRender=function(){var c=this;var r=b.prototype.overrideInternalRender.call(this);if(this.inlineAction){var d=document.createElement("button");d.className=this.hostConfig.makeCssClassName("ac-inlineActionButton");d.onclick=function(e){e.preventDefault();e.cancelBubble=true;if(c.inlineAction){c.inlineAction.execute();}};if(this.inlineAction.iconUrl){d.classList.add("iconOnly");var i=document.createElement("img");i.style.height="100%";i.setAttribute("role","presentation");i.style.display="none";i.onload=function(){i.style.removeProperty("display");};i.onerror=function(){d.removeChild(i);d.classList.remove("iconOnly");d.classList.add("textOnly");d.textContent=c.inlineAction&&c.inlineAction.title?c.inlineAction.title:n.Strings.defaults.inlineActionTitle();};i.src=this.inlineAction.iconUrl;d.appendChild(i);d.title=this.inlineAction.title?this.inlineAction.title:n.Strings.defaults.inlineActionTitle();}else{d.classList.add("textOnly");d.textContent=this.inlineAction.title?this.inlineAction.title:n.Strings.defaults.inlineActionTitle();}d.style.marginLeft="8px";this.inputControlContainerElement.appendChild(d);}return r;};D.prototype.getJsonTypeName=function(){return"Input.Text";};D.prototype.getActionById=function(i){var r=b.prototype.getActionById.call(this,i);if(!r&&this.inlineAction){r=this.inlineAction.getActionById(i);}return r;};D.prototype.isSet=function(){return this.value?true:false;};D.prototype.isValid=function(){if(!this.value){return true;}if(this.regex){return new RegExp(this.regex,"g").test(this.value);}return true;};Object.defineProperty(D.prototype,"value",{get:function(){if(this.renderedInputControlElement){if(this.isMultiline){return this.renderedInputControlElement.value;}else{return this.renderedInputControlElement.value;}}else{return undefined;}},enumerable:false,configurable:true});D.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");D.maxLengthProperty=new k.NumProperty(k.Versions.v1_0,"maxLength");D.isMultilineProperty=new k.BoolProperty(k.Versions.v1_0,"isMultiline",false);D.placeholderProperty=new k.StringProperty(k.Versions.v1_0,"placeholder");D.styleProperty=new k.EnumProperty(k.Versions.v1_0,"style",E.InputTextStyle,E.InputTextStyle.Text);D.inlineActionProperty=new A(k.Versions.v1_0,"inlineAction",["Action.ShowCard"]);D.regexProperty=new k.StringProperty(k.Versions.v1_3,"regex",true);g([k.property(D.valueProperty)],D.prototype,"defaultValue",void 0);g([k.property(D.maxLengthProperty)],D.prototype,"maxLength",void 0);g([k.property(D.isMultilineProperty)],D.prototype,"isMultiline",void 0);g([k.property(D.placeholderProperty)],D.prototype,"placeholder",void 0);g([k.property(D.styleProperty)],D.prototype,"style",void 0);g([k.property(D.inlineActionProperty)],D.prototype,"inlineAction",void 0);g([k.property(D.regexProperty)],D.prototype,"regex",void 0);return D;}(z));a.TextInput=D;var G=(function(b){f(G,b);function G(){var c=b!==null&&b.apply(this,arguments)||this;c.valueOn="true";c.valueOff="false";c.wrap=false;return c;}G.prototype.updateInputControlAriaLabelledBy=function(){if(this._checkboxInputElement){var c=this.getAllLabelIds().join(" ");if(this._checkboxInputLabelElement&&this._checkboxInputLabelElement.id){c+=" "+this._checkboxInputLabelElement.id;}if(c){this._checkboxInputElement.setAttribute("aria-labelledby",c);}else{this._checkboxInputElement.removeAttribute("aria-labelledby");}}};G.prototype.internalRender=function(){var c=this;var e=document.createElement("div");e.className=this.hostConfig.makeCssClassName("ac-input","ac-toggleInput");e.style.width="100%";e.style.display="flex";e.style.alignItems="center";this._checkboxInputElement=document.createElement("input");this._checkboxInputElement.id=U.generateUniqueId();this._checkboxInputElement.type="checkbox";this._checkboxInputElement.style.display="inline-block";this._checkboxInputElement.style.verticalAlign="middle";this._checkboxInputElement.style.margin="0";this._checkboxInputElement.style.flex="0 0 auto";if(this.title){this._checkboxInputElement.setAttribute("aria-label",this.title);}if(this.isRequired){this._checkboxInputElement.setAttribute("aria-required","true");}this._checkboxInputElement.tabIndex=0;if(this.defaultValue==this.valueOn){this._checkboxInputElement.checked=true;}this._checkboxInputElement.onchange=function(){c.valueChanged();};U.appendChild(e,this._checkboxInputElement);if(this.title||this.isDesignMode()){var d=new q();d.setParent(this);d.forElementId=this._checkboxInputElement.id;d.hostConfig=this.hostConfig;d.text=!this.title?this.getJsonTypeName():this.title;d.useMarkdown=s.GlobalSettings.useMarkdownInRadioButtonAndCheckbox;d.wrap=this.wrap;this._checkboxInputLabelElement=d.render();if(this._checkboxInputLabelElement){this._checkboxInputLabelElement.id=U.generateUniqueId();this._checkboxInputLabelElement.style.display="inline-block";this._checkboxInputLabelElement.style.flex="1 1 auto";this._checkboxInputLabelElement.style.marginLeft="6px";this._checkboxInputLabelElement.style.verticalAlign="middle";var i=document.createElement("div");i.style.width="6px";U.appendChild(e,i);U.appendChild(e,this._checkboxInputLabelElement);}}return e;};Object.defineProperty(G.prototype,"isNullable",{get:function(){return false;},enumerable:false,configurable:true});G.prototype.getJsonTypeName=function(){return"Input.Toggle";};G.prototype.focus=function(){if(this._checkboxInputElement){this._checkboxInputElement.focus();}};G.prototype.isSet=function(){if(this.isRequired){return this.value===this.valueOn;}return this.value?true:false;};Object.defineProperty(G.prototype,"value",{get:function(){if(this._checkboxInputElement){return this._checkboxInputElement.checked?this.valueOn:this.valueOff;}else{return undefined;}},enumerable:false,configurable:true});G.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");G.titleProperty=new k.StringProperty(k.Versions.v1_0,"title");G.valueOnProperty=new k.StringProperty(k.Versions.v1_0,"valueOn",true,undefined,"true",function(c){return"true";});G.valueOffProperty=new k.StringProperty(k.Versions.v1_0,"valueOff",true,undefined,"false",function(c){return"false";});G.wrapProperty=new k.BoolProperty(k.Versions.v1_2,"wrap",false);g([k.property(G.valueProperty)],G.prototype,"defaultValue",void 0);g([k.property(G.titleProperty)],G.prototype,"title",void 0);g([k.property(G.valueOnProperty)],G.prototype,"valueOn",void 0);g([k.property(G.valueOffProperty)],G.prototype,"valueOff",void 0);g([k.property(G.wrapProperty)],G.prototype,"wrap",void 0);return G;}(z));a.ToggleInput=G;var H=(function(b){f(H,b);function H(c,d){var e=b.call(this)||this;e.title=c;e.value=d;return e;}H.prototype.getSchemaKey=function(){return"Choice";};H.titleProperty=new k.StringProperty(k.Versions.v1_0,"title");H.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");g([k.property(H.titleProperty)],H.prototype,"title",void 0);g([k.property(H.valueProperty)],H.prototype,"value",void 0);return H;}(k.SerializableObject));a.Choice=H;var J=(function(b){f(J,b);function J(){var c=b!==null&&b.apply(this,arguments)||this;c.isMultiSelect=false;c.wrap=false;c.choices=[];return c;}Object.defineProperty(J.prototype,"isCompact",{get:function(){return this.style!=="expanded";},set:function(c){this.style=c?undefined:"expanded";},enumerable:false,configurable:true});J.getUniqueCategoryName=function(){var c="__ac-category"+J.uniqueCategoryCounter;J.uniqueCategoryCounter++;return c;};J.prototype.internalApplyAriaCurrent=function(){var o=this._selectElement.options;if(o){for(var i=0;i<o.length;i++){if(o[i].selected){o[i].setAttribute("aria-current","true");}else{o[i].removeAttribute("aria-current");}}}};J.prototype.renderCompoundInput=function(c,d,e){var i=this;var o=document.createElement("div");o.className=this.hostConfig.makeCssClassName("ac-input",c);o.style.width="100%";this._toggleInputs=[];this._labels=[];for(var p=0,r=this.choices;p<r.length;p++){var z1=r[p];var A1=document.createElement("input");A1.id=U.generateUniqueId();A1.type=d;A1.style.margin="0";A1.style.display="inline-block";A1.style.verticalAlign="middle";A1.style.flex="0 0 auto";A1.name=this.id?this.id:this._uniqueCategoryName;if(this.isRequired){A1.setAttribute("aria-required","true");}if(z1.value){A1.value=z1.value;}if(z1.title){A1.setAttribute("aria-label",z1.title);}if(e&&z1.value){if(e.indexOf(z1.value)>=0){A1.checked=true;}}A1.onchange=function(){i.valueChanged();};this._toggleInputs.push(A1);var B1=document.createElement("div");B1.style.display="flex";B1.style.alignItems="center";U.appendChild(B1,A1);var C1=new q();C1.setParent(this);C1.forElementId=A1.id;C1.hostConfig=this.hostConfig;C1.text=z1.title?z1.title:"Choice "+this._toggleInputs.length;C1.useMarkdown=s.GlobalSettings.useMarkdownInRadioButtonAndCheckbox;C1.wrap=this.wrap;var D1=C1.render();this._labels.push(D1);if(D1){D1.id=U.generateUniqueId();D1.style.display="inline-block";D1.style.flex="1 1 auto";D1.style.marginLeft="6px";D1.style.verticalAlign="middle";var E1=document.createElement("div");E1.style.width="6px";U.appendChild(B1,E1);U.appendChild(B1,D1);}U.appendChild(o,B1);}return o;};J.prototype.updateInputControlAriaLabelledBy=function(){if((this.isMultiSelect||this.style==="expanded")&&this._toggleInputs&&this._labels){var c=this.getAllLabelIds();for(var i=0;i<this._toggleInputs.length;i++){var d=c.join(" ");var e=this._labels[i];if(e&&e.id){d+=" "+e.id;}if(d){this._toggleInputs[i].setAttribute("aria-labelledby",d);}else{this._toggleInputs[i].removeAttribute("aria-labelledby");}}}else{b.prototype.updateInputControlAriaLabelledBy.call(this);}};J.prototype.internalRender=function(){var c=this;this._uniqueCategoryName=J.getUniqueCategoryName();if(this.isMultiSelect){return this.renderCompoundInput("ac-choiceSetInput-multiSelect","checkbox",this.defaultValue?this.defaultValue.split(this.hostConfig.choiceSetInputValueSeparator):undefined);}else{if(this.style==="expanded"){return this.renderCompoundInput("ac-choiceSetInput-expanded","radio",this.defaultValue?[this.defaultValue]:undefined);}else{this._selectElement=document.createElement("select");this._selectElement.className=this.hostConfig.makeCssClassName("ac-input","ac-multichoiceInput","ac-choiceSetInput-compact");this._selectElement.style.width="100%";var o=document.createElement("option");o.selected=true;o.disabled=true;o.hidden=true;o.value="";if(this.placeholder){o.text=this.placeholder;}U.appendChild(this._selectElement,o);for(var d=0,e=this.choices;d<e.length;d++){var i=e[d];var p=document.createElement("option");p.value=i.value;p.text=i.title;p.setAttribute("aria-label",i.title);if(i.value==this.defaultValue){p.selected=true;}U.appendChild(this._selectElement,p);}this._selectElement.onchange=function(){c.internalApplyAriaCurrent();c.valueChanged();};this.internalApplyAriaCurrent();return this._selectElement;}}};J.prototype.getJsonTypeName=function(){return"Input.ChoiceSet";};J.prototype.focus=function(){if(this._toggleInputs&&(this.isMultiSelect||this.style==="expanded")){if(this._toggleInputs.length>0){this._toggleInputs[0].focus();}}else{b.prototype.focus.call(this);}};J.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(this.choices.length==0){c.addFailure(this,E.ValidationEvent.CollectionCantBeEmpty,n.Strings.errors.choiceSetMustHaveAtLeastOneChoice());}for(var d=0,e=this.choices;d<e.length;d++){var i=e[d];if(!i.title||!i.value){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.choiceSetChoicesMustHaveTitleAndValue());}}};J.prototype.isSet=function(){return this.value?true:false;};Object.defineProperty(J.prototype,"value",{get:function(){if(!this.isMultiSelect){if(this.isCompact){if(this._selectElement){return this._selectElement.selectedIndex>0?this._selectElement.value:undefined;}return undefined;}else{if(!this._toggleInputs||this._toggleInputs.length==0){return undefined;}for(var c=0,d=this._toggleInputs;c<d.length;c++){var e=d[c];if(e.checked){return e.value;}}return undefined;}}else{if(!this._toggleInputs||this._toggleInputs.length==0){return undefined;}var r="";for(var i=0,o=this._toggleInputs;i<o.length;i++){var e=o[i];if(e.checked){if(r!=""){r+=this.hostConfig.choiceSetInputValueSeparator;}r+=e.value;}}return r?r:undefined;}},enumerable:false,configurable:true});J.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");J.choicesProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_0,"choices",H);J.styleProperty=new k.ValueSetProperty(k.Versions.v1_0,"style",[{value:"compact"},{value:"expanded"}],"compact");J.isMultiSelectProperty=new k.BoolProperty(k.Versions.v1_0,"isMultiSelect",false);J.placeholderProperty=new k.StringProperty(k.Versions.v1_0,"placeholder");J.wrapProperty=new k.BoolProperty(k.Versions.v1_2,"wrap",false);J.uniqueCategoryCounter=0;g([k.property(J.valueProperty)],J.prototype,"defaultValue",void 0);g([k.property(J.styleProperty)],J.prototype,"style",void 0);g([k.property(J.isMultiSelectProperty)],J.prototype,"isMultiSelect",void 0);g([k.property(J.placeholderProperty)],J.prototype,"placeholder",void 0);g([k.property(J.wrapProperty)],J.prototype,"wrap",void 0);g([k.property(J.choicesProperty)],J.prototype,"choices",void 0);return J;}(z));a.ChoiceSetInput=J;var N=(function(b){f(N,b);function N(){return b!==null&&b.apply(this,arguments)||this;}N.prototype.internalRender=function(){var c=this;this._numberInputElement=document.createElement("input");this._numberInputElement.setAttribute("type","number");if(this.min!==undefined){this._numberInputElement.setAttribute("min",this.min.toString());}if(this.max!==undefined){this._numberInputElement.setAttribute("max",this.max.toString());}this._numberInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-numberInput");this._numberInputElement.style.width="100%";this._numberInputElement.tabIndex=0;if(this.defaultValue!==undefined){this._numberInputElement.valueAsNumber=this.defaultValue;}if(this.placeholder){this._numberInputElement.placeholder=this.placeholder;this._numberInputElement.setAttribute("aria-label",this.placeholder);}this._numberInputElement.oninput=function(){c.valueChanged();};return this._numberInputElement;};N.prototype.getJsonTypeName=function(){return"Input.Number";};N.prototype.isSet=function(){return this.value!==undefined&&!isNaN(this.value);};N.prototype.isValid=function(){if(this.value===undefined){return!this.isRequired;}var r=true;if(this.min!==undefined){r=r&&(this.value>=this.min);}if(this.max!==undefined){r=r&&(this.value<=this.max);}return r;};Object.defineProperty(N.prototype,"value",{get:function(){return this._numberInputElement?this._numberInputElement.valueAsNumber:undefined;},enumerable:false,configurable:true});N.valueProperty=new k.NumProperty(k.Versions.v1_0,"value");N.placeholderProperty=new k.StringProperty(k.Versions.v1_0,"placeholder");N.minProperty=new k.NumProperty(k.Versions.v1_0,"min");N.maxProperty=new k.NumProperty(k.Versions.v1_0,"max");g([k.property(N.valueProperty)],N.prototype,"defaultValue",void 0);g([k.property(N.minProperty)],N.prototype,"min",void 0);g([k.property(N.maxProperty)],N.prototype,"max",void 0);g([k.property(N.placeholderProperty)],N.prototype,"placeholder",void 0);return N;}(z));a.NumberInput=N;var K=(function(b){f(K,b);function K(){return b!==null&&b.apply(this,arguments)||this;}K.prototype.internalRender=function(){var c=this;this._dateInputElement=document.createElement("input");this._dateInputElement.setAttribute("type","date");if(this.min){this._dateInputElement.setAttribute("min",this.min);}if(this.max){this._dateInputElement.setAttribute("max",this.max);}if(this.placeholder){this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.setAttribute("aria-label",this.placeholder);}this._dateInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-dateInput");this._dateInputElement.style.width="100%";this._dateInputElement.oninput=function(){c.valueChanged();};if(this.defaultValue){this._dateInputElement.value=this.defaultValue;}return this._dateInputElement;};K.prototype.getJsonTypeName=function(){return"Input.Date";};K.prototype.isSet=function(){return this.value?true:false;};K.prototype.isValid=function(){if(!this.value){return!this.isRequired;}var c=new Date(this.value);var r=true;if(this.min){var d=new Date(this.min);r=r&&(c>=d);}if(this.max){var e=new Date(this.max);r=r&&(c<=e);}return r;};Object.defineProperty(K.prototype,"value",{get:function(){return this._dateInputElement?this._dateInputElement.value:undefined;},enumerable:false,configurable:true});K.valueProperty=new k.StringProperty(k.Versions.v1_0,"value");K.placeholderProperty=new k.StringProperty(k.Versions.v1_0,"placeholder");K.minProperty=new k.StringProperty(k.Versions.v1_0,"min");K.maxProperty=new k.StringProperty(k.Versions.v1_0,"max");g([k.property(K.valueProperty)],K.prototype,"defaultValue",void 0);g([k.property(K.minProperty)],K.prototype,"min",void 0);g([k.property(K.maxProperty)],K.prototype,"max",void 0);g([k.property(K.placeholderProperty)],K.prototype,"placeholder",void 0);return K;}(z));a.DateInput=K;var L=(function(b){f(L,b);function L(c,d){var e=b.call(this,c,d,function(i,p,o,r){var z1=o[p.name];if(typeof z1==="string"&&z1&&/^[0-9]{2}:[0-9]{2}$/.test(z1)){return z1;}return undefined;},function(i,p,o,r,z1){z1.serializeValue(o,p.name,r);})||this;e.targetVersion=c;e.name=d;return e;}return L;}(k.CustomProperty));a.TimeProperty=L;var O=(function(b){f(O,b);function O(){return b!==null&&b.apply(this,arguments)||this;}O.convertTimeStringToDate=function(c){return new Date("1973-09-04T"+c+":00Z");};O.prototype.internalRender=function(){var c=this;this._timeInputElement=document.createElement("input");this._timeInputElement.setAttribute("type","time");this._timeInputElement.setAttribute("min",this.min);this._timeInputElement.setAttribute("max",this.max);this._timeInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-timeInput");this._timeInputElement.style.width="100%";this._timeInputElement.oninput=function(){c.valueChanged();};if(this.placeholder){this._timeInputElement.placeholder=this.placeholder;this._timeInputElement.setAttribute("aria-label",this.placeholder);}if(this.defaultValue){this._timeInputElement.value=this.defaultValue;}return this._timeInputElement;};O.prototype.getJsonTypeName=function(){return"Input.Time";};O.prototype.isSet=function(){return this.value?true:false;};O.prototype.isValid=function(){if(!this.value){return!this.isRequired;}var c=O.convertTimeStringToDate(this.value);var r=true;if(this.min){var d=O.convertTimeStringToDate(this.min);r=r&&(c>=d);}if(this.max){var e=O.convertTimeStringToDate(this.max);r=r&&(c<=e);}return r;};Object.defineProperty(O.prototype,"value",{get:function(){return this._timeInputElement?this._timeInputElement.value:undefined;},enumerable:false,configurable:true});O.valueProperty=new L(k.Versions.v1_0,"value");O.placeholderProperty=new k.StringProperty(k.Versions.v1_0,"placeholder");O.minProperty=new L(k.Versions.v1_0,"min");O.maxProperty=new L(k.Versions.v1_0,"max");g([k.property(O.valueProperty)],O.prototype,"defaultValue",void 0);g([k.property(O.minProperty)],O.prototype,"min",void 0);g([k.property(O.maxProperty)],O.prototype,"max",void 0);g([k.property(O.placeholderProperty)],O.prototype,"placeholder",void 0);return O;}(z));a.TimeInput=O;var P=(function(){function P(b,p){this._state=0;this.action=b;this._parentContainerStyle=p;}P.prototype.updateCssStyle=function(){var b,c;if(this.action.parent&&this.action.renderedElement){var d=this.action.parent.hostConfig;this.action.renderedElement.className=d.makeCssClassName("ac-pushButton");if(this._parentContainerStyle){this.action.renderedElement.classList.add("style-"+this._parentContainerStyle);}this.action.updateActionButtonCssStyle(this.action.renderedElement,this._state);this.action.renderedElement.classList.remove(d.makeCssClassName("expanded"));this.action.renderedElement.classList.remove(d.makeCssClassName("subdued"));switch(this._state){case 1:this.action.renderedElement.classList.add(d.makeCssClassName("expanded"));break;case 2:this.action.renderedElement.classList.add(d.makeCssClassName("subdued"));break;}if(this.action.style){if(this.action.style===E.ActionStyle.Positive){(b=this.action.renderedElement.classList).add.apply(b,d.makeCssClassNames("primary","style-positive"));}else{(c=this.action.renderedElement.classList).add.apply(c,d.makeCssClassNames("style-"+this.action.style.toLowerCase()));}}}};P.prototype.render=function(){var b=this;this.action.render();if(this.action.renderedElement){this.action.renderedElement.onclick=function(e){e.preventDefault();e.cancelBubble=true;b.click();};this.updateCssStyle();}};P.prototype.click=function(){if(this.onClick!==undefined){this.onClick(this);}};Object.defineProperty(P.prototype,"state",{get:function(){return this._state;},set:function(b){this._state=b;this.updateCssStyle();},enumerable:false,configurable:true});return P;}());var Q=(function(b){f(Q,b);function Q(){var c=b!==null&&b.apply(this,arguments)||this;c.style=E.ActionStyle.Default;return c;}Q.prototype.getDefaultSerializationContext=function(){return new y1();};Q.prototype.addCssClasses=function(e){};Q.prototype.internalGetReferencedInputs=function(){return{};};Q.prototype.internalPrepareForExecution=function(i){};Q.prototype.internalValidateInputs=function(r){var c=[];if(r){for(var d=0,e=Object.keys(r);d<e.length;d++){var i=e[d];var o=r[i];if(!o.validateValue()){c.push(o);}}}return c;};Q.prototype.shouldSerialize=function(c){return c.actionRegistry.findByName(this.getJsonTypeName())!==undefined;};Q.prototype.raiseExecuteActionEvent=function(){if(this.onExecute){this.onExecute(this);}l1(this);};Q.prototype.getHref=function(){return"";};Q.prototype.getAriaRole=function(){return"button";};Q.prototype.updateActionButtonCssStyle=function(c,d){if(d===void 0){d=0;}};Q.prototype.parse=function(c,d){return b.prototype.parse.call(this,c,d?d:new y1());};Q.prototype.render=function(c){if(c===void 0){c="ac-pushButton";}var d=this.hostConfig;var e=document.createElement("button");this.addCssClasses(e);if(this.accessibleTitle){e.setAttribute("aria-label",this.accessibleTitle);}else if(this.title){e.setAttribute("aria-label",this.title);}if(this.expanded!=undefined){e.setAttribute("aria-expanded",this.expanded.toString());}e.type="button";e.style.display="flex";e.style.alignItems="center";e.style.justifyContent="center";e.setAttribute("role",this.getAriaRole());var i=document.createElement("div");i.style.overflow="hidden";i.style.textOverflow="ellipsis";if(!(d.actions.iconPlacement==E.ActionIconPlacement.AboveTitle||d.actions.allowTitleToWrap)){i.style.whiteSpace="nowrap";}if(this.title){i.innerText=this.title;}if(!this.iconUrl){e.classList.add("noIcon");e.appendChild(i);}else{var o=document.createElement("img");o.src=this.iconUrl;o.style.width=d.actions.iconSize+"px";o.style.height=d.actions.iconSize+"px";o.style.flex="0 0 auto";if(d.actions.iconPlacement==E.ActionIconPlacement.AboveTitle){e.classList.add("iconAbove");e.style.flexDirection="column";if(this.title){o.style.marginBottom="6px";}}else{e.classList.add("iconLeft");o.style.maxHeight="100%";if(this.title){o.style.marginRight="6px";}}e.appendChild(o);e.appendChild(i);}this._renderedElement=e;};Q.prototype.execute=function(){if(this._actionCollection){this._actionCollection.actionExecuted(this);}this.raiseExecuteActionEvent();};Q.prototype.prepareForExecution=function(){var r=this.getReferencedInputs();var i=this.internalValidateInputs(r);if(i.length>0){i[0].focus();return false;}this.internalPrepareForExecution(r);return true;};;Q.prototype.remove=function(){if(this._actionCollection){return this._actionCollection.removeAction(this);}return false;};Q.prototype.getAllInputs=function(p){if(p===void 0){p=true;}return[];};Q.prototype.getResourceInformation=function(){return this.iconUrl?[{url:this.iconUrl,mimeType:"image"}]:[];};Q.prototype.getActionById=function(i){return this.id===i?this:undefined;};Q.prototype.getReferencedInputs=function(){return this.internalGetReferencedInputs();};Q.prototype.validateInputs=function(){return this.internalValidateInputs(this.getReferencedInputs());};Object.defineProperty(Q.prototype,"isPrimary",{get:function(){return this.style==E.ActionStyle.Positive;},set:function(c){if(c){this.style=E.ActionStyle.Positive;}else{if(this.style==E.ActionStyle.Positive){this.style=E.ActionStyle.Default;}}},enumerable:false,configurable:true});Object.defineProperty(Q.prototype,"hostConfig",{get:function(){return this.parent?this.parent.hostConfig:h.defaultHostConfig;},enumerable:false,configurable:true});Object.defineProperty(Q.prototype,"parent",{get:function(){return this._parent;},enumerable:false,configurable:true});Q.titleProperty=new k.StringProperty(k.Versions.v1_0,"title");Q.iconUrlProperty=new k.StringProperty(k.Versions.v1_1,"iconUrl");Q.styleProperty=new k.ValueSetProperty(k.Versions.v1_2,"style",[{value:E.ActionStyle.Default},{value:E.ActionStyle.Positive},{value:E.ActionStyle.Destructive}],E.ActionStyle.Default);g([k.property(Q.titleProperty)],Q.prototype,"title",void 0);g([k.property(Q.iconUrlProperty)],Q.prototype,"iconUrl",void 0);g([k.property(Q.styleProperty)],Q.prototype,"style",void 0);return Q;}(j.CardObject));a.Action=Q;var S=(function(b){f(S,b);function S(){var c=b!==null&&b.apply(this,arguments)||this;c._isPrepared=false;return c;}S.prototype.internalGetReferencedInputs=function(){var r={};if(this.associatedInputs!=="none"){var c=this.parent;var i=[];while(c){i=i.concat(c.getAllInputs(false));c=c.parent;}for(var d=0,e=i;d<e.length;d++){var o=e[d];if(o.id){r[o.id]=o;}}}return r;};S.prototype.internalPrepareForExecution=function(i){if(this._originalData){this._processedData=JSON.parse(JSON.stringify(this._originalData));}else{this._processedData={};}if(this._processedData&&i){for(var c=0,d=Object.keys(i);c<d.length;c++){var e=d[c];var o=i[e];if(o.id&&o.isSet()){this._processedData[o.id]=typeof o.value==="string"?o.value:o.value.toString();}}}this._isPrepared=true;};Object.defineProperty(S.prototype,"data",{get:function(){return this._isPrepared?this._processedData:this._originalData;},set:function(c){this._originalData=c;this._isPrepared=false;},enumerable:false,configurable:true});S.dataProperty=new k.PropertyDefinition(k.Versions.v1_0,"data");S.associatedInputsProperty=new k.CustomProperty(k.Versions.v1_3,"associatedInputs",function(c,p,d,e){var i=d[p.name];if(i!==undefined&&typeof i==="string"){return i.toLowerCase()==="none"?"none":"auto";}return undefined;},function(c,p,d,e,i){i.serializeValue(d,p.name,e);});g([k.property(S.dataProperty)],S.prototype,"_originalData",void 0);g([k.property(S.associatedInputsProperty)],S.prototype,"associatedInputs",void 0);return S;}(Q));a.SubmitActionBase=S;var V=(function(b){f(V,b);function V(){return b!==null&&b.apply(this,arguments)||this;}V.prototype.getJsonTypeName=function(){return V.JsonTypeName;};V.JsonTypeName="Action.Submit";return V;}(S));a.SubmitAction=V;var W=(function(b){f(W,b);function W(){return b!==null&&b.apply(this,arguments)||this;}W.prototype.getJsonTypeName=function(){return W.JsonTypeName;};W.JsonTypeName="Action.Execute";W.verbProperty=new k.StringProperty(k.Versions.v1_4,"verb");g([k.property(W.verbProperty)],W.prototype,"verb",void 0);return W;}(S));a.ExecuteAction=W;var X=(function(b){f(X,b);function X(){return b!==null&&b.apply(this,arguments)||this;}X.prototype.getJsonTypeName=function(){return X.JsonTypeName;};X.prototype.getAriaRole=function(){return"link";};X.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(!this.url){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.propertyMustBeSet("url"));}};X.prototype.getHref=function(){return this.url;};X.urlProperty=new k.StringProperty(k.Versions.v1_0,"url");X.JsonTypeName="Action.OpenUrl";g([k.property(X.urlProperty)],X.prototype,"url",void 0);return X;}(Q));a.OpenUrlAction=X;var Y=(function(b){f(Y,b);function Y(){var c=b!==null&&b.apply(this,arguments)||this;c.targetElements={};return c;}Y.prototype.updateAriaControlsAttribute=function(){if(this.targetElements){var e=Object.keys(this.targetElements);if(this._renderedElement){if(e.length>0){this._renderedElement.setAttribute("aria-controls",e.join(" "));}else{this._renderedElement.removeAttribute("aria-controls");}}}};Y.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(!this.targetElements){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.propertyMustBeSet("targetElements"));}};Y.prototype.getJsonTypeName=function(){return Y.JsonTypeName;};Y.prototype.render=function(c){if(c===void 0){c="ac-pushButton";}b.prototype.render.call(this,c);this.updateAriaControlsAttribute();};Y.prototype.execute=function(){if(this.parent){for(var c=0,d=Object.keys(this.targetElements);c<d.length;c++){var e=d[c];var i=this.parent.getRootElement().getElementById(e);if(i){if(typeof this.targetElements[e]==="boolean"){i.isVisible=this.targetElements[e];}else{i.isVisible=!i.isVisible;}}}}};Y.prototype.addTargetElement=function(e,i){if(i===void 0){i=undefined;}this.targetElements[e]=i;this.updateAriaControlsAttribute();};Y.prototype.removeTargetElement=function(e){delete this.targetElements[e];this.updateAriaControlsAttribute();};Y.targetElementsProperty=new k.CustomProperty(k.Versions.v1_2,"targetElements",function(c,p,d,e){var r={};if(Array.isArray(d[p.name])){for(var i=0,o=d[p.name];i<o.length;i++){var z1=o[i];if(typeof z1==="string"){r[z1]=undefined;}else if(typeof z1==="object"){var A1=z1["elementId"];if(typeof A1==="string"){r[A1]=U.parseBool(z1["isVisible"]);}}}}return r;},function(c,p,d,e,i){var o=[];for(var r=0,_a=Object.keys(e);r<_a.length;r++){var id=_a[r];if(typeof e[id]==="boolean"){o.push({elementId:id,isVisible:e[id]});}else{o.push(id);}}i.serializeArray(d,p.name,o);},{},function(c){return{};});Y.JsonTypeName="Action.ToggleVisibility";g([k.property(Y.targetElementsProperty)],Y.prototype,"targetElements",void 0);return Y;}(Q));a.ToggleVisibilityAction=Y;var Z=(function(b){f(Z,b);function Z(c,d){var e=b.call(this,c,d,undefined,function(){return new s.StringWithSubstitutions();})||this;e.targetVersion=c;e.name=d;return e;}Z.prototype.parse=function(c,d,e){var r=new s.StringWithSubstitutions();r.set(U.parseString(d[this.name]));return r;};Z.prototype.toJSON=function(c,d,e,i){i.serializeValue(d,this.name,e.getOriginal());};return Z;}(k.PropertyDefinition));var $=(function(b){f($,b);function $(c,d){if(c===void 0){c="";}if(d===void 0){d="";}var e=b.call(this)||this;e.name=c;e.value=d;return e;}$.prototype.getSchemaKey=function(){return"HttpHeader";};$.prototype.getReferencedInputs=function(i,r){this._value.getReferencedInputs(i,r);};$.prototype.prepareForExecution=function(i){this._value.substituteInputValues(i,s.ContentTypes.applicationXWwwFormUrlencoded);};Object.defineProperty($.prototype,"value",{get:function(){return this._value.get();},set:function(c){this._value.set(c);},enumerable:false,configurable:true});$.nameProperty=new k.StringProperty(k.Versions.v1_0,"name");$.valueProperty=new Z(k.Versions.v1_0,"value");g([k.property($.nameProperty)],$.prototype,"name",void 0);g([k.property($.valueProperty)],$.prototype,"_value",void 0);return $;}(k.SerializableObject));a.HttpHeader=$;var a1=(function(b){f(a1,b);function a1(){var c=b!==null&&b.apply(this,arguments)||this;c._ignoreInputValidation=false;return c;}a1.prototype.internalGetReferencedInputs=function(){var c=this.parent?this.parent.getRootElement().getAllInputs():[];var r={};this._url.getReferencedInputs(c,r);for(var d=0,e=this.headers;d<e.length;d++){var i=e[d];i.getReferencedInputs(c,r);}this._body.getReferencedInputs(c,r);return r;};a1.prototype.internalPrepareForExecution=function(i){if(i){this._url.substituteInputValues(i,s.ContentTypes.applicationXWwwFormUrlencoded);var c=s.ContentTypes.applicationJson;for(var d=0,e=this.headers;d<e.length;d++){var o=e[d];o.prepareForExecution(i);if(o.name&&o.name.toLowerCase()=="content-type"){c=o.value;}}this._body.substituteInputValues(i,c);}};;a1.prototype.getJsonTypeName=function(){return a1.JsonTypeName;};a1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(!this.url){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.propertyMustBeSet("url"));}if(this.headers.length>0){for(var d=0,e=this.headers;d<e.length;d++){var i=e[d];if(!i.name){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.actionHttpHeadersMustHaveNameAndValue());}}}};Object.defineProperty(a1.prototype,"ignoreInputValidation",{get:function(){return this._ignoreInputValidation;},set:function(c){this._ignoreInputValidation=c;},enumerable:false,configurable:true});Object.defineProperty(a1.prototype,"url",{get:function(){return this._url.get();},set:function(c){this._url.set(c);},enumerable:false,configurable:true});Object.defineProperty(a1.prototype,"body",{get:function(){return this._body.get();},set:function(c){this._body.set(c);},enumerable:false,configurable:true});a1.urlProperty=new Z(k.Versions.v1_0,"url");a1.bodyProperty=new Z(k.Versions.v1_0,"body");a1.methodProperty=new k.StringProperty(k.Versions.v1_0,"method");a1.headersProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_0,"headers",$);a1.ignoreInputValidationProperty=new k.BoolProperty(k.Versions.v1_3,"ignoreInputValidation",false);a1.JsonTypeName="Action.Http";g([k.property(a1.urlProperty)],a1.prototype,"_url",void 0);g([k.property(a1.bodyProperty)],a1.prototype,"_body",void 0);g([k.property(a1.methodProperty)],a1.prototype,"method",void 0);g([k.property(a1.headersProperty)],a1.prototype,"headers",void 0);g([k.property(a1.ignoreInputValidationProperty)],a1.prototype,"_ignoreInputValidation",void 0);return a1;}(Q));a.HttpAction=a1;var b1=(function(b){f(b1,b);function b1(){var c=b!==null&&b.apply(this,arguments)||this;c.card=new w1();return c;}b1.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);var e=c["card"];if(e){this.card.parse(e,d);}else{d.logParseEvent(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.showCardMustHaveCard());}};b1.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);if(this.card){d.serializeValue(c,"card",this.card.toJSON(d));}};b1.prototype.addCssClasses=function(e){b.prototype.addCssClasses.call(this,e);if(this.parent){e.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));}};b1.prototype.raiseExecuteActionEvent=function(){if(this.hostConfig.actions.showCard.actionMode===E.ShowCardActionMode.Popup){b.prototype.raiseExecuteActionEvent.call(this);}};b1.prototype.getJsonTypeName=function(){return b1.JsonTypeName;};b1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);this.card.internalValidateProperties(c);};b1.prototype.updateActionButtonCssStyle=function(c,d){if(d===void 0){d=0;}b.prototype.updateActionButtonCssStyle.call(this,c);if(this.parent){c.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));c.setAttribute("aria-expanded",(d===1).toString());}};b1.prototype.setParent=function(c){b.prototype.setParent.call(this,c);this.card.setParent(c);};b1.prototype.getAllInputs=function(p){if(p===void 0){p=true;}return this.card.getAllInputs(p);};b1.prototype.getResourceInformation=function(){return b.prototype.getResourceInformation.call(this).concat(this.card.getResourceInformation());};b1.prototype.getActionById=function(i){var r=b.prototype.getActionById.call(this,i);if(!r){r=this.card.getActionById(i);}return r;};b1.JsonTypeName="Action.ShowCard";return b1;}(Q));a.ShowCardAction=b1;var c1=(function(){function c1(o){this._renderedActionCount=0;this.items=[];this.buttons=[];this._owner=o;}c1.prototype.isActionAllowed=function(b){var c=this._owner.getForbiddenActionTypes();if(c){for(var d=0,e=c;d<e.length;d++){var i=e[d];if(b.constructor===i){return false;}}}return true;};c1.prototype.refreshContainer=function(){this._actionCardContainer.innerHTML="";if(!this._actionCard){this._actionCardContainer.style.marginTop="0px";return;}this._actionCardContainer.style.marginTop=this._renderedActionCount>0?this._owner.hostConfig.actions.showCard.inlineTopMargin+"px":"0px";var p=this._owner.getEffectivePadding();this._owner.getImmediateSurroundingPadding(p);var b=this._owner.hostConfig.paddingDefinitionToSpacingDefinition(p);if(this._actionCard){this._actionCard.style.paddingLeft=b.left+"px";this._actionCard.style.paddingRight=b.right+"px";this._actionCard.style.marginLeft="-"+b.left+"px";this._actionCard.style.marginRight="-"+b.right+"px";if(b.bottom!=0&&!this._owner.isDesignMode()){this._actionCard.style.paddingBottom=b.bottom+"px";this._actionCard.style.marginBottom="-"+b.bottom+"px";}U.appendChild(this._actionCardContainer,this._actionCard);}};c1.prototype.layoutChanged=function(){this._owner.getRootElement().updateLayout();};c1.prototype.showActionCard=function(b,c,r){if(c===void 0){c=false;}if(r===void 0){r=true;}b.card.suppressStyle=c;var d=b.card.renderedElement&&!this._owner.isDesignMode()?b.card.renderedElement:b.card.render();this._actionCard=d;this._expandedAction=b;this.refreshContainer();if(r){this.layoutChanged();m1(b,true);}};c1.prototype.collapseExpandedAction=function(){for(var b=0,c=this.buttons;b<c.length;b++){var d=c[b];d.state=0;}var p=this._expandedAction;this._expandedAction=undefined;this._actionCard=undefined;this.refreshContainer();if(p){this.layoutChanged();m1(p,false);}};c1.prototype.expandShowCardAction=function(b,r){for(var c=0,d=this.buttons;c<d.length;c++){var e=d[c];if(e.action!==b){e.state=2;}else{e.state=1;}}this.showActionCard(b,!(this._owner.isAtTheVeryLeft()&&this._owner.isAtTheVeryRight()),r);};c1.prototype.getParentContainer=function(){if(this._owner instanceof g1){return this._owner;}else{return this._owner.getParentContainer();}};c1.prototype.findActionButton=function(b){for(var c=0,d=this.buttons;c<d.length;c++){var e=d[c];if(e.action==b){return e;}}return undefined;};c1.prototype.actionExecuted=function(b){if(!(b instanceof b1)){this.collapseExpandedAction();}else{if(b===this._expandedAction){this.collapseExpandedAction();}else{this.expandShowCardAction(b,true);}}};c1.prototype.parse=function(b,c){this.clear();if(Array.isArray(b)){for(var d=0,e=b;d<e.length;d++){var i=e[d];var o=c.parseAction(this._owner,i,[],!this._owner.isDesignMode());if(o){this.addAction(o);}}}};c1.prototype.toJSON=function(b,p,c){c.serializeArray(b,p,this.items);};c1.prototype.getActionById=function(i){var r=undefined;for(var b=0,c=this.items;b<c.length;b++){var d=c[b];r=d.getActionById(i);if(r){break;}}return r;};c1.prototype.validateProperties=function(c){if(this._owner.hostConfig.actions.maxActions&&this.items.length>this._owner.hostConfig.actions.maxActions){c.addFailure(this._owner,E.ValidationEvent.TooManyActions,n.Strings.errors.tooManyActions(this._owner.hostConfig.actions.maxActions));}if(this.items.length>0&&!this._owner.hostConfig.supportsInteractivity){c.addFailure(this._owner,E.ValidationEvent.InteractivityNotAllowed,n.Strings.errors.interactivityNotAllowed());}for(var b=0,d=this.items;b<d.length;b++){var i=d[b];if(!this.isActionAllowed(i)){c.addFailure(this._owner,E.ValidationEvent.ActionTypeNotAllowed,n.Strings.errors.actionTypeNotAllowed(i.getJsonTypeName()));}i.internalValidateProperties(c);}};c1.prototype.render=function(o,b){var c=this._owner.hostConfig;if(!c.supportsInteractivity){return undefined;}var e=document.createElement("div");var d=c.actions.maxActions?Math.min(c.actions.maxActions,this.items.length):this.items.length;this._actionCardContainer=document.createElement("div");this._renderedActionCount=0;if(c.actions.preExpandSingleShowCardAction&&d==1&&this.items[0]instanceof b1&&this.isActionAllowed(this.items[0])){this.showActionCard(this.items[0],true);this._renderedActionCount=1;}else{var p=document.createElement("div");p.className=c.makeCssClassName("ac-actionSet");p.style.display="flex";p.setAttribute("role","menubar");if(o==E.Orientation.Horizontal){p.style.flexDirection="row";if(this._owner.horizontalAlignment&&c.actions.actionAlignment!=E.ActionAlignment.Stretch){switch(this._owner.horizontalAlignment){case E.HorizontalAlignment.Center:p.style.justifyContent="center";break;case E.HorizontalAlignment.Right:p.style.justifyContent="flex-end";break;default:p.style.justifyContent="flex-start";break;}}else{switch(c.actions.actionAlignment){case E.ActionAlignment.Center:p.style.justifyContent="center";break;case E.ActionAlignment.Right:p.style.justifyContent="flex-end";break;default:p.style.justifyContent="flex-start";break;}}}else{p.style.flexDirection="column";if(this._owner.horizontalAlignment&&c.actions.actionAlignment!=E.ActionAlignment.Stretch){switch(this._owner.horizontalAlignment){case E.HorizontalAlignment.Center:p.style.alignItems="center";break;case E.HorizontalAlignment.Right:p.style.alignItems="flex-end";break;default:p.style.alignItems="flex-start";break;}}else{switch(c.actions.actionAlignment){case E.ActionAlignment.Center:p.style.alignItems="center";break;case E.ActionAlignment.Right:p.style.alignItems="flex-end";break;case E.ActionAlignment.Stretch:p.style.alignItems="stretch";break;default:p.style.alignItems="flex-start";break;}}}var r=this.getParentContainer();if(r){var z1=r.getEffectiveStyle();var A1=this.items.filter(this.isActionAllowed.bind(this));for(var i=0;i<A1.length;i++){var B1=this.findActionButton(A1[i]);if(!B1){B1=new P(A1[i],z1);B1.onClick=function(ab){ab.action.execute();};this.buttons.push(B1);}B1.render();if(B1.action.renderedElement){if(A1.length>1){B1.action.renderedElement.setAttribute("aria-posinset",(i+1).toString());B1.action.renderedElement.setAttribute("aria-setsize",A1.length.toString());B1.action.renderedElement.setAttribute("role","menuitem");}if(c.actions.actionsOrientation==E.Orientation.Horizontal&&c.actions.actionAlignment==E.ActionAlignment.Stretch){B1.action.renderedElement.style.flex="0 1 100%";}else{B1.action.renderedElement.style.flex="0 1 auto";}p.appendChild(B1.action.renderedElement);this._renderedActionCount++;if(this._renderedActionCount>=c.actions.maxActions||i==this.items.length-1){break;}else if(c.actions.buttonSpacing>0){var C1=document.createElement("div");if(o===E.Orientation.Horizontal){C1.style.flex="0 0 auto";C1.style.width=c.actions.buttonSpacing+"px";}else{C1.style.height=c.actions.buttonSpacing+"px";}U.appendChild(p,C1);}}}}var D1=document.createElement("div");D1.style.overflow="hidden";D1.appendChild(p);U.appendChild(e,D1);}U.appendChild(e,this._actionCardContainer);for(var _i=0,_a=this.buttons;_i<_a.length;_i++){var G1=_a[_i];if(G1.state==1){this.expandShowCardAction(G1.action,false);break;}}return this._renderedActionCount>0?e:undefined;};c1.prototype.addAction=function(b){if(!b){throw new Error("The action parameter cannot be null.");}if((!b.parent||b.parent===this._owner)&&this.items.indexOf(b)<0){this.items.push(b);if(!b.parent){b.setParent(this._owner);}b["_actionCollection"]=this;}else{throw new Error(n.Strings.errors.actionAlreadyParented());}};c1.prototype.removeAction=function(b){if(this.expandedAction&&this._expandedAction==b){this.collapseExpandedAction();}var c=this.items.indexOf(b);if(c>=0){this.items.splice(c,1);b.setParent(undefined);b["_actionCollection"]=undefined;for(var i=0;i<this.buttons.length;i++){if(this.buttons[i].action==b){this.buttons.splice(i,1);break;}}return true;}return false;};c1.prototype.clear=function(){this.items=[];this.buttons=[];this._expandedAction=undefined;this._renderedActionCount=0;};c1.prototype.getAllInputs=function(p){if(p===void 0){p=true;}var r=[];if(p){for(var b=0,c=this.items;b<c.length;b++){var d=c[b];r=r.concat(d.getAllInputs());}}return r;};c1.prototype.getResourceInformation=function(){var r=[];for(var b=0,c=this.items;b<c.length;b++){var d=c[b];r=r.concat(d.getResourceInformation());}return r;};Object.defineProperty(c1.prototype,"renderedActionCount",{get:function(){return this._renderedActionCount;},enumerable:false,configurable:true});Object.defineProperty(c1.prototype,"expandedAction",{get:function(){return this._expandedAction;},enumerable:false,configurable:true});return c1;}());var d1=(function(b){f(d1,b);function d1(){var c=b.call(this)||this;c._actionCollection=new c1(c);return c;}d1.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);this._actionCollection.parse(c["actions"],d);};d1.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);this._actionCollection.toJSON(c,"actions",d);};d1.prototype.internalRender=function(){return this._actionCollection.render(this.orientation!==undefined?this.orientation:this.hostConfig.actions.actionsOrientation,this.isDesignMode());};d1.prototype.isBleedingAtBottom=function(){if(this._actionCollection.renderedActionCount==0){return b.prototype.isBleedingAtBottom.call(this);}else{if(this._actionCollection.items.length==1){return this._actionCollection.expandedAction!==undefined&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!==undefined;}}};d1.prototype.getJsonTypeName=function(){return"ActionSet";};d1.prototype.getActionCount=function(){return this._actionCollection.items.length;};d1.prototype.getActionAt=function(i){if(i>=0&&i<this.getActionCount()){return this._actionCollection.items[i];}else{return b.prototype.getActionAt.call(this,i);}};d1.prototype.getActionById=function(i){var r=this._actionCollection.getActionById(i);return r?r:b.prototype.getActionById.call(this,i);};d1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);this._actionCollection.validateProperties(c);};d1.prototype.addAction=function(c){this._actionCollection.addAction(c);};d1.prototype.getAllInputs=function(p){if(p===void 0){p=true;}return p?this._actionCollection.getAllInputs():[];};d1.prototype.getResourceInformation=function(){return this._actionCollection.getResourceInformation();};d1.prototype.findDOMNodeOwner=function(c){var d=undefined;for(var e=0,i=this._actionCollection.items;e<i.length;e++){var o=i[e];d=o.findDOMNodeOwner(c);if(d){return d;}}return b.prototype.findDOMNodeOwner.call(this,c);};Object.defineProperty(d1.prototype,"isInteractive",{get:function(){return true;},enumerable:false,configurable:true});d1.orientationProperty=new k.EnumProperty(k.Versions.v1_1,"orientation",E.Orientation);g([k.property(d1.orientationProperty)],d1.prototype,"orientation",void 0);return d1;}(C));a.ActionSet=d1;var e1=(function(b){f(e1,b);function e1(){var c=b!==null&&b.apply(this,arguments)||this;c._bleed=false;return c;}Object.defineProperty(e1.prototype,"style",{get:function(){if(this.allowCustomStyle){var c=this.getValue(e1.styleProperty);if(c&&this.hostConfig.containerStyles.getStyleByName(c)){return c;}}return undefined;},set:function(c){this.setValue(e1.styleProperty,c);},enumerable:false,configurable:true});e1.prototype.adjustRenderedElementSize=function(r){b.prototype.adjustRenderedElementSize.call(this,r);if(this.minPixelHeight){r.style.minHeight=this.minPixelHeight+"px";}};e1.prototype.applyBackground=function(){if(this.renderedElement){var c=this.hostConfig.containerStyles.getStyleByName(this.style,this.hostConfig.containerStyles.getStyleByName(this.defaultStyle));if(c.backgroundColor){var d=U.stringToCssColor(c.backgroundColor);this.renderedElement.style.backgroundColor=d;this.renderedElement.style.border="1px solid "+d;}}};e1.prototype.applyPadding=function(){b.prototype.applyPadding.call(this);if(!this.renderedElement){return;}var p=new s.SpacingDefinition();if(this.getEffectivePadding()){p=this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());}this.renderedElement.style.paddingTop=p.top+"px";this.renderedElement.style.paddingRight=p.right+"px";this.renderedElement.style.paddingBottom=p.bottom+"px";this.renderedElement.style.paddingLeft=p.left+"px";if(this.isBleeding()){var c=new s.PaddingDefinition();this.getImmediateSurroundingPadding(c);var d=this.hostConfig.paddingDefinitionToSpacingDefinition(c);this.renderedElement.style.marginRight="-"+d.right+"px";this.renderedElement.style.marginLeft="-"+d.left+"px";if(!this.isDesignMode()){this.renderedElement.style.marginTop="-"+d.top+"px";this.renderedElement.style.marginBottom="-"+d.bottom+"px";}if(this.separatorElement&&this.separatorOrientation==E.Orientation.Horizontal){this.separatorElement.style.marginLeft="-"+d.left+"px";this.separatorElement.style.marginRight="-"+d.right+"px";}}else{this.renderedElement.style.marginRight="0";this.renderedElement.style.marginLeft="0";this.renderedElement.style.marginTop="0";this.renderedElement.style.marginBottom="0";if(this.separatorElement&&this.separatorOrientation===E.Orientation.Horizontal){this.separatorElement.style.marginRight="0";this.separatorElement.style.marginLeft="0";}}};e1.prototype.getHasBackground=function(){var c=this.parent;while(c){var d=c instanceof g1?c.backgroundImage.isValid():false;if(c instanceof e1){if(this.hasExplicitStyle&&(c.getEffectiveStyle()!=this.getEffectiveStyle()||d)){return true;}}c=c.parent;}return false;};e1.prototype.getDefaultPadding=function(){return this.getHasBackground()?new s.PaddingDefinition(E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding):b.prototype.getDefaultPadding.call(this);};e1.prototype.getHasExpandedAction=function(){return false;};e1.prototype.getBleed=function(){return this._bleed;};e1.prototype.setBleed=function(c){this._bleed=c;};Object.defineProperty(e1.prototype,"renderedActionCount",{get:function(){return 0;},enumerable:false,configurable:true});Object.defineProperty(e1.prototype,"hasExplicitStyle",{get:function(){return this.getValue(e1.styleProperty)!==undefined;},enumerable:false,configurable:true});Object.defineProperty(e1.prototype,"allowCustomStyle",{get:function(){return true;},enumerable:false,configurable:true});e1.prototype.isBleeding=function(){return(this.getHasBackground()||this.hostConfig.alwaysAllowBleed)&&this.getBleed();};e1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);var e=this.getValue(e1.styleProperty);if(e!==undefined){var d=this.hostConfig.containerStyles.getStyleByName(e);if(!d){c.addFailure(this,E.ValidationEvent.InvalidPropertyValue,n.Strings.errors.invalidPropertyValue(e,"style"));}}};e1.prototype.render=function(){var r=b.prototype.render.call(this);if(r&&this.getHasBackground()){this.applyBackground();}return r;};e1.prototype.getEffectiveStyle=function(){var e=this.style;return e?e:b.prototype.getEffectiveStyle.call(this);};e1.styleProperty=new k.ValueSetProperty(k.Versions.v1_0,"style",[{value:E.ContainerStyle.Default},{value:E.ContainerStyle.Emphasis},{targetVersion:k.Versions.v1_2,value:E.ContainerStyle.Accent},{targetVersion:k.Versions.v1_2,value:E.ContainerStyle.Good},{targetVersion:k.Versions.v1_2,value:E.ContainerStyle.Attention},{targetVersion:k.Versions.v1_2,value:E.ContainerStyle.Warning}]);e1.bleedProperty=new k.BoolProperty(k.Versions.v1_2,"bleed",false);e1.minHeightProperty=new k.PixelSizeProperty(k.Versions.v1_2,"minHeight");g([k.property(e1.styleProperty)],e1.prototype,"style",null);g([k.property(e1.bleedProperty)],e1.prototype,"_bleed",void 0);g([k.property(e1.minHeightProperty)],e1.prototype,"minPixelHeight",void 0);return e1;}(w));a.StylableCardElementContainer=e1;var f1=(function(b){f(f1,b);function f1(){return b!==null&&b.apply(this,arguments)||this;}f1.prototype.getSchemaKey=function(){return"BackgroundImage";};f1.prototype.internalParse=function(c,d){if(typeof c==="string"){this.resetDefaultValues();this.url=c;}else{return b.prototype.internalParse.call(this,c,d);}};f1.prototype.apply=function(e){if(this.url&&e.renderedElement){e.renderedElement.style.backgroundImage="url('"+e.preProcessPropertyValue(f1.urlProperty,this.url)+"')";switch(this.fillMode){case E.FillMode.Repeat:e.renderedElement.style.backgroundRepeat="repeat";break;case E.FillMode.RepeatHorizontally:e.renderedElement.style.backgroundRepeat="repeat-x";break;case E.FillMode.RepeatVertically:e.renderedElement.style.backgroundRepeat="repeat-y";break;case E.FillMode.Cover:default:e.renderedElement.style.backgroundRepeat="no-repeat";e.renderedElement.style.backgroundSize="cover";break;}switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.renderedElement.style.backgroundPositionX="center";break;case E.HorizontalAlignment.Right:e.renderedElement.style.backgroundPositionX="right";break;}switch(this.verticalAlignment){case E.VerticalAlignment.Center:e.renderedElement.style.backgroundPositionY="center";break;case E.VerticalAlignment.Bottom:e.renderedElement.style.backgroundPositionY="bottom";break;}}};f1.prototype.isValid=function(){return this.url?true:false;};f1.urlProperty=new k.StringProperty(k.Versions.v1_0,"url");f1.fillModeProperty=new k.EnumProperty(k.Versions.v1_2,"fillMode",E.FillMode,E.FillMode.Cover);f1.horizontalAlignmentProperty=new k.EnumProperty(k.Versions.v1_2,"horizontalAlignment",E.HorizontalAlignment,E.HorizontalAlignment.Left);f1.verticalAlignmentProperty=new k.EnumProperty(k.Versions.v1_2,"verticalAlignment",E.VerticalAlignment,E.VerticalAlignment.Top);g([k.property(f1.urlProperty)],f1.prototype,"url",void 0);g([k.property(f1.fillModeProperty)],f1.prototype,"fillMode",void 0);g([k.property(f1.horizontalAlignmentProperty)],f1.prototype,"horizontalAlignment",void 0);g([k.property(f1.verticalAlignmentProperty)],f1.prototype,"verticalAlignment",void 0);return f1;}(k.SerializableObject));a.BackgroundImage=f1;var g1=(function(b){f(g1,b);function g1(){var c=b!==null&&b.apply(this,arguments)||this;c.verticalContentAlignment=E.VerticalAlignment.Top;c._items=[];c._renderedItems=[];return c;}Object.defineProperty(g1.prototype,"backgroundImage",{get:function(){return this.getValue(g1.backgroundImageProperty);},enumerable:false,configurable:true});g1.prototype.insertItemAt=function(i,c,d){if(!i.parent||d){if(i.isStandalone){if(c<0||c>=this._items.length){this._items.push(i);}else{this._items.splice(c,0,i);}i.setParent(this);}else{throw new Error(n.Strings.errors.elementTypeNotStandalone(i.getJsonTypeName()));}}else{throw new Error(n.Strings.errors.elementAlreadyParented());}};g1.prototype.supportsExcplitiHeight=function(){return true;};g1.prototype.getItemsCollectionPropertyName=function(){return"items";};g1.prototype.applyBackground=function(){if(this.backgroundImage.isValid()&&this.renderedElement){this.backgroundImage.apply(this);}b.prototype.applyBackground.call(this);};g1.prototype.internalRender=function(){this._renderedItems=[];var c=this.hostConfig;var e=document.createElement("div");if(this.rtl!==undefined&&this.rtl){e.dir="rtl";}e.classList.add(c.makeCssClassName("ac-container"));e.style.display="flex";e.style.flexDirection="column";if(s.GlobalSettings.useAdvancedCardBottomTruncation){e.style.minHeight='-webkit-min-content';}switch(this.verticalContentAlignment){case E.VerticalAlignment.Center:e.style.justifyContent="center";break;case E.VerticalAlignment.Bottom:e.style.justifyContent="flex-end";break;default:e.style.justifyContent="flex-start";break;}if(this._items.length>0){for(var d=0,i=this._items;d<i.length;d++){var o=i[d];var r=this.isElementAllowed(o)?o.render():undefined;if(r){if(this._renderedItems.length>0&&o.separatorElement){o.separatorElement.style.flex="0 0 auto";U.appendChild(e,o.separatorElement);}U.appendChild(e,r);this._renderedItems.push(o);}}}else{if(this.isDesignMode()){var p=this.createPlaceholderElement();p.style.width="100%";p.style.height="100%";e.appendChild(p);}}return e;};g1.prototype.truncateOverflow=function(c){if(this.renderedElement){var d=this.renderedElement.offsetTop+c+1;var e=function(r){var z1=r.renderedElement;if(z1){switch(U.getFitStatus(z1,d)){case E.ContainerFitStatus.FullyInContainer:var A1=r['resetOverflow']();if(A1){e(r);}break;case E.ContainerFitStatus.Overflowing:var B1=d-z1.offsetTop;r['handleOverflow'](B1);break;case E.ContainerFitStatus.FullyOutOfContainer:r['handleOverflow'](0);break;}}};for(var i=0,o=this._items;i<o.length;i++){var p=o[i];e(p);}return true;}return false;};g1.prototype.undoOverflowTruncation=function(){for(var c=0,d=this._items;c<d.length;c++){var i=d[c];i['resetOverflow']();}};g1.prototype.getHasBackground=function(){return this.backgroundImage.isValid()||b.prototype.getHasBackground.call(this);};g1.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);this.clear();this.setShouldFallback(false);var e=c[this.getItemsCollectionPropertyName()];if(Array.isArray(e)){for(var i=0,o=e;i<o.length;i++){var p=o[i];var r=d.parseElement(this,p,!this.isDesignMode());if(r){this.insertItemAt(r,-1,true);}}}};g1.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);d.serializeArray(c,this.getItemsCollectionPropertyName(),this._items);};Object.defineProperty(g1.prototype,"isSelectable",{get:function(){return true;},enumerable:false,configurable:true});g1.prototype.getItemCount=function(){return this._items.length;};g1.prototype.getItemAt=function(i){return this._items[i];};g1.prototype.getFirstVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedItems&&this._renderedItems.length>0){for(var c=0,d=this._renderedItems;c<d.length;c++){var i=d[c];if(i.isVisible){return i;}};}return undefined;};g1.prototype.getLastVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedItems&&this._renderedItems.length>0){for(var i=this._renderedItems.length-1;i>=0;i--){if(this._renderedItems[i].isVisible){return this._renderedItems[i];}}}return undefined;};g1.prototype.getJsonTypeName=function(){return"Container";};g1.prototype.isFirstElement=function(e){var d=this.isDesignMode();for(var c=0,i=this._items;c<i.length;c++){var o=i[c];if(o.isVisible||d){return o==e;}}return false;};g1.prototype.isLastElement=function(e){var d=this.isDesignMode();for(var i=this._items.length-1;i>=0;i--){if(this._items[i].isVisible||d){return this._items[i]==e;}}return false;};g1.prototype.isRtl=function(){if(this.rtl!==undefined){return this.rtl;}else{var p=this.getParentContainer();return p?p.isRtl():false;}};g1.prototype.isBleedingAtTop=function(){var c=this.getFirstVisibleRenderedItem();return this.isBleeding()||(c?c.isBleedingAtTop():false);};g1.prototype.isBleedingAtBottom=function(){var c=this.getLastVisibleRenderedItem();return this.isBleeding()||(c?c.isBleedingAtBottom()&&c.getEffectiveStyle()==this.getEffectiveStyle():false);};g1.prototype.indexOf=function(c){return this._items.indexOf(c);};g1.prototype.addItem=function(i){this.insertItemAt(i,-1,false);};g1.prototype.insertItemBefore=function(i,c){this.insertItemAt(i,this._items.indexOf(c),false);};g1.prototype.insertItemAfter=function(i,c){this.insertItemAt(i,this._items.indexOf(c)+1,false);};g1.prototype.removeItem=function(i){var c=this._items.indexOf(i);if(c>=0){this._items.splice(c,1);i.setParent(undefined);this.updateLayout();return true;}return false;};g1.prototype.clear=function(){this._items=[];this._renderedItems=[];};g1.prototype.getResourceInformation=function(){var r=b.prototype.getResourceInformation.call(this);if(this.backgroundImage.isValid()){r.push({url:this.backgroundImage.url,mimeType:"image"});}return r;};g1.prototype.getActionById=function(i){var r=b.prototype.getActionById.call(this,i);if(!r){if(this.selectAction){r=this.selectAction.getActionById(i);}if(!r){for(var c=0,d=this._items;c<d.length;c++){var e=d[c];r=e.getActionById(i);if(r){break;}}}}return r;};Object.defineProperty(g1.prototype,"padding",{get:function(){return this.getPadding();},set:function(c){this.setPadding(c);},enumerable:false,configurable:true});Object.defineProperty(g1.prototype,"selectAction",{get:function(){return this._selectAction;},set:function(c){this._selectAction=c;},enumerable:false,configurable:true});Object.defineProperty(g1.prototype,"bleed",{get:function(){return this.getBleed();},set:function(c){this.setBleed(c);},enumerable:false,configurable:true});g1.backgroundImageProperty=new k.SerializableObjectProperty(k.Versions.v1_0,"backgroundImage",f1);g1.verticalContentAlignmentProperty=new k.EnumProperty(k.Versions.v1_1,"verticalContentAlignment",E.VerticalAlignment,E.VerticalAlignment.Top);g1.rtlProperty=new k.BoolProperty(k.Versions.v1_0,"rtl");g([k.property(g1.backgroundImageProperty)],g1.prototype,"backgroundImage",null);g([k.property(g1.verticalContentAlignmentProperty)],g1.prototype,"verticalContentAlignment",void 0);g([k.property(g1.rtlProperty)],g1.prototype,"rtl",void 0);return g1;}(e1));a.Container=g1;var h1=(function(b){f(h1,b);function h1(c){if(c===void 0){c="stretch";}var d=b.call(this)||this;d.width="stretch";d._computedWeight=0;d.width=c;return d;}h1.prototype.adjustRenderedElementSize=function(r){var c=20;if(this.isDesignMode()){r.style.minWidth="20px";r.style.minHeight=(!this.minPixelHeight?c:Math.max(this.minPixelHeight,c))+"px";}else{r.style.minWidth="0";if(this.minPixelHeight){r.style.minHeight=this.minPixelHeight+"px";}}if(this.width==="auto"){r.style.flex="0 1 auto";}else if(this.width==="stretch"){r.style.flex="1 1 50px";}else if(this.width instanceof s.SizeAndUnit){if(this.width.unit==E.SizeUnit.Pixel){r.style.flex="0 0 auto";r.style.width=this.width.physicalSize+"px";}else{r.style.flex="1 1 "+(this._computedWeight>0?this._computedWeight:this.width.physicalSize)+"%";}}};h1.prototype.shouldSerialize=function(c){return true;};Object.defineProperty(h1.prototype,"separatorOrientation",{get:function(){return E.Orientation.Vertical;},enumerable:false,configurable:true});h1.prototype.getJsonTypeName=function(){return"Column";};Object.defineProperty(h1.prototype,"hasVisibleSeparator",{get:function(){if(this.parent&&this.parent instanceof i1){return this.separatorElement!==undefined&&!this.parent.isLeftMostElement(this);}else{return false;}},enumerable:false,configurable:true});Object.defineProperty(h1.prototype,"isStandalone",{get:function(){return false;},enumerable:false,configurable:true});h1.widthProperty=new k.CustomProperty(k.Versions.v1_0,"width",function(c,p,d,i){var r=p.defaultValue;var o=d[p.name];var z1=false;if(typeof o==="number"&&!isNaN(o)){r=new s.SizeAndUnit(o,E.SizeUnit.Weight);}else if(o==="auto"||o==="stretch"){r=o;}else if(typeof o==="string"){try{r=s.SizeAndUnit.parse(o);if(r.unit===E.SizeUnit.Pixel&&p.targetVersion.compareTo(i.targetVersion)>0){z1=true;}}catch(e){z1=true;}}else{z1=true;}if(z1){i.logParseEvent(c,E.ValidationEvent.InvalidPropertyValue,n.Strings.errors.invalidColumnWidth(o));r="auto";}return r;},function(c,p,d,e,i){if(e instanceof s.SizeAndUnit){if(e.unit===E.SizeUnit.Pixel){i.serializeValue(d,"width",e.physicalSize+"px");}else{i.serializeNumber(d,"width",e.physicalSize);}}else{i.serializeValue(d,"width",e);}},"stretch");g([k.property(h1.widthProperty)],h1.prototype,"width",void 0);return h1;}(g1));a.Column=h1;var i1=(function(b){f(i1,b);function i1(){var c=b!==null&&b.apply(this,arguments)||this;c._columns=[];return c;}i1.prototype.createColumnInstance=function(c,d){return d.parseCardObject(this,c,[],!this.isDesignMode(),function(e){return!e||e==="Column"?new h1():undefined;},function(e,i){d.logParseEvent(undefined,E.ValidationEvent.ElementTypeNotAllowed,n.Strings.errors.elementTypeNotAllowed(e));});};i1.prototype.internalRender=function(){this._renderedColumns=[];if(this._columns.length>0){var c=this.hostConfig;var e=document.createElement("div");e.className=c.makeCssClassName("ac-columnSet");e.style.display="flex";if(s.GlobalSettings.useAdvancedCardBottomTruncation){e.style.minHeight='-webkit-min-content';}switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.style.justifyContent="center";break;case E.HorizontalAlignment.Right:e.style.justifyContent="flex-end";break;default:e.style.justifyContent="flex-start";break;}var d=0;for(var i=0,o=this._columns;i<o.length;i++){var p=o[i];if(p.width instanceof s.SizeAndUnit&&(p.width.unit==E.SizeUnit.Weight)){d+=p.width.physicalSize;}}for(var r=0,_c=this._columns;r<_c.length;r++){var p=_c[r];if(p.width instanceof s.SizeAndUnit&&p.width.unit==E.SizeUnit.Weight&&d>0){var z1=100/d*p.width.physicalSize;p["_computedWeight"]=z1;}var A1=p.render();if(A1){if(this._renderedColumns.length>0&&p.separatorElement){p.separatorElement.style.flex="0 0 auto";U.appendChild(e,p.separatorElement);}U.appendChild(e,A1);this._renderedColumns.push(p);}}return this._renderedColumns.length>0?e:undefined;}else{return undefined;}};i1.prototype.truncateOverflow=function(c){for(var d=0,e=this._columns;d<e.length;d++){var i=e[d];i['handleOverflow'](c);}return true;};i1.prototype.undoOverflowTruncation=function(){for(var c=0,d=this._columns;c<d.length;c++){var e=d[c];e['resetOverflow']();}};Object.defineProperty(i1.prototype,"isSelectable",{get:function(){return true;},enumerable:false,configurable:true});i1.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);this._columns=[];this._renderedColumns=[];var e=c["columns"];if(Array.isArray(e)){for(var i=0,o=e;i<o.length;i++){var p=o[i];var r=this.createColumnInstance(p,d);if(r){this._columns.push(r);}}}};i1.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);d.serializeArray(c,"columns",this._columns);};i1.prototype.isFirstElement=function(e){for(var c=0,d=this._columns;c<d.length;c++){var i=d[c];if(i.isVisible){return i==e;}}return false;};i1.prototype.isBleedingAtTop=function(){if(this.isBleeding()){return true;}if(this._renderedColumns&&this._renderedColumns.length>0){for(var c=0,d=this._columns;c<d.length;c++){var e=d[c];if(e.isBleedingAtTop()){return true;}}}return false;};i1.prototype.isBleedingAtBottom=function(){if(this.isBleeding()){return true;}if(this._renderedColumns&&this._renderedColumns.length>0){for(var c=0,d=this._columns;c<d.length;c++){var e=d[c];if(e.isBleedingAtBottom()){return true;}}}return false;};i1.prototype.getItemCount=function(){return this._columns.length;};i1.prototype.getFirstVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedColumns&&this._renderedColumns.length>0){return this._renderedColumns[0];}else{return undefined;}};i1.prototype.getLastVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedColumns&&this._renderedColumns.length>0){return this._renderedColumns[this._renderedColumns.length-1];}else{return undefined;}};i1.prototype.getColumnAt=function(i){return this._columns[i];};i1.prototype.getItemAt=function(i){return this.getColumnAt(i);};i1.prototype.getJsonTypeName=function(){return"ColumnSet";};i1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);var d=0;var e=0;for(var i=0,o=this._columns;i<o.length;i++){var p=o[i];if(typeof p.width==="number"){d++;}else if(p.width==="stretch"){e++;}}if(d>0&&e>0){c.addFailure(this,E.ValidationEvent.Hint,n.Strings.hints.dontUseWeightedAndStrecthedColumnsInSameSet());}};i1.prototype.addColumn=function(c){if(!c.parent){this._columns.push(c);c.setParent(this);}else{throw new Error(n.Strings.errors.columnAlreadyBelongsToAnotherSet());}};i1.prototype.removeItem=function(i){if(i instanceof h1){var c=this._columns.indexOf(i);if(c>=0){this._columns.splice(c,1);i.setParent(undefined);this.updateLayout();return true;}}return false;};i1.prototype.indexOf=function(c){return c instanceof h1?this._columns.indexOf(c):-1;};i1.prototype.isLeftMostElement=function(e){return this._columns.indexOf(e)==0;};i1.prototype.isRightMostElement=function(e){return this._columns.indexOf(e)==this._columns.length-1;};i1.prototype.isTopElement=function(e){return this._columns.indexOf(e)>=0;};i1.prototype.isBottomElement=function(e){return this._columns.indexOf(e)>=0;};i1.prototype.getActionById=function(i){var r=undefined;for(var c=0,d=this._columns;c<d.length;c++){var e=d[c];r=e.getActionById(i);if(r){break;}}return r;};Object.defineProperty(i1.prototype,"bleed",{get:function(){return this.getBleed();},set:function(c){this.setBleed(c);},enumerable:false,configurable:true});Object.defineProperty(i1.prototype,"padding",{get:function(){return this.getPadding();},set:function(c){this.setPadding(c);},enumerable:false,configurable:true});Object.defineProperty(i1.prototype,"selectAction",{get:function(){return this._selectAction;},set:function(c){this._selectAction=c;},enumerable:false,configurable:true});return i1;}(e1));a.ColumnSet=i1;function j1(i){var c=i.getRootElement();var o=(c&&c.onImageLoaded)?c.onImageLoaded:v1.onImageLoaded;if(o){o(i);}}function k1(e,b,c){var d=e.getRootElement();var o=(d&&d.onAnchorClicked)?d.onAnchorClicked:v1.onAnchorClicked;return o!==undefined?o(e,b,c):false;}function l1(b){var c=b.parent?b.parent.getRootElement():undefined;var o=(c&&c.onExecuteAction)?c.onExecuteAction:v1.onExecuteAction;if(b.prepareForExecution()&&o){o(b);}}function m1(b,i){var c=b.parent?b.parent.getRootElement():undefined;var o=(c&&c.onInlineCardExpanded)?c.onInlineCardExpanded:v1.onInlineCardExpanded;if(o){o(b,i);}}function n1(i){var c=i.getRootElement();var o=(c&&c.onInputValueChanged)?c.onInputValueChanged:v1.onInputValueChanged;if(o){o(i);}}function o1(e,b){if(b===void 0){b=true;}var r=e.getRootElement();if(b){r.updateLayout();}var c=r;var o=(c&&c.onElementVisibilityChanged)?c.onElementVisibilityChanged:v1.onElementVisibilityChanged;if(o!==undefined){o(e);}}var p1=(function(b){f(p1,b);function p1(){var c=b.call(this)||this;c._actionCollection=new c1(c);return c;}p1.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);this._actionCollection.parse(c["actions"],d);};p1.prototype.internalToJSON=function(c,d){b.prototype.internalToJSON.call(this,c,d);this._actionCollection.toJSON(c,"actions",d);};p1.prototype.internalRender=function(){var e=b.prototype.internalRender.call(this);if(e){var r=this._actionCollection.render(this.hostConfig.actions.actionsOrientation,false);if(r){U.appendChild(e,U.renderSeparation(this.hostConfig,{spacing:this.hostConfig.getEffectiveSpacing(this.hostConfig.actions.spacing)},E.Orientation.Horizontal));U.appendChild(e,r);}if(this.renderIfEmpty){return e;}else{return e.children.length>0?e:undefined;}}else{return undefined;}};p1.prototype.getHasExpandedAction=function(){if(this.renderedActionCount==0){return false;}else if(this.renderedActionCount==1){return this._actionCollection.expandedAction!==undefined&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!==undefined;}};Object.defineProperty(p1.prototype,"renderedActionCount",{get:function(){return this._actionCollection.renderedActionCount;},enumerable:false,configurable:true});Object.defineProperty(p1.prototype,"renderIfEmpty",{get:function(){return false;},enumerable:false,configurable:true});p1.prototype.getActionCount=function(){return this._actionCollection.items.length;};p1.prototype.getActionAt=function(i){if(i>=0&&i<this.getActionCount()){return this._actionCollection.items[i];}else{return b.prototype.getActionAt.call(this,i);}};p1.prototype.getActionById=function(i){var r=this._actionCollection.getActionById(i);return r?r:b.prototype.getActionById.call(this,i);};p1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(this._actionCollection){this._actionCollection.validateProperties(c);}};p1.prototype.isLastElement=function(e){return b.prototype.isLastElement.call(this,e)&&this._actionCollection.items.length==0;};p1.prototype.addAction=function(c){this._actionCollection.addAction(c);};p1.prototype.clear=function(){b.prototype.clear.call(this);this._actionCollection.clear();};p1.prototype.getAllInputs=function(p){if(p===void 0){p=true;}var r=b.prototype.getAllInputs.call(this,p);if(p){r=r.concat(this._actionCollection.getAllInputs(p));}return r;};p1.prototype.getResourceInformation=function(){return b.prototype.getResourceInformation.call(this).concat(this._actionCollection.getResourceInformation());};p1.prototype.isBleedingAtBottom=function(){if(this._actionCollection.renderedActionCount==0){return b.prototype.isBleedingAtBottom.call(this);}else{if(this._actionCollection.items.length==1){return this._actionCollection.expandedAction!==undefined&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!==undefined;}}};Object.defineProperty(p1.prototype,"isStandalone",{get:function(){return false;},enumerable:false,configurable:true});return p1;}(g1));a.ContainerWithActions=p1;var q1=(function(b){f(q1,b);function q1(c,d){var e=b.call(this,c,d,undefined)||this;e.targetVersion=c;e.name=d;return e;}q1.prototype.parse=function(c,d,e){var i=e.parseAction(c.parent,d[this.name],[],false);if(i!==undefined){if(i instanceof W){return i;}e.logParseEvent(c,E.ValidationEvent.ActionTypeNotAllowed,n.Strings.errors.actionTypeNotAllowed(i.getJsonTypeName()));}e.logParseEvent(c,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.propertyMustBeSet("action"));return undefined;};q1.prototype.toJSON=function(c,d,e,i){i.serializeValue(d,this.name,e?e.toJSON(i):undefined,undefined,true);};return q1;}(k.PropertyDefinition));a.RefreshActionProperty=q1;var r1=(function(b){f(r1,b);function r1(){return b!==null&&b.apply(this,arguments)||this;}Object.defineProperty(r1.prototype,"action",{get:function(){return this.getValue(r1.actionProperty);},set:function(c){this.setValue(r1.actionProperty,c);if(c){c.setParent(this.parent);}},enumerable:false,configurable:true});r1.prototype.getSchemaKey=function(){return"RefreshDefinition";};r1.actionProperty=new q1(k.Versions.v1_4,"action");r1.userIdsProperty=new k.StringArrayProperty(k.Versions.v1_4,"userIds");g([k.property(r1.actionProperty)],r1.prototype,"action",null);g([k.property(r1.userIdsProperty)],r1.prototype,"userIds",void 0);return r1;}(k.SerializableObject));a.RefreshDefinition=r1;var s1=(function(b){f(s1,b);function s1(){return b!==null&&b.apply(this,arguments)||this;}s1.prototype.getSchemaKey=function(){return"AuthCardButton";};s1.typeProperty=new k.StringProperty(k.Versions.v1_4,"type");s1.titleProperty=new k.StringProperty(k.Versions.v1_4,"title");s1.imageProperty=new k.StringProperty(k.Versions.v1_4,"image");s1.valueProperty=new k.StringProperty(k.Versions.v1_4,"value");g([k.property(s1.typeProperty)],s1.prototype,"type",void 0);g([k.property(s1.titleProperty)],s1.prototype,"title",void 0);g([k.property(s1.imageProperty)],s1.prototype,"image",void 0);g([k.property(s1.valueProperty)],s1.prototype,"value",void 0);return s1;}(k.SerializableObject));a.AuthCardButton=s1;var t1=(function(b){f(t1,b);function t1(){return b!==null&&b.apply(this,arguments)||this;}t1.prototype.getSchemaKey=function(){return"TokenExchangeResource";};t1.idProperty=new k.StringProperty(k.Versions.v1_4,"id");t1.uriProperty=new k.StringProperty(k.Versions.v1_4,"uri");t1.providerIdProperty=new k.StringProperty(k.Versions.v1_4,"providerId");g([k.property(t1.idProperty)],t1.prototype,"id",void 0);g([k.property(t1.uriProperty)],t1.prototype,"uri",void 0);g([k.property(t1.providerIdProperty)],t1.prototype,"providerId",void 0);return t1;}(k.SerializableObject));a.TokenExchangeResource=t1;var u1=(function(b){f(u1,b);function u1(){return b!==null&&b.apply(this,arguments)||this;}u1.prototype.getSchemaKey=function(){return"Authentication";};u1.textProperty=new k.StringProperty(k.Versions.v1_4,"text");u1.connectionNameProperty=new k.StringProperty(k.Versions.v1_4,"connectionName");u1.buttonsProperty=new k.SerializableObjectCollectionProperty(k.Versions.v1_4,"buttons",s1);u1.tokenExchangeResourceProperty=new k.SerializableObjectProperty(k.Versions.v1_4,"tokenExchangeResource",t1,true);g([k.property(u1.textProperty)],u1.prototype,"text",void 0);g([k.property(u1.connectionNameProperty)],u1.prototype,"connectionName",void 0);g([k.property(u1.buttonsProperty)],u1.prototype,"buttons",void 0);g([k.property(u1.tokenExchangeResourceProperty)],u1.prototype,"tokenExchangeResource",void 0);return u1;}(k.SerializableObject));a.Authentication=u1;var v1=(function(b){f(v1,b);function v1(){var c=b!==null&&b.apply(this,arguments)||this;c.designMode=false;return c;}Object.defineProperty(v1.prototype,"refresh",{get:function(){return this.getValue(v1.refreshProperty);},set:function(c){this.setValue(v1.refreshProperty,c);if(c){c.parent=this;}},enumerable:false,configurable:true});Object.defineProperty(v1,"processMarkdown",{get:function(){throw new Error(n.Strings.errors.processMarkdownEventRemoved());},set:function(c){throw new Error(n.Strings.errors.processMarkdownEventRemoved());},enumerable:false,configurable:true});v1.applyMarkdown=function(c){var r={didProcess:false};if(v1.onProcessMarkdown){v1.onProcessMarkdown(c,r);}else if(window.markdownit){var d=window.markdownit;r.outputHtml=d().render(c);r.didProcess=true;}else{console.warn(n.Strings.errors.markdownProcessingNotEnabled);}return r;};v1.prototype.isVersionSupported=function(){if(this.bypassVersionCheck){return true;}else{var c=!this.version||!this.version.isValid||(this.maxVersion.major<this.version.major)||(this.maxVersion.major==this.version.major&&this.maxVersion.minor<this.version.minor);return!c;}};v1.prototype.getDefaultSerializationContext=function(){return new y1(this.version);};v1.prototype.getItemsCollectionPropertyName=function(){return"body";};v1.prototype.internalParse=function(c,d){this._fallbackCard=undefined;var e=d.parseElement(undefined,c["fallback"],!this.isDesignMode());if(e){this._fallbackCard=new v1();this._fallbackCard.addItem(e);}b.prototype.internalParse.call(this,c,d);};v1.prototype.internalToJSON=function(c,d){this.setValue(v1.versionProperty,d.targetVersion);b.prototype.internalToJSON.call(this,c,d);};v1.prototype.internalRender=function(){var r=b.prototype.internalRender.call(this);if(s.GlobalSettings.useAdvancedCardBottomTruncation&&r){r.style.removeProperty("minHeight");}return r;};v1.prototype.getHasBackground=function(){return true;};v1.prototype.getDefaultPadding=function(){return new s.PaddingDefinition(E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding);};v1.prototype.shouldSerialize=function(c){return true;};Object.defineProperty(v1.prototype,"renderIfEmpty",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(v1.prototype,"bypassVersionCheck",{get:function(){return false;},enumerable:false,configurable:true});Object.defineProperty(v1.prototype,"allowCustomStyle",{get:function(){return this.hostConfig.adaptiveCard&&this.hostConfig.adaptiveCard.allowCustomStyle;},enumerable:false,configurable:true});Object.defineProperty(v1.prototype,"hasBackground",{get:function(){return true;},enumerable:false,configurable:true});v1.prototype.getJsonTypeName=function(){return"AdaptiveCard";};v1.prototype.internalValidateProperties=function(c){b.prototype.internalValidateProperties.call(this,c);if(this.getValue(C.typeNameProperty)!=="AdaptiveCard"){c.addFailure(this,E.ValidationEvent.MissingCardType,n.Strings.errors.invalidCardType());}if(!this.bypassVersionCheck&&!this.version){c.addFailure(this,E.ValidationEvent.PropertyCantBeNull,n.Strings.errors.propertyMustBeSet("version"));}else if(!this.isVersionSupported()){c.addFailure(this,E.ValidationEvent.UnsupportedCardVersion,n.Strings.errors.unsupportedCardVersion(this.version.toString(),this.maxVersion.toString()));}};v1.prototype.render=function(c){var r;if(this.shouldFallback()&&this._fallbackCard){this._fallbackCard.hostConfig=this.hostConfig;r=this._fallbackCard.render();}else{r=b.prototype.render.call(this);if(r){r.classList.add(this.hostConfig.makeCssClassName("ac-adaptiveCard"));if(s.GlobalSettings.setTabIndexAtCardRoot){r.tabIndex=0;}if(this.speak){r.setAttribute("aria-label",this.speak);}}}if(c){U.appendChild(c,r);this.updateLayout();}return r;};v1.prototype.updateLayout=function(p){if(p===void 0){p=true;}b.prototype.updateLayout.call(this,p);if(s.GlobalSettings.useAdvancedCardBottomTruncation&&this.isDisplayed()){var c=this.hostConfig.getEffectiveSpacing(E.Spacing.Default);this['handleOverflow'](this.renderedElement.offsetHeight-c);}};v1.prototype.shouldFallback=function(){return b.prototype.shouldFallback.call(this)||!this.isVersionSupported();};Object.defineProperty(v1.prototype,"hasVisibleSeparator",{get:function(){return false;},enumerable:false,configurable:true});v1.schemaUrl="http://adaptivecards.io/schemas/adaptive-card.json";v1.$schemaProperty=new k.CustomProperty(k.Versions.v1_0,"$schema",function(c,p,d,e){return v1.schemaUrl;},function(c,p,d,e,i){i.serializeValue(d,p.name,v1.schemaUrl);});v1.versionProperty=new k.CustomProperty(k.Versions.v1_0,"version",function(c,p,d,e){var i=k.Version.parse(d[p.name],e);if(i===undefined){i=k.Versions.latest;e.logParseEvent(c,E.ValidationEvent.InvalidPropertyValue,n.Strings.errors.invalidCardVersion(i.toString()));}return i;},function(c,p,d,e,i){if(e!==undefined){i.serializeValue(d,p.name,e.toString());}},k.Versions.v1_0);v1.fallbackTextProperty=new k.StringProperty(k.Versions.v1_0,"fallbackText");v1.speakProperty=new k.StringProperty(k.Versions.v1_0,"speak");v1.refreshProperty=new k.SerializableObjectProperty(k.Versions.v1_4,"refresh",r1,true);v1.authenticationProperty=new k.SerializableObjectProperty(k.Versions.v1_4,"authentication",u1,true);g([k.property(v1.versionProperty)],v1.prototype,"version",void 0);g([k.property(v1.fallbackTextProperty)],v1.prototype,"fallbackText",void 0);g([k.property(v1.speakProperty)],v1.prototype,"speak",void 0);g([k.property(v1.refreshProperty)],v1.prototype,"refresh",null);g([k.property(v1.authenticationProperty)],v1.prototype,"authentication",void 0);return v1;}(p1));a.AdaptiveCard=v1;var w1=(function(b){f(w1,b);function w1(){var c=b!==null&&b.apply(this,arguments)||this;c.suppressStyle=false;return c;}w1.prototype.getSchemaKey=function(){return"InlineAdaptiveCard";};w1.prototype.populateSchema=function(c){b.prototype.populateSchema.call(this,c);c.remove(v1.$schemaProperty,v1.versionProperty);};w1.prototype.getDefaultPadding=function(){return new s.PaddingDefinition(this.suppressStyle?E.Spacing.None:E.Spacing.Padding,E.Spacing.Padding,this.suppressStyle?E.Spacing.None:E.Spacing.Padding,E.Spacing.Padding);};Object.defineProperty(w1.prototype,"bypassVersionCheck",{get:function(){return true;},enumerable:false,configurable:true});Object.defineProperty(w1.prototype,"defaultStyle",{get:function(){if(this.suppressStyle){return E.ContainerStyle.Default;}else{return this.hostConfig.actions.showCard.style?this.hostConfig.actions.showCard.style:E.ContainerStyle.Emphasis;}},enumerable:false,configurable:true});w1.prototype.render=function(c){var r=b.prototype.render.call(this,c);if(r){r.setAttribute("aria-live","polite");r.removeAttribute("tabindex");}return r;};return w1;}(v1));var x1=(function(){function x1(){}x1.populateWithDefaultElements=function(r){r.clear();r.register("Container",g1);r.register("TextBlock",q);r.register("RichTextBlock",R,k.Versions.v1_2);r.register("TextRun",t,k.Versions.v1_2);r.register("Image",v);r.register("ImageSet",x);r.register("Media",y,k.Versions.v1_1);r.register("FactSet",u);r.register("ColumnSet",i1);r.register("ActionSet",d1,k.Versions.v1_2);r.register("Input.Text",D);r.register("Input.Date",K);r.register("Input.Time",O);r.register("Input.Number",N);r.register("Input.ChoiceSet",J);r.register("Input.Toggle",G);};x1.populateWithDefaultActions=function(r){r.clear();r.register(X.JsonTypeName,X);r.register(V.JsonTypeName,V);r.register(b1.JsonTypeName,b1);r.register(Y.JsonTypeName,Y,k.Versions.v1_2);r.register(W.JsonTypeName,W,k.Versions.v1_4);};x1.reset=function(){x1.populateWithDefaultElements(x1.elements);x1.populateWithDefaultActions(x1.actions);};x1.elements=new l.CardObjectRegistry();x1.actions=new l.CardObjectRegistry();return x1;}());a.GlobalRegistry=x1;x1.reset();var y1=(function(b){f(y1,b);function y1(){return b!==null&&b.apply(this,arguments)||this;}y1.prototype.internalParseCardObject=function(p,c,d,e,i,o){var r=undefined;if(c&&typeof c==="object"){var z1=U.parseString(c["type"]);if(z1){if(d.indexOf(z1)>=0){o(z1,1);}else{var A1=false;r=i(z1);if(!r){A1=s.GlobalSettings.enableFallback&&e;o(z1,0);}else{r.setParent(p);r.parse(c,this);A1=s.GlobalSettings.enableFallback&&e&&r.shouldFallback();}if(A1){var B1=c["fallback"];if(!B1&&p){p.setShouldFallback(true);}if(typeof B1==="string"&&B1.toLowerCase()==="drop"){r=undefined;}else if(typeof B1==="object"){r=this.internalParseCardObject(p,B1,d,true,i,o);}}}}}return r;};y1.prototype.cardObjectParsed=function(o,c){if(o instanceof Q&&this.onParseAction){this.onParseAction(o,c,this);}else if(o instanceof C&&this.onParseElement){this.onParseElement(o,c,this);}};y1.prototype.shouldSerialize=function(o){if(o instanceof Q){return this.actionRegistry.findByName(o.getJsonTypeName())!==undefined;}else if(o instanceof C){return this.elementRegistry.findByName(o.getJsonTypeName())!==undefined;}else{return true;}};y1.prototype.parseCardObject=function(p,c,d,e,i,o){var r=this.internalParseCardObject(p,c,d,e,i,o);if(r!==undefined){this.cardObjectParsed(r,c);}return r;};y1.prototype.parseElement=function(p,c,d){var e=this;return this.parseCardObject(p,c,[],d,function(i){return e.elementRegistry.createInstance(i,e.targetVersion);},function(i,o){if(o===0){e.logParseEvent(undefined,E.ValidationEvent.UnknownElementType,n.Strings.errors.unknownElementType(i));}else{e.logParseEvent(undefined,E.ValidationEvent.ElementTypeNotAllowed,n.Strings.errors.elementTypeNotAllowed(i));}});};y1.prototype.parseAction=function(p,c,d,e){var i=this;return this.parseCardObject(p,c,d,e,function(o){return i.actionRegistry.createInstance(o,i.targetVersion);},function(o,r){if(r==0){i.logParseEvent(undefined,E.ValidationEvent.UnknownActionType,n.Strings.errors.unknownActionType(o));}else{i.logParseEvent(undefined,E.ValidationEvent.ActionTypeNotAllowed,n.Strings.errors.actionTypeNotAllowed(o));}});};Object.defineProperty(y1.prototype,"elementRegistry",{get:function(){return this._elementRegistry?this._elementRegistry:x1.elements;},enumerable:false,configurable:true});y1.prototype.setElementRegistry=function(c){this._elementRegistry=c;};Object.defineProperty(y1.prototype,"actionRegistry",{get:function(){return this._actionRegistry?this._actionRegistry:x1.actions;},enumerable:false,configurable:true});y1.prototype.setActionRegistry=function(c){this._actionRegistry=c;};return y1;}(k.BaseSerializationContext));a.SerializationContext=y1;}),"./src/card-object.ts":(function(m,e,_){"use strict";var a=(this&&this.__extends)||(function(){var c=function(d,b){c=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return c(d,b);};return function(d,b){c(d,b);function i(){this.constructor=d;}d.prototype=b===null?Object.create(b):(i.prototype=b.prototype,new i());};})();var f=(this&&this.__decorate)||function(b,t,k,l){var c=arguments.length,r=c<3?t:l===null?l=Object.getOwnPropertyDescriptor(t,k):l,d;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")r=Reflect.decorate(b,t,k,l);else for(var i=b.length-1;i>=0;i--)if(d=b[i])r=(c<3?d(r):c>3?d(t,k,r):d(t,k))||r;return c>3&&r&&Object.defineProperty(t,k,r),r;};Object.defineProperty(e,"__esModule",{value:true});e.CardObject=e.ValidationResults=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var s=_("./src/strings.ts");var g=_("./src/shared.ts");var h=_("./src/host-capabilities.ts");var j=_("./src/serialization.ts");var V=(function(){function V(){this.allIds={};this.validationEvents=[];}V.prototype.addFailure=function(c,b,d){this.validationEvents.push({phase:E.ValidationPhase.Validation,source:c,event:b,message:d});};return V;}());e.ValidationResults=V;var C=(function(b){a(C,b);function C(){var c=b!==null&&b.apply(this,arguments)||this;c._shouldFallback=false;return c;}C.prototype.getSchemaKey=function(){return this.getJsonTypeName();};Object.defineProperty(C.prototype,"requires",{get:function(){return this.getValue(C.requiresProperty);},enumerable:false,configurable:true});C.prototype.contains=function(n){if(this._renderedElement){return this._renderedElement.contains(n);}return false;};C.prototype.preProcessPropertyValue=function(p,c){var v=c===undefined?this.getValue(p):c;if(g.GlobalSettings.allowPreProcessingPropertyValues){var d=this;while(d&&!d.onPreProcessPropertyValue){d=d.parent;}if(d&&d.onPreProcessPropertyValue){return d.onPreProcessPropertyValue(this,p,v);}}return v;};C.prototype.setParent=function(v){this._parent=v;};C.prototype.setShouldFallback=function(v){this._shouldFallback=v;};C.prototype.shouldFallback=function(){return this._shouldFallback||!this.requires.areAllMet(this.hostConfig.hostCapabilities);};C.prototype.getRootObject=function(){var r=this;while(r.parent){r=r.parent;}return r;};C.prototype.internalValidateProperties=function(c){if(this.id){if(c.allIds.hasOwnProperty(this.id)){if(c.allIds[this.id]==1){c.addFailure(this,E.ValidationEvent.DuplicateId,s.Strings.errors.duplicateId(this.id));}c.allIds[this.id]+=1;}else{c.allIds[this.id]=1;}}};C.prototype.validateProperties=function(){var r=new V();this.internalValidateProperties(r);return r;};C.prototype.findDOMNodeOwner=function(n){return this.contains(n)?this:undefined;};Object.defineProperty(C.prototype,"parent",{get:function(){return this._parent;},enumerable:false,configurable:true});Object.defineProperty(C.prototype,"renderedElement",{get:function(){return this._renderedElement;},enumerable:false,configurable:true});C.typeNameProperty=new j.StringProperty(j.Versions.v1_0,"type",undefined,undefined,undefined,function(c){return c.getJsonTypeName();});C.idProperty=new j.StringProperty(j.Versions.v1_0,"id");C.requiresProperty=new j.SerializableObjectProperty(j.Versions.v1_2,"requires",h.HostCapabilities,false,new h.HostCapabilities());f([j.property(C.idProperty)],C.prototype,"id",void 0);f([j.property(C.requiresProperty)],C.prototype,"requires",null);return C;}(j.SerializableObject));e.CardObject=C;}),"./src/channel-adapter.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.ChannelAdapter=void 0;var C=(function(){function C(){}return C;}());e.ChannelAdapter=C;}),"./src/enums.ts":(function(m,e,_){"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
Object.defineProperty(e,"__esModule",{value:true});e.LogLevel=e.RefreshMode=e.ContainerFitStatus=e.ValidationEvent=e.ValidationPhase=e.ContainerStyle=e.InputTextStyle=e.ActionIconPlacement=e.FillMode=e.Orientation=e.ShowCardActionMode=e.ImageStyle=e.ActionAlignment=e.VerticalAlignment=e.HorizontalAlignment=e.TextColor=e.Spacing=e.FontType=e.TextWeight=e.TextSize=e.SizeUnit=e.ImageSize=e.Size=e.ActionStyle=void 0;var A=(function(){function A(){}A.Default="default";A.Positive="positive";A.Destructive="destructive";return A;}());e.ActionStyle=A;var S;(function(S){S[S["Auto"]=0]="Auto";S[S["Stretch"]=1]="Stretch";S[S["Small"]=2]="Small";S[S["Medium"]=3]="Medium";S[S["Large"]=4]="Large";})(S=e.Size||(e.Size={}));var I;(function(I){I[I["Small"]=0]="Small";I[I["Medium"]=1]="Medium";I[I["Large"]=2]="Large";})(I=e.ImageSize||(e.ImageSize={}));var a;(function(a){a[a["Weight"]=0]="Weight";a[a["Pixel"]=1]="Pixel";})(a=e.SizeUnit||(e.SizeUnit={}));var T;(function(T){T[T["Small"]=0]="Small";T[T["Default"]=1]="Default";T[T["Medium"]=2]="Medium";T[T["Large"]=3]="Large";T[T["ExtraLarge"]=4]="ExtraLarge";})(T=e.TextSize||(e.TextSize={}));var b;(function(b){b[b["Lighter"]=0]="Lighter";b[b["Default"]=1]="Default";b[b["Bolder"]=2]="Bolder";})(b=e.TextWeight||(e.TextWeight={}));var F;(function(F){F[F["Default"]=0]="Default";F[F["Monospace"]=1]="Monospace";})(F=e.FontType||(e.FontType={}));var c;(function(c){c[c["None"]=0]="None";c[c["Small"]=1]="Small";c[c["Default"]=2]="Default";c[c["Medium"]=3]="Medium";c[c["Large"]=4]="Large";c[c["ExtraLarge"]=5]="ExtraLarge";c[c["Padding"]=6]="Padding";})(c=e.Spacing||(e.Spacing={}));var d;(function(d){d[d["Default"]=0]="Default";d[d["Dark"]=1]="Dark";d[d["Light"]=2]="Light";d[d["Accent"]=3]="Accent";d[d["Good"]=4]="Good";d[d["Warning"]=5]="Warning";d[d["Attention"]=6]="Attention";})(d=e.TextColor||(e.TextColor={}));var H;(function(H){H[H["Left"]=0]="Left";H[H["Center"]=1]="Center";H[H["Right"]=2]="Right";})(H=e.HorizontalAlignment||(e.HorizontalAlignment={}));var V;(function(V){V[V["Top"]=0]="Top";V[V["Center"]=1]="Center";V[V["Bottom"]=2]="Bottom";})(V=e.VerticalAlignment||(e.VerticalAlignment={}));var f;(function(f){f[f["Left"]=0]="Left";f[f["Center"]=1]="Center";f[f["Right"]=2]="Right";f[f["Stretch"]=3]="Stretch";})(f=e.ActionAlignment||(e.ActionAlignment={}));var g;(function(g){g[g["Default"]=0]="Default";g[g["Person"]=1]="Person";})(g=e.ImageStyle||(e.ImageStyle={}));var h;(function(h){h[h["Inline"]=0]="Inline";h[h["Popup"]=1]="Popup";})(h=e.ShowCardActionMode||(e.ShowCardActionMode={}));var O;(function(O){O[O["Horizontal"]=0]="Horizontal";O[O["Vertical"]=1]="Vertical";})(O=e.Orientation||(e.Orientation={}));var i;(function(i){i[i["Cover"]=0]="Cover";i[i["RepeatHorizontally"]=1]="RepeatHorizontally";i[i["RepeatVertically"]=2]="RepeatVertically";i[i["Repeat"]=3]="Repeat";})(i=e.FillMode||(e.FillMode={}));var j;(function(j){j[j["LeftOfTitle"]=0]="LeftOfTitle";j[j["AboveTitle"]=1]="AboveTitle";})(j=e.ActionIconPlacement||(e.ActionIconPlacement={}));var k;(function(k){k[k["Text"]=0]="Text";k[k["Tel"]=1]="Tel";k[k["Url"]=2]="Url";k[k["Email"]=3]="Email";})(k=e.InputTextStyle||(e.InputTextStyle={}));var C=(function(){function C(){}C.Default="default";C.Emphasis="emphasis";C.Accent="accent";C.Good="good";C.Attention="attention";C.Warning="warning";return C;}());e.ContainerStyle=C;var l;(function(l){l[l["Parse"]=0]="Parse";l[l["ToJSON"]=1]="ToJSON";l[l["Validation"]=2]="Validation";})(l=e.ValidationPhase||(e.ValidationPhase={}));var n;(function(n){n[n["Hint"]=0]="Hint";n[n["ActionTypeNotAllowed"]=1]="ActionTypeNotAllowed";n[n["CollectionCantBeEmpty"]=2]="CollectionCantBeEmpty";n[n["Deprecated"]=3]="Deprecated";n[n["ElementTypeNotAllowed"]=4]="ElementTypeNotAllowed";n[n["InteractivityNotAllowed"]=5]="InteractivityNotAllowed";n[n["InvalidPropertyValue"]=6]="InvalidPropertyValue";n[n["MissingCardType"]=7]="MissingCardType";n[n["PropertyCantBeNull"]=8]="PropertyCantBeNull";n[n["TooManyActions"]=9]="TooManyActions";n[n["UnknownActionType"]=10]="UnknownActionType";n[n["UnknownElementType"]=11]="UnknownElementType";n[n["UnsupportedCardVersion"]=12]="UnsupportedCardVersion";n[n["DuplicateId"]=13]="DuplicateId";n[n["UnsupportedProperty"]=14]="UnsupportedProperty";n[n["RequiredInputsShouldHaveLabel"]=15]="RequiredInputsShouldHaveLabel";n[n["RequiredInputsShouldHaveErrorMessage"]=16]="RequiredInputsShouldHaveErrorMessage";n[n["Other"]=17]="Other";})(n=e.ValidationEvent||(e.ValidationEvent={}));var o;(function(o){o[o["FullyInContainer"]=0]="FullyInContainer";o[o["Overflowing"]=1]="Overflowing";o[o["FullyOutOfContainer"]=2]="FullyOutOfContainer";})(o=e.ContainerFitStatus||(e.ContainerFitStatus={}));var R;(function(R){R[R["Disabled"]=0]="Disabled";R[R["Manual"]=1]="Manual";R[R["Automatic"]=2]="Automatic";})(R=e.RefreshMode||(e.RefreshMode={}));var L;(function(L){L[L["Info"]=0]="Info";L[L["Warning"]=1]="Warning";L[L["Error"]=2]="Error";})(L=e.LogLevel||(e.LogLevel={}));}),"./src/host-capabilities.ts":(function(m,e,_){"use strict";var a=(this&&this.__extends)||(function(){var c=function(d,b){c=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return c(d,b);};return function(d,b){c(d,b);function f(){this.constructor=d;}d.prototype=b===null?Object.create(b):(f.prototype=b.prototype,new f());};})();Object.defineProperty(e,"__esModule",{value:true});e.HostCapabilities=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var s=_("./src/serialization.ts");var H=(function(b){a(H,b);function H(){var c=b!==null&&b.apply(this,arguments)||this;c._capabilities={};return c;}H.prototype.getSchemaKey=function(){return"HostCapabilities";};H.prototype.internalParse=function(c,d){b.prototype.internalParse.call(this,c,d);if(c){for(var n in c){var j=c[n];if(typeof j==="string"){if(j=="*"){this.addCapability(n,"*");}else{var v=s.Version.parse(j,d);if(v&&v.isValid){this.addCapability(n,v);}}}}}};H.prototype.internalToJSON=function(t,c){b.prototype.internalToJSON.call(this,t,c);for(var k in this._capabilities){t[k]=this._capabilities[k];}};H.prototype.addCapability=function(n,v){this._capabilities[n]=v;};H.prototype.removeCapability=function(n){delete this._capabilities[n];};H.prototype.clear=function(){this._capabilities={};};H.prototype.hasCapability=function(n,v){if(this._capabilities.hasOwnProperty(n)){if(v=="*"||this._capabilities[n]=="*"){return true;}return v.compareTo(this._capabilities[n])<=0;}return false;};H.prototype.areAllMet=function(h){for(var c in this._capabilities){if(!h.hasCapability(c,this._capabilities[c])){return false;}}return true;};return H;}(s.SerializableObject));e.HostCapabilities=H;}),"./src/host-config.ts":(function(m,a,_){"use strict";var c=(this&&this.__extends)||(function(){var e=function(d,b){e=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return e(d,b);};return function(d,b){e(d,b);function p(){this.constructor=d;}d.prototype=b===null?Object.create(b):(p.prototype=b.prototype,new p());};})();Object.defineProperty(a,"__esModule",{value:true});a.defaultHostConfig=a.HostConfig=a.FontTypeSet=a.FontTypeDefinition=a.ContainerStyleSet=a.ContainerStyleDefinition=a.ColorSetDefinition=a.ActionsConfig=a.ShowCardActionConfig=a.FactSetConfig=a.FactTitleDefinition=a.FactTextDefinition=a.InputConfig=a.InputLabelConfig=a.RequiredInputLabelTextDefinition=a.BaseTextDefinition=a.MediaConfig=a.ImageSetConfig=a.AdaptiveCardConfig=a.TextColorDefinition=a.ColorDefinition=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var U=_("./src/utils.ts");var S=_("./src/shared.ts");var h=_("./src/host-capabilities.ts");function f(b,v,d){if(typeof v==="string"){var p=U.parseEnum(b,v,d);return p!==undefined?p:d;}else if(typeof v==="number"){return v;}else{return d;}}var C=(function(){function C(d,b){this.default="#000000";this.subtle="#666666";if(d){this.default=d;}if(b){this.subtle=b;}}C.prototype.parse=function(b){if(b){this.default=b["default"]||this.default;this.subtle=b["subtle"]||this.subtle;}};return C;}());a.ColorDefinition=C;var T=(function(b){c(T,b);function T(){var d=b!==null&&b.apply(this,arguments)||this;d.highlightColors=new C("#22000000","#11000000");return d;}T.prototype.parse=function(d){b.prototype.parse.call(this,d);if(d){this.highlightColors.parse(d["highlightColors"]);}};return T;}(C));a.TextColorDefinition=T;var A=(function(){function A(b){this.allowCustomStyle=false;if(b){this.allowCustomStyle=b["allowCustomStyle"]||this.allowCustomStyle;}}return A;}());a.AdaptiveCardConfig=A;var I=(function(){function I(b){this.imageSize=E.Size.Medium;this.maxImageHeight=100;if(b){this.imageSize=b["imageSize"]!=null?b["imageSize"]:this.imageSize;this.maxImageHeight=U.parseNumber(b["maxImageHeight"],100);}}I.prototype.toJSON=function(){return{imageSize:E.Size[this.imageSize],maxImageHeight:this.maxImageHeight};};return I;}());a.ImageSetConfig=I;var M=(function(){function M(b){this.allowInlinePlayback=true;if(b){this.defaultPoster=b["defaultPoster"];this.allowInlinePlayback=b["allowInlinePlayback"]||this.allowInlinePlayback;}}M.prototype.toJSON=function(){return{defaultPoster:this.defaultPoster,allowInlinePlayback:this.allowInlinePlayback};};return M;}());a.MediaConfig=M;var B=(function(){function B(b){this.size=E.TextSize.Default;this.color=E.TextColor.Default;this.isSubtle=false;this.weight=E.TextWeight.Default;if(b){this.size=f(E.TextSize,b["size"],this.size);this.color=f(E.TextColor,b["color"],this.color);this.isSubtle=b["isSubtle"]||this.isSubtle;this.weight=f(E.TextWeight,b["weight"],this.getDefaultWeight());}};B.prototype.getDefaultWeight=function(){return E.TextWeight.Default;};B.prototype.toJSON=function(){return{size:E.TextSize[this.size],color:E.TextColor[this.color],isSubtle:this.isSubtle,weight:E.TextWeight[this.weight]};};return B;}());a.BaseTextDefinition=B;var R=(function(b){c(R,b);function R(d){var e=b.call(this,d)||this;e.suffix=" *";e.suffixColor=E.TextColor.Attention;if(d){e.suffix=d["suffix"]||e.suffix;e.suffixColor=f(E.TextColor,d["suffixColor"],e.suffixColor);}return e;}R.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);d["suffix"]=this.suffix;d["suffixColor"]=E.TextColor[this.suffixColor];return d;};return R;}(B));a.RequiredInputLabelTextDefinition=R;var g=(function(){function g(b){this.inputSpacing=E.Spacing.Small;this.requiredInputs=new R();this.optionalInputs=new B();if(b){this.inputSpacing=f(E.Spacing,b["inputSpacing"],this.inputSpacing);this.requiredInputs=new R(b["requiredInputs"]);this.optionalInputs=new B(b["optionalInputs"]);}}return g;}());a.InputLabelConfig=g;var i=(function(){function i(b){this.label=new g();this.errorMessage=new B({color:E.TextColor.Attention});if(b){this.label=new g(b["label"]);this.errorMessage=new B(b["errorMessage"]);}}return i;}());a.InputConfig=i;var F=(function(b){c(F,b);function F(d){var e=b.call(this,d)||this;e.wrap=true;if(d){e.wrap=d["wrap"]!=null?d["wrap"]:e.wrap;}return e;}F.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);d["wrap"]=this.wrap;return d;};return F;}(B));a.FactTextDefinition=F;var j=(function(b){c(j,b);function j(d){var e=b.call(this,d)||this;e.maxWidth=150;e.weight=E.TextWeight.Bolder;if(d){e.maxWidth=d["maxWidth"]!=null?d["maxWidth"]:e.maxWidth;e.weight=f(E.TextWeight,d["weight"],E.TextWeight.Bolder);}return e;}j.prototype.getDefaultWeight=function(){return E.TextWeight.Bolder;};return j;}(F));a.FactTitleDefinition=j;var k=(function(){function k(b){this.title=new j();this.value=new F();this.spacing=10;if(b){this.title=new j(b["title"]);this.value=new F(b["value"]);this.spacing=b.spacing&&b.spacing!=null?b.spacing&&b.spacing:this.spacing;}}return k;}());a.FactSetConfig=k;var l=(function(){function l(b){this.actionMode=E.ShowCardActionMode.Inline;this.inlineTopMargin=16;this.style=E.ContainerStyle.Emphasis;if(b){this.actionMode=f(E.ShowCardActionMode,b["actionMode"],E.ShowCardActionMode.Inline);this.inlineTopMargin=b["inlineTopMargin"]!=null?b["inlineTopMargin"]:this.inlineTopMargin;this.style=b["style"]&&typeof b["style"]==="string"?b["style"]:E.ContainerStyle.Emphasis;}}l.prototype.toJSON=function(){return{actionMode:E.ShowCardActionMode[this.actionMode],inlineTopMargin:this.inlineTopMargin,style:this.style};};return l;}());a.ShowCardActionConfig=l;var n=(function(){function n(b){this.maxActions=5;this.spacing=E.Spacing.Default;this.buttonSpacing=20;this.showCard=new l();this.preExpandSingleShowCardAction=false;this.actionsOrientation=E.Orientation.Horizontal;this.actionAlignment=E.ActionAlignment.Left;this.iconPlacement=E.ActionIconPlacement.LeftOfTitle;this.allowTitleToWrap=false;this.iconSize=16;if(b){this.maxActions=b["maxActions"]!=null?b["maxActions"]:this.maxActions;this.spacing=f(E.Spacing,b.spacing&&b.spacing,E.Spacing.Default);this.buttonSpacing=b["buttonSpacing"]!=null?b["buttonSpacing"]:this.buttonSpacing;this.showCard=new l(b["showCard"]);this.preExpandSingleShowCardAction=U.parseBool(b["preExpandSingleShowCardAction"],false);this.actionsOrientation=f(E.Orientation,b["actionsOrientation"],E.Orientation.Horizontal);this.actionAlignment=f(E.ActionAlignment,b["actionAlignment"],E.ActionAlignment.Left);this.iconPlacement=f(E.ActionIconPlacement,b["iconPlacement"],E.ActionIconPlacement.LeftOfTitle);this.allowTitleToWrap=b["allowTitleToWrap"]!=null?b["allowTitleToWrap"]:this.allowTitleToWrap;try{var d=S.SizeAndUnit.parse(b["iconSize"]);if(d.unit==E.SizeUnit.Pixel){this.iconSize=d.physicalSize;}}catch(e){}}}n.prototype.toJSON=function(){return{maxActions:this.maxActions,spacing:E.Spacing[this.spacing],buttonSpacing:this.buttonSpacing,showCard:this.showCard,preExpandSingleShowCardAction:this.preExpandSingleShowCardAction,actionsOrientation:E.Orientation[this.actionsOrientation],actionAlignment:E.ActionAlignment[this.actionAlignment]};};return n;}());a.ActionsConfig=n;var o=(function(){function o(b){this.default=new T();this.dark=new T();this.light=new T();this.accent=new T();this.good=new T();this.warning=new T();this.attention=new T();this.parse(b);}o.prototype.parseSingleColor=function(b,p){if(b){this[p].parse(b[p]);}};o.prototype.parse=function(b){if(b){this.parseSingleColor(b,"default");this.parseSingleColor(b,"dark");this.parseSingleColor(b,"light");this.parseSingleColor(b,"accent");this.parseSingleColor(b,"good");this.parseSingleColor(b,"warning");this.parseSingleColor(b,"attention");}};return o;}());a.ColorSetDefinition=o;var q=(function(){function q(b){this.foregroundColors=new o({"default":{default:"#333333",subtle:"#EE333333"},"dark":{default:"#000000",subtle:"#66000000"},"light":{default:"#FFFFFF",subtle:"#33000000"},"accent":{default:"#2E89FC",subtle:"#882E89FC"},"good":{default:"#028A02",subtle:"#DD027502"},"warning":{default:"#E69500",subtle:"#DDE69500"},"attention":{default:"#CC3300",subtle:"#DDCC3300"}});this.parse(b);}q.prototype.parse=function(b){if(b){this.backgroundColor=b["backgroundColor"];this.foregroundColors.parse(b["foregroundColors"]);this.highlightBackgroundColor=b["highlightBackgroundColor"];this.highlightForegroundColor=b["highlightForegroundColor"];}};Object.defineProperty(q.prototype,"isBuiltIn",{get:function(){return false;},enumerable:false,configurable:true});return q;}());a.ContainerStyleDefinition=q;var r=(function(b){c(r,b);function r(){return b!==null&&b.apply(this,arguments)||this;}Object.defineProperty(r.prototype,"isBuiltIn",{get:function(){return true;},enumerable:false,configurable:true});return r;}(q));var s=(function(){function s(b){this._allStyles={};this._allStyles[E.ContainerStyle.Default]=new r();this._allStyles[E.ContainerStyle.Emphasis]=new r();this._allStyles[E.ContainerStyle.Accent]=new r();this._allStyles[E.ContainerStyle.Good]=new r();this._allStyles[E.ContainerStyle.Attention]=new r();this._allStyles[E.ContainerStyle.Warning]=new r();if(b){this._allStyles[E.ContainerStyle.Default].parse(b[E.ContainerStyle.Default]);this._allStyles[E.ContainerStyle.Emphasis].parse(b[E.ContainerStyle.Emphasis]);this._allStyles[E.ContainerStyle.Accent].parse(b[E.ContainerStyle.Accent]);this._allStyles[E.ContainerStyle.Good].parse(b[E.ContainerStyle.Good]);this._allStyles[E.ContainerStyle.Attention].parse(b[E.ContainerStyle.Attention]);this._allStyles[E.ContainerStyle.Warning].parse(b[E.ContainerStyle.Warning]);var d=b["customStyles"];if(d&&Array.isArray(d)){for(var e=0,p=d;e<p.length;e++){var v=p[e];if(v){var w=v["name"];if(w&&typeof w==="string"){if(this._allStyles.hasOwnProperty(w)){this._allStyles[w].parse(v["style"]);}else{this._allStyles[w]=new q(v["style"]);}}}}}}}s.prototype.toJSON=function(){var b=this;var d=[];Object.keys(this._allStyles).forEach(function(p){if(!b._allStyles[p].isBuiltIn){d.push({name:p,style:b._allStyles[p]});}});var e={default:this.default,emphasis:this.emphasis};if(d.length>0){e.customStyles=d;}return e;};s.prototype.getStyleByName=function(b,d){if(b&&this._allStyles.hasOwnProperty(b)){return this._allStyles[b];}else{return d?d:this._allStyles[E.ContainerStyle.Default];}};Object.defineProperty(s.prototype,"default",{get:function(){return this._allStyles[E.ContainerStyle.Default];},enumerable:false,configurable:true});Object.defineProperty(s.prototype,"emphasis",{get:function(){return this._allStyles[E.ContainerStyle.Emphasis];},enumerable:false,configurable:true});return s;}());a.ContainerStyleSet=s;var t=(function(){function t(b){this.fontFamily="Segoe UI,Segoe,Segoe WP,Helvetica Neue,Helvetica,sans-serif";this.fontSizes={small:12,default:14,medium:17,large:21,extraLarge:26};this.fontWeights={lighter:200,default:400,bolder:600};if(b){this.fontFamily=b;}}t.prototype.parse=function(b){this.fontFamily=b["fontFamily"]||this.fontFamily;this.fontSizes={small:b.fontSizes&&b.fontSizes["small"]||this.fontSizes.small,default:b.fontSizes&&b.fontSizes["default"]||this.fontSizes.default,medium:b.fontSizes&&b.fontSizes["medium"]||this.fontSizes.medium,large:b.fontSizes&&b.fontSizes["large"]||this.fontSizes.large,extraLarge:b.fontSizes&&b.fontSizes["extraLarge"]||this.fontSizes.extraLarge};this.fontWeights={lighter:b.fontWeights&&b.fontWeights["lighter"]||this.fontWeights.lighter,default:b.fontWeights&&b.fontWeights["default"]||this.fontWeights.default,bolder:b.fontWeights&&b.fontWeights["bolder"]||this.fontWeights.bolder};};t.monospace=new t("'Courier New', Courier, monospace");return t;}());a.FontTypeDefinition=t;var u=(function(){function u(b){this.default=new t();this.monospace=new t("'Courier New', Courier, monospace");if(b){this.default.parse(b["default"]);this.monospace.parse(b["monospace"]);}}u.prototype.getStyleDefinition=function(b){switch(b){case E.FontType.Monospace:return this.monospace;case E.FontType.Default:default:return this.default;}};return u;}());a.FontTypeSet=u;var H=(function(){function H(b){this.hostCapabilities=new h.HostCapabilities();this.choiceSetInputValueSeparator=",";this.supportsInteractivity=true;this.spacing={small:3,default:8,medium:20,large:30,extraLarge:40,padding:15};this.separator={lineThickness:1,lineColor:"#EEEEEE"};this.imageSizes={small:40,medium:80,large:160};this.containerStyles=new s();this.inputs=new i();this.actions=new n();this.adaptiveCard=new A();this.imageSet=new I();this.media=new M();this.factSet=new k();this.alwaysAllowBleed=false;if(b){if(typeof b==="string"||b instanceof String){b=JSON.parse(b);}this.choiceSetInputValueSeparator=(b&&typeof b["choiceSetInputValueSeparator"]==="string")?b["choiceSetInputValueSeparator"]:this.choiceSetInputValueSeparator;this.supportsInteractivity=(b&&typeof b["supportsInteractivity"]==="boolean")?b["supportsInteractivity"]:this.supportsInteractivity;this._legacyFontType=new t();this._legacyFontType.parse(b);if(b.fontTypes){this.fontTypes=new u(b.fontTypes);}if(b.lineHeights){this.lineHeights={small:b.lineHeights["small"],default:b.lineHeights["default"],medium:b.lineHeights["medium"],large:b.lineHeights["large"],extraLarge:b.lineHeights["extraLarge"]};};this.imageSizes={small:b.imageSizes&&b.imageSizes["small"]||this.imageSizes.small,medium:b.imageSizes&&b.imageSizes["medium"]||this.imageSizes.medium,large:b.imageSizes&&b.imageSizes["large"]||this.imageSizes.large,};this.containerStyles=new s(b["containerStyles"]);this.spacing={small:b.spacing&&b.spacing["small"]||this.spacing.small,default:b.spacing&&b.spacing["default"]||this.spacing.default,medium:b.spacing&&b.spacing["medium"]||this.spacing.medium,large:b.spacing&&b.spacing["large"]||this.spacing.large,extraLarge:b.spacing&&b.spacing["extraLarge"]||this.spacing.extraLarge,padding:b.spacing&&b.spacing["padding"]||this.spacing.padding};this.separator={lineThickness:b.separator&&b.separator["lineThickness"]||this.separator.lineThickness,lineColor:b.separator&&b.separator["lineColor"]||this.separator.lineColor};this.inputs=new i(b.inputs||this.inputs);this.actions=new n(b.actions||this.actions);this.adaptiveCard=new A(b.adaptiveCard||this.adaptiveCard);this.imageSet=new I(b["imageSet"]);this.factSet=new k(b["factSet"]);}}H.prototype.getFontTypeDefinition=function(b){if(this.fontTypes){return this.fontTypes.getStyleDefinition(b);}else{return b==E.FontType.Monospace?t.monospace:this._legacyFontType;}};H.prototype.getEffectiveSpacing=function(b){switch(b){case E.Spacing.Small:return this.spacing.small;case E.Spacing.Default:return this.spacing.default;case E.Spacing.Medium:return this.spacing.medium;case E.Spacing.Large:return this.spacing.large;case E.Spacing.ExtraLarge:return this.spacing.extraLarge;case E.Spacing.Padding:return this.spacing.padding;default:return 0;}};H.prototype.paddingDefinitionToSpacingDefinition=function(p){return new S.SpacingDefinition(this.getEffectiveSpacing(p.top),this.getEffectiveSpacing(p.right),this.getEffectiveSpacing(p.bottom),this.getEffectiveSpacing(p.left));};H.prototype.makeCssClassNames=function(){var b=[];for(var d=0;d<arguments.length;d++){b[d]=arguments[d];}var e=[];for(var p=0,v=b;p<v.length;p++){var w=v[p];e.push((this.cssClassNamePrefix?this.cssClassNamePrefix+"-":"")+w);}return e;};H.prototype.makeCssClassName=function(){var b=[];for(var d=0;d<arguments.length;d++){b[d]=arguments[d];}var e=this.makeCssClassNames.apply(this,b).join(" ");return e?e:"";};Object.defineProperty(H.prototype,"fontFamily",{get:function(){return this._legacyFontType.fontFamily;},set:function(v){this._legacyFontType.fontFamily=v;},enumerable:false,configurable:true});Object.defineProperty(H.prototype,"fontSizes",{get:function(){return this._legacyFontType.fontSizes;},enumerable:false,configurable:true});Object.defineProperty(H.prototype,"fontWeights",{get:function(){return this._legacyFontType.fontWeights;},enumerable:false,configurable:true});return H;}());a.HostConfig=H;a.defaultHostConfig=new H({supportsInteractivity:true,spacing:{small:10,default:20,medium:30,large:40,extraLarge:50,padding:20},separator:{lineThickness:1,lineColor:"#EEEEEE"},fontTypes:{default:{fontFamily:"'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",fontSizes:{small:12,default:14,medium:17,large:21,extraLarge:26},fontWeights:{lighter:200,default:400,bolder:600}},monospace:{fontFamily:"'Courier New', Courier, monospace",fontSizes:{small:12,default:14,medium:17,large:21,extraLarge:26},fontWeights:{lighter:200,default:400,bolder:600}}},imageSizes:{small:40,medium:80,large:160},containerStyles:{default:{backgroundColor:"#FFFFFF",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}},emphasis:{backgroundColor:"#08000000",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}},accent:{backgroundColor:"#C7DEF9",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}},good:{backgroundColor:"#CCFFCC",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}},attention:{backgroundColor:"#FFC5B2",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}},warning:{backgroundColor:"#FFE2B2",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#028A02",subtle:"#DD027502"},warning:{default:"#e69500",subtle:"#DDe69500"}}}},inputs:{label:{requiredInputs:{color:E.TextColor.Accent,size:E.TextSize.ExtraLarge,weight:E.TextWeight.Bolder,isSubtle:true,suffix:" (required)",suffixColor:E.TextColor.Good},optionalInputs:{color:E.TextColor.Warning,size:E.TextSize.Medium,weight:E.TextWeight.Lighter,isSubtle:false}},errorMessage:{color:E.TextColor.Accent,size:E.TextSize.Small,weight:E.TextWeight.Bolder}},actions:{maxActions:5,spacing:E.Spacing.Default,buttonSpacing:10,showCard:{actionMode:E.ShowCardActionMode.Inline,inlineTopMargin:16},actionsOrientation:E.Orientation.Horizontal,actionAlignment:E.ActionAlignment.Left},adaptiveCard:{allowCustomStyle:false},imageSet:{imageSize:E.Size.Medium,maxImageHeight:100},factSet:{title:{color:E.TextColor.Default,size:E.TextSize.Default,isSubtle:false,weight:E.TextWeight.Bolder,wrap:true,maxWidth:150,},value:{color:E.TextColor.Default,size:E.TextSize.Default,isSubtle:false,weight:E.TextWeight.Default,wrap:true,},spacing:10}});}),"./src/registry.ts":(function(m,a,_){"use strict";Object.defineProperty(a,"__esModule",{value:true});a.CardObjectRegistry=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var s=_("./src/serialization.ts");var C=(function(){function C(){this._items={};}C.prototype.findByName=function(t){return this._items.hasOwnProperty(t)?this._items[t]:undefined;};C.prototype.clear=function(){this._items={};};C.prototype.register=function(t,o,b){if(b===void 0){b=s.Versions.v1_0;}var r=this.findByName(t);if(r!==undefined){r.objectType=o;}else{r={typeName:t,objectType:o,schemaVersion:b};}this._items[t]=r;};C.prototype.unregister=function(t){delete this._items[t];};C.prototype.createInstance=function(t,b){var r=this.findByName(t);return(r&&r.schemaVersion.compareTo(b)<=0)?new r.objectType():undefined;};C.prototype.getItemCount=function(){return Object.keys(this._items).length;};C.prototype.getItemAt=function(i){var b=this;return Object.keys(this._items).map(function(e){return b._items[e];})[i];};return C;}());a.CardObjectRegistry=C;}),"./src/serialization.ts":(function(m,e,_){"use strict";var a=(this&&this.__extends)||(function(){var i=function(d,b){i=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return i(d,b);};return function(d,b){i(d,b);function p(){this.constructor=d;}d.prototype=b===null?Object.create(b):(p.prototype=b.prototype,new p());};})();Object.defineProperty(e,"__esModule",{value:true});e.SerializableObject=e.property=e.SerializableObjectSchema=e.CustomProperty=e.SerializableObjectCollectionProperty=e.SerializableObjectProperty=e.EnumProperty=e.ValueSetProperty=e.StringArrayProperty=e.PixelSizeProperty=e.NumProperty=e.BoolProperty=e.StringProperty=e.PropertyDefinition=e.BaseSerializationContext=e.isVersionLessOrEqual=e.Versions=e.Version=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var c=_("./src/shared.ts");var U=_("./src/utils.ts");var E=_("./src/enums.ts");var f=_("./src/strings.ts");var V=(function(){function V(b,d,i){if(b===void 0){b=1;}if(d===void 0){d=1;}this._isValid=true;this._major=b;this._minor=d;this._label=i;}V.parse=function(b,d){if(!b){return undefined;}var i=new V();i._versionString=b;var p=/(\d+).(\d+)/gi;var s=p.exec(b);if(s!=null&&s.length==3){i._major=parseInt(s[1]);i._minor=parseInt(s[2]);}else{i._isValid=false;}if(!i._isValid){d.logParseEvent(undefined,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidVersionString(i._versionString));}return i;};V.prototype.toString=function(){return!this._isValid?this._versionString:this._major+"."+this._minor;};V.prototype.toJSON=function(){return this.toString();};V.prototype.compareTo=function(b){if(!this.isValid||!b.isValid){throw new Error("Cannot compare invalid version.");}if(this.major>b.major){return 1;}else if(this.major<b.major){return-1;}else if(this.minor>b.minor){return 1;}else if(this.minor<b.minor){return-1;}return 0;};Object.defineProperty(V.prototype,"label",{get:function(){return this._label?this._label:this.toString();},enumerable:false,configurable:true});Object.defineProperty(V.prototype,"major",{get:function(){return this._major;},enumerable:false,configurable:true});Object.defineProperty(V.prototype,"minor",{get:function(){return this._minor;},enumerable:false,configurable:true});Object.defineProperty(V.prototype,"isValid",{get:function(){return this._isValid;},enumerable:false,configurable:true});return V;}());e.Version=V;var g=(function(){function g(){}g.v1_0=new V(1,0);g.v1_1=new V(1,1);g.v1_2=new V(1,2);g.v1_3=new V(1,3);g.v1_4=new V(1,4);g.latest=g.v1_4;return g;}());e.Versions=g;function h(b,d){if(b instanceof V){if(d instanceof V){return d.compareTo(b)>=0;}else{return true;}}else{return true;}}e.isVersionLessOrEqual=h;var B=(function(){function B(b){if(b===void 0){b=g.latest;}this.targetVersion=b;this._validationEvents=[];}B.prototype.serializeValue=function(b,p,d,i,s){if(i===void 0){i=undefined;}if(s===void 0){s=false;}if(d===null||d===undefined||d===i){if(!c.GlobalSettings.enableFullJsonRoundTrip||s){delete b[p];}}else{b[p]=d;}};B.prototype.serializeString=function(b,p,d,i){if(d===null||d===undefined||d===i){delete b[p];}else{b[p]=d;}};B.prototype.serializeBool=function(b,p,d,i){if(d===null||d===undefined||d===i){delete b[p];}else{b[p]=d;}};B.prototype.serializeNumber=function(b,p,d,i){if(d===null||d===undefined||d===i||isNaN(d)){delete b[p];}else{b[p]=d;}};B.prototype.serializeEnum=function(b,d,p,i,s){if(s===void 0){s=undefined;}var x=d[p];var y=x==undefined?true:b[x]!==undefined;if(i==s){if(y){delete d[p];}}else{if(i==undefined){if(y){delete d[p];}}else{d[p]=b[i];}}};B.prototype.serializeArray=function(b,p,d){var i=[];if(d){for(var s=0,x=d;s<x.length;s++){var y=x[s];var z=undefined;if(y instanceof w){z=y.toJSON(this);}else if(y.toJSON){z=y.toJSON();}else{z=y;}if(z!==undefined){i.push(z);}}}if(i.length==0){if(b.hasOwnProperty(p)&&Array.isArray(b[p])){delete b[p];}}else{this.serializeValue(b,p,i);}};B.prototype.clearEvents=function(){this._validationEvents=[];};B.prototype.logEvent=function(s,p,b,d){this._validationEvents.push({source:s,phase:p,event:b,message:d});};B.prototype.logParseEvent=function(s,b,d){this.logEvent(s,E.ValidationPhase.Parse,b,d);};B.prototype.getEventAt=function(i){return this._validationEvents[i];};Object.defineProperty(B.prototype,"eventCount",{get:function(){return this._validationEvents.length;},enumerable:false,configurable:true});return B;}());e.BaseSerializationContext=B;var S=(function(b){a(S,b);function S(){return b!==null&&b.apply(this,arguments)||this;}return S;}(B));var P=(function(){function P(b,d,i,p){this.targetVersion=b;this.name=d;this.defaultValue=i;this.onGetInitialValue=p;this.isSerializationEnabled=true;this.sequentialNumber=P._sequentialNumber;P._sequentialNumber++;}P.prototype.getInternalName=function(){return this.name;};P.prototype.parse=function(s,b,d){return b[this.name];};P.prototype.toJSON=function(s,b,d,i){i.serializeValue(b,this.name,d,this.defaultValue);};P._sequentialNumber=0;return P;}());e.PropertyDefinition=P;var j=(function(b){a(j,b);function j(d,i,p,s,x,y){if(p===void 0){p=true;}var z=b.call(this,d,i,x,y)||this;z.targetVersion=d;z.name=i;z.treatEmptyAsUndefined=p;z.regEx=s;z.defaultValue=x;z.onGetInitialValue=y;return z;}j.prototype.parse=function(s,d,i){var p=U.parseString(d[this.name],this.defaultValue);var x=p===undefined||(p===""&&this.treatEmptyAsUndefined);if(!x&&this.regEx!==undefined){var y=this.regEx.exec(p);if(!y){i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidPropertyValue(p,this.name));return undefined;}}return p;};j.prototype.toJSON=function(s,d,i,p){p.serializeString(d,this.name,i===""&&this.treatEmptyAsUndefined?undefined:i,this.defaultValue);};return j;}(P));e.StringProperty=j;var k=(function(b){a(k,b);function k(){return b!==null&&b.apply(this,arguments)||this;}k.prototype.parse=function(s,d,i){return U.parseBool(d[this.name],this.defaultValue);};k.prototype.toJSON=function(s,d,i,p){p.serializeBool(d,this.name,i,this.defaultValue);};return k;}(P));e.BoolProperty=k;var N=(function(b){a(N,b);function N(){return b!==null&&b.apply(this,arguments)||this;}N.prototype.parse=function(s,d,i){return U.parseNumber(d[this.name],this.defaultValue);};N.prototype.toJSON=function(s,d,i,p){p.serializeNumber(d,this.name,i,this.defaultValue);};return N;}(P));e.NumProperty=N;var l=(function(b){a(l,b);function l(){return b!==null&&b.apply(this,arguments)||this;}l.prototype.parse=function(s,d,i){var p=undefined;var x=d[this.name];if(typeof x==="string"){var y=false;try{var z=c.SizeAndUnit.parse(x,true);if(z.unit==E.SizeUnit.Pixel){p=z.physicalSize;y=true;}}catch(A){}if(!y){i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidPropertyValue(d[this.name],"minHeight"));}}return p;};l.prototype.toJSON=function(s,d,i,p){p.serializeValue(d,this.name,typeof i==="number"&&!isNaN(i)?i+"px":undefined);};return l;}(P));e.PixelSizeProperty=l;var n=(function(b){a(n,b);function n(d,i,p,s){var x=b.call(this,d,i,p,s)||this;x.targetVersion=d;x.name=i;x.defaultValue=p;x.onGetInitialValue=s;return x;}n.prototype.parse=function(s,d,i){var p=d[this.name];if(p===undefined||!Array.isArray(p)){return this.defaultValue;}var x=[];for(var y=0,z=p;y<z.length;y++){var A=z[y];if(typeof A==="string"){x.push(A);}else{i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,"Invalid array value \""+A+"\" of type \""+typeof A+"\" ignored for \""+this.name+"\".");}}return x;};n.prototype.toJSON=function(s,d,i,p){p.serializeArray(d,this.name,i);};return n;}(P));e.StringArrayProperty=n;var o=(function(b){a(o,b);function o(d,i,p,s,x){var y=b.call(this,d,i,s,x)||this;y.targetVersion=d;y.name=i;y.values=p;y.defaultValue=s;y.onGetInitialValue=x;return y;}o.prototype.isValidValue=function(d,i){for(var p=0,s=this.values;p<s.length;p++){var x=s[p];if(d.toLowerCase()===x.value.toLowerCase()){var y=x.targetVersion?x.targetVersion:this.targetVersion;return y.compareTo(i.targetVersion)<=0;}}return false;};o.prototype.parse=function(s,d,i){var p=d[this.name];if(p===undefined){return this.defaultValue;}if(typeof p==="string"){for(var x=0,y=this.values;x<y.length;x++){var z=y[x];if(p.toLowerCase()===z.value.toLowerCase()){var A=z.targetVersion?z.targetVersion:this.targetVersion;if(A.compareTo(i.targetVersion)<=0){return z.value;}else{i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.propertyValueNotSupported(p,this.name,A.toString(),i.targetVersion.toString()));return this.defaultValue;}}}}i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidPropertyValue(p,this.name));return this.defaultValue;};o.prototype.toJSON=function(s,d,i,p){var x=false;for(var y=0,z=this.values;y<z.length;y++){var A=z[y];if(A.value===i){var D=A.targetVersion?A.targetVersion:this.targetVersion;if(D.compareTo(p.targetVersion)<=0){x=true;break;}else{p.logEvent(s,E.ValidationPhase.ToJSON,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.propertyValueNotSupported(i,this.name,D.toString(),p.targetVersion.toString()));}}}if(x){p.serializeValue(d,this.name,i,this.defaultValue);}};return o;}(P));e.ValueSetProperty=o;var q=(function(b){a(q,b);function q(d,i,p,s,x,y){var z=b.call(this,d,i,s,y)||this;z.targetVersion=d;z.name=i;z.enumType=p;z.defaultValue=s;z.onGetInitialValue=y;z._values=[];if(!x){for(var A in p){var D=parseInt(A,10);if(D>=0){z._values.push({value:D});}}}else{z._values=x;}return z;}q.prototype.parse=function(s,d,i){var p=d[this.name];if(typeof p!=="string"){return this.defaultValue;}var x=U.getEnumValueByName(this.enumType,p);if(x!==undefined){for(var y=0,z=this.values;y<z.length;y++){var A=z[y];if(A.value===x){var D=A.targetVersion?A.targetVersion:this.targetVersion;if(D.compareTo(i.targetVersion)<=0){return x;}else{i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.propertyValueNotSupported(p,this.name,D.toString(),i.targetVersion.toString()));return this.defaultValue;}}}}i.logParseEvent(s,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidPropertyValue(p,this.name));return this.defaultValue;};q.prototype.toJSON=function(s,d,i,p){if(i!==undefined){var x=false;for(var y=0,z=this.values;y<z.length;y++){var A=z[y];if(A.value===i){var D=A.targetVersion?A.targetVersion:this.targetVersion;if(D.compareTo(p.targetVersion)<=0){x=true;break;}else{p.logEvent(s,E.ValidationPhase.ToJSON,E.ValidationEvent.InvalidPropertyValue,f.Strings.errors.invalidPropertyValue(i,this.name));}}}if(x){p.serializeEnum(this.enumType,d,this.name,i,this.defaultValue);}}};Object.defineProperty(q.prototype,"values",{get:function(){return this._values;},enumerable:false,configurable:true});return q;}(P));e.EnumProperty=q;var r=(function(b){a(r,b);function r(d,i,p,s,x){if(s===void 0){s=false;}var y=b.call(this,d,i,x,function(z){return y.nullable?undefined:new y.objectType();})||this;y.targetVersion=d;y.name=i;y.objectType=p;y.nullable=s;return y;}r.prototype.parse=function(s,d,i){var p=d[this.name];if(p===undefined){return this.onGetInitialValue?this.onGetInitialValue(s):this.defaultValue;}var x=new this.objectType();x.parse(p,i);return x;};r.prototype.toJSON=function(s,d,i,p){var x=undefined;if(i!==undefined&&!i.hasAllDefaultValues()){x=i.toJSON(p);}if(typeof x==="object"&&Object.keys(x).length===0){x=undefined;}p.serializeValue(d,this.name,x,this.defaultValue,true);};return r;}(P));e.SerializableObjectProperty=r;var t=(function(b){a(t,b);function t(d,i,p,s){var x=b.call(this,d,i,undefined,function(y){return[];})||this;x.targetVersion=d;x.name=i;x.objectType=p;x.onItemAdded=s;return x;}t.prototype.parse=function(s,d,i){var p=[];var x=d[this.name];if(Array.isArray(x)){for(var y=0,z=x;y<z.length;y++){var A=z[y];var D=new this.objectType();D.parse(A,i);p.push(D);if(this.onItemAdded){this.onItemAdded(s,D);}}}return p.length>0?p:(this.onGetInitialValue?this.onGetInitialValue(s):undefined);};t.prototype.toJSON=function(s,d,i,p){p.serializeArray(d,this.name,i);};return t;}(P));e.SerializableObjectCollectionProperty=t;var C=(function(b){a(C,b);function C(d,i,p,s,x,y){var z=b.call(this,d,i,x,y)||this;z.targetVersion=d;z.name=i;z.onParse=p;z.onToJSON=s;z.defaultValue=x;z.onGetInitialValue=y;if(!z.onParse){throw new Error("CustomPropertyDefinition instances must have an onParse handler.");}if(!z.onToJSON){throw new Error("CustomPropertyDefinition instances must have an onToJSON handler.");}return z;}C.prototype.parse=function(s,d,i){return this.onParse(s,this,d,i);};C.prototype.toJSON=function(s,d,i,p){this.onToJSON(s,this,d,i,p);};return C;}(P));e.CustomProperty=C;var u=(function(){function u(){this._properties=[];}u.prototype.indexOf=function(v){for(var i=0;i<this._properties.length;i++){if(this._properties[i]===v){return i;}}return-1;};u.prototype.add=function(){var p=[];for(var b=0;b<arguments.length;b++){p[b]=arguments[b];}for(var i=0;i<p.length;i++){if(this.indexOf(p[i])===-1){this._properties.push(p[i]);}}};u.prototype.remove=function(){var p=[];for(var b=0;b<arguments.length;b++){p[b]=arguments[b];}for(var d=0,i=p;d<i.length;d++){var s=i[d];while(true){var x=this.indexOf(s);if(x>=0){this._properties.splice(x,1);}else{break;}}}};u.prototype.getItemAt=function(i){return this._properties[i];};u.prototype.getCount=function(){return this._properties.length;};return u;}());e.SerializableObjectSchema=u;function v(v){return function(b,p){var d=Object.getOwnPropertyDescriptor(b,p)||{};if(!d.get&&!d.set){d.get=function(){return this.getValue(v);};d.set=function(i){this.setValue(v,i);};Object.defineProperty(b,p,d);}};}e.property=v;var w=(function(){function w(){this._propertyBag={};this._rawProperties={};this.maxVersion=w.defaultMaxVersion;var s=this.getSchema();for(var i=0;i<s.getCount();i++){var p=s.getItemAt(i);if(p.onGetInitialValue){this.setValue(p,p.onGetInitialValue(this));}}}w.prototype.getDefaultSerializationContext=function(){return new S();};w.prototype.populateSchema=function(s){var b=this.constructor;var p=[];for(var d in b){try{var i=b[d];if(i instanceof P){p.push(i);}}catch(x){}}if(p.length>0){var y=p.sort(function(z,A){if(z.sequentialNumber>A.sequentialNumber){return 1;}else if(z.sequentialNumber<A.sequentialNumber){return-1;}return 0;});s.add.apply(s,y);}if(w.onRegisterCustomProperties){w.onRegisterCustomProperties(this,s);}};w.prototype.getValue=function(v){return this._propertyBag.hasOwnProperty(v.getInternalName())?this._propertyBag[v.getInternalName()]:v.defaultValue;};w.prototype.setValue=function(v,b){if(b===undefined||b===null){delete this._propertyBag[v.getInternalName()];}else{this._propertyBag[v.getInternalName()]=b;}};w.prototype.internalParse=function(b,d){this._propertyBag={};this._rawProperties=c.GlobalSettings.enableFullJsonRoundTrip?(b?b:{}):{};if(b){var s=this.getSchema();for(var i=0;i<s.getCount();i++){var p=s.getItemAt(i);if(p.isSerializationEnabled){var x=p.onGetInitialValue?p.onGetInitialValue(this):undefined;if(b.hasOwnProperty(p.name)){if(p.targetVersion.compareTo(d.targetVersion)<=0){x=p.parse(this,b,d);}else{d.logParseEvent(this,E.ValidationEvent.UnsupportedProperty,f.Strings.errors.propertyNotSupported(p.name,p.targetVersion.toString(),d.targetVersion.toString()));}}this.setValue(p,x);}}}else{this.resetDefaultValues();}};w.prototype.internalToJSON=function(b,d){var s=this.getSchema();var p=[];for(var i=0;i<s.getCount();i++){var x=s.getItemAt(i);if(x.isSerializationEnabled&&x.targetVersion.compareTo(d.targetVersion)<=0&&p.indexOf(x.name)===-1){x.toJSON(this,b,this.getValue(x),d);p.push(x.name);}}};w.prototype.shouldSerialize=function(b){return true;};w.prototype.parse=function(s,b){this.internalParse(s,b?b:new S());};w.prototype.toJSON=function(b){var d;if(b&&b instanceof B){d=b;}else{d=this.getDefaultSerializationContext();d.toJSONOriginalParam=b;}if(this.shouldSerialize(d)){var i=void 0;if(c.GlobalSettings.enableFullJsonRoundTrip&&this._rawProperties&&typeof this._rawProperties==="object"){i=this._rawProperties;}else{i={};}this.internalToJSON(i,d);return i;}else{return undefined;}};w.prototype.hasDefaultValue=function(v){return this.getValue(v)===v.defaultValue;};w.prototype.hasAllDefaultValues=function(){var s=this.getSchema();for(var i=0;i<s.getCount();i++){var p=s.getItemAt(i);if(!this.hasDefaultValue(p)){return false;}}return true;};w.prototype.resetDefaultValues=function(){var s=this.getSchema();for(var i=0;i<s.getCount();i++){var p=s.getItemAt(i);this.setValue(p,p.defaultValue);}};w.prototype.setCustomProperty=function(b,d){var s=(typeof d==="string"&&!d)||d===undefined||d===null;if(s){delete this._rawProperties[b];}else{this._rawProperties[b]=d;}};w.prototype.getCustomProperty=function(b){return this._rawProperties[b];};w.prototype.getSchema=function(){var s=w._schemaCache[this.getSchemaKey()];if(!s){s=new u();this.populateSchema(s);w._schemaCache[this.getSchemaKey()]=s;}return s;};w.defaultMaxVersion=g.v1_3;w._schemaCache={};return w;}());e.SerializableObject=w;}),"./src/shared.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.UUID=e.SizeAndUnit=e.PaddingDefinition=e.SpacingDefinition=e.StringWithSubstitutions=e.ContentTypes=e.GlobalSettings=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var G=(function(){function G(){}G.useAdvancedTextBlockTruncation=true;G.useAdvancedCardBottomTruncation=false;G.useMarkdownInRadioButtonAndCheckbox=true;G.allowMarkForTextHighlighting=false;G.alwaysBleedSeparators=false;G.enableFullJsonRoundTrip=false;G.displayInputValidationErrors=true;G.allowPreProcessingPropertyValues=false;G.setTabIndexAtCardRoot=true;G.enableFallback=true;G.useWebkitLineClamp=true;G.applets={logEnabled:true,logLevel:E.LogLevel.Error,maximumRetryAttempts:3,defaultTimeBetweenRetryAttempts:3000,authPromptWidth:400,authPromptHeight:600,refresh:{mode:E.RefreshMode.Manual,timeBetweenAutomaticRefreshes:3000,maximumConsecutiveAutomaticRefreshes:3,allowManualRefreshesAfterAutomaticRefreshes:true}};return G;}());e.GlobalSettings=G;e.ContentTypes={applicationJson:"application/json",applicationXWwwFormUrlencoded:"application/x-www-form-urlencoded"};var S=(function(){function S(){this._isProcessed=false;}S.prototype.getReferencedInputs=function(i,r){if(!r){throw new Error("The referencedInputs parameter cannot be null.");}for(var c=0,d=i;c<d.length;c++){var f=d[c];var g=new RegExp("\\{{2}("+f.id+").value\\}{2}","gi").exec(this._original);if(g!=null&&f.id){r[f.id]=f;}}};S.prototype.substituteInputValues=function(i,c){this._processed=this._original;if(this._original){var r=/\{{2}([a-z0-9_$@]+).value\}{2}/gi;var d=void 0;while((d=r.exec(this._original))!==null){for(var f=0,g=Object.keys(i);f<g.length;f++){var k=g[f];if(k.toLowerCase()==d[1].toLowerCase()){var h=i[k];var v="";if(h.value){v=h.value;}if(c===e.ContentTypes.applicationJson){v=JSON.stringify(v);v=v.slice(1,-1);}else if(c===e.ContentTypes.applicationXWwwFormUrlencoded){v=encodeURIComponent(v);}this._processed=this._processed.replace(d[0],v);break;}}}}this._isProcessed=true;};S.prototype.getOriginal=function(){return this._original;};S.prototype.get=function(){if(!this._isProcessed){return this._original;}else{return this._processed;}};S.prototype.set=function(v){this._original=v;this._isProcessed=false;};return S;}());e.StringWithSubstitutions=S;var a=(function(){function a(t,r,c,l){if(t===void 0){t=0;}if(r===void 0){r=0;}if(c===void 0){c=0;}if(l===void 0){l=0;}this.left=0;this.top=0;this.right=0;this.bottom=0;this.top=t;this.right=r;this.bottom=c;this.left=l;}return a;}());e.SpacingDefinition=a;var P=(function(){function P(t,r,c,l){if(t===void 0){t=E.Spacing.None;}if(r===void 0){r=E.Spacing.None;}if(c===void 0){c=E.Spacing.None;}if(l===void 0){l=E.Spacing.None;}this.top=E.Spacing.None;this.right=E.Spacing.None;this.bottom=E.Spacing.None;this.left=E.Spacing.None;this.top=t;this.right=r;this.bottom=c;this.left=l;}return P;}());e.PaddingDefinition=P;var b=(function(){function b(p,u){this.physicalSize=p;this.unit=u;}b.parse=function(i,r){if(r===void 0){r=false;}var c=new b(0,E.SizeUnit.Weight);if(typeof i==="number"){c.physicalSize=i;return c;}else if(typeof i==="string"){var d=/^([0-9]+)(px|\*)?$/g;var f=d.exec(i);var g=r?3:2;if(f&&f.length>=g){c.physicalSize=parseInt(f[1]);if(f.length==3){if(f[2]=="px"){c.unit=E.SizeUnit.Pixel;}}return c;}}throw new Error("Invalid size: "+i);};return b;}());e.SizeAndUnit=b;
/**
 * Fast UUID generator, RFC4122 version 4 compliant.
 * @author Jeff Ward (jcward.com).
 * @license MIT license
 * @link http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
 **/
var U=(function(){function U(){}U.generate=function(){var d=Math.random()*0xffffffff|0;var c=Math.random()*0xffffffff|0;var f=Math.random()*0xffffffff|0;var g=Math.random()*0xffffffff|0;return U.lut[d&0xff]+U.lut[d>>8&0xff]+U.lut[d>>16&0xff]+U.lut[d>>24&0xff]+'-'+U.lut[c&0xff]+U.lut[c>>8&0xff]+'-'+U.lut[c>>16&0x0f|0x40]+U.lut[c>>24&0xff]+'-'+U.lut[f&0x3f|0x80]+U.lut[f>>8&0xff]+'-'+U.lut[f>>16&0xff]+U.lut[f>>24&0xff]+U.lut[g&0xff]+U.lut[g>>8&0xff]+U.lut[g>>16&0xff]+U.lut[g>>24&0xff];};U.initialize=function(){for(var i=0;i<256;i++){U.lut[i]=(i<16?'0':'')+i.toString(16);}};U.lut=[];return U;}());e.UUID=U;U.initialize();}),"./src/strings.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.Strings=void 0;var S=(function(){function S(){}S.errors={unknownElementType:function(t){return"Unknown element type \""+t+"\". Fallback will be used if present.";},unknownActionType:function(t){return"Unknown action type \""+t+"\". Fallback will be used if present.";},elementTypeNotAllowed:function(t){return"Element type \""+t+"\" is not allowed in this context.";},actionTypeNotAllowed:function(t){return"Action type \""+t+"\" is not allowed in this context.";},invalidPropertyValue:function(v,p){return"Invalid value \""+v+"\" for property \""+p+"\".";},showCardMustHaveCard:function(){return"\"An Action.ShowCard must have its \"card\" property set to a valid AdaptiveCard object.";},invalidColumnWidth:function(i){return"Invalid column width \""+i+"\" - defaulting to \"auto\".";},invalidCardVersion:function(d){return"Invalid card version. Defaulting to \""+d+"\".";},invalidVersionString:function(v){return"Invalid version string \""+v+"\".";},propertyValueNotSupported:function(v,p,s,a){return"Value \""+v+"\" for property \""+p+"\" is supported in version "+s+", but you are using version "+a+".";},propertyNotSupported:function(p,s,v){return"Property \""+p+"\" is supported in version "+s+", but you are using version "+v+".";},indexOutOfRange:function(i){return"Index out of range ("+i+").";},elementCannotBeUsedAsInline:function(){return"RichTextBlock.addInline: the specified card element cannot be used as a RichTextBlock inline.";},inlineAlreadyParented:function(){return"RichTextBlock.addInline: the specified inline already belongs to another RichTextBlock.";},interactivityNotAllowed:function(){return"Interactivity is not allowed.";},inputsMustHaveUniqueId:function(){return"All inputs must have a unique Id.";},choiceSetMustHaveAtLeastOneChoice:function(){return"An Input.ChoiceSet must have at least one choice defined.";},choiceSetChoicesMustHaveTitleAndValue:function(){return"All choices in an Input.ChoiceSet must have their title and value properties set.";},propertyMustBeSet:function(p){return"Property \""+p+"\" must be set.";},actionHttpHeadersMustHaveNameAndValue:function(){return"All headers of an Action.Http must have their name and value properties set.";},tooManyActions:function(a){return"Maximum number of actions exceeded ("+a+").";},columnAlreadyBelongsToAnotherSet:function(){return"This column already belongs to another ColumnSet.";},invalidCardType:function(){return"Invalid or missing card type. Make sure the card's type property is set to \"AdaptiveCard\".";},unsupportedCardVersion:function(v,a){return"The specified card version ("+v+") is not supported. The maximum supported card version is "+a+".";},duplicateId:function(i){return"Duplicate Id \""+i+"\".";},markdownProcessingNotEnabled:function(){return"Markdown processing isn't enabled. Please see https://www.npmjs.com/package/adaptivecards#supporting-markdown";},processMarkdownEventRemoved:function(){return"The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead.";},elementAlreadyParented:function(){return"The element already belongs to another container.";},actionAlreadyParented:function(){return"The action already belongs to another element.";},elementTypeNotStandalone:function(t){return"Elements of type "+t+" cannot be used as standalone elements.";}};S.magicCodeInputCard={tryAgain:function(){return"That didn't work... let's try again.";},pleaseLogin:function(){return"Please login in the popup. You will obtain a magic code. Paste that code below and select \"Submit\"";},enterMagicCode:function(){return"Enter magic code";},pleaseEnterMagicCodeYouReceived:function(){return"Please enter the magic code you received.";},submit:function(){return"Submit";},cancel:function(){return"Cancel";},somethingWentWrong:function(){return"Something went wrong. This action can't be handled.";},authenticationFailed:function(){return"Authentication failed.";}};S.runtime={automaticRefreshPaused:function(){return"Automatic refresh paused.";},clckToRestartAutomaticRefresh:function(){return"Click to restart.";},refreshThisCard:function(){return"Refresh this card";}};S.hints={dontUseWeightedAndStrecthedColumnsInSameSet:function(){return"It is not recommended to use weighted and stretched columns in the same ColumnSet, because in such a situation stretched columns will always get the minimum amount of space.";}};S.defaults={inlineActionTitle:function(){return"Inline Action";},mediaPlayerAriaLabel:function(){return"Media content";},mediaPlayerPlayMedia:function(){return"Play media";}};return S;}());e.Strings=S;}),"./src/text-formatters.ts":(function(m,e,_){"use strict";var a=(this&&this.__extends)||(function(){var c=function(d,b){c=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return c(d,b);};return function(d,b){c(d,b);function g(){this.constructor=d;}d.prototype=b===null?Object.create(b):(g.prototype=b.prototype,new g());};})();Object.defineProperty(e,"__esModule",{value:true});e.formatText=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var A=(function(){function A(r){this._regularExpression=r;}A.prototype.format=function(l,i){var b;if(i){var r=i;while((b=this._regularExpression.exec(i))!=null){r=r.replace(b[0],this.internalFormat(l,b));};return r;}else{return i;}};return A;}());var D=(function(b){a(D,b);function D(){return b!==null&&b.apply(this,arguments)||this;}D.prototype.internalFormat=function(l,c){var d=new Date(Date.parse(c[1]));var g=c[2]!=undefined?c[2].toLowerCase():"compact";if(g!="compact"){return d.toLocaleDateString(l,{day:"numeric",weekday:g,month:g,year:"numeric"});}else{return d.toLocaleDateString();}};return D;}(A));var T=(function(b){a(T,b);function T(){return b!==null&&b.apply(this,arguments)||this;}T.prototype.internalFormat=function(l,c){var d=new Date(Date.parse(c[1]));return d.toLocaleTimeString(l,{hour:'numeric',minute:'2-digit'});};return T;}(A));function f(l,t){var b=[new D(/\{{2}DATE\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))(?:, ?(COMPACT|LONG|SHORT))?\)\}{2}/g),new T(/\{{2}TIME\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))\)\}{2}/g)];var r=t;for(var c=0,d=b;c<d.length;c++){var g=d[c];r=g.format(l,r);}return r;}e.formatText=f;}),"./src/utils.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.clearElementChildren=e.getFitStatus=e.truncate=e.stringToCssColor=e.renderSeparation=e.parseEnum=e.getEnumValueByName=e.parseBool=e.parseNumber=e.parseString=e.appendChild=e.generateUniqueId=e.isMobileOS=e.isInternetExplorer=void 0;
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var S=_("./src/shared.ts");function i(){return window.document.documentMode!==undefined;}e.isInternetExplorer=i;function c(){var a=window.navigator.userAgent;return!!a.match(/Android/i)||!!a.match(/iPad/i)||!!a.match(/iPhone/i);}e.isMobileOS=c;function d(){return"__ac-"+S.UUID.generate();}e.generateUniqueId=d;function f(a,b){if(b){a.appendChild(b);}}e.appendChild=f;function p(a,b){return typeof a==="string"?a:b;}e.parseString=p;function h(a,b){return typeof a==="number"?a:b;}e.parseNumber=h;function j(a,b){if(typeof a==="boolean"){return a;}else if(typeof a==="string"){switch(a.toLowerCase()){case"true":return true;case"false":return false;default:return b;}}return b;}e.parseBool=j;function k(a,b){for(var g in a){var r=parseInt(g,10);if(r>=0){var w=a[g];if(w&&typeof w==="string"&&w.toLowerCase()===b.toLowerCase()){return r;}}}return undefined;}e.getEnumValueByName=k;function l(a,b,g){if(!b){return g;}var r=k(a,b);return r!==undefined?r:g;}e.parseEnum=l;function n(a,b,g){if(b.spacing>0||(b.lineThickness&&b.lineThickness>0)){var r=document.createElement("div");r.className=a.makeCssClassName("ac-"+(g==E.Orientation.Horizontal?"horizontal":"vertical")+"-separator");r.setAttribute("aria-hidden","true");var w=b.lineColor?s(b.lineColor):"";if(g==E.Orientation.Horizontal){if(b.lineThickness){r.style.paddingTop=(b.spacing/2)+"px";r.style.marginBottom=(b.spacing/2)+"px";r.style.borderBottom=b.lineThickness+"px solid "+w;}else{r.style.height=b.spacing+"px";}}else{if(b.lineThickness){r.style.paddingLeft=(b.spacing/2)+"px";r.style.marginRight=(b.spacing/2)+"px";r.style.borderRight=b.lineThickness+"px solid "+w;}else{r.style.width=b.spacing+"px";}}r.style.overflow="hidden";r.style.flex="0 0 auto";return r;}else{return undefined;}}e.renderSeparation=n;function s(w){if(w){var x=/#([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})?/gi;var y=x.exec(w);if(y&&y[4]){var a=parseInt(y[1],16)/255;var r=parseInt(y[2],16);var g=parseInt(y[3],16);var b=parseInt(y[4],16);return"rgba("+r+","+g+","+b+","+a+")";}}return w;}e.stringToCssColor=s;function t(a,b,g){var r=function(){return b-a.scrollHeight>=-1.0;};if(r())return;var w=a.innerHTML;var x=function(D){a.innerHTML=w.substring(0,D)+'...';};var y=o(w);var z=0;var A=y.length;var B=0;while(z<A){var C=Math.floor((z+A)/2);x(y[C]);if(r()){B=y[C];z=C+1;}else{A=C;}}x(B);if(g&&b-a.scrollHeight>=g-1.0){var D=q(w,B);while(D<w.length){x(D);if(r()){B=D;D=q(w,D);}else{break;}}x(B);}}e.truncate=t;function o(a){var r=[];var b=q(a,-1);while(b<a.length){if(a[b]==' '){r.push(b);}b=q(a,b);}return r;}function q(a,b){b+=1;while(b<a.length&&a[b]=='<'){while(b<a.length&&a[b++]!='>');}return b;}function u(a,b){var g=a.offsetTop;var r=g+a.clientHeight;if(r<=b){return E.ContainerFitStatus.FullyInContainer;}else if(g<b){return E.ContainerFitStatus.Overflowing;}else{return E.ContainerFitStatus.FullyOutOfContainer;}}e.getFitStatus=u;function v(a){while(a.firstChild){a.removeChild(a.firstChild);}}e.clearElementChildren=v;})});});
