/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/ui/core/Core","sap/base/util/merge"],function(R,L,C,m){"use strict";var S=31536000;function g(r){var u=r.url,d=r.data,U,p;if(r.method!=="GET"){return r.url;}U=new URL(u,window.location.href);for(p in d){U.searchParams.set(p,d[p]);}return U.href;}var a=R.extend("sap.ui.integration.util.CacheAndRequestDataProvider",{metadata:{associations:{host:{type:"sap.ui.integration.Host",multiple:false},card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});a.prototype.init=function(){this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this);};a.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();R.prototype.destroy.apply(this,arguments);};a.prototype.getHostInstance=function(){return C.byId(this.getHost());};a.prototype.getCardInstance=function(){return C.byId(this.getCard());};a.prototype.getCardInstanceHeader=function(){var c=this.getCardInstance();if(!c){return null;}return c.getCardHeader();};a.prototype.onDataRequestComplete=function(){var i;if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null;}if(!this._oSettings||!this._oSettings.updateInterval){return;}i=parseInt(this._oSettings.updateInterval);if(isNaN(i)){return;}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache();}.bind(this),i*1000);};a.prototype._request=function(r){var p,c=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=g(r);this._subscribeToHostMessages();p=R.prototype._request.apply(this,arguments);p.then(function(v){var j=v[1],d=j.getResponseHeader("Date");if(d&&c){this._attachTimestampPress();c.setDataTimestamp((new Date(d)).toISOString());}}.bind(this));return p;};a.prototype.refreshWithoutCache=function(){var c=this.getCardInstanceHeader();if(c){c.setDataTimestampUpdating(true);}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate();}.bind(this),200);};a.prototype.refreshFromCache=function(){var c=this.getCardInstanceHeader();if(c){c.setDataTimestampUpdating(true);}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate();}.bind(this),200);};a.prototype._prepareHeaders=function(h,s){var c=this.getCardInstance(),H=this.getHostInstance(),d={enabled:true,maxAge:0,staleWhileRevalidate:true},n=m({request:{cache:d}},s),o=n.request.cache;if(o.noStore){o.enabled=false;}if(o.enabled){if(this._bCacheOnly){o.maxAge=S;o.staleWhileRevalidate=false;}else if(this._bNoCache){o.maxAge=0;o.staleWhileRevalidate=false;}}n.request.cache=o;if(H&&H.modifyRequestHeaders){return H.modifyRequestHeaders(Object.assign({},h),n,c);}return h;};a.prototype._subscribeToHostMessages=function(){var h=this.getHostInstance();if(this._bIsSubscribed){return;}if(!h){return;}h.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true;};a.prototype._unsubscribeFromHostMessages=function(){var h=this.getHostInstance();if(!h){return;}h.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false;};a.prototype._handleHostMessage=function(e){var d=e.getParameter("data");if(d.type!=="ui-integration-card-update"){return;}if(d.url!==this._sCurrentRequestFullUrl){return;}L.info("[CARDS CACHE] message ui-integration-card-update received for "+d.url);this.refreshFromCache();};a.prototype._attachTimestampPress=function(e){var c=this.getCardInstance(),h=this.getCardInstanceHeader();if(this._oHeaderDelegate){return;}if(!h){return;}this._oHeaderDelegate={onBeforeRendering:function(){var $=c.$().find(".sapFCardDataTimestamp");$.off("click",this._oRefreshWithoutCacheBound);}.bind(this),onAfterRendering:function(){var $=c.$().find(".sapFCardDataTimestamp");$.on("click",this._oRefreshWithoutCacheBound);}.bind(this)};h.addEventDelegate(this._oHeaderDelegate);};a.prototype._detachTimestampPress=function(e){var c=this.getCardInstance(),h=this.getCardInstanceHeader(),$=c&&c.$().find(".sapFCardDataTimestamp");if(!h){return;}$.off("click",this._oRefreshWithoutCacheBound);h.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null;};return a;});
