/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BindingResolver","../library","sap/base/Log","sap/ui/util/openWindow","sap/ui/base/ManagedObject","sap/base/strings/capitalize"],function(B,l,L,o,M,c){"use strict";function _(s){if(s&&typeof s==="object"){return s.name;}return s;}var A=l.CardActionArea,C=l.CardActionType;var a=M.extend("sap.ui.integration.util.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});a.prototype.attach=function(b){var d=b.control,s=b.area;b.actionControl=b.actionControl||b.control;b.enabledPropertyValue=b.enabledPropertyValue||true;b.disabledPropertyValue=b.disabledPropertyValue||false;b.eventName=b.eventName||"press";if(!b.actions){this._fireActionReady(d,s);return;}var e=b.actions[0];if(e&&e.type){b.action=e;this._attachAction(b);}else{this._fireActionReady(d,s);}};a.prototype._attachAction=function(b){var d=b.action,s=b.area,e=b.control,f=b.actionControl,E=b.enabledPropertyName,v=b.enabledPropertyValue,D=b.disabledPropertyValue,g=true,S=this._isSingleAction(s),h=true;if(E){g=false;if(d.service&&!S){this._setControlEnabledStateUsingService(d,e,f,E,v,D);}else{this._setControlEnabledState(d,f,E,v,D);}}if(d.service&&S){this._getSingleActionEnabledState(d,e).then(function(i){if(i){this._attachEventListener(b);}this._fireActionReady(e,s);}.bind(this));return;}if(g){h=d.enabled!==false&&d.enabled!=="false";}if(h){this._attachEventListener(b);}this._fireActionReady(e,s);};a.prototype._setControlEnabledStateUsingService=function(b,d,e,p,E,D){var f=M.bindingParser("{path:''}");f.formatter=function(v){var g=this.getBindingContext(),P,m;if(g){P=g.getPath();}m=B.resolveValue(b.parameters,d,P);if(v.__resolved){if(!v.__enabled||v.__enabled==="false"){return D;}return E;}if(!v.__promise){v.__promise=true;d._oServiceManager.getService(_(b.service)).then(function(n){if(n){n.enabled({parameters:m}).then(function(h){v.__resolved=true;v.__enabled=h;d.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return D;};e.bindProperty(p,f);};a.prototype._setControlEnabledState=function(b,d,p,e,D){var f,v;if(typeof b.enabled==="object"){f=b.enabled;f.formatter=function(V){if(!V||V==="false"){return D;}return e;};}if(f){d.bindProperty(p,f);}else{v=(b.enabled===false||b.enabled==="false")?D:e;d.setProperty(p,v);}};a.prototype._getSingleActionEnabledState=function(b,d){var e=d.getBindingContext(),p,P;if(e){P=e.getPath();}p=B.resolveValue(b.parameters,d,P);return new Promise(function(r){d._oServiceManager.getService(_(b.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};a.prototype._fireActionReady=function(b,s){var h=s===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";b.fireEvent(e);};a.prototype._resolveBindingPath=function(e){var b=e.getSource().getBindingContext(),p;if(this.getBindingPathResolver()){p=this.getBindingPathResolver()(e);}else if(b){p=b.getPath();}return p;};a.prototype._handleServiceAction=function(E,b,d){var s=E.getSource();var p=this._resolveBindingPath(E);d._oServiceManager.getService(_(b.service)).then(function(S){if(S){S.navigate({parameters:B.resolveValue(b.parameters,s,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,b,p);}.bind(this));};a.prototype._attachEventListener=function(b){var d=b.action;b.actionControl["attach"+c(b.eventName)](function(e){var s=e.getSource();if(d.service){this._handleServiceAction(e,d,b.control);}else{this._processAction(s,d,this._resolveBindingPath(e));}}.bind(this));};a.prototype._processAction=function(s,b,p){var h=this._getHostInstance(),d=this.getCard(),u=b.url;if(u){u=B.resolveValue(u,s,p);}a.fireAction({card:d,host:h,action:b,parameters:B.resolveValue(b.parameters,s,p),source:s,url:u});};a.prototype._getHostInstance=function(){var b=this.getCard();if(b){return b.getHostInstance();}return null;};a.prototype.fireAction=function(s,t,p){var h=this._getHostInstance(),b=this.getCard(),d=this._extractActionConfigurations(b,p),e={card:b,host:h,action:{type:t},parameters:d,source:s};a.fireAction(e);};a.fireAction=function(m){var h=m.host,b=m.card,e=b.getAggregation("_extension"),d=m.action,p=m.parameters||{},f={type:d.type,card:b,actionSource:m.source,parameters:p},g=Object.assign({},f,{manifestParameters:p}),i=b.fireAction(g);if(!i){return false;}if(h){i=h.fireAction(f);}if(!i){return false;}if(e){i=e.fireAction(f);}if(i){a._doPredefinedAction(m);}return i;};a._doPredefinedAction=function(m){var b=m.action,p=m.parameters,t=b.type,u,T,P,s;if(p){P=p.url;s=p.target;}switch(t){case C.Navigation:if(b.service){break;}u=m.url||P;T=b.target||s||"_blank";if(u){a.openUrl(u,T);}break;case C.Custom:if(typeof b.action==="function"){b.action(m.card,m.source);}break;case C.Submit:if(m.source&&m.source.isA("sap.ui.integration.cards.BaseContent")){a.handleSubmitAction(m);}break;default:break;}};a.openUrl=function(u,t){o(u,t);};a.handleSubmitAction=function(m){var d,b=m.card,D=b._oDataProviderFactory,e=m.source,f=m.parameters;if(!f.configuration){return;}e.onActionSubmitStart(f);d=D.create({request:f.configuration});d.getData().then(function(r){e.onActionSubmitEnd(r,null);},function(E){L.error(E);e.onActionSubmitEnd(null,{error:E});}).finally(function(){D.remove(d);});};a.prototype._extractActionConfigurations=function(b,p){var r=b&&b.getManifestEntry("/sap.card/configuration/actionHandlers/submit"),d=p.data||{};if(!r){return p;}return{data:d,configuration:{"mode":r.mode||"cors","url":r.url,"method":r.method||"POST","parameters":Object.assign({},d,r.parameters),"headers":r.headers,"xhrFields":{"withCredentials":!!r.withCredentials}}};};a.prototype._isSingleAction=function(s){return[A.Header,A.Content,A.ContentItemDetail,A.ActionsStrip].indexOf(s)>-1;};return a;});
