/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/p13n/subcontroller/FilterController','sap/ui/mdc/p13n/subcontroller/AdaptFiltersController',"sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer",'sap/m/library','sap/m/Button',"sap/ui/mdc/p13n/StateUtil","sap/base/util/merge","sap/ui/mdc/filterbar/p13n/AdaptationFilterBar","sap/ui/core/library"],function(F,A,a,b,c,d,l,B,S,m,e,C){"use strict";var H=C.aria.HasPopup;var f=c.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},p13nMode:{type:"sap.ui.mdc.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false},_p13nModeValue:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:d});var g=l.ButtonType;f.prototype._createInnerLayout=function(){this._cLayoutItem=b;this._oFilterBarLayout=new a();this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons();};f.prototype.setP13nMode=function(M){var o=this.getP13nMode();this.setProperty("p13nMode",M||[],false);var r={};r.controller={};M&&M.forEach(function(s){if(!o||o.indexOf(s)<0){this._setP13nMode(s,true);}if(s=="Item"){r.controller["Item"]=A;}if(s=="Value"){r.controller["Filter"]=F;}}.bind(this));o&&o.forEach(function(s){if(!M||M.indexOf(s)<0){this._setP13nMode(s,false);}}.bind(this));this.getEngine().registerAdaptation(this,r);return this;};f.prototype._setP13nMode=function(M,v){switch(M){case"Item":this._setP13nModeItem(v);break;case"Value":this._setP13nModeValue(v);break;}};f.prototype.setFilterConditions=function(v,s){F.checkConditionOperatorSanity(v);if(this._oP13nFB){this._oP13nFB.setFilterConditions(m({},v));}this.setProperty("filterConditions",v,s);return this;};f.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem");};f.prototype._setP13nModeItem=function(v){this._oModel.setProperty("/_p13nModeItem",v,true);};f.prototype._getP13nModeValue=function(){return this._oModel.getProperty("/_p13nModeValue");};f.prototype._setP13nModeValue=function(v){this._oModel.setProperty("/_p13nModeValue",v,false);this._bPersistValues=v;};f.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new B(this.getId()+"-btnAdapt",{type:g.Transparent,text:"{"+c.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setAriaHasPopup(H.ListBox);this._btnAdapt.setModel(this._oModel,c.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:'/showAdaptFiltersButton',model:c.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:c.INNER_MODEL_NAME}],formatter:function(v,V){return v&&V;}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,c.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:'/showGoButton',model:c.INNER_MODEL_NAME},{path:"/liveMode",model:c.INNER_MODEL_NAME}],formatter:function(v,V){return v&&((this._isPhone())?true:!V);}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnAdapt);}};f.prototype.retrieveInbuiltFilter=function(){var i=c.prototype.retrieveInbuiltFilter.apply(this,arguments);return i.then(function(I){I._bPersistValues=this._bPersistValues;return I;}.bind(this));};f.prototype.onAdaptFilters=function(E){return this._oMetadataAppliedPromise.then(function(){return this.getEngine().uimanager.show(this,"Item",this._btnAdapt);}.bind(this));};f.prototype.getCurrentState=function(){var s=c.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete s.items;}return s;};c.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField();};return f;});
