/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/Element','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/base/Log','sap/base/util/merge','sap/ui/base/SyncPromise','sap/ui/model/FormatException','sap/ui/model/ParseException'],function(E,F,O,C,a,L,m,S,b,P){"use strict";var c;var l;var d=E.extend("sap.ui.mdc.field.FieldHelpBase",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldHelpBaseDelegate"}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},navigate:{parameters:{value:{type:"any"},key:{type:"any"},condition:{type:"object"},itemId:{type:"string"},leaveFocus:{type:"boolean"}}},dataUpdate:{},disconnect:{},open:{suggestion:{type:"boolean"}},afterClose:{},switchToValueHelp:{}},defaultProperty:"filterValue"}});d._init=function(){c=undefined;l=undefined;};d.prototype.init=function(){E.prototype.init.apply(this,arguments);this._oTextOrKeyPromises={};};d.prototype.invalidate=function(o){if(o){var p=this.getAggregation("_popover");if(p&&o===p){if(o.bOutput&&!this._bIsBeingDestroyed){var n=this.getParent();if(n){n.invalidate(this);}}return;}}};d.prototype.setFilterValue=function(s){this.setProperty("filterValue",s,true);return this;};d.prototype.connect=function(o){if(this._oField&&this._oField!==o){var p=this.getAggregation("_popover");if(p){p._oPreviousFocus=null;}this.close();this.setFilterValue("");this.setConditions([]);this.fireDisconnect();}this._oField=o;k.call(this,o);return this;};d.prototype._getField=function(){if(this._oField){return this._oField;}else{return this.getParent();}};d.prototype._getOperator=function(){if(!this._oOperator){this._oOperator=F.getEQOperator();}return this._oOperator;};d.prototype._createCondition=function(K,D,I,o){var n=this._getOperator();var v=[K];if(n.valueTypes.length>1&&n.valueTypes[1]!==O.ValueType.Static&&D!==null&&D!==undefined){v.push(D);}return C.createCondition(n.name,v,I,o,a.Validated);};d.prototype._getControlForSuggestion=function(){var o=this._getField();if(o.getControlForSuggestion){return o.getControlForSuggestion();}else{return o;}};d.prototype.getFieldPath=function(){var s="";if(this._oField&&this._oField.getFieldPath){s=this._oField.getFieldPath();}return s||"Help";};d.prototype.getDomRef=function(){var p=this.getAggregation("_popover");if(p){return p.getDomRef();}else{return E.prototype.getDomRef.apply(this,arguments);}};d.prototype.getContentId=function(){var p=this.getAggregation("_popover");if(p){var n=p._getAllContent();if(n.length===1){return n[0].getId();}}};d.prototype.getAriaHasPopup=function(){return"listbox";};d.prototype.getRoleDescription=function(M){return null;};d.prototype.getValueHelpEnabled=function(){return true;};d.prototype.open=function(s){var o=this._getField();if(o){var p=this._getPopover();if(p&&!this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;if(!p.isOpen()){if(!this.isFocusInHelp()){p.setInitialFocus(this._getControlForSuggestion());}p.setFieldGroupIds(o.getFieldGroupIds());var n=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var q=this._fireOpen(!!s,n);if(q){if(p._getAllContent().length>0){p.openBy(this._getControlForSuggestion());}else{this._bOpenIfContent=true;}}else{this._bOpenAfterPromise=true;}}}else{this._bOpen=true;this._bSuggestion=s;}}else{L.warning("FieldHelp not assigned to field -> can not be opened.",this);}};d.prototype.close=function(){var p=this.getAggregation("_popover");if(p&&p.isOpen()){var n=p.oPopup.getOpenState();if(n!=="CLOSED"&&n!=="CLOSING"){this._bClosing=true;p.close();}}else{delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}this._bReopen=false;};d.prototype.toggleOpen=function(s){var p=this.getAggregation("_popover");if(p){if(p.isOpen()){var n=p.oPopup.getOpenState();if(n!=="CLOSED"&&n!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(s);}}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{this.open(s);}};d.prototype.isOpen=function(n){if(n&&this._bClosing){return false;}var I=false;var p=this.getAggregation("_popover");if(p){I=p.isOpen();}return I;};d.prototype.skipOpening=function(){if(this._bOpenIfContent){delete this._bOpenIfContent;}if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;}};d.prototype.initBeforeOpen=function(s){if(this._bOpenAfterPromise){return;}var B=function(){this._bBeforeOpenPending=false;if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var n=this._callContentRequest(s,B);if(!n){this._bBeforeOpenPending=true;}};d.prototype._createPopover=function(){var p;if((!c||!l)&&!this._bPopoverRequested){c=sap.ui.require("sap/m/Popover");l=sap.ui.require("sap/m/library");if(!c||!l){sap.ui.require(["sap/m/Popover","sap/m/library"],_.bind(this));this._bPopoverRequested=true;}}if(c&&l&&!this._bPopoverRequested){p=new c(this.getId()+"-pop",{contentHeight:"auto",placement:l.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,afterOpen:this._handleAfterOpen.bind(this),afterClose:this._handleAfterClose.bind(this)}).addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");p.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_popover",p,true);if(this._oContent){this._setContent(this._oContent);}}return p;};function _(p,n){c=p;l=n;this._bPopoverRequested=false;if(!this._bIsBeingDestroyed){this._createPopover();if(this._bOpen){this.open(this._bSuggestion);}}}d.prototype._getPopover=function(){var p=this.getAggregation("_popover");if(!p){p=this._createPopover();}return p;};d.prototype._handleAfterOpen=function(o){};d.prototype._handleAfterClose=function(o){this._bClosing=false;if(this._bReopen){this._bReopen=false;this.open();}this.fireAfterClose();};d.prototype.openByTyping=function(){return false;};d.prototype.openByClick=function(){return false;};d.prototype.isFocusInHelp=function(){return!this.openByTyping();};d.prototype.removeFocus=function(){};d.prototype.navigate=function(s){};d.prototype.getTextForKey=function(K,I,o,B,n,s){return e.call(this,K,B,I,o,false,n,s,true);};function e(K,B,I,o,n,p,s,q){return h.call(this,true,K,B,I,o,n,p,s,undefined,false,q);}d.prototype.getKeyForText=function(t,B,o,s){return f.call(this,t,B,false,o,s,true);};function f(t,B,n,o,s,p){return h.call(this,false,t,B,undefined,undefined,n,o,s,undefined,false,p);}d.prototype._getTextOrKey=function(v,K,B,I,o,n,p,s,q,r,t){if(K){return"";}else{return undefined;}};d.prototype._isTextOrKeyRequestSupported=function(){return false;};d.prototype.isValidationSupported=function(){return this.isUsableForValidation();};d.prototype.getItemForValue=function(v,p,I,o,B,n,q,r,s,t){if(typeof v!=="object"||!v.hasOwnProperty("value")){v={value:v,parsedValue:p,inParameters:I,outParameters:o,bindingContext:B,checkKeyFirst:n,checkKey:q,checkDescription:r,conditionModel:s,conditionModelName:t};}if(v&&typeof v==="object"&&v.hasOwnProperty("value")){return g.call(this,v.value,v.parsedValue,v.inParameters,v.outParameters,v.bindingContext,v.checkKeyFirst&&v.checkKey,v.checkKey,v.checkDescription,v.conditionModel,v.conditionModelName);}else{return g.call(this,v,p,I,o,B,n&&q,q,r,s,t);}};function g(v,p,I,o,B,n,q,r,s,t){return S.resolve().then(function(){if(q&&r){return h.call(this,true,v,B,I,o,false,s,t,p,true,false);}else if(q){return e.call(this,p,B,I,o,false,s,t,false);}else if(r){return f.call(this,v,B,false,s,t,false);}}.bind(this)).then(function(R){if(R){if(typeof R==="object"){return R;}else if(q){return{key:p,description:R};}else{return{key:R,description:v};}}else{return undefined;}}).catch(function(u){throw u;}).unwrap();}d.prototype.isUsableForValidation=function(){return true;};d.prototype.onFieldChange=function(){};d.prototype._setContent=function(o){var p=this.getAggregation("_popover");if(p){p.removeAllContent();p.addContent(o);this._oContent=undefined;if(this._bOpenIfContent){var n=this._getField();if(n){p.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else{this._oContent=o;}return this;};d.prototype.getIcon=function(){return"sap-icon://slim-arrow-down";};d.prototype.getUIArea=function(){var u=E.prototype.getUIArea.apply(this,arguments);if(!u){if(this._oField){u=this._oField.getUIArea();}}return u;};d.prototype.getScrollDelegate=function(){var p=this.getAggregation("_popover");if(p){return p.getScrollDelegate();}else{return undefined;}};d.prototype._fireOpen=function(s,n){if(this._bBeforeOpenPending){return false;}var o=this._callContentRequest(s,n);if(o){this.fireOpen({suggestion:s});}return o;};d.prototype._callContentRequest=function(s,n){if(!this._bNoContentRequest){if(this._oContentRequestPromise){this._oContentRequestPromise.then(function(){this._bNoContentRequest=true;n();this._bNoContentRequest=false;}.bind(this));return false;}if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}if(this.bDelegateInitialized){var p=this._getContenRequestProperties(s);var o=this.getControlDelegate().contentRequest(this.getPayload(),this,s,p);if(o instanceof Promise){this._oContentRequestPromise=o;o.then(function(){this._oContentRequestPromise=undefined;this._bNoContentRequest=true;n();this._bNoContentRequest=false;}.bind(this));return false;}}else{this.awaitControlDelegate().then(function(){if(this._callContentRequest(s,n)){n();}}.bind(this));return false;}}return true;};d.prototype._getContenRequestProperties=function(s){return null;};function h(K,v,B,I,o,n,p,s,q,r,t){var u=JSON.stringify(I);var w=B&&B.getPath();if(this._oTextOrKeyPromises[K]&&this._oTextOrKeyPromises[K][v]&&this._oTextOrKeyPromises[K][v][u]&&this._oTextOrKeyPromises[K][v][u][w]){return this._oTextOrKeyPromises[K][v][u][w].promise;}var x=function(){i.call(this);}.bind(this);var y=this._callContentRequest(true,x);if(!y){if(!this._oTextOrKeyPromises[K]){this._oTextOrKeyPromises[K]={};}if(!this._oTextOrKeyPromises[K][v]){this._oTextOrKeyPromises[K][v]={};}if(!this._oTextOrKeyPromises[K][v][u]){this._oTextOrKeyPromises[K][v][u]={};}if(!this._oTextOrKeyPromises[K][v][u][w]){this._oTextOrKeyPromises[K][v][u][w]={};}this._oTextOrKeyPromises[K][v][u][w].promise=new Promise(function(R,z){this._oTextOrKeyPromises[K][v][u][w].resolve=R;this._oTextOrKeyPromises[K][v][u][w].reject=z;this._oTextOrKeyPromises[K][v][u][w].key=K;this._oTextOrKeyPromises[K][v][u][w].value=v;this._oTextOrKeyPromises[K][v][u][w].inParameters=I?m({},I):undefined;this._oTextOrKeyPromises[K][v][u][w].outParameters=o?m({},o):undefined;this._oTextOrKeyPromises[K][v][u][w].bindingContext=B;this._oTextOrKeyPromises[K][v][u][w].noRequest=n;this._oTextOrKeyPromises[K][v][u][w].conditionModel=p;this._oTextOrKeyPromises[K][v][u][w].conditionModelName=s;this._oTextOrKeyPromises[K][v][u][w].parsedValue=q;this._oTextOrKeyPromises[K][v][u][w].keyAndDescription=r;this._oTextOrKeyPromises[K][v][u][w].caseSensitive=t;}.bind(this));return this._oTextOrKeyPromises[K][v][u][w].promise;}return this._getTextOrKey(v,K,B,I,o,n,p,s,q,r,t);}function i(){for(var K in this._oTextOrKeyPromises){for(var v in this._oTextOrKeyPromises[K]){for(var I in this._oTextOrKeyPromises[K][v]){for(var s in this._oTextOrKeyPromises[K][v][I]){j.call(this,this._oTextOrKeyPromises[K][v][I][s]);delete this._oTextOrKeyPromises[K][v][I][s];}}}}}function j(t){var M=t.value;var n=t.key;var I=t.inParameters;var o=t.outParameters;var B=t.bindingContext;var N=t.noRequest;var r=t.resolve;var R=t.reject;var p=t.conditionModel;var s=t.conditionModelName;var v=t.parsedValue;var K=t.keyAndDescription;var q=t.caseSensitive;S.resolve().then(function(){return this._getTextOrKey(M,n,B,I,o,N,p,s,v,K,q);}.bind(this)).then(function(u){r(u);}).catch(function(u){R(u);}).unwrap();}function k(o){this._oOperator=undefined;if(o&&o._getOperators){this._oOperator=F.getEQOperator(o._getOperators());}}d.prototype.isTypeaheadSupported=function(){return this.openByTyping();};d.prototype.shouldOpenOnClick=function(){return this.openByClick();};d.prototype.onControlChange=function(){return this.onFieldChange();};d.prototype.getAriaAttributes=function(M){return{contentId:this.getContentId(),ariaHasPopup:this.getAriaHasPopup(),role:"combobox",roleDescription:this.getRoleDescription(M),valueHelpEnabled:this.getValueHelpEnabled()};};d.prototype.attachEvent=function(s,D,n,o){if(s==="navigated"){return E.prototype.attachEvent.apply(this,["navigate",D,n,o]);}else{return E.prototype.attachEvent.apply(this,arguments);}};d.prototype.detachEvent=function(s,n,o){if(s==="navigated"){return E.prototype.detachEvent.apply(this,["navigate",n,o]);}else{return E.prototype.detachEvent.apply(this,arguments);}};return d;});
