/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/p13n/AdaptationProvider","sap/base/util/merge","sap/base/Log","sap/ui/mdc/util/PropertyHelper","sap/ui/mdc/p13n/modification/FlexModificationHandler","sap/m/MessageStrip","sap/ui/core/library","sap/ui/mdc/p13n/StateUtil","sap/ui/core/Element","sap/ui/mdc/p13n/DefaultProviderRegistry","sap/ui/mdc/p13n/UIManager"],function(A,m,L,P,F,M,c,S,E,D,U){"use strict";var b="Engine: This class is a singleton. Please use the getInstance() method instead.";var d=c.MessageType;var _=new WeakMap();var e;var f=A.extend("sap.ui.mdc.p13n.Engine",{constructor:function(){A.call(this);if(e){throw Error(b);}this._aRegistry=[];this.defaultProviderRegistry=D.getInstance();this.uimanager=U.getInstance(this);}});f.prototype.registerAdaptation=function(C,o){if(!o.hasOwnProperty("controller")){throw new Error("Please provide atleast a configuration 'controller' containing a map of key-value pairs (key + Controller class) in order to register adaptation.");}if(this._getRegistryEntry(C)){this.deregisterAdaptation(C);}var a=Object.keys(o.controller);a.forEach(function(k){var g=o.controller[k];if(!this.getController(C,k)){if(this._aRegistry.indexOf(C.getId())<0){this._aRegistry.push(C.getId());}var h=new g(C);this.addController(h,k);}}.bind(this));};f.prototype.deregisterAdaptation=function(C){var r=this._getRegistryEntry(C);Object.keys(r.controller).forEach(function(k){var o=r.controller[k];o.destroy();delete r.controller[k];});_.delete(C);var i=this._aRegistry.indexOf(C.getId());this._aRegistry.splice(i,1);};f.prototype._setModificationHandler=function(C,o){if(!o.isA("sap.ui.mdc.p13n.modification.ModificationHandler")){throw new Error("Only sap.ui.mdc.p13n.modification.ModificationHandler derivations are allowed for modification");}var a=this._determineModification(C);a.handler=o;this._getRegistryEntry(C).modification=a;};f.prototype.createChanges=function(g){var C=g.control;var k=g.key;var n=g.state;var h=!!g.applyAbsolute;var s=!!g.suppressAppliance;if(!k||!C||!n){throw new Error("To create changes via Engine, atleast a 1)Control 2)Key and 3)State needs to be provided.");}return this.initAdaptation(C,k).then(function(){var o=this.getController(C,k);var i=o.getChangeOperations();var r=this._getRegistryEntry(C);var j=o.getCurrentState();var p=m(j instanceof Array?[]:{},j);var l={existingState:p,applyAbsolute:h,changedState:n,control:o.getAdaptationControl(),changeOperations:i,deltaAttributes:["name"],propertyInfo:r.helper.getProperties().map(function(a){return{name:a.getName()};})};var q=o.getDelta(l);if(!s){this._processChanges(C,q);}return q||[];}.bind(this));};f.prototype.reset=function(C,k){k=k instanceof Array?k:[k];var r={selector:C};var o=this._determineModification(C);return o.handler.reset(r,o.payload).then(function(){return this.initAdaptation(C,k).then(function(p){k.forEach(function(K){var a=this.getController(C,K);a.update(p);}.bind(this));}.bind(this));}.bind(this));};f.prototype.waitForChanges=function(C){var o=this._determineModification(C);return o.handler.waitForChanges({element:C},o.payload);};f.prototype.isModificationSupported=function(C){var o=this._determineModification(C);return o.handler.isModificationSupported({element:C},o.payload);};f.prototype._processChanges=function(C,a){if(a instanceof Array&&a.length>0){var o=this._determineModification(C);return o.handler.processChanges(a,o.payload);}else{return Promise.resolve([]);}};f.prototype.getRTASettingsActionHandler=function(C,p,k){var r;var a=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");if(a.length>0){return Promise.reject("Please do not use a PeristenceProvider in RTA.");}var o=this.getModificationHandler(C);var i=o.processChanges;var R=new Promise(function(g,h){r=g;});o.processChanges=r;this._setModificationHandler(C,o);this.uimanager.show(C,k).then(function(g){var h=g.getCustomHeader();if(h){h.getContentRight()[0].setVisible(false);}g.addStyleClass(p.styleClass);});R.then(function(){o.processChanges=i;});return R;};f.prototype.enhanceXConfig=function(C,a){var o=f.getControlInstance(C);var r=this._getRegistryEntry(C);return Promise.resolve().then(function(){if(r){var g=this.getModificationHandler(C);return g.enhanceConfig(o,a).then(function(h){r.xConfig=h;});}else{throw new Error("The control instance needs to be registered to use xConfig!");}}.bind(this));};f.prototype.readXConfig=function(C,a,s){var o=f.getControlInstance(C);var g=this.getModificationHandler(C);return g.readConfig(o,a,s)||Promise.resolve({});};f.prototype.applyState=function(C,s,a){return this.retrieveState(C).then(function(o){var g=[],h=[],i={};if(C.validateState instanceof Function){i=C.validateState(S._externalizeKeys(s));}if(i.validation===d.Error){L.error(i.message);}Object.keys(s).forEach(function(j){var k=this.getController(C,j);if(!k){return;}var l=this.createChanges({control:C,key:j,state:k.sanityCheck(s[j]),suppressAppliance:true,applyAbsolute:a});g.push(l);}.bind(this));return Promise.all(g).then(function(r){r.forEach(function(j){if(j&&j.length>0){h=h.concat(j);}});return this._processChanges(C,h);}.bind(this));}.bind(this));};f.prototype.retrieveState=function(C){var v=this.checkXStateInterface(C);if(!v){throw new Error("The control needs to implement the interface IxState.");}return C.initialized().then(function(){return f.getInstance().waitForChanges(C).then(function(){var r={};f.getInstance().getRegisteredControllers(C).forEach(function(k){r[k]=f.getInstance().getController(C,k).getCurrentState();});return m({},r);});});};f.prototype.checkXStateInterface=function(C){if(!C){return false;}if(!this.isModificationSupported(C)){return false;}if(!C.isA("sap.ui.mdc.IxState")){return false;}return true;};f.prototype.initAdaptation=function(C,k,a){this.verifyController(C,k);return this._retrievePropertyHelper(C,a);};f.prototype.addController=function(C,k,p){var r=this._createRegistryEntry(C.getAdaptationControl(),p);r.controller[k]=C;};f.prototype.getController=function(C,k){var r=this._getRegistryEntry(C);if(r&&r.controller.hasOwnProperty(k)){return r.controller[k];}};f.prototype.verifyController=function(C,k){var K=k instanceof Array?k:[k];K.forEach(function(s){if(!this.getController(C,s)){var o=f.getControlInstance(C);throw new Error("No controller registered yet for "+o.getId()+" and key: "+s);}}.bind(this));};f.prototype.getUISettings=function(C,k){this.verifyController(C,k);var p=this._getRegistryEntry(C).helper;var u={};k.forEach(function(K){var o=this.getController(C,K);var a=o.getAdaptationUI(p);if(a instanceof Promise){u[K]={};u[K]={resetEnabled:o.getResetEnabled(),containerSettings:o.getUISettings(),adaptationUI:a};}}.bind(this));return u;};f.prototype.isRegisteredForModification=function(C){var r=this._getRegistryEntry(C);return r&&!!r.modification;};f.prototype.getRegisteredControllers=function(C){var r=this._getRegistryEntry(C);return Object.keys(r.controller);};f.prototype._getRegistryEntry=function(C){var o=f.getControlInstance(C);return _.get(o);};f.prototype.getModificationHandler=function(C){var o=this._determineModification(C);return o.handler;};f.prototype._createRegistryEntry=function(C,p){var o=f.getControlInstance(C);if(!_.has(o)){_.set(o,{modification:p&&p.modification?p.modification:null,controller:{},activeP13n:null,helper:null,xConfig:null});}return _.get(o);};f.prototype._determineModification=function(C){var r=this._getRegistryEntry(C);if(r&&r.modification){return r.modification;}var p=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");var v=f.hasForReference(C,"sap.ui.fl.variants.VariantManagement");var a=p.length?p:undefined;var h=a?a[0].getMode():"Standard";var H={Global:F,Transient:F,Standard:F,Auto:F};var g=H[h];if(!g){throw new Error("Please provide a valid ModificationHandler! - valid Modification handlers are:"+Object.keys(H));}var o={handler:g.getInstance(),payload:{hasVM:v&&v.length>0,hasPP:p&&p.length>0,mode:h}};if(r&&!r.modification){r.modification=o;}return o;};f.hasForReference=function(C,s){var a=C&&C.getId?C.getId():C;var r=E.registry.filter(function(o){if(!o.isA(s)){return false;}var g=o.getFor();for(var n=0;n<g.length;n++){if(g[n]===a||f.hasControlAncestorWithId(a,g[n])){return true;}}return false;});return r;};f.hasControlAncestorWithId=function(C,a){var o;if(C===a){return true;}o=sap.ui.getCore().byId(C);while(o){if(o.getId()===a){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;};f.getControlInstance=function(C){return typeof C=="string"?sap.ui.getCore().byId(C):C;};f.prototype.hasActiveP13n=function(C){return!!this._getRegistryEntry(C).activeP13n;};f.prototype.setActiveP13n=function(C,k){this._getRegistryEntry(C).activeP13n=k;};f.prototype.validateP13n=function(C,k,p){var o=this.getController(C,k);var a=f.getControlInstance(C);var g=this._getRegistryEntry(C).controller;var t={};Object.keys(g).forEach(function(s){t[s]=g[s].getCurrentState();});if(o.model2State instanceof Function){t[k]=o.model2State();var i=a.validateState(S._externalizeKeys(t),k);var h;if(i.validation!==d.None){h=new M({type:i.validation,text:i.message});}if(p.setMessageStrip instanceof Function){p.setMessageStrip(h);}else{L.warning("message strip could not be provided - the adaptation UI needs to implement 'setMessageStrip'");}}};f.prototype.handleP13n=function(C,k){var a=[];k.forEach(function(s){var o=this.getController(C,s);var p=this.createChanges({control:C,key:s,state:o.getP13nData(),suppressAppliance:true,applyAbsolute:true}).then(function(i){return o.getBeforeApply().then(function(g){var h=g?g.concat(i):i;return h;});});a.push(p);}.bind(this));return Promise.all(a).then(function(g){var h=[];g.forEach(function(t){h=h.concat(t);});if(h.length>0){f.getInstance()._processChanges(C,h);}});};f.prototype._retrievePropertyHelper=function(C,a){var r=this._getRegistryEntry(C);var o=f.getControlInstance(C);if(a){if(r.helper){r.helper.destroy();}r.helper=new P(a);return Promise.resolve(r.helper);}if(r.helper){return Promise.resolve(r.helper);}return o.initPropertyHelper().then(function(p){r.helper=p;return p;},function(h){throw new Error(h);});};f.getInstance=function(){if(!e){e=new f();}return e;};f.prototype._getRegistry=function(){var r={};this._aRegistry.forEach(function(k){var C=sap.ui.getCore().byId(k);r[k]=_.get(C);});return r;};f.prototype.destroy=function(){A.prototype.destroy.apply(this,arguments);e=null;this._aRegistry=null;_.delete(this);this.defaultProviderRegistry.destroy();this.defaultProviderRegistry=null;this.uimanager.destroy();this.uimanager=null;};return f;});
