/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/ui/mdc/library","sap/m/Button",'sap/m/Column',"sap/m/Table","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData"],function(B,L,C,S,T,I,M,c,d,e,F,f,V,H,g,h,i,l,D,R,j){"use strict";var k=l.FlexJustifyContent;var m=sap.ui.getCore();var n=B.extend("sap.ui.mdc.p13n.panels.ChartItemPanelNew",{metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},init:function(){this._bMobileMode=D.system.phone;B.prototype.init.apply(this,arguments);this._bindListItems();this.setEnableReorder(true);},renderer:{}});n.prototype._setInnerLayout=function(){this._oInnerControl=new V({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){var $=null;var p=this.getParent();if(p&&p.$){$=p.$("cont");if($.children().length>0){var s=this._oInnerControl.$()[0].clientWidth;var a=570;if(!this._bMobileMode&&s<=a){this._switchMobileMode(true);}else if(this._bMobileMode&&s>a){this._switchMobileMode(false);}}}}};if(D.system.desktop){this._sContainerResizeListener=R.register(this._oInnerControl,this._fnHandleResize.bind(this));}};n.prototype._switchMobileMode=function(b){if(this._bMobileMode==b){return;}this._bMobileMode=b;if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._oListControl.setMultiSelectMode("ClearAll");this._setInnerLayout();this._bindListItems();};n.prototype._createInnerListControl=function(){var s=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";var t=new e(s,Object.assign(this._getListControlConfig(),{}));t.addEventDelegate({onAfterRendering:this._checkFocusAfterTableRerender.bind(this)});return t;};n.prototype._checkFocusAfterTableRerender=function(){if(this._oFocusInfo&&this._oFocusInfo.tableItem){this._oFocusInfo.tableItem.focus();}this._oFocusInfo=null;};n.prototype._bindListItems=function(o){var s;var p=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){s=this.getPanelConfig().sorter;}else{var q={text:p.getText('chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER')};var r={text:p.getText('chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER')};var G={"Aggregatable":q,"Groupable":r,"Measure":q,"Dimension":r};var t=function(a){var b=a.getProperty("kind");return{key:b,text:G[b].text};};var u=function(a,b){if(a===b){return 0;}if(a==="MEASURE"||a==="AGGREGATABLE"){return 1;}return-1;};s=new h("kind",false,t,u);}var v;this._mTemplatesMap=new Map();if(this._bMobileMode){v=this._createListItemMobile;}else{v=this._createListItem;}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new F({filters:[new F("visible",f.EQ,true),new F("template",f.EQ,true)],and:false})],factory:v.bind(this),sorter:s},o));};n.prototype._getTemplateComboBox=function(K){var v=new F("visible",f.EQ,false);var o=new g({id:"p13nPanel-templateComboBox-"+K,width:"100%",placeholder:this._getPlaceholderTextForKind(K),items:{path:this.P13N_MODEL+">/items",template:new I({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[v,new F("kind",f.EQ,K)]},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(K,o);return o;};n.prototype._getPlaceholderTextForKind=function(K){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var p=a.getText('chart.PERSONALIZATION_DIALOG_TEMPLATE_MEASURE');var P=a.getText('chart.PERSONALIZATION_DIALOG_TEMPLATE_DIMENSION');var b={"Aggregatable":p,"Groupable":P,"Measure":p,"Dimension":P};return b[K];};n.prototype._getRoleSelect=function(){return new S({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new I({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(r){if(!r){return false;}return r.length>1;}}});};n.prototype._getNameComboBox=function(K,N){var o=new F({filters:[new F("visible",f.EQ,false),new F("name",f.EQ,N)],and:false});return new g({width:"100%",items:{path:this.P13N_MODEL+">/items",template:new I({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[o,new F("kind",f.EQ,K)]},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new j({key:"prevName",value:N}),new j({key:"prevKind",value:K})]});};n.prototype._createListItem=function(s,o){var r,a=[];if(o.getObject()&&o.getObject().template){a.push(this._getTemplateComboBox(o.getObject().kind));}else{a.push(this._getNameComboBox(o.getObject().kind,o.getObject().name));a.push(this._getRoleSelect());r=o.getObject().kind+"-RemoveBtn-"+o.getObject().name;a.push(new H({justifyContent:k.End,items:[new c({id:r,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",customData:[new j({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new j({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));}var b;if(o.getObject()&&o.getObject().template){var K=o.getObject().kind;b=new C({cells:a,visible:{path:this.P13N_MODEL+">/items",formatter:function(p){p=p.filter(function(q){return q.visible===false&&q.template===false&&q.kind===K;});return p.length!=0;}}});}else{b=new C({cells:a});}b.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._handleOnKeyDown.bind(this)});return b;};n.prototype._createListItemMobile=function(s,o){var r,a=[];if(o.getObject()&&o.getObject().template){a.push(this._getTemplateComboBox(o.getObject().kind));}else{var v=new V({items:[this._getNameComboBox(o.getObject().kind,o.getObject().name),this._getRoleSelect()]});r=o.getObject().kind+"-RemoveBtn-"+o.getObject().name;a.push(v);}var b=new H({justifyContent:k.End,items:[new c({id:r,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(E){return!E;}},customData:[new j({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new j({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});a.push(b);var p;if(o.getObject()&&o.getObject().template){var K=o.getObject().kind;p=new C({cells:a,visible:{path:this.P13N_MODEL+">/items",formatter:function(q){q=q.filter(function(t){return t.visible===false&&t.template===false&&t.kind===K;});return q.length!=0;}}});}else{p=new C({cells:a});}p.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._handleOnKeyDown.bind(this)});return p;};n.prototype._handleOnKeyDown=function(E){if(E.keyCode===38&&E.ctrlKey){}else if(E.keyCode===40&&E.ctrlKey){}else if(E.keyCode===68&&E.ctrlKey){var r,o=m.byId(E.currentTarget.id);if(this._bMobileMode){r=o.getCells()[1].getItems()[o.getCells()[1].getItems().length-1];}else{r=o.getCells()[2].getItems()[o.getCells()[2].getItems().length-1];}if(r){this._onPressHide(E,r);E.preventDefault();}}};n.prototype._handleActivated=function(o){var a=this._getModelItemByTableItem(o);if(a&&a.template){this.removeMoveButtons();}this._oHoveredItem=o;this._updateEnableOfMoveButtons(o,false);this._addMoveButtons(o);this._setMoveButtonVisibility(true);};n.prototype.onChangeOfItemName=function(E){var p=E.getSource().data().prevName;var K=E.getSource().data().prevKind;var N=E.getSource().getSelectedKey();var P=this._getP13nModel().getProperty("/items").find(function(a){return a.name===p&&a.kind===K;});var o=this._getP13nModel().getProperty("/items").find(function(a){return a.name===N&&a.kind===K;});this.removeMoveButtons();if(P&&o){P.visible=false;o.visible=true;P.tempName=P.name;o.role=P.role;this._moveItemsByIndex(this._getItemIndex(o),this._getItemIndex(P));this._getP13nModel().refresh(true);this._fireChangeItems();}};n.prototype._getItemIndexByNameAndKind=function(N,K){var a=this._getP13nModel().getProperty("/items");var o=a.find(function(b){return(b.name===N&&b.kind===K&&!b.template);});return this._getItemIndex(o);};n.prototype._getItemIndex=function(o){return this._getP13nModel().getProperty("/items").indexOf(o);};n.prototype.removeMoveButtons=function(){var o=this._getMoveButtonContainer();if(o){o.removeItem(this._getMoveBottomButton());o.removeItem(this._getMoveDownButton());o.removeItem(this._getMoveUpButton());o.removeItem(this._getMoveTopButton());}};n.prototype.getP13nState=function(){var a=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",a);return a;};n.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent();}return undefined;};n.prototype._addMoveButtons=function(o){var t=o;if(!t){return;}var b=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(!b){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0);}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0);}}};n.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};n.prototype._updateAvailableRolesForItems=function(){var a=this._getP13nModel().getProperty("/items");var A=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){A=this.getPanelConfig().allowedLayoutOptions;}else{i.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!");}a.forEach(function(o){if(!o.availableRoles){return;}o.availableRoles=o.availableRoles.filter(function(b){return A.indexOf(b.key)!=-1;});});this._getP13nModel().setProperty("/items",a);this._getP13nModel().refresh(true);};n.prototype._onPressHide=function(E,r){var p;if(r){p=r.data().propertyName;}else{p=E.getSource().data().propertyName;}var a=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);a.filter(function(b){return b.name===p;}).forEach(function(o){o.visible=false;if(this._mTemplatesMap.has(o.kind)&&this._mTemplatesMap.get(o.kind).getVisible()){this._mTemplatesMap.get(o.kind).focus();}}.bind(this));this._getP13nModel().setProperty("/items",a);this._getP13nModel().refresh(true);this._fireChangeItems();this._updateVisibleIndexes();};n.prototype.setP13nData=function(p){p=p.filter(function(b){return!b.template;});B.prototype.setP13nData.apply(this,arguments);var a=[];var A=[];this.getP13nData().forEach(function(o,b){if(!o.availableRoles){o.availableRoles=this._getChartItemTextByKey(o.kind);}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){var q=this.getPanelConfig().allowedLayoutOptions;if(q&&q.length>=1){o.availableRoles=o.availableRoles.filter(function(r){return q.indexOf(r.key)!=-1;});if(q.indexOf(o.role)===-1){o.role=q[0];}}}o.template=false;o.tempName=o.name;if(!o.visible){A.push(o);}if(!o.index){o.index=b;}a.push(o);}.bind(this));a=a.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",a);this._updateVisibleIndexes();};n.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map();this._getP13nModel().getProperty("/items").forEach(function(o,_){if(o.template||!o.visible){return;}if(this._mVisibleIndexes.has(o.kind)){this._mVisibleIndexes.get(o.kind).push(_);}else{var a=[_];this._mVisibleIndexes.set(o.kind,a);}}.bind(this));};n.prototype.onChangeOfTemplateName=function(E){var s=E.getSource().getSelectedKey();var o=this._getCleanP13nItems().find(function(b){return b.name===s;});if(o){o.visible=true;E.getSource().setSelectedKey(undefined);this._getP13nModel().refresh(true);var a=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];var O=this._getItemIndexByNameAndKind(o.name,o.kind);var N=a[a.length-1];if(O>N){N+=1;}if(N){this._moveItemsByIndex(O,N,true);}else{this._fireChangeItems();}this._updateVisibleIndexes();}else{E.getSource().setSelectedKey(undefined);}};n.prototype._getTemplateItems=function(){var a=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[];}this.getPanelConfig().templateConfig.forEach(function(t){var o={template:true,kind:t.kind};a.push(o);});return a;};n.prototype._getListControlConfig=function(){var o=B.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){o.columns=[new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_TYPE")})}),new d()];}else{var a=new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});var r=new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_TYPE")})});o.columns=[a,r,new d()];}o.mode="None";return o;};n.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(function(a){return!a.template;});};n.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(function(o){return{columnKey:o.name,visible:o.visible,index:o.index,role:o.role};})});};n.prototype.onChangeOfRole=function(E){var s=E.getParameter("selectedItem");if(s){var t;if(this._bMobileMode){t=E.getSource().getParent().getParent();}else{t=E.getSource().getParent();}this.fireChange();this._updateEnableOfMoveButtons(t);}this._fireChangeItems();};n.prototype._updateEnableOfMoveButtons=function(t,b){if(!t){return;}var a,o=this._getModelItemByTableItem(t);var p=this._getP13nModel().getProperty("/items").indexOf(o);var u=true,q=true;if(!o||o.template){return;}a=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];if(p==0||a.indexOf(p)===0){u=false;}if(a.indexOf(p)===a.length-1){q=false;}this._getMoveTopButton().setEnabled(u);this._getMoveUpButton().setEnabled(u);this._getMoveDownButton().setEnabled(q);this._getMoveBottomButton().setEnabled(q);if(b){this._oFocusInfo={tableItem:t};}};n.prototype._getListItemFromMoveButton=function(b){if(b&&b.getParent()&&b.getParent().getParent()){return b.getParent().getParent();}return undefined;};n.prototype._onPressButtonMoveToTop=function(E){var o=this._getListItemFromMoveButton(E.getSource());if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var t=this._mVisibleIndexes.get(a.kind)[0];this._oSelectedItem=o;this._moveSelectedItem(t);};n.prototype._onPressButtonMoveUp=function(E,o){if(!o){o=this._getListItemFromMoveButton(E.getSource());}if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind);var t=this._getP13nModel().getProperty("/items").indexOf(a);this._oSelectedItem=o;var N=b[b.indexOf(t)-1];this._moveSelectedItem(N);};n.prototype._onPressButtonMoveDown=function(E,o){if(!o){o=this._getListItemFromMoveButton(E.getSource());}if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind);var t=this._getP13nModel().getProperty("/items").indexOf(a);this._oSelectedItem=o;var N=b[b.indexOf(t)+1];this._moveSelectedItem(N);};n.prototype._onPressButtonMoveToBottom=function(E){var o=this._getListItemFromMoveButton(E.getSource());if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind)[this._mVisibleIndexes.get(a.kind).length-1];this._oSelectedItem=o;this._moveSelectedItem(b);};n.prototype._moveTableItem=function(o,N){var a=this._getP13nModel().getProperty("/items");var O=a.indexOf(o.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(O,N);};n.prototype._moveItemsByIndex=function(o,N,p){var a=this._getP13nModel().getProperty("/items");N=(N<=0)?0:Math.min(N,a.length-1);if(N==o){return;}a.splice(N,0,a.splice(o,1)[0]);a.forEach(function(b,q){if(!b.template){b.index=q;}});this._getP13nModel().setProperty("/items",a);this._oSelectedItem=this._oListControl.getItems().find(function(b){var q=this._getModelItemByTableItem(b);return q&&q===a[N];}.bind(this));this._updateEnableOfMoveButtons(this._oSelectedItem,!p);this._handleActivated(this._oSelectedItem);this._fireChangeItems();};n.prototype._getModelItemByTableItem=function(t){return this._getP13nModel().getProperty(t.getBindingContextPath());};n.prototype._getMoveConfigForTableItem=function(t){var o=this._getModelItemByTableItem(t);if(!o){return undefined;}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(o),aggregationRole:o.kind,template:o.template};};n.prototype._getDragDropConfig=function(){var o=B.prototype._getDragDropConfig.apply(this,arguments);o.attachDragStart(this._checkDragStart.bind(this));o.attachDragEnter(this._checkDrag.bind(this));o.attachDragEnd(function(){this._oDraggedItem=null;}.bind(this));return o;};n.prototype._checkDrag=function(E){var o=E.getParameter("target");var a=this._getMoveConfigForTableItem(o);var b=this._getMoveConfigForTableItem(this._oDraggedItem);if(!a||a.template||b.aggregationRole!=a.aggregationRole){E.preventDefault();return;}};n.prototype._checkDragStart=function(E){this._oDraggedItem=E.getParameter("target");this._checkDrag(E);};n.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var a=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var b=this._getMoveConfigForTableItem(o);var p=this._getMoveConfigForTableItem(a);if(!b||b.template||!p){E.preventDefault();return;}var q=b.currentIndex;var r=p.currentIndex;if(p.template&&s=="After"){E.preventDefault();return;}if(!p.template&&(b.aggregationRole!=undefined&&b.aggregationRole!=p.aggregationRole)){E.preventDefault();return;}if(q<r){if(s=="Before"&&r!=0){r-=1;}}else if(s=="After"){r+=1;}this._moveItemsByIndex(q,r);this._getP13nModel().refresh(true);this._updateVisibleIndexes();};n.prototype._getMoveTopButton=function(){if(this._oMoveTopBtn&&this._oMoveTopBtn.isDestroyed()){this._oMoveTopBtn=null;}return B.prototype._getMoveTopButton.apply(this,arguments);};n.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null;}return B.prototype._getMoveUpButton.apply(this,arguments);};n.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null;}return B.prototype._getMoveDownButton.apply(this,arguments);};n.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null;}return B.prototype._getMoveBottomButton.apply(this,arguments);};n.prototype._getChartItemTextByKey=function(K){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={Dimension:[{key:M.ChartItemRoleType.category,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],Measure:[{key:M.ChartItemRoleType.axis1,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[K];};n.prototype._getResourceTextMDC=function(t,v){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundleMDC.getText(t,v):this.oResourceBundleMDC;};return n;});
