/*!

 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Binding','./Filter','./FilterType','./Sorter','sap/base/util/array/diff'],function(B,F,b,S,d){"use strict";var L=B.extend("sap.ui.model.ListBinding",{constructor:function(M,p,c,s,f,P){B.call(this,M,p,c,P);this.aSorters=m(s,S);this.aFilters=[];this.aApplicationFilters=m(f,F);this.oCombinedFilter=null;this.bUseExtendedChangeDetection=false;this.bDetectUpdates=true;},metadata:{"abstract":true,publicMethods:["getContexts","getCurrentContexts","sort","attachSort","detachSort","filter","attachFilter","detachFilter","getDistinctValues","isGrouped","getLength","isLengthFinal"]}});function m(a,c){if(Array.isArray(a)){return a;}return a instanceof c?[a]:[];}L.prototype.getCurrentContexts=function(){return this.getContexts();};L.prototype.getCount=function(){return this.isLengthFinal()?this.getLength():undefined;};L.prototype.getLength=function(){return 0;};L.prototype.isLengthFinal=function(){return true;};L.prototype.getDistinctValues=function(p){return null;};L.prototype.attachSort=function(f,l){this.attachEvent("sort",f,l);};L.prototype.detachSort=function(f,l){this.detachEvent("sort",f,l);};L.prototype._fireSort=function(p){this.fireEvent("sort",p);};L.prototype.attachFilter=function(f,l){this.attachEvent("filter",f,l);};L.prototype.detachFilter=function(f,l){this.detachEvent("filter",f,l);};L.prototype._fireFilter=function(p){this.fireEvent("filter",p);};L.prototype.isGrouped=function(){return!!(this.aSorters&&this.aSorters[0]&&this.aSorters[0].fnGroup);};L.prototype.getGroup=function(c){return this.aSorters[0].getGroup(c);};L.prototype.diffData=function(o,n){return d(o,n,this.oExtendedChangeDetectionConfig);};L.prototype.enableExtendedChangeDetection=function(D,k,e){this.bUseExtendedChangeDetection=true;this.bDetectUpdates=D;this.oExtendedChangeDetectionConfig=e;if(typeof k==="string"){this.getEntryKey=function(c){return c.getProperty(k);};}else if(typeof k==="function"){this.getEntryKey=k;}if(this.update){this.update();}};L.prototype.getContextData=function(c){var C;if(this.getEntryKey&&!this.bDetectUpdates){C=this.getEntryKey(c);if(this.isGrouped()){C+="-"+this.getGroup(c).key;}}else{C=this.getEntryData(c);}return C;};L.prototype.getEntryData=function(c){return JSON.stringify(c.getObject());};L.prototype.getFilters=function(f){switch(f){case b.Application:return this.aApplicationFilters&&this.aApplicationFilters.slice()||[];case b.Control:return this.aFilters&&this.aFilters.slice()||[];default:throw new Error("Invalid FilterType: "+f);}};L.prototype.getFilterInfo=function(i){if(this.oCombinedFilter){return this.oCombinedFilter.getAST(i);}return null;};return L;});
