/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_ODataMetaModelUtils","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ClientContextBinding","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/MetaModel","sap/ui/model/json/JSONListBinding","sap/ui/model/json/JSONModel","sap/ui/model/json/JSONPropertyBinding","sap/ui/model/json/JSONTreeBinding","sap/ui/performance/Measurement"],function(U,L,e,a,B,M,S,b,C,c,F,d,J,f,g,h,k){"use strict";var m=new Map(),o="sap.ui.model.odata.ODataMetaModel",p=[o],P=o+"/load",r=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;var O=J.extend("sap.ui.model.odata.ODataMetaListBinding"),R=M.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});O.prototype.applyFilter=function(){var t=this,i=F.combineFilters(this.aFilters,this.aApplicationFilters);this.aIndices=F.apply(this.aIndices,i,function(v,s){return s==="@sapui.name"?v:t.oModel.getProperty(s,t.oList[v]);},this.mNormalizeCache);this.iLength=this.aIndices.length;};var l=d.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(i,A,D){var j=D.annotationsLoaded(),t=this;function n(){var q;if(t.bDestroyed){throw new Error("Meta model already destroyed");}k.average(P,"",p);q=JSON.parse(JSON.stringify(i.getServiceMetadata()));t.oModel=new f(q);t.oModel.setDefaultBindingMode(t.sDefaultBindingMode);U.merge(A?A.getAnnotationsData():{},q,t);k.end(P);}d.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=b.OneTime;this.oLoadedPromise=j?j.then(n):new Promise(function(q,s){n();q();});this.oLoadedPromiseSync=S.resolve(this.oLoadedPromise);this.oMetadata=i;this.oDataModel=D;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={"OneTime":true};}});l.prototype._getObject=function(s,j){var n=j,q,t,i,E,N,v,u,w=s||"",x;if(!j||j instanceof c){w=this.resolve(s||"",j);if(!w){L.error("Invalid relative path w/o context",s,o);return null;}}if(w.charAt(0)==="/"){n=this.oModel._getObject("/");w=w.slice(1);}u="/";N=n;while(w){v=undefined;q=undefined;if(w.charAt(0)==='['){try{x=B.parseExpression(w,1);E=x.at;if(w.length===E+1||w.charAt(E+1)==='/'){q=x.result;v=w.slice(0,E+1);w=w.slice(E+2);}}catch(y){if(!(y instanceof SyntaxError)){throw y;}}}if(v===undefined){E=w.indexOf("/");if(E<0){v=w;w="";}else{v=w.slice(0,E);w=w.slice(E+1);}}if(!N){if(L.isLoggable(L.Level.WARNING,o)){L.warning("Invalid part: "+v,"path: "+s+", context: "+(j instanceof c?j.getPath():j),o);}break;}if(q){if(n===j){L.error("A query is not allowed when an object context has been given",s,o);return null;}if(!Array.isArray(N)){L.error("Invalid query: '"+u+"' does not point to an array",s,o);return null;}t=u+v;v=this.mQueryCache[t];if(v===undefined){this.oResolver=this.oResolver||new R({models:this.oModel});for(i=0;i<N.length;i+=1){this.oResolver.bindObject(u+i);this.oResolver.bindProperty("any",q);try{if(this.oResolver.getAny()){this.mQueryCache[t]=v=i;break;}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject();}}}}N=N[v];u=u+v+"/";}return N;};l.prototype._getOrCreateSharedModelCache=function(){var D=this.oDataModel;if(!this.oSharedModelCache){this.oSharedModelCache={bFirstCodeListRequested:false,oModel:new D.constructor(D.getCodeListModelParameters())};}return this.oSharedModelCache;};l.prototype._mergeMetadata=function(i){var E=this.getODataEntityContainer(),j=U.getChildAnnotations(i.annotations,E.namespace+"."+E.name,true),n=E.entitySet.length,s=this.oModel.getObject("/dataServices/schema"),t=this;i.entitySets.forEach(function(q){var u,v,T=q.entityType,N=T.slice(0,T.lastIndexOf("."));if(!t.getODataEntitySet(q.name)){E.entitySet.push(JSON.parse(JSON.stringify(q)));if(!t.getODataEntityType(T)){u=t.oMetadata._getEntityTypeByName(T);v=U.getSchema(s,N);v.entityType.push(JSON.parse(JSON.stringify(u)));U.visitParents(v,i.annotations,"entityType",U.visitEntityType,v.entityType.length-1);}}});U.visitChildren(E.entitySet,j,"EntitySet",s,null,n);};l.prototype._sendBundledRequest=function(){var q=this.mQName2PendingRequest,Q=Object.keys(q),t=this;if(!Q.length){return;}this.mQName2PendingRequest={};Q=Q.sort();Q.forEach(function(s,i){Q[i]=encodeURIComponent(s);});this.oDataModel.addAnnotationUrl("$metadata?sap-value-list="+Q.join(",")).then(function(i){var s;t._mergeMetadata(i);for(s in q){try{q[s].resolve(i);}catch(E){q[s].reject(E);}}},function(E){var s;for(s in q){q[s].reject(E);}});};l.prototype.bindContext=function(s,i,j){return new C(this,s,i,j);};l.prototype.bindList=function(s,i,j,n,q){return new O(this,s,i,j,n,q);};l.prototype.bindProperty=function(s,i,j){return new g(this,s,i,j);};l.prototype.bindTree=function(s,i,j,n){return new h(this,s,i,j,n);};l.prototype.destroy=function(){d.prototype.destroy.apply(this,arguments);if(this.oSharedModelCache){this.oSharedModelCache.oModel.destroy();delete this.oSharedModelCache;}return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments);};l.prototype.fetchCodeList=function(t){var i=this;return this.oLoadedPromiseSync.then(function(){var s,j,n,q,u,v,w,x,y="com.sap.vocabularies.CodeList.v1."+t,z=i.getODataEntityContainer()[y];if(!z||!z.Url.String){return null;}if(z.Url.String!=="./$metadata"){throw new Error(y+"/Url/String has to be './$metadata' for the service "+i.oDataModel.getCodeListModelParameters().serviceUrl);}q=z.CollectionPath.String;v=i.oDataModel.getMetadataUrl();s=v+"#"+q;w=m.get(s);if(w){return w;}n=i._getOrCreateSharedModelCache();j=n.oModel;x=new S(function(A,D){j.read("/"+q,{error:D,success:A,urlParameters:{$skip:0,$top:5000}});});u=new S(function(A,D){try{A(i._getPropertyNamesForCodeListCustomizing(q));}catch(E){D(E);}});w=S.all([x,u]).then(function(A){var D=A[0].results,E=A[1];return D.reduce(function(G,H){var I=H[E.code],K={Text:H[E.text],UnitSpecificScale:H[E.unitSpecificScale]};if(E.standardCode){K.StandardCode=H[E.standardCode];}if(K.UnitSpecificScale===null){L.error("Ignoring customizing w/o unit-specific scale for code "+I+" from "+q,i.oDataModel.getCodeListModelParameters().serviceUrl,o);}else{G[I]=K;}return G;},{});}).catch(function(E){if(j.bDestroyed){m.delete(s);}else{L.error("Couldn't load code list: "+q+" for "+i.oDataModel.getCodeListModelParameters().serviceUrl,E,o);}throw E;}).finally(function(){if(n.bFirstCodeListRequested){if(!j.bDestroyed){j.destroy();}delete i.oSharedModelCache;}else{n.bFirstCodeListRequested=true;}});m.set(s,w);return w;});};l.prototype.getMetaContext=function(s){var A,E,i,j,n,N,q,t,Q;function u(v){var w=v.indexOf("(");return w>=0?v.slice(0,w):v;}if(!s){return null;}t=s.split("/");if(t[0]!==""){throw new Error("Not an absolute path: "+s);}t.shift();q=u(t[0]);E=this.getODataEntitySet(q);if(E){Q=E.entityType;}else{j=this.getODataFunctionImport(q);if(j){if(t.length===1){n=this.getODataFunctionImport(q,true);}Q=j.returnType;if(Q.lastIndexOf("Collection(",0)===0){Q=Q.slice(11,-1);}}else{throw new Error("Entity set or function import not found: "+q);}}t.shift();while(t.length){i=this.getODataEntityType(Q);if(i){N=u(t[0]);A=this.getODataAssociationEnd(i,N);}else{i=this.getODataComplexType(Q);}if(A){Q=A.type;if(A.multiplicity==="1"&&N!==t[0]){throw new Error("Multiplicity is 1: "+t[0]);}t.shift();}else{n=this.getODataProperty(i,t,true);if(t.length){throw new Error("Property not found: "+t.join("/"));}break;}}n=n||this.getODataEntityType(Q,true);return this.createBindingContext(n);};l.prototype.getODataAssociationEnd=function(E,n){var N=E?U.findObject(E.navigationProperty,n):null,A=N?U.getObject(this.oModel,"association",N.relationship):null,i=A?U.findObject(A.end,N.toRole,"role"):null;return i;};l.prototype.getODataAssociationSetEnd=function(E,n){var A,i=null,j=this.getODataEntityContainer(),N=E?U.findObject(E.navigationProperty,n):null;if(j&&N){A=U.findObject(j.associationSet,N.relationship,"association");i=A?U.findObject(A.end,N.toRole,"role"):null;}return i;};l.prototype.getODataComplexType=function(q,A){return U.getObject(this.oModel,"complexType",q,A);};l.prototype.getODataEntityContainer=function(A){var v=A?undefined:null,s=this.oModel.getObject("/dataServices/schema");if(s){s.forEach(function(n,i){var j=U.findIndex(n.entityContainer,"true","isDefaultEntityContainer");if(j>=0){v=A?"/dataServices/schema/"+i+"/entityContainer/"+j:n.entityContainer[j];return false;}});if(!v&&s.length===1&&s[0].entityContainer&&s[0].entityContainer.length===1){v=A?"/dataServices/schema/0/entityContainer/0":s[0].entityContainer[0];}}return v;};l.prototype.getODataEntitySet=function(n,A){return U.getFromContainer(this.getODataEntityContainer(),"entitySet",n,A);};l.prototype.getODataEntityType=function(q,A){return U.getObject(this.oModel,"entityType",q,A);};l.prototype.getODataFunctionImport=function(n,A){var i=n&&n.indexOf('/')>=0?n.split('/'):undefined,E=i?U.getObject(this.oModel,"entityContainer",i[0]):this.getODataEntityContainer();return U.getFromContainer(E,"functionImport",i?i[1]:n,A);};l.prototype.getODataProperty=function(t,n,A){var i,j=Array.isArray(n)?n:[n],q=null,s;while(t&&j.length){i=U.findIndex(t.property,j[0]);if(i<0){break;}j.shift();q=t.property[i];s=t.$path+"/property/"+i;if(j.length){t=this.getODataComplexType(q.type);}}return A?s:q;};l.prototype.getODataValueLists=function(i){var j=false,n,s=i.getPath(),q=this.mContext2Promise[s],t=this;if(q){return q;}n=r.exec(s);if(!n){throw new Error("Unsupported property context with path "+s);}q=new Promise(function(u,v){var w=i.getObject(),Q,V=U.getValueLists(w);if(!(""in V)&&w["sap:value-list"]){j=true;Q=t.oModel.getObject(n[2]).namespace+"."+t.oModel.getObject(n[1]).name;t.mQName2PendingRequest[Q+"/"+w.name]={resolve:function(x){e(w,(x.annotations.propertyAnnotations[Q]||{})[w.name]);V=U.getValueLists(w);if(a(V)){v(new Error("No value lists returned for "+s));}else{delete t.mContext2Promise[s];u(V);}},reject:v};setTimeout(t._sendBundledRequest.bind(t),0);}else{u(V);}});if(j){this.mContext2Promise[s]=q;}return q;};l.prototype.getProperty=function(){return this._getObject.apply(this,arguments);};l.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments);};l.prototype.loaded=function(){return this.oLoadedPromise;};l.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh");};l.prototype.requestCurrencyCodes=function(){return Promise.resolve(this.fetchCodeList("CurrencyCodes"));};l.prototype.requestUnitsOfMeasure=function(){return Promise.resolve(this.fetchCodeList("UnitsOfMeasure"));};l.prototype.setLegacySyntax=function(i){if(i){throw new Error("Legacy syntax not supported by ODataMetaModel");}};l.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty");};l.prototype._getPropertyNamesForCodeListCustomizing=function(s){var i="/"+s+"/##",t=this.oDataModel.getObject(i),A=t["Org.OData.Core.V1.AlternateKeys"],K=l._getKeyPath(t,i),j=this.oDataModel.getObject("/"+s+"/"+K+"/##");if(A){if(A.length!==1){throw new Error("Single alternative expected: "+i+"Org.OData.Core.V1.AlternateKeys");}else if(A[0].Key.length!==1){throw new Error("Single key expected: "+i+"Org.OData.Core.V1.AlternateKeys/0/Key");}K=A[0].Key[0].Name.Path;}return{code:K,standardCode:j["com.sap.vocabularies.CodeList.v1.StandardCode"]&&j["com.sap.vocabularies.CodeList.v1.StandardCode"].Path,text:j["com.sap.vocabularies.Common.v1.Text"].Path,unitSpecificScale:j["com.sap.vocabularies.Common.v1.UnitSpecificScale"].Path};};l._getKeyPath=function(t,T){var K=t.key.propertyRef;if(K&&K.length===1){return K[0].name;}throw new Error("Single key expected: "+T);};l.getCodeListTerm=function(D){if(D==="/##@@requestCurrencyCodes"){return"CurrencyCodes";}else if(D==="/##@@requestUnitsOfMeasure"){return"UnitsOfMeasure";}};return l;});
