/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_ODataMetaModelUtils","sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/base/EventProvider","sap/ui/core/cache/CacheManager","sap/ui/thirdparty/datajs"],function(U,a,L,e,b,c,u,E,C,O){"use strict";var s="sap.ui.model.odata.ODataMetadata",S="http://www.sap.com/Protocols/SAPData";var d=E.extend("sap.ui.model.odata.ODataMetadata",{constructor:function(m,p){E.apply(this,arguments);this.bLoaded=false;this.bFailed=false;this.mEntityTypes={};this.mRequestHandles={};this.sUrl=m;this.bAsync=p.async;this.sUser=p.user;this.bWithCredentials=p.withCredentials;this.sPassword=p.password;this.mHeaders=p.headers;this.sCacheKey=p.cacheKey;this.oLoadEvent=null;this.oFailedEvent=null;this.oMetadata=null;this.bMessageScopeSupported=false;this.mNamespaces=p.namespaces||{sap:"http://www.sap.com/Protocols/SAPData",m:"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata","":"http://schemas.microsoft.com/ado/2007/06/edmx"};var t=this;this.pLoadedWithReject=new Promise(function(r,f){t.fnResolve=r;t.fnReject=f;});this.pLoaded=this.pLoadedWithReject.catch(function(o){return new Promise(function(r,f){t.fnResolve=r;});});function w(p){C.set(t.sCacheKey,JSON.stringify({metadata:t.oMetadata,params:p}));}function l(o){L.error("[ODataMetadata] initial loading of metadata failed");if(o&&o.message){L.error("Error: "+o.message);}}if(this.sCacheKey){C.get(this.sCacheKey).then(function(M){if(M){var o=JSON.parse(M);this.oMetadata=o.metadata;this._handleLoaded(this.oMetadata,o.params,false);}else{this._loadMetadata().then(w).catch(l);}}.bind(this)).catch(l);}else{this._loadMetadata().catch(l);}},metadata:{publicMethods:["getServiceMetadata","attachFailed","detachFailed","attachLoaded","detachLoaded","refresh"]}});d._returnsCollection=function(f){if(f&&f.returnType&&f.returnType.startsWith("Collection(")){return true;}return false;};d.prototype._setNamespaces=function(n){this.mNamespaces=n;};d.prototype._handleLoaded=function(m,p,f){var h=[];this.oMetadata=this.oMetadata?this.merge(this.oMetadata,m,h):m;this.oRequestHandle=null;p.entitySets=h;this.fnResolve(p);if(this.bAsync&&!f){this.fireLoaded(this);}else if(!this.bAsync&&!f){this.bLoaded=true;this.bFailed=false;this.oLoadEvent=setTimeout(this.fireLoaded.bind(this,p),0);}};d.prototype._loadMetadata=function(f,h){var t=this;f=f||this.sUrl;var r=this._createRequest(f);return new Promise(function(i,j){var R;function _(m,o){if(!m||!m.dataServices){var p={message:"Invalid metadata document",request:r,response:o};k(p);return;}t.sMetadataBody=o.body;t.oRequestHandle=null;var P={metadataString:t.sMetadataBody};var l=o.headers["Last-Modified"];if(l){P.lastModified=l;}var n=o.headers["eTag"];if(n){P.eTag=n;}t._handleLoaded(m,P,h);i(P);}function k(o){var p={message:o.message,request:o.request,response:o.response};if(o.response){p.statusCode=o.response.statusCode;p.statusText=o.response.statusText;p.responseText=o.response.body;}if(R&&R.bSuppressErrorHandlerCall){return;}if(t.bAsync){delete t.mRequestHandles[R.id];}j(p);t.fnReject(p);if(t.bAsync&&!h){t.fireFailed(p);}else if(!t.bAsync&&!h){t.bFailed=true;t.oFailedEvent=setTimeout(t.fireFailed.bind(t,p),0);}}R=O.request(r,_,k,O.metadataHandler);if(t.bAsync){R.id=u();t.mRequestHandles[R.id]=R;}});};d.prototype.refresh=function(){return this._loadMetadata();};d.prototype.getServiceMetadata=function(){return this.oMetadata;};d.prototype.isLoaded=function(){return this.bLoaded;};d.prototype.loaded=function(r){return r?this.pLoadedWithReject:this.pLoaded;};d.prototype.isFailed=function(){return this.bFailed;};d.prototype.fireLoaded=function(p){this.bLoaded=true;this.bFailed=false;this.fireEvent("loaded",p);L.debug(this+" - loaded was fired");return this;};d.prototype.attachLoaded=function(D,f,l){this.attachEvent("loaded",D,f,l);return this;};d.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};d.prototype.fireFailed=function(p){this.bFailed=true;this.fireEvent("failed",p);return this;};d.prototype.attachFailed=function(D,f,l){this.attachEvent("failed",D,f,l);return this;};d.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};d.prototype._getEntityAssociationEnd=function(o,n){var f;if(!this._checkMetadataLoaded()){return null;}this._mGetEntityAssociationEndCache=this._mGetEntityAssociationEndCache||{};f=o.namespace+"."+o.name+"/"+n;if(this._mGetEntityAssociationEndCache[f]===undefined){var N=o?U.findObject(o.navigationProperty,n):null,A=N?U.getObject(this.oMetadata.dataServices.schema,"association",N.relationship):null,h=A?U.findObject(A.end,N.toRole,"role"):null;this._mGetEntityAssociationEndCache[f]=h;}return this._mGetEntityAssociationEndCache[f];};function g(f){var m={};for(var i=0;i<f.length;i++){var o=f[i];if(o.entityContainer){for(var j=0;j<o.entityContainer.length;j++){var h=o.entityContainer[j];if(h.entitySet){for(var k=0;k<h.entitySet.length;k++){if(h.entitySet[k].name!=null){m[h.entitySet[k].name]=h.entitySet[k];}}}}}}return m;}d.prototype._findEntitySetByName=function(n){if(!this.mEntitySets){this.mEntitySets=g(this.oMetadata.dataServices.schema);}return this.mEntitySets[n];};d.prototype._getEntityTypeByPath=function(p){if(!p){a(undefined,"sPath not defined!");return null;}if(this.mEntityTypes[p]){return this.mEntityTypes[p];}if(!this._checkMetadataLoaded()){return null;}var f=p.replace(/^\/|\/$/g,""),P=f.split("/"),l=P.length,o,h,j,r,t=this;if(P[0].indexOf("(")!=-1){P[0]=P[0].substring(0,P[0].indexOf("("));}if(l>1){o=t._getEntityTypeByPath(P[0]);for(var i=1;i<P.length;i++){if(o){if(P[i].indexOf("(")!=-1){P[i]=P[i].substring(0,P[i].indexOf("("));}r=t._getEntityTypeByNavProperty(o,P[i]);if(r){o=r;}j=o;}}}else{h=this._splitName(this._getEntityTypeName(P[0]));j=this._getObjectMetadata("entityType",h.name,h.namespace);if(j){j.entityType=this._getEntityTypeName(P[0]);}}if(!j){var F=P[P.length-1];var k=this._getFunctionImportMetadata(F,"GET");if(!k){k=this._getFunctionImportMetadata(F,"POST");}if(k&&k.entitySet){j=Object.assign({},this._getEntityTypeByPath(k.entitySet));if(j){j.entityType=this._getEntityTypeName(k.entitySet);j.isFunction=true;}}}if(j){this.mEntityTypes[p]=j;}return j;};d.prototype._getEntityTypeByName=function(n){var o,t=this,f,N,h;if(!n){a(undefined,"sName not defined!");return null;}h=this._splitName(n);N=h.namespace;f=h.name;if(!this._checkMetadataLoaded()){return null;}if(this.mEntityTypes[n]){o=this.mEntityTypes[n];}else{e(this.oMetadata.dataServices.schema,function(i,j){if(j.entityType&&(!N||j.namespace===N)){e(j.entityType,function(k,l){if(l.name===f){o=l;t.mEntityTypes[n]=o;o.namespace=j.namespace;return false;}});}});}return o;};d.prototype._checkMetadataLoaded=function(){if(!this.oMetadata||c(this.oMetadata)){a(undefined,"No metadata loaded!");return false;}return true;};d.prototype._getAnnotation=function(p){var n,P,m,M,o,f,h;P=p.split('/#');M=P[1].split('/');if(!P[0]){o=this._getEntityTypeByName(M[0]);a(o,M[0]+" is not a valid EntityType");if(!o){return;}f=P[1].substr(P[1].indexOf('/')+1);h=this._getPropertyMetadata(o,f);a(h,f+" is not a valid property path");if(!h){return;}m=f.substr(f.indexOf(h.name));m=m.substr(m.indexOf('/')+1);}else{o=this._getEntityTypeByPath(P[0]);a(o,P[0]+" is not a valid path");if(!o){return;}p=P[0].replace(/^\/|\/$/g,"");f=p;while(!h&&f.indexOf("/")>0){f=f.substr(f.indexOf('/')+1);h=this._getPropertyMetadata(o,f);}a(h,f+" is not a valid property path");if(!h){return;}m=M.join('/');}n=this._getAnnotationObject(o,h,m);return n;};d.prototype._getAnnotationObject=function(o,f,m){var A,p,h,n,j;if(!f){return;}n=f;p=m.split('/');if(p[0].indexOf('.')>-1){return this._getV4AnnotationObject(o,f,p);}else{if(p.length>1){n=n[p[0]];if(!n&&f.extensions){for(var i=0;i<f.extensions.length;i++){var k=f.extensions[i];if(k.name==p[0]){n=k;break;}}}m=p.splice(0,1);h=this._getAnnotationObject(o,n,p.join('/'));}else{if(p[0].indexOf('@')>-1){j=p[0].substr(1);A=j.split(':');h=n[A[0]];if(!h&&n.extensions){for(var i=0;i<n.extensions.length;i++){var k=n.extensions[i];if(k.name===A[1]&&k.namespace===this.mNamespaces[A[0]]){h=k.value;break;}}}}else{A=p[0].split(':');h=n[A[0]];h=n[p[0]];if(!h&&n.extensions){for(var i=0;i<n.extensions.length;i++){var k=n.extensions[i];if(k.name===A[1]&&k.namespace===this.mNamespaces[A[0]]){h=k;break;}}}}}}return h;};d.prototype._getV4AnnotationObject=function(o,f,p){var A,h=[];if(p.length>1){a(p.length==1,"'"+p.join('/')+"' is not a valid annotation path");return;}var t=o.namespace?o.namespace+".":"";t+=o.name+"/"+f.name;e(this.oMetadata.dataServices.schema,function(i,j){if(j.annotations){e(j.annotations,function(k,f){if(f.target===t&&!f.qualifier){h.push(f.annotation);return false;}});}});if(h){e(h,function(i,k){e(k,function(j,l){if(l.term===p[0]){A=l;}});});}return A;};d.prototype._splitName=function(f){var i={};if(f){var h=f.lastIndexOf(".");i.name=f.substr(h+1);i.namespace=f.substr(0,h);}return i;};d.prototype._getEntityTypeName=function(f){var h,o;if(f){o=this._findEntitySetByName(f);if(o){h=o.entityType;}}return h;};d.prototype._getObjectMetadata=function(o,f,n){var h;if(f&&n){e(this.oMetadata.dataServices.schema,function(i,k){if(k[o]&&k.namespace===n){e(k[o],function(j,l){if(l.name===f){h=l;h.namespace=k.namespace;return false;}});return!h;}});}return h;};d.prototype.getUseBatch=function(){var f=false;e(this.oMetadata.dataServices.schema,function(i,o){if(o.entityContainer){e(o.entityContainer,function(k,h){if(h.extensions){e(h.extensions,function(l,j){if(j.name==="use-batch"&&j.namespace==="http://www.sap.com/Protocols/SAPData"){f=(typeof j.value==='string')?(j.value.toLowerCase()==='true'):!!j.value;return false;}});}});}});return f;};d.prototype._getFunctionImportMetadataIterate=function(f,h){var o=[];e(this.oMetadata.dataServices.schema,function(i,j){if(j["entityContainer"]){e(j["entityContainer"],function(k,l){if(l["functionImport"]){e(l["functionImport"],function(F,m){if(f(m)){o.push(m);if(h){return false;}}});}return!(h&&o.length===1);});}return!(h&&o.length===1);});return o;};d.prototype._getFirstMatchingFunctionImportMetadata=function(f){var o=this._getFunctionImportMetadataIterate(f,true);return o.length===1?o[0]:null;};d.prototype._getFunctionImportMetadataByName=function(f){if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}return this._getFunctionImportMetadataIterate(function(F){return F.name===f;});};d.prototype._getFunctionImportMetadata=function(f,m){if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}return this._getFirstMatchingFunctionImportMetadata(function(F){return F.name===f&&F.httpMethod===m;});};d.prototype._getEntityTypeByNavProperty=function(m,n){if(!m.navigationProperty){return undefined;}for(var i=0;i<m.navigationProperty.length;++i){var N=m.navigationProperty[i];if(N.name===n){return this._getEntityTypeByNavPropertyObject(N);}}return undefined;};d.prototype._getEntityTypeByNavPropertyObject=function(n){var t;var A=this._splitName(n.relationship);var m=this._getObjectMetadata("association",A.name,A.namespace);if(m){var f=m.end[0];if(f.role!==n.toRole){f=m.end[1];}var o=this._splitName(f.type);t=this._getObjectMetadata("entityType",o.name,o.namespace);if(t){t.entityType=f.type;}}return t;};d.prototype._getNavigationPropertyNames=function(o){var n=[];if(o.navigationProperty){e(o.navigationProperty,function(k,N){n.push(N.name);});}return n;};d.prototype._getNavPropertyRefInfo=function(o,p){var n,A,f,h,P,D,j,r,k,l,K,t=this;e(o.navigationProperty,function(i,N){f=t._splitName(N.relationship);A=t._getObjectMetadata("association",f.name,f.namespace);if(!A||!A.referentialConstraint){return;}D=A.referentialConstraint.dependent;k=A.end.find(function(k){return k.role===D.role;});if(k.type!==o.namespace+"."+o.name){return;}j=D.propertyRef.some(function(m){return m.name===p;});if(!j){return;}P=A.referentialConstraint.principal;r=P.role;h=t._getAssociationSetByAssociation(N.relationship);k=h.end.find(function(k){return k.role===r;});l=k.entitySet;K=P.propertyRef.map(function(m){return m.name;});n={name:N.name,entitySet:l,keys:K};});return n;};d.prototype._getPropertyMetadata=function(o,p){var P,t=this;if(!o){return;}p=p.replace(/^\/|\/$/g,"");var f=p.split("/");e(o.property,function(k,h){if(h.name===f[0]){P=h;return false;}});if(f.length>1){if(!P){while(o&&f.length>1){o=this._getEntityTypeByNavProperty(o,f[0]);f.shift();}if(o){P=t._getPropertyMetadata(o,f[0]);}}else if(!P.type.toLowerCase().startsWith("edm.")){var n=this._splitName(P.type);P=this._getPropertyMetadata(this._getObjectMetadata("complexType",n.name,n.namespace),f[1]);}}return P;};d.prototype.destroy=function(){delete this.oMetadata;var t=this;e(this.mRequestHandles,function(k,r){r.bSuppressErrorHandlerCall=true;r.abort();delete t.mRequestHandles[k];});if(this.oLoadEvent){clearTimeout(this.oLoadEvent);}if(this.oFailedEvent){clearTimeout(this.oFailedEvent);}E.prototype.destroy.apply(this,arguments);};d.prototype._fillElementCaches=function(){var t=this;if(this._entitySetMap||!this._checkMetadataLoaded()){return;}this._entitySetMap={};this.oMetadata.dataServices.schema.forEach(function(m){(m.entityContainer||[]).forEach(function(f){(f.entitySet||[]).forEach(function(h){var o=t._getEntityTypeByName(h.entityType);o.__navigationPropertiesMap={};(o.navigationProperty||[]).forEach(function(p){o.__navigationPropertiesMap[p.name]=p;});h.__entityType=o;t._entitySetMap[h.entityType]=h;});});});};d.prototype._createRequest=function(f){var D={"sap-cancel-on-close":true},l={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()};b(D,this.mHeaders,l);var r={headers:D,requestUri:f,method:'GET',user:this.sUser,password:this.sPassword,async:this.bAsync};if(this.bAsync){r.withCredentials=this.bWithCredentials;}return r;};d.prototype._getEntitySetByPath=function(f){var o;this._fillElementCaches();o=this._getEntityTypeByPath(f);if(o){return this._entitySetMap[o.entityType];}};d.prototype._addUrl=function(v){var f=[].concat(v);return Promise.all(f.map(function(h){return this._loadMetadata(h,true);},this));};d.prototype.merge=function(t,f,h){var m=this;if(this.mEntitySets){delete this.mEntitySets;}e(t.dataServices.schema,function(i,T){e(f.dataServices.schema,function(j,n){if(n.namespace===T.namespace){if(n.entityType){if(!m.mEntityTypeNames){m.mEntityTypeNames={};T.entityType.map(function(o){m.mEntityTypeNames[o.name]=true;});}T.entityType=!T.entityType?[]:T.entityType;for(var i=0;i<n.entityType.length;i++){if(!(n.entityType[i].name in m.mEntityTypeNames)){T.entityType.push(n.entityType[i]);m.mEntityTypeNames[n.entityType[i].name]=true;}}}if(T.entityContainer&&n.entityContainer){e(T.entityContainer,function(k,p){e(n.entityContainer,function(l,q){if(q.entitySet){if(q.name===p.name){if(!m.mEntitySetNames){m.mEntitySetNames={};p.entitySet.map(function(o){m.mEntitySetNames[o.name]=true;});}p.entitySet=!p.entitySet?[]:p.entitySet;for(var i=0;i<q.entitySet.length;i++){if(!(q.entitySet[i].name in m.mEntitySetNames)){p.entitySet.push(q.entitySet[i]);m.mEntitySetNames[q.entitySet[i].name]=true;}}q.entitySet.forEach(function(o){h.push(o);});}}});});}if(n.annotations){T.annotations=!T.annotations?[]:T.annotations;T.annotations=T.annotations.concat(n.annotations);}}});});return t;};d.prototype._getEntitySetByType=function(f){var h=f.namespace+"."+f.name;var j=this.oMetadata.dataServices.schema;for(var i=0;i<j.length;++i){var k=j[i].entityContainer;if(k){for(var n=0;n<k.length;++n){var l=k[n].entitySet;if(l){for(var m=0;m<l.length;++m){if(l[m].entityType===h){return l[m];}}}}}}return null;};d.prototype._calculateCanonicalPath=function(p){var f,i,P,t;if(p){i=p.lastIndexOf(")");if(i!==-1){t=p.substr(0,i+1);var o=this._getEntitySetByPath(t);if(o){if(o.__entityType.isFunction){f=p;}else{P=p.split("/");if(t==="/"+P[1]){if(!(P[2]in o.__entityType.__navigationPropertiesMap)){f=p;}}else{P=t.split("/");t='/'+o.name+P[P.length-1].substr(P[P.length-1].indexOf("("))+p.substr(i+1);if(t!==p){f=t;}}}}}}return f;};d.prototype._getAssociationSetByAssociation=function(A){var f=this.oMetadata.dataServices.schema;for(var i=0;i<f.length;++i){var h=f[i].entityContainer;if(h){for(var n=0;n<h.length;++n){var j=h[n].associationSet;if(j){for(var m=0;m<j.length;++m){if(j[m].association===A){return j[m];}}}}}}return null;};d.prototype._isMessageScopeSupported=function(){var f=this.oMetadata.dataServices.schema,o,h;if(!this.bMessageScopeSupported&&f){for(var i=0;i<f.length;++i){h=f[i].entityContainer;if(h){for(var n=0;n<h.length;++n){o=h[n];if(o.extensions&&Array.isArray(o.extensions)){for(var m=0;m<o.extensions.length;++m){if(o.extensions[m].name==="message-scope-supported"&&o.extensions[m].namespace===this.mNamespaces.sap){if(o.extensions[m].value==="true"){this.bMessageScopeSupported=true;break;}}}}}}}}return this.bMessageScopeSupported;};d.prototype._isCollection=function(p){var f=false;var i=p.lastIndexOf("/");if(i>0){var h=p.substring(0,i);var o=this._getEntityTypeByPath(h);if(o){var A=this._getEntityAssociationEnd(o,p.substring(i+1));if(A&&A.multiplicity==="*"){f=true;}}}else{f=true;}return f;};d.prototype._getReducedPath=function(p){var A,i,k,n,N,o,f,h=p.split("/"),j;if(h.length<4){return p;}this._fillElementCaches();for(i=1;i<h.length-2;i+=1){j=this._getEntityTypeByPath(h.slice(0,i+1).join('/'));N=j&&j.__navigationPropertiesMap[h[i+1].split("(")[0]];if(!N){continue;}f=h[i+2].split("(")[0];n=this._getEntityTypeByNavPropertyObject(N);o=n&&n.__navigationPropertiesMap[f];if(!o||N.relationship!==o.relationship){continue;}k=h[i+2].slice(f.length);A=this._getEntityAssociationEnd(n,f);if(A.multiplicity!=="*"||k&&h[i].endsWith(k)){h.splice(i+1,2);return this._getReducedPath(h.join("/"));}}return h.join("/");};d.prototype.getKeyPropertyNamesByPath=function(p){var A,o,i=p.lastIndexOf("/");if(i>0){o=this._getEntityTypeByPath(p.slice(0,i));if(o){A=this._getEntityAssociationEnd(o,p.slice(i+1).split("(")[0]);o=A?this._getEntityTypeByName(A.type):undefined;}}else{o=this._getEntityTypeByPath(p);}if(o){return o.key.propertyRef.map(function(k){return k.name;});}};d.prototype._getCanonicalPathOfFunctionImport=function(f,F){var A,m,h,i,k,p,P,j=f.extensions,l=f.returnType,I="",n=false;if(j){for(i=0;i<j.length;i+=1){if(j[i].name==="action-for"){A=j[i].value;break;}}}if(d._returnsCollection(f)){n=true;l=l.slice(11,-1);}if(A){h=this._getEntityTypeByName(A);}else if(f.entitySet){h=this._getEntityTypeByPath(f.entitySet);}else if(l){h=this._getEntityTypeByName(l);}if(h){m=this._getEntitySetByType(h);if(m&&h.key&&h.key.propertyRef){if(n){return"/"+m.name;}P=h.key.propertyRef;if(P.length===1){p=P[0].name;if(F[p]){I=F[p];}}else{k=[];for(i=0;i<P.length;i+=1){p=P[i].name;if(F[p]){k.push(p+"="+F[p]);}}I=k.join(",");}return"/"+m.name+"("+I+")";}else if(!m){L.error("Cannot determine path of the entity set for the function import '"+f.name+"'",this,s);}else{L.error("Cannot determine keys of the entity type '"+h.entityType+"' for the function import '"+f.name+"'",this,s);}}return"";};d.prototype._splitByLastNavigationProperty=function(p){var o,i,k,l,f,h=p.split("/"),F="/"+h[1],j=h.length;this._fillElementCaches();o=this._getEntityTypeByPath(F);for(i=2;i<j;i+=1){f=h[i];k=f.indexOf("(");if(k!==-1){f=f.slice(0,k);}if(o&&o.__navigationPropertiesMap[f]){l=i;o=this._getEntityTypeByNavProperty(o,f);}else{break;}}if(l===undefined){return{pathBeforeLastNavigationProperty:p,lastNavigationProperty:"",addressable:true,pathAfterLastNavigationProperty:""};}return{pathBeforeLastNavigationProperty:h.slice(0,l).join("/"),lastNavigationProperty:"/"+h[l],addressable:this._isAddressable(o),pathAfterLastNavigationProperty:(l+1)>=j?"":("/"+h.slice(l+1).join("/"))};};d.prototype._isAddressable=function(o){var f;if(!o){return true;}f=this._entitySetMap[o.entityType];if(!f||!f.extensions){return true;}return!f.extensions.some(function(h){return h.name==="addressable"&&h.namespace===S&&h.value==="false";});};return d;});
