/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/hash","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/core/LocaleData","sap/ui/core/format/NumberFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(h,e,a,i,L,N,C,F,P,V){"use strict";var U=C.extend("sap.ui.model.type.Unit",{constructor:function(f,c,d){C.apply(this,arguments);this.sName="Unit";this.bShowMeasure=!f||!("showMeasure"in f)||f.showMeasure;this.bShowNumber=!f||!("showNumber"in f)||f.showNumber;this.bUseRawValues=true;this.aDynamicFormatOptionNames=d;}});U.prototype._getInstance=function(A,u){var f=this.createFormatOptions(A);if(u&&!this.oFormatOptions.customUnits&&!f.customUnits){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=L.getInstance(l);var s=o.getUnitFromMapping(u)||u;var m=o.getUnitFormat(s);if(m){var b=a({},m);b.decimals=(f.decimals!=undefined)?f.decimals:b.decimals;b.precision=(f.precision!=undefined)?f.precision:b.precision;f.customUnits={};f.customUnits[u]=b;}}var c=f;if(this.oFormatOptions){c=a({},this.oFormatOptions,f);}if(this.getMetadata().getClass()!==U){var M=this.getMetadata();M._mTypeInstanceCache=M._mTypeInstanceCache||{};var H=h(JSON.stringify(c)||"");var d=M._mTypeInstanceCache[H];if(!d){d=N.getUnitInstance(c);M._mTypeInstanceCache[H]=d;}return d;}else{return N.getUnitInstance(c);}};U.prototype._clearInstances=function(){if(this.getMetadata().getClass()!==U){var m=this.getMetadata();if(m._mTypeInstanceCache){m._mTypeInstanceCache={};}}};U.prototype.createFormatOptions=function(v){var f={};if(this.aDynamicFormatOptionNames&&v.length>=this.aDynamicFormatOptionNames.length){this.aDynamicFormatOptionNames.forEach(function(d,I){if(d){f[d]=v[I];}});}return f;};U.prototype.extractArguments=function(v){return Array.isArray(v)&&v.length>2?v.slice(2):[];};U.prototype.formatValue=function(v,I){var b=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){b=this.oInputFormat.parse(v);}if(!Array.isArray(b)){throw new F("Cannot format Unit: "+v+" has the wrong format");}if((b[0]==undefined||b[0]==null)&&this.bShowNumber){return null;}switch(this.getPrimitiveType(I)){case"string":this.aDynamicValues=this.extractArguments(b);this.oOutputFormat=this._getInstance(this.aDynamicValues,b[1]);return this.oOutputFormat.format(b);case"int":case"float":case"any":default:throw new F("Don't know how to format Unit to "+I);}};U.prototype.parseValue=function(v,I){var r;switch(this.getPrimitiveType(I)){case"string":this.oOutputFormat=this._getInstance(this.aDynamicValues);r=this.oOutputFormat.parse(v);if(!Array.isArray(r)||this.bShowNumber&&isNaN(r[0])){throw this.getParseException();}break;case"int":case"float":default:throw new P("Don't know how to parse Unit from "+I);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};U.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],d=v,f;if(this.oInputFormat){d=this.oInputFormat.parse(v);}f=d[0];e(this.oConstraints,function(n,o){switch(n){case"minimum":if(f<o){c.push("minimum");m.push(b.getText("Unit.Minimum",[o]));}break;case"maximum":if(f>o){c.push("maximum");m.push(b.getText("Unit.Maximum",[o]));}break;case"decimals":var t=N._shiftDecimalPoint(f,o);if(Math.floor(t)!==t){c.push("decimals");m.push(b.getText("Unit.Decimals",[o]));}break;default:break;}});if(c.length>0){throw new V(m.join(" "),c);}}};U.prototype.setFormatOptions=function(f){this.oFormatOptions=Object.assign(f.style!=="short"&&f.style!=="long"?{preserveDecimals:true}:{},f);this._clearInstances();this._createInputFormat();};U.prototype._handleLocalizationChange=function(){this._clearInstances();this._createInputFormat();};U.prototype._createInputFormat=function(){var s=this.oFormatOptions.source;if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getUnitInstance(s);}};U.prototype.getParseException=function(){var b=sap.ui.getCore().getLibraryResourceBundle(),t;if(!this.bShowNumber){t=b.getText("Unit.InvalidMeasure");}else if(!this.bShowMeasure){t=b.getText("EnterNumber");}else{t=b.getText("Unit.Invalid");}return new P(t);};U.prototype.getPartsIgnoringMessages=function(){if(!this.bShowMeasure){return[1];}else if(!this.bShowNumber){return[0];}return[];};return U;});
